#!/bin/sh
#  
# define common variables
DEFAULT_INFO_PLIST="/Contents/Info.plist"
DEFAULT_MACOS="Contents/MacOS"

## which is generated by auto-build

MDFIND=/usr/bin/mdfind
MDLS=/usr/bin/mdls
HEAD=/usr/bin/head
DEFAULTS=/usr/bin/defaults

_get_valueByKey()
{
    kMDFile="$1"
    kMDItem="$2"
    if [ ! -e "$kMDFile" ] || [ -z "$kMDItem" ]; then
        kMDItemValue=""
        return 1;
    fi
    if [ -d "$kMDFile" -a ! -z "echo $kMDFile | grep '\.app\$'" ]; then
        kMDItemValue=$($MDLS -name $kMDItem "$kMDFile" | grep $kMDItem | sed "s/$kMDItem = \"\([^\"]*\)\"/\1/")
    elif [ -f "$kMDFile" -a ! -z "echo $kMDFile | grep '\.plist\$'" ]; then
        kMDItemValue=$($DEFAULTS read "${kMDFile%.plist}" "$kMDItem")
    fi
}

usage()
{
    cat >&2 <<ending_tag
Usage: $0 <command> [options]
command:
    -b <BID>

options:
    -d <defualt_path>
    -l <finding_location>
    -o <output_string>

output_string:
    b   Bundle Identifier (default)
    e   Executable path
    l   App location

ending_tag

    exit 2
}

_getopt()
{
    # You cannot use the set command with a backquoted getopt directly,
    # since the exit code from getopt would be shadowed by those of set,
    # which is zero by definition.

    local i=0
    local count=${#argv[@]}
    while [ $i -lt $count ]; do
        case "${argv[$i]}"
        in
            -b) # find by BundleID, ex: -b com.company.application
                gFindType="-b"
                gFindKey="${argv[$((i + 1))]}"
                i=$((i + 2));;
            -d) # default path, ex: -d /Applications/Preview.app
                gDefPath="${argv[$((i + 1))]}"
                i=$((i + 2));;
            -l) # finding scope, ex: -l /Applications
                gLocation="${argv[$((i + 1))]}"
                i=$((i + 2));;
            -o) # output string, ex: -o i
                gOutput="${argv[$((i + 1))]}"
                i=$((i + 2));;
            *) 
                i=$((i + 1)); break;;
        esac
    done

    if [ -z "$gFindType" ]; then
        return 1
    else
        return 0
    fi
}

findBy()
{
    local kMDItem
    local kMDKey
    local plistKey
    case "$gFindType"
    in
        -b) # find by BundleID
            kMDItem="kMDItemCFBundleIdentifier"
            ;;
    esac

    case "$gOutput"
    in
        e) # Executable path
            plistKey="CFBundleExecutable"
            ;;
        l) #App lication
            ;;
        b|*) # Bundle Identifier
            gOutput="i"
            kMDKey="kMDItemCFBundleIdentifier"
            plistKey="CFBundleIdentifier"
            ;;
    esac

    local onlyIn
    if [ ! -z "$gLocation" -a -d "$gLocation" ]; then
        onlyIn="-onlyin $gLocation"
    fi
    local target_app=$($MDFIND $onlyIn "$kMDItem = '$gFindKey'" | $HEAD -n 1)

    if [ -z "$target_app" ] && [ ! -z "$gDefPath" -a -d "$gDefPath" ]; then
        target_app="$gDefPath"
    fi

    if [ -z "$target_app" ]; then
        return 1
    fi

    # -o l, output target location
    if [ "$gOutput" == "l" ]; then
        echo $target_app
        return 0
    fi

    _get_valueByKey "${target_app}$DEFAULT_INFO_PLIST" "$plistKey"
    if [ -z "$kMDItemValue" -a ! -z "$kMDKey" ]; then
        _get_valueByKey "${target_app}" "$kMDKey"
    fi

    #output the result
    if [ ! -z "$kMDItemValue" ]; then
        case "$gOutput" in e)
            kMDItemValue="$target_app/$DEFAULT_MACOS/$kMDItemValue"
            ;;
        esac
        echo $kMDItemValue
        return 0
    else
        return 1
    fi
}

# main
i=0
argv=()
for arg in "$@"; do
    argv[$i]="$arg"
    i=$((i + 1))
done

_getopt;
if [ $? != 0 ]; then
    usage;
fi

findBy;
