#!/bin/bash

# startServices.sh
# SupportTool
#
# Created by Andy Tzeng on 2009/5/17.
#			 Jie Wu		on 2012/3/8
# Copyright 2009 Trend Micro Incorporated. All rights reserved.

TM_LIBRARY_PATH="/Library/Application Support/TrendMicro"
UIMGMT_PATH="/Library/Application Support/TrendMicro/TmccMac/UIMgmt.app"
DEFAULT_TMLOGINMGR_PATH="$TM_LIBRARY_PATH/TmccMac/TmLoginMgr.app"

OS_VERSION=$(sw_vers | grep 'ProductVersion:' | egrep -o '[0-9]*(\.[0-9]*){1,2}')
OS_MAJOR_VERSION=$(echo $OS_VERSION | cut -f 1 -d . -)
OS_MINOR_VERSION=$(echo $OS_VERSION | cut -f 2 -d . -)

LaunchdDir="/Library/LaunchDaemons"
# start iCoreService

coreServices=(
	"com.trendmicro.itis.plugin"
)

# stop iCoreservice
startiCore()
{
	"$TM_LIBRARY_PATH"/TmccMac/iCoreMgr -s start icore
}

startiTISServices()
{
	for item in ${coreServices[@]}; do
		svc=`launchctl list | grep $item`
		if [ -z "$svc" ]; then
			launchctl load "${LaunchdDir}/${item}.plist"
		fi
	done
}

step1()
{
    #/sbin/SystemStarter start iCoreService > /dev/null
	startiCore;
	startiTISServices;
}

step2()
{
    ICORE=$(ps A -o command | grep '^\(\/Library\/.*\/TmccMac/iCoreService\)')
    if [ -z "$ICORE" ]; then
		echo "cp!"
        "$TM_LIBRARY_PATH"/TmccMac/iCoreMgr -s start icore
		"$TM_LIBRARY_PATH"/TmccMac/iCoreService -p 61401 -n 61100 "$TM_LIBRARY_PATH"/Plug-in/iTISPlugin.framework/Versions/Current/iTISPlugin &
    fi
}

step3()
{
    os_ver=$(sw_vers -productVersion | tr -d ".")
    touch "/Library/Application Support/TrendMicro/common/var/UIMgmt.lock"
    for u in $(users); do
        sudo -u "$u" launchctl load  /Library/LaunchAgents/com.trendmicro.itis.uimgmt.agent.plist

        #sudo -u launchctl not work in 10.5.x
        if [ $OS_MAJOR_VERSION -eq 10 -a $OS_MINOR_VERSION -le 6 ] ; then
            sudo -u "$u" open -a "$UIMGMT_PATH"
        fi
    done

    sleep 5
}


user=`whoami`
if [ $user != "root" ]; then
	echo "Error! stop with user '$user'. Make sure you are 'root'!"
else
	step1;
	step3;
fi
