#!/bin/bash

# stopServices.sh
# SupportTool
#
# Created by Andy Tzeng on 2009/5/17.
#            Jie Wu     on 2012/3/8
# Copyright 2009 Trend Micro Incorporated. All rights reserved.


LaunchdDir="/Library/LaunchDaemons"

coreServices=(
	"com.trendmicro.icore.main"
	"com.trendmicro.icore.av"
	"com.trendmicro.icore.wp"
	"com.trendmicro.itis.plugin"
    "com.trendmicro.itis.fbdaemon"
	"com.trendmicro.itis.kext"
)

# stop iCoreservice
stopiCore()
{
	for item in ${coreServices[@]}; do
		launchctl stop "${item}"
		launchctl unload "${LaunchdDir}/${item}.plist"
	done
    
    launchctl unload /Library/Application\ Support/TrendMicro/common/conf/TmStartDecompress.plist
}


# Step1: Try to do normal way to stop services
step1()
{
	## iTIS 2.0 3/24/2012
	## iCore 2.0 has a enhanced feature to resume scan and update if it is stop abnormally.
	## But this kind of feature will confused user when using support tool to stop & start iTIS.
	## So we need to cancel all the operations and then kill all services.
	/Library/Application\ Support/TrendMicro/TmccMac/iCoreMgr -s cancel mau
	/Library/Application\ Support/TrendMicro/TmccMac/iCoreMgr -s cancel sau
	/Library/Application\ Support/TrendMicro/TmccMac/iCoreMgr -s cancel ms
	/Library/Application\ Support/TrendMicro/TmccMac/iCoreMgr -s cancel ss
    killall TmLoginMgr iTIS

    rm "/Library/Application Support/TrendMicro/common/var/UIMgmt.lock"
    for u in $(users); do
        sudo -u "$u" launchctl unload /Library/LaunchAgents/com.trendmicro.itis.uimgmt.agent.plist
    done

    launchctl remove "com.trendmicro.itis.fbdaemon"
    launchctl remove "com.trendmicro.itis.dca"

    sleep 1
    killall UIMgmt
    stopiCore;
}

# Step2: Wait 2 second for service shutdown. If it is running, try to kill them again
step2()
{
    chkret=0
	
	# actually I think we should kill iTIS firstly and then iCore 
	ICORE=$(ps auxw | grep "\(TmLoginMgr\|UIMgmt\|iTIS\|FBDaemon\|DCAManager)" | grep -v grep);
    if [ ! -z "$ICORE" ]; then
        chkret=1
        killall TmLoginMgr UIMgmt iTIS FBDaemon DCAManager
    fi

    ICORE=$(ps A -o command | grep "^\(\/Library\/.*\/TmccMac/\)\?\(iCoreService\|UpdateUtility\)$")
    if [ ! -z "$ICORE" ]; then
        chkret=1
        /Library/Application\ Support/TrendMicro/TmccMac/iCoreMgr -s stop icore
        sleep 3
        killall iCoreService
    fi

    return $chkret
}

# Step3: Wait 2 second for service shutdown again. Check whether all services stopped. If no, try to force stopping
step3()
{
    sleep 1
    PSLIST=$(ps A -o pid,command | grep "^\(\/Library\/.*\/TmccMac/\)\?\(iCoreService\|UpdateUtility\)$" | awk '{print $1}')
    if [ ! -z "$PSLIST" ]; then
        for pid in $PSLIST; do
            kill -9 $pid
        done
    fi

    sleep 1
    PSLIST=$(ps A -o pid,command | grep TrendMicro | grep -v grep | awk '{print $1}')
    if [ ! -z "$PSLIST" ]; then
        for pid in $PSLIST; do
            kill -9 $pid
        done
    fi

    sleep 1
    KEXTLIST=$(/usr/sbin/kextstat | grep trendmicro | awk '{print $6}')
    if [ ! -z "$KEXTLIST" ]; then
        for kext in $KEXTLIST; do
            /sbin/kextunload -b $kext
        done
    fi
}

echo "Begin Stop iTIS service "
user=`whoami`
if [ $user != "root" ]; then
	echo "Error! stop with user '$user'. Make sure you are 'root'!"
else
	step1;
	step2;
	if [ $? -eq 1 ]; then
		step3;
	fi
fi
echo "End Stop iTIS service "