#!/usr/bin/perl
#
# chkconfig: 345 01 99
# description: Starts and stops the SPLX daemons used to provide SPLX services.
#
# /etc/init.d/splxhttpd
#
### BEGIN INIT INFO
# Provides: splxhttpd
# Required-Start:
# X-UnitedLinux-Should-Start:
# Required-Stop:
# X-UnitedLinux-Should-Stop:
# Default-Start: 3 4 5
# Default-Stop:
# Short-Description: ServerProtect for Linux httpd
# Description: Starts and stops the SPLX httpd daemons used to provide SPLX httpd services.
### END INIT INFO

use utf8;

use Sys::Syslog qw(:DEFAULT setlogsock);
use POSIX qw(strftime);

# define variables

$uid=$<;

$debuglevel=0;
$MODULE_NAME="splx_service";

#$tmi_cfg_file="/opt/TrendMicro/TMI/TMI.cfg";

$ld_so_conf_file="/etc/ld.so.conf";

$product_root="/opt/TrendMicro/SProtectLinux";

$splx_log_file="$product_root/SPLX.tmp/splx.log";

$tmsplx_xml_file="$product_root/tmsplx.xml";

$httpd_pid_file="$product_root/SPLX.httpd/logs/splxhttpd.pid";

$httpd_prog="$product_root/SPLX.httpd/bin/splxhttpd";

# define commands

if( -e "/sbin/pidof" )
{
        $pidof="/sbin/pidof";
}elsif ( -e "/bin/pidof")
{
        $pidof="/bin/pidof";
}elsif ( -e "/usr/bin/pidof")
{
        $pidof="/usr/bin/pidof";
}elsif ( -e "/usr/sbin/pidof")
{
        $pidof="/usr/sbin/pidof";
}elsif ( -e "/usr/local/bin/pidof")
{
        $pidof="/usr/local/bin/pidof";
}elsif ( -e "/usr/local/sbin/pidof")
{
        $pidof="/usr/local/sbin/pidof";
}else
{
}
$ldconfig="/sbin/ldconfig";

$insmod="/sbin/insmod";

$rmmod="/sbin/rmmod";

$mknod="/bin/mknod";
$ps="/bin/ps";
# reads debug level from configuration file

open TMSPLX_XML, "< $tmsplx_xml_file";
while(<TMSPLX_XML>){
	if(/(Name=\"UserDebugLevel\"\sValue=\"\d\")/){
		@list=split / /, $1;
		foreach $token (@list){
			if($token=~/Value/){
				@sublist=split /=/, $token;
				$debuglevel=eval $sublist[1];
			}
		}
	}
}
close TMSPLX_XML;

# write logs if DEBUG is defined
my $log_file_is_open = 0; #FALSE
sub open_log{
   if (open LOG_FILE, ">> /var/log/messages") {
      binmode(LOG_FILE, ":utf8");
      $log_file_is_open = 1; #TRUE
   }
}

sub write_log {
  my $message=$_[0];

  if ($log_file_is_open) {
    $now_string = strftime "%b %e %H:%M:%S", localtime;
    ($hostname, @alias, $ad, $len, @addrs) = gethostbyname('localhost');
    print LOG_FILE $now_string . " " . $hostname . " " . $MODULE_NAME . ": " . $message . "\n";
  }
  return 1;	
}

sub close_log{
  if ($log_file_is_open) {
    close(LOG_FILE);
  }
  return 1;
}

# check if this script is run by root

if (defined($uid) && ($uid!=0)){
	write_log "error: ServerProtect for Linux must be run by root.";
	print "splxhttpd must be launched by a root user. Login as root and try again.\n";
	exit 1;
}
# set colors for displaying results

$bootup=$ENV{"BOOTUP"};
$res_col=60;

if (!defined($bootup)) {
	$bootup="color";
}

sub move_to_colon{
	($bootup eq "color") && (print "\033[${res_col}G");
	return 1;
}

sub set_success_color{
	($bootup eq "color") && (print "\033[1;32m");
	return 1;
}

sub set_failure_color{
	($bootup eq "color") && (print "\033[1;31m");
	return 1;
}

sub set_normal_color{
	($bootup eq "color") && (print "\033[0;39m");
	return 1;
}

sub info_success {
    if ( -e "/etc/init.d/functions") {    
        system ("export CONSOLETYPE=vt && . /etc/init.d/functions && \$SETCOLOR_SUCCESS && echo -ne \"" . $_[0] . "\" && \$SETCOLOR_NORMAL");
    }
    else
    {
        set_success_color;
        print $_[0];
        set_normal_color;
    }
}

sub info_failure {
    if ( -e "/etc/init.d/functions") {    
        system ("export CONSOLETYPE=vt && . /etc/init.d/functions && \$SETCOLOR_FAILURE && echo -ne \"" . $_[0] . "\" && \$SETCOLOR_NORMAL");
    }
    else
    {
        set_failure_color;
        print $_[0];
        set_normal_color;
    }
}

# echo success or failure
sub echo_success {
    if (( -e "/etc/init.d/functions") && ($bootup eq "color")){    
        system ("export CONSOLETYPE=vt && . /etc/init.d/functions && \$MOVE_TO_COL && echo -n \"[  \" && \$SETCOLOR_SUCCESS && echo -n \"OK\" && \$SETCOLOR_NORMAL && echo -ne \"  ]\\r\"");
        print "\n"
    }
    else
    {
        ($bootup eq "color") && (&move_to_colon);
        print "[  ";
        
        ($bootup eq "color") && (&set_success_color);
        print "OK";
        
        ($bootup eq "color") && (&set_normal_color);
        print "  ]\n";
        
    }
}

sub echo_failure {
    if ((-e "/etc/init.d/functions") && ($bootup eq "color")){
        system ("export CONSOLETYPE=vt && . /etc/init.d/functions && \$MOVE_TO_COL && echo -n \"[\" && \$SETCOLOR_FAILURE && echo -n \"FAILED\" && \$SETCOLOR_NORMAL && echo -ne \"]\\r\"");
        print "\n";
    }
    else
    {
        ($bootup eq "color") && (&move_to_colon);
        print "[";
        
        ($bootup eq "color") && (&set_failure_color);
        print "FAILED";
        
        ($bootup eq "color") && (&set_normal_color);
        print "]\n";
    }
}

# check status of a program

sub is_running{
	my %property=(
			"running" => 0,
			"pid" => ""
			);
	my $program=$_[0];
	my @pid_list;
	my $pid;
	SWITCH:{
		# splxmod
		($program eq "splxmod") && do {
			open MODULES, "< /proc/modules";
			while(<MODULES>){
				if(/splxmod/){
					$property{'running'}=1;
				}
			}
			close MODULES;
			return %property;
			last SWITCH;
		};

		# default
		open PID_OF, "$pidof $program |" or return %property;
		while(<PID_OF>){
			@pid_list=split /\s/, $_;
		}
		close PID_OF;
		foreach $pid (@pid_list){
			if(kill 0, $pid){
				if($property{"pid"} eq ""){
					$property{"pid"}=$pid;
				}
				else{
					$property{"pid"}.=" $pid";
				}
			}
		}
		if($property{"pid"} ne ""){
			$property{"running"}=1;
			return %property;
		}
		else{
			$property{"running"}=0;
			return %property;
		}
	}
}

# show status of programs

sub show_status{
	my $program=$_[0];
	my $running=0;
	my %property=(
			"running" => 0,
			"pid" => ""
			);

	SWITCH:{
		($program eq "splxmod") && do {
			%property = is_running "splxmod";
			if($property{"running"}==1){
				print "$program module is running...\n";
				return 0;
			}
			if( -e "/var/lock/subsys/splxmod"){
				print "$program module has been loaded but is not running...\n";
				return 1;
			}
			else{
				print "$program module is stopped\n";
				return 1;
			}
			last SWITCH;
			};
		($program eq "entity") && do {
			%property = is_running "entity";
			if($property{"running"}==1){
				print "$program (pid ".$property{"pid"}.") is running...\n";
				return 0;
			}
			if(-e "/var/run/entity.pid"){
				open PID_FILE, "< /var/run/entity.pid";
				while(<PID_FILE>){
					chomp;
					if($_ ne ""){
						print "$program dead but pid file exists\n";
						return 1;
					}
					close PID_FILE;
				}
			}
			if( -e "/var/lock/subsys/entity.pid"){
				print "$program dead but subsys locked\n";
				return 1;
			}
			else{
				print "$program is stopped\n";
				return 1;
			}
			last SWITCH;
			};
		%property = is_running $program;
		if($property{"running"}==1){
			print "$program (pid ".$property{"pid"}.") is running...\n";
			return 0;
		}
		if(-e "/var/run/$program.pid"){
			open PID_FILE, "< /var/run/$program.pid";
			while(<PID_FILE>){
				print "$program is dead, but the pid file still exists. The pid file path is '/var/run/splxhttpd.pid'.\n";
				close PID_FILE;
				return 1;
			}
		}
		if(-e "/var/lock/subsys/$program"){
			print "$program is dead, but the subsys is locked. The subsys path is '/var/lock/subsys/splxhttpd'.\n";
			return 1;
		}
		else{
			print "$program is stopped\n";
			return 1;
		}
	}
}

# update library paths for execution

sub update_library_path{
	my $first=0;
	my $reload=0;
	open LD_SO_CONF_FILE, "< $ld_so_conf_file";
	while(<LD_SO_CONF_FILE>){
		if(/$product_root\/SPLX.lib/){
			$first=1;
		}
	}
	close LD_SO_CONF_FILE;
	open LD_SO_CONF_FILE, ">> $ld_so_conf_file";
	if($first==0){
		print LD_SO_CONF_FILE "$product_root/SPLX.lib\n";
		$reload=1;
	}
	close LD_SO_CONF_FILE;
	if($reload==1){
		system "$ldconfig";
	}

	my $ld_library_path=$ENV{'LD_LIBRARY_PATH'};
	if(defined($ld_library_path)){
		if(!($ld_library_path=~/"$product_root\/SPLX.lib"/)){
			if(length($ld_library_path)==0){
				$ld_library_path="$product_root/SPLX.lib";
			}
			else{
				$ld_library_path="$ld_library_path:$product_root/SPLX.lib";
			}
		}
	}

	return 1;
}

# kill process

sub kill_proc{
	my $program=$_[0];
        my @pid_list;
	my $i;
        my $return_value=0;
        open PID_OF, "$pidof $program |" or return 0;
        while(<PID_OF>){
                @pid_list=split /\s/, $_;
        }
        close PID_OF;
	$i= scalar(@pid_list)-1;
        if ($i<0){
                $return_value=1;
        }
#       midified to fix the internal case #TT155623 
        else{
		$count=$i;
		while($count>=0){
			
			open PPID_OF, "$ps -eo pid,ppid | grep $pid_list[ $count ] |" or return 0;
			my $line;
			while(<PPID_OF>){
			$line++;
			}
			close PPID_OF;
			if($line>1){
			last;
			}
			$count--;
		}
		if($count<0){
			$count=$i;
		}	
		my $pid=$pid_list[ $count ];
                $return_value+=kill 15, $pid;
        }
 #  modified end
	if($return_value){
                return 1;
        }
        else{
                return 0;
        }
}

# touch file

sub touch{
	my $filename=$_[0];
	if(-e $_[0]){
		open TEMP, $filename;
		close TEMP;
	}
	else{
		open TEMP, "> $filename";
		close TEMP;
	}
}

# main program

if($debuglevel!=0){
	open_log;
}
SWITCH:{
	(!defined($ARGV[0])) && do{
		print "Invalid usage of splxhttpd command.\n";
		print "Valid syntax is: '$0 {start|stop|restart|status}'.\n";
		print "Enter the correct splxhttpd command and try again.\n";
		exit 1;
				};
	($ARGV[0] eq "start") && do {
				#print "Starting ServerProtect for Linux httpd: \n";
				#write_log "Starting ServerProtect for Linux httpd:";

				# start splxhttpd
				print "Starting splxhttpd: ";
				write_log "step: starting splxhttpd service.";
				%property=is_running "splxhttpd";
				if(!$property{"running"}==1)
				{
					if((system "$httpd_prog > /dev/null 2>&1")!=0){
						echo_failure;
                        info_failure("Some errors were found while starting splxhttpd. See the system log for error description. The default system log file path is /var/log/messages.\n");
                        write_log "error: splxhttpd service can't be started.";

						exit(1);
					}	
				}
                                echo_success;

				touch "/var/lock/subsys/splxhttpd";
				info_success( "ServerProtect for Linux httpd started.\n");
				write_log "ServerProtect for Linux httpd started.";

				last SWITCH;
				};
	($ARGV[0] eq "stop") && do {
				my $STOP_splxhttpd=0;
				my $no_splxhttpd=0;

        			#print "Shutting down ServerProtect for Linux httpd:\n";
        			#write_log "Shutting down ServerProtect for Linux httpd: ";

				# stop splxhttpd
				  print "Shutting down splxhttpd: ";
				  write_log "step: shutting down splxhttpd service.";
				  %property=is_running "splxhttpd";
				  if($property{"running"}==0){
				    unlink "/var/lock/subsys/splxhttpd";
				    write_log "info: splxhttpd service not running.";
				    echo_failure;
				    $STOP_splxhttpd=0;
				    $no_splxhttpd=1;
				  } else {
                                    $i=0;
				    while ($property{"running"} && $i<15){
				      if(! kill_proc "splxhttpd"){
					write_log "Unable to stop splxhttpd. ServerProtect will attempt to stop splxhttpd.";
				      }
				      sleep 1;
				      %property=is_running "splxhttpd";
                                      $i=$i+1;
				    }
                                    if($property{"running"}){
                                        write_log "Some errors were found while stopping splxhttpd.";
                                        echo_failure;
                                        $STOP_splxhttpd=1;
                                    }else{
				        unlink "/var/lock/subsys/splxhttpd";
                        unlink "$product_root/SPLX.tmp/cookies_tmp";
				        write_log "success: splxhttpd service stopped.";
				        echo_success;
				        $STOP_splxhttpd=0;
                                    }
				  }

				$STOP=$STOP_splxhttpd;
                                if($STOP==0){
                                				if($no_splxhttpd==1)
                                				{
                                        	info_failure( "ServerProtect for Linux httpd not running.\n");
                                        	unlink "/var/lock/subsys/splxhttpd";
                                        	write_log "ServerProtect for Linux httpd not running.";
                                        	exit 2;
                                				}
                                				
                                        info_success( "ServerProtect for Linux httpd stopped normally.\n");
                                        unlink "/var/lock/subsys/splxhttpd";
                                        write_log "ServerProtect for Linux httpd stopped.";
                                        exit 0;
                                }
                                else{
                                    info_failure("splxhttp stopped with errors. See the system log for error description. The default system log file path is /var/log/messages.\n");
                                         write_log "ServerProtect for Linux httpd stopped with errors.";
                                        exit 1;
                                }
				last SWITCH;
				};
	($ARGV[0] eq "restart") && do {
				system "$0 stop";
				system "$0 start";
				last SWITCH;
				};
	($ARGV[0] eq "status") && do {
                                my $STATUS_splxhttpd=0;
				$STATUS_splxhttpd=show_status "splxhttpd";
				exit($STATUS_splxhttpd);
				last SWITCH;
				};
	print "Invalid usage of splxhttpd command.\n";
        print "Valid syntax is: '$0 {start|stop|restart|status}'.\n";
        print "Enter the correct splxhttpd command and try again.\n";
        
}

if($debuglevel!=0){
	close_log;
}

exit 0;
