const MSGTYPE = {
	kOpenURL: '100',
	kOpenApp: '101',
	kOpenDeepClean: '102',
	kRate: '103',
	kFeedback: '104',
	kAutoStart: '105',
	kCancelAutoStart: '106',
	kBigFile: '107',
	kSmartScan: '108'
};

var sendNativeResponse = function (msg) {
	if (window.webkit) {
		window.webkit.messageHandlers.native.postMessage(msg);
	}
};

var openURL = function (app_url, app_name) {
	if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kOpenURL,
			tag: app_name,
			URL: app_url
		});
	}
};

var openApp = function (app_bundleId, app_url) {
	if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kOpenApp,
			bundleId: app_bundleId,
			URL: app_url
		});
	}
};

var openDeepClean = function () {
	if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kOpenDeepClean
		});
	}
};

var openRate = function () {
	if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kRate
		});
	}
};

var openFeedback = function () {
	if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kFeedback
		});
	}
};

var openAutoStart = function () {
	if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kAutoStart
		});
	}
};

var openSmartScan = function () {
	if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kSmartScan
		});
	}
};

String.format = function () {
	if (arguments.length == 0)
		return null;
	var str = arguments[0];
	for (var i = 1; i < arguments.length; i++) {
		var re = new RegExp('\\{' + (i - 1) + '\\}', 'gm');
		str = str.replace(re, arguments[i]);
	}
	return str;
};

var wkSetLanguage = function (language) {
	$('.wrapper').children().each(function () {
		$(this).addClass(language);
	});

	switch (language) {
		case 'zh-Hans':
			wkRunLocalization(ATLocalization_zhCN);
			break;
		case 'zh-Hant':
			wkRunLocalization(ATLocalization_zhTW);
			break;
		case 'de':
			wkRunLocalization(ATLocalization_de);
			break;
		case 'es':
			wkRunLocalization(ATLocalization_es);
			break;
		case 'fr':
			wkRunLocalization(ATLocalization_fr);
			break;
		case 'it':
			wkRunLocalization(ATLocalization_it);
			break;
		case 'ko':
			wkRunLocalization(ATLocalization_ko);
			break;
		case 'nl':
			wkRunLocalization(ATLocalization_nl);
			break;
		case 'en':
			wkRunLocalization(ATLocalization_en);
			break;
		default:
			wkRunLocalization(ATLocalization_en);
	}
};

var wkRunLocalization = function(wkWordings) {

	$("#title-content").html(wkWordings.Product_Title);
	$("#btn-cancel-title-content").html(wkWordings.Button_Cancel);
	$("#btn-open-title-content").html(wkWordings.Button_Open);
};

var initEvent = function () {
	$(".btn-cancel").click(function () {
		window.location.href = "http://closewindow";
	});

	$(".btn-open").click(function () {
		openSmartScan();
	});
};

$(document).ready(function () {
	// wkSetLanguage("en");
	initEvent();
});
