const MSGTYPE = {
    kOpenApp: '101',
};

var sendNativeResponse = function (msg) {
	if (window.webkit) {
		window.webkit.messageHandlers.native.postMessage(msg);
	}
};

var openApp = function (app_bundleId, app_url) {
	if (typeof native != "undefined") {
		var parameter = {'bundleId': app_bundleId, 'appURL': app_url};
		native.openAppJS(parameter);
	} else if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kOpenApp,
			bundleId: app_bundleId,
			URL: app_url
		});
	}
};

var wkSetLanguage = function (language) {
	switch (language) {
		case 'zh-Hans':
			wkRunLocalization(Localization_zh_hans);
			break;
		case 'zh-Hant':
			wkRunLocalization(Localization_zh_hant);
			break;
		case 'de':
			wkRunLocalization(Localization_de);
			break;
		case 'es':
			wkRunLocalization(Localization_es);
			break;
		case 'fr':
			wkRunLocalization(Localization_fr);
			break;
		case 'it':
			wkRunLocalization(Localization_it);
			break;
		case 'ko':
			wkRunLocalization(Localization_ko);
			break;
		case 'nl':
			wkRunLocalization(Localization_nl);
			break;
		case 'en':
			wkRunLocalization(Localization_en);
		    break;
		case 'pt':
			wkRunLocalization(Localization_ptBR);
		    break;	
		default:
			wkRunLocalization(Localization_en);
	}
};

var wkRunLocalization = function(wkWordings) {
	$("#description-content-1").html(wkWordings.Product_Description_1);
	$("#description-content-2").html(wkWordings.Product_Description_2);
	$("#btn-cancel-title-content").html(wkWordings.Button_Cancel);
	$("#btn-download-title-content").html(wkWordings.Button_Download);
};

var initEvent = function () {
	$(".btn-cancel").click(function () {
		window.location.href = "http://closewindow";
	});

	$(".btn-download").click(function () {
		openApp('com.trendmicro.adblockone', 'macappstore://apps.apple.com/app/apple-store/id1491889901?pt=444218&ct=CleanerOnePro_BuyAdblock_V1001&mt=8');
	});
};

$(document).ready(function () {
	// wkSetLanguage('en')
	initEvent();
});
