const MSGTYPE = {
	kOpenURL: '100',
	kOpenApp: '101',
	kReactivateLicense: '102',
	kRenewLicense: '103'
};

var sendNativeResponse = function (msg) {
	if (window.webkit) {
		window.webkit.messageHandlers.native.postMessage(msg);
	}
};

var reactivateLicense = function () {
	if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kReactivateLicense
		});
	}
};

var renewLicense = function () {
	if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kRenewLicense
		});
	}
};

String.format = function() {
    if (arguments.length == 0)
        return null;
    var str = arguments[0];
    for ( var i = 1; i < arguments.length; i++) {
        var re = new RegExp('\\{' + (i - 1) + '\\}', 'gm');
        str = str.replace(re, arguments[i]);
    }
    return str;
};

var wkSetLanguage = function (language) {
	$('.wrapper').children().each(function () {
		$(this).addClass(language);
	});

	switch (language) {
		case 'zh-Hans':
			wkRunLocalization(ATLocalization_zhCN);
			break;
		case 'zh-Hant':
			wkRunLocalization(ATLocalization_zhTW);
			break;
		case 'de':
			wkRunLocalization(ATLocalization_de);
			break;
		case 'es':
			wkRunLocalization(ATLocalization_es);
			break;
		case 'fr':
			wkRunLocalization(ATLocalization_fr);
			break;
		case 'it':
			wkRunLocalization(ATLocalization_it);
			break;
		case 'ko':
			wkRunLocalization(ATLocalization_ko);
			break;
		case 'nl':
			wkRunLocalization(ATLocalization_nl);
			break;
		case 'en':
			wkRunLocalization(ATLocalization_en);
			break;
        case 'pt':
            wkRunLocalization(ATLocalization_ptBR);
            break;
		default:
			wkRunLocalization(ATLocalization_en);
	}
};

var wkRunLocalization = function(wkWordings) {
	$("#title-content").html(wkWordings.Product_Title);
	$("#description-content").html(wkWordings.Product_Description);
	$("#btn-reactivate-title-content").html(wkWordings.Button_Reactivate);
	$("#btn-renew-title-content").html(wkWordings.Button_Renew);
};

var initEvent = function() {
	$(".btn-reactivate").click(function() {
        reactivateLicense();
    });

    $(".btn-renew").click(function() {
        renewLicense();
    });
};

$(document).ready(function(){
	// wkSetLanguage("zh-Hans");
    initEvent();
});
