const MSGTYPE = {
    kOpenURL: '100',
    kOpenApp: '101'
};

var appLanguage = "";
var showiTIS = false;

var sendNativeResponse = function (msg) {
    if (window.webkit) {
        window.webkit.messageHandlers.native.postMessage(msg);
    }
};

var openURL = function (app_url, app_name) {
    if (typeof native != "undefined") {
        var parameter = {'URL': app_url};
        native.openURLJS(parameter);
    } else if (window.webkit) {
        sendNativeResponse({
            type: MSGTYPE.kOpenURL,
            tag: app_name,
            URL: app_url
        });
    }
};

var openApp = function (app_bundleId, app_url) {
    if (typeof native != "undefined") {
        var parameter = {'bundleId': app_bundleId, 'appURL': app_url};
        native.openAppJS(parameter);
    } else if (window.webkit) {
        sendNativeResponse({
            type: MSGTYPE.kOpenApp,
            bundleId: app_bundleId,
            URL: app_url
        });
    }
};

String.format = function() {
    if (arguments.length == 0)
        return null;
    var str = arguments[0];
    for ( var i = 1; i < arguments.length; i++) {
        var re = new RegExp('\\{' + (i - 1) + '\\}', 'gm');
        str = str.replace(re, arguments[i]);
    }
    return str;
}

var wkSetLanguage = function (language) {
    appLanguage = language;
    switch (language) {
        case 'zh-Hans':
            wkRunLocalization(ATLocalization_zhCN);
            break;
        case 'zh-Hant':
            wkRunLocalization(ATLocalization_zhTW);
            break;
        case 'de':
            wkRunLocalization(ATLocalization_de);
            break;
        case 'es':
            wkRunLocalization(ATLocalization_es);
            break;
        case 'fr':
            wkRunLocalization(ATLocalization_fr);
            break;
        case 'it':
            wkRunLocalization(ATLocalization_it);
            break;
        case 'ko':
            wkRunLocalization(ATLocalization_ko);
            break;
        case 'nl':
            wkRunLocalization(ATLocalization_nl);
            break;
        case 'en':
            wkRunLocalization(ATLocalization_en);
            break;
        case 'pt':
            wkRunLocalization(ATLocalization_ptBR);
            break;
        default:
            wkRunLocalization(ATLocalization_en);
    }
};

var wkRunLocalization = function(wkWordings) {
    $(".title-content").html(wkWordings.Product_Title);
    $(".description-content").html(wkWordings.Product_Description);
    $(".tool-name-content-safety").html(wkWordings.Tool_Name_safety);
    $(".tool-name-content-iTIS").html(wkWordings.Tool_Name_iTIS);
    $(".tool-description-content-safety").html(wkWordings.Tool_Description_safety);
    $(".tool-description-content-iTIS").html(wkWordings.Tool_Description_iTIS);
    $(".tool-name-content-icleanerone").html(wkWordings.Tool_Name_icleanerone);
    $(".tool-description-content-icleanerone").html(wkWordings.Tool_Description_icleanerone);
    $(".tool-name-content-feedback").html(wkWordings.Tool_Name_other);
    $(".tool-description-content-feedback").html(wkWordings.Tool_Description_other);
    $(".tool-name-content-vpnone").html(wkWordings.Tool_Name_vpnone);
    $(".tool-description-content-vpnone").html(wkWordings.Tool_Description_vpnone);
    $(".tool-name-content-adblockone").html(wkWordings.Tool_Name_adblockone);
    $(".tool-description-content-adblockone").html(wkWordings.Tool_Description_adblockone);
    $(".tool-name-content-unarchiver").html(wkWordings.Tool_Name_unarchiver);
    $(".tool-description-content-unarchiver").html(wkWordings.Tool_Description_unarchiver);
    $(".btn-open-title").html(wkWordings.Button_Open);
};

var wkSetRegion = function (region) {
    var showVO = region.toLowerCase() != 'cn' && appLanguage.toLowerCase() == 'en'
    if (showVO && !showiTIS) {
        showPlanB();
        return;
    }
    if (!showVO && showiTIS) {
        showPlanC();
        return;
    }
    if (showVO && showiTIS) {
        showPlanD();
        return;
    }
};

var showPlanB = function() {
    $("#wrapper-2").removeClass("hidden");
    $("#wrapper-1").addClass("hidden");
}

var showPlanC = function() {
    $("#wrapper-3").removeClass("hidden");
    $("#wrapper-1").addClass("hidden");
}

var showPlanD = function() {
    $("#wrapper-4").removeClass("hidden");
    $("#wrapper-1").addClass("hidden");
}

var iTISinstalled = function() {
    showiTIS = true;
}

var initEvent = function() {
    $(".btn-open-tool-safety").click(function() {
        openApp('com.trendmicro.DrSafety', 'macappstore://apps.apple.com/app/apple-store/id1068435535?pt=444218&ct=CleanerOnePro_TB_BuySafety_V1033&mt=12');
    });

    $(".btn-open-tool-iTIS").click(function() {
        openApp('com.trendmicro.iTIS.MainUI', '');
        openApp('com.trendmicro.iTIS.UIMgmt', '');
        openApp('com.trendmicro.AFMAgent', '');
        openApp('com.trendmicro.AFMMainUI', '');
    });

    $(".btn-open-tool-icleanerone").click(function() {
        openURL('https://itunes.apple.com/app/id1156773866?pt=444218&ct=CleanerOnePro_TB_BuyiCO_V1033&mt=12','iCleanerOne');
    });

    $(".btn-open-tool-adblockone").click(function() {
        openApp('com.trendmicro.adblockone', 'macappstore://apps.apple.com/app/apple-store/id1491889901?pt=444218&ct=CleanerOnePro_TB_BuyAdblock_V1033&mt=12');
    });

    $(".btn-open-tool-vpnone").click(function() {
        openApp('com.trendmicro.MAC.TMPWP', 'macappstore://apps.apple.com/app/apple-store/id1451310993?pt=444218&ct=CleanerOnePro_TB_BuyVPN_V1033&mt=12');
    });

    $(".btn-open-tool-unarchiver").click(function() {
        openApp('com.trendmicro.DrUnzip', 'macappstore://apps.apple.com/app/apple-store/id1127253508?pt=444218&ct=CleanerOnePro_TB_BuyUnarchiver_V1033&mt=12');
    });

    $(".tool-icon-feedback").click(function() {
        window.location.href="http://feedback/";
    });
}

$(document).ready(function(){
    // wkSetLanguage("en");
    // wkSetRegion("US");
    initEvent();
});
