String.format = function() {
    if (arguments.length == 0)
        return null;
    var str = arguments[0];
    for ( var i = 1; i < arguments.length; i++) {
        var re = new RegExp('\\{' + (i - 1) + '\\}', 'gm');
        str = str.replace(re, arguments[i]);
    }
    return str;
};

var getNotShowGuideCheckbox = function() {
    if ($("#setting-show-guide").hasClass("checkbox-checked")) {
        return true;
    } else {
        return false;
    }
}

var setShowGuideSettingUnShow = function() {
    $("#setting-show-guide").css("display", "none");
}

var setLanguage = function(language) {
    $('.guide').children().each(function(){
        $(this).addClass(language);
    });
    $('.action-button-content').addClass(language);

    $.getScript("localization/"+language+".lproj/LocalizationString.js", function(data, textStatus, jqxhr) {
        runLocalization();
    });
}

var initSilder = function() {
    $("#slides").slidesjs({
        width: 600,
        height: 328,
        navigation: {
            active: false,
            effect: "slide"
        },
        effect: {
            slide: {
                speed: 100
            }
        },
        callback: {
            loaded: function(number) {
                var index = number-1;
                $('.guide').eq(index).children().each(function(){
                    $('.guide').children().removeClass('animate');
                    if($(this).attr('data-animate')){
                        var  that = this;
                        setTimeout(function() {
                            $(that).addClass('animate');
                        }, 0);
                    }
                });

                $('.guide').eq(index).addClass('animate');
            },
            complete: function(number) {
                var index = number-1;
                $('.guide').eq(index).children().each(function(){
                    $('.guide').children().removeClass('animate');
                    if($(this).attr('data-animate')){
                        var  that = this;
                        setTimeout(function() {
                            $(that).addClass('animate');
                        }, 0);
                    }
                });

                if (number == 1) {
                    $('.guide').removeClass('animate');
                    $('.guide').eq(index).addClass('animate');
                }

                var count = $('.guide').length;

                if (number == count) {
                    $('.guide-setting-items').removeClass('hide');
                    $('.slidesjs-next').addClass('hide');
                    $('.action-button').removeClass('hide');
                } else {
                    $('.guide-setting-items').addClass('hide');
                    $('.slidesjs-next').removeClass('hide');
                    $('.action-button').addClass('hide');
                }
                callOC(number);
            }
        }
    });
};

var runLocalization = function() {
    $("#menuview-title").html(ATLocalization.Guide_Title);
    $("#menuview-description").html(ATLocalization.Guide_First_Step);
    $("#sidebar-title").html(ATLocalization.Guide_Title);
    $("#sidebar-description").html(ATLocalization.Guide_Second_Step);
    $("#menu-delete-title").html(ATLocalization.Guide_Title);
    $("#menu-delete-description").html(ATLocalization.Guide_Third_Step);
    $(".guide-setting-item-content").html(ATLocalization.Guide_Setting_Show_Guide);
    
    $("#next-button-content .action-button-content").html(ATLocalization.Guide_Next_Button);
    $("#enter-button-content .action-button-content").html(ATLocalization.Guide_Enter_Button);
}

var initEvent = function() {
    $('.guide-setting-item').click(function() {
        if ($(this).hasClass('checkbox-checked')) {
            $(this).removeClass('checkbox-checked')
        } else {
            $(this).addClass('checkbox-checked');
        }
    });
}

var callOC =  function (option) {
    if (native) {
        var parameter = {'event':option};
        var result = native.sendEvent(parameter);
    }
}

$(document).ready(function(){
    //setLanguage("en");
    initSilder();
    initEvent();
});
