const MSGTYPE = {
	kOpenURL: '100',
	kOpenApp: '101',
	kPurchase: '102',
	kActivate: '103'
};

const SKUID = {
	OneSeat:"1000",
	MutiSeat:"1002"
}

const SHOWSAVEDTYPE = {
	percent: 0,
	num: 1
}

var tmpJsonSku1 = {"OrignPrice":"","CurrentPrice":"","DiscountDescription":""};
var tmpJsonSku2 = {"OrignPrice":"","CurrentPrice":"","DiscountDescription":""};
var l10nDidSet = false;
var priceDidSetSku1 = false;
var priceDidSetSku2 = false;
var showSavedType = SHOWSAVEDTYPE.percent;

var sendNativeResponse = function (msg) {
	if (window.webkit) {
		window.webkit.messageHandlers.native.postMessage(msg);
	}
};

var openURL = function (app_url, app_name) {
	if (typeof native != "undefined") {
		var parameter = {'URL': app_url};
		native.openURLJS(parameter);
	} else if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kOpenURL,
			tag: app_name,
			URL: app_url
		});
	}
};

var openApp = function (app_bundleId, app_url) {
	if (typeof native != "undefined") {
		var parameter = {'bundleId': app_bundleId, 'appURL': app_url};
		native.openAppJS(parameter);
	} else if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kOpenApp,
			bundleId: app_bundleId,
			URL: app_url
		});
	}
};

var purchaseSku1 = function () {
	if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kPurchase,
			skuID: SKUID.OneSeat
		});
	}
};

var purchaseSku2 = function () {
	if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kPurchase,
			skuID: SKUID.MutiSeat
		});
	}
};

var activate = function () {
	if (window.webkit) {
		sendNativeResponse({
			type: MSGTYPE.kActivate
		});
	}
};

String.format = function() {
    if (arguments.length == 0)
        return null;
    var str = arguments[0];
    for ( var i = 1; i < arguments.length; i++) {
        var re = new RegExp('\\{' + (i - 1) + '\\}', 'gm');
        str = str.replace(re, arguments[i]);
    }
    return str;
};

var wkSetLanguage = function (language) {
	$('.wrapper').children().each(function () {
		$(this).addClass(language);
	});
	
	switch (language) {
		case 'zh-Hans':
			wkRunLocalization(ATLocalization_zhCN);
			break;
		case 'zh-Hant':
			wkRunLocalization(ATLocalization_zhTW);
			break;
		case 'de':
			wkRunLocalization(ATLocalization_de);
			break;
		case 'es':
			wkRunLocalization(ATLocalization_es);
			break;
		case 'fr':
			wkRunLocalization(ATLocalization_fr);
			break;
		case 'it':
			wkRunLocalization(ATLocalization_it);
			break;
		case 'ko':
			wkRunLocalization(ATLocalization_ko);
			break;
		case 'nl':
			wkRunLocalization(ATLocalization_nl);
			break;
		case 'en':
			wkRunLocalization(ATLocalization_en);
			break;
		default:
			wkRunLocalization(ATLocalization_en);
	}
};

var wkRunLocalization = function(wkWordings) {
	$("#title-content").html(wkWordings.Product_Title);
	$("#plan-title-0").html(wkWordings.Plan_Title_0);
	$("#plan-title-1").html(wkWordings.Plan_Title_1);
	$("#plan-title-2").html(wkWordings.Plan_Title_2);
	$("#sku-price-0").html(wkWordings.Sku_Price_0);
	$(".text-year").html(wkWordings.Text_Year);
	$(".btn-upgrade-title").html(wkWordings.Btn_Upgrade);
	$(".text-current").html(wkWordings.Text_Current);
	$("#plan-desc-title-0").html(wkWordings.Plan_Desc_Title_0);
	$("#plan-desc-title-1").html(wkWordings.Plan_Desc_Title_1);
	$("#plan-desc-title-2").html(wkWordings.Plan_Desc_Title_2);
	$(".plan-desc-detail-feature-0").html(wkWordings.Plan_Desc_Feature_0);
	$(".plan-desc-detail-feature-1").html(wkWordings.Plan_Desc_Feature_1);
	$(".plan-desc-detail-feature-2").html(wkWordings.Plan_Desc_Feature_2);
	$(".plan-desc-detail-feature-3").html(wkWordings.Plan_Desc_Feature_3);
	$(".plan-desc-detail-feature-4").html(wkWordings.Plan_Desc_Feature_4);
	$(".plan-desc-detail-feature-5").html(wkWordings.Plan_Desc_Feature_5);
	$(".plan-desc-detail-feature-6").html(wkWordings.Plan_Desc_Feature_6);
	$("#additional-description-content").html(wkWordings.Additional_Desc);
	$("#btn-activate-title-content").html(wkWordings.Button_Activate);

	$("#sku-price-saved-num-1").html(wkWordings.Sku_Price_Saved_Num_1);
	$("#sku-price-saved-num-2").html(wkWordings.Sku_Price_Saved_Num_2);
	$("#sku-price-saved-percent-1").html(wkWordings.Sku_Price_Saved_Percent_1);
	$("#sku-price-saved-percent-2").html(wkWordings.Sku_Price_Saved_Percent_2);

	if(showSavedType == SHOWSAVEDTYPE.num) {
		$("#sku-price-saved-num-1").removeClass('hidden');
		$("#sku-price-saved-num-2").removeClass('hidden');
		$("#sku-price-saved-percent-1").addClass('hidden');
		$("#sku-price-saved-percent-2").addClass('hidden');
	} else {
		$("#sku-price-saved-num-1").addClass('hidden');
		$("#sku-price-saved-num-2").addClass('hidden');
		$("#sku-price-saved-percent-1").removeClass('hidden');
		$("#sku-price-saved-percent-2").removeClass('hidden');
	}

	l10nDidSet = true;
	if(priceDidSetSku1) {
		setPriceSavedSku1(tmpJsonSku1);
	}
	if(priceDidSetSku2) {
		setPriceSavedSku2(tmpJsonSku2);
	}
};

var wkSetPriceSku1 = function(skuInfo) {
	var skuInfoJson = jQuery.parseJSON(skuInfo);
	
	tmpJsonSku1 = skuInfoJson;
	priceDidSetSku1 = true;
	if(l10nDidSet){
		setPriceSavedSku1(skuInfoJson);
	}

	var orignPrice = skuInfoJson['OrignPrice'];
	var currentPrice = skuInfoJson['CurrentPrice'];
	
	$("#sku-price-orign-1").html(orignPrice);
	var currentPrice = currentPrice + "/";
    $("#sku-price-current-1").html(currentPrice);

	$("#loading-1").addClass('hidden');
	$("#all-price-block-sku1").removeClass("hidden");
}

var wkSetPriceSku1Fail = function() {
	$("#sku-price-orign-1").html('');
	$("#sku-price-current-1").html('');
	$("#loading-1").addClass('hidden');
}

var wkSetPriceSku2 = function(skuInfo) {
	var skuInfoJson = jQuery.parseJSON(skuInfo);

	tmpJsonSku2 = skuInfoJson;
	priceDidSetSku2 = true;
	if(l10nDidSet){
		setPriceSavedSku2(skuInfoJson);
	}

	var orignPrice = skuInfoJson['OrignPrice'];
	var currentPrice = skuInfoJson['CurrentPrice'];
	
	$("#sku-price-orign-2").html(orignPrice);
	var currentPrice = currentPrice + "/";
    $("#sku-price-current-2").html(currentPrice);

	$("#loading-2").addClass('hidden');
	$("#all-price-block-sku2").removeClass("hidden");
}

var wkSetPriceSku2Fail = function() {
    $("#sku-price-orign-2").html('');
    $("#sku-price-current-2").html('');
    $("#loading-2").addClass('hidden');
}

var setPriceSavedSku1 = function(skuInfoJson) {

	var orignPrice = skuInfoJson['OrignPrice'];
	var currentPrice = skuInfoJson['CurrentPrice'];
	var dicount = skuInfoJson['DiscountDescription'];

	if(showSavedType == SHOWSAVEDTYPE.percent) {
		var oldString = $("#sku-price-saved-percent-1").html();
		var newString = oldString.replace('%@', dicount);
		$("#sku-price-saved-percent-1").html(newString);
	} else {
		var originNum = (orignPrice.match(/\d+(.\d+)?/g))[0];
		var currentNum = (currentPrice.match(/\d+(.\d+)?/g))[0];
		var savedNum = parseFloat(originNum) - parseFloat(currentNum);
		savedNum = savedNum.toFixed(2)
		var savedNumStr = currentPrice.replace(/\d+(.\d+)?/g,savedNum);

		var oldString = $("#sku-price-saved-num-1").html();
		var newString = oldString.replace('%@', savedNumStr);
		$("#sku-price-saved-num-1").html(newString);
	}
}

var setPriceSavedSku2 = function(skuInfoJson) {

	var orignPrice = skuInfoJson['OrignPrice'];
	var currentPrice = skuInfoJson['CurrentPrice'];
	var dicount = skuInfoJson['DiscountDescription'];

	if(showSavedType == SHOWSAVEDTYPE.percent) {
		var oldString = $("#sku-price-saved-percent-2").html();
		var newString = oldString.replace('%@', dicount);
		$("#sku-price-saved-percent-2").html(newString);
	} else {
		var originNum = (orignPrice.match(/\d+(.\d+)?/g))[0];
		var currentNum = (currentPrice.match(/\d+(.\d+)?/g))[0];
		var savedNum = parseFloat(originNum) - parseFloat(currentNum);
		savedNum = savedNum.toFixed(2)
		var savedNumStr = currentPrice.replace(/\d+(.\d+)?/g,savedNum);

		var oldString = $("#sku-price-saved-num-2").html();
		var newString = oldString.replace('%@', savedNumStr);
		$("#sku-price-saved-num-2").html(newString);
	}
}

var initEvent = function() {
    $(".btn-close").click(function() {
        window.location.href="http://closewindow";
    });

    $("#btn-upgrade-1").click(function() {
		purchaseSku1();
	});
	
	$("#btn-upgrade-2").click(function() {
		purchaseSku2();
 });

    $(".btn-activate").click(function() {
       	activate();
	});
	
	if( Math.round(Math.random()) == 0 ) {
		showSavedType = SHOWSAVEDTYPE.percent;
	} else {
		showSavedType = SHOWSAVEDTYPE.num;
	}
};

$(document).ready(function(){
    // wkSetLanguage("zh-Hans");
    initEvent();
});
