var store = window.localStorage;
var flavours = ['aws', 'azure', 'on-premise'];
var languages = [
	{  'label':'English', 'id':'ENGLISH',  'value':'', 	 'airgapped': 'hc_en'  },
	{  'label':'中文', 	  'id':'CHINESE',  'value':'zh-cn', 'airgapped': 'hc_zh_cn'  },
	{  'label':'日本語',   'id':'JAPANESE', 'value':'ja-jp', 'airgapped': 'hc_ja_jp'  }
];
var languageSubFolders = ['hc_en', 'hc_zh_cn', 'hc_ja_jp', 'zh-cn', 'ja-jp'];

var isRedirected = getParameterByName('redirected') || getParameterByName('cshid');

var currentFlavour = '';
var currentVersion = ''; 
var currentLanguage = '';
var airgapped = false;
var urlParams = window.location.pathname.split('/');
var selectedLanguage = 'ENGLISH';

if(typeof(urlParams[0]) != undefined && urlParams[0] == '') {
	urlParams.splice(0, 1);
}

// Check if URL is 10.0
if(urlParams[0] == "10" && urlParams[1] && urlParams[1] == "0") {
	currentFlavour = "";
	currentVersion = "10/0";
	urlParams.splice(0, 2);

// Check if flavour is set (10_1/aws/)
} else if(urlParams[1] && flavours.indexOf(urlParams[1]) > -1) {
	currentFlavour = urlParams[1];
	currentVersion = urlParams[0];
	urlParams.splice(0, 2);

// Check if version is set (10_1/)
} else if(parseInt(urlParams[0].replace('_',''))) {
	currentVersion = urlParams[0];
	urlParams.splice(0, 1);
}

// Get the selected language
for(var i = 0; i < languages.length; i++) {
	if(urlParams[0] == languages[i].value) {
		selectedLanguage = languages[i].id;
		break;
	} else if(urlParams[0] == languages[i].airgapped) {
		airgapped = true;
		selectedLanguage = languages[i].id;
		break;
	}
}

var directoryPath = (currentVersion ? currentVersion + '/' : '') + (currentFlavour ? currentFlavour + '/' : '');

if(!airgapped && window.location.protocol != 'file:' && !getParameterByName('pageNotFound') && !getParameterByName('stayOnPage')) {
	redirectToUserHelpCenter();
}

$(document).ready(function() {
	initializeProductSelector();
	initializeLanguageSelector();
});

function redirectToUserHelpCenter() {

	var softwarePages = [
		'software.html', 
		'software-9-0.html', 
		'software-9-5.html', 
		'software-9-6.html', 
		'software-10-0.html',
		'software-11-0.html',
		'software-feature-releases.html'
	];

	for(var i = 0; i < 3; i++) {
		if(urlParams[i] && softwarePages.indexOf(urlParams[i]) > -1) {
			if(currentFlavour || currentVersion) {
				redirect('');
			}
			return;
		}
	}

	if(isRedirected || (store.getItem('flavour') == currentFlavour && store.getItem('version') == currentVersion)) {
		store.setItem('flavour', currentFlavour);
		store.setItem('version', currentVersion);
		return;
	}

	var flavour = store.getItem('flavour') ? store.getItem('flavour') + '/' : '';
	var version = store.getItem('version') ? store.getItem('version') + '/' : '';

	if(flavour  || version) {
		redirect(version + flavour);
	}
}

function redirect(productSubFolder) {
	var origin = window.location.origin + '/';
	var urlPath = urlParams.join('/');

	var anchorArray = window.location.href.split('#');
	var anchor = anchorArray[1] ? '#' + anchorArray[1] : '';

	var queryArray = window.location.href.split('?');
	var query = queryArray[1] && queryArray[1] != 'redirected=true' && queryArray[1] != 'pageNotFound=true' && queryArray[1] != 'stayOnPage=true' ? '&' + queryArray[1] : '';

	var redirectTo = origin + productSubFolder + urlPath + anchor + '?redirected=true' + query.replace('&redirected=true', '');
	window.location.href = redirectTo;
}

function initializeProductSelector() {

	var navSearch = $('.nav-search');

	if(airgapped || getParameterByName('cshid') || window.self !== window.top) {
		navSearch.find('.search').css('width', '100%');
		return;
	}

	var html = '';
	var selected = '';

	var options = [{
		label: 'Deep Security as a Service',
		value: ''
	}, {
		label: 'Deep Security 11.1オンプレミス',
		value: '11_1/on-premise/'	
	}, {
		label: 'Deep Security 11.1 AWS Marketplace',
		value: '11_1/aws/'
	}, {
		label: 'Deep Security 11.1 Azure Marketplace',
		value: '11_1/azure/'		
	}, {
		label: 'Deep Security 11.0オンプレミス',
		value: '11_0/on-premise/'
	}, {
		label: 'Deep Security 11.0 AWS Marketplace',
		value: '11_0/aws/'	
	}, {
		label: 'Deep Security 11.0 Azure Marketplace',
		value: '11_0/azure/'			
	}, {
		label: 'Deep Security 10.3オンプレミス',
		value: '10_3/on-premise/'
	},  {
		label: 'Deep Security 10.3 AWS Marketplace',
		value: '10_3/aws/'
	},  {
		label: 'Deep Security 10.3 Azure Marketplace',
		value: '10_3/azure/'
	}, {
		label: 'Deep Security 10.2オンプレミス',
		value: '10_2/on-premise/'
	},  {
		label: 'Deep Security 10.2 AWS Marketplace',
		value: '10_2/aws/'
	},  {
		label: 'Deep Security 10.2 Azure Marketplace',
		value: '10_2/azure/'
	}, {
		label: 'Deep Security 10.1オンプレミス',
		value: '10_1/on-premise/'
	}, {
		label: 'Deep Security 10.1 for AWS Marketplace',
		value: '10_1/aws/'
	}, {
		label: 'Deep Security 10.1 for Azure Marketplace',
		value: '10_1/azure/'
	}, {
		label: 'Deep Security 10.0 (すべてのプラットフォーム)',
		value: '10/0/'
	}];

	html += '<div class="product-dropdown">';
	html += '	<div class="selected">';

	var selectedValue = false;
	for(var i = 0; i < options.length; i++) {
		if(options[i].value == directoryPath) {
			html += '<span class="selected-text">' + options[i].label + '</span>';
			selectedValue = true;
			break;
		}
	}

	if(!selectedValue) {
		html += '<span>' + options[0].label + '</span>';
	}

	html += '	</div>';
	html += '	<ul class="options">';

	for(var i = 0; i < options.length; i++) {
		if(options[i].value != directoryPath) {
			html += '<li><a href="javascript:redirect(&quot;' + options[i].value + '&quot;);">' + options[i].label + '</a></li>';
		}
	}

	html += '	</ul>';
	html += '</div>';

	$('.nav-search').find('.search').css('width','calc(60% - 10px)');

	navSearch.prepend(html);

	var productDropdown = $('.product-dropdown');

	$('body').click(function(e) {
		if(e.target.className != 'selected' && e.target.className != 'selected-text') {
			productDropdown.removeClass('active');
		}
	})

	productDropdown.click(function() {
		productDropdown.toggleClass('active');
	});
}

function initializeLanguageSelector() {

	var navigationWrapper = $('.navigation-wrapper');

	if(!navigationWrapper) {
		return;
	}

	if(window.location.protocol == 'file:') {
		console.warn('ローカルファイルをご覧の場合、言語とプラットフォームの選択機能は正しく動作しません。HTTPプロトコルのURL (Webサーバ) が必要です。');
	}

	var html = '';
	var lang = '';
	var params = urlParams.slice();

	if(params[0]) {
		if(languageSubFolders.indexOf(params[0]) > -1) {
			params.splice(0, 1);
		}
	}

	html = '<ul class="language-selector">';

	for(var i = 0; i < languages.length; i++) {
	
		lang = languages[i];
		
		html += '<li>';
	
		if(lang.id == 'ENGLISH') {
			html += '<a href="' + window.location.origin + '/' + directoryPath + ((airgapped) ? lang.airgapped + '/' : '') + params.join('/') + '" class="' + ((selectedLanguage == lang.id) ? 'active' : '') + '">' + lang.label + '</a>';
		} else {
			html += '<a href="' + window.location.origin + '/' + directoryPath + ((airgapped) ? lang.airgapped : lang.value) + '/' + params.join('/') +  '" class="' + ((selectedLanguage == lang.id) ? 'active' : '') + '">' + lang.label + '</a>';
		}
	
		html += '</li>';
	
	}
	
	html += '</ul>';
	
	navigationWrapper.append(html);

	$('ul.navigation').css('margin-top', 28);
}

function getParameterByName(name) {
  var query = window.location.search;
  var value = '';

  query = query.replace('?', '');
  query = query.split('&');

  query.forEach(function(param) {
    param = param.split('=');
    if (param[0] === name) {
      value = param[1];
    }
  });

  return value;
}