// Copyright (C) 2013 Trend Micro Inc. All rights reserved.

function helpInit(){
	//changeParentTitle();
	checkIfSearch();
	if(document.title == "Frequently Asked Questions"){
		expandHLNodes()
	}
}
window.onload=helpInit;

function changeParentTitle(){
	if(window.parent){
		window.parent.document.title = "DSS Help -- " + window.document.title;
	}
}


function checkIfSearch(){

	var search = getQueryStringValue("search");
	
	if(search != -1 && window.parent.SEARCHING == true)
	{
		if(document.getElementById("searchToggleDiv"))
			document.getElementById("searchToggleDiv").style.display = "block";
	
		var aIgnored = new Array(
		 "a", "about", "after", "all", "also", "an", "and",
		 "another", "any", "are", "as", "at", "be", "because", "been", "before", "being", 
		 "between", "both", "but", "by", "came", "can", "come", "could", "did", "do", 
		 "does", "each", "else", "for", "from", "get", "got", "has", "had", "he", "have", 
		 "her", "here", "him", "himself", "his", "how", "if", "in", "into", "is", "it", "its", 
		 "just", "like", "make", "many", "me", "might", "more", "most", "much", "must", "my", 
		 "never", "no", "now", "of", "on", "only", "other", "our", "out", "over", "re", "said", 
		 "same", "see", "should", "since", "so", "some", "still", "such", "take", "than", "that", 
		 "the", "their", "them", "then", "there", "these", "they", "this", "those", "through", "to", 
		 "too", "under", "up", "use", "very", "want", "was", "way", "we", "well", "were", "what", 
		 "when", "where", "which", "while", "who", "will", "with", "would", "you", "your", 
		 "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ".", "$", 
		 "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");
	
		var aSearch = search.split(" ");
		
		var len = aSearch.length;
		var aFinal = new Array();
		var sNewBit = "";
		for (i=0;i<=len;i++){
			for (j=i+1;j<=len;j++){
				sNewBit = aSearch.slice(i,j).join(" ");
				var b = 0;
				for(k=0;k<aIgnored.length;k++){
					if(sNewBit == aIgnored[k]){
						b = 1;
					}
				}
				if(b == 0){
					aFinal.push(sNewBit);
				}
			}
		}
	
		aFinal.sort(compareFunction);

		var lengthOfLongestPhrase = aFinal[0].split(" ").length;
		var aCssClassNames = new Array("searchStringHi", "searchStringMed", "searchStringLow");
		
		for(i=0;i<aFinal.length;i++){
			if(aFinal[i].split(" ").length == lengthOfLongestPhrase)
				highlightWord(document.getElementsByTagName("body")[0], aFinal[i], aCssClassNames[0]);
			else if(aFinal[i].split(" ").length == lengthOfLongestPhrase - 1)
				highlightWord(document.getElementsByTagName("body")[0], aFinal[i], aCssClassNames[1]);
			else 
				highlightWord(document.getElementsByTagName("body")[0], aFinal[i], aCssClassNames[2]);
		}
	}
}




function compareFunction(a,b){
	return(b.length - a.length)
}

function getQueryStringValue(param){
	var keyIsPresent = false;
	var loc = window.location.href.toString();
	if(loc.indexOf("?") != -1)
	{
		var qs = loc.split("?")[1];
		var keyValueArr = qs.split("&");
		var value = "";
		for(i=0;i<keyValueArr.length;i++){
			if(keyValueArr[i].split("=")[0] == param){
				if(keyValueArr[i].split("=").length == 2){
					keyIsPresent = true;
					value = keyValueArr[i].split("=")[1];
					break;
				}
			}
		}
	}
	if(keyIsPresent)
		return(decodeURI(value).toLowerCase().replace(/\+/g, " "))
	else
		return(-1)
}

function highlightWord(node,word,cssclassname) {
	// Iterate into this node's childNodes
	if (node.hasChildNodes) {
		var hi_cn;
		for (hi_cn=0;hi_cn<node.childNodes.length;hi_cn++) {
			highlightWord(node.childNodes[hi_cn],word,cssclassname);
		}
	}
	// And do this node itself
	if (node.nodeType == 3) { // text node
		tempNodeVal = node.nodeValue.toLowerCase();
		tempWordVal = word.toLowerCase();
		if (tempNodeVal.indexOf(tempWordVal) != -1) {
			pn = node.parentNode;
			if (pn.tagName.toLowerCase() != "h1" && 
				pn.className != "searchStringLow" && 
				pn.className != "searchStringMed" && 
				pn.className != "searchStringHi") {
				
				// word has not already been highlighted!
				nv = node.nodeValue;
				ni = tempNodeVal.indexOf(tempWordVal);
				// Create a load of replacement nodes
				before = document.createTextNode(nv.substr(0,ni));
				docWordVal = nv.substr(ni,word.length);
				after = document.createTextNode(nv.substr(ni+word.length));
				hiwordtext = document.createTextNode(docWordVal);
				hiword = document.createElement("span");
				hiword.className = cssclassname;
				hiword.appendChild(hiwordtext);
				pn.insertBefore(before,node);
				pn.insertBefore(hiword,node);
				pn.insertBefore(after,node);
				pn.removeChild(node);
			}
		}
	}
}

var HIGHLIGHT = 1;
function toggleHighlight(){
	coll = document.getElementsByTagName("span");
	for(i=0;i<coll.length;i++){
		//alert(coll[i].className);
		cn = coll[i].className.toString();
		
		if(HIGHLIGHT == 1 && (cn == "searchStringHi" || cn == "searchStringMed" || cn == "searchStringLow")){
			coll[i].style.backgroundColor = "white";
		}
		else if(HIGHLIGHT == 0){
			if(cn == "searchStringHi"){
				coll[i].style.backgroundColor = "#ffff33";	
			}
			else if(cn == "searchStringMed"){
				coll[i].style.backgroundColor = "#ffff99";	
			}
			else if(cn == "searchStringLow"){
				coll[i].style.backgroundColor = "#ffffcc";	
			}
		}
	}
	if(HIGHLIGHT == 0)
		HIGHLIGHT = 1;
	else
		HIGHLIGHT = 0;	
}


//  toggles the display of answers in the faq.
function showHideAnswer(el){
	var q = el;
	while(q.className != "question"){
		q = q.parentNode
	}
	var coll = q.parentNode.childNodes;
	for(i=0;i<coll.length;i++){
		if(coll[i].className == "answer"){
			var ans = coll[i];
			break;
		}
	}
	var im = el.childNodes[0];
	if(ans.style.display != "none"){
		ans.style.display = "none";
		im.setAttribute("src", "images/plus.gif");
		el.style.fontWeight = "normal";
	}
	else{
		ans.style.display = "block";
		im.setAttribute("src", "images/minus.gif");
		el.style.fontWeight = "bold";
	}
}

function getElementsByClassName(oElm, strTagName, strClassName){
/*
    Written by Jonathan Snook, http://www.snook.ca/jonathan
    Add-ons by Robert Nyman, http://www.robertnyman.com
*/
    var arrElements = (strTagName == "*" && document.all)? document.all : 
    oElm.getElementsByTagName(strTagName);
    var arrReturnElements = new Array();
    strClassName = strClassName.replace(/\-/g, "\\-");
    var oRegExp = new RegExp("(^|\\s)" + strClassName + "(\\s|$)");
    var oElement;
    for(var i=0; i<arrElements.length; i++){
        oElement = arrElements[i];      
        if(oRegExp.test(oElement.className)){
            arrReturnElements.push(oElement);
        }   
    }
    return (arrReturnElements)
}



function expandHLNodes(){
	var coll = getElementsByClassName(document, "*", "answer"); // questions
	for(ii=0;ii<coll.length;ii++){
		var cSpans = coll[ii].getElementsByTagName("span"); //highlights
		for(jj=0;jj<cSpans.length;jj++){
			if(cSpans[jj].className.indexOf("search")!= -1){
				for(kk=0;kk<cSpans[jj].parentNode.parentNode.childNodes.length;kk++){ // for ie vs ff childNodes compatibility, loop through childnodes to find the question span
					if(cSpans[jj].parentNode.parentNode.childNodes[kk].className == "question"){
						showHideAnswer(cSpans[jj].parentNode.parentNode.childNodes[kk]);
						break;
					}
				}
			}
		}
	}
}
