<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/tld/struts-bean-el.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/tld/struts-html-el.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/tld/c.tld" prefix="c" %>

<html>
<head>
<title></title>
<link href="/css/trend-style.css" rel="stylesheet" type="text/css" />
<base target="_self" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<script language="JavaScript" src="/javascripts/tooltip.js" type="text/javascript"></script>
<script language="JavaScript" src="/javascripts/validation.jsp"></script>
<script language="JavaScript" type="text/JavaScript">
var readOnly = false;
var itemChecked = false;

function checkReadOnly()
{
    <c:if test="${adminUser.systemReadOnly}">
        readOnly = true;
        form = document.forms[0];
        if(!form)
        {
            return;
        }
        
        form.addBtn.disabled = true;
        form.resetBtn.disabled = true;
        form.saveBtn.disabled = true;
        disableDatabutton("delBtnTop");
        disableDatabutton("delBtnBottom");
    </c:if>
    return;
}

function refreshDataButtonStatus()
{
    itemChecked = false;
    
    form = document.forms[0]
    if(!form)
    {
        return;
    }
    
    if(form.checkAll.checked || form.selectAllEntriesTop.checked || form.selectAllEntriesBottom.checked)
    {
        itemChecked = true;
    }
    else if(form.selectedDest)
    {
        if(form.selectedDest.checked)
        {
            itemChecked = true;
        }
        else
        {
            for(var i=0; i<form.selectedDest.length; i++)
            {
                if(form.selectedDest[i].checked)
                {
                    itemChecked = true;
                    break;
                }
            }
        }
    }
    
    if(itemChecked)
    {
        enableDatabutton("delBtnTop");
        enableDatabutton("delBtnBottom");
    }
    else
    {
        disableDatabutton("delBtnTop");
        disableDatabutton("delBtnBottom");
    }
    
    checkReadOnly();
    return;
}

function enableDatabutton(btnId)
{
    btn = document.getElementById(btnId);
    if(!btn)
    {
        return;
    }
    
    if(!btn.disabled)
    {
        return;
    }
    
    btn.disabled = false;
    btn.style.cursor = "pointer";
    btn.style.color = "";
    btn.style.textDecoration = "";
    
    btnImg = document.getElementById(btnId + "Img");
    if(!btnImg)
    {
        return;
    }
    btnImg.src = btnImg.src.replace(/_gray.gif/i, ".gif");
    btnImg.style.cursor = "pointer";
}

function disableDatabutton(btnId)
{
    btn = document.getElementById(btnId);
    if(!btn)
    {
        return;
    }
    
    if(btn.disabled)
    {
        return;
    }
    
    btn.disabled = true;
    btn.style.cursor = "default";
    btn.style.color = "#999999";
    btn.style.textDecoration = "none";
    
    btnImg = document.getElementById(btnId + "Img");
    if(!btnImg)
    {
        return;
    }
    btnImg.src = btnImg.src.replace(/.gif/i, "_gray.gif");
    btnImg.style.cursor = "default";
}

function checkBError()
{
    <c:if test="${!empty errorMsg}" var="errmsg" scope="request">
        alert("<c:out value='${errorMsg}' />");
    </c:if>
}

function lockButtons()
{
    btn = document.getElementById("addBtn");
    btn.disabled = true;
    btn = document.getElementById("resetBtn");
    btn.disabled = true;
    btn = document.getElementById("saveBtn");
    btn.disabled = true;
    btn = document.getElementById("cancelBtn");
    btn.disabled = true;
    
    return;
}

function deleteDest()
{
    form = document.forms[0];
    form.action = "/removeDestination.imss";
    form.submit();
}

function checkSelectAllEntries(item)
{   
    form = document.forms[0];
    if(!form)
    {
        return;
    }
    
    if(item.checked)
    {
        form.selectAllEntriesTop.checked = true;
        form.selectAllEntriesBottom.checked = true;
    }
    else
    {
        form.selectAllEntriesTop.checked = false;
        form.selectAllEntriesBottom.checked = false;
    }
    
    refreshDataButtonStatus();
}

function editDestination()
{
    form = document.forms[0];
    if(!form)
    {
        return;
    }
    
    var address = form.address.value;
    if(address.length == 0 || (isValidIPAddress(address) == false && isValidateIPv6Address(address) == false && checkHostNameStr(address) == false))
    {
        form.address.focus();
        form.address.select();
        alert("<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.invalidDestAddress' />");
        return;
    }
    
    var port = form.port.value;
    if(port.length == 0 || checkportstr(port) == false)
    {
        form.port.focus();
        form.port.select();
        alert("<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.invalidDestPort' />");
        return;
    }
    
    var pref = form.pref.value;
    if(pref.length == 0 || isNaN(pref) || parseInt(pref, 10) < 1 || parseInt(pref, 10) > 65535 || pref.indexOf('.') != -1)
    {
        form.pref.focus();
        form.pref.select();
        alert("<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.invalidDestPref' />");
        return;
    }
    
    form.action = "/editDestination.imss";
    form.submit();
}

function firstPage()
{
    document.forms[0].action = "/firstDestinationPage.imss";
    form.submit();
}

function lastPage()
{
    document.forms[0].action = "/lastDestinationPage.imss";
    form.submit();
}

function prevPage()
{
    document.forms[0].action = "/prevDestinationPage.imss";
    form.submit();
}

function nextPage()
{
    document.forms[0].action = "/nextDestinationPage.imss";
    form.submit();
}

function jumpToPage(arg)
{
    var id = "pageNum1";
    var val = document.getElementById(arg).options[document.getElementById(arg).options.selectedIndex].value;
    if(arg == "pageNum1")
    {
        id = "pageNum2";
    }
    for(var i=0;i<document.getElementById(id).options.length;i++)
    {        
        if(document.getElementById(id).options[i].value == val)
        {            
            document.getElementById(id).options[i].selected=true;
            break;        
        }    
    }
    document.forms[0].action="/jumpDestinationPage.imss";
    document.forms[0].submit();
    return false;
}

function changePageSize()
{
    document.forms[0].action="/changeDestinationPageSize.imss";
    document.forms[0].submit();
    return false;
}

function sortBy(column)
{
    if(document.forms[0].sortBy.value==column)
    {
        if(document.forms[0].sortDirection.value == 1)
            document.forms[0].sortDirection.value = 0;
        else
            document.forms[0].sortDirection.value = 1;
    }
    else
    {
        document.forms[0].sortDirection.value = 1;
        document.forms[0].sortBy.value = column;
    }
    document.forms[0].action="/sortDestinationPage.imss";
    document.forms[0].submit();
    return false;
}

function checkDest(checkedItem, top, items)
{
    updateCheckboxGroup(checkedItem, top, items);
    if(items)
    {
        items.checked = top.checked;
    }
    refreshDataButtonStatus();
}

function clickDestination(index, address, port, pref)
{
    form = document.forms[0];
    
    if(form.selectedDest.length)
    {
        for(var i=0; i<form.selectedDest.length; i++)
        {
            if(form.selectedDest[i].value == index)
            {
                form.selectedDest[i].checked = true;
            }
            else
            {
                form.selectedDest[i].checked = false;
            }
        }
    }
    else
    {
        form.selectedDest.checked = true;
    }
    
    form.address.value = address;
    form.port.value = port;
    form.pref.value = pref;
    
    form.destOp.value = "update";
    form.addBtn.value = "<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.updateDest' />";
}

function resetDestOp()
{
    form = document.forms[0];
    if(!form)
    {
        return;
    }
    
    if(form.selectedDest)
    {
        if(form.selectedDest.length)
        {
            for(var i=0; i<form.selectedDest.length; i++)
            {
                form.selectedDest[i].checked = false;
            }
        }
        else
        {
            form.selectedDest.checked = false;
        }
    }
    
    form.checkAll.checked = false;
    form.selectAllEntriesTop.checked = false;
    form.selectAllEntriesBottom.checked = false;
    
    form.address.value = "";
    form.port.value = "";
    form.pref.value = "";
    
    form.destOp.value = "add";
    form.addBtn.value = "<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.addDest' />";
}

function setAddBtnString()
{
    form = document.forms[0];
    if(form.destOp.value == "update")
    {
        form.addBtn.value = "<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.updateDest' />";
    }
    else
    {
        form.addBtn.value = "<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.addDest' />";
    }
}

function changeStatus(id)
{
    form = document.forms[0];
    form.action = "/changeDestinationStatus.imss?id=" + id;
    form.submit();
}

function saveSettings()
{
    form = document.forms[0];
    
    var target = form.target.value;
    if(target.length == 0 || (checkEmailAddress_Format(target) == false && checkWildcardDomain_Format(target) == false))
    {
        alert("<bean:message bundle='systemResource' key='sys.smtp.delivery.save.invalidTarge' />");
        return;
    }
    
    if(form.deliveryType.value == "0")
    {
        var address = form.mxRecord.value;
        if(address.length == 0 || checkHostNameStr(address) == false)
        {
            form.mxRecord.focus();
            form.mxRecord.select();
            alert("<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.invalidMxRecord' />");
            return;
        }
        
        var port = form.mxPort.value;
        if(port.length == 0 || checkportstr(port) == false)
        {
            form.mxPort.focus();
            form.mxPort.select();
            alert("<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.invalidMxPort' />");
            return;
        }
    }
    
    <c:choose>
      <c:when test="${fromWizard == 'true'}">
        form.action = "/WizardSetting_smtp_saveDelivery.imss?fromWizard=true";
      </c:when>
      <c:otherwise>
        form.action = "/saveSMTPDelivery.imss";
      </c:otherwise>
    </c:choose>
    
    form.submit();
}

function changeDeliveryType()
{
    form = document.forms[0];
    
    if(form.deliveryType.value == "0")
    {
        document.getElementById("mxDetails").style.display="";
        document.getElementById("staticDetails").style.display="none";
    }
    else if(form.deliveryType.value == "1")
    {
        document.getElementById("mxDetails").style.display="none";
        document.getElementById("staticDetails").style.display="";
    }
}
</script>
</head>

<body leftmargin="0" topmargin="0" marginwidth="0" onload="refreshDataButtonStatus(); setAddBtnString(); changeDeliveryType(); checkBError();">
<DIV id="tooltip" style="visibility:hidden;position:absolute;z-index:1000;top:-100"></DIV>
<script language="JavaScript" type="text/javascript">
    Text[0]=["<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.tip.target.title' />","<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.tip.target.desc' />"]
    Text[1]=["<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.tip.pref.title' />","<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.tip.pref.desc' />"]

    Style[0]=["black","","","","",11,"black","white","","","",11,400,,0,"#666666",3,24,0.4,90,,"",,,12,-10]
    Style[1]=["black","","","","",11,"black","white","","","",11,290,,0,"#666666",3,24,0.4,90,,"",,,12,-10]

    var tipId="tooltip"
    var FiltersEnabled = 1 // [for IE5.5+] if your not going to use transitions or filters in any of the tips set this to zero.
    mig_clay()
</script>

<html:form action="/saveSMTPDelivery.imss" onsubmit="lockButtons();">
<table cellspacing=0 cellpadding=0 width=600 border=0>
<tbody>
<tr> 
  <td class="content-title">
    <c:if test="${mode=='add'}">
    <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.head.add" />
    </c:if>
    <c:if test="${mode=='edit'}">
    <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.head.edit" />
    </c:if>
  </td>
  <td valign="bottom"> 
    <div align="right">
    <a href="/help/<bean:message key='locale' />/<bean:message bundle='OnlineHelpResource' key='olh.system.smtp_delivery_detail'/>" target="_blank" />
    <img src="/images/<bean:message key='locale' />/question_cui.gif" width="16" height="16" border="0" />
    </a>
    </div>
  </td>
</tr>
<tr> 
  <td height="10" colspan="2" class="hor-dotted-line">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="1">
  </td>
</tr>
</tbody>
</table>

<table cellSpacing=0 cellPadding=0 width="600" border=0>
<tbody>
<tr> 
  <td height="10">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="10" />
  </td>
</tr>
<tr>
  <td width="600">
    <a href="/initSMTPDelivery.imss"><bean:message bundle="systemResource" key="sys.smtp.tab.domainBasedDelivery" /></a>
    &gt;
    <c:if test="${mode=='add'}">
    <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.add" />
    </c:if>
    <c:if test="${mode=='edit'}">
    <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.edit" />
    </c:if>
  </td>
</tr>
<tr> 
  <td height="15">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="10" />
  </td>
</tr>
</tbody>
</table>

<table class="border" cellSpacing=0 cellPadding=0 width="600" border=0>
<tbody>
<tr>
  <td class="tableheadergrey" colspan="2">
    <bean:message bundle="systemResource" key="sys.smtp.delivery.domain" />
  </td>
</tr>
<tr> 
  <td height="5">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="5" />
  </td>
</tr>
<tr>
  <td class="padding-left-5px" nowrap>
    <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.label.target" />
    <a href="#" onMouseOver="stm(Text[0], Style[0]); return false;" onMouseOut="htm(); return false;"><img src="/images/<bean:message key='locale' />/info_mark_cui.gif" width="14" height="15" border="0" align="absmiddle" /></a>
  </td>
  <td>
    <html:text property="target" styleClass="button" maxlength="256" style="width: 300px;"/>
  </td>
</tr>
<tr> 
  <td height="5">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="5" />
  </td>
</tr>
<tr>
  <td class="tableheadergrey border3" colspan="2">
    <bean:message bundle="systemResource" key="sys.smtp.delivery.title.deliveryMethod" />
  </td>
</tr>
<tr> 
  <td height="5">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="5" />
  </td>
</tr>
<tr>
  <td class="padding-left-5px" width="38%" nowrap>
    <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.label.deliveryMethod" />
  </td>
  <td>
    <html:select property="deliveryType" styleId="deliveryType" styleClass="button" onchange="changeDeliveryType();">
      <html:option value="0"><bean:message bundle="systemResource" key="sys.smtp.delivery.detail.mxDeliveryMethod" /></html:option>
      <html:option value="1"><bean:message bundle="systemResource" key="sys.smtp.delivery.detail.staticDeliveryMethod" /></html:option>
    </html:select>
  </td>
</tr>
<tr> 
  <td height="5">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="5" />
  </td>
</tr>
<tr>
  <td class="tableheadergrey border3" colspan="2">
    <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.title.detailedSettings" />
  </td>
</tr>
<tr>
  <td height="5">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="5" />
  </td>
</tr>
</tbody>
<tbody id="mxDetails">
<tr>
  <td class="padding-left-5px" nowrap>
    <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.label.mxRecord" />
  </td>
  <td>
    <html:text property="mxRecord" styleId="mxRecord" styleClass="button" maxlength="256" style="width: 300px;" />
  </td>
</tr>
<tr>
  <td height="5">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="5" />
  </td>
</tr>
<tr>
  <td class="padding-left-5px">
    <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.label.mxPort" />
  </td>
  <td>
    <html:text property="mxPort" styleId="mxPort" styleClass="button" maxlength="5" style="width: 60px;" />
  </td>
</tr>
<tr>
  <td height="5">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="5" />
  </td>
</tr>
</tbody>
<tbody id="staticDetails">
<tr>
  <td class="padding-left-5px" nowrap>
    <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.label.address" />
  </td>
  <td>
    <html:text property="address" styleId="address" styleClass="button" maxlength="256" style="width: 300px;" />
  </td>
</tr>
<tr>
  <td height="5">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="5" />
  </td>
</tr>
<tr>
  <td class="padding-left-5px">
    <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.label.port" />
  </td>
  <td>
    <html:text property="port" styleId="port" styleClass="button" maxlength="5" style="width: 60px;" />
  </td>
</tr>
<tr>
  <td height="5">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="5" />
  </td>
</tr>
<tr>
  <td class="padding-left-5px">
    <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.label.pref" />
    <a href="#" onMouseOver="stm(Text[1], Style[1]); return false;" onMouseOut="htm(); return false;"><img src="/images/<bean:message key='locale' />/info_mark_cui.gif" width="14" height="15" border="0" align="absmiddle" /></a>
  </td>
  <td>
    <html:text property="pref" styleId="pref" styleClass="button" maxlength="5" style="width: 60px;" />
  </td>
</tr>
<tr> 
  <td height="5">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="5" />
  </td>
</tr>
<tr>
  <td colspan="2" style="padding-left: 3px;">
    <input name="addBtn" id="addBtn" type="button" class="button" onclick="editDestination();" value="<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.addDest' />"></input>
    <input name="resetBtn" id="resetBtn" type="button"  class="button" value="<bean:message bundle='systemResource' key='sys.smtp.delivery.detail.reset' />" onclick="resetDestOp();"></input>
  </td>
</tr>
<tr> 
  <td height="5">
    <img src="/images/<bean:message key='locale' />/1space_cui.gif" width="1" height="5" />
  </td>
</tr>
<tr>
  <td colspan="2" style="padding-bottom: 5px; padding-right: 5px; padding-left: 5px;">
    <table cellspacing=0 cellpadding=0 width="100%" border=0 class="border">
      <tbody>
        <tr>
          <td class="tableheadergrey" colspan="2">
            <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.label.destList" />
          </td>
        </tr>
        <tr>
          <td class="data2">
            <table height="26" border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td nowrap>
                <html:checkbox property="selectAllEntriesTop" onclick="checkSelectAllEntries(this);" />
                <bean:message bundle="systemResource" key="sys.smtp.delivery.allEntries" arg0="${deliveryDestinationTotal}" />
              </td>
              <td width="5">
                &nbsp;
              </td>
              <td nowrap>
                <a id="delBtnTop" href="#" class="databutton" onclick="return deleteDest();">
                <img id="delBtnTopImg" src='/images/<bean:message key="locale" />/icon_delete.gif' border="0" />
                <bean:message key="label.delete" />
                </a> 
              </td>
            </tr>
            </table>
          </td>
          <td class="data2">
            <table height="26" border="0" align="right" cellpadding="0" cellspacing="0">
            <tr>
              <td class="data1">
                <strong><c:out value="${deliveryDestionationIndexFirst}" />-<c:out value="${deliveryDestinationIndexLast}" /></strong>
                <bean:message bundle="systemResource" key="sys.smtp.delivery.of" />
                <c:out value="${deliveryDestinationTotal}" />
              </td>
              <td>&nbsp;<a href="#" onclick="return firstPage();"><img src="/images/<bean:message key='locale' />/pagination-beginning.gif" width="10" height="9" alt="" border="0"></a></td>
              <td>&nbsp;<a href="#" onclick="return prevPage();"><img src="/images/<bean:message key='locale' />/pagination-previous.gif" width="10" height="9" alt="" border="0"></a></td>
              <td nowrap class="data2">
                <bean:message key="display.page" />
                <html:select property="pageNum" styleId="pageNum1" styleClass="button" onchange="return jumpToPage('pageNum1');">
                <c:forEach begin="1" end="${deliveryDestinationTotalpages}" varStatus="current">
                  <html:option value="${current.count}"><c:out value="${current.count}" /></html:option>
                </c:forEach>
                </html:select>
              </td>
              <td>&nbsp;<a href="#" onclick="return nextPage();"><img src="/images/<bean:message key='locale' />/pagination-next.gif" width="10" height="9" alt="" border="0"></a></td>
              <td>&nbsp;<a href="#" onclick="return lastPage();"><img src="/images/<bean:message key='locale' />/pagination-end.gif" width="10" height="9" alt="" border="0"></a>&nbsp;</td>
              <td>&nbsp;</td>
            </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td colspan="2">
            <table width="100%" border="0" cellpadding="0" cellspacing="0">
            <tbody>
            <tr>
              <td class="grey2" width="1%">
                <input name="checkAll" type="checkbox" value="checkbox" onclick="checkDest(this, this, document.forms[0].selectedDest);" />
              </td>
              <td class="grey2" nowrap>
                <a href="#" onclick="sortBy('address')" >
                <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.head.address" />
                </a>
                <c:if test="${mtaDeliveryDetailForm.map.sortBy == 'address'}">
                  <c:choose>
                    <c:when test="${mtaDeliveryDetailForm.map.sortDirection == 1}">
                      <img src="/images/<bean:message key='locale' />/arrow_up.gif" width="9" height="9" />
                    </c:when>
                    <c:otherwise>
                      <img src="/images/<bean:message key='locale' />/arrow_down.gif" width="9" height="9" />
                    </c:otherwise>
                  </c:choose>
                </c:if>
              </td>
              <td class="grey2" width="15%" nowrap>
                <a href="#" onclick="sortBy('port')" >
                <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.head.port" />
                </a>
                <c:if test="${mtaDeliveryDetailForm.map.sortBy == 'port'}">
                  <c:choose>
                    <c:when test="${mtaDeliveryDetailForm.map.sortDirection == 1}">
                      <img src="/images/<bean:message key='locale' />/arrow_up.gif" width="9" height="9" />
                    </c:when>
                    <c:otherwise>
                      <img src="/images/<bean:message key='locale' />/arrow_down.gif" width="9" height="9" />
                    </c:otherwise>
                  </c:choose>
                </c:if>
              </td>
              <td class="grey2" width="15%" nowrap>
                <a href="#" onclick="sortBy('pref')" >
                <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.head.pref" />
                </a>
                <c:if test="${mtaDeliveryDetailForm.map.sortBy == 'pref'}">
                  <c:choose>
                    <c:when test="${mtaDeliveryDetailForm.map.sortDirection == 1}">
                      <img src="/images/<bean:message key='locale' />/arrow_up.gif" width="9" height="9" />
                    </c:when>
                    <c:otherwise>
                      <img src="/images/<bean:message key='locale' />/arrow_down.gif" width="9" height="9" />
                    </c:otherwise>
                  </c:choose>
                </c:if>
              </td>
              <td class="grey2-end" width="15%" align="center" nowrap>
                <a href="#" onclick="sortBy('status')" >
                <bean:message bundle="systemResource" key="sys.smtp.delivery.detail.head.status" />
                </a>
                <c:if test="${mtaDeliveryDetailForm.map.sortBy == 'status'}">
                  <c:choose>
                    <c:when test="${mtaDeliveryDetailForm.map.sortDirection == 1}">
                      <img src="/images/<bean:message key='locale' />/arrow_up.gif" width="9" height="9" />
                    </c:when>
                    <c:otherwise>
                      <img src="/images/<bean:message key='locale' />/arrow_down.gif" width="9" height="9" />
                    </c:otherwise>
                  </c:choose>
                </c:if>
              </td>
            </tr>
            <c:forEach items="${deliveryPolicy.destList.list}" var="choiceItem" varStatus="current">
              <c:if test="${current.count >= deliveryDestionationIndexFirst and current.count <= deliveryDestinationIndexLast}">
                <c:choose>
                  <c:when test="${current.count % 2 == 1}">
                    <c:set var="class1" value="data1b" />
                    <c:set var="class2" value="data1" />
                  </c:when>
                  <c:otherwise>
                    <c:set var="class1" value="data2b" />
                    <c:set var="class2" value="data2" />
                  </c:otherwise>
                </c:choose>
                <tr>
                  <td class="<c:out value='${class1}' />">
                    <html:multibox property="selectedDest" value="${current.index}" onclick="checkDest(this, document.forms[0].checkAll, document.forms[0].selectedDest);" />
                  </td>
                  <td class="<c:out value='${class1}' />">
                    <a href="#" onclick="clickDestination(<c:out value='${current.index}' />, '<c:out value="${choiceItem.address}" />', '<c:out value="${choiceItem.port}" />', '<c:out value="${choiceItem.pref}" />');">
                      <c:out value="${choiceItem.address}" />
                    </a>
                  </td>
                  <td class="<c:out value='${class1}' />">
                    <c:out value="${choiceItem.port}" />
                  </td>
                  <td class="<c:out value='${class1}' />">
                    <c:out value="${choiceItem.pref}" />
                  </td>
                  <td class="<c:out value='${class2}' />" align="center">
                    <a href="#">
                    <c:choose>
                      <c:when test="${choiceItem.status == 0}">
                        <img src="/images/<bean:message key='locale' />/icon_valid_disable_button.gif" onclick="changeStatus(<c:out value='${current.index}' />)" border="0" style="vertical-align:middle" />
                      </c:when>
                      <c:otherwise>
                        <img src="/images/<bean:message key='locale' />/icon_valid_enable_button.gif" onclick="changeStatus(<c:out value='${current.index}' />)" border="0" style="vertical-align:middle" />
                      </c:otherwise>
                    </c:choose>
                    </a>
                  </td>
                </tr>
              </c:if>
            </c:forEach>
            </tbody>
            </table>
          </td>
        </tr>
        <tr>
          <td class="data2 border3">
            <table height="26" border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td nowrap>
                <html:checkbox property="selectAllEntriesBottom" onclick="checkSelectAllEntries(this);" />
                <bean:message bundle="systemResource" key="sys.smtp.delivery.allEntries" arg0="${deliveryDestinationTotal}" />
              </td>
              <td width="5">
                &nbsp;
              </td>
              <td nowrap>
                <a id="delBtnBottom" href="#" class="databutton" onclick="return deleteDest();">
                <img id="delBtnBottomImg" src='/images/<bean:message key="locale" />/icon_delete.gif' border="0" />
                <bean:message key="label.delete" />
                </a> 
              </td>
            </tr>
            </table>
          </td>
          <td class="data2 border3">
            <table height="26" border="0" align="right" cellpadding="0" cellspacing="0">
            <tr>
              <td class="data1">
                <strong><c:out value="${deliveryDestionationIndexFirst}" />-<c:out value="${deliveryDestinationIndexLast}" /></strong>
                <bean:message bundle="systemResource" key="sys.smtp.delivery.of" />
                <c:out value="${deliveryDestinationTotal}" />
              </td>
              <td>&nbsp;<a href="#" onclick="return firstPage();"><img src="/images/<bean:message key='locale' />/pagination-beginning.gif" width="10" height="9" alt="" border="0"></a></td>
              <td>&nbsp;<a href="#" onclick="return prevPage();"><img src="/images/<bean:message key='locale' />/pagination-previous.gif" width="10" height="9" alt="" border="0"></a></td>
              <td nowrap class="data2">
                <bean:message key="display.page" />
                <html:select property="pageNum" styleId="pageNum2" styleClass="button" onchange="return jumpToPage('pageNum2');">
                <c:forEach begin="1" end="${deliveryDestinationTotalpages}" varStatus="current">
                  <html:option value="${current.count}"><c:out value="${current.count}" /></html:option>
                </c:forEach>
                </html:select>
              </td>
              <td>&nbsp;<a href="#" onclick="return nextPage();"><img src="/images/<bean:message key='locale' />/pagination-next.gif" width="10" height="9" alt="" border="0"></a></td>
              <td>&nbsp;<a href="#" onclick="return lastPage();"><img src="/images/<bean:message key='locale' />/pagination-end.gif" width="10" height="9" alt="" border="0"></a>&nbsp;</td>
              <td>&nbsp;</td>
            </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td colspan="2" align="right" class="data2 border3" style="padding-top: 5px">
            <table>
            <tbody>
            <tr>
              <td align="right">
                <bean:message bundle="systemResource" key="sys.smtp.delivery.rowPage" /> 
              </td>
              <td align="right" class="data1" style="padding:3px">
                <html:select property="numPerPage" styleClass="button" onchange="return changePageSize();">
                  <html:option value="10"><bean:message bundle="policy" key="ruleSummary.10PerPage" /></html:option>
                  <html:option value="15"><bean:message bundle="policy" key="ruleSummary.15PerPage" /></html:option>
                  <html:option value="20"><bean:message bundle="policy" key="ruleSummary.20PerPage" /></html:option>
                  <html:option value="30"><bean:message bundle="policy" key="ruleSummary.30PerPage" /></html:option>
                  <html:option value="50"><bean:message bundle="policy" key="ruleSummary.50PerPage" /></html:option>
                  <html:option value="100"><bean:message bundle="policy" key="ruleSummary.100PerPage" /></html:option>
                  <html:option value="200"><bean:message bundle="policy" key="ruleSummary.200PerPage" /></html:option>
                </html:select>
              </td>
            </tr>
            </tbody>
            </table>
          </td>
        </tr>
      </tbody>
    </table>
  </td>
</tr>
</tbody>
</table>

<table cellspacing=0 cellpadding=0 width=600 border=0>
<tbody>
<tr>
  <td height="28" valign="bottom">
    <c:choose>
      <c:when test="${fromWizard == 'true'}">
        <input name="saveBtn" id="saveBtn" type="button" class="button" style="width:50px" onclick="saveSettings();" value="<bean:message key='button.OK' />" />
        <input onclick="lockButtons(); window.close();" name="cancelBtn" id="cancelBtn" type="button" class="button" value="<bean:message key='button.cancel' />" />
      </c:when>
      <c:otherwise>
        <input name="saveBtn" id="saveBtn" type="button" class="button" style="width:50px" onclick="saveSettings();" value="<bean:message key='button.save' />" />
        <input onclick="lockButtons(); self.location.href=('/initSMTPDelivery.imss');" name="cancelBtn" id="cancelBtn" type="button" class="button" value="<bean:message key='button.cancel' />" />
      </c:otherwise>
    </c:choose>    
  </td>
</tr>
</tbody>
</table>
<html:hidden property="destOp" />
<html:hidden property="sortBy" />
<html:hidden property="sortDirection" />
</html:form>
</body>
</html>