<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://www.springframework.org/tags" prefix="spring" %>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<html>
<head>
<title>Quarantines</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<link href="/css/trend-style.css" rel="stylesheet" type="text/css">

<script language="JavaScript" src="/javascripts/validation.jsp"></script>
<script language="javascript">

function stringTrim(strToTrim) {
	return(strToTrim.replace(/^\s+|\s+$/g, ''));
}

function checkallitems()
{
  	if(!checknumber(document.forms[0].expDays))
       	 return false;

      if(document.forms[0].expDays.value<=0 || document.forms[0].expDays.value>60)
      {
          document.forms[0].expDays.select();
          alert('<spring:message code="error.qa.save.invalidDays" />');
          document.forms[0].expDays.focus();
          return false;
      }

   var form = document.forms[0];
   var oSrc = stringTrim(form.areaName.value);
   if (oSrc == null || oSrc.length == 0 || oSrc == " ") {
      	alert("<spring:message code="error.qa.save.nameIsNull" />");
	form.areaName.focus();
      return false;
    }   
    form.areaName.disabled=false; 

    if(checkNameObjNameStartWith(form.areaName.value)){
        alert('<spring:message code="errors.q_area_name.beginwithIMSS"/>');
      form.areaName.focus();
      return false;
    }
    else ;

    return true;
}

function cancelSave()
{
    document.forms[0].action="/cacelSaveArea.imss";
    document.forms[0].submit();
    return true;
}


function checkDelgAdm() 
{
<c:if test="${uiStates.accessQuarantineFrom==1}">
    <c:if test="${adminUser.policyReadOnly}" >
        var form = document.forms[0];      
        for (i=0; i<form.elements.length; i++) {
            form.elements[i].disabled = true;
        }
	form.cancelbtn1.disabled=false;
	form.cancelbtn2.disabled=false;
    </c:if>
</c:if>
<c:if test="${uiStates.accessQuarantineFrom!=1}">
    <c:if test="${adminUser.quarantinesReadOnly}" >
        var form = document.forms[0];      
        for (i=0; i<form.elements.length; i++) {
            form.elements[i].disabled = true;
        }
	form.cancelbtn2.disabled=false;
    </c:if>
</c:if>
} 

function LockButtons()  {
   var form =  document.forms[0];
   form.submitbtn.disabled = true;     
   return true;
}
 
function setFocus() { 
    var form = document.forms[0];
    if (form.submitbtn != null && form.submitbtn.disabled == false) {
        form.submitbtn.focus(); 
    }
}

function checkBError() 
{
      <c:if test="${ !empty saveErr}" var="errmsg" scope="request">
         alert("<c:out value='${saveErr}' escapeXml="false" />");
      </c:if>
}

</script>
</head>

<body bgcolor="#FFFFFF" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onload="checkBError();checkDelgAdm();">

<form:form action="/saveArea.imss" modelAttribute="qtSettingDetailForm" name="qtSettingDetailForm" onsubmit="return LockButtons();" >

<table cellspacing=0 cellpadding=0 width=540 border=0>
  <tbody>
    <tr> 
      <td class="content-title">

      <c:if test="${uiStates.accessQuarantineFrom==2}">
      	<c:if test="${updateForTitle == 'yes'}">
		<spring:message code="qt.setting_detail.edit" /> <c:out value="${areaNameForTitle}" />
	</c:if>
	
	
	<c:if test="${updateForTitle != 'yes'}">
		<c:if test="${isQTForTitle == 'true'}">
			<spring:message code="qt.setting_detail.add_qt" />
		</c:if>
		<c:if test="${isQTForTitle != 'true'}">
			<spring:message code="qt.setting_detail.add_ar" />
		</c:if>
	</c:if>
      </c:if>
      <c:if test="${uiStates.accessQuarantineFrom==1}">
       <c:if test="${qtSettingDetailForm.update=='yes'}">
         <c:out value="${qtSettingDetailForm.areaName}"/>
       </c:if>
       <c:if test="${qtSettingDetailForm.update!='yes'}">
         <spring:message code="ruleDetail.quarantine.new" />
       </c:if>
      </c:if>

      <br></td>
      <td valign="bottom"> <div align="right">	<a href="/help/<spring:message code='locale' />/<spring:message code='olh.quarantines.quarantines_settings_detail'/>" target="_blank"><img src="/images/<spring:message code="locale" />/question_cui.gif" width="16" height="16" border="0"></a></div></td>
    </tr>
    <tr> 
      <td height="10" colspan="2" class="hor-dotted-line"><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="1"></td>
    </tr>    
    <c:if test="${uiStates.accessQuarantineFrom==1}">
    <tr>
      <td height="10" colspan="2" class="data1">
      <c:if test="${uiStates.accessNameObjectFrom==1}">
        <a href="/initRuleActionFrame.imss">
        <c:if test="${uiStates.ruleUIState==1}">
        <spring:message code="addRule.title.newRule" />
        </c:if>
        <c:if test="${uiStates.ruleUIState==2}">
        <c:out value="${tempRule.ruleName}"/>
        </c:if>
        </a> 
      </c:if>
      <c:if test="${uiStates.accessNameObjectFrom==2}">
	   <c:if test="${scanExcpObj.type == 0}">
            <a href="/initSEpasswordAction.imss?type=0">
	      <spring:message code="sys.scanExcp.title.violation" />
            </a>
          </c:if>
          <c:if test="${scanExcpObj.type == 1}">
            <a href="/initSEpasswordAction.imss?type=1">
	      <spring:message code="sys.scanExcp.title.encryptMsg" />
            </a>
          </c:if>
          <c:if test="${scanExcpObj.type == 2}">
            <a href="/initSEpasswordAction.imss?type=2">
	      <spring:message code="sys.scnaExcp.title.msgPasswordZip" />
            </a>
          </c:if>
          <c:if test="${scanExcpObj.type == 3}">
            <a href="/initSEpasswordAction.imss?type=3">
	      <spring:message code="sys.scanExcp.title.otherScanning" />
            </a>
          </c:if>
          <c:if test="${scanExcpObj.type == 5}">
            <a href="/initSEpasswordAction.imss?type=5">
	      <spring:message code="sys.scanExcp.title.notscannedByIBEEncrptRule" />
            </a>
          </c:if>
          <c:if test="${scanExcpObj.type == 6}">
            <a href="/initSEpasswordAction.imss?type=6">
	      <spring:message code="sys.scanExcp.title.dda" />
            </a>
          </c:if>
      </c:if>
        &gt; <a href="/initRuleActionNamedObj.imss?type=quarantine"><spring:message code="ruleDetail.quarantine.head" /></a>
        &gt; 
       <c:if test="${qtSettingDetailForm.update=='yes'}">
         <c:out value="${qtSettingDetailForm.areaName}"/>
       </c:if>
       <c:if test="${qtSettingDetailForm.update!='yes'}">
         <spring:message code="ruleDetail.quarantine.new" />
       </c:if>
      </td>
    </tr>
    </c:if>    
    <tr> 
      <td height="10" colspan="2"><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10"> 
      </td>
    </tr>
  </tbody>
</table>
<c:if test="${uiStates.accessQuarantineFrom==1}">
<table width="540" border="0" cellspacing="0" cellpadding="0">
  <tr> 
    <td height="28" valign="top">
	<input type="submit" name="submitbtn" class="button" onclick="return checkallitems();" style="width:50px" value="<spring:message code="button.save" />" >
       <input name="cancelbtn1" type="button" class="button" onClick="return cancelSave();" value="<spring:message code="button.cancel" />">
    </td>
  </tr>
</table>
</c:if>
<table width="540" border="0" cellpadding="0" cellspacing="0" class="border">
  <tr>
    <td style="padding-top:3px"><table width="538" border="0" cellpadding="0" cellspacing="0">
      <tr>
        <td width="44"  class="data1" style="padding-top:3px"><spring:message code="qt.setting.sdetail.name" />:</td>
        <td width="494" class="data1" style="padding-top:3px; padding-left:7px">
          <c:if test="${qtSettingDetailForm.preFilterFlag==1 || qtSettingDetailForm.areaID==100000}">
            <form:input path="areaName" cssClass="button"  size="93" maxlength="256" disabled="true" />
          </c:if>
          <c:if test="${qtSettingDetailForm.preFilterFlag!=1 && qtSettingDetailForm.areaID!=100000}">
            <form:input path="areaName" cssClass="button"  size="93" maxlength="256" />
          </c:if>
        </td>
      </tr>
      <tr>
        <td  class="data1">&nbsp;</td>
        <td  class="data1">
      <spring:message code="qt.setting.sdetail.maxage" />:
      <form:input path="expDays" cssClass="button"  size="5" maxlength="5" /> 
      <spring:message code="qt.setting.sdetail.days" /></td>
      </tr>
      <tr>
        <td  class="data1">&nbsp;</td>
        <td  class="data1">
          <table>
            <tr>
              <td class="data1" style="vertical-align:top">
                  <form:checkbox path="sync" value="1" />
              </td>
              <td class="data1">
                  <c:if test="${qtSettingDetailForm.preFilterFlag==1}">
                    <spring:message code="qt.setting.sdetail.sync.prefilter" />
                  </c:if>
                 <c:if test="${qtSettingDetailForm.preFilterFlag!=1}">
                    <spring:message code="qt.setting.sdetail.sync" />
                 </c:if>
              </td>
            </tr>
          </table>
        </td>
      </tr>
       <tr>
        <td  class="data1">&nbsp;</td>
        <td  class="data1">
          <table>
            <tr>
              <td class="data1" style="vertical-align:top" nowrap>
                  <b><spring:message code="qt.settings.label.note" /></b>
              </td>
              <td class="data1">
                  <c:if test="${qtSettingDetailForm.preFilterFlag==1}">
                    <spring:message code="qt.setting.sdetail.sync.prefilter.note" /><spring:message code="qt.setting.sdetail.manage_from_EUQ_Web" />
                  </c:if>
                 <c:if test="${qtSettingDetailForm.preFilterFlag!=1}">
                    <spring:message code="qt.setting.sdetail.sync.note" /><spring:message code="qt.setting.sdetail.manage_from_EUQ_Web" />
                 </c:if>
              </td>
            </tr>
          </table>
        </td>
      </tr>         
    </table></td>
  </tr>
</table>
<table width="540" border="0" cellspacing="0" cellpadding="0">
  <tr> 
    <td height="28" valign="bottom">
	<input type="submit" name="submitbtn" class="button" onclick="return checkallitems();" style="width:50px" value="<spring:message code="button.save" />" >
       <input name="cancelbtn2" type="button" class="button" onClick="return cancelSave();" value="<spring:message code="button.cancel" />" >
    </td>
  </tr>
</table>
<br>
<form:hidden path="update" />
<form:hidden path="areaID" />
<form:hidden path="isQT" />
<form:hidden path="preFilterFlag" />
</form:form>
</body>
</html>
