﻿<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://www.springframework.org/tags" prefix="spring" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib prefix="html" uri="http://www.springframework.org/tags/form" %>
<html>
<head>
<base target="_self">
<title><spring:message code="adminEuq.title" /></title>
<link href="/css/trend-style.css" rel="stylesheet" type="text/css">
<script language="JavaScript" src="/javascripts/tooltip.js" type="text/javascript"></script>
<script language="JavaScript" src="/javascripts/validation.jsp" type="text/javascript"></script>
<script LANGUAGE="JavaScript">
var BEerror = null;
var originAuthType = "ldap";
<c:if test="${not empty euq_error}">
     BEerror = '<c:out value="${euq_error}" />'; 
</c:if>
function checkError() {
   if (BEerror) {
      alert(BEerror);
      self.location.href=('/initEuqMgr.imss');
   }
}
function save()
{
  var check_status = document.forms[0].enableEuq.checked;
  
  var authTypes = document.forms[0].euqAuthType;

  var euqAuthType = "";
  
  for(var i=0; i < authTypes.length; i++)
  {
	  if (authTypes[i].checked)
	  {
		  euqAuthType = authTypes[i].value;
	  }
  }
  
  if (check_status == false)
  {

	<c:if test="${isEuqEnable}">
	
	    if (!confirm("<spring:message code="adminEuq.confirmDisableEuq" />"))
	
	    	return false;
    
	</c:if>
  }
  else {

      if(euqAuthType == "")
      {
          alert("<spring:message code="adminEuq.noAuthTypeSelected" />");
          return false;
      }
  
      // check if LDAP enable
	  if (euqAuthType == "ldap")
	  {
		  <c:if test="${ldapDisabled}">

		    alert("<spring:message code="adminEuq.ldapDisabled" />");

		    return false;

		  </c:if>		  
	  }
	  else
	  {
		    <c:if test="${totalSmtpAuth == 0}">   
		        <c:choose>
		            <c:when test="${isEuqEnable}">
                        if(originAuthType == "ldap")
                        {
                            alert("<spring:message code="adminEuq.smtpAuthNoConfigForChange" />");
                            return false;
                        }
                        else
                        {
                            alert("<spring:message code="adminEuq.smtpAuthNoConfig" />");
                            return false;
                        }
		            </c:when>
		            <c:otherwise>
		                alert("<spring:message code="adminEuq.smtpAuthNoConfig" />");
		                return false;
		            </c:otherwise>
		        </c:choose>
		    </c:if>
		  
	  }
    }

    document.forms[0].action="/processEnableEuq.imss";
    return true;    
}

function transfer()
{
  if (!confirm("<spring:message code="adminEuq.confirmTransfer" />"))
    return false;
  document.forms[0].action="/processTransferEuq.imss";
  return true;
}

function removeEuqData()
{
  if (!confirm("<spring:message code="adminEuq.confirmRemove" />"))
    return false;
  document.forms[0].action="/processRemoveEuq.imss";
  return true;
}

function updateUIStatus()
{
  var authTypes = document.forms[0].euqAuthType;

  for(var i=0; i < authTypes.length; i++)
  {
          if (authTypes[i].checked)
          {
              originAuthType = authTypes[i].value;
          }
  }
  
  <c:if test="${ldapDisabled}">
      document.forms[0].euqAuthType[0].checked = false;
  </c:if>
  
  <c:if test="${!isEuqEnable}">
      document.forms[0].btnTransfer.disabled=true;
      document.forms[0].btnRemove.disabled=true;
  </c:if>
  
  <c:choose>
	  <c:when test="${isEuqCheck}">
	      document.forms[0].enableEuq.checked = true;
	  </c:when>
	  <c:otherwise>
	      document.forms[0].enableEuq.checked = false;
	  </c:otherwise>
  </c:choose>
  
  <c:if test="${euqAuthType=='ldap'}">
      document.getElementById("smtpAuthArea").style.display='none';
      document.getElementById("smtpAuthSpace").style.display='none';
      document.getElementById("smtpAuthDesc").style.display='none';
  </c:if>  
}

function addSubmit()
{
    document.forms[0].action="/saveAddSmtpAuth.imss";
    document.forms[0].submit();
    return true;
}

function editSubmit(id)
{
    document.forms[0].action="/saveEditSmtpAuth.imss?id="+id;
    document.forms[0].submit();
    return true;
}

function NewWindow(mypage, myname, w, h, scroll) {
	var winl = (screen.width - w) / 2;
	var wint = (screen.height - h) / 2;
	winprops = 'height='+h+',width='+w+',top='+wint+',left='+winl+',scrollbars='+scroll+',resizable'
	win = window.open(mypage, myname, winprops)
	if (parseInt(navigator.appVersion) >= 4) { win.window.focus(); }
}

function AddSmtpAuth()
{
    NewWindow('/addSmtpAuth.imss','Add','550','250','auto');
    return false;
}

function DeleteSmtpAuth()
{
    var count = 0;
    var ids = document.getElementsByName("selectedSmtpAuth");
    for (var i = 0; i < ids.length; i++)
    {
        if(ids[i].checked)
        {
            count = count + 1;
        }
    }

    if(count == 0) return false;
    if(count == <c:out value="${totalSmtpAuth}" />)
    {
        if (!confirm("<spring:message code="adminEuq.confirmDeleteAll" />"))
        return false;
    }

    document.forms[0].action="/deleteSmtpAuth.imss";
    document.forms[0].submit();
    return false;
}

function EditSmtpAuth(id)
{
    var url="/editSmtpAuth.imss?id="+id;
    NewWindow(url,'Edit','550','250','auto');
    return false;
}

function FirstPage()
{
    document.forms[0].action="/firstSmtpAuthPage.imss";
    document.forms[0].submit();
    return false;
}

function PrevPage()
{
    document.forms[0].action="/previousSmtpAuthPage.imss";
    document.forms[0].submit();
    return false;
}

function jumpToPage()
{
    document.forms[0].action="/jumpSmtpAuthPage.imss";
    document.forms[0].submit();
    return false;
}

function NextPage()
{
    document.forms[0].action="/nextSmtpAuthPage.imss";
    document.forms[0].submit();
    return false;
}

function LastPage()
{
    document.forms[0].action="/lastSmtpAuthPage.imss";
    document.forms[0].submit();
    return false;
}

function changePageSize()
{
    document.forms[0].action="/changeSmtpAuthPageSize.imss";
    document.forms[0].submit();
    return false;
}

function selectAuthType(authType)
{
    if(authType=='ldap')
    {
        document.getElementById("smtpAuthArea").style.display='none';
        document.getElementById("smtpAuthSpace").style.display='none';
        document.getElementById("smtpAuthDesc").style.display='none';
    }
    else
    {
        document.getElementById("smtpAuthArea").style.display='';
        document.getElementById("smtpAuthSpace").style.display='';
        document.getElementById("smtpAuthDesc").style.display='';

    }
}

</script>
</head>

<BODY leftmargin="0" topmargin="0" marginwidth="0" onLoad="updateUIStatus();checkError();">
<DIV id="tooltip" style="visibility:hidden;position:absolute;z-index:1000;top:-100"></DIV>
<script language="JavaScript" type="text/javascript">
Text[0]=["<spring:message code="adminEuq.euqLdapHelpTitle" />","<spring:message code="adminEuq.euqLdapHelpContent" />"]

Style[0]=["black","","","","",11,"black","white","","","",11,290,,0,"#666666",3,24,0.4,90,,"",,,12,-10]
var tipId="tooltip"
var FiltersEnabled = 1 // [for IE5.5+] if your not going to use transitions or filters in any of the tips set this to zero.
mig_clay()
</script>
<form:form modelAttribute="euqMgrForm" name="euqMgrForm" action="/initEuqMgr.imss" onsubmit="LockFormButton(this);">
<table cellspacing=0 cellpadding=0 width=540 border=0>
  <tbody>
    <tr> 
      <td class="content-title"><spring:message code="adminEuq.title" /><br> </td>
      <td valign="bottom"> <div align="right"><a href="/help/<spring:message code="locale" />/<spring:message code='olh.admin.euq_using_euq'/>" target="_blank"><img src="/images/<spring:message code="locale" />/question_cui.gif" border="0"></a></div></td>
    </tr>
    <tr> 
      <td height="10" colspan="2" class="hor-dotted-line"><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10"></td>
    </tr>
    <tr> 
      <td height="10" colspan="2"><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10"> <table cellpadding="0" cellspacing="0" border="0" width="100%">
        <tr>
          <!-- TABS -->
          <td background="/images/<spring:message code="locale" />/tab_background_cui.gif">
            <table cellpadding="0" cellspacing="0" border="0">
              <tr>
                <td><img src="/images/<spring:message code="locale" />/tab_active1_left_cui.gif" width="11" height="23" alt="" border="0"></td>
                <td background="/images/<spring:message code="locale" />/tab_active_background_cui.gif" class="tabactive" style="vertical-align:top" nowrap><spring:message code="adminEuq.MgrTitle" /></td>
                <td><img src="/images/<spring:message code="locale" />/tab_active_right_cui.gif" width="23" height="23" alt="" border="0"></td>
                <c:if test="${isEuqEnable}">
                <td><img src="/images/<spring:message code="locale" />/tab_inactive2_left_cui.gif" width="11" height="23" alt="" border="0"></td>
                <td style="vertical-align:top" background="/images/<spring:message code="locale" />/tab_inactive_background_cui.gif" class="tabinactive" nowrap> <A onmouseover="this.style.color='#FF0000';"
            style="COLOR: #000000; text-decoration:none" 
            onmouseout="this.style.color='#000000';" 
            href="/initEndUserAccess.imss" > <spring:message code="adminEuq.AccessTitle" /></a></td>
                <td><img src="/images/<spring:message code="locale" />/tab_inactive_right_cui.gif" width="23" height="23" alt="" border="0"></td>
                </c:if>
              </tr>
            </table>
          </td>
          <td background="/images/<spring:message code="locale" />/tab_background_cui.gif" align="right"><img src="/images/<spring:message code="locale" />/tab_right_corner_cui.gif" width="6" height="23" alt="" border="0"></td>
          <!-- /TABS -->
        </tr>
      </table>
    </tr>
  </tbody>
</table>
<table cellpadding="0" cellspacing="0" border="0" width="540">
  <tr>
    <td colspan="2" class="border"><table width="538" border="0" cellpadding="0" cellspacing="0" >
      <tr>
        <td width="1614" colspan="2" >
          <table width="100%" border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td class="tableheadergrey"><spring:message code="adminEuq.EnableEuqTitle" /></td>
            </tr>
          </table>
        </td>
      </tr>
      <tr>
        <td  class="data1">
          <form:checkbox path="enableEuq" id="enableEuq"/>
          <spring:message code="adminEuq.cbEnableEuq" />
        </td>
        <td align="right" class="data1">
            <input type="submit" class="button" style="width:60px" onclick="return save();" value="<spring:message code="button.save" />">

        </td>
      </tr>
      <tr>
        <td colspan="2" class="data1" style="padding:0px 10px 0px 21px;">
                 <c:choose>
                 <c:when test="${ldapDisabled}">
                     <form:radiobutton path="euqAuthType" disabled="true" value="ldap" onclick="selectAuthType('ldap')"/>
                     <spring:message code="adminEuq.euqLdapType" />
                 </c:when>
                 <c:otherwise>
                     <form:radiobutton path="euqAuthType" value="ldap" onclick="selectAuthType('ldap')"/>
                     <spring:message code="adminEuq.euqLdapType" />
                 </c:otherwise>
                 </c:choose>
                 <a href="#" onclick="return false" 
                   onMouseOver="stm(Text[0],Style[0]);return false;" 
                   onMouseOut="htm();return false;">
                   <img src="/images/<spring:message code="locale" />/info_mark_cui.gif" width="15" height="15"border="0" align="absmiddle">
                 </a>
        </td>
      </tr>
      
      <tr>
        <td colspan="2" class="data1" style="padding:0px 10px 0px 21px;">
            <form:radiobutton path="euqAuthType" value="smtp" onclick="selectAuthType('smtp')"/>
                <spring:message code="adminEuq.euqSmtpAuthType" />
        </td>
      </tr>
      
      <tr id="smtpAuthSpace">
        <td colspan="2" ><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10"></td>
      </tr>
      
	  <tr id="smtpAuthDesc">
	    <td width="538" colspan="2" style="padding:0px 10px 0px 40px;"><spring:message code="adminEuq.smtpAuthListDesc" /></td>
	  </tr>

      <tr id="smtpAuthArea">
        <td width="538" colspan="2" style="padding:0px 10px 0px 40px;"><table width="488" cellspacing="0" cellpadding="0" border="0" class="border">
            <tbody><tr>
                <tr>
                    <td width="488" colspan="2"><table width="488" cellspacing="0" cellpadding="0" border="0">
	                    <tbody><tr>
	                      <td class="data2">
	                          <table width="125" height="26" cellspacing="0" cellpadding="0" border="0">
	                           <tbody><tr>
	                             <td nowrap><a onclick="return AddSmtpAuth();" class="databutton" href="#"><img border="0" src="/images/<spring:message code="locale" />/icon_add.gif"><spring:message code="label.add" /></a> </td>
	                             <td class="text"><img width="2" height="1" src="/images/<spring:message code="locale" />/1space_cui.gif"></td>
	                             <td nowrap><a onclick="return DeleteSmtpAuth();" class="databutton" href="#"><img border="0" src="/images/<spring:message code="locale" />/icon_delete.gif"><spring:message code="label.delete" /></a> </td>
	                           </tr></tbody>
	                          </table></td>
	                      <td class="data2">
	                        <table height="26" cellspacing="0" cellpadding="0" border="0" align="right">
	                          <tbody><tr>
	                            <td class="data1">
	                              <strong><c:out value="${firstSmtpAuth}" />-<c:out value="${lastSmtpAuth}" /></strong> 
	                              <spring:message code="adminEuq.smtpAuthOfStr" />
	                              <c:out value="${totalSmtpAuth}" />
	                            </td>
	                            <td>&nbsp;<a onclick="return FirstPage();" href="#"><img width="10" height="9" border="0" alt="" src="/images/<spring:message code="locale" />/pagination-beginning.gif"></a></td>
	                            <td>&nbsp;<a onclick="return PrevPage();" href="#"><img width="10" height="9" border="0" alt="" src="/images/<spring:message code="locale" />/pagination-previous.gif"></a></td>
	                            <td nowrap class="data2"><spring:message code="display.page" />
	                              <form:select path="pageNum" cssClass="button" onchange="return jumpToPage();">
	                                <c:forEach begin="1" end="${totalSmtpAuthPage}" varStatus="current">
	                                  <form:option value="${current.index}"><c:out value="${current.index}" /></form:option>
	                                </c:forEach>
	                              </form:select>
	                            </td>
	                            <td>&nbsp;<a onclick="return NextPage();" href="#"><img width="10" height="9" border="0" alt="" src="/images/<spring:message code="locale" />/pagination-next.gif"></a></td>
	                            <td>&nbsp;<a onclick="return LastPage();" href="#"><img width="10" height="9" border="0" alt="" src="/images/<spring:message code="locale" />/pagination-end.gif"></a>&nbsp;</td>
	                            <td>&nbsp;</td>
	                          </tr>
	                        </tbody></table>
	                      </td>
	                    </tr></tbody></table>
                    </td>
                </tr>
                <tr>
                  <td colspan="3">
                  <table class="border2" cellspacing="0" cellpadding="0" border="0">
                      <tbody>
                        <tr>
	                        <td width="21" class="grey2"><input name="checkAll" type="checkbox" value="checkbox" onClick="updateCheckboxGroup(this, this, document.forms[0].selectedSmtpAuth);"></td>
	                        <td width="241" class="grey2"><spring:message code="adminEuq.domainColName" /></td>
	                        <td width="200" class="grey2"><spring:message code="adminEuq.serverColName" /></td>
                                <td width="200" class="grey2"><spring:message code="adminEuq.smtpSupportTLS" /></td>
                        </tr>
                        
                        <c:forEach items="${smtpAuthList}" var="choiceItem" varStatus="current">
	                        <c:choose>
	                          <c:when test="${current.index % 2 == 0}">
	                            <c:set var="class1" value="data1b" />
	                          </c:when>
	                          <c:otherwise>
	                            <c:set var="class1" value="data2b" />
	                          </c:otherwise>
	                        </c:choose>
                                    
                            <c:if test="${current.index + 1 >= firstSmtpAuth && current.index + 1 <= lastSmtpAuth}">
                                <TR>
                                  <TD class="<c:out value='${class1}' />">
                                    <form:checkbox path="selectedSmtpAuth" value="${current.index}" onclick="updateCheckboxGroup(this, document.forms[0].checkAll, document.forms[0].selectedSmtpAuth);"/>
                                  </TD>
                                  <TD class="<c:out value='${class1}' />">
                                    <a href="#" onclick="return EditSmtpAuth(<c:out value="${current.index}" />);">
                                        <c:out value='${choiceItem.domain}' />
                                    </a>
                                  </TD>
                                   <TD class="<c:out value='${class1}' />">                                    
                                        <c:out value='${choiceItem.server}' />:<c:out value='${choiceItem.port}' />
                                  </TD> 
                                   <TD class="<c:out value='${class1}' />">                                    
                                        <c:out value='${choiceItem.enableSTARTTLSString}' />
                                  </TD> 
                            </c:if>
                         </c:forEach>                       
                        </tbody>
                    </table>
                    </td>
                </tr>
                <tr>
	                <td class="data2" align="right" colspan="2" style="padding:3px">
		                <form:select path="numPerPage" cssClass="button" onchange="return changePageSize();">
		                  <form:option value="10"><spring:message code="ruleSummary.10PerPage" /></form:option>
		                  <form:option value="15"><spring:message code="ruleSummary.15PerPage" /></form:option>
		                  <form:option value="20"><spring:message code="ruleSummary.20PerPage" /></form:option>
		                  <form:option value="30"><spring:message code="ruleSummary.30PerPage" /></form:option>
		                  <form:option value="50"><spring:message code="ruleSummary.50PerPage" /></form:option>
		                  <form:option value="100"><spring:message code="ruleSummary.100PerPage" /></form:option>
		                  <form:option value="200"><spring:message code="ruleSummary.200PerPage" /></form:option>
		                </form:select>
	                 </td>
                 </tr>
                 </tbody></table></td>
      </tr>
      
      <tr class="border">
        <td colspan="2"><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10"> </td>
      </tr>
      <tr>
        <td colspan="2" ><table width="100%" border="0" cellpadding="0" cellspacing="0" class="border3">
          <tr>
            <td class="tableheadergrey"><spring:message code="adminEuq.remove.title" /></td>
          </tr>
        </table></td>
      </tr>
      <tr>
        <td class="data1"><spring:message code="adminEuq.remove.suggestion" />
        </td>
        <td align="right" class="data1">
         <input name="btnRemove" type="submit"  class="button" value="<spring:message code="adminEuq.btnRemove" />" style="width:60px" onclick="return removeEuqData();">
        </td>
      </tr> 
 
      <tr>
        <td colspan="2" ><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10"></td>
      </tr>
      
      <tr>
        <td colspan="2" ><table width="100%" border="0" cellpadding="0" cellspacing="0" class="border3">
          <tr>
            <td class="tableheadergrey"><spring:message code="adminEuq.TransferEuqTitle" /></td>
          </tr>
        </table></td>
      </tr>
      <tr class="border">
        <td class="data1"><spring:message code="adminEuq.TransferEuq" /></td>
        <td align="right" class="data1">
        </td>
      </tr>
      <tr class="border">
        <td>
          <input type="radio" name="transferType" value="0" /><spring:message code="adminEuq.TransferEuqWhiteList" /><BR>
          <input type="radio" name="transferType" value="1" checked /><spring:message code="adminEuq.TransferEuqAll" /><BR><BR>
        </td>
        <td align="right" class="data1">
          <input type="submit" name="btnTransfer" id="btnTransfer" class="button" style="width:85px" onclick="return transfer();" value="<spring:message code="adminEuq.btnTransfer" />" />
        </td>
      </tr>
      <tr class="border">
        <td colspan="2" class="data1"><spring:message code="adminEuq.TransferEuqWarning" />
        <br>
        <br>
        <spring:message code="adminEuq.TransferEuqNote" />
        </td>
      </tr>
      <tr class="border">
        <td colspan="2"><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10"> </td>
      </tr>
<!--      
      <tr>
        <td colspan="2">
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="border3">
            <tr>
              <td class="tableheadergrey"><spring:message code="adminEuq.RemoveEuqTitle" /></td>
            </tr>
          </table>
        </td>
      </tr>
      <tr>
        <td class="data1" style="padding-bottom:3px"><spring:message code="adminEuq.RemoveEuq" /></td>
        <td align="right" class="data1" style="padding-bottom:3px">
          <input type="submit" name="btnRemove" id="btnRemove" class="button" style="width:60px" onclick="return remove();" value="<spring:message code="adminEuq.btnRemove" />" />
          
        </td>
      </tr>
-->      
    </table>
    </td>
  </tr>
</table>
<br>
<form:hidden path="domainName" />
<form:hidden path="server" />
<form:hidden path="port" />
<form:hidden path="enableSTARTTLS" />
</form:form>
</BODY>
</html>
