<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://www.springframework.org/tags" prefix="spring" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<script language="JavaScript" src="/javascripts/validation.jsp" type="text/javascript"></script>
<script language="JavaScript" type="text/JavaScript">
     function checkBError()
    {
      <c:if test="${ !empty errorMsg}" var="errmsg" scope="request">
         alert("<c:out value='${errorMsg}' />");
         document.forms[0].certName.focus();
      </c:if>
    }
    function checkReadOnly()
    {
        <c:if test="${adminUser.systemReadOnly}" >
            var form = document.forms[0];
            for (var i=0; i<form.elements.length; i++) 
            {
                form.elements[i].disabled = true;
            }
            form.cancel.disabled=false;
        </c:if>
    }

    function checkType()
    {
        var form = document.forms[0];
        if (form.certType.value==1)
        {
            document.getElementById("vd").style.visibility = "visible";
            form.validDays.style.visibility = "visible";
        }
        else
        {
            document.getElementById("vd").style.visibility = "hidden";
            form.validDays.style.visibility = "hidden";
        }
        return false;
    }

    function checkValid()
    {
        var form = document.forms[0];
        var cert_name = form.certName.value;
        var cert_type = form.certType.value;
        var key_length = form.keyLength.value;
        var country_code = form.countryCode.value;
        var sta = form.state.value;
        var lo = form.locality.value;
        var organization = form.org.value;
        var org_unit = form.orgUnit.value;
        var common_name = form.commonName.value;
        var email = form.emailAddress.value;
        var valid_days = form.validDays.value;
        if (cert_name=="")
        {
            alert("<spring:message code="errors.sys.tls.cert.add.empty.name" />");
            form.certName.focus();
            return false;
        }
        else if (!checkASCII_Format(cert_name)|| checkIfContainInvalidChar_Shell(cert_name))
        {
            alert("<spring:message code="errors.sys.tls.cert.add.wrongAscii.name" />");
            form.certName.focus();
            return false;
        }
        else if (cert_name.length >128)
        {
            alert("<spring:message code="errors.sys.tls.cert.add.largeAscii.128.name" />");
            form.certName.focus();
            return false;
        }
        if (cert_type=="")
        {
            alert("<spring:message code="errors.sys.tls.cert.add.emptyType" />");
            form.certType.focus();
            return false;
        }
        if (key_length=="")
        {
            alert("<spring:message code="errors.sys.tls.cert.add.emptyLength" />");
            form.keyLength.focus();
            return false;
        }
        if (country_code=="")
        {
            alert("<spring:message code="errors.sys.tls.cert.add.emptyCountry" />");
            form.countryCode.focus();
            return false;
        }
        if (sta=="")
        {
            alert("<spring:message code="errors.sys.tls.cert.add.empty.state" />");
            form.state.focus();
            return false;
        }
        else if (!checkASCII_Format(sta)|| checkIfContainInvalidChar_Shell(sta))
        {
            alert("<spring:message code="errors.sys.tls.cert.add.wrongAscii.state" />");
            form.state.focus();
            return false;
        }
        else if (sta.length >128)
        {
            alert("<spring:message code="errors.sys.tls.cert.add.largeAscii.128.state" />");
            form.state.focus();
            return false;
        }
        if (lo=="")
        {
            alert("<spring:message code="errors.sys.tls.cert.add.empty.locality" />");
            form.locality.focus();
            return false;
        }
        else if (!checkASCII_Format(lo)||checkIfContainInvalidChar_Shell(lo))
        {
            alert("<spring:message code="errors.sys.tls.cert.add.wrongAscii.locality" />");
            form.locality.focus();
            return false;
        }
        else if (lo.length >128)
        {
            alert("<spring:message code="errors.sys.tls.cert.add.largeAscii.128.locality" />");
            form.locality.focus();
            return false;
        }
        if (organization=="")
        {
            alert("<spring:message code="errors.sys.tls.cert.add.empty.organization" />");
            form.org.focus();
            return false;
        }
        else if (!checkASCII_Format(organization)||checkIfContainInvalidChar_Shell(organization))
        {
            alert("<spring:message code="errors.sys.tls.cert.add.wrongAscii.organization" />");
            form.org.focus();
            return false;
        }
        else if (organization.length >64)
        {
            alert("<spring:message code="errors.sys.tls.cert.add.largeAscii.64.organization" />");
            form.org.focus();
            return false;
        }
        if (org_unit=="")
        {
            alert("<spring:message code="errors.sys.tls.cert.add.empty.organization.unit" />");
            form.orgUnit.focus();
            return false;
        }
        else if (!checkASCII_Format(org_unit)||checkIfContainInvalidChar_Shell(org_unit))
        {
            alert("<spring:message code="errors.sys.tls.cert.add.wrongAscii.organization.unit" />");
            form.orgUnit.focus();
            return false;
        }
        else if (org_unit.length >64)
        {
            alert("<spring:message code="errors.sys.tls.cert.add.largeAscii.64.organization.unit" />");
            form.orgUnit.focus();
            return false;
        }
        if (common_name=="")
        {
            alert("<spring:message code="errors.sys.tls.cert.add.empty.common.name" />");
            form.commonName.focus();
            return false;
        }
        else if (!checkASCII_Format(common_name)||checkIfContainInvalidChar_Shell(common_name))
        {
            alert("<spring:message code="errors.sys.tls.cert.add.wrongAscii.common.name" />");
            form.commonName.focus();
            return false;
        }
        else if (common_name.length >64)
        {
            alert("<spring:message code="errors.sys.tls.cert.add.largeAscii.64.common.name" />");
            form.commonName.focus();
            return false;
        }
        if (!checkEmailAddress_Format(email))
        {
            alert("<spring:message code="errors.sys.tls.cert.add.wrongEmail" />");
            form.emailAddress.focus();
            return false;
        }
        else if (email.length >64)
        {
            alert("<spring:message code="errors.sys.tls.cert.add.wrongEmail.all" />");
            form.emailAddress.focus();
            return false;
        }
        else
        {
            var ehead = email.substring(0, email.indexOf('@'));
            var etail = email.substring(email.indexOf('@')+1);
            if (ehead.length >59)
            {
                alert("<spring:message code="errors.sys.tls.cert.add.wrongEmail.head" />");
                form.emailAddress.focus();
                return false;
            }
            if (etail.length >63)
            {
                alert("<spring:message code="errors.sys.tls.cert.add.wrongEmail.tail" />");
                form.emailAddress.focus();
                return false;
            }
        }
        if (cert_type==1 && valid_days=="")
        {
            alert("<spring:message code="errors.sys.tls.cert.add.wrongDigit" />");
            form.validDays.focus();
            return false;
        }
        else if (cert_type==1 && !checkInteger_Format(valid_days))
        {
            alert("<spring:message code="errors.sys.tls.cert.add.wrongDigit" />");
            form.validDays.focus();
            return false;
        }
        else if (cert_type==1 && valid_days<=0)
        {
            alert("<spring:message code="errors.sys.tls.cert.add.negetiveDigit" />");
            form.validDays.focus();
            return false;
        }
        else if (cert_type==1 && valid_days>7300)
        {
            alert("<spring:message code="errors.sys.tls.cert.add.largeDigit.80y" />");
            form.validDays.focus();
            return false;
        }
        return true;
    }

</script>
<html>
<head>
<title><spring:message code="smtp.tls.cert.add.title"/></title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<link href="/css/top.css" rel="stylesheet" type="text/css">
</head>
<body bgcolor="#FFFFFF" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onload="checkBError();checkReadOnly();checkType()">
<table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr>
    <td bgcolor="#FF0000" class="popup-title">
      <spring:message code="smtp.tls.cert.add.title"/>
    </td>
  </tr>
</table>
<form:form modelAttribute="tlsForm" name="tlsForm" action="/saveCert.imss?mode=0">
<table width="95%" border="0" align="center" cellpadding="0" cellspacing="0">
  <tr>
    <td width="550" style="padding-top:3px"><table width="100%" border="0" cellpadding="0" cellspacing="0">
      <tr>
        <td width="100"  class="data1">
        </td>
        <td width="115"  class="data1">
          <spring:message code="smtp.tls.cert.add.name"/><font color=red>*</font>
        </td>
        <td width="100"  class="data1">
          <form:input path="certName" cssClass="button" style="width: 200px"/>
        </td>
        <td width="200"  class="data1">
        </td>
      </tr>
      <tr>
        <td width="100"  class="data1">
        </td>
        <td width="115"  class="data1">
          <spring:message code="smtp.tls.cert.add.type"/><font color=red>*</font>
        </td>
        <td width="200" class="data1">
        <form:select path="certType" cssClass="button" onchange="return checkType();" style="width:200px">
          <form:option value=""><spring:message code="smtp.tls.cert.type.blank" /></form:option>
          <form:option value="0"><spring:message code="smtp.tls.cert.type.request" /></form:option>
          <form:option value="1"><spring:message code="smtp.tls.cert.type.signed" /></form:option>
        </form:select>
        </td>
        <td width="100"  class="data1">
        </td>
      </tr>
      <tr>
        <td width="100"  class="data1">
        </td>
        <td width="115"  class="data1">
          <spring:message code="smtp.tls.cert.add.key"/><font color=red>*</font>
        </td>
        <td width="200" class="data1">
        <form:select path="keyLength" cssClass="button" onchange="return true;" style="width:200px">
          <form:option value=""><spring:message code="smtp.tls.cert.key.blank" /></form:option>
          <form:option value="1024"><spring:message code="smtp.tls.cert.key.1024" /></form:option>
          <form:option value="2048"><spring:message code="smtp.tls.cert.key.2048" /></form:option>
        </form:select>
        </td>
        <td width="100"  class="data1">
        </td>
      </tr>
      <tr>
        <td width="100"  class="data1">
        </td>
        <td width="115"  class="data1">
          <spring:message code="smtp.tls.cert.add.country"/><font color=red>*</font>
        </td>
        <td width="200" class="data1">
        <form:select path="countryCode" items="${countryList}" cssClass="button" onchange="return true;" style="width:200px" />
        </td>
        <td width="100"  class="data1">
        </td>
      </tr>
      <tr>
        <td width="100"  class="data1">
        </td>
        <td width="115"  class="data1">
          <spring:message code="smtp.tls.cert.add.state"/><font color=red>*</font>
        </td>
        <td width="200"  class="data1">
          <form:input path="state" cssClass="button" style="width: 200px"/>
        </td>
        <td width="100"  class="data1">
        </td>
      </tr>
      <tr>
        <td width="100"  class="data1">
        </td> 
        <td width="115"  class="data1">
          <spring:message code="smtp.tls.cert.add.loc"/><font color=red>*</font>
        </td> 
        <td width="200"  class="data1">
          <form:input path="locality" cssClass="button" style="width: 200px"/>
        </td>
        <td width="100"  class="data1">
        </td>
      </tr>
      <tr>
        <td width="100"  class="data1">
        </td>
        <td width="115"  class="data1">
          <spring:message code="smtp.tls.cert.add.org"/><font color=red>*</font>
        </td>
        <td width="200"  class="data1">
          <form:input path="org" cssClass="button" style="width: 200px"/>
        </td>
        <td width="100"  class="data1">
        </td>
      </tr>
      <tr>
        <td width="100"  class="data1">
        </td>
        <td width="200"  class="data1">
          <spring:message code="smtp.tls.cert.add.unit"/><font color=red>*</font>
        </td>
        <td width="200"  class="data1">
          <form:input path="orgUnit" cssClass="button" style="width: 200px"/>
        </td>
        <td width="100"  class="data1">
        </td>
      </tr>
      <tr>
        <td width="100"  class="data1">
        </td>
        <td width="115"  class="data1">
          <spring:message code="smtp.tls.cert.add.cn"/><font color=red>*</font>
        </td>
        <td width="200"  class="data1">
          <form:input path="commonName" cssClass="button" style="width: 200px"/>
        </td>
        <td width="100"  class="data1">
        </td>
      </tr>
      <tr>
        <td width="100"  class="data1">
        </td>
        <td width="115"  class="data1">
          <spring:message code="smtp.tls.cert.add.email"/><font color=red>*</font>
        </td>
        <td width="200"  class="data1">
          <form:input path="emailAddress" cssClass="button" style="width: 200px"/>
        </td>
        <td width="100"  class="data1">
        </td>
      </tr>
      <tr>
        <td width="100"  class="data1">
        </td>
        <td width="115"  class="data1" id="vd">
          <spring:message code="smtp.tls.cert.add.duration"/><font color=red>*</font>
        </td>
        <td width="200"  class="data1">
          <form:input path="validDays" cssClass="button" style="width: 200px"/>
        </td>
        <td width="100"  class="data1">
        </td>
      </tr>
    </table></td>
  </tr>
  <tr>
    <td height="35" align="center" style="padding:15px">
        <input type="submit" class="cbutton" onclick="return checkValid();" value="<spring:message code="button.save" />"/>
        <input name="cancel" type="button" class="cbutton" onClick="javascript:window.close();" value="<spring:message code="button.cancel" />" >
    </td>
  </tr>
</table>
<form:hidden path="id" />
</form:form>

</body>
</html>
