#!/bin/sh

# Script for IMSA 7 patching via Web Console.
# ini_util.sh is based on StarGate implementation, with minor bug fixes.
# Zhennan, Nov/07/2006
#
# This script is invoked by imssmgr, which is running as root
# when invoked, stdout and stderr will be redirected to log file: patchlog.txt
# for easy testing, no stdout and stderr redirection inside the script.
# this script can be executed from console directly, with correct folder structure
#
# Naming convention
# F_  means a subroutine

export PATCH_FOLDER=${IMSS_HOME}/patch
export TEMP_FOLDER=${PATCH_FOLDER}/temp

export PATCHINFOINI=${TEMP_FOLDER}/patchinfo.ini
export PATCHMGMINI=${PATCH_FOLDER}/patch.ini

# For app patch, this lock will be removed in this file: apply.sh
# For os patch, after system reboot, it will be removed by post_update_os.sh
LOCK_FILE=${PATCH_FOLDER}/.isinprogress

TEMP_BINARY_TAR_GZ=${TEMP_FOLDER}/binary.tar.gz
TEMP_ROLLBACK_SH=${TEMP_FOLDER}/rollback.sh
TEMP_INI_UTIL_SH=${TEMP_FOLDER}/ini_util.sh
TEMP_PATCH_COMMON_SH=${TEMP_FOLDER}/patch_common.sh
TEMP_APPLY_APP_SH=${TEMP_FOLDER}/apply_app.sh
TEMP_APPLY_OS_SH=${TEMP_FOLDER}/apply_os.sh


. ${TEMP_INI_UTIL_SH}
. ${TEMP_PATCH_COMMON_SH}

PATCH_TYPE=""

RESULT_BUILD=`F_ini_get ${PATCHINFOINI} "General" "BuildNum"`
PATCH_TITLE=`F_ini_get ${PATCHINFOINI} "General" "Title"`

PARAMETER_UNREG=""

F_check_required_files_and_fields() {

    if [ ! -f "$TEMP_INI_UTIL_SH" ] ; then
        F_log "Can not find $TEMP_INI_UTIL_SH."
        ERROR_NUMBER=${ERR_FILE_MISSING}
        return 1
    fi

    if [ ! -f "$TEMP_PATCH_COMMON_SH" ] ; then
        F_log "Can not find $TEMP_PATCH_COMMON_SH."
        ERROR_NUMBER=${ERR_FILE_MISSING}
        return 1
    fi

    if [ ! -f "$PATCHINFOINI" ] ; then
        F_log "Cannot find $PATCHINFOINI."
        ERROR_NUMBER=${ERR_FILE_MISSING}
        return 1
    fi

    # type, build, title are required

    PATCH_TYPE=`F_ini_get $PATCHINFOINI General Type`
    if [ -z "$PATCH_TYPE" ] ; then
        F_log "Cannot find Type in $PATCHINFOINI."
        ERROR_NUMBER=${ERR_INI_FILE_CONTENT}
        return 1
    fi

    _value=`F_ini_get $PATCHINFOINI General BuildNum`
    if [ -z "$_value" ] ; then
        F_log "Cannot find BuildNum in $PATCHINFOINI."
        ERROR_NUMBER=${ERR_INI_FILE_CONTENT}
        return 1
    fi

    _value=`F_ini_get $PATCHINFOINI General Title`
    if [ -z "$_value" ] ; then
        F_log "Cannot find Title in $PATCHINFOINI."
        ERROR_NUMBER=${ERR_INI_FILE_CONTENT}
        return 1
    fi

    F_log "Required file and fields check OK."
    return 0

}

F_check_all() {

    F_check_required_files_and_fields
    if [ $? -ne 0 ] ; then
        F_log "The patch format is incorrect. Please check required files or fields in the configuration file."
        return 1
    fi
    
    return 0
}

F_apply() {
    
    if [ ${PATCH_TYPE} = "app" ] ; then
        
        if [ ! -f "$TEMP_APPLY_APP_SH" ] ; then
            F_log "Cannot find $TEMP_APPLY_APP_SH."
            ERROR_NUMBER=${ERR_FILE_MISSING}
            return 1
        fi
        
        F_log "Calling ${TEMP_APPLY_APP_SH}"

        sh ${TEMP_APPLY_APP_SH} ${PARAMETER_UNREG}
        
        # return value really doesn't matter now, since caller won't check it.
        # but we return it anyway.
        
        # Since apply_app.sh already wrote the patchresult.ini
        # Do not return, just exit, so caller (F_main) can write result base on return value.
        rm -f ${LOCK_FILE}
               
        exit $?
        
    else
        if [ ${PATCH_TYPE} = "os" ] ; then
            
            if [ ! -f "$TEMP_APPLY_OS_SH" ] ; then
                F_log "Cannot find $TEMP_APPLY_OS_SH."
                ERROR_NUMBER=${ERR_FILE_MISSING}
                return 1
            fi
            
            F_log "Calling ${TEMP_APPLY_OS_SH}"
            
            UI_INTERRUPTION=`F_ini_get $PATCHINFOINI "General" "UIInterruption"`
            if [ -z "$UI_INTERRUPTION" ] ; then
                UI_INTERRUPTION="0"
            fi
            
            IS_MASTER=0
            sh ${IMSS_HOME}/script/is_master.sh
            if [ $? = 1 ] ; then
                IS_MASTER=1
            fi
            
            if [ $UI_INTERRUPTION = "1" ] ; then
            if [ $IS_MASTER = 1 ] ; then
                ${IMSS_HOME}/PostgreSQL/bin/psql -U sa -d imss -c "update tb_patch_status set status=4 where status=2;" > /dev/null 2>&1
                sleep 10
                ${IMSS_HOME}PostgreSQL/bin/psql -U sa -d imss -c "update tb_patch_status set status=2 where status=4;" > /dev/null 2>&1
            fi
            fi

            sh ${TEMP_APPLY_OS_SH}

            # when update_os.sh call "reboot", "apply_os.sh" will return with 0
            
            _value=$?
            if [ ${_value} -eq 0 ] ; then
                # rebooting, save flags in patchresult.ini
                # use action = 3 to indicate "rebooting"
                F_write_result "2" "0"  "3" "0" "0" "msg" "build" "title"
            else
                # failed in update_os.sh
                F_write_result "2" "0"  "1" "0" "1" "${ERR_MSG_FAIL}" "result" "title"
            fi
            
            rm -f ${LOCK_FILE}
            exit ${_value}
            
        else
            F_log "Invalid patch type: $PATCH_TYPE"
            return 1
        fi
    fi
    
    return 0
}

F_main() {

    F_log "Start apply patch."

    if [ -f "$LOCK_FILE" ] ; then
        F_log "Another installing/uninstalling is in progress."
        ERROR_NUMBER=${ERR_ISINPROGRESS}
        return 1
    fi

    touch ${LOCK_FILE}

    if [ $? -ne 0 ] ; then
        F_log "Can not create lock file."
        ERROR_NUMBER=${ERR_FAILED_TO_LOCK}
        return 1
    fi

    F_check_all

    if [ $? -ne 0 ] ; then
        rm -f ${LOCK_FILE}
        return 1
    fi

    F_apply
    
    if [ $? -ne 0 ] ; then
        rm -f ${LOCK_FILE}
        return 1
    fi

        
    # Success
    rm -f ${LOCK_FILE}
    return 0
}

# IMSA-7.0-00742 
if [ ! -z $1 ] ; then
    if [ $1 = "unreg" ] ; then
        PARAMETER_UNREG="unreg"
    fi
fi

F_main
if [ $? -ne 0 ] ; then
    # PATCH_TYPE may be incorrect here...default to 1
    if [ ${PATCH_TYPE} = "os" ] ; then
        F_write_result "2" "0"  "1" "0" "1" "${ERR_MSG_FAIL}" "${RESULT_BUILD}" "${PATCH_TITLE}"
    else
        F_write_result "1" "0"  "1" "0" "1" "${ERR_MSG_FAIL}" "${RESULT_BUILD}" "${PATCH_TITLE}"
    fi    
    exit ${ERROR_NUMBER}
else
    exit 0
fi
