#!/bin/sh

# Script for IMSA 7 patching via Web Console.
# inherited from IMSA 1 apply.sh
# ini_util.sh is based on StarGate implementation, with minor bug fixes.
# Zhennan, Nov/07/2006
#
# This script is invoked by apply.sh, which is invoked by imssmgr

export PATCH_FOLDER=${IMSS_HOME}/patch
export TEMP_FOLDER=${PATCH_FOLDER}/temp

TEMP_BINARY_TAR_GZ=${TEMP_FOLDER}/binary.tar.gz
TEMP_EN_SPECIFIC_DIR=${TEMP_FOLDER}/en_specific
TEMP_JA_SPECIFIC_DIR=${TEMP_FOLDER}/jp_specific
TEMP_ROLLBACK_SH=${TEMP_FOLDER}/rollback.sh
TEMP_INI_UTIL_SH=${TEMP_FOLDER}/ini_util.sh
TEMP_PATCH_COMMON_SH=${TEMP_FOLDER}/patch_common.sh
TEMP_BACKUP_TAR=${TEMP_FOLDER}/backup.tar
TEMP_BACKUP_TAR_GZ=${TEMP_FOLDER}/backup.tar.gz
TEMP_BACKUP_FILELIST=${TEMP_FOLDER}/backup.filelist
TEMP_OUTDATED_FILELIST=${TEMP_FOLDER}/outdated.filelist
APP_TEMP_IN_HOME=${IMSS_HOME}/app_temp
APP_TEMP_IN_APP_DATA=/var/app_data/imss/app_temp/
#EULA is not used by scripts.
ODBC_INI=${IMSS_HOME}/config/odbc.ini

NORMAL_ROLLBACK_SH=${PATCH_FOLDER}/rollback.sh
NORMAL_INI_UTIL_SH=${PATCH_FOLDER}/ini_util.sh
NORMAL_PATCH_COMMON_SH=${PATCH_FOLDER}/patch_common.sh
NORMAL_BACKUP_TAR_GZ=${PATCH_FOLDER}/backup.tar.gz
NORMAL_BACKUP_FILELIST=${PATCH_FOLDER}/backup.filelist
#NORMAL_NEW_FILELIST=${PATCH_FOLDER}/new.filelist

TEMP_APPLY_DB_SH=${TEMP_FOLDER}/apply_db.sh
TEMP_APPLY_OS_SH=${TEMP_FOLDER}/apply_os.sh
TEMP_APPLY_CONFIG_SH=${TEMP_FOLDER}/apply_config.sh
TOMCAT_CACHE_FOLDER=${IMSS_HOME}/UI/adminUI/ROOT/work/
EUQ_CACHE_FOLDER=${IMSS_HOME}/UI/euqUI/ROOT/work/

TEMP_APPLY_DB_SQL=${TEMP_FOLDER}/upgrade.sql
APACHE_SH=${IMSS_HOME}/UI/php/bin/apache.sh
PHP_INI=${IMSS_HOME}/UI/php/conf/php.ini
AGENT_INI=${IMSS_HOME}/config/Agent.ini
EUQ_APACHE_SH=${IMSS_HOME}/UI/euqUI/bin/Apache.sh
TEMP_ENGINE_SH=${TEMP_FOLDER}/apply_eng.sh
TEMP_ROLLBACK_DB_SQL=${TEMP_FOLDER}/rollback.sql
TMASE_ENGINE_BINARY=${IMSS_HOME}/lib/libtmaseng.so
TEMP_TMASE_SO_FILE=${TEMP_FOLDER}/tmase/libtmaseng.so

ADMIN_CONF=${IMSS_HOME}/UI/php/conf/widget.conf
EUQ_CONF=${IMSS_HOME}/UI/euqUI/conf/EUQ.conf

. ${TEMP_INI_UTIL_SH}
. ${TEMP_PATCH_COMMON_SH}

PATCH_NUMBER=""
ERROR_NUMBER=0

NO_BACKUP_FILE=0
PARAMETER_UNREG="notunreg"
PATCH_TYPE=""
PATCH_SUB_TYPE=""


PATCH_SUB_TYPE_PATCH=1
PATCH_SUB_TYPE_HF=2
PATCH_SUB_TYPE_CP=3
PATCH_SUB_TYPE_SP=4

# PATCHINFOINI is exported in apply.sh
# but to ease the testing, define it here again
export PATCHINFOINI=${TEMP_FOLDER}/patchinfo.ini
RESULT_BUILD=`F_ini_get ${PATCHINFOINI} "General" "BuildNum"`
PATCH_TITLE=`F_ini_get ${PATCHINFOINI} "General" "Title"`

PATCH_ROLLBACKABLE=`F_ini_get $PATCHINFOINI "Application" "Rollbackable"`
if [ -z "$PATCH_ROLLBACKABLE" ] ; then
    PATCH_ROLLBACKABLE="0"
fi

UI_INTERRUPTION=`F_ini_get $PATCHINFOINI "General" "UIInterruption"`
if [ -z "$UI_INTERRUPTION" ] ; then
    UI_INTERRUPTION="0"
fi

PATCH_TYPE=`F_ini_get $PATCHINFOINI "General" "Type"`
PATCH_SUB_TYPE=`F_ini_get $PATCHINFOINI "General" "SubType"`

IS_MASTER=0
sh ${IMSS_HOME}/script/is_master.sh
if [ $? = 1 ] ; then
    IS_MASTER=1
fi

IS_IMSVA=0
if [ -f /etc/trend-release ]; then
    IS_IMSVA=1
fi

# for imsva, product is installed in /opt/trend/imss.
# for imss, product's installed folder is set by customer.
TARGET_FOLDER=""
if [ ${IS_IMSVA} -eq 0 ]; then
    TARGET_FOLDER=${IMSS_HOME}
fi

F_check_required_files_and_fields() {

    if [ ! -f "$PATCHMGMINI" ] ; then
        touch $PATCHMGMINI
        if [ $? -ne 0 ] ; then
            F_log "Can not create $PATCHMGMINI."
            ERROR_NUMBER=${ERR_INI_FILE_ACCESS}
            return 1
        fi
    fi

    if [ ! -f "$TEMP_BINARY_TAR_GZ" ] ; then
        F_log "Can not find $TEMP_BINARY_TAR_GZ."
        ERROR_NUMBER=${ERR_FILE_MISSING}
        return 1
    fi
    
    if [ ! -d "$TEMP_EN_SPECIFIC_DIR" ] ; then
        F_log "Can not find $TEMP_EN_SPECIFIC_DIR."
        ERROR_NUMBER=${ERR_FILE_MISSING}
        return 1
    fi 

    if [ ! -d "$TEMP_JA_SPECIFIC_DIR" ] ; then
        F_log "Can not find $TEMP_JA_SPECIFIC_DIR."
        ERROR_NUMBER=${ERR_FILE_MISSING}
        return 1
    fi       

    if [ $PATCH_ROLLBACKABLE = "1" ] ; then
        if [ ! -f "$TEMP_ROLLBACK_SH" ] ; then
            F_log "Can not find $TEMP_ROLLBACK_SH."
            ERROR_NUMBER=${ERR_FILE_MISSING}
            return 1
        fi
    fi

    # Number, MD5, RequireDiskSpace are required

    PATCH_NUMBER=`F_ini_get $PATCHINFOINI Application Number`
    if [ -z "$PATCH_NUMBER" ] ; then
        F_log "Cannot find Number in $PATCHINFOINI."
        ERROR_NUMBER=${ERR_INI_FILE_CONTENT}
        return 1
    fi

    _value=`F_ini_get $PATCHINFOINI Application MD5`
    if [ -z "$_value" ] ; then
        F_log "Cannot find MD5 in $PATCHINFOINI."
        ERROR_NUMBER=${ERR_INI_FILE_CONTENT}
        return 1
    fi

    _value=`F_ini_get $PATCHINFOINI Application RequireDiskSpace`
    if [ -z "$_value" ] ; then
        F_log "Cannot find RequireDiskSpace in $PATCHINFOINI."
        ERROR_NUMBER=${ERR_INI_FILE_CONTENT}
        return 1
    fi

    # change the string to int here, it is used to write to patchhistory.txt
	# and then upload the entries in patchhistory.txt to tb_patch_history and
	# the patch_subtype field's type is integer
	case ${PATCH_SUB_TYPE} in
		"Patch")  PATCH_SUB_TYPE=1; PATCH_SUB_TYPE_STR="patch" ;;
		"HF")     PATCH_SUB_TYPE=2; PATCH_SUB_TYPE_STR="hotfix" ;;
		"CP")     PATCH_SUB_TYPE=3; PATCH_SUB_TYPE_STR="critical patch" ;;
		"SP")     PATCH_SUB_TYPE=4; PATCH_SUB_TYPE_STR="service pack" ;;
	esac

    F_log "Required file and fields for application update check OK."

    return 0
}

F_check_redundancy() {

    _applied_patches=`F_ini_get $PATCHMGMINI Patches Applied`

    #stop if the patch number is already in Applied..
    for i in $_applied_patches
    do
        if [ "$PATCH_NUMBER" = "$i" ] ; then
            F_log "Cannot apply this patch. The patch script has detected a same patch number."
            ERROR_NUMBER=${ERR_ALREADY_APPLIED}
            return 1
        fi
    done

    #delete the section if there is an old section
    F_ini_get_section $PATCHMGMINI $PATCH_NUMBER
    if [ $? -eq 0 ] ; then
        F_log "The patch section is still in $PATCHMGMINI. The old section will be overwritten."
        F_ini_delete_section $PATCHMGMINI $PATCH_NUMBER
    fi

    F_log "Redundancy Check OK."
    return 0
}

F_check_dependency() {

    #Return error if I require a patch that doesn't exist.

    _dependency_number=`F_ini_get $PATCHINFOINI Application Dependency`
	_dependency_string=`F_ini_get $PATCHINFOINI Application DependencyString`

    if [ -z "$_dependency_number" ] ; then
        return 0
    fi

    if [ -n "$_dependency_number" ] ; then

        _found_require=0
        for j in $_applied_patches
        do
            if [ "$_dependency_number" = "$j" ] ; then
                _found_require=1
            fi
        done
        if [ "$_found_require" = "0" ] ; then
			if [ -z "$_dependency_string" ] ; then
				_dependency_string=$_dependency_number
			fi		

            F_log "Cannot find the required previous dependency patch $_dependency_number."
            ERROR_NUMBER=${ERR_DEPENDENCY_MISSING}
            # Hint users that they need to install dependency patch. This msg will show in UI page.
            ERR_MSG_FAIL="An error occurred while updating the device. Make sure you have installed the previous build (build $_dependency_string) before installing this $PATCH_SUB_TYPE_STR."

            return 1
        fi
        F_log "Find the required previous dependency patch $_dependency_number."
    fi

    return 0
}

# F_check_free_disk is only used in IMSVA
F_check_free_disk() {

    _available_disk_size=`df -P -m $IMSS_HOME/../ | tail -1 | awk '{print $4}'`
    _required_disk_size=`F_ini_get $PATCHINFOINI Application RequireDiskSpace`
    _sub_of_disk_size=`expr ${_available_disk_size} - ${_required_disk_size}`
    if [ ${_sub_of_disk_size} -gt 0 ] ; then
        F_log "Disk space check passed: ${_available_disk_size} > ${_required_disk_size}"
        return 0
    else
        F_log "Not enough disk space: ${_available_disk_size} <= ${_required_disk_size}"
        ERROR_NUMBER=${ERR_DISK_SPACE}
        return 1
    fi
    
    return 0
}

F_check_md5sum() {

    _real_md5sum=`md5sum $TEMP_BINARY_TAR_GZ | awk '{print $1}'`
    _said_md5sum=`F_ini_get $PATCHINFOINI Application MD5`
    if [ ${_real_md5sum} = ${_said_md5sum} ] ; then
        F_log "md5sum check passed: ${_real_md5sum}"
        return 0
    else
        F_log "md5sum check fail. real:${_real_md5sum} expected:${_said_md5sum}"
        ERROR_NUMBER=${ERR_MD5SUM}
        return 1
    fi

    return 0
}


F_check_all() {

    F_check_required_files_and_fields
    if [ $? -ne 0 ] ; then
        F_log "The patch format is incorrect. Please check required files or fields in the configuration file."
        return 1
    fi

    F_check_redundancy
    if [ $? -ne 0 ] ; then
        F_log "Cannot pass redundancy check. Exit."
        return 1
    fi

    F_check_dependency
    if [ $? -ne 0 ] ; then
        F_log "Cannot pass dependency check. Exit."
        return 1
    fi

    
    F_check_free_disk
    if [ $? -ne 0 ] ; then
        F_log "Cannot pass free disk check. Exit."
        return 1
    fi

    F_check_md5sum
    if [ $? -ne 0 ] ; then
        F_log "Cannot pass md5 check. Exit."
        return 1
    fi

}


F_handle_outdated() {

	if [ ! -f ${TEMP_OUTDATED_FILELIST} ]; then
		return 0;
	fi

	if [ $1 = "backup" ]; then
		#remove blank lines
		sed -i -r '/^$/d' ${TEMP_OUTDATED_FILELIST}
    	len=`wc -l < ${TEMP_OUTDATED_FILELIST}`

    	for i in `seq 1 $len`; do
    	    f=`head -n $i ${TEMP_OUTDATED_FILELIST} | tail -n 1`
		
    	    if [ -r /${f} ] ; then
    	        if [ $i -eq 0 ] ; then
    	            tar cf $TEMP_BACKUP_TAR -C / ${f}
    	            if [ $? -ne 0 ] ; then
    	                F_log "Generate backup.tar failed."
    	                ERROR_NUMBER=${ERR_BACKUP}
    	                return 1
    	            fi
    	        else
    	            tar rf $TEMP_BACKUP_TAR -C / ${f}
    	            if [ $? -ne 0 ] ; then
    	                F_log "Append backup.tar failed."
    	                ERROR_NUMBER=${ERR_BACKUP}
    	                return 1
    	            fi
    	        fi
    	    fi
    	done
	    F_log "Backup outdated files done."

	elif [ $1 = "rm" ]; then
		len=`wc -l < ${TEMP_OUTDATED_FILELIST}`
		for i in `seq 1 $len`; do
		    f=`head -n $i ${TEMP_OUTDATED_FILELIST} | tail -n 1`
			if [ -z ${f} ]; then
		        continue
		    fi
		    rm -rf /${f}
		done
	fi	
	return 0
}

F_handle_config() {
	if [ $1 = "modify" ]; then
		#handle modify operations
		return 0;	
	elif [ $1 = "backup" ]; then
		#backup the configure files to be modified
		return 0;
	fi
	
	return 0
}

F_backup() {

    # generate backup.filelist first
    tar -ztvf ${TEMP_BINARY_TAR_GZ} | grep -v "/$" | awk '{print $6}' > ${TEMP_BACKUP_FILELIST}
    if [ $? -ne 0 ] ; then
        F_log "Generate backup.filelist failed."
        ERROR_NUMBER=${ERR_BACKUP}
        return 1
    fi

    #don't rollback those file for VRTS-5256
    sed -i '/imsva_pd_util/d'  ${TEMP_BACKUP_FILELIST}
    sed -i '/liblogin.so/d'  ${TEMP_BACKUP_FILELIST}
    sed -i '/AdminAccountService.class/d'  ${TEMP_BACKUP_FILELIST}
    sed -i '/AdminAccountDao.class/d'  ${TEMP_BACKUP_FILELIST}
    sed -i '/AdminAccountMapper.class/d'  ${TEMP_BACKUP_FILELIST}

    # backup these files, some maybe missing from current system, so, ignore-failed-read
    #Add by Marvin 2006-2-15 22:56
    len=`wc -l < $TEMP_BACKUP_FILELIST`
    done_file_cnt=0

    for i in `seq 1 $len`; do
        f=`head -n $i $TEMP_BACKUP_FILELIST | tail -n 1`
        if [ -r ${TARGET_FOLDER}/$f ]; then
            done_file_cnt=`expr ${done_file_cnt} + 1`
            if [ $i -eq 0 ]; then
                tar cf $TEMP_BACKUP_TAR -C ${TARGET_FOLDER}/ $f
                if [ $? -ne 0 ] ; then
                    F_log "Generate backup.tar failed."
                    ERROR_NUMBER=${ERR_BACKUP}
                    return 1
                fi
            else
                tar rf $TEMP_BACKUP_TAR -C ${TARGET_FOLDER}/ $f
                if [ $? -ne 0 ] ; then
                    F_log "Append backup.tar failed."
                    ERROR_NUMBER=${ERR_BACKUP}
                    return 1
                fi
            fi
        fi
    done

    # backup files to be deleted
	F_handle_outdated "backup"
    if  [ $? -ne 0 ]; then
        F_log "Cannot backup existing files which are going to be deleted. Exit."
        return 1
    fi

    # backup the confiure files that can not be replaced directly 
	F_handle_config "backup"
    if  [ $? -ne 0 ]; then
        F_log "Cannot backup server.xml. Exit."
        return 1
    fi

    rm -f $TEMP_BACKUP_TAR_GZ

    if [ ${done_file_cnt} -ne 0 ] ; then
        gzip $TEMP_BACKUP_TAR
        if [ $? -ne 0 ] ; then
            F_log "Generate backup.tar.gz failed."
            ERROR_NUMBER=${ERR_BACKUP}
            return 1
        fi
    else
        NO_BACKUP_FILE=1
    fi

    #End by Marvin
    F_log "Backup done."
    return 0;
}

F_apply_now() {

    rm -rf ${IMSS_HOME}/UI/adminUI/ROOT/help/en/webhelp/*

    # apply new files
    tar -C ${TARGET_FOLDER}/ -zxf ${TEMP_BINARY_TAR_GZ}
    if [ $? -ne 0 ] ; then
        F_log "Can not untar patch files. Auto rollback."
        ERROR_NUMBER=${ERR_UNTAR_PATCH_FILES}

        # auto rollback
        pushd .
        cd ${TARGET_FOLDER}/
        rm -rf `cat ${TEMP_BACKUP_FILELIST}`
        popd
        tar -C ${TARGET_FOLDER}/ -zxf ${TEMP_BACKUP_TAR_GZ}

        return 1
    fi 
    if [ -e ${PATCH_FOLDER}/temp/needReplaceTmaseBinary ]; then
        /bin/cp -vf $TEMP_TMASE_SO_FILE ${IMSS_HOME}/lib/
        chmod 750 ${IMSS_HOME}/lib/libtmaseng.so
        chown imss:imss ${IMSS_HOME}/lib/libtmaseng.so
        rm -rf ${PATCH_FOLDER}/temp/needReplaceTmaseBinary
    fi
    F_log "Apply patch files done."
    return 0;
}

F_post_apply() {

    # update patch.ini
    F_ini_exist_section ${PATCHMGMINI} "Patches"
    if [ $? -ne 0 ] ; then
        F_ini_append_section ${PATCHMGMINI} "Patches"
    fi

    _value=`F_ini_get ${PATCHMGMINI} "Patches" "Applied"`
    F_ini_add_key ${PATCHMGMINI} "Patches" "Applied" "$_value $PATCH_NUMBER"

    F_ini_add_key ${PATCHMGMINI} "Patches" "Rollbackable" "$PATCH_NUMBER"

    F_ini_exist_section ${PATCHMGMINI} "$PATCH_NUMBER"
    if [ $? -ne 1 ] ; then
        F_ini_delete_section ${PATCHMGMINI} "$PATCH_NUMBER"
    fi

    F_ini_append_section ${PATCHMGMINI} "$PATCH_NUMBER"

    _value=`F_ini_get ${PATCHINFOINI} "General" "BuildNum"`
    F_ini_add_key ${PATCHMGMINI} "$PATCH_NUMBER" "BuildNum" "${_value}"
    RESULT_BUILD=${_value}

    _value=`F_ini_get ${PATCHINFOINI} "General" "Title"`
    F_ini_add_key ${PATCHMGMINI} "$PATCH_NUMBER" "Title" "${_value}"
    PATCH_TITLE=${_value}

    _value=`F_ini_get ${PATCHINFOINI} "General" "Description"`
    F_ini_add_key ${PATCHMGMINI} "$PATCH_NUMBER" "Description" "${_value}"

    _value=`F_ini_get ${PATCHINFOINI} "Application" "CmdBeforeUpdate"`
    F_ini_add_key ${PATCHMGMINI} "$PATCH_NUMBER" "CmdBeforeUpdate" "${_value}"

    _value=`F_ini_get ${PATCHINFOINI} "Application" "CmdAfterUpdate"`
    F_ini_add_key ${PATCHMGMINI} "$PATCH_NUMBER" "CmdAfterUpdate" "${_value}"

    F_ini_add_key ${PATCHMGMINI} "$PATCH_NUMBER" "NoBackupFile" "${NO_BACKUP_FILE}"

    F_ini_add_key ${PATCHMGMINI} "$PATCH_NUMBER" "UIInterruption" "${UI_INTERRUPTION}"

	# append the type and subtype in patch.ini
	F_ini_add_key ${PATCHMGMINI} "$PATCH_NUMBER" "Type" ${PATCH_TYPE}
	F_ini_add_key ${PATCHMGMINI} "$PATCH_NUMBER" "SubType" ${PATCH_SUB_TYPE}

    # change "_PKG_INSTALL_ROOT_" to ${IMSS_HOME} for the files under binary//
    for _file in `tar ztvf ${TEMP_BINARY_TAR_GZ} | grep "\sscript" | grep -v "/$" | awk '{print $6}' `; do
        F_log "found  $_file"
        if [ -f ${IMSS_HOME}/${_file} ]; then
            F_log "Update _PKG_INSTALL_ROOT_ in ${IMSS_HOME}/${_file}"
            sed -i "s#_PKG_INSTALL_ROOT_#$IMSS_HOME#g" ${IMSS_HOME}/${_file}
        fi
    done
	
    DB_SERVER=`grep 'Servername' ${ODBC_INI} | awk -F= '{print $NF}'| sed -r 's/[[:space:]]//g'`
    DB_PORT=`grep 'Port' ${ODBC_INI} | awk -F= '{print $NF}'| sed -r 's/[[:space:]]//g'`
    DB_NAME=`grep 'Database' ${ODBC_INI} | awk -F= '{print $NF}'| sed -r 's/[[:space:]]//g'`
    RESOURCE_XML="${IMSS_HOME}/UI/adminUI/ROOT/WEB-INF/imss-resources.xml"	
    sed -i "s#_PKG_SERVER_:_PKG_DB_PORT_/_PKG_DB_#${DB_SERVER}:${DB_PORT}/${DB_NAME}#g" $RESOURCE_XML
    
    #replace _PKG_INSTALL_ROOT_ IN APACHE.SH
    #F_log "Update _PKG_INSTALL_ROOT_ in ${APACHE_SH}"
    #sed -i "s#_PKG_INSTALL_ROOT_#$IMSS_HOME#g" ${APACHE_SH}
    
    #F_log "Update _PKG_INSTALL_ROOT_ in ${PHP_INI}"
    #sed -i "s#_PKG_INSTALL_ROOT_#$IMSS_HOME#g" ${PHP_INI}
    
    #F_log "Update _PKG_INSTALL_ROOT_ in ${EUQ_APACHE_SH}"
    #sed -i "s#_PKG_INSTALL_ROOT_#$IMSS_HOME#g" ${EUQ_APACHE_SH}

    F_log "Update /opt/trend/imss/config/Agent.ini RetryCount"
    sed -i "s#RetryCount=1#RetryCount=4#g" ${AGENT_INI}

    rm -rf ${IMSS_HOME}/UI/tomcat/work/*
    rm -rf ${IMSS_HOME}/UI/tomcat/webapps/*

    cp ${IMSS_HOME}/UI/php/conf/widget.conf ${IMSS_HOME}/UI/php/conf/widget.conf.bakhf1368

    sed -i '$a\#Block access from UI' ${IMSS_HOME}/UI/php/conf/widget.conf
    if [ `grep -c "/widget/repository/db/" ${IMSS_HOME}/UI/php/conf/widget.conf` -eq '0' ]; then
        echo -e "<Directory  ~ \"/widget/repository/db/\">\n    Require all denied\n</Directory>" >> ${IMSS_HOME}/UI/php/conf/widget.conf
    fi
    if [ `grep -c "/widget/repository/inc/" ${IMSS_HOME}/UI/php/conf/widget.conf` -eq '0' ]; then
        echo -e "<Directory  ~ \"/widget/repository/inc/\">\n    Require all denied\n</Directory>" >> ${IMSS_HOME}/UI/php/conf/widget.conf
    fi
    if [ `grep -c "/widget/repository/cache/" ${IMSS_HOME}/UI/php/conf/widget.conf` -eq '0' ]; then
        echo -e "<Directory  ~ \"/widget/repository/cache/\">\n    Require all denied\n</Directory>" >> ${IMSS_HOME}/UI/php/conf/widget.conf
    fi
    rm -rf ${IMSS_HOME}/UI/adminUI/ROOT/widget/repository/userGenerated


    RealTime_Polling=`cat $IMSS_HOME/config/Agent.ini | grep RealTime_Polling | sed 's/ //g' | cut -d '=' -f 2`
    RealTime_Size=`cat $IMSS_HOME/config/Agent.ini | grep RealTime_Size | sed 's/ //g' | cut -d '=' -f 2`
    Batch_Polling=`cat $IMSS_HOME/config/Agent.ini | grep Batch_Polling | sed 's/ //g' | cut -d '=' -f 2`
    Batch_Size=`cat $IMSS_HOME/config/Agent.ini | grep Batch_Size | sed 's/ //g' | cut -d '=' -f 2`
    RealTime_Queue_Size=`cat $IMSS_HOME/config/Agent.ini | grep RealTime_Queue_Size | sed 's/ //g' | cut -d '=' -f 2`
    Batch_Queue_Size=`cat $IMSS_HOME/config/Agent.ini | grep Batch_Queue_Size | sed 's/ //g' | cut -d '=' -f 2`
    real_content=`echo $RealTime_Polling, $RealTime_Size, $Batch_Polling, $Batch_Size, $RealTime_Queue_Size, $Batch_Queue_Size`
    origin_content="60, 500, 60, 500, 10000000, 10000000"
 
    if [ "$real_content" == "$origin_content" ]; then
        sed -i '/^RealTime_Polling/cRealTime_Polling=30' $IMSS_HOME/config/Agent.ini
        sed -i '/^RealTime_Size/cRealTime_Size=1000000' $IMSS_HOME/config/Agent.ini
        sed -i '/^Batch_Polling/cBatch_Polling=60' $IMSS_HOME/config/Agent.ini
        sed -i '/^Batch_Size/cBatch_Size=5000000' $IMSS_HOME/config/Agent.ini
        sed -i '/^RealTime_Queue_Size/cRealTime_Queue_Size=500000000' $IMSS_HOME/config/Agent.ini
        sed -i '/^Batch_Queue_Size/cBatch_Queue_Size=500000000' $IMSS_HOME/config/Agent.ini

        F_log "Update /opt/trend/imss/config/Agent.ini OK"
    fi

    return 0
}

F_apply() {

    F_backup
    if [ $? -ne 0 ] ; then
        F_log "Cannot backup existing files. Exit."
        return 1
    fi

    if [ $UI_INTERRUPTION = "1" ] ; then
    	if [ $IS_MASTER = 1 ] ; then
        	${IMSS_HOME}/PostgreSQL/bin/psql -U sa -d imss -c "update tb_patch_status set status=4 where status=2;" > /dev/null 2>&1
        	sleep 10
        	${IMSS_HOME}/PostgreSQL/bin/psql -U sa -d imss -c "update tb_patch_status set status=2 where status=4;" > /dev/null 2>&1
    	fi
    fi

    if [ $IS_MASTER -eq 1 ] ; then
        F_log "Apply Database update."
        . ${TEMP_APPLY_DB_SH} "install" 
        
        if [ $? -ne 0 ];then
            F_log "Cannot update database, stop apply hot fix."
            return 1
        fi
        #check and upgrade ENGINE if needed
        . ${TEMP_ENGINE_SH} "install" 1
        if [ $? -ne 0 ] ; then
            F_log "Cannot update ENGINE, stop apply hot fix."
            return 1
        fi
    else
        #check and upgrade ENGINE if needed
        . ${TEMP_ENGINE_SH} "install" 0
        if [ $? -ne 0 ] ; then
            F_log "Cannot update ENGINE, stop apply hot fix."
            return 1
        fi		
    fi
    
    
    _value=`F_ini_get ${PATCHINFOINI} "Application" "CmdBeforeUpdate"`
    if [ ! -z "$_value" ] ; then
        F_log "Calling ${_value}"
        sh -c "${_value}"
    fi

    #hf1368
    grep -q "secretRequired"  ${IMSS_HOME}/UI/adminUI/conf/server.xml
    if [ $? -eq 1 ];then
        F_log "update ${IMSS_HOME}/UI/adminUI/conf/server.xml file"
        sed -i "s#protocol=\"AJP/1.3\"#protocol=\"AJP/1.3\" secretRequired=\"false\"#g" ${IMSS_HOME}/UI/adminUI/conf/server.xml
    fi
    grep -q "secretRequired"  ${IMSS_HOME}/UI/euqUI/conf/server.xml
    if [ $? -eq 1 ];then
        F_log "update ${IMSS_HOME}/UI/euqUI/conf/server.xml file"
        sed -i "s#protocol=\"AJP/1.3\"#protocol=\"AJP/1.3\" address=\"0.0.0.0\" secretRequired=\"true\" secret=\"oRcImDnErT\"#g" ${IMSS_HOME}/UI/euqUI/conf/server.xml
    fi  

    sed -i '/mod_mpm_prefork.so/d' ${ADMIN_CONF}
    sed -i '$a\LoadModule mpm_prefork_module modules/mod_mpm_prefork.so' ${ADMIN_CONF}
    sed -i '/mod_mpm_prefork.so/d' ${EUQ_CONF}
    sed -i '$a\LoadModule mpm_prefork_module modules/mod_mpm_prefork.so' ${EUQ_CONF}

    # Clear tomcat cache folder, just in case.
    if [  -d "$TOMCAT_CACHE_FOLDER" ] ; then
        echo "clean adminUI cache data"
        rm -rf ${TOMCAT_CACHE_FOLDER}
    fi
    if [  -d "$EUQ_CACHE_FOLDER" ] ; then 
        echo "clean euqUI cache data"
        rm -rf ${EUQ_CACHE_FOLDER}
    fi

	# remove the outdated files
	F_handle_outdated "rm"

    F_apply_now
    if [ $? -ne 0 ] ; then
        _value=`F_ini_get ${PATCHINFOINI} "Application" "CmdAfterUpdate"`
        if [ ! -z "$_value" ] ; then
            F_log "Calling ${_value}"
            sh -c "${_value}"
        fi
        F_log "Cannot apply new patch files. Exit."
        return 1
    fi
	
	# modify the files can not be replaced directly
	F_handle_config "modify"

	# update patch.ini
    F_post_apply
    # no error check for F_post_apply
     
    # must write result before call CmdAfterUpdate
    # otherwise, imssmgr may not able to find the result during startup
    F_write_result "1" "${PATCH_SUB_TYPE}" "1" "${PATCH_ROLLBACKABLE}" "0" "${ERR_MSG_SUCCESS}" "${RESULT_BUILD}" "${PATCH_TITLE}"

    _value=`F_ini_get ${PATCHINFOINI} "Application" "CmdAfterUpdate"`
    if [ ! -z "$_value" ] ; then
        F_log "Calling ${_value}"
        sh -c "${_value}"
    fi
    $IMSS_HOME/bin/imsva_pd_util install $IMSS_HOME

    return 0
}

F_main() {

    F_check_all

    if [ $? -ne 0 ] ; then
        return 1
    fi

    F_gen_lan_package

    if [ $? -ne 0 ] ; then
        return 1
    fi
    
    F_apply

    if [ $? -ne 0 ] ; then
        return 1
    fi

    # Success
    F_log "Done. Success"
    return 0
}

F_save_rollback() {

    if [ ${PARAMETER_UNREG} = "unreg" ] ; then
        return 0
    fi

	# create the backup folder	
	if [ -d $IMSS_HOME/patch/patches/${PATCH_NUMBER} ]; then
		rm -rf $IMSS_HOME/patch/patches/${PATCH_NUMBER}/*
	else
		mkdir -p $IMSS_HOME/patch/patches/${PATCH_NUMBER}
	fi

	# backup the files which are related with backup
	BACKUP_FOLDER=${PATCH_FOLDER}/patches/${PATCH_NUMBER}
	mv $TEMP_APPLY_DB_SH		$BACKUP_FOLDER
	mv $TEMP_ROLLBACK_SH 		$BACKUP_FOLDER
	mv $TEMP_BACKUP_FILELIST    $BACKUP_FOLDER
	mv $TEMP_BACKUP_TAR_GZ 		$BACKUP_FOLDER 
	mv $TEMP_ROLLBACK_DB_SQL	$BACKUP_FOLDER
	
	cp -f $TEMP_INI_UTIL_SH 		${NORMAL_INI_UTIL_SH}
	cp -f $TEMP_PATCH_COMMON_SH 	${NORMAL_PATCH_COMMON_SH}
	
	# remove the files in TEMP_FOLDER
	# rm -rf $TEMP_FOLDER/* 2>/dev/null
}

F_gen_lan_package() {

	BINARY_NAME="binary"
	BINARY_TAR="${TEMP_FOLDER}/${BINARY_NAME}.tar"
	BINARY_TAR_GZ="${BINARY_TAR}.gz"
	
	GZIP="/bin/gzip" 
	TAR="/bin/tar" 
	FIND="/usr/bin/find" 
	XARGS="/usr/bin/xargs" 
	TOUCH="/bin/touch" 
	
	#Get the current IMSS locale
	IMSS_INI_DB=${IMSS_HOME}/config/imss.ini.db
	IS_LOCALE_EN=`grep locale ${IMSS_INI_DB} | grep ja >/dev/null 2>&1 ; echo $?` 
	
	if [  ${IS_LOCALE_EN} -eq 1 ];then 
		F_log "product locale: en"
		BIN_SRC_DIR=${TEMP_EN_SPECIFIC_DIR} 
	else
		F_log "product locale: ja"
		BIN_SRC_DIR="${TEMP_JA_SPECIFIC_DIR}" 
	fi
	
	# check if there's language specific binaries need to be updatd
	exist_files=`${FIND} ${BIN_SRC_DIR} -type f  -name "*" `
	if [ "${exist_files}" == "" ];then
		F_log "no language specific files, skip to next steps ..."
		return 0
	fi
	
	# make sure the binaries are newer
	`${FIND} ${BIN_SRC_DIR} -name "*" | ${XARGS} ${TOUCH}`
	
	# extract the original package to get the tar file
	msg= `${GZIP} -d ${BINARY_TAR_GZ} 2>&1`
	ret=$?
	
	if [ ${ret} -ne 0 ]; then
		F_log "extract file fail: [${msg}]"
		return -1
	fi
	
	#apply the files
	CWD=`pwd`
	pushd . > /dev/null
	cd ${BIN_SRC_DIR} 
	msg=`${TAR} -u --file="${BINARY_TAR}" ./ 2>&1`
	ret=$?
	popd > /dev/null
	
	if [ ${ret} -ne 0 ];then
		F_log "update binary failed: [${msg}]"
		return -1 
	fi
	
	# package the file again
	
	msg=`${GZIP} ${BINARY_TAR} 2>&1`
	ret=$?
	
	if [ ${ret} -ne 0 ];then
		F_log "packaging binary failed: [${msg}]"
		return -1 
	fi
	
	return 0

}

# IMSA-7.0-00742 
if [ ! -z $1 ] ; then
    if [ $1 = "unreg" ] ; then
        PARAMETER_UNREG="unreg"
    fi
fi

F_main
if [ $? -ne 0 ] ; then
    # result_build and title doesn't matter, they won't be used when fail
    ## it matters because the stupid ConfigFileOnDisck class doesn't OK if any key has no value
    F_write_result "1" "${PATCH_SUB_TYPE}"  "1" "0" "1" "${ERR_MSG_FAIL}" "${RESULT_BUILD}" "${PATCH_TITLE}"
    exit ${ERROR_NUMBER}
else
	# save the files which are used to rollback.
    F_save_rollback

    exit 0
fi
