#!/bin/sh

# Script for IMSA patching via Web Console.
# patch_common.sh is shared by both apply.sh and rollback.sh
# Zhennan, Feb/07/2006
#
# Naming convention
# F_  means a subroutine

# disable interactive
alias cp='cp'

# error code define
# NOTE: should never return 127 here
# 127 is same as WEXISTSTATUS(rtn_of_system_call) when script can not be found

ERR_ISINPROGRESS=101
ERR_FAILED_TO_LOCK=102
ERR_INI_FILE_ACCESS=103
ERR_INI_FILE_CONTENT=104
ERR_FILE_MISSING=105
ERR_ALREADY_APPLIED=106
ERR_DEPENDENCY_MISSING=107
ERR_DISK_SPACE=108
ERR_MD5SUM=109
ERR_BACKUP=110
ERR_UNTAR_PATCH_FILES=111
ERR_UNTAR_BACKUP_FILES=112

#ERR_MSG_FAIL is set as default and common value.  This argument may be changed when explicit hints should be shown in UI page.
#eg. In apply_app.sh:F_check_dependency, ERR_MSG_FAIL will be re-set when error occured.
ERR_MSG_FAIL="An error occurred while updating the device. Try again and check the logs for additional details. If the problem persists, restart parent and child devices or rescue the application."
ERR_MSG_SUCCESS="Operation successful."

F_log() {
    echo "`date`: $1"
}

# may not have IMSS_HOME during reboot (in post_update_os.sh)
export PATCH_FOLDER=${IMSS_HOME}/patch
PATCH_RESULT_INI=${PATCH_FOLDER}/patchresult.ini

F_write_result() {
    
    rm -rf ${PATCH_RESULT_INI} 2>/dev/null
    
    touch ${PATCH_RESULT_INI}
    
    F_ini_append_section ${PATCH_RESULT_INI} "PatchResult" ""
    
    F_ini_add_key ${PATCH_RESULT_INI} "PatchResult" type "$1"
    F_ini_add_key ${PATCH_RESULT_INI} "PatchResult" subtype "$2"
    F_ini_add_key ${PATCH_RESULT_INI} "PatchResult" action "$3"
    F_ini_add_key ${PATCH_RESULT_INI} "PatchResult" rollbackable "$4"
    F_ini_add_key ${PATCH_RESULT_INI} "PatchResult" result "$5"
    F_ini_add_key ${PATCH_RESULT_INI} "PatchResult" error_msg "$6"
    F_ini_add_key ${PATCH_RESULT_INI} "PatchResult" result_build "$7"
    F_ini_add_key ${PATCH_RESULT_INI} "PatchResult" title "$8"
    
}
