
#!/bin/sh
export ODBCINI=${IMSS_HOME}/config/odbc.ini
export PATCH_FOLDER=${IMSS_HOME}/patch
export TEMP_FOLDER=${PATCH_FOLDER}/temp
export DB_PSQL=${IMSS_HOME}/PostgreSQL/bin/psql
export PASSWD_UTIL=${IMSS_HOME}/bin/passwd_util
export PGPASS="/root/.pgpass"

UPDATE_AU_SERVER_URL=${TEMP_FOLDER}/dbsql/update_au_server_url.sql
UPDATE_TMASE_SERVER_URL=${TEMP_FOLDER}/dbsql/update_tmase_server_url.sql
TEMP_INI_UTIL_SH=${PATCH_FOLDER}/temp/ini_util.sh
TEMP_PATCH_COMMON_SH=${PATCH_FOLDER}/temp/patch_common.sh
NORMAL_INI_UTIL_SH=${PATCH_FOLDER}/ini_util.sh
NORMAL_PATCH_COMMON_SH=${PATCH_FOLDER}/patch_common.sh

ROLLBACK_FOLDER=${PATCH_FOLDER}/patches

TEMP_BACKUP_DBSQL_FOLDER=${TEMP_FOLDER}/dbsql_backup
OLD_AU_SERVER_URL_FILENAME=${TEMP_BACKUP_DBSQL_FOLDER}/OLD_AU_SERVER_URL
OLD_TMASE_SERVER_URL_FILENAME=${TEMP_BACKUP_DBSQL_FOLDER}/OLD_TMASE_SERVER_URL
SQL_UPGRADE=${TEMP_FOLDER}/upgrade.sql
SQL_ROLLBACK=rollback.sql
F_setupDBEnv()
{
    export ODBCINI=${IMSS_HOME}/config/odbc.ini
    DB_USER=`F_ini_get ${ODBCINI} "IMSS" "UserName"`
    DB_SERVER=`F_ini_get ${ODBCINI} "IMSS" "Servername"`
    DB_NAME=`F_ini_get ${ODBCINI} "IMSS" "Database"`
    DB_PASSWD=`F_ini_get ${ODBCINI} "IMSS" "Password"`
    DB_PORT=`F_ini_get ${ODBCINI} "IMSS" "Port"`
    
    DB_USER=`echo ${DB_USER}`
    DB_SERVER=`echo ${DB_SERVER}`
    DB_NAME=`echo ${DB_NAME}`
    DB_PASSWD=`echo ${DB_PASSWD}`
    DB_PORT=`echo ${DB_PORT}`
    
    if [ -z "${DB_USER}" -o -z "${DB_SERVER}" -o -z "${DB_NAME}" -o -z "${DB_PASSWD}" -o -z "${DB_PORT}" ]; then
        F_log "Error: can not get DB information from ${ODBCINI}: UserName=${DB_USER}, Servername=${DB_SERVER}, Database=${DB_NAME}, Password=${DB_PASSWD}, Port=${DB_PORT}."
        exit 1
    fi
    
    DB_PASSWDPlain="`${IMSS_HOME}/bin/passwd_util -d ${DB_PASSWD}`"
    export PGPASSWORD="${DB_PASSWDPlain}"

    return 0
}

F_install()
{
  
    #SEG-70448
    #update AU server url in section Update in table tb_global_setting
    old_au_server_url=`${DB_PSQL} -U "${DB_USER}" -d "${DB_NAME}" -t -A -c "select value from tb_global_setting where inifile='imss.ini' and section='Update' and name='UpdateServer';"`
    
    old_tmase_server_url=`${DB_PSQL} -U "${DB_USER}" -d "${DB_NAME}" -t -A -c "select value from tb_global_setting where inifile='imss.ini' and section='Update' and name='TMASEServerurl';"`
    
    if [ -d "$TEMP_BACKUP_DBSQL_FOLDER" ] ; then
        F_log "$TEMP_BACKUP_DBSQL_FOLDER exist".
    else
        F_log "$TEMP_BACKUP_DBSQL_FOLDER does not exist, create it".
        mkdir -p $TEMP_BACKUP_DBSQL_FOLDER
    fi
    
    if [[ "$old_au_server_url" =~ ^http:.* ]]; then
        if [ -f "$OLD_AU_SERVER_URL_FILENAME" ] ; then
            rm -rf $OLD_AU_SERVER_URL_FILENAME
        fi
        echo ${old_au_server_url} >> $OLD_AU_SERVER_URL_FILENAME
        $DB_PSQL -U "${DB_USER}" -d "${DB_NAME}" -f $UPDATE_AU_SERVER_URL 
    else
        F_log "no need to update au server url."
    fi
    if [[ "$old_tmase_server_url" =~ ^http:.* ]]; then
        if [ -f "$OLD_TMASE_SERVER_URL_FILENAME" ] ; then
            rm -rf $OLD_TMASE_SERVER_URL_FILENAME
        fi
        echo ${old_tmase_server_url} >> $OLD_TMASE_SERVER_URL_FILENAME
        $DB_PSQL -U "${DB_USER}" -d "${DB_NAME}" -f $UPDATE_TMASE_SERVER_URL 
    else
        F_log "no need to update tmase server url."
    fi

    # delete .pgpass file
    if [ -f "${PGPASS}" ] ; then
        rm -f "${PGPASS}"
    fi

    return 0
}

F_rollback()
{        
    if [ -f "$OLD_AU_SERVER_URL_FILENAME" ] ; then
        old_au_server_url_txt=`cat "$OLD_AU_SERVER_URL_FILENAME"`
        $DB_PSQL -U "${DB_USER}" -d "${DB_NAME}" -c "update tb_global_setting set value='$old_au_server_url_txt' where inifile='imss.ini' and section='Update' and name='UpdateServer';"
        rm -rf $OLD_AU_SERVER_URL_FILENAME
    fi
    if [ -f "$OLD_TMASE_SERVER_URL_FILENAME" ] ; then
        old_tmase_server_url_txt=`cat "$OLD_TMASE_SERVER_URL_FILENAME"`
        $DB_PSQL -U "${DB_USER}" -d "${DB_NAME}" -c "update tb_global_setting set value='$old_tmase_server_url_txt' where inifile='imss.ini' and section='Update' and name='TMASEServerurl';"
        rm -rf $OLD_TMASE_SERVER_URL_FILENAME
    fi
    
    F_log "rollback success."
    return 0
}

####################################################################################################

F_setupDBEnv

case "$1" in
'install')
    F_install
    ;;
'rollback')
    F_rollback
    ;;
*)
	exit 0
    ;;
esac

