<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://www.springframework.org/tags" prefix="spring" %>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>


<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Untitled Document</title>
<meta content="text/html; utf-8" http-equiv="Content-Type" />
<link href="/css/left.css" type="text/css" rel="stylesheet"></link>
<link href="/css/jquery.autocomplete.css" type="text/css" rel="stylesheet"></link>
<script language="JavaScript" src="/javascripts/popup.js"></script>
<script language="JavaScript" src="/javascripts/jquery-1.4.min.js"></script>
<script language="JavaScript" src="/javascripts/jquery.autocomplete.js"></script>
<script id="TMCUBE_COMMON_JAVASCRIPT_FILE" language="JavaScript" Src="/javascripts/TmCube_Common.js"> </script>
<script id="CompJS" language="JavaScript">
var uicompList = new Array();

var TmCube_Navigation = new Object();
TmCube_Navigation.name = "Navigation";
TmCube_Navigation.onload = window.TmCube_Navigation_onload;
uicompList[uicompList.length] = TmCube_Navigation;
    

//Component: Navigation

//Global variables definition
/**
 *  Color of selected menu item.
 */
TmCube_Navigation_HIGHLIGHT = "#990000";

//Function definition
function TmCube_Navigation_activeMenu(element)
{
	var compObj = TmCube_getComponent(element);
	var curControl = TmCube_getControlName(element);
	var box = TmCube_getElement(compObj.name, "box");
	if (compObj.expandingAbility && /^multiple$/i.test(compObj.expandingAbility))
	{
		TmCube_Navigation_recoverCurrent(element);
		if (TmCube_Navigation_isExpanded(compObj, element))
		{
			TmCube_Navigation_expandingAbility(element);
			compObj.currentMenu = "";
		}
		else
		{
			TmCube_Navigation_expandMenu(element);
			compObj.currentMenu = "";
		}
		TmCube_Navigation_refreshTable(box);
		return false;
	}
	if (compObj.currentMenu == curControl)
	{
		TmCube_Navigation_recoverCurrent(element);
		TmCube_Navigation_refreshTable(box);
		return false;
	}
	TmCube_Navigation_recoverCurrent(element);
	TmCube_Navigation_expandMenu(element);
	TmCube_Navigation_refreshTable(box);
	return false;
}

function TmCube_Navigation_activeIcon(element)
{
	var compObj = TmCube_getComponent(element);
	var curControl = TmCube_getControlName(element);
	var cut = curControl.search(/_icon$/);
	if (cut == -1)
	{
             var msg =" <spring:message code="errors.nav.unkown_icon"/>";
	    alert(msg);
		return false;
	}
	var menuItem = curControl.slice(0, cut);
	var menuElement = TmCube_getElement(compObj.name, menuItem);
	if (menuElement && /a/i.test(menuElement.tagName))
	{
		TmCube_Navigation_activeMenu(menuElement);
	}
	return false;
}

function TmCube_Navigation_expandingAbility(element)
{
	var compObj = TmCube_getComponent(element);
	var prefix = compObj.name;
	var curControl = TmCube_getControlName(element);
	element.parentNode.className = "navinactive";
	var curItemsElem = TmCube_getElement(compObj.name, curControl + "_items");
	if (compObj.currentElement)
	{
		if (TmCube_Navigation_isContained(compObj.currentElement, curItemsElem))
		{
			compObj.curGroup = curControl;
			element.style.color = TmCube_Navigation_HIGHLIGHT;
		}
	}
	var curImgElem = TmCube_getElement(compObj.name, curControl + "_img");
	curItemsElem.style.display = "none";
	curImgElem.src = TmCube_getNormalURL("/images/<spring:message code="locale" />/os_nav_arrow_inactive_cui.gif");
}

function TmCube_Navigation_isContained(son, father)
{
	var htmlreg = /^html$/i;
	for (;son.parentNode != father && !htmlreg.test(son.tagName); son = son.parentNode);
	if (htmlreg.test(son.tagName))
	{
		return false;
	}
	return true;
}

function TmCube_Navigation_recoverCurrent(element)
{
	var compObj = TmCube_getComponent(element);
	var prefix = compObj.name;
	if (compObj.currentMenu)
	{
		var curElem = TmCube_getElement(prefix, compObj.currentMenu);
		var curItemsElem = TmCube_getElement(prefix, compObj.currentMenu + "_items");
		if (curItemsElem) //Means sub item exists
		{
			var curImgElem = TmCube_getElement(prefix, compObj.currentMenu + "_img");
			curElem.parentNode.className = "navinactive";
			if (compObj.currentElement && TmCube_Navigation_isContained(compObj.currentElement, curItemsElem))
			{
				compObj.curGroup = compObj.currentMenu;
			}
			curItemsElem.style.display = "none";
			curImgElem.src = TmCube_getNormalURL("/images/<spring:message code="locale" />/os_nav_arrow_inactive_cui.gif");
		}
		else //Means sub item not exists, just single menu
		{
			var curControl = TmCube_getControlName(element);
			if (compObj.currentMenu == curControl)
			{
				return;
			}
			curElem.parentNode.className = "navinactive";
			var curImgElem = TmCube_getElement(prefix, compObj.currentMenu + "_img");
			curImgElem.src = TmCube_getNormalURL("/images/<spring:message code="locale" />/arrow_inactive_space_cui.gif");
		}
		TmCube_Navigation_resetMenu(compObj, curElem);
		if (compObj.curGroup)
		{
			var curGroup = TmCube_getElement(compObj.name, compObj.curGroup);
			if (curGroup)
			{
				curGroup.style.color = TmCube_Navigation_HIGHLIGHT;
			}
		}
	}
	compObj.currentMenu = "";
	return;
}

function TmCube_Navigation_isExpanded(compObj, element)
{
	var id = TmCube_getControlName(element);
	var itemsElem = TmCube_getElement(compObj.name, id + "_items");
	return (itemsElem.style.display == "block");
}

function TmCube_Navigation_resetMenu(compObj, curElem)
{
	if (compObj.expandingAbility && (/^single$/i.test(compObj.expandingAbility) ||
		/^multiple$/i.test(compObj.expandingAbility)))
	{
		return;
	}
	var id = curElem.id;
	var curItemElem = TmCube_getElement(compObj.name, compObj.currentMenu + "_items");
	if (!curItemElem)
	{
		return;
	}
	var lastElem = compObj[id];
	if (!lastElem)
	{
		lastElem = document.createElement('tt');
		lastElem.id = curElem.id;
		lastElem.innerHTML = curElem.innerHTML;
	}
	var parent = curElem.parentNode;
	parent.replaceChild(lastElem, curElem);
	compObj[id] = curElem;
}

function TmCube_Navigation_expandMenu(element)
{
	//alert(element.);
	var compObj = TmCube_getComponent(element);
	var curControl = TmCube_getControlName(element);
	if (compObj.currentMenu == curControl)
	{
		compObj.currentMenu = "";
		return;
	}
	element.parentNode.className = "navactive";
	var curItemsElem = TmCube_getElement(compObj.name, curControl + "_items");
	var curImgElem = TmCube_getElement(compObj.name, curControl + "_img");
	curItemsElem.style.display = "block";
	curImgElem.src = TmCube_getNormalURL("/images/<spring:message code="locale" />/os_nav_arrow_active_cui.gif");
	compObj.currentMenu = curControl;
	TmCube_Navigation_resetMenu(compObj, element);
	if (compObj.curGroup && compObj.curGroup == curControl)
	{
		var curGroup = TmCube_getElement(compObj.name, compObj.curGroup);
		if (curGroup)
		{
			curGroup.style.color = "";
		}
	}
}

function TmCube_Navigation_processSingle(element)
{
	if (!TmCube_Navigation_checkChanging(element))
	{
		return false;
	}
	TmCube_Navigation_recoverCurrent(element);
	TmCube_Navigation_selectSingle(element);
	var box = TmCube_getElement(TmCube_getPrefix(element), "box");
	TmCube_Navigation_refreshTable(box);
	return true;
}

function TmCube_Navigation_selectSingle(element)
{
	var compObj = TmCube_getComponent(element);
	var curControl = TmCube_getControlName(element);
	if (compObj.currentMenu == curControl)
	{
		return;
	}
	element.parentNode.className = "navactivesingle";
	if (compObj.currentElement)
	{
		compObj.currentElement.style.color = "";
	}
	compObj.currentElement = element;
	compObj.currentElement.style.color = TmCube_Navigation_HIGHLIGHT;
	if (compObj.curGroup)
	{
		var curGroup = TmCube_getElement(compObj.name, compObj.curGroup);
		if (curGroup)
		{
			curGroup.style.color = "";
		}
		compObj.curGroup = "";
	}
	var curImgElem = TmCube_getElement(compObj.name, curControl + "_img");
	curImgElem.src = TmCube_getNormalURL("/images/<spring:message code="locale" />/arrow_space_cui.gif");
	compObj.currentMenu = curControl;
}

function TmCube_Navigation_refreshTable(node)
{
	if (TmCube_getBrowserType() == "NS")
	{
		if (/Netscape6\/6\.0/.test(navigator.userAgent))
		{
			node.setAttribute("height", "0");
		}
		else
		{
			var aNode = document.createTextNode("Temp");
			var parent = node.parentNode;
			parent.replaceChild(aNode, node);
			parent.replaceChild(node, aNode);
		}
	}
}

function TmCube_Navigation_isSingleMenuSelected(compObj)
{
	if (compObj.currentMenu)

	{
		var itemsElem = TmCube_getElement(compObj.name, compObj.currentMenu + "_items");
		return !itemsElem;
	}
	return false;
}

/**
 * Test whether the navigation can be redirect.
 */
function TmCube_Navigation_checkChanging(element)
{
	var compObj = TmCube_getComponent(element);
	if (!TmCube_Navigation_canChange(compObj, element))
		return false;
	TmCube_Navigation_selectMenuItem(compObj, element);
	return true;
}

function TmCube_Navigation_selectMenuItem(compObj, element)
{
	if (compObj.currentElement)
	{
		compObj.currentElement.style.color = "";
	}
	compObj.currentElement = element;
	element.style.color = TmCube_Navigation_HIGHLIGHT;
	var curGroup = TmCube_getElement(compObj.name, compObj.curGroup);
	if (curGroup)
	{
		curGroup.style.color = "";
		//compObj.curGroup = "";
	}
	if (TmCube_Navigation_isSingleMenuSelected(compObj))
	{
		TmCube_Navigation_recoverCurrent(element);
	}
        if(element.id =="Navigation__IBEEncrptRegst")
        {
                    var d_mask= top.left.document.getElementById('mask');
                    var d_scrollWidth = Math.max(top.left.document.documentElement.scrollWidth, top.left.document.body.scrollWidth);
                    var d_scrollHeight = Math.max(top.left.document.documentElement.scrollHeight, top.left.document.body.scrollHeight);
                    d_mask.style.width = d_scrollWidth;
                    d_mask.style.height=d_scrollHeight;
                    d_mask.style.display="";
        }
}

function TmCube_Navigation_canChange(compObj, element)
{
	var older = compObj.currentElement;
	if (compObj.pageChanging && element != older)
	{
		var result = compObj.pageChanging(element.href, (older)? older.href:null); 
		if (!result)
		{
			return false;
		}
	}
	return true;
}

/**
 * Given a menuitem name, and retrieve it's parent menu name.
 * Internal function. If paramenters is not valid, return null.
 * No exceptions. No error message.
 * @param compName component name
 * @param itemName name attribute of menuitem.
 * @return a string represent the name  of  parent menu(component name has been stripped). If null, there are two possibilities:
 *              1. Parameters may be null; 2. Could not found the parent element; 3. the parent element name is corrupt.
 */
function TmCube_Navigation_getParentName(compName, itemName)
{
	if (!compName || !itemName)
	{
		return null;
	}
	var fullName = compName + "__" + itemName;
	var elem = document.getElementById(fullName);
    for (;elem && (!elem.id || !/_items$/.test(elem.id));elem = elem.parentNode);
    if (!elem)
    {
        return null;
    }
	var controlName = TmCube_getControlName(elem);
	if (!controlName)
	{
		return null;
	}
	return controlName.slice(0, controlName.search(/_items$/));
}

/**
 * Jump to the menu item and adjust navigation current selected item to the right one.
 * API function. Requires that parameters are exact, otherwise show exception dialog to user. no error dialog.
 * @param itemName name attribute of menuitem or menu. If its menu name. the menu must be single menu.
 * @param compName component name. if it's null, treat it as default component name "Navigation".
 * @return none.
 */
function TmCube_Navigation_goTo(itemName, compName, noJump)
{
	if (!compName)
	{
		compName = "Navigation";
	}
	if (noJump === false)
	{
		noJump = false;
	}
	else
	{
		noJump = true;
	}
	var compObj = TmCube_getComponentByPrefix(compName);
	try
	{
		if (compObj)
		{
			var controlName = TmCube_Navigation_getParentName(compName, itemName);
			if (controlName)
			{
				TmCube_Navigation_goToSubItem(compObj, controlName, itemName, noJump);
			}
			else if (TmCube_Navigation_isSingleItem(compName, itemName))
			{
				TmCube_Navigation_goToSingleMenu(compObj, itemName, noJump);
			}
			else
			{
				throw "The menu item could not be found, Please recheck the parameters of this function";
			}
		}
	}
	catch (e)
	{
		alert ("Exception occurred:\n" + e);
	}
}

/**
 * Goto sub mene item. 
 * Internal function. Require that all parameters are reliable. Throw exceptions. No error message.
 * @param compObj component object.
 * @param controlName parent menu name(id).
 * @param itemName single menu item name (single menu is the level one menu item)
 * @param noJump If true, open the menu link, default is false.
 * @return none.
 * @throw exception if no element which corresponds to parent menu doesn't exist.
 */
function TmCube_Navigation_goToSubItem(compObj, controlName, itemName, noJump)
{
	var elem = TmCube_getElement(compObj.name, controlName);
	if (elem ) 
	{
		var itemElem = TmCube_getElement(compObj.name, itemName);
		if (TmCube_Navigation_canChange(compObj, itemElem))
		{
			if (compObj.currentMenu != controlName)
			{
					/* For multiple navigation only. if the menu has expanded, skipping the click simulation.*/
					if (!/^multiple$/i.test(compObj.expandingAbility) || !TmCube_Navigation_isExpanded(compObj, elem))
					{
						TmCube_Navigation_activeMenu(elem);
					}
			}
			TmCube_Navigation_selectMenuItem(compObj, itemElem);
			if (!noJump)
			{
				window.open(unescape(itemElem.href), itemElem.target);			
			}
		}
	}
	else
	{
		throw "No parent menu found : " + compObj.name + "__" + controlName;
	}
}

/**
 * Determine whether the target item is a single menu (in the first menu level).
 * Internal function. If parameters is not valid, return false. No exception. No error message.
 * @param compName component name.
 * @param itemName single menu item name (single menu is the level one menu item)
 * @return if true, item is single menu.
 */
function TmCube_Navigation_isSingleItem(compName, itemName)
{
	var elem = TmCube_getElement(compName, itemName);
	if (elem && /^a$/i.test(elem.tagName))
	{
		if ("IE" == TmCube_getBrowserType())
		{
			if (typeof elem.onclick == "function" && elem.onclick.toString().indexOf("return TmCube_Navigation_processSingle(this);"))
			{
				return true;
			}
		}
		else if ("NS" == TmCube_getBrowserType())
		{
			var onclickHandler;
			if ((onclickHandler = elem.getAttribute('onclick')) && (onclickHandler.indexOf("return TmCube_Navigation_processSingle(this);") != -1))
			{
				return true;
			}
		}
	}
	return false;
}

/**
 * Goto the single menu.
 * Internal function.Do nothing if parameters is not valid. Throw exceptions. No error message. 
 * @param compObj component object.
 * @param itemName single menu item name (single menu is the level one menu item)
 * @param noJump If false, open the menu link, default is false.
 * @return none.
 * @throw exception if the element which represents the single menu does not exist.
 */
function TmCube_Navigation_goToSingleMenu(compObj, itemName, noJump)
{
	if (compObj.currentMenu != itemName)
	{
		var elem = TmCube_getElement(compObj.name, itemName);
		if (elem && elem.href)
		{
			if (TmCube_Navigation_processSingle(elem) && !noJump)
			{
				window.open(unescape(elem.href), elem.target);			
			}
		}
		else
		{
			throw "No single menu found : " + compObj.name + "__" + itemName;
		}
	}
}

function TmCube_Navigation_onload()
{
	document.body.style.backgroundColor = "#EDEEEC";
	document.body.style.color = "#000000";
	document.body.style.marginLeft = "0";
	document.body.style.marginTop = "0";
	document.body.style.marginRight = "0";
	document.body.style.paddingRight = "0";
	TmCube_resolveURLAttributes(TmCube_getElement(this.name, "box"), new Array("td", "background"));
	this.currentMenu = "";
	if (this.defaultMenu)
	{
		TmCube_Navigation_goTo(this.defaultMenu, this.name, false);
	}
	if (TmCube_getBrowserType() != "IE")
	{
		self.resizeBy(0, -2);
		window.setTimeout("window.self.resizeBy(0,2)", 1);
	}
}

</script>
<script language="JavaScript">
function checkMenu(element){
	var compObj = TmCube_getComponent(element);
	var curControl = TmCube_getControlName(element);
	if(compObj.currentMenu == curControl)
	   return true;
	return false;
}
function smartSearch_activeMenu(type){
	switch(type){
		case '1':
		    TmCube_Navigation_processSingle(document.getElementById("Navigation__Summary"));
		    break;
		case '2':
		    if(!checkMenu(document.getElementById("Navigation__Policy")))
		        TmCube_Navigation_activeMenu(document.getElementById("Navigation__Policy"));
		    break;
		case '3': 
		    if(!checkMenu(document.getElementById("Navigation__IPFiltering")))
		        TmCube_Navigation_activeMenu(document.getElementById("Navigation__IPFiltering"));
		    break;
		case '4':
		    if(!checkMenu(document.getElementById("Navigation__Reports")))
				    TmCube_Navigation_activeMenu(document.getElementById("Navigation__Reports"));
		    break;
		case '5':
		    if(!checkMenu(document.getElementById("Navigation__Logs")))
			      TmCube_Navigation_activeMenu(document.getElementById("Navigation__Logs"));	  
		    break;
		case '6':
		    if(!checkMenu(document.getElementById("Navigation__QuarantineArchive")))	
					  TmCube_Navigation_activeMenu(document.getElementById("Navigation__QuarantineArchive"));	  
		    break;
		case '7':
		    if(!checkMenu(document.getElementById("Navigation__Administration")))
					  TmCube_Navigation_activeMenu(document.getElementById("Navigation__Administration"));				
		    break;
		case '8':
				TmCube_Navigation_processSingle(document.getElementById("Navigation__Prefilter"));				
		    break;
                case '9':
				TmCube_Navigation_processSingle(document.getElementById("Navigation__SRealtime"));
		    break;
                case '10':
				TmCube_Navigation_processSingle(document.getElementById("Navigation__SSystem"));
		    break;
		case '0':
		    break;
	}
}
function findValue(li) {
	if (li == null) return alert("No match!");
	if(li.extra) 
		var sValue = li.extra[1];
	else 
		var sValue = li.selectValue;
	document.getElementById("SmartSearch").value="";
	smartSearch_activeMenu(li.extra[2]);
	if(document.getElementById(li.extra[0]) != null)
	  TmCube_Navigation_checkChanging(document.getElementById(li.extra[0]));
	eval(sValue);
	document.getElementById("SmartSearch").focus();
//	var newcookie;
//	newcookie = li.selectValue + "|" + li.extra[0] + "|" + li.extra[1] + "\r\n";
//	if ($.cookie("SmartSearch").indexOf(newcookie) == -1)
//		$.cookie("SmartSearch", $.cookie("SmartSearch")+newcookie);
}

function selectItem(li) {
        findValue(li);
}

function formatItem(row, i, num) {
	return row[0];

}

function checkRight(type) {

	var isShow = false;
	switch(type)
	{
		case '1':
		    <c:if test="${adminUser.showSummary}">
		        isShow = true;
		    </c:if>
		    break;
		case '2':
			  <c:if test="${adminUser.showPolicy}">
		        isShow = true;
		    </c:if>
		    break;
		case '3':
				<c:if test="${adminUser.showIPFiltering}">
		        isShow = true;
		    </c:if>
		    break;
		case '4':
			  <c:if test="${adminUser.showReports}">
		        isShow = true;
		    </c:if>
		    break;
		case '5':
				<c:if test="${adminUser.showLogs}">
		        isShow = true;
		    </c:if>
		    break;
		case '6':
				<c:if test="${adminUser.showQuarantines}">
		        isShow = true;
		    </c:if>
		    break;
		case '7':
				<c:if test="${adminUser.showSystem}">
		        isShow = true;
		    </c:if>
		    break;
		case '8':
				<c:if test="${adminUser.showPrefilter}">
		        isShow = true;
		    </c:if>
		    break;
                    case '9':
		    <c:if test="${adminUser.showSummary}">
		        isShow = true;
		    </c:if>
		    break;
                    case '10':
		    <c:if test="${adminUser.showSummary}">
		        isShow = true;
		    </c:if>
		    break;
		case '0':
				    isShow = true;
		    break;
	}
	return isShow;
}


function SmartSearchInit()
{
	var search_keyword = "<spring:message code="label.smart.search.box" />";
	$("#SmartSearch").autocomplete(
		"smartSearchList.imss",
	{
		delay:10,
		minChars:1,
		matchSubset:1,
		matchContains:1,
		cacheLength:10,
		onItemSelect:selectItem,
		onFindValue:findValue,
		formatItem:formatItem,
		autoFill:false,
		maxItemsToShow:5, 
		title:search_keyword,
		width:"165",
		marginLeft:"30",
		checkRight:checkRight
	});
}
</script>
</head>
<body onLoad="TmCube_uiInitial(); SmartSearchInit();">
  <div id="mask" style="display: none; z-index: 1000; position: absolute;left: 0px; top: 0px; height:100%;width:100%;  background-color: #cccccc;opacity:.0;filter: alpha(opacity:0);	"></div>
<div style="background-color:#A8A8A8; position:absolute; left:178; top:0px; width:1px; height:100%; padding:0px; margin: 0px"></div>
<table id="Navigation__box" width="179" border="0" bgcolor="#EDEEEC" cellpadding="0" cellspacing="0">
  
  <tr>
    <td height="20px">&nbsp;</td>
  </tr>
  <tr>
    <td height="25px">
      <div style="height:22px;border:1px solid;border-color:#dddddd;width:165px;background:#ffffff;margin-left:5px; margin-right:5px;">
        <img src="/images/<spring:message code="locale" />/s_cui.gif" border="0" align="left" width="20" height="20" style="margin-left: 5px;vertical-align:middle;" />
	      <input type="text" id="SmartSearch" autocomplete="off" style="width: 108px; vertical-align:middle;"/>
        <img src="/images/<spring:message code="locale" />/x_cui.gif" border="0" width="20" height="20" id="closeButton" style="visibility:hidden;vertical-align:middle;" onclick="this.style.visibility='hidden';$('#SmartSearch').focus();" />
      </div>
    </td>
  </tr>
  <tr>
    <td height="5px"></td>
  </tr>
  <tr>
    <td style="width:1px" valign="top" bgcolor="#A8A8A8"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
  </tr>
  <c:if test="${adminUser.showSummary}" >
  <tr>
    <td><table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td class="navinactive" height="20px"><a><img width="7px" border="0" height="9px" id="Navigation__SRealtime_img" src="/images/<spring:message code="locale" />/arrow_inactive_space_cui.gif"></img></a>&nbsp;<a target="right" onClick="return TmCube_Navigation_processSingle(this);" id="Navigation__SRealtime" href="/showWidgetPage.imss"><spring:message code="label.nav.dashboard" /></a></td>
        </tr>
      </table></td>
  </tr>
  </c:if>

  <c:if test="${adminUser.showSummary}" >
  <tr>
    <td><table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td class="navinactive" height="20px"><a><img width="7px" border="0" height="9px" id="Navigation__SSystem_img" src="/images/<spring:message code="locale" />/arrow_inactive_space_cui.gif"></img></a>&nbsp;<a target="right" onClick="return TmCube_Navigation_processSingle(this);" id="Navigation__SSystem" href="/initSummaryPage.imss"><spring:message code="label.nav.systemsummary" /></a></td>
        </tr>
      </table></td>
  </tr>
  </c:if>

  <c:if test="${adminUser.showPrefilter}" >
  <tr>
    <td><table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td class="navinactive" height="20px"><a><img width="7px" border="0" height="9px" id="Navigation__Prefilter_img" src="/images/<spring:message code="locale" />/arrow_inactive_space_cui.gif"></img></a>&nbsp;<a target="right" onClick="return TmCube_Navigation_processSingle(this);" id="Navigation__Prefilter" href="/prefilterEntry.imss"><spring:message code="label.nav.prefilter" /></a></td>
        </tr>
      </table></td>
  </tr>
  </c:if>
  
   <c:if test="${adminUser.showPolicy}" >
  <tr>
    <td><table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td class="navinactive" height="20px"><a target="right" onClick="return TmCube_Navigation_activeIcon(this)" href="#" id="Navigation__Policy_icon"><img width="7px" border="0" height="9px" id="Navigation__Policy_img" src="/images/<spring:message code="locale" />/os_nav_arrow_inactive_cui.gif"></img></a>&nbsp;<a target="right" onClick="return TmCube_Navigation_activeMenu(this)" href="#" id="Navigation__Policy"><spring:message code="label.nav.policy" /></a></td>
        </tr>
        <tr id="Navigation__Policy_items" style="display:none;margin:0;padding:0;">
          <td style="margin:0;padding:0;"><div style="margin:0;padding:0;">
              <table style="margin:0;padding:0;" border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/leftbk2_cui.gif"><img width="179" height="4" src="/images/<spring:message code="locale" />/leftbk2_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__ListOfPolicies" href="/initRuleList.imss"><spring:message code="label.nav.policyList" /></a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__ScanningExceptions" href="/scanExcpAction.imss"><spring:message code="label.nav.scanExcp" /></a></td>
                </tr>
		        <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__CommonObj_DKIMApprovedList" href="/initDKIMSetting.imss"><spring:message code="label.nav.whitelist" /></a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <!-- add for common object-->
                <tr>
                  <td class="subnav" height="20"><spring:message code="label.nav.Common" /></td>
                </tr>
                
                <tr>
                  <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__CommonObj_AddressGroups" href="/detailAddrGroup.imss"><spring:message code="label.nav.addressgroup" /></a></td>
                </tr>
             
                <c:if test="${platform=='windows'}">
                <tr>
                  <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__CommonObj_BATVKey" href="/initBATVKeySetting.imss"><spring:message code="label.nav.batvKey" /></a></td>
                </tr>
                </c:if> 
                
                <tr>
                  <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__CommonObj_KeywordsExpressions" href="/initRuleAttrKeywordlist.imss?outlist=outlist"><spring:message code="label.nav.keywordList" /></a></td>
                </tr>
          
                <tr>
                  <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__CommonObj_ComplianceTemplates" href="/initComplianceTemplate.imss"><spring:message code="label.nav.complianceTemplates" /></a></td>
                </tr>
                <tr>
                  <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__DLP_Date_Identifiers" href="/initExpression.imss"><spring:message code="label.nav.dataIdentifiers"/></a></td>
                </tr>  
                <tr>
                  <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__CommonObj_Notifications" href="/initRuleActionNotifyList.imss?outlist=outlist"><spring:message code="label.nav.notifyList" /></a></td>
                </tr>

                <tr>
                  <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__CommonObj_Stamps" href="/initRuleActionStampsList.imss?outlist=outlist"><spring:message code="label.nav.stamps" /></a></td>
                </tr>
                <!-- add for common object-->        

                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                 <tr>
	            <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__ScanMode" href="/initScanModePage.imss"><spring:message code="label.nav.scanmode" /></a></td>
	        </tr>
                 <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__InternalAddresses" href="/initPolicyIntGrps.imss"><spring:message code="label.nav.intAddr" /></a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__SmartProtection" href="/initSmartProtectionScanServicePage.imss"><spring:message code="label.nav.smartProtection" /></a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
	              <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__DDAConfiguration" href="/initDDASettingPage.imss"><spring:message code="label.nav.ddaconfiguration" /></a></td>
	            </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                 <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__IBEEncrptRegst" href="/ibeentry.imss"><spring:message code="label.nav.ibeEncrptRgst.left" /></a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__ClickProtection" href="/initClickProtectionPage.imss"><spring:message code="label.nav.clickProtection" /></a></td>
                </tr>
                <tr>
                  <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #999999;"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
              </table>
            </div></td>
        </tr>
      </table></td>
  </tr>
  </c:if>

  <c:if test="${adminUser.showIPFiltering and (uiStates.hasIPFiltering or uiStates.hasNRS)}">
  <tr>
    <td><table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td class="navinactive" height="20px"><a target="right" onClick="return TmCube_Navigation_activeIcon(this)" href="#" id="Navigation__IPFiltering_icon"><img width="7px" border="0" height="9px" id="Navigation__IPFiltering_img" src="/images/<spring:message code="locale" />/os_nav_arrow_inactive_cui.gif"></img></a>
          <a target="right" onClick="return TmCube_Navigation_activeMenu(this)" href="#" id="Navigation__IPFiltering"> <spring:message code="label.nav.ipfilter" /></a></td>
        </tr>
        <tr id="Navigation__IPFiltering_items" style="display:none;margin:0;padding:0;">
          <td style="margin:0;padding:0;"><div style="margin:0;padding:0;">
              <table style="margin:0;padding:0;" border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/leftbk2_cui.gif"><img width="179" height="4" src="/images/<spring:message code="locale" />/leftbk2_cui.gif"></img></td>
                </tr>
				<c:if test="${uiStates.hasIPFiltering}">
				<tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__Overview" href="/ip_overview.imss"><spring:message code="label.nav.overview"/></a></td>
                </tr>
				<tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
			    </tr>
				</c:if>
				<c:if test="${uiStates.hasIPFiltering}">
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__IRules" href="/ip_setting_spam_query.imss"><spring:message code="label.nav.ipsetting" /></a></td>
                </tr>
				
				<tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
				</c:if>
				<c:if test="${uiStates.hasNRS}">
				<tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__NRS" href="/ip_nrs_setting_query.imss"><spring:message code="label.nav.nrs"/></a></td>
                </tr>
				

                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
				</c:if>
				<c:if test="${uiStates.hasIPFiltering or uiStates.hasNRS}">
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__Whitelist" href="/ip_approvedlist.imss"><spring:message code="label.nav.whitelist"/> </a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
				</c:if>
                <c:if test="${uiStates.hasIPFiltering}">
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__Blocklist" href="/ip_blocked.imss"><spring:message code="label.nav.blocklist"/></a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
				</c:if>
				<c:if test="${uiStates.hasIPFiltering}">
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__CachedIP" href="/ip_cached_query.imss"><spring:message code="label.nav.catchedip"/></a></td>
                </tr>
				</c:if>
                <tr>
                  <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #999999;"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
              </table>
            </div></td>
        </tr>
      </table></td>
  </tr>
  </c:if>
  <c:if test="${adminUser.showReports}" >
  <tr>
    <td><table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td class="navinactive" height="20px"><a target="right" onClick="return TmCube_Navigation_activeIcon(this)" href="#" id="Navigation__Reports_icon"><img width="7px" border="0" height="9px" id="Navigation__Reports_img" src="/images/<spring:message code="locale" />/os_nav_arrow_inactive_cui.gif"></img></a>&nbsp;<a target="right" onClick="return TmCube_Navigation_activeMenu(this)" href="#" id="Navigation__Reports"><spring:message code="label.nav.report" /></a></td>
        </tr>
        <tr id="Navigation__Reports_items" style="display:none;margin:0;padding:0;">
          <td style="margin:0;padding:0;"><div style="margin:0;padding:0;">
              <table style="margin:0;padding:0;" border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/leftbk2_cui.gif"><img width="179" height="4" src="/images/<spring:message code="locale" />/leftbk2_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__OneTimeReports" href="/reports_onetimePage.imss"><spring:message code="label.nav.oneTimeReport" /></a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__ScheduledReports" href="/reports_schedPage.imss"><spring:message code="label.nav.schdReport" /></a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__RSettings" href="/reports_settingsPage.imss"><spring:message code="label.nav.rptSetting" /></a></td>
                </tr>
                <tr>
                  <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #999999;"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
              </table>
            </div></td>
        </tr>
      </table></td>
  </tr>
  </c:if>
  


  <c:if test="${adminUser.showLogs}" >
  <tr>
    <td><table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td class="navinactive" height="20px"><a target="right" onClick="return TmCube_Navigation_activeIcon(this)" href="#" id="Navigation__Logs_icon"><img width="7px" border="0" height="9px" id="Navigation__Logs_img" src="/images/<spring:message code="locale" />/os_nav_arrow_inactive_cui.gif"></img></a>&nbsp;<a target="right" onClick="return TmCube_Navigation_activeMenu(this)" href="#" id="Navigation__Logs"><spring:message code="label.nav.log" /></a></td>
        </tr>
        <tr id="Navigation__Logs_items" style="display:none;margin:0;padding:0;">
          <td style="margin:0;padding:0;"><div style="margin:0;padding:0;">
              <table style="margin:0;padding:0;" border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/leftbk2_cui.gif"><img width="179" height="4" src="/images/<spring:message code="locale" />/leftbk2_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__LQuery" href="/left_logsPage.imss"><spring:message code="label.nav.logQuery" /></a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__LSettings" href="/initLogSettings.imss"><spring:message code="label.nav.logSetting" /></a></td>
                </tr>
                <c:if test="${appliance=='yes'}">
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__SyslogServerSettings" href="/initSyslogServerSettings.imss"><spring:message code="label.nav.syslogSetting" /></a></td>
                </tr>				
                </c:if>
                <tr>
                  <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #999999;"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
              </table>
            </div></td>
        </tr>
      </table></td>
  </tr>
  </c:if>
  
  <c:if test="${adminUser.showQuarantines}" >
  <tr>
    <td><table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td class="navinactive" height="20px"><a target="right" onClick="return TmCube_Navigation_activeIcon(this)" href="#" id="Navigation__QuarantineArchive_icon"><img width="7px" border="0" height="9px" id="Navigation__QuarantineArchive_img" src="/images/<spring:message code="locale" />/os_nav_arrow_inactive_cui.gif"></img></a>&nbsp;<a target="right" onClick="return TmCube_Navigation_activeMenu(this)" href="#" id="Navigation__QuarantineArchive"><spring:message code="label.nav.quarantine" /></a></td>
        </tr>
        <tr id="Navigation__QuarantineArchive_items" style="display:none;margin:0;padding:0;">
          <td style="margin:0;padding:0;"><div style="margin:0;padding:0;">
              <table style="margin:0;padding:0;" border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/leftbk2_cui.gif"><img width="179" height="4" src="/images/<spring:message code="locale" />/leftbk2_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__QQuery" href="/initQtQueryPage.imss"><spring:message code="label.nav.quaQuery" /></a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__QSettings" href="/initQtSettingsPage.imss"><spring:message code="label.nav.quaSetting" /></a></td>
                </tr>
                <tr>
                  <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #999999;"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
              </table>
            </div></td>
        </tr>
      </table></td>
  </tr>
  </c:if>
  
  <c:if test="${adminUser.showQuarantines and enableSendmailMgmt}" >
  <tr>
    <td><table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td class="navinactive" height="20px"><a target="right" onClick="return TmCube_Navigation_activeIcon(this)" href="#" id="Navigation__Mta_icon"><img width="7px" border="0" height="9px" id="Navigation__Mta_img" src="/images/<spring:message code="locale" />/os_nav_arrow_inactive_cui.gif"></img></a>&nbsp;<a target="right" onClick="return TmCube_Navigation_activeMenu(this)" href="#" id="Navigation__Mta"><spring:message code="label.nav.mtaSendmail" /></a></td>
        </tr>
        <tr id="Navigation__Mta_items" style="display:none;margin:0;padding:0;">
          <td style="margin:0;padding:0;"><div style="margin:0;padding:0;">
              <table style="margin:0;padding:0;" border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/leftbk2_cui.gif"><img width="179" height="4" src="/images/<spring:message code="locale" />/leftbk2_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__QQuery" href="/initMtaSummary.imss"><spring:message code="label.nav.mtaSummary" /></a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__QSettings" href="/initMtaQuery.imss"><spring:message code="label.nav.mtaQuery" /></a></td>
                </tr>
                <tr>
                  <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #999999;"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
              </table>
            </div></td>
        </tr>
      </table></td>
  </tr>
  </c:if>

  <c:if test="${adminUser.showSystem || adminUser.usingIMSSAuth}">
  <tr>
    <td><table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr>
          <td class="navinactive" height="20px"><a target="right" onClick="return TmCube_Navigation_activeIcon(this)" href="#" id="Navigation__Administration_icon"><img width="7px" border="0" height="9px" id="Navigation__Administration_img" src="/images/<spring:message code="locale" />/os_nav_arrow_inactive_cui.gif"></img></a>&nbsp;<a target="right" onClick="return TmCube_Navigation_activeMenu(this)" href="#" id="Navigation__Administration"><spring:message code="label.nav.admin" /></a></td>
        </tr>
        <tr id="Navigation__Administration_items" style="display:none;margin:0;padding:0;">
          <td style="margin:0;padding:0;"><div style="margin:0;padding:0;">
              <table style="margin:0;padding:0;" border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/leftbk2_cui.gif"><img width="179" height="4" src="/images/<spring:message code="locale" />/leftbk2_cui.gif"></img></td>
                </tr>

                <c:if test="${adminUser.showSystem}" >
                        <tr>
                            <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__Proxy" href="/initUpdProxyPage.imss"><spring:message code="label.nav.proxy" /></a></td>
                        </tr>
                       <tr>
	                         <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
	                     </tr>   
	                <tr>
	                  <td class="subnav"><spring:message code="label.nav.update" /></td>
	                </tr>
	                <tr>
	                  <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__Updates" href="/initUpdSchPage.imss"><spring:message code="label.nav.auupdates" /></a></td>
	                </tr>
	                <tr>
	                  <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__Patch" href="/initPatchPage.imss"><spring:message code="label.nav.patch" /></a></td>
	                </tr>

	               <tr>
	                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
      		        </tr>
                <c:if test="${adminUser.root}" >
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__EndUserAcess" href="/initEuqMgr.imss"><spring:message code="label.nav.adminEuq" /></a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
              </c:if>
			  <tr>
	                 <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__Notifications" href="/initNotiEventPage.imss"><spring:message code="label.nav.notify" /></a></td>
	               </tr>
  			  <tr>
                        <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                	  </tr>

	                <tr>
	                  <td class="subnav"><spring:message code="label.nav.adminImssCfg" /></td>
	                </tr>
	                <c:if test="${uiStates.hasSMTP}">
		                <tr>
		                  <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__SMTPRouting" href="/initSMTPSetting.imss"><spring:message code="label.nav.mta" /></a></td>
		                </tr>
	                </c:if>
	                <tr>
	                  <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__Connections" href="/initConnBasicPage.imss"><spring:message code="label.nav.connect" /></a></td>
	                </tr>
                    <!-- leilu start -->
	                <tr>
	                  <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__DBMaintain" href="/initDbMaintainPage.imss"><spring:message code="label.nav.db_maintenance" /></a></td>
	                </tr>
                    <!-- leilu end -->
	                <c:if test="${appliance=='yes'}">
                    <tr>
                      <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__TLSSeting" href="/initTLSSettings.imss"><spring:message code="label.nav.TlsSetting" /></a></td>
                    </tr>
                    </c:if>
                    <c:if test="${appliance=='yes'}">
                    <tr>
                      <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__DKIMSignature" href="/initSignDomainPage.imss"><spring:message code="label.nav.DkimSignature" /></a></td>
                    </tr>
                    </c:if>
                    <tr>
                        <td class="subnav2" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__InternalHost" href="/initInternalHostPage.imss"><spring:message code="label.nav.internalHost" /></a></td>
                    </tr>
	                <tr>
	                  <td class="subnav2" height="20"><a target="right" onClick="NewWindowRnd('/initConfigWizard.imss','ConfigWiz','720','455','yes');return false;" href="/initConfigWizard.imss" id="Navigation__ConfigWizard"><spring:message code="label.nav.adminCfgWizard" /></a><img src="/images/<spring:message code="locale" />/icon_popup.gif"></td>
	                </tr>
	                <tr>
	                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
	                </tr>
                    <!-- leilu start-->
                    <c:if test="${adminUser.showSystem}">
                    <tr>
	                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__Backup" href="/initBackupPage.imss"><spring:message code="label.nav.backup" /></a></td>
	                </tr>
                    <tr>
                      <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                    </tr>
                	</c:if>
                    <!-- leilu end-->
		</c:if>
		
		<c:if test="${adminUser.root}" >
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__AdminAccts" href="/displayAdminList.imss"><spring:message code="label.nav.adminAcct" /></a></td>
                </tr>
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
              </c:if>
              
              <c:if test="${adminUser.usingIMSSAuth}">
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__Password" href="/initChangePwd.imss"><spring:message code="label.nav.adminPwd" /></a></td>
                </tr>
              </c:if>
              <c:if test="${adminUser.root}" >
                <tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__ProductLicenses" href="/initPRpage.imss"><spring:message code="label.nav.adminProdLic" /></a></td>
                </tr>
                </c:if>
               <c:if test="${adminUser.showSystem}" >
               	<tr>
                  <td bgcolor="#FFFFFF" background="/images/<spring:message code="locale" />/dot_cui.gif"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
                <tr>
                  <td class="subnav" height="20"><a target="right" onClick="return TmCube_Navigation_checkChanging(this)" id="Navigation__SPN" href="/initSPN.imss"><spring:message code="label.nav.SPN" /></a></td>
                </tr>
               </c:if>
                <tr>
                  <td style="border-bottom-style: solid; border-bottom-width: 1px; border-bottom-color: #999999;"><img height="1px" src="/images/<spring:message code="locale" />/1space_cui.gif"></img></td>
                </tr>
              </table>
            </div></td>
        </tr>
      </table></td>
  </tr>
  </c:if>
  
</table>
</body>

</html>
