<%@ page contentType="text/html;charset=utf-8" language="java" %>
<%@ taglib uri="http://www.springframework.org/tags" prefix="spring" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%-- 
    Document   : sys_updates_proxy
    Created on : 2010-7-27, 10:36:55
    Author     : jason_wang
--%>
<script language="JavaScript" src="/javascripts/validation.jsp"></script>
<script type='text/javascript' src='/javascripts/jquery-1.4.js'></script>
<script language="JavaScript" type="text/JavaScript">  
    function checkPermission()
    {
        <c:if test="${adminUser.systemReadOnly}" >
        var form = document.forms[0];      
        for (i=0; i<form.elements.length; i++) {
            form.elements[i].disabled = true;
        }	
        </c:if>
    }
    
    function checkBError() {
            <c:if test="${ !empty ActUpdError}" var="errmsg" scope="request">
            alert("<c:out value='${ActUpdError}' />");
            </c:if>
        }
        
        function checkproxy()
        {
            if(!document.forms[0].useProxy.checked)
                {
                    document.forms[0].proxyAddr.disabled=true;
                    document.forms[0].proxyPort.disabled=true;
                    document.forms[0].proxyUserName.disabled=true;
                    document.forms[0].proxyPwd.disabled=true;
                    document.forms[0].proxyType.disabled=true;
                }
                else
                    {
                        document.forms[0].proxyAddr.disabled=false;
                        document.forms[0].proxyPort.disabled=false;
                        document.forms[0].proxyUserName.disabled=false;
                        document.forms[0].proxyPwd.disabled=false;
                        document.forms[0].proxyType.disabled=false;
                    }
                    showNote();
                }
                
                function validateFields() {  
                    var form = document.forms[0]; 
                    var addr = form.proxyAddr.value;
                    var port = form.proxyPort.value;
                    
                    if (form.useProxy.checked) {
                        if (!checkProxyServerName(form.proxyAddr)) {
                            form.proxyAddr.select();
                            form.proxyAddr.focus();
                            alert("<spring:message code="errors.sys.upd.invalidPxySvr" />");
                                return false;
                            }
                            
                            if (!checkport(form.proxyPort)) {
                                return false;
                            }
                            
                        }
                        
                        return true;
                    }
                    
                    function checkProxyServerName(objName)
                    {
                        var datafield = objName;
                        if (objName.value.length==0)
                            {
                                datafield.select();
                                return false;
                            }
                            
                            var strVal = objName.value;
                            var hostNamePatt = /[a-zA-Z0-9_-]+/;
                            if(strVal.match(hostNamePatt) )
                                return true;
                            
                            
                            if (isValidIPAddress(objName.value) || objName.value=="localhost" 
                                || isValidateIPv6Address(objName.value) || FSfncValidateDomain(objName))
                            {
                                return true;        
                            }
                            
                            
                            return false;
                            
                        }
                        
                        function LockButtons()  {
                            var form =  document.forms[0];
                            form.submitbtn.disabled = true;     
                            return true;
                        }
                        
                        function showNote(){                            
                            if(!document.forms[0].useProxy.checked) {
                                $('#note_id').hide();
                                return;
                            }
                            var selected = document.forms[0].proxyType.value;
                            var noteMsg = "";
                            if(selected == "socks4") {
                                noteMsg = '<spring:message code="sys.upd.msg.prxy.note.socks4" />';
                            }
                            else if (selected == "socks5") {
                                noteMsg = '<spring:message code="sys.upd.msg.prxy.note.socks5" />';
                            }
                            else {
                                noteMsg = '<spring:message code="sys.upd.msg.prxy.note.http" />';
                            }
                            $('#note_id').show();	
                            $('#note_msg').html(noteMsg);
                        }
                        </script>
<html>
    <head>
        <title></title>
        <link rel="stylesheet" type="text/css" href="../css/trend-style.css">
        <base target="_self">
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    </head>
    <BODY leftmargin="0" topmargin="0" marginwidth="0" onload="checkBError();checkPermission();checkproxy();">
        <form:form modelAttribute="updProxyForm" name="updProxyForm" action="/saveProxySetting.imss" onsubmit="return LockButtons()" >
            <table cellspacing=0 cellpadding=0 width=540 border=0>
                <tbody>
                    <tr> 
                        <td class="content-title"><spring:message code="sys.upd.label.proxy" /><br> </td>
                        <td valign="bottom"> <div align="right">	<a href="/help/<spring:message code='locale' />/<spring:message code='olh.system.sys_proxy_setting'/>" target="_blank"><img src="/images/<spring:message code="locale" />/question_cui.gif" width="16" height="16" border="0"></a></div></td>
                    </tr>
                    <tr> 
                        <td height="10" colspan="2" class="hor-dotted-line"><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10"></td>
                    </tr>
                    <tr> 
                        <td height="10" colspan="2"><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10">
                    </tr>
                    <tr> 
                        <td class="data1" colspan="2">
                        	  <form:checkbox path="useProxy" onclick="checkproxy();" />
                            <spring:message code="sys.upd.label.useProxy" />
                        </td>
                    </tr>
                    <tr> 
                    	<td height="10" colspan="2">
                    		<img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10">
                    	</td>
                    </tr>
                </tbody>
            </table>
            <TABLE cellSpacing=0 cellPadding=0 width="540" border=0 class="border">
                <TBODY>
                    <tr> 
                        <td colspan="3"><table width="538" border="0" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td class="tableheader"><spring:message code="sys.upd.title.proxy" /></td>
                                </tr>
                        </table></td>
                    </tr>
                    
                    <tr> 
                        <td colspan="3">
                            <table width="538" border="0" cellspacing="0" cellpadding="0">                         
                                <TR>
                                    <TD class="data1">&nbsp;</TD>
                                    <TD width="167" class="data1"><spring:message code="sys.conn.tmcm.label.pxy.type" /></TD>
                                    <TD width="371" class="data1">
                                        <form:select cssClass="button" path="proxyType" size="1" onchange="return showNote();">
                                            <form:option value="http"><spring:message code="sys.upd.label.prxy.type.http" /></form:option>
                                            <form:option value="socks4"><spring:message code="sys.upd.label.prxy.type.sock4" /></form:option>
                                            <form:option value="socks5"><spring:message code="sys.upd.label.prxy.type.sock5" /></form:option>
                                        </form:select>
                                    </TD>
                                </TR>
                                <TR>
                                    <TD class="data1">&nbsp;</TD>
                                    <TD class="data1"><spring:message code="sys.conn.tmcm.label.pxy.server" /></TD>
                                    <TD class="data1"><form:input path="proxyAddr" cssClass="button" size="50" maxlength="128" /></TD>
                                </TR>
                                <TR>
                                    <TD class="data1">&nbsp;</TD>
                                    <TD class="data1"><spring:message code="sys.conn.tmcm.label.pxy.port" /></TD>
                                    <TD class="data1"><form:input path="proxyPort" cssClass="button" size="5" maxlength="5" /></TD>
                                </TR>
                                <TR>
                                    <TD class="data1">&nbsp;</TD>
                                    <TD class="data1"><spring:message code="sys.conn.tmcm.label.pxy.user" /></TD>
                                    <TD class="data1"><form:input path="proxyUserName" cssClass="button" size="50" maxlength="64" /></TD>
                                </TR>
                                <TR>
                                    <TD class="data1">&nbsp;</TD>
                                    <TD class="data1"><spring:message code="sys.conn.tmcm.label.pxy.pwd" /></TD>
                                    <TD class="data1"><form:password showPassword="true" path="proxyPwd" cssClass="button" size="50" maxlength="64" /></TD>
                                </TR>
                                <TR>
                                	<TD height="10" colspan="2"></TD>
                                </TR>
                                
                        </table></td>
                    </TR>
                </TBODY>    
            </TABLE>
            <table width="540" border="0" cellspacing="0" cellpadding="0">
                <tr> 
                    <td height="28" valign="bottom"> 
                <input type="submit" class="button"  style="width:50px" onclick="return validateFields()" name="submitbtn" value="<spring:message code="button.save" />"/>
                <input name="Apply222" type="button" class="cbutton" value="<spring:message code="button.cancel" />" onClick="self.location.href=('/initUpdProxyPage.imss')">
                    </td>
                </tr>
                <tr id="note_id">
                    <td style="COLOR: #ff0000;" id="note_msg"><spring:message code="sys.upd.msg.prxy.note.http" /></td>
                </tr>
                <tr>
                    <td>
                        <span class="text-error"><c:out value="${changeOK}" /></span>
                    </td>
                </tr>
            </table>
        </form:form>
    </BODY>
</html>
