

module "tables"
--[[
  version=
    -- version, data structure version, reserved
    -- platform, used for which platform
    -- sp, platform service pack
    -- patch, platform patch number
    -- build, platform build number
]]--
version = { version = 1, platform='IMSx_VA_8.0', sp=0, patch=0}

tables={
  tb_component_list= {
    export=true
  },
  tb_named_obj= {
    export=true,
    export_condition=" where id not in (select id from tb_named_obj_rule where rule_id in (select rule_id from tb_rule where rule_name like 'OPP%'))",
    backup=true,
    truncate=true,
    truncate_condition=" where id > 2 and id < 99999 and id not in (select id from tb_named_obj_rule where rule_id in (select rule_id from tb_rule where rule_name like 'OPP%'))",
    sequence="tb_named_obj_id_seq"
  },
  tb_entity= {
    export=true,
    backup=true,
    truncate=true,
    sequence="tb_entity_entity_id_seq"
  },
  tb_policy= {
    export=true,
    export_condition=" where (policy_name not like 'OPP%' or policy_name is null) and policy_id not in (select policy_id from tb_rule where has_so_file_filter = '1' or has_so_url_filter = '1')",
    backup=true,
    truncate=true,
    truncate_condition=" where policy_name not like 'OPP%' or policy_name is null",
    sequence="tb_policy_policy_id_seq"
  },
  tb_rule={
    export=true,
    export_condition=" where rule_name not like 'OPP%' and has_so_file_filter = '0' and has_so_url_filter = '0'",
    backup=true,
    truncate=true,
    truncate_condition=" where rule_name not like 'OPP%'",
    sequence="tb_rule_rule_id_seq",    
    dependency={
      "tb_policy"
    }
  },
  tb_scanning_exceptions= {
    export=true,
    backup=true,
    truncate=true
  },
  tb_entity_rule= {
    export=true,
    export_condition="  where rule_id in (select rule_id from tb_rule where rule_name not like 'OPP%' and has_so_file_filter = '0' and has_so_url_filter = '0')",
    backup=true,
    truncate=true,
    truncate_condition=" where rule_id in (select rule_id from tb_rule where rule_name not like 'OPP%')",
    dependency = {
      "tb_entity",
      "tb_rule"
    }
  },
  tb_named_obj_rule= {
    export=true,
    export_condition=" where rule_id in (select rule_id from tb_rule where rule_name not like 'OPP%' and has_so_file_filter = '0' and has_so_url_filter = '0')",
    backup=true,
    truncate=true,
    truncate_condition=" where rule_id in (select rule_id from tb_rule where rule_name not like 'OPP%')",
    dependency = {
      "tb_named_obj",
      "tb_rule"
    }
  },
  tb_inter_addr= {
    export=true,
    backup=true,
    truncate=true
  },
  tb_named_obj_scan_exception= {
    export=true,
    backup=true,
    truncate=true,
    dependency = {
      "tb_named_obj",
      "tb_scanning_exceptions"
    }
  },
  tb_dkim_whitelist= {
    export=true,
    backup=true,
    truncate=true,
    sequence="tb_dkim_white_list_seq"
  },
  t_iprule= {
    export=true,
    backup=true,
    truncate=true
  },
  t_manual_domain= {
    export=true,
    backup=true,
    truncate=true
  },
  t_type_setting= {
    export=true,
    backup=true,
    truncate=true
  },
  t_foxhuntersetting= {
    export=true,
    export_condition=" where type = 1",
    backup=true,
    truncate=true
  },
  tb_postfixconfig= {
    export=true,
    backup=true
  },
  tb_report_setting= {
    export=true,
    backup=true,
    truncate=true,
  },
  tb_report_tickets={
    export=true,
    export_condition=" where report_type <4",
    backup=true,
    sequence="tb_report_tickets_ticket_id_seq"
  },
  tb_euq_entity={
    export=true,
    backup=true,
    truncate=true,
    sequence="tb_euq_entity_entity_id_seq"
  },
  tb_dlp_sub_keyword_list={
	export=true,
	backup=true,
	truncate=true,
	dependency = {
      "tb_dlp_keyword_list"
    }
  },
  tb_dlp_keyword_list={
	export=true,
	backup=true,
	truncate=true,
	dependency = {
      "tb_dlp_template_data_reference"
    }
  },  
  tb_dlp_expression={
	export=true,
	backup=true,
	truncate=true,
	dependency = {
      "tb_dlp_template_data_reference"
    }
	
  },
  tb_dlp_file_attribute={
    export=true,
    backup=true,
    truncate=true,
	dependency = {
      "tb_dlp_template_data_reference"
    }	
  },
  tb_dlp_template_data_reference={
	export=true,
	backup=true,
	truncate=true,
  },
  tb_global_setting={
    export=true,
    backup=true
  },
  tb_tls_policy_map={
    export=true,
    backup=true,
    truncate=true
  },
  tb_tls_certificate={
    export=true,
    backup=true,
    truncate=true,
    sequence="tb_certificate_id_seq"
  },
  tb_tls_service_certificate_usage={
    export=true,
    export_condition=" where scanner_id=1",
    backup=true,
    truncate=true
  },
  tb_delivery_policies={
    export=true,
    backup=true,
    truncate=true
  },
  tb_internal_host={
    export=true,
    backup=true,
    truncate=true
  },
  tb_syslog_setting={
    export=true,
    backup=true,
    truncate=true
  },
  tb_syslog_logtype={
    export=true,
    backup=true,
    truncate=true
  },
  t_sender_filter_approved={
    export=true,
    backup=true,
    truncate=true
  },
  tb_smart_protection_server={
    export=true,
    backup=true,
    truncate=true
  },
  tb_proxy_list={
    export=true,
    backup=true,
    truncate=true
  }  
}

GobalExclusiveSettings = {
  {section="adminui", records="*"},
  {section="cmagent", records="*"},
  {section="custom_defense", records="*"},
  {section="euqmaster", records="*"},
  {section="dda", records="*"},
  {section="dda_server", records="*"},
  {section="log", records="misc_file_rotate_prefix"},
  {section="euq", records="digest_inline_action_key"},
  --{section="General-Notification", records="PreferredCharset"},
  --{section="MessageModule", records="DefaultSourceCharset"},
  {section="smart_scan", records={
      "sps_server_addr",
      "uuid",
      "proxy_addr",
      "proxy_port",
      "proxy_user_name",
      "proxy_user_password",
      "use_ssl",
      "use_proxy"
      }
  },
  {section="Registration",
    records={
      "product_version",
      "product_name",
      "PrProductName",
      "PrProductName2",
      "PrProductName3",
      "PrProductName4",
      "PrServerRenewInstrURL",
      "NRSImageProfile",
      "SPSImageProfile",
      "PrefilterImageProfile",
      "VSAPIImageProfile",
      "RCImageProfile",
      "EEImageProfile",
      "PrServerUpgradeInstrURL",
      "PrServerURL",
      "PrServerUpdateURL",
      "PrServerViewLicURL"
    }
  },
  {section="general",
    records={
      "locale",
      "imss_version",
      "service_pack",
      "hotfix_number",
      "proc_extended_proc_live_period_secs",
      "proc_thread_per_proc",
      "proc_proc_inc_num",
      "proc_max_worker_proc",
      "proc_max_connections"
    }
  },
  {section="policy_server",
    records={
      "dbChangePollIntervalInSecs",
      "recv_timeout_secs",
      "send_timeout_secs",
      "max_threads",
      "threads",
      "refershTime"
    }
  },
  {section="smtp",
    records = {
      "downstream_smtp_server_addr",
      "downstream_smtp_server_port"
    }
  },
  {section="Update",
    records = {
      "Platform",
      "Language",
      "VersionSmartScanAgentPattern",
      "VersionVirusEngine",
      "VersionATSEEngine",
      "VersionVirusPattern",
      "VersionSpywarePattern",
      "VersionIntellitrapPattern",
      "VersionIntellitrapException",
      "VersionTMASEEngine",
      "VersionTMASEPattern",
      "VersionTMUFEEngine",
      "UpdateDateSmartScanAgentPattern",
      "UpdateDateVirusEngine",
      "UpdateDateATSEEngine",
      "UpdateDateVirusPattern",
      "UpdateDateSpywarePattern",
      "UpdateDateIntellitrapPattern",
      "UpdateDateIntellitrapException",
      "UpdateDateTMASEEngine",
      "UpdateDateTMASEPattern",
      "UpdateDateTMUFEEngine",
      "TMASEServerurl",
      "UpdateServer",
      "UpdateServerPort"
    }
  },
  {section = "virus",
    records = {
      "VSSPtnBaseNameList"
    }
  },
  {section = "click_protection",
    records = {
      "ws_host",
      "ws_port"
    }
  }
}