#!/bin/sh

t_modify() {
    
    TEMP_POSTFIX_SERVICE="/usr/lib/systemd/system/postfix.service"

    if [ -f /usr/lib/systemd/system/postfix.service ]; then
        echo "begin to modify postfix.service..."
        
        grep -q "^PIDFile="  $TEMP_POSTFIX_SERVICE
        if [ $? -eq 0 ];then
            sed -i "s/^PIDFile=.*$/PIDFile=$POSTFIX_QUEUE_PATH\/pid\/master.pid/" $TEMP_POSTFIX_SERVICE
        fi
    fi
	echo "Run cmd: systemctl daemon-reload"
	echo "Run cmd: systemctl restart postfix.service"
	systemctl daemon-reload
    systemctl restart postfix.service
}

t_main() {
    # Identify the current OS
    IsRHEL7Later=0
    VERSION_FILE_PATH="/etc/redhat-release"
    REGEX_MATCH="Red Hat Enterprise Linux Server release (7|8|9|10)\."

    if [ -f /etc/centos-release ] ; then
        VERSION_FILE_PATH="/etc/centos-release"
        REGEX_MATCH="CentOS Linux release (7|8|9|10)\."
    fi
    echo `cat "${VERSION_FILE_PATH}"` | grep -E "${REGEX_MATCH}" > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        IsRHEL7Later=1
    fi
    
    if [ ${IsRHEL7Later} -eq 1 ]; then
        echo "Need to modify postfix.service for IMSS on RedHat 7x"
        t_modify
    fi
    exit $?
}



if [ $# != 1 ] ; then 
    echo "usage: $0 path" 
    exit 1; 
fi 


POSTFIX_QUEUE_PATH=$1
POSTFIX_QUEUE_PATH=`echo ${POSTFIX_QUEUE_PATH%*/}`
POSTFIX_QUEUE_PATH=$(echo $POSTFIX_QUEUE_PATH | sed 's/\//\\\//g')

echo "postfix queue path=" $POSTFIX_QUEUE_PATH

#imsva
if [ -f /etc/trend-release ]; then
    echo "No need to modify postfix.service for IMSVA"
#imss
else
    t_main
fi



