#! /bin/bash
IMSS_HOME=_PKG_INSTALL_ROOT_
ADMIN_PID_FILE=$IMSS_HOME/UI/adminUI/bin/admin.pid
EUQ_PID_FILE=$IMSS_HOME/UI/euqUI/bin/euq.pid
is_euq_enable=0
is_master=0

$IMSS_HOME/script/is_euq_enable.sh
if [ $? -eq 1 ]; then
   is_euq_enable=1
fi
$IMSS_HOME/script/is_master.sh
if [ $? -eq 1 ]; then 
   is_master=1
fi
if [ $is_euq_enable -eq 1 ]; then
        if [ -f $EUQ_PID_FILE ]; then
          EUQ_PID=`cat $EUQ_PID_FILE`
        else
          EUQ_PID=`ps -ef|grep "/euqUI/conf/server.xml start"|grep java|grep -v grep|awk '{ print $2}'`
        fi
        if test -n "$EUQ_PID"; then
          EUQ_RUNNING=`ps -ef|grep $EUQ_PID|grep java|grep "/euqUI/conf/server.xml start"|grep -v grep`
          if test "$EUQ_RUNNING" ; then
	   $IMSS_HOME/script/S99EUQ restart
	  fi
	fi
fi

if [ $is_master -eq 0 ]; then
	exit 0
fi
#release admin UI
if [ -f $ADMIN_PID_FILE ]; then
   ADMIN_PID=`cat $ADMIN_PID_FILE`
else
   ADMIN_PID=`ps -ef|grep "/adminUI/conf/server.xml start"|grep java|grep -v grep|awk '{ print $2}'`
fi
if test -z "$ADMIN_PID" ; then
   exit 0
fi
child_process_exist=`ps -ef|awk '{print $3}' |grep "^$ADMIN_PID$"`

if test -z  "$child_process_exist" ; then
    $IMSS_HOME/script/S99ADMINUI restart
fi

