<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://www.springframework.org/tags" prefix="spring" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<html>
<head>
<title></title>
<link href="/css/trend-style.css" rel="stylesheet" type="text/css">
<base target="_self">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<script language="JavaScript" src="/javascripts/validation.jsp" type="text/javascript"></script>
<script src="/javascripts/expand.js"></script>
<script language="JavaScript" type="text/JavaScript">

//Begin SEG TT case 245100:changes string order to numeric order.
//function dot2num changes ipstr to num.
function dot2num(dot) 
{
	var d = dot.split('.');
	return ((((((+d[0])*256)+(+d[1]))*256)+(+d[2]))*256)+(+d[3]);
}

//function CompareIpStr compares to IPs as numberic order.
function CompareIpStr(strip1,strip2)
{
	var ipStr1 = strip1;
	var ipStr2 = strip2;
	var idx1 = ipStr1.search(':'); //for cases that the IP address followed by subnet mask
	if (idx1 != -1)
	{
		ipStr1 = ipStr1.substring(0,idx1);
	}
	var idx2 = ipStr2.search(':'); //for cases that the IP address followed by subnet mask
	if (idx2 != -1)
	{
		ipStr2 = ipStr2.substring(0,idx2);
	}
	var ipNum1 = parseInt(dot2num(ipStr1));
	var ipNum2 = parseInt(dot2num(ipStr2));
	if(ipNum1 < ipNum2)
	{
		return -1;
	}
	else if(ipNum1 > ipNum2)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}
// check IPv4 Subnet address like: 10.64.72.81:255.255.254.0
function isValidIPAddressAndMask(stripAndMask)
{
    var idx1 = stripAndMask.search(':'); //for cases that the IP address followed by subnet mask
    if (idx1 == -1)
    {
        return false;
    }
    ipStr1 = stripAndMask.substring(0,idx1);
    return isValidIPAddress(ipStr1)
}

//sort IPv4 and IPv6.
//IPv4 is before IPv6, 
//IPv4 is in numeric order. If it is subnet, only sort IP before ":"
//IPv6 is in string order
function sortSelectedList(listname)
{
    var oldArray = document.getElementById(listname);
    var newArrayIpv4 = new Array();
    var newArrayIpv6 = new Array();
    var indexIpv4 = 0;
    var indexIpv6 = 0;
    for(i=0; i<oldArray.length; i++)  
    {
        if(isValidIPAddress(oldArray.options[i].text) == true || isValidIPAddressAndMask(oldArray.options[i].text) == true)
        {
            newArrayIpv4[indexIpv4] = oldArray.options[i].text;
            indexIpv4++;
        }
        else
        {
            newArrayIpv6[indexIpv6] = oldArray.options[i].text;
            indexIpv6++;
        }
    }

  newArrayIpv4.sort(CompareIpStr);
  newArrayIpv6.sort()

  for(i=0; i<oldArray.length; i++)  {
      if(i< newArrayIpv4.length)
      {
          oldArray.options[i].text = newArrayIpv4[i];
          oldArray.options[i].value = newArrayIpv4[i];
      }
      else
      {
          oldArray.options[i].text = newArrayIpv6[i-newArrayIpv4.length];
          oldArray.options[i].value = newArrayIpv6[i-newArrayIpv4.length];
      }
  }
}
//End SEG TT case 245100:changes string order to numeric order.
function NewWindow(mypage, myname, w, h, scroll) {
var winl = (screen.width - w) / 2;
var wint = (screen.height - h) / 2;
winprops = 'height='+h+',width='+w+',top='+wint+',left='+winl+',scrollbars='+scroll+',resizable'
win = window.open(mypage, myname, winprops)
if (parseInt(navigator.appVersion) >= 4) { win.window.focus(); }
}

function checkReadOnly()
{
    <c:if test="${adminUser.systemReadOnly}" >
        var form = mtaConnForm;
        for (var i=0; i<form.elements.length; i++) 
        {
            form.elements[i].disabled = true;
        }        
    </c:if>
}


<c:if test="${mtaConnForm.aclType=='deny'}">
var acceptOpen=true;
var denyOpen=false;
</c:if>
<c:if test="${mtaConnForm.aclType=='allow'}">
var acceptOpen=false;
var denyOpen=true;
</c:if>

function patchStatus()
{
    <c:if test="${mtaConnForm.aclType=='deny'}">
      document.getElementById('aclAccept').style.display="block";
    </c:if>
    <c:if test="${mtaConnForm.aclType=='allow'}">
      document.getElementById('aclDeny').style.display="block";
    </c:if>
    <c:if test="${importRefreshType=='deny'}">
      document.getElementById('aclAccept').style.display="block";
      document.getElementById('aclDeny').style.display="none";
      document.forms[0].aclType[0].checked=true;
      document.forms[0].aclType[1].checked=false;
    </c:if>
    <c:if test="${importRefreshType=='allow'}">
      document.getElementById('aclDeny').style.display="block";
      document.getElementById('aclAccept').style.display="none";
      document.forms[0].aclType[0].checked=false;
      document.forms[0].aclType[1].checked=true;
    </c:if>
    
}

function changeACLToAccept()
{
    if(!acceptOpen)
    {
        expandcontent('aclAccept');
        expandcontent('aclDeny');
        acceptOpen=true;
        denyOpen=false;
    }
}

function changeACLToDeny()
{
    if(!denyOpen)
    {
        expandcontent('aclDeny');
        expandcontent('aclAccept');
        denyOpen=true;
        acceptOpen=false;
    }
}

<c:if test="${platform=='windows'}">
<c:if test="${mtaConnForm.tlsType=='tlsOnly'}">
var tlsAcceptAll=false;
var tlsOnly=true;
</c:if>
<c:if test="${mtaConnForm.tlsType=='both'}">
var tlsAcceptAll=true;
var tlsOnly=false;
</c:if>
function changeTLSToAcceptAll()
{
    if(!tlsAcceptAll)
    {
        expandcontent('tlsAcceptAll');
        tlsAcceptAll=true;
        tlsOnly=false;
    }
}
function changeTLSToTLSOnly()
{
    if(!tlsOnly)
    {
        expandcontent('tlsAcceptAll');
        tlsAcceptAll=false;
        tlsOnly=true;
    }
}

function importTLSEnforceListFun()
{
  importType="tlsEnforceList";
  NewWindow('/importTLSEnforceList.imss','import','550','150','auto');
  return false;
}

function addTLSEnforceAddr()
{
    if(document.forms[0].tlsAddrType[0].checked)
    {
        if(!checkempty(document.forms[0].tlsDomain))
            return false;
        if(!checkdomain(document.forms[0].tlsDomain))
            return false;
    }
    else if(document.forms[0].tlsAddrType[1].checked)
    {
        if(!checkempty(document.forms[0].tlsSingleAddr))
            return false;
        if(!checkip(document.forms[0].tlsSingleAddr))
            return false;
    }
    else if(document.forms[0].tlsAddrType[2].checked)
    {
        if(!checkempty(document.forms[0].tlsSubnetAddr))
            return false;
        if(!checkip(document.forms[0].tlsSubnetAddr))
            return false;
    }
    mtaConnForm.action="/addTLSEnforceAddr.imss";
    mtaConnForm.submit();
    return true;
}

function removeTLSEnforceAddr()
{
    mtaConnForm.action="/removeTLSEnforceAddr.imss";
    mtaConnForm.submit();
    return true;
}
</c:if>

function addDenyAddr()
{
    if(document.forms[0].denyAddrType[0].checked)
    {
        if(!checkempty(document.forms[0].denySingleAddr))
            return false;
        if(!checkIpv4AndIpv6(document.forms[0].denySingleAddr))
            return false;
        if(document.forms[0].denySingleAddr.value == "127.0.0.1")
        {
           alert("<spring:message code="js.badIP"/>");
           return false;
        }
    }
    else if(document.forms[0].denyAddrType[1].checked)
    {
        if(!checkempty(document.forms[0].denySubnetAddr))
            return false;
        if(document.forms[0].ipTypeofDeny.selectedIndex == 0)
        {
            if(!checkip(document.forms[0].denySubnetAddr))
                return false;
        }
        else if(document.forms[0].ipTypeofDeny.selectedIndex == 1)
        {
            if(!checkIpv6WithMask(document.forms[0].denySubnetAddr))
                return false;
        }
        if(document.forms[0].denySubnetAddr.value == "127.0.0.1")
        {
            alert("<spring:message code="js.badIP"/>");
            return false;
        }
        /*if(check(document.forms[0].denySubnetMask))
            return false;*/
    }
    mtaConnForm.action="/addDenyAddr.imss";
    mtaConnForm.submit();
    return true;
}

function removeDenyAddr()
{
    mtaConnForm.action="/removeDenyAddr.imss";
    mtaConnForm.submit();
    return true;
}

function addAcceptAddr()
{
    if(document.forms[0].acceptAddrType[0].checked)
    {
        if(!checkempty(document.forms[0].acceptSingleAddr))
            return false;
        if(!checkIpv4AndIpv6(document.forms[0].acceptSingleAddr))
            return false;
    }
    else if(document.forms[0].acceptAddrType[1].checked)
    {
        if(!checkempty(document.forms[0].acceptSubnetAddr))
            return false;
        if(document.forms[0].ipTypeofAccept.selectedIndex == 0)
        {
            if(!checkip(document.forms[0].acceptSubnetAddr))
                return false;
        }
        else if(document.forms[0].ipTypeofAccept.selectedIndex == 1)
        {
            if(!checkIpv6WithMask(document.forms[0].acceptSubnetAddr))
                return false;
        }
        /*if(check(document.forms[0].denySubnetMask))
            return false;*/
    }
    mtaConnForm.action="/addAcceptAddr.imss";
    mtaConnForm.submit();
    return true;
}

function removeAcceptAddr()
{
    mtaConnForm.action="/removeAcceptAddr.imss";
    mtaConnForm.submit();
    return true;
}

function selectIpTypeofAccept(obj)
{
    if(obj.selectedIndex==0)
        changeToIpv4ofAccept();
    else if(obj.selectedIndex==1)
        changeToIpv6ofAccept();
}
function changeToIpv4ofAccept()
{
    var text = "<spring:message code="sys.smtp.rule.subnetAddrEG" />";
    document.getElementById("acceptSubnetAddrEG").innerHTML = text;
    document.getElementById("acceptSubnetMask").style.visibility = "visible";
    document.getElementById("acceptSubnetMaskText").style.visibility = "visible";
    document.getElementById("acceptSubnetMaskEG").style.visibility = "visible";
}

function changeToIpv6ofAccept()
{
    var text = "<spring:message code="sys.smtp.rule.ipv6.subnetAddrEG" />";
    document.getElementById("acceptSubnetAddrEG").innerHTML = text;
    document.getElementById("acceptSubnetMask").style.visibility = "hidden";
    document.getElementById("acceptSubnetMaskText").style.visibility = "hidden";
    document.getElementById("acceptSubnetMaskEG").style.visibility = "hidden";
}

function selectIpTypeofDeny(obj)
{
    if(obj.selectedIndex==0)
        changeToIpv4ofDeny();
    else if(obj.selectedIndex==1)
        changeToIpv6ofDeny();
}
function changeToIpv4ofDeny()
{
    var text = "<spring:message code="sys.smtp.rule.subnetAddrEG" />";
    document.getElementById("denySubnetAddrEG").innerHTML = text;
    document.getElementById("denySubnetMask").style.visibility = "visible";
    document.getElementById("denySubnetMaskText").style.visibility = "visible";
    document.getElementById("denySubnetMaskEG").style.visibility = "visible";
}

function changeToIpv6ofDeny()
{
    var text = "<spring:message code="sys.smtp.rule.ipv6.subnetAddrEG" />";
    document.getElementById("denySubnetAddrEG").innerHTML = text;
    document.getElementById("denySubnetMask").style.visibility = "hidden";
    document.getElementById("denySubnetMaskText").style.visibility = "hidden";
    document.getElementById("denySubnetMaskEG").style.visibility = "hidden";
}

function upload(fileType)
{
    mtaConnForm.action="/uploadTLSFile.imss";
    mtaConnForm.fileType.value=fileType;
    mtaConnForm.submit();
    return true;
}

function download(fileType)
{
    mtaConnForm.action="/downloadTLSFile.imss";
    mtaConnForm.fileType.value=fileType;
    mtaConnForm.submit();
    return true;
}

var importType="";

function importDeny()
{
  importType="deny";
  NewWindow('/importDeny.imss','import','550','150','auto');
  return false;
}

function exportDeny(){
     mtaConnForm.action="/exportDeny.imss";
     mtaConnForm.submit();
     mtaConnForm.action="/saveSMTPConn.imss";
     
}
function importAccept()
{
  importType="allow";
  NewWindow('/importAccept.imss','import','550','150','auto');
  return false;
}

function exportAccept(){
    mtaConnForm.action="/exportAccept.imss";
     mtaConnForm.submit();
     mtaConnForm.action="/saveSMTPConn.imss";
}


function refresh()
{
   mtaConnForm.action="/showConn.imss?type="+importType;
   mtaConnForm.submit();
}

function updateTLSStatus()
{
    <c:if test="${appliance!='yes'}">
    if(!mtaConnForm.useTLS.checked)
    {
        mtaConnForm.enforceTLS.disabled=true;
        mtaConnForm.caCertFile.disabled=true;
        mtaConnForm.privateKeyFile.disabled=true;
        mtaConnForm.certFile.disabled=true;
        mtaConnForm.uploadButton1.disabled=true;
        mtaConnForm.uploadButton2.disabled=true;
        mtaConnForm.uploadButton3.disabled=true;
    }
    else
    {
        mtaConnForm.enforceTLS.disabled=false;
        mtaConnForm.caCertFile.disabled=false;
        mtaConnForm.privateKeyFile.disabled=false;
        mtaConnForm.certFile.disabled=false;
        mtaConnForm.uploadButton1.disabled=false;
        mtaConnForm.uploadButton2.disabled=false;
        mtaConnForm.uploadButton3.disabled=false;
    }
    </c:if>    
}

function checkForm()
{
    if(!checkport(document.forms[0].port))
    {
        return false;
    }
    if(!checknumber(document.forms[0].timeout))
    {
        return false;
    }
    if(document.forms[0].timeout.value<=0)
    {
        document.forms[0].timeout.select();
        alert('<spring:message code="errors.sys.mta.invalidTimeout" />');
        return false;
    }
    if(document.forms[0].maxConnType[1].checked)
    {
        if(!checknumber(document.forms[0].maxConnNum))
        {
            return false;
        }
        if(document.forms[0].maxConnNum.value<1 || document.forms[0].maxConnNum.value>1024)
        {
			document.forms[0].maxConnNum.select();
            alert('<spring:message code="errors.sys.mta.invalidMaxConnNum" />');
            return false;
        }
        
    }
    return true;
}

function updateMaxConnStatus()
{
    if(mtaConnForm.maxConnType[0].checked)
    {
        mtaConnForm.maxConnNum.disabled=true;
    }
    else
    {
        mtaConnForm.maxConnNum.disabled=false;
    }
}

function checkBError()
{
  <c:if test="${ !empty errorMsg}" var="errmsg" scope="request">
     alert("<c:out value='${errorMsg}' />");
  </c:if>
}

</script>
</head>

<BODY leftmargin="0" topmargin="0" marginwidth="0" onload="updateTLSStatus(); updateMaxConnStatus(); patchStatus(); checkReadOnly(); checkBError(); ">
<table cellspacing=0 cellpadding=0 width=540 border=0>
  <tbody>
    <tr> 
      <td class="content-title"><spring:message code="sys.smtp.head" /></td>
      <td align="right" valign="bottom"><a href="/help/<spring:message code='locale' />/<spring:message code='olh.system.smtp_conn'/>" target="_blank"><img src="/images/<spring:message code="locale" />/question_cui.gif" width="16" height="16" border="0"></a></td>
    </tr>
    <tr> 
      <td height="10" colspan="2" class="hor-dotted-line"><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="1"></td>
    </tr>
    <tr> 
      <td height="10" colspan="2"><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10">
    </tr>
  </tbody>
</table>
<form:form modelAttribute="mtaConnForm" name="mtaConnForm" action="/saveSMTPConn.imss"  enctype="multipart/form-data">
<TABLE cellSpacing=0 cellPadding=0 width="540" border=0>
  <TBODY>
    <TR> 
      <TD id=main-content vAlign=top width="540"> <table cellpadding="0" cellspacing="0" border="0" width="100%">
          <c:if test="${platform=='linux'}">
          <c:if test="${appliance!='yes'}">
             <td class="data1" colspan="2">
                 <form:checkbox path="applySetting"/>
                 <spring:message code="sys.smtp.basic.apply" />
             </td>
          </tr>
          </c:if>
          </c:if>
          <tr><td colspan="2">&nbsp;</td></tr>
          <tr> 
            <!-- TABS -->
            <td background="/images/<spring:message code="locale" />/tab_background_cui.gif"> <table cellpadding="0" cellspacing="0" border="0">
                <tr> 
                  <td><img src="/images/<spring:message code="locale" />/tab_inactive1_left_cui.gif" width="11" height="23" alt="" border="0"></td>
                  <td style="vertical-align:top" background="/images/<spring:message code="locale" />/tab_inactive_background_cui.gif" class="tabinactive" nowrap><A onMouseOver="this.style.color='#FF0000';"
      style="COLOR: #000000; text-decoration:none" 
      onmouseout="this.style.color='#000000';" 
      href="/initSMTPSetting.imss" ><spring:message code="sys.smtp.tab.basic" /></a></td>
                  <td><img src="/images/<spring:message code="locale" />/tab_inactive_right_cui.gif" width="23" height="23" alt="" border="0"></td>
                  
                  <td><img src="/images/<spring:message code="locale" />/tab_active2_left_cui.gif" width="11" height="23" alt="" border="0"></td>
                  <td background="/images/<spring:message code="locale" />/tab_active_background_cui.gif" class="tabactive" style="vertical-align:top" nowrap><spring:message code="sys.smtp.tab.connections" /></td>
                  <td><img src="/images/<spring:message code="locale" />/tab_active_right_cui.gif" width="23" height="23" alt="" border="0"></td>
                  
                  <td><img src="/images/<spring:message code="locale" />/tab_inactive2_left_cui.gif" width="11" height="23" alt="" border="0"></td>
                  <td style="vertical-align:top" background="/images/<spring:message code="locale" />/tab_inactive_background_cui.gif" class="tabinactive" nowrap>
                    <A onMouseOver="this.style.color='#FF0000';" 
      style="COLOR: #000000; text-decoration:none" 
      onmouseout="this.style.color='#000000';" 
      href="/initSMTPRule.imss" ><spring:message code="sys.smtp.tab.messagePolicy" /></a></td>
                  <td><img src="/images/<spring:message code="locale" />/tab_inactive_right_cui.gif" width="23" height="23" alt="" border="0"></td>
                  
                  <td><img src="/images/<spring:message code="locale" />/tab_inactive2_left_cui.gif" width="11" height="23" alt="" border="0"></td>
                  <td style="vertical-align:top" background="/images/<spring:message code="locale" />/tab_inactive_background_cui.gif" class="tabinactive" nowrap>
                    <span class="tabinactive"><A onMouseOver="this.style.color='#FF0000';" style="COLOR: #000000; text-decoration:none" onmouseout="this.style.color='#000000';" href="/initSMTPDelivery.imss" >
                    <c:if test="${platform=='linux'}">
                    <spring:message code="sys.smtp.tab.domainBasedDelivery" />
                    </c:if>
                    <c:if test="${platform=='windows'}">
                    <spring:message code="sys.smtp.tab.delivery" />
                    </c:if></a></span></td>
                  <td><img src="/images/<spring:message code="locale" />/tab_inactive_right_cui.gif" width="23" height="23" alt="" border="0"></td>
                  <td>&nbsp;</td>
                </tr>
              </table></td>
            <td background="/images/<spring:message code="locale" />/tab_background_cui.gif" align="right"><img src="/images/<spring:message code="locale" />/tab_right_corner_cui.gif" width="6" height="23" alt="" border="0"></td>
            <!-- /TABS -->
          </tr>
          <tr> 
            <td colspan="2" class="border"> <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr> 
                  <td width="538" style="padding-bottom:3px">
<table width="100%" border="0" cellpadding="0" cellspacing="0" >
                      <tr> 
                        <td colspan="5" class="tableheadergrey"><spring:message code="sys.smtp.conn.title.interface" /></td>
                      </tr>
<c:if test="${appliance!='yes'}">                                            
                      <tr>
                        <td width="185" colspan="3" class="data1"><spring:message code="sys.smtp.conn.ip" /></td>
                        <td colspan="2"  class="data1">
                          <form:select path="ipAddress" cssClass="button">
                              <form:option value="127.0.0.1"><spring:message code="sys.smtp.conn.loopbackAddr" /></form:option>
                              <form:option value="all"><spring:message code="sys.smtp.conn.allIP" /></form:option>
                          </form:select>
                        </td>
                      </tr>
</c:if>                      
                      <tr>
                        <td colspan="3"  class="data1"><spring:message code="sys.smtp.conn.port" /></td>
                        <td colspan="2"  class="data1"><form:input path="port" cssClass="button" size="5" maxlength="5"/></td>
                      </tr>
                      <tr>
                        <td colspan="3"  class="data1"><spring:message code="sys.smtp.conn.timeout" /></td>
                        <td colspan="2"  class="data1"><form:input path="timeout" cssClass="button" size="5" maxlength="5" />
                          <spring:message code="sys.smtp.conn.miniutes" /></td>
                      </tr>
                      <tr>
                        <td colspan="3"  class="data1"><spring:message code="sys.smtp.conn.simConn" /></td>
                        <td colspan="2"  class="data1"><form:radiobutton path="maxConnType" value="noLimit" onclick="updateMaxConnStatus();"/>
                          <spring:message code="sys.smtp.conn.noLimit" /></td>
                      </tr>
                      <tr> 
                        <td colspan="3"  class="data1">&nbsp;</td>
                        <td colspan="2"  class="data1"><form:radiobutton path="maxConnType" value="number" onclick="updateMaxConnStatus();"/>
                          <spring:message code="sys.smtp.conn.maxConn_1" />
                        <form:input path="maxConnNum" cssClass="button" size="5"  maxlength="5"/>
                          <spring:message code="sys.smtp.conn.maxConn_2" /></td>
                      </tr>
                      <tr> 
                        <td colspan="5"><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10"></td>
                      </tr>
                      <tr>
                        <td colspan="5"><table width="100%" border="0" cellpadding="0" cellspacing="0" class="border3">
                            <tr>
                              <td class="tableheadergrey"><spring:message code="sys.smtp.conn.title.control" /></td>
                            </tr>
                        </table></td>
                      </tr>
                      
                      <tr>
                        <td colspan="5" class="data1"><spring:message code="sys.smtp.conn.permitOrDeny" /></td>
                      </tr>
                      <tr>
                        <td colspan="5" class="data1">
                          <form:radiobutton path="aclType" value="deny" onclick="changeACLToAccept();"/><spring:message code="sys.smtp.conn.accept" />
                        </td>
                      </tr>
                      <tr>
                        <td width="20px">
                        <td colspan="5">

                        
                      <table width="100%" border="0" cellpadding="0" cellspacing="0" id="aclAccept" class="switchcontent">
                      <tr>
                        <td width="20">&nbsp;</td>
                        <td width="1%"><form:radiobutton path="denyAddrType" value="singleAddr" /></td>
                        <td class="data1"><spring:message code="sys.smtp.rule.singleComp" /></td>
                        <td width="40" rowspan="10" align="center">
                        <input name="Apply22222" type="button" class="button" value="&gt;&gt;" style="width:40px" onClick="return addDenyAddr();">
                          <br>
                        <input name="Apply222222" type="button" class="button" value="&lt;&lt;" style="width:40px" onClick="return removeDenyAddr();"></td>
                        <td rowspan="10">
                        <form:select path="selectedDenyList" size="13" multiple="true" cssClass="button" style="width:280px;height:200px">
                          <c:forEach items="${denyAccessList}" var="addr" varStatus="index">
                            <form:option value="${addr}"><c:out value="${addr}" /></form:option>
                          </c:forEach>
                        </form:select>
                        </td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><form:input path="denySingleAddr" cssClass="button" size="30" /></td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><spring:message code="sys.smtp.rule.singleCompEG" /></td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                        <td><form:radiobutton path="denyAddrType" value="groupAddr" /></td>
                        <td class="data1"><spring:message code="sys.smtp.rule.groupComp" /></td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                      	<td>&nbsp;</td>
                        <td class="data1">
                          <span class="textbold"><spring:message code="sys.smtp.rule.ip.type" /></span>
                          <select name="ipTypeofDeny" onChange="selectIpTypeofDeny(this)" class="button">
                            <option value="ipv4" selected><spring:message code="sys.smtp.rule.ip.type.ipv4" /></option>
                            <option value="ipv6"><spring:message code="sys.smtp.rule.ip.type.ipv6" /></option>
                          </select>
                        </td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><spring:message code="sys.smtp.rule.subnetAddr" /></td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><form:input path="denySubnetAddr" cssClass="button" size="30" /></td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1" id="denySubnetAddrEG"><spring:message code="sys.smtp.rule.subnetAddrEG" /></td>
                      </tr>
                      <tr id="denySubnetMask">
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><spring:message code="sys.smtp.rule.subnetMask" /></td>
                      </tr>
                      <tr id="denySubnetMaskText">
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><form:input path="denySubnetMask" cssClass="button" maxlength="15" /></td>
                      </tr>
                      <tr id="denySubnetMaskEG">
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><spring:message code="sys.smtp.rule.subnetMaskEG" /></td>
                        <td class="data1"><input name="sort" type="button"  class="button" value="<spring:message code="label.sortipsubnetlist" />" style="position:relative; width:70px; left:260px" onClick=sortSelectedList("selectedDenyList")></td>
                      </tr>
                      <tr>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td class="data1"><input name="import" type="button"  class="button" value="<spring:message code="label.importfromfile" />" style="width:110px" onClick=importDeny()></td>
                      </tr>
                      
                      <tr>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td class="data1"><input name="exportDenyBtn" type="button"  class="button" value="<spring:message code="button.export" />" style="width:110px" onClick=exportDeny()></td>
                      </tr>
                      
                      <tr> 
                        <td colspan="5"><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10"></td>
                      </tr>
                      </table>
                      
                        </td>
                      </tr>
                      <tr>
                        <td colspan="5" class="data1">
                          <form:radiobutton path="aclType" value="allow" onclick="changeACLToDeny();"/><spring:message code="sys.smtp.conn.deny" />
                        </td>
                      </tr>
                      <tr>
                        <td colspan="5">

                        
                      <table width="100%" border="0" cellpadding="0" cellspacing="0" id="aclDeny" class="switchcontent">
                      <tr>
                        <td width="20">&nbsp;</td>
                        <td width="1%"><form:radiobutton path="acceptAddrType" value="singleAddr" /></td>
                        <td class="data1"><spring:message code="sys.smtp.rule.singleComp" /></td>
                        <td width="40" rowspan="10" align="center">
                        <input name="Apply22222" type="button" class="button" value="&gt;&gt;" style="width:30px" onClick="return addAcceptAddr();">
                          <br>
                        <input name="Apply222222" type="button" class="button" value="&lt;&lt;" style="width:30px" onClick="return removeAcceptAddr();"></td>
                        <td rowspan="10">
                        <form:select path="selectedAllowList" size="13" multiple="true" cssClass="button" style="width:280px;height:200px">
                          <c:forEach items="${allowAccessList}" var="addr" varStatus="index">
                            <form:option value="${addr}"><c:out value="${addr}" /></form:option>
                          </c:forEach>
                        </form:select>
                        </td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><form:input path="acceptSingleAddr" cssClass="button" size="30" /></td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><spring:message code="sys.smtp.rule.singleCompEG" /></td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                        <td><form:radiobutton path="acceptAddrType" value="groupAddr" /></td>
                        <td class="data1"><spring:message code="sys.smtp.rule.groupComp" /></td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                      	<td>&nbsp;</td>
                        <td class="data1">
                          <span class="textbold"><spring:message code="sys.smtp.rule.ip.type" /></span>
                          <select name="ipTypeofAccept" onChange="selectIpTypeofAccept(this)" class="button">
                            <option value="ipv4" selected><spring:message code="sys.smtp.rule.ip.type.ipv4" /></option>
                            <option value="ipv6"><spring:message code="sys.smtp.rule.ip.type.ipv6" /></option>
                          </select>
                        </td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><spring:message code="sys.smtp.rule.subnetAddr" /></td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><form:input path="acceptSubnetAddr" cssClass="button" size="30" /></td>
                      </tr>
                      <tr>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1" id="acceptSubnetAddrEG"><spring:message code="sys.smtp.rule.subnetAddrEG" /></td>
                      </tr>
                      <tr id="acceptSubnetMask">
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><spring:message code="sys.smtp.rule.subnetMask" /></td>
                      </tr>
                      <tr id="acceptSubnetMaskText">
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><form:input path="acceptSubnetMask" cssClass="button" maxlength="15" /></td>
                      </tr>
                      <tr id="acceptSubnetMaskEG">
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td class="data1"><spring:message code="sys.smtp.rule.subnetMaskEG" /></td>
                        <td class="data1"><input name="sort" type="button"  class="button" value="<spring:message code="label.sortipsubnetlist" />" style="position:relative; width:70px; left:260px" onClick=sortSelectedList("selectedAllowList")></td>

                      </tr>
                      <tr>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td class="data1"><input name="import" type="button"  class="button" value="<spring:message code="label.importfromfile" />" style="width:110px" onClick=importAccept()></td>
                       <tr>
                            <td>&nbsp;</td>
                            <td>&nbsp;</td>
                            <td class="data1"><input name="exportAcceptBtn" type="button"  class="button" value="<spring:message code='button.export' />" style="width:110px" onClick="exportAccept()"/></td>
                      </tr>
                      <tr> 
                        <td colspan="5"><img src="/images/<spring:message code="locale" />/1space_cui.gif" width="1" height="10"></td>
                      </tr>
                      </table>
                      
                        </td>
                      </tr>
                      
                      <c:if test="${appliance!='yes'}">
                      <tr> 
                        <td colspan="5"><table width="100%" border="0" cellpadding="0" cellspacing="0" class="border3">
                            <tr> 
                              <td class="tableheadergrey"><spring:message code="sys.smtp.conn.title.tls" /></td>
                            </tr>
                          </table></td>
                      </tr>
                      <tr> 
                        <td colspan="5" class="data1"><form:checkbox path="useTLS" onclick="return updateTLSStatus();"/>
                          <spring:message code="sys.smtp.conn.enableTLS" /></td>
                      </tr>
                      <tr>
                        <td colspan="5" class="data1" style="padding-left:24px"><form:checkbox path="enforceTLS" />
                          <spring:message code="sys.smtp.conn.onlyTLS" /></td>
                      </tr>
                      <tr>
                        <td colspan="3"  class="data1" style="padding-left:24px"><spring:message code="sys.smtp.conn.caCert" /></td>
                      <td colspan="2"  class="data1" style="padding-left:24px"><input type="file" name="caCertFile" class="button" />
&nbsp;&nbsp;&nbsp;
<input name="uploadButton1" type="button" class="button" value="<spring:message code="button.upload" />" onClick="return upload('caCert');"></td>
                      </tr>
                      <c:if test="${mtaConnForm.hasCaCert}">
                      <tr>
                        <td colspan="3"  class="data1" style="padding-left:24px"></td>
                        <td colspan="2"  class="data1" style="padding-left:24px">
                          <spring:message code="sys.smtp.conn.current" />&nbsp;<a href="/downloadTLSFile.imss?fileType=caCert"><spring:message code="sys.smtp.conn.caCertFilename" /></a>
                        </td>
                      </tr>
                      </c:if>
                      <tr>
                        <td colspan="3"  class="data1" style="padding-left:24px"><spring:message code="sys.smtp.conn.privateKey" /></td>
                      <td colspan="2"  class="data1" style="padding-left:24px"><input type="file" name="privateKeyFile" class="button" />
&nbsp;&nbsp;&nbsp;
<input name="uploadButton2" type="button" class="button" value="<spring:message code="button.upload" />" onClick="return upload('privateKey');"></td>
                      </tr>
                      <c:if test="${mtaConnForm.hasPrivateKey}">
                      <tr>
                        <td colspan="3"  class="data1" style="padding-left:24px"></td>
                        <td colspan="2"  class="data1" style="padding-left:24px">
                          <spring:message code="sys.smtp.conn.current" />&nbsp;<a href="/downloadTLSFile.imss?fileType=privateKey"><spring:message code="sys.smtp.conn.privateKeyFilename" /></a>
                        </td>
                      </tr>
                      </c:if>
                      <tr>
                        <td colspan="3"  class="data1" style="padding-left:24px"><spring:message code="sys.smtp.conn.certificate" /></td>
                      <td colspan="2"  class="data1" style="padding-left:24px"><input type="file" name="certFile" class="button" />
&nbsp;&nbsp;&nbsp;
<input name="uploadButton3" type="button" class="button" value="<spring:message code="button.upload" />" onClick="return upload('cert');"></td>
                      </tr>
                      <c:if test="${mtaConnForm.hasCert}">
                      <tr>
                        <td colspan="3"  class="data1" style="padding-left:24px"></td>
                        <td colspan="2"  class="data1" style="padding-left:24px">
                          <spring:message code="sys.smtp.conn.current" />&nbsp;<a href="/downloadTLSFile.imss?fileType=cert"><spring:message code="sys.smtp.conn.certificateFilename" /></a>
                        </td>
                      </tr>
                      </c:if>
                      <tr> 
                        <td colspan="5" class="data1"><form:checkbox path="useOutgoingTLS" />
                          <spring:message code="sys.smtp.conn.enableOutgoingTLS" /></td>
                      </tr>
                      </c:if>
                    </table>
                  </td>
                </tr>
              </table></td>
          </tr>
        </table></TD>
    </TR>
  </TBODY>
</TABLE>
<table width="540" border="0" cellspacing="0" cellpadding="0">
  <tr> 
    <td height="28" valign="bottom">
        <input type="submit" value="<spring:message code="button.save" />" class="button" style="width:50px" onclick="return checkForm();">
      <input name="cancelbtn" type="button" class="cbutton" value="<spring:message code="button.cancel" />" onClick="self.location.href=('/initSMTPConn.imss')">
       </td>
  </tr>
  <tr>
  	<td>
        <span class="text-error"><c:out value="${changeOK}" /></span>
    </td>
  </tr>
</table>
<form:hidden path="fileType" />
<form:hidden path="hasCaCert" />
<form:hidden path="hasPrivateKey" />
<form:hidden path="hasCert" />
</form:form>
<br>
</BODY>
</HTML>
