#!/bin/sh
export PSQL_BIN=${IMSS_HOME}/PostgreSQL/bin/psql
export ODBCINI=${IMSS_HOME}/config/odbc.ini
export PATCH_FOLDER=${IMSS_HOME}/patch
export TEMP_FOLDER=${PATCH_FOLDER}/temp
export PASSWD_UTIL=${IMSS_HOME}/bin/passwd_util
export PGPASS="/root/.pgpass"
TEMP_TMASE_ZIP_FILE=${TEMP_FOLDER}/engine/libtmaseng.so.zip
TEMP_TMASE_SO_FILE=${TEMP_FOLDER}/engine/libtmaseng.so
TEMP_BACKUP_TMASE_FOLDER=${TEMP_FOLDER}/tmase_backup
TEMP_VSAPI_SO_FILE=${TEMP_FOLDER}/engine/libvsapi.so
TEMP_VSAPI_ZIP_FILE=${TEMP_FOLDER}/engine/libvsapi.so.zip
TEMP_ATSE_SO_FILE=${TEMP_FOLDER}/engine/libatse.so
TEMP_ATSE_ZIP_FILE=${TEMP_FOLDER}/engine/libatse.so.zip
PATCH_TMASE_VER="8.600.1015"
PATCH_VSAPI_VER="12.500.1004"
PATCH_ATSE_VER="12.500.1004"
SCANNER_INFO=${IMSS_HOME}/config/scanner.info
UPDATE_TMASE_SQL=${TEMP_FOLDER}/engine/update_tmase.sql
ROLLBACK_TMASE_SQL=${TEMP_FOLDER}/engine/rollback_tmase.sql
AUCMD_SH=${TEMP_FOLDER}/engine/aucmd.sh

UPDATE_VSAPI_SQL="UPDATE tb_global_setting set value='$PATCH_VSAPI_VER' WHERE name='VersionVirusEngine';"
UPDATE_ATSE_SQL="UPDATE tb_global_setting set value='$PATCH_ATSE_VER' WHERE name='VersionATSEEngine';"
UPDATE_VERSION_SQL="UPDATE tb_version_number set au_uploads=au_uploads+1;"

F_getDBInfo()
{
    DB_USER=`F_ini_get ${ODBCINI} "IMSS" "UserName"`
    DB_SERVER=`F_ini_get ${ODBCINI} "IMSS" "Servername"`
    DB_NAME=`F_ini_get ${ODBCINI} "IMSS" "Database"`
    DB_PASSWD=`F_ini_get ${ODBCINI} "IMSS" "Password"`
    DB_PORT=`F_ini_get ${ODBCINI} "IMSS" "Port"`

    if [ -z "${DB_USER}" -o -z "${DB_SERVER}" -o -z "${DB_NAME}" -o -z "${DB_PASSWD}" -o -z "${DB_PORT}" ]; then
        F_log "Can not get DB information from $ODBCINI."
        return 1
    fi

    return 0
}


F_update_tmase()
{
    CURVER=`F_ini_get $SCANNER_INFO "update" "spam_engine_version"`
    echo "Local TMASE version $CURVER"
    LOCAL_VER1=`echo $CURVER | awk -F'.' '{print $1}'`
    LOCAL_VER2=`echo $CURVER | awk -F'.' '{print $2}'`
    LOCAL_VER3=`echo $CURVER | awk -F'.' '{print $3}'`
    NEED_UPDATE=0
    if [ $LOCAL_VER1 -lt 8 ] ; then
        NEED_UPDATE=1
    fi
    if [ $LOCAL_VER1 -eq 8 ] && [ $LOCAL_VER2 -lt 600 ] ; then
        NEED_UPDATE=1
    fi
    if [ $LOCAL_VER1 -eq 8 ] && [ $LOCAL_VER2 -eq 600 ] && [ $LOCAL_VER3 -lt 1015 ] ; then
        NEED_UPDATE=1
    fi
    F_log "IS_MASTER = $IS_MASTER"
    #check if need to disable rollback.
    #scanner also upgrade with this TMASE engine,so we can not rollback TMASE engine.
    if [ $IS_MASTER -eq 1 ] ; then
        echo "${PSQL_BIN} -U ${DB_USER} -h ${DB_SERVER} -p ${DB_PORT} ${DB_NAME} -t -A -c \"select version from tb_active_update where type=105;\""
        back_up_tmase=`${PSQL_BIN} -U ${DB_USER} -h ${DB_SERVER} -p ${DB_PORT} ${DB_NAME} -t -A -c "select version from tb_active_update where type=105;"`
        if [ -z $back_up_tmase ] ; then
            echo "empty back_up_tmase, so ignore rollback check."
        else
            BACK_VER1=`echo $back_up_tmase | awk -F'.' '{print $1}'`
            BACK_VER2=`echo $back_up_tmase | awk -F'.' '{print $2}'`
            BACK_VER3=`echo $back_up_tmase | awk -F'.' '{print $3}'`
            F_log "Get backup engine version:$back_up_tmase"
            NEED_DISABLE_ROLLBACK=0
            if [ $BACK_VER1 -lt 8 ] ; 
            then
                NEED_DISABLE_ROLLBACK=1
            fi
            if [ $BACK_VER1 -eq 8 ] && [ $BACK_VER2 -lt 500 ] ; 
            then
                NEED_DISABLE_ROLLBACK=1
            fi
            if [ $BACK_VER1 -eq 8 ] && [ $BACK_VER2 -eq 500 ] && [ $BACK_VER3 -lt 1020 ] ; 
            then
                 NEED_DISABLE_ROLLBACK=1
            fi
            if [ $NEED_DISABLE_ROLLBACK -eq 1 ];then
                F_log "Need to disable rollback TMASE ..."
                ${AUCMD_SH} remove 105 
            fi
        fi
    fi
    if [ $NEED_UPDATE -eq 1 ] ; then
        echo "Start to upgrade TMASE engine to $PATCH_TMASE_VER ..."
        touch ${PATCH_FOLDER}/temp/needReplaceTmaseBinary
        /bin/cp -vf $TEMP_TMASE_SO_FILE ${IMSS_HOME}/lib/
        chmod 750 ${IMSS_HOME}/lib/libtmaseng.so
        chown imss:imss ${IMSS_HOME}/lib/libtmaseng.so
        F_ini_add_key $SCANNER_INFO update spam_engine_version $PATCH_TMASE_VER
        F_log "update scanner.info ..."
        if [ $IS_MASTER -eq 1 ] ; then
            echo "update database (master) ..."
            rm -rf $TEMP_BACKUP_TMASE_FOLDER/*
            $AUCMD_SH get 5 $TEMP_BACKUP_TMASE_FOLDER/libtmaseng.so.zip
            old_tmase_ver=`${PSQL_BIN} -U ${DB_USER} -h ${DB_SERVER} -p ${DB_PORT} ${DB_NAME} -t -A -c "select version from tb_active_update where type=5;"`
            echo ${old_tmase_ver} >> ${TEMP_BACKUP_TMASE_FOLDER}/OLD_VER
            # Backup rollback sql
            cp -f ${PATCH_FOLDER}/temp/engine/rollback_tmase.sql ${PATCH_FOLDER}/temp/engine/rollback_tmase.sql.bak
            sed -i "s/OLD_TMASE_VERSION/${old_tmase_ver}/" ${PATCH_FOLDER}/temp/engine/rollback_tmase.sql
            echo "Done backing up TMASE."
            
            echo "Add  TMASE $PATCH_TMASE_VER to db"
            ${AUCMD_SH} add 5 ${TEMP_TMASE_ZIP_FILE} ${PATCH_TMASE_VER}
            #add update db
            $PSQL_BIN -U ${DB_USER} -h ${DB_SERVER} -p ${DB_PORT} ${DB_NAME} -f $UPDATE_TMASE_SQL 
            if [ $? -ne 0 ]; then
                echo "Fail to execute upgrade schema script"
                return 1
            fi

            echo "Update DB schema finished successfully"
        fi
        return 0
    fi
}

F_update_vsapi()
{
    CURVER=`F_ini_get $SCANNER_INFO "update" "virus_engine_version"`
    echo "Local VSAPI version $CURVER"
    LOCAL_VER1=`echo $CURVER | awk -F'.' '{print $1}'`
    LOCAL_VER2=`echo $CURVER | awk -F'.' '{print $2}'`
    LOCAL_VER3=`echo $CURVER | awk -F'.' '{print $3}'`
    NEED_UPDATE=0
    if [ $LOCAL_VER1 -lt 12 ] ; then
        NEED_UPDATE=1
    fi
    if [ $LOCAL_VER1 -eq 12 ] && [ $LOCAL_VER2 -lt 500 ] ; then
        NEED_UPDATE=1
    fi
    if [ $LOCAL_VER1 -eq 12 ] && [ $LOCAL_VER2 -eq 500 ] && [ $LOCAL_VER3 -lt 1004 ] ; then
        NEED_UPDATE=1
    fi
    F_log "IS_MASTER = $IS_MASTER"
    if [ $NEED_UPDATE -eq 1 ] ; then
        echo "Start to upgrade VSAPI engine to $PATCH_VSAPI_VER ..."
        if [ $IS_MASTER -eq 1 ] ; then
            echo "update database (master) ..."
            echo "Add VSAPI $PATCH_VSAPI_VER to DB"
            ${AUCMD_SH} add 0 ${TEMP_VSAPI_SO_FILE} ${PATCH_VSAPI_VER}
            #add update db
            $PSQL_BIN -U ${DB_USER} -h ${DB_SERVER} -p ${DB_PORT} ${DB_NAME} -c "$UPDATE_VSAPI_SQL" 
            $PSQL_BIN -U ${DB_USER} -h ${DB_SERVER} -p ${DB_PORT} ${DB_NAME} -c "$UPDATE_VERSION_SQL"
            if [ $? -ne 0 ]; then
                echo "Fail to execute upgrade schema script"
                return 1
            fi
            echo "Update DB schema finished successfully"
        fi
        return 0
    fi
}

F_update_atse()
{
    CURVER=`F_ini_get $SCANNER_INFO "update" "atse_engine_version"`
    echo "Local ATSE version $CURVER"
    LOCAL_VER1=`echo $CURVER | awk -F'.' '{print $1}'`
    LOCAL_VER2=`echo $CURVER | awk -F'.' '{print $2}'`
    LOCAL_VER3=`echo $CURVER | awk -F'.' '{print $3}'`
    NEED_UPDATE=0
    if [ $LOCAL_VER1 -lt 12 ] ; then
        NEED_UPDATE=1
    fi
    if [ $LOCAL_VER1 -eq 12 ] && [ $LOCAL_VER2 -lt 500 ] ; then
        NEED_UPDATE=1
    fi
    if [ $LOCAL_VER1 -eq 12 ] && [ $LOCAL_VER2 -eq 500 ] && [ $LOCAL_VER3 -lt 1004 ] ; then
        NEED_UPDATE=1
    fi
    F_log "IS_MASTER = $IS_MASTER"
    if [ $NEED_UPDATE -eq 1 ] ; then
        echo "Start to upgrade ATSE engine to $PATCH_ATSE_VER ..."
        if [ $IS_MASTER -eq 1 ] ; then
            echo "update database (master) ..."
            echo "Add ATSE $PATCH_ATSE_VER to DB"
            ${AUCMD_SH} add 9 ${TEMP_ATSE_SO_FILE} ${PATCH_ATSE_VER}
            #add update db
            $PSQL_BIN -U ${DB_USER} -h ${DB_SERVER} -p ${DB_PORT} ${DB_NAME} -c "$UPDATE_ATSE_SQL" 
            $PSQL_BIN -U ${DB_USER} -h ${DB_SERVER} -p ${DB_PORT} ${DB_NAME} -c "$UPDATE_VERSION_SQL"
            if [ $? -ne 0 ]; then
                echo "Fail to execute upgrade schema script"
                return 1
            fi
            echo "Update DB schema finished successfully"
        fi
        return 0
    fi
}

F_install()
{
    F_getDBInfo
    if [ $? -ne 0 ] ; then
        F_log "F_getDBInfo failed."
        return 1
    fi
    
    # touch .pgpass file
    # IP:port:dbname:username:Password
    # 10.64.71.80:5432:imssdb2:postgres:sa
    
    echo "${DB_SERVER}:${DB_PORT}:${DB_NAME}:${DB_USER}:`$PASSWD_UTIL -d $DB_PASSWD`" | sed s/[[:space:]]//g > ${PGPASS}
    #chmod 0600
    [ -f "${PGPASS}" ] && chmod 0600 "${PGPASS}"
    F_update_tmase
    if [ $? -ne 0 ] ; then
        return 1
    fi

    F_update_vsapi
    if [ $? -ne 0 ] ; then
        return 1
    fi

    F_update_atse
    if [ $? -ne 0 ] ; then
        return 1
    fi

    return 0
}

F_rollback()
{
    #cannot rollback. parent-child mode, if rollback may cause unable to start.
    #echo "Checking if need to rollback TMASE schema"
    #if [ -e ${TAG_ROLLBACK_TMASE} ] ; then
    #   rm -rf ${TAG_ROLLBACK_TMASE}
    #   CURVER=`F_ini_get $SCANNER_INFO "update" "spam_engine_version"`
    #   echo "Local TMASE version $CURVER"
    #   if [ x"$CURVER"  != x"$PATCH_TMASE_VER"];then 
    #       echo "No need to rollback TMASE"
    #       return 0
    #   fi
    #   
    #   echo "rollback TMASE engine because it was updated by this HF "
       
    #  old_ver=`cat "${TEMP_BACKUP_TMASE_FOLDER}/OLD_VER"`
    #    ${AUCMD_SH} add 5 ${TEMP_BACKUP_TMASE_FOLDER}/libtmaseng.so.zip  $old_ver
    #    $PSQL_BIN -U sa -d imss  -f $ROLLBACK_TMASE_SQL 
    #    # Rollback db sql
     #   mv -f ${PATCH_FOLDER}/temp/tmase/rollback_tmase.sql.bak ${PATCH_FOLDER}/temp/tmase/rollback_tmase.sql

    #fi
    return 0
}



IS_MASTER=$2
case "$1" in
'install')
    F_install
    ;;
'rollback')
    F_rollback
    ;;

*)
    exit -1
    ;;
esac


