# F_ini_get
# Get the value of a key in an INI file
# Usage: Catch the value using an variable.
# e.g. VAR=`F_ini_get "file" "section" "key"`
#
# param: full path to an INI file 
# param: section name excluding '[' ']'
# param: key name
#
# print: the ini value or error
#
F_ini_get()
{
    INI_F="$1"
    INI_SECTION="$2"
    INI_KEY="$3"

    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
        return 1
    fi
        
    RANGE_START="/^\[${INI_SECTION}\]/"
    RANGE_END="/^\[.*\]/"
        
    MY_SEDCMD_1="${RANGE_START},${RANGE_END}p"
    MY_SEDCMD_2="/^[\t ]*${INI_KEY}[\t ]*=/p"

    _R=`sed -n -e "${MY_SEDCMD_1}" ${INI_F} | sed -n -e "${MY_SEDCMD_2}" | awk -F= '{ printf $2 }'`
    printf "%s" "$_R"
    if [ -z "$_R" ] ; then
        return 1
    else
        return 0
    fi
}

#get a whole section of ini without the section headers and without the Number=xxxx line
F_ini_get_section()
{
    INI_F="$1"
    INI_SECTION="$2"

    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
        return 1
    fi
        
    RANGE_START="/^\[${INI_SECTION}\]/"
    RANGE_END="/^\[.*\]/"
        
    MY_SEDCMD_1="${RANGE_START},${RANGE_END}p"

    _R=`sed -n -e "${MY_SEDCMD_1}" ${INI_F} | grep -v '\[.*\]' | grep -v 'Number='`
    printf "%s\n" "$_R"
    if [ -z "$_R" ] ; then
        return 1
    else
        return 0
    fi

}

F_ini_rename_section()
{
    INI_F="$1"
    OLD_SECTION_NAME="$2"
    NEW_SECTION_NAME="$3"
    TMP_F=/tmp/temp$$
    
    grep -v "^[     ]*#"  $INI_F | grep "\[$OLD_SECTION_NAME\]"  > /dev/null 2>&1
    if [ $? -ne 0 ] ; then
        echo "Section $OLD_SECTION_NAME doesn't exist in $INI_F. Cannot rename."
        return 2
    fi
    sed -e "s/\[$OLD_SECTION_NAME\]/[$NEW_SECTION_NAME]/" ${INI_F} > $TMP_F
    cp -f ${TMP_F} ${INI_F}
    rm -f ${TMP_F}
    return 0

}
#
# detect if a section header exist in the ini
# param: ini file
# param: section_name
F_ini_exist_section()
{
    INI_F="$1"
    INI_NEW_SECTION="$2"
    
    #tab and space before comment still makes a comment line
    grep -v "^[     ]*#"  $INI_F | grep "\[$INI_NEW_SECTION\]"  > /dev/null 2>&1
    if [ $? -eq 0 ] ; then
        #echo "Section $INI_NEW_SECTION has already existed in $INI_F."
        return 0
    fi
    return 1
}

# can not append an already exist section
F_ini_append_section()
{
    INI_F="$1"
    INI_NEW_SECTION="$2"
    INI_SECTION_DATA="$3"
    TMP_F=/tmp/temp$$

    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
        return 1
    fi

    #tab and space before comment still makes a comment line
    grep -v "^[     ]*#"  $INI_F | grep "\[$INI_NEW_SECTION\]"  > /dev/null 2>&1
    if [ $? -eq 0 ] ; then
        echo "Section $INI_NEW_SECTION has already existed in $INI_F."
        return 2
    fi

    cat $INI_F > $TMP_F
    printf "[%s]\n" "$INI_NEW_SECTION" >> $TMP_F
    printf "%s\n" "$INI_SECTION_DATA" >> $TMP_F
    cp -f ${TMP_F} ${INI_F}
    rm -f ${TMP_F}
    return 0
}

F_ini_delete_section()
{
    INI_F="$1"
    INI_SECTION="$2"
    TMP_F=/tmp/temp$$

    if [ ! -f "$INI_F" ] ; then
        echo "${INI_F} not found."
        return 1
    fi

    #tab and space before comment still makes a comment line
    SECTION_BEGIN_LINE=`grep -n "^\[$INI_SECTION\]" $INI_F`  
    if [ $? -ne 0 ] ; then
        echo "Section $INI_SECTION doesn't exist in $INI_F."
        return 2
    fi
    #echo $SECTION_BEGIN_LINE
    SECTION_BEGIN_LINE=`echo $SECTION_BEGIN_LINE | cut -d: -f1`
    #echo $SECTION_BEGIN_LINE

    #tail +$SECTION_BEGIN_LINE $INI_F | grep -n "^\[.*\]" $INI_F
     
    RANGE_START="/^\[${INI_SECTION}\]/"
    RANGE_END="/^\[.*\]/"
        
    MY_SEDCMD_1="${RANGE_START},${RANGE_END}p"

    SECTION_NUMBER_OF_LINES=`sed -n -e "${MY_SEDCMD_1}" ${INI_F} | wc -l`
    LAST_LINE=`sed -n -e "${MY_SEDCMD_1}" ${INI_F} | tail -1`
    #echo $SECTION_NUMBER_OF_LINES  
    #echo $LAST_LINE
    echo $LAST_LINE | grep "^\[.*\]" > /dev/null 2>&1
    if [ $? -eq 0 ] ; then
        SECTION_NUMBER_OF_LINES=`expr $SECTION_NUMBER_OF_LINES - 1`
    fi
    #echo $SECTION_NUMBER_OF_LINES
    SECTION_END_LINE=`expr $SECTION_BEGIN_LINE + $SECTION_NUMBER_OF_LINES - 1`

    sed -e "${SECTION_BEGIN_LINE},${SECTION_END_LINE}d" $INI_F > ${TMP_F}

    cp -f ${TMP_F} ${INI_F}
    rm -f ${TMP_F}
}



# F_ini_set
# Set the value of a key in an INI file
# It uses a temp file.
# e.g. F_ini_set "file" "section" "key" "value"
#
# param: full path to an INI file 
# param: section name excluding '[' ']'
# param: key name
# param: value
#
# print: error
#
F_ini_set() {
    INI_F="$1"
    INI_SECTION="$2"
    INI_KEY="$3"
    INI_VALUE="$4"
    TMP_F=/tmp/temp$$

    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
    return 1
    fi

    RANGE_START="/\[${INI_SECTION}\]/"
    RANGE_END="/\\[.*\]/"

    MY_SEDCMD="${RANGE_START},${RANGE_END}s?^[ \t]*${INI_KEY}=.*?${INI_KEY}=${INI_VALUE}?"
    sed -e "${MY_SEDCMD}" ${INI_F} > ${TMP_F}
    cp -f ${TMP_F} ${INI_F}
    rm -f ${TMP_F}
}

# F_ini_delete_key
# Delete the key in an INI file
# It uses a temp file.
# e.g. F_ini_key_delete "file" "section" "key" 
#
# param: full path to an INI file 
# param: section name excluding '[' ']'
# param: key name
#
# print: error
#
F_ini_delete_key() {
    INI_F="$1"
    INI_SECTION="$2"
    INI_KEY="$3"
    TMP_F=/tmp/temp$$
    TMP_F2=/tmp/t2emp$$

    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
    return 1
    fi

    RANGE_START="/\[${INI_SECTION}\]/"
    RANGE_END="/\\[.*\]/"

    MY_SEDCMD="${RANGE_START},${RANGE_END}s?^[ \t]*${INI_KEY}=.*?DELETE_THIS_KEY?"
    sed -e "${MY_SEDCMD}" ${INI_F} > ${TMP_F}
    MY_SEDCMD2="/DELETE_THIS_KEY/d"
    sed -e "${MY_SEDCMD2}" ${TMP_F} > ${TMP_F2}
    cp -f ${TMP_F2} ${INI_F}
    rm -f ${TMP_F} ${TMP_F2}
}


# F_ini_add_key
# Add a name=value to a section, right next line to the [section] 
# e.g. F_ini_add_key "file" "section" "key" "value"
#
# param: full path to an INI file 
# param: section name excluding '[' ']'
# param: key name
# param: value
#
# print: error
#
F_ini_add_key(){

    INI_F="$1"
    INI_SECTION="$2"
    INI_KEY="$3"
    INI_VALUE="$4"
    TMP_F=/tmp/temp$$

    #if it exists, overwrite
    VAR=`F_ini_get "$INI_F" "$INI_SECTION" "$INI_KEY"`
    if [ $? -eq 0 ] ; then
        F_ini_set "$INI_F" "$INI_SECTION" "$INI_KEY" "$INI_VALUE"
        return 0
    fi


    #where the section is
    SECTION_LINE_NO=`grep -n "^\[$INI_SECTION\]" $INI_F | cut -d: -f1`
    if [ -z "$SECTION_LINE_NO" ] ; then
        echo "Cannot add key to section $INI_SECTION. The section wan not found."
        return 1
    fi
    TOTAL_LINE_NO=`wc -l $INI_F | cut -b1-8 | xargs | awk '{print $1}'`
    REST_LINE_NO=`expr $TOTAL_LINE_NO - $SECTION_LINE_NO`
    #copy first half
    head -$SECTION_LINE_NO ${INI_F} > $TMP_F
    echo "$INI_KEY=$INI_VALUE" >> $TMP_F
    tail -$REST_LINE_NO ${INI_F} >> $TMP_F
    cp -f ${TMP_F} ${INI_F}
    rm -f ${TMP_F}

}

