#!/bin/sh

# The script for IMSS/IMSVA application uninstallation.

# disable ctl-c,ctrl-z and kill
trap "" SIGINT SIGTERM SIGTSTP

if [ -f /etc/trend-release ]; then
    IMSS_HOME=/opt/trend/imss
else
    PREFIX=`rpm -q --queryformat '%{INSTPREFIXES}' imss`
    if [ -d "$PREFIX" ]; then
        IMSS_HOME=$PREFIX/imss
    else
        IMSS_HOME=/opt/trend/imss
    fi
fi
export IMSS_HOME

CUR_DIR=$(cd "$(dirname "$0")"; pwd)
INSTALLER_DIR=$IMSS_HOME/installer
LD_LIBRARY_PATH=$INSTALLER_DIR/imssbase/lib:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH
PATH=$INSTALLER_DIR/imssbase/bin:$PATH
export PATH

# Copy an installer.ini and modify the log path.
cp -af $IMSS_HOME/config/installer.ini $CUR_DIR
sed -e "s,^[ \t]*log_path[ \t]*=.*$,log_path = $CUR_DIR/uninstalllog," -i $CUR_DIR/installer.ini

cd $INSTALLER_DIR
$IMSS_HOME/python/bin/python $INSTALLER_DIR/script/main.py -m uninstall -c $CUR_DIR/installer.ini

# If uninstall successfully finished, remove the installer folder and python folder.
if [ $? -eq 0 ]; then
    cd $CUR_DIR
    rm -rf $IMSS_HOME/installer
    rm -rf $IMSS_HOME/python
fi
