#!/bin/bash
INSTALL_PATH=$1
IMSS_HOME=$INSTALL_PATH/imss
LD_LIBRARY_PATH=$IMSS_HOME/lib/curl:$IMSS_HOME/lib
export LD_LIBRARY_PATH

# NSS database for regular LDAP operations.
mkdir -p $IMSS_HOME/config/nss
chmod 700 $IMSS_HOME/config/nss

# The certutil requires the password should be at least 8 characters long, and should contain at least one non-alphabetic character.
echo trend+micro > $IMSS_HOME/config/nss/pwd
certutil -d sql:$IMSS_HOME/config/nss/ -N -f $IMSS_HOME/config/nss/pwd
chown -R imss:imss $IMSS_HOME/config/nss

# NSS database for test connection from UI.
mkdir -p $IMSS_HOME/temp/nss
chmod 700 $IMSS_HOME/temp/nss
certutil -d sql:$IMSS_HOME/temp/nss/ -N -f $IMSS_HOME/config/nss/pwd
chown -R imss:imss $IMSS_HOME/temp/nss