#!/bin/bash

IMSS_HOME=/opt/trend/imss
PG_HOME=$IMSS_HOME/PostgreSQL
PG_BIN=$PG_HOME/bin
PGDATA_HOME=/var/app_data/imss/db
DB92_BACKUP=/var/app_data/imss/pg92

backup() {
    mode=$1

    #prepare env
    cp -af /mnt/backup/database/libpq.so.5 $PG_HOME/lib
    cp -af /mnt/backup/database/libreadline.so.5 $PG_HOME/lib

    mkdir -p $DB92_BACKUP
    cd $DB92_BACKUP
    #backup admin db first
    if [ "$mode" == "all" ]; then
        /mnt/backup/database/pg_dump -U sa -v -Fc imss > backup_admin.tar 2>>dump.txt
        if [ $? -ne 0 ]; then
            echo "failed to backup database imss!"
            exit 100
        fi
    fi
    #backup euq database
    /mnt/backup/database/pg_dump -U sa -v -Fc imsseuq > backup_euq.tar 2>>dump.txt
    if [ $? -ne 0 ]; then
        echo "failed to backup database imsseuq!"
        exit 120
    fi

    rm -rf $PG_HOME/lib/libpq.so.5
    rm -rf $PG_HOME/lib/libreadline.so.5
}

restore() {
    mode=$1

    cd $DB92_BACKUP
    #restore admin db first
    if [ "$mode" == "all" ]; then
        $PG_BIN/pg_restore -U sa -d postgres -C -v -e < backup_admin.tar 2>>restore.txt
        if [ $? -ne 0 ]; then
            echo "failed to restore database imss!"
            exit 200
        fi
    fi
    #restore euq db
    $PG_BIN/pg_restore -U sa -d postgres -C -v -e < backup_euq.tar 2>>restore.txt
    if [ $? -ne 0 ]; then
        echo "failed to restore database imsseuq!"
        exit 220
    fi
}

case $1 in
  backupAll)
        backup all
        ;;
  backupEuq)
        backup euq
        ;;
  restoreAll)
        restore all
        ;;
  restoreEuq)
        restore euq
        ;;
    *)
    exit 255
        ;;
esac
