#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging

class Log(object):
    """
    This class is used to log information to a certain file.
    """

    def __init__(self, logFilePath):
        """
        Initialize the object.
        """
        self.logFilePath = logFilePath
        self.logger = None
    
    def createLogger(self):
        """
        Create and configure the logger.
        
        return: (ret, object) tuple, if logger is created successfully, ret=0,
        object is the created logger, otherwise, ret=-1, object is the 
        exception occurred.
        """
        # Create a logger.
        self.logger = logging.getLogger("")
        self.logger.setLevel(logging.DEBUG)
        # Create a file log handler.
        try:
            fh = logging.FileHandler(self.logFilePath, "a")
        except Exception, e:
            self.logger = None
            return (-1, e)
        
        fh.setLevel(logging.DEBUG)
        # Create a formatter.
        formatter = logging.Formatter("%(asctime)s [%(process)d:%(thread)d] \
%(message)s [%(filename)s:%(lineno)d]",
                                      "%Y/%m/%d %H:%M:%S %Z")
        fh.setFormatter(formatter)
        # Add the handler to logger
        self.logger.addHandler(fh)
        
        return (0, self.logger)
        
    def getLogger(self):
        """
        Return the logger object. If it is None, create a new one.
        
        return: (ret, object) tuple, if logger is created successfully, ret=0,
        object is the created logger, otherwise, ret=-1, object is the 
        exception occurred.
        """
        if self.logger == None:
            return self.createLogger()
        else:
            return (0, self.logger)
