#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
import getopt
import config
import utility
import log
import step
import resource
import installer
from model import g_upd_models
from installer import *
import os
# Wordings of failed initializations are hard-coded in this script, 
# so they cannot be localized.
msgConfigInitFail = "Fail to initialize configuration module, %s. Please make sure the package is complete and retry.\r\n\
If this issue persists, please contact Technical Support."
msgResourceInitFail = "Fail to initialize resource module, %s. Please make sure the package is complete and retry.\r\n\
If this issue persists, please contact Technical Support."
msgLogInitFail = "Fail to initialize log module, %s. Please make sure the package is complete and retry.\r\n\
If this issue persists, please contact Technical Support."
msgUtilInitFail = "Fail to initialize utility module. Please make sure the package is complete and retry.\r\n\
If this issue persists, please contact Technical Support."
msgWrongArgument = "You have specified a wrong argument, please specify the correct argument and retry."

class MainProgram(object):
    def __init__(self):
        self.conf = None
        self.res = None
        self.logger = None
        self.util = None
    
    def execute(self, args):
        """
        Execute corresponding actions due to passed in arguments.
        args: arguments passed.
        """
        # Parse comand line argument list.
        try:
            optlist, arglist = getopt.getopt(args[1:], "m:c:")
        except Exception:
            print msgWrongArgument
            return -1
        
        for option, value in optlist:
            if option == "-m":
                # Mode argument
                mode = value
            elif option == "-c":
                confPath = value
            else:
                print msgWrongArgument
                return -1

        # Initialize all members. All these members shall be successfully 
        # initialized, or the installation exits.
        self.conf = config.Config()
        # Initialize configurations.
        (ret, exception) = self.conf.loadConfig(confPath)
        if ret != 0:
            print msgConfigInitFail %(utility.excToString(exception))
            return -1
        
        # Initialize resource.
        self.res = resource.Resource()
        (ret, exception) = self.res.loadResFile("resource/%s%s%s" 
                                                %(self.conf.getResFilePrefix(), 
                                                  self.conf.getLanguage(), 
                                                  self.conf.getResFileSuffix()))
        if ret != 0:
            print msgResourceInitFail %(utility.excToString(exception))
            return -1
        
        # Initialize log module.
        (ret, obj) = log.Log(self.conf.getLogPath()).getLogger()
        if ret != 0:
            print msgLogInitFail %(utility.excToString(obj))
            return -1
        self.logger = obj
        
        # Initialize utility module.
        self.util = utility.Utility(self.conf, self.logger)
        if self.util == None:
            print msgUtilInitFail
            return -1
        
        # All initializations finished.
        self.logger.debug("All internal modules have been initialized.")
        
        # Check whether the script is executed by root.
        currentUser = self.util.getCurrentUsername()
        if mode != "initeuqdb":
            if currentUser != "root":
                self.logger.debug("The current user is %s. "
                                  "The script must be executed by root."
                                  %(currentUser))
                print self.res.getWording("msg.needRootPrivilege")
                return -1

        # Check running mode.
        self.logger.debug("Current running mode is %s." %(mode))
        installerInUse = None
        if self.conf.getInstallMode() == 1:
            installerInUse = installer.TerminalInstaller(self.conf, self.res, self.logger, self.util)
        else:
            installerInUse = installer.TuiInstaller(self.conf, self.res, self.logger, self.util)
        if mode == "upgrade":
            # Upgrade the application.
            print self.res.getWording("msg.start_upgrade")
            ret = installerInUse.upgrade()
            return ret
        elif mode == "imss_upgrade":
            self.logger.debug(self.res.getWording("msg.start_upgrade"))
            g_upd_models.initial(conf = self.conf,logger =  self.logger, util = self.util,res=self.res,mode=Const.MODE_IMSS_UPGRADE)
            upd = ImssTuiUpgrade(self.conf, self.res, self.logger, self.util)
            upd.upgrade()
            return ret
        elif mode == "uninstall":
            # Uninstall the application.
            ret = installerInUse.uninstall()
            return ret
        elif mode == "install":
            # Install the application.
            ret = installerInUse.install()
            return ret
        elif mode == "testdb":
            # Test if the database can be connected.
            if len(arglist) < 5:
                self.logger.debug("Incorrect arguments %s for mode %s." %(arglist, mode))
                return -1
            oneStep = step.Step(self.conf, self.res, self.logger, self.util, False, step.TerminalStatusUpdater())
            return oneStep.testDb(arglist[0], arglist[1], arglist[2], arglist[3], arglist[4])
        elif mode == "initeuqdb":
            # Initialize EUQ database before use.
            if len(arglist) < 5:
                self.logger.debug("Incorrect arguments %s for mode %s." %(arglist, mode))
                return -1
            oneStep = step.Step(self.conf, self.res, self.logger, self.util, False, step.TerminalStatusUpdater())
            return oneStep.createEuqDb(arglist[0], (int)(arglist[1]), arglist[2], arglist[3], arglist[4])
        elif mode == "addtrustip":
            # Add an IP into trusted IP list.
            if len(arglist) < 1:
                self.logger.debug("Incorrect arguments %s for mode %s." %(arglist, mode))
                return -1
            oneStep = step.Step(self.conf, self.res, self.logger, self.util, False, step.TerminalStatusUpdater())
            return oneStep.addTrustIp(arglist[0])
        elif mode == "getparentver":
            # Print the OS and app version of the parent in db.
            if len(arglist) < 5:
                self.logger.debug("Incorrect arguments %s for mode %s." %(arglist, mode))
                return -1
            oneStep = step.Step(self.conf, self.res, self.logger, self.util, False, step.TerminalStatusUpdater())
            return oneStep.printParentVersions(arglist[0], arglist[1], arglist[2], arglist[3], arglist[4])
        elif mode == "getsoapport":
            # Print the OS and app version of the parent in db.
            if len(arglist) < 5:
                self.logger.debug("Incorrect arguments %s for mode %s." %(arglist, mode))
                return -1
            oneStep = step.Step(self.conf, self.res, self.logger, self.util, False, step.TerminalStatusUpdater())
            return oneStep.printSoapSvcPort(arglist[0], arglist[1], arglist[2], arglist[3], arglist[4])
        elif mode == "checkipincomplist":
            # Check if the IP address is already in admin DB.
            if len(arglist) < 6:
                self.logger.debug("Incorrect arguments %s for mode %s." %(arglist, mode))
                return -1
            oneStep = step.Step(self.conf, self.res, self.logger, self.util, False, step.TerminalStatusUpdater())
            return oneStep.checkIpInCompList(arglist[0], arglist[1], arglist[2], arglist[3], arglist[4], arglist[5])
        elif mode == "register":
            if len(arglist) < 5:
                self.logger.debug("Incorrect arguments %s for mode %s." %(arglist, mode))
                return -1
            oneStep = step.Step(self.conf, self.res, self.logger, self.util, False, step.TerminalStatusUpdater())
            return oneStep.register(arglist[0], arglist[1], arglist[2], arglist[3], arglist[4], arglist[5])
        elif mode == "start_dryrun":
            oneStep = step.Step(self.conf, self.res, self.logger, self.util, False, step.TerminalStatusUpdater())
            return oneStep.startDryrun()
        elif mode == "stop_dryrun":
            oneStep = step.Step(self.conf, self.res, self.logger, self.util, False, step.TerminalStatusUpdater())
            return oneStep.stopDryrun()
        elif mode == "confirm_upgrade":
            return installerInUse.confirmUpgrade()
        else:
            print msgWrongArgument
            self.logger.debug("Incorrect mode argument %s." %(mode))
            return -1

if __name__ == "__main__":
    mainProg = MainProgram()
    ret = mainProg.execute(sys.argv)
    exit(ret)
    