-- This file will be executed before configuration migration during upgrade.
-- Normally schema changes will be contained in this file.

-- 
-- Part 0. Utilities for upgrade.
--

-- This function is used to insert into tb_global_setting table or ignore.
-- Concurrent access is not considered in this fucntion. During the upgrade,
-- only one connection can operate the imss DATABASE, so concurrency can be
-- ignored.
CREATE OR REPLACE FUNCTION insertGlobalSetting (TEXT, TEXT, TEXT, TEXT, TEXT) RETURNS void AS $BODY$ 
DECLARE
    vSection    ALIAS FOR $1; 
    vName       ALIAS FOR $2;
    vValue      ALIAS FOR $3;
    vInifile    ALIAS FOR $4;
    vNotes      ALIAS FOR $5;
    vRec        RECORD;
BEGIN
    SELECT INTO vRec name FROM tb_global_setting WHERE section = vSection and name = vName;
    IF NOT FOUND THEN
        INSERT INTO tb_global_setting VALUES (vSection, vName, vValue, vInifile, vNotes);
    END IF;
END $BODY$ LANGUAGE 'plpgsql' VOLATILE;


-- 
-- Part 1. Function and Trigger.
--

--Create a procedure that used when change value from 1 to 0, and return the updated result
CREATE or REPLACE FUNCTION changeToZeroInGlobalSetting(vSection TEXT, vName TEXT)
RETURNS INTEGER 
AS $$
DECLARE
    update_count INTEGER;
BEGIN 
    update_count = 0;
    UPDATE tb_global_setting SET value='0' WHERE section=vSection AND name=vName AND value='1';
    GET DIAGNOSTICS update_count = ROW_COUNT;
    RETURN update_count;
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION CheckTableId (int, timestamptz) RETURNS integer AS '
DECLARE
    v_hour_num       ALIAS FOR $1;
    v_starttime      ALIAS FOR $2;
    v_table_id       int;
BEGIN

    select into v_table_id table_id from tb_log_table_info where hour_num = v_hour_num;
    if not found then
        select into v_table_id table_id from tb_log_table_info where hour_num = -1 order by table_id asc limit 1;
        if found then
            update tb_log_table_info set hour_num = v_hour_num, time_start = v_starttime,
                time_end = v_starttime + interval''1 hour'', trafficsum_bookmark = 0, top100data_bookmark = 0,
                reportsum_bookmark = 0, indexed = ''0'', summarized = ''0'', trafficsum_gened = ''0'', top100data_gened = ''0''
                where table_id = v_table_id and not exists(select 1 from tb_log_table_info where hour_num = v_hour_num);
            if found then
                return v_table_id;
            else
                select into v_table_id table_id from tb_log_table_info where hour_num = v_hour_num;
                return v_table_id;
            end if;
        end if;
    else
        return v_table_id;
    end if;
    
    return -1; /* cannot create new tables */
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION checkruleall(int4, int8, "timestamptz")
  RETURNS int4 AS
'
declare
setting RECORD;
current RECORD;
iprule RECORD;
iplog RECORD;
tt timestamptz;
newip RECORD;
BEGIN 

select into newip * from t_cachedip_tmp2 where ip=$2 limit 1;
IF  FOUND THEN

SELECT INTO setting * FROM t_type_setting WHERE type=1;

IF  FOUND THEN
tt=$3-int2interval(setting.duration)*3600;

SELECT INTO current count(*) as allcount,sum(isdha) as count1,sum(isvirus) as count2,
sum(isspam) as count3,sum(isbounced) as count4  from t_cachedip_tmp 
where  ip=$2 and time> tt and time<=$3;
end if;

SELECT INTO setting * FROM t_type_setting WHERE type=1 and enable=true;
IF  FOUND THEN

if (current.allcount<>0) then
if ((current.count1*100.0/current.allcount) > setting.rate ) and (current.allcount >setting.totalmail)
then 
select into iprule * from t_iprule where ip=$2;
if NOT FOUND then
select into iprule * from t_iprule where ipint2string(ip)=ipint2string($2);
if NOT FOUND then
if is_ip_in_approved_or_blocked_subnets(ipint2string($2))=0 then
select into iplog ''matched: ''||current.count1||'' all: ''||current.allcount||'' time ''||$3||'' - ''||($3-int2interval(setting.duration)*3600) as log;
if (setting.action = 3)
THEN
insert into t_iprule ( enable,ip,type,action,createtime,comments, expiration) values (true,$2,1,setting.action,LOCALTIMESTAMP(0),iplog.log, NULL);
ELSE
insert into t_iprule ( enable,ip,type,action,createtime,comments, expiration) values (true,$2,1,setting.action,LOCALTIMESTAMP(0),iplog.log, LOCALTIMESTAMP(0) + int2interval(setting.blockduration));
end if;
delete  from t_cachedip_tmp2 where ip=$2;
	Return 1;
end if;
end if;
end if;
end if;
end if;
end if;

SELECT INTO setting * FROM t_type_setting WHERE type=2 and enable=true;
IF  FOUND THEN

if (current.allcount<>0) then
if ((current.count2*100.0/current.allcount) > setting.rate ) and (current.allcount >setting.totalmail)
then 
select into iprule * from t_iprule where ip=$2;
if NOT FOUND then
select into iprule * from t_iprule where ipint2string(ip)=ipint2string($2);
if NOT FOUND then
if is_ip_in_approved_or_blocked_subnets(ipint2string($2))=0 then
select into iplog ''matched: ''||current.count2||'' all: ''||current.allcount||'' time ''||$3||'' - ''||($3-int2interval(setting.duration)*3600) as log;
if (setting.action = 3)
THEN
insert into t_iprule ( enable,ip,type,action,createtime,comments, expiration) values (true,$2,2,setting.action,LOCALTIMESTAMP(0),iplog.log, NULL);
ELSE
insert into t_iprule ( enable,ip,type,action,createtime,comments, expiration) values (true,$2,2,setting.action,LOCALTIMESTAMP(0),iplog.log, LOCALTIMESTAMP(0) + int2interval(setting.blockduration));
end if;
delete  from t_cachedip_tmp2 where ip=$2;
	Return 1;
end if;
end if;
end if;
end if;
end if;
end if;


SELECT INTO setting * FROM t_type_setting WHERE type=3 and enable=true;
IF  FOUND THEN

if (current.allcount<>0) then
if ((current.count3*100.0/current.allcount) > setting.rate ) and (current.allcount >setting.totalmail)
then 
select into iprule * from t_iprule where ip=$2;
if NOT FOUND then
select into iprule * from t_iprule where ipint2string(ip)=ipint2string($2);
if NOT FOUND then
if is_ip_in_approved_or_blocked_subnets(ipint2string($2))=0 then
select into iplog ''matched: ''||current.count3||'' all: ''||current.allcount||'' time ''||$3||'' - ''||($3-int2interval(setting.duration)*3600) as log;
if (setting.action = 3)
THEN
insert into t_iprule ( enable,ip,type,action,createtime,comments, expiration) values (true,$2,3,setting.action,LOCALTIMESTAMP(0),iplog.log, NULL);
ELSE
insert into t_iprule ( enable,ip,type,action,createtime,comments, expiration) values (true,$2,3,setting.action,LOCALTIMESTAMP(0),iplog.log, LOCALTIMESTAMP(0) + int2interval(setting.blockduration));
end if;
delete  from t_cachedip_tmp2 where ip=$2;
	Return 1;
end if;
end if;
end if;
end if;
end if;
end if;

SELECT INTO setting * FROM t_type_setting WHERE type=4 and enable=true;
IF  FOUND THEN

if (current.allcount<>0) then
if ((current.count4*100.0/current.allcount) > setting.rate ) and (current.allcount >setting.totalmail)
then 
select into iprule * from t_iprule where ip=$2;
if NOT FOUND then
select into iprule * from t_iprule where ipint2string(ip)=ipint2string($2);
if NOT FOUND then
if is_ip_in_approved_or_blocked_subnets(ipint2string($2))=0 then
select into iplog ''matched: ''||current.count4||'' all: ''||current.allcount||'' time ''||$3||'' - ''||($3-int2interval(setting.duration)*3600) as log;
if (setting.action = 3)
THEN
insert into t_iprule ( enable,ip,type,action,createtime,comments, expiration) values (true,$2,4,setting.action,LOCALTIMESTAMP(0),iplog.log, NULL);
ELSE
insert into t_iprule ( enable,ip,type,action,createtime,comments, expiration) values (true,$2,4,setting.action,LOCALTIMESTAMP(0),iplog.log, LOCALTIMESTAMP(0) + int2interval(setting.blockduration));
end if;
delete  from t_cachedip_tmp2 where ip=$2;
	Return 1;
end if;
end if;
end if;
end if;
end if;
end if;




End if; --check if in t_cachedip_tmp2
Return 0;	
END;
'
  LANGUAGE 'plpgsql' VOLATILE;
  
CREATE OR REPLACE FUNCTION checkrulebytype(int4, int8, "timestamptz")
  RETURNS int4 AS
'
declare
setting RECORD;
current RECORD;
iprule RECORD;
iplog RECORD;
tt timestamptz;
newip RECORD;
BEGIN 

select into newip * from t_cachedip_tmp2 where ip=$2 limit 1;
IF  FOUND THEN

SELECT INTO setting * FROM t_type_setting WHERE type=$1 and enable=true;

IF  FOUND THEN
tt=$3-int2interval(setting.duration)*3600;
if $1=1 then
SELECT INTO current count(*) as allcount,sum(isdha) as count from t_cachedip_tmp 
where  ip=$2 and time> tt and time<=$3;
end if;

if $1=2 then
SELECT INTO current count(*) as allcount,sum(isvirus) as count from t_cachedip_tmp 
where  ip=$2 and time> tt and time<=$3;
end if;

if $1=3 then
SELECT INTO current count(*) as allcount,sum(isspam) as count from t_cachedip_tmp 
where  ip=$2 and time> tt and time<=$3;
end if;

if $1=4 then
SELECT INTO current count(*) as allcount,sum(isbounced) as count from t_cachedip_tmp 
where  ip=$2 and time> tt and time<=$3;
end if;

if (current.allcount<>0) then
if ((current.count*100.0/current.allcount) > setting.rate ) and (current.allcount >setting.totalmail)
then 
select into iprule * from t_iprule where ip=$2;
if NOT FOUND then
select into iprule * from t_iprule where ipint2string(ip)=ipint2string($2);
if NOT FOUND then
if is_ip_in_approved_or_blocked_subnets(ipint2string($2))=0 then
select into iplog ''matched: ''||current.count||'' all: ''||current.allcount||'' time ''||$3||'' - ''||($3-int2interval(setting.duration)*3600) as log;
if (setting.action = 3)
THEN
insert into t_iprule ( enable,ip,type,action,createtime,comments, expiration) values (true,$2,$1,setting.action,LOCALTIMESTAMP(0),iplog.log, NULL);
ELSE
insert into t_iprule ( enable,ip,type,action,createtime,comments, expiration) values (true,$2,$1,setting.action,LOCALTIMESTAMP(0),iplog.log, LOCALTIMESTAMP(0) + int2interval(setting.blockduration));
end if;
delete  from t_cachedip_tmp2 where ip=$2;
	Return 1;
end if;
end if;
end if;
end if;
end if;

end if;

End if; --check if in t_cachedip_tmp2
Return 0;	
END;
'
  LANGUAGE 'plpgsql' VOLATILE;


DROP FUNCTION IF EXISTS CleanupDBLog_bak (int, timestamptz);
CREATE OR REPLACE FUNCTION CleanupDBLog (int, timestamptz) RETURNS VOID AS '
DECLARE
    v_type      ALIAS FOR $1;
    v_endtime   ALIAS FOR $2;
    v_tmp       int;         
BEGIN
    if v_type = ''1'' then
        /* cleanup traffic summary and top10 data */
        delete from tb_traffic_summary where endtime < v_endtime;
        delete from tb_top10_individual_traffic where date < v_endtime;
        delete from tb_top10_triggered_rule where endtime < v_endtime;
        delete from tb_top10_virus_code where endtime < v_endtime;
        delete from tb_quarantine_summary where end_time < v_endtime;
        delete from tb_ransomware_detection where time_date < v_endtime;
    else
        if v_type = ''2'' then
            /* cleanup raw lo data*/
            delete from tb_system_event where time_date < v_endtime;
            delete from tb_ip_event where time_date < v_endtime;
            delete from t_sender_filter_blocked_log where blocked_time < v_endtime;
            delete from tb_splited_virus_event where time_date < v_endtime;
            delete from tb_mda_event where date_time < v_endtime;
            delete from tb_uuid_mail_info where date_time < v_endtime;
            
            select scanner_id into v_tmp from tb_component_list where ipprofiler = 1 or ipprofiler = 2;
            if found then
                delete from t_messages where sessionstarttime < v_endtime;
                delete from t_messagesdropped where recordtime < v_endtime;
                delete from t_messagesnull where sessionstarttime < v_endtime;
                delete from t_cachedip where time < v_endtime;
            end if;
        end if;
    end if;
    return;
END;
' LANGUAGE plpgsql;

--Disable all so based rules
CREATE OR REPLACE FUNCTION disableSOBasedRules()
RETURNS INTEGER
AS $$
DECLARE delete_count INTEGER;
BEGIN
    UPDATE tb_global_setting set value = '0' WHERE section = 'cmagent' AND name = 'enable_so_file';
    UPDATE tb_global_setting set value = '0' WHERE section = 'cmagent' AND name = 'enable_so_url';
    UPDATE tb_policy set is_enable = '0' WHERE policy_id=(select policy_id from tb_rule where has_so_file_filter = 1);
    UPDATE tb_policy set is_enable = '0' WHERE policy_id=(select policy_id from tb_rule where has_so_url_filter = 1);
    
    delete_count = 0;
    DELETE FROM tb_custom_defense_blacklist;
    GET DIAGNOSTICS delete_count = ROW_COUNT;
    IF delete_count > 0
    THEN
        UPDATE tb_tables_version set version = version + 1 where tb_name='tb_custom_defense_blacklist';
    END IF;
    
    RETURN 0;
END;
$$ LANGUAGE plpgsql;

--Enable all so based rules
CREATE OR REPLACE FUNCTION enableSOBasedRules()
RETURNS INTEGER
AS $$
DECLARE update_count INTEGER;
BEGIN
    update_count = 0;
    UPDATE tb_global_setting set value = '1' WHERE section = 'cmagent' AND name = 'enable_so_file';
    UPDATE tb_global_setting set value = '1' WHERE section = 'cmagent' AND name = 'enable_so_url';
    UPDATE tb_policy set is_enable = '1' WHERE policy_id=(select policy_id from tb_rule where has_so_file_filter = 1);
    UPDATE tb_policy set is_enable = '1' WHERE policy_id=(select policy_id from tb_rule where has_so_url_filter = 1);
    GET DIAGNOSTICS update_count = ROW_COUNT;
    RETURN update_count;
END;
$$ LANGUAGE plpgsql;

--Disable SO File based rule
CREATE OR REPLACE FUNCTION disableSOFileBasedRule()
RETURNS INTEGER
AS $$
DECLARE delete_count INTEGER;
BEGIN
    UPDATE tb_global_setting set value = '0' WHERE section = 'cmagent' AND name = 'enable_so_file';
    UPDATE tb_policy set is_enable = '0' WHERE policy_id=(select policy_id from tb_rule where has_so_file_filter = 1);
    
    delete_count = 0;
    --SO File is the type 2
    DELETE FROM tb_custom_defense_blacklist WHERE so_type = 2;
    GET DIAGNOSTICS delete_count = ROW_COUNT;
    IF delete_count > 0
    THEN
        UPDATE tb_tables_version set version = version + 1 where tb_name='tb_custom_defense_blacklist';
    END IF;
    
    RETURN 0;
END;
$$ LANGUAGE plpgsql;

--Enable SO File based rule
CREATE OR REPLACE FUNCTION enableSOFileBasedRule()
RETURNS INTEGER
AS $$
DECLARE update_count INTEGER;
BEGIN
    update_count = 0;
    UPDATE tb_global_setting set value = '1' WHERE section = 'cmagent' AND name = 'enable_so_file';
    UPDATE tb_policy set is_enable = '1' WHERE policy_id=(select policy_id from tb_rule where has_so_file_filter = 1);
    GET DIAGNOSTICS update_count = ROW_COUNT;
    RETURN update_count;
END;
$$ LANGUAGE plpgsql;

--Disable SO URL based rule
CREATE OR REPLACE FUNCTION disableSOURLBasedRule()
RETURNS INTEGER
AS $$
DECLARE update_count INTEGER;
BEGIN
    update_count = 0;
    UPDATE tb_global_setting set value = '0' WHERE section = 'cmagent' AND name = 'enable_so_url';
    UPDATE tb_policy set is_enable = '0' WHERE policy_id=(select policy_id from tb_rule where has_so_url_filter = 1);
    GET DIAGNOSTICS update_count = ROW_COUNT;
    RETURN update_count;
END;
$$ LANGUAGE plpgsql;

--Enable SO URL based rule
CREATE OR REPLACE FUNCTION enableSOURLBasedRule()
RETURNS INTEGER
AS $$
DECLARE update_count INTEGER;
BEGIN
    update_count = 0;
    UPDATE tb_global_setting set value = '1' WHERE section = 'cmagent' AND name = 'enable_so_url';
    UPDATE tb_policy set is_enable = '1' WHERE policy_id=(select policy_id from tb_rule where has_so_url_filter = 1);
    GET DIAGNOSTICS update_count = ROW_COUNT;
    RETURN update_count;
END;
$$ LANGUAGE plpgsql;

--removeAllSO
CREATE OR REPLACE FUNCTION removeAllSO(soType int, lastSync bigint, lastID bigint)
RETURNS INTEGER
AS $$
DECLARE delete_count INTEGER;
BEGIN
    delete_count = 0;
    IF soType < 0
    THEN
        DELETE FROM tb_custom_defense_blacklist;
    ELSE
        DELETE FROM tb_custom_defense_blacklist WHERE so_type = soType;
    END IF;
    GET DIAGNOSTICS delete_count = ROW_COUNT;
    IF delete_count > 0
    THEN
        UPDATE tb_tables_version set version = version + 1 WHERE tb_name='tb_custom_defense_blacklist';
    END IF;
    
    UPDATE tb_global_setting set value = lastSync WHERE section = 'custom_defense' AND name = 'last_sync';
    UPDATE tb_global_setting set value = lastID WHERE section = 'custom_defense' AND name = 'last_id';

    RETURN 0;
END;
$$ LANGUAGE plpgsql;

--removeExpiredSO
CREATE OR REPLACE FUNCTION removeExpiredSO(soType int, lastSync bigint, lastID bigint, currentTime bigint)
RETURNS INTEGER
AS $$
DECLARE delete_count INTEGER;
BEGIN
    delete_count = 0;
    IF soType < 0
    THEN
        DELETE FROM tb_custom_defense_blacklist WHERE expiration <= currentTime;
    ELSE
        DELETE FROM tb_custom_defense_blacklist WHERE expiration <= currentTime AND so_type = soType;
    END IF;
    
    GET DIAGNOSTICS delete_count = ROW_COUNT;
    IF delete_count > 0
    THEN
        UPDATE tb_tables_version set version = version + 1 where tb_name='tb_custom_defense_blacklist';
    END IF;
    
    UPDATE tb_global_setting set value = lastSync WHERE section = 'custom_defense' AND name = 'last_sync';
    UPDATE tb_global_setting set value = lastID WHERE section = 'custom_defense' AND name = 'last_id';

    RETURN 0;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION UpdateSOPolicyRule () RETURNS int AS $$
DECLARE
    v_policy_id      int4;
    v_rule_id        int4;
    v_enable_so_file text;
    v_file_enabled   int4;
    v_enable_so_url  text;
    v_url_enabled    int4;
    v_wrs_use_local  text;
    BEGIN 
        SELECT INTO v_enable_so_file value FROM tb_global_setting WHERE section = 'cmagent' and name = 'enable_so_file'; 
        if v_enable_so_file = '1' then  
            v_file_enabled = 1; 
        else
            v_file_enabled = 0;
        end if; 
        SELECT INTO v_enable_so_url value FROM tb_global_setting WHERE section = 'cmagent' and name = 'enable_so_url';  
        if v_enable_so_url = '1' then  
            SELECT INTO v_wrs_use_local value FROM tb_global_setting WHERE section = 'wrsagent' and name = 'use_local';  
            if v_wrs_use_local = '1' then 
                v_url_enabled = 1; 
            else 
                v_url_enabled = 0; 
                update tb_global_setting set value = '0' WHERE section = 'cmagent' and name = 'enable_so_url';  
            end if; 
        else  
            v_url_enabled = 0; 
        end if;
        v_policy_id := nextval('tb_policy_policy_id_seq');
        v_rule_id := nextval('tb_rule_rule_id_seq');
        insert into tb_policy values(v_policy_id, 'TMCM_Suspicious file detection', 201, v_file_enabled, 0, 1,'admin', 'admin', now(), now()); 
        INSERT INTO tb_rule VALUES (v_rule_id, v_policy_id, 0, 'TMCM_Suspicious file detection', 247, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0, 'TMCM_Suspicious file detection.', E'1;5;0;1;*@*;0;;0;;1;*@*;0;;0;;0;;1;1;1;1;151;mode=0\r\nIntellitrap=1\r\nspyw=1\r\nadw=1\r\ndial=1\r\njoke=1\r\nhktl=1\r\nrap=1\r\ncrck=1\r\nothers=1\r\npwdp=1\r\nnoppc=0\r\nva=5\r\nmm=0\r\ngryware=0\r\nmailtrap=0\r\nenableSO=1\r\n;1;0;0;0;1;1;3;2;8;1-100000;', -99999, 0, 0, 0, 0, 1, 0); 
        INSERT INTO tb_named_obj_rule VALUES (100000, v_rule_id);
        INSERT INTO tb_entity_rule VALUES (1, v_rule_id); 
        INSERT INTO tb_entity_rule VALUES (2, v_rule_id); 
        v_policy_id := nextval('tb_policy_policy_id_seq');
        v_rule_id := nextval('tb_rule_rule_id_seq'); 
        insert into tb_policy values(v_policy_id, 'TMCM_Suspicious URL detection', 201, v_url_enabled, 0, 1,'admin', 'admin', now(), now());
        INSERT INTO tb_rule VALUES (v_rule_id, v_policy_id, 0, 'TMCM_Suspicious URL detection', 247, 0, 2, 0, 0, 1, 0, 0, 0, 0, 0, 'TMCM_Suspicious URL detection.', E'1;5;0;1;*@*;0;;0;;1;*@*;0;;0;;0;;0;2;1;8;77;000800000002000710005.0000200000800000000000200000800000000000200000800000000;1;17;13;0:2:1:6:1:0:0;1;0;0;0;1;1;3;2;8;1-100000;', -99998, 1, 0, 0, 0, 0, 1); 
        INSERT INTO tb_named_obj_rule VALUES (100000, v_rule_id);
        INSERT INTO tb_entity_rule VALUES (1, v_rule_id);
        INSERT INTO tb_entity_rule VALUES (2, v_rule_id);
        return 0;
    END;
$$ LANGUAGE plpgsql; 

--updateSyncInfo
CREATE OR REPLACE FUNCTION updateSOSyncInfo(lastSync bigint, lastID bigint)
RETURNS INTEGER
AS $$
BEGIN
    UPDATE tb_global_setting set value = lastSync WHERE section = 'custom_defense' AND name = 'last_sync';
    UPDATE tb_global_setting set value = lastID WHERE section = 'custom_defense' AND name = 'last_id';

    RETURN 0;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION addDdaFileCacheNotExist(vKey TEXT, vRating INT, vVirusNames TEXT, vStatus INT, vModifyTime TIMESTAMP WITH TIME ZONE, vMailId TEXT) RETURNS void AS $BODY$ 
DECLARE
    vRec        RECORD;
BEGIN
    SELECT INTO vRec key FROM tb_dda_file_cache WHERE key = vKey;
    IF NOT FOUND THEN
        INSERT INTO tb_dda_file_cache (key, rating, virus_names, status, modify_time, mail_id) VALUES (vKey, vRating, vVirusNames, vStatus, vModifyTime, vMailId);
    END IF;
END $BODY$ LANGUAGE 'plpgsql' VOLATILE;

CREATE OR REPLACE FUNCTION addDdaFileCache(vKey TEXT, vRating INT, vVirusNames TEXT, vStatus INT, vModifyTime TIMESTAMP WITH TIME ZONE, vMailId TEXT) RETURNS void AS $BODY$ 
DECLARE
    vRec        RECORD;
BEGIN
    DELETE FROM tb_dda_file_cache WHERE key=vKey;
    INSERT INTO tb_dda_file_cache (key, rating, virus_names, status, modify_time, mail_id) VALUES (vKey, vRating, vVirusNames, vStatus, vModifyTime, vMailId);
    
END $BODY$ LANGUAGE 'plpgsql' VOLATILE;

CREATE OR REPLACE FUNCTION PurgeLastDayDataByScanner(int, int) RETURNS integer AS '
DECLARE
    p_scanner_id ALIAS FOR $1;
    qarea ALIAS FOR $2;
    rec_tables RECORD;
    rec_data RECORD;
    rec_Area RECORD;
    rec_Summary RECORD;
    result int;
    last_time timestamptz;
    szQuery varchar(256);
    szTable varchar(32);
    v_scanner_id int;
    v_action int;
BEGIN
    result := 0;
    
    IF qarea = 3 THEN       -- 3 means quarantine
        szTable := ''tb_quarantine'';
        v_action := 7;        -- clean_quarantine_by_time
    ELSIF qarea = 4 THEN    -- 4 means archive
        szTable := ''tb_archive'';
        v_action := 10;       -- clean_archive_by_time
    END IF;

    SELECT INTO v_scanner_id scanner_id FROM tb_euq_action WHERE "scanner_id" = p_scanner_id AND "action" = v_action;
    IF found THEN
        result := -1;
        RETURN result;
    END IF;
    
    FOR rec_tables IN SELECT table_id, time_end FROM tb_log_table_info WHERE hour_num <> -1 ORDER BY time_start ASC LOOP
        szQuery := ''SELECT * FROM '' || szTable || ''_'' || rec_tables.table_id || '' WHERE scanner_id = '' || p_scanner_id || '' LIMIT 1'';
        FOR rec_data IN EXECUTE szQuery LOOP
            result := result + 1;
            last_time := rec_tables.time_end;
            
            -- update tb_named_obj
            FOR rec_Area IN SELECT id FROM tb_named_obj WHERE type = qarea LOOP
                FOR rec_Summary IN EXECUTE ''SELECT COUNT(scanner_id) AS count, SUM(CAST((msg_size*1024) AS int8)) AS msgsize FROM '' || szTable || ''_'' || rec_tables.table_id || '' WHERE scanner_id='' || p_scanner_id || '' AND qa_id='' || rec_Area.id LOOP
                    -- IMSA-7.0-01288, if msg_count = 0, msgsize will be null, the UPDATE will cause data lost
                    IF rec_Summary.count > 0 THEN
                        UPDATE tb_named_obj SET msg_size=msg_size-rec_Summary.msgsize,msg_count=msg_count-rec_Summary.count WHERE id=rec_Area.id;
                    END IF;
                END LOOP;
            END LOOP;
            
            -- remove from tb_quarantine or tb_archive
            EXECUTE ''DELETE FROM '' || szTable || ''_'' || rec_tables.table_id || '' WHERE scanner_id = '' || p_scanner_id;
        END LOOP;
        EXIT WHEN result = 24;
    END LOOP;
    
    IF result > 0 THEN
        INSERT INTO tb_euq_action VALUES ('''', p_scanner_id, '''', v_action, '''', 0, '''', last_time, '''');
        IF qarea = 3 THEN       -- 3 means quarantine, delete EUQ db only if it is quarantine 
            SELECT INTO v_scanner_id scanner_id FROM tb_component_list WHERE euq <> 0;
            -- if EUQ enabled, insert action for EUQ sync
            IF found THEN
                INSERT INTO tb_euq_action VALUES ('''', p_scanner_id, '''', 8, '''', 0, '''', last_time, '''');
            END IF;
        END IF;
    END IF;
    
    RETURN result;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION GenDDASummary(timestamptz, timestamptz) RETURNS SETOF RECORD AS '
DECLARE
	rec_count	RECORD;
	rec_query   RECORD;
	v_starttime 	ALIAS FOR $1;
	v_endtime		ALIAS FOR $2;
BEGIN

    select into rec_query sum(pol_dda_total) as pol_dda_total,
                          sum(dda_no) as dda_no,
                          sum(dda_low) as dda_low,
                          sum(dda_med) as dda_med,
                          sum(dda_high) as dda_high,
                          sum(dda_err) as dda_err,
                          sum(dda_wait) as dda_wait
                          from tb_traffic_summary ts
                          where ts.starttime >= v_starttime and ts.starttime < v_endtime;

    select into rec_count rec_query.pol_dda_total, 1;
    return next rec_count;

    select into rec_count rec_query.dda_high, 2;
    return next rec_count;

    select into rec_count rec_query.dda_med, 3;
    return next rec_count;
    
    select into rec_count rec_query.dda_low, 4;
    return next rec_count;

    select into rec_count rec_query.dda_no, 5;
    return next rec_count;
    
	select into rec_count rec_query.dda_err, 6;
	return next rec_count;

	return;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION GenIPProfSummary(timestamptz, timestamptz) RETURNS SETOF RECORD AS '
DECLARE
    rec_count   RECORD;
    rec_query   RECORD;
    v_starttime   ALIAS FOR $1;
    v_endtime     ALIAS FOR $2;
BEGIN

    select into rec_query sum(ipfilt_conn) as ipfilt_conn,
                          sum(ipfilt_block) as ipfilt_block,
                          sum(ipfilt_virus) as ipfilt_virus,
                          sum(ipfilt_spam) as ipfilt_spam,
                          sum(ipfilt_bounce) as ipfilt_bounce,
                          sum(ipfilt_dha) as ipfilt_dha,
                          sum(ipfilt_manual) as ipfilt_manual
                          from tb_traffic_summary ts
                          where ts.starttime >= v_starttime and ts.starttime < v_endtime;

    /* Total Sender Connections */
    select into rec_count rec_query.ipfilt_conn, 1;
    return next rec_count;

    /* Total Blocked */
    select into rec_count rec_query.ipfilt_block, 2;
    return next rec_count;
    
    /* Virus */
    select into rec_count rec_query.ipfilt_virus, 3;
    return next rec_count;

    /* Spam */  
    select into rec_count rec_query.ipfilt_spam, 4;
    return next rec_count;

    /* Bounced mail  */
    select into rec_count rec_query.ipfilt_bounce, 5;
    return next rec_count;

    /* DHA attack */
    select into rec_count rec_query.ipfilt_dha, 6;
    return next rec_count;

    /* Manual */
    select into rec_count rec_query.ipfilt_manual, 7;
    return next rec_count;
    
    return;
END;
' LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION GenNRSSummary(timestamptz, timestamptz) RETURNS SETOF RECORD AS '
DECLARE
    rec_count   RECORD;
    rec_query   RECORD;
    v_starttime   ALIAS FOR $1;
    v_endtime     ALIAS FOR $2;
BEGIN

    select into rec_query sum(nrs_conn) as nrs_conn,
                          sum(nrs_block) as nrs_block
                          from tb_traffic_summary ts
                          where ts.starttime >= v_starttime and ts.starttime < v_endtime;

    select into rec_count rec_query.nrs_conn, 1;
    return next rec_count;

    select into rec_count rec_query.nrs_block, 2;
    return next rec_count;
    
    return;
END;
' LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION GenTrafficSummaryByNum(timestamptz, timestamptz) RETURNS SETOF RECORD AS '
DECLARE
    rec_count    RECORD;
    rec_query    RECORD;
    v_starttime    ALIAS FOR $1;
    v_endtime      ALIAS FOR $2;
BEGIN

    select into rec_query sum(msg_total) as msg_total,
                          sum(msg_in) as msg_in,
                          sum(msg_out) as msg_out,
                          sum(pol_virus_total) as pol_virus_total,
                          sum(pol_virus_in) as pol_virus_in,
                          sum(pol_virus_out) as pol_virus_out,
                          sum(pol_spyware_total) as pol_spyware_total,
                          sum(pol_spyware_in) as pol_spyware_in,
                          sum(pol_spyware_out) as pol_spyware_out,
                          sum(pol_spam_total) as pol_spam_total,
                          sum(pol_spam_in) as pol_spam_in,
                          sum(pol_spam_out) as pol_spam_out,
                          sum(pol_phish_total) as pol_phish_total,
                          sum(pol_phish_in) as pol_phish_in,
                          sum(pol_phish_out) as pol_phish_out,
                          sum(pol_attach_total) as pol_attach_total,
                          sum(pol_attach_in) as pol_attach_in,
                          sum(pol_attach_out) as pol_attach_out,
                          sum(pol_size_total) as pol_size_total,
                          sum(pol_size_in) as pol_size_in,
                          sum(pol_size_out) as pol_size_out,
                          sum(pol_content_total) as pol_content_total,
                          sum(pol_content_in) as pol_content_in,
                          sum(pol_content_out) as pol_content_out,
                          sum(pol_other_total) as pol_other_total,
                          sum(pol_other_in) as pol_other_in,
                          sum(pol_other_out) as pol_other_out,
                          sum(pol_ipfilt_total) as pol_ipfilt_total,
                          sum(pol_ipfilt_in) as pol_ipfilt_in,
                          sum(pol_ipfilt_out) as pol_ipfilt_out,
                          sum(pol_nrs_total) as pol_nrs_total,
                          sum(pol_nrs_in) as pol_nrs_in,
                          sum(pol_nrs_out) as pol_nrs_out,
                          sum(pol_exception_total) as pol_exception_total,
                          sum(pol_exception_in) as pol_exception_in,
                          sum(pol_exception_out) as pol_exception_out,
                          sum(pol_wrs_total) as pol_wrs_total,
                          sum(pol_wrs_in) as pol_wrs_in,
                          sum(pol_wrs_out) as pol_wrs_out,
                          sum(pol_dkim_total) as pol_dkim_total,
                          sum(pol_dkim_in) as pol_dkim_in,
                          sum(pol_dkim_out) as pol_dkim_out,
                          sum(msg_clean_total) as msg_clean_total,
                          sum(msg_clean_in) as msg_clean_in,
                          sum(msg_clean_out) as msg_clean_out,
                          sum(pol_preflt_total) as pol_preflt_total,
                          sum(pol_preflt_in) as pol_preflt_in,
                          sum(pol_preflt_out) as pol_preflt_out,
                          sum(pol_compliance_total) as pol_compliance_total,
                          sum(pol_compliance_in) as pol_compliance_in,
                          sum(pol_compliance_out) as pol_compliance_out,
                          sum(pol_ibe_total) as pol_ibe_total,
                          sum(pol_ibe_in) as pol_ibe_in,
                          sum(pol_ibe_out) as pol_ibe_out,
                          sum(pol_suspicious_total) as pol_suspicious_total,
                          sum(pol_suspicious_in) as pol_suspicious_in,
                          sum(pol_suspicious_out) as pol_suspicious_out,
                          sum(pol_analyzed_apt_total) as pol_analyzed_apt_total,
                          sum(pol_analyzed_apt_in) as pol_analyzed_apt_in,
                          sum(pol_analyzed_apt_out) as pol_analyzed_apt_out,                          
                          sum(pol_ccca_total) as pol_ccca_total,
                          sum(pol_ccca_in) as pol_ccca_in,
                          sum(pol_ccca_out) as pol_ccca_out,
                          sum(pol_graymail_total) as pol_graymail_total,
                          sum(pol_graymail_in) as pol_graymail_in,
                          sum(pol_graymail_out) as pol_graymail_out,
                          sum(pol_conn_block_total) as pol_conn_block_total,
                          sum(pol_conn_block) as pol_conn_block,
						  sum((0)::numeric) as pol_conn_block_out,
                          sum(pol_so_total) as pol_so_total,
                          sum(pol_so_in) as pol_so_in,
                          sum(pol_so_out) as pol_so_out                          
                          from tb_traffic_summary ts
                          where ts.starttime >= v_starttime and ts.starttime < v_endtime;
    
    select into rec_count rec_query.msg_total, 1;
    return next rec_count;

    select into rec_count rec_query.msg_in, 2;
    return next rec_count;
    
    select into rec_count rec_query.msg_out, 3;
    return next rec_count;

    select into rec_count rec_query.pol_virus_total, 4;
    return next rec_count;

    select into rec_count rec_query.pol_virus_in, 5;
    return next rec_count;
    
    select into rec_count rec_query.pol_virus_out, 6;
    return next rec_count;

    select into rec_count rec_query.pol_spyware_total, 7;
    return next rec_count;

    select into rec_count rec_query.pol_spyware_in, 8;
    return next rec_count;
    
    select into rec_count rec_query.pol_spyware_out, 9;
    return next rec_count;

    select into rec_count rec_query.pol_spam_total, 10;
    return next rec_count;

    select into rec_count rec_query.pol_spam_in, 11;
    return next rec_count;

    select into rec_count rec_query.pol_spam_out, 12;
    return next rec_count;

    select into rec_count rec_query.pol_ccca_total, 13;
    return next rec_count;

    select into rec_count rec_query.pol_ccca_in, 14;
    return next rec_count;

    select into rec_count rec_query.pol_ccca_out, 15;
    return next rec_count; 
    
    select into rec_count rec_query.pol_phish_total, 16;
    return next rec_count;

    select into rec_count rec_query.pol_phish_in, 17;
    return next rec_count;
    
    select into rec_count rec_query.pol_phish_out, 18;
    return next rec_count;

    select into rec_count rec_query.pol_graymail_total, 19;
    return next rec_count;

    select into rec_count rec_query.pol_graymail_in, 20;
    return next rec_count;
    
    select into rec_count rec_query.pol_graymail_out, 21;
    return next rec_count;

    select into rec_count rec_query.pol_wrs_total, 22;
    return next rec_count;

    select into rec_count rec_query.pol_wrs_in, 23;
    return next rec_count;
    
    select into rec_count rec_query.pol_wrs_out, 24;
    return next rec_count;

    select into rec_count rec_query.pol_dkim_total, 25;
    return next rec_count;

    select into rec_count rec_query.pol_dkim_in, 26;
    return next rec_count;
    
    select into rec_count rec_query.pol_dkim_out, 27;
    return next rec_count;
    
    select into rec_count rec_query.pol_attach_total, 28;
    return next rec_count;

    select into rec_count rec_query.pol_attach_in, 29;
    return next rec_count;
    
    select into rec_count rec_query.pol_attach_out, 30;
    return next rec_count;

    select into rec_count rec_query.pol_size_total, 31;
    return next rec_count;

    select into rec_count rec_query.pol_size_in, 32;
    return next rec_count;
    
    select into rec_count rec_query.pol_size_out, 33;
    return next rec_count;
    
    select into rec_count rec_query.pol_content_total, 34;
    return next rec_count;

    select into rec_count rec_query.pol_content_in, 35;
    return next rec_count;
    
    select into rec_count rec_query.pol_content_out, 36;
    return next rec_count;

    select into rec_count rec_query.pol_compliance_total, 37;
    return next rec_count;

    select into rec_count rec_query.pol_compliance_in, 38;
    return next rec_count;
    
    select into rec_count rec_query.pol_compliance_out, 39;
    return next rec_count;

    select into rec_count rec_query.pol_other_total, 40;
    return next rec_count;

    select into rec_count rec_query.pol_other_in, 41;
    return next rec_count;
    
    select into rec_count rec_query.pol_other_out, 42;
    return next rec_count;

    select into rec_count rec_query.pol_exception_total, 43;
    return next rec_count;

    select into rec_count rec_query.pol_exception_in, 44;
    return next rec_count;
    
    select into rec_count rec_query.pol_exception_out, 45;
    return next rec_count;

    select into rec_count rec_query.pol_preflt_total, 46;
    return next rec_count;

    select into rec_count rec_query.pol_preflt_in, 47;
    return next rec_count;
    
    select into rec_count rec_query.pol_preflt_out, 48;
    return next rec_count;

    select into rec_count rec_query.pol_ipfilt_total, 49;
    return next rec_count;

    select into rec_count rec_query.pol_ipfilt_in, 50;
    return next rec_count;
    
    select into rec_count rec_query.pol_ipfilt_out, 51;
    return next rec_count;

    select into rec_count rec_query.pol_nrs_total, 52;
    return next rec_count;

    select into rec_count rec_query.pol_nrs_in, 53;
    return next rec_count;
    
    select into rec_count rec_query.pol_nrs_out, 54;
    return next rec_count;

    select into rec_count rec_query.msg_clean_total, 55;
    return next rec_count;

    select into rec_count rec_query.msg_clean_in, 56;
    return next rec_count;
    
    select into rec_count rec_query.msg_clean_out, 57;
    return next rec_count;

    select into rec_count rec_query.pol_ibe_total, 58;
    return next rec_count;

    select into rec_count rec_query.pol_ibe_in, 59;
    return next rec_count;
    
    select into rec_count rec_query.pol_ibe_out, 60;
    return next rec_count;
   
    select into rec_count rec_query.pol_suspicious_total+rec_query.pol_analyzed_apt_total, 61;
    return next rec_count;

    select into rec_count rec_query.pol_suspicious_in+rec_query.pol_analyzed_apt_in, 62;
    return next rec_count;
    
    select into rec_count rec_query.pol_suspicious_out+rec_query.pol_analyzed_apt_out, 63;
    return next rec_count;
    
    select into rec_count rec_query.pol_so_total, 64;
    return next rec_count;

    select into rec_count rec_query.pol_so_in, 65;
    return next rec_count;
    
    select into rec_count rec_query.pol_so_out, 66;
    return next rec_count;
    
    -- The items only for IMSVA should always be at the tail
    select into rec_count rec_query.pol_conn_block_total, 67;
    return next rec_count;

    select into rec_count rec_query.pol_conn_block, 68;
    return next rec_count;
    
    select into rec_count rec_query.pol_conn_block_out, 69;
    return next rec_count;
    
    return;
END;
' LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION GenTrafficSummaryBySize(timestamptz, timestamptz) RETURNS SETOF RECORD AS '
DECLARE
    rec_sum        RECORD;
    rec_query      RECORD;
    v_starttime      ALIAS FOR $1;
    v_endtime        ALIAS FOR $2;
BEGIN

    select into rec_query sum(msg_total_size) as msg_total_size,
                          sum(msg_in_size) as msg_in_size,
                          sum(msg_out_size) as msg_out_size
                          from tb_traffic_summary ts
                          where ts.starttime >= v_starttime and ts.starttime < v_endtime;
    
    select into rec_sum rec_query.msg_total_size, 1;
    return next rec_sum;

    select into rec_sum rec_query.msg_in_size, 2;
    return next rec_sum;
    
    select into rec_sum rec_query.msg_out_size, 3;
    return next rec_sum;
    
    return;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION GenVirusSummary(timestamptz, timestamptz) RETURNS SETOF RECORD AS '
DECLARE
	rec_count	RECORD;
	rec_query   RECORD;
	v_starttime 	ALIAS FOR $1;
	v_endtime		ALIAS FOR $2;
BEGIN

    select into rec_query sum(pol_virus_total) as pol_virus_total,
                          sum(virus_del) as virus_del,
                          sum(virus_quar) as virus_quar,
                          sum(virus_clean) as virus_clean,
                          sum(virus_attdel) as virus_attdel,
                          sum(ipfilt_virus) as ipfilt_virus
                          from tb_traffic_summary ts
                          where ts.starttime >= v_starttime and ts.starttime < v_endtime;

    select into rec_count rec_query.pol_virus_total, 1;
    return next rec_count;

    select into rec_count rec_query.virus_del, 2;
    return next rec_count;
    
    select into rec_count rec_query.virus_quar, 3;
    return next rec_count;

    select into rec_count rec_query.virus_clean, 4;
    return next rec_count;
    
    select into rec_count rec_query.virus_attdel, 5;
    return next rec_count;
	
	select into rec_count rec_query.ipfilt_virus, 6;
	return next rec_count;
	
	return;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION PurgeAllOldData(int, int, int, int) RETURNS integer AS '
DECLARE
    keep_days ALIAS FOR $1;
    qarea ALIAS FOR $2;
    area_id ALIAS FOR $3;
    max_keep_days ALIAS FOR $4;
    szTable varchar(32);
    result int;
    last_time timestamptz;
    max_last_time timestamptz;
    rec_tables RECORD;
    rec_Summary RECORD;
    rec_Scanner RECORD;
    rec_Date RECORD;
    v_scanner_id int;
    needToDelete bool;
BEGIN
    result := 0;
    
    IF qarea = 3 THEN       -- 3 means quarantine
        szTable := ''tb_quarantine'';
    ELSIF qarea = 4 THEN    -- 4 means archive
        szTable := ''tb_archive'';
    END IF;

    FOR rec_Date IN EXECUTE ''SELECT date_trunc(''''day'''', current_timestamp) - interval '''''' || keep_days || '' days'''' AS date'' LOOP
        last_time := rec_Date.date;
    END LOOP;
    FOR rec_Date IN EXECUTE ''SELECT date_trunc(''''day'''', current_timestamp) - interval '''''' || max_keep_days || '' days'''' AS date'' LOOP
        max_last_time := rec_Date.date;
    END LOOP;
    --SELECT date_trunc(''day'', current_timestamp) - interval ''$1 days'' INTO last_time;
    --SELECT date_trunc(''day'', current_timestamp) - interval ''$4 days'' INTO max_last_time;

    FOR rec_tables IN SELECT table_id FROM tb_log_table_info WHERE time_start < last_time LOOP
        -- update tb_named_obj
        needToDelete := false;
        FOR rec_Summary IN EXECUTE ''SELECT COUNT(qa_id) AS count, SUM(CAST((msg_size*1024) AS int8)) AS msgsize FROM '' || szTable || ''_'' || rec_tables.table_id || '' WHERE time_date < '''''' || last_time || '''''' AND qa_id='' || area_id LOOP
            IF rec_Summary.count > 0 THEN
                needToDelete := true;
                UPDATE tb_named_obj SET msg_size=msg_size-rec_Summary.msgsize,msg_count=msg_count-rec_Summary.count WHERE id=area_id;
            END IF;
        END LOOP;

        IF needToDelete THEN
            EXECUTE ''DELETE FROM '' || szTable || ''_'' || rec_tables.table_id || '' WHERE time_date < '''''' || last_time || '''''' AND qa_id = '' || area_id;
            result := result + 1;
        END IF;
    END LOOP;

    IF result > 0 THEN
        FOR rec_Scanner IN SELECT scanner_id FROM tb_component_list LOOP
            IF qarea = 3 THEN  -- for quarantine, insert action (7)
                INSERT INTO tb_euq_action VALUES ('''', rec_Scanner.scanner_id, '''', 7, '''', 0, '''', max_last_time, '''');
            ELSIF qarea = 4 THEN  -- for archive, insert action (10)
                INSERT INTO tb_euq_action VALUES ('''', rec_Scanner.scanner_id, '''', 10, '''', 0, '''', max_last_time, '''');
            END IF;

            -- if euq enabled, insert action for EUQ sync
            SELECT INTO v_scanner_id scanner_id FROM tb_component_list WHERE euq <> 0;
            IF found THEN
                INSERT INTO tb_euq_action VALUES ('''', rec_Scanner.scanner_id, '''', 9, '''', 0, area_id, last_time, '''');
            END IF;
        END LOOP;
    END IF;

    RETURN result;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION SpamDetectionCount(timestamptz, timestamptz) RETURNS SETOF RECORD AS '
DECLARE
	rec_count	RECORD;
    rec_query   RECORD;
	v_starttime 	ALIAS FOR $1;
	v_endtime		ALIAS FOR $2;
BEGIN

    select into rec_query sum(pol_spam_total) as pol_spam_total,
                          sum(spam_quar) as spam_quar,
                          sum(spam_del) as spam_del,
                          sum(spam_subtag) as spam_subtag,
                          sum(spam_other) as spam_other
                          from tb_traffic_summary ts
                          where ts.starttime >= v_starttime and ts.starttime < v_endtime;

    select into rec_count rec_query.pol_spam_total, 1;
    return next rec_count;

    select into rec_count rec_query.spam_quar, 2;
    return next rec_count;
    
    select into rec_count rec_query.spam_del, 3;
    return next rec_count;

    select into rec_count rec_query.spam_subtag, 4;
    return next rec_count;
    
    select into rec_count rec_query.spam_other, 5;
    return next rec_count;
            	
	return;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION SpamDetectionSumSize(timestamptz, timestamptz) RETURNS SETOF RECORD AS '
DECLARE
    rec_count   RECORD;
    rec_query   RECORD;
	v_starttime 	ALIAS FOR $1;
	v_endtime		ALIAS FOR $2;
BEGIN

    select into rec_query sum(spam_total_size) as spam_total_size,
                          sum(spam_quar_size) as spam_quar_size,
                          sum(spam_del_size) as spam_del_size,
                          sum(spam_subtag_size) as spam_subtag_size,
                          sum(spam_other_size) as spam_other_size
                          from tb_traffic_summary ts
                          where ts.starttime >= v_starttime and ts.starttime < v_endtime;

    select into rec_count rec_query.spam_total_size, 1;
    return next rec_count;

    select into rec_count rec_query.spam_quar_size, 2;
    return next rec_count;
    
    select into rec_count rec_query.spam_del_size, 3;
    return next rec_count;

    select into rec_count rec_query.spam_subtag_size, 4;
    return next rec_count;
    
    select into rec_count rec_query.spam_other_size, 5;
    return next rec_count;
            	
	return;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION GenHourlyTrafficSum(int, timestamptz, timestamptz) RETURNS SETOF RECORD AS '
DECLARE
    cnt_total      INTEGER;
    cnt_incoming   INTEGER;
    cnt_outgoing   INTEGER;
    virus_total    INTEGER;
    spy_total      INTEGER;
    spam_total     INTEGER;
    phish_total    INTEGER;
    wrs_total      INTEGER;
    dkim_total      INTEGER;
    attach_total   INTEGER;
    size_total     INTEGER;
    content_total  INTEGER;
    other_total    INTEGER;
    except_total   INTEGER;
    so_total   INTEGER;
    cnt_totalblock INTEGER;
    cnt_virus      INTEGER;
    cnt_spam       INTEGER;
    cnt_bounce     INTEGER;
    cnt_dha        INTEGER;
    cnt_manual     INTEGER;
    cnt_nrs        INTEGER;
    cnt_smtpblock  INTEGER;
    rec_count      RECORD;
    table_id       ALIAS FOR $1;
    starttime      ALIAS FOR $2;
    endtime        ALIAS FOR $3;
    sqlcmd         text;
BEGIN
    cnt_total := 0;
    cnt_incoming := 0;
    cnt_outgoing := 0;
    sqlcmd := ''select msg_route, count(*) as cnt from (select distinct msg_id, scanner_id, msg_route from tb_policy_event_'' || table_id || '') foo group by msg_route'';
    for rec_count in execute sqlcmd
    loop
        if rec_count.msg_route = 1 then
            cnt_incoming := rec_count.cnt;
        else
            if rec_count.msg_route = 2 then
                cnt_outgoing := rec_count.cnt;
            end if;
        end if;
        cnt_total := cnt_total + rec_count.cnt;
    end loop;
    
    select into rec_count cnt_total, 1;
    return next rec_count;

    select into rec_count cnt_incoming, 2;
    return next rec_count;
    
    select into rec_count cnt_outgoing, 3;
    return next rec_count;

    virus_total      := 0;
    spy_total        := 0;
    spam_total       := 0;
    phish_total      := 0;
    wrs_total        := 0;
    dkim_total        := 0;
    attach_total     := 0;
    size_total       := 0;
    content_total    := 0;
    other_total      := 0;
    except_total     := 0;
    so_total         := 0;

    sqlcmd := ''select sum(filter_type_virus) as virus, sum(filter_type_spyware) as spyware,
            sum(filter_type_spam) as spam, sum(filter_type_phishing) as phishing, sum(filter_type_wrs) as wrs, sum(filter_type_dkim) as dkim,
            sum(filter_type_attachment) as attachment, sum(filter_type_size) as size,
            sum(filter_type_content) as content, sum(filter_type_other) as other,
            sum(filter_type_except) as exception_cnt,
            sum(filter_type_so) as so_cnt from
            (
            select
            case when sum(pe.filter_type_virus::integer) >0 then 1 else 0 end       as filter_type_virus,
            case when sum(pe.filter_type_spyware::integer) >0 then 1 else 0 end     as filter_type_spyware,
            case when sum(pe.filter_type_spam::integer) >0 then 1 else 0 end        as filter_type_spam,
            case when sum(pe.filter_type_phishing::integer) >0 then 1 else 0 end    as filter_type_phishing,
            case when sum(pe.filter_type_wrs::integer) >0 then 1 else 0 end         as filter_type_wrs,
            case when sum(pe.filter_type_dkim::integer) >0 then 1 else 0 end         as filter_type_dkim,
            case when sum(pe.filter_type_attachment::integer) >0 then 1 else 0 end  as filter_type_attachment,
            case when sum(pe.filter_type_size::integer) >0 then 1 else 0 end        as filter_type_size,
            case when sum(pe.filter_type_content::integer) >0 then 1 else 0 end     as filter_type_content,
            case when sum(pe.filter_type_other::integer) >0 then 1 else 0 end       as filter_type_other,
            case when sum(pe.filter_type_so::integer) >0 then 1 else 0 end       as filter_type_so,
            case when sum((pe.filter_type_malformed|pe.filter_type_unscanned)::integer) >0 then 1 else 0 end   as filter_type_except,
            msg_id                                                                  as msg_id,
            scanner_id                                                              as scanner_id
            from tb_policy_event_'' || table_id || '' pe
            group by msg_id, scanner_id
            ) as foo'';
    for rec_count in execute sqlcmd
    loop
        virus_total := virus_total + rec_count.virus;
        spy_total := spy_total + rec_count.spyware;
        spam_total := spam_total + rec_count.spam;
        phish_total := phish_total + rec_count.phishing;
        wrs_total := wrs_total + rec_count.wrs;
        dkim_total := dkim_total + rec_count.dkim;
        attach_total := attach_total + rec_count.attachment;
        size_total := size_total + rec_count.size;
        content_total := content_total + rec_count.content;
        other_total := other_total + rec_count.other;
        except_total := except_total + rec_count.exception_cnt;
        so_total := so_total + rec_count.so_cnt;      
    end loop;
        
    select into rec_count virus_total, 4;
    return next rec_count;
    
    select into rec_count spy_total, 5;
    return next rec_count;

    select into rec_count spam_total, 6;
    return next rec_count;

    select into rec_count phish_total, 7;
    return next rec_count;
    
    select into rec_count wrs_total, 8;
    return next rec_count;

    select into rec_count dkim_total, 9;
    return next rec_count;

    select into rec_count attach_total, 10;
    return next rec_count;

    select into rec_count size_total, 11;
    return next rec_count;

    select into rec_count content_total, 12;
    return next rec_count;

    select into rec_count other_total, 13;
    return next rec_count;

    select into rec_count except_total, 14;
    return next rec_count;
    
    cnt_totalblock := 0;
    cnt_virus := 0;
    cnt_spam := 0;
    cnt_bounce := 0;
    cnt_dha := 0;
    cnt_manual := 0;
    for rec_count in
        select type, sum(count) as cnt from t_blockedip where createtime between starttime and endtime group by type
    loop
        if rec_count.type = 1 then
            cnt_dha := rec_count.cnt;
        end if;
        if rec_count.type = 2 then
            cnt_virus := rec_count.cnt;
        end if;
        if rec_count.type = 3 then
            cnt_spam := rec_count.cnt;
        end if;
        if rec_count.type = 4 then
            cnt_bounce := rec_count.cnt;
        end if;
        if rec_count.type = 5 then
            cnt_manual := rec_count.cnt;
        end if;
        cnt_totalblock := cnt_totalblock + rec_count.cnt;
    end loop;

    /* Total Blocked */
    select into rec_count cnt_totalblock, 15;
    return next rec_count;
    
    /* Virus */
    select into rec_count cnt_virus, 16;
    return next rec_count;

    /* Spam */  
    select into rec_count cnt_spam, 17;
    return next rec_count;

    /* Bounced mail  */
    select into rec_count cnt_bounce, 18;
    return next rec_count;

    /* DHA attack */
    select into rec_count cnt_dha, 19;
    return next rec_count;

    /* Manual */
    select into rec_count cnt_manual, 20;
    return next rec_count;
    
    /* NRS Blocked */
    select into cnt_nrs sum(act_num) from tb_ip_event where action = 1 and time_date between starttime and endtime;
    select into rec_count cnt_nrs, 21;
    return next rec_count;

    /* Blocked ip/sender by SMTP Traffic Throttling */
    select into cnt_smtpblock sum(count) from t_sender_filter_blocked_log where blocked_time between starttime and endtime;
    select into rec_count cnt_smtpblock, 22;
    return next rec_count;
    
    select into rec_count so_total, 23;
    return next rec_count;
    
    return;
END;
' LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION GenLastTime_Policy(int) RETURNS SETOF RECORD AS '
DECLARE
    tables        RECORD;
    lasttime        TIMESTAMPTZ;
    view            RECORD;
    rec_count    RECORD;
    szCmd        text;
    scanner_id    ALIAS FOR $1;
BEGIN
    <<TRAVERSE>>
    for tables in select * from tb_log_table_info where hour_num >= 0 and time_start <= current_timestamp order by time_end desc loop
        szCmd := ''select count(*) as counts from tb_policy_event_'' || tables.table_id || '' where scanner_id = '' || scanner_id;
        for view in execute szCmd loop
            if view.counts > 0 then
                szCmd := ''select max(time_date) at time zone '' || ''''''utc'''''' || '' as last_time from tb_policy_event_'' || tables.table_id ||'' where scanner_id = '' || scanner_id;
                for view in execute szCmd loop
                    lasttime = view.last_time;
                end loop;
                select into rec_count lasttime,1;
                return next rec_count;
                exit TRAVERSE;
            end if;
        end loop;
    end loop;
END;
' LANGUAGE plpgsql;

DROP FUNCTION IF EXISTS smartscanSwitchToConventionalMode();
DROP FUNCTION IF EXISTS AddComponentList ( integer, varchar(80), varchar(128));

CREATE OR REPLACE FUNCTION GenMailTraffic_IPFilt(int, timestamptz, timestamptz) RETURNS SETOF RECORD AS '
DECLARE
    cnt            INTEGER;
    rec_count    RECORD;
    v_scanner_id  ALIAS FOR $1;
    starttime     ALIAS FOR $2;
    endtime        ALIAS FOR $3;
BEGIN
    /* Total IP-Profiler Blocked */
    select into cnt sum(count) from t_blockedip where t_blockedip.scanner_id = v_scanner_id and createtime >= starttime and createtime < endtime;
      select into rec_count cnt, 1;
    return next rec_count;
    
    /* Virus */
    select into cnt sum(count) from t_blockedip where t_blockedip.scanner_id = v_scanner_id and type = 2 and createtime >= starttime and createtime < endtime;
      select into rec_count cnt, 2;
    return next rec_count;

    /* Spam */    
    select into cnt sum(count) from t_blockedip where t_blockedip.scanner_id = v_scanner_id and type = 3 and createtime >= starttime and createtime < endtime;
      select into rec_count cnt, 3;
    return next rec_count;

    /* Bounced mail  */
    select into cnt sum(count) from t_blockedip where t_blockedip.scanner_id = v_scanner_id and type = 4 and createtime >= starttime and createtime < endtime;
      select into rec_count cnt, 4;
    return next rec_count;

    /* DHA attack */
    select into cnt sum(count) from t_blockedip where t_blockedip.scanner_id = v_scanner_id and type = 1 and createtime >= starttime and createtime < endtime;
      select into rec_count cnt, 5;
    return next rec_count;

    /* Manual */
    select into cnt sum(count) from t_blockedip where t_blockedip.scanner_id = v_scanner_id and type = 5 and createtime >= starttime and createtime < endtime;
      select into rec_count cnt, 6;
    return next rec_count;
  
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION GenMailTraffic_NRS(int, timestamptz, timestamptz) RETURNS SETOF RECORD AS '
DECLARE
    cnt            INTEGER;
    rec_count    RECORD;
    v_scanner_id  ALIAS FOR $1;
    starttime     ALIAS FOR $2;
    endtime        ALIAS FOR $3;
BEGIN
    /* NRS Blocked */
    select into cnt sum(act_num) from tb_ip_event where tb_ip_event.scanner_id = v_scanner_id and action = 1 and time_date >= starttime and time_date < endtime;
      select into rec_count cnt, 1;
    return next rec_count;
    
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION GenMailTraffic_Policy(int, timestamptz, timestamptz, int) RETURNS SETOF RECORD AS '
DECLARE
    cnt        INTEGER;
    view        RECORD;
    rec_count    RECORD;
    starttable     INTEGER;
    endtable    INTEGER;
    szCmd         text;
    scanner_id    ALIAS FOR $1;
    starttime     ALIAS FOR $2;
    endtime        ALIAS FOR $3;
    risklevel   ALIAS FOR $4;
BEGIN
    select into starttable * from (select lt.table_id from tb_log_table_info lt where lt.time_start <= starttime and lt.time_end > starttime and lt.hour_num <> -1) foo;
    if found then
    
    /* Total mail */
        szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.dda_status<>100 and pe.scanner_id = '' || scanner_id || '' and pe.time_date >= '''''' || starttime || '''''' 
        and pe.time_date < '''''' || endtime || '''''' group by pe.msg_id, pe.scanner_id) foo'';
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 1;
    return next rec_count;

    /* Incoming */
        szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.dda_status<>100 and pe.scanner_id = '' || scanner_id || '' and pe.msg_route = 1 
        and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''' group by pe.msg_id, pe.scanner_id) foo'';
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
    select into rec_count cnt, 2;
    return next rec_count;
    
    /* Outgoing */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.dda_status<>100 and pe.scanner_id = '' || scanner_id || '' and pe.msg_route = 2
        and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''' group by pe.msg_id, pe.scanner_id) foo'';
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
    select into rec_count cnt, 3;
    return next rec_count;
    
    /* Normal */
    szCmd := ''select sum(clean) as counts from (select
        case when sum(
                     (pe.filter_type_virus|pe.filter_type_spyware|pe.filter_type_spam|pe.filter_type_phishing|pe.filter_type_wrs|pe.filter_type_dkim|pe.filter_type_attachment|pe.filter_type_size|pe.filter_type_content|pe.filter_type_other|pe.filter_type_malformed|pe.filter_type_unscanned|pe.filter_type_preflt|pe.filter_type_compliance|pe.filter_type_ccca|pe.filter_type_graymail|pe.filter_type_so)::integer
                     + case when pe.suspicious_apt_filters_map<>0 then 1 else 0 end
                     + case when pe.analyzed_apt_filters_map<>0 then 1 else 0 end)
                     >0 then 0 else 1 end as clean,
                     pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
                     where pe.dda_status<>100 and pe.dda_status<>102 and pe.dda_status<>104 and pe.scanner_id = '' || scanner_id || '' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''' group by pe.msg_id ) as foo'';
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
    select into rec_count cnt, 4;
    return next rec_count;
    
    /* Virus */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_virus=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo'';
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
    select into rec_count cnt, 5;
    return next rec_count;

        /* Spyware */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_spyware=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 6;
    return next rec_count;

        /* Spam */
        szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_spam=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 7;
    return next rec_count;
    
    /* Phishing */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_phishing=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 8;
    return next rec_count;
    
    /* Attachment */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_attachment=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 9;
    return next rec_count;
    
    /* Size */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_size=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 10;
    return next rec_count;
    
    /* Content */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_content=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 11;
    return next rec_count;
    
    /* Other */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_other=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 12;
    return next rec_count;
    
    /* Malformed, Unscanned */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_malformed=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_unscanned=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := cnt + view.counts;
    end loop;
       select into rec_count cnt, 13;
    return next rec_count;
    
    /* WRS */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_wrs=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 14;
    return next rec_count;
    
    /* DKIM */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_dkim=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 15;
    return next rec_count;
    
    /* PRE-FILTER */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_preflt=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 16;
    return next rec_count;
    
    /* Compliance */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_compliance=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 17;
    return next rec_count;
    
    /* Suspicious */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.suspicious_apt_filters_map<>0 and pe.dda_status<>100 and pe.dda_status<>102 and pe.dda_status<>104 
        and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
    select into rec_count cnt, 18;
    return next rec_count;

    /* Suspicious exploit */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.dda_status<>100 and pe.dda_status<>102 and pe.dda_status<>104 
        and pe.analyzed_apt_filters_map<>0 and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
    select into rec_count cnt, 19;
    return next rec_count;
    
    /* CCCA */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_ccca=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 20;
    return next rec_count;

    /* graymail */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_graymail=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 21;
    return next rec_count;
    
    /* Suspicious Objects */
    szCmd := ''select count(msg_id) as counts from (select pe.msg_id from tb_policy_event_'' || mod(starttable,64*24) || '' pe 
        where pe.scanner_id = '' || scanner_id || '' 
        and pe.filter_type_so=''''1'''' and pe.time_date >= '''''' || starttime || '''''' and pe.time_date < '''''' || endtime || '''''') foo''; 
    for view in execute szCmd loop
        cnt := view.counts;
    end loop;
       select into rec_count cnt, 22;
    return next rec_count;

    end if;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION GenMailTraffic_SMTP_TRAFFIC_THROTTLING(int, timestamptz, timestamptz) RETURNS SETOF RECORD AS '
DECLARE
    cnt            INTEGER;
    rec_count    RECORD;
    v_scanner_id  ALIAS FOR $1;
    starttime     ALIAS FOR $2;
    endtime        ALIAS FOR $3;
BEGIN

    /* smtp conn blocked ip */
    select into cnt sum(count) from t_sender_filter_blocked_log where t_sender_filter_blocked_log.scanner_id = v_scanner_id and type = 1 and blocked_time >= starttime and blocked_time < endtime;
      select into rec_count cnt, 1;
    return next rec_count;

    /* smtp conn blocked sender */
    select into cnt sum(count) from t_sender_filter_blocked_log where t_sender_filter_blocked_log.scanner_id = v_scanner_id and type = 2 and blocked_time >= starttime and blocked_time < endtime;
      select into rec_count cnt, 2;
    return next rec_count;
    
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION GenSmtpConnBlockedSummary(timestamptz, timestamptz) RETURNS SETOF RECORD AS '
DECLARE
    rec_count   			RECORD;
    v_starttime   			ALIAS FOR $1;
    v_endtime     			ALIAS FOR $2;
    blocked_total_count 	INTEGER;
    blocked_ip_count 		INTEGER;
BEGIN

    select into blocked_total_count sum(count)
                          from t_sender_filter_blocked_log ts
                          where ts.blocked_time >= v_starttime and ts.blocked_time < v_endtime and (type = 1 or type = 2);
 
    select into blocked_ip_count sum(count)
                          from t_sender_filter_blocked_log ts
                          where ts.blocked_time >= v_starttime and ts.blocked_time < v_endtime and type = 1;

    select into rec_count blocked_total_count, 1;
    return next rec_count;

    select into rec_count blocked_ip_count, 2;
    return next rec_count;
    
    return;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION getTableIDForTimestamp (atimestamp text) RETURNS integer AS
$body$
DECLARE
    v_TimeStamp TIMESTAMPTZ;
    v_HourNum INTEGER;
    v_TableID INTEGER;
BEGIN
    if (atimestamp is Null) then
        RAISE EXCEPTION 'The parameter is Null at invoking InsertTransac_Full()';
    end if;
    
    v_TimeStamp := date_trunc('hour', atimestamp::TIMESTAMPTZ);
    
    v_HourNum := (floor(extract(epoch from v_TimeStamp)/3600))::INTEGER % 10000;
    SELECT INTO v_TableID CheckTableId(v_HourNum, v_TimeStamp);
    if not found then
    RAISE INFO 'Could not get table_id from tb_log_table_info for timestamp %', v_TimeStamp;                                                 
        return -1;
    else
        return v_TableID;
    end if;
END;
$body$
LANGUAGE 'plpgsql';

CREATE OR REPLACE FUNCTION getNextHourlyTableID (int,int) RETURNS integer AS
$body$
DECLARE
    v_table_id       ALIAS FOR $1;
    v_event_id       ALIAS FOR $2;
    v_TimeStamp      timestamptz;
    v_TableID INTEGER;
    szExecuteCmd text;
    v_result text;
    curs refcursor;
BEGIN    
    szExecuteCmd := 'select time_date from tb_policy_event_' || v_table_id || ' where policy_event_id=' || v_event_id;
    OPEN curs FOR EXECUTE szExecuteCmd;
    FETCH curs INTO v_TimeStamp;
    if not found then
    RAISE INFO 'Could not get time_date from tb_policy_event_% and category id %', v_table_id, v_event_id;                                                 
        return -1;
    end if;     
    
    v_TimeStamp := v_TimeStamp + INTERVAL'1 hour';
    
    v_result := to_char(v_TimeStamp, 'YYYY-MM-DD HH24:MI:SS');
    --RAISE INFO 'getNextHourlyTableID,using new timestamp % to call getTableIDForTimestamp', v_result;
    
    select into v_TableID getTableIDForTimestamp(v_result);
    if not found then
    RAISE INFO 'Could not get table_id from function getNextHourlyTableID()';                                                 
        return -1;
    else
        return v_TableID;
    end if;    
END;
$body$
LANGUAGE 'plpgsql';

CREATE OR REPLACE FUNCTION is_ip_in_smtp_approved_subnets(ip varchar)
RETURNS int AS $$
-- Judge whether an IP is in a subnet of smtp traffic thorttling approved list.
DECLARE
  rec      RECORD;
BEGIN
  FOR rec IN SELECT * FROM t_sender_filter_approved WHERE type = 2 LOOP
    IF is_ip_in_subnet(ip, rec.ip, rec.comments) THEN
      RETURN 1;
    END IF;
  END LOOP;

  RETURN 0;
END;
$$ LANGUAGE plpgsql VOLATILE;

CREATE OR REPLACE FUNCTION random_string(length INTEGER)
RETURNS TEXT
AS $$
DECLARE
    loop_count INTEGER := CEIL(length / 32.); -- how many md5's we need to have at least `length` chars
    output TEXT := ''; -- the result text
    i INT4; -- loop counter
BEGIN

    FOR i IN 1..loop_count LOOP
        output := output || md5(random()::TEXT);
    END LOOP;

    -- get the substring for the exact number of characters
    -- and upper them up
    RETURN substring(output from 1 for length);
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION SetLogTableInfoForTimeRange (time_1 text, time_2 text) RETURNS integer AS
$body$
DECLARE
    v_TimeStamp TIMESTAMPTZ;
    v_endStamp TIMESTAMPTZ;
    v_HourNum INTEGER;
    v_table_id INTEGER;
BEGIN
    if (time_1 is Null) or (time_2 is Null) then
        RAISE EXCEPTION 'At least one parameter is Null at invoking SetLogTableInfoForTimeRange()';
    end if;
    
    v_TimeStamp := date_trunc('hour', time_1::TIMESTAMPTZ);
    v_endStamp := date_trunc('hour', time_2::TIMESTAMPTZ);
    LOOP
        v_HourNum := (floor(extract(epoch from v_TimeStamp)/3600))::INTEGER % 10000;
        SELECT into v_table_id table_id FROM tb_log_table_info WHERE hour_num = v_HourNum;
        if not found then
            select into v_table_id table_id from tb_log_table_info where hour_num = -1 order by table_id asc limit 1;
            if found then           
                update tb_log_table_info set hour_num = v_HourNum, time_start = v_TimeStamp,
                    time_end = v_TimeStamp + interval'1 hour', reportsum_bookmark = '0',
                    indexed = '0'
                    where table_id = v_table_id;
                if not found then
                    RAISE EXCEPTION 'Could not update tb_log_table_info for hour_num %, start_time %', v_HourNum, v_TimeStamp;
                    return -1;   
                end if;
                --RAISE INFO 'Update tb_log_table_info for hour_num %, start_time %', v_HourNum, v_TimeStamp;
            end if;
        end if;
        v_TimeStamp := v_TimeStamp + INTERVAL'1 hour'; 
        if (v_TimeStamp - v_endStamp) > INTERVAL'0 second' then
            return 1;
        end if;
    END LOOP;                                       
END;
$body$
LANGUAGE 'plpgsql';

CREATE OR REPLACE FUNCTION UpdateQuarantineSummary (timestamptz, varchar(256), int) RETURNS VOID AS '
DECLARE
    v_time_date    ALIAS FOR $1;
    v_rule_name    ALIAS FOR $2;
    v_type         ALIAS FOR $3;
    v_rec          RECORD;
    v_start_time   timestamptz;
    v_end_time     timestamptz;
    rec_date       RECORD;
    
BEGIN
    select into v_rec * from tb_quarantine_summary where start_time <= v_time_date and  end_time > v_time_date and rule_name = v_rule_name;
    if not found then   
        select into rec_date date_trunc(''hour'', v_time_date) AS date;
        v_start_time := rec_date.date;
        
        SELECT into rec_date date_trunc(''hour'', v_time_date) + interval ''1 hour'' AS date;
        v_end_time := rec_date.date;

        insert into tb_quarantine_summary values(v_start_time, v_end_time, v_rule_name, 0, 0, 0) on conflict do nothing;
        
    end if;
    
    -- 1: quarantine event, 2: deliver event, 3: reprocess event
    if v_type = 1 then
        update tb_quarantine_summary set quarantine_count = quarantine_count + 1 where start_time <= v_time_date and end_time > v_time_date and rule_name = v_rule_name;
    
    elsif v_type = 2 then
        update tb_quarantine_summary set deliver_count = deliver_count + 1 where start_time <= v_time_date and end_time > v_time_date and rule_name = v_rule_name;
    
    elsif v_type = 3 then
        update tb_quarantine_summary set reprocess_count = reprocess_count + 1 where start_time <= v_time_date and end_time > v_time_date and rule_name = v_rule_name;
    end if;

    return;
END;
' LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION t_iprule_verson_updater() RETURNS trigger AS $$ 
DECLARE
  oldver integer;
BEGIN
	select version into oldver from tb_tables_version where tb_name='t_iprule';
	IF oldver is NULL
	THEN
	    insert into tb_tables_version values ('t_iprule',0);
	ELSE
	    --  2147483642 == 0x7FFFFFFFA
	    IF oldver = 2147483642
	    THEN
	        oldver := 0;
	    ELSE
	        oldver := oldver+1;
	    END IF;
	    update tb_tables_version set version=oldver where tb_name='t_iprule';
	END IF; 
	RETURN NULL;
END
$$ LANGUAGE plpgsql;

CREATE TRIGGER t_iprule_verson_updater_trigger AFTER INSERT OR UPDATE OR DELETE ON t_iprule
    FOR EACH ROW EXECUTE PROCEDURE t_iprule_verson_updater();

CREATE OR REPLACE FUNCTION Update_Traffic_Ipfilt(int, int, timestamptz, timestamptz, int, int, int, int, int, int) RETURNS INTEGER AS '
DECLARE
    rec        RECORD;
    szCmd        text;
    total        alias for $5;
    virus        alias for $6;
    spam        alias for $7;
    bounce        alias for $8;
    dha        alias for $9;
    manual        alias for $10;
    
BEGIN
    szCmd := ''insert into tb_rtstat_mail_traffic_ipfilt values ('' || $1 || '', '' || $2 || '', '''''' ||
         $3 || '''''', '''''' || $4 || '''''', 0, 0, 0, 0, 0, 0, 0, 0, 0)'';
    select into rec * from tb_rtstat_mail_traffic_ipfilt where scanner_id = $1 and interval = $2 and starttime = $3 and endtime = $4;
    if not found then
        execute szCmd;
    end if;

    szCmd := ''update tb_rtstat_mail_traffic_ipfilt set ipfilt_virus = '' || virus || '', ipfilt_spam = '' || spam ||
        '', ipfilt_bounce = '' || bounce || '', ipfilt_dha = '' || dha || '', ipfilt_manual = '' || manual ||
        '' where scanner_id = '' || $1 || '' and interval = '' || $2 || 
        '' and starttime = '''''' || $3 || '''''' and endtime = '''''' || $4 || '''''''';
    execute szCmd;
        
    szCmd := ''update tb_rtstat_mail_traffic_ipfilt set ipfilt_total = ipfilt_virus + ipfilt_spam + ipfilt_bounce + ipfilt_dha + ipfilt_manual + ipfilt_nrs + connection_blocked_ip + 
        connection_blocked_sender'' || 
        '' where scanner_id = '' || $1 || '' and interval = '' || $2 || 
        '' and starttime = '''''' || $3 || '''''' and endtime = '''''' || $4 || '''''''';
    execute szCmd;

    return 0;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION Update_Traffic_NRS(int, int, timestamptz, timestamptz, int) RETURNS INTEGER AS '
DECLARE
    rec        RECORD;
    szCmd        text;
    nrs        alias for $5;
    
BEGIN
    szCmd := ''insert into tb_rtstat_mail_traffic_ipfilt values ('' || $1 || '', '' || $2 || '', '''''' ||
         $3 || '''''', '''''' || $4 || '''''', 0, 0, 0, 0, 0, 0, 0, 0,0)'';
    select into rec * from tb_rtstat_mail_traffic_ipfilt where scanner_id = $1 and interval = $2 and starttime = $3 and endtime = $4;
    if not found then
        execute szCmd;
    end if;

    szCmd := ''update tb_rtstat_mail_traffic_ipfilt set ipfilt_nrs = '' || nrs || 
        '' where scanner_id = '' || $1 || '' and interval = '' || $2 || 
        '' and starttime = '''''' || $3 || '''''' and endtime = '''''' || $4 || '''''''';
    execute szCmd;
        
    szCmd := ''update tb_rtstat_mail_traffic_ipfilt set ipfilt_total = ipfilt_virus + ipfilt_spam + ipfilt_bounce + ipfilt_dha + ipfilt_manual + ipfilt_nrs + connection_blocked_ip + 
        connection_blocked_sender'' || 
        '' where scanner_id = '' || $1 || '' and interval = '' || $2 || 
        '' and starttime = '''''' || $3 || '''''' and endtime = '''''' || $4 || '''''''';
    execute szCmd;

    return 0;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION Update_Traffic_SMTP_TRAFFIC_THROTTLING(int, int, timestamptz, timestamptz, int,int) RETURNS INTEGER AS '
DECLARE
    rec        RECORD;
    szCmd        text;
    conn_blocked_ip        alias for $5;
    conn_blocked_sender alias for $6;
    
BEGIN
    szCmd := ''insert into tb_rtstat_mail_traffic_ipfilt values ('' || $1 || '', '' || $2 || '', '''''' ||
         $3 || '''''', '''''' || $4 || '''''', 0, 0, 0, 0, 0, 0, 0, 0, 0)'';
    select into rec * from tb_rtstat_mail_traffic_ipfilt where scanner_id = $1 and interval = $2 and starttime = $3 and endtime = $4;
    if not found then
        execute szCmd;
    end if;

    szCmd := ''update tb_rtstat_mail_traffic_ipfilt set connection_blocked_ip = '' || conn_blocked_ip || '', connection_blocked_sender = '' || conn_blocked_sender ||
        '' where scanner_id = '' || $1 || '' and interval = '' || $2 || 
        '' and starttime = '''''' || $3 || '''''' and endtime = '''''' || $4 || '''''''';
    execute szCmd;
        
    szCmd := ''update tb_rtstat_mail_traffic_ipfilt set ipfilt_total = ipfilt_virus + ipfilt_spam + ipfilt_bounce + ipfilt_dha + ipfilt_manual + ipfilt_nrs + connection_blocked_ip + 
        connection_blocked_sender'' || 
        '' where scanner_id = '' || $1 || '' and interval = '' || $2 || 
        '' and starttime = '''''' || $3 || '''''' and endtime = '''''' || $4 || '''''''';
    execute szCmd;

    return 0;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION UpdateTlsCertificate () RETURNS int AS $$
DECLARE
    v_rec            RECORD;
BEGIN
        
    SELECT INTO v_rec * from tb_tls_certificate where cert_file_md5='85b0859a7836cd8dfce4816f4614c919';
    if not found then
        INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Trend Micro Inc, CN=Trend Micro S2 CA', 3, 1, 0, '2014-03-01 23:13:48', '2030-12-31 14:06:06', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            5b:46:99:90:ec:75:9d:34
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=AffirmTrust, CN=AffirmTrust Commercial
        Validity
            Not Before: Mar  1 23:13:48 2014 GMT
            Not After : Dec 31 14:06:06 2030 GMT
        Subject: C=US, O=Trend Micro Inc, CN=Trend Micro S2 CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:de:68:90:89:5c:9a:4b:3d:74:b8:2e:c4:bf:fe:
                    09:2e:43:b2:d7:23:f2:e4:3f:f0:b3:d7:06:82:c4:
                    f1:b8:1a:ad:90:d9:dd:56:22:6a:0f:a8:e3:4e:27:
                    54:46:e3:a4:83:d3:05:4a:25:8b:32:c1:45:82:c9:
                    83:76:ee:ef:f0:8c:39:3f:a7:16:a6:66:a7:7f:88:
                    b7:df:a5:9c:97:ca:e1:9a:1e:bb:7a:9f:7a:57:e6:
                    20:20:3c:03:7c:3c:29:d6:c2:29:ff:ec:2e:50:ba:
                    4a:43:f7:c9:79:51:1d:13:5b:cf:a8:c0:22:ff:e7:
                    05:0e:35:4a:ac:92:59:4b:12:dd:ae:79:d3:45:53:
                    18:46:b1:70:ea:e4:cb:2f:8d:0c:b6:7b:49:c5:06:
                    ff:c6:14:92:e2:9e:42:f6:4d:f4:c8:66:c5:39:11:
                    47:c4:a3:0e:e7:0e:66:fb:28:e1:59:43:e5:67:b8:
                    7c:22:9e:9c:aa:34:9e:64:ad:68:5e:f7:8e:35:da:
                    b3:7e:9b:9f:a4:b5:8e:eb:34:48:8a:67:3e:92:c8:
                    f4:15:42:64:24:29:10:ef:6c:66:be:84:bc:cf:92:
                    1a:0b:3b:2c:79:71:71:61:31:58:d9:1c:65:82:c6:
                    bc:eb:13:6c:0b:28:f7:63:be:05:23:bb:be:b9:1f:
                    43:2d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Authority Information Access: 
                CA Issuers - URI:http://ocsp.affirmtrust.com/commca.crt
                OCSP - URI:http://ocsp.affirmtrust.com/comm

            X509v3 Subject Key Identifier: 
                B0:99:E1:90:4E:F3:65:63:28:9C:12:3F:78:56:BA:84:C0:C7:3A:3D
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:9D:93:C6:53:8B:5E:CA:AF:3F:9F:1E:0F:E5:99:95:BC:24:F6:94:8F

            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: http://www.affirmtrust.com/resources/cps

            X509v3 CRL Distribution Points: 
                URI:http://crl.affirmtrust.com/crl/AffirmTrustCommercial.crl

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
        bc:2c:13:61:90:a8:ad:e5:45:9b:44:b3:d1:80:0f:78:c0:de:
        bd:20:8d:28:66:29:37:3f:97:c5:15:e0:c1:65:a9:b9:ba:8c:
        8a:be:7e:04:a6:7b:c4:a3:ae:e7:59:15:1e:f3:13:60:95:60:
        76:9b:ed:b2:72:a0:a5:f0:1f:96:95:54:87:9a:7c:91:50:3f:
        40:44:9e:e3:db:e8:12:a0:96:0e:66:3e:f7:1b:44:63:7c:34:
        01:01:44:be:55:41:ad:97:a1:94:4b:98:9b:c6:7f:2e:e5:ad:
        a6:2c:ec:94:3e:ee:b9:7f:cb:46:de:ff:f2:9f:61:c0:94:23:
        39:f8:a7:cc:97:8a:21:38:90:51:8f:03:f4:41:81:bf:bf:dc:
        09:c5:97:a5:51:b5:dd:5f:0f:13:a4:ce:f0:4f:fd:09:b0:b2:
        f0:7e:f3:7b:7a:ef:08:cb:53:40:31:bf:d4:3a:6d:89:e4:43:
        89:8f:95:9c:c4:db:c6:3f:bc:e3:9e:3a:ad:99:56:8d:54:dd:
        f7:cf:13:e1:5b:68:b5:1c:10:f1:55:e3:5a:98:75:58:12:3c:
        2b:d8:6b:b1:86:1b:c5:38:dd:f5:00:4a:a5:f0:b2:1a:0e:a6:
        76:de:b4:8f:b3:44:de:5a:1f:54:ed:4c:ae:f5:7b:69:13:a9:
        ca:84:72:43
', 'DE6890895C9A4B3D74B82EC4BFFE092E43B2D723F2E43FF0B3D70682C4F1B81AAD90D9DD56226A0FA8E34E275446E3A483D3054A258B32C14582C98376EEEFF08C393FA716A666A77F88B7DFA59C97CAE19A1EBB7A9F7A57E620203C037C3C29D6C229FFEC2E50BA4A43F7C979511D135BCFA8C022FFE7050E354AAC92594B12DDAE79D345531846B170EAE4CB2F8D0CB67B49C506FFC61492E29E42F64DF4C866C5391147C4A30EE70E66FB28E15943E567B87C229E9CAA349E64AD685EF78E35DAB37E9B9FA4B58EEB34488A673E92C8F4154264242910EF6C66BE84BCCF921A0B3B2C797171613158D91C6582C6BCEB136C0B28F763BE0523BBBEB91F432D', '/C=US/O=Trend Micro Inc/CN=Trend Micro S2 CA', 'C=US/O=AffirmTrust/CN=AffirmTrust Commercial', '5B469990EC759D34', NULL, '-----BEGIN CERTIFICATE-----
MIIEeDCCA2CgAwIBAgIIW0aZkOx1nTQwDQYJKoZIhvcNAQELBQAwRDELMAkGA1UEBhMCVVMxFDAS
BgNVBAoMC0FmZmlybVRydXN0MR8wHQYDVQQDDBZBZmZpcm1UcnVzdCBDb21tZXJjaWFsMB4XDTE0
MDMwMTIzMTM0OFoXDTMwMTIzMTE0MDYwNlowQzELMAkGA1UEBhMCVVMxGDAWBgNVBAoMD1RyZW5k
IE1pY3JvIEluYzEaMBgGA1UEAwwRVHJlbmQgTWljcm8gUzIgQ0EwggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDeaJCJXJpLPXS4LsS//gkuQ7LXI/LkP/Cz1waCxPG4Gq2Q2d1WImoPqONO
J1RG46SD0wVKJYsywUWCyYN27u/wjDk/pxamZqd/iLffpZyXyuGaHrt6n3pX5iAgPAN8PCnWwin/
7C5QukpD98l5UR0TW8+owCL/5wUONUqskllLEt2uedNFUxhGsXDq5MsvjQy2e0nFBv/GFJLinkL2
TfTIZsU5EUfEow7nDmb7KOFZQ+VnuHwinpyqNJ5krWhe94412rN+m5+ktY7rNEiKZz6SyPQVQmQk
KRDvbGa+hLzPkhoLOyx5cXFhMVjZHGWCxrzrE2wLKPdjvgUju765H0MtAgMBAAGjggFtMIIBaTBw
BggrBgEFBQcBAQRkMGIwMgYIKwYBBQUHMAKGJmh0dHA6Ly9vY3NwLmFmZmlybXRydXN0LmNvbS9j
b21tY2EuY3J0MCwGCCsGAQUFBzABhiBodHRwOi8vb2NzcC5hZmZpcm10cnVzdC5jb20vY29tbTAd
BgNVHQ4EFgQUsJnhkE7zZWMonBI/eFa6hMDHOj0wDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
gBSdk8ZTi17Krz+fHg/lmZW8JPaUjzBJBgNVHSAEQjBAMD4GBFUdIAAwNjA0BggrBgEFBQcCARYo
aHR0cDovL3d3dy5hZmZpcm10cnVzdC5jb20vcmVzb3VyY2VzL2NwczBJBgNVHR8EQjBAMD6gPKA6
hjhodHRwOi8vY3JsLmFmZmlybXRydXN0LmNvbS9jcmwvQWZmaXJtVHJ1c3RDb21tZXJjaWFsLmNy
bDAOBgNVHQ8BAf8EBAMCAQYwDQYJKoZIhvcNAQELBQADggEBALwsE2GQqK3lRZtEs9GAD3jA3r0g
jShmKTc/l8UV4MFlqbm6jIq+fgSme8SjrudZFR7zE2CVYHab7bJyoKXwH5aVVIeafJFQP0BEnuPb
6BKglg5mPvcbRGN8NAEBRL5VQa2XoZRLmJvGfy7lraYs7JQ+7rl/y0be//KfYcCUIzn4p8yXiiE4
kFGPA/RBgb+/3AnFl6VRtd1fDxOkzvBP/QmwsvB+83t67wjLU0Axv9Q6bYnkQ4mPlZzE28Y/vOOe
Oq2ZVo1U3ffPE+FbaLUcEPFV41qYdVgSPCvYa7GGG8U43fUASqXwshoOpnbetI+zRN5aH1TtTK71
e2kTqcqEckM=
-----END CERTIFICATE-----
', '85b0859a7836cd8dfce4816f4614c919');
    end if;
    
    return 0;
END;
$$ LANGUAGE plpgsql;

DROP FUNCTION IF EXISTS UpdateTrafficSum (timestamptz, timestamptz,
numeric, numeric, numeric, numeric, numeric, numeric, numeric, numeric,
numeric, numeric, numeric, numeric, numeric, numeric, numeric, numeric,
numeric, numeric, numeric, numeric, numeric, numeric,  numeric, numeric, numeric);

DROP FUNCTION IF EXISTS UpdateTrafficSum (timestamptz, timestamptz, 
numeric, numeric, numeric, numeric, numeric, numeric, numeric, numeric, 
numeric, numeric, numeric, numeric, numeric, numeric, numeric, numeric, 
numeric, numeric, numeric, numeric, numeric);


CREATE OR REPLACE FUNCTION UpdateTrafficSum (timestamptz, timestamptz,
numeric, numeric, numeric, numeric, numeric, numeric, numeric, numeric,
numeric, numeric, numeric, numeric, numeric, numeric, numeric, numeric,
numeric, numeric, numeric, numeric, numeric, numeric, numeric) RETURNS VOID AS '
DECLARE
    v_starttime   ALIAS FOR $1;
    v_endtime     ALIAS FOR $2;
    v_tmp         timestamptz;
BEGIN
    select into v_tmp starttime from tb_traffic_summary where starttime = v_starttime;
    if found then
       update tb_traffic_summary set msg_total = $3, msg_in = $4,
       msg_out = $5, pol_virus_total = $6, pol_spyware_total = $7, pol_spam_total = $8,
       pol_phish_total = $9, pol_wrs_total = $10, pol_dkim_total = $11, pol_attach_total = $12, pol_size_total = $13, pol_content_total = $14,
       pol_other_total = $15, pol_exception_total = $16, ipfilt_block = $17, ipfilt_virus = $18,
       ipfilt_spam = $19, ipfilt_bounce = $20, ipfilt_dha = $21, ipfilt_manual = $22,
       nrs_block = $23, pol_conn_block = $24, pol_so_total = $25 where starttime = v_starttime ;
    else
       insert into tb_traffic_summary (starttime, endtime, msg_total, msg_in, msg_out,
       pol_virus_total, pol_spyware_total, pol_spam_total, pol_phish_total, pol_wrs_total, pol_dkim_total, pol_attach_total,
       pol_size_total, pol_content_total, pol_other_total, pol_exception_total,
       ipfilt_block, ipfilt_virus, ipfilt_spam, ipfilt_bounce, ipfilt_dha, ipfilt_manual,
       nrs_block,pol_conn_block, pol_so_total) values (v_starttime, v_endtime,
       $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, $20, $21, $22, $23, $24, $25);
    end if;   

    return;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION GenHourlyTop100Rule(int, timestamptz, timestamptz) RETURNS integer AS '
DECLARE 
    rec_count        RECORD;
    imported         bit;
    table_id         ALIAS FOR $1;
    v_starttime      ALIAS FOR $2;
    v_endtime        ALIAS FOR $3;
    v_tmp            timestamptz;
    sqlcmd           text;
BEGIN
    imported := ''0'';
    select into v_tmp starttime from tb_top10_triggered_rule where starttime = v_starttime;
    if found then
        imported := ''1'';
    end if;
    
    sqlcmd := ''select rule_name, count(rule_name) as cnt from tb_policy_event_'' || table_id ||
    '' where is_rule_triggered and filter_type_preflt = ''''0'''' group by rule_name order by cnt desc limit 100'';
    for rec_count in execute sqlcmd
    loop
        if imported = ''0'' then
            insert into tb_top10_triggered_rule values (v_starttime, v_endtime,
                rec_count.rule_name, rec_count.cnt);
            if not found then
                return -1;
            end if;
        else
            select into v_tmp starttime from tb_top10_triggered_rule where starttime = v_starttime and rule_name = rec_count.rule_name;
            if found then
                update tb_top10_triggered_rule set triggered_count=rec_count.cnt
                where starttime = v_starttime and rule_name = rec_count.rule_name;
                if not found then
                    return -2;
                end if;
            else
                insert into tb_top10_triggered_rule values (v_starttime, v_endtime,
                rec_count.rule_name, rec_count.cnt);
                if not found then
                    return -3;
                end if;
            end if;
        end if;
    end loop;

    return 0;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION GenHourlyPolicySum(int, timestamptz, timestamptz) RETURNS integer AS '
DECLARE
    msg_cnt_total    INTEGER;
    msg_cnt_in       INTEGER;
    msg_cnt_out      INTEGER;
    msg_size_total   float;
    msg_size_in      float;
    msg_size_out     float;
    virus_total      INTEGER;
    virus_incoming   INTEGER;
    virus_outgoing   INTEGER;
    spy_total        INTEGER;
    spy_incoming     INTEGER;
    spy_outgoing     INTEGER;
    spam_total       INTEGER;
    spam_incoming    INTEGER;
    spam_outgoing    INTEGER;
    phish_total      INTEGER;
    phish_incoming   INTEGER;
    phish_outgoing   INTEGER;
    wrs_total        INTEGER;
    wrs_incoming     INTEGER;
    wrs_outgoing     INTEGER;
    dkim_total       INTEGER;
    dkim_incoming    INTEGER;
    dkim_outgoing    INTEGER;
    attach_total     INTEGER;
    attach_incoming  INTEGER;
    attach_outgoing  INTEGER;
    size_total       INTEGER;
    size_incoming    INTEGER;
    size_outgoing    INTEGER;
    content_total    INTEGER;
    content_incoming INTEGER;
    content_outgoing INTEGER;
    other_total      INTEGER;
    other_incoming   INTEGER;
    other_outgoing   INTEGER;
    except_total     INTEGER;
    except_incoming  INTEGER;
    except_outgoing  INTEGER;
    clean_total      INTEGER;
    clean_incoming   INTEGER;
    clean_outgoing   INTEGER;
    preflt_total     INTEGER;
    preflt_incoming  INTEGER;
    preflt_outgoing  INTEGER;
    compliance_total INTEGER;
    compliance_incoming INTEGER;
    compliance_outgoing INTEGER;
     ibe_total INTEGER;
    ibe_incoming INTEGER;
    ibe_outgoing INTEGER;
    cnt_ipprof_conn  INTEGER;
    cnt_ipprof_block INTEGER;
    cnt_virus        INTEGER;
    cnt_spam         INTEGER;
    cnt_bounce       INTEGER;
    cnt_dha          INTEGER;
    cnt_manual       INTEGER;
    cnt_nrs_conn     INTEGER;
    cnt_nrs_block    INTEGER;
    spamact_quar     INTEGER;
    spamact_del      INTEGER;
    spamact_subtag   INTEGER;
    spamact_other    INTEGER;
    spamact_total_size  float;
    spamact_quar_size   float;
    spamact_del_size    float;
    spamact_subtag_size float;
    spamact_other_size  float;
    virusact_del     INTEGER;
    virusact_quar    INTEGER;
    virusact_clean   INTEGER;
    virusact_attdel  INTEGER; 
    decryption_total   INTEGER;
    encryption_total   INTEGER;  
    decryption_size   float;
    encryption_size   float;
    rec_count        RECORD;
    table_id         ALIAS FOR $1;
    v_starttime      ALIAS FOR $2;
    v_endtime        ALIAS FOR $3;
    v_tmp            timestamptz;
    dda_total        INTEGER;
    dda_incoming     INTEGER;
    dda_outgoing     INTEGER;    
    ddava_no         INTEGER;
    ddava_low        INTEGER;
    ddava_med        INTEGER;
    ddava_high       INTEGER;
    ddava_err        INTEGER;
    ddava_wait       INTEGER;
    suspicious_total INTEGER;
    suspicious_incoming INTEGER;
    suspicious_outgoing INTEGER;
    ccca_total       INTEGER;
    ccca_incoming    INTEGER;
    ccca_outgoing    INTEGER;
    graymail_total      INTEGER;
    graymail_incoming   INTEGER;
    graymail_outgoing   INTEGER;
    graymail_cat_mml    INTEGER;
    graymail_cat_scl    INTEGER;
    graymail_cat_oth    INTEGER;
    sqlcmd           text;
    analyzed_apt_total INTEGER;
    analyzed_apt_incoming INTEGER;
    analyzed_apt_outgoing INTEGER;
    cnt_conn_block_conn	INTEGER;
    cnt_conn_block	INTEGER;
    so_total      INTEGER;
    so_incoming   INTEGER;
    so_outgoing   INTEGER;
     
BEGIN
    msg_cnt_total    := 0;
    msg_cnt_in       := 0;
    msg_cnt_out      := 0;
    msg_size_total   := 0;
    msg_size_in      := 0;
    msg_size_out     := 0;
    virus_total      := 0;
    virus_incoming   := 0;
    virus_outgoing   := 0;
    spy_total        := 0;
    spy_incoming     := 0;
    spy_outgoing     := 0;
    spam_total       := 0;
    spam_incoming    := 0;
    spam_outgoing    := 0;
    phish_total      := 0;
    phish_incoming   := 0;
    phish_outgoing   := 0;
    wrs_total        := 0;
    wrs_incoming     := 0;
    wrs_outgoing     := 0;
    dkim_total       := 0;
    dkim_incoming    := 0;
    dkim_outgoing    := 0;
    attach_total     := 0;
    attach_incoming  := 0;
    attach_outgoing  := 0;
    size_total       := 0;
    size_incoming    := 0;
    size_outgoing    := 0;
    content_total    := 0;
    content_incoming := 0;
    content_outgoing := 0;
    other_total      := 0;
    other_incoming   := 0;
    other_outgoing   := 0;
    except_total     := 0;
    except_incoming  := 0;
    except_outgoing  := 0;
    clean_total      := 0;
    clean_incoming   := 0;
    clean_outgoing   := 0;
    preflt_total     := 0;
    preflt_incoming  := 0;
    preflt_outgoing  := 0;
    compliance_total := 0;
    compliance_incoming  := 0;
    compliance_outgoing  := 0;
    ibe_total := 0;
    ibe_incoming  := 0;
    ibe_outgoing  := 0;
    spamact_quar     := 0;
    spamact_del      := 0;
    spamact_subtag   := 0;
    spamact_other    := 0;
    spamact_total_size  := 0;
    spamact_quar_size   := 0;
    spamact_del_size    := 0;
    spamact_subtag_size := 0;
    spamact_other_size  := 0;
    virusact_del     := 0;
    virusact_quar    := 0;
    virusact_clean   := 0;
    virusact_attdel  := 0; 
    decryption_total    := 0;
    encryption_total    := 0; 
    decryption_size   := 0;
    encryption_size    := 0; 
    dda_total := 0;
    dda_incoming := 0;
    dda_outgoing := 0;
    ddava_no    := 0;
    ddava_low   := 0;
    ddava_med   := 0;
    ddava_high  := 0;
    ddava_err   := 0;
    ddava_wait  := 0;
    suspicious_total := 0;
    suspicious_incoming := 0;
    suspicious_outgoing := 0;
    analyzed_apt_total := 0;
    analyzed_apt_incoming := 0;
    analyzed_apt_outgoing := 0;    
    ccca_total        := 0;
    ccca_incoming     := 0;
    ccca_outgoing     := 0;
    graymail_total      := 0;
    graymail_incoming   := 0;
    graymail_outgoing   := 0;
    graymail_cat_mml    := 0;
    graymail_cat_scl    := 0;
    graymail_cat_oth    := 0;
    so_total      := 0;
    so_incoming   := 0;
    so_outgoing   := 0;
    
    sqlcmd := ''select msg_route, count(*) as cnt, sum(msg_size) as sum,
            sum(filter_type_virus) as virus, sum(filter_type_spyware) as spyware,
            sum(filter_type_spam) as spam, sum(filter_type_phishing) as phishing, sum(filter_type_wrs) as wrs, 
            sum(filter_type_dkim) as dkim,
            sum(filter_type_attachment) as attachment, sum(filter_type_size) as size,
            sum(filter_type_content) as content, sum(filter_type_other) as other,
            sum(filter_type_except) as exception_cnt, sum(filter_type_clean) as clean, 
            sum(filter_type_preflt) as preflt, sum(filter_type_compliance) as compliance,
            sum(filter_type_suspicious) as suspicious, sum(filter_type_dda) as dda,
            sum(act_ibe) as ibe,
            sum(spamact_quar) as sa_quar, sum(spamact_del) as sa_del,
            sum(spamact_subtag) as sa_subtag, sum(spamact_other) as sa_other,
            sum(filter_type_spam*msg_size) as sa_total_size,
            sum(spamact_quar*msg_size) as sa_quar_size, sum(spamact_del*msg_size) as sa_del_size,
            sum(spamact_subtag*msg_size) as sa_subtag_size, sum(spamact_other*msg_size) as sa_other_size,
            sum(virusact_del) as va_del, sum(virusact_quar) as va_quar,
            sum(virusact_clean) as va_clean, sum(virusact_attdel) as va_attdel,
            sum(suspicious_no) as dtas_no, sum(suspicious_low) as dtas_low, sum(suspicious_med) as dtas_med,
            sum(suspicious_high) as dtas_high, sum(suspicious_err) as dtas_err, sum(suspicious_wait) as dtas_wait,
            sum(act_dec) as dec, sum(act_enc) as enc ,
            sum(act_dec*msg_size) as dec_size, sum(act_enc*msg_size) as enc_size, sum(filter_type_ccca) as ccca,
            sum(filter_type_graymail) as graymail,
            sum(graymail_cat_mml) as graymail_mml, sum(graymail_cat_scl) as graymail_scl, sum(graymail_cat_oth) as graymail_oth,
            sum(filter_type_analyzed_apt) as analyzed_apt,
            sum(filter_type_so) as so
            from
            (
            select
            case when sum(pe.filter_type_virus::integer) >0 then 1 else 0 end       as filter_type_virus,
            case when sum(pe.filter_type_spyware::integer) >0 then 1 else 0 end     as filter_type_spyware,
            case when sum(case when pe.suspicious_apt_filters_map<>0 then 1 else 0 end) >0 then 1 else 0 end     as filter_type_suspicious,
            case when sum(case when pe.analyzed_apt_filters_map<>0 then 1 else 0 end) >0 then 1 else 0 end     as filter_type_analyzed_apt,
            case when sum((pe.dda_status>0 and pe.dda_status<32765)::integer) >0 then 1 else 0 end   as filter_type_dda,
            case when sum(pe.filter_type_spam::integer) >0 then 1 else 0 end        as filter_type_spam,
            case when sum(pe.filter_type_phishing::integer) >0 then 1 else 0 end    as filter_type_phishing,
            case when sum(pe.filter_type_wrs::integer) >0 then 1 else 0 end         as filter_type_wrs,
            case when sum(pe.filter_type_dkim::integer) >0 then 1 else 0 end        as filter_type_dkim,
            case when sum(pe.filter_type_attachment::integer) >0 then 1 else 0 end  as filter_type_attachment,
            case when sum(pe.filter_type_size::integer) >0 then 1 else 0 end        as filter_type_size,
            case when sum(pe.filter_type_content::integer) >0 then 1 else 0 end     as filter_type_content,
            case when sum(pe.filter_type_other::integer) >0 then 1 else 0 end       as filter_type_other,
            case when sum(pe.filter_type_so::integer) >0 then 1 else 0 end       as filter_type_so,
            case when sum((pe.filter_type_malformed|pe.filter_type_unscanned)::integer) >0 then 1 else 0 end   as filter_type_except,
            case when sum(
                         (pe.filter_type_virus|pe.filter_type_spyware|pe.filter_type_spam|pe.filter_type_phishing|pe.filter_type_wrs|pe.filter_type_dkim|pe.filter_type_attachment|pe.filter_type_size|pe.filter_type_content|pe.filter_type_other|pe.filter_type_malformed|pe.filter_type_unscanned|pe.filter_type_preflt|pe.filter_type_compliance|pe.filter_type_ccca|pe.filter_type_graymail|pe.filter_type_snap|pe.filter_type_so)::integer                       
                         + case when pe.suspicious_apt_filters_map<>0 then 1 else 0 end
                         + case when pe.analyzed_apt_filters_map<>0 then 1 else 0 end) 
                         >0 then 0 else 1 end as filter_type_clean,
            case when sum(pe.filter_type_preflt::integer) >0 then 1 else 0 end      as filter_type_preflt,
            case when sum(pe.filter_type_compliance::integer) >0 then 1 else 0 end      as filter_type_compliance,
            case when sum((pe.act_decryption|pe.act_encryption|pe.act_reencryption)::integer) >0 then 1 else 0 end      as act_ibe,
            case when sum((pe.filter_type_spam&pe.act_quarantined)::integer) >0 then 1 else 0 end              as spamact_quar,
            case when sum((pe.filter_type_spam&pe.act_deleted)::integer) >0 then 1 else 0 end                  as spamact_del,
            case when sum((pe.filter_type_spam&pe.act_subjects_tagged)::integer) >0 then 1 else 0 end          as spamact_subtag,
            case when sum((pe.filter_type_spam&(((~pe.act_quarantined)&(~pe.act_deleted)&(~pe.act_subjects_tagged))|pe.act_delivered|pe.act_archived|pe.act_rcptchanged|pe.act_stamped|pe.act_attachments_deleted|pe.act_delivery_postponed|pe.act_notifications_sent|pe.act_cleaned|pe.act_bcc|pe.act_handoff|pe.act_insert_x_header_tag))::integer) >0 then 1 else 0 end          as spamact_other,
            case when sum((pe.filter_type_virus&pe.act_deleted)::integer) >0 then 1 else 0 end                 as virusact_del,            
            case when sum((pe.filter_type_virus&pe.act_quarantined)::integer) >0 then 1 else 0 end             as virusact_quar,
            case when sum((pe.filter_type_virus&pe.act_cleaned)::integer) >0 then 1 else 0 end                 as virusact_clean,
            case when sum((pe.filter_type_virus&pe.act_attachments_deleted)::integer) >0 then 1 else 0 end     as virusact_attdel,
            case when sum((pe.dda_rating=0)::integer) >0 then 1 else 0 end        as suspicious_no,
            case when sum((pe.dda_rating=1)::integer) >0 then 1 else 0 end        as suspicious_low,
            case when sum((pe.dda_rating=2)::integer) >0 then 1 else 0 end        as suspicious_med,
            case when sum((pe.dda_rating=3)::integer) >0 then 1 else 0 end        as suspicious_high,
            case when sum((pe.dda_rating<0 or (pe.dda_rating>3 and pe.dda_rating<32765) 
                         or pe.dda_status=2 or pe.dda_status=4 or pe.dda_status=11)::integer) >0 then 1 else 0 end        as suspicious_err,
            case when sum((pe.dda_status=1 or pe.dda_status=3)::integer) >0 then 1 else 0 end        as suspicious_wait,
            case when sum(pe.act_decryption::integer) >0 then 1 else 0      end          as act_dec,
            case when sum((pe.act_encryption|pe.act_reencryption)::integer) >0 then 1 else 0      end         as act_enc,
            case when sum(pe.filter_type_ccca::integer) >0 then 1 else 0 end    as filter_type_ccca,
            case when sum(pe.filter_type_graymail::integer) >0 then 1 else 0 end    as filter_type_graymail,
            case when sum((pe.filter_type_graymail=''''1'''' and pe.graymail_category=1)::integer) >0 then 1 else 0 end        as graymail_cat_mml,
            case when sum((pe.filter_type_graymail=''''1'''' and pe.graymail_category=2)::integer) >0 then 1 else 0 end        as graymail_cat_scl,
            case when sum((pe.filter_type_graymail=''''1'''' and pe.graymail_category=0)::integer) >0 then 1 else 0 end        as graymail_cat_oth,
            msg_id                                                                  as msg_id,
            scanner_id                                                              as scanner_id,
            msg_route                                                               as msg_route,
            max(msg_size)                                                           as msg_size
            from tb_policy_event_'' || table_id || '' pe where pe.dda_status<>100 and pe.dda_status<>102 and pe.dda_status<>104
            group by msg_id, scanner_id, msg_route
            ) as foo group by msg_route'';
    for rec_count in execute sqlcmd
    loop
        if rec_count.msg_route = 1 then
            msg_cnt_in := rec_count.cnt;
            msg_size_in := rec_count.sum;
            virus_incoming := rec_count.virus;
            spy_incoming := rec_count.spyware;
            spam_incoming := rec_count.spam;
            phish_incoming := rec_count.phishing;
            wrs_incoming := rec_count.wrs;
            dkim_incoming := rec_count.dkim;
            attach_incoming := rec_count.attachment;
            size_incoming := rec_count.size;
            content_incoming := rec_count.content;
            other_incoming := rec_count.other;
            except_incoming := rec_count.exception_cnt;
            clean_incoming := rec_count.clean;
            preflt_incoming := rec_count.preflt;
            compliance_incoming := rec_count.compliance;
            ibe_incoming := rec_count.ibe;
            dda_incoming := rec_count.dda;
            suspicious_incoming := rec_count.suspicious;
            ccca_incoming := rec_count.ccca;
            graymail_incoming := rec_count.graymail;
            analyzed_apt_incoming := rec_count.analyzed_apt;
            so_incoming := rec_count.so;
        else
            if rec_count.msg_route = 2 then
                msg_cnt_out := rec_count.cnt;
                msg_size_out := rec_count.sum;
                virus_outgoing := rec_count.virus;
                spy_outgoing := rec_count.spyware;
                spam_outgoing := rec_count.spam;
                phish_outgoing := rec_count.phishing;
                wrs_outgoing := rec_count.wrs;
                dkim_outgoing := rec_count.dkim;
                attach_outgoing := rec_count.attachment;
                size_outgoing := rec_count.size;
                content_outgoing := rec_count.content;
                other_outgoing := rec_count.other;
                except_outgoing := rec_count.exception_cnt;
                clean_outgoing := rec_count.clean;
                preflt_outgoing := rec_count.preflt;
                compliance_outgoing := rec_count.compliance;
                ibe_outgoing := rec_count.ibe;
                dda_outgoing := rec_count.dda;
                suspicious_outgoing := rec_count.suspicious;
                ccca_outgoing := rec_count.ccca;
                graymail_outgoing := rec_count.graymail;
                analyzed_apt_outgoing := rec_count.analyzed_apt;
                so_outgoing := rec_count.so;
            end if;
        end if;
        msg_cnt_total := msg_cnt_total + rec_count.cnt;
        msg_size_total := msg_size_total + rec_count.sum;     
        virus_total := virus_total + rec_count.virus;
        spy_total := spy_total + rec_count.spyware;
        spam_total := spam_total + rec_count.spam;
        phish_total := phish_total + rec_count.phishing;
        wrs_total := wrs_total + rec_count.wrs;
        dkim_total := dkim_total + rec_count.dkim;
        attach_total := attach_total + rec_count.attachment;
        size_total := size_total + rec_count.size;
        content_total := content_total + rec_count.content;
        other_total := other_total + rec_count.other;
        except_total := except_total + rec_count.exception_cnt;
        clean_total := clean_total + rec_count.clean;
        preflt_total := preflt_total + rec_count.preflt;
        compliance_total := compliance_total + rec_count.compliance;
        ibe_total := ibe_total + rec_count.ibe;
        spamact_quar := spamact_quar + rec_count.sa_quar;
        spamact_del := spamact_del + rec_count.sa_del;
        spamact_subtag := spamact_subtag + rec_count.sa_subtag;
        spamact_other := spamact_other + rec_count.sa_other;
        spamact_total_size := spamact_total_size + rec_count.sa_total_size;
        spamact_quar_size := spamact_quar_size + rec_count.sa_quar_size;
        spamact_del_size := spamact_del_size + rec_count.sa_del_size;
        spamact_subtag_size := spamact_subtag_size + rec_count.sa_subtag_size;
        spamact_other_size := spamact_other_size + rec_count.sa_other_size;
        virusact_del := virusact_del + rec_count.va_del;
        virusact_quar := virusact_quar + rec_count.va_quar;
        virusact_clean := virusact_clean + rec_count.va_clean;
        virusact_attdel := virusact_attdel + rec_count.va_attdel;
        decryption_total	  := decryption_total + rec_count.dec;
        encryption_total	  := encryption_total + rec_count.enc;
        decryption_size :=decryption_size + rec_count.dec_size;
        encryption_size :=encryption_size + rec_count.enc_size;
        dda_total := dda_total + rec_count.dda;
        ddava_no := ddava_no + rec_count.dtas_no;
        ddava_low := ddava_low + rec_count.dtas_low;
        ddava_med := ddava_med + rec_count.dtas_med;
        ddava_high := ddava_high + rec_count.dtas_high;
        ddava_err := ddava_err + rec_count.dtas_err;
        ddava_wait := ddava_wait + rec_count.dtas_wait;
        suspicious_total := suspicious_total + rec_count.suspicious;
        ccca_total :=ccca_total + rec_count.ccca;
        graymail_total := graymail_total + rec_count.graymail;
        graymail_cat_mml := graymail_cat_mml + rec_count.graymail_mml;
        graymail_cat_scl := graymail_cat_scl + rec_count.graymail_scl;
        graymail_cat_oth := graymail_cat_oth + rec_count.graymail_oth;
        analyzed_apt_total := analyzed_apt_total + rec_count.analyzed_apt;
        so_total := so_total + rec_count.so;
    end loop;

    cnt_ipprof_conn  := 0;
    cnt_ipprof_block := 0;
    cnt_virus        := 0;
    cnt_spam         := 0;
    cnt_bounce       := 0;
    cnt_dha          := 0;
    cnt_manual       := 0;
    
    select into cnt_ipprof_conn count(*) from t_cachedip where time >= v_starttime and time < v_endtime;
    
    for rec_count in
        select type, sum(count) as cnt from t_blockedip where createtime >= v_starttime and createtime < v_endtime group by type
    loop
        if rec_count.type = 1 then
            cnt_dha := rec_count.cnt;
        end if;
        if rec_count.type = 2 then
            cnt_virus := rec_count.cnt;
        end if;
        if rec_count.type = 3 then
            cnt_spam := rec_count.cnt;
        end if;
        if rec_count.type = 4 then
            cnt_bounce := rec_count.cnt;
        end if;
        if rec_count.type = 5 then
            cnt_manual := rec_count.cnt;
        end if;
        cnt_ipprof_block := cnt_ipprof_block + rec_count.cnt;
    end loop;

    cnt_nrs_conn  := 0;
    cnt_nrs_block := 0;
    for rec_count in
        select action, sum(act_num) as cnt from tb_ip_event where time_date >= v_starttime and time_date < v_endtime group by action
    loop
        if rec_count.action = 0 then
            cnt_nrs_conn := rec_count.cnt;
        else
            if rec_count.action = 1 then
                cnt_nrs_block := rec_count.cnt;
            end if;
        end if;
    end loop;
    cnt_ipprof_conn := cnt_ipprof_conn + cnt_nrs_block;

    cnt_conn_block := 0;
    select into cnt_conn_block sum(count) from t_sender_filter_blocked_log where blocked_time >= v_starttime and blocked_time < v_endtime;
    cnt_conn_block_conn  := cnt_conn_block;

    select into v_tmp starttime from tb_traffic_summary where starttime = v_starttime;
    if found then
       update tb_traffic_summary set starttime=v_starttime, endtime=v_endtime,
       msg_total=msg_cnt_total, msg_in=msg_cnt_in, msg_out=msg_cnt_out,
       msg_total_size=msg_size_total, msg_in_size=msg_size_in, msg_out_size=msg_size_out,
       pol_virus_total=virus_total, pol_virus_in=virus_incoming, pol_virus_out=virus_outgoing,
       pol_spyware_total=spy_total, pol_spyware_in=spy_incoming, pol_spyware_out=spy_outgoing,
       pol_spam_total=spam_total, pol_spam_in=spam_incoming, pol_spam_out=spam_outgoing,
       pol_phish_total=phish_total, pol_phish_in=phish_incoming, pol_phish_out=phish_outgoing,
       pol_wrs_total=wrs_total, pol_wrs_in=wrs_incoming, pol_wrs_out=wrs_outgoing,
       pol_dkim_total=dkim_total, pol_dkim_in=dkim_incoming, pol_dkim_out=dkim_outgoing,
       pol_attach_total=attach_total, pol_attach_in=attach_incoming, pol_attach_out=attach_outgoing,
       pol_size_total=size_total, pol_size_in=size_incoming, pol_size_out=size_outgoing,
       pol_content_total=content_total, pol_content_in=content_incoming, pol_content_out=content_outgoing,
       pol_other_total=other_total, pol_other_in=other_incoming, pol_other_out=other_outgoing,
       pol_exception_total=except_total, pol_exception_in=except_incoming, pol_exception_out=except_outgoing,
       pol_ipfilt_total=cnt_ipprof_block, pol_ipfilt_in=cnt_ipprof_block, pol_ipfilt_out=0,
       pol_nrs_total=cnt_nrs_block, pol_nrs_in=cnt_nrs_block, pol_nrs_out=0,
       ipfilt_conn=cnt_ipprof_conn, ipfilt_block=cnt_ipprof_block, ipfilt_virus=cnt_virus, ipfilt_spam=cnt_spam,
       ipfilt_bounce=cnt_bounce, ipfilt_dha=cnt_dha, ipfilt_manual=cnt_manual,
       nrs_conn=cnt_nrs_conn, nrs_block=cnt_nrs_block,
       spam_quar=spamact_quar, spam_del=spamact_del, spam_subtag=spamact_subtag, spam_other=spamact_other, spam_total_size=spamact_total_size,
       spam_quar_size=spamact_quar_size, spam_del_size=spamact_del_size, spam_subtag_size=spamact_subtag_size, spam_other_size=spamact_other_size,
       virus_del=virusact_del, virus_quar=virusact_quar, virus_clean=virusact_clean, virus_attdel=virusact_attdel,
       msg_clean_total=clean_total, msg_clean_in=clean_incoming, msg_clean_out=clean_outgoing,
       pol_preflt_total=preflt_total, pol_preflt_in=preflt_incoming, pol_preflt_out=preflt_outgoing,
       pol_compliance_total=compliance_total, pol_compliance_in=compliance_incoming, pol_compliance_out=compliance_outgoing,
       pol_dec_total=decryption_total, pol_enc_total=encryption_total ,pol_dec_size=decryption_size, pol_enc_size=encryption_size,
       pol_ibe_total=ibe_total, pol_ibe_in=ibe_incoming, pol_ibe_out=ibe_outgoing,
       pol_dda_total=dda_total, pol_dda_in=dda_incoming, pol_dda_out=dda_outgoing, dda_no=ddava_no,
       dda_low=ddava_low, dda_med=ddava_med, dda_high=ddava_high, dda_err=ddava_err, dda_wait=ddava_wait,
       pol_suspicious_total=suspicious_total, pol_suspicious_in=suspicious_incoming, pol_suspicious_out=suspicious_outgoing,
       pol_ccca_total=ccca_total, pol_ccca_in=ccca_incoming, pol_ccca_out=ccca_outgoing,
       pol_graymail_total=graymail_total, pol_graymail_in=graymail_incoming, pol_graymail_out=graymail_outgoing,
       graymail_mml=graymail_cat_mml, graymail_scl=graymail_cat_scl, graymail_oth=graymail_cat_oth,
       pol_analyzed_apt_total=analyzed_apt_total, pol_analyzed_apt_in=analyzed_apt_incoming, pol_analyzed_apt_out=analyzed_apt_outgoing,
       pol_conn_block_total=cnt_conn_block_conn, pol_conn_block = cnt_conn_block,
       pol_so_total=so_total, pol_so_in=so_incoming, pol_so_out=so_outgoing
       where starttime = v_starttime;
       if not found then
           return -1;
       end if;
    else
       insert into tb_traffic_summary values (v_starttime, v_endtime,
       msg_cnt_total, msg_cnt_in, msg_cnt_out, msg_size_total, msg_size_in, msg_size_out,
       virus_total, virus_incoming, virus_outgoing, spy_total, spy_incoming, spy_outgoing,
       spam_total, spam_incoming, spam_outgoing, phish_total, phish_incoming, phish_outgoing,
       attach_total, attach_incoming, attach_outgoing, size_total, size_incoming, size_outgoing,
       content_total, content_incoming, content_outgoing, other_total, other_incoming, other_outgoing,
       except_total, except_incoming, except_outgoing,
       cnt_ipprof_block, cnt_ipprof_block, 0,
       cnt_nrs_block, cnt_nrs_block, 0,
       cnt_ipprof_conn, cnt_ipprof_block, cnt_virus, cnt_spam, cnt_bounce, cnt_dha, cnt_manual,
       cnt_nrs_conn, cnt_nrs_block,
       spamact_quar, spamact_del, spamact_subtag, spamact_other, spamact_total_size,
       spamact_quar_size, spamact_del_size, spamact_subtag_size, spamact_other_size,
       virusact_del, virusact_quar, virusact_clean, virusact_attdel, wrs_total, wrs_incoming, wrs_outgoing, dkim_total, dkim_incoming, dkim_outgoing,
       clean_total, clean_incoming, clean_outgoing, preflt_total, preflt_incoming, preflt_outgoing, 
       compliance_total, compliance_incoming, compliance_outgoing,
       decryption_total, encryption_total, decryption_size, encryption_size, ibe_total, ibe_incoming, ibe_outgoing,
       dda_total, dda_incoming, dda_outgoing, ddava_no, ddava_low, ddava_med, ddava_high, ddava_err, ddava_wait,
       suspicious_total, suspicious_incoming, suspicious_outgoing, ccca_total, ccca_incoming, ccca_outgoing,
       graymail_total, graymail_incoming, graymail_outgoing, graymail_cat_mml, graymail_cat_scl, graymail_cat_oth,
       analyzed_apt_total, analyzed_apt_incoming, analyzed_apt_outgoing,cnt_conn_block_conn,cnt_conn_block,so_total,so_incoming, so_outgoing);
       if not found then
           return -2;
       end if;
    end if;
    
    return 0;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION InsertTransac_Redelivery (out_timestamp text, postfix_id text, smtp_mail_from text, smtp_rcpt_to text, delivery_ip text, delivery_feedback text, delivery_status text) RETURNS integer AS
$body$
DECLARE
    v_TimeStamp TIMESTAMPTZ;
    v_HourNum INTEGER;
    v_TableID INTEGER;
    szExecuteCmd text;
    curs refcursor;
    v_msg_tracing_id INTEGER;
    v_extra_item text;
BEGIN
    if (out_timestamp is Null) or (postfix_id is Null) or (smtp_mail_from is Null) or (smtp_rcpt_to is Null) or (delivery_ip is Null) or (delivery_feedback is Null) or (delivery_status is Null) then
        RAISE EXCEPTION 'At least one parameter is Null at invoking InsertTransac_Full()';
    end if;
    
    v_TimeStamp := date_trunc('hour', out_timestamp::TIMESTAMPTZ);
    
    LOOP
        v_HourNum := (floor(extract(epoch from v_TimeStamp)/3600))::INTEGER % 10000;        
        v_TimeStamp := v_TimeStamp - INTERVAL'1 hour';
        if (out_timestamp::TIMESTAMPTZ - v_TimeStamp) > INTERVAL'27 hours' then
            RAISE INFO 'It has went back in time more than 1 day, but could not find relative deferred transaction record in DB.';
            return -1;
        end if;
        SELECT INTO v_TableID table_id FROM tb_log_table_info WHERE hour_num = v_HourNum;
        if not found then
            RAISE INFO 'Could not get table_id from tb_log_table_info for timestamp %', v_TimeStamp;
        else
            szExecuteCmd := 'SELECT msg_tracing_id, extra_item FROM tb_msg_tracing_' || v_TableID
                                || ' WHERE postfix_id=' || quote_literal(postfix_id) 
                                || ' and smtp_mail_from=' || quote_literal(smtp_mail_from) 
                                || ' and smtp_rcpt_to=' || quote_literal(smtp_rcpt_to) || ';';
			<<TRAVERSE>>
			BEGIN
                OPEN curs FOR EXECUTE szExecuteCmd;    
                FETCH curs INTO v_msg_tracing_id, v_extra_item;
                if v_msg_tracing_id is Null then
                    CLOSE curs;
                    EXIT TRAVERSE;   --EXIT the inner BEGIN block to continue the LOOP to try another earlier hour
                end if;
                CLOSE curs;
                v_extra_item := (v_extra_item::INTEGER + 1)::text;
                --RAISE INFO 'v_msg_tracing_id = %, v_extra_item = %', v_msg_tracing_id, v_extra_item;
                szExecuteCmd := 'UPDATE tb_msg_tracing_' || v_TableID 
                                    || ' SET out_timestamp=' || quote_literal(out_timestamp) 
                                    || ', delivery_ip=' || quote_literal(delivery_ip) 
                                    || ', delivery_feedback=' || quote_literal(delivery_feedback) 
                                    || ', delivery_status=' || quote_literal(delivery_status) 
                                    || ', extra_item=' || quote_literal(v_extra_item) 
                                    || ' WHERE msg_tracing_id=' || quote_literal(v_msg_tracing_id) || ';';
                --RAISE INFO 'szExecuteCmd = %', szExecuteCmd;
                EXECUTE szExecuteCmd;
                if not found then
                    RAISE INFO 'Update tb_msg_tracing_x failed. szExecuteCmd = %', szExecuteCmd;
                    return -1;
                else
                    return v_msg_tracing_id;
                end if;
            END;
        end if;
    END LOOP;                                       
END;
$body$
LANGUAGE 'plpgsql';

CREATE OR REPLACE FUNCTION CreateLogTables (int, int) RETURNS int AS '
DECLARE
    nFirstHour     ALIAS FOR $1;
    nCreateNum     ALIAS FOR $2;
    nTmp           int;
    nHourSeq       int;
    szCreateTableCmd text;
BEGIN
    SET client_min_messages to ERROR;
    nTmp := 0;
    while nCreateNum > nTmp loop
    nHourSeq := nFirstHour + nTmp;
    szCreateTableCmd := ''CREATE TABLE tb_policy_event_'' || nHourSeq || '' (
      policy_event_id serial NOT NULL,
      msg_id char(36) NOT NULL,
      scanner_id int4 NOT NULL,  
      smtp_sender varchar(321),
      smtp_rcpt varchar(2048),
      msg_subject varchar(256),
      msg_route int2,
      msg_size float8,
      rule_name varchar(256),
      time_date timestamptz NOT NULL,
      filter_type_virus bit(1) DEFAULT B''''0''''::"bit",
      filter_type_spyware bit(1) DEFAULT B''''0''''::"bit",
      filter_type_spam bit(1) DEFAULT B''''0''''::"bit",
      filter_type_attachment bit(1) DEFAULT B''''0''''::"bit",
      filter_type_content bit(1) DEFAULT B''''0''''::"bit",
      filter_type_size bit(1) DEFAULT B''''0''''::"bit",
      filter_type_other bit(1) DEFAULT B''''0''''::"bit",
      filter_type_malformed bit(1) DEFAULT B''''0''''::"bit",
      filter_type_unscanned bit(1) DEFAULT B''''0''''::"bit",
      filter_type_phishing bit(1) DEFAULT B''''0''''::"bit",
      filter_description varchar(256),
      act_deleted bit(1) DEFAULT B''''0''''::"bit",
      act_quarantined bit(1) DEFAULT B''''0''''::"bit",
      act_delivered bit(1) DEFAULT B''''0''''::"bit",
      act_archived bit(1) DEFAULT B''''0''''::"bit",
      act_rcptchanged bit(1) DEFAULT B''''0''''::"bit",
      act_stamped bit(1) DEFAULT B''''0''''::"bit",
      act_attachments_deleted bit(1) DEFAULT B''''0''''::"bit",
      act_subjects_tagged bit(1) DEFAULT B''''0''''::"bit",
      act_delivery_postponed bit(1) DEFAULT B''''0''''::"bit",
      act_notifications_sent bit(1) DEFAULT B''''0''''::"bit",
      act_cleaned bit(1) DEFAULT B''''0''''::"bit",
      act_bcc bit(1) DEFAULT B''''0''''::"bit",
      act_handoff bit(1) DEFAULT B''''0''''::"bit",
      spam_score float4 DEFAULT (0)::real,
      spam_category_id int4 DEFAULT 1,
      spam_sensitive int2 DEFAULT 0,
      attach_name varchar(1024),
      attach_type varchar(80),
      virus_name varchar(1024),
      virus_type varchar(80),
      original_msg_id varchar(1024),
      filter_type_wrs bit(1) DEFAULT B''''0''''::"bit",
      wrs_threshold int4,
      wrs_score int4,
      reason varchar(1024),
      filter_type_dkim bit(1) DEFAULT B''''0''''::"bit",
      dkim_author varchar(256),
      dkim_reason varchar(1024),
      act_insert_x_header_tag bit(1) DEFAULT B''''0''''::"bit",
      filter_type_preflt bit(1) DEFAULT B''''0''''::"bit",
      filter_type_compliance bit(1) DEFAULT B''''0''''::"bit",
      act_decryption bit(1) DEFAULT B''''0''''::"bit",
      act_encryption bit(1) DEFAULT B''''0''''::"bit",
      act_reencryption bit(1) DEFAULT B''''0''''::"bit",
      dda_status int2,
      dda_rating int2,
      filter_type_ccca bit(1) DEFAULT B''''0''''::"bit",
      ccca_detection_type    varchar(10),
      ccca_detection_addresses varchar(1024),
      wrs_category_list varchar(1024),
      filter_type_graymail bit(1) DEFAULT B''''0''''::"bit",
      graymail_category int4 DEFAULT 0,
      dlp_compliance_matchdetail varchar(32768),
      filter_type_snap bit(1) DEFAULT B''''0''''::"bit",
      snap_report text,
      suspicious_apt_filters_map int4,
      analyzed_apt_filters_map int4,
      triggered_keywords varchar(2048),
      original_attach_name varchar(1024),
      filter_type_so bit(1) DEFAULT B''''0''''::"bit",
      so_file_detection int2 default 0,
      so_file_sourcetype text,
      so_file_action int2,
      so_file_value text,
      so_url_detection int2 default 0,
      so_url_sourcetype text,
      so_url_action int2,
      so_url_value text,
      is_rule_triggered boolean DEFAULT false,
      rewrite_status smallint DEFAULT 0,
      rewritten_url_num integer DEFAULT 0,
      emerging_threat_category smallint,
      dda_virus_name text,
      ransomware_type smallint,
      CONSTRAINT policy_event_'' || nHourSeq || ''_policy_event_id_pk PRIMARY KEY (policy_event_id)
    ) 
    WITHOUT OIDS;'';
    EXECUTE szCreateTableCmd;

    szCreateTableCmd := ''CREATE TABLE tb_quarantine_'' || nHourSeq || '' (
      policy_event_id int4 NOT NULL,
      msg_id char(36) NOT NULL,
      scanner_id int4 NOT NULL,
      smtp_sender varchar(321),
      smtp_rcpt varchar(2048),
      msg_subject varchar(256),
      msg_route int2,
      msg_size float8,
      qa_id int4 NOT NULL,
      rule_name varchar(256),
      time_date timestamptz,
      filter_type_virus bit(1) DEFAULT B''''0''''::"bit",
      filter_type_spyware bit(1) DEFAULT B''''0''''::"bit",
      filter_type_spam bit(1) DEFAULT B''''0''''::"bit",
      filter_type_attachment bit(1) DEFAULT B''''0''''::"bit",
      filter_type_content bit(1) DEFAULT B''''0''''::"bit",
      filter_type_size bit(1) DEFAULT B''''0''''::"bit",
      filter_type_other bit(1) DEFAULT B''''0''''::"bit",
      filter_type_malformed bit(1) DEFAULT B''''0''''::"bit",
      filter_type_unscanned bit(1) DEFAULT B''''0''''::"bit",
      filter_type_phishing bit(1) DEFAULT B''''0''''::"bit",
      attach_name varchar(1024),
      qt_live_ttl timestamptz,
      ref_num int4 DEFAULT 0,
      original_msg_id varchar(1024),
      filter_type_wrs bit(1) DEFAULT B''''0''''::"bit",
      filter_type_dkim bit(1) DEFAULT B''''0''''::"bit",
      filter_type_preflt bit(1) DEFAULT B''''0''''::"bit",
      filter_type_compliance bit(1) DEFAULT B''''0''''::"bit",
      dda_status int2,
      dda_rating int2,
      filter_type_ccca bit(1) DEFAULT B''''0''''::"bit",
      filter_type_graymail bit(1) DEFAULT B''''0''''::"bit",
      filter_type_snap bit(1) DEFAULT B''''0''''::"bit",
      suspicious_apt_filters_map int4,
      analyzed_apt_filters_map int4,
      filter_type_so bit(1) DEFAULT B''''0''''::"bit",
      CONSTRAINT quarantine_'' || nHourSeq || ''_policy_event_id_pk PRIMARY KEY (policy_event_id)
    ) 
    WITHOUT OIDS;'';
    EXECUTE szCreateTableCmd;

    szCreateTableCmd := ''CREATE TABLE tb_archive_'' || nHourSeq || '' (
      policy_event_id int4 NOT NULL,
      msg_id char(36) NOT NULL,
      scanner_id int4 NOT NULL,
      smtp_sender varchar(321),
      smtp_rcpt varchar(2048),
      msg_subject varchar(256),
      msg_route int2,
      msg_size float8,
      qa_id int4 NOT NULL,
      rule_name varchar(256),
      time_date timestamptz,
      filter_type_virus bit(1) DEFAULT B''''0''''::"bit",
      filter_type_spyware bit(1) DEFAULT B''''0''''::"bit",
      filter_type_spam bit(1) DEFAULT B''''0''''::"bit",
      filter_type_attachment bit(1) DEFAULT B''''0''''::"bit",
      filter_type_content bit(1) DEFAULT B''''0''''::"bit",
      filter_type_size bit(1) DEFAULT B''''0''''::"bit",
      filter_type_other bit(1) DEFAULT B''''0''''::"bit",
      filter_type_malformed bit(1) DEFAULT B''''0''''::"bit",
      filter_type_unscanned bit(1) DEFAULT B''''0''''::"bit",
      filter_type_phishing bit(1) DEFAULT B''''0''''::"bit",
      attach_name varchar(1024),
      qt_live_ttl timestamptz,
      original_msg_id varchar(1024),
      filter_type_wrs bit(1) DEFAULT B''''0''''::"bit",
      filter_type_dkim bit(1) DEFAULT B''''0''''::"bit",
      filter_type_preflt bit(1) DEFAULT B''''0''''::"bit",
      filter_type_compliance bit(1) DEFAULT B''''0''''::"bit",
      dda_status int2,
      dda_rating int2,
      filter_type_ccca bit(1) DEFAULT B''''0''''::"bit",
      filter_type_graymail bit(1) DEFAULT B''''0''''::"bit",
      filter_type_snap bit(1) DEFAULT B''''0''''::"bit",
      suspicious_apt_filters_map int4,
      analyzed_apt_filters_map int4,
      filter_type_so bit(1) DEFAULT B''''0''''::"bit",
      CONSTRAINT archive_'' || nHourSeq || ''_policy_event_id_pk PRIMARY KEY (policy_event_id)
    ) 
    WITHOUT OIDS;'';
    EXECUTE szCreateTableCmd;

    szCreateTableCmd := ''CREATE TABLE tb_msg_tracing_'' || nHourSeq || '' (  
      msg_tracing_id serial NOT NULL, 
      in_timestamp timestamptz NOT NULL,
      scan_timestamp timestamptz,
      out_timestamp timestamptz,
      first_delivery_timestamp timestamptz,
      msg_id varchar(1024) NOT NULL,
      internal_msg_id varchar(36),
      postfix_id varchar(16),
      scanner_id int4 NOT NULL CHECK (scanner_id > 0),
      smtp_mail_from varchar(321) NOT NULL,
      smtp_rcpt_to varchar(2048) NOT NULL,
      subject varchar(256),
      client_ip varchar(384),
      delivery_ip varchar(384),
      delivery_feedback varchar(384),
      delivery_status varchar(8),
      first_delivery_info varchar(384),
      act_deleted bit(1) DEFAULT B''''0''''::"bit",
      act_quarantined bit(1) DEFAULT B''''0''''::"bit",
      act_delivered bit(1) DEFAULT B''''0''''::"bit",
      act_archived bit(1) DEFAULT B''''0''''::"bit",
      act_rcptchanged bit(1) DEFAULT B''''0''''::"bit",
      act_stamped bit(1) DEFAULT B''''0''''::"bit",
      act_attachments_deleted bit(1) DEFAULT B''''0''''::"bit",
      act_subjects_tagged bit(1) DEFAULT B''''0''''::"bit",
      act_delivery_postponed bit(1) DEFAULT B''''0''''::"bit",
      act_notifications_sent bit(1) DEFAULT B''''0''''::"bit",
      act_cleaned bit(1) DEFAULT B''''0''''::"bit",
      act_bcc bit(1) DEFAULT B''''0''''::"bit",
      act_handoff bit(1) DEFAULT B''''0''''::"bit",
      act_insert_x_header_tag bit(1) DEFAULT B''''0''''::"bit",
      extra_item text,
      split_flag int4 NOT NULL DEFAULT 0 CHECK (split_flag = 0 OR split_flag = 1 OR split_flag = 2),
      reprocess_flag bool NOT NULL DEFAULT false,
      match_policy_flag bool NOT NULL DEFAULT true,
      todeliverytimestamp timestamptz,
      indeliverytimestamp timestamptz,
      act_decryption bit(1) DEFAULT B''''0''''::"bit",
      act_encryption bit(1) DEFAULT B''''0''''::"bit",
      act_reencryption bit(1) DEFAULT B''''0''''::"bit",
      dkim_result text,
      tls int4 NOT NULL DEFAULT 0,
      original_attach_name text,
      CONSTRAINT msg_tracing_'' || nHourSeq || ''_msg_tracing_id_pk PRIMARY KEY (msg_tracing_id)
    ) 
    WITHOUT OIDS;'';
    EXECUTE szCreateTableCmd;
    
    szCreateTableCmd := ''CREATE INDEX idx_policy_event_'' || nHourSeq || ''_timedate ON tb_policy_event_'' || nHourSeq || ''(time_date)'';
    EXECUTE szCreateTableCmd;
    
    szCreateTableCmd := ''CREATE INDEX idx_quarantine_'' || nHourSeq || ''_timedate ON tb_quarantine_'' || nHourSeq || ''(time_date)'';
    EXECUTE szCreateTableCmd;
    
    szCreateTableCmd := ''CREATE INDEX idx_archive_'' || nHourSeq || ''_timedate ON tb_archive_'' || nHourSeq || ''(time_date)'';
    EXECUTE szCreateTableCmd;
    szCreateTableCmd := ''CREATE INDEX idx_msg_tracing_'' || nHourSeq || ''_timedate ON tb_msg_tracing_'' || nHourSeq || ''(in_timestamp)'';
    EXECUTE szCreateTableCmd;
    szCreateTableCmd := ''CREATE INDEX idx_tb_msg_tracing_'' || nHourSeq || ''_postfix_id ON tb_msg_tracing_'' || nHourSeq || ''(postfix_id)'';
    EXECUTE szCreateTableCmd;

    insert into tb_log_table_info (table_id, hour_num) values(nHourSeq, -1);
    nTmp := nTmp + 1;
    end loop;

    return 0;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION CreateLogImportFunc (int, int) RETURNS int AS $createBody$
DECLARE
    nFirstHour     ALIAS FOR $1;
    nCreateNum     ALIAS FOR $2;
    nTmp           int;
    nHourSeq       int;
    szCreateTableCmd text;
BEGIN
    nTmp := 0;
    while nCreateNum > nTmp loop
    nHourSeq := nFirstHour + nTmp;
    szCreateTableCmd := 'CREATE OR REPLACE FUNCTION AddPolicyEventFromLog_' || nHourSeq || $AddPolicyEventFromLog1$ (
    char(36), int, varchar(321), varchar(2048), varchar(256), smallint, float,
    varchar(256), timestamptz, char(14), varchar(256), char(16), real, int, smallint, varchar(1024),
    varchar(80), varchar(1024),varchar(80), int, timestamptz, int, timestamptz, varchar(1024), bit, int, int, int, varchar(1024), varchar(256), varchar(1024), int, varchar(10), varchar(1024), varchar(1024), int, varchar(32768),int,int,int, varchar(2048), varchar(1024),
    smallint, varchar(1024),smallint, varchar(32768),smallint, varchar(1024),smallint, varchar(32768), boolean, smallint, integer, int, text, int)
RETURNS integer AS $AddPolicyEventFromLog_body$
DECLARE
    v_msg_id              ALIAS FOR $1;
    v_scanner_id          ALIAS FOR $2;
    v_smtp_sender         ALIAS FOR $3;
    v_smtp_rcpt           ALIAS FOR $4;
    v_msg_subject         ALIAS FOR $5;
    v_msg_route           ALIAS FOR $6;
    v_msg_size            ALIAS FOR $7;
    v_rule_name           ALIAS FOR $8;
    v_time_date           ALIAS FOR $9;
    v_filter_types        ALIAS FOR $10;
    v_filter_description  ALIAS FOR $11;
    v_msg_actions         ALIAS FOR $12;
    v_spam_score          ALIAS FOR $13;
    v_spam_category_id    ALIAS FOR $14;
    v_spam_sensitive      ALIAS FOR $15;
    v_attach_name         ALIAS FOR $16;
    v_attach_type         ALIAS FOR $17;
    v_virus_name          ALIAS FOR $18;
    v_virus_type          ALIAS FOR $19;
    v_qa_id               ALIAS FOR $20;
    v_qa_live_ttl         ALIAS FOR $21;
    v_aa_id               ALIAS FOR $22;
    v_aa_live_ttl         ALIAS FOR $23;
    v_org_msg_id          ALIAS FOR $24;
    v_multi_virus         ALIAS FOR $25;
    v_ref_num             ALIAS FOR $26;
    v_wrs_threshold       ALIAS FOR $27;
    v_wrs_score           ALIAS FOR $28;
    v_reason              ALIAS FOR $29;
    v_dkim_author         ALIAS FOR $30;
    v_dkim_reason         ALIAS FOR $31;
    v_dda_status          ALIAS FOR $32;
    v_ccca_detection_type      ALIAS FOR $33;
    v_ccca_detection_addresses ALIAS FOR $34;
    v_wrs_category_list        ALIAS FOR $35;
    v_graymail_category        ALIAS FOR $36;
    v_dlp_detail_match_result  ALIAS FOR $37;
    v_dda_rating               ALIAS FOR $38;
    v_suspicious_apt_filters_map  ALIAS FOR $39;
    v_analyzed_apt_filters_map  ALIAS FOR $40;
    v_triggered_keywords ALIAS FOR $41;
    v_org_attach_name ALIAS FOR $42;
    v_so_file_detection ALIAS FOR $43;
    v_so_file_sourcetype ALIAS FOR $44;
    v_so_file_action ALIAS FOR $45;
    v_so_file_value ALIAS FOR $46;
    v_so_url_detection ALIAS FOR $47;
    v_so_url_detection_sourcetype ALIAS FOR $48;
    v_so_url_action ALIAS FOR $49;
    v_so_url_value ALIAS FOR $50;
    v_is_rule_triggered ALIAS FOR $51;
    v_rewrite_status ALIAS FOR $52;
    v_rewritten_url_num ALIAS FOR $53;
    v_emerging_threat_category  ALIAS FOR $54;
    v_dda_virus_name   ALIAS FOR $55;
    v_ransomware_type  ALIAS FOR $56;
        
    v_filter_type_virus         bit;
    v_filter_type_spam          bit;
    v_filter_type_attachment    bit;
    v_filter_type_content       bit;
    v_filter_type_size          bit;
    v_filter_type_other         bit;
    v_filter_type_malformed     bit;
    v_filter_type_unscanned     bit;
    v_filter_type_phishing      bit;
    v_filter_type_spyware       bit;
    v_filter_type_wrs           bit;
    v_filter_type_dkim          bit;
    v_filter_type_preflt        bit;
    v_filter_type_compliance    bit;
    v_filter_type_so            bit;
    v_act_deleted               bit;
    v_act_quarantined           bit;
    v_act_delivered             bit;
    v_act_archived              bit;
    v_act_rcptchanged           bit;
    v_act_stamped               bit;
    v_act_attachments_deleted   bit;
    v_act_subjects_tagged       bit;
    v_act_delivery_postponed    bit;
    v_act_notifications_sent    bit;
    v_act_cleaned               bit;
    v_act_bcc                   bit;
    v_act_handoff               bit;
    v_act_insert_x_header_tag   bit;
    v_act_decryption            bit;
    v_act_encryption            bit;
    v_act_reencryption          bit;
    v_policy_event_id           int4;
    v_len                       int;
    v_pos                       int;
    v_str                       varchar(2048);
    v_filter_type_ccca          bit;
    v_filter_type_graymail      bit;
    v_filter_type_snap          bit;

BEGIN  
    /*parse to get filter type*/
    v_filter_type_virus      := substring(v_filter_types from 1 for 1);
    v_filter_type_spam       := substring(v_filter_types from 2 for 1);
    v_filter_type_attachment := substring(v_filter_types from 3 for 1);
    v_filter_type_content    := substring(v_filter_types from 4 for 1);
    v_filter_type_size       := substring(v_filter_types from 5 for 1);
    v_filter_type_other      := substring(v_filter_types from 6 for 1);
    v_filter_type_malformed  := substring(v_filter_types from 7 for 1);
    v_filter_type_unscanned  := substring(v_filter_types from 8 for 1);
    v_filter_type_phishing   := substring(v_filter_types from 9 for 1);
    v_filter_type_wrs        := substring(v_filter_types from 10 for 1);
    v_filter_type_dkim       := substring(v_filter_types from 11 for 1);
    v_filter_type_compliance := substring(v_filter_types from 13 for 1);
    v_filter_type_ccca       := substring(v_filter_types from 14 for 1);
    v_filter_type_graymail   := substring(v_filter_types from 15 for 1); 
    v_filter_type_snap       := substring(v_filter_types from 16 for 1); 
    v_filter_type_spyware    := substring(v_filter_types from 17 for 1);
    v_filter_type_preflt     := substring(v_filter_types from 18 for 1);
    v_filter_type_so         := substring(v_filter_types from 19 for 1);

    /*parse to get action */
    v_act_deleted            := substring(v_msg_actions from 1 for 1);
    v_act_quarantined        := substring(v_msg_actions from 2 for 1);
    v_act_delivered          := substring(v_msg_actions from 3 for 1);
    v_act_archived           := substring(v_msg_actions from 4 for 1);
    v_act_handoff            := substring(v_msg_actions from 5 for 1); 
    v_act_rcptchanged        := substring(v_msg_actions from 6 for 1);
    v_act_stamped            := substring(v_msg_actions from 7 for 1);
    v_act_attachments_deleted:= substring(v_msg_actions from 8 for 1);
    v_act_subjects_tagged    := substring(v_msg_actions from 9 for 1);
    v_act_delivery_postponed := substring(v_msg_actions from 10 for 1);
    v_act_notifications_sent := substring(v_msg_actions from 11 for 1);
    v_act_cleaned            := substring(v_msg_actions from 12 for 1);
    v_act_bcc                := substring(v_msg_actions from 13 for 1);
    v_act_insert_x_header_tag := substring(v_msg_actions from 14 for 1);
    v_act_decryption         := substring(v_msg_actions from 15 for 1);
    v_act_encryption         := substring(v_msg_actions from 16 for 1);
    v_act_reencryption       := substring(v_msg_actions from 17 for 1);
    v_policy_event_id        := nextval('tb_policy_event_$AddPolicyEventFromLog1$ || nHourSeq || $AddPolicyEventFromLog2$_policy_event_id_seq');

    /*1.add a row into tb_policy_event, msg_id&scanner_id may be duplicate*/
    insert into tb_policy_event_$AddPolicyEventFromLog2$ || nHourSeq || $AddPolicyEventFromLog31$ values (v_policy_event_id,
        v_msg_id, v_scanner_id, v_smtp_sender, v_smtp_rcpt, v_msg_subject, v_msg_route, v_msg_size, v_rule_name, v_time_date, 
        v_filter_type_virus, v_filter_type_spyware, v_filter_type_spam, v_filter_type_attachment, 
        v_filter_type_content, v_filter_type_size, v_filter_type_other, v_filter_type_malformed, 
        v_filter_type_unscanned, v_filter_type_phishing, v_filter_description, v_act_deleted, v_act_quarantined,
        v_act_delivered, v_act_archived, v_act_rcptchanged, v_act_stamped, v_act_attachments_deleted, 
        v_act_subjects_tagged, v_act_delivery_postponed, v_act_notifications_sent, v_act_cleaned, v_act_bcc, 
        v_act_handoff, v_spam_score, v_spam_category_id, v_spam_sensitive, v_attach_name, v_attach_type,    
        v_virus_name, v_virus_type, v_org_msg_id, v_filter_type_wrs, v_wrs_threshold, v_wrs_score, v_reason,
        v_filter_type_dkim, v_dkim_author, v_dkim_reason, v_act_insert_x_header_tag, v_filter_type_preflt, 
        v_filter_type_compliance,v_act_decryption,v_act_encryption, v_act_reencryption, 
        v_dda_status, v_dda_rating,v_filter_type_ccca,v_ccca_detection_type,v_ccca_detection_addresses,
        v_wrs_category_list,v_filter_type_graymail,v_graymail_category,v_dlp_detail_match_result,v_filter_type_snap,
        NULL,v_suspicious_apt_filters_map,v_analyzed_apt_filters_map,v_triggered_keywords,v_org_attach_name,
        v_filter_type_so, v_so_file_detection, v_so_file_sourcetype, v_so_file_action, v_so_file_value,
        v_so_url_detection, v_so_url_detection_sourcetype, v_so_url_action, v_so_url_value, v_is_rule_triggered, 
        v_rewrite_status, v_rewritten_url_num, v_emerging_threat_category, v_dda_virus_name, v_ransomware_type);
        
    if not found then
        /*could not insert tb_policy_event*/
        return -1;
    end if; 

    if v_dda_status BETWEEN 100 AND 102 then
        insert into tb_dtas_mail values (v_msg_id, v_scanner_id, 0, v_dda_rating, v_dda_status, '1970-01-01', 0, '1970-01-01', 0, '', '', 
            v_time_date, $AddPolicyEventFromLog31$ || nHourSeq || $AddPolicyEventFromLog3$, v_policy_event_id, v_act_quarantined::bit(1)::integer,
            v_act_archived::bit(1)::integer, v_act_delivery_postponed::bit(1)::integer, v_msg_route,'1970-01-01','1970-01-01','1970-01-01','',0,'');
    end if;
    
    /*Insert for click time protection URL click log query*/
    IF v_rewrite_status <> 0 THEN
        INSERT INTO tb_uuid_mail_info 
            (uuid, date_time, sender, rcpts, msgid)
        SELECT v_msg_id, v_time_date, v_smtp_sender, v_smtp_rcpt, v_org_msg_id
        WHERE
            NOT EXISTS (
                SELECT 1 FROM tb_uuid_mail_info WHERE uuid = v_msg_id
            );
    END IF;

    /*2.add a row into tb_quatantine if v_act_quarantined = 1*/
    if v_act_quarantined = '1' then
        insert into tb_quarantine_$AddPolicyEventFromLog3$ || nHourSeq || $AddPolicyEventFromLog4$ (policy_event_id, 
            msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, msg_size, qa_id, rule_name, time_date, 
            filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment,
            filter_type_content, filter_type_size, filter_type_other, filter_type_malformed,
            filter_type_unscanned, filter_type_phishing, attach_name, qt_live_ttl, ref_num, original_msg_id, 
            filter_type_wrs, filter_type_dkim, filter_type_preflt, filter_type_compliance,
            dda_status, dda_rating,filter_type_ccca, filter_type_graymail,filter_type_snap,
            suspicious_apt_filters_map,analyzed_apt_filters_map, filter_type_so) 
            values (v_policy_event_id, v_msg_id, v_scanner_id, v_smtp_sender, v_smtp_rcpt, v_msg_subject, v_msg_route, v_msg_size,
            v_qa_id, v_rule_name, v_time_date, 
            v_filter_type_virus, v_filter_type_spyware, v_filter_type_spam, v_filter_type_attachment,
            v_filter_type_content, v_filter_type_size, v_filter_type_other, v_filter_type_malformed,
            v_filter_type_unscanned, v_filter_type_phishing, v_attach_name, v_qa_live_ttl, v_ref_num,
            v_org_msg_id, v_filter_type_wrs, v_filter_type_dkim, v_filter_type_preflt, v_filter_type_compliance,
            v_dda_status, v_dda_rating,v_filter_type_ccca,v_filter_type_graymail,
            v_filter_type_snap,v_suspicious_apt_filters_map,v_analyzed_apt_filters_map, v_filter_type_so);
        
        if not found then
            /*could not insert tb_quarantine*/
            return -2;
        end if;
        
        if v_dda_status NOT BETWEEN 100 AND 102 then
            PERFORM UpdateQuarantineSummary(v_time_date, v_rule_name, 1);
        end if;
    end if;
    
    /*3.add a row into tb_archive if v_act_archived = 1*/
    if v_act_archived = '1' then
        insert into tb_archive_$AddPolicyEventFromLog4$ || nHourSeq || $AddPolicyEventFromLog5$ (policy_event_id, 
            msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, msg_size, qa_id, rule_name, time_date, 
            filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment,
            filter_type_content, filter_type_size, filter_type_other, filter_type_malformed,
            filter_type_unscanned, filter_type_phishing, attach_name, qt_live_ttl, original_msg_id, filter_type_wrs, filter_type_dkim, 
            filter_type_preflt, filter_type_compliance,
            dda_status, dda_rating,filter_type_ccca, filter_type_graymail,filter_type_snap,
            suspicious_apt_filters_map,analyzed_apt_filters_map)
            values (v_policy_event_id, v_msg_id, v_scanner_id, v_smtp_sender, v_smtp_rcpt, v_msg_subject, v_msg_route, v_msg_size,
            v_aa_id, v_rule_name, v_time_date, 
            v_filter_type_virus, v_filter_type_spyware, v_filter_type_spam, v_filter_type_attachment,
            v_filter_type_content, v_filter_type_size, v_filter_type_other, v_filter_type_malformed,
            v_filter_type_unscanned, v_filter_type_phishing, v_attach_name, v_aa_live_ttl,
            v_org_msg_id, v_filter_type_wrs, v_filter_type_dkim, v_filter_type_preflt, v_filter_type_compliance, v_dda_status, v_dda_rating,
            v_filter_type_ccca,v_filter_type_graymail,v_filter_type_snap,v_suspicious_apt_filters_map,v_analyzed_apt_filters_map);
        if not found then
            /*could not insert tb_archive*/
            return -3;
        end if;
    end if;

    /*4.add rows into tb_splited_virus_event if v_multi_virus = 1*/
    if v_multi_virus = '1' then
        v_len := length(v_virus_name);
        v_str := substring(v_virus_name from 2 for v_len-1);
        v_pos := position(';' in v_str);
        while v_pos > 0 loop
            insert into tb_splited_virus_event (time_date, virus_name) 
                values (v_time_date, substring(v_str from 1 for (v_pos - 1)));
            v_str := substring(v_str from v_pos + 1 for v_len - v_pos);
            v_len := length(v_str);
            v_pos := position(';' in v_str);
        end loop;
        if trim(both from v_str) <> '' then
            insert into tb_splited_virus_event (time_date, virus_name) values (v_time_date, v_str);
        end if;
    end if;
    
    /*5.add a row into tb_postpone if v_act_delivery_postponed = 1*/
      if v_act_delivery_postponed = '1' then
            insert into tb_postpone values (v_msg_id, v_scanner_id, v_qa_id, v_smtp_sender, v_smtp_rcpt, 
                v_msg_subject, v_msg_route, v_msg_size, v_rule_name, v_time_date, 
                v_filter_type_virus, v_filter_type_spyware, v_filter_type_spam, v_filter_type_attachment,
                v_filter_type_content, v_filter_type_size, v_filter_type_other, v_filter_type_malformed,
                v_filter_type_unscanned, v_filter_type_phishing, v_attach_name, v_qa_live_ttl, v_ref_num,
                v_filter_type_wrs, v_filter_type_dkim, v_filter_type_compliance, v_dda_status, 
                v_dda_rating, v_filter_type_ccca, v_filter_type_graymail,v_filter_type_snap,
                v_suspicious_apt_filters_map,v_analyzed_apt_filters_map);
            if not found then
                /*could not insert tb_postpone*/
                return -6;
            end if;    
      end if;


    return 0;
END;
$AddPolicyEventFromLog_body$ LANGUAGE 'plpgsql';$AddPolicyEventFromLog5$ ;
    EXECUTE szCreateTableCmd;
    szCreateTableCmd := $InsertTransac0$CREATE OR REPLACE FUNCTION InsertTransac_$InsertTransac0$ || nHourSeq || $InsertTransac1$(
    in_timestamp text, scan_timestamp text, out_timestamp text, msg_id text, internal_msg_id text, postfix_id text, 
    scanner_id integer, smtp_mail_from text, smtp_rcpt_to text, subject text, client_ip text, 
    delivery_ip text, delivery_feedback text, delivery_status text, act_set text, split_flag integer, 
    extra_item text, todeliverytimestamp text, indeliverytimestamp text, dkim_result text, tls integer, 
    original_attach_name text)
RETURNS integer AS $InsertTransacBody$
DECLARE
    v_act_deleted               bit := 0;
    v_act_quarantined           bit := 0;
    v_act_delivered             bit := 0;
    v_act_archived              bit := 0;
    v_act_rcptchanged           bit := 0;
    v_act_stamped               bit := 0;
    v_act_attachments_deleted   bit := 0;
    v_act_subjects_tagged       bit := 0;
    v_act_delivery_postponed    bit := 0;
    v_act_notifications_sent    bit := 0;
    v_act_cleaned               bit := 0;
    v_act_bcc                   bit := 0;
    v_act_handoff               bit := 0;
    v_act_insert_x_header_tag   bit := 0;
    v_act_decryption            bit := 0;
    v_act_encryption            bit := 0;
    v_act_reencryption          bit := 0;
    v_msg_tracing_id            INTEGER;
    v_match_policy_flag         BOOLEAN := False;
    v_first_delivery_timestamp  TIMESTAMPTZ := Null;
    v_first_delivery_info       TEXT := Null;
    v_TimeStamp                 TIMESTAMPTZ;
    v_in_timestamp              TEXT := Null;
    v_indeliverytimestamp       TEXT := Null;
    v_HourNum INTEGER;
    v_TableID INTEGER;
    szExecuteCmd text := Null;
    curs refcursor;
    v_client_ip text := Null;
BEGIN
    /*parse to get action */
    if act_set is not Null then
        v_act_deleted            := substring(act_set from 1 for 1);
        v_act_quarantined        := substring(act_set from 2 for 1);
        v_act_delivered          := substring(act_set from 3 for 1);
        v_act_archived           := substring(act_set from 4 for 1);
        v_act_handoff            := substring(act_set from 5 for 1); 
        v_act_rcptchanged        := substring(act_set from 6 for 1);
        v_act_stamped            := substring(act_set from 7 for 1);
        v_act_attachments_deleted:= substring(act_set from 8 for 1);
        v_act_subjects_tagged    := substring(act_set from 9 for 1);
        v_act_delivery_postponed := substring(act_set from 10 for 1);
        v_act_notifications_sent := substring(act_set from 11 for 1);
        v_act_cleaned            := substring(act_set from 12 for 1);
        v_act_bcc                := substring(act_set from 13 for 1);
        v_act_insert_x_header_tag := substring(act_set from 14 for 1);
        v_act_decryption         := substring(act_set from 15 for 1);
        v_act_encryption         := substring(act_set from 16 for 1);
        v_act_reencryption       := substring(act_set from 17 for 1);
        if act_set != '00000000000000000' then
            v_match_policy_flag = True;
        end if;
    end if;
    
      
    if delivery_status = 'deferred' then
        v_first_delivery_timestamp = todeliverytimestamp::TIMESTAMPTZ;
        v_first_delivery_info = delivery_feedback;
    end if;
  
    if (client_ip is null) and (out_timestamp is not Null) and (msg_id is not Null) then
        v_TimeStamp := date_trunc('hour', in_timestamp::TIMESTAMPTZ);
        LOOP
            v_HourNum := (floor(extract(epoch from v_TimeStamp)/3600))::INTEGER % 10000;  
            if (in_timestamp::TIMESTAMPTZ - v_TimeStamp) > INTERVAL'2 hours' then
                EXIT;
            end if;
            --RAISE INFO 'v_HourNum:%, v_TimeStamp:%', v_HourNum, v_TimeStamp;    
            v_TimeStamp := v_TimeStamp - INTERVAL'1 hour';
            SELECT INTO v_TableID table_id FROM tb_log_table_info WHERE hour_num = v_HourNum;
            if not found then
                RAISE INFO 'Could not get table_id from tb_log_table_info for timestamp %', v_TimeStamp;
            else
                szExecuteCmd := 'SELECT in_timestamp, client_ip, indeliverytimestamp FROM tb_msg_tracing_' || v_TableID
                                || ' WHERE msg_id = ' || quote_literal(msg_id) 
                                || ' and scan_timestamp is null and delivery_status = ''deferred'';';
                OPEN curs FOR EXECUTE szExecuteCmd;
                FETCH curs INTO v_in_timestamp, v_client_ip, v_indeliverytimestamp;
                if v_in_timestamp is not Null then
                    CLOSE curs;
                    EXIT;   --EXIT the loop when found the record
                end if;
                CLOSE curs;
            end if;
        END LOOP; 
        if v_in_timestamp is not Null and v_client_ip is not Null then     
            --Find the firs the record
            v_TimeStamp := date_trunc('hour', v_in_timestamp::TIMESTAMPTZ);
            v_HourNum := (floor(extract(epoch from v_TimeStamp)/3600))::INTEGER % 10000;  
            SELECT INTO v_TableID table_id FROM tb_log_table_info WHERE hour_num = v_HourNum;
            if not found then
                RAISE INFO 'Could not get table_id from tb_log_table_info for timestamp %', v_TimeStamp;
            else
                szExecuteCmd := 'SELECT InsertTransac_' || v_TableID || '(' 
                                || COALESCE(quote_literal(v_in_timestamp),'null') || ','
                                || COALESCE(quote_literal(scan_timestamp),'null') || ','
                                || COALESCE(quote_literal(out_timestamp),'null') || ','
                                || COALESCE(quote_literal(msg_id),'null') ||','
                                || COALESCE(quote_literal(internal_msg_id),'null') || ','
                                || COALESCE(quote_literal(postfix_id),'null') ||','
                                || quote_literal(scanner_id) || ','
                                || COALESCE(quote_literal(smtp_mail_from),'null') ||','
                                || COALESCE(quote_literal(smtp_rcpt_to),'null') || ','
                                || COALESCE(quote_literal(subject),'null') || ','
                                || COALESCE(quote_literal(v_client_ip),'null') || ','
                                || COALESCE(quote_literal(delivery_ip),'null') || ','
                                || COALESCE(quote_literal(delivery_feedback),'null') || ','
                                || COALESCE(quote_literal(delivery_status),'null') || ','
                                || COALESCE(quote_literal(act_set),'null') || ','
                                || quote_literal(split_flag) || ','
                                || COALESCE(quote_literal(extra_item),'null') || ','
                                || COALESCE(quote_literal(todeliverytimestamp),'null') || ','
                                || COALESCE(quote_literal(v_indeliverytimestamp),'null') || ','
                                || COALESCE(quote_literal(dkim_result),'null') || ','
                                || quote_literal(tls) || ','
                                || COALESCE(quote_literal(original_attach_name),'null') || ');';
                EXECUTE szExecuteCmd;
                if not found then
                    RAISE INFO 'select InsertTransac_% failed. szExecuteCmd = %', v_TableID, szExecuteCmd;
                    return -1;
                end if;    
                return 0;             
            end if;             
        else
            RAISE INFO 'Cannot got the first deferred record in_timestamp %', v_in_timestamp;
        end if;
    end if;    
    
    v_msg_tracing_id := nextval('tb_msg_tracing_$InsertTransac1$ || nHourSeq || $InsertTransac2$_msg_tracing_id_seq');        
    INSERT INTO tb_msg_tracing_$InsertTransac2$ || nHourSeq || $InsertTransac3$ VALUES (v_msg_tracing_id, 
                                        in_timestamp::timestamptz, 
                                        scan_timestamp::timestamptz, 
                                        out_timestamp::timestamptz,
                                        v_first_delivery_timestamp,
                                        msg_id,
                                        internal_msg_id, 
                                        postfix_id,
                                        scanner_id,
                                        smtp_mail_from,
                                        smtp_rcpt_to,
                                        subject,
                                        client_ip,
                                        delivery_ip,
                                        delivery_feedback,
                                        delivery_status,
                                        v_first_delivery_info,
                                        v_act_deleted,
                                        v_act_quarantined,
                                        v_act_delivered,
                                        v_act_archived,
                                        v_act_rcptchanged,
                                        v_act_stamped,
                                        v_act_attachments_deleted,
                                        v_act_subjects_tagged,
                                        v_act_delivery_postponed,
                                        v_act_notifications_sent,
                                        v_act_cleaned,
                                        v_act_bcc,
                                        v_act_handoff,
                                        v_act_insert_x_header_tag,
                                        extra_item,
                                        split_flag,
                                        False,
                                        v_match_policy_flag,
                                        todeliverytimestamp::timestamptz, 
                                        indeliverytimestamp::timestamptz,
                                        v_act_decryption,
                                        v_act_encryption,
                                        v_act_reencryption,
                                        dkim_result,
                                        tls,
                                        original_attach_name);
    if not found then
        /*could not insert tb_msg_tracing*/
        return -1;
    else
        return v_msg_tracing_id;
    end if;                                          
END;
$InsertTransacBody$
LANGUAGE $sql$plpgsql$sql$;$InsertTransac3$;
    EXECUTE szCreateTableCmd;

    nTmp := nTmp + 1;
    end loop;

    return 0;
END;
$createBody$ LANGUAGE plpgsql;



--
-- Drop old stored procedure AddPolicyEventFromLog_x
--
CREATE OR REPLACE FUNCTION DropOldPolicyEventFunc (int, int) RETURNS int AS '
DECLARE
    nFirstHour     ALIAS FOR $1;
    nCreateNum     ALIAS FOR $2;
    nTmp           int;
    nHourSeq       int;
    szCreateTableCmd text;
    vFunctionName text;
    vBakFunctionName text;
    v_Rec          RECORD;
BEGIN
    nTmp := 0;
    while nCreateNum > nTmp loop
      nHourSeq := nFirstHour + nTmp;
      vFunctionName := ''addpolicyeventfromlog_'' || nHourSeq;
      
      SELECT INTO v_rec * FROM pg_proc WHERE proname=vFunctionName and pronargs=29;
      if found then
        szCreateTableCmd := ''DROP FUNCTION '' || vFunctionName || '' ( 
        char(36), int, varchar(321), varchar(2048), varchar(256), smallint, float,
        varchar(256), timestamptz, char(13), varchar(256), char(13), real, int, smallint, varchar(1024),
        varchar(80), varchar(1024),varchar(80), int, timestamptz, int, timestamptz, varchar(1024), bit, int, int, int, character varying[])'';
        EXECUTE szCreateTableCmd;
      end if;   

      nTmp := nTmp + 1;
    end loop;
	  
    return 0;
END;
' LANGUAGE plpgsql;

select DropOldPolicyEventFunc(0, 512);
select DropOldPolicyEventFunc(512, 512);
select DropOldPolicyEventFunc(1024, 512);
DROP FUNCTION DropOldPolicyEventFunc(int, int);

---
--- Create new stored procedure AddPolicyEventFromLog_x and InsertTransac_x
---
select CreateLogImportFunc(0, 512);
select CreateLogImportFunc(512, 512);
select CreateLogImportFunc(1024, 512);



--
-- Part 2. table schema, view and necessary new data insertion and existed data transfer
--

ALTER TABLE t_messagesdropped ADD COLUMN scanner_id int DEFAULT 0;
ALTER TABLE t_messagesdropped ADD COLUMN connection_ip character varying(256);
ALTER TABLE t_messagesdropped ADD COLUMN "sender" character varying(325);
ALTER TABLE t_messagesdropped ADD COLUMN "recipient" character varying(2048);
CREATE INDEX idx_messagesdropped_recordtime ON t_messagesdropped USING btree (recordtime);


ALTER TABLE t_iprule ADD COLUMN expiration timestamp with time zone DEFAULT NULL;


ALTER TABLE t_manual_domain ADD COLUMN expiration timestamp with time zone DEFAULT NULL;
ALTER TABLE t_manual_domain ADD COLUMN resolvetype varchar(8) DEFAULT 'a';
ALTER TABLE t_manual_domain ADD COLUMN enablescheduleresolve boolean DEFAULT false;

DROP VIEW IF EXISTS t_blockedip;
CREATE VIEW t_blockedip AS
    SELECT t_iprule."domain", t_messagesdropped.scanner_id AS scanner_id, t_messagesdropped.upstreammta_ip AS ip, t_messagesdropped.recordtime AS createtime, t_messagesdropped."type",t_messagesdropped.connection_ip, t_messagesdropped.sender, t_messagesdropped.recipient, t_messagesdropped.count FROM (t_messagesdropped LEFT JOIN t_iprule ON (t_messagesdropped.upstreammta_ip & 4294967295)=(t_iprule.ip & 4294967295));
COMMENT ON VIEW t_blockedip IS 'select t_iprule.domain,t_messagesdropped.scanner_id as scanner_id,t_messagesdropped.upstreammta_ip as ip,t_messagesdropped.recordtime as createtime,t_messagesdropped.Type ,t_messagesdropped.connection_ip, t_messagesdropped.sender, t_messagesdropped.recipient,t_messagesdropped.count from t_messagesdropped left join t_iprule on (t_messagesdropped.upstreammta_ip & 4294967295)=(t_iprule.ip & 4294967295)';


ALTER TABLE t_type_setting ALTER rate TYPE integer;
ALTER TABLE t_type_setting ADD COLUMN blockduration integer DEFAULT 1800;
ALTER TABLE t_type_setting ADD COLUMN watchtimeunits integer DEFAULT 2;
ALTER TABLE t_type_setting ADD COLUMN blocktimeunits integer DEFAULT 2;


ALTER TABLE t_type_setting_default ALTER rate TYPE integer;
ALTER TABLE t_type_setting_default ADD COLUMN blockduration integer DEFAULT 1800;
ALTER TABLE t_type_setting_default ADD COLUMN watchtimeunits integer DEFAULT 2;
ALTER TABLE t_type_setting_default ADD COLUMN blocktimeunits integer DEFAULT 2;


ALTER TABLE t_cachedip RENAME TO t_cachedip_bak;
CREATE TABLE t_cachedip (
    ip bigint NOT NULL,
    isspam smallint DEFAULT 0 NOT NULL,
    isdha smallint DEFAULT 0 NOT NULL,
    isvirus smallint DEFAULT 0 NOT NULL,
    isbounced smallint DEFAULT 0 NOT NULL,
    isnullsession smallint DEFAULT 0 NOT NULL,
    isnormal smallint DEFAULT 0 NOT NULL,
    "time" timestamp with time zone,
    processflag boolean DEFAULT false,
    totalmsg smallint DEFAULT 0
)
WITHOUT OIDS;
INSERT INTO t_cachedip(ip, isspam, isdha, isvirus, isbounced, isnullsession, "time", processflag)
    SELECT * FROM t_cachedip_bak;
DROP TABLE t_cachedip_bak;
CREATE INDEX idx_flag ON t_cachedip USING btree (processflag);
CREATE INDEX idx_ip ON t_cachedip USING btree (ip);
CREATE INDEX idx_time ON t_cachedip USING btree ("time");


DROP TRIGGER IF EXISTS autorule ON t_cachedip_tmp;
ALTER TABLE t_cachedip_tmp RENAME TO t_cachedip_tmp_bak;
CREATE TABLE t_cachedip_tmp (
    ip bigint,
    isspam smallint,
    isdha smallint,
    isvirus smallint,
    isbounced smallint,
    isnullsession smallint,
    isnormal smallint,
    "time" timestamp with time zone,
    processflag boolean,
    totalmsg smallint DEFAULT 0
)
WITHOUT OIDS;
INSERT INTO t_cachedip_tmp(ip, isspam, isdha, isvirus, isbounced, isnullsession, "time", processflag)
    SELECT * FROM t_cachedip_tmp_bak;
DROP TABLE t_cachedip_tmp_bak;
CREATE INDEX idx_iptime ON t_cachedip_tmp USING btree (ip, "time");
CREATE TRIGGER autorule AFTER INSERT ON t_cachedip_tmp FOR EACH ROW EXECUTE PROCEDURE rule_check();


ALTER TABLE tb_administrator ADD COLUMN cli_permission integer DEFAULT 0 NOT NULL;
ALTER TABLE tb_administrator ADD COLUMN prefilter_permission integer DEFAULT 0 NOT NULL;
ALTER TABLE tb_administrator ALTER admin_name TYPE text;
ALTER TABLE tb_administrator ALTER own_root_entity TYPE text;
ALTER TABLE tb_administrator ALTER md5_digest TYPE text;


ALTER TABLE tb_component_list RENAME TO tb_component_list_bak;
CREATE TABLE tb_component_list (
    scanner_id integer DEFAULT nextval('tb_scanner_id_seq'),
    scanner_name character varying(1024),
    ip_addr character varying(256),
    daemon smallint DEFAULT 0,
    policy smallint DEFAULT 0,
    euq smallint DEFAULT 0,
    nrs smallint DEFAULT 0,
    ipprofiler smallint DEFAULT 0,
    euq_port int4 DEFAULT 0,
    admin_cmd int8 DEFAULT 0,
    is_master int DEFAULT 0,
    os_ver varchar(128),
    app_ver varchar(256),
    patch_log oid,
    mac_addr varchar(128),
    cmagent smallint DEFAULT 0
)
WITHOUT OIDS;
INSERT INTO tb_component_list(scanner_id, scanner_name, ip_addr, daemon, policy, euq, nrs, ipprofiler, euq_port, admin_cmd, app_ver)
    SELECT * FROM tb_component_list_bak;
UPDATE tb_component_list set is_master=1 where scanner_id =(SELECT MIN(scanner_id) FROM tb_component_list);
DROP TABLE tb_component_list_bak;


ALTER TABLE tb_ip_event ADD COLUMN connection_ip character varying(256);
ALTER TABLE tb_ip_event ADD COLUMN "sender" character varying(325);
ALTER TABLE tb_ip_event ADD COLUMN "recipient" character varying(2048);
ALTER TABLE tb_ip_event ADD COLUMN "type" integer NOT NULL DEFAULT 0;


ALTER TABLE ONLY tb_entity DROP CONSTRAINT tb_entity_entity_name_key;
ALTER TABLE ONLY tb_entity
    ADD CONSTRAINT tb_entity_entity_name_key UNIQUE (entity_type,entity_name);


ALTER TABLE tb_global_setting ALTER value TYPE text;


ALTER TABLE tb_named_obj ALTER "comment" SET DEFAULT '';

ALTER TABLE tb_named_obj_rule DROP CONSTRAINT rule_id;
ALTER TABLE tb_rule RENAME TO tb_rule_bak;
ALTER TABLE tb_rule_bak ALTER "rule_id" TYPE INTEGER;
ALTER SEQUENCE tb_rule_rule_id_seq RENAME TO tb_rule_bak_rule_id_seq;

CREATE TABLE tb_rule (
    rule_id serial NOT NULL,
    policy_id integer NOT NULL,
    version_number integer NOT NULL,
    rule_name character varying(1024) NOT NULL,
    active_time integer DEFAULT 247 NOT NULL,
    rule_type integer NOT NULL,
    display_action integer NOT NULL,
    has_multi_actions integer NOT NULL,
    has_virus_filter integer NOT NULL,
    has_spam_filter integer NOT NULL,
    has_attachment_filter integer NOT NULL,
    has_content_filter integer NOT NULL,
    has_size_filter integer NOT NULL,
    has_time_range_filter integer NOT NULL,
    has_other_filter integer NOT NULL,
    note character varying(4096),
    rule_value text NOT NULL,
    rule_order integer NOT NULL,
    has_wrs_filter integer NOT NULL,
    has_compliance_filter integer DEFAULT 0 NOT NULL,
    has_ccca_filter integer DEFAULT 0 NOT NULL,
    has_graymail_filter integer DEFAULT 0 NOT NULL,
    has_so_file_filter integer DEFAULT 0 NOT NULL,
    has_so_url_filter integer DEFAULT 0 NOT NULL
)
WITHOUT OIDS;
INSERT INTO tb_rule(rule_id, policy_id, version_number, rule_name, active_time, rule_type, display_action, has_multi_actions, has_virus_filter, has_spam_filter, has_attachment_filter, has_content_filter, has_size_filter, has_time_range_filter, has_other_filter, note, rule_value, rule_order, has_wrs_filter, has_graymail_filter)
    SELECT * FROM tb_rule_bak;
SELECT setval('tb_rule_rule_id_seq', nextval('tb_rule_bak_rule_id_seq')-1);
DROP TABLE tb_rule_bak;
---DROP SEQUENCE IF EXISTS tb_rule_bak_rule_id_seq;


ALTER TABLE tb_report_tickets ADD COLUMN delivery_enabled int DEFAULT 0;
ALTER TABLE tb_report_tickets ADD COLUMN sender text DEFAULT 'postmaster@localhost';
ALTER TABLE tb_report_tickets ADD COLUMN recipients text DEFAULT '';


ALTER TABLE tb_version_number ADD COLUMN system_settings int4 NOT NULL DEFAULT 0;


CREATE TABLE tb_tables_version (
    tb_name text,
    version integer
)
WITHOUT OIDS;


CREATE TABLE t_sender_filter_approved (
    "enable" boolean NOT NULL,
    "ip" character varying(256),
    "sender" character varying(256),
    "type" smallint default 1,
    createtime timestamp without time zone default now(),
    comments varchar(256),
    expiration timestamp with time zone default NULL
)
WITHOUT OIDS;

CREATE TABLE t_sender_filter_blocked (
    "enable" boolean NOT NULL,
    "ip" character varying(256),
    "sender" character varying(256),
    "type" smallint default 1,
    blocked_start_time int8 default NULL,
    expiration int8 default NULL
)
WITHOUT OIDS;

CREATE TABLE tb_dda_file_cache (
    key TEXT PRIMARY KEY,
    rating INTEGER NOT NULL,
    virus_names TEXT NOT NULL,
    status INTEGER NOT NULL,
    modify_time TIMESTAMP WITH TIME ZONE NOT NULL,
    mail_id TEXT NOT NULL
)
WITHOUT OIDS; 

CREATE TABLE t_sender_filter_blocked_log(
    blocked_time timestamp with time zone NOT NULL,
    scanner_id integer NOT NULL,
    "ip" character varying(256),
    "sender" character varying(325),
    "type"   integer NOT NULL DEFAULT 0,
    "count" integer DEFAULT 0
)
WITHOUT OIDS;
CREATE INDEX idx_sender_filter_blocked_log_blocked_time ON t_sender_filter_blocked_log USING btree (blocked_time);

CREATE TABLE t_sender_filter_conn_traffic(
    "ip" character varying(256),
    "sender" character varying(256),
    "time_stamp" timestamp with time zone,
    "type" smallint NOT NULL DEFAULT 1,
    "scanner_id" smallint,
    "count" integer DEFAULT 0
)
WITHOUT OIDS;
CREATE INDEX idx_sender_filter_conn_traffic_time_stamp ON t_sender_filter_conn_traffic USING btree (time_stamp);

ALTER TABLE ONLY t_sender_filter_approved
    ADD CONSTRAINT t_sender_filter_approved_pkey PRIMARY KEY (ip,sender);

ALTER TABLE ONLY t_sender_filter_blocked
    ADD CONSTRAINT t_sender_filter_blocked_pkey PRIMARY KEY (ip,sender);


CREATE TABLE tb_dlp_keyword_list(
    name VARCHAR(255) PRIMARY KEY NOT NULL UNIQUE,
    display_name VARCHAR(255) NOT NULL,
    description VARCHAR(1024),
    criteria integer NOT NULL DEFAULT 0,
    char_number INTEGER DEFAULT 0,
    score INTEGER DEFAULT 0,
    pre_define BOOLEAN default false,
    modified TIMESTAMP WITH time ZONE not NULL,
    content text not null default ''
)WITHOUT OIDS;

CREATE TABLE tb_dlp_sub_keyword_list(
    list_name VARCHAR(255) NOT NULL,
    sub_keyword VARCHAR(255) NOT NULL,
    case_sensitive BOOLEAN default FALSE,
    score INTEGER DEFAULT 0,
    PRIMARY KEY(list_name,sub_keyword),
    FOREIGN KEY (list_name) REFERENCES tb_dlp_keyword_list(name)
)WITHOUT OIDS;
    
CREATE TABLE tb_dlp_file_attribute(
    name VARCHAR(255) PRIMARY KEY NOT NULL UNIQUE,
    display_name VARCHAR(255) NOT NULL,
    description VARCHAR(1024),
    except_flag BOOLEAN default false,
    file_type_list text default '',
    extension VARCHAR(1024) default '',
    min_size integer default 0,
    max_size integer default 0,
    min_unit varchar(2) default 'K',
    max_unit varchar(2) default 'K',
    pre_define BOOLEAN default false,
    modified TIMESTAMP WITH time ZONE not NULL,
    content text not null default ''
)WITHOUT OIDS;
  
CREATE TABLE tb_dlp_support_file_attribute(
    category VARCHAR(255) NOT NULL,
    category_display_name VARCHAR(255) NOT NULL,
    type VARCHAR(255) NOT NULL,
    type_display_name VARCHAR(255) NOT NULL,
    PRIMARY KEY(category,type)
)WITHOUT OIDS;
  
CREATE TABLE tb_dlp_expression(
    name VARCHAR(255) PRIMARY KEY NOT NULL UNIQUE,
    display_name varchar(255) NOT NULL,
    description varchar(1024),
    criteria VARCHAR(20) default 'none',
    spec_char varchar(255) default '',
    spec_min integer default 0,
    spec_max integer default 0,
    suff_char varchar(255) default '',
    suff_len integer default 0,
    suff_expr_min integer default 0,
    suff_expr_max integer default 0,
    sepa_char varchar(2) default '',
    sepa_left_min INTEGER default 0,
    sepa_left_max INTEGER default 0,
    sepa_right_max INTEGER default 0,
    expression varchar(1024) default '',
    example varchar(1024) default '',
    display_data varchar(1024) default '',
    validator varchar(255) default '',
    case_sensitive BOOLEAN default false,
    pre_define BOOLEAN default false,
    modified TIMESTAMP WITH time ZONE not NULL,
    content text not null default ''
)WITHOUT OIDS;
    
CREATE TABLE tb_dlp_validator(
    name VARCHAR(255) PRIMARY KEY NOT NULL UNIQUE,
    display_name varchar(255) NOT NULL
)WITHOUT OIDS;
    
CREATE TABLE tb_dlp_template_data_reference(
    template_name VARCHAR(255) NOT NULL,
    data_identifier_name VARCHAR(255) NOT NULL,
    type VARCHAR(20) not null,
    PRIMARY KEY(template_name,data_identifier_name)
)WITHOUT OIDS;


CREATE TABLE tb_tls_policy_map
(
    direction integer NOT NULL,
    enable integer DEFAULT 1 NOT NULL,
    fieldname character varying(256) NOT NULL,
    version integer DEFAULT 0 NOT NULL,
    tls_level character varying(64) NOT NULL,
    cipher_grade character varying(256) NOT NULL,
    cipher_exclusion character varying(256),
    protocols character varying(256),
    verify_depth character varying(64),
    fingerprint_digest character varying(64) 
)
WITHOUT OIDS;  

CREATE SEQUENCE "tb_certificate_id_seq" 
    INCREMENT 1 MINVALUE 1 MAXVALUE 9223372036854775807 START 1 CACHE 1;  

CREATE TABLE tb_tls_certificate
(
    cert_id integer DEFAULT nextval('tb_certificate_id_seq'),
    cert_name character varying(256) NOT NULL,
    cert_type integer NOT NULL,
    cert_status integer NOT NULL,
    cert_valid integer NOT NULL,
    date_from timestamp without time zone,
    date_to timestamp without time zone, 
    cert_text text,
    cert_modulus text,
    cert_subject text,
    cert_issuer text,
    cert_serial text,
    key_file text,
    cert_file text,
    cert_file_md5 character varying(40)
)
WITHOUT OIDS;

CREATE TABLE tb_tls_service_certificate_usage
(
    scanner_id integer NOT NULL,
    service_type integer NOT NULL,
    cert_id integer NOT NULL,
    version integer NOT NULL
)
WITHOUT OIDS;


CREATE TABLE tb_ibe_data
(
    --IBE SDK used to combine [USER;gateway-id] and [CLIENT;domain-id] for indexes.  
    ind varchar(1024) NOT NULL,
    last_mod timestamp with time zone,
    last_acc timestamp with time zone,
    lobj boolean DEFAULT 'F',
    --Default value of user_data shall be NULL but not empty vchar.
    --The maximum length shall be consistent with IBE_DB_IO_BLOB_CHECK_SIZE, +4 for fault protection.
    user_data varchar(4194308),
    content oid  
) 
WITHOUT OIDS;

CREATE TABLE tb_ibe_cfg
(
    --IBE SDK used to combine [USER;gateway-id] and [CLIENT;domain-id] for indexes.  
    ind varchar(1024) NOT NULL,
    last_mod timestamp with time zone,
    last_acc timestamp with time zone,
    lobj boolean DEFAULT 'F',
    --Default value of user_data shall be NULL but not empty vchar.
    --The maximum length shall be consistent with IBE_DB_IO_BLOB_CHECK_SIZE, +4 for fault protection.
    user_data varchar(4194308),
    content oid  
) 
WITHOUT OIDS;

CREATE TABLE tb_ibe_jobs
(
    ind varchar(1024) NOT NULL,
    last_mod timestamp with time zone,
    last_acc timestamp with time zone,  
    processed boolean DEFAULT 'F',
    type integer NOT NULL
) 
WITHOUT OIDS;

ALTER TABLE ONLY tb_ibe_data
    ADD CONSTRAINT "ibe_data_ind" PRIMARY KEY ("ind");

ALTER TABLE ONLY tb_ibe_cfg
    ADD CONSTRAINT "ibe_cfg_ind" PRIMARY KEY ("ind");
    
ALTER TABLE ONLY tb_ibe_jobs
    ADD CONSTRAINT "ibe_jobs_ind" PRIMARY KEY ("ind");


CREATE TABLE tb_euq_sso_info 
(
    file_path character varying(128) NOT NULL, 
    content oid NOT NULL, 
    version integer
)
WITHOUT OIDS;


CREATE TABLE "public"."tb_dtas_mail" (
    "msg_id" varchar(36) NOT NULL,
    "scanner_id" int4 NOT NULL,
    "status" int4 DEFAULT 0 NOT NULL,
    "rating" int4 default 0,
    "result" int4 default 0,
    "submit_time" timestamptz,
    "submit_retry" int4 DEFAULT 0 NOT NULL,
    "query_time" timestamptz,
    "query_retry" int4 DEFAULT 0 NOT NULL,
    "sha1" varchar(256),
    "tgz_name" varchar(512),
    "create_time" timestamptz NOT NULL,
    "table_idx" int4 NOT NULL,
    "event_idx" int4 NULL,
    "quarantined" int4 NULL,
    "archived" int4 NULL,
    "postponed" int4 NULL,
    "msg_route" int4 NULL,
    "first_submit_time" timestamptz NOT NULL,
    "expired_time" timestamptz NOT NULL,
    "submit_end_time" timestamptz NOT NULL,
    "dump_file_uuid" varchar(256),
    "last_error" int4 default 0,
    "xml_report_uuid" varchar(256),
    "submit_target" varchar(256) default '',
    "virus_names" text,
CONSTRAINT "tb_dtas_mail_pkey" PRIMARY KEY ("msg_id")
) WITHOUT OIDS;
CREATE INDEX "idx_status" ON "public"."tb_dtas_mail" USING btree ("status");
CREATE INDEX "idx_created" ON "public"."tb_dtas_mail" USING btree ("create_time");


CREATE TABLE tb_rtstat_cpu
(
    scanner_id  int NOT NULL,
    rt_time     timestamptz,
    user_usage  float DEFAULT (0)::double precision,
    sys_usage   float DEFAULT (0)::double precision,
    idle_usage  float DEFAULT (0)::double precision,
    constraint  cpu_scanner_id_pk primary key (scanner_id)
);

CREATE TABLE tb_rtstat_mem
(
    scanner_id  int NOT NULL,
    rt_time     timestamptz,
    mem_total   int DEFAULT 0,
    mem_used    int DEFAULT 0,
    mem_avail   int DEFAULT 0,
    constraint  mem_scanner_id_pk primary key (scanner_id)
);

CREATE TABLE tb_rtstat_disk_size
(
    scanner_id  int NOT NULL,
    type        int NOT NULL,
    rt_time     timestamptz,
    disk_total  int DEFAULT 0,
    disk_used   int DEFAULT 0,
    disk_avail  int DEFAULT 0,
    constraint  disk_scanner_id_type_pk primary key (scanner_id, type)
);

CREATE TABLE tb_rtstat_mta_queue_count
(
    scanner_id  int NOT NULL,
    type        int NOT NULL,
    rt_time     timestamptz,
    mail_count  int DEFAULT 0,
    constraint  queue_scanner_id_type_pk primary key (scanner_id, type)
);

CREATE TABLE tb_rtstat_mail_traffic_policy
(
    scanner_id      int NOT NULL,
    interval        int NOT NULL,
    starttime       timestamptz NOT NULL,
    endtime         timestamptz NOT NULL,
    msg_total       numeric DEFAULT (0)::numeric,
    msg_inbound     numeric DEFAULT (0)::numeric,
    msg_outbound    numeric DEFAULT (0)::numeric,
    pol_normal      numeric DEFAULT (0)::numeric,
    pol_virus       numeric DEFAULT (0)::numeric,
    pol_spyware     numeric DEFAULT (0)::numeric,
    pol_spam        numeric DEFAULT (0)::numeric,
    pol_phish       numeric DEFAULT (0)::numeric,
    pol_attach      numeric DEFAULT (0)::numeric,
    pol_size        numeric DEFAULT (0)::numeric,
    pol_content     numeric DEFAULT (0)::numeric,
    pol_other       numeric DEFAULT (0)::numeric,
    pol_exception   numeric DEFAULT (0)::numeric,
    pol_wrs         numeric DEFAULT (0)::numeric,
    pol_dkim        numeric DEFAULT (0)::numeric,
    pol_prefilter   numeric DEFAULT (0)::numeric,
    pol_compliance  numeric DEFAULT (0)::numeric,
    pol_suspicious  numeric default (0)::numeric,
    pol_exploit     numeric default (0)::numeric,
    pol_ccca        numeric default (0)::numeric,
    pol_graymail    numeric default (0)::numeric,
    pol_so    numeric default (0)::numeric,
    CONSTRAINT      tb_rtstat_mail_traffic_policy_pkey PRIMARY KEY (scanner_id, interval, starttime, endtime)
);
CREATE INDEX idx_mail_traffic_policy_endtime
    ON tb_rtstat_mail_traffic_policy
    USING btree
    (endtime);

CREATE TABLE tb_rtstat_mail_traffic_ipfilt
(
    scanner_id      int NOT NULL,
    interval        int NOT NULL,
    starttime       timestamptz NOT NULL,
    endtime         timestamptz NOT NULL,
    ipfilt_total    numeric DEFAULT (0)::numeric,
    ipfilt_virus    numeric DEFAULT (0)::numeric,
    ipfilt_spam     numeric DEFAULT (0)::numeric,
    ipfilt_bounce   numeric DEFAULT (0)::numeric,
    ipfilt_dha      numeric DEFAULT (0)::numeric,
    ipfilt_manual   numeric DEFAULT (0)::numeric,
    ipfilt_nrs      numeric DEFAULT (0)::numeric,
    connection_blocked_ip     numeric DEFAULT (0)::numeric,
    connection_blocked_sender numeric DEFAULT (0)::numeric,
    CONSTRAINT      tb_rtstat_mail_traffic_ipfilt_pkey PRIMARY KEY (scanner_id, interval, starttime, endtime)
);
CREATE INDEX idx_mail_traffic_ipfilt_endtime
    ON tb_rtstat_mail_traffic_ipfilt
    USING btree
    (endtime);

CREATE TABLE tb_rtstat_setting
(
    sys_refresh int4 DEFAULT 60,
    traffic_refresh int4 DEFAULT 300,
    cpu_threshold int2 DEFAULT 50,
    mem_threshold int4 DEFAULT 50
);


CREATE TABLE tb_deferred
(
    msg_id char(36) NOT NULL,
    scanner_id int4 NOT NULL,
    smtp_sender varchar(321),
    smtp_rcpt varchar(2048),
    arrive_time timestamptz,
    defer_reason varchar(4096),
    msg_size int4 DEFAULT 0,
    status int2 DEFAULT 0,
    CONSTRAINT tb_deferred_pk PRIMARY KEY (msg_id, scanner_id)
);
CREATE TABLE tb_deferred_action
(
    msg_id char(36) NOT NULL,
    scanner_id int4 NOT NULL,
    "action" int2 NOT NULL
);
CREATE INDEX idx_tb_deferred_msgid_sid
    ON tb_deferred
    USING btree
    (msg_id, scanner_id);


CREATE TABLE tb_postpone
(
    msg_id char(36) NOT NULL,
    scanner_id int4 NOT NULL,
    qa_id int4 NOT NULL,
    smtp_sender varchar(321),
    smtp_rcpt varchar(2048),
    msg_subject varchar(512),
    msg_route int2,
    msg_size float8 DEFAULT 0,
    rule_name varchar(256),
    time_date timestamptz,
    filter_type_virus bit(1) DEFAULT B'0'::"bit",
    filter_type_spyware bit(1) DEFAULT B'0'::"bit",
    filter_type_spam bit(1) DEFAULT B'0'::"bit",
    filter_type_attachment bit(1) DEFAULT B'0'::"bit",
    filter_type_content bit(1) DEFAULT B'0'::"bit",
    filter_type_size bit(1) DEFAULT B'0'::"bit",
    filter_type_other bit(1) DEFAULT B'0'::"bit",
    filter_type_malformed bit(1) DEFAULT B'0'::"bit",
    filter_type_unscanned bit(1) DEFAULT B'0'::"bit",
    filter_type_phishing bit(1) DEFAULT B'0'::"bit",
    attach_name varchar(1024),
    qt_live_ttl timestamptz,
    ref_num int4 DEFAULT 0,
    filter_type_wrs bit(1) DEFAULT B'0'::"bit",
    filter_type_dkim bit(1) DEFAULT B'0'::"bit",
    filter_type_compliance bit(1) DEFAULT B'0'::"bit",
    dda_status int2,
    dda_rating int2,
    filter_type_ccca bit(1) DEFAULT B'0'::"bit",
    filter_type_graymail bit(1) DEFAULT B'0'::"bit",
    filter_type_snap bit(1) DEFAULT B'0'::"bit",
    suspicious_apt_filters_map int4,
    analyzed_apt_filters_map int4
)
WITHOUT OIDS;


CREATE TABLE tb_patch_latest_pkg
(
    file_name varchar(128),
    patch_type int4,
    apply_order int4,
    build_number varchar(128),
    patch_title varchar(1024),
    upload_time timestamptz,
    timeout int4,
    patch_description varchar(256),
    patch_interruption varchar(256),
    eula_content oid,
    file_content oid
)
WITHOUT OIDS;

CREATE TABLE tb_patch_status
(
    scanner_id int4,
    is_master int4,
    ip_addr varchar(256),
    scanner_name varchar(1024),
    status int4,
    paction int4,
    result int4,
    error_msg varchar(1024)
)
WITHOUT OIDS;

CREATE TABLE tb_patch_history
(
    scanner_id int4,
    rollbackable int4,
    applied_date timestamptz,
    patch_type int4,
    patch_subtype int4,
    build_number varchar(128),
    patch_title varchar(1024),
    timeout int4
) 
WITHOUT OIDS;


CREATE TABLE tb_trusted_ip_list
(
    ip_addr varchar NOT NULL,
    scanner_id int4 NOT NULL DEFAULT -1,
    CONSTRAINT trust_ip_list_pk PRIMARY KEY (ip_addr)
);


CREATE TABLE tb_cdt_detail
(
    scanner_id  int NOT NULL,
    file_days   int NOT NULL,
    file_time   timestamptz,
    file_size   int ,
    file_stat   int ,
    file_name   varchar(128),
    file_oid    oid,
    file_etime  timestamptz
);


CREATE TABLE tb_internal_host
(
    host_ip        varchar(256) NOT NULL,
    host_type      int NOT NULL,
    description    varchar(4096) default '',
    CONSTRAINT internal_host_pk PRIMARY KEY(host_ip)
)WITHOUT OIDS;


CREATE TABLE tb_delivery_policies
(
    target         text PRIMARY KEY,
    policy_type    int,
    details        text,
    addtime        timestamp without time zone
)WITHOUT OIDS;


CREATE TABLE tb_admin_sysusers
(
    user_id int NOT NULL,
    user_name varchar(256) PRIMARY KEY NOT NULL UNIQUE
) WITHOUT OIDS;


CREATE TABLE tb_syslog_setting (    
    id serial PRIMARY KEY,
    facility text NOT NULL,
    status boolean DEFAULT true,
    logtype_list text DEFAULT NULL,
    server_list text DEFAULT NULL,
    modifytime timestamp with time zone
)WITHOUT OIDS;

CREATE TABLE tb_syslog_logtype (
    id text NOT NULL,
    logprefix text NOT NULL
)WITHOUT OIDS;


CREATE TABLE tb_smart_protection_server(
    server_uuid text unique primary key,
    host text unique,
    enable_fr integer,
    enable_wr integer,
    port_fr integer,
    port_wr integer,
    enable_ssl integer,
    preference integer,
    base_path_fr text default '',
    base_path_wr text default '',
    is_local integer,
    enable_proxy integer,
    proxy_uuid text  default ''
)WITHOUT OIDS;


CREATE TABLE tb_proxy_list(
    proxy_uuid text unique primary key,
    proxy_name text unique,
    proxy_type integer,
    proxy_addr text,
    proxy_port integer,
    proxy_username text default '',
    proxy_pwd text default ''
)WITHOUT OIDS;


CREATE TABLE tb_custom_defense_blacklist
(
    so_data text unique primary key,
    so_type integer,
    so_action integer,
    filter_crc text,
    root_file_sha1 text default '',
    source_file_sha1 text default '',
    source_type integer,
    expiration bigint default 0,
    risk_level integer,
    detectable integer,
    data_md5 text,
    violated_dtas_policy text default ''
)WITHOUT OIDS;


CREATE TABLE tb_uuid_mail_info (
    uuid text PRIMARY KEY NOT NULL,
    date_time timestamptz NOT NULL,
    sender text NOT NULL,
    rcpts text NOT NULL,
    msgid text NOT NULL
)
WITHOUT OIDS;
CREATE INDEX idx_tb_uuid_mail_info ON tb_uuid_mail_info USING btree (uuid, sender, rcpts, msgid);


CREATE TABLE tb_ransomware_detection (
    scanner_id integer NOT NULL,
    msg_id char(36) NOT NULL,
    ransomware_type integer NOT NULL,
    time_date timestamp with time zone NOT NULL,
    table_id integer NOT NULL,
    policy_event_id integer NOT NULL
)
WITHOUT OIDS;
CREATE INDEX idx_ransomware_detection_msgid ON tb_ransomware_detection(msg_id);
CREATE INDEX idx_ransomware_detection_time_date ON tb_ransomware_detection(time_date);


ALTER TABLE tb_top10_individual_traffic RENAME TO tb_top10_individual_traffic_bak;
CREATE TABLE tb_top10_individual_traffic (
    date timestamp with time zone NOT NULL,
    user_name character varying(256),
    "domain" character varying(256),
    spam_no numeric DEFAULT 0::numeric,
    virus_no numeric DEFAULT 0::numeric,
    wrs_no numeric DEFAULT 0::numeric,
    total_no numeric DEFAULT 0::numeric,
    spam_size double precision DEFAULT 0::double precision,
    virus_size double precision DEFAULT 0::double precision,
    wrs_size double precision DEFAULT 0::double precision,
    total_size double precision DEFAULT 0::double precision,
    rcpt_or_sender bit(1) DEFAULT B'0'::"bit",
    compliance_no numeric DEFAULT 0::numeric,
    compliance_size double precision DEFAULT 0::double precision,
    ibe_no numeric DEFAULT 0::numeric,
    ibe_size double precision DEFAULT 0::double precision,
    ccca_no numeric DEFAULT 0::numeric,
    ccca_size double precision DEFAULT 0::double precision,
    graymail_mml numeric DEFAULT 0::numeric,
    graymail_mml_size double precision DEFAULT 0::double precision,
    graymail_scl numeric DEFAULT 0::numeric,
    graymail_scl_size double precision DEFAULT 0::double precision
)
WITHOUT OIDS;
INSERT INTO tb_top10_individual_traffic(date, user_name, domain, spam_no, virus_no, wrs_no, total_no, spam_size, virus_size, wrs_size, total_size, rcpt_or_sender, graymail_mml, graymail_mml_size)
    SELECT * FROM tb_top10_individual_traffic_bak;
DROP TABLE tb_top10_individual_traffic_bak;
ALTER TABLE ONLY tb_top10_individual_traffic
    ADD CONSTRAINT tb_top10_individual_traffic_pkey PRIMARY KEY (date, user_name, "domain", rcpt_or_sender);


ALTER TABLE tb_traffic_summary RENAME TO tb_traffic_summary_bak;
CREATE TABLE tb_traffic_summary (
    starttime timestamptz NOT NULL,
    endtime timestamptz NOT NULL,
    msg_total numeric DEFAULT (0)::numeric,
    msg_in numeric DEFAULT (0)::numeric,
    msg_out numeric DEFAULT (0)::numeric,
    msg_total_size float8 DEFAULT (0)::double precision,
    msg_in_size float8 DEFAULT (0)::double precision,
    msg_out_size float8 DEFAULT (0)::double precision,
    pol_virus_total numeric DEFAULT (0)::numeric,
    pol_virus_in numeric DEFAULT (0)::numeric,
    pol_virus_out numeric DEFAULT (0)::numeric,  
    pol_spyware_total numeric DEFAULT (0)::numeric,
    pol_spyware_in numeric DEFAULT (0)::numeric,
    pol_spyware_out numeric DEFAULT (0)::numeric,
    pol_spam_total numeric DEFAULT (0)::numeric,
    pol_spam_in numeric DEFAULT (0)::numeric,
    pol_spam_out numeric DEFAULT (0)::numeric,
    pol_phish_total numeric DEFAULT (0)::numeric,
    pol_phish_in numeric DEFAULT (0)::numeric,
    pol_phish_out numeric DEFAULT (0)::numeric,
    pol_attach_total numeric DEFAULT (0)::numeric,
    pol_attach_in numeric DEFAULT (0)::numeric,
    pol_attach_out numeric DEFAULT (0)::numeric,
    pol_size_total numeric DEFAULT (0)::numeric,
    pol_size_in numeric DEFAULT (0)::numeric,
    pol_size_out numeric DEFAULT (0)::numeric,
    pol_content_total numeric DEFAULT (0)::numeric,
    pol_content_in numeric DEFAULT (0)::numeric,
    pol_content_out numeric DEFAULT (0)::numeric,
    pol_other_total numeric DEFAULT (0)::numeric,
    pol_other_in numeric DEFAULT (0)::numeric,
    pol_other_out numeric DEFAULT (0)::numeric,
    pol_exception_total numeric DEFAULT (0)::numeric,
    pol_exception_in numeric DEFAULT (0)::numeric,
    pol_exception_out numeric DEFAULT (0)::numeric,
    pol_ipfilt_total numeric DEFAULT (0)::numeric,
    pol_ipfilt_in numeric DEFAULT (0)::numeric,
    pol_ipfilt_out numeric DEFAULT (0)::numeric,
    pol_nrs_total numeric DEFAULT (0)::numeric,
    pol_nrs_in numeric DEFAULT (0)::numeric,
    pol_nrs_out numeric DEFAULT (0)::numeric,
    ipfilt_conn numeric DEFAULT (0)::numeric,
    ipfilt_block numeric DEFAULT (0)::numeric,
    ipfilt_virus numeric DEFAULT (0)::numeric,
    ipfilt_spam numeric DEFAULT (0)::numeric,
    ipfilt_bounce numeric DEFAULT (0)::numeric,
    ipfilt_dha numeric DEFAULT (0)::numeric,
    ipfilt_manual numeric DEFAULT (0)::numeric,
    nrs_conn numeric DEFAULT (0)::numeric,
    nrs_block numeric DEFAULT (0)::numeric,
    spam_quar numeric DEFAULT (0)::numeric,
    spam_del numeric DEFAULT (0)::numeric,
    spam_subtag numeric DEFAULT (0)::numeric,
    spam_other numeric DEFAULT (0)::numeric,
    spam_total_size float8 DEFAULT (0)::double precision,
    spam_quar_size float8 DEFAULT (0)::double precision,
    spam_del_size float8 DEFAULT (0)::double precision,
    spam_subtag_size float8 DEFAULT (0)::double precision,
    spam_other_size float8 DEFAULT (0)::double precision,
    virus_del numeric DEFAULT (0)::numeric,
    virus_quar numeric DEFAULT (0)::numeric,
    virus_clean numeric DEFAULT (0)::numeric,
    virus_attdel numeric DEFAULT (0)::numeric,
    pol_wrs_total numeric DEFAULT (0)::numeric,
    pol_wrs_in numeric DEFAULT (0)::numeric,
    pol_wrs_out numeric DEFAULT (0)::numeric,
    pol_dkim_total numeric DEFAULT (0)::numeric,
    pol_dkim_in numeric DEFAULT (0)::numeric,
    pol_dkim_out numeric DEFAULT (0)::numeric,
    msg_clean_total numeric DEFAULT (0)::numeric,
    msg_clean_in numeric DEFAULT (0)::numeric,
    msg_clean_out numeric DEFAULT (0)::numeric,
    pol_preflt_total numeric DEFAULT (0)::numeric,
    pol_preflt_in numeric DEFAULT (0)::numeric,
    pol_preflt_out numeric DEFAULT (0)::numeric,
    pol_compliance_total numeric DEFAULT (0)::numeric,
    pol_compliance_in numeric DEFAULT (0)::numeric,
    pol_compliance_out numeric DEFAULT (0)::numeric,
    pol_dec_total numeric DEFAULT (0)::numeric,
    pol_enc_total numeric DEFAULT (0)::numeric,
    pol_dec_size float8 DEFAULT (0)::double precision,
    pol_enc_size float8 DEFAULT (0)::double precision,
    pol_ibe_total numeric DEFAULT (0)::numeric,
    pol_ibe_in numeric DEFAULT (0)::numeric,
    pol_ibe_out numeric DEFAULT (0)::numeric,
    pol_dda_total numeric default (0)::numeric,
    pol_dda_in numeric default (0)::numeric,
    pol_dda_out numeric default (0)::numeric,
    dda_no numeric default (0)::numeric,
    dda_low numeric default (0)::numeric,
    dda_med numeric default (0)::numeric,
    dda_high numeric default (0)::numeric,
    dda_err numeric default (0)::numeric,
    dda_wait numeric default (0)::numeric,
    pol_suspicious_total numeric default (0)::numeric,
    pol_suspicious_in numeric default (0)::numeric,
    pol_suspicious_out numeric default (0)::numeric,
    pol_ccca_total numeric default (0)::numeric,
    pol_ccca_in numeric default (0)::numeric,
    pol_ccca_out numeric default (0)::numeric,
    pol_graymail_total numeric default (0)::numeric,
    pol_graymail_in numeric default (0)::numeric,
    pol_graymail_out numeric default (0)::numeric,
    graymail_mml numeric default (0)::numeric,
    graymail_scl numeric default (0)::numeric,
    graymail_oth numeric default (0)::numeric,
    pol_analyzed_apt_total numeric default (0)::numeric,
    pol_analyzed_apt_in numeric default (0)::numeric,
    pol_analyzed_apt_out numeric default (0)::numeric,
    pol_conn_block_total numeric DEFAULT (0)::numeric,
    pol_conn_block numeric DEFAULT (0)::numeric,
    pol_so_total numeric DEFAULT (0)::numeric,
    pol_so_in numeric DEFAULT (0)::numeric,
    pol_so_out numeric DEFAULT (0)::numeric
)
WITHOUT OIDS;
INSERT INTO tb_traffic_summary(starttime, endtime, msg_total, msg_in, msg_out, msg_total_size, msg_in_size, msg_out_size, pol_virus_total, pol_virus_in, pol_virus_out, pol_spyware_total, pol_spyware_in, pol_spyware_out,
            pol_spam_total, pol_spam_in, pol_spam_out, pol_phish_total, pol_phish_in, pol_phish_out, pol_attach_total, pol_attach_in, pol_attach_out, pol_size_total, pol_size_in, pol_size_out,
            pol_content_total, pol_content_in, pol_content_out, pol_other_total, pol_other_in, pol_other_out, pol_exception_total, pol_exception_in, pol_exception_out, pol_ipfilt_total, pol_ipfilt_in, pol_ipfilt_out,
            pol_nrs_total, pol_nrs_in, pol_nrs_out, ipfilt_conn, ipfilt_block, ipfilt_virus, ipfilt_spam, ipfilt_bounce, ipfilt_dha, ipfilt_manual, nrs_conn, nrs_block,
            spam_quar, spam_del, spam_subtag, spam_other, spam_total_size, spam_quar_size, spam_del_size, spam_subtag_size, spam_other_size, virus_del, virus_quar, virus_clean, virus_attdel, 
            pol_wrs_total, pol_wrs_in, pol_wrs_out, pol_dkim_total, pol_dkim_in, pol_dkim_out, msg_clean_total, msg_clean_in, msg_clean_out, pol_graymail_total, pol_graymail_in, pol_graymail_out)
    SELECT starttime, endtime, msg_total, msg_in, msg_out, msg_total_size, msg_in_size, msg_out_size, pol_virus_total, pol_virus_in, pol_virus_out, pol_spyware_total, pol_spyware_in, pol_spyware_out,
            pol_spam_total, pol_spam_in, pol_spam_out, pol_phish_total, pol_phish_in, pol_phish_out, pol_attach_total, pol_attach_in, pol_attach_out, pol_size_total, pol_size_in, pol_size_out,
            pol_content_total, pol_content_in, pol_content_out, pol_other_total, pol_other_in, pol_other_out, pol_exception_total, pol_exception_in, pol_exception_out, pol_ipfilt_total, pol_ipfilt_in, pol_ipfilt_out,
            pol_nrs_total, pol_nrs_in, pol_nrs_out, ipfilt_conn, ipfilt_block, ipfilt_virus, ipfilt_spam, ipfilt_bounce, ipfilt_dha, ipfilt_manual, nrs_conn, nrs_block,
            spam_quar, spam_del, spam_subtag, spam_other, spam_total_size, spam_quar_size, spam_del_size, spam_subtag_size, spam_other_size, virus_del, virus_quar, virus_clean, virus_attdel, 
            pol_wrs_total, pol_wrs_in, pol_wrs_out, pol_dkim_total, pol_dkim_in, pol_dkim_out, msg_clean_total, msg_clean_in, msg_clean_out, pol_mml_total, pol_mml_in, pol_mml_out FROM tb_traffic_summary_bak;
DROP TABLE tb_traffic_summary_bak;
ALTER TABLE ONLY tb_traffic_summary
    ADD CONSTRAINT tb_traffic_summary_pkey PRIMARY KEY (starttime, endtime);

---
---   initialize tb_tls_certificate for default UI cert and ca cert 
---
INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'default_mta(Trend)', 1, 1, 0, 'Mar 24 03:52:38 2016 GMT', 'Mar 19 03:52:38 2036 GMT', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            ff:bb:c3:c8:45:24:55:04
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: ST=CA, L=CU, O=TREND, OU=IMSVA, CN=IMSVA.TREND
        Validity
            Not Before: Mar 24 03:52:38 2016 GMT
            Not After : Mar 19 03:52:38 2036 GMT
        Subject: ST=CA, L=CU, O=TREND, OU=IMSVA, CN=IMSVA.TREND
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:a8:e4:a4:7e:29:6e:19:14:ff:cf:c1:69:52:84:
                    27:77:11:64:f6:67:22:54:0e:0b:c0:43:0e:74:a6:
                    24:e9:a3:ad:dc:64:27:87:64:bb:cb:c8:6e:1b:f7:
                    f8:d9:0e:cb:3b:48:c8:7b:c6:9b:30:19:17:2b:fb:
                    89:1a:09:13:c2:a3:b1:e2:e5:ec:51:ba:db:13:af:
                    1b:a9:4d:fe:a2:67:df:d2:5e:b6:50:69:3a:6d:81:
                    0c:45:fb:c6:45:c1:aa:4e:3a:6a:14:df:de:2b:69:
                    71:0b:ec:80:29:df:b4:c2:21:84:f1:59:6d:df:d3:
                    23:f2:e5:4a:c7:6b:4f:db:dc:41:7d:45:f1:0c:ee:
                    10:dd:c1:cb:9a:86:16:35:7e:8c:fe:46:53:b1:a8:
                    b3:82:c3:fd:e3:a1:48:65:19:72:d7:2a:49:c6:6d:
                    28:dd:0a:e9:ae:ca:61:cd:54:0a:7f:ca:d0:6f:09:
                    e1:58:27:75:50:e4:90:19:32:69:21:c2:92:75:9f:
                    dd:b3:2e:8d:ad:08:71:14:0a:15:0e:7c:a9:42:a1:
                    32:d3:38:bb:03:74:81:57:86:fc:5c:54:c1:24:23:
                    35:e1:d3:cc:2c:0a:1f:22:d2:ab:d8:06:57:46:e4:
                    00:fc:df:c0:fd:90:a1:d6:60:2a:80:35:f3:ce:da:
                    bc:73
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
                CA:FALSE
    Signature Algorithm: sha256WithRSAEncryption
         52:51:f3:c1:7d:50:92:fa:d9:f5:14:c3:cf:c8:f2:2d:e2:4f:
         89:9f:aa:e4:4a:14:8b:97:49:0a:d1:60:d3:1e:f4:0c:01:0a:
         41:70:6c:1a:23:19:b8:d1:88:a3:40:73:6a:27:78:34:13:83:
         d6:38:84:8b:4f:b7:6b:c4:e3:ce:f8:7c:10:8f:85:1f:60:f4:
         95:41:a0:ac:b1:ec:65:11:c9:cd:d4:a7:6b:e9:5c:c7:79:7b:
         41:11:62:c5:b4:f7:de:66:15:0d:e1:ad:64:82:6e:25:bd:1c:
         72:56:80:82:ba:42:5c:ec:5b:b2:85:78:58:d7:37:eb:cf:41:
         34:5a:6a:17:96:bf:d0:34:66:92:6a:bf:3a:25:27:0e:fa:de:
         8a:c6:e0:52:5c:f6:b6:4b:89:71:42:18:ce:24:89:4f:0f:57:
         73:a7:d6:56:73:af:5a:1c:58:89:a2:80:49:7d:4a:42:94:25:
         cb:6b:5f:f2:47:80:f4:4d:70:9f:f6:54:d0:31:aa:58:55:52:
         b3:5e:43:dd:94:cc:70:39:1c:c4:8e:85:2b:bc:09:64:7e:8c:
         c9:5f:5b:45:08:0e:a9:df:b8:74:f4:44:68:ae:54:36:04:26:
         b2:18:60:8c:f5:4d:13:73:07:27:62:a5:e9:5f:18:46:34:eb:
         ab:fe:d1:d9
', 'A8E4A47E296E1914FFCFC169528427771164F66722540E0BC0430E74A624E9A3ADDC64278764BBCBC86E1BF7F8D90ECB3B48C87BC69B3019172BFB891A0913C2A3B1E2E5EC51BADB13AF1BA94DFEA267DFD25EB650693A6D810C45FBC645C1AA4E3A6A14DFDE2B69710BEC8029DFB4C22184F1596DDFD323F2E54AC76B4FDBDC417D45F10CEE10DDC1CB9A8616357E8CFE4653B1A8B382C3FDE3A148651972D72A49C66D28DD0AE9AECA61CD540A7FCAD06F09E158277550E49019326921C292759FDDB32E8DAD0871140A150E7CA942A132D338BB0374815786FC5C54C1242335E1D3CC2C0A1F22D2ABD8065746E400FCDFC0FD90A1D6602A8035F3CEDABC73', '/ST=CA/L=CU/O=TREND/OU=IMSVA/CN=IMSVA.TREND', 'ST=CA/L=CU/O=TREND/OU=IMSVA/CN=IMSVA.TREND', 'FFBBC3C845245504', '-----BEGIN RSA PRIVATE KEY-----
Proc-Type: 4,ENCRYPTED
DEK-Info: AES-256-CBC,FEFC5BC5ECDBFC05694EA4BE28E382DF

rozchbO2//ZR01aQaSs4iCOypdXAzblAsUwU38R0SIsc/7wWv6WUzZKFDgpDZDKF
BKNlO+ViE1OxCLAQ3561gogNzhSKN5zPZFCQMZnucKw5Lmo81hXVuK6385ZO7XrG
KCscqe+6655tvycCPvgKLIess+PQL6PS2nB7wcL1JWJaj7ooz5RQ6ZpEOzv/uPwm
fCPGULhFQKUhkeqxMZv37g3DlLnF6f+HoXEMRIyXl0fP3HNwiQSAhE7ZL1iKik24
wAV6KbFo+X8+LMbf4Mp0sVwTfeu4Zmcap/KgbvVh1jP9U4q2GB81LyWgL97s520w
C+mIFSVyk9LqYefDGbQPsyDgMa7dsBn7UzEsk2hk0tN5/sPMm0pdJGyBt2Gdwt74
Yw9nsFtVpw+m1HEBTPX4ibM426kPgGTKUUtHOEBUJ3hHtq9g3iuIPe6WIE7Sh/gm
E96bbLJWIB6blcy4kpDqbmguME07z2ShCBWAN8xq5MlYvW6kIDfgt7fxuOp12bfF
WZToYsvF2vx6sYOi+Cm2RcQLcaMcnbumadRdHaq1VonQAO0gnad+JbDf3EdWMDbO
5XfDfXzCkJ5YWSFGfQB+D3Vaw2YsJgacZosiz4k40qPhIwtxZ8Kn5YmSol1k5cGO
//D2FYWJSG0cd9bt9dtAcxr6sJJYiOz+4N+WQlnoJQ2ZoB65BDYfp7aIkW1X8CaA
zZ9/BMI5jB9Dxa8v90lpsfDPW5CWYgLH0QxSotbAdDCWgDywJ9ClG9gB1t5JnOg8
RLdBJXJfejUP8NhcyBpPAGjOb6c773WTB3Ja5BGU9ZWcFwF9xDAr4W1DbXdPnMWu
u2Kb46hJMNG1dsVURFRY+LNt5BzxX9X8hIPi0yifWy8g8ZqscfGEpL/CfqsqfzFX
HEtqTH1PLpz6LgerXwC2Hfhv3mmuM5teaIcDFDhC+jCauPeAus+MLzTjbjtK/rig
EV7VWy4r2Xx2laS8kEKoYdYUG49X5n4+mhDISJqK4DeXQzDEPXVpkzSxopxq65pF
kEAGjkq2rvDA76FAEX/nlJvCIpeAfQqmLxJM9N+KCjHDEZ9RuGQlvKKNpDcvyFjF
6WxVefizHfvkA6GGsVYHhjIv4k1kAEQIeIs77l90qGSrbXED6s57R7yce5RKdrUA
10vgVRE5t+u7E7ocvsAppk+fq1GUL3SIUvlzWBUV4V0NTV5xN6pn3VfvtgoY0QyG
Cc/iRmMl62I6BncdIhOj6R61qJX4i3domCfI+CBLUZgbmA61FDl7pZo8mnbUvUnn
kHmEMK5Vlh9NHVdR4cEktil08wq6LJKJ1yaepOffPRwC8RHe6h3wAgqieUCPMhHa
5xSgMWPDUPj/H6u5VvTFhY6Emmzqb65qj4ISmlGtPJg6ugZMqQ8EIfiyBQumGADb
hfY8EGzkaHt1aTD+O7JHC1p/rfludat+Bq4p3v+7EZwFxQTs7+3Um/3t9RWwBuG/
QvM1x+M4w6ivmxhGLOb93v/TklMWduibD6EDMBUMUE8ZeM1/7r/4Iil2QxxEIeAj
ghHakxJKYWlEjax3fkZbOgSwKPUQFMtNzcusUR6Su007c/NgpgrXkmr6pYiji7qy
-----END RSA PRIVATE KEY-----

', '-----BEGIN CERTIFICATE-----
MIIDMDCCAhigAwIBAgIJAP+7w8hFJFUEMA0GCSqGSIb3DQEBCwUAMFAxCzAJBgNV
BAgTAkNBMQswCQYDVQQHEwJDVTEOMAwGA1UEChMFVFJFTkQxDjAMBgNVBAsTBUlN
U1ZBMRQwEgYDVQQDEwtJTVNWQS5UUkVORDAeFw0xNjAzMjQwMzUyMzhaFw0zNjAz
MTkwMzUyMzhaMFAxCzAJBgNVBAgTAkNBMQswCQYDVQQHEwJDVTEOMAwGA1UEChMF
VFJFTkQxDjAMBgNVBAsTBUlNU1ZBMRQwEgYDVQQDEwtJTVNWQS5UUkVORDCCASIw
DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKjkpH4pbhkU/8/BaVKEJ3cRZPZn
IlQOC8BDDnSmJOmjrdxkJ4dku8vIbhv3+NkOyztIyHvGmzAZFyv7iRoJE8KjseLl
7FG62xOvG6lN/qJn39JetlBpOm2BDEX7xkXBqk46ahTf3itpcQvsgCnftMIhhPFZ
bd/TI/LlSsdrT9vcQX1F8QzuEN3By5qGFjV+jP5GU7Gos4LD/eOhSGUZctcqScZt
KN0K6a7KYc1UCn/K0G8J4VgndVDkkBkyaSHCknWf3bMuja0IcRQKFQ58qUKhMtM4
uwN0gVeG/FxUwSQjNeHTzCwKHyLSq9gGV0bkAPzfwP2QodZgKoA1887avHMCAwEA
AaMNMAswCQYDVR0TBAIwADANBgkqhkiG9w0BAQsFAAOCAQEAUlHzwX1QkvrZ9RTD
z8jyLeJPiZ+q5EoUi5dJCtFg0x70DAEKQXBsGiMZuNGIo0Bzaid4NBOD1jiEi0+3
a8Tjzvh8EI+FH2D0lUGgrLHsZRHJzdSna+lcx3l7QRFixbT33mYVDeGtZIJuJb0c
claAgrpCXOxbsoV4WNc3689BNFpqF5a/0DRmkmq/OiUnDvreisbgUlz2tkuJcUIY
ziSJTw9Xc6fWVnOvWhxYiaKASX1KQpQly2tf8keA9E1wn/ZU0DGqWFVSs15D3ZTM
cDkcxI6FK7wJZH6MyV9bRQgOqd+4dPREaK5UNgQmshhgjPVNE3MHJ2Kl6V8YRjTr
q/7R2Q==
-----END CERTIFICATE-----
', 'bc03bc593e7393f65c8b0119230d4d7b');

INSERT INTO  tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'default_console(Trend)', 2, 1, 0, 'Mar 24 03:53:32 2016 GMT', 'Mar 22 03:53:32 2026 GMT', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            df:e8:02:36:28:8f:25:79
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, ST=CA, O=IMSS, OU=IMSS, CN=IMSS
        Validity
            Not Before: Mar 24 03:53:32 2016 GMT
            Not After : Mar 22 03:53:32 2026 GMT
        Subject: C=US, ST=CA, O=IMSS, OU=IMSS, CN=IMSS
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:e2:f1:86:f1:c7:91:c9:5d:1f:c3:f6:58:60:af:
                    a0:fc:37:39:19:82:2a:25:3b:96:b3:8a:3f:02:f8:
                    d9:0d:19:d7:c7:d3:25:43:e8:03:b6:11:7d:4a:db:
                    a1:2d:73:65:c8:7b:cb:a5:54:d6:b2:80:56:16:b4:
                    f4:32:79:9d:cf:b4:c2:8c:d1:f4:59:d4:58:55:49:
                    c8:36:1c:84:b2:0b:45:16:ac:b6:5d:4d:79:fb:67:
                    4e:7b:9e:32:e4:81:d0:83:4f:0f:fb:74:16:6a:de:
                    d3:da:9c:ad:e0:9f:08:ca:2d:68:32:72:4d:e1:7f:
                    8a:6c:cf:79:f2:b2:34:47:28:b4:27:11:a1:a5:d4:
                    f7:5f:40:b0:32:7d:7b:63:24:7d:3a:51:b5:19:7c:
                    21:7d:8f:b7:de:54:7f:ee:84:86:c6:fc:2b:ff:fe:
                    26:51:1a:49:e4:2b:33:9b:c1:d1:a0:2a:b1:f2:a7:
                    9b:c1:dd:1d:d4:5f:c6:b4:07:a6:69:b6:94:b8:92:
                    11:e0:fe:2c:5a:c5:5e:2c:ac:7b:53:72:7f:84:08:
                    5a:63:82:e5:68:ef:26:c4:e1:fc:5b:72:86:ac:cb:
                    82:f7:1a:25:2a:d8:37:82:32:40:d8:b8:dd:68:9d:
                    f6:ea:55:9f:aa:cb:cc:03:a9:16:7e:ef:76:16:d7:
                    a9:53
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
                CA:FALSE
    Signature Algorithm: sha256WithRSAEncryption
         95:c7:a5:7a:a3:5b:e0:84:1b:63:47:c4:30:11:d2:5f:5c:dd:
         a8:d3:4c:d0:08:1a:08:7e:b9:09:11:b3:1f:5c:71:12:f9:af:
         cb:d4:d9:1f:41:8e:53:20:2e:f7:b6:4b:94:72:55:98:29:72:
         49:31:54:f6:2e:8f:cf:41:6b:e1:55:7c:96:0e:9e:f5:ba:f5:
         69:97:19:3a:18:f1:09:a1:ec:fd:80:6f:0b:24:95:bf:90:30:
         2c:fd:eb:da:8f:5a:ec:e6:42:3a:af:d1:bb:46:21:9f:8e:39:
         35:df:6a:15:ef:1e:3f:78:8f:ba:11:6b:d8:7d:a7:71:eb:a3:
         10:a7:e4:1e:30:eb:88:6a:0c:ba:37:a0:53:ee:c9:5d:86:d7:
         59:27:36:89:5e:87:ad:f3:98:6a:7a:8c:90:0f:7f:fa:66:56:
         4a:f9:33:8e:f9:4d:06:7b:4b:e5:0c:b5:5f:dc:69:c9:24:56:
         03:f9:f6:dc:93:58:6c:93:f6:b5:5c:28:ef:40:df:d0:a4:bc:
         df:38:e6:31:df:3f:9f:3f:22:54:f8:3f:47:f2:b0:37:9f:27:
         05:4f:e1:a9:20:c3:54:db:49:76:76:d0:3a:8d:79:11:bc:10:
         77:b5:f0:a4:d8:22:e1:a6:10:bb:0f:56:91:3b:49:e6:f6:2f:
         1a:d2:cb:81
', 'E2F186F1C791C95D1FC3F65860AFA0FC373919822A253B96B38A3F02F8D90D19D7C7D32543E803B6117D4ADBA12D7365C87BCBA554D6B2805616B4F432799DCFB4C28CD1F459D4585549C8361C84B20B4516ACB65D4D79FB674E7B9E32E481D0834F0FFB74166ADED3DA9CADE09F08CA2D6832724DE17F8A6CCF79F2B2344728B42711A1A5D4F75F40B0327D7B63247D3A51B5197C217D8FB7DE547FEE8486C6FC2BFFFE26511A49E42B339BC1D1A02AB1F2A79BC1DD1DD45FC6B407A669B694B89211E0FE2C5AC55E2CAC7B53727F84085A6382E568EF26C4E1FC5B7286ACCB82F71A252AD837823240D8B8DD689DF6EA559FAACBCC03A9167EEF7616D7A953', '/C=US/ST=CA/O=IMSS/OU=IMSS/CN=IMSS', 'C=US/ST=CA/O=IMSS/OU=IMSS/CN=IMSS', 'DFE80236288F2579', '-----BEGIN RSA PRIVATE KEY-----
Proc-Type: 4,ENCRYPTED
DEK-Info: AES-256-CBC,9D85A4813F36BC8469491273EA3FDBE9

2TCb4zsbAlLbaIEW9fgfAKGYJ9zKHIc/+/SrkaskTQPQNwPK3f7WhrHke5Xkyh8j
iYnxvvHAVa/nJU23vbC/Q5zafg58gCtKYP64wup6C3Aw23Vseb02lBi7Nv1Np08G
Jadp4eo1Zeyrd5N4yIFBgG3tsocF3IjD4MsgQS32huUJyw9sNe9gaWM8NR2yU5I8
wN3++9Ke3C+KqtRKwreoty+LzXN6ckPqA1MsKP20yzdwfuVG6weW1CTNCjfQU5RX
DKUJbXLj87yvgQGyDNv3U1JEBlahMw0VS0jV16IZR566Zn14AC91zdR2t7TrHcEu
E660k+pwOywYbVOnukSuAINMvpB6Bha27QyuKChR2DcdytH05yNAQkXJJ1TXA9gd
9VCyjv2LWxt9Cb2C8Rm3EWD8HLeWDtxyNsVb3eDy1CeJRgKQ5O0Y9/XnVm/aYl/N
lFgiPeyL+vup2oK/zdqRVvDcYBuEeIllsx5o030a8o7vcegJUz8anmCrGv4qQg76
5upymFqKilluvWEYVTmdEwwdOskVZc1KylCZwc3Nu2ZZYqALQUEpQK8S6r4b9YSq
lxHCESwZAkRoopgCw8mw9zVnoAk9pXSWOSY53+PMBhbCwS/TJ3/lAc31chqiaY7f
vOdp7jXRmSvvDfK6awPK0TgxO09HCWhroOI+1vHLqeM5ur75WOL/S9lerX0QnBjM
XsgHgvmKe16amCazPx5BnZTqA5MFPUTbPDY5V1gUhXJvyVv/mIN/BLTceBBrzrjr
/Qa2g6xq95J/zdX8qnDP+SSQLHZVgH6reEnNUSSygRwCKNlWGcflJsRqxY5k5gxk
H7fXsapTgl8oqS1+YmpotdGA8bN1JBpEasl0Y7vU3hAt/7DuB1/V9gon9JODhx5L
jamdUpv6DvB6KH3SEmXeIAIsfkHnix/m+sw8RVdhiW8HEpIdh2dif7tO8zE2wF78
Cyk3XTgvI4Cm/Q/YHFX664YCu8ENGrexQrT7owbfeVErgDyKuRIun2IYvLHWxUmE
MIM/+rcN8iiEtxLDUppzjnQ6jCCPlS1nIg2z4ArYNcD4LNlUsBtHfeG2sgjlK3q8
1Z5DBY7jUg33p5o6DgI2CqH7ly1PCVlsbMGr/ZdBPPh3B0hd8rP7L9Ja6k1a+rSk
+9TclFoHcXSHk8dovpHTtVa+kzrlz6bbpBUmvgYNgaNJ8ZJbUX0+tQRaw+SvPEGY
7G9MSLjAySqV8eFZud1Sqv0v8dsFmKWy+ezmfoM5cDFjfS/p9DJpg/eqP1HxVgJ1
q1FTmJYs8uZkFvP8SyoZ/XNiB9lCQQ5bRIT8FGRri4311bxzNZPSzyIDPJxM7DQ5
FECgqCV/FUT5yass6PjK++pXUlpBaGLNjXEBj7wEaqUjKNVtxuHitFcxEPHhVReg
HnGGRwJQxOPHNKqmiM1pKjICY8iUhlGnSo6bSSrp2RCBgywDlrKCfggO/4wM6/Wa
yLqqYCFFLhcz7RnRJOJRrB/IfMw/zwlQI91688hyhSnqGtGC9nhc9heYKxmbIOm0
EdqvRpD11n9wPW6ohyZTzVHiEJZgzpX/+iR52qYLo2dLMrNA+xXvu22ap75JslwT
-----END RSA PRIVATE KEY-----

', '-----BEGIN CERTIFICATE-----
MIIDHjCCAgagAwIBAgIJAN/oAjYojyV5MA0GCSqGSIb3DQEBCwUAMEcxCzAJBgNV
BAYTAlVTMQswCQYDVQQIEwJDQTENMAsGA1UEChMESU1TUzENMAsGA1UECxMESU1T
UzENMAsGA1UEAxMESU1TUzAeFw0xNjAzMjQwMzUzMzJaFw0yNjAzMjIwMzUzMzJa
MEcxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTENMAsGA1UEChMESU1TUzENMAsG
A1UECxMESU1TUzENMAsGA1UEAxMESU1TUzCCASIwDQYJKoZIhvcNAQEBBQADggEP
ADCCAQoCggEBAOLxhvHHkcldH8P2WGCvoPw3ORmCKiU7lrOKPwL42Q0Z18fTJUPo
A7YRfUrboS1zZch7y6VU1rKAVha09DJ5nc+0wozR9FnUWFVJyDYchLILRRastl1N
eftnTnueMuSB0INPD/t0Fmre09qcreCfCMotaDJyTeF/imzPefKyNEcotCcRoaXU
919AsDJ9e2MkfTpRtRl8IX2Pt95Uf+6Ehsb8K//+JlEaSeQrM5vB0aAqsfKnm8Hd
HdRfxrQHpmm2lLiSEeD+LFrFXiyse1Nyf4QIWmOC5WjvJsTh/FtyhqzLgvcaJSrY
N4IyQNi43Wid9upVn6rLzAOpFn7vdhbXqVMCAwEAAaMNMAswCQYDVR0TBAIwADAN
BgkqhkiG9w0BAQsFAAOCAQEAlceleqNb4IQbY0fEMBHSX1zdqNNM0AgaCH65CRGz
H1xxEvmvy9TZH0GOUyAu97ZLlHJVmClySTFU9i6Pz0Fr4VV8lg6e9br1aZcZOhjx
CaHs/YBvCySVv5AwLP3r2o9a7OZCOq/Ru0Yhn445Nd9qFe8eP3iPuhFr2H2nceuj
EKfkHjDriGoMujegU+7JXYbXWSc2iV6HrfOYanqMkA9/+mZWSvkzjvlNBntL5Qy1
X9xpySRWA/n23JNYbJP2tVwo70Df0KS83zjmMd8/nz8iVPg/R/KwN58nBU/hqSDD
VNtJdnbQOo15EbwQd7XwpNgi4aYQuw9WkTtJ5vYvGtLLgQ==
-----END CERTIFICATE-----
', '4a0830cdf302b87c095b768a9b78b7f2');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=TREND, CN=IMSVA.TREND', 3, 1, 0, 'Apr  2 09:29:00 2011 GMT', 'Apr  2 09:29:00 2031 GMT', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: ST=CA, L=CU, O=TREND, OU=IMSVA, CN=IMSVA.TREND
        Validity
            Not Before: Apr  2 09:29:00 2011 GMT
            Not After : Apr  2 09:29:00 2031 GMT
        Subject: ST=CA, L=CU, O=TREND, OU=IMSVA, CN=IMSVA.TREND
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:cf:db:e2:43:e5:40:49:35:f5:4d:d8:f1:6b:5d:
                    ef:3c:83:fc:dc:1a:f6:ea:a6:0b:cd:b6:dc:56:78:
                    4f:b3:31:21:93:58:5d:77:e8:ff:0a:bd:37:fa:b7:
                    48:7f:68:f2:fc:b2:a5:d7:e3:84:b8:2e:6d:c3:f8:
                    87:80:fd:52:e3:30:30:9e:0b:8f:9b:8b:b2:34:a1:
                    a4:81:60:a5:64:c7:31:a3:15:10:40:26:51:7a:ef:
                    11:37:81:94:b0:99:bc:92:68:3a:56:cc:d9:d6:16:
                    b7:52:6c:d0:d0:56:69:fd:b1:64:e9:f2:7f:0c:23:
                    77:5f:bf:9b:32:84:75:8b:f1:79:f0:55:be:1b:6d:
                    9b:e1:3b:ef:0b:5d:f8:f3:f5:f2:88:ab:de:bb:62:
                    e5:b8:b1:46:82:80:3e:9e:8f:c5:23:c6:39:3f:b2:
                    8a:d0:ce:01:0f:a4:c7:83:48:58:7b:34:31:9b:ab:
                    86:82:f9:9a:e2:98:c5:a2:7c:bc:1b:d5:ce:5b:88:
                    86:d2:45:af:90:a8:b1:bc:2c:8c:1e:84:1e:02:7d:
                    68:ff:ad:63:9b:22:92:f8:75:30:42:9c:d8:a1:87:
                    58:3c:12:71:21:7b:9e:be:11:a1:ec:08:a0:25:05:
                    3f:2e:8e:e3:2d:ce:af:05:9a:75:8b:50:68:d6:08:
                    a2:25
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints:
                CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        5b:f2:32:c7:e2:13:48:a3:94:d2:d1:3d:9c:0e:9d:7c:af:ff:
        60:03:0f:e8:98:30:6c:e9:fe:36:ce:9f:a5:f8:7d:82:ff:79:
        35:7b:44:56:51:5b:8a:a6:41:83:e3:75:fa:e0:04:0e:20:b3:
        a3:1f:20:b1:d0:5f:9f:45:85:a9:e9:1a:25:0c:87:26:b9:f6:
        2f:72:70:28:3e:ba:69:85:e2:af:1a:f4:6f:36:95:a3:3b:85:
        83:54:f8:da:8c:1e:a9:89:2f:04:1e:91:70:c8:ac:3d:ae:77:
        cb:ac:8e:31:26:3e:40:07:d3:25:b9:bd:6a:7f:9a:72:bd:a1:
        6c:90:de:72:9b:1d:e3:7d:69:88:23:92:55:29:04:bc:3b:e9:
        e6:21:34:ba:c0:72:55:d7:78:66:d4:fc:5c:0b:64:7b:ee:98:
        e6:a2:3e:b8:c7:65:72:99:ee:fe:bc:d7:b7:cf:3c:e4:f1:11:
        64:5d:90:36:3f:a8:58:90:5f:f2:1b:66:b2:6f:77:bc:f2:19:
        f5:2f:6c:59:9f:ec:fc:18:2b:49:63:55:47:20:e9:81:3f:e8:
        95:e3:08:1a:74:ea:a6:9f:8b:68:41:27:42:4a:46:51:f0:82:
        40:74:d4:68:32:34:6c:d6:0a:52:5c:89:1a:94:16:d2:e2:44:
        61:62:42:e5', 'CFDBE243E5404935F54DD8F16B5DEF3C83FCDC1AF6EAA60BCDB6DC56784FB3312193585D77E8FF0ABD37FAB7487F68F2FCB2A5D7E384B82E6DC3F88780FD52E330309E0B8F9B8BB234A1A48160A564C731A315104026517AEF11378194B099BC92683A56CCD9D616B7526CD0D05669FDB164E9F27F0C23775FBF9B3284758BF179F055BE1B6D9BE13BEF0B5DF8F3F5F288ABDEBB62E5B8B14682803E9E8FC523C6393FB28AD0CE010FA4C78348587B34319BAB8682F99AE298C5A27CBC1BD5CE5B8886D245AF90A8B1BC2C8C1E841E027D68FFAD639B2292F87530429CD8A187583C1271217B9EBE11A1EC08A025053F2E8EE32DCEAF059A758B5068D608A225', '/ST=CA/L=CU/O=TREND/OU=IMSVA/CN=IMSVA.TREND', '/ST=CA/L=CU/O=TREND/OU=IMSVA/CN=IMSVA.TREND', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIDKzCCAhOgAwIBAgIBATANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQIEwJDQTEL
MAkGA1UEBxMCQ1UxDjAMBgNVBAoTBVRSRU5EMQ4wDAYDVQQLEwVJTVNWQTEUMBIG
A1UEAxMLSU1TVkEuVFJFTkQwHhcNMTEwNDAyMDkyOTAwWhcNMzEwNDAyMDkyOTAw
WjBQMQswCQYDVQQIEwJDQTELMAkGA1UEBxMCQ1UxDjAMBgNVBAoTBVRSRU5EMQ4w
DAYDVQQLEwVJTVNWQTEUMBIGA1UEAxMLSU1TVkEuVFJFTkQwggEiMA0GCSqGSIb3
DQEBAQUAA4IBDwAwggEKAoIBAQDP2+JD5UBJNfVN2PFrXe88g/zcGvbqpgvNttxW
eE+zMSGTWF136P8KvTf6t0h/aPL8sqXX44S4Lm3D+IeA/VLjMDCeC4+bi7I0oaSB
YKVkxzGjFRBAJlF67xE3gZSwmbySaDpWzNnWFrdSbNDQVmn9sWTp8n8MI3dfv5sy
hHWL8XnwVb4bbZvhO+8LXfjz9fKIq967YuW4sUaCgD6ej8Ujxjk/sorQzgEPpMeD
SFh7NDGbq4aC+ZrimMWifLwb1c5biIbSRa+QqLG8LIwehB4CfWj/rWObIpL4dTBC
nNihh1g8EnEhe56+EaHsCKAlBT8ujuMtzq8FmnWLUGjWCKIlAgMBAAGjEDAOMAwG
A1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAFvyMsfiE0ijlNLRPZwOnXyv
/2ADD+iYMGzp/jbOn6X4fYL/eTV7RFZRW4qmQYPjdfrgBA4gs6MfILHQX59Fhanp
GiUMhya59i9ycCg+ummF4q8a9G82laM7hYNU+NqMHqmJLwQekXDIrD2ud8usjjEm
PkAH0yW5vWp/mnK9oWyQ3nKbHeN9aYgjklUpBLw76eYhNLrAclXXeGbU/FwLZHvu
mOaiPrjHZXKZ7v6817fPPOTxEWRdkDY/qFiQX/IbZrJvd7zyGfUvbFmf7PwYK0lj
VUcg6YE/6JXjCBp06qafi2hBJ0JKRlHwgkB01GgyNGzWClJciRqUFtLiRGFiQuU=
-----END CERTIFICATE-----
', '0792f0b0a41f8b42031e4960c52f94bd');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=BE, O=GlobalSign nv-sa, CN=GlobalSign Root CA', 3, 1, 0, '1998-09-01 12:00:00', '2028-01-28 12:00:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:15:4b:5a:c3:94
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Sep  1 12:00:00 1998 GMT
            Not After : Jan 28 12:00:00 2028 GMT
        Subject: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:da:0e:e6:99:8d:ce:a3:e3:4f:8a:7e:fb:f1:8b:
                    83:25:6b:ea:48:1f:f1:2a:b0:b9:95:11:04:bd:f0:
                    63:d1:e2:67:66:cf:1c:dd:cf:1b:48:2b:ee:8d:89:
                    8e:9a:af:29:80:65:ab:e9:c7:2d:12:cb:ab:1c:4c:
                    70:07:a1:3d:0a:30:cd:15:8d:4f:f8:dd:d4:8c:50:
                    15:1c:ef:50:ee:c4:2e:f7:fc:e9:52:f2:91:7d:e0:
                    6d:d5:35:30:8e:5e:43:73:f2:41:e9:d5:6a:e3:b2:
                    89:3a:56:39:38:6f:06:3c:88:69:5b:2a:4d:c5:a7:
                    54:b8:6c:89:cc:9b:f9:3c:ca:e5:fd:89:f5:12:3c:
                    92:78:96:d6:dc:74:6e:93:44:61:d1:8d:c7:46:b2:
                    75:0e:86:e8:19:8a:d5:6d:6c:d5:78:16:95:a2:e9:
                    c8:0a:38:eb:f2:24:13:4f:73:54:93:13:85:3a:1b:
                    bc:1e:34:b5:8b:05:8c:b9:77:8b:b1:db:1f:20:91:
                    ab:09:53:6e:90:ce:7b:37:74:b9:70:47:91:22:51:
                    63:16:79:ae:b1:ae:41:26:08:c8:19:2b:d1:46:aa:
                    48:d6:64:2a:d7:83:34:ff:2c:2a:c1:6c:19:43:4a:
                    07:85:e7:d3:7c:f6:21:68:ef:ea:f2:52:9f:7f:93:
                    90:cf
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B
    Signature Algorithm: sha1WithRSAEncryption
        d6:73:e7:7c:4f:76:d0:8d:bf:ec:ba:a2:be:34:c5:28:32:b5:
        7c:fc:6c:9c:2c:2b:bd:09:9e:53:bf:6b:5e:aa:11:48:b6:e5:
        08:a3:b3:ca:3d:61:4d:d3:46:09:b3:3e:c3:a0:e3:63:55:1b:
        f2:ba:ef:ad:39:e1:43:b9:38:a3:e6:2f:8a:26:3b:ef:a0:50:
        56:f9:c6:0a:fd:38:cd:c4:0b:70:51:94:97:98:04:df:c3:5f:
        94:d5:15:c9:14:41:9c:c4:5d:75:64:15:0d:ff:55:30:ec:86:
        8f:ff:0d:ef:2c:b9:63:46:f6:aa:fc:df:bc:69:fd:2e:12:48:
        64:9a:e0:95:f0:a6:ef:29:8f:01:b1:15:b5:0c:1d:a5:fe:69:
        2c:69:24:78:1e:b3:a7:1c:71:62:ee:ca:c8:97:ac:17:5d:8a:
        c2:f8:47:86:6e:2a:c4:56:31:95:d0:67:89:85:2b:f9:6c:a6:
        5d:46:9d:0c:aa:82:e4:99:51:dd:70:b7:db:56:3d:61:e4:6a:
        e1:5c:d6:f6:fe:3d:de:41:cc:07:ae:63:52:bf:53:53:f4:2b:
        e9:c7:fd:b6:f7:82:5f:85:d2:41:18:db:81:b3:04:1c:c5:1f:
        a4:80:6f:15:20:c9:de:0c:88:0a:1d:d6:66:55:e2:fc:48:c9:
        29:26:69:e0','DA0EE6998DCEA3E34F8A7EFBF18B83256BEA481FF12AB0B9951104BDF063D1E26766CF1CDDCF1B482BEE8D898E9AAF298065ABE9C72D12CBAB1C4C7007A13D0A30CD158D4FF8DDD48C50151CEF50EEC42EF7FCE952F2917DE06DD535308E5E4373F241E9D56AE3B2893A5639386F063C88695B2A4DC5A754B86C89CC9BF93CCAE5FD89F5123C927896D6DC746E934461D18DC746B2750E86E8198AD56D6CD5781695A2E9C80A38EBF224134F73549313853A1BBC1E34B58B058CB9778BB1DB1F2091AB09536E90CE7B3774B97047912251631679AEB1AE412608C8192BD146AA48D6642AD78334FF2C2AC16C19434A0785E7D37CF62168EFEAF2529F7F9390CF', '/C=BE/O=GlobalSign nv-sa/OU=Root CA/CN=GlobalSign Root CA', 'C=BE/O=GlobalSign nv-sa/OU=Root CA/CN=GlobalSign Root CA', '040000000001154B5AC394', NULL, '-----BEGIN CERTIFICATE-----
MIIDdTCCAl2gAwIBAgILBAAAAAABFUtaw5QwDQYJKoZIhvcNAQEFBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05ODA5MDExMjAw
MDBaFw0yODAxMjgxMjAwMDBaMFcxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMRAwDgYDVQQLEwdSb290IENBMRswGQYDVQQDExJHbG9iYWxT
aWduIFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDaDuaZ
jc6j40+Kfvvxi4Mla+pIH/EqsLmVEQS98GPR4mdmzxzdzxtIK+6NiY6arymAZavp
xy0Sy6scTHAHoT0KMM0VjU/43dSMUBUc71DuxC73/OlS8pF94G3VNTCOXkNz8kHp
1Wrjsok6Vjk4bwY8iGlbKk3Fp1S4bInMm/k8yuX9ifUSPJJ4ltbcdG6TRGHRjcdG
snUOhugZitVtbNV4FpWi6cgKOOvyJBNPc1STE4U6G7weNLWLBYy5d4ux2x8gkasJ
U26Qzns3dLlwR5EiUWMWea6xrkEmCMgZK9FGqkjWZCrXgzT/LCrBbBlDSgeF59N8
9iFo7+ryUp9/k5DPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8E
BTADAQH/MB0GA1UdDgQWBBRge2YaRQ2XyolQL30EzTSo//z9SzANBgkqhkiG9w0B
AQUFAAOCAQEA1nPnfE920I2/7LqivjTFKDK1fPxsnCwrvQmeU79rXqoRSLblCKOz
yj1hTdNGCbM+w6DjY1Ub8rrvrTnhQ7k4o+YviiY776BQVvnGCv04zcQLcFGUl5gE
38NflNUVyRRBnMRddWQVDf9VMOyGj/8N7yy5Y0b2qvzfvGn9LhJIZJrglfCm7ymP
AbEVtQwdpf5pLGkkeB6zpxxxYu7KyJesF12KwvhHhm4qxFYxldBniYUr+WymXUad
DKqC5JlR3XC321Y9YeRq4VzW9v493kHMB65jUr9TU/Qr6cf9tveCX4XSQRjbgbME
HMUfpIBvFSDJ3gyICh3WZlXi/EjJKSZp4A==
-----END CERTIFICATE-----', '7872bab9a5e1a71e3d7f77836a841a04');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=BE, O=GlobalSign nv-sa, CN=Trusted Root CA G2', 3, 1, 0, '2012-04-25 11:00:00', '2027-04-25 11:00:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:36:e9:3a:3a:b3
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Apr 25 11:00:00 2012 GMT
            Not After : Apr 25 11:00:00 2027 GMT
        Subject: C=BE, OU=Trusted Root, O=GlobalSign nv-sa, CN=Trusted Root CA G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ac:ae:be:aa:ed:70:ca:fb:83:b1:2e:35:bb:b8:
                    b0:ac:31:33:5d:bb:52:c0:a6:c7:54:71:6f:1c:60:
                    70:0a:c6:4b:ba:e3:89:e7:e9:04:7f:f0:e0:b6:2b:
                    ca:68:df:bd:cc:35:b9:ec:8c:36:8a:8b:a3:d9:c9:
                    33:3f:ce:45:7b:a9:6f:7e:4d:35:f1:3a:eb:ba:6b:
                    41:81:da:fa:d4:e3:97:52:22:2a:90:7b:41:4c:2d:
                    df:05:cf:b9:33:05:25:ad:6d:5e:d8:ca:ce:4a:89:
                    ca:e2:65:36:e3:ca:4f:be:87:72:38:0d:aa:05:75:
                    b3:da:86:e3:83:03:e4:8d:89:bc:8d:76:76:ef:33:
                    23:56:e0:75:0f:a5:fc:ab:17:91:37:db:1a:35:2f:
                    84:e2:ce:95:53:56:55:00:e9:2f:e6:0c:22:b1:aa:
                    80:16:31:cb:94:d4:36:0a:c0:71:1b:70:a4:d7:52:
                    d8:a9:05:e6:8b:52:98:cc:1e:55:be:64:86:85:15:
                    bf:7b:bc:53:14:07:fd:65:9b:36:11:ea:d5:1a:c8:
                    96:0f:f4:ac:15:1f:8b:fc:e2:4a:16:05:48:1e:d4:
                    f9:a2:f1:e4:3c:4f:a6:14:c5:06:20:ea:b9:01:a9:
                    b4:1f:85:0b:82:6f:9e:e9:03:4a:d1:62:85:90:99:
                    d5:1f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: https://www.globalsign.com/repository/

            X509v3 Subject Key Identifier: 
                14:F6:E5:8B:31:B6:45:80:4A:4C:6D:FC:C2:87:89:CA:36:C3:90:62
            X509v3 CRL Distribution Points: 
                URI:http://crl.globalsign.net/root.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp2.globalsign.com/rootr1

            X509v3 Authority Key Identifier: 
                keyid:60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B

    Signature Algorithm: sha1WithRSAEncryption
        be:c8:1b:49:7e:93:82:e4:72:92:3e:6b:f9:2f:66:c4:91:c1:
        23:38:b8:0e:b3:19:7d:f8:7b:bf:00:da:8c:ad:af:c4:46:f1:
        b2:70:55:bf:3e:00:73:14:0f:e5:de:da:46:1d:87:f5:23:ff:
        06:90:5d:fa:91:d0:e8:31:41:72:fd:0a:de:19:33:e2:65:47:
        56:af:b0:d2:97:58:be:40:c1:85:c0:5c:23:81:dc:9e:4f:5b:
        65:ce:72:4e:c7:67:0d:2f:45:b1:90:86:35:a3:43:1f:81:e0:
        a3:94:16:0d:5b:de:8b:ff:cf:a5:e4:af:7c:9a:09:f4:50:85:
        78:7b:28:2d:01:73:44:57:3c:f1:b9:36:fe:65:09:6f:b3:b5:
        b6:e0:d3:33:26:de:4c:9f:40:84:d1:ba:c3:12:83:a2:01:b0:
        32:6a:3a:78:da:89:a2:90:45:c5:e2:0f:44:a4:e3:76:57:6f:
        66:d4:28:cc:42:ef:e4:dd:dd:02:f8:47:21:dc:58:96:d0:ed:
        8c:a5:2d:34:bf:c7:e8:f1:58:87:0e:43:4a:0e:e7:fe:78:b7:
        93:d3:43:5e:27:79:88:4e:cf:dc:78:81:49:36:01:80:16:e9:
        dd:6f:78:fc:1b:85:c0:bc:ae:84:30:90:74:fb:1e:f7:d8:06:
        87:3b:e0:53', 'ACAEBEAAED70CAFB83B12E35BBB8B0AC31335DBB52C0A6C754716F1C60700AC64BBAE389E7E9047FF0E0B62BCA68DFBDCC35B9EC8C368A8BA3D9C9333FCE457BA96F7E4D35F13AEBBA6B4181DAFAD4E39752222A907B414C2DDF05CFB9330525AD6D5ED8CACE4A89CAE26536E3CA4FBE8772380DAA0575B3DA86E38303E48D89BC8D7676EF332356E0750FA5FCAB179137DB1A352F84E2CE9553565500E92FE60C22B1AA801631CB94D4360AC0711B70A4D752D8A905E68B5298CC1E55BE64868515BF7BBC531407FD659B3611EAD51AC8960FF4AC151F8BFCE24A1605481ED4F9A2F1E43C4FA614C50620EAB901A9B41F850B826F9EE9034AD162859099D51F', '/C=BE/OU=Trusted Root/O=GlobalSign nv-sa/CN=Trusted Root CA G2', 'C=BE/O=GlobalSign nv-sa/OU=Root CA/CN=GlobalSign Root CA', '04000000000136E93A3AB3', NULL, '-----BEGIN CERTIFICATE-----
MIIEXTCCA0WgAwIBAgILBAAAAAABNuk6OrMwDQYJKoZIhvcNAQEFBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw0xMjA0MjUxMTAw
MDBaFw0yNzA0MjUxMTAwMDBaMFwxCzAJBgNVBAYTAkJFMRUwEwYDVQQLEwxUcnVz
dGVkIFJvb3QxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExGzAZBgNVBAMTElRy
dXN0ZWQgUm9vdCBDQSBHMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
AKyuvqrtcMr7g7EuNbu4sKwxM127UsCmx1RxbxxgcArGS7rjiefpBH/w4LYrymjf
vcw1ueyMNoqLo9nJMz/ORXupb35NNfE667prQYHa+tTjl1IiKpB7QUwt3wXPuTMF
Ja1tXtjKzkqJyuJlNuPKT76HcjgNqgV1s9qG44MD5I2JvI12du8zI1bgdQ+l/KsX
kTfbGjUvhOLOlVNWVQDpL+YMIrGqgBYxy5TUNgrAcRtwpNdS2KkF5otSmMweVb5k
hoUVv3u8UxQH/WWbNhHq1RrIlg/0rBUfi/ziShYFSB7U+aLx5DxPphTFBiDquQGp
tB+FC4JvnukDStFihZCZ1R8CAwEAAaOCASMwggEfMA4GA1UdDwEB/wQEAwIBBjAP
BgNVHRMBAf8EBTADAQH/MEcGA1UdIARAMD4wPAYEVR0gADA0MDIGCCsGAQUFBwIB
FiZodHRwczovL3d3dy5nbG9iYWxzaWduLmNvbS9yZXBvc2l0b3J5LzAdBgNVHQ4E
FgQUFPblizG2RYBKTG38woeJyjbDkGIwMwYDVR0fBCwwKjAooCagJIYiaHR0cDov
L2NybC5nbG9iYWxzaWduLm5ldC9yb290LmNybDA+BggrBgEFBQcBAQQyMDAwLgYI
KwYBBQUHMAGGImh0dHA6Ly9vY3NwMi5nbG9iYWxzaWduLmNvbS9yb290cjEwHwYD
VR0jBBgwFoAUYHtmGkUNl8qJUC99BM00qP/8/UswDQYJKoZIhvcNAQEFBQADggEB
AL7IG0l+k4LkcpI+a/kvZsSRwSM4uA6zGX34e78A2oytr8RG8bJwVb8+AHMUD+Xe
2kYdh/Uj/waQXfqR0OgxQXL9Ct4ZM+JlR1avsNKXWL5AwYXAXCOB3J5PW2XOck7H
Zw0vRbGQhjWjQx+B4KOUFg1b3ov/z6Xkr3yaCfRQhXh7KC0Bc0RXPPG5Nv5lCW+z
tbbg0zMm3kyfQITRusMSg6IBsDJqOnjaiaKQRcXiD0Sk43ZXb2bUKMxC7+Td3QL4
RyHcWJbQ7YylLTS/x+jxWIcOQ0oO5/54t5PTQ14neYhOz9x4gUk2AYAW6d1vePwb
hcC8roQwkHT7HvfYBoc74FM=
-----END CERTIFICATE-----', 'eb7487f02b6d45b7a9c2c2273fa56f07');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=BE, O=GlobalSign nv-sa, CN=Trusted Root CA SHA256 G2', 3, 1, 0, '2012-04-25 11:00:00', '2027-04-25 11:00:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:36:e9:82:39:5d
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: OU=GlobalSign Root CA - R3, O=GlobalSign, CN=GlobalSign
        Validity
            Not Before: Apr 25 11:00:00 2012 GMT
            Not After : Apr 25 11:00:00 2027 GMT
        Subject: C=BE, OU=Trusted Root, O=GlobalSign nv-sa, CN=Trusted Root CA SHA256 G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:cf:cd:3e:fd:0d:8f:02:12:ee:63:07:b4:e1:84:
                    cb:04:b1:8a:af:5f:c9:49:c1:ed:0e:f0:18:e4:4f:
                    78:1a:31:b1:09:b4:91:d7:fd:55:84:bf:3c:d1:43:
                    c9:c8:df:39:b5:d7:4e:a3:16:4f:82:d2:32:66:2c:
                    43:be:f2:be:0a:0a:53:e7:07:9b:c8:10:5b:a8:af:
                    da:a7:b6:a8:07:28:21:00:9e:d7:e7:6d:17:64:c4:
                    70:28:0e:9c:11:66:ba:b6:30:8b:58:7d:73:b1:cc:
                    50:c4:6c:e0:b5:5e:74:ae:7d:ae:c7:64:9a:a6:80:
                    8f:c4:ca:4c:e3:eb:69:11:5c:16:25:fd:ca:3f:73:
                    53:fa:37:7d:19:16:97:5a:03:5e:8b:92:4a:42:ea:
                    3d:97:e7:19:91:27:ae:a1:68:a3:bd:a7:ab:e6:17:
                    0b:0a:e7:cf:cb:03:0c:41:dd:2b:e9:75:c8:33:f9:
                    7b:83:d0:e3:31:a1:36:e1:df:9f:6b:66:d6:c5:05:
                    c2:f1:64:ff:3d:9f:83:d4:a5:04:91:db:67:fe:2c:
                    40:0e:ab:28:88:88:9b:1a:7e:cc:f3:81:04:f7:f3:
                    4b:8d:bc:cf:af:04:4e:94:15:09:17:3e:9c:bb:0f:
                    88:23:4a:d9:f0:e1:45:79:9f:ce:90:71:d8:66:ad:
                    a1:f7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: https://www.globalsign.com/repository/

            X509v3 Subject Key Identifier: 
                C8:63:9B:08:69:54:C2:98:C8:D9:CD:E3:33:B7:50:5E:F8:C9:01:9B
            X509v3 CRL Distribution Points: 
                URI:http://crl.globalsign.net/root-r3.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp2.globalsign.com/rootr3

            X509v3 Authority Key Identifier: 
                keyid:8F:F0:4B:7F:A8:2E:45:24:AE:4D:50:FA:63:9A:8B:DE:E2:DD:1B:BC

    Signature Algorithm: sha256WithRSAEncryption
        5f:36:cb:c0:18:c9:89:8e:a3:dd:61:1c:c4:3d:de:56:7b:08:
        63:8a:58:dd:b9:7a:eb:ad:2d:82:9c:42:b8:b5:71:e2:8d:71:
        ca:25:64:4b:f0:5c:40:50:fb:18:8a:17:14:14:6b:7f:91:e2:
        6c:ed:6e:48:43:b0:d1:06:68:47:09:6c:8a:8d:55:3e:0d:4f:
        45:a7:1c:1b:90:b5:b0:1e:75:97:f4:cb:d5:71:f9:ce:57:59:
        04:29:d1:62:ba:c5:a8:23:e8:af:18:b4:c6:84:68:82:3f:24:
        aa:44:b6:c7:2c:d8:2c:49:61:c7:d5:fb:8c:8c:df:67:c7:42:
        e2:68:0e:7a:80:ad:56:fc:0c:f7:1b:e6:79:fd:e7:e9:5c:9b:
        ef:f8:65:df:0f:f3:5b:02:b1:5b:22:89:35:a1:7b:b5:27:03:
        e6:7b:ed:2d:4c:f2:06:9a:fe:f9:ac:ed:8b:22:75:5a:58:96:
        71:2e:96:f9:5d:a0:2a:0f:6b:c4:40:bf:ad:cd:b2:25:2e:f4:
        0e:f7:e4:3e:21:27:04:9d:b1:d8:01:d9:57:7c:8a:4c:02:d4:
        aa:ea:e4:57:bd:39:26:57:9d:a9:44:fd:23:97:eb:03:06:0d:
        5d:9f:29:37:37:5e:9f:e0:c8:71:22:28:ef:22:b2:e8:c5:fd:
        73:36:c5:59', 'CFCD3EFD0D8F0212EE6307B4E184CB04B18AAF5FC949C1ED0EF018E44F781A31B109B491D7FD5584BF3CD143C9C8DF39B5D74EA3164F82D232662C43BEF2BE0A0A53E7079BC8105BA8AFDAA7B6A8072821009ED7E76D1764C470280E9C1166BAB6308B587D73B1CC50C46CE0B55E74AE7DAEC7649AA6808FC4CA4CE3EB69115C1625FDCA3F7353FA377D1916975A035E8B924A42EA3D97E7199127AEA168A3BDA7ABE6170B0AE7CFCB030C41DD2BE975C833F97B83D0E331A136E1DF9F6B66D6C505C2F164FF3D9F83D4A50491DB67FE2C400EAB2888889B1A7ECCF38104F7F34B8DBCCFAF044E941509173E9CBB0F88234AD9F0E145799FCE9071D866ADA1F7', '/C=BE/OU=Trusted Root/O=GlobalSign nv-sa/CN=Trusted Root CA SHA256 G2', 'OU=GlobalSign Root CA - R3/O=GlobalSign/CN=GlobalSign', '04000000000136E982395D', NULL, '-----BEGIN CERTIFICATE-----
MIIEXDCCA0SgAwIBAgILBAAAAAABNumCOV0wDQYJKoZIhvcNAQELBQAwTDEgMB4G
A1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjMxEzARBgNVBAoTCkdsb2JhbFNp
Z24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMTIwNDI1MTEwMDAwWhcNMjcwNDI1
MTEwMDAwWjBjMQswCQYDVQQGEwJCRTEVMBMGA1UECxMMVHJ1c3RlZCBSb290MRkw
FwYDVQQKExBHbG9iYWxTaWduIG52LXNhMSIwIAYDVQQDExlUcnVzdGVkIFJvb3Qg
Q0EgU0hBMjU2IEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAz80+
/Q2PAhLuYwe04YTLBLGKr1/JScHtDvAY5E94GjGxCbSR1/1VhL880UPJyN85tddO
oxZPgtIyZixDvvK+CgpT5webyBBbqK/ap7aoByghAJ7X520XZMRwKA6cEWa6tjCL
WH1zscxQxGzgtV50rn2ux2SapoCPxMpM4+tpEVwWJf3KP3NT+jd9GRaXWgNei5JK
Quo9l+cZkSeuoWijvaer5hcLCufPywMMQd0r6XXIM/l7g9DjMaE24d+fa2bWxQXC
8WT/PZ+D1KUEkdtn/ixADqsoiIibGn7M84EE9/NLjbzPrwROlBUJFz6cuw+II0rZ
8OFFeZ/OkHHYZq2h9wIDAQABo4IBJjCCASIwDgYDVR0PAQH/BAQDAgEGMA8GA1Ud
EwEB/wQFMAMBAf8wRwYDVR0gBEAwPjA8BgRVHSAAMDQwMgYIKwYBBQUHAgEWJmh0
dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRvcnkvMB0GA1UdDgQWBBTI
Y5sIaVTCmMjZzeMzt1Be+MkBmzA2BgNVHR8ELzAtMCugKaAnhiVodHRwOi8vY3Js
Lmdsb2JhbHNpZ24ubmV0L3Jvb3QtcjMuY3JsMD4GCCsGAQUFBwEBBDIwMDAuBggr
BgEFBQcwAYYiaHR0cDovL29jc3AyLmdsb2JhbHNpZ24uY29tL3Jvb3RyMzAfBgNV
HSMEGDAWgBSP8Et/qC5FJK5NUPpjmove4t0bvDANBgkqhkiG9w0BAQsFAAOCAQEA
XzbLwBjJiY6j3WEcxD3eVnsIY4pY3bl6660tgpxCuLVx4o1xyiVkS/BcQFD7GIoX
FBRrf5HibO1uSEOw0QZoRwlsio1VPg1PRaccG5C1sB51l/TL1XH5zldZBCnRYrrF
qCPorxi0xoRogj8kqkS2xyzYLElhx9X7jIzfZ8dC4mgOeoCtVvwM9xvmef3n6Vyb
7/hl3w/zWwKxWyKJNaF7tScD5nvtLUzyBpr++aztiyJ1WliWcS6W+V2gKg9rxEC/
rc2yJS70DvfkPiEnBJ2x2AHZV3yKTALUqurkV705JledqUT9I5frAwYNXZ8pNzde
n+DIcSIo7yKy6MX9czbFWQ==
-----END CERTIFICATE-----', 'c83c558a3c1c12d69aa76d3d1f587cd4');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=BM, O=QuoVadis Limited, CN=QuoVadis Root Certification Authority', 3, 1, 0, '2001-03-19 18:33:33', '2021-03-17 18:33:33', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 985026699 (0x3ab6508b)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=BM, O=QuoVadis Limited, OU=Root Certification Authority, CN=QuoVadis Root Certification Authority
        Validity
            Not Before: Mar 19 18:33:33 2001 GMT
            Not After : Mar 17 18:33:33 2021 GMT
        Subject: C=BM, O=QuoVadis Limited, OU=Root Certification Authority, CN=QuoVadis Root Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:bf:61:b5:95:53:ba:57:fc:fa:f2:67:0b:3a:1a:
                    df:11:80:64:95:b4:d1:bc:cd:7a:cf:f6:29:96:2e:
                    24:54:40:24:38:f7:1a:85:dc:58:4c:cb:a4:27:42:
                    97:d0:9f:83:8a:c3:e4:06:03:5b:00:a5:51:1e:70:
                    04:74:e2:c1:d4:3a:ab:d7:ad:3b:07:18:05:8e:fd:
                    83:ac:ea:66:d9:18:1b:68:8a:f5:57:1a:98:ba:f5:
                    ed:76:3d:7c:d9:de:94:6a:3b:4b:17:c1:d5:8f:bd:
                    65:38:3a:95:d0:3d:55:36:4e:df:79:57:31:2a:1e:
                    d8:59:65:49:58:20:98:7e:ab:5f:7e:9f:e9:d6:4d:
                    ec:83:74:a9:c7:6c:d8:ee:29:4a:85:2a:06:14:f9:
                    54:e6:d3:da:65:07:8b:63:37:12:d7:d0:ec:c3:7b:
                    20:41:44:a3:ed:cb:a0:17:e1:71:65:ce:1d:66:31:
                    f7:76:01:19:c8:7d:03:58:b6:95:49:1d:a6:12:26:
                    e8:c6:0c:76:e0:e3:66:cb:ea:5d:a6:26:ee:e5:cc:
                    5f:bd:67:a7:01:27:0e:a2:ca:54:c5:b1:7a:95:1d:
                    71:1e:4a:29:8a:03:dc:6a:45:c1:a4:19:5e:6f:36:
                    cd:c3:a2:b0:b7:fe:5c:38:e2:52:bc:f8:44:43:e6:
                    90:bb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Authority Information Access: 
                OCSP - URI:https://ocsp.quovadisoffshore.com

            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Certificate Policies: 
                Policy: 1.3.6.1.4.1.8024.0.1
                  User Notice:
                    Explicit Text: Reliance on the QuoVadis Root Certificate by any party assumes acceptance of the then applicable standard terms and conditions of use, certification practices, and the QuoVadis Certificate Policy.
                  CPS: http://www.quovadis.bm

            X509v3 Subject Key Identifier: 
                8B:4B:6D:ED:D3:29:B9:06:19:EC:39:39:A9:F0:97:84:6A:CB:EF:DF
            X509v3 Authority Key Identifier: 
                keyid:8B:4B:6D:ED:D3:29:B9:06:19:EC:39:39:A9:F0:97:84:6A:CB:EF:DF
                DirName:/C=BM/O=QuoVadis Limited/OU=Root Certification Authority/CN=QuoVadis Root Certification Authority
                serial:3A:B6:50:8B

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        8a:d4:14:b5:fe:f4:9a:92:a7:19:d4:a4:7e:72:18:8f:d9:68:
        7c:52:24:dd:67:6f:39:7a:c4:aa:5e:3d:e2:58:b0:4d:70:98:
        84:61:e8:1b:e3:69:18:0e:ce:fb:47:50:a0:4e:ff:f0:24:1f:
        bd:b2:ce:f5:27:fc:ec:2f:53:aa:73:7b:03:3d:74:6e:e6:16:
        9e:eb:a5:2e:c4:bf:56:27:50:2b:62:ba:be:4b:1c:3c:55:5c:
        41:1d:24:be:82:20:47:5d:d5:44:7e:7a:16:68:df:7d:4d:51:
        70:78:57:1d:33:1e:fd:02:99:9c:0c:cd:0a:05:4f:c7:bb:8e:
        a4:75:fa:4a:6d:b1:80:8e:09:56:b9:9c:1a:60:fe:5d:c1:d7:
        7a:dc:11:78:d0:d6:5d:c1:b7:d5:ad:32:99:03:3a:8a:cc:54:
        25:39:31:81:7b:13:22:51:ba:46:6c:a1:bb:9e:fa:04:6c:49:
        26:74:8f:d2:73:eb:cc:30:a2:e6:ea:59:22:87:f8:97:f5:0e:
        fd:ea:cc:92:a4:16:c4:52:18:ea:21:ce:b1:f1:e6:84:81:e5:
        ba:a9:86:28:f2:43:5a:5d:12:9d:ac:1e:d9:a8:e5:0a:6a:a7:
        7f:a0:87:29:cf:f2:89:4d:d4:ec:c5:e2:e6:7a:d0:36:23:8a:
        4a:74:36:f9', 'BF61B59553BA57FCFAF2670B3A1ADF11806495B4D1BCCD7ACFF629962E2454402438F71A85DC584CCBA4274297D09F838AC3E406035B00A5511E700474E2C1D43AABD7AD3B0718058EFD83ACEA66D9181B688AF5571A98BAF5ED763D7CD9DE946A3B4B17C1D58FBD65383A95D03D55364EDF7957312A1ED85965495820987EAB5F7E9FE9D64DEC8374A9C76CD8EE294A852A0614F954E6D3DA65078B633712D7D0ECC37B204144A3EDCBA017E17165CE1D6631F7760119C87D0358B695491DA61226E8C60C76E0E366CBEA5DA626EEE5CC5FBD67A701270EA2CA54C5B17A951D711E4A298A03DC6A45C1A4195E6F36CDC3A2B0B7FE5C38E252BCF84443E690BB', '/C=BM/O=QuoVadis Limited/OU=Root Certification Authority/CN=QuoVadis Root Certification Authority', 'C=BM/O=QuoVadis Limited/OU=Root Certification Authority/CN=QuoVadis Root Certification Authority', 'AB6508B', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', 'd6ef793f3cc9bed96240494bd2958c8c');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=DK, O=TDC, CN=TDC OCES CA', 3, 1, 0, '2003-02-11 08:39:30', '2037-02-11 09:09:30', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1044954564 (0x3e48bdc4)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=DK, O=TDC, CN=TDC OCES CA
        Validity
            Not Before: Feb 11 08:39:30 2003 GMT
            Not After : Feb 11 09:09:30 2037 GMT
        Subject: C=DK, O=TDC, CN=TDC OCES CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ac:62:f6:61:20:b2:cf:c0:c6:85:d7:e3:79:e6:
                    cc:ed:f2:39:92:a4:97:2e:64:a3:84:5b:87:9c:4c:
                    fd:a4:f3:c4:5f:21:bd:56:10:eb:db:2e:61:ec:93:
                    69:e3:a3:cc:bd:99:c3:05:fc:06:b8:ca:36:1c:fe:
                    90:8e:49:4c:c4:56:9a:2f:56:bc:cf:7b:0c:f1:6f:
                    47:a6:0d:43:4d:e2:e9:1d:39:34:cd:8d:2c:d9:12:
                    98:f9:e3:e1:c1:4a:7c:86:38:c4:a9:c4:61:88:d2:
                    5e:af:1a:26:4d:d5:e4:a0:22:47:84:d9:64:b7:19:
                    96:fc:ec:19:e4:b2:97:26:4e:4a:4c:cb:8f:24:8b:
                    54:18:1c:48:61:7b:d5:88:68:da:5d:b5:ea:cd:1a:
                    30:c1:80:83:76:50:aa:4f:d1:d4:dd:38:f0:ef:16:
                    f4:e1:0c:50:06:bf:ea:fb:7a:49:a1:28:2b:1c:f6:
                    fc:15:32:a3:74:6a:8f:a9:c3:62:29:71:31:e5:3b:
                    a4:60:17:5e:74:e6:da:13:ed:e9:1f:1f:1b:d1:b2:
                    68:73:c6:10:34:75:46:10:10:e3:90:00:76:40:cb:
                    8b:b7:43:09:21:ff:ab:4e:93:c6:58:e9:a5:82:db:
                    77:c4:3a:99:b1:72:95:49:04:f0:b7:2b:fa:7b:59:
                    8e:dd
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Certificate Policies: 
                Policy: 1.2.208.169.1.1.1
                  CPS: http://www.certifikat.dk/repository
                  User Notice:
                    Organization: TDC
                    Number: 1
                    Explicit Text: Certifikater fra denne CA udstedes under OID 1.2.208.169.1.1.1. Certificates from this CA are issued under OID 1.2.208.169.1.1.1.

            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 CRL Distribution Points: 
                DirName:/C=DK/O=TDC/CN=TDC OCES CA/CN=CRL1
                URI:http://crl.oces.certifikat.dk/oces.crl

            X509v3 Private Key Usage Period: 
                Not Before: Feb 11 08:39:30 2003 GMT, Not After: Feb 11 09:09:30 2037 GMT
            X509v3 Authority Key Identifier: 
                keyid:60:B5:85:EC:56:64:7E:12:19:27:67:1D:50:15:4B:73:AE:3B:F9:12

            X509v3 Subject Key Identifier: 
                60:B5:85:EC:56:64:7E:12:19:27:67:1D:50:15:4B:73:AE:3B:F9:12
            1.2.840.113533.7.65.0: 
                0...V6.0:4.0....
    Signature Algorithm: sha1WithRSAEncryption
        0a:ba:26:26:46:d3:73:a8:09:f3:6b:0b:30:99:fd:8a:e1:57:
        7a:11:d3:b8:94:d7:09:10:6e:a3:b1:38:03:d1:b6:f2:43:41:
        29:62:a7:72:d8:fb:7c:05:e6:31:70:27:54:18:4e:8a:7c:4e:
        e5:d1:ca:8c:78:88:cf:1b:d3:90:8b:e6:23:f8:0b:0e:33:43:
        7d:9c:e2:0a:19:8f:c9:01:3e:74:5d:74:c9:8b:1c:03:e5:18:
        c8:01:4c:3f:cb:97:05:5d:98:71:a6:98:6f:b6:7c:bd:37:7f:
        be:e1:93:25:6d:6f:f0:0a:ad:17:18:e1:03:bc:07:29:c8:ad:
        26:e8:f8:61:f0:fd:21:09:7e:9a:8e:a9:68:7d:48:62:72:bd:
        00:ea:01:99:b8:06:82:51:81:4e:f1:f5:b4:91:54:b9:23:7a:
        00:9a:9f:5d:8d:e0:3c:64:b9:1a:12:92:2a:c7:82:44:72:39:
        dc:e2:3c:c6:d8:55:f5:15:4e:c8:05:0e:db:c6:d0:62:a6:ec:
        15:b4:b5:02:82:db:ac:8c:a2:81:f0:9b:99:31:f5:20:20:a8:
        88:61:0a:07:9f:94:fc:d0:d7:1b:cc:2e:17:f3:04:27:76:67:
        eb:54:83:fd:a4:90:7e:06:3d:04:a3:43:2d:da:fc:0b:62:ea:
        2f:5f:62:53', 'AC62F66120B2CFC0C685D7E379E6CCEDF23992A4972E64A3845B879C4CFDA4F3C45F21BD5610EBDB2E61EC9369E3A3CCBD99C305FC06B8CA361CFE908E494CC4569A2F56BCCF7B0CF16F47A60D434DE2E91D3934CD8D2CD91298F9E3E1C14A7C8638C4A9C46188D25EAF1A264DD5E4A0224784D964B71996FCEC19E4B297264E4A4CCB8F248B54181C48617BD58868DA5DB5EACD1A30C180837650AA4FD1D4DD38F0EF16F4E10C5006BFEAFB7A49A1282B1CF6FC1532A3746A8FA9C362297131E53BA460175E74E6DA13EDE91F1F1BD1B26873C6103475461010E390007640CB8BB7430921FFAB4E93C658E9A582DB77C43A99B172954904F0B72BFA7B598EDD', '/C=DK/O=TDC/CN=TDC OCES CA', 'C=DK/O=TDC/CN=TDC OCES CA', '3E48BDC4', NULL, '-----BEGIN CERTIFICATE-----
MIIFGTCCBAGgAwIBAgIEPki9xDANBgkqhkiG9w0BAQUFADAxMQswCQYDVQQGEwJE
SzEMMAoGA1UEChMDVERDMRQwEgYDVQQDEwtUREMgT0NFUyBDQTAeFw0wMzAyMTEw
ODM5MzBaFw0zNzAyMTEwOTA5MzBaMDExCzAJBgNVBAYTAkRLMQwwCgYDVQQKEwNU
REMxFDASBgNVBAMTC1REQyBPQ0VTIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A
MIIBCgKCAQEArGL2YSCyz8DGhdfjeebM7fI5kqSXLmSjhFuHnEz9pPPEXyG9VhDr
2y5h7JNp46PMvZnDBfwGuMo2HP6QjklMxFaaL1a8z3sM8W9Hpg1DTeLpHTk0zY0s
2RKY+ePhwUp8hjjEqcRhiNJerxomTdXkoCJHhNlktxmW/OwZ5LKXJk5KTMuPJItU
GBxIYXvViGjaXbXqzRowwYCDdlCqT9HU3Tjw7xb04QxQBr/q+3pJoSgrHPb8FTKj
dGqPqcNiKXEx5TukYBdedObaE+3pHx8b0bJoc8YQNHVGEBDjkAB2QMuLt0MJIf+r
TpPGWOmlgtt3xDqZsXKVSQTwtyv6e1mO3QIDAQABo4ICNzCCAjMwDwYDVR0TAQH/
BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwgewGA1UdIASB5DCB4TCB3gYIKoFQgSkB
AQEwgdEwLwYIKwYBBQUHAgEWI2h0dHA6Ly93d3cuY2VydGlmaWthdC5kay9yZXBv
c2l0b3J5MIGdBggrBgEFBQcCAjCBkDAKFgNUREMwAwIBARqBgUNlcnRpZmlrYXRl
ciBmcmEgZGVubmUgQ0EgdWRzdGVkZXMgdW5kZXIgT0lEIDEuMi4yMDguMTY5LjEu
MS4xLiBDZXJ0aWZpY2F0ZXMgZnJvbSB0aGlzIENBIGFyZSBpc3N1ZWQgdW5kZXIg
T0lEIDEuMi4yMDguMTY5LjEuMS4xLjARBglghkgBhvhCAQEEBAMCAAcwgYEGA1Ud
HwR6MHgwSKBGoESkQjBAMQswCQYDVQQGEwJESzEMMAoGA1UEChMDVERDMRQwEgYD
VQQDEwtUREMgT0NFUyBDQTENMAsGA1UEAxMEQ1JMMTAsoCqgKIYmaHR0cDovL2Ny
bC5vY2VzLmNlcnRpZmlrYXQuZGsvb2Nlcy5jcmwwKwYDVR0QBCQwIoAPMjAwMzAy
MTEwODM5MzBagQ8yMDM3MDIxMTA5MDkzMFowHwYDVR0jBBgwFoAUYLWF7FZkfhIZ
J2cdUBVLc647+RIwHQYDVR0OBBYEFGC1hexWZH4SGSdnHVAVS3OuO/kSMB0GCSqG
SIb2fQdBAAQQMA4bCFY2LjA6NC4wAwIEkDANBgkqhkiG9w0BAQUFAAOCAQEACrom
JkbTc6gJ82sLMJn9iuFXehHTuJTXCRBuo7E4A9G28kNBKWKnctj7fAXmMXAnVBhO
inxO5dHKjHiIzxvTkIvmI/gLDjNDfZziChmPyQE+dF10yYscA+UYyAFMP8uXBV2Y
caaYb7Z8vTd/vuGTJW1v8AqtFxjhA7wHKcitJuj4YfD9IQl+mo6paH1IYnK9AOoB
mbgGglGBTvH1tJFUuSN6AJqfXY3gPGS5GhKSKseCRHI53OI8xthV9RVOyAUO28bQ
YqbsFbS1AoLbrIyigfCbmTH1ICCoiGEKB5+U/NDXG8wuF/MEJ3Zn61SD/aSQfgY9
BKNDLdr8C2LqL19iUw==
-----END CERTIFICATE-----', '89e8c77260dca45e9de7465e9cf1e94d');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=DK, O=TDC Internet', 3, 1, 0, '2001-04-05 16:33:17', '2021-04-05 17:03:17', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 986490188 (0x3acca54c)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=DK, O=TDC Internet, OU=TDC Internet Root CA
        Validity
            Not Before: Apr  5 16:33:17 2001 GMT
            Not After : Apr  5 17:03:17 2021 GMT
        Subject: C=DK, O=TDC Internet, OU=TDC Internet Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:c4:b8:40:bc:91:d5:63:1f:d7:99:a0:8b:0c:40:
                    1e:74:b7:48:9d:46:8c:02:b2:e0:24:5f:f0:19:13:
                    a7:37:83:6b:5d:c7:8e:f9:84:30:ce:1a:3b:fa:fb:
                    ce:8b:6d:23:c6:c3:6e:66:9f:89:a5:df:e0:42:50:
                    67:fa:1f:6c:1e:f4:d0:05:d6:bf:ca:d6:4e:e4:68:
                    60:6c:46:aa:1c:5d:63:e1:07:86:0e:65:00:a7:2e:
                    a6:71:c6:bc:b9:81:a8:3a:7d:1a:d2:f9:d1:ac:4b:
                    cb:ce:75:af:dc:7b:fa:81:73:d4:fc:ba:bd:41:88:
                    d4:74:b3:f9:5e:38:3a:3c:43:a8:d2:95:4e:77:6d:
                    13:0c:9d:8f:78:01:b7:5a:20:1f:03:37:35:e2:2c:
                    db:4b:2b:2c:78:b9:49:db:c4:d0:c7:9c:9c:e4:8a:
                    20:09:21:16:56:66:ff:05:ec:5b:e3:f0:cf:ab:24:
                    24:5e:c3:7f:70:7a:12:c4:d2:b5:10:a0:b6:21:e1:
                    8d:78:69:55:44:69:f5:ca:96:1c:34:85:17:25:77:
                    e2:f6:2f:27:98:78:fd:79:06:3a:a2:d6:5a:43:c1:
                    ff:ec:04:3b:ee:13:ef:d3:58:5a:ff:92:eb:ec:ae:
                    da:f2:37:03:47:41:b6:97:c9:2d:0a:41:22:bb:bb:
                    e6:a7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 CRL Distribution Points: 
                DirName:/C=DK/O=TDC Internet/OU=TDC Internet Root CA/CN=CRL1

            X509v3 Private Key Usage Period: 
                Not Before: Apr  5 16:33:17 2001 GMT, Not After: Apr  5 17:03:17 2021 GMT
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
                keyid:6C:64:01:C7:FD:85:6D:AC:C8:DA:9E:50:08:85:08:B5:3C:56:A8:50

            X509v3 Subject Key Identifier: 
                6C:64:01:C7:FD:85:6D:AC:C8:DA:9E:50:08:85:08:B5:3C:56:A8:50
            X509v3 Basic Constraints: 
                CA:TRUE
            1.2.840.113533.7.65.0: 
                0...V5.0:4.0....
    Signature Algorithm: sha1WithRSAEncryption
        4e:43:cc:d1:dd:1d:10:1b:06:7f:b7:a4:fa:d3:d9:4d:fb:23:
        9f:23:54:5b:e6:8b:2f:04:28:8b:b5:27:6d:89:a1:ec:98:69:
        dc:e7:8d:26:83:05:79:74:ec:b4:b9:a3:97:c1:35:00:fd:15:
        da:39:81:3a:95:31:90:de:97:e9:86:a8:99:77:0c:e5:5a:a0:
        84:ff:12:16:ac:6e:b8:8d:c3:7b:92:c2:ac:2e:d0:7d:28:ec:
        b6:f3:60:38:69:6f:3e:d8:04:55:3e:9e:cc:55:d2:ba:fe:bb:
        47:04:d7:0a:d9:16:0a:34:29:f5:58:13:d5:4f:cf:8f:56:4b:
        b3:1e:ee:d3:98:79:da:08:1e:0c:6f:b8:f8:16:27:ef:c2:6f:
        3d:f6:a3:4b:3e:0e:e4:6d:6c:db:3b:41:12:9b:bd:0d:47:23:
        7f:3c:4a:d0:af:c0:af:f6:ef:1b:b5:15:c4:eb:83:c4:09:5f:
        74:8b:d9:11:fb:c2:56:b1:3c:f8:70:ca:34:8d:43:40:13:8c:
        fd:99:03:54:79:c6:2e:ea:86:a1:f6:3a:d4:09:bc:f4:bc:66:
        cc:3d:58:d0:57:49:0a:ee:25:e2:41:ee:13:f9:9b:38:34:d1:
        00:f5:7e:e7:94:1d:fc:69:03:62:b8:99:05:05:3d:6b:78:12:
        bd:b0:6f:65', 'C4B840BC91D5631FD799A08B0C401E74B7489D468C02B2E0245FF01913A737836B5DC78EF98430CE1A3BFAFBCE8B6D23C6C36E669F89A5DFE0425067FA1F6C1EF4D005D6BFCAD64EE468606C46AA1C5D63E107860E6500A72EA671C6BCB981A83A7D1AD2F9D1AC4BCBCE75AFDC7BFA8173D4FCBABD4188D474B3F95E383A3C43A8D2954E776D130C9D8F7801B75A201F033735E22CDB4B2B2C78B949DBC4D0C79C9CE48A200921165666FF05EC5BE3F0CFAB24245EC37F707A12C4D2B510A0B621E18D7869554469F5CA961C3485172577E2F62F279878FD79063AA2D65A43C1FFEC043BEE13EFD3585AFF92EBECAEDAF237034741B697C92D0A4122BBBBE6A7','/C=DK/O=TDC Internet/OU=TDC Internet Root CA', 'C=DK/O=TDC Internet/OU=TDC Internet Root CA', '3ACCA54C', NULL, '-----BEGIN CERTIFICATE-----
MIIEKzCCAxOgAwIBAgIEOsylTDANBgkqhkiG9w0BAQUFADBDMQswCQYDVQQGEwJE
SzEVMBMGA1UEChMMVERDIEludGVybmV0MR0wGwYDVQQLExRUREMgSW50ZXJuZXQg
Um9vdCBDQTAeFw0wMTA0MDUxNjMzMTdaFw0yMTA0MDUxNzAzMTdaMEMxCzAJBgNV
BAYTAkRLMRUwEwYDVQQKEwxUREMgSW50ZXJuZXQxHTAbBgNVBAsTFFREQyBJbnRl
cm5ldCBSb290IENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxLhA
vJHVYx/XmaCLDEAedLdInUaMArLgJF/wGROnN4NrXceO+YQwzho7+vvOi20jxsNu
Zp+Jpd/gQlBn+h9sHvTQBda/ytZO5GhgbEaqHF1j4QeGDmUApy6mcca8uYGoOn0a
0vnRrEvLznWv3Hv6gXPU/Lq9QYjUdLP5Xjg6PEOo0pVOd20TDJ2PeAG3WiAfAzc1
4izbSysseLlJ28TQx5yc5IogCSEWVmb/Bexb4/DPqyQkXsN/cHoSxNK1EKC2IeGN
eGlVRGn1ypYcNIUXJXfi9i8nmHj9eQY6otZaQ8H/7AQ77hPv01ha/5Lr7K7a8jcD
R0G2l8ktCkEiu7vmpwIDAQABo4IBJTCCASEwEQYJYIZIAYb4QgEBBAQDAgAHMGUG
A1UdHwReMFwwWqBYoFakVDBSMQswCQYDVQQGEwJESzEVMBMGA1UEChMMVERDIElu
dGVybmV0MR0wGwYDVQQLExRUREMgSW50ZXJuZXQgUm9vdCBDQTENMAsGA1UEAxME
Q1JMMTArBgNVHRAEJDAigA8yMDAxMDQwNTE2MzMxN1qBDzIwMjEwNDA1MTcwMzE3
WjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAUbGQBx/2FbazI2p5QCIUItTxWqFAw
HQYDVR0OBBYEFGxkAcf9hW2syNqeUAiFCLU8VqhQMAwGA1UdEwQFMAMBAf8wHQYJ
KoZIhvZ9B0EABBAwDhsIVjUuMDo0LjADAgSQMA0GCSqGSIb3DQEBBQUAA4IBAQBO
Q8zR3R0QGwZ/t6T609lN+yOfI1Rb5osvBCiLtSdtiaHsmGnc540mgwV5dOy0uaOX
wTUA/RXaOYE6lTGQ3pfphqiZdwzlWqCE/xIWrG64jcN7ksKsLtB9KOy282A4aW8+
2ARVPp7MVdK6/rtHBNcK2RYKNCn1WBPVT8+PVkuzHu7TmHnaCB4Mb7j4Fifvwm89
9qNLPg7kbWzbO0ESm70NRyN/PErQr8Cv9u8btRXE64PECV90i9kR+8JWsTz4cMo0
jUNAE4z9mQNUecYu6oah9jrUCbz0vGbMPVjQV0kK7iXiQe4T+Zs4NNEA9X7nlB38
aQNiuJkFBT1reBK9sG9l
-----END CERTIFICATE-----', 'b57630f33fb356ca170805f083be2987');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ES, O=IPS Internet publishing Services s.l., CN=IPS CA Chained CAs Certification Authority', 3, 1, 0, '2001-12-29 00:53:58', '2025-12-27 00:53:58', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ES, ST=Barcelona, L=Barcelona, O=IPS Internet publishing Services s.l., O=ips@mail.ips.es C.I.F.  B-60929452, OU=IPS CA Chained CAs Certification Authority, CN=IPS CA Chained CAs Certification Authority/emailAddress=ips@mail.ips.es
        Validity
            Not Before: Dec 29 00:53:58 2001 GMT
            Not After : Dec 27 00:53:58 2025 GMT
        Subject: C=ES, ST=Barcelona, L=Barcelona, O=IPS Internet publishing Services s.l., O=ips@mail.ips.es C.I.F.  B-60929452, OU=IPS CA Chained CAs Certification Authority, CN=IPS CA Chained CAs Certification Authority/emailAddress=ips@mail.ips.es
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:dc:56:92:49:b2:94:20:bc:98:4f:50:eb:68:a4:
                    a7:49:0b:bf:d2:31:e8:c7:4f:c2:86:0b:fa:68:fd:
                    43:5a:8a:f3:60:92:35:99:38:bb:4d:03:52:21:5b:
                    f0:37:99:35:e1:41:20:81:85:81:05:71:81:9d:b4:
                    95:19:a9:5f:76:34:2e:63:37:35:57:8e:b4:1f:42:
                    3f:15:5c:e1:7a:c1:5f:13:18:32:31:c9:ad:be:a3:
                    c7:83:66:1e:b9:9c:04:13:cb:69:c1:06:de:30:06:
                    bb:33:a3:b5:1f:f0:8f:6f:ce:ff:96:e8:54:be:66:
                    80:ae:6b:db:41:84:36:a2:3d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                A1:AD:31:B1:F9:3E:E1:17:A6:C8:AB:34:FC:52:87:09:1E:62:52:41
            X509v3 Authority Key Identifier: 
                keyid:A1:AD:31:B1:F9:3E:E1:17:A6:C8:AB:34:FC:52:87:09:1E:62:52:41
                DirName:/C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA Chained CAs Certification Authority/CN=IPS CA Chained CAs Certification Authority/emailAddress=ips@mail.ips.es
                serial:00

            X509v3 Basic Constraints: 
                CA:TRUE
            X509v3 Key Usage: 
                Digital Signature, Non Repudiation, Key Encipherment, Data Encipherment, Key Agreement, Certificate Sign, CRL Sign, Encipher Only, Decipher Only
            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication, Code Signing, E-mail Protection, Time Stamping, Microsoft Individual Code Signing, Microsoft Commercial Code Signing, Microsoft Trust List Signing, Microsoft Encrypted File System
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 Subject Alternative Name: 
                email:ips@mail.ips.es
            X509v3 Issuer Alternative Name: 
                email:ips@mail.ips.es
            Netscape Comment: 
                Chained CA Certificate issued by http://www.ips.es/
            Netscape Base Url: 
                http://www.ips.es/ips2002/
            Netscape CA Revocation Url: 
                http://www.ips.es/ips2002/ips2002CAC.crl
            Netscape Revocation Url: 
                http://www.ips.es/ips2002/revocationCAC.html?
            Netscape Renewal Url: 
                http://www.ips.es/ips2002/renewalCAC.html?
            Netscape CA Policy Url: 
                http://www.ips.es/ips2002/policyCAC.html
            X509v3 CRL Distribution Points: 
                URI:http://www.ips.es/ips2002/ips2002CAC.crl
                URI:http://wwwback.ips.es/ips2002/ips2002CAC.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp.ips.es/

    Signature Algorithm: sha1WithRSAEncryption
        44:72:30:9d:56:58:a2:41:1b:28:b7:95:e1:a6:1a:95:5f:a7:
        78:40:2b:ef:db:96:4a:fc:4c:71:63:d9:73:95:bd:02:e2:a2:
        06:c7:be:97:2a:93:80:34:86:03:fa:dc:d8:3d:1e:07:cd:1e:
        73:43:24:60:f5:1d:61:dc:dc:96:a0:bc:fb:1d:e3:e7:12:00:
        27:33:02:c0:c0:2b:53:3d:d8:6b:03:81:a3:db:d6:93:95:20:
        ef:d3:96:7e:26:90:89:9c:26:9b:cd:6f:66:ab:ed:03:22:44:
        38:cc:59:bd:9f:db:f6:07:a2:01:7f:26:c4:63:f5:25:42:5e:
        62:bd', 'DC569249B29420BC984F50EB68A4A7490BBFD231E8C74FC2860BFA68FD435A8AF36092359938BB4D0352215BF0379935E141208185810571819DB49519A95F76342E633735578EB41F423F155CE17AC15F13183231C9ADBEA3C783661EB99C0413CB69C106DE3006BB33A3B51FF08F6FCEFF96E854BE6680AE6BDB418436A23D', '/C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA Chained CAs Certification Authority/CN=IPS CA Chained CAs Certification Authority/emailAddress=ips@mail.ips.es', 'C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA Chained CAs Certification Authority/CN=IPS CA Chained CAs Certification Authority/emailAddress=ips@mail.ips.es', '00', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', '31256e345d570eaf8814c18b2f7c4b50');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ES, O=IPS Internet publishing Services s.l., CN=IPS CA CLASE1 Certification Authority', 3, 1, 0, '2001-12-29 00:59:38', '2025-12-27 00:59:38', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ES, ST=Barcelona, L=Barcelona, O=IPS Internet publishing Services s.l., O=ips@mail.ips.es C.I.F.  B-60929452, OU=IPS CA CLASE1 Certification Authority, CN=IPS CA CLASE1 Certification Authority/emailAddress=ips@mail.ips.es
        Validity
            Not Before: Dec 29 00:59:38 2001 GMT
            Not After : Dec 27 00:59:38 2025 GMT
        Subject: C=ES, ST=Barcelona, L=Barcelona, O=IPS Internet publishing Services s.l., O=ips@mail.ips.es C.I.F.  B-60929452, OU=IPS CA CLASE1 Certification Authority, CN=IPS CA CLASE1 Certification Authority/emailAddress=ips@mail.ips.es
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:e0:51:27:a7:0b:dd:af:d1:b9:43:5b:82:37:45:
                    56:72:ef:9a:b6:c2:12:ef:2c:12:cc:76:f9:06:59:
                    af:5d:21:d4:d2:5a:b8:a0:d4:f3:6a:fd:ca:69:8d:
                    66:48:f7:74:e6:ee:36:bd:e8:96:91:75:a6:71:28:
                    ca:e7:22:12:32:69:b0:3e:1e:6b:f4:50:52:62:62:
                    fd:63:3b:7d:7e:ec:ee:38:ea:62:f4:6c:a8:71:8d:
                    e1:e9:8b:c9:3f:c6:b5:cd:94:42:6f:dd:82:45:3c:
                    e8:df:09:e8:ef:0a:55:a9:56:47:61:4c:49:64:73:
                    10:28:3f:ca:bf:09:ff:c6:2f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                EB:B3:19:79:F3:C1:A5:1C:AC:DC:BA:1F:66:A2:B2:9B:69:D0:78:08
            X509v3 Authority Key Identifier: 
                keyid:EB:B3:19:79:F3:C1:A5:1C:AC:DC:BA:1F:66:A2:B2:9B:69:D0:78:08
                DirName:/C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA CLASE1 Certification Authority/CN=IPS CA CLASE1 Certification Authority/emailAddress=ips@mail.ips.es
                serial:00

            X509v3 Basic Constraints: 
                CA:TRUE
            X509v3 Key Usage: 
                Digital Signature, Non Repudiation, Key Encipherment, Data Encipherment, Key Agreement, Certificate Sign, CRL Sign, Encipher Only, Decipher Only
            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication, Code Signing, E-mail Protection, Time Stamping, Microsoft Individual Code Signing, Microsoft Commercial Code Signing, Microsoft Trust List Signing, Microsoft Encrypted File System
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 Subject Alternative Name: 
                email:ips@mail.ips.es
            X509v3 Issuer Alternative Name: 
                email:ips@mail.ips.es
            Netscape Comment: 
                CLASE1 CA Certificate issued by http://www.ips.es/
            Netscape Base Url: 
                http://www.ips.es/ips2002/
            Netscape CA Revocation Url: 
                http://www.ips.es/ips2002/ips2002CLASE1.crl
            Netscape Revocation Url: 
                http://www.ips.es/ips2002/revocationCLASE1.html?
            Netscape Renewal Url: 
                http://www.ips.es/ips2002/renewalCLASE1.html?
            Netscape CA Policy Url: 
                http://www.ips.es/ips2002/policyCLASE1.html
            X509v3 CRL Distribution Points: 
                URI:http://www.ips.es/ips2002/ips2002CLASE1.crl
                URI:http://wwwback.ips.es/ips2002/ips2002CLASE1.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp.ips.es/

    Signature Algorithm: sha1WithRSAEncryption
        2b:d0:eb:fd:da:c8:ca:59:6a:da:d3:cc:32:2e:c9:54:1b:8a:
        62:7e:15:2d:e9:d9:31:d3:2e:f4:27:23:ff:5b:ab:c5:4a:b6:
        72:40:ae:53:74:f4:bc:05:b4:c6:d9:c8:c9:77:fb:b7:f9:34:
        7f:78:00:f8:d6:a4:e4:52:3f:2c:4a:63:57:81:75:5a:8e:e8:
        8c:fb:02:c0:94:c6:29:ba:b3:dc:1c:e8:b2:af:d2:2e:62:5b:
        1a:a9:8e:0e:cc:c5:57:45:51:14:e9:4e:1c:88:a5:91:f4:a3:
        f7:8e:51:c8:a9:be:86:33:3e:e6:2f:48:6e:af:54:90:4e:ad:
        b1:25', 'E05127A70BDDAFD1B9435B8237455672EF9AB6C212EF2C12CC76F90659AF5D21D4D25AB8A0D4F36AFDCA698D6648F774E6EE36BDE8969175A67128CAE722123269B03E1E6BF450526262FD633B7D7EECEE38EA62F46CA8718DE1E98BC93FC6B5CD94426FDD82453CE8DF09E8EF0A55A95647614C49647310283FCABF09FFC62F', '/C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA CLASE1 Certification Authority/CN=IPS CA CLASE1 Certification Authority/emailAddress=ips@mail.ips.es', 'C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA CLASE1 Certification Authority/CN=IPS CA CLASE1 Certification Authority/emailAddress=ips@mail.ips.es', '00', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', 'e9e1176307eff45ae958721009d50415');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ES, O=IPS Internet publishing Services s.l., CN=IPS CA CLASE3 Certification Authority', 3, 1, 0, '2001-12-29 01:01:44', '2025-12-27 01:01:44', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ES, ST=Barcelona, L=Barcelona, O=IPS Internet publishing Services s.l., O=ips@mail.ips.es C.I.F.  B-60929452, OU=IPS CA CLASE3 Certification Authority, CN=IPS CA CLASE3 Certification Authority/emailAddress=ips@mail.ips.es
        Validity
            Not Before: Dec 29 01:01:44 2001 GMT
            Not After : Dec 27 01:01:44 2025 GMT
        Subject: C=ES, ST=Barcelona, L=Barcelona, O=IPS Internet publishing Services s.l., O=ips@mail.ips.es C.I.F.  B-60929452, OU=IPS CA CLASE3 Certification Authority, CN=IPS CA CLASE3 Certification Authority/emailAddress=ips@mail.ips.es
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ab:17:fe:0e:b0:c6:68:1b:53:f0:52:be:9f:fa:
                    da:fa:8b:13:04:bb:01:8f:32:d9:1f:8f:4d:ce:36:
                    98:da:e4:00:44:8c:28:d8:13:44:2a:a4:6b:4e:17:
                    24:42:9c:d3:88:a4:41:82:d6:23:fb:8b:c9:86:e5:
                    b9:a9:82:05:dc:f1:de:1f:e0:0c:99:55:98:f2:38:
                    ec:6c:9d:20:03:c0:ef:aa:a3:c6:64:04:51:2d:78:
                    0d:a3:d2:a8:3a:d6:24:4c:e9:96:7a:18:ac:13:23:
                    22:1b:7c:e8:31:11:b3:5f:09:aa:30:70:71:46:25:
                    6b:49:71:80:2b:95:01:b2:1f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                B8:93:FF:2E:CB:DC:2C:8E:A2:E7:7A:FE:36:51:21:A3:98:5B:0C:34
            X509v3 Authority Key Identifier: 
                keyid:B8:93:FF:2E:CB:DC:2C:8E:A2:E7:7A:FE:36:51:21:A3:98:5B:0C:34
                DirName:/C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA CLASE3 Certification Authority/CN=IPS CA CLASE3 Certification Authority/emailAddress=ips@mail.ips.es
                serial:00

            X509v3 Basic Constraints: 
                CA:TRUE
            X509v3 Key Usage: 
                Digital Signature, Non Repudiation, Key Encipherment, Data Encipherment, Key Agreement, Certificate Sign, CRL Sign, Encipher Only, Decipher Only
            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication, Code Signing, E-mail Protection, Time Stamping, Microsoft Individual Code Signing, Microsoft Commercial Code Signing, Microsoft Trust List Signing, Microsoft Encrypted File System
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 Subject Alternative Name: 
                email:ips@mail.ips.es
            X509v3 Issuer Alternative Name: 
                email:ips@mail.ips.es
            Netscape Comment: 
                CLASE3 CA Certificate issued by http://www.ips.es/
            Netscape Base Url: 
                http://www.ips.es/ips2002/
            Netscape CA Revocation Url: 
                http://www.ips.es/ips2002/ips2002CLASE3.crl
            Netscape Revocation Url: 
                http://www.ips.es/ips2002/revocationCLASE3.html?
            Netscape Renewal Url: 
                http://www.ips.es/ips2002/renewalCLASE3.html?
            Netscape CA Policy Url: 
                http://www.ips.es/ips2002/policyCLASE3.html
            X509v3 CRL Distribution Points: 
                URI:http://www.ips.es/ips2002/ips2002CLASE3.crl
                URI:http://wwwback.ips.es/ips2002/ips2002CLASE3.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp.ips.es/

    Signature Algorithm: sha1WithRSAEncryption
        17:65:5c:99:95:43:03:27:af:26:e5:eb:d0:b3:17:23:f7:43:
        aa:c7:f0:7d:ec:0f:c6:a9:ae:ae:96:0f:76:29:1c:e2:06:2d:
        7e:26:c5:3c:fa:a1:c1:81:ce:53:b0:42:d1:97:57:1a:17:7e:
        a4:51:61:c6:ee:e9:5e:ef:05:ba:eb:bd:0f:a7:92:6f:d8:a3:
        06:68:29:8e:79:f5:ff:bf:f9:a7:af:e4:b1:ce:c2:d1:80:42:
        27:05:04:34:f8:c3:7f:16:78:23:0c:07:24:f2:46:47:ad:3b:
        54:d0:af:d5:31:b2:af:7d:c8:ea:e9:d4:56:d9:0e:13:b2:c5:
        45:50', 'AB17FE0EB0C6681B53F052BE9FFADAFA8B1304BB018F32D91F8F4DCE3698DAE400448C28D813442AA46B4E1724429CD388A44182D623FB8BC986E5B9A98205DCF1DE1FE00C995598F238EC6C9D2003C0EFAAA3C66404512D780DA3D2A83AD6244CE9967A18AC1323221B7CE83111B35F09AA30707146256B4971802B9501B21F', '/C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA CLASE3 Certification Authority/CN=IPS CA CLASE3 Certification Authority/emailAddress=ips@mail.ips.es', 'C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA CLASE3 Certification Authority/CN=IPS CA CLASE3 Certification Authority/emailAddress=ips@mail.ips.es', '00', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', 'e3b09acfcd3a80662327e49910c719f3');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ES, O=IPS Internet publishing Services s.l., CN=IPS CA CLASEA1 Certification Authority', 3, 1, 0, '2001-12-29 01:05:32', '2025-12-27 01:05:32', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ES, ST=Barcelona, L=Barcelona, O=IPS Internet publishing Services s.l., O=ips@mail.ips.es C.I.F.  B-60929452, OU=IPS CA CLASEA1 Certification Authority, CN=IPS CA CLASEA1 Certification Authority/emailAddress=ips@mail.ips.es
        Validity
            Not Before: Dec 29 01:05:32 2001 GMT
            Not After : Dec 27 01:05:32 2025 GMT
        Subject: C=ES, ST=Barcelona, L=Barcelona, O=IPS Internet publishing Services s.l., O=ips@mail.ips.es C.I.F.  B-60929452, OU=IPS CA CLASEA1 Certification Authority, CN=IPS CA CLASEA1 Certification Authority/emailAddress=ips@mail.ips.es
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:bb:30:d7:dc:d0:54:bd:35:4e:9f:c5:4c:82:ea:
                    d1:50:3c:47:98:fc:9b:69:9d:77:cd:6e:e0:3f:ee:
                    eb:32:5f:5f:9f:d2:d0:79:e5:95:73:44:21:32:e0:
                    0a:db:9d:d7:ce:8d:ab:52:8b:2b:78:e0:9b:5b:7d:
                    f4:fd:6d:09:e5:ae:e1:6c:1d:07:23:a0:17:d1:f9:
                    7d:a8:46:46:91:22:a8:b2:69:c6:ad:f7:f5:f5:94:
                    a1:30:94:bd:00:cc:44:7f:ee:c4:9e:c9:c1:e6:8f:
                    0a:36:c1:fd:24:3d:01:a0:f5:7b:e2:7c:78:66:43:
                    8b:4f:59:f2:9b:d9:fa:49:b3
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                67:26:96:E7:A1:BF:D8:B5:03:9D:FE:3B:DC:FE:F2:8A:E6:15:DD:30
            X509v3 Authority Key Identifier: 
                keyid:67:26:96:E7:A1:BF:D8:B5:03:9D:FE:3B:DC:FE:F2:8A:E6:15:DD:30
                DirName:/C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA CLASEA1 Certification Authority/CN=IPS CA CLASEA1 Certification Authority/emailAddress=ips@mail.ips.es
                serial:00

            X509v3 Basic Constraints: 
                CA:TRUE
            X509v3 Key Usage: 
                Digital Signature, Non Repudiation, Key Encipherment, Data Encipherment, Key Agreement, Certificate Sign, CRL Sign, Encipher Only, Decipher Only
            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication, Code Signing, E-mail Protection, Time Stamping, Microsoft Individual Code Signing, Microsoft Commercial Code Signing, Microsoft Trust List Signing, Microsoft Encrypted File System
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 Subject Alternative Name: 
                email:ips@mail.ips.es
            X509v3 Issuer Alternative Name: 
                email:ips@mail.ips.es
            Netscape Comment: 
                CLASEA1 CA Certificate issued by http://www.ips.es/
            Netscape Base Url: 
                http://www.ips.es/ips2002/
            Netscape CA Revocation Url: 
                http://www.ips.es/ips2002/ips2002CLASEA1.crl
            Netscape Revocation Url: 
                http://www.ips.es/ips2002/revocationCLASEA1.html?
            Netscape Renewal Url: 
                http://www.ips.es/ips2002/renewalCLASEA1.html?
            Netscape CA Policy Url: 
                http://www.ips.es/ips2002/policyCLASEA1.html
            X509v3 CRL Distribution Points: 
                URI:http://www.ips.es/ips2002/ips2002CLASEA1.crl
                URI:http://wwwback.ips.es/ips2002/ips2002CLASEA1.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp.ips.es/

    Signature Algorithm: sha1WithRSAEncryption
        7e:ba:8a:ac:80:00:84:15:0a:d5:98:51:0c:64:c5:9c:02:58:
        83:66:ca:ad:1e:07:cd:7e:6a:da:80:07:df:03:34:4a:1c:93:
        c4:4b:58:20:35:36:71:ed:a2:0a:35:12:a5:a6:65:a7:85:69:
        0a:0e:e3:61:ee:ea:be:28:93:33:d5:ec:e8:be:c4:db:5f:7f:
        a8:f9:63:31:c8:6b:96:e2:29:c2:5b:a0:e7:97:36:9d:77:5e:
        31:6b:fe:d3:a7:db:2a:db:db:96:8b:1f:66:de:b6:03:c0:2b:
        b3:78:d6:55:07:e5:8f:39:50:de:07:23:72:e6:bd:20:14:4b:
        b4:86', 'BB30D7DCD054BD354E9FC54C82EAD1503C4798FC9B699D77CD6EE03FEEEB325F5F9FD2D079E59573442132E00ADB9DD7CE8DAB528B2B78E09B5B7DF4FD6D09E5AEE16C1D0723A017D1F97DA846469122A8B269C6ADF7F5F594A13094BD00CC447FEEC49EC9C1E68F0A36C1FD243D01A0F57BE27C7866438B4F59F29BD9FA49B3', '/C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA CLASEA1 Certification Authority/CN=IPS CA CLASEA1 Certification Authority/emailAddress=ips@mail.ips.es', 'C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA CLASEA1 Certification Authority/CN=IPS CA CLASEA1 Certification Authority/emailAddress=ips@mail.ips.es', '00', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', 'd127615c5afa1fa51ce011777502b01c');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ES, O=IPS Internet publishing Services s.l., CN=IPS CA CLASEA3 Certification Authority', 3, 1, 0, '2001-12-29 01:07:50', '2025-12-27 01:07:50', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ES, ST=Barcelona, L=Barcelona, O=IPS Internet publishing Services s.l., O=ips@mail.ips.es C.I.F.  B-60929452, OU=IPS CA CLASEA3 Certification Authority, CN=IPS CA CLASEA3 Certification Authority/emailAddress=ips@mail.ips.es
        Validity
            Not Before: Dec 29 01:07:50 2001 GMT
            Not After : Dec 27 01:07:50 2025 GMT
        Subject: C=ES, ST=Barcelona, L=Barcelona, O=IPS Internet publishing Services s.l., O=ips@mail.ips.es C.I.F.  B-60929452, OU=IPS CA CLASEA3 Certification Authority, CN=IPS CA CLASEA3 Certification Authority/emailAddress=ips@mail.ips.es
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ee:80:00:f6:1a:64:2e:ad:6a:c8:83:b1:8b:a7:
                    ee:8f:d9:b6:db:cd:1b:bb:86:06:22:76:33:0c:12:
                    6d:48:56:61:d2:dc:82:25:62:2f:9f:d2:69:30:65:
                    03:42:23:58:bc:47:dc:6b:d6:75:5d:17:3c:e1:ff:
                    f2:58:67:79:a0:c1:81:b1:d4:56:a2:f2:8d:11:99:
                    fd:f6:7d:f1:c7:c4:5e:02:2a:9a:e2:4a:b5:13:8a:
                    00:fd:8c:77:86:e6:d7:94:f5:20:75:2e:0e:4c:bf:
                    74:c4:3f:81:3e:83:b4:a3:38:36:29:e7:e8:2a:f5:
                    8c:88:41:aa:80:a6:e3:6c:ef
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                1E:9F:57:50:47:B6:61:93:39:D3:2C:FC:DA:5D:3D:05:75:B7:99:02
            X509v3 Authority Key Identifier: 
                keyid:1E:9F:57:50:47:B6:61:93:39:D3:2C:FC:DA:5D:3D:05:75:B7:99:02
                DirName:/C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA CLASEA3 Certification Authority/CN=IPS CA CLASEA3 Certification Authority/emailAddress=ips@mail.ips.es
                serial:00

            X509v3 Basic Constraints: 
                CA:TRUE
            X509v3 Key Usage: 
                Digital Signature, Non Repudiation, Key Encipherment, Data Encipherment, Key Agreement, Certificate Sign, CRL Sign, Encipher Only, Decipher Only
            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication, Code Signing, E-mail Protection, Time Stamping, Microsoft Individual Code Signing, Microsoft Commercial Code Signing, Microsoft Trust List Signing, Microsoft Encrypted File System
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 Subject Alternative Name: 
                email:ips@mail.ips.es
            X509v3 Issuer Alternative Name: 
                email:ips@mail.ips.es
            Netscape Comment: 
                CLASEA3 CA Certificate issued by http://www.ips.es/
            Netscape Base Url: 
                http://www.ips.es/ips2002/
            Netscape CA Revocation Url: 
                http://www.ips.es/ips2002/ips2002CLASEA3.crl
            Netscape Revocation Url: 
                http://www.ips.es/ips2002/revocationCLASEA3.html?
            Netscape Renewal Url: 
                http://www.ips.es/ips2002/renewalCLASEA3.html?
            Netscape CA Policy Url: 
                http://www.ips.es/ips2002/policyCLASEA3.html
            X509v3 CRL Distribution Points: 
                URI:http://www.ips.es/ips2002/ips2002CLASEA3.crl
                URI:http://wwwback.ips.es/ips2002/ips2002CLASEA3.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp.ips.es/

    Signature Algorithm: sha1WithRSAEncryption
        4a:3d:20:47:1a:da:89:f4:7a:2b:31:79:ec:01:c0:cc:01:f5:
        d6:c1:fc:c8:c3:f3:50:02:51:90:58:2a:9f:e7:35:09:5b:30:
        0a:81:00:25:47:af:d4:0f:0e:9e:60:26:a8:95:a7:83:08:df:
        2d:ac:e9:0e:f7:9c:c8:9f:cb:93:45:f1:ba:6a:c6:67:51:4a:
        69:4f:6b:fe:7d:0b:2f:52:29:c2:50:ad:24:44:ed:23:b3:48:
        cb:44:40:c1:03:95:0c:0a:78:06:12:01:f5:91:31:2d:49:8d:
        bb:3f:45:4e:2c:e0:e8:cd:b5:c9:14:15:0c:e3:07:83:9b:26:
        75:ef', 'EE8000F61A642EAD6AC883B18BA7EE8FD9B6DBCD1BBB86062276330C126D485661D2DC8225622F9FD269306503422358BC47DC6BD6755D173CE1FFF2586779A0C181B1D456A2F28D1199FDF67DF1C7C45E022A9AE24AB5138A00FD8C7786E6D794F520752E0E4CBF74C43F813E83B4A3383629E7E82AF58C8841AA80A6E36CEF', '/C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA CLASEA3 Certification Authority/CN=IPS CA CLASEA3 Certification Authority/emailAddress=ips@mail.ips.es', 'C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA CLASEA3 Certification Authority/CN=IPS CA CLASEA3 Certification Authority/emailAddress=ips@mail.ips.es', '00', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', '97abbe684e5e2f527e3437ed17fe9da6');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ES, O=IPS Internet publishing Services s.l., CN=IPS CA Timestamping Certification Authority', 3, 1, 0, '2001-12-29 01:10:18', '2025-12-27 01:10:18', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ES, ST=Barcelona, L=Barcelona, O=IPS Internet publishing Services s.l., O=ips@mail.ips.es C.I.F.  B-60929452, OU=IPS CA Timestamping Certification Authority, CN=IPS CA Timestamping Certification Authority/emailAddress=ips@mail.ips.es
        Validity
            Not Before: Dec 29 01:10:18 2001 GMT
            Not After : Dec 27 01:10:18 2025 GMT
        Subject: C=ES, ST=Barcelona, L=Barcelona, O=IPS Internet publishing Services s.l., O=ips@mail.ips.es C.I.F.  B-60929452, OU=IPS CA Timestamping Certification Authority, CN=IPS CA Timestamping Certification Authority/emailAddress=ips@mail.ips.es
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:bc:b8:ee:56:a5:9a:8c:e6:36:c9:c2:62:a0:66:
                    81:8d:1a:d5:7a:d2:73:9f:0e:84:64:ba:95:b4:90:
                    a7:78:af:ca:fe:54:61:5b:ce:b2:20:57:01:ae:44:
                    92:43:10:38:11:f7:68:fc:17:40:a5:68:27:32:3b:
                    c4:a7:e6:42:71:c5:99:ef:76:ff:2b:95:24:f5:49:
                    92:18:68:ca:00:b5:a4:5a:2f:6e:cb:d6:1b:2c:0d:
                    54:67:6b:7a:29:a1:58:ab:a2:5a:00:d6:5b:bb:18:
                    c2:df:f6:1e:13:56:76:9b:a5:68:e2:98:ce:c6:03:
                    8a:34:db:4c:83:41:a6:a9:a3
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                8B:D0:10:50:09:81:F2:9D:09:D5:0E:60:78:03:22:A2:3F:C8:CA:66
            X509v3 Authority Key Identifier: 
                keyid:8B:D0:10:50:09:81:F2:9D:09:D5:0E:60:78:03:22:A2:3F:C8:CA:66
                DirName:/C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA Timestamping Certification Authority/CN=IPS CA Timestamping Certification Authority/emailAddress=ips@mail.ips.es
                serial:00

            X509v3 Basic Constraints: 
                CA:TRUE
            X509v3 Key Usage: 
                Digital Signature, Non Repudiation, Key Encipherment, Data Encipherment, Key Agreement, Certificate Sign, CRL Sign, Encipher Only, Decipher Only
            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication, Code Signing, E-mail Protection, Time Stamping, Microsoft Individual Code Signing, Microsoft Commercial Code Signing, Microsoft Trust List Signing, Microsoft Encrypted File System
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 Subject Alternative Name: 
                email:ips@mail.ips.es
            X509v3 Issuer Alternative Name: 
                email:ips@mail.ips.es
            Netscape Comment: 
                Timestamping CA Certificate issued by http://www.ips.es/
            Netscape Base Url: 
                http://www.ips.es/ips2002/
            Netscape CA Revocation Url: 
                http://www.ips.es/ips2002/ips2002Timestamping.crl
            Netscape Revocation Url: 
                http://www.ips.es/ips2002/revocationTimestamping.html?
            Netscape Renewal Url: 
                http://www.ips.es/ips2002/renewalTimestamping.html?
            Netscape CA Policy Url: 
                http://www.ips.es/ips2002/policyTimestamping.html
            X509v3 CRL Distribution Points: 
                URI:http://www.ips.es/ips2002/ips2002Timestamping.crl
                URI:http://wwwback.ips.es/ips2002/ips2002Timestamping.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp.ips.es/

    Signature Algorithm: sha1WithRSAEncryption
        65:ba:c1:cc:00:1a:95:91:ca:e9:6c:3a:bf:3a:1e:14:08:7c:
        fb:83:ee:6b:62:51:d3:33:91:b5:60:79:7e:04:d8:5d:79:37:
        e8:c3:5b:b0:c4:67:2d:68:5a:b2:5f:0e:0a:fa:cd:3f:3a:45:
        a1:ea:36:cf:26:1e:a7:11:28:c5:94:8f:84:4c:53:08:c5:93:
        b3:fc:e2:7f:f5:8d:f3:b1:a9:85:5f:88:de:91:96:ee:17:5b:
        ae:a5:ea:70:65:78:2c:21:64:01:95:ce:ce:4c:3e:50:f4:b6:
        59:cb:63:8d:b6:bd:18:d4:87:4a:5f:dc:ef:e9:56:f0:0a:0c:
        e8:75', 'BCB8EE56A59A8CE636C9C262A066818D1AD57AD2739F0E8464BA95B490A778AFCAFE54615BCEB2205701AE449243103811F768FC1740A56827323BC4A7E64271C599EF76FF2B9524F549921868CA00B5A45A2F6ECBD61B2C0D54676B7A29A158ABA25A00D65BBB18C2DFF61E1356769BA568E298CEC6038A34DB4C8341A6A9A3', '/C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA Timestamping Certification Authority/CN=IPS CA Timestamping Certification Authority/emailAddress=ips@mail.ips.es', 'C=ES/ST=Barcelona/L=Barcelona/O=IPS Internet publishing Services s.l./O=ips@mail.ips.es C.I.F.  B-60929452/OU=IPS CA Timestamping Certification Authority/CN=IPS CA Timestamping Certification Authority/emailAddress=ips@mail.ips.es', '00', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', '6f351ddaaa89122264e8d353da67dbcb');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=EU, O=AC Camerfirma SA CIF A82743287, CN=Chambers of Commerce Root', 3, 1, 0, '2003-09-30 16:13:43', '2037-09-30 16:13:44', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=EU, O=AC Camerfirma SA CIF A82743287, OU=http://www.chambersign.org, CN=Chambers of Commerce Root
        Validity
            Not Before: Sep 30 16:13:43 2003 GMT
            Not After : Sep 30 16:13:44 2037 GMT
        Subject: C=EU, O=AC Camerfirma SA CIF A82743287, OU=http://www.chambersign.org, CN=Chambers of Commerce Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b7:36:55:e5:a5:5d:18:30:e0:da:89:54:91:fc:
                    c8:c7:52:f8:2f:50:d9:ef:b1:75:73:65:47:7d:1b:
                    5b:ba:75:c5:fc:a1:88:24:fa:2f:ed:ca:08:4a:39:
                    54:c4:51:7a:b5:da:60:ea:38:3c:81:b2:cb:f1:bb:
                    d9:91:23:3f:48:01:70:75:a9:05:2a:ad:1f:71:f3:
                    c9:54:3d:1d:06:6a:40:3e:b3:0c:85:ee:5c:1b:79:
                    c2:62:c4:b8:36:8e:35:5d:01:0c:23:04:47:35:aa:
                    9b:60:4e:a0:66:3d:cb:26:0a:9c:40:a1:f4:5d:98:
                    bf:71:ab:a5:00:68:2a:ed:83:7a:0f:a2:14:b5:d4:
                    22:b3:80:b0:3c:0c:5a:51:69:2d:58:18:8f:ed:99:
                    9e:f1:ae:e2:95:e6:f6:47:a8:d6:0c:0f:b0:58:58:
                    db:c3:66:37:9e:9b:91:54:33:37:d2:94:1c:6a:48:
                    c9:c9:f2:a5:da:a5:0c:23:f7:23:0e:9c:32:55:5e:
                    71:9c:84:05:51:9a:2d:fd:e6:4e:2a:34:5a:de:ca:
                    40:37:67:0c:54:21:55:77:da:0a:0c:cc:97:ae:80:
                    dc:94:36:4a:f4:3e:ce:36:13:1e:53:e4:ac:4e:3a:
                    05:ec:db:ae:72:9c:38:8b:d0:39:3b:89:0a:3e:77:
                    fe:75
                Exponent: 3 (0x3)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:12
            X509v3 CRL Distribution Points: 
                URI:http://crl.chambersign.org/chambersroot.crl

            X509v3 Subject Key Identifier: 
                E3:94:F5:B1:4D:E9:DB:A1:29:5B:57:8B:4D:76:06:76:E1:D1:A2:8A
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 Subject Alternative Name: 
                email:chambersroot@chambersign.org
            X509v3 Issuer Alternative Name: 
                email:chambersroot@chambersign.org
            X509v3 Certificate Policies: 
                Policy: 1.3.6.1.4.1.17326.10.3.1
                  CPS: http://cps.chambersign.org/cps/chambersroot.html

    Signature Algorithm: sha1WithRSAEncryption
        0c:41:97:c2:1a:86:c0:22:7c:9f:fb:90:f3:1a:d1:03:b1:ef:
        13:f9:21:5f:04:9c:da:c9:a5:8d:27:6c:96:87:91:be:41:90:
        01:72:93:e7:1e:7d:5f:f6:89:c6:5d:a7:40:09:3d:ac:49:45:
        45:dc:2e:8d:30:68:b2:09:ba:fb:c3:2f:cc:ba:0b:df:3f:77:
        7b:46:7d:3a:12:24:8e:96:8f:3c:05:0a:6f:d2:94:28:1d:6d:
        0c:c0:2e:88:22:d5:d8:cf:1d:13:c7:f0:48:d7:d7:05:a7:cf:
        c7:47:9e:3b:3c:34:c8:80:4f:d4:14:bb:fc:0d:50:f7:fa:b3:
        ec:42:5f:a9:dd:6d:c8:f4:75:cf:7b:c1:72:26:b1:01:1c:5c:
        2c:fd:7a:4e:b4:01:c5:05:57:b9:e7:3c:aa:05:d9:88:e9:07:
        46:41:ce:ef:41:81:ae:58:df:83:a2:ae:ca:d7:77:1f:e7:00:
        3c:9d:6f:8e:e4:32:09:1d:4d:78:34:78:34:3c:94:9b:26:ed:
        4f:71:c6:19:7a:bd:20:22:48:5a:fe:4b:7d:03:b7:e7:58:be:
        c6:32:4e:74:1e:68:dd:a8:68:5b:b3:3e:ee:62:7d:d9:80:e8:
        0a:75:7a:b7:ee:b4:65:9a:21:90:e0:aa:d0:98:bc:38:b5:73:
        3c:8b:f8:dc', 'B73655E5A55D1830E0DA895491FCC8C752F82F50D9EFB1757365477D1B5BBA75C5FCA18824FA2FEDCA084A3954C4517AB5DA60EA383C81B2CBF1BBD991233F48017075A9052AAD1F71F3C9543D1D066A403EB30C85EE5C1B79C262C4B8368E355D010C23044735AA9B604EA0663DCB260A9C40A1F45D98BF71ABA500682AED837A0FA214B5D422B380B03C0C5A51692D58188FED999EF1AEE295E6F647A8D60C0FB05858DBC366379E9B91543337D2941C6A48C9C9F2A5DAA50C23F7230E9C32555E719C8405519A2DFDE64E2A345ADECA4037670C54215577DA0A0CCC97AE80DC94364AF43ECE36131E53E4AC4E3A05ECDBAE729C388BD0393B890A3E77FE75', '/C=EU/O=AC Camerfirma SA CIF A82743287/OU=http://www.chambersign.org/CN=Chambers of Commerce Root', 'C=EU/O=AC Camerfirma SA CIF A82743287/OU=http://www.chambersign.org/CN=Chambers of Commerce Root', '00', NULL, '-----BEGIN CERTIFICATE-----
MIIEvTCCA6WgAwIBAgIBADANBgkqhkiG9w0BAQUFADB/MQswCQYDVQQGEwJFVTEn
MCUGA1UEChMeQUMgQ2FtZXJmaXJtYSBTQSBDSUYgQTgyNzQzMjg3MSMwIQYDVQQL
ExpodHRwOi8vd3d3LmNoYW1iZXJzaWduLm9yZzEiMCAGA1UEAxMZQ2hhbWJlcnMg
b2YgQ29tbWVyY2UgUm9vdDAeFw0wMzA5MzAxNjEzNDNaFw0zNzA5MzAxNjEzNDRa
MH8xCzAJBgNVBAYTAkVVMScwJQYDVQQKEx5BQyBDYW1lcmZpcm1hIFNBIENJRiBB
ODI3NDMyODcxIzAhBgNVBAsTGmh0dHA6Ly93d3cuY2hhbWJlcnNpZ24ub3JnMSIw
IAYDVQQDExlDaGFtYmVycyBvZiBDb21tZXJjZSBSb290MIIBIDANBgkqhkiG9w0B
AQEFAAOCAQ0AMIIBCAKCAQEAtzZV5aVdGDDg2olUkfzIx1L4L1DZ77F1c2VHfRtb
unXF/KGIJPov7coISjlUxFF6tdpg6jg8gbLL8bvZkSM/SAFwdakFKq0fcfPJVD0d
BmpAPrMMhe5cG3nCYsS4No41XQEMIwRHNaqbYE6gZj3LJgqcQKH0XZi/caulAGgq
7YN6D6IUtdQis4CwPAxaUWktWBiP7Zme8a7ileb2R6jWDA+wWFjbw2Y3npuRVDM3
0pQcakjJyfKl2qUMI/cjDpwyVV5xnIQFUZot/eZOKjRa3spAN2cMVCFVd9oKDMyX
roDclDZK9D7ONhMeU+SsTjoF7Nuucpw4i9A5O4kKPnf+dQIBA6OCAUQwggFAMBIG
A1UdEwEB/wQIMAYBAf8CAQwwPAYDVR0fBDUwMzAxoC+gLYYraHR0cDovL2NybC5j
aGFtYmVyc2lnbi5vcmcvY2hhbWJlcnNyb290LmNybDAdBgNVHQ4EFgQU45T1sU3p
26EpW1eLTXYGduHRooowDgYDVR0PAQH/BAQDAgEGMBEGCWCGSAGG+EIBAQQEAwIA
BzAnBgNVHREEIDAegRxjaGFtYmVyc3Jvb3RAY2hhbWJlcnNpZ24ub3JnMCcGA1Ud
EgQgMB6BHGNoYW1iZXJzcm9vdEBjaGFtYmVyc2lnbi5vcmcwWAYDVR0gBFEwTzBN
BgsrBgEEAYGHLgoDATA+MDwGCCsGAQUFBwIBFjBodHRwOi8vY3BzLmNoYW1iZXJz
aWduLm9yZy9jcHMvY2hhbWJlcnNyb290Lmh0bWwwDQYJKoZIhvcNAQEFBQADggEB
AAxBl8IahsAifJ/7kPMa0QOx7xP5IV8EnNrJpY0nbJaHkb5BkAFyk+cefV/2icZd
p0AJPaxJRUXcLo0waLIJuvvDL8y6C98/d3tGfToSJI6WjzwFCm/SlCgdbQzALogi
1djPHRPH8EjX1wWnz8dHnjs8NMiAT9QUu/wNUPf6s+xCX6ndbcj0dc97wXImsQEc
XCz9ek60AcUFV7nnPKoF2YjpB0ZBzu9Bga5Y34OirsrXdx/nADydb47kMgkdTXg0
eDQ8lJsm7U9xxhl6vSAiSFr+S30Dt+dYvsYyTnQeaN2oaFuzPu5ifdmA6Ap1erfu
tGWaIZDgqtCYvDi1czyL+Nw=
-----END CERTIFICATE-----', '039e118a272b1fad6586f74fa96c289d');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=EU, O=AC Camerfirma SA CIF A82743287, CN=Global Chambersign Root', 3, 1, 0, '2003-09-30 16:14:18', '2037-09-30 16:14:18', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=EU, O=AC Camerfirma SA CIF A82743287, OU=http://www.chambersign.org, CN=Global Chambersign Root
        Validity
            Not Before: Sep 30 16:14:18 2003 GMT
            Not After : Sep 30 16:14:18 2037 GMT
        Subject: C=EU, O=AC Camerfirma SA CIF A82743287, OU=http://www.chambersign.org, CN=Global Chambersign Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:a2:70:a2:d0:9f:42:ae:5b:17:c7:d8:7d:cf:14:
                    83:fc:4f:c9:a1:b7:13:af:8a:d7:9e:3e:04:0a:92:
                    8b:60:56:fa:b4:32:2f:88:4d:a1:60:08:f4:b7:09:
                    4e:a0:49:2f:49:d6:d3:df:9d:97:5a:9f:94:04:70:
                    ec:3f:59:d9:b7:cc:66:8b:98:52:28:09:02:df:c5:
                    2f:84:8d:7a:97:77:bf:ec:40:9d:25:72:ab:b5:3f:
                    32:98:fb:b7:b7:fc:72:84:e5:35:87:f9:55:fa:a3:
                    1f:0e:6f:2e:28:dd:69:a0:d9:42:10:c6:f8:b5:44:
                    c2:d0:43:7f:db:bc:e4:a2:3c:6a:55:78:0a:77:a9:
                    d8:ea:19:32:b7:2f:fe:5c:3f:1b:ee:b1:98:ec:ca:
                    ad:7a:69:45:e3:96:0f:55:f6:e6:ed:75:ea:65:e8:
                    32:56:93:46:89:a8:25:8a:65:06:ee:6b:bf:79:07:
                    d0:f1:b7:af:ed:2c:4d:92:bb:c0:a8:5f:a7:67:7d:
                    04:f2:15:08:70:ac:92:d6:7d:04:d2:33:fb:4c:b6:
                    0b:0b:fb:1a:c9:c4:8d:03:a9:7e:5c:f2:50:ab:12:
                    a5:a1:cf:48:50:a5:ef:d2:c8:1a:13:fa:b0:7f:b1:
                    82:1c:77:6a:0f:5f:dc:0b:95:8f:ef:43:7e:e6:45:
                    09:25
                Exponent: 3 (0x3)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:12
            X509v3 CRL Distribution Points: 
                URI:http://crl.chambersign.org/chambersignroot.crl

            X509v3 Subject Key Identifier: 
                43:9C:36:9F:B0:9E:30:4D:C6:CE:5F:AD:10:AB:E5:03:A5:FA:A9:14
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 Subject Alternative Name: 
                email:chambersignroot@chambersign.org
            X509v3 Issuer Alternative Name: 
                email:chambersignroot@chambersign.org
            X509v3 Certificate Policies: 
                Policy: 1.3.6.1.4.1.17326.10.1.1
                  CPS: http://cps.chambersign.org/cps/chambersignroot.html

    Signature Algorithm: sha1WithRSAEncryption
        3c:3b:70:91:f9:04:54:27:91:e1:ed:ed:fe:68:7f:61:5d:e5:
        41:65:4f:32:f1:18:05:94:6a:1c:de:1f:70:db:3e:7b:32:02:
        34:b5:0c:6c:a1:8a:7c:a5:f4:8f:ff:d4:d8:ad:17:d5:2d:04:
        d1:3f:58:80:e2:81:59:88:be:c0:e3:46:93:24:fe:90:bd:26:
        a2:30:2d:e8:97:26:57:35:89:74:96:18:f6:15:e2:af:24:19:
        56:02:02:b2:ba:0f:14:ea:c6:8a:66:c1:86:45:55:8b:be:92:
        be:9c:a4:04:c7:49:3c:9e:e8:29:7a:89:d7:fe:af:ff:68:f5:
        a5:17:90:bd:ac:99:cc:a5:86:57:09:67:46:db:d6:16:c2:46:
        f1:e4:a9:50:f5:8f:d1:92:15:d3:5f:3e:c6:00:49:3a:6e:58:
        b2:d1:d1:27:0d:25:c8:32:f8:20:11:cd:7d:32:33:48:94:54:
        4c:dd:dc:79:c4:30:9f:eb:8e:b8:55:b5:d7:88:5c:c5:6a:24:
        3d:b2:d3:05:03:51:c6:07:ef:cc:14:72:74:3d:6e:72:ce:18:
        28:8c:4a:a0:77:e5:09:2b:45:44:47:ac:b7:67:7f:01:8a:05:
        5a:93:be:a1:c1:ff:f8:e7:0e:67:a4:47:49:76:5d:75:90:1a:
        f5:26:8f:f0', 'A270A2D09F42AE5B17C7D87DCF1483FC4FC9A1B713AF8AD79E3E040A928B6056FAB4322F884DA16008F4B7094EA0492F49D6D3DF9D975A9F940470EC3F59D9B7CC668B9852280902DFC52F848D7A9777BFEC409D2572ABB53F3298FBB7B7FC7284E53587F955FAA31F0E6F2E28DD69A0D94210C6F8B544C2D0437FDBBCE4A23C6A55780A77A9D8EA1932B72FFE5C3F1BEEB198ECCAAD7A6945E3960F55F6E6ED75EA65E83256934689A8258A6506EE6BBF7907D0F1B7AFED2C4D92BBC0A85FA7677D04F2150870AC92D67D04D233FB4CB60B0BFB1AC9C48D03A97E5CF250AB12A5A1CF4850A5EFD2C81A13FAB07FB1821C776A0F5FDC0B958FEF437EE6450925', '/C=EU/O=AC Camerfirma SA CIF A82743287/OU=http://www.chambersign.org/CN=Global Chambersign Root', 'C=EU/O=AC Camerfirma SA CIF A82743287/OU=http://www.chambersign.org/CN=Global Chambersign Root', '00', NULL, '-----BEGIN CERTIFICATE-----
MIIExTCCA62gAwIBAgIBADANBgkqhkiG9w0BAQUFADB9MQswCQYDVQQGEwJFVTEn
MCUGA1UEChMeQUMgQ2FtZXJmaXJtYSBTQSBDSUYgQTgyNzQzMjg3MSMwIQYDVQQL
ExpodHRwOi8vd3d3LmNoYW1iZXJzaWduLm9yZzEgMB4GA1UEAxMXR2xvYmFsIENo
YW1iZXJzaWduIFJvb3QwHhcNMDMwOTMwMTYxNDE4WhcNMzcwOTMwMTYxNDE4WjB9
MQswCQYDVQQGEwJFVTEnMCUGA1UEChMeQUMgQ2FtZXJmaXJtYSBTQSBDSUYgQTgy
NzQzMjg3MSMwIQYDVQQLExpodHRwOi8vd3d3LmNoYW1iZXJzaWduLm9yZzEgMB4G
A1UEAxMXR2xvYmFsIENoYW1iZXJzaWduIFJvb3QwggEgMA0GCSqGSIb3DQEBAQUA
A4IBDQAwggEIAoIBAQCicKLQn0KuWxfH2H3PFIP8T8mhtxOviteePgQKkotgVvq0
Mi+ITaFgCPS3CU6gSS9J1tPfnZdan5QEcOw/Wdm3zGaLmFIoCQLfxS+EjXqXd7/s
QJ0lcqu1PzKY+7e3/HKE5TWH+VX6ox8Oby4o3Wmg2UIQxvi1RMLQQ3/bvOSiPGpV
eAp3qdjqGTK3L/5cPxvusZjsyq16aUXjlg9V9ubtdepl6DJWk0aJqCWKZQbua795
B9Dxt6/tLE2Su8CoX6dnfQTyFQhwrJLWfQTSM/tMtgsL+xrJxI0DqX5c8lCrEqWh
z0hQpe/SyBoT+rB/sYIcd2oPX9wLlY/vQ37mRQklAgEDo4IBUDCCAUwwEgYDVR0T
AQH/BAgwBgEB/wIBDDA/BgNVHR8EODA2MDSgMqAwhi5odHRwOi8vY3JsLmNoYW1i
ZXJzaWduLm9yZy9jaGFtYmVyc2lnbnJvb3QuY3JsMB0GA1UdDgQWBBRDnDafsJ4w
TcbOX60Qq+UDpfqpFDAOBgNVHQ8BAf8EBAMCAQYwEQYJYIZIAYb4QgEBBAQDAgAH
MCoGA1UdEQQjMCGBH2NoYW1iZXJzaWducm9vdEBjaGFtYmVyc2lnbi5vcmcwKgYD
VR0SBCMwIYEfY2hhbWJlcnNpZ25yb290QGNoYW1iZXJzaWduLm9yZzBbBgNVHSAE
VDBSMFAGCysGAQQBgYcuCgEBMEEwPwYIKwYBBQUHAgEWM2h0dHA6Ly9jcHMuY2hh
bWJlcnNpZ24ub3JnL2Nwcy9jaGFtYmVyc2lnbnJvb3QuaHRtbDANBgkqhkiG9w0B
AQUFAAOCAQEAPDtwkfkEVCeR4e3t/mh/YV3lQWVPMvEYBZRqHN4fcNs+ezICNLUM
bKGKfKX0j//U2K0X1S0E0T9YgOKBWYi+wONGkyT+kL0mojAt6JcmVzWJdJYY9hXi
ryQZVgICsroPFOrGimbBhkVVi76SvpykBMdJPJ7oKXqJ1/6v/2j1pReQvayZzKWG
VwlnRtvWFsJG8eSpUPWP0ZIV018+xgBJOm5YstHRJw0lyDL4IBHNfTIzSJRUTN3c
ecQwn+uOuFW114hcxWokPbLTBQNRxgfvzBRydD1ucs4YKIxKoHflCStFREest2d/
AYoFWpO+ocH/+OcOZ6RHSXZddZAa9SaP8A==
-----END CERTIFICATE-----', 'f130d662fbfeb1ddc4c35d2e0c67a357');
 
INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=FI, O=Sonera, CN=Sonera Class1 CA', 3, 1, 0, '2001-04-06 10:49:13', '2021-04-06 10:49:13', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 36 (0x24)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=FI, O=Sonera, CN=Sonera Class1 CA
        Validity
            Not Before: Apr  6 10:49:13 2001 GMT
            Not After : Apr  6 10:49:13 2021 GMT
        Subject: C=FI, O=Sonera, CN=Sonera Class1 CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b5:89:1f:2b:4f:67:0a:79:ff:c5:1e:f8:7f:3c:
                    ed:d1:7e:da:b0:cd:6d:2f:36:ac:34:c6:db:d9:64:
                    17:08:63:30:33:22:8a:4c:ee:8e:bb:0f:0d:42:55:
                    c9:9d:2e:a5:ef:f7:a7:8c:c3:ab:b9:97:cb:8e:ef:
                    3f:15:67:a8:82:72:63:53:0f:41:8c:7d:10:95:24:
                    a1:5a:a5:06:fa:92:57:9d:fa:a5:01:f2:75:e9:1f:
                    bc:56:26:52:4e:78:19:65:58:55:03:58:c0:14:ae:
                    8c:7c:55:5f:70:5b:77:23:06:36:97:f3:24:b5:9a:
                    46:95:e4:df:0d:0b:05:45:e5:d1:f2:1d:82:bb:c6:
                    13:e0:fe:aa:7a:fd:69:30:94:f3:d2:45:85:fc:f2:
                    32:5b:32:de:e8:6c:5d:1f:cb:a4:22:74:b0:80:8e:
                    5d:94:f7:06:00:4b:a9:d4:5e:2e:35:50:09:f3:80:
                    97:f4:0c:17:ae:39:d8:5f:cd:33:c1:1c:ca:89:c2:
                    22:f7:45:12:ed:5e:12:93:9d:63:ab:82:2e:b9:eb:
                    42:41:44:cb:4a:1a:00:82:0d:9e:f9:8b:57:3e:4c:
                    c7:17:ed:2c:8b:72:33:5f:72:7a:38:56:d5:e6:d9:
                    ae:05:1a:1d:75:45:b1:cb:a5:25:1c:12:57:36:fd:
                    22:37
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                47:E2:0C:8B:F6:53:88:52
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        8b:1a:b2:c9:5d:61:b4:e1:b9:2b:b9:53:d1:b2:85:9d:77:8e:
        16:ee:11:3d:db:c2:63:d9:5b:97:65:fb:12:67:d8:2a:5c:b6:
        ab:e5:5e:c3:b7:16:2f:c8:e8:ab:1d:8a:fd:ab:1a:7c:d5:5f:
        63:cf:dc:b0:dd:77:b9:a8:e6:d2:22:38:87:07:14:d9:ff:be:
        56:b5:fd:07:0e:3c:55:ca:16:cc:a7:a6:77:37:fb:db:5c:1f:
        4e:59:06:87:a3:03:43:f5:16:ab:b7:84:bd:4e:ef:9f:31:37:
        f0:46:f1:40:b6:d1:0c:a5:64:f8:63:5e:21:db:55:4e:4f:31:
        76:9c:10:61:8e:b6:53:3a:a3:11:be:af:6d:7c:1e:bd:ae:2d:
        e2:0c:69:c7:85:53:68:a2:61:ba:c5:3e:b4:79:54:78:9e:0a:
        c7:02:be:62:d1:11:82:4b:65:2f:91:5a:c2:a8:87:b1:56:68:
        94:79:f9:25:f7:c1:d5:ae:1a:b8:bb:3d:8f:a9:8a:38:15:f7:
        73:d0:5a:60:d1:80:b0:f0:dc:d5:50:cd:4e:ee:92:48:69:ed:
        b2:23:1e:30:cc:c8:94:c8:b6:f5:3b:86:7f:3f:a6:2e:9f:f6:
        3e:2c:b5:92:96:3e:df:2c:93:8a:ff:81:8c:0f:0f:59:21:19:
        57:bd:55:9a', 'B5891F2B4F670A79FFC51EF87F3CEDD17EDAB0CD6D2F36AC34C6DBD9641708633033228A4CEE8EBB0F0D4255C99D2EA5EFF7A78CC3ABB997CB8EEF3F1567A8827263530F418C7D109524A15AA506FA92579DFAA501F275E91FBC5626524E78196558550358C014AE8C7C555F705B7723063697F324B59A4695E4DF0D0B0545E5D1F21D82BBC613E0FEAA7AFD693094F3D24585FCF2325B32DEE86C5D1FCBA42274B0808E5D94F706004BA9D45E2E355009F38097F40C17AE39D85FCD33C11CCA89C222F74512ED5E12939D63AB822EB9EB424144CB4A1A00820D9EF98B573E4CC717ED2C8B72335F727A3856D5E6D9AE051A1D7545B1CBA5251C125736FD2237', '/C=FI/O=Sonera/CN=Sonera Class1 CA', 'C=FI/O=Sonera/CN=Sonera Class1 CA', '24', NULL, '-----BEGIN CERTIFICATE-----
MIIDIDCCAgigAwIBAgIBJDANBgkqhkiG9w0BAQUFADA5MQswCQYDVQQGEwJGSTEP
MA0GA1UEChMGU29uZXJhMRkwFwYDVQQDExBTb25lcmEgQ2xhc3MxIENBMB4XDTAx
MDQwNjEwNDkxM1oXDTIxMDQwNjEwNDkxM1owOTELMAkGA1UEBhMCRkkxDzANBgNV
BAoTBlNvbmVyYTEZMBcGA1UEAxMQU29uZXJhIENsYXNzMSBDQTCCASIwDQYJKoZI
hvcNAQEBBQADggEPADCCAQoCggEBALWJHytPZwp5/8Ue+H887dF+2rDNbS82rDTG
29lkFwhjMDMiikzujrsPDUJVyZ0upe/3p4zDq7mXy47vPxVnqIJyY1MPQYx9EJUk
oVqlBvqSV536pQHydekfvFYmUk54GWVYVQNYwBSujHxVX3BbdyMGNpfzJLWaRpXk
3w0LBUXl0fIdgrvGE+D+qnr9aTCU89JFhfzyMlsy3uhsXR/LpCJ0sICOXZT3BgBL
qdReLjVQCfOAl/QMF6452F/NM8EcyonCIvdFEu1eEpOdY6uCLrnrQkFEy0oaAIIN
nvmLVz5MxxftLItyM19yejhW1ebZrgUaHXVFsculJRwSVzb9IjcCAwEAAaMzMDEw
DwYDVR0TAQH/BAUwAwEB/zARBgNVHQ4ECgQIR+IMi/ZTiFIwCwYDVR0PBAQDAgEG
MA0GCSqGSIb3DQEBBQUAA4IBAQCLGrLJXWG04bkruVPRsoWdd44W7hE928Jj2VuX
ZfsSZ9gqXLar5V7DtxYvyOirHYr9qxp81V9jz9yw3Xe5qObSIjiHBxTZ/75Wtf0H
DjxVyhbMp6Z3N/vbXB9OWQaHowND9Rart4S9Tu+fMTfwRvFAttEMpWT4Y14h21VO
TzF2nBBhjrZTOqMRvq9tfB69ri3iDGnHhVNoomG6xT60eVR4ngrHAr5i0RGCS2Uv
kVrCqIexVmiUefkl98HVrhq4uz2PqYo4Ffdz0Fpg0YCw8NzVUM1O7pJIae2yIx4w
zMiUyLb1O4Z/P6Yun/Y+LLWSlj7fLJOK/4GMDw9ZIRlXvVWa
-----END CERTIFICATE-----', '797e08eb51a9a87f59874178d93b8d66');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=FI, O=Sonera, CN=Sonera Class2 CA', 3, 1, 0, '2001-04-06 07:29:40', '2021-04-06 07:29:40', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 29 (0x1d)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=FI, O=Sonera, CN=Sonera Class2 CA
        Validity
            Not Before: Apr  6 07:29:40 2001 GMT
            Not After : Apr  6 07:29:40 2021 GMT
        Subject: C=FI, O=Sonera, CN=Sonera Class2 CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:90:17:4a:35:9d:ca:f0:0d:96:c7:44:fa:16:37:
                    fc:48:bd:bd:7f:80:2d:35:3b:e1:6f:a8:67:a9:bf:
                    03:1c:4d:8c:6f:32:47:d5:41:68:a4:13:04:c1:35:
                    0c:9a:84:43:fc:5c:1d:ff:89:b3:e8:17:18:cd:91:
                    5f:fb:89:e3:ea:bf:4e:5d:7c:1b:26:d3:75:79:ed:
                    e6:84:e3:57:e5:ad:29:c4:f4:3a:28:e7:a5:7b:84:
                    36:69:b3:fd:5e:76:bd:a3:2d:99:d3:90:4e:23:28:
                    7d:18:63:f1:54:3b:26:9d:76:5b:97:42:b2:ff:ae:
                    f0:4e:ec:dd:39:95:4e:83:06:7f:e7:49:40:c8:c5:
                    01:b2:54:5a:66:1d:3d:fc:f9:e9:3c:0a:9e:81:b8:
                    70:f0:01:8b:e4:23:54:7c:c8:ae:f8:90:1e:00:96:
                    72:d4:54:cf:61:23:bc:ea:fb:9d:02:95:d1:b6:b9:
                    71:3a:69:08:3f:0f:b4:e1:42:c7:88:f5:3f:98:a8:
                    a7:ba:1c:e0:71:71:ef:58:57:81:50:7a:5c:6b:74:
                    46:0e:83:03:98:c3:8e:a8:6e:f2:76:32:6e:27:83:
                    c2:73:f3:dc:18:e8:b4:93:ea:75:44:6b:04:60:20:
                    71:57:87:9d:f3:be:a0:90:23:3d:8a:24:e1:da:21:
                    db:c3
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                4A:A0:AA:58:84:D3:5E:3C
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        5a:ce:87:f9:16:72:15:57:4b:1d:d9:9b:e7:a2:26:30:ec:93:
        67:df:d6:2d:d2:34:af:f7:38:a5:ce:ab:16:b9:ab:2f:7c:35:
        cb:ac:d0:0f:b4:4c:2b:fc:80:ef:6b:8c:91:5f:36:76:f7:db:
        b3:1b:19:ea:f4:b2:11:fd:61:71:44:bf:28:b3:3a:1d:bf:b3:
        43:e8:9f:bf:dc:31:08:71:b0:9d:8d:d6:34:47:32:90:c6:65:
        24:f7:a0:4a:7c:04:73:8f:39:6f:17:8c:72:b5:bd:4b:c8:7a:
        f8:7b:83:c3:28:4e:9c:09:ea:67:3f:b2:67:04:1b:c3:14:da:
        f8:e7:49:24:91:d0:1d:6a:fa:61:39:ef:6b:e7:21:75:06:07:
        d8:12:b4:21:20:70:42:71:81:da:3c:9a:36:be:a6:5b:0d:6a:
        6c:9a:1f:91:7b:f9:f9:ef:42:ba:4e:4e:9e:cc:0c:8d:94:dc:
        d9:45:9c:5e:ec:42:50:63:ae:f4:5d:c4:b1:12:dc:ca:3b:a8:
        2e:9d:14:5a:05:75:b7:ec:d7:63:e2:ba:35:b6:04:08:91:e8:
        da:9d:9c:f6:66:b5:18:ac:0a:a6:54:26:34:33:d2:1b:c1:d4:
        7f:1a:3a:8e:0b:aa:32:6e:db:fc:4f:25:9f:d9:32:c7:96:5a:
        70:ac:df:4c', '90174A359DCAF00D96C744FA1637FC48BDBD7F802D353BE16FA867A9BF031C4D8C6F3247D54168A41304C1350C9A8443FC5C1DFF89B3E81718CD915FFB89E3EABF4E5D7C1B26D37579EDE684E357E5AD29C4F43A28E7A57B843669B3FD5E76BDA32D99D3904E23287D1863F1543B269D765B9742B2FFAEF04EECDD39954E83067FE74940C8C501B2545A661D3DFCF9E93C0A9E81B870F0018BE423547CC8AEF8901E009672D454CF6123BCEAFB9D0295D1B6B9713A69083F0FB4E142C788F53F98A8A7BA1CE07171EF585781507A5C6B74460E830398C38EA86EF276326E2783C273F3DC18E8B493EA75446B0460207157879DF3BEA090233D8A24E1DA21DBC3', '/C=FI/O=Sonera/CN=Sonera Class2 CA', 'C=FI/O=Sonera/CN=Sonera Class2 CA', '1D', NULL, '-----BEGIN CERTIFICATE-----
MIIDIDCCAgigAwIBAgIBHTANBgkqhkiG9w0BAQUFADA5MQswCQYDVQQGEwJGSTEP
MA0GA1UEChMGU29uZXJhMRkwFwYDVQQDExBTb25lcmEgQ2xhc3MyIENBMB4XDTAx
MDQwNjA3Mjk0MFoXDTIxMDQwNjA3Mjk0MFowOTELMAkGA1UEBhMCRkkxDzANBgNV
BAoTBlNvbmVyYTEZMBcGA1UEAxMQU29uZXJhIENsYXNzMiBDQTCCASIwDQYJKoZI
hvcNAQEBBQADggEPADCCAQoCggEBAJAXSjWdyvANlsdE+hY3/Ei9vX+ALTU74W+o
Z6m/AxxNjG8yR9VBaKQTBME1DJqEQ/xcHf+Js+gXGM2RX/uJ4+q/Tl18GybTdXnt
5oTjV+WtKcT0OijnpXuENmmz/V52vaMtmdOQTiMofRhj8VQ7Jp12W5dCsv+u8E7s
3TmVToMGf+dJQMjFAbJUWmYdPfz56TwKnoG4cPABi+QjVHzIrviQHgCWctRUz2Ej
vOr7nQKV0ba5cTppCD8PtOFCx4j1P5iop7oc4HFx71hXgVB6XGt0Rg6DA5jDjqhu
8nYybieDwnPz3BjotJPqdURrBGAgcVeHnfO+oJAjPYok4doh28MCAwEAAaMzMDEw
DwYDVR0TAQH/BAUwAwEB/zARBgNVHQ4ECgQISqCqWITTXjwwCwYDVR0PBAQDAgEG
MA0GCSqGSIb3DQEBBQUAA4IBAQBazof5FnIVV0sd2ZvnoiYw7JNn39Yt0jSv9zil
zqsWuasvfDXLrNAPtEwr/IDva4yRXzZ299uzGxnq9LIR/WFxRL8oszodv7ND6J+/
3DEIcbCdjdY0RzKQxmUk96BKfARzjzlvF4xytb1LyHr4e4PDKE6cCepnP7JnBBvD
FNr450kkkdAdavphOe9r5yF1BgfYErQhIHBCcYHaPJo2vqZbDWpsmh+Re/n570K6
Tk6ezAyNlNzZRZxe7EJQY670XcSxEtzKO6gunRRaBXW37Ndj4ro1tgQIkejanZz2
ZrUYrAqmVCY0M9IbwdR/GjqOC6oybtv8TyWf2TLHllpwrN9M
-----END CERTIFICATE-----', 'deaf4e9dcb2f040ad4ae28207dd16212');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=GB, O=Comodo CA Limited, CN=AAA Certificate Services', 3, 1, 0, '2004-01-01 00:00:00', '2028-12-31 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=Comodo CA Limited, CN=AAA Certificate Services
        Validity
            Not Before: Jan  1 00:00:00 2004 GMT
            Not After : Dec 31 23:59:59 2028 GMT
        Subject: C=GB, ST=Greater Manchester, L=Salford, O=Comodo CA Limited, CN=AAA Certificate Services
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:be:40:9d:f4:6e:e1:ea:76:87:1c:4d:45:44:8e:
                    be:46:c8:83:06:9d:c1:2a:fe:18:1f:8e:e4:02:fa:
                    f3:ab:5d:50:8a:16:31:0b:9a:06:d0:c5:70:22:cd:
                    49:2d:54:63:cc:b6:6e:68:46:0b:53:ea:cb:4c:24:
                    c0:bc:72:4e:ea:f1:15:ae:f4:54:9a:12:0a:c3:7a:
                    b2:33:60:e2:da:89:55:f3:22:58:f3:de:dc:cf:ef:
                    83:86:a2:8c:94:4f:9f:68:f2:98:90:46:84:27:c7:
                    76:bf:e3:cc:35:2c:8b:5e:07:64:65:82:c0:48:b0:
                    a8:91:f9:61:9f:76:20:50:a8:91:c7:66:b5:eb:78:
                    62:03:56:f0:8a:1a:13:ea:31:a3:1e:a0:99:fd:38:
                    f6:f6:27:32:58:6f:07:f5:6b:b8:fb:14:2b:af:b7:
                    aa:cc:d6:63:5f:73:8c:da:05:99:a8:38:a8:cb:17:
                    78:36:51:ac:e9:9e:f4:78:3a:8d:cf:0f:d9:42:e2:
                    98:0c:ab:2f:9f:0e:01:de:ef:9f:99:49:f1:2d:df:
                    ac:74:4d:1b:98:b5:47:c5:e5:29:d1:f9:90:18:c7:
                    62:9c:be:83:c7:26:7b:3e:8a:25:c7:c0:dd:9d:e6:
                    35:68:10:20:9d:8f:d8:de:d2:c3:84:9c:0d:5e:e8:
                    2f:c9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                A0:11:0A:23:3E:96:F1:07:EC:E2:AF:29:EF:82:A5:7F:D0:30:A4:B4
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 CRL Distribution Points: 
                URI:http://crl.comodoca.com/AAACertificateServices.crl
                URI:http://crl.comodo.net/AAACertificateServices.crl

    Signature Algorithm: sha1WithRSAEncryption
        08:56:fc:02:f0:9b:e8:ff:a4:fa:d6:7b:c6:44:80:ce:4f:c4:
        c5:f6:00:58:cc:a6:b6:bc:14:49:68:04:76:e8:e6:ee:5d:ec:
        02:0f:60:d6:8d:50:18:4f:26:4e:01:e3:e6:b0:a5:ee:bf:bc:
        74:54:41:bf:fd:fc:12:b8:c7:4f:5a:f4:89:60:05:7f:60:b7:
        05:4a:f3:f6:f1:c2:bf:c4:b9:74:86:b6:2d:7d:6b:cc:d2:f3:
        46:dd:2f:c6:e0:6a:c3:c3:34:03:2c:7d:96:dd:5a:c2:0e:a7:
        0a:99:c1:05:8b:ab:0c:2f:f3:5c:3a:cf:6c:37:55:09:87:de:
        53:40:6c:58:ef:fc:b6:ab:65:6e:04:f6:1b:dc:3c:e0:5a:15:
        c6:9e:d9:f1:59:48:30:21:65:03:6c:ec:e9:21:73:ec:9b:03:
        a1:e0:37:ad:a0:15:18:8f:fa:ba:02:ce:a7:2c:a9:10:13:2c:
        d4:e5:08:26:ab:22:97:60:f8:90:5e:74:d4:a2:9a:53:bd:f2:
        a9:68:e0:a2:6e:c2:d7:6c:b1:a3:0f:9e:bf:eb:68:e7:56:f2:
        ae:f2:e3:2b:38:3a:09:81:b5:6b:85:d7:be:2d:ed:3f:1a:b7:
        b2:63:e2:f5:62:2c:82:d4:6a:00:41:50:f1:39:83:9f:95:e9:
        36:96:98:6e', 'BE409DF46EE1EA76871C4D45448EBE46C883069DC12AFE181F8EE402FAF3AB5D508A16310B9A06D0C57022CD492D5463CCB66E68460B53EACB4C24C0BC724EEAF115AEF4549A120AC37AB23360E2DA8955F32258F3DEDCCFEF8386A28C944F9F68F29890468427C776BFE3CC352C8B5E07646582C048B0A891F9619F762050A891C766B5EB78620356F08A1A13EA31A31EA099FD38F6F62732586F07F56BB8FB142BAFB7AACCD6635F738CDA0599A838A8CB17783651ACE99EF4783A8DCF0FD942E2980CAB2F9F0E01DEEF9F9949F12DDFAC744D1B98B547C5E529D1F99018C7629CBE83C7267B3E8A25C7C0DD9DE6356810209D8FD8DED2C3849C0D5EE82FC9', '/C=GB/ST=Greater Manchester/L=Salford/O=Comodo CA Limited/CN=AAA Certificate Services', 'C=GB/ST=Greater Manchester/L=Salford/O=Comodo CA Limited/CN=AAA Certificate Services', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIEMjCCAxqgAwIBAgIBATANBgkqhkiG9w0BAQUFADB7MQswCQYDVQQGEwJHQjEb
MBkGA1UECAwSR3JlYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHDAdTYWxmb3JkMRow
GAYDVQQKDBFDb21vZG8gQ0EgTGltaXRlZDEhMB8GA1UEAwwYQUFBIENlcnRpZmlj
YXRlIFNlcnZpY2VzMB4XDTA0MDEwMTAwMDAwMFoXDTI4MTIzMTIzNTk1OVowezEL
MAkGA1UEBhMCR0IxGzAZBgNVBAgMEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UE
BwwHU2FsZm9yZDEaMBgGA1UECgwRQ29tb2RvIENBIExpbWl0ZWQxITAfBgNVBAMM
GEFBQSBDZXJ0aWZpY2F0ZSBTZXJ2aWNlczCCASIwDQYJKoZIhvcNAQEBBQADggEP
ADCCAQoCggEBAL5AnfRu4ep2hxxNRUSOvkbIgwadwSr+GB+O5AL686tdUIoWMQua
BtDFcCLNSS1UY8y2bmhGC1Pqy0wkwLxyTurxFa70VJoSCsN6sjNg4tqJVfMiWPPe
3M/vg4aijJRPn2jymJBGhCfHdr/jzDUsi14HZGWCwEiwqJH5YZ92IFCokcdmtet4
YgNW8IoaE+oxox6gmf049vYnMlhvB/VruPsUK6+3qszWY19zjNoFmag4qMsXeDZR
rOme9Hg6jc8P2ULimAyrL58OAd7vn5lJ8S3frHRNG5i1R8XlKdH5kBjHYpy+g8cm
ez6KJcfA3Z3mNWgQIJ2P2N7Sw4ScDV7oL8kCAwEAAaOBwDCBvTAdBgNVHQ4EFgQU
oBEKIz6W8Qfs4q8p74Klf9AwpLQwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQF
MAMBAf8wewYDVR0fBHQwcjA4oDagNIYyaHR0cDovL2NybC5jb21vZG9jYS5jb20v
QUFBQ2VydGlmaWNhdGVTZXJ2aWNlcy5jcmwwNqA0oDKGMGh0dHA6Ly9jcmwuY29t
b2RvLm5ldC9BQUFDZXJ0aWZpY2F0ZVNlcnZpY2VzLmNybDANBgkqhkiG9w0BAQUF
AAOCAQEACFb8AvCb6P+k+tZ7xkSAzk/ExfYAWMymtrwUSWgEdujm7l3sAg9g1o1Q
GE8mTgHj5rCl7r+8dFRBv/38ErjHT1r0iWAFf2C3BUrz9vHCv8S5dIa2LX1rzNLz
Rt0vxuBqw8M0Ayx9lt1awg6nCpnBBYurDC/zXDrPbDdVCYfeU0BsWO/8tqtlbgT2
G9w84FoVxp7Z8VlIMCFlA2zs6SFz7JsDoeA3raAVGI/6ugLOpyypEBMs1OUIJqsi
l2D4kF501KKaU73yqWjgom7C12yxow+ev+to51byrvLjKzg6CYG1a4XXvi3tPxq3
smPi9WIsgtRqAEFQ8TmDn5XpNpaYbg==
-----END CERTIFICATE-----', 'a22a580eec5fdd8e3f2a066c1c5a1a5c');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=GB, O=COMODO CA Limited, CN=COMODO RSA Certification Authority', 3, 1, 0, '2000-05-30 10:48:38', '2020-05-30 10:48:38', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            27:66:ee:56:eb:49:f3:8e:ab:d7:70:a2:fc:84:de:22
        Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=SE, O=AddTrust AB, OU=AddTrust External TTP Network, CN=AddTrust External CA Root
        Validity
            Not Before: May 30 10:48:38 2000 GMT
            Not After : May 30 10:48:38 2020 GMT
        Subject: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO RSA Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (4096 bit)
                Modulus (4096 bit):
                    00:91:e8:54:92:d2:0a:56:b1:ac:0d:24:dd:c5:cf:
                    44:67:74:99:2b:37:a3:7d:23:70:00:71:bc:53:df:
                    c4:fa:2a:12:8f:4b:7f:10:56:bd:9f:70:72:b7:61:
                    7f:c9:4b:0f:17:a7:3d:e3:b0:04:61:ee:ff:11:97:
                    c7:f4:86:3e:0a:fa:3e:5c:f9:93:e6:34:7a:d9:14:
                    6b:e7:9c:b3:85:a0:82:7a:76:af:71:90:d7:ec:fd:
                    0d:fa:9c:6c:fa:df:b0:82:f4:14:7e:f9:be:c4:a6:
                    2f:4f:7f:99:7f:b5:fc:67:43:72:bd:0c:00:d6:89:
                    eb:6b:2c:d3:ed:8f:98:1c:14:ab:7e:e5:e3:6e:fc:
                    d8:a8:e4:92:24:da:43:6b:62:b8:55:fd:ea:c1:bc:
                    6c:b6:8b:f3:0e:8d:9a:e4:9b:6c:69:99:f8:78:48:
                    30:45:d5:ad:e1:0d:3c:45:60:fc:32:96:51:27:bc:
                    67:c3:ca:2e:b6:6b:ea:46:c7:c7:20:a0:b1:1f:65:
                    de:48:08:ba:a4:4e:a9:f2:83:46:37:84:eb:e8:cc:
                    81:48:43:67:4e:72:2a:9b:5c:bd:4c:1b:28:8a:5c:
                    22:7b:b4:ab:98:d9:ee:e0:51:83:c3:09:46:4e:6d:
                    3e:99:fa:95:17:da:7c:33:57:41:3c:8d:51:ed:0b:
                    b6:5c:af:2c:63:1a:df:57:c8:3f:bc:e9:5d:c4:9b:
                    af:45:99:e2:a3:5a:24:b4:ba:a9:56:3d:cf:6f:aa:
                    ff:49:58:be:f0:a8:ff:f4:b8:ad:e9:37:fb:ba:b8:
                    f4:0b:3a:f9:e8:43:42:1e:89:d8:84:cb:13:f1:d9:
                    bb:e1:89:60:b8:8c:28:56:ac:14:1d:9c:0a:e7:71:
                    eb:cf:0e:dd:3d:a9:96:a1:48:bd:3c:f7:af:b5:0d:
                    22:4c:c0:11:81:ec:56:3b:f6:d3:a2:e2:5b:b7:b2:
                    04:22:52:95:80:93:69:e8:8e:4c:65:f1:91:03:2d:
                    70:74:02:ea:8b:67:15:29:69:52:02:bb:d7:df:50:
                    6a:55:46:bf:a0:a3:28:61:7f:70:d0:c3:a2:aa:2c:
                    21:aa:47:ce:28:9c:06:45:76:bf:82:18:27:b4:d5:
                    ae:b4:cb:50:e6:6b:f4:4c:86:71:30:e9:a6:df:16:
                    86:e0:d8:ff:40:dd:fb:d0:42:88:7f:a3:33:3a:2e:
                    5c:1e:41:11:81:63:ce:18:71:6b:2b:ec:a6:8a:b7:
                    31:5c:3a:6a:47:e0:c3:79:59:d6:20:1a:af:f2:6a:
                    98:aa:72:bc:57:4a:d2:4b:9d:bb:10:fc:b0:4c:41:
                    e5:ed:1d:3d:5e:28:9d:9c:cc:bf:b3:51:da:a7:47:
                    e5:84:53
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Authority Key Identifier: 
                keyid:AD:BD:98:7A:34:B4:26:F7:FA:C4:26:54:EF:03:BD:E0:24:CB:54:1A

            X509v3 Subject Key Identifier: 
                BB:AF:7E:02:3D:FA:A6:F1:3C:84:8E:AD:EE:38:98:EC:D9:32:32:D4
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy

            X509v3 CRL Distribution Points: 
                URI:http://crl.usertrust.com/AddTrustExternalCARoot.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp.usertrust.com

    Signature Algorithm: sha384WithRSAEncryption
        64:bf:83:f1:5f:9a:85:d0:cd:b8:a1:29:57:0d:e8:5a:f7:d1:
        e9:3e:f2:76:04:6e:f1:52:70:bb:1e:3c:ff:4d:0d:74:6a:cc:
        81:82:25:d3:c3:a0:2a:5d:4c:f5:ba:8b:a1:6d:c4:54:09:75:
        c7:e3:27:0e:5d:84:79:37:40:13:77:f5:b4:ac:1c:d0:3b:ab:
        17:12:d6:ef:34:18:7e:2b:e9:79:d3:ab:57:45:0c:af:28:fa:
        d0:db:e5:50:95:88:bb:df:85:57:69:7d:92:d8:52:ca:73:81:
        bf:1c:f3:e6:b8:6e:66:11:05:b3:1e:94:2d:7f:91:95:92:59:
        f1:4c:ce:a3:91:71:4c:7c:47:0c:3b:0b:19:f6:a1:b1:6c:86:
        3e:5c:aa:c4:2e:82:cb:f9:07:96:ba:48:4d:90:f2:94:c8:a9:
        73:a2:eb:06:7b:23:9d:de:a2:f3:4d:55:9f:7a:61:45:98:18:
        68:c7:5e:40:6b:23:f5:79:7a:ef:8c:b5:6b:8b:b7:6f:46:f4:
        7b:f1:3d:4b:04:d8:93:80:59:5a:e0:41:24:1d:b2:8f:15:60:
        58:47:db:ef:6e:46:fd:15:f5:d9:5f:9a:b3:db:d8:b8:e4:40:
        b3:cd:97:39:ae:85:bb:1d:8e:bc:dc:87:9b:d1:a6:ef:f1:3b:
        6f:10:38:6f', '91E85492D20A56B1AC0D24DDC5CF446774992B37A37D23700071BC53DFC4FA2A128F4B7F1056BD9F7072B7617FC94B0F17A73DE3B00461EEFF1197C7F4863E0AFA3E5CF993E6347AD9146BE79CB385A0827A76AF7190D7ECFD0DFA9C6CFADFB082F4147EF9BEC4A62F4F7F997FB5FC674372BD0C00D689EB6B2CD3ED8F981C14AB7EE5E36EFCD8A8E49224DA436B62B855FDEAC1BC6CB68BF30E8D9AE49B6C6999F878483045D5ADE10D3C4560FC32965127BC67C3CA2EB66BEA46C7C720A0B11F65DE4808BAA44EA9F283463784EBE8CC814843674E722A9B5CBD4C1B288A5C227BB4AB98D9EEE05183C309464E6D3E99FA9517DA7C3357413C8D51ED0BB65CAF2C631ADF57C83FBCE95DC49BAF4599E2A35A24B4BAA9563DCF6FAAFF4958BEF0A8FFF4B8ADE937FBBAB8F40B3AF9E843421E89D884CB13F1D9BBE18960B88C2856AC141D9C0AE771EBCF0EDD3DA996A148BD3CF7AFB50D224CC01181EC563BF6D3A2E25BB7B204225295809369E88E4C65F191032D707402EA8B671529695202BBD7DF506A5546BFA0A328617F70D0C3A2AA2C21AA47CE289C064576BF821827B4D5AEB4CB50E66BF44C867130E9A6DF1686E0D8FF40DDFBD042887FA3333A2E5C1E41118163CE18716B2BECA68AB7315C3A6A47E0C37959D6201AAFF26A98AA72BC574AD24B9DBB10FCB04C41E5ED1D3D5E289D9CCCBFB351DAA747E58453', '/C=GB/ST=Greater Manchester/L=Salford/O=COMODO CA Limited/CN=COMODO RSA Certification Authority', 'C=SE/O=AddTrust AB/OU=AddTrust External TTP Network/CN=AddTrust External CA Root', '2766EE56EB49F38EABD770A2FC84DE22', NULL, '-----BEGIN CERTIFICATE-----
MIIFdDCCBFygAwIBAgIQJ2buVutJ846r13Ci/ITeIjANBgkqhkiG9w0BAQwFADBv
MQswCQYDVQQGEwJTRTEUMBIGA1UEChMLQWRkVHJ1c3QgQUIxJjAkBgNVBAsTHUFk
ZFRydXN0IEV4dGVybmFsIFRUUCBOZXR3b3JrMSIwIAYDVQQDExlBZGRUcnVzdCBF
eHRlcm5hbCBDQSBSb290MB4XDTAwMDUzMDEwNDgzOFoXDTIwMDUzMDEwNDgzOFow
gYUxCzAJBgNVBAYTAkdCMRswGQYDVQQIExJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAO
BgNVBAcTB1NhbGZvcmQxGjAYBgNVBAoTEUNPTU9ETyBDQSBMaW1pdGVkMSswKQYD
VQQDEyJDT01PRE8gUlNBIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIICIjANBgkq
hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAkehUktIKVrGsDSTdxc9EZ3SZKzejfSNw
AHG8U9/E+ioSj0t/EFa9n3Byt2F/yUsPF6c947AEYe7/EZfH9IY+Cvo+XPmT5jR6
2RRr55yzhaCCenavcZDX7P0N+pxs+t+wgvQUfvm+xKYvT3+Zf7X8Z0NyvQwA1onr
ayzT7Y+YHBSrfuXjbvzYqOSSJNpDa2K4Vf3qwbxstovzDo2a5JtsaZn4eEgwRdWt
4Q08RWD8MpZRJ7xnw8outmvqRsfHIKCxH2XeSAi6pE6p8oNGN4Tr6MyBSENnTnIq
m1y9TBsoilwie7SrmNnu4FGDwwlGTm0+mfqVF9p8M1dBPI1R7Qu2XK8sYxrfV8g/
vOldxJuvRZnio1oktLqpVj3Pb6r/SVi+8Kj/9Lit6Tf7urj0Czr56ENCHonYhMsT
8dm74YlguIwoVqwUHZwK53Hrzw7dPamWoUi9PPevtQ0iTMARgexWO/bTouJbt7IE
IlKVgJNp6I5MZfGRAy1wdALqi2cVKWlSArvX31BqVUa/oKMoYX9w0MOiqiwhqkfO
KJwGRXa/ghgntNWutMtQ5mv0TIZxMOmm3xaG4Nj/QN370EKIf6MzOi5cHkERgWPO
GHFrK+ymircxXDpqR+DDeVnWIBqv8mqYqnK8V0rSS527EPywTEHl7R09XiidnMy/
s1Hap0flhFMCAwEAAaOB9DCB8TAfBgNVHSMEGDAWgBStvZh6NLQm9/rEJlTvA73g
JMtUGjAdBgNVHQ4EFgQUu69+Aj36pvE8hI6t7jiY7NkyMtQwDgYDVR0PAQH/BAQD
AgGGMA8GA1UdEwEB/wQFMAMBAf8wEQYDVR0gBAowCDAGBgRVHSAAMEQGA1UdHwQ9
MDswOaA3oDWGM2h0dHA6Ly9jcmwudXNlcnRydXN0LmNvbS9BZGRUcnVzdEV4dGVy
bmFsQ0FSb290LmNybDA1BggrBgEFBQcBAQQpMCcwJQYIKwYBBQUHMAGGGWh0dHA6
Ly9vY3NwLnVzZXJ0cnVzdC5jb20wDQYJKoZIhvcNAQEMBQADggEBAGS/g/FfmoXQ
zbihKVcN6Fr30ek+8nYEbvFScLsePP9NDXRqzIGCJdPDoCpdTPW6i6FtxFQJdcfj
Jw5dhHk3QBN39bSsHNA7qxcS1u80GH4r6XnTq1dFDK8o+tDb5VCViLvfhVdpfZLY
Uspzgb8c8+a4bmYRBbMelC1/kZWSWfFMzqORcUx8Rww7Cxn2obFshj5cqsQugsv5
B5a6SE2Q8pTIqXOi6wZ7I53eovNNVZ96YUWYGGjHXkBrI/V5eu+MtWuLt29G9Hvx
PUsE2JOAWVrgQSQdso8VYFhH2+9uRv0V9dlfmrPb2LjkQLPNlzmuhbsdjrzch5vR
pu/xO28QOG8=
-----END CERTIFICATE-----', 'c6417027053396eaa5a7235c8d2315b7');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=GB, O=COMODO CA Limited, CN=COMODO RSA Certification Authority', 3, 1, 0, '2010-01-19 00:00:00', '2038-01-18 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            4c:aa:f9:ca:db:63:6f:e0:1f:f7:4e:d8:5b:03:86:9d
        Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO RSA Certification Authority
        Validity
            Not Before: Jan 19 00:00:00 2010 GMT
            Not After : Jan 18 23:59:59 2038 GMT
        Subject: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO RSA Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (4096 bit)
                Modulus (4096 bit):
                    00:91:e8:54:92:d2:0a:56:b1:ac:0d:24:dd:c5:cf:
                    44:67:74:99:2b:37:a3:7d:23:70:00:71:bc:53:df:
                    c4:fa:2a:12:8f:4b:7f:10:56:bd:9f:70:72:b7:61:
                    7f:c9:4b:0f:17:a7:3d:e3:b0:04:61:ee:ff:11:97:
                    c7:f4:86:3e:0a:fa:3e:5c:f9:93:e6:34:7a:d9:14:
                    6b:e7:9c:b3:85:a0:82:7a:76:af:71:90:d7:ec:fd:
                    0d:fa:9c:6c:fa:df:b0:82:f4:14:7e:f9:be:c4:a6:
                    2f:4f:7f:99:7f:b5:fc:67:43:72:bd:0c:00:d6:89:
                    eb:6b:2c:d3:ed:8f:98:1c:14:ab:7e:e5:e3:6e:fc:
                    d8:a8:e4:92:24:da:43:6b:62:b8:55:fd:ea:c1:bc:
                    6c:b6:8b:f3:0e:8d:9a:e4:9b:6c:69:99:f8:78:48:
                    30:45:d5:ad:e1:0d:3c:45:60:fc:32:96:51:27:bc:
                    67:c3:ca:2e:b6:6b:ea:46:c7:c7:20:a0:b1:1f:65:
                    de:48:08:ba:a4:4e:a9:f2:83:46:37:84:eb:e8:cc:
                    81:48:43:67:4e:72:2a:9b:5c:bd:4c:1b:28:8a:5c:
                    22:7b:b4:ab:98:d9:ee:e0:51:83:c3:09:46:4e:6d:
                    3e:99:fa:95:17:da:7c:33:57:41:3c:8d:51:ed:0b:
                    b6:5c:af:2c:63:1a:df:57:c8:3f:bc:e9:5d:c4:9b:
                    af:45:99:e2:a3:5a:24:b4:ba:a9:56:3d:cf:6f:aa:
                    ff:49:58:be:f0:a8:ff:f4:b8:ad:e9:37:fb:ba:b8:
                    f4:0b:3a:f9:e8:43:42:1e:89:d8:84:cb:13:f1:d9:
                    bb:e1:89:60:b8:8c:28:56:ac:14:1d:9c:0a:e7:71:
                    eb:cf:0e:dd:3d:a9:96:a1:48:bd:3c:f7:af:b5:0d:
                    22:4c:c0:11:81:ec:56:3b:f6:d3:a2:e2:5b:b7:b2:
                    04:22:52:95:80:93:69:e8:8e:4c:65:f1:91:03:2d:
                    70:74:02:ea:8b:67:15:29:69:52:02:bb:d7:df:50:
                    6a:55:46:bf:a0:a3:28:61:7f:70:d0:c3:a2:aa:2c:
                    21:aa:47:ce:28:9c:06:45:76:bf:82:18:27:b4:d5:
                    ae:b4:cb:50:e6:6b:f4:4c:86:71:30:e9:a6:df:16:
                    86:e0:d8:ff:40:dd:fb:d0:42:88:7f:a3:33:3a:2e:
                    5c:1e:41:11:81:63:ce:18:71:6b:2b:ec:a6:8a:b7:
                    31:5c:3a:6a:47:e0:c3:79:59:d6:20:1a:af:f2:6a:
                    98:aa:72:bc:57:4a:d2:4b:9d:bb:10:fc:b0:4c:41:
                    e5:ed:1d:3d:5e:28:9d:9c:cc:bf:b3:51:da:a7:47:
                    e5:84:53
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                BB:AF:7E:02:3D:FA:A6:F1:3C:84:8E:AD:EE:38:98:EC:D9:32:32:D4
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha384WithRSAEncryption
        0a:f1:d5:46:84:b7:ae:51:bb:6c:b2:4d:41:14:00:93:4c:9c:
        cb:e5:c0:54:cf:a0:25:8e:02:f9:fd:b0:a2:0d:f5:20:98:3c:
        13:2d:ac:56:a2:b0:d6:7e:11:92:e9:2e:ba:9e:2e:9a:72:b1:
        bd:19:44:6c:61:35:a2:9a:b4:16:12:69:5a:8c:e1:d7:3e:a4:
        1a:e8:2f:03:f4:ae:61:1d:10:1b:2a:a4:8b:7a:c5:fe:05:a6:
        e1:c0:d6:c8:fe:9e:ae:8f:2b:ba:3d:99:f8:d8:73:09:58:46:
        6e:a6:9c:f4:d7:27:d3:95:da:37:83:72:1c:d3:73:e0:a2:47:
        99:03:38:5d:d5:49:79:00:29:1c:c7:ec:9b:20:1c:07:24:69:
        57:78:b2:39:fc:3a:84:a0:b5:9c:7c:8d:bf:2e:93:62:27:b7:
        39:da:17:18:ae:bd:3c:09:68:ff:84:9b:3c:d5:d6:0b:03:e3:
        57:9e:14:f7:d1:eb:4f:c8:bd:87:23:b7:b6:49:43:79:85:5c:
        ba:eb:92:0b:a1:c6:e8:68:a8:4c:16:b1:1a:99:0a:e8:53:2c:
        92:bb:a1:09:18:75:0c:65:a8:7b:cb:23:b7:1a:c2:28:85:c3:
        1b:ff:d0:2b:62:ef:a4:7b:09:91:98:67:8c:14:01:cd:68:06:
        6a:63:21:75:03:80:88:8a:6e:81:c6:85:f2:a9:a4:2d:e7:f4:
        a5:24:10:47:83:ca:cd:f4:8d:79:58:b1:06:9b:e7:1a:2a:d9:
        9d:01:d7:94:7d:ed:03:4a:ca:f0:db:e8:a9:01:3e:f5:56:99:
        c9:1e:8e:49:3d:bb:e5:09:b9:e0:4f:49:92:3d:16:82:40:cc:
        cc:59:c6:e6:3a:ed:12:2e:69:3c:6c:95:b1:fd:aa:1d:7b:7f:
        86:be:1e:0e:32:46:fb:fb:13:8f:75:7f:4c:8b:4b:46:63:fe:
        00:34:40:70:c1:c3:b9:a1:dd:a6:70:e2:04:b3:41:bc:e9:80:
        91:ea:64:9c:7a:e1:22:03:a9:9c:6e:6f:0e:65:4f:6c:87:87:
        5e:f3:6e:a0:f9:75:a5:9b:40:e8:53:b2:27:9d:4a:b9:c0:77:
        21:8d:ff:87:f2:de:bc:8c:ef:17:df:b7:49:0b:d1:f2:6e:30:
        0b:1a:0e:4e:76:ed:11:fc:f5:e9:56:b2:7d:bf:c7:6d:0a:93:
        8c:a5:d0:c0:b6:1d:be:3a:4e:94:a2:d7:6e:6c:0b:c2:8a:7c:
        fa:20:f3:c4:e4:e5:cd:0d:a8:cb:91:92:b1:7c:85:ec:b5:14:
        69:66:0e:82:e7:cd:ce:c8:2d:a6:51:7f:21:c1:35:53:85:06:
        4a:5d:9f:ad:bb:1b:5f:74', '91E85492D20A56B1AC0D24DDC5CF446774992B37A37D23700071BC53DFC4FA2A128F4B7F1056BD9F7072B7617FC94B0F17A73DE3B00461EEFF1197C7F4863E0AFA3E5CF993E6347AD9146BE79CB385A0827A76AF7190D7ECFD0DFA9C6CFADFB082F4147EF9BEC4A62F4F7F997FB5FC674372BD0C00D689EB6B2CD3ED8F981C14AB7EE5E36EFCD8A8E49224DA436B62B855FDEAC1BC6CB68BF30E8D9AE49B6C6999F878483045D5ADE10D3C4560FC32965127BC67C3CA2EB66BEA46C7C720A0B11F65DE4808BAA44EA9F283463784EBE8CC814843674E722A9B5CBD4C1B288A5C227BB4AB98D9EEE05183C309464E6D3E99FA9517DA7C3357413C8D51ED0BB65CAF2C631ADF57C83FBCE95DC49BAF4599E2A35A24B4BAA9563DCF6FAAFF4958BEF0A8FFF4B8ADE937FBBAB8F40B3AF9E843421E89D884CB13F1D9BBE18960B88C2856AC141D9C0AE771EBCF0EDD3DA996A148BD3CF7AFB50D224CC01181EC563BF6D3A2E25BB7B204225295809369E88E4C65F191032D707402EA8B671529695202BBD7DF506A5546BFA0A328617F70D0C3A2AA2C21AA47CE289C064576BF821827B4D5AEB4CB50E66BF44C867130E9A6DF1686E0D8FF40DDFBD042887FA3333A2E5C1E41118163CE18716B2BECA68AB7315C3A6A47E0C37959D6201AAFF26A98AA72BC574AD24B9DBB10FCB04C41E5ED1D3D5E289D9CCCBFB351DAA747E58453', '/C=GB/ST=Greater Manchester/L=Salford/O=COMODO CA Limited/CN=COMODO RSA Certification Authority', 'C=GB/ST=Greater Manchester/L=Salford/O=COMODO CA Limited/CN=COMODO RSA Certification Authority', '4CAAF9CADB636FE01FF74ED85B03869D', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', 'ca105a966a5f62e1fa38db228585e366');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=GB, O=COMODO CA Limited, CN=COMODO RSA Domain Validation Secure Server CA', 3, 1, 0, '2014-02-12 00:00:00', '2029-02-11 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            2b:2e:6e:ea:d9:75:36:6c:14:8a:6e:db:a3:7c:8c:07
        Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO RSA Certification Authority
        Validity
            Not Before: Feb 12 00:00:00 2014 GMT
            Not After : Feb 11 23:59:59 2029 GMT
        Subject: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO RSA Domain Validation Secure Server CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:8e:c2:02:19:e1:a0:59:a4:eb:38:35:8d:2c:fd:
                    01:d0:d3:49:c0:64:c7:0b:62:05:45:16:3a:a8:a0:
                    c0:0c:02:7f:1d:cc:db:c4:a1:6d:77:03:a3:0f:86:
                    f9:e3:06:9c:3e:0b:81:8a:9b:49:1b:ad:03:be:fa:
                    4b:db:8c:20:ed:d5:ce:5e:65:8e:3e:0d:af:4c:c2:
                    b0:b7:45:5e:52:2f:34:de:48:24:64:b4:41:ae:00:
                    97:f7:be:67:de:9e:d0:7a:a7:53:80:3b:7c:ad:f5:
                    96:55:6f:97:47:0a:7c:85:8b:22:97:8d:b3:84:e0:
                    96:57:d0:70:18:60:96:8f:ee:2d:07:93:9d:a1:ba:
                    ca:d1:cd:7b:e9:c4:2a:9a:28:21:91:4d:6f:92:4f:
                    25:a5:f2:7a:35:dd:26:dc:46:a5:d0:ac:59:35:8c:
                    ff:4e:91:43:50:3f:59:93:1e:6c:51:21:ee:58:14:
                    ab:fe:75:50:78:3e:4c:b0:1c:86:13:fa:6b:98:bc:
                    e0:3b:94:1e:85:52:dc:03:93:24:18:6e:cb:27:51:
                    45:e6:70:de:25:43:a4:0d:e1:4a:a5:ed:b6:7e:c8:
                    cd:6d:ee:2e:1d:27:73:5d:dc:45:30:80:aa:e3:b2:
                    41:0b:af:bd:44:87:da:b9:e5:1b:9d:7f:ae:e5:85:
                    82:a5
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Authority Key Identifier: 
                keyid:BB:AF:7E:02:3D:FA:A6:F1:3C:84:8E:AD:EE:38:98:EC:D9:32:32:D4

            X509v3 Subject Key Identifier: 
                90:AF:6A:3A:94:5A:0B:D8:90:EA:12:56:73:DF:43:B4:3A:28:DA:E7
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication
            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                Policy: 2.23.140.1.2.1

            X509v3 CRL Distribution Points: 
                URI:http://crl.comodoca.com/COMODORSACertificationAuthority.crl

            Authority Information Access: 
                CA Issuers - URI:http://crt.comodoca.com/COMODORSAAddTrustCA.crt
                OCSP - URI:http://ocsp.comodoca.com

    Signature Algorithm: sha384WithRSAEncryption
        4e:2b:76:4f:92:1c:62:36:89:ba:77:c1:27:05:f4:1c:d6:44:
        9d:a9:9a:3e:aa:d5:66:66:01:3e:ea:49:e6:a2:35:bc:fa:f6:
        dd:95:8e:99:35:98:0e:36:18:75:b1:dd:dd:50:72:7c:ae:dc:
        77:88:ce:0f:f7:90:20:ca:a3:67:2e:1f:56:7f:7b:e1:44:ea:
        42:95:c4:5d:0d:01:50:46:15:f2:81:89:59:6c:8a:dd:8c:f1:
        12:a1:8d:3a:42:8a:98:f8:4b:34:7b:27:3b:08:b4:6f:24:3b:
        72:9d:63:74:58:3c:1a:6c:3f:4f:c7:11:9a:c8:a8:f5:b5:37:
        ef:10:45:c6:6c:d9:e0:5e:95:26:b3:eb:ad:a3:b9:ee:7f:0c:
        9a:66:35:73:32:60:4e:e5:dd:8a:61:2c:6e:52:11:77:68:96:
        d3:18:75:51:15:00:1b:74:88:dd:e1:c7:38:04:43:28:e9:16:
        fd:d9:05:d4:5d:47:27:60:d6:fb:38:3b:6c:72:a2:94:f8:42:
        1a:df:ed:6f:06:8c:45:c2:06:00:aa:e4:e8:dc:d9:b5:e1:73:
        78:ec:f6:23:dc:d1:dd:6c:8e:1a:8f:a5:ea:54:7c:96:b7:c3:
        fe:55:8e:8d:49:5e:fc:64:bb:cf:3e:bd:96:eb:69:cd:bf:e0:
        48:f1:62:82:10:e5:0c:46:57:f2:33:da:d0:c8:63:ed:c6:1f:
        94:05:96:4a:1a:91:d1:f7:eb:cf:8f:52:ae:0d:08:d9:3e:a8:
        a0:51:e9:c1:87:74:d5:c9:f7:74:ab:2e:53:fb:bb:7a:fb:97:
        e2:f8:1f:26:8f:b3:d2:a0:e0:37:5b:28:3b:31:e5:0e:57:2d:
        5a:b8:ad:79:ac:5e:20:66:1a:a5:b9:a6:b5:39:c1:f5:98:43:
        ff:ee:f9:a7:a7:fd:ee:ca:24:3d:80:16:c4:17:8f:8a:c1:60:
        a1:0c:ae:5b:43:47:91:4b:d5:9a:17:5f:f9:d4:87:c1:c2:8c:
        b7:e7:e2:0f:30:19:37:86:ac:e0:dc:42:03:e6:94:a8:9d:ae:
        fd:0f:24:51:94:ce:92:08:d1:fc:50:f0:03:40:7b:88:59:ed:
        0e:dd:ac:d2:77:82:34:dc:06:95:02:d8:90:f9:2d:ea:37:d5:
        1a:60:d0:67:20:d7:d8:42:0b:45:af:82:68:de:dd:66:24:37:
        90:29:94:19:46:19:25:b8:80:d7:cb:d4:86:28:6a:44:70:26:
        23:62:a9:9f:86:6f:bf:ba:90:70:d2:56:77:85:78:ef:ea:25:
        a9:17:ce:50:72:8c:00:3a:aa:e3:db:63:34:9f:f8:06:71:01:
        e2:82:20:d4:fe:6f:bd:b1', '8EC20219E1A059A4EB38358D2CFD01D0D349C064C70B620545163AA8A0C00C027F1DCCDBC4A16D7703A30F86F9E3069C3E0B818A9B491BAD03BEFA4BDB8C20EDD5CE5E658E3E0DAF4CC2B0B7455E522F34DE482464B441AE0097F7BE67DE9ED07AA753803B7CADF596556F97470A7C858B22978DB384E09657D0701860968FEE2D07939DA1BACAD1CD7BE9C42A9A2821914D6F924F25A5F27A35DD26DC46A5D0AC59358CFF4E9143503F59931E6C5121EE5814ABFE7550783E4CB01C8613FA6B98BCE03B941E8552DC039324186ECB275145E670DE2543A40DE14AA5EDB67EC8CD6DEE2E1D27735DDC453080AAE3B2410BAFBD4487DAB9E51B9D7FAEE58582A5', '/C=GB/ST=Greater Manchester/L=Salford/O=COMODO CA Limited/CN=COMODO RSA Domain Validation Secure Server CA', 'C=GB/ST=Greater Manchester/L=Salford/O=COMODO CA Limited/CN=COMODO RSA Certification Authority', '2B2E6EEAD975366C148A6EDBA37C8C07', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', 'a704ec457347c607fcfe48808c6dd8b7');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=GB, O=COMODO CA Limited, CN=COMODO RSA Organization Validation Secure Server CA', 3, 1, 0, '2014-02-12 00:00:00', '2029-02-11 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            36:82:5e:7f:b5:a4:81:93:7e:f6:d1:73:6b:b9:3c:a6
        Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO RSA Certification Authority
        Validity
            Not Before: Feb 12 00:00:00 2014 GMT
            Not After : Feb 11 23:59:59 2029 GMT
        Subject: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO RSA Organization Validation Secure Server CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b9:14:d9:85:f2:41:44:57:ff:30:44:1e:dc:3c:
                    44:a3:17:b8:6e:01:f8:a3:5f:c2:a9:21:1d:ce:59:
                    f4:ec:f3:88:a9:09:32:3c:b1:8b:63:a4:3e:27:36:
                    f3:8f:f9:38:66:2e:07:97:41:8f:4b:a6:dd:c3:5f:
                    9e:73:3c:e7:ca:20:0d:4f:7c:32:05:cf:c1:2e:48:
                    65:4a:85:d0:1f:56:31:6d:8e:e5:c6:32:d4:1b:bc:
                    9f:7d:96:fc:98:d7:4f:f8:f4:58:56:f8:e3:45:be:
                    91:18:82:e4:8a:be:af:cd:52:37:51:87:4f:1e:97:
                    c1:e8:3a:ae:f9:ff:46:e4:65:3f:3f:c3:47:83:2f:
                    cc:b8:42:5e:2d:7e:f7:5a:68:ae:5d:4b:c0:a6:35:
                    21:f5:86:a3:c8:49:8b:98:63:60:0d:c9:21:48:c2:
                    92:30:65:46:b2:86:35:04:42:25:7e:ad:a7:4e:4b:
                    12:40:00:7a:88:68:5c:6f:9f:a3:a4:78:11:21:ae:
                    3d:0b:0e:be:45:14:23:cf:eb:75:d7:f6:a0:f1:bc:
                    45:6c:5e:bc:a1:32:ec:f3:58:78:42:28:0b:3a:01:
                    76:f0:c5:a0:9e:c1:69:70:de:8f:4b:a6:79:df:f2:
                    76:b6:e3:0f:13:7c:18:3b:b1:51:6c:6a:20:39:ce:
                    9e:69
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Authority Key Identifier: 
                keyid:BB:AF:7E:02:3D:FA:A6:F1:3C:84:8E:AD:EE:38:98:EC:D9:32:32:D4

            X509v3 Subject Key Identifier: 
                9A:F3:2B:DA:CF:AD:4F:B6:2F:BB:2A:48:48:2A:12:B7:1B:42:C1:24
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication
            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                Policy: 2.23.140.1.2.2

            X509v3 CRL Distribution Points: 
                URI:http://crl.comodoca.com/COMODORSACertificationAuthority.crl

            Authority Information Access: 
                CA Issuers - URI:http://crt.comodoca.com/COMODORSAAddTrustCA.crt
                OCSP - URI:http://ocsp.comodoca.com

    Signature Algorithm: sha384WithRSAEncryption
        69:8a:36:68:9a:1e:3b:65:0b:e0:7c:cf:a6:ab:71:3b:af:61:
        a4:3f:e4:64:01:49:10:d3:1d:8f:e2:d5:ed:67:d3:9e:5b:97:
        bd:42:1e:07:f9:d0:bb:6d:f7:32:95:5a:22:29:62:f8:0c:9c:
        59:56:27:36:a0:22:12:11:fa:47:f4:51:c9:59:7b:29:4a:a5:
        48:35:7c:c5:97:66:e0:27:25:3b:15:7a:32:75:4a:91:fb:a6:
        6b:9e:e2:53:fa:0d:8c:13:fb:23:b8:0b:12:2c:ae:ed:db:1d:
        47:90:d5:d0:93:69:76:91:38:15:34:d7:18:ea:7e:bc:6b:58:
        de:2a:39:90:03:44:04:4a:56:d8:68:e5:f5:7c:69:7e:9e:7d:
        54:4b:d0:d8:86:ab:67:66:13:57:5e:89:2a:17:ad:2d:ae:bd:
        40:0e:66:ed:8a:ff:54:b4:c1:01:cb:a9:e0:47:ba:11:61:8f:
        ad:ae:23:48:2a:c6:25:79:89:1c:41:04:95:c0:11:ea:57:2b:
        d6:b4:97:fa:b1:e9:15:62:ec:4a:71:77:fd:f3:a1:9c:da:f6:
        6b:00:29:c5:32:e7:fa:4e:ea:b3:2a:a7:18:97:1c:58:a7:42:
        36:5f:ec:14:cf:f8:7b:0e:f7:dd:cc:88:15:9a:9a:5c:c8:f1:
        20:c7:d1:86:72:a1:17:9b:ae:ba:fe:6c:a8:32:d1:00:76:49:
        73:f7:3f:27:87:3c:b6:c9:2d:fa:aa:90:90:c9:0a:09:9f:c9:
        69:1f:07:19:a9:bf:de:ba:f8:0b:88:82:44:16:10:7f:07:c0:
        80:22:5f:7f:bc:30:de:ba:cd:07:79:64:56:d8:ff:f3:4f:9c:
        30:bb:6e:1e:51:4b:e6:cd:bd:17:c4:c5:bf:c8:3f:8e:b1:1f:
        8a:46:b7:06:43:6f:62:2d:cf:51:9d:45:ca:8a:e9:13:8b:c0:
        c7:91:be:5b:b6:fa:37:4a:89:fe:f0:9d:da:13:26:22:2c:06:
        90:3e:8b:13:98:a0:19:d6:dd:da:4a:48:7f:3d:0f:89:9d:24:
        72:4b:0e:7b:44:ff:d4:36:b6:83:76:23:58:8b:14:6c:b8:5d:
        f7:61:6d:39:76:ed:dd:12:3d:6b:87:88:97:91:be:c0:46:02:
        1e:76:1c:dd:b6:af:5c:4f:f5:00:d6:9c:4d:a9:e0:9e:a2:8e:
        fc:b1:16:79:5c:21:d3:45:81:9a:0c:39:6c:6d:28:d7:25:d2:
        b7:11:90:d0:f6:de:6f:5e:f4:fa:a4:8b:66:77:72:2f:9b:90:
        40:2c:52:12:60:f9:ff:b5:70:2e:89:9a:79:09:89:81:2d:ec:
        5c:78:6f:81:87:f1:fc:55', 'B914D985F2414457FF30441EDC3C44A317B86E01F8A35FC2A9211DCE59F4ECF388A909323CB18B63A43E2736F38FF938662E0797418F4BA6DDC35F9E733CE7CA200D4F7C3205CFC12E48654A85D01F56316D8EE5C632D41BBC9F7D96FC98D74FF8F45856F8E345BE911882E48ABEAFCD523751874F1E97C1E83AAEF9FF46E4653F3FC347832FCCB8425E2D7EF75A68AE5D4BC0A63521F586A3C8498B9863600DC92148C292306546B286350442257EADA74E4B1240007A88685C6F9FA3A4781121AE3D0B0EBE451423CFEB75D7F6A0F1BC456C5EBCA132ECF3587842280B3A0176F0C5A09EC16970DE8F4BA679DFF276B6E30F137C183BB1516C6A2039CE9E69', '/C=GB/ST=Greater Manchester/L=Salford/O=COMODO CA Limited/CN=COMODO RSA Organization Validation Secure Server CA', 'C=GB/ST=Greater Manchester/L=Salford/O=COMODO CA Limited/CN=COMODO RSA Certification Authority', '36825E7FB5A481937EF6D1736BB93CA6', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', 'a32e8f8593e9cd2b3f5735bb287f2f55');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=GB, O=Comodo CA Limited, CN=Secure Certificate Services', 3, 1, 0, '2004-01-01 00:00:00', '2028-12-31 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=Comodo CA Limited, CN=Secure Certificate Services
        Validity
            Not Before: Jan  1 00:00:00 2004 GMT
            Not After : Dec 31 23:59:59 2028 GMT
        Subject: C=GB, ST=Greater Manchester, L=Salford, O=Comodo CA Limited, CN=Secure Certificate Services
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:c0:71:33:82:8a:d0:70:eb:73:87:82:40:d5:1d:
                    e4:cb:c9:0e:42:90:f9:de:34:b9:a1:ba:11:f4:25:
                    85:f3:cc:72:6d:f2:7b:97:6b:b3:07:f1:77:24:91:
                    5f:25:8f:f6:74:3d:e4:80:c2:f8:3c:0d:f3:bf:40:
                    ea:f7:c8:52:d1:72:6f:ef:c8:ab:41:b8:6e:2e:17:
                    2a:95:69:0c:cd:d2:1e:94:7b:2d:94:1d:aa:75:d7:
                    b3:98:cb:ac:bc:64:53:40:bc:8f:ac:ac:36:cb:5c:
                    ad:bb:dd:e0:94:17:ec:d1:5c:d0:bf:ef:a5:95:c9:
                    90:c5:b0:ac:fb:1b:43:df:7a:08:5d:b7:b8:f2:40:
                    1b:2b:27:9e:50:ce:5e:65:82:88:8c:5e:d3:4e:0c:
                    7a:ea:08:91:b6:36:aa:2b:42:fb:ea:c2:a3:39:e5:
                    db:26:38:ad:8b:0a:ee:19:63:c7:1c:24:df:03:78:
                    da:e6:ea:c1:47:1a:0b:0b:46:09:dd:02:fc:de:cb:
                    87:5f:d7:30:63:68:a1:ae:dc:32:a1:ba:be:fe:44:
                    ab:68:b6:a5:17:15:fd:bd:d5:a7:a7:9a:e4:44:33:
                    e9:88:8e:fc:ed:51:eb:93:71:4e:ad:01:e7:44:8e:
                    ab:2d:cb:a8:fe:01:49:48:f0:c0:dd:c7:68:d8:92:
                    fe:3d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                3C:D8:93:88:C2:C0:82:09:CC:01:99:06:93:20:E9:9E:70:09:63:4F
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 CRL Distribution Points: 
                URI:http://crl.comodoca.com/SecureCertificateServices.crl
                URI:http://crl.comodo.net/SecureCertificateServices.crl

    Signature Algorithm: sha1WithRSAEncryption
        87:01:6d:23:1d:7e:5b:17:7d:c1:61:32:cf:8f:e7:f3:8a:94:
        59:66:e0:9e:28:a8:5e:d3:b7:f4:34:e6:aa:39:b2:97:16:c5:
        82:6f:32:a4:e9:8c:e7:af:fd:ef:c2:e8:b9:4b:aa:a3:f4:e6:
        da:8d:65:21:fb:ba:80:eb:26:28:85:1a:fe:39:8c:de:5b:04:
        04:b4:54:f9:a3:67:9e:41:fa:09:52:cc:05:48:a8:c9:3f:21:
        04:1e:ce:48:6b:fc:85:e8:c2:7b:af:7f:b7:cc:f8:5f:3a:fd:
        35:c6:0d:ef:97:dc:4c:ab:11:e1:6b:cb:31:d1:6c:fb:48:80:
        ab:dc:9c:37:b8:21:14:4b:0d:71:3d:ec:83:33:6e:d1:6e:32:
        16:ec:98:c7:16:8b:59:a6:34:ab:05:57:2d:93:f7:aa:13:cb:
        d2:13:e2:b7:2e:3b:cd:6b:50:17:09:68:3e:b5:26:57:ee:b6:
        e0:b6:dd:b9:29:80:79:7d:8f:a3:f0:a4:28:a4:15:c4:85:f4:
        27:d4:6b:bf:e5:5c:e4:65:02:76:54:b4:e3:37:66:24:d3:19:
        61:c8:52:10:e5:8b:37:9a:b9:a9:f9:1d:bf:ea:99:92:61:96:
        ff:01:cd:a1:5f:0d:bc:71:bc:0e:ac:0b:1d:47:45:1d:c1:ec:
        7c:ec:fd:29', 'C07133828AD070EB73878240D51DE4CBC90E4290F9DE34B9A1BA11F42585F3CC726DF27B976BB307F17724915F258FF6743DE480C2F83C0DF3BF40EAF7C852D1726FEFC8AB41B86E2E172A95690CCDD21E947B2D941DAA75D7B398CBACBC645340BC8FACAC36CB5CADBBDDE09417ECD15CD0BFEFA595C990C5B0ACFB1B43DF7A085DB7B8F2401B2B279E50CE5E6582888C5ED34E0C7AEA0891B636AA2B42FBEAC2A339E5DB2638AD8B0AEE1963C71C24DF0378DAE6EAC1471A0B0B4609DD02FCDECB875FD7306368A1AEDC32A1BABEFE44AB68B6A51715FDBDD5A7A79AE44433E9888EFCED51EB93714EAD01E7448EAB2DCBA8FE014948F0C0DDC768D892FE3D', '/C=GB/ST=Greater Manchester/L=Salford/O=Comodo CA Limited/CN=Secure Certificate Services', 'C=GB/ST=Greater Manchester/L=Salford/O=Comodo CA Limited/CN=Secure Certificate Services', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIEPzCCAyegAwIBAgIBATANBgkqhkiG9w0BAQUFADB+MQswCQYDVQQGEwJHQjEb
MBkGA1UECAwSR3JlYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHDAdTYWxmb3JkMRow
GAYDVQQKDBFDb21vZG8gQ0EgTGltaXRlZDEkMCIGA1UEAwwbU2VjdXJlIENlcnRp
ZmljYXRlIFNlcnZpY2VzMB4XDTA0MDEwMTAwMDAwMFoXDTI4MTIzMTIzNTk1OVow
fjELMAkGA1UEBhMCR0IxGzAZBgNVBAgMEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4G
A1UEBwwHU2FsZm9yZDEaMBgGA1UECgwRQ29tb2RvIENBIExpbWl0ZWQxJDAiBgNV
BAMMG1NlY3VyZSBDZXJ0aWZpY2F0ZSBTZXJ2aWNlczCCASIwDQYJKoZIhvcNAQEB
BQADggEPADCCAQoCggEBAMBxM4KK0HDrc4eCQNUd5MvJDkKQ+d40uaG6EfQlhfPM
cm3ye5drswfxdySRXyWP9nQ95IDC+DwN879A6vfIUtFyb+/Iq0G4bi4XKpVpDM3S
HpR7LZQdqnXXs5jLrLxkU0C8j6ysNstcrbvd4JQX7NFc0L/vpZXJkMWwrPsbQ996
CF23uPJAGysnnlDOXmWCiIxe004MeuoIkbY2qitC++rCoznl2yY4rYsK7hljxxwk
3wN42ubqwUcaCwtGCd0C/N7Lh1/XMGNooa7cMqG6vv5Eq2i2pRcV/b3Vp6ea5EQz
6YiO/O1R65NxTq0B50SOqy3LqP4BSUjwwN3HaNiS/j0CAwEAAaOBxzCBxDAdBgNV
HQ4EFgQUPNiTiMLAggnMAZkGkyDpnnAJY08wDgYDVR0PAQH/BAQDAgEGMA8GA1Ud
EwEB/wQFMAMBAf8wgYEGA1UdHwR6MHgwO6A5oDeGNWh0dHA6Ly9jcmwuY29tb2Rv
Y2EuY29tL1NlY3VyZUNlcnRpZmljYXRlU2VydmljZXMuY3JsMDmgN6A1hjNodHRw
Oi8vY3JsLmNvbW9kby5uZXQvU2VjdXJlQ2VydGlmaWNhdGVTZXJ2aWNlcy5jcmww
DQYJKoZIhvcNAQEFBQADggEBAIcBbSMdflsXfcFhMs+P5/OKlFlm4J4oqF7Tt/Q0
5qo5spcWxYJvMqTpjOev/e/C6LlLqqP05tqNZSH7uoDrJiiFGv45jN5bBAS0VPmj
Z55B+glSzAVIqMk/IQQezkhr/IXownuvf7fM+F86/TXGDe+X3EyrEeFryzHRbPtI
gKvcnDe4IRRLDXE97IMzbtFuMhbsmMcWi1mmNKsFVy2T96oTy9IT4rcuO81rUBcJ
aD61JlfutuC23bkpgHl9j6PwpCikFcSF9CfUa7/lXORlAnZUtOM3ZiTTGWHIUhDl
izeauan5Hb/qmZJhlv8BzaFfDbxxvA6sCx1HRR3B7Hzs/Sk=
-----END CERTIFICATE-----', 'fd71e5a4845691cb7c4f7e96e09b71e6');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=GB, O=Comodo CA Limited, CN=Trusted Certificate Services', 3, 1, 0, '2004-01-01 00:00:00', '2028-12-31 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=Comodo CA Limited, CN=Trusted Certificate Services
        Validity
            Not Before: Jan  1 00:00:00 2004 GMT
            Not After : Dec 31 23:59:59 2028 GMT
        Subject: C=GB, ST=Greater Manchester, L=Salford, O=Comodo CA Limited, CN=Trusted Certificate Services
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:df:71:6f:36:58:53:5a:f2:36:54:57:80:c4:74:
                    08:20:ed:18:7f:2a:1d:e6:35:9a:1e:25:ac:9c:e5:
                    96:7e:72:52:a0:15:42:db:59:dd:64:7a:1a:d0:b8:
                    7b:dd:39:15:bc:55:48:c4:ed:3a:00:ea:31:11:ba:
                    f2:71:74:1a:67:b8:cf:33:cc:a8:31:af:a3:e3:d7:
                    7f:bf:33:2d:4c:6a:3c:ec:8b:c3:92:d2:53:77:24:
                    74:9c:07:6e:70:fc:bd:0b:5b:76:ba:5f:f2:ff:d7:
                    37:4b:4a:60:78:f7:f0:fa:ca:70:b4:ea:59:aa:a3:
                    ce:48:2f:a9:c3:b2:0b:7e:17:72:16:0c:a6:07:0c:
                    1b:38:cf:c9:62:b7:3f:a0:93:a5:87:41:f2:b7:70:
                    40:77:d8:be:14:7c:e3:a8:c0:7a:8e:e9:63:6a:d1:
                    0f:9a:c6:d2:f4:8b:3a:14:04:56:d4:ed:b8:cc:6e:
                    f5:fb:e2:2c:58:bd:7f:4f:6b:2b:f7:60:24:58:24:
                    ce:26:ef:34:91:3a:d5:e3:81:d0:b2:f0:04:02:d7:
                    5b:b7:3e:92:ac:6b:12:8a:f9:e4:05:b0:3b:91:49:
                    5c:b2:eb:53:ea:f8:9f:47:86:ee:bf:95:c0:c0:06:
                    9f:d2:5b:5e:11:1b:f4:c7:04:35:29:d2:55:5c:e4:
                    ed:eb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                C5:7B:58:BD:ED:DA:25:69:D2:F7:59:16:A8:B3:32:C0:7B:27:5B:F4
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 CRL Distribution Points: 
                URI:http://crl.comodoca.com/TrustedCertificateServices.crl
                URI:http://crl.comodo.net/TrustedCertificateServices.crl

    Signature Algorithm: sha1WithRSAEncryption
        c8:93:81:3b:89:b4:af:b8:84:12:4c:8d:d2:f0:db:70:ba:57:
        86:15:34:10:b9:2f:7f:1e:b0:a8:89:60:a1:8a:c2:77:0c:50:
        4a:9b:00:8b:d8:8b:f4:41:e2:d0:83:8a:4a:1c:14:06:b0:a3:
        68:05:70:31:30:a7:53:9b:0e:e9:4a:a0:58:69:67:0e:ae:9d:
        f6:a5:2c:41:bf:3c:06:6b:e4:59:cc:6d:10:f1:96:6f:1f:df:
        f4:04:02:a4:9f:45:3e:c8:d8:fa:36:46:44:50:3f:82:97:91:
        1f:28:db:18:11:8c:2a:e4:65:83:57:12:12:8c:17:3f:94:36:
        fe:5d:b0:c0:04:77:13:b8:f4:15:d5:3f:38:cc:94:3a:55:d0:
        ac:98:f5:ba:00:5f:e0:86:19:81:78:2f:28:c0:7e:d3:cc:42:
        0a:f5:ae:50:a0:d1:3e:c6:a1:71:ec:3f:a0:20:8c:66:3a:89:
        b4:8e:d4:d8:b1:4d:25:47:ee:2f:88:c8:b5:e1:05:45:c0:be:
        14:71:de:7a:fd:8e:7b:7d:4d:08:96:a5:12:73:f0:2d:ca:37:
        27:74:12:27:4c:cb:b6:97:e9:d9:ae:08:6d:5a:39:40:dd:05:
        47:75:6a:5a:21:b3:a3:18:cf:4e:f7:2e:57:b7:98:70:5e:c8:
        c4:78:b0:62', 'DF716F3658535AF236545780C4740820ED187F2A1DE6359A1E25AC9CE5967E7252A01542DB59DD647A1AD0B87BDD3915BC5548C4ED3A00EA3111BAF271741A67B8CF33CCA831AFA3E3D77FBF332D4C6A3CEC8BC392D2537724749C076E70FCBD0B5B76BA5FF2FFD7374B4A6078F7F0FACA70B4EA59AAA3CE482FA9C3B20B7E1772160CA6070C1B38CFC962B73FA093A58741F2B7704077D8BE147CE3A8C07A8EE9636AD10F9AC6D2F48B3A140456D4EDB8CC6EF5FBE22C58BD7F4F6B2BF760245824CE26EF34913AD5E381D0B2F00402D75BB73E92AC6B128AF9E405B03B91495CB2EB53EAF89F4786EEBF95C0C0069FD25B5E111BF4C7043529D2555CE4EDEB', '/C=GB/ST=Greater Manchester/L=Salford/O=Comodo CA Limited/CN=Trusted Certificate Services', 'C=GB/ST=Greater Manchester/L=Salford/O=Comodo CA Limited/CN=Trusted Certificate Services', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIEQzCCAyugAwIBAgIBATANBgkqhkiG9w0BAQUFADB/MQswCQYDVQQGEwJHQjEb
MBkGA1UECAwSR3JlYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHDAdTYWxmb3JkMRow
GAYDVQQKDBFDb21vZG8gQ0EgTGltaXRlZDElMCMGA1UEAwwcVHJ1c3RlZCBDZXJ0
aWZpY2F0ZSBTZXJ2aWNlczAeFw0wNDAxMDEwMDAwMDBaFw0yODEyMzEyMzU5NTla
MH8xCzAJBgNVBAYTAkdCMRswGQYDVQQIDBJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAO
BgNVBAcMB1NhbGZvcmQxGjAYBgNVBAoMEUNvbW9kbyBDQSBMaW1pdGVkMSUwIwYD
VQQDDBxUcnVzdGVkIENlcnRpZmljYXRlIFNlcnZpY2VzMIIBIjANBgkqhkiG9w0B
AQEFAAOCAQ8AMIIBCgKCAQEA33FvNlhTWvI2VFeAxHQIIO0Yfyod5jWaHiWsnOWW
fnJSoBVC21ndZHoa0Lh73TkVvFVIxO06AOoxEbrycXQaZ7jPM8yoMa+j49d/vzMt
TGo87IvDktJTdyR0nAducPy9C1t2ul/y/9c3S0pgePfw+spwtOpZqqPOSC+pw7IL
fhdyFgymBwwbOM/JYrc/oJOlh0Hyt3BAd9i+FHzjqMB6juljatEPmsbS9Is6FARW
1O24zG71++IsWL1/T2sr92AkWCTOJu80kTrV44HQsvAEAtdbtz6SrGsSivnkBbA7
kUlcsutT6vifR4buv5XAwAaf0lteERv0xwQ1KdJVXOTt6wIDAQABo4HJMIHGMB0G
A1UdDgQWBBTFe1i97doladL3WRaoszLAeydb9DAOBgNVHQ8BAf8EBAMCAQYwDwYD
VR0TAQH/BAUwAwEB/zCBgwYDVR0fBHwwejA8oDqgOIY2aHR0cDovL2NybC5jb21v
ZG9jYS5jb20vVHJ1c3RlZENlcnRpZmljYXRlU2VydmljZXMuY3JsMDqgOKA2hjRo
dHRwOi8vY3JsLmNvbW9kby5uZXQvVHJ1c3RlZENlcnRpZmljYXRlU2VydmljZXMu
Y3JsMA0GCSqGSIb3DQEBBQUAA4IBAQDIk4E7ibSvuIQSTI3S8NtwuleGFTQQuS9/
HrCoiWChisJ3DFBKmwCL2Iv0QeLQg4pKHBQGsKNoBXAxMKdTmw7pSqBYaWcOrp32
pSxBvzwGa+RZzG0Q8ZZvH9/0BAKkn0U+yNj6NkZEUD+Cl5EfKNsYEYwq5GWDVxIS
jBc/lDb+XbDABHcTuPQV1T84zJQ6VdCsmPW6AF/ghhmBeC8owH7TzEIK9a5QoNE+
xqFx7D+gIIxmOom0jtTYsU0lR+4viMi14QVFwL4Ucd56/Y57fU0IlqUSc/Atyjcn
dBInTMu2l+nZrghtWjlA3QVHdWpaIbOjGM9O9y5Xt5hwXsjEeLBi
-----END CERTIFICATE-----', 'd89b71c3fa04259136130c7a4ee766ff');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=HU, O=NetLock Halozatbiztonsagi Kft., CN=NetLock Minositett Kozjegyzoi (Class QA) Tanusitvanykiado', 3, 1, 0, '2003-03-30 01:47:11', '2022-12-15 01:47:11', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 123 (0x7b)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=HU, L=Budapest, O=NetLock Halozatbiztonsagi Kft., OU=Tanusitvanykiadok, CN=NetLock Minositett Kozjegyzoi (Class QA) Tanusitvanykiado/emailAddress=info@netlock.hu
        Validity
            Not Before: Mar 30 01:47:11 2003 GMT
            Not After : Dec 15 01:47:11 2022 GMT
        Subject: C=HU, L=Budapest, O=NetLock Halozatbiztonsagi Kft., OU=Tanusitvanykiadok, CN=NetLock Minositett Kozjegyzoi (Class QA) Tanusitvanykiado/emailAddress=info@netlock.hu
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:c7:52:25:b2:d8:3d:d4:84:55:09:a7:1b:bd:6c:
                    b9:14:f4:8a:02:db:76:fc:6a:2a:78:ab:e5:77:f0:
                    6e:e0:8c:23:67:db:a5:64:99:b9:dd:01:3e:6f:ef:
                    2d:9a:3c:22:f0:5d:c9:57:a0:55:41:7f:f2:43:5e:
                    58:82:53:31:65:ce:1e:f2:26:ba:00:54:1e:af:b0:
                    bc:1c:e4:52:8c:a0:32:af:b7:37:b1:53:67:68:74:
                    67:50:f6:2d:2e:64:de:ae:26:79:df:df:99:86:ab:
                    ab:7f:85:ec:a0:fb:80:cc:f4:b8:0c:1e:93:45:63:
                    b9:dc:b8:5b:9b:ed:5b:39:d4:5f:62:b0:a7:8e:7c:
                    66:38:2c:aa:b1:08:63:17:67:7d:cc:bd:b3:f1:c3:
                    3f:cf:50:39:ed:d1:19:83:15:db:87:12:27:96:b7:
                    da:ea:e5:9d:bc:ba:ea:39:4f:8b:ef:74:9a:e7:c5:
                    d0:d2:ea:86:51:1c:e4:fe:64:08:28:04:79:05:eb:
                    ca:c5:71:0e:0b:ef:ab:ea:ec:12:11:a1:18:05:32:
                    69:d1:0c:2c:1a:3d:25:99:3f:b5:7c:ca:6d:b0:ae:
                    99:99:fa:08:60:e7:19:c2:f2:bd:51:d3:cc:d3:02:
                    ac:c1:11:0c:80:ce:ab:dc:94:9d:6b:a3:39:53:3a:
                    d6:85
                Exponent: 50557 (0xc57d)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:4
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            Netscape Comment: 
                FIGYELEM! Ezen tanusitvany a NetLock Kft. Minositett Szolgaltatasi Szabalyzataban leirt eljarasok alapjan keszult. A minositett elektronikus alairas joghatas ervenyesulesenek, valamint elfogadasanak feltetele a Minositett Szolgaltatasi Szabalyzatban, az Altalanos Szerzodesi Feltetelekben eloirt ellenorzesi eljaras megtetele. A dokumentumok megtalalhatok a https://www.netlock.hu/docs/ cimen vagy kerhetok az info@netlock.net e-mail cimen. WARNING! The issuance and the use of this certificate are subject to the NetLock Qualified CPS available at https://www.netlock.hu/docs/ or by e-mail at info@netlock.net
            X509v3 Subject Key Identifier: 
                09:6A:62:16:92:B0:5A:BB:55:0E:CB:75:32:3A:32:E5:B2:21:C9:28
    Signature Algorithm: sha1WithRSAEncryption
        91:6a:50:9c:db:78:81:9b:3f:8b:42:e3:3b:fc:a6:c3:ee:43:
        e0:cf:f3:e2:80:35:49:45:76:02:e2:e3:2f:05:c5:f1:2a:e7:
        c0:41:33:c6:b6:9b:d0:33:39:cd:c0:db:a1:ad:6c:37:02:4c:
        58:41:3b:f2:97:92:c6:48:a8:cd:e5:8a:39:89:61:f9:52:97:
        e9:bd:f6:f9:94:74:e8:71:0e:bc:77:86:c3:06:cc:5a:7c:4a:
        7e:34:50:30:2e:fb:7f:32:9a:8d:3d:f3:20:5b:f8:6a:ca:86:
        f3:31:4c:2c:59:80:02:7d:fe:38:c9:30:75:1c:b7:55:e3:bc:
        9f:ba:a8:6d:84:28:05:75:b3:8b:0d:c0:91:54:21:e7:a6:0b:
        b4:99:f5:51:41:dc:cd:a3:47:22:d9:c7:01:81:c4:dc:47:4f:
        26:ea:1f:ed:db:cd:0d:98:f4:a3:9c:b4:73:32:4a:96:99:fe:
        bc:7f:c8:25:58:f8:58:f3:76:66:89:54:a4:a6:3e:c4:50:5c:
        ba:89:18:82:75:48:21:d2:4f:13:e8:60:7e:07:76:db:10:b5:
        51:e6:aa:b9:68:aa:cd:f6:9d:90:75:12:ea:38:1a:ca:44:e8:
        b7:99:a7:2a:68:95:66:95:ab:ad:ef:89:cb:60:a9:06:12:c6:
        94:47:e9:28', 'C75225B2D83DD4845509A71BBD6CB914F48A02DB76FC6A2A78ABE577F06EE08C2367DBA56499B9DD013E6FEF2D9A3C22F05DC957A055417FF2435E5882533165CE1EF226BA00541EAFB0BC1CE4528CA032AFB737B1536768746750F62D2E64DEAE2679DFDF9986ABAB7F85ECA0FB80CCF4B80C1E934563B9DCB85B9BED5B39D45F62B0A78E7C66382CAAB1086317677DCCBDB3F1C33FCF5039EDD1198315DB87122796B7DAEAE59DBCBAEA394F8BEF749AE7C5D0D2EA86511CE4FE640828047905EBCAC5710E0BEFABEAEC1211A118053269D10C2C1A3D25993FB57CCA6DB0AE9999FA0860E719C2F2BD51D3CCD302ACC1110C80CEABDC949D6BA339533AD685', '/C=HU/L=Budapest/O=NetLock Halozatbiztonsagi Kft./OU=Tanusitvanykiadok/CN=NetLock Minositett Kozjegyzoi (Class QA) Tanusitvanykiado/emailAddress=info@netlock.hu', 'C=HU/L=Budapest/O=NetLock Halozatbiztonsagi Kft./OU=Tanusitvanykiadok/CN=NetLock Minositett Kozjegyzoi (Class QA) Tanusitvanykiado/emailAddress=info@netlock.hu', '7B', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', '8a2b0f016146ed5f78f8bdd828772803');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=IE, O=Baltimore, CN=Baltimore CyberTrust Root', 3, 1, 0, '2000-05-12 18:46:00', '2025-05-12 23:59:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 33554617 (0x20000b9)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=IE, O=Baltimore, OU=CyberTrust, CN=Baltimore CyberTrust Root
        Validity
            Not Before: May 12 18:46:00 2000 GMT
            Not After : May 12 23:59:00 2025 GMT
        Subject: C=IE, O=Baltimore, OU=CyberTrust, CN=Baltimore CyberTrust Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:a3:04:bb:22:ab:98:3d:57:e8:26:72:9a:b5:79:
                    d4:29:e2:e1:e8:95:80:b1:b0:e3:5b:8e:2b:29:9a:
                    64:df:a1:5d:ed:b0:09:05:6d:db:28:2e:ce:62:a2:
                    62:fe:b4:88:da:12:eb:38:eb:21:9d:c0:41:2b:01:
                    52:7b:88:77:d3:1c:8f:c7:ba:b9:88:b5:6a:09:e7:
                    73:e8:11:40:a7:d1:cc:ca:62:8d:2d:e5:8f:0b:a6:
                    50:d2:a8:50:c3:28:ea:f5:ab:25:87:8a:9a:96:1c:
                    a9:67:b8:3f:0c:d5:f7:f9:52:13:2f:c2:1b:d5:70:
                    70:f0:8f:c0:12:ca:06:cb:9a:e1:d9:ca:33:7a:77:
                    d6:f8:ec:b9:f1:68:44:42:48:13:d2:c0:c2:a4:ae:
                    5e:60:fe:b6:a6:05:fc:b4:dd:07:59:02:d4:59:18:
                    98:63:f5:a5:63:e0:90:0c:7d:5d:b2:06:7a:f3:85:
                    ea:eb:d4:03:ae:5e:84:3e:5f:ff:15:ed:69:bc:f9:
                    39:36:72:75:cf:77:52:4d:f3:c9:90:2c:b9:3d:e5:
                    c9:23:53:3f:1f:24:98:21:5c:07:99:29:bd:c6:3a:
                    ec:e7:6e:86:3a:6b:97:74:63:33:bd:68:18:31:f0:
                    78:8d:76:bf:fc:9e:8e:5d:2a:86:a7:4d:90:dc:27:
                    1a:39
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                E5:9D:59:30:82:47:58:CC:AC:FA:08:54:36:86:7B:3A:B5:04:4D:F0
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:3
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        85:0c:5d:8e:e4:6f:51:68:42:05:a0:dd:bb:4f:27:25:84:03:
        bd:f7:64:fd:2d:d7:30:e3:a4:10:17:eb:da:29:29:b6:79:3f:
        76:f6:19:13:23:b8:10:0a:f9:58:a4:d4:61:70:bd:04:61:6a:
        12:8a:17:d5:0a:bd:c5:bc:30:7c:d6:e9:0c:25:8d:86:40:4f:
        ec:cc:a3:7e:38:c6:37:11:4f:ed:dd:68:31:8e:4c:d2:b3:01:
        74:ee:be:75:5e:07:48:1a:7f:70:ff:16:5c:84:c0:79:85:b8:
        05:fd:7f:be:65:11:a3:0f:c0:02:b4:f8:52:37:39:04:d5:a9:
        31:7a:18:bf:a0:2a:f4:12:99:f7:a3:45:82:e3:3c:5e:f5:9d:
        9e:b5:c8:9e:7c:2e:c8:a4:9e:4e:08:14:4b:6d:fd:70:6d:6b:
        1a:63:bd:64:e6:1f:b7:ce:f0:f2:9f:2e:bb:1b:b7:f2:50:88:
        73:92:c2:e2:e3:16:8d:9a:32:02:ab:8e:18:dd:e9:10:11:ee:
        7e:35:ab:90:af:3e:30:94:7a:d0:33:3d:a7:65:0f:f5:fc:8e:
        9e:62:cf:47:44:2c:01:5d:bb:1d:b5:32:d2:47:d2:38:2e:d0:
        fe:81:dc:32:6a:1e:b5:ee:3c:d5:fc:e7:81:1d:19:c3:24:42:
        ea:63:39:a9', 'A304BB22AB983D57E826729AB579D429E2E1E89580B1B0E35B8E2B299A64DFA15DEDB009056DDB282ECE62A262FEB488DA12EB38EB219DC0412B01527B8877D31C8FC7BAB988B56A09E773E81140A7D1CCCA628D2DE58F0BA650D2A850C328EAF5AB25878A9A961CA967B83F0CD5F7F952132FC21BD57070F08FC012CA06CB9AE1D9CA337A77D6F8ECB9F16844424813D2C0C2A4AE5E60FEB6A605FCB4DD075902D459189863F5A563E0900C7D5DB2067AF385EAEBD403AE5E843E5FFF15ED69BCF939367275CF77524DF3C9902CB93DE5C923533F1F2498215C079929BDC63AECE76E863A6B97746333BD681831F0788D76BFFC9E8E5D2A86A74D90DC271A39', '/C=IE/O=Baltimore/OU=CyberTrust/CN=Baltimore CyberTrust Root', 'C=IE/O=Baltimore/OU=CyberTrust/CN=Baltimore CyberTrust Root', '020000B9', NULL, '-----BEGIN CERTIFICATE-----
MIIDdzCCAl+gAwIBAgIEAgAAuTANBgkqhkiG9w0BAQUFADBaMQswCQYDVQQGEwJJ
RTESMBAGA1UEChMJQmFsdGltb3JlMRMwEQYDVQQLEwpDeWJlclRydXN0MSIwIAYD
VQQDExlCYWx0aW1vcmUgQ3liZXJUcnVzdCBSb290MB4XDTAwMDUxMjE4NDYwMFoX
DTI1MDUxMjIzNTkwMFowWjELMAkGA1UEBhMCSUUxEjAQBgNVBAoTCUJhbHRpbW9y
ZTETMBEGA1UECxMKQ3liZXJUcnVzdDEiMCAGA1UEAxMZQmFsdGltb3JlIEN5YmVy
VHJ1c3QgUm9vdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKMEuyKr
mD1X6CZymrV51Cni4eiVgLGw41uOKymaZN+hXe2wCQVt2yguzmKiYv60iNoS6zjr
IZ3AQSsBUnuId9Mcj8e6uYi1agnnc+gRQKfRzMpijS3ljwumUNKoUMMo6vWrJYeK
mpYcqWe4PwzV9/lSEy/CG9VwcPCPwBLKBsua4dnKM3p31vjsufFoREJIE9LAwqSu
XmD+tqYF/LTdB1kC1FkYmGP1pWPgkAx9XbIGevOF6uvUA65ehD5f/xXtabz5OTZy
dc93Uk3zyZAsuT3lySNTPx8kmCFcB5kpvcY67Oduhjprl3RjM71oGDHweI12v/ye
jl0qhqdNkNwnGjkCAwEAAaNFMEMwHQYDVR0OBBYEFOWdWTCCR1jMrPoIVDaGezq1
BE3wMBIGA1UdEwEB/wQIMAYBAf8CAQMwDgYDVR0PAQH/BAQDAgEGMA0GCSqGSIb3
DQEBBQUAA4IBAQCFDF2O5G9RaEIFoN27TyclhAO992T9Ldcw46QQF+vaKSm2eT92
9hkTI7gQCvlYpNRhcL0EYWoSihfVCr3FvDB81ukMJY2GQE/szKN+OMY3EU/t3Wgx
jkzSswF07r51XgdIGn9w/xZchMB5hbgF/X++ZRGjD8ACtPhSNzkE1akxehi/oCr0
Epn3o0WC4zxe9Z2etciefC7IpJ5OCBRLbf1wbWsaY71k5h+3zvDyny67G7fyUIhz
ksLi4xaNmjICq44Y3ekQEe5+NauQrz4wlHrQMz2nZQ/1/I6eYs9HRCwBXbsdtTLS
R9I4LtD+gdwyah617jzV/OeBHRnDJELqYzmp
-----END CERTIFICATE-----', 'b1358966caad2e52a9f662032dc91139');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=IL, O=StartCom Ltd., CN=Free SSL Certification Authority', 3, 1, 0, '2005-03-17 17:37:48', '2035-03-10 17:37:48', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=IL, ST=Israel, L=Eilat, O=StartCom Ltd., OU=CA Authority Dep., CN=Free SSL Certification Authority/emailAddress=admin@startcom.org
        Validity
            Not Before: Mar 17 17:37:48 2005 GMT
            Not After : Mar 10 17:37:48 2035 GMT
        Subject: C=IL, ST=Israel, L=Eilat, O=StartCom Ltd., OU=CA Authority Dep., CN=Free SSL Certification Authority/emailAddress=admin@startcom.org
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ed:84:60:00:23:9e:c8:4a:51:29:27:de:3a:a1:
                    39:b5:69:ab:09:b2:2f:34:fd:61:dc:3d:d3:b0:cf:
                    b1:d7:c2:c4:c2:b1:e4:96:56:c4:be:aa:14:0e:e7:
                    cc:3a:50:c8:3a:62:9d:c3:a3:ac:59:7b:8e:ee:55:
                    1a:1c:47:be:a3:97:39:b3:b5:ef:23:2c:08:e8:d8:
                    af:73:2f:b9:c9:83:e8:ed:00:0f:c8:75:a5:2f:34:
                    4c:18:e8:76:88:23:49:8a:db:b6:ed:68:da:c3:b5:
                    62:29:4c:a5:4b:b7:98:b4:09:14:10:a0:f8:fe:62:
                    76:22:15:0b:a4:d6:08:2f:35
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: 
                Digital Signature, Non Repudiation, Key Encipherment, Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                1C:89:C3:96:CC:BD:FE:32:D5:0D:8C:81:31:B6:98:9D:8D:28:64:8D
            X509v3 Authority Key Identifier: 
                keyid:1C:89:C3:96:CC:BD:FE:32:D5:0D:8C:81:31:B6:98:9D:8D:28:64:8D
                DirName:/C=IL/ST=Israel/L=Eilat/O=StartCom Ltd./OU=CA Authority Dep./CN=Free SSL Certification Authority/emailAddress=admin@startcom.org
                serial:00

            X509v3 Subject Alternative Name: 
                email:admin@startcom.org
            X509v3 Issuer Alternative Name: 
                email:admin@startcom.org
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            Netscape Comment: 
                Free SSL Certification Authority
            Netscape CA Revocation Url: 
                http://cert.startcom.org/ca-crl.crl
            Netscape Base Url: 
                http://cert.startcom.org/
            Netscape CA Policy Url: 
                http://cert.startcom.org/index.php?app=111
    Signature Algorithm: md5WithRSAEncryption
        6c:71:25:e1:9e:34:91:21:ef:db:6c:bd:01:08:56:8f:88:d8:
        41:3a:53:f5:72:df:27:57:4b:76:84:f7:68:a4:fe:eb:3f:09:
        7e:28:b8:57:ea:1f:c1:aa:e2:ff:96:9f:49:99:e6:b2:95:73:
        96:c6:48:c7:5e:8d:07:72:56:f8:83:8f:9f:77:af:29:d3:45:
        0e:a4:ee:b0:36:74:2d:f0:cd:98:23:7b:37:4b:da:fe:51:98:
        c4:1e:34:3c:88:fd:99:3b:50:a7:c1:8b:33:c7:c2:52:16:12:
        95:53:65:22:ef:ba:8b:ce:62:db:70:23:b1:80:df:1a:20:38:
        e7:7e', 'ED846000239EC84A512927DE3AA139B569AB09B22F34FD61DC3DD3B0CFB1D7C2C4C2B1E49656C4BEAA140EE7CC3A50C83A629DC3A3AC597B8EEE551A1C47BEA39739B3B5EF232C08E8D8AF732FB9C983E8ED000FC875A52F344C18E8768823498ADBB6ED68DAC3B562294CA54BB798B4091410A0F8FE627622150BA4D6082F35', '/C=IL/ST=Israel/L=Eilat/O=StartCom Ltd./OU=CA Authority Dep./CN=Free SSL Certification Authority/emailAddress=admin@startcom.org', 'C=IL/ST=Israel/L=Eilat/O=StartCom Ltd./OU=CA Authority Dep./CN=Free SSL Certification Authority/emailAddress=admin@startcom.org', '00', NULL, '-----BEGIN CERTIFICATE-----
MIIFFjCCBH+gAwIBAgIBADANBgkqhkiG9w0BAQQFADCBsDELMAkGA1UEBhMCSUwx
DzANBgNVBAgTBklzcmFlbDEOMAwGA1UEBxMFRWlsYXQxFjAUBgNVBAoTDVN0YXJ0
Q29tIEx0ZC4xGjAYBgNVBAsTEUNBIEF1dGhvcml0eSBEZXAuMSkwJwYDVQQDEyBG
cmVlIFNTTCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTEhMB8GCSqGSIb3DQEJARYS
YWRtaW5Ac3RhcnRjb20ub3JnMB4XDTA1MDMxNzE3Mzc0OFoXDTM1MDMxMDE3Mzc0
OFowgbAxCzAJBgNVBAYTAklMMQ8wDQYDVQQIEwZJc3JhZWwxDjAMBgNVBAcTBUVp
bGF0MRYwFAYDVQQKEw1TdGFydENvbSBMdGQuMRowGAYDVQQLExFDQSBBdXRob3Jp
dHkgRGVwLjEpMCcGA1UEAxMgRnJlZSBTU0wgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
dHkxITAfBgkqhkiG9w0BCQEWEmFkbWluQHN0YXJ0Y29tLm9yZzCBnzANBgkqhkiG
9w0BAQEFAAOBjQAwgYkCgYEA7YRgACOeyEpRKSfeOqE5tWmrCbIvNP1h3D3TsM+x
18LEwrHkllbEvqoUDufMOlDIOmKdw6OsWXuO7lUaHEe+o5c5s7XvIywI6Nivcy+5
yYPo7QAPyHWlLzRMGOh2iCNJitu27Wjaw7ViKUylS7eYtAkUEKD4/mJ2IhULpNYI
LzUCAwEAAaOCAjwwggI4MA8GA1UdEwEB/wQFMAMBAf8wCwYDVR0PBAQDAgHmMB0G
A1UdDgQWBBQcicOWzL3+MtUNjIExtpidjShkjTCB3QYDVR0jBIHVMIHSgBQcicOW
zL3+MtUNjIExtpidjShkjaGBtqSBszCBsDELMAkGA1UEBhMCSUwxDzANBgNVBAgT
BklzcmFlbDEOMAwGA1UEBxMFRWlsYXQxFjAUBgNVBAoTDVN0YXJ0Q29tIEx0ZC4x
GjAYBgNVBAsTEUNBIEF1dGhvcml0eSBEZXAuMSkwJwYDVQQDEyBGcmVlIFNTTCBD
ZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTEhMB8GCSqGSIb3DQEJARYSYWRtaW5Ac3Rh
cnRjb20ub3JnggEAMB0GA1UdEQQWMBSBEmFkbWluQHN0YXJ0Y29tLm9yZzAdBgNV
HRIEFjAUgRJhZG1pbkBzdGFydGNvbS5vcmcwEQYJYIZIAYb4QgEBBAQDAgAHMC8G
CWCGSAGG+EIBDQQiFiBGcmVlIFNTTCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAy
BglghkgBhvhCAQQEJRYjaHR0cDovL2NlcnQuc3RhcnRjb20ub3JnL2NhLWNybC5j
cmwwKAYJYIZIAYb4QgECBBsWGWh0dHA6Ly9jZXJ0LnN0YXJ0Y29tLm9yZy8wOQYJ
YIZIAYb4QgEIBCwWKmh0dHA6Ly9jZXJ0LnN0YXJ0Y29tLm9yZy9pbmRleC5waHA/
YXBwPTExMTANBgkqhkiG9w0BAQQFAAOBgQBscSXhnjSRIe/bbL0BCFaPiNhBOlP1
ct8nV0t2hPdopP7rPwl+KLhX6h/BquL/lp9JmeaylXOWxkjHXo0Hclb4g4+fd68p
00UOpO6wNnQt8M2YI3s3S9r+UZjEHjQ8iP2ZO1CnwYszx8JSFhKVU2Ui77qLzmLb
cCOxgN8aIDjnfg==
-----END CERTIFICATE-----', 'ff2da502287c8a1bfebf338dba3dc9fb');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=IL, O=StartCom Ltd., CN=StartCom Certification Authority', 3, 1, 0, '2006-09-17 19:46:36', '2036-09-17 19:46:36', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=IL, O=StartCom Ltd., OU=Secure Digital Certificate Signing, CN=StartCom Certification Authority
        Validity
            Not Before: Sep 17 19:46:36 2006 GMT
            Not After : Sep 17 19:46:36 2036 GMT
        Subject: C=IL, O=StartCom Ltd., OU=Secure Digital Certificate Signing, CN=StartCom Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (4096 bit)
                Modulus (4096 bit):
                    00:c1:88:db:09:bc:6c:46:7c:78:9f:95:7b:b5:33:
                    90:f2:72:62:d6:c1:36:20:22:24:5e:ce:e9:77:f2:
                    43:0a:a2:06:64:a4:cc:8e:36:f8:38:e6:23:f0:6e:
                    6d:b1:3c:dd:72:a3:85:1c:a1:d3:3d:b4:33:2b:d3:
                    2f:af:fe:ea:b0:41:59:67:b6:c4:06:7d:0a:9e:74:
                    85:d6:79:4c:80:37:7a:df:39:05:52:59:f7:f4:1b:
                    46:43:a4:d2:85:85:d2:c3:71:f3:75:62:34:ba:2c:
                    8a:7f:1e:8f:ee:ed:34:d0:11:c7:96:cd:52:3d:ba:
                    33:d6:dd:4d:de:0b:3b:4a:4b:9f:c2:26:2f:fa:b5:
                    16:1c:72:35:77:ca:3c:5d:e6:ca:e1:26:8b:1a:36:
                    76:5c:01:db:74:14:25:fe:ed:b5:a0:88:0f:dd:78:
                    ca:2d:1f:07:97:30:01:2d:72:79:fa:46:d6:13:2a:
                    a8:b9:a6:ab:83:49:1d:e5:f2:ef:dd:e4:01:8e:18:
                    0a:8f:63:53:16:85:62:a9:0e:19:3a:cc:b5:66:a6:
                    c2:6b:74:07:e4:2b:e1:76:3e:b4:6d:d8:f6:44:e1:
                    73:62:1f:3b:c4:be:a0:53:56:25:6c:51:09:f7:aa:
                    ab:ca:bf:76:fd:6d:9b:f3:9d:db:bf:3d:66:bc:0c:
                    56:aa:af:98:48:95:3a:4b:df:a7:58:50:d9:38:75:
                    a9:5b:ea:43:0c:02:ff:99:eb:e8:6c:4d:70:5b:29:
                    65:9c:dd:aa:5d:cc:af:01:31:ec:0c:eb:d2:8d:e8:
                    ea:9c:7b:e6:6e:f7:27:66:0c:1a:48:d7:6e:42:e3:
                    3f:de:21:3e:7b:e1:0d:70:fb:63:aa:a8:6c:1a:54:
                    b4:5c:25:7a:c9:a2:c9:8b:16:a6:bb:2c:7e:17:5e:
                    05:4d:58:6e:12:1d:01:ee:12:10:0d:c6:32:7f:18:
                    ff:fc:f4:fa:cd:6e:91:e8:36:49:be:1a:48:69:8b:
                    c2:96:4d:1a:12:b2:69:17:c1:0a:90:d6:fa:79:22:
                    48:bf:ba:7b:69:f8:70:c7:fa:7a:37:d8:d8:0d:d2:
                    76:4f:57:ff:90:b7:e3:91:d2:dd:ef:c2:60:b7:67:
                    3a:dd:fe:aa:9c:f0:d4:8b:7f:72:22:ce:c6:9f:97:
                    b6:f8:af:8a:a0:10:a8:d9:fb:18:c6:b6:b5:5c:52:
                    3c:89:b6:19:2a:73:01:0a:0f:03:b3:12:60:f2:7a:
                    2f:81:db:a3:6e:ff:26:30:97:f5:8b:dd:89:57:b6:
                    ad:3d:b3:af:2b:c5:b7:76:02:f0:a5:d6:2b:9a:86:
                    14:2a:72:f6:e3:33:8c:5d:09:4b:13:df:bb:8c:74:
                    13:52:4b
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
                CA:TRUE
            X509v3 Key Usage: 
                Digital Signature, Key Encipherment, Key Agreement, Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                4E:0B:EF:1A:A4:40:5B:A5:17:69:87:30:CA:34:68:43:D0:41:AE:F2
            X509v3 CRL Distribution Points: 
                URI:http://cert.startcom.org/sfsca-crl.crl
                URI:http://crl.startcom.org/sfsca-crl.crl

            X509v3 Certificate Policies: 
                Policy: 1.3.6.1.4.1.23223.1.1.1
                  CPS: http://cert.startcom.org/policy.pdf
                  CPS: http://cert.startcom.org/intermediate.pdf
                  User Notice:
                    Organization: Start Commercial (StartCom) Ltd.
                    Number: 1
                    Explicit Text: Limited Liability, read the section *Legal Limitations* of the StartCom Certification Authority Policy available at http://cert.startcom.org/policy.pdf

            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            Netscape Comment: 
                StartCom Free SSL Certification Authority
    Signature Algorithm: sha1WithRSAEncryption
        16:6c:99:f4:66:0c:34:f5:d0:85:5e:7d:0a:ec:da:10:4e:38:
        1c:5e:df:a6:25:05:4b:91:32:c1:e8:3b:f1:3d:dd:44:09:5b:
        07:49:8a:29:cb:66:02:b7:b1:9a:f7:25:98:09:3c:8e:1b:e1:
        dd:36:87:2b:4b:bb:68:d3:39:66:3d:a0:26:c7:f2:39:91:1d:
        51:ab:82:7b:7e:d5:ce:5a:e4:e2:03:57:70:69:97:08:f9:5e:
        58:a6:0a:df:8c:06:9a:45:16:16:38:0a:5e:57:f6:62:c7:7a:
        02:05:e6:bc:1e:b5:f2:9e:f4:a9:29:83:f8:b2:14:e3:6e:28:
        87:44:c3:90:1a:de:38:a9:3c:ac:43:4d:64:45:ce:dd:28:a9:
        5c:f2:73:7b:04:f8:17:e8:ab:b1:f3:2e:5c:64:6e:73:31:3a:
        12:b8:bc:b3:11:e4:7d:8f:81:51:9a:3b:8d:89:f4:4d:93:66:
        7b:3c:03:ed:d3:9a:1d:9a:f3:65:50:f5:a0:d0:75:9f:2f:af:
        f0:ea:82:43:98:f8:69:9c:89:79:c4:43:8e:46:72:e3:64:36:
        12:af:f7:25:1e:38:89:90:77:7e:c3:6b:6a:b9:c3:cb:44:4b:
        ac:78:90:8b:e7:c7:2c:1e:4b:11:44:c8:34:52:27:cd:0a:5d:
        9f:85:c1:89:d5:1a:78:f2:95:10:53:32:dd:80:84:66:75:d9:
        b5:68:28:fb:61:2e:be:84:a8:38:c0:99:12:86:a5:1e:67:64:
        ad:06:2e:2f:a9:70:85:c7:96:0f:7c:89:65:f5:8e:43:54:0e:
        ab:dd:a5:80:39:94:60:c0:34:c9:96:70:2c:a3:12:f5:1f:48:
        7b:bd:1c:7e:6b:b7:9d:90:f4:22:3b:ae:f8:fc:2a:ca:fa:82:
        52:a0:ef:af:4b:55:93:eb:c1:b5:f0:22:8b:ac:34:4e:26:22:
        04:a1:87:2c:75:4a:b7:e5:7d:13:d7:b8:0c:64:c0:36:d2:c9:
        2f:86:12:8c:23:09:c1:1b:82:3b:73:49:a3:6a:57:87:94:e5:
        d6:78:c5:99:43:63:e3:4d:e0:77:2d:e1:65:99:72:69:04:1a:
        47:09:e6:0f:01:56:24:fb:1f:bf:0e:79:a9:58:2e:b9:c4:09:
        01:7e:95:ba:6d:00:06:3e:b2:ea:4a:10:39:d8:d0:2b:f5:bf:
        ec:75:bf:97:02:c5:09:1b:08:dc:55:37:e2:81:fb:37:84:43:
        62:20:ca:e7:56:4b:65:ea:fe:6c:c1:24:93:24:a1:34:eb:05:
        ff:9a:22:ae:9b:7d:3f:f1:65:51:0a:a6:30:6a:b3:f4:88:1c:
        80:0d:fc:72:8a:e8:83:5e', 'C188DB09BC6C467C789F957BB53390F27262D6C1362022245ECEE977F2430AA20664A4CC8E36F838E623F06E6DB13CDD72A3851CA1D33DB4332BD32FAFFEEAB0415967B6C4067D0A9E7485D6794C80377ADF39055259F7F41B4643A4D28585D2C371F3756234BA2C8A7F1E8FEEED34D011C796CD523DBA33D6DD4DDE0B3B4A4B9FC2262FFAB5161C723577CA3C5DE6CAE1268B1A36765C01DB741425FEEDB5A0880FDD78CA2D1F079730012D7279FA46D6132AA8B9A6AB83491DE5F2EFDDE4018E180A8F6353168562A90E193ACCB566A6C26B7407E42BE1763EB46DD8F644E173621F3BC4BEA05356256C5109F7AAABCABF76FD6D9BF39DDBBF3D66BC0C56AAAF9848953A4BDFA75850D93875A95BEA430C02FF99EBE86C4D705B29659CDDAA5DCCAF0131EC0CEBD28DE8EA9C7BE66EF727660C1A48D76E42E33FDE213E7BE10D70FB63AAA86C1A54B45C257AC9A2C98B16A6BB2C7E175E054D586E121D01EE12100DC6327F18FFFCF4FACD6E91E83649BE1A48698BC2964D1A12B26917C10A90D6FA792248BFBA7B69F870C7FA7A37D8D80DD2764F57FF90B7E391D2DDEFC260B7673ADDFEAA9CF0D48B7F7222CEC69F97B6F8AF8AA010A8D9FB18C6B6B55C523C89B6192A73010A0F03B31260F27A2F81DBA36EFF263097F58BDD8957B6AD3DB3AF2BC5B77602F0A5D62B9A86142A72F6E3338C5D094B13DFBB8C7413524B', '/C=IL/O=StartCom Ltd./OU=Secure Digital Certificate Signing/CN=StartCom Certification Authority', 'C=IL/O=StartCom Ltd./OU=Secure Digital Certificate Signing/CN=StartCom Certification Authority', '01', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', 'd067bb319513fa1f4aa3003e54440063');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=JP, O=SECOM Trust.net', 3, 1, 0, '2003-09-30 04:20:49', '2023-09-30 04:20:49', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=JP, O=SECOM Trust.net, OU=Security Communication RootCA1
        Validity
            Not Before: Sep 30 04:20:49 2003 GMT
            Not After : Sep 30 04:20:49 2023 GMT
        Subject: C=JP, O=SECOM Trust.net, OU=Security Communication RootCA1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b3:b3:fe:7f:d3:6d:b1:ef:16:7c:57:a5:0c:6d:
                    76:8a:2f:4b:bf:64:fb:4c:ee:8a:f0:f3:29:7c:f5:
                    ff:ee:2a:e0:e9:e9:ba:5b:64:22:9a:9a:6f:2c:3a:
                    26:69:51:05:99:26:dc:d5:1c:6a:71:c6:9a:7d:1e:
                    9d:dd:7c:6c:c6:8c:67:67:4a:3e:f8:71:b0:19:27:
                    a9:09:0c:a6:95:bf:4b:8c:0c:fa:55:98:3b:d8:e8:
                    22:a1:4b:71:38:79:ac:97:92:69:b3:89:7e:ea:21:
                    68:06:98:14:96:87:d2:61:36:bc:6d:27:56:9e:57:
                    ee:c0:c0:56:fd:32:cf:a4:d9:8e:c2:23:d7:8d:a8:
                    f3:d8:25:ac:97:e4:70:38:f4:b6:3a:b4:9d:3b:97:
                    26:43:a3:a1:bc:49:59:72:4c:23:30:87:01:58:f6:
                    4e:be:1c:68:56:66:af:cd:41:5d:c8:b3:4d:2a:55:
                    46:ab:1f:da:1e:e2:40:3d:db:cd:7d:b9:92:80:9c:
                    37:dd:0c:96:64:9d:dc:22:f7:64:8b:df:61:de:15:
                    94:52:15:a0:7d:52:c9:4b:a8:21:c9:c6:b1:ed:cb:
                    c3:95:60:d1:0f:f0:ab:70:f8:df:cb:4d:7e:ec:d6:
                    fa:ab:d9:bd:7f:54:f2:a5:e9:79:fa:d9:d6:76:24:
                    28:73
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                A0:73:49:99:68:DC:85:5B:65:E3:9B:28:2F:57:9F:BD:33:BC:07:48
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        68:40:a9:a8:bb:e4:4f:5d:79:b3:05:b5:17:b3:60:13:eb:c6:
        92:5d:e0:d1:d3:6a:fe:fb:be:9b:6d:bf:c7:05:6d:59:20:c4:
        1c:f0:b7:da:84:58:02:63:fa:48:16:ef:4f:a5:0b:f7:4a:98:
        f2:3f:9e:1b:ad:47:6b:63:ce:08:47:eb:52:3f:78:9c:af:4d:
        ae:f8:d5:4f:cf:9a:98:2a:10:41:39:52:c4:dd:d9:9b:0e:ef:
        93:01:ae:b2:2e:ca:68:42:24:42:6c:b0:b3:3a:3e:cd:e9:da:
        48:c4:15:cb:e9:f9:07:0f:92:50:49:8a:dd:31:97:5f:c9:e9:
        37:aa:3b:59:65:97:94:32:c9:b3:9f:3e:3a:62:58:c5:49:ad:
        62:0e:71:a5:32:aa:2f:c6:89:76:43:40:13:13:67:3d:a2:54:
        25:10:cb:f1:3a:f2:d9:fa:db:49:56:bb:a6:fe:a7:41:35:c3:
        e0:88:61:c9:88:c7:df:36:10:22:98:59:ea:b0:4a:fb:56:16:
        73:6e:ac:4d:f7:22:a1:4f:ad:1d:7a:2d:45:27:e5:30:c1:5e:
        f2:da:13:cb:25:42:51:95:47:03:8c:6c:21:cc:74:42:ed:53:
        ff:33:8b:8f:0f:57:01:16:2f:cf:a6:ee:c9:70:22:14:bd:fd:
        be:6c:0b:03', 'B3B3FE7FD36DB1EF167C57A50C6D768A2F4BBF64FB4CEE8AF0F3297CF5FFEE2AE0E9E9BA5B64229A9A6F2C3A266951059926DCD51C6A71C69A7D1E9DDD7C6CC68C67674A3EF871B01927A9090CA695BF4B8C0CFA55983BD8E822A14B713879AC979269B3897EEA21680698149687D26136BC6D27569E57EEC0C056FD32CFA4D98EC223D78DA8F3D825AC97E47038F4B63AB49D3B972643A3A1BC4959724C2330870158F64EBE1C685666AFCD415DC8B34D2A5546AB1FDA1EE2403DDBCD7DB992809C37DD0C96649DDC22F7648BDF61DE15945215A07D52C94BA821C9C6B1EDCBC39560D10FF0AB70F8DFCB4D7EECD6FAABD9BD7F54F2A5E979FAD9D676242873', '/C=JP/O=SECOM Trust.net/OU=Security Communication RootCA1', 'C=JP/O=SECOM Trust.net/OU=Security Communication RootCA1', '00', NULL, '-----BEGIN CERTIFICATE-----
MIIDWjCCAkKgAwIBAgIBADANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJKUDEY
MBYGA1UEChMPU0VDT00gVHJ1c3QubmV0MScwJQYDVQQLEx5TZWN1cml0eSBDb21t
dW5pY2F0aW9uIFJvb3RDQTEwHhcNMDMwOTMwMDQyMDQ5WhcNMjMwOTMwMDQyMDQ5
WjBQMQswCQYDVQQGEwJKUDEYMBYGA1UEChMPU0VDT00gVHJ1c3QubmV0MScwJQYD
VQQLEx5TZWN1cml0eSBDb21tdW5pY2F0aW9uIFJvb3RDQTEwggEiMA0GCSqGSIb3
DQEBAQUAA4IBDwAwggEKAoIBAQCzs/5/022x7xZ8V6UMbXaKL0u/ZPtM7orw8yl8
9f/uKuDp6bpbZCKamm8sOiZpUQWZJtzVHGpxxpp9Hp3dfGzGjGdnSj74cbAZJ6kJ
DKaVv0uMDPpVmDvY6CKhS3E4eayXkmmziX7qIWgGmBSWh9JhNrxtJ1aeV+7AwFb9
Ms+k2Y7CI9eNqPPYJayX5HA49LY6tJ07lyZDo6G8SVlyTCMwhwFY9k6+HGhWZq/N
QV3Is00qVUarH9oe4kA92819uZKAnDfdDJZkndwi92SL32HeFZRSFaB9UslLqCHJ
xrHty8OVYNEP8Ktw+N/LTX7s1vqr2b1/VPKl6Xn62dZ2JChzAgMBAAGjPzA9MB0G
A1UdDgQWBBSgc0mZaNyFW2XjmygvV5+9M7wHSDALBgNVHQ8EBAMCAQYwDwYDVR0T
AQH/BAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAaECpqLvkT115swW1F7NgE+vG
kl3g0dNq/vu+m22/xwVtWSDEHPC32oRYAmP6SBbvT6UL90qY8j+eG61Ha2POCEfr
Uj94nK9NrvjVT8+amCoQQTlSxN3Zmw7vkwGusi7KaEIkQmywszo+zenaSMQVy+n5
Bw+SUEmK3TGXX8npN6o7WWWXlDLJs58+OmJYxUmtYg5xpTKqL8aJdkNAExNnPaJU
JRDL8Try2frbSVa7pv6nQTXD4IhhyYjH3zYQIphZ6rBK+1YWc26sTfcioU+tHXot
RSflMMFe8toTyyVCUZVHA4xsIcx0Qu1T/zOLjw9XARYvz6buyXAiFL39vmwLAw==
-----END CERTIFICATE-----', '65e1b82ec98f06be99a3514c66f8b907');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=PL, O=Unizeto Sp. z o.o., CN=Certum CA', 3, 1, 0, '2002-06-11 10:46:39', '2027-06-11 10:46:39', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 65568 (0x10020)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=PL, O=Unizeto Sp. z o.o., CN=Certum CA
        Validity
            Not Before: Jun 11 10:46:39 2002 GMT
            Not After : Jun 11 10:46:39 2027 GMT
        Subject: C=PL, O=Unizeto Sp. z o.o., CN=Certum CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ce:b1:c1:2e:d3:4f:7c:cd:25:ce:18:3e:4f:c4:
                    8c:6f:80:6a:73:c8:5b:51:f8:9b:d2:dc:bb:00:5c:
                    b1:a0:fc:75:03:ee:81:f0:88:ee:23:52:e9:e6:15:
                    33:8d:ac:2d:09:c5:76:f9:2b:39:80:89:e4:97:4b:
                    90:a5:a8:78:f8:73:43:7b:a4:61:b0:d8:58:cc:e1:
                    6c:66:7e:9c:f3:09:5e:55:63:84:d5:a8:ef:f3:b1:
                    2e:30:68:b3:c4:3c:d8:ac:6e:8d:99:5a:90:4e:34:
                    dc:36:9a:8f:81:88:50:b7:6d:96:42:09:f3:d7:95:
                    83:0d:41:4b:b0:6a:6b:f8:fc:0f:7e:62:9f:67:c4:
                    ed:26:5f:10:26:0f:08:4f:f0:a4:57:28:ce:8f:b8:
                    ed:45:f6:6e:ee:25:5d:aa:6e:39:be:e4:93:2f:d9:
                    47:a0:72:eb:fa:a6:5b:af:ca:53:3f:e2:0e:c6:96:
                    56:11:6e:f7:e9:66:a9:26:d8:7f:95:53:ed:0a:85:
                    88:ba:4f:29:a5:42:8c:5e:b6:fc:85:20:00:aa:68:
                    0b:a1:1a:85:01:9c:c4:46:63:82:88:b6:22:b1:ee:
                    fe:aa:46:59:7e:cf:35:2c:d5:b6:da:5d:f7:48:33:
                    14:54:b6:eb:d9:6f:ce:cd:88:d6:ab:1b:da:96:3b:
                    1d:59
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        b8:8d:ce:ef:e7:14:ba:cf:ee:b0:44:92:6c:b4:39:3e:a2:84:
        6e:ad:b8:21:77:d2:d4:77:82:87:e6:20:41:81:ee:e2:f8:11:
        b7:63:d1:17:37:be:19:76:24:1c:04:1a:4c:eb:3d:aa:67:6f:
        2d:d4:cd:fe:65:31:70:c5:1b:a6:02:0a:ba:60:7b:6d:58:c2:
        9a:49:fe:63:32:0b:6b:e3:3a:c0:ac:ab:3b:b0:e8:d3:09:51:
        8c:10:83:c6:34:e0:c5:2b:e0:1a:b6:60:14:27:6c:32:77:8c:
        bc:b2:72:98:cf:cd:cc:3f:b9:c8:24:42:14:d6:57:fc:e6:26:
        43:a9:1d:e5:80:90:ce:03:54:28:3e:f7:3f:d3:f8:4d:ed:6a:
        0a:3a:93:13:9b:3b:14:23:13:63:9c:3f:d1:87:27:79:e5:4c:
        51:e3:01:ad:85:5d:1a:3b:b1:d5:73:10:a4:d3:f2:bc:6e:64:
        f5:5a:56:90:a8:c7:0e:4c:74:0f:2e:71:3b:f7:c8:47:f4:69:
        6f:15:f2:11:5e:83:1e:9c:7c:52:ae:fd:02:da:12:a8:59:67:
        18:db:bc:70:dd:9b:b1:69:ed:80:ce:89:40:48:6a:0e:35:ca:
        29:66:15:21:94:2c:e8:60:2a:9b:85:4a:40:f3:6b:8a:24:ec:
        06:16:2c:73', 'CEB1C12ED34F7CCD25CE183E4FC48C6F806A73C85B51F89BD2DCBB005CB1A0FC7503EE81F088EE2352E9E615338DAC2D09C576F92B398089E4974B90A5A878F873437BA461B0D858CCE16C667E9CF3095E556384D5A8EFF3B12E3068B3C43CD8AC6E8D995A904E34DC369A8F818850B76D964209F3D795830D414BB06A6BF8FC0F7E629F67C4ED265F10260F084FF0A45728CE8FB8ED45F66EEE255DAA6E39BEE4932FD947A072EBFAA65BAFCA533FE20EC69656116EF7E966A926D87F9553ED0A8588BA4F29A5428C5EB6FC852000AA680BA11A85019CC446638288B622B1EEFEAA46597ECF352CD5B6DA5DF748331454B6EBD96FCECD88D6AB1BDA963B1D59', '/C=PL/O=Unizeto Sp. z o.o./CN=Certum CA', 'C=PL/O=Unizeto Sp. z o.o./CN=Certum CA', '010020', NULL, '-----BEGIN CERTIFICATE-----
MIIDDDCCAfSgAwIBAgIDAQAgMA0GCSqGSIb3DQEBBQUAMD4xCzAJBgNVBAYTAlBM
MRswGQYDVQQKExJVbml6ZXRvIFNwLiB6IG8uby4xEjAQBgNVBAMTCUNlcnR1bSBD
QTAeFw0wMjA2MTExMDQ2MzlaFw0yNzA2MTExMDQ2MzlaMD4xCzAJBgNVBAYTAlBM
MRswGQYDVQQKExJVbml6ZXRvIFNwLiB6IG8uby4xEjAQBgNVBAMTCUNlcnR1bSBD
QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM6xwS7TT3zNJc4YPk/E
jG+AanPIW1H4m9LcuwBcsaD8dQPugfCI7iNS6eYVM42sLQnFdvkrOYCJ5JdLkKWo
ePhzQ3ukYbDYWMzhbGZ+nPMJXlVjhNWo7/OxLjBos8Q82KxujZlakE403Daaj4GI
ULdtlkIJ89eVgw1BS7Bqa/j8D35in2fE7SZfECYPCE/wpFcozo+47UX2bu4lXapu
Ob7kky/ZR6By6/qmW6/KUz/iDsaWVhFu9+lmqSbYf5VT7QqFiLpPKaVCjF62/IUg
AKpoC6EahQGcxEZjgoi2IrHu/qpGWX7PNSzVttpd90gzFFS269lvzs2I1qsb2pY7
HVkCAwEAAaMTMBEwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEA
uI3O7+cUus/usESSbLQ5PqKEbq24IXfS1HeCh+YgQYHu4vgRt2PRFze+GXYkHAQa
TOs9qmdvLdTN/mUxcMUbpgIKumB7bVjCmkn+YzILa+M6wKyrO7Do0wlRjBCDxjTg
xSvgGrZgFCdsMneMvLJymM/NzD+5yCRCFNZX/OYmQ6kd5YCQzgNUKD73P9P4Te1q
CjqTE5s7FCMTY5w/0YcneeVMUeMBrYVdGjux1XMQpNPyvG5k9VpWkKjHDkx0Dy5x
O/fIR/RpbxXyEV6DHpx8Uq79AtoSqFlnGNu8cN2bsWntgM6JQEhqDjXKKWYVIZQs
6GAqm4VKQPNriiTsBhYscw==
-----END CERTIFICATE-----','35610177afc9c64e70f1ce62c1885496');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=SE, O=AddTrust AB, CN=AddTrust Class 1 CA Root', 3, 1, 0, '2000-05-30 10:38:31', '2020-05-30 10:38:31', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=SE, O=AddTrust AB, OU=AddTrust TTP Network, CN=AddTrust Class 1 CA Root
        Validity
            Not Before: May 30 10:38:31 2000 GMT
            Not After : May 30 10:38:31 2020 GMT
        Subject: C=SE, O=AddTrust AB, OU=AddTrust TTP Network, CN=AddTrust Class 1 CA Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:96:96:d4:21:49:60:e2:6b:e8:41:07:0c:de:c4:
                    e0:dc:13:23:cd:c1:35:c7:fb:d6:4e:11:0a:67:5e:
                    f5:06:5b:6b:a5:08:3b:5b:29:16:3a:e7:87:b2:34:
                    06:c5:bc:05:a5:03:7c:82:cb:29:10:ae:e1:88:81:
                    bd:d6:9e:d3:fe:2d:56:c1:15:ce:e3:26:9d:15:2e:
                    10:fb:06:8f:30:04:de:a7:b4:63:b4:ff:b1:9c:ae:
                    3c:af:77:b6:56:c5:b5:ab:a2:e9:69:3a:3d:0e:33:
                    79:32:3f:70:82:92:99:61:6d:8d:30:08:8f:71:3f:
                    a6:48:57:19:f8:25:dc:4b:66:5c:a5:74:8f:98:ae:
                    c8:f9:c0:06:22:e7:ac:73:df:a5:2e:fb:52:dc:b1:
                    15:65:20:fa:35:66:69:de:df:2c:f1:6e:bc:30:db:
                    2c:24:12:db:eb:35:35:68:90:cb:00:b0:97:21:3d:
                    74:21:23:65:34:2b:bb:78:59:a3:d6:e1:76:39:9a:
                    a4:49:8e:8c:74:af:6e:a4:9a:a3:d9:9b:d2:38:5c:
                    9b:a2:18:cc:75:23:84:be:eb:e2:4d:33:71:8e:1a:
                    f0:c2:f8:c7:1d:a2:ad:03:97:2c:f8:cf:25:c6:f6:
                    b8:24:31:b1:63:5d:92:7f:63:f0:25:c9:53:2e:1f:
                    bf:4d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                95:B1:B4:F0:94:B6:BD:C7:DA:D1:11:09:21:BE:C1:AF:49:FD:10:7B
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:95:B1:B4:F0:94:B6:BD:C7:DA:D1:11:09:21:BE:C1:AF:49:FD:10:7B
                DirName:/C=SE/O=AddTrust AB/OU=AddTrust TTP Network/CN=AddTrust Class 1 CA Root
                serial:01

    Signature Algorithm: sha1WithRSAEncryption
        2c:6d:64:1b:1f:cd:0d:dd:b9:01:fa:96:63:34:32:48:47:99:
        ae:97:ed:fd:72:16:a6:73:47:5a:f4:eb:dd:e9:f5:d6:fb:45:
        cc:29:89:44:5d:bf:46:39:3d:e8:ee:bc:4d:54:86:1e:1d:6c:
        e3:17:27:43:e1:89:56:2b:a9:6f:72:4e:49:33:e3:72:7c:2a:
        23:9a:bc:3e:ff:28:2a:ed:a3:ff:1c:23:ba:43:57:09:67:4d:
        4b:62:06:2d:f8:ff:6c:9d:60:1e:d8:1c:4b:7d:b5:31:2f:d9:
        d0:7c:5d:f8:de:6b:83:18:78:37:57:2f:e8:33:07:67:df:1e:
        c7:6b:2a:95:76:ae:8f:57:a3:f0:f4:52:b4:a9:53:08:cf:e0:
        4f:d3:7a:53:8b:fd:bb:1c:56:36:f2:fe:b2:b6:e5:76:bb:d5:
        22:65:a7:3f:fe:d1:66:ad:0b:bc:6b:99:86:ef:3f:7d:f3:18:
        32:ca:7b:c6:e3:ab:64:46:95:f8:26:69:d9:55:83:7b:2c:96:
        07:ff:59:2c:44:a3:c6:e5:e9:a9:dc:a1:63:80:5a:21:5e:21:
        cf:53:54:f0:ba:6f:89:db:a8:aa:95:cf:8b:e3:71:cc:1e:1b:
        20:44:08:c0:7a:b6:40:fd:c4:e4:35:e1:1d:16:1c:d0:bc:2b:
        8e:d6:71:d9', '9696D4214960E26BE841070CDEC4E0DC1323CDC135C7FBD64E110A675EF5065B6BA5083B5B29163AE787B23406C5BC05A5037C82CB2910AEE18881BDD69ED3FE2D56C115CEE3269D152E10FB068F3004DEA7B463B4FFB19CAE3CAF77B656C5B5ABA2E9693A3D0E3379323F70829299616D8D30088F713FA6485719F825DC4B665CA5748F98AEC8F9C00622E7AC73DFA52EFB52DCB1156520FA356669DEDF2CF16EBC30DB2C2412DBEB35356890CB00B097213D74212365342BBB7859A3D6E176399AA4498E8C74AF6EA49AA3D99BD2385C9BA218CC752384BEEBE24D33718E1AF0C2F8C71DA2AD03972CF8CF25C6F6B82431B1635D927F63F025C9532E1FBF4D', '/C=SE/O=AddTrust AB/OU=AddTrust TTP Network/CN=AddTrust Class 1 CA Root', 'C=SE/O=AddTrust AB/OU=AddTrust TTP Network/CN=AddTrust Class 1 CA Root', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIEGDCCAwCgAwIBAgIBATANBgkqhkiG9w0BAQUFADBlMQswCQYDVQQGEwJTRTEU
MBIGA1UEChMLQWRkVHJ1c3QgQUIxHTAbBgNVBAsTFEFkZFRydXN0IFRUUCBOZXR3
b3JrMSEwHwYDVQQDExhBZGRUcnVzdCBDbGFzcyAxIENBIFJvb3QwHhcNMDAwNTMw
MTAzODMxWhcNMjAwNTMwMTAzODMxWjBlMQswCQYDVQQGEwJTRTEUMBIGA1UEChML
QWRkVHJ1c3QgQUIxHTAbBgNVBAsTFEFkZFRydXN0IFRUUCBOZXR3b3JrMSEwHwYD
VQQDExhBZGRUcnVzdCBDbGFzcyAxIENBIFJvb3QwggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQCWltQhSWDia+hBBwzexODcEyPNwTXH+9ZOEQpnXvUGW2ul
CDtbKRY654eyNAbFvAWlA3yCyykQruGIgb3WntP+LVbBFc7jJp0VLhD7Bo8wBN6n
tGO0/7Gcrjyvd7ZWxbWroulpOj0OM3kyP3CCkplhbY0wCI9xP6ZIVxn4JdxLZlyl
dI+Yrsj5wAYi56xz36Uu+1LcsRVlIPo1Zmne3yzxbrww2ywkEtvrNTVokMsAsJch
PXQhI2U0K7t4WaPW4XY5mqRJjox0r26kmqPZm9I4XJuiGMx1I4S+6+JNM3GOGvDC
+Mcdoq0Dlyz4zyXG9rgkMbFjXZJ/Y/AlyVMuH79NAgMBAAGjgdIwgc8wHQYDVR0O
BBYEFJWxtPCUtr3H2tERCSG+wa9J/RB7MAsGA1UdDwQEAwIBBjAPBgNVHRMBAf8E
BTADAQH/MIGPBgNVHSMEgYcwgYSAFJWxtPCUtr3H2tERCSG+wa9J/RB7oWmkZzBl
MQswCQYDVQQGEwJTRTEUMBIGA1UEChMLQWRkVHJ1c3QgQUIxHTAbBgNVBAsTFEFk
ZFRydXN0IFRUUCBOZXR3b3JrMSEwHwYDVQQDExhBZGRUcnVzdCBDbGFzcyAxIENB
IFJvb3SCAQEwDQYJKoZIhvcNAQEFBQADggEBACxtZBsfzQ3duQH6lmM0MkhHma6X
7f1yFqZzR1r0693p9db7RcwpiURdv0Y5PejuvE1Uhh4dbOMXJ0PhiVYrqW9yTkkz
43J8KiOavD7/KCrto/8cI7pDVwlnTUtiBi34/2ydYB7YHEt9tTEv2dB8Xfjea4MY
eDdXL+gzB2ffHsdrKpV2ro9Xo/D0UrSpUwjP4E/TelOL/bscVjby/rK25Xa71SJl
pz/+0WatC7xrmYbvP33zGDLKe8bjq2RGlfgmadlVg3sslgf/WSxEo8bl6ancoWOA
WiFeIc9TVPC6b4nbqKqVz4vjccweGyBECMB6tkD9xOQ14R0WHNC8K47Wcdk=
-----END CERTIFICATE-----', '895acb0f3722eba4276e25f4312d1b74');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=SE, O=AddTrust AB, CN=AddTrust External CA Root', 3, 1, 0, '2000-05-30 10:48:38', '2020-05-30 10:48:38', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=SE, O=AddTrust AB, OU=AddTrust External TTP Network, CN=AddTrust External CA Root
        Validity
            Not Before: May 30 10:48:38 2000 GMT
            Not After : May 30 10:48:38 2020 GMT
        Subject: C=SE, O=AddTrust AB, OU=AddTrust External TTP Network, CN=AddTrust External CA Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b7:f7:1a:33:e6:f2:00:04:2d:39:e0:4e:5b:ed:
                    1f:bc:6c:0f:cd:b5:fa:23:b6:ce:de:9b:11:33:97:
                    a4:29:4c:7d:93:9f:bd:4a:bc:93:ed:03:1a:e3:8f:
                    cf:e5:6d:50:5a:d6:97:29:94:5a:80:b0:49:7a:db:
                    2e:95:fd:b8:ca:bf:37:38:2d:1e:3e:91:41:ad:70:
                    56:c7:f0:4f:3f:e8:32:9e:74:ca:c8:90:54:e9:c6:
                    5f:0f:78:9d:9a:40:3c:0e:ac:61:aa:5e:14:8f:9e:
                    87:a1:6a:50:dc:d7:9a:4e:af:05:b3:a6:71:94:9c:
                    71:b3:50:60:0a:c7:13:9d:38:07:86:02:a8:e9:a8:
                    69:26:18:90:ab:4c:b0:4f:23:ab:3a:4f:84:d8:df:
                    ce:9f:e1:69:6f:bb:d7:42:d7:6b:44:e4:c7:ad:ee:
                    6d:41:5f:72:5a:71:08:37:b3:79:65:a4:59:a0:94:
                    37:f7:00:2f:0d:c2:92:72:da:d0:38:72:db:14:a8:
                    45:c4:5d:2a:7d:b7:b4:d6:c4:ee:ac:cd:13:44:b7:
                    c9:2b:dd:43:00:25:fa:61:b9:69:6a:58:23:11:b7:
                    a7:33:8f:56:75:59:f5:cd:29:d7:46:b7:0a:2b:65:
                    b6:d3:42:6f:15:b2:b8:7b:fb:ef:e9:5d:53:d5:34:
                    5a:27
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                AD:BD:98:7A:34:B4:26:F7:FA:C4:26:54:EF:03:BD:E0:24:CB:54:1A
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:AD:BD:98:7A:34:B4:26:F7:FA:C4:26:54:EF:03:BD:E0:24:CB:54:1A
                DirName:/C=SE/O=AddTrust AB/OU=AddTrust External TTP Network/CN=AddTrust External CA Root
                serial:01

    Signature Algorithm: sha1WithRSAEncryption
        b0:9b:e0:85:25:c2:d6:23:e2:0f:96:06:92:9d:41:98:9c:d9:
        84:79:81:d9:1e:5b:14:07:23:36:65:8f:b0:d8:77:bb:ac:41:
        6c:47:60:83:51:b0:f9:32:3d:e7:fc:f6:26:13:c7:80:16:a5:
        bf:5a:fc:87:cf:78:79:89:21:9a:e2:4c:07:0a:86:35:bc:f2:
        de:51:c4:d2:96:b7:dc:7e:4e:ee:70:fd:1c:39:eb:0c:02:51:
        14:2d:8e:bd:16:e0:c1:df:46:75:e7:24:ad:ec:f4:42:b4:85:
        93:70:10:67:ba:9d:06:35:4a:18:d3:2b:7a:cc:51:42:a1:7a:
        63:d1:e6:bb:a1:c5:2b:c2:36:be:13:0d:e6:bd:63:7e:79:7b:
        a7:09:0d:40:ab:6a:dd:8f:8a:c3:f6:f6:8c:1a:42:05:51:d4:
        45:f5:9f:a7:62:21:68:15:20:43:3c:99:e7:7c:bd:24:d8:a9:
        91:17:73:88:3f:56:1b:31:38:18:b4:71:0f:9a:cd:c8:0e:9e:
        8e:2e:1b:e1:8c:98:83:cb:1f:31:f1:44:4c:c6:04:73:49:76:
        60:0f:c7:f8:bd:17:80:6b:2e:e9:cc:4c:0e:5a:9a:79:0f:20:
        0a:2e:d5:9e:63:26:1e:55:92:94:d8:82:17:5a:7b:d0:bc:c7:
        8f:4e:86:04', 'B7F71A33E6F200042D39E04E5BED1FBC6C0FCDB5FA23B6CEDE9B113397A4294C7D939FBD4ABC93ED031AE38FCFE56D505AD69729945A80B0497ADB2E95FDB8CABF37382D1E3E9141AD7056C7F04F3FE8329E74CAC89054E9C65F0F789D9A403C0EAC61AA5E148F9E87A16A50DCD79A4EAF05B3A671949C71B350600AC7139D38078602A8E9A869261890AB4CB04F23AB3A4F84D8DFCE9FE1696FBBD742D76B44E4C7ADEE6D415F725A710837B37965A459A09437F7002F0DC29272DAD03872DB14A845C45D2A7DB7B4D6C4EEACCD1344B7C92BDD430025FA61B9696A582311B7A7338F567559F5CD29D746B70A2B65B6D3426F15B2B87BFBEFE95D53D5345A27', '/C=SE/O=AddTrust AB/OU=AddTrust External TTP Network/CN=AddTrust External CA Root', 'C=SE/O=AddTrust AB/OU=AddTrust External TTP Network/CN=AddTrust External CA Root', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIENjCCAx6gAwIBAgIBATANBgkqhkiG9w0BAQUFADBvMQswCQYDVQQGEwJTRTEU
MBIGA1UEChMLQWRkVHJ1c3QgQUIxJjAkBgNVBAsTHUFkZFRydXN0IEV4dGVybmFs
IFRUUCBOZXR3b3JrMSIwIAYDVQQDExlBZGRUcnVzdCBFeHRlcm5hbCBDQSBSb290
MB4XDTAwMDUzMDEwNDgzOFoXDTIwMDUzMDEwNDgzOFowbzELMAkGA1UEBhMCU0Ux
FDASBgNVBAoTC0FkZFRydXN0IEFCMSYwJAYDVQQLEx1BZGRUcnVzdCBFeHRlcm5h
bCBUVFAgTmV0d29yazEiMCAGA1UEAxMZQWRkVHJ1c3QgRXh0ZXJuYWwgQ0EgUm9v
dDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALf3GjPm8gAELTngTlvt
H7xsD821+iO2zt6bETOXpClMfZOfvUq8k+0DGuOPz+VtUFrWlymUWoCwSXrbLpX9
uMq/NzgtHj6RQa1wVsfwTz/oMp50ysiQVOnGXw94nZpAPA6sYapeFI+eh6FqUNzX
mk6vBbOmcZSccbNQYArHE504B4YCqOmoaSYYkKtMsE8jqzpPhNjfzp/haW+710LX
a0Tkx63ubUFfclpxCDezeWWkWaCUN/cALw3CknLa0Dhy2xSoRcRdKn23tNbE7qzN
E0S3ySvdQwAl+mG5aWpYIxG3pzOPVnVZ9c0p10a3CitlttNCbxWyuHv77+ldU9U0
WicCAwEAAaOB3DCB2TAdBgNVHQ4EFgQUrb2YejS0Jvf6xCZU7wO94CTLVBowCwYD
VR0PBAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wgZkGA1UdIwSBkTCBjoAUrb2YejS0
Jvf6xCZU7wO94CTLVBqhc6RxMG8xCzAJBgNVBAYTAlNFMRQwEgYDVQQKEwtBZGRU
cnVzdCBBQjEmMCQGA1UECxMdQWRkVHJ1c3QgRXh0ZXJuYWwgVFRQIE5ldHdvcmsx
IjAgBgNVBAMTGUFkZFRydXN0IEV4dGVybmFsIENBIFJvb3SCAQEwDQYJKoZIhvcN
AQEFBQADggEBALCb4IUlwtYj4g+WBpKdQZic2YR5gdkeWxQHIzZlj7DYd7usQWxH
YINRsPkyPef89iYTx4AWpb9a/IfPeHmJIZriTAcKhjW88t5RxNKWt9x+Tu5w/Rw5
6wwCURQtjr0W4MHfRnXnJK3s9EK0hZNwEGe6nQY1ShjTK3rMUUKhemPR5ruhxSvC
Nr4TDea9Y355e6cJDUCrat2PisP29owaQgVR1EX1n6diIWgVIEM8med8vSTYqZEX
c4g/VhsxOBi0cQ+azcgOno4uG+GMmIPLHzHxREzGBHNJdmAPx/i9F4BrLunMTA5a
mnkPIAou1Z5jJh5VkpTYghdae9C8x49OhgQ=
-----END CERTIFICATE-----', '51e14b4c734e450402ea2cf73f2aee0f');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=SE, O=AddTrust AB, CN=AddTrust Public CA Root', 3, 1, 0, '2000-05-30 10:41:50', '2020-05-30 10:41:50', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=SE, O=AddTrust AB, OU=AddTrust TTP Network, CN=AddTrust Public CA Root
        Validity
            Not Before: May 30 10:41:50 2000 GMT
            Not After : May 30 10:41:50 2020 GMT
        Subject: C=SE, O=AddTrust AB, OU=AddTrust TTP Network, CN=AddTrust Public CA Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:e9:1a:30:8f:83:88:14:c1:20:d8:3c:9b:8f:1b:
                    7e:03:74:bb:da:69:d3:46:a5:f8:8e:c2:0c:11:90:
                    51:a5:2f:66:54:40:55:ea:db:1f:4a:56:ee:9f:23:
                    6e:f4:39:cb:a1:b9:6f:f2:7e:f9:5d:87:26:61:9e:
                    1c:f8:e2:ec:a6:81:f8:21:c5:24:cc:11:0c:3f:db:
                    26:72:7a:c7:01:97:07:17:f9:d7:18:2c:30:7d:0e:
                    7a:1e:62:1e:c6:4b:c0:fd:7d:62:77:d3:44:1e:27:
                    f6:3f:4b:44:b3:b7:38:d9:39:1f:60:d5:51:92:73:
                    03:b4:00:69:e3:f3:14:4e:ee:d1:dc:09:cf:77:34:
                    46:50:b0:f8:11:f2:fe:38:79:f7:07:39:fe:51:92:
                    97:0b:5b:08:5f:34:86:01:ad:88:97:eb:66:cd:5e:
                    d1:ff:dc:7d:f2:84:da:ba:77:ad:dc:80:08:c7:a7:
                    87:d6:55:9f:97:6a:e8:c8:11:64:ba:e7:19:29:3f:
                    11:b3:78:90:84:20:52:5b:11:ef:78:d0:83:f6:d5:
                    48:90:d0:30:1c:cf:80:f9:60:fe:79:e4:88:f2:dd:
                    00:eb:94:45:eb:65:94:69:40:ba:c0:d5:b4:b8:ba:
                    7d:04:11:a8:eb:31:05:96:94:4e:58:21:8e:9f:d0:
                    60:fd
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                81:3E:37:D8:92:B0:1F:77:9F:5C:B4:AB:73:AA:E7:F6:34:60:2F:FA
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:81:3E:37:D8:92:B0:1F:77:9F:5C:B4:AB:73:AA:E7:F6:34:60:2F:FA
                DirName:/C=SE/O=AddTrust AB/OU=AddTrust TTP Network/CN=AddTrust Public CA Root
                serial:01

    Signature Algorithm: sha1WithRSAEncryption
        03:f7:15:4a:f8:24:da:23:56:16:93:76:dd:36:28:b9:ae:1b:
        b8:c3:f1:64:ba:20:18:78:95:29:27:57:05:bc:7c:2a:f4:b9:
        51:55:da:87:02:de:0f:16:17:31:f8:aa:79:2e:09:13:bb:af:
        b2:20:19:12:e5:93:f9:4b:f9:83:e8:44:d5:b2:41:25:bf:88:
        75:6f:ff:10:fc:4a:54:d0:5f:f0:fa:ef:36:73:7d:1b:36:45:
        c6:21:6d:b4:15:b8:4e:cf:9c:5c:a5:3d:5a:00:8e:06:e3:3c:
        6b:32:7b:f2:9f:f0:b6:fd:df:f0:28:18:48:f0:c6:bc:d0:bf:
        34:80:96:c2:4a:b1:6d:8e:c7:90:45:de:2f:67:ac:45:04:a3:
        7a:dc:55:92:c9:47:66:d8:1a:8c:c7:ed:9c:4e:9a:e0:12:bb:
        b5:6a:4c:84:e1:e1:22:0d:87:00:64:fe:8c:7d:62:39:65:a6:
        ef:42:b6:80:25:12:61:01:a8:24:13:70:00:11:26:5f:fa:35:
        50:c5:48:cc:06:47:e8:27:d8:70:8d:5f:64:e6:a1:44:26:5e:
        22:ec:92:cd:ff:42:9a:44:21:6d:5c:c5:e3:22:1d:5f:47:12:
        e7:ce:5f:5d:fa:d8:aa:b1:33:2d:d9:76:f2:4e:3a:33:0c:2b:
        b3:2d:90:06', 'E91A308F838814C120D83C9B8F1B7E0374BBDA69D346A5F88EC20C119051A52F66544055EADB1F4A56EE9F236EF439CBA1B96FF27EF95D8726619E1CF8E2ECA681F821C524CC110C3FDB26727AC701970717F9D7182C307D0E7A1E621EC64BC0FD7D6277D3441E27F63F4B44B3B738D9391F60D551927303B40069E3F3144EEED1DC09CF77344650B0F811F2FE3879F70739FE5192970B5B085F348601AD8897EB66CD5ED1FFDC7DF284DABA77ADDC8008C7A787D6559F976AE8C81164BAE719293F11B378908420525B11EF78D083F6D54890D0301CCF80F960FE79E488F2DD00EB9445EB65946940BAC0D5B4B8BA7D0411A8EB310596944E58218E9FD060FD', '/C=SE/O=AddTrust AB/OU=AddTrust TTP Network/CN=AddTrust Public CA Root', 'C=SE/O=AddTrust AB/OU=AddTrust TTP Network/CN=AddTrust Public CA Root', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIEFTCCAv2gAwIBAgIBATANBgkqhkiG9w0BAQUFADBkMQswCQYDVQQGEwJTRTEU
MBIGA1UEChMLQWRkVHJ1c3QgQUIxHTAbBgNVBAsTFEFkZFRydXN0IFRUUCBOZXR3
b3JrMSAwHgYDVQQDExdBZGRUcnVzdCBQdWJsaWMgQ0EgUm9vdDAeFw0wMDA1MzAx
MDQxNTBaFw0yMDA1MzAxMDQxNTBaMGQxCzAJBgNVBAYTAlNFMRQwEgYDVQQKEwtB
ZGRUcnVzdCBBQjEdMBsGA1UECxMUQWRkVHJ1c3QgVFRQIE5ldHdvcmsxIDAeBgNV
BAMTF0FkZFRydXN0IFB1YmxpYyBDQSBSb290MIIBIjANBgkqhkiG9w0BAQEFAAOC
AQ8AMIIBCgKCAQEA6Rowj4OIFMEg2Dybjxt+A3S72mnTRqX4jsIMEZBRpS9mVEBV
6tsfSlbunyNu9DnLoblv8n75XYcmYZ4c+OLspoH4IcUkzBEMP9smcnrHAZcHF/nX
GCwwfQ56HmIexkvA/X1id9NEHif2P0tEs7c42TkfYNVRknMDtABp4/MUTu7R3AnP
dzRGULD4EfL+OHn3Bzn+UZKXC1sIXzSGAa2Il+tmzV7R/9x98oTaunet3IAIx6eH
1lWfl2royBFkuucZKT8Rs3iQhCBSWxHveNCD9tVIkNAwHM+A+WD+eeSI8t0A65RF
62WUaUC6wNW0uLp9BBGo6zEFlpROWCGOn9Bg/QIDAQABo4HRMIHOMB0GA1UdDgQW
BBSBPjfYkrAfd59ctKtzquf2NGAv+jALBgNVHQ8EBAMCAQYwDwYDVR0TAQH/BAUw
AwEB/zCBjgYDVR0jBIGGMIGDgBSBPjfYkrAfd59ctKtzquf2NGAv+qFopGYwZDEL
MAkGA1UEBhMCU0UxFDASBgNVBAoTC0FkZFRydXN0IEFCMR0wGwYDVQQLExRBZGRU
cnVzdCBUVFAgTmV0d29yazEgMB4GA1UEAxMXQWRkVHJ1c3QgUHVibGljIENBIFJv
b3SCAQEwDQYJKoZIhvcNAQEFBQADggEBAAP3FUr4JNojVhaTdt02KLmuG7jD8WS6
IBh4lSknVwW8fCr0uVFV2ocC3g8WFzH4qnkuCRO7r7IgGRLlk/lL+YPoRNWyQSW/
iHVv/xD8SlTQX/D67zZzfRs2RcYhbbQVuE7PnFylPVoAjgbjPGsye/Kf8Lb93/Ao
GEjwxrzQvzSAlsJKsW2Ox5BF3i9nrEUEo3rcVZLJR2bYGozH7ZxOmuASu7VqTITh
4SINhwBk/ox9Yjllpu9CtoAlEmEBqCQTcAARJl/6NVDFSMwGR+gn2HCNX2TmoUQm
XiLsks3/QppEIW1cxeMiHV9HEufOX1362KqxMy3ZdvJOOjMMK7MtkAY=
-----END CERTIFICATE-----', 'e0a3a4ecbfc76649d2c9f4f0d2773565');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=SE, O=AddTrust AB, CN=AddTrust Qualified CA Root', 3, 1, 0, '2000-05-30 10:44:50', '2020-05-30 10:44:50', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=SE, O=AddTrust AB, OU=AddTrust TTP Network, CN=AddTrust Qualified CA Root
        Validity
            Not Before: May 30 10:44:50 2000 GMT
            Not After : May 30 10:44:50 2020 GMT
        Subject: C=SE, O=AddTrust AB, OU=AddTrust TTP Network, CN=AddTrust Qualified CA Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:e4:1e:9a:fe:dc:09:5a:87:a4:9f:47:be:11:5f:
                    af:84:34:db:62:3c:79:78:b7:e9:30:b5:ec:0c:1c:
                    2a:c4:16:ff:e0:ec:71:eb:8a:f5:11:6e:ed:4f:0d:
                    91:d2:12:18:2d:49:15:01:c2:a4:22:13:c7:11:64:
                    ff:22:12:9a:b9:8e:5c:2f:08:cf:71:6a:b3:67:01:
                    59:f1:5d:46:f3:b0:78:a5:f6:0e:42:7a:e3:7f:1b:
                    cc:d0:f0:b7:28:fd:2a:ea:9e:b3:b0:b9:04:aa:fd:
                    f6:c7:b4:b1:b8:2a:a0:fb:58:f1:19:a0:6f:70:25:
                    7e:3e:69:4a:7f:0f:22:d8:ef:ad:08:11:9a:29:99:
                    e1:aa:44:45:9a:12:5e:3e:9d:6d:52:fc:e7:a0:3d:
                    68:2f:f0:4b:70:7c:13:38:ad:bc:15:25:f1:d6:ce:
                    ab:a2:c0:31:d6:2f:9f:e0:ff:14:59:fc:84:93:d9:
                    87:7c:4c:54:13:eb:9f:d1:2d:11:f8:18:3a:3a:de:
                    25:d9:f7:d3:40:ed:a4:06:12:c4:3b:e1:91:c1:56:
                    35:f0:14:dc:65:36:09:6e:ab:a4:07:c7:35:d1:c2:
                    03:33:36:5b:75:26:6d:42:f1:12:6b:43:6f:4b:71:
                    94:fa:34:1d:ed:13:6e:ca:80:7f:98:2f:6c:b9:65:
                    d8:e9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                39:95:8B:62:8B:5C:C9:D4:80:BA:58:0F:97:3F:15:08:43:CC:98:A7
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:39:95:8B:62:8B:5C:C9:D4:80:BA:58:0F:97:3F:15:08:43:CC:98:A7
                DirName:/C=SE/O=AddTrust AB/OU=AddTrust TTP Network/CN=AddTrust Qualified CA Root
                serial:01

    Signature Algorithm: sha1WithRSAEncryption
        19:ab:75:ea:f8:8b:65:61:95:13:ba:69:04:ef:86:ca:13:a0:
        c7:aa:4f:64:1b:3f:18:f6:a8:2d:2c:55:8f:05:b7:30:ea:42:
        6a:1d:c0:25:51:2d:a7:bf:0c:b3:ed:ef:08:7f:6c:3c:46:1a:
        ea:18:43:df:76:cc:f9:66:86:9c:2c:68:f5:e9:17:f8:31:b3:
        18:c4:d6:48:7d:23:4c:68:c1:7e:bb:01:14:6f:c5:d9:6e:de:
        bb:04:42:6a:f8:f6:5c:7d:e5:da:fa:87:eb:0d:35:52:67:d0:
        9e:97:76:05:93:3f:95:c7:01:e6:69:55:38:7f:10:61:99:c9:
        e3:5f:a6:ca:3e:82:63:48:aa:e2:08:48:3e:aa:f2:b2:85:62:
        a6:b4:a7:d9:bd:37:9c:68:b5:2d:56:7d:b0:b7:3f:a0:b1:07:
        d6:e9:4f:dc:de:45:71:30:32:7f:1b:2e:09:f9:bf:52:a1:ee:
        c2:80:3e:06:5c:2e:55:40:c1:1b:f5:70:45:b0:dc:5d:fa:f6:
        72:5a:77:d2:63:cd:cf:58:89:00:42:63:3f:79:39:d0:44:b0:
        82:6e:41:19:e8:dd:e0:c1:88:5a:d1:1e:71:93:1f:24:30:74:
        e5:1e:a8:de:3c:27:37:7f:83:ae:9e:77:cf:f0:30:b1:ff:4b:
        99:e8:c6:a1', 'E41E9AFEDC095A87A49F47BE115FAF8434DB623C7978B7E930B5EC0C1C2AC416FFE0EC71EB8AF5116EED4F0D91D212182D491501C2A42213C71164FF22129AB98E5C2F08CF716AB3670159F15D46F3B078A5F60E427AE37F1BCCD0F0B728FD2AEA9EB3B0B904AAFDF6C7B4B1B82AA0FB58F119A06F70257E3E694A7F0F22D8EFAD08119A2999E1AA44459A125E3E9D6D52FCE7A03D682FF04B707C1338ADBC1525F1D6CEABA2C031D62F9FE0FF1459FC8493D9877C4C5413EB9FD12D11F8183A3ADE25D9F7D340EDA40612C43BE191C15635F014DC6536096EABA407C735D1C20333365B75266D42F1126B436F4B7194FA341DED136ECA807F982F6CB965D8E9', '/C=SE/O=AddTrust AB/OU=AddTrust TTP Network/CN=AddTrust Qualified CA Root', 'C=SE/O=AddTrust AB/OU=AddTrust TTP Network/CN=AddTrust Qualified CA Root', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIEHjCCAwagAwIBAgIBATANBgkqhkiG9w0BAQUFADBnMQswCQYDVQQGEwJTRTEU
MBIGA1UEChMLQWRkVHJ1c3QgQUIxHTAbBgNVBAsTFEFkZFRydXN0IFRUUCBOZXR3
b3JrMSMwIQYDVQQDExpBZGRUcnVzdCBRdWFsaWZpZWQgQ0EgUm9vdDAeFw0wMDA1
MzAxMDQ0NTBaFw0yMDA1MzAxMDQ0NTBaMGcxCzAJBgNVBAYTAlNFMRQwEgYDVQQK
EwtBZGRUcnVzdCBBQjEdMBsGA1UECxMUQWRkVHJ1c3QgVFRQIE5ldHdvcmsxIzAh
BgNVBAMTGkFkZFRydXN0IFF1YWxpZmllZCBDQSBSb290MIIBIjANBgkqhkiG9w0B
AQEFAAOCAQ8AMIIBCgKCAQEA5B6a/twJWoekn0e+EV+vhDTbYjx5eLfpMLXsDBwq
xBb/4Oxx64r1EW7tTw2R0hIYLUkVAcKkIhPHEWT/IhKauY5cLwjPcWqzZwFZ8V1G
87B4pfYOQnrjfxvM0PC3KP0q6p6zsLkEqv32x7SxuCqg+1jxGaBvcCV+PmlKfw8i
2O+tCBGaKZnhqkRFmhJePp1tUvznoD1oL/BLcHwTOK28FSXx1s6rosAx1i+f4P8U
WfyEk9mHfExUE+uf0S0R+Bg6Ot4l2ffTQO2kBhLEO+GRwVY18BTcZTYJbqukB8c1
0cIDMzZbdSZtQvESa0NvS3GU+jQd7RNuyoB/mC9suWXY6QIDAQABo4HUMIHRMB0G
A1UdDgQWBBQ5lYtii1zJ1IC6WA+XPxUIQ8yYpzALBgNVHQ8EBAMCAQYwDwYDVR0T
AQH/BAUwAwEB/zCBkQYDVR0jBIGJMIGGgBQ5lYtii1zJ1IC6WA+XPxUIQ8yYp6Fr
pGkwZzELMAkGA1UEBhMCU0UxFDASBgNVBAoTC0FkZFRydXN0IEFCMR0wGwYDVQQL
ExRBZGRUcnVzdCBUVFAgTmV0d29yazEjMCEGA1UEAxMaQWRkVHJ1c3QgUXVhbGlm
aWVkIENBIFJvb3SCAQEwDQYJKoZIhvcNAQEFBQADggEBABmrder4i2VhlRO6aQTv
hsoToMeqT2QbPxj2qC0sVY8FtzDqQmodwCVRLae/DLPt7wh/bDxGGuoYQ992zPlm
hpwsaPXpF/gxsxjE1kh9I0xowX67ARRvxdlu3rsEQmr49lx95dr6h+sNNVJn0J6X
dgWTP5XHAeZpVTh/EGGZyeNfpso+gmNIquIISD6q8rKFYqa0p9m9N5xotS1WfbC3
P6CxB9bpT9zeRXEwMn8bLgn5v1Kh7sKAPgZcLlVAwRv1cEWw3F369nJad9Jjzc9Y
iQBCYz95OdBEsIJuQRno3eDBiFrRHnGTHyQwdOUeqN48Jzd/g66ed8/wMLH/S5no
xqE=
-----END CERTIFICATE-----','bb09222cda1208b9c97d58cc6af4c62c');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=America Online Inc., CN=America Online Root Certification Authority 1', 3, 1, 0, '2002-05-28 06:00:00', '2037-11-19 20:43:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=America Online Inc., CN=America Online Root Certification Authority 1
        Validity
            Not Before: May 28 06:00:00 2002 GMT
            Not After : Nov 19 20:43:00 2037 GMT
        Subject: C=US, O=America Online Inc., CN=America Online Root Certification Authority 1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:a8:2f:e8:a4:69:06:03:47:c3:e9:2a:98:ff:19:
                    a2:70:9a:c6:50:b2:7e:a5:df:68:4d:1b:7c:0f:b6:
                    97:68:7d:2d:a6:8b:97:e9:64:86:c9:a3:ef:a0:86:
                    bf:60:65:9c:4b:54:88:c2:48:c5:4a:39:bf:14:e3:
                    59:55:e5:19:b4:74:c8:b4:05:39:5c:16:a5:e2:95:
                    05:e0:12:ae:59:8b:a2:33:68:58:1c:a6:d4:15:b7:
                    d8:9f:d7:dc:71:ab:7e:9a:bf:9b:8e:33:0f:22:fd:
                    1f:2e:e7:07:36:ef:62:39:c5:dd:cb:ba:25:14:23:
                    de:0c:c6:3d:3c:ce:82:08:e6:66:3e:da:51:3b:16:
                    3a:a3:05:7f:a0:dc:87:d5:9c:fc:72:a9:a0:7d:78:
                    e4:b7:31:55:1e:65:bb:d4:61:b0:21:60:ed:10:32:
                    72:c5:92:25:1e:f8:90:4a:18:78:47:df:7e:30:37:
                    3e:50:1b:db:1c:d3:6b:9a:86:53:07:b0:ef:ac:06:
                    78:f8:84:99:fe:21:8d:4c:80:b6:0c:82:f6:66:70:
                    79:1a:d3:4f:a3:cf:f1:cf:46:b0:4b:0f:3e:dd:88:
                    62:b8:8c:a9:09:28:3b:7a:c7:97:e1:1e:e5:f4:9f:
                    c0:c0:ae:24:a0:c8:a1:d9:0f:d6:7b:26:82:69:32:
                    3d:a7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                00:AD:D9:A3:F6:79:F6:6E:74:A9:7F:33:3D:81:17:D7:4C:CF:33:DE
            X509v3 Authority Key Identifier: 
                keyid:00:AD:D9:A3:F6:79:F6:6E:74:A9:7F:33:3D:81:17:D7:4C:CF:33:DE

            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        7c:8a:d1:1f:18:37:82:e0:b8:b0:a3:ed:56:95:c8:62:61:9c:
        05:a2:cd:c2:62:26:61:cd:10:16:d7:cc:b4:65:34:d0:11:8a:
        ad:a8:a9:05:66:ef:74:f3:6d:5f:9d:99:af:f6:8b:fb:eb:52:
        b2:05:98:a2:6f:2a:c5:54:bd:25:bd:5f:ae:c8:86:ea:46:2c:
        c1:b3:bd:c1:e9:49:70:18:16:97:08:13:8c:20:e0:1b:2e:3a:
        47:cb:1e:e4:00:30:95:5b:f4:45:a3:c0:1a:b0:01:4e:ab:bd:
        c0:23:6e:63:3f:80:4a:c5:07:ed:dc:e2:6f:c7:c1:62:f1:e3:
        72:d6:04:c8:74:67:0b:fa:88:ab:a1:01:c8:6f:f0:14:af:d2:
        99:cd:51:93:7e:ed:2e:38:c7:bd:ce:46:50:3d:72:e3:79:25:
        9d:9b:88:2b:10:20:dd:a5:b8:32:9f:8d:e0:29:df:21:74:86:
        82:db:2f:82:30:c6:c7:35:86:b3:f9:96:5f:46:db:0c:45:fd:
        f3:50:c3:6f:c6:c3:48:ad:46:a6:e1:27:47:0a:1d:0e:9b:b6:
        c2:77:7f:63:f2:e0:7d:1a:be:fc:e0:df:d7:c7:a7:6c:b0:f9:
        ae:ba:3c:fd:74:b4:11:e8:58:0d:80:bc:d3:a8:80:3a:99:ed:
        75:cc:46:7b', 'A82FE8A469060347C3E92A98FF19A2709AC650B27EA5DF684D1B7C0FB697687D2DA68B97E96486C9A3EFA086BF60659C4B5488C248C54A39BF14E35955E519B474C8B405395C16A5E29505E012AE598BA23368581CA6D415B7D89FD7DC71AB7E9ABF9B8E330F22FD1F2EE70736EF6239C5DDCBBA251423DE0CC63D3CCE8208E6663EDA513B163AA3057FA0DC87D59CFC72A9A07D78E4B731551E65BBD461B02160ED103272C592251EF8904A187847DF7E30373E501BDB1CD36B9A865307B0EFAC0678F88499FE218D4C80B60C82F66670791AD34FA3CFF1CF46B04B0F3EDD8862B88CA909283B7AC797E11EE5F49FC0C0AE24A0C8A1D90FD67B268269323DA7', '/C=US/O=America Online Inc./CN=America Online Root Certification Authority 1', 'C=US/O=America Online Inc./CN=America Online Root Certification Authority 1', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIDpDCCAoygAwIBAgIBATANBgkqhkiG9w0BAQUFADBjMQswCQYDVQQGEwJVUzEc
MBoGA1UEChMTQW1lcmljYSBPbmxpbmUgSW5jLjE2MDQGA1UEAxMtQW1lcmljYSBP
bmxpbmUgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAxMB4XDTAyMDUyODA2
MDAwMFoXDTM3MTExOTIwNDMwMFowYzELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0Ft
ZXJpY2EgT25saW5lIEluYy4xNjA0BgNVBAMTLUFtZXJpY2EgT25saW5lIFJvb3Qg
Q2VydGlmaWNhdGlvbiBBdXRob3JpdHkgMTCCASIwDQYJKoZIhvcNAQEBBQADggEP
ADCCAQoCggEBAKgv6KRpBgNHw+kqmP8ZonCaxlCyfqXfaE0bfA+2l2h9LaaLl+lk
hsmj76CGv2BlnEtUiMJIxUo5vxTjWVXlGbR0yLQFOVwWpeKVBeASrlmLojNoWBym
1BW32J/X3HGrfpq/m44zDyL9Hy7nBzbvYjnF3cu6JRQj3gzGPTzOggjmZj7aUTsW
OqMFf6Dch9Wc/HKpoH145LcxVR5lu9RhsCFg7RAycsWSJR74kEoYeEfffjA3PlAb
2xzTa5qGUwew76wGePiEmf4hjUyAtgyC9mZweRrTT6PP8c9GsEsPPt2IYriMqQko
O3rHl+Ee5fSfwMCuJKDIodkP1nsmgmkyPacCAwEAAaNjMGEwDwYDVR0TAQH/BAUw
AwEB/zAdBgNVHQ4EFgQUAK3Zo/Z59m50qX8zPYEX10zPM94wHwYDVR0jBBgwFoAU
AK3Zo/Z59m50qX8zPYEX10zPM94wDgYDVR0PAQH/BAQDAgGGMA0GCSqGSIb3DQEB
BQUAA4IBAQB8itEfGDeC4Liwo+1WlchiYZwFos3CYiZhzRAW18y0ZTTQEYqtqKkF
Zu90821fnZmv9ov761KyBZiibyrFVL0lvV+uyIbqRizBs73B6UlwGBaXCBOMIOAb
LjpHyx7kADCVW/RFo8AasAFOq73AI25jP4BKxQft3OJvx8Fi8eNy1gTIdGcL+oir
oQHIb/AUr9KZzVGTfu0uOMe9zkZQPXLjeSWdm4grECDdpbgyn43gKd8hdIaC2y+C
MMbHNYaz+ZZfRtsMRf3zUMNvxsNIrUam4SdHCh0Om7bCd39j8uB9Gr784N/Xx6ds
sPmuujz9dLQR6FgNgLzTqIA6me11zEZ7
-----END CERTIFICATE-----', 'cd48fafdf6ec378b6b8cfccc2df13022');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=America Online Inc., CN=America Online Root Certification Authority 2', 3, 1, 0, '2002-05-28 06:00:00', '2037-09-29 14:08:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=America Online Inc., CN=America Online Root Certification Authority 2
        Validity
            Not Before: May 28 06:00:00 2002 GMT
            Not After : Sep 29 14:08:00 2037 GMT
        Subject: C=US, O=America Online Inc., CN=America Online Root Certification Authority 2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (4096 bit)
                Modulus (4096 bit):
                    00:cc:41:45:1d:e9:3d:4d:10:f6:8c:b1:41:c9:e0:
                    5e:cb:0d:b7:bf:47:73:d3:f0:55:4d:dd:c6:0c:fa:
                    b1:66:05:6a:cd:78:b4:dc:02:db:4e:81:f3:d7:a7:
                    7c:71:bc:75:63:a0:5d:e3:07:0c:48:ec:25:c4:03:
                    20:f4:ff:0e:3b:12:ff:9b:8d:e1:c6:d5:1b:b4:6d:
                    22:e3:b1:db:7f:21:64:af:86:bc:57:22:2a:d6:47:
                    81:57:44:82:56:53:bd:86:14:01:0b:fc:7f:74:a4:
                    5a:ae:f1:ba:11:b5:9b:58:5a:80:b4:37:78:09:33:
                    7c:32:47:03:5c:c4:a5:83:48:f4:57:56:6e:81:36:
                    27:18:4f:ec:9b:28:c2:d4:b4:d7:7c:0c:3e:0c:2b:
                    df:ca:04:d7:c6:8e:ea:58:4e:a8:a4:a5:18:1c:6c:
                    45:98:a3:41:d1:2d:d2:c7:6d:8d:19:f1:ad:79:b7:
                    81:3f:bd:06:82:27:2d:10:58:05:b5:78:05:b9:2f:
                    db:0c:6b:90:90:7e:14:59:38:bb:94:24:13:e5:d1:
                    9d:14:df:d3:82:4d:46:f0:80:39:52:32:0f:e3:84:
                    b2:7a:43:f2:5e:de:5f:3f:1d:dd:e3:b2:1b:a0:a1:
                    2a:23:03:6e:2e:01:15:87:5c:a6:75:75:c7:97:61:
                    be:de:86:dc:d4:48:db:bd:2a:bf:4a:55:da:e8:7d:
                    50:fb:b4:80:17:b8:94:bf:01:3d:ea:da:ba:7c:e0:
                    58:67:17:b9:58:e0:88:86:46:67:6c:9d:10:47:58:
                    32:d0:35:7c:79:2a:90:a2:5a:10:11:23:35:ad:2f:
                    cc:e4:4a:5b:a7:c8:27:f2:83:de:5e:bb:5e:77:e7:
                    e8:a5:6e:63:c2:0d:5d:61:d0:8c:d2:6c:5a:21:0e:
                    ca:28:a3:ce:2a:e9:95:c7:48:cf:96:6f:1d:92:25:
                    c8:c6:c6:c1:c1:0c:05:ac:26:c4:d2:75:d2:e1:2a:
                    67:c0:3d:5b:a5:9a:eb:cf:7b:1a:a8:9d:14:45:e5:
                    0f:a0:9a:65:de:2f:28:bd:ce:6f:94:66:83:48:29:
                    d8:ea:65:8c:af:93:d9:64:9f:55:57:26:bf:6f:cb:
                    37:31:99:a3:60:bb:1c:ad:89:34:32:62:b8:43:21:
                    06:72:0c:a1:5c:6d:46:c5:fa:29:cf:30:de:89:dc:
                    71:5b:dd:b6:37:3e:df:50:f5:b8:07:25:26:e5:bc:
                    b5:fe:3c:02:b3:b7:f8:be:43:c1:87:11:94:9e:23:
                    6c:17:8a:b8:8a:27:0c:54:47:f0:a9:b3:c0:80:8c:
                    a0:27:eb:1d:19:e3:07:8e:77:70:ca:2b:f4:7d:76:
                    e0:78:67
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                4D:45:C1:68:38:BB:73:A9:69:A1:20:E7:ED:F5:22:A1:23:14:D7:9E
            X509v3 Authority Key Identifier: 
                keyid:4D:45:C1:68:38:BB:73:A9:69:A1:20:E7:ED:F5:22:A1:23:14:D7:9E

            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        67:6b:06:b9:5f:45:3b:2a:4b:33:b3:e6:1b:6b:59:4e:22:cc:
        b9:b7:a4:25:c9:a7:c4:f0:54:96:0b:64:f3:b1:58:4f:5e:51:
        fc:b2:97:7b:27:65:c2:e5:ca:e7:0d:0c:25:7b:62:e3:fa:9f:
        b4:87:b7:45:46:af:83:a5:97:48:8c:a5:bd:f1:16:2b:9b:76:
        2c:7a:35:60:6c:11:80:97:cc:a9:92:52:e6:2b:e6:69:ed:a9:
        f8:36:2d:2c:77:bf:61:48:d1:63:0b:b9:5b:52:ed:18:b0:43:
        42:22:a6:b1:77:ae:de:69:c5:cd:c7:1c:a1:b1:a5:1c:10:fb:
        18:be:1a:70:dd:c1:92:4b:be:29:5a:9d:3f:35:be:e5:7d:51:
        f8:55:e0:25:75:23:87:1e:5c:dc:ba:9d:b0:ac:b3:69:db:17:
        83:c9:f7:de:0c:bc:08:dc:91:9e:a8:d0:d7:15:37:73:a5:35:
        b8:fc:7e:c5:44:40:06:c3:eb:f8:22:80:5c:47:ce:02:e3:11:
        9f:44:ff:fd:9a:32:cc:7d:64:51:0e:eb:57:26:76:3a:e3:1e:
        22:3c:c2:a6:36:dd:19:ef:a7:fc:12:f3:26:c0:59:31:85:4c:
        9c:d8:cf:df:a4:cc:cc:29:93:ff:94:6d:76:5c:13:08:97:f2:
        ed:a5:0b:4d:dd:e8:c9:68:0e:66:d3:00:0e:33:12:5b:bc:95:
        e5:32:90:a8:b3:c6:6c:83:ad:77:ee:8b:7e:7e:b1:a9:ab:d3:
        e1:f1:b6:c0:b1:ea:88:c0:e7:d3:90:e9:28:92:94:7b:68:7b:
        97:2a:0a:67:2d:85:02:38:10:e4:03:61:d4:da:25:36:c7:08:
        58:2d:a1:a7:51:af:30:0a:49:f5:a6:69:87:07:2d:44:46:76:
        8e:2a:e5:9a:3b:d7:18:a2:fc:9c:38:10:cc:c6:3b:d2:b5:17:
        3a:6f:fd:ae:25:bd:f5:72:59:64:b1:74:2a:38:5f:18:4c:df:
        cf:71:04:5a:36:d4:bf:2f:99:9c:e8:d9:ba:b1:95:e6:02:4b:
        21:a1:5b:d5:c1:4f:8f:ae:69:6d:53:db:01:93:b5:5c:1e:18:
        dd:64:5a:ca:18:28:3e:63:04:11:fd:1c:8d:00:0f:b8:37:df:
        67:8a:9d:66:a9:02:6a:91:ff:13:ca:2f:5d:83:bc:87:93:6c:
        dc:24:51:16:04:25:66:fa:b3:d9:c2:ba:29:be:9a:48:38:82:
        99:f4:bf:3b:4a:31:19:f9:bf:8e:21:33:14:ca:4f:54:5f:fb:
        ce:fb:8f:71:7f:fd:5e:19:a0:0f:4b:91:b8:c4:54:bc:06:b0:
        45:8f:26:91:a2:8e:fe:a9', 'CC41451DE93D4D10F68CB141C9E05ECB0DB7BF4773D3F0554DDDC60CFAB166056ACD78B4DC02DB4E81F3D7A77C71BC7563A05DE3070C48EC25C40320F4FF0E3B12FF9B8DE1C6D51BB46D22E3B1DB7F2164AF86BC57222AD647815744825653BD8614010BFC7F74A45AAEF1BA11B59B585A80B4377809337C3247035CC4A58348F457566E813627184FEC9B28C2D4B4D77C0C3E0C2BDFCA04D7C68EEA584EA8A4A5181C6C4598A341D12DD2C76D8D19F1AD79B7813FBD0682272D105805B57805B92FDB0C6B90907E145938BB942413E5D19D14DFD3824D46F0803952320FE384B27A43F25EDE5F3F1DDDE3B21BA0A12A23036E2E0115875CA67575C79761BEDE86DCD448DBBD2ABF4A55DAE87D50FBB48017B894BF013DEADABA7CE0586717B958E0888646676C9D10475832D0357C792A90A25A10112335AD2FCCE44A5BA7C827F283DE5EBB5E77E7E8A56E63C20D5D61D08CD26C5A210ECA28A3CE2AE995C748CF966F1D9225C8C6C6C1C10C05AC26C4D275D2E12A67C03D5BA59AEBCF7B1AA89D1445E50FA09A65DE2F28BDCE6F9466834829D8EA658CAF93D9649F555726BF6FCB373199A360BB1CAD89343262B8432106720CA15C6D46C5FA29CF30DE89DC715BDDB6373EDF50F5B8072526E5BCB5FE3C02B3B7F8BE43C18711949E236C178AB88A270C5447F0A9B3C0808CA027EB1D19E3078E7770CA2BF47D76E07867', '/C=US/O=America Online Inc./CN=America Online Root Certification Authority 2', 'C=US/O=America Online Inc./CN=America Online Root Certification Authority 2', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIFpDCCA4ygAwIBAgIBATANBgkqhkiG9w0BAQUFADBjMQswCQYDVQQGEwJVUzEc
MBoGA1UEChMTQW1lcmljYSBPbmxpbmUgSW5jLjE2MDQGA1UEAxMtQW1lcmljYSBP
bmxpbmUgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAyMB4XDTAyMDUyODA2
MDAwMFoXDTM3MDkyOTE0MDgwMFowYzELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0Ft
ZXJpY2EgT25saW5lIEluYy4xNjA0BgNVBAMTLUFtZXJpY2EgT25saW5lIFJvb3Qg
Q2VydGlmaWNhdGlvbiBBdXRob3JpdHkgMjCCAiIwDQYJKoZIhvcNAQEBBQADggIP
ADCCAgoCggIBAMxBRR3pPU0Q9oyxQcngXssNt79Hc9PwVU3dxgz6sWYFas14tNwC
206B89enfHG8dWOgXeMHDEjsJcQDIPT/DjsS/5uN4cbVG7RtIuOx238hZK+GvFci
KtZHgVdEglZTvYYUAQv8f3SkWq7xuhG1m1hagLQ3eAkzfDJHA1zEpYNI9FdWboE2
JxhP7JsowtS013wMPgwr38oE18aO6lhOqKSlGBxsRZijQdEt0sdtjRnxrXm3gT+9
BoInLRBYBbV4Bbkv2wxrkJB+FFk4u5QkE+XRnRTf04JNRvCAOVIyD+OEsnpD8l7e
Xz8d3eOyG6ChKiMDbi4BFYdcpnV1x5dhvt6G3NRI270qv0pV2uh9UPu0gBe4lL8B
PeraunzgWGcXuVjgiIZGZ2ydEEdYMtA1fHkqkKJaEBEjNa0vzORKW6fIJ/KD3l67
Xnfn6KVuY8INXWHQjNJsWiEOyiijzirplcdIz5ZvHZIlyMbGwcEMBawmxNJ10uEq
Z8A9W6Wa6897GqidFEXlD6CaZd4vKL3Ob5Rmg0gp2OpljK+T2WSfVVcmv2/LNzGZ
o2C7HK2JNDJiuEMhBnIMoVxtRsX6Kc8w3onccVvdtjc+31D1uAclJuW8tf48ArO3
+L5DwYcRlJ4jbBeKuIonDFRH8KmzwICMoCfrHRnjB453cMor9H124HhnAgMBAAGj
YzBhMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFE1FwWg4u3OpaaEg5+31IqEj
FNeeMB8GA1UdIwQYMBaAFE1FwWg4u3OpaaEg5+31IqEjFNeeMA4GA1UdDwEB/wQE
AwIBhjANBgkqhkiG9w0BAQUFAAOCAgEAZ2sGuV9FOypLM7PmG2tZTiLMubekJcmn
xPBUlgtk87FYT15R/LKXeydlwuXK5w0MJXti4/qftIe3RUavg6WXSIylvfEWK5t2
LHo1YGwRgJfMqZJS5ivmae2p+DYtLHe/YUjRYwu5W1LtGLBDQiKmsXeu3mnFzccc
obGlHBD7GL4acN3Bkku+KVqdPzW+5X1R+FXgJXUjhx5c3LqdsKyzadsXg8n33gy8
CNyRnqjQ1xU3c6U1uPx+xURABsPr+CKAXEfOAuMRn0T//ZoyzH1kUQ7rVyZ2OuMe
IjzCpjbdGe+n/BLzJsBZMYVMnNjP36TMzCmT/5RtdlwTCJfy7aULTd3oyWgOZtMA
DjMSW7yV5TKQqLPGbIOtd+6Lfn6xqavT4fG2wLHqiMDn05DpKJKUe2h7lyoKZy2F
AjgQ5ANh1NolNscIWC2hp1GvMApJ9aZphwctREZ2jirlmjvXGKL8nDgQzMY70rUX
Om/9riW99XJZZLF0KjhfGEzfz3EEWjbUvy+ZnOjZurGV5gJLIaFb1cFPj65pbVPb
AZO1XB4Y3WRayhgoPmMEEf0cjQAPuDffZ4qdZqkCapH/E8ovXYO8h5Ns3CRRFgQl
Zvqz2cK6Kb6aSDiCmfS/O0oxGfm/jiEzFMpPVF/7zvuPcX/9XhmgD0uRuMRUvAaw
RY8mkaKO/qk=
-----END CERTIFICATE-----', '904082017a22f4e72b6268962b565909');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=AOL Time Warner Inc., CN=AOL Time Warner Root Certification Authority 1', 3, 1, 0, '2002-05-29 06:00:00', '2037-11-20 15:03:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=AOL Time Warner Inc., OU=America Online Inc., CN=AOL Time Warner Root Certification Authority 1
        Validity
            Not Before: May 29 06:00:00 2002 GMT
            Not After : Nov 20 15:03:00 2037 GMT
        Subject: C=US, O=AOL Time Warner Inc., OU=America Online Inc., CN=AOL Time Warner Root Certification Authority 1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:99:de:8f:c3:25:a3:69:34:e8:05:f7:74:b9:bf:
                    5a:97:19:b9:2f:94:d2:93:e5:2d:89:ca:84:7c:3f:
                    10:43:1b:8c:8b:7c:84:58:f8:24:7c:48:cf:2a:fd:
                    c0:15:d9:18:7e:84:1a:17:d3:db:9e:d7:ca:e4:d9:
                    d7:aa:58:51:87:f0:f0:8b:48:4e:e2:c2:c4:59:69:
                    30:62:b6:30:a2:8c:0b:11:99:61:35:6d:7e:ef:c5:
                    b1:19:06:20:12:8e:42:e1:df:0f:96:10:52:a8:cf:
                    9c:5f:95:14:d8:af:3b:75:0b:31:20:1f:44:2f:a2:
                    62:41:b3:bb:18:21:db:ca:71:3c:8c:ec:b6:b9:0d:
                    9f:ef:51:ef:4d:7b:12:f2:0b:0c:e1:ac:40:8f:77:
                    7f:b0:ca:78:71:0c:5d:16:71:70:a2:d7:c2:3a:85:
                    cd:0e:9a:c4:e0:00:b0:d5:25:ea:dc:2b:e4:94:2d:
                    38:9c:89:41:57:64:28:65:19:1c:b6:44:b4:c8:31:
                    6b:8e:01:7b:76:59:25:7f:15:1c:84:08:7c:73:65:
                    20:0a:a1:04:2e:1a:32:a8:9a:20:b1:9c:2c:21:59:
                    e7:fb:cf:ee:70:2d:08:ca:63:3e:2c:9b:93:19:6a:
                    a4:c2:97:ff:b7:86:57:88:85:6c:9e:15:16:2b:4d:
                    2c:b3
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                A1:36:30:16:CB:86:90:00:45:80:53:B1:8F:C8:D8:3D:7C:BE:5F:12
            X509v3 Authority Key Identifier: 
                keyid:A1:36:30:16:CB:86:90:00:45:80:53:B1:8F:C8:D8:3D:7C:BE:5F:12

            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        8a:20:18:a5:be:b3:2f:b4:a6:84:00:40:30:29:fa:b4:14:73:
        4c:79:45:a7:f6:70:e0:e8:7e:64:1e:0a:95:7c:6a:61:c2:ef:
        4e:1f:be:ff:c9:99:1f:07:61:4a:e1:5d:4c:cd:ad:ee:d0:52:
        32:d9:59:32:bc:da:79:72:d6:7b:09:e8:02:81:35:d3:0a:df:
        11:1d:c9:79:a0:80:4d:fe:5a:d7:56:d6:ed:0f:2a:af:a7:18:
        75:33:0c:ea:c1:61:05:4f:6a:9a:89:f2:8d:b9:9f:2e:ef:b0:
        5f:5a:00:eb:be:ad:a0:f8:44:05:67:bc:cb:04:ef:9e:64:c5:
        e9:c8:3f:05:bf:c6:2f:07:1c:c3:36:71:86:ca:38:66:4a:cd:
        d6:b8:4b:c6:6c:a7:97:3b:fa:13:2d:6e:23:61:87:a1:63:42:
        ac:c2:cb:97:9f:61:68:cf:2d:4c:04:9d:d7:25:4f:0a:0e:4d:
        90:8b:18:56:a8:93:48:57:dc:6f:ae:bd:9e:67:57:77:89:50:
        b3:be:11:9b:45:67:83:86:19:87:d3:98:bd:08:1a:16:1f:58:
        82:0b:e1:96:69:05:4b:8e:ec:83:51:31:07:d5:d4:9f:ff:59:
        7b:a8:6e:85:cf:d3:4b:a9:49:b0:5f:b0:39:28:68:0e:73:dd:
        25:9a:de:12', '99DE8FC325A36934E805F774B9BF5A9719B92F94D293E52D89CA847C3F10431B8C8B7C8458F8247C48CF2AFDC015D9187E841A17D3DB9ED7CAE4D9D7AA585187F0F08B484EE2C2C459693062B630A28C0B119961356D7EEFC5B1190620128E42E1DF0F961052A8CF9C5F9514D8AF3B750B31201F442FA26241B3BB1821DBCA713C8CECB6B90D9FEF51EF4D7B12F20B0CE1AC408F777FB0CA78710C5D167170A2D7C23A85CD0E9AC4E000B0D525EADC2BE4942D389C894157642865191CB644B4C8316B8E017B7659257F151C84087C7365200AA1042E1A32A89A20B19C2C2159E7FBCFEE702D08CA633E2C9B93196AA4C297FFB7865788856C9E15162B4D2CB3', '/C=US/O=AOL Time Warner Inc./OU=America Online Inc./CN=AOL Time Warner Root Certification Authority 1', 'C=US/O=AOL Time Warner Inc./OU=America Online Inc./CN=AOL Time Warner Root Certification Authority 1', '01', NULL, '-----BEGIN CERTIFICATE-----
MIID5jCCAs6gAwIBAgIBATANBgkqhkiG9w0BAQUFADCBgzELMAkGA1UEBhMCVVMx
HTAbBgNVBAoTFEFPTCBUaW1lIFdhcm5lciBJbmMuMRwwGgYDVQQLExNBbWVyaWNh
IE9ubGluZSBJbmMuMTcwNQYDVQQDEy5BT0wgVGltZSBXYXJuZXIgUm9vdCBDZXJ0
aWZpY2F0aW9uIEF1dGhvcml0eSAxMB4XDTAyMDUyOTA2MDAwMFoXDTM3MTEyMDE1
MDMwMFowgYMxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRBT0wgVGltZSBXYXJuZXIg
SW5jLjEcMBoGA1UECxMTQW1lcmljYSBPbmxpbmUgSW5jLjE3MDUGA1UEAxMuQU9M
IFRpbWUgV2FybmVyIFJvb3QgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgMTCCASIw
DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJnej8Mlo2k06AX3dLm/WpcZuS+U
0pPlLYnKhHw/EEMbjIt8hFj4JHxIzyr9wBXZGH6EGhfT257XyuTZ16pYUYfw8ItI
TuLCxFlpMGK2MKKMCxGZYTVtfu/FsRkGIBKOQuHfD5YQUqjPnF+VFNivO3ULMSAf
RC+iYkGzuxgh28pxPIzstrkNn+9R7017EvILDOGsQI93f7DKeHEMXRZxcKLXwjqF
zQ6axOAAsNUl6twr5JQtOJyJQVdkKGUZHLZEtMgxa44Be3ZZJX8VHIQIfHNlIAqh
BC4aMqiaILGcLCFZ5/vP7nAtCMpjPiybkxlqpMKX/7eGV4iFbJ4VFitNLLMCAwEA
AaNjMGEwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUoTYwFsuGkABFgFOxj8jY
PXy+XxIwHwYDVR0jBBgwFoAUoTYwFsuGkABFgFOxj8jYPXy+XxIwDgYDVR0PAQH/
BAQDAgGGMA0GCSqGSIb3DQEBBQUAA4IBAQCKIBilvrMvtKaEAEAwKfq0FHNMeUWn
9nDg6H5kHgqVfGphwu9OH77/yZkfB2FK4V1Mza3u0FIy2VkyvNp5ctZ7CegCgTXT
Ct8RHcl5oIBN/lrXVtbtDyqvpxh1MwzqwWEFT2qaifKNuZ8u77BfWgDrvq2g+EQF
Z7zLBO+eZMXpyD8Fv8YvBxzDNnGGyjhmSs3WuEvGbKeXO/oTLW4jYYehY0KswsuX
n2Fozy1MBJ3XJU8KDk2QixhWqJNIV9xvrr2eZ1d3iVCzvhGbRWeDhhmH05i9CBoW
H1iCC+GWaQVLjuyDUTEH1dSf/1l7qG6Fz9NLqUmwX7A5KGgOc90lmt4S
-----END CERTIFICATE-----', 'fb84bf4b2d90e78cb2b7af923d564744');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=AOL Time Warner Inc., CN=AOL Time Warner Root Certification Authority 2', 3, 1, 0, '2002-05-29 06:00:00', '2037-09-28 23:43:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=AOL Time Warner Inc., OU=America Online Inc., CN=AOL Time Warner Root Certification Authority 2
        Validity
            Not Before: May 29 06:00:00 2002 GMT
            Not After : Sep 28 23:43:00 2037 GMT
        Subject: C=US, O=AOL Time Warner Inc., OU=America Online Inc., CN=AOL Time Warner Root Certification Authority 2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (4096 bit)
                Modulus (4096 bit):
                    00:b4:37:5a:08:16:99:14:e8:55:b1:1b:24:6b:fc:
                    c7:8b:e6:87:a9:89:ee:8b:99:cd:4f:40:86:a4:b6:
                    4d:c9:d9:b1:dc:3c:4d:0d:85:4c:15:6c:46:8b:52:
                    78:9f:f8:23:fd:67:f5:24:3a:68:5d:d0:f7:64:61:
                    41:54:a3:8b:a5:08:d2:29:5b:9b:60:4f:26:83:d1:
                    63:12:56:49:76:a4:16:c2:a5:9d:45:ac:8b:84:95:
                    a8:16:b1:ec:9f:ea:24:1a:ef:b9:57:5c:9a:24:21:
                    2c:4d:0e:71:1f:a6:ac:5d:45:74:03:98:c4:54:8c:
                    16:4a:41:77:86:95:75:0c:47:01:66:60:fc:15:f1:
                    0f:ea:f5:14:78:c7:0e:d7:6e:81:1c:5e:bf:5e:e7:
                    3a:2a:d8:97:17:30:7c:00:ad:08:9d:33:af:b8:99:
                    61:80:8b:a8:95:7e:14:dc:12:6c:a4:d0:d8:ef:40:
                    49:02:36:f9:6e:a9:d6:1d:96:56:04:b2:b3:2d:16:
                    56:86:8f:d9:20:57:80:cd:67:10:6d:b0:4c:f0:da:
                    46:b6:ea:25:2e:46:af:8d:b0:85:38:34:8b:14:26:
                    82:2b:ac:ae:99:0b:8e:14:d7:52:bd:9e:69:c3:86:
                    02:0b:ea:76:75:31:09:ce:33:19:21:85:43:e6:89:
                    2d:9f:25:37:67:f1:23:6a:d2:00:6d:97:f9:9f:e7:
                    29:ca:dd:1f:d7:06:ea:b8:c9:b9:09:21:9f:c8:3f:
                    06:c5:d2:e9:12:46:00:4e:7b:08:eb:42:3d:2b:48:
                    6e:9d:67:dd:4b:02:e4:44:f3:93:19:a5:27:ce:69:
                    7a:be:67:d3:fc:50:a4:2c:ab:c3:6b:b9:e3:80:4c:
                    cf:05:61:4b:2b:dc:1b:b9:a6:d2:d0:aa:f5:2b:73:
                    fb:ce:90:35:9f:0c:52:1c:bf:5c:21:61:11:5b:15:
                    4b:a9:24:51:fc:a4:5c:f7:17:9d:b0:d2:fa:07:e9:
                    8f:56:e4:1a:8c:68:8a:04:d3:7c:5a:e3:9e:a2:a1:
                    ca:71:5b:a2:d4:a0:e7:29:85:5d:03:68:2a:4f:d2:
                    06:d7:3d:f9:c3:03:2f:3f:65:f9:67:1e:47:40:d3:
                    63:0f:e3:d5:8e:f9:85:ab:97:4c:b3:d7:26:eb:96:
                    0a:94:de:85:36:9c:c8:7f:81:09:02:49:2a:0e:f5:
                    64:32:0c:82:d1:ba:6a:82:1b:b3:4b:74:11:f3:8c:
                    77:d6:9f:bf:dc:37:a4:a7:55:04:2f:d4:31:e8:d3:
                    46:b9:03:7c:da:12:4e:59:64:b7:51:31:31:50:a0:
                    ca:1c:27:d9:10:2e:ad:d6:bd:10:66:2b:c3:b0:22:
                    4a:12:5b
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                4F:69:6D:03:7E:9D:9F:07:18:43:BC:B7:10:4E:D5:BF:A9:C4:20:28
            X509v3 Authority Key Identifier: 
                keyid:4F:69:6D:03:7E:9D:9F:07:18:43:BC:B7:10:4E:D5:BF:A9:C4:20:28

            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        3b:f3:ae:ca:e8:2e:87:85:fb:65:59:e7:ad:11:14:a5:57:bc:
        58:9f:24:12:57:bb:fb:3f:34:da:ee:ad:7a:2a:34:72:70:31:
        6b:c7:19:98:80:c9:82:de:37:77:5e:54:8b:8e:f2:ea:67:4f:
        c9:74:84:91:56:09:d5:e5:7a:9a:81:b6:81:c2:ad:36:e4:f1:
        54:11:53:f3:34:45:01:26:c8:e5:1a:bc:34:44:21:de:ad:25:
        fc:76:16:77:21:90:80:98:57:9d:4e:ea:ec:2f:aa:3c:14:7b:
        57:c1:7e:18:14:67:ee:24:c6:bd:ba:15:b0:d2:18:bd:b7:55:
        81:ac:53:c0:e8:dd:69:12:13:42:b7:02:b5:05:41:ca:79:50:
        6e:82:0e:71:72:93:46:e8:9d:0d:5d:bd:ae:ce:29:ad:63:d5:
        55:16:80:30:27:ff:76:ba:f7:b8:d6:4a:e3:d9:b5:f9:52:d0:
        4e:40:a9:c7:e5:c2:32:c7:aa:76:24:e1:6b:05:50:eb:c5:bf:
        0a:54:e5:b9:42:3c:24:fb:b7:07:9c:30:9f:79:5a:e6:e0:40:
        52:15:f4:fc:aa:f4:56:f9:44:97:87:ed:0e:65:72:5e:be:26:
        fb:4d:a4:2d:08:07:de:d8:5c:a0:dc:81:33:99:18:25:11:77:
        a7:eb:fd:58:09:2c:99:6b:1b:8a:f3:52:3f:1a:4d:48:60:f1:
        a0:f6:33:02:53:8b:ed:25:09:b8:0d:2d:ed:97:73:ec:d7:96:
        1f:8e:60:0e:da:10:9b:2f:18:24:f6:a6:4d:0a:f9:3b:cb:75:
        c2:cc:2f:ce:24:69:c9:0a:22:8e:59:a7:f7:82:0c:d7:d7:6b:
        35:9c:43:00:6a:c4:95:67:ba:9c:45:cb:b8:0e:37:f7:dc:4e:
        01:4f:be:0a:b6:03:d3:ad:8a:45:f7:da:27:4d:29:b1:48:df:
        e4:11:e4:96:46:bd:6c:02:3e:d6:51:c8:95:17:01:15:a9:f2:
        aa:aa:f2:bf:2f:65:1b:6f:d0:b9:1a:93:f5:8e:35:c4:80:87:
        3e:94:2f:66:e4:e9:a8:ff:41:9c:70:2a:4f:2a:39:18:95:1e:
        7e:fb:61:01:3c:51:08:2e:28:18:a4:16:0f:31:fd:3a:6c:23:
        93:20:76:e1:fd:07:85:d1:5b:3f:d2:1c:73:32:dd:fa:b9:f8:
        8c:cf:02:87:7a:9a:96:e4:ed:4f:89:8d:53:43:ab:0e:13:c0:
        01:15:b4:79:38:db:fc:6e:3d:9e:51:b6:b8:13:8b:67:cf:f9:
        7c:d9:22:1d:f6:5d:c5:1c:01:2f:98:e8:7a:24:18:bc:84:d7:
        fa:dc:72:5b:f7:c1:3a:68', 'B4375A08169914E855B11B246BFCC78BE687A989EE8B99CD4F4086A4B64DC9D9B1DC3C4D0D854C156C468B52789FF823FD67F5243A685DD0F764614154A38BA508D2295B9B604F2683D16312564976A416C2A59D45AC8B8495A816B1EC9FEA241AEFB9575C9A24212C4D0E711FA6AC5D45740398C4548C164A41778695750C47016660FC15F10FEAF51478C70ED76E811C5EBF5EE73A2AD89717307C00AD089D33AFB89961808BA8957E14DC126CA4D0D8EF40490236F96EA9D61D965604B2B32D1656868FD9205780CD67106DB04CF0DA46B6EA252E46AF8DB08538348B1426822BACAE990B8E14D752BD9E69C386020BEA76753109CE3319218543E6892D9F253767F1236AD2006D97F99FE729CADD1FD706EAB8C9B909219FC83F06C5D2E91246004E7B08EB423D2B486E9D67DD4B02E444F39319A527CE697ABE67D3FC50A42CABC36BB9E3804CCF05614B2BDC1BB9A6D2D0AAF52B73FBCE90359F0C521CBF5C2161115B154BA92451FCA45CF7179DB0D2FA07E98F56E41A8C688A04D37C5AE39EA2A1CA715BA2D4A0E729855D03682A4FD206D73DF9C3032F3F65F9671E4740D3630FE3D58EF985AB974CB3D726EB960A94DE85369CC87F810902492A0EF564320C82D1BA6A821BB34B7411F38C77D69FBFDC37A4A755042FD431E8D346B9037CDA124E5964B751313150A0CA1C27D9102EADD6BD10662BC3B0224A125B', '/C=US/O=AOL Time Warner Inc./OU=America Online Inc./CN=AOL Time Warner Root Certification Authority 2', 'C=US/O=AOL Time Warner Inc./OU=America Online Inc./CN=AOL Time Warner Root Certification Authority 2', '01', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', '7a714f6f30c3676a92ce5ded68e490aa');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=DigiCert Inc, CN=DigiCert Assured ID Root CA', 3, 1, 0, '2006-11-10 00:00:00', '2031-11-10 00:00:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            0c:e7:e0:e5:17:d8:46:fe:8f:e5:60:fc:1b:f0:30:39
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root CA
        Validity
            Not Before: Nov 10 00:00:00 2006 GMT
            Not After : Nov 10 00:00:00 2031 GMT
        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ad:0e:15:ce:e4:43:80:5c:b1:87:f3:b7:60:f9:
                    71:12:a5:ae:dc:26:94:88:aa:f4:ce:f5:20:39:28:
                    58:60:0c:f8:80:da:a9:15:95:32:61:3c:b5:b1:28:
                    84:8a:8a:dc:9f:0a:0c:83:17:7a:8f:90:ac:8a:e7:
                    79:53:5c:31:84:2a:f6:0f:98:32:36:76:cc:de:dd:
                    3c:a8:a2:ef:6a:fb:21:f2:52:61:df:9f:20:d7:1f:
                    e2:b1:d9:fe:18:64:d2:12:5b:5f:f9:58:18:35:bc:
                    47:cd:a1:36:f9:6b:7f:d4:b0:38:3e:c1:1b:c3:8c:
                    33:d9:d8:2f:18:fe:28:0f:b3:a7:83:d6:c3:6e:44:
                    c0:61:35:96:16:fe:59:9c:8b:76:6d:d7:f1:a2:4b:
                    0d:2b:ff:0b:72:da:9e:60:d0:8e:90:35:c6:78:55:
                    87:20:a1:cf:e5:6d:0a:c8:49:7c:31:98:33:6c:22:
                    e9:87:d0:32:5a:a2:ba:13:82:11:ed:39:17:9d:99:
                    3a:72:a1:e6:fa:a4:d9:d5:17:31:75:ae:85:7d:22:
                    ae:3f:01:46:86:f6:28:79:c8:b1:da:e4:57:17:c4:
                    7e:1c:0e:b0:b4:92:a6:56:b3:bd:b2:97:ed:aa:a7:
                    f0:b7:c5:a8:3f:95:16:d0:ff:a1:96:eb:08:5f:18:
                    77:4f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                45:EB:A2:AF:F4:92:CB:82:31:2D:51:8B:A7:A7:21:9D:F3:6D:C8:0F
            X509v3 Authority Key Identifier: 
                keyid:45:EB:A2:AF:F4:92:CB:82:31:2D:51:8B:A7:A7:21:9D:F3:6D:C8:0F

    Signature Algorithm: sha1WithRSAEncryption
        a2:0e:bc:df:e2:ed:f0:e3:72:73:7a:64:94:bf:f7:72:66:d8:
        32:e4:42:75:62:ae:87:eb:f2:d5:d9:de:56:b3:9f:cc:ce:14:
        28:b9:0d:97:60:5c:12:4c:58:e4:d3:3d:83:49:45:58:97:35:
        69:1a:a8:47:ea:56:c6:79:ab:12:d8:67:81:84:df:7f:09:3c:
        94:e6:b8:26:2c:20:bd:3d:b3:28:89:f7:5f:ff:22:e2:97:84:
        1f:e9:65:ef:87:e0:df:c1:67:49:b3:5d:eb:b2:09:2a:eb:26:
        ed:78:be:7d:3f:2b:f3:b7:26:35:6d:5f:89:01:b6:49:5b:9f:
        01:05:9b:ab:3d:25:c1:cc:b6:7f:c2:f1:6f:86:c6:fa:64:68:
        eb:81:2d:94:eb:42:b7:fa:8c:1e:dd:62:f1:be:50:67:b7:6c:
        bd:f3:f1:1f:6b:0c:36:07:16:7f:37:7c:a9:5b:6d:7a:f1:12:
        46:60:83:d7:27:04:be:4b:ce:97:be:c3:67:2a:68:11:df:80:
        e7:0c:33:66:bf:13:0d:14:6e:f3:7f:1f:63:10:1e:fa:8d:1b:
        25:6d:6c:8f:a5:b7:61:01:b1:d2:a3:26:a1:10:71:9d:ad:e2:
        c3:f9:c3:99:51:b7:2b:07:08:ce:2e:e6:50:b2:a7:fa:0a:45:
        2f:a2:f0:f2', 'AD0E15CEE443805CB187F3B760F97112A5AEDC269488AAF4CEF520392858600CF880DAA9159532613CB5B128848A8ADC9F0A0C83177A8F90AC8AE779535C31842AF60F98323676CCDEDD3CA8A2EF6AFB21F25261DF9F20D71FE2B1D9FE1864D2125B5FF9581835BC47CDA136F96B7FD4B0383EC11BC38C33D9D82F18FE280FB3A783D6C36E44C061359616FE599C8B766DD7F1A24B0D2BFF0B72DA9E60D08E9035C678558720A1CFE56D0AC8497C3198336C22E987D0325AA2BA138211ED39179D993A72A1E6FAA4D9D5173175AE857D22AE3F014686F62879C8B1DAE45717C47E1C0EB0B492A656B3BDB297EDAAA7F0B7C5A83F9516D0FFA196EB085F18774F', '/C=US/O=DigiCert Inc/OU=www.digicert.com/CN=DigiCert Assured ID Root CA', 'C=US/O=DigiCert Inc/OU=www.digicert.com/CN=DigiCert Assured ID Root CA', '0CE7E0E517D846FE8FE560FC1BF03039', NULL, '-----BEGIN CERTIFICATE-----
MIIDtzCCAp+gAwIBAgIQDOfg5RfYRv6P5WD8G/AwOTANBgkqhkiG9w0BAQUFADBl
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMzExMTEwMDAwMDAwWjBlMQswCQYDVQQG
EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
cnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0EwggEi
MA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCtDhXO5EOAXLGH87dg+XESpa7c
JpSIqvTO9SA5KFhgDPiA2qkVlTJhPLWxKISKityfCgyDF3qPkKyK53lTXDGEKvYP
mDI2dsze3Tyoou9q+yHyUmHfnyDXH+Kx2f4YZNISW1/5WBg1vEfNoTb5a3/UsDg+
wRvDjDPZ2C8Y/igPs6eD1sNuRMBhNZYW/lmci3Zt1/GiSw0r/wty2p5g0I6QNcZ4
VYcgoc/lbQrISXwxmDNsIumH0DJaoroTghHtORedmTpyoeb6pNnVFzF1roV9Iq4/
AUaG9ih5yLHa5FcXxH4cDrC0kqZWs72yl+2qp/C3xag/lRbQ/6GW6whfGHdPAgMB
AAGjYzBhMA4GA1UdDwEB/wQEAwIBhjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQW
BBRF66Kv9JLLgjEtUYunpyGd823IDzAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYun
pyGd823IDzANBgkqhkiG9w0BAQUFAAOCAQEAog683+Lt8ONyc3pklL/3cmbYMuRC
dWKuh+vy1dneVrOfzM4UKLkNl2BcEkxY5NM9g0lFWJc1aRqoR+pWxnmrEthngYTf
fwk8lOa4JiwgvT2zKIn3X/8i4peEH+ll74fg38FnSbNd67IJKusm7Xi+fT8r87cm
NW1fiQG2SVufAQWbqz0lwcy2f8Lxb4bG+mRo64EtlOtCt/qMHt1i8b5QZ7dsvfPx
H2sMNgcWfzd8qVttevESRmCD1ycEvkvOl77DZypoEd+A5wwzZr8TDRRu838fYxAe
+o0bJW1sj6W3YQGx0qMmoRBxna3iw/nDmVG3KwcIzi7mULKn+gpFL6Lw8g==
-----END CERTIFICATE-----', '9e328b8d7eb2098bca933ed3353de369');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=DigiCert Inc, CN=DigiCert Global Root CA', 3, 1, 0, '2006-11-10 00:00:00', '2031-11-10 00:00:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            08:3b:e0:56:90:42:46:b1:a1:75:6a:c9:59:91:c7:4a
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root CA
        Validity
            Not Before: Nov 10 00:00:00 2006 GMT
            Not After : Nov 10 00:00:00 2031 GMT
        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:e2:3b:e1:11:72:de:a8:a4:d3:a3:57:aa:50:a2:
                    8f:0b:77:90:c9:a2:a5:ee:12:ce:96:5b:01:09:20:
                    cc:01:93:a7:4e:30:b7:53:f7:43:c4:69:00:57:9d:
                    e2:8d:22:dd:87:06:40:00:81:09:ce:ce:1b:83:bf:
                    df:cd:3b:71:46:e2:d6:66:c7:05:b3:76:27:16:8f:
                    7b:9e:1e:95:7d:ee:b7:48:a3:08:da:d6:af:7a:0c:
                    39:06:65:7f:4a:5d:1f:bc:17:f8:ab:be:ee:28:d7:
                    74:7f:7a:78:99:59:85:68:6e:5c:23:32:4b:bf:4e:
                    c0:e8:5a:6d:e3:70:bf:77:10:bf:fc:01:f6:85:d9:
                    a8:44:10:58:32:a9:75:18:d5:d1:a2:be:47:e2:27:
                    6a:f4:9a:33:f8:49:08:60:8b:d4:5f:b4:3a:84:bf:
                    a1:aa:4a:4c:7d:3e:cf:4f:5f:6c:76:5e:a0:4b:37:
                    91:9e:dc:22:e6:6d:ce:14:1a:8e:6a:cb:fe:cd:b3:
                    14:64:17:c7:5b:29:9e:32:bf:f2:ee:fa:d3:0b:42:
                    d4:ab:b7:41:32:da:0c:d4:ef:f8:81:d5:bb:8d:58:
                    3f:b5:1b:e8:49:28:a2:70:da:31:04:dd:f7:b2:16:
                    f2:4c:0a:4e:07:a8:ed:4a:3d:5e:b5:7f:a3:90:c3:
                    af:27
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                03:DE:50:35:56:D1:4C:BB:66:F0:A3:E2:1B:1B:C3:97:B2:3D:D1:55
            X509v3 Authority Key Identifier: 
                keyid:03:DE:50:35:56:D1:4C:BB:66:F0:A3:E2:1B:1B:C3:97:B2:3D:D1:55

    Signature Algorithm: sha1WithRSAEncryption
        cb:9c:37:aa:48:13:12:0a:fa:dd:44:9c:4f:52:b0:f4:df:ae:
        04:f5:79:79:08:a3:24:18:fc:4b:2b:84:c0:2d:b9:d5:c7:fe:
        f4:c1:1f:58:cb:b8:6d:9c:7a:74:e7:98:29:ab:11:b5:e3:70:
        a0:a1:cd:4c:88:99:93:8c:91:70:e2:ab:0f:1c:be:93:a9:ff:
        63:d5:e4:07:60:d3:a3:bf:9d:5b:09:f1:d5:8e:e3:53:f4:8e:
        63:fa:3f:a7:db:b4:66:df:62:66:d6:d1:6e:41:8d:f2:2d:b5:
        ea:77:4a:9f:9d:58:e2:2b:59:c0:40:23:ed:2d:28:82:45:3e:
        79:54:92:26:98:e0:80:48:a8:37:ef:f0:d6:79:60:16:de:ac:
        e8:0e:cd:6e:ac:44:17:38:2f:49:da:e1:45:3e:2a:b9:36:53:
        cf:3a:50:06:f7:2e:e8:c4:57:49:6c:61:21:18:d5:04:ad:78:
        3c:2c:3a:80:6b:a7:eb:af:15:14:e9:d8:89:c1:b9:38:6c:e2:
        91:6c:8a:ff:64:b9:77:25:57:30:c0:1b:24:a3:e1:dc:e9:df:
        47:7c:b5:b4:24:08:05:30:ec:2d:bd:0b:bf:45:bf:50:b9:a9:
        f3:eb:98:01:12:ad:c8:88:c6:98:34:5f:8d:0a:3c:c6:e9:d5:
        95:95:6d:de', 'E23BE11172DEA8A4D3A357AA50A28F0B7790C9A2A5EE12CE965B010920CC0193A74E30B753F743C46900579DE28D22DD870640008109CECE1B83BFDFCD3B7146E2D666C705B37627168F7B9E1E957DEEB748A308DAD6AF7A0C3906657F4A5D1FBC17F8ABBEEE28D7747F7A78995985686E5C23324BBF4EC0E85A6DE370BF7710BFFC01F685D9A844105832A97518D5D1A2BE47E2276AF49A33F84908608BD45FB43A84BFA1AA4A4C7D3ECF4F5F6C765EA04B37919EDC22E66DCE141A8E6ACBFECDB3146417C75B299E32BFF2EEFAD30B42D4ABB74132DA0CD4EFF881D5BB8D583FB51BE84928A270DA3104DDF7B216F24C0A4E07A8ED4A3D5EB57FA390C3AF27', '/C=US/O=DigiCert Inc/OU=www.digicert.com/CN=DigiCert Global Root CA', 'C=US/O=DigiCert Inc/OU=www.digicert.com/CN=DigiCert Global Root CA', '083BE056904246B1A1756AC95991C74A', NULL, '-----BEGIN CERTIFICATE-----
MIIDrzCCApegAwIBAgIQCDvgVpBCRrGhdWrJWZHHSjANBgkqhkiG9w0BAQUFADBh
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBD
QTAeFw0wNjExMTAwMDAwMDBaFw0zMTExMTAwMDAwMDBaMGExCzAJBgNVBAYTAlVT
MRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
b20xIDAeBgNVBAMTF0RpZ2lDZXJ0IEdsb2JhbCBSb290IENBMIIBIjANBgkqhkiG
9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4jvhEXLeqKTTo1eqUKKPC3eQyaKl7hLOllsB
CSDMAZOnTjC3U/dDxGkAV53ijSLdhwZAAIEJzs4bg7/fzTtxRuLWZscFs3YnFo97
nh6Vfe63SKMI2tavegw5BmV/Sl0fvBf4q77uKNd0f3p4mVmFaG5cIzJLv07A6Fpt
43C/dxC//AH2hdmoRBBYMql1GNXRor5H4idq9Joz+EkIYIvUX7Q6hL+hqkpMfT7P
T19sdl6gSzeRntwi5m3OFBqOasv+zbMUZBfHWymeMr/y7vrTC0LUq7dBMtoM1O/4
gdW7jVg/tRvoSSiicNoxBN33shbyTApOB6jtSj1etX+jkMOvJwIDAQABo2MwYTAO
BgNVHQ8BAf8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUA95QNVbR
TLtm8KPiGxvDl7I90VUwHwYDVR0jBBgwFoAUA95QNVbRTLtm8KPiGxvDl7I90VUw
DQYJKoZIhvcNAQEFBQADggEBAMucN6pIExIK+t1EnE9SsPTfrgT1eXkIoyQY/Esr
hMAtudXH/vTBH1jLuG2cenTnmCmrEbXjcKChzUyImZOMkXDiqw8cvpOp/2PV5Adg
06O/nVsJ8dWO41P0jmP6P6fbtGbfYmbW0W5BjfIttep3Sp+dWOIrWcBAI+0tKIJF
PnlUkiaY4IBIqDfv8NZ5YBberOgOzW6sRBc4L0na4UU+Krk2U886UAb3LujEV0ls
YSEY1QSteDwsOoBrp+uvFRTp2InBuThs4pFsiv9kuXclVzDAGySj4dzp30d8tbQk
CAUw7C29C79Fv1C5qfPrmAESrciIxpg0X40KPMbp1ZWVbd4=
-----END CERTIFICATE-----', '5945bad341623ae14991e09ffe851725');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=DigiCert Inc, CN=DigiCert High Assurance EV Root CA', 3, 1, 0, '2006-11-10 00:00:00', '2031-11-10 00:00:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            02:ac:5c:26:6a:0b:40:9b:8f:0b:79:f2:ae:46:25:77
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert High Assurance EV Root CA
        Validity
            Not Before: Nov 10 00:00:00 2006 GMT
            Not After : Nov 10 00:00:00 2031 GMT
        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert High Assurance EV Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:c6:cc:e5:73:e6:fb:d4:bb:e5:2d:2d:32:a6:df:
                    e5:81:3f:c9:cd:25:49:b6:71:2a:c3:d5:94:34:67:
                    a2:0a:1c:b0:5f:69:a6:40:b1:c4:b7:b2:8f:d0:98:
                    a4:a9:41:59:3a:d3:dc:94:d6:3c:db:74:38:a4:4a:
                    cc:4d:25:82:f7:4a:a5:53:12:38:ee:f3:49:6d:71:
                    91:7e:63:b6:ab:a6:5f:c3:a4:84:f8:4f:62:51:be:
                    f8:c5:ec:db:38:92:e3:06:e5:08:91:0c:c4:28:41:
                    55:fb:cb:5a:89:15:7e:71:e8:35:bf:4d:72:09:3d:
                    be:3a:38:50:5b:77:31:1b:8d:b3:c7:24:45:9a:a7:
                    ac:6d:00:14:5a:04:b7:ba:13:eb:51:0a:98:41:41:
                    22:4e:65:61:87:81:41:50:a6:79:5c:89:de:19:4a:
                    57:d5:2e:e6:5d:1c:53:2c:7e:98:cd:1a:06:16:a4:
                    68:73:d0:34:04:13:5c:a1:71:d3:5a:7c:55:db:5e:
                    64:e1:37:87:30:56:04:e5:11:b4:29:80:12:f1:79:
                    39:88:a2:02:11:7c:27:66:b7:88:b7:78:f2:ca:0a:
                    a8:38:ab:0a:64:c2:bf:66:5d:95:84:c1:a1:25:1e:
                    87:5d:1a:50:0b:20:12:cc:41:bb:6e:0b:51:38:b8:
                    4b:cb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                B1:3E:C3:69:03:F8:BF:47:01:D4:98:26:1A:08:02:EF:63:64:2B:C3
            X509v3 Authority Key Identifier: 
                keyid:B1:3E:C3:69:03:F8:BF:47:01:D4:98:26:1A:08:02:EF:63:64:2B:C3

    Signature Algorithm: sha1WithRSAEncryption
        1c:1a:06:97:dc:d7:9c:9f:3c:88:66:06:08:57:21:db:21:47:
        f8:2a:67:aa:bf:18:32:76:40:10:57:c1:8a:f3:7a:d9:11:65:
        8e:35:fa:9e:fc:45:b5:9e:d9:4c:31:4b:b8:91:e8:43:2c:8e:
        b3:78:ce:db:e3:53:79:71:d6:e5:21:94:01:da:55:87:9a:24:
        64:f6:8a:66:cc:de:9c:37:cd:a8:34:b1:69:9b:23:c8:9e:78:
        22:2b:70:43:e3:55:47:31:61:19:ef:58:c5:85:2f:4e:30:f6:
        a0:31:16:23:c8:e7:e2:65:16:33:cb:bf:1a:1b:a0:3d:f8:ca:
        5e:8b:31:8b:60:08:89:2d:0c:06:5c:52:b7:c4:f9:0a:98:d1:
        15:5f:9f:12:be:7c:36:63:38:bd:44:a4:7f:e4:26:2b:0a:c4:
        97:69:0d:e9:8c:e2:c0:10:57:b8:c8:76:12:91:55:f2:48:69:
        d8:bc:2a:02:5b:0f:44:d4:20:31:db:f4:ba:70:26:5d:90:60:
        9e:bc:4b:17:09:2f:b4:cb:1e:43:68:c9:07:27:c1:d2:5c:f7:
        ea:21:b9:68:12:9c:3c:9c:bf:9e:fc:80:5c:9b:63:cd:ec:47:
        aa:25:27:67:a0:37:f3:00:82:7d:54:d7:a9:f8:e9:2e:13:a3:
        77:e8:1f:4a', 'C6CCE573E6FBD4BBE52D2D32A6DFE5813FC9CD2549B6712AC3D5943467A20A1CB05F69A640B1C4B7B28FD098A4A941593AD3DC94D63CDB7438A44ACC4D2582F74AA5531238EEF3496D71917E63B6ABA65FC3A484F84F6251BEF8C5ECDB3892E306E508910CC4284155FBCB5A89157E71E835BF4D72093DBE3A38505B77311B8DB3C724459AA7AC6D00145A04B7BA13EB510A984141224E656187814150A6795C89DE194A57D52EE65D1C532C7E98CD1A0616A46873D03404135CA171D35A7C55DB5E64E13787305604E511B4298012F1793988A202117C2766B788B778F2CA0AA838AB0A64C2BF665D9584C1A1251E875D1A500B2012CC41BB6E0B5138B84BCB', '/C=US/O=DigiCert Inc/OU=www.digicert.com/CN=DigiCert High Assurance EV Root CA', 'C=US/O=DigiCert Inc/OU=www.digicert.com/CN=DigiCert High Assurance EV Root CA', '02AC5C266A0B409B8F0B79F2AE462577', NULL, '-----BEGIN CERTIFICATE-----
MIIDxTCCAq2gAwIBAgIQAqxcJmoLQJuPC3nyrkYldzANBgkqhkiG9w0BAQUFADBs
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2VydCBIaWdoIEFzc3VyYW5j
ZSBFViBSb290IENBMB4XDTA2MTExMDAwMDAwMFoXDTMxMTExMDAwMDAwMFowbDEL
MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMiRGlnaUNlcnQgSGlnaCBBc3N1cmFuY2Ug
RVYgUm9vdCBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMbM5XPm
+9S75S0tMqbf5YE/yc0lSbZxKsPVlDRnogocsF9ppkCxxLeyj9CYpKlBWTrT3JTW
PNt0OKRKzE0lgvdKpVMSOO7zSW1xkX5jtqumX8OkhPhPYlG++MXs2ziS4wblCJEM
xChBVfvLWokVfnHoNb9Ncgk9vjo4UFt3MRuNs8ckRZqnrG0AFFoEt7oT61EKmEFB
Ik5lYYeBQVCmeVyJ3hlKV9Uu5l0cUyx+mM0aBhakaHPQNAQTXKFx01p8VdteZOE3
hzBWBOURtCmAEvF5OYiiAhF8J2a3iLd48soKqDirCmTCv2ZdlYTBoSUeh10aUAsg
EsxBu24LUTi4S8sCAwEAAaNjMGEwDgYDVR0PAQH/BAQDAgGGMA8GA1UdEwEB/wQF
MAMBAf8wHQYDVR0OBBYEFLE+w2kD+L9HAdSYJhoIAu9jZCvDMB8GA1UdIwQYMBaA
FLE+w2kD+L9HAdSYJhoIAu9jZCvDMA0GCSqGSIb3DQEBBQUAA4IBAQAcGgaX3Nec
nzyIZgYIVyHbIUf4KmeqvxgydkAQV8GK83rZEWWONfqe/EW1ntlMMUu4kehDLI6z
eM7b41N5cdblIZQB2lWHmiRk9opmzN6cN82oNLFpmyPInngiK3BD41VHMWEZ71jF
hS9OMPagMRYjyOfiZRYzy78aG6A9+MpeizGLYAiJLQwGXFK3xPkKmNEVX58Svnw2
Yzi9RKR/5CYrCsSXaQ3pjOLAEFe4yHYSkVXySGnYvCoCWw9E1CAx2/S6cCZdkGCe
vEsXCS+0yx5DaMkHJ8HSXPfqIbloEpw8nL+e/IBcm2PN7EeqJSdnoDfzAIJ9VNep
+OkuE6N36B9K
-----END CERTIFICATE-----', '3b92857df75558b2466d31a45b9c64f8');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Entrust.net, CN=Entrust.net Client Certification Authority', 3, 1, 0, '1999-10-12 19:24:30', '2019-10-12 19:54:30', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 939758062 (0x380391ee)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=US, O=Entrust.net, OU=www.entrust.net/Client_CA_Info/CPS incorp. by ref. limits liab., OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Client Certification Authority
        Validity
            Not Before: Oct 12 19:24:30 1999 GMT
            Not After : Oct 12 19:54:30 2019 GMT
        Subject: C=US, O=Entrust.net, OU=www.entrust.net/Client_CA_Info/CPS incorp. by ref. limits liab., OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Client Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c8:3a:99:5e:31:17:df:ac:27:6f:90:7b:e4:19:
                    ff:45:a3:34:c2:db:c1:a8:4f:f0:68:ea:84:fd:9f:
                    75:79:cf:c1:8a:51:94:af:c7:57:03:47:64:9e:ad:
                    82:1b:5a:da:7f:37:78:47:bb:37:98:12:96:ce:c6:
                    13:7d:ef:d2:0c:30:51:a9:39:9e:55:f8:fb:b1:e7:
                    30:de:83:b2:ba:3e:f1:d5:89:3b:3b:85:ba:aa:74:
                    2c:fe:3f:31:6e:af:91:95:6e:06:d4:07:4d:4b:2c:
                    56:47:18:04:52:da:0e:10:93:bf:63:90:9b:e1:df:
                    8c:e6:02:a4:e6:4f:5e:f7:8b
                Exponent: 3 (0x3)
        X509v3 extensions:
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 CRL Distribution Points: 
                DirName:/C=US/O=Entrust.net/OU=www.entrust.net/Client_CA_Info/CPS incorp. by ref. limits liab./OU=(c) 1999 Entrust.net Limited/CN=Entrust.net Client Certification Authority/CN=CRL1
                URI:http://www.entrust.net/CRL/Client1.crl

            X509v3 Private Key Usage Period: 
                Not Before: Oct 12 19:24:30 1999 GMT, Not After: Oct 12 19:24:30 2019 GMT
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
                keyid:C4:FB:9C:29:7B:97:CD:4C:96:FC:EE:5B:B3:CA:99:74:8B:95:EA:4C

            X509v3 Subject Key Identifier: 
                C4:FB:9C:29:7B:97:CD:4C:96:FC:EE:5B:B3:CA:99:74:8B:95:EA:4C
            X509v3 Basic Constraints: 
                CA:TRUE
            1.2.840.113533.7.65.0: 
                0
..V4.0....
    Signature Algorithm: md5WithRSAEncryption
        3f:ae:8a:f1:d7:66:03:05:9e:3e:fa:ea:1c:46:bb:a4:5b:8f:
        78:9a:12:48:99:f9:f4:35:de:0c:36:07:02:6b:10:3a:89:14:
        81:9c:31:a6:7c:b2:41:b2:6a:e7:07:01:a1:4b:f9:9f:25:3b:
        96:ca:99:c3:3e:a1:51:1c:f3:c3:2e:44:f7:b0:67:46:aa:92:
        e5:3b:da:1c:19:14:38:30:d5:e2:a2:31:25:2e:f1:ec:45:38:
        ed:f8:06:58:03:73:62:b0:10:31:8f:40:bf:64:e0:5c:3e:c5:
        4f:1f:da:12:43:ff:4c:e6:06:26:a8:9b:19:aa:44:3c:76:b2:
        5c:ec', 'C83A995E3117DFAC276F907BE419FF45A334C2DBC1A84FF068EA84FD9F7579CFC18A5194AFC7570347649EAD821B5ADA7F377847BB37981296CEC6137DEFD20C3051A9399E55F8FBB1E730DE83B2BA3EF1D5893B3B85BAAA742CFE3F316EAF91956E06D4074D4B2C5647180452DA0E1093BF63909BE1DF8CE602A4E64F5EF78B', '/C=US/O=Entrust.net/OU=www.entrust.net/Client_CA_Info/CPS incorp. by ref. limits liab./OU=(c) 1999 Entrust.net Limited/CN=Entrust.net Client Certification Authority', 'C=US/O=Entrust.net/OU=www.entrust.net/Client_CA_Info/CPS incorp. by ref. limits liab./OU=(c) 1999 Entrust.net Limited/CN=Entrust.net Client Certification Authority',' 380391EE', NULL, '-----BEGIN CERTIFICATE-----
MIIE7TCCBFagAwIBAgIEOAOR7jANBgkqhkiG9w0BAQQFADCByTELMAkGA1UEBhMC
VVMxFDASBgNVBAoTC0VudHJ1c3QubmV0MUgwRgYDVQQLFD93d3cuZW50cnVzdC5u
ZXQvQ2xpZW50X0NBX0luZm8vQ1BTIGluY29ycC4gYnkgcmVmLiBsaW1pdHMgbGlh
Yi4xJTAjBgNVBAsTHChjKSAxOTk5IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNV
BAMTKkVudHJ1c3QubmV0IENsaWVudCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAe
Fw05OTEwMTIxOTI0MzBaFw0xOTEwMTIxOTU0MzBaMIHJMQswCQYDVQQGEwJVUzEU
MBIGA1UEChMLRW50cnVzdC5uZXQxSDBGBgNVBAsUP3d3dy5lbnRydXN0Lm5ldC9D
bGllbnRfQ0FfSW5mby9DUFMgaW5jb3JwLiBieSByZWYuIGxpbWl0cyBsaWFiLjEl
MCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMq
RW50cnVzdC5uZXQgQ2xpZW50IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGdMA0G
CSqGSIb3DQEBAQUAA4GLADCBhwKBgQDIOpleMRffrCdvkHvkGf9FozTC28GoT/Bo
6oT9n3V5z8GKUZSvx1cDR2SerYIbWtp/N3hHuzeYEpbOxhN979IMMFGpOZ5V+Pux
5zDeg7K6PvHViTs7hbqqdCz+PzFur5GVbgbUB01LLFZHGARS2g4Qk79jkJvh34zm
AqTmT173iwIBA6OCAeAwggHcMBEGCWCGSAGG+EIBAQQEAwIABzCCASIGA1UdHwSC
ARkwggEVMIHkoIHhoIHepIHbMIHYMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50
cnVzdC5uZXQxSDBGBgNVBAsUP3d3dy5lbnRydXN0Lm5ldC9DbGllbnRfQ0FfSW5m
by9DUFMgaW5jb3JwLiBieSByZWYuIGxpbWl0cyBsaWFiLjElMCMGA1UECxMcKGMp
IDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMqRW50cnVzdC5uZXQg
Q2xpZW50IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMCyg
KqAohiZodHRwOi8vd3d3LmVudHJ1c3QubmV0L0NSTC9DbGllbnQxLmNybDArBgNV
HRAEJDAigA8xOTk5MTAxMjE5MjQzMFqBDzIwMTkxMDEyMTkyNDMwWjALBgNVHQ8E
BAMCAQYwHwYDVR0jBBgwFoAUxPucKXuXzUyW/O5bs8qZdIuV6kwwHQYDVR0OBBYE
FMT7nCl7l81MlvzuW7PKmXSLlepMMAwGA1UdEwQFMAMBAf8wGQYJKoZIhvZ9B0EA
BAwwChsEVjQuMAMCBJAwDQYJKoZIhvcNAQEEBQADgYEAP66K8ddmAwWePvrqHEa7
pFuPeJoSSJn59DXeDDYHAmsQOokUgZwxpnyyQbJq5wcBoUv5nyU7lsqZwz6hURzz
wy5E97BnRqqS5TvaHBkUODDV4qIxJS7x7EU47fgGWANzYrAQMY9Av2TgXD7FTx/a
EkP/TOYGJqibGapEPHayXOw=
-----END CERTIFICATE-----', 'f3555d28213a9e0b0e501faf19d68163');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Entrust.net, CN=Entrust.net Secure Server Certification Authority', 3, 1, 0, '1999-05-25 16:09:40', '2019-05-25 16:39:40', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 927650371 (0x374ad243)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Entrust.net, OU=www.entrust.net/CPS incorp. by ref. (limits liab.), OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Secure Server Certification Authority
        Validity
            Not Before: May 25 16:09:40 1999 GMT
            Not After : May 25 16:39:40 2019 GMT
        Subject: C=US, O=Entrust.net, OU=www.entrust.net/CPS incorp. by ref. (limits liab.), OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Secure Server Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:cd:28:83:34:54:1b:89:f3:0f:af:37:91:31:ff:
                    af:31:60:c9:a8:e8:b2:10:68:ed:9f:e7:93:36:f1:
                    0a:64:bb:47:f5:04:17:3f:23:47:4d:c5:27:19:81:
                    26:0c:54:72:0d:88:2d:d9:1f:9a:12:9f:bc:b3:71:
                    d3:80:19:3f:47:66:7b:8c:35:28:d2:b9:0a:df:24:
                    da:9c:d6:50:79:81:7a:5a:d3:37:f7:c2:4a:d8:29:
                    92:26:64:d1:e4:98:6c:3a:00:8a:f5:34:9b:65:f8:
                    ed:e3:10:ff:fd:b8:49:58:dc:a0:de:82:39:6b:81:
                    b1:16:19:61:b9:54:b6:e6:43
                Exponent: 3 (0x3)
        X509v3 extensions:
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 CRL Distribution Points: 
                DirName:/C=US/O=Entrust.net/OU=www.entrust.net/CPS incorp. by ref. (limits liab.)/OU=(c) 1999 Entrust.net Limited/CN=Entrust.net Secure Server Certification Authority/CN=CRL1
                URI:http://www.entrust.net/CRL/net1.crl

            X509v3 Private Key Usage Period: 
                Not Before: May 25 16:09:40 1999 GMT, Not After: May 25 16:09:40 2019 GMT
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
                keyid:F0:17:62:13:55:3D:B3:FF:0A:00:6B:FB:50:84:97:F3:ED:62:D0:1A

            X509v3 Subject Key Identifier: 
                F0:17:62:13:55:3D:B3:FF:0A:00:6B:FB:50:84:97:F3:ED:62:D0:1A
            X509v3 Basic Constraints: 
                CA:TRUE
            1.2.840.113533.7.65.0: 
                0
..V4.0....
    Signature Algorithm: sha1WithRSAEncryption
        90:dc:30:02:fa:64:74:c2:a7:0a:a5:7c:21:8d:34:17:a8:fb:
        47:0e:ff:25:7c:8d:13:0a:fb:e4:98:b5:ef:8c:f8:c5:10:0d:
        f7:92:be:f1:c3:d5:d5:95:6a:04:bb:2c:ce:26:36:65:c8:31:
        c6:e7:ee:3f:e3:57:75:84:7a:11:ef:46:4f:18:f4:d3:98:bb:
        a8:87:32:ba:72:f6:3c:e2:3d:9f:d7:1d:d9:c3:60:43:8c:58:
        0e:22:96:2f:62:a3:2c:1f:ba:ad:05:ef:ab:32:78:87:a0:54:
        73:19:b5:5c:05:f9:52:3e:6d:2d:45:0b:f7:0a:93:ea:ed:06:
        f9:b2', 'CD288334541B89F30FAF379131FFAF3160C9A8E8B21068ED9FE79336F10A64BB47F504173F23474DC5271981260C54720D882DD91F9A129FBCB371D380193F47667B8C3528D2B90ADF24DA9CD65079817A5AD337F7C24AD829922664D1E4986C3A008AF5349B65F8EDE310FFFDB84958DCA0DE82396B81B1161961B954B6E643', '/C=US/O=Entrust.net/OU=www.entrust.net/CPS incorp. by ref. (limits liab.)/OU=(c) 1999 Entrust.net Limited/CN=Entrust.net Secure Server Certification Authority', 'C=US/O=Entrust.net/OU=www.entrust.net/CPS incorp. by ref. (limits liab.)/OU=(c) 1999 Entrust.net Limited/CN=Entrust.net Secure Server Certification Authority', '374AD243', NULL, '-----BEGIN CERTIFICATE-----
MIIE2DCCBEGgAwIBAgIEN0rSQzANBgkqhkiG9w0BAQUFADCBwzELMAkGA1UEBhMC
VVMxFDASBgNVBAoTC0VudHJ1c3QubmV0MTswOQYDVQQLEzJ3d3cuZW50cnVzdC5u
ZXQvQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMc
KGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5u
ZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05OTA1
MjUxNjA5NDBaFw0xOTA1MjUxNjM5NDBaMIHDMQswCQYDVQQGEwJVUzEUMBIGA1UE
ChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5j
b3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBF
bnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUg
U2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGdMA0GCSqGSIb3DQEBAQUA
A4GLADCBhwKBgQDNKIM0VBuJ8w+vN5Ex/68xYMmo6LIQaO2f55M28Qpku0f1BBc/
I0dNxScZgSYMVHINiC3ZH5oSn7yzcdOAGT9HZnuMNSjSuQrfJNqc1lB5gXpa0zf3
wkrYKZImZNHkmGw6AIr1NJtl+O3jEP/9uElY3KDegjlrgbEWGWG5VLbmQwIBA6OC
AdcwggHTMBEGCWCGSAGG+EIBAQQEAwIABzCCARkGA1UdHwSCARAwggEMMIHeoIHb
oIHYpIHVMIHSMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5
BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1p
dHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVk
MTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRp
b24gQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMCmgJ6AlhiNodHRwOi8vd3d3LmVu
dHJ1c3QubmV0L0NSTC9uZXQxLmNybDArBgNVHRAEJDAigA8xOTk5MDUyNTE2MDk0
MFqBDzIwMTkwNTI1MTYwOTQwWjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAU8Bdi
E1U9s/8KAGv7UISX8+1i0BowHQYDVR0OBBYEFPAXYhNVPbP/CgBr+1CEl/PtYtAa
MAwGA1UdEwQFMAMBAf8wGQYJKoZIhvZ9B0EABAwwChsEVjQuMAMCBJAwDQYJKoZI
hvcNAQEFBQADgYEAkNwwAvpkdMKnCqV8IY00F6j7Rw7/JXyNEwr75Ji174z4xRAN
95K+8cPV1ZVqBLssziY2ZcgxxufuP+NXdYR6Ee9GTxj005i7qIcyunL2POI9n9cd
2cNgQ4xYDiKWL2KjLB+6rQXvqzJ4h6BUcxm1XAX5Uj5tLUUL9wqT6u0G+bI=
-----END CERTIFICATE-----', '431aefb317c295f76996865f551e474d');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Equifax Secure', 3, 1, 0, '1999-06-23 12:14:45', '2019-06-23 12:14:45', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 930140085 (0x3770cfb5)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Equifax Secure, OU=Equifax Secure eBusiness CA-2
        Validity
            Not Before: Jun 23 12:14:45 1999 GMT
            Not After : Jun 23 12:14:45 2019 GMT
        Subject: C=US, O=Equifax Secure, OU=Equifax Secure eBusiness CA-2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:e4:39:39:93:1e:52:06:1b:28:36:f8:b2:a3:29:
                    c5:ed:8e:b2:11:bd:fe:eb:e7:b4:74:c2:8f:ff:05:
                    e7:d9:9d:06:bf:12:c8:3f:0e:f2:d6:d1:24:b2:11:
                    de:d1:73:09:8a:d4:b1:2c:98:09:0d:1e:50:46:b2:
                    83:a6:45:8d:62:68:bb:85:1b:20:70:32:aa:40:cd:
                    a6:96:5f:c4:71:37:3f:04:f3:b7:41:24:39:07:1a:
                    1e:2e:61:58:a0:12:0b:e5:a5:df:c5:ab:ea:37:71:
                    cc:1c:c8:37:3a:b9:97:52:a7:ac:c5:6a:24:94:4e:
                    9c:7b:cf:c0:6a:d6:df:21:bd
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 CRL Distribution Points: 
                DirName:/C=US/O=Equifax Secure/OU=Equifax Secure eBusiness CA-2/CN=CRL1

            X509v3 Private Key Usage Period: 
                Not After: Jun 23 12:14:45 2019 GMT
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
                keyid:50:9E:0B:EA:AF:5E:B9:20:48:A6:50:6A:CB:FD:D8:20:7A:A7:82:76

            X509v3 Subject Key Identifier: 
                50:9E:0B:EA:AF:5E:B9:20:48:A6:50:6A:CB:FD:D8:20:7A:A7:82:76
            X509v3 Basic Constraints: 
                CA:TRUE
            1.2.840.113533.7.65.0: 
                0...V3.0c....
    Signature Algorithm: sha1WithRSAEncryption
        0c:86:82:ad:e8:4e:1a:f5:8e:89:27:e2:35:58:3d:29:b4:07:
        8f:36:50:95:bf:6e:c1:9e:eb:c4:90:b2:85:a8:bb:b7:42:e0:
        0f:07:39:df:fb:9e:90:b2:d1:c1:3e:53:9f:03:44:b0:7e:4b:
        f4:6f:e4:7c:1f:e7:e2:b1:e4:b8:9a:ef:c3:bd:ce:de:0b:32:
        34:d9:de:28:ed:33:6b:c4:d4:d7:3d:12:58:ab:7d:09:2d:cb:
        70:f5:13:8a:94:a1:27:a4:d6:70:c5:6d:94:b5:c9:7d:9d:a0:
        d2:c6:08:49:d9:66:9b:a6:d3:f4:0b:dc:c5:26:57:e1:91:30:
        ea:cd', 'E43939931E52061B2836F8B2A329C5ED8EB211BDFEEBE7B474C28FFF05E7D99D06BF12C83F0EF2D6D124B211DED173098AD4B12C98090D1E5046B283A6458D6268BB851B207032AA40CDA6965FC471373F04F3B7412439071A1E2E6158A0120BE5A5DFC5ABEA3771CC1CC8373AB99752A7ACC56A24944E9C7BCFC06AD6DF21BD', '/C=US/O=Equifax Secure/OU=Equifax Secure eBusiness CA-2', 'C=US/O=Equifax Secure/OU=Equifax Secure eBusiness CA-2', '3770CFB5', NULL, '-----BEGIN CERTIFICATE-----
MIIDIDCCAomgAwIBAgIEN3DPtTANBgkqhkiG9w0BAQUFADBOMQswCQYDVQQGEwJV
UzEXMBUGA1UEChMORXF1aWZheCBTZWN1cmUxJjAkBgNVBAsTHUVxdWlmYXggU2Vj
dXJlIGVCdXNpbmVzcyBDQS0yMB4XDTk5MDYyMzEyMTQ0NVoXDTE5MDYyMzEyMTQ0
NVowTjELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkVxdWlmYXggU2VjdXJlMSYwJAYD
VQQLEx1FcXVpZmF4IFNlY3VyZSBlQnVzaW5lc3MgQ0EtMjCBnzANBgkqhkiG9w0B
AQEFAAOBjQAwgYkCgYEA5Dk5kx5SBhsoNviyoynF7Y6yEb3+6+e0dMKP/wXn2Z0G
vxLIPw7y1tEkshHe0XMJitSxLJgJDR5QRrKDpkWNYmi7hRsgcDKqQM2mll/EcTc/
BPO3QSQ5BxoeLmFYoBIL5aXfxavqN3HMHMg3OrmXUqesxWoklE6ce8/AatbfIb0C
AwEAAaOCAQkwggEFMHAGA1UdHwRpMGcwZaBjoGGkXzBdMQswCQYDVQQGEwJVUzEX
MBUGA1UEChMORXF1aWZheCBTZWN1cmUxJjAkBgNVBAsTHUVxdWlmYXggU2VjdXJl
IGVCdXNpbmVzcyBDQS0yMQ0wCwYDVQQDEwRDUkwxMBoGA1UdEAQTMBGBDzIwMTkw
NjIzMTIxNDQ1WjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAUUJ4L6q9euSBIplBq
y/3YIHqngnYwHQYDVR0OBBYEFFCeC+qvXrkgSKZQasv92CB6p4J2MAwGA1UdEwQF
MAMBAf8wGgYJKoZIhvZ9B0EABA0wCxsFVjMuMGMDAgbAMA0GCSqGSIb3DQEBBQUA
A4GBAAyGgq3oThr1jokn4jVYPSm0B482UJW/bsGe68SQsoWou7dC4A8HOd/7npCy
0cE+U58DRLB+S/Rv5Hwf5+Kx5Lia78O9zt4LMjTZ3ijtM2vE1Nc9ElirfQkty3D1
E4qUoSek1nDFbZS1yX2doNLGCEnZZpum0/QL3MUmV+GRMOrN
-----END CERTIFICATE-----', '7d0835e5c32c5788c75a167a38c9f0cf');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Equifax Secure Inc., CN=Equifax Secure eBusiness CA-1', 3, 1, 0, '1999-06-21 04:00:00', '2020-06-21 04:00:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 4 (0x4)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=US, O=Equifax Secure Inc., CN=Equifax Secure eBusiness CA-1
        Validity
            Not Before: Jun 21 04:00:00 1999 GMT
            Not After : Jun 21 04:00:00 2020 GMT
        Subject: C=US, O=Equifax Secure Inc., CN=Equifax Secure eBusiness CA-1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ce:2f:19:bc:17:b7:77:de:93:a9:5f:5a:0d:17:
                    4f:34:1a:0c:98:f4:22:d9:59:d4:c4:68:46:f0:b4:
                    35:c5:85:03:20:c6:af:45:a5:21:51:45:41:eb:16:
                    58:36:32:6f:e2:50:62:64:f9:fd:51:9c:aa:24:d9:
                    f4:9d:83:2a:87:0a:21:d3:12:38:34:6c:8d:00:6e:
                    5a:a0:d9:42:ee:1a:21:95:f9:52:4c:55:5a:c5:0f:
                    38:4f:46:fa:6d:f8:2e:35:d6:1d:7c:eb:e2:f0:b0:
                    75:80:c8:a9:13:ac:be:88:ef:3a:6e:ab:5f:2a:38:
                    62:02:b0:12:7b:fe:8f:a6:03
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:4A:78:32:52:11:DB:59:16:36:5E:DF:C1:14:36:40:6A:47:7C:4C:A1

            X509v3 Subject Key Identifier: 
                4A:78:32:52:11:DB:59:16:36:5E:DF:C1:14:36:40:6A:47:7C:4C:A1
    Signature Algorithm: md5WithRSAEncryption
        75:5b:a8:9b:03:11:e6:e9:56:4c:cd:f9:a9:4c:c0:0d:9a:f3:
        cc:65:69:e6:25:76:cc:59:b7:d6:54:c3:1d:cd:99:ac:19:dd:
        b4:85:d5:e0:3d:fc:62:20:a7:84:4b:58:65:f1:e2:f9:95:21:
        3f:f5:d4:7e:58:1e:47:87:54:3e:58:a1:b5:b5:f8:2a:ef:71:
        e7:bc:c3:f6:b1:49:46:e2:d7:a0:6b:e5:56:7a:9a:27:98:7c:
        46:62:14:e7:c9:fc:6e:03:12:79:80:38:1d:48:82:8d:fc:17:
        fe:2a:96:2b:b5:62:a6:a6:3d:bd:7f:92:59:cd:5a:2a:82:b2:
        37:79', 'CE2F19BC17B777DE93A95F5A0D174F341A0C98F422D959D4C46846F0B435C5850320C6AF45A521514541EB165836326FE2506264F9FD519CAA24D9F49D832A870A21D31238346C8D006E5AA0D942EE1A2195F9524C555AC50F384F46FA6DF82E35D61D7CEBE2F0B07580C8A913ACBE88EF3A6EAB5F2A386202B0127BFE8FA603', '/C=US/O=Equifax Secure Inc./CN=Equifax Secure eBusiness CA-1', 'C=US/O=Equifax Secure Inc./CN=Equifax Secure eBusiness CA-1', '04', NULL, '-----BEGIN CERTIFICATE-----
MIICgjCCAeugAwIBAgIBBDANBgkqhkiG9w0BAQQFADBTMQswCQYDVQQGEwJVUzEc
MBoGA1UEChMTRXF1aWZheCBTZWN1cmUgSW5jLjEmMCQGA1UEAxMdRXF1aWZheCBT
ZWN1cmUgZUJ1c2luZXNzIENBLTEwHhcNOTkwNjIxMDQwMDAwWhcNMjAwNjIxMDQw
MDAwWjBTMQswCQYDVQQGEwJVUzEcMBoGA1UEChMTRXF1aWZheCBTZWN1cmUgSW5j
LjEmMCQGA1UEAxMdRXF1aWZheCBTZWN1cmUgZUJ1c2luZXNzIENBLTEwgZ8wDQYJ
KoZIhvcNAQEBBQADgY0AMIGJAoGBAM4vGbwXt3fek6lfWg0XTzQaDJj0ItlZ1MRo
RvC0NcWFAyDGr0WlIVFFQesWWDYyb+JQYmT5/VGcqiTZ9J2DKocKIdMSODRsjQBu
WqDZQu4aIZX5UkxVWsUPOE9G+m34LjXWHXzr4vCwdYDIqROsvojvOm6rXyo4YgKw
Env+j6YDAgMBAAGjZjBkMBEGCWCGSAGG+EIBAQQEAwIABzAPBgNVHRMBAf8EBTAD
AQH/MB8GA1UdIwQYMBaAFEp4MlIR21kWNl7fwRQ2QGpHfEyhMB0GA1UdDgQWBBRK
eDJSEdtZFjZe38EUNkBqR3xMoTANBgkqhkiG9w0BAQQFAAOBgQB1W6ibAxHm6VZM
zfmpTMANmvPMZWnmJXbMWbfWVMMdzZmsGd20hdXgPfxiIKeES1hl8eL5lSE/9dR+
WB5Hh1Q+WKG1tfgq73HnvMP2sUlG4tega+VWeponmHxGYhTnyfxuAxJ5gDgdSIKN
/Bf+KpYrtWKmpj29f5JZzVoqgrI3eQ==
-----END CERTIFICATE-----', '083dabd6d75420e9911d7e095b57350a');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Equifax Secure Inc., CN=Equifax Secure Global eBusiness CA-1', 3, 1, 0, '1999-06-21 04:00:00', '2020-06-21 04:00:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=US, O=Equifax Secure Inc., CN=Equifax Secure Global eBusiness CA-1
        Validity
            Not Before: Jun 21 04:00:00 1999 GMT
            Not After : Jun 21 04:00:00 2020 GMT
        Subject: C=US, O=Equifax Secure Inc., CN=Equifax Secure Global eBusiness CA-1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ba:e7:17:90:02:65:b1:34:55:3c:49:c2:51:d5:
                    df:a7:d1:37:8f:d1:e7:81:73:41:52:60:9b:9d:a1:
                    17:26:78:ad:c7:b1:e8:26:94:32:b5:de:33:8d:3a:
                    2f:db:f2:9a:7a:5a:73:98:a3:5c:e9:fb:8a:73:1b:
                    5c:e7:c3:bf:80:6c:cd:a9:f4:d6:2b:c0:f7:f9:99:
                    aa:63:a2:b1:47:02:0f:d4:e4:51:3a:12:3c:6c:8a:
                    5a:54:84:70:db:c1:c5:90:cf:72:45:cb:a8:59:c0:
                    cd:33:9d:3f:a3:96:eb:85:33:21:1c:3e:1e:3e:60:
                    6e:76:9c:67:85:c5:c8:c3:61
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:BE:A8:A0:74:72:50:6B:44:B7:C9:23:D8:FB:A8:FF:B3:57:6B:68:6C

            X509v3 Subject Key Identifier: 
                BE:A8:A0:74:72:50:6B:44:B7:C9:23:D8:FB:A8:FF:B3:57:6B:68:6C
    Signature Algorithm: md5WithRSAEncryption
        30:e2:01:51:aa:c7:ea:5f:da:b9:d0:65:0f:30:d6:3e:da:0d:
        14:49:6e:91:93:27:14:31:ef:c4:f7:2d:45:f8:ec:c7:bf:a2:
        41:0d:23:b4:92:f9:19:00:67:bd:01:af:cd:e0:71:fc:5a:cf:
        64:c4:e0:96:98:d0:a3:40:e2:01:8a:ef:27:07:f1:65:01:8a:
        44:2d:06:65:75:52:c0:86:10:20:21:5f:6c:6b:0f:6c:ae:09:
        1c:af:f2:a2:18:34:c4:75:a4:73:1c:f1:8d:dc:ef:ad:f9:b3:
        76:b4:92:bf:dc:95:10:1e:be:cb:c8:3b:5a:84:60:19:56:94:
        a9:55', 'BAE717900265B134553C49C251D5DFA7D1378FD1E781734152609B9DA1172678ADC7B1E8269432B5DE338D3A2FDBF29A7A5A7398A35CE9FB8A731B5CE7C3BF806CCDA9F4D62BC0F7F999AA63A2B147020FD4E4513A123C6C8A5A548470DBC1C590CF7245CBA859C0CD339D3FA396EB8533211C3E1E3E606E769C6785C5C8C361', '/C=US/O=Equifax Secure Inc./CN=Equifax Secure Global eBusiness CA-1', 'C=US/O=Equifax Secure Inc./CN=Equifax Secure Global eBusiness CA-1', '01', NULL, '-----BEGIN CERTIFICATE-----
MIICkDCCAfmgAwIBAgIBATANBgkqhkiG9w0BAQQFADBaMQswCQYDVQQGEwJVUzEc
MBoGA1UEChMTRXF1aWZheCBTZWN1cmUgSW5jLjEtMCsGA1UEAxMkRXF1aWZheCBT
ZWN1cmUgR2xvYmFsIGVCdXNpbmVzcyBDQS0xMB4XDTk5MDYyMTA0MDAwMFoXDTIw
MDYyMTA0MDAwMFowWjELMAkGA1UEBhMCVVMxHDAaBgNVBAoTE0VxdWlmYXggU2Vj
dXJlIEluYy4xLTArBgNVBAMTJEVxdWlmYXggU2VjdXJlIEdsb2JhbCBlQnVzaW5l
c3MgQ0EtMTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAuucXkAJlsTRVPEnC
UdXfp9E3j9HngXNBUmCbnaEXJnitx7HoJpQytd4zjTov2/KaelpzmKNc6fuKcxtc
58O/gGzNqfTWK8D3+ZmqY6KxRwIP1ORROhI8bIpaVIRw28HFkM9yRcuoWcDNM50/
o5brhTMhHD4ePmBudpxnhcXIw2ECAwEAAaNmMGQwEQYJYIZIAYb4QgEBBAQDAgAH
MA8GA1UdEwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAUvqigdHJQa0S3ySPY+6j/s1dr
aGwwHQYDVR0OBBYEFL6ooHRyUGtEt8kj2Puo/7NXa2hsMA0GCSqGSIb3DQEBBAUA
A4GBADDiAVGqx+pf2rnQZQ8w1j7aDRRJbpGTJxQx78T3LUX47Me/okENI7SS+RkA
Z70Br83gcfxaz2TE4JaY0KNA4gGK7ycH8WUBikQtBmV1UsCGECAhX2xrD2yuCRyv
8qIYNMR1pHMc8Y3c7635s3a0kr/clRAevsvIO1qEYBlWlKlV
-----END CERTIFICATE-----', 'beb8ddbf2ba54a0d1dec0adf443e3c85');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=GeoTrust Inc., CN=GeoTrust Global CA', 3, 1, 0, '2002-05-21 04:00:00', '2022-05-21 04:00:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 144470 (0x23456)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=GeoTrust Inc., CN=GeoTrust Global CA
        Validity
            Not Before: May 21 04:00:00 2002 GMT
            Not After : May 21 04:00:00 2022 GMT
        Subject: C=US, O=GeoTrust Inc., CN=GeoTrust Global CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:da:cc:18:63:30:fd:f4:17:23:1a:56:7e:5b:df:
                    3c:6c:38:e4:71:b7:78:91:d4:bc:a1:d8:4c:f8:a8:
                    43:b6:03:e9:4d:21:07:08:88:da:58:2f:66:39:29:
                    bd:05:78:8b:9d:38:e8:05:b7:6a:7e:71:a4:e6:c4:
                    60:a6:b0:ef:80:e4:89:28:0f:9e:25:d6:ed:83:f3:
                    ad:a6:91:c7:98:c9:42:18:35:14:9d:ad:98:46:92:
                    2e:4f:ca:f1:87:43:c1:16:95:57:2d:50:ef:89:2d:
                    80:7a:57:ad:f2:ee:5f:6b:d2:00:8d:b9:14:f8:14:
                    15:35:d9:c0:46:a3:7b:72:c8:91:bf:c9:55:2b:cd:
                    d0:97:3e:9c:26:64:cc:df:ce:83:19:71:ca:4e:e6:
                    d4:d5:7b:a9:19:cd:55:de:c8:ec:d2:5e:38:53:e5:
                    5c:4f:8c:2d:fe:50:23:36:fc:66:e6:cb:8e:a4:39:
                    19:00:b7:95:02:39:91:0b:0e:fe:38:2e:d1:1d:05:
                    9a:f6:4d:3e:6f:0f:07:1d:af:2c:1e:8f:60:39:e2:
                    fa:36:53:13:39:d4:5e:26:2b:db:3d:a8:14:bd:32:
                    eb:18:03:28:52:04:71:e5:ab:33:3d:e1:38:bb:07:
                    36:84:62:9c:79:ea:16:30:f4:5f:c0:2b:e8:71:6b:
                    e4:f9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                C0:7A:98:68:8D:89:FB:AB:05:64:0C:11:7D:AA:7D:65:B8:CA:CC:4E
            X509v3 Authority Key Identifier: 
                keyid:C0:7A:98:68:8D:89:FB:AB:05:64:0C:11:7D:AA:7D:65:B8:CA:CC:4E

    Signature Algorithm: sha1WithRSAEncryption
        35:e3:29:6a:e5:2f:5d:54:8e:29:50:94:9f:99:1a:14:e4:8f:
        78:2a:62:94:a2:27:67:9e:d0:cf:1a:5e:47:e9:c1:b2:a4:cf:
        dd:41:1a:05:4e:9b:4b:ee:4a:6f:55:52:b3:24:a1:37:0a:eb:
        64:76:2a:2e:2c:f3:fd:3b:75:90:bf:fa:71:d8:c7:3d:37:d2:
        b5:05:95:62:b9:a6:de:89:3d:36:7b:38:77:48:97:ac:a6:20:
        8f:2e:a6:c9:0c:c2:b2:99:45:00:c7:ce:11:51:22:22:e0:a5:
        ea:b6:15:48:09:64:ea:5e:4f:74:f7:05:3e:c7:8a:52:0c:db:
        15:b4:bd:6d:9b:e5:c6:b1:54:68:a9:e3:69:90:b6:9a:a5:0f:
        b8:b9:3f:20:7d:ae:4a:b5:b8:9c:e4:1d:b6:ab:e6:94:a5:c1:
        c7:83:ad:db:f5:27:87:0e:04:6c:d5:ff:dd:a0:5d:ed:87:52:
        b7:2b:15:02:ae:39:a6:6a:74:e9:da:c4:e7:bc:4d:34:1e:a9:
        5c:4d:33:5f:92:09:2f:88:66:5d:77:97:c7:1d:76:13:a9:d5:
        e5:f1:16:09:11:35:d5:ac:db:24:71:70:2c:98:56:0b:d9:17:
        b4:d1:e3:51:2b:5e:75:e8:d5:d0:dc:4f:34:ed:c2:05:66:80:
        a1:cb:e6:33', 'DACC186330FDF417231A567E5BDF3C6C38E471B77891D4BCA1D84CF8A843B603E94D21070888DA582F663929BD05788B9D38E805B76A7E71A4E6C460A6B0EF80E489280F9E25D6ED83F3ADA691C798C9421835149DAD9846922E4FCAF18743C11695572D50EF892D807A57ADF2EE5F6BD2008DB914F8141535D9C046A37B72C891BFC9552BCDD0973E9C2664CCDFCE831971CA4EE6D4D57BA919CD55DEC8ECD25E3853E55C4F8C2DFE502336FC66E6CB8EA4391900B7950239910B0EFE382ED11D059AF64D3E6F0F071DAF2C1E8F6039E2FA36531339D45E262BDB3DA814BD32EB180328520471E5AB333DE138BB073684629C79EA1630F45FC02BE8716BE4F9', '/C=US/O=GeoTrust Inc./CN=GeoTrust Global CA', 'C=US/O=GeoTrust Inc./CN=GeoTrust Global CA', '023456', NULL, '-----BEGIN CERTIFICATE-----
MIIDVDCCAjygAwIBAgIDAjRWMA0GCSqGSIb3DQEBBQUAMEIxCzAJBgNVBAYTAlVT
MRYwFAYDVQQKEw1HZW9UcnVzdCBJbmMuMRswGQYDVQQDExJHZW9UcnVzdCBHbG9i
YWwgQ0EwHhcNMDIwNTIxMDQwMDAwWhcNMjIwNTIxMDQwMDAwWjBCMQswCQYDVQQG
EwJVUzEWMBQGA1UEChMNR2VvVHJ1c3QgSW5jLjEbMBkGA1UEAxMSR2VvVHJ1c3Qg
R2xvYmFsIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2swYYzD9
9BcjGlZ+W988bDjkcbd4kdS8odhM+KhDtgPpTSEHCIjaWC9mOSm9BXiLnTjoBbdq
fnGk5sRgprDvgOSJKA+eJdbtg/OtppHHmMlCGDUUna2YRpIuT8rxh0PBFpVXLVDv
iS2Aelet8u5fa9IAjbkU+BQVNdnARqN7csiRv8lVK83Qlz6cJmTM386DGXHKTubU
1XupGc1V3sjs0l44U+VcT4wt/lAjNvxm5suOpDkZALeVAjmRCw7+OC7RHQWa9k0+
bw8HHa8sHo9gOeL6NlMTOdReJivbPagUvTLrGAMoUgRx5aszPeE4uwc2hGKceeoW
MPRfwCvocWvk+QIDAQABo1MwUTAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBTA
ephojYn7qwVkDBF9qn1luMrMTjAfBgNVHSMEGDAWgBTAephojYn7qwVkDBF9qn1l
uMrMTjANBgkqhkiG9w0BAQUFAAOCAQEANeMpauUvXVSOKVCUn5kaFOSPeCpilKIn
Z57QzxpeR+nBsqTP3UEaBU6bS+5Kb1VSsyShNwrrZHYqLizz/Tt1kL/6cdjHPTfS
tQWVYrmm3ok9Nns4d0iXrKYgjy6myQzCsplFAMfOEVEiIuCl6rYVSAlk6l5PdPcF
PseKUgzbFbS9bZvlxrFUaKnjaZC2mqUPuLk/IH2uSrW4nOQdtqvmlKXBx4Ot2/Un
hw4EbNX/3aBd7YdStysVAq45pmp06drE57xNNB6pXE0zX5IJL4hmXXeXxx12E6nV
5fEWCRE11azbJHFwLJhWC9kXtNHjUStedejV0NxPNO3CBWaAocvmMw==
-----END CERTIFICATE-----', 'a59fa24705ed0be7ff6b00d5f3aefd5c');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=GoDaddy.com, Inc., CN=Go Daddy Root Certificate Authority - G2', 3, 1, 0, '2009-09-01 00:00:00', '2037-12-31 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, ST=Arizona, L=Scottsdale, O=GoDaddy.com, Inc., CN=Go Daddy Root Certificate Authority - G2
        Validity
            Not Before: Sep  1 00:00:00 2009 GMT
            Not After : Dec 31 23:59:59 2037 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=GoDaddy.com, Inc., CN=Go Daddy Root Certificate Authority - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:bf:71:62:08:f1:fa:59:34:f7:1b:c9:18:a3:f7:
                    80:49:58:e9:22:83:13:a6:c5:20:43:01:3b:84:f1:
                    e6:85:49:9f:27:ea:f6:84:1b:4e:a0:b4:db:70:98:
                    c7:32:01:b1:05:3e:07:4e:ee:f4:fa:4f:2f:59:30:
                    22:e7:ab:19:56:6b:e2:80:07:fc:f3:16:75:80:39:
                    51:7b:e5:f9:35:b6:74:4e:a9:8d:82:13:e4:b6:3f:
                    a9:03:83:fa:a2:be:8a:15:6a:7f:de:0b:c3:b6:19:
                    14:05:ca:ea:c3:a8:04:94:3b:46:7c:32:0d:f3:00:
                    66:22:c8:8d:69:6d:36:8c:11:18:b7:d3:b2:1c:60:
                    b4:38:fa:02:8c:ce:d3:dd:46:07:de:0a:3e:eb:5d:
                    7c:c8:7c:fb:b0:2b:53:a4:92:62:69:51:25:05:61:
                    1a:44:81:8c:2c:a9:43:96:23:df:ac:3a:81:9a:0e:
                    29:c5:1c:a9:e9:5d:1e:b6:9e:9e:30:0a:39:ce:f1:
                    88:80:fb:4b:5d:cc:32:ec:85:62:43:25:34:02:56:
                    27:01:91:b4:3b:70:2a:3f:6e:b1:e8:9c:88:01:7d:
                    9f:d4:f9:db:53:6d:60:9d:bf:2c:e7:58:ab:b8:5f:
                    46:fc:ce:c4:1b:03:3c:09:eb:49:31:5c:69:46:b3:
                    e0:47
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                3A:9A:85:07:10:67:28:B6:EF:F6:BD:05:41:6E:20:C1:94:DA:0F:DE
    Signature Algorithm: sha256WithRSAEncryption
        99:db:5d:79:d5:f9:97:59:67:03:61:f1:7e:3b:06:31:75:2d:
        a1:20:8e:4f:65:87:b4:f7:a6:9c:bc:d8:e9:2f:d0:db:5a:ee:
        cf:74:8c:73:b4:38:42:da:05:7b:f8:02:75:b8:fd:a5:b1:d7:
        ae:f6:d7:de:13:cb:53:10:7e:8a:46:d1:97:fa:b7:2e:2b:11:
        ab:90:b0:27:80:f9:e8:9f:5a:e9:37:9f:ab:e4:df:6c:b3:85:
        17:9d:3d:d9:24:4f:79:91:35:d6:5f:04:eb:80:83:ab:9a:02:
        2d:b5:10:f4:d8:90:c7:04:73:40:ed:72:25:a0:a9:9f:ec:9e:
        ab:68:12:99:57:c6:8f:12:3a:09:a4:bd:44:fd:06:15:37:c1:
        9b:e4:32:a3:ed:38:e8:d8:64:f3:2c:7e:14:fc:02:ea:9f:cd:
        ff:07:68:17:db:22:90:38:2d:7a:8d:d1:54:f1:69:e3:5f:33:
        ca:7a:3d:7b:0a:e3:ca:7f:5f:39:e5:e2:75:ba:c5:76:18:33:
        ce:2c:f0:2f:4c:ad:f7:b1:e7:ce:4f:a8:c4:9b:4a:54:06:c5:
        7f:7d:d5:08:0f:e2:1c:fe:7e:17:b8:ac:5e:f6:d4:16:b2:43:
        09:0c:4d:f6:a7:6b:b4:99:84:65:ca:7a:88:e2:e2:44:be:5c:
        f7:ea:1c:f5', 'BF716208F1FA5934F71BC918A3F7804958E9228313A6C52043013B84F1E685499F27EAF6841B4EA0B4DB7098C73201B1053E074EEEF4FA4F2F593022E7AB19566BE28007FCF316758039517BE5F935B6744EA98D8213E4B63FA90383FAA2BE8A156A7FDE0BC3B6191405CAEAC3A804943B467C320DF3006622C88D696D368C1118B7D3B21C60B438FA028CCED3DD4607DE0A3EEB5D7CC87CFBB02B53A4926269512505611A44818C2CA9439623DFAC3A819A0E29C51CA9E95D1EB69E9E300A39CEF18880FB4B5DCC32EC85624325340256270191B43B702A3F6EB1E89C88017D9FD4F9DB536D609DBF2CE758ABB85F46FCCEC41B033C09EB49315C6946B3E047', '/C=US/ST=Arizona/L=Scottsdale/O=GoDaddy.com, Inc./CN=Go Daddy Root Certificate Authority - G2', 'C=US/ST=Arizona/L=Scottsdale/O=GoDaddy.com, Inc./CN=Go Daddy Root Certificate Authority - G2', '00', NULL, '-----BEGIN CERTIFICATE-----
MIIDxTCCAq2gAwIBAgIBADANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMCVVMx
EDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxGjAYBgNVBAoT
EUdvRGFkZHkuY29tLCBJbmMuMTEwLwYDVQQDEyhHbyBEYWRkeSBSb290IENlcnRp
ZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTA5MDkwMTAwMDAwMFoXDTM3MTIzMTIz
NTk1OVowgYMxCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdBcml6b25hMRMwEQYDVQQH
EwpTY290dHNkYWxlMRowGAYDVQQKExFHb0RhZGR5LmNvbSwgSW5jLjExMC8GA1UE
AxMoR28gRGFkZHkgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgLSBHMjCCASIw
DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAL9xYgjx+lk09xvJGKP3gElY6SKD
E6bFIEMBO4Tx5oVJnyfq9oQbTqC023CYxzIBsQU+B07u9PpPL1kwIuerGVZr4oAH
/PMWdYA5UXvl+TW2dE6pjYIT5LY/qQOD+qK+ihVqf94Lw7YZFAXK6sOoBJQ7Rnwy
DfMAZiLIjWltNowRGLfTshxgtDj6AozO091GB94KPutdfMh8+7ArU6SSYmlRJQVh
GkSBjCypQ5Yj36w6gZoOKcUcqeldHraenjAKOc7xiID7S13MMuyFYkMlNAJWJwGR
tDtwKj9useiciAF9n9T521NtYJ2/LOdYq7hfRvzOxBsDPAnrSTFcaUaz4EcCAwEA
AaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYE
FDqahQcQZyi27/a9BUFuIMGU2g/eMA0GCSqGSIb3DQEBCwUAA4IBAQCZ21151fmX
WWcDYfF+OwYxdS2hII5PZYe096acvNjpL9DbWu7PdIxztDhC2gV7+AJ1uP2lsdeu
9tfeE8tTEH6KRtGX+rcuKxGrkLAngPnon1rpN5+r5N9ss4UXnT3ZJE95kTXWXwTr
gIOrmgIttRD02JDHBHNA7XIloKmf7J6raBKZV8aPEjoJpL1E/QYVN8Gb5DKj7Tjo
2GTzLH4U/ALqn83/B2gX2yKQOC16jdFU8WnjXzPKej17CuPKf1855eJ1usV2GDPO
LPAvTK33sefOT6jEm0pUBsV/fdUID+Ic/n4XuKxe9tQWskMJDE32p2u0mYRlynqI
4uJEvlz36hz1
-----END CERTIFICATE-----', '1e8af9a33f6e16fa41e03feb1412ab84');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=GoDaddy.com, Inc., CN=Go Daddy Secure Certificate Authority - G2', 3, 1, 0, '2011-05-03 07:00:00', '2031-05-03 07:00:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 7 (0x7)
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, ST=Arizona, L=Scottsdale, O=GoDaddy.com, Inc., CN=Go Daddy Root Certificate Authority - G2
        Validity
            Not Before: May  3 07:00:00 2011 GMT
            Not After : May  3 07:00:00 2031 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=GoDaddy.com, Inc., OU=http://certs.godaddy.com/repository/, CN=Go Daddy Secure Certificate Authority - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b9:e0:cb:10:d4:af:76:bd:d4:93:62:eb:30:64:
                    b8:81:08:6c:c3:04:d9:62:17:8e:2f:ff:3e:65:cf:
                    8f:ce:62:e6:3c:52:1c:da:16:45:4b:55:ab:78:6b:
                    63:83:62:90:ce:0f:69:6c:99:c8:1a:14:8b:4c:cc:
                    45:33:ea:88:dc:9e:a3:af:2b:fe:80:61:9d:79:57:
                    c4:cf:2e:f4:3f:30:3c:5d:47:fc:9a:16:bc:c3:37:
                    96:41:51:8e:11:4b:54:f8:28:be:d0:8c:be:f0:30:
                    38:1e:f3:b0:26:f8:66:47:63:6d:de:71:26:47:8f:
                    38:47:53:d1:46:1d:b4:e3:dc:00:ea:45:ac:bd:bc:
                    71:d9:aa:6f:00:db:db:cd:30:3a:79:4f:5f:4c:47:
                    f8:1d:ef:5b:c2:c4:9d:60:3b:b1:b2:43:91:d8:a4:
                    33:4e:ea:b3:d6:27:4f:ad:25:8a:a5:c6:f4:d5:d0:
                    a6:ae:74:05:64:57:88:b5:44:55:d4:2d:2a:3a:3e:
                    f8:b8:bd:e9:32:0a:02:94:64:c4:16:3a:50:f1:4a:
                    ae:e7:79:33:af:0c:20:07:7f:e8:df:04:39:c2:69:
                    02:6c:63:52:fa:77:c1:1b:c8:74:87:c8:b9:93:18:
                    50:54:35:4b:69:4e:bc:3b:d3:49:2e:1f:dc:c1:d2:
                    52:fb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                40:C2:BD:27:8E:CC:34:83:30:A2:33:D7:FB:6C:B3:F0:B4:2C:80:CE
            X509v3 Authority Key Identifier: 
                keyid:3A:9A:85:07:10:67:28:B6:EF:F6:BD:05:41:6E:20:C1:94:DA:0F:DE

            Authority Information Access: 
                OCSP - URI:http://ocsp.godaddy.com/

            X509v3 CRL Distribution Points: 
                URI:http://crl.godaddy.com/gdroot-g2.crl

            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: https://certs.godaddy.com/repository/

    Signature Algorithm: sha256WithRSAEncryption
        08:7e:6c:93:10:c8:38:b8:96:a9:90:4b:ff:a1:5f:4f:04:ef:
        6c:3e:9c:88:06:c9:50:8f:a6:73:f7:57:31:1b:be:bc:e4:2f:
        db:f8:ba:d3:5b:e0:b4:e7:e6:79:62:0e:0c:a2:d7:6a:63:73:
        31:b5:f5:a8:48:a4:3b:08:2d:a2:5d:90:d7:b4:7c:25:4f:11:
        56:30:c4:b6:44:9d:7b:2c:9d:e5:5e:e6:ef:0c:61:aa:bf:e4:
        2a:1b:ee:84:9e:b8:83:7d:c1:43:ce:44:a7:13:70:0d:91:1f:
        f4:c8:13:ad:83:60:d9:d8:72:a8:73:24:1e:b5:ac:22:0e:ca:
        17:89:62:58:44:1b:ab:89:25:01:00:0f:cd:c4:1b:62:db:51:
        b4:d3:0f:51:2a:9b:f4:bc:73:fc:76:ce:36:a4:cd:d9:d8:2c:
        ea:ae:9b:f5:2a:b2:90:d1:4d:75:18:8a:3f:8a:41:90:23:7d:
        5b:4b:fe:a4:03:58:9b:46:b2:c3:60:60:83:f8:7d:50:41:ce:
        c2:a1:90:c3:bb:ef:02:2f:d2:15:54:ee:44:15:d9:0a:ae:a7:
        8a:33:ed:b1:2d:76:36:26:dc:04:eb:9f:f7:61:1f:15:dc:87:
        6f:ee:46:96:28:ad:a1:26:7d:0a:09:a7:2e:04:a3:8d:bc:f8:
        bc:04:30:01', 'B9E0CB10D4AF76BDD49362EB3064B881086CC304D962178E2FFF3E65CF8FCE62E63C521CDA16454B55AB786B63836290CE0F696C99C81A148B4CCC4533EA88DC9EA3AF2BFE80619D7957C4CF2EF43F303C5D47FC9A16BCC3379641518E114B54F828BED08CBEF030381EF3B026F86647636DDE7126478F384753D1461DB4E3DC00EA45ACBDBC71D9AA6F00DBDBCD303A794F5F4C47F81DEF5BC2C49D603BB1B24391D8A4334EEAB3D6274FAD258AA5C6F4D5D0A6AE7405645788B54455D42D2A3A3EF8B8BDE9320A029464C4163A50F14AAEE77933AF0C20077FE8DF0439C269026C6352FA77C11BC87487C8B993185054354B694EBC3BD3492E1FDCC1D252FB', '/C=US/ST=Arizona/L=Scottsdale/O=GoDaddy.com, Inc./OU=http://certs.godaddy.com/repository//CN=Go Daddy Secure Certificate Authority - G2', 'C=US/ST=Arizona/L=Scottsdale/O=GoDaddy.com, Inc./CN=Go Daddy Root Certificate Authority - G2', '07', NULL, '-----BEGIN CERTIFICATE-----
MIIE0DCCA7igAwIBAgIBBzANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMCVVMx
EDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxGjAYBgNVBAoT
EUdvRGFkZHkuY29tLCBJbmMuMTEwLwYDVQQDEyhHbyBEYWRkeSBSb290IENlcnRp
ZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTExMDUwMzA3MDAwMFoXDTMxMDUwMzA3
MDAwMFowgbQxCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdBcml6b25hMRMwEQYDVQQH
EwpTY290dHNkYWxlMRowGAYDVQQKExFHb0RhZGR5LmNvbSwgSW5jLjEtMCsGA1UE
CxMkaHR0cDovL2NlcnRzLmdvZGFkZHkuY29tL3JlcG9zaXRvcnkvMTMwMQYDVQQD
EypHbyBEYWRkeSBTZWN1cmUgQ2VydGlmaWNhdGUgQXV0aG9yaXR5IC0gRzIwggEi
MA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC54MsQ1K92vdSTYuswZLiBCGzD
BNliF44v/z5lz4/OYuY8UhzaFkVLVat4a2ODYpDOD2lsmcgaFItMzEUz6ojcnqOv
K/6AYZ15V8TPLvQ/MDxdR/yaFrzDN5ZBUY4RS1T4KL7QjL7wMDge87Am+GZHY23e
cSZHjzhHU9FGHbTj3ADqRay9vHHZqm8A29vNMDp5T19MR/gd71vCxJ1gO7GyQ5HY
pDNO6rPWJ0+tJYqlxvTV0KaudAVkV4i1RFXULSo6Pvi4vekyCgKUZMQWOlDxSq7n
eTOvDCAHf+jfBDnCaQJsY1L6d8EbyHSHyLmTGFBUNUtpTrw700kuH9zB0lL7AgMB
AAGjggEaMIIBFjAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBBjAdBgNV
HQ4EFgQUQMK9J47MNIMwojPX+2yz8LQsgM4wHwYDVR0jBBgwFoAUOpqFBxBnKLbv
9r0FQW4gwZTaD94wNAYIKwYBBQUHAQEEKDAmMCQGCCsGAQUFBzABhhhodHRwOi8v
b2NzcC5nb2RhZGR5LmNvbS8wNQYDVR0fBC4wLDAqoCigJoYkaHR0cDovL2NybC5n
b2RhZGR5LmNvbS9nZHJvb3QtZzIuY3JsMEYGA1UdIAQ/MD0wOwYEVR0gADAzMDEG
CCsGAQUFBwIBFiVodHRwczovL2NlcnRzLmdvZGFkZHkuY29tL3JlcG9zaXRvcnkv
MA0GCSqGSIb3DQEBCwUAA4IBAQAIfmyTEMg4uJapkEv/oV9PBO9sPpyIBslQj6Zz
91cxG7685C/b+LrTW+C05+Z5Yg4MotdqY3MxtfWoSKQ7CC2iXZDXtHwlTxFWMMS2
RJ17LJ3lXubvDGGqv+QqG+6EnriDfcFDzkSnE3ANkR/0yBOtg2DZ2HKocyQetawi
DsoXiWJYRBuriSUBAA/NxBti21G00w9RKpv0vHP8ds42pM3Z2Czqrpv1KrKQ0U11
GIo/ikGQI31bS/6kA1ibRrLDYGCD+H1QQc7CoZDDu+8CL9IVVO5EFdkKrqeKM+2x
LXY2JtwE65/3YR8V3Idv7kaWKK2hJn0KCacuBKONvPi8BDAB
-----END CERTIFICATE-----', '29655b47dfda20e8e1f4c7878371a292');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=GoDaddy.com, Inc., CN=Go Daddy Secure Certification Authority', 3, 1, 0, '2006-11-16 01:54:37', '2026-11-16 01:54:37', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 769 (0x301)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=The Go Daddy Group, Inc., OU=Go Daddy Class 2 Certification Authority
        Validity
            Not Before: Nov 16 01:54:37 2006 GMT
            Not After : Nov 16 01:54:37 2026 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=GoDaddy.com, Inc., OU=http://certificates.godaddy.com/repository, CN=Go Daddy Secure Certification Authority/serialNumber=07969287
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:c4:2d:d5:15:8c:9c:26:4c:ec:32:35:eb:5f:b8:
                    59:01:5a:a6:61:81:59:3b:70:63:ab:e3:dc:3d:c7:
                    2a:b8:c9:33:d3:79:e4:3a:ed:3c:30:23:84:8e:b3:
                    30:14:b6:b2:87:c3:3d:95:54:04:9e:df:99:dd:0b:
                    25:1e:21:de:65:29:7e:35:a8:a9:54:eb:f6:f7:32:
                    39:d4:26:55:95:ad:ef:fb:fe:58:86:d7:9e:f4:00:
                    8d:8c:2a:0c:bd:42:04:ce:a7:3f:04:f6:ee:80:f2:
                    aa:ef:52:a1:69:66:da:be:1a:ad:5d:da:2c:66:ea:
                    1a:6b:bb:e5:1a:51:4a:00:2f:48:c7:98:75:d8:b9:
                    29:c8:ee:f8:66:6d:0a:9c:b3:f3:fc:78:7c:a2:f8:
                    a3:f2:b5:c3:f3:b9:7a:91:c1:a7:e6:25:2e:9c:a8:
                    ed:12:65:6e:6a:f6:12:44:53:70:30:95:c3:9c:2b:
                    58:2b:3d:08:74:4a:f2:be:51:b0:bf:87:d0:4c:27:
                    58:6b:b5:35:c5:9d:af:17:31:f8:0b:8f:ee:ad:81:
                    36:05:89:08:98:cf:3a:af:25:87:c0:49:ea:a7:fd:
                    67:f7:45:8e:97:cc:14:39:e2:36:85:b5:7e:1a:37:
                    fd:16:f6:71:11:9a:74:30:16:fe:13:94:a3:3f:84:
                    0d:4f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                FD:AC:61:32:93:6C:45:D6:E2:EE:85:5F:9A:BA:E7:76:99:68:CC:E7
            X509v3 Authority Key Identifier: 
                keyid:D2:C4:B0:D2:91:D4:4C:11:71:B3:61:CB:3D:A1:FE:DD:A8:6A:D4:E3

            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            Authority Information Access: 
                OCSP - URI:http://ocsp.godaddy.com

            X509v3 CRL Distribution Points: 
                URI:http://certificates.godaddy.com/repository/gdroot.crl

            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: http://certificates.godaddy.com/repository

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        d2:86:c0:ec:bd:f9:a1:b6:67:ee:66:0b:a2:06:3a:04:50:8e:
        15:72:ac:4a:74:95:53:cb:37:cb:44:49:ef:07:90:6b:33:d9:
        96:f0:94:56:a5:13:30:05:3c:85:32:21:7b:c9:c7:0a:a8:24:
        a4:90:de:46:d3:25:23:14:03:67:c2:10:d6:6f:0f:5d:7b:7a:
        cc:9f:c5:58:2a:c1:c4:9e:21:a8:5a:f3:ac:a4:46:f3:9e:e4:
        63:cb:2f:90:a4:29:29:01:d9:72:2c:29:df:37:01:27:bc:4f:
        ee:68:d3:21:8f:c0:b3:e4:f5:09:ed:d2:10:aa:53:b4:be:f0:
        cc:59:0b:d6:3b:96:1c:95:24:49:df:ce:ec:fd:a7:48:91:14:
        45:0e:3a:36:6f:da:45:b3:45:a2:41:c9:d4:d7:44:4e:3e:b9:
        74:76:d5:a2:13:55:2c:c6:87:a3:b5:99:ac:06:84:87:7f:75:
        06:fc:bf:14:4c:0e:cc:6e:c4:df:3d:b7:12:71:f4:e8:f1:51:
        40:22:28:49:e0:1d:4b:87:a8:34:cc:06:a2:dd:12:5a:d1:86:
        36:64:03:35:6f:6f:77:6e:eb:f2:85:50:98:5e:ab:03:53:ad:
        91:23:63:1f:16:9c:cd:b9:b2:05:63:3a:e1:f4:68:1b:17:05:
        35:95:53:ee', 'C42DD5158C9C264CEC3235EB5FB859015AA66181593B7063ABE3DC3DC72AB8C933D379E43AED3C3023848EB33014B6B287C33D9554049EDF99DD0B251E21DE65297E35A8A954EBF6F73239D4265595ADEFFBFE5886D79EF4008D8C2A0CBD4204CEA73F04F6EE80F2AAEF52A16966DABE1AAD5DDA2C66EA1A6BBBE51A514A002F48C79875D8B929C8EEF8666D0A9CB3F3FC787CA2F8A3F2B5C3F3B97A91C1A7E6252E9CA8ED12656E6AF6124453703095C39C2B582B3D08744AF2BE51B0BF87D04C27586BB535C59DAF1731F80B8FEEAD813605890898CF3AAF2587C049EAA7FD67F7458E97CC1439E23685B57E1A37FD16F671119A743016FE1394A33F840D4F', '/C=US/ST=Arizona/L=Scottsdale/O=GoDaddy.com, Inc./OU=http://certificates.godaddy.com/repository/CN=Go Daddy Secure Certification Authority/serialNumber=07969287', 'C=US/O=The Go Daddy Group, Inc./OU=Go Daddy Class 2 Certification Authority', '0301', NULL, '-----BEGIN CERTIFICATE-----
MIIE3jCCA8agAwIBAgICAwEwDQYJKoZIhvcNAQEFBQAwYzELMAkGA1UEBhMCVVMx
ITAfBgNVBAoTGFRoZSBHbyBEYWRkeSBHcm91cCwgSW5jLjExMC8GA1UECxMoR28g
RGFkZHkgQ2xhc3MgMiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wNjExMTYw
MTU0MzdaFw0yNjExMTYwMTU0MzdaMIHKMQswCQYDVQQGEwJVUzEQMA4GA1UECBMH
QXJpem9uYTETMBEGA1UEBxMKU2NvdHRzZGFsZTEaMBgGA1UEChMRR29EYWRkeS5j
b20sIEluYy4xMzAxBgNVBAsTKmh0dHA6Ly9jZXJ0aWZpY2F0ZXMuZ29kYWRkeS5j
b20vcmVwb3NpdG9yeTEwMC4GA1UEAxMnR28gRGFkZHkgU2VjdXJlIENlcnRpZmlj
YXRpb24gQXV0aG9yaXR5MREwDwYDVQQFEwgwNzk2OTI4NzCCASIwDQYJKoZIhvcN
AQEBBQADggEPADCCAQoCggEBAMQt1RWMnCZM7DI161+4WQFapmGBWTtwY6vj3D3H
KrjJM9N55DrtPDAjhI6zMBS2sofDPZVUBJ7fmd0LJR4h3mUpfjWoqVTr9vcyOdQm
VZWt7/v+WIbXnvQAjYwqDL1CBM6nPwT27oDyqu9SoWlm2r4arV3aLGbqGmu75RpR
SgAvSMeYddi5Kcju+GZtCpyz8/x4fKL4o/K1w/O5epHBp+YlLpyo7RJlbmr2EkRT
cDCVw5wrWCs9CHRK8r5RsL+H0EwnWGu1NcWdrxcx+AuP7q2BNgWJCJjPOq8lh8BJ
6qf9Z/dFjpfMFDniNoW1fho3/Rb2cRGadDAW/hOUoz+EDU8CAwEAAaOCATIwggEu
MB0GA1UdDgQWBBT9rGEyk2xF1uLuhV+auud2mWjM5zAfBgNVHSMEGDAWgBTSxLDS
kdRMEXGzYcs9of7dqGrU4zASBgNVHRMBAf8ECDAGAQH/AgEAMDMGCCsGAQUFBwEB
BCcwJTAjBggrBgEFBQcwAYYXaHR0cDovL29jc3AuZ29kYWRkeS5jb20wRgYDVR0f
BD8wPTA7oDmgN4Y1aHR0cDovL2NlcnRpZmljYXRlcy5nb2RhZGR5LmNvbS9yZXBv
c2l0b3J5L2dkcm9vdC5jcmwwSwYDVR0gBEQwQjBABgRVHSAAMDgwNgYIKwYBBQUH
AgEWKmh0dHA6Ly9jZXJ0aWZpY2F0ZXMuZ29kYWRkeS5jb20vcmVwb3NpdG9yeTAO
BgNVHQ8BAf8EBAMCAQYwDQYJKoZIhvcNAQEFBQADggEBANKGwOy9+aG2Z+5mC6IG
OgRQjhVyrEp0lVPLN8tESe8HkGsz2ZbwlFalEzAFPIUyIXvJxwqoJKSQ3kbTJSMU
A2fCENZvD117esyfxVgqwcSeIaha86ykRvOe5GPLL5CkKSkB2XIsKd83ASe8T+5o
0yGPwLPk9Qnt0hCqU7S+8MxZC9Y7lhyVJEnfzuz9p0iRFEUOOjZv2kWzRaJBydTX
RE4+uXR21aITVSzGh6O1mawGhId/dQb8vxRMDsxuxN89txJx9OjxUUAiKEngHUuH
qDTMBqLdElrRhjZkAzVvb3du6/KFUJheqwNTrZEjYx8WnM25sgVjOuH0aBsXBTWV
U+4=
-----END CERTIFICATE-----', '3ddb4e4856a653f2caae15e06000df8f');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Starfield Technologies, Inc.', 3, 1, 0, '2004-06-29 17:39:16', '2034-06-29 17:39:16', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Starfield Technologies, Inc., OU=Starfield Class 2 Certification Authority
        Validity
            Not Before: Jun 29 17:39:16 2004 GMT
            Not After : Jun 29 17:39:16 2034 GMT
        Subject: C=US, O=Starfield Technologies, Inc., OU=Starfield Class 2 Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b7:32:c8:fe:e9:71:a6:04:85:ad:0c:11:64:df:
                    ce:4d:ef:c8:03:18:87:3f:a1:ab:fb:3c:a6:9f:f0:
                    c3:a1:da:d4:d8:6e:2b:53:90:fb:24:a4:3e:84:f0:
                    9e:e8:5f:ec:e5:27:44:f5:28:a6:3f:7b:de:e0:2a:
                    f0:c8:af:53:2f:9e:ca:05:01:93:1e:8f:66:1c:39:
                    a7:4d:fa:5a:b6:73:04:25:66:eb:77:7f:e7:59:c6:
                    4a:99:25:14:54:eb:26:c7:f3:7f:19:d5:30:70:8f:
                    af:b0:46:2a:ff:ad:eb:29:ed:d7:9f:aa:04:87:a3:
                    d4:f9:89:a5:34:5f:db:43:91:82:36:d9:66:3c:b1:
                    b8:b9:82:fd:9c:3a:3e:10:c8:3b:ef:06:65:66:7a:
                    9b:19:18:3d:ff:71:51:3c:30:2e:5f:be:3d:77:73:
                    b2:5d:06:6c:c3:23:56:9a:2b:85:26:92:1c:a7:02:
                    b3:e4:3f:0d:af:08:79:82:b8:36:3d:ea:9c:d3:35:
                    b3:bc:69:ca:f5:cc:9d:e8:fd:64:8d:17:80:33:6e:
                    5e:4a:5d:99:c9:1e:87:b4:9d:1a:c0:d5:6e:13:35:
                    23:5e:df:9b:5f:3d:ef:d6:f7:76:c2:ea:3e:bb:78:
                    0d:1c:42:67:6b:04:d8:f8:d6:da:6f:8b:f2:44:a0:
                    01:ab
                Exponent: 3 (0x3)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                BF:5F:B7:D1:CE:DD:1F:86:F4:5B:55:AC:DC:D7:10:C2:0E:A9:88:E7
            X509v3 Authority Key Identifier: 
                keyid:BF:5F:B7:D1:CE:DD:1F:86:F4:5B:55:AC:DC:D7:10:C2:0E:A9:88:E7
                DirName:/C=US/O=Starfield Technologies, Inc./OU=Starfield Class 2 Certification Authority
                serial:00

            X509v3 Basic Constraints: 
                CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        05:9d:3f:88:9d:d1:c9:1a:55:a1:ac:69:f3:f3:59:da:9b:01:
        87:1a:4f:57:a9:a1:79:09:2a:db:f7:2f:b2:1e:cc:c7:5e:6a:
        d8:83:87:a1:97:ef:49:35:3e:77:06:41:58:62:bf:8e:58:b8:
        0a:67:3f:ec:b3:dd:21:66:1f:c9:54:fa:72:cc:3d:4c:40:d8:
        81:af:77:9e:83:7a:bb:a2:c7:f5:34:17:8e:d9:11:40:f4:fc:
        2c:2a:4d:15:7f:a7:62:5d:2e:25:d3:00:0b:20:1a:1d:68:f9:
        17:b8:f4:bd:8b:ed:28:59:dd:4d:16:8b:17:83:c8:b2:65:c7:
        2d:7a:a5:aa:bc:53:86:6d:dd:57:a4:ca:f8:20:41:0b:68:f0:
        f4:fb:74:be:56:5d:7a:79:f5:f9:1d:85:e3:2d:95:be:f5:71:
        90:43:cc:8d:1f:9a:00:0a:87:29:e9:55:22:58:00:23:ea:e3:
        12:43:29:5b:47:08:dd:8c:41:6a:65:06:a8:e5:21:aa:41:b4:
        95:21:95:b9:7d:d1:34:ab:13:d6:ad:bc:dc:e2:3d:39:cd:bd:
        3e:75:70:a1:18:59:03:c9:22:b4:8f:9c:d5:5e:2a:d7:a5:b6:
        d4:0a:6d:f8:b7:40:11:46:9a:1f:79:0e:62:bf:0f:97:ec:e0:
        2f:1f:17:94', 'B732C8FEE971A60485AD0C1164DFCE4DEFC80318873FA1ABFB3CA69FF0C3A1DAD4D86E2B5390FB24A43E84F09EE85FECE52744F528A63F7BDEE02AF0C8AF532F9ECA0501931E8F661C39A74DFA5AB673042566EB777FE759C64A99251454EB26C7F37F19D530708FAFB0462AFFADEB29EDD79FAA0487A3D4F989A5345FDB43918236D9663CB1B8B982FD9C3A3E10C83BEF0665667A9B19183DFF71513C302E5FBE3D7773B25D066CC323569A2B8526921CA702B3E43F0DAF087982B8363DEA9CD335B3BC69CAF5CC9DE8FD648D1780336E5E4A5D99C91E87B49D1AC0D56E1335235EDF9B5F3DEFD6F776C2EA3EBB780D1C42676B04D8F8D6DA6F8BF244A001AB', '/C=US/O=Starfield Technologies, Inc./OU=Starfield Class 2 Certification Authority', 'C=US/O=Starfield Technologies, Inc./OU=Starfield Class 2 Certification Authority', '00', NULL, '-----BEGIN CERTIFICATE-----
MIIEDzCCAvegAwIBAgIBADANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQGEwJVUzEl
MCMGA1UEChMcU3RhcmZpZWxkIFRlY2hub2xvZ2llcywgSW5jLjEyMDAGA1UECxMp
U3RhcmZpZWxkIENsYXNzIDIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMDQw
NjI5MTczOTE2WhcNMzQwNjI5MTczOTE2WjBoMQswCQYDVQQGEwJVUzElMCMGA1UE
ChMcU3RhcmZpZWxkIFRlY2hub2xvZ2llcywgSW5jLjEyMDAGA1UECxMpU3RhcmZp
ZWxkIENsYXNzIDIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwggEgMA0GCSqGSIb3
DQEBAQUAA4IBDQAwggEIAoIBAQC3Msj+6XGmBIWtDBFk385N78gDGIc/oav7PKaf
8MOh2tTYbitTkPskpD6E8J7oX+zlJ0T1KKY/e97gKvDIr1MvnsoFAZMej2YcOadN
+lq2cwQlZut3f+dZxkqZJRRU6ybH838Z1TBwj6+wRir/resp7defqgSHo9T5iaU0
X9tDkYI22WY8sbi5gv2cOj4QyDvvBmVmepsZGD3/cVE8MC5fvj13c7JdBmzDI1aa
K4UmkhynArPkPw2vCHmCuDY96pzTNbO8acr1zJ3o/WSNF4Azbl5KXZnJHoe0nRrA
1W4TNSNe35tfPe/W93bC6j67eA0cQmdrBNj41tpvi/JEoAGrAgEDo4HFMIHCMB0G
A1UdDgQWBBS/X7fRzt0fhvRbVazc1xDCDqmI5zCBkgYDVR0jBIGKMIGHgBS/X7fR
zt0fhvRbVazc1xDCDqmI56FspGowaDELMAkGA1UEBhMCVVMxJTAjBgNVBAoTHFN0
YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xMjAwBgNVBAsTKVN0YXJmaWVsZCBD
bGFzcyAyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMAwGA1UdEwQFMAMBAf8w
DQYJKoZIhvcNAQEFBQADggEBAAWdP4id0ckaVaGsafPzWdqbAYcaT1epoXkJKtv3
L7IezMdeatiDh6GX70k1PncGQVhiv45YuApnP+yz3SFmH8lU+nLMPUxA2IGvd56D
eruix/U0F47ZEUD0/CwqTRV/p2JdLiXTAAsgGh1o+Re49L2L7ShZ3U0WixeDyLJl
xy16paq8U4Zt3VekyvggQQto8PT7dL5WXXp59fkdheMtlb71cZBDzI0fmgAKhynp
VSJYACPq4xJDKVtHCN2MQWplBqjlIapBtJUhlbl90TSrE9atvNziPTnNvT51cKEY
WQPJIrSPnNVeKtelttQKbfi3QBFGmh95DmK/D5fs4C8fF5Q=
-----END CERTIFICATE-----', '758158cc118b07162bbe84f2baad7709');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Starfield Technologies, Inc., CN=Starfield Root Certificate Authority - G2', 3, 1, 0, '2009-09-01 00:00:00', '2037-12-31 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., CN=Starfield Root Certificate Authority - G2
        Validity
            Not Before: Sep  1 00:00:00 2009 GMT
            Not After : Dec 31 23:59:59 2037 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., CN=Starfield Root Certificate Authority - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:bd:ed:c1:03:fc:f6:8f:fc:02:b1:6f:5b:9f:48:
                    d9:9d:79:e2:a2:b7:03:61:56:18:c3:47:b6:d7:ca:
                    3d:35:2e:89:43:f7:a1:69:9b:de:8a:1a:fd:13:20:
                    9c:b4:49:77:32:29:56:fd:b9:ec:8c:dd:22:fa:72:
                    dc:27:61:97:ee:f6:5a:84:ec:6e:19:b9:89:2c:dc:
                    84:5b:d5:74:fb:6b:5f:c5:89:a5:10:52:89:46:55:
                    f4:b8:75:1c:e6:7f:e4:54:ae:4b:f8:55:72:57:02:
                    19:f8:17:71:59:eb:1e:28:07:74:c5:9d:48:be:6c:
                    b4:f4:a4:b0:f3:64:37:79:92:c0:ec:46:5e:7f:e1:
                    6d:53:4c:62:af:cd:1f:0b:63:bb:3a:9d:fb:fc:79:
                    00:98:61:74:cf:26:82:40:63:f3:b2:72:6a:19:0d:
                    99:ca:d4:0e:75:cc:37:fb:8b:89:c1:59:f1:62:7f:
                    5f:b3:5f:65:30:f8:a7:b7:4d:76:5a:1e:76:5e:34:
                    c0:e8:96:56:99:8a:b3:f0:7f:a4:cd:bd:dc:32:31:
                    7c:91:cf:e0:5f:11:f8:6b:aa:49:5c:d1:99:94:d1:
                    a2:e3:63:5b:09:76:b5:56:62:e1:4b:74:1d:96:d4:
                    26:d4:08:04:59:d0:98:0e:0e:e6:de:fc:c3:ec:1f:
                    90:f1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                7C:0C:32:1F:A7:D9:30:7F:C4:7D:68:A3:62:A8:A1:CE:AB:07:5B:27
    Signature Algorithm: sha256WithRSAEncryption
        11:59:fa:25:4f:03:6f:94:99:3b:9a:1f:82:85:39:d4:76:05:
        94:5e:e1:28:93:6d:62:5d:09:c2:a0:a8:d4:b0:75:38:f1:34:
        6a:9d:e4:9f:8a:86:26:51:e6:2c:d1:c6:2d:6e:95:20:4a:92:
        01:ec:b8:8a:67:7b:31:e2:67:2e:8c:95:03:26:2e:43:9d:4a:
        31:f6:0e:b5:0c:bb:b7:e2:37:7f:22:ba:00:a3:0e:7b:52:fb:
        6b:bb:3b:c4:d3:79:51:4e:cd:90:f4:67:07:19:c8:3c:46:7a:
        0d:01:7d:c5:58:e7:6d:e6:85:30:17:9a:24:c4:10:e0:04:f7:
        e0:f2:7f:d4:aa:0a:ff:42:1d:37:ed:94:e5:64:59:12:20:77:
        38:d3:32:3e:38:81:75:96:73:fa:68:8f:b1:cb:ce:1f:c5:ec:
        fa:9c:7e:cf:7e:b1:f1:07:2d:b6:fc:bf:ca:a4:bf:d0:97:05:
        4a:bc:ea:18:28:02:90:bd:54:78:09:21:71:d3:d1:7d:1d:d9:
        16:b0:a9:61:3d:d0:0a:00:22:fc:c7:7b:cb:09:64:45:0b:3b:
        40:81:f7:7d:7c:32:f5:98:ca:58:8e:7d:2a:ee:90:59:73:64:
        f9:36:74:5e:25:a1:f5:66:05:2e:7f:39:15:a9:2a:fb:50:8b:
        8e:85:69:f4', 'BDEDC103FCF68FFC02B16F5B9F48D99D79E2A2B703615618C347B6D7CA3D352E8943F7A1699BDE8A1AFD13209CB44977322956FDB9EC8CDD22FA72DC276197EEF65A84EC6E19B9892CDC845BD574FB6B5FC589A51052894655F4B8751CE67FE454AE4BF85572570219F8177159EB1E280774C59D48BE6CB4F4A4B0F364377992C0EC465E7FE16D534C62AFCD1F0B63BB3A9DFBFC7900986174CF26824063F3B2726A190D99CAD40E75CC37FB8B89C159F1627F5FB35F6530F8A7B74D765A1E765E34C0E89656998AB3F07FA4CDBDDC32317C91CFE05F11F86BAA495CD19994D1A2E3635B0976B55662E14B741D96D426D4080459D0980E0EE6DEFCC3EC1F90F1', '/C=US/ST=Arizona/L=Scottsdale/O=Starfield Technologies, Inc./CN=Starfield Root Certificate Authority - G2', 'C=US/ST=Arizona/L=Scottsdale/O=Starfield Technologies, Inc./CN=Starfield Root Certificate Authority - G2', '00', NULL, '-----BEGIN CERTIFICATE-----
MIID3TCCAsWgAwIBAgIBADANBgkqhkiG9w0BAQsFADCBjzELMAkGA1UEBhMCVVMx
EDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxJTAjBgNVBAoT
HFN0YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xMjAwBgNVBAMTKVN0YXJmaWVs
ZCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTA5MDkwMTAwMDAw
MFoXDTM3MTIzMTIzNTk1OVowgY8xCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdBcml6
b25hMRMwEQYDVQQHEwpTY290dHNkYWxlMSUwIwYDVQQKExxTdGFyZmllbGQgVGVj
aG5vbG9naWVzLCBJbmMuMTIwMAYDVQQDEylTdGFyZmllbGQgUm9vdCBDZXJ0aWZp
Y2F0ZSBBdXRob3JpdHkgLSBHMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
ggEBAL3twQP89o/8ArFvW59I2Z154qK3A2FWGMNHttfKPTUuiUP3oWmb3ooa/RMg
nLRJdzIpVv257IzdIvpy3Cdhl+72WoTsbhm5iSzchFvVdPtrX8WJpRBSiUZV9Lh1
HOZ/5FSuS/hVclcCGfgXcVnrHigHdMWdSL5stPSksPNkN3mSwOxGXn/hbVNMYq/N
Hwtjuzqd+/x5AJhhdM8mgkBj87JyahkNmcrUDnXMN/uLicFZ8WJ/X7NfZTD4p7dN
dloedl40wOiWVpmKs/B/pM293DIxfJHP4F8R+GuqSVzRmZTRouNjWwl2tVZi4Ut0
HZbUJtQIBFnQmA4O5t78w+wfkPECAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAO
BgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFHwMMh+n2TB/xH1oo2Kooc6rB1snMA0G
CSqGSIb3DQEBCwUAA4IBAQARWfolTwNvlJk7mh+ChTnUdgWUXuEok21iXQnCoKjU
sHU48TRqneSfioYmUeYs0cYtbpUgSpIB7LiKZ3sx4mcujJUDJi5DnUox9g61DLu3
4jd/IroAow57UvtruzvE03lRTs2Q9GcHGcg8RnoNAX3FWOdt5oUwF5okxBDgBPfg
8n/Uqgr/Qh037ZTlZFkSIHc40zI+OIF1lnP6aI+xy84fxez6nH7PfrHxBy22/L/K
pL/QlwVKvOoYKAKQvVR4CSFx09F9HdkWsKlhPdAKACL8x3vLCWRFCztAgfd9fDL1
mMpYjn0q7pBZc2T5NnReJaH1ZgUufzkVqSr7UIuOhWn0
-----END CERTIFICATE-----', '59ded95ba90cc18fc757e2d9045b58f6');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Starfield Technologies, Inc., CN=Starfield Secure Certificate Authority - G2', 3, 1, 0, '2011-05-03 07:00:00', '2031-05-03 07:00:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 7 (0x7)
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., CN=Starfield Root Certificate Authority - G2
        Validity
            Not Before: May  3 07:00:00 2011 GMT
            Not After : May  3 07:00:00 2031 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., OU=http://certs.starfieldtech.com/repository/, CN=Starfield Secure Certificate Authority - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:e5:90:66:4b:ec:f9:46:71:a9:20:83:be:e9:6c:
                    bf:4a:c9:48:69:81:75:4e:6d:24:f6:cb:17:13:f8:
                    b0:71:59:84:7a:6b:2b:85:a4:34:b5:16:e5:cb:cc:
                    e9:41:70:2c:a4:2e:d6:fa:32:7d:e1:a8:de:94:10:
                    ac:31:c1:c0:d8:6a:ff:59:27:ab:76:d6:fc:0b:74:
                    6b:b8:a7:ae:3f:c4:54:f4:b4:31:44:dd:93:56:8c:
                    a4:4c:5e:9b:89:cb:24:83:9b:e2:57:7d:b7:d8:12:
                    1f:c9:85:6d:f4:d1:80:f1:50:9b:87:ae:d4:0b:10:
                    05:fb:27:ba:28:6d:17:e9:0e:d6:4d:b9:39:55:06:
                    ff:0a:24:05:7e:2f:c6:1d:72:6c:d4:8b:29:8c:57:
                    7d:da:d9:eb:66:1a:d3:4f:a7:df:7f:52:c4:30:c5:
                    a5:c9:0e:02:c5:53:bf:77:38:68:06:24:c3:66:c8:
                    37:7e:30:1e:45:71:23:35:ff:90:d8:2a:9d:8d:e7:
                    b0:92:4d:3c:7f:2a:0a:93:dc:cd:16:46:65:f7:60:
                    84:8b:76:4b:91:27:73:14:92:e0:ea:ee:8f:16:ea:
                    8d:0e:3e:76:17:bf:7d:89:80:80:44:43:e7:2d:e0:
                    43:09:75:da:36:e8:ad:db:89:3a:f5:5d:12:8e:23:
                    04:83
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                25:45:81:68:50:26:38:3D:3B:2D:2C:BE:CD:6A:D9:B6:3D:B3:66:63
            X509v3 Authority Key Identifier: 
                keyid:7C:0C:32:1F:A7:D9:30:7F:C4:7D:68:A3:62:A8:A1:CE:AB:07:5B:27

            Authority Information Access: 
                OCSP - URI:http://ocsp.starfieldtech.com/

            X509v3 CRL Distribution Points: 
                URI:http://crl.starfieldtech.com/sfroot-g2.crl

            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: https://certs.starfieldtech.com/repository/

    Signature Algorithm: sha256WithRSAEncryption
        56:65:ca:fe:f3:3f:0a:a8:93:8b:18:c7:de:43:69:13:34:20:
        be:4e:5f:78:a8:6b:9c:db:6a:4d:41:db:c1:13:ec:dc:31:00:
        22:5e:f7:00:9e:0c:e0:34:65:34:f9:b1:3a:4e:48:c8:12:81:
        88:5c:5b:3e:08:53:7a:f7:1a:64:df:b8:50:61:cc:53:51:40:
        29:4b:c2:f4:ae:3a:5f:e4:ca:ad:26:cc:4e:61:43:e5:fd:57:
        a6:37:70:ce:43:2b:b0:94:c3:92:e9:e1:5f:aa:10:49:b7:69:
        e4:e0:d0:1f:64:a4:2b:cd:1f:6f:a0:f8:84:24:18:ce:79:3d:
        a9:91:bf:54:18:13:89:99:54:11:0d:55:c5:26:0b:79:4f:5a:
        1c:6e:f9:63:db:14:80:a4:07:ab:fa:b2:a5:b9:88:dd:91:fe:
        65:3b:a4:a3:79:be:89:4d:e1:d0:b0:f4:c8:17:0c:0a:96:14:
        7c:09:b7:6c:e1:c2:d8:55:d4:18:a0:aa:41:69:70:24:a3:b9:
        ef:e9:5a:dc:3e:eb:94:4a:f0:b7:de:5f:0e:76:fa:fb:fb:69:
        03:45:40:50:ee:72:0c:a4:12:86:81:cd:13:d1:4e:c4:3c:ca:
        4e:0d:d2:26:f1:00:b7:b4:a6:a2:e1:6e:7a:81:fd:30:ac:7a:
        1f:c7:59:7b', 'E590664BECF94671A92083BEE96CBF4AC9486981754E6D24F6CB1713F8B07159847A6B2B85A434B516E5CBCCE941702CA42ED6FA327DE1A8DE9410AC31C1C0D86AFF5927AB76D6FC0B746BB8A7AE3FC454F4B43144DD93568CA44C5E9B89CB24839BE2577DB7D8121FC9856DF4D180F1509B87AED40B1005FB27BA286D17E90ED64DB9395506FF0A24057E2FC61D726CD48B298C577DDAD9EB661AD34FA7DF7F52C430C5A5C90E02C553BF7738680624C366C8377E301E45712335FF90D82A9D8DE7B0924D3C7F2A0A93DCCD164665F760848B764B9127731492E0EAEE8F16EA8D0E3E7617BF7D8980804443E72DE0430975DA36E8ADDB893AF55D128E230483', '/C=US/ST=Arizona/L=Scottsdale/O=Starfield Technologies, Inc./OU=http://certs.starfieldtech.com/repository//CN=Starfield Secure Certificate Authority - G2', 'C=US/ST=Arizona/L=Scottsdale/O=Starfield Technologies, Inc./CN=Starfield Root Certificate Authority - G2', '07', NULL, '-----BEGIN CERTIFICATE-----
MIIFADCCA+igAwIBAgIBBzANBgkqhkiG9w0BAQsFADCBjzELMAkGA1UEBhMCVVMx
EDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxJTAjBgNVBAoT
HFN0YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xMjAwBgNVBAMTKVN0YXJmaWVs
ZCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTExMDUwMzA3MDAw
MFoXDTMxMDUwMzA3MDAwMFowgcYxCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdBcml6
b25hMRMwEQYDVQQHEwpTY290dHNkYWxlMSUwIwYDVQQKExxTdGFyZmllbGQgVGVj
aG5vbG9naWVzLCBJbmMuMTMwMQYDVQQLEypodHRwOi8vY2VydHMuc3RhcmZpZWxk
dGVjaC5jb20vcmVwb3NpdG9yeS8xNDAyBgNVBAMTK1N0YXJmaWVsZCBTZWN1cmUg
Q2VydGlmaWNhdGUgQXV0aG9yaXR5IC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IB
DwAwggEKAoIBAQDlkGZL7PlGcakgg77pbL9KyUhpgXVObST2yxcT+LBxWYR6ayuF
pDS1FuXLzOlBcCykLtb6Mn3hqN6UEKwxwcDYav9ZJ6t21vwLdGu4p64/xFT0tDFE
3ZNWjKRMXpuJyySDm+JXfbfYEh/JhW300YDxUJuHrtQLEAX7J7oobRfpDtZNuTlV
Bv8KJAV+L8YdcmzUiymMV33a2etmGtNPp99/UsQwxaXJDgLFU793OGgGJMNmyDd+
MB5FcSM1/5DYKp2N57CSTTx/KgqT3M0WRmX3YISLdkuRJ3MUkuDq7o8W6o0OPnYX
v32JgIBEQ+ct4EMJddo26K3biTr1XRKOIwSDAgMBAAGjggEsMIIBKDAPBgNVHRMB
Af8EBTADAQH/MA4GA1UdDwEB/wQEAwIBBjAdBgNVHQ4EFgQUJUWBaFAmOD07LSy+
zWrZtj2zZmMwHwYDVR0jBBgwFoAUfAwyH6fZMH/EfWijYqihzqsHWycwOgYIKwYB
BQUHAQEELjAsMCoGCCsGAQUFBzABhh5odHRwOi8vb2NzcC5zdGFyZmllbGR0ZWNo
LmNvbS8wOwYDVR0fBDQwMjAwoC6gLIYqaHR0cDovL2NybC5zdGFyZmllbGR0ZWNo
LmNvbS9zZnJvb3QtZzIuY3JsMEwGA1UdIARFMEMwQQYEVR0gADA5MDcGCCsGAQUF
BwIBFitodHRwczovL2NlcnRzLnN0YXJmaWVsZHRlY2guY29tL3JlcG9zaXRvcnkv
MA0GCSqGSIb3DQEBCwUAA4IBAQBWZcr+8z8KqJOLGMfeQ2kTNCC+Tl94qGuc22pN
QdvBE+zcMQAiXvcAngzgNGU0+bE6TkjIEoGIXFs+CFN69xpk37hQYcxTUUApS8L0
rjpf5MqtJsxOYUPl/VemN3DOQyuwlMOS6eFfqhBJt2nk4NAfZKQrzR9voPiEJBjO
eT2pkb9UGBOJmVQRDVXFJgt5T1ocbvlj2xSApAer+rKluYjdkf5lO6Sjeb6JTeHQ
sPTIFwwKlhR8Cbds4cLYVdQYoKpBaXAko7nv6VrcPuuUSvC33l8Odvr7+2kDRUBQ
7nIMpBKGgc0T0U7EPMpODdIm8QC3tKai4W56gf0wrHofx1l7
-----END CERTIFICATE-----', 'b2ecb6d08bf20d2ef4e86f5abc0dff65');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Starfield Technologies, Inc., CN=Starfield Secure Certification Authority', 3, 1, 0, '2006-11-16 01:15:40', '2026-11-16 01:15:40', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 513 (0x201)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Starfield Technologies, Inc., OU=Starfield Class 2 Certification Authority
        Validity
            Not Before: Nov 16 01:15:40 2006 GMT
            Not After : Nov 16 01:15:40 2026 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., OU=http://certificates.starfieldtech.com/repository, CN=Starfield Secure Certification Authority/serialNumber=10688435
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:e2:a7:5d:a3:ed:66:ef:6a:2f:2b:36:1f:dd:8d:
                    d3:05:02:a0:ca:0f:5e:19:ae:38:72:cf:16:da:54:
                    4a:cb:48:0a:f4:a1:73:11:65:85:43:c9:5b:17:0c:
                    9a:2b:be:0f:98:51:7a:60:29:0d:6c:de:e2:e8:e5:
                    15:4d:56:ff:90:d1:a7:a6:04:3f:60:07:4a:ca:6f:
                    a5:10:e7:b3:f8:5c:b1:bc:2b:2a:dc:01:79:f5:1d:
                    35:f5:7a:28:83:f2:93:73:82:89:ac:60:6d:cb:c2:
                    48:c2:1d:d4:06:44:17:3c:ac:01:47:ab:3e:70:84:
                    09:0b:b8:20:08:40:20:87:a1:63:1a:ca:3e:83:d2:
                    37:b3:98:8d:32:3f:37:bf:a1:b7:5b:5f:de:5c:33:
                    92:cf:3e:07:ce:b9:48:4b:e2:f0:55:50:2f:f8:70:
                    42:89:d1:93:96:8a:63:d9:66:0d:e6:58:6e:b9:6d:
                    90:bd:ca:dc:84:66:f2:39:8e:5b:a6:58:55:73:cb:
                    62:6c:1b:d7:20:16:3b:2c:59:f5:cb:c8:56:32:4a:
                    50:27:ba:55:d3:a8:01:cb:72:a9:74:8b:0c:ad:3a:
                    e5:15:b6:2a:df:65:f8:de:8a:f5:ef:84:3b:f9:e7:
                    54:65:0b:80:bd:47:45:a5:f0:44:d8:53:3b:be:80:
                    f1:2f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                49:4B:52:27:D1:1B:BC:F2:A1:21:6A:62:7B:51:42:7A:8A:D7:D5:56
            X509v3 Authority Key Identifier: 
                keyid:BF:5F:B7:D1:CE:DD:1F:86:F4:5B:55:AC:DC:D7:10:C2:0E:A9:88:E7

            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            Authority Information Access: 
                OCSP - URI:http://ocsp.starfieldtech.com

            X509v3 CRL Distribution Points: 
                URI:http://certificates.starfieldtech.com/repository/sfroot.crl

            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: http://certificates.starfieldtech.com/repository

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        86:52:ba:b3:1f:a6:5e:6b:90:a6:64:2a:fc:45:b2:ae:9f:3e:
        b3:62:af:db:1f:67:c4:bd:ca:a1:2f:c7:9c:0d:21:57:d0:f8:
        36:21:ce:3a:25:3e:78:76:b3:d9:dd:bc:de:fb:6c:84:5f:0c:
        a3:0d:12:eb:11:3b:71:5f:80:1e:f1:1f:6d:0e:5f:c1:ec:d4:
        a5:f7:65:bb:1f:4c:95:01:13:b2:6a:9c:0b:eb:1f:9d:b1:e7:
        ed:19:0d:bc:85:7c:f3:17:bd:59:63:ae:a7:1a:05:cd:47:e3:
        2d:96:62:51:32:0a:08:68:4b:22:77:5f:f7:45:dc:61:de:f4:
        cb:2b:22:29:44:25:d2:9f:0b:77:7a:a1:26:7c:4a:d7:0f:c2:
        d1:3c:ba:0e:a7:95:9a:5b:05:0a:10:f9:55:5f:c1:97:8b:74:
        cc:5e:28:69:13:7e:d0:0a:8d:9d:0f:60:54:7a:c4:8c:1b:35:
        0f:74:7a:70:b2:82:cf:1d:b5:e2:8a:db:2a:c6:b2:51:69:bf:
        12:17:92:60:17:aa:3d:5b:09:f8:87:65:1d:a7:a4:28:e5:22:
        02:03:82:44:9a:34:63:9e:fb:28:cf:e8:cd:2e:0e:52:20:ed:
        4a:cb:38:7c:9d:ae:6e:79:d7:95:2c:a8:91:f3:86:01:21:91:
        4b:b5:40:a4', 'E2A75DA3ED66EF6A2F2B361FDD8DD30502A0CA0F5E19AE3872CF16DA544ACB480AF4A17311658543C95B170C9A2BBE0F98517A60290D6CDEE2E8E5154D56FF90D1A7A6043F60074ACA6FA510E7B3F85CB1BC2B2ADC0179F51D35F57A2883F293738289AC606DCBC248C21DD40644173CAC0147AB3E7084090BB82008402087A1631ACA3E83D237B3988D323F37BFA1B75B5FDE5C3392CF3E07CEB9484BE2F055502FF8704289D193968A63D9660DE6586EB96D90BDCADC8466F2398E5BA6585573CB626C1BD720163B2C59F5CBC856324A5027BA55D3A801CB72A9748B0CAD3AE515B62ADF65F8DE8AF5EF843BF9E754650B80BD4745A5F044D8533BBE80F12F', '/C=US/ST=Arizona/L=Scottsdale/O=Starfield Technologies, Inc./OU=http://certificates.starfieldtech.com/repository/CN=Starfield Secure Certification Authority/serialNumber=10688435', 'C=US/O=Starfield Technologies, Inc./OU=Starfield Class 2 Certification Authority', '0201', NULL, '-----BEGIN CERTIFICATE-----
MIIFBzCCA++gAwIBAgICAgEwDQYJKoZIhvcNAQEFBQAwaDELMAkGA1UEBhMCVVMx
JTAjBgNVBAoTHFN0YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xMjAwBgNVBAsT
KVN0YXJmaWVsZCBDbGFzcyAyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA2
MTExNjAxMTU0MFoXDTI2MTExNjAxMTU0MFowgdwxCzAJBgNVBAYTAlVTMRAwDgYD
VQQIEwdBcml6b25hMRMwEQYDVQQHEwpTY290dHNkYWxlMSUwIwYDVQQKExxTdGFy
ZmllbGQgVGVjaG5vbG9naWVzLCBJbmMuMTkwNwYDVQQLEzBodHRwOi8vY2VydGlm
aWNhdGVzLnN0YXJmaWVsZHRlY2guY29tL3JlcG9zaXRvcnkxMTAvBgNVBAMTKFN0
YXJmaWVsZCBTZWN1cmUgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxETAPBgNVBAUT
CDEwNjg4NDM1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4qddo+1m
72ovKzYf3Y3TBQKgyg9eGa44cs8W2lRKy0gK9KFzEWWFQ8lbFwyaK74PmFF6YCkN
bN7i6OUVTVb/kNGnpgQ/YAdKym+lEOez+FyxvCsq3AF59R019Xoog/KTc4KJrGBt
y8JIwh3UBkQXPKwBR6s+cIQJC7ggCEAgh6FjGso+g9I3s5iNMj83v6G3W1/eXDOS
zz4HzrlIS+LwVVAv+HBCidGTlopj2WYN5lhuuW2QvcrchGbyOY5bplhVc8tibBvX
IBY7LFn1y8hWMkpQJ7pV06gBy3KpdIsMrTrlFbYq32X43or174Q7+edUZQuAvUdF
pfBE2FM7voDxLwIDAQABo4IBRDCCAUAwHQYDVR0OBBYEFElLUifRG7zyoSFqYntR
QnqK19VWMB8GA1UdIwQYMBaAFL9ft9HO3R+G9FtVrNzXEMIOqYjnMBIGA1UdEwEB
/wQIMAYBAf8CAQAwOQYIKwYBBQUHAQEELTArMCkGCCsGAQUFBzABhh1odHRwOi8v
b2NzcC5zdGFyZmllbGR0ZWNoLmNvbTBMBgNVHR8ERTBDMEGgP6A9hjtodHRwOi8v
Y2VydGlmaWNhdGVzLnN0YXJmaWVsZHRlY2guY29tL3JlcG9zaXRvcnkvc2Zyb290
LmNybDBRBgNVHSAESjBIMEYGBFUdIAAwPjA8BggrBgEFBQcCARYwaHR0cDovL2Nl
cnRpZmljYXRlcy5zdGFyZmllbGR0ZWNoLmNvbS9yZXBvc2l0b3J5MA4GA1UdDwEB
/wQEAwIBBjANBgkqhkiG9w0BAQUFAAOCAQEAhlK6sx+mXmuQpmQq/EWyrp8+s2Kv
2x9nxL3KoS/HnA0hV9D4NiHOOiU+eHaz2d283vtshF8Mow0S6xE7cV+AHvEfbQ5f
wezUpfdlux9MlQETsmqcC+sfnbHn7RkNvIV88xe9WWOupxoFzUfjLZZiUTIKCGhL
Indf90XcYd70yysiKUQl0p8Ld3qhJnxK1w/C0Ty6DqeVmlsFChD5VV/Bl4t0zF4o
aRN+0AqNnQ9gVHrEjBs1D3R6cLKCzx214orbKsayUWm/EheSYBeqPVsJ+IdlHaek
KOUiAgOCRJo0Y577KM/ozS4OUiDtSss4fJ2ubnnXlSyokfOGASGRS7VApA==
-----END CERTIFICATE-----', '3257799c8d7c6bbe513ea6a5d104ee28');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Starfield Technologies, Inc., CN=Starfield Services Root Certificate Authority', 3, 1, 0, '2008-06-02 00:00:00', '2029-12-31 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., OU=http://certificates.starfieldtech.com/repository/, CN=Starfield Services Root Certificate Authority
        Validity
            Not Before: Jun  2 00:00:00 2008 GMT
            Not After : Dec 31 23:59:59 2029 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., OU=http://certificates.starfieldtech.com/repository/, CN=Starfield Services Root Certificate Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:f2:cc:56:2a:4d:e6:16:37:5a:97:ea:6d:35:38:
                    d1:10:9b:db:b8:dc:a9:04:09:95:33:2e:09:c5:00:
                    7b:1a:78:42:8f:c8:f4:05:8e:fe:d2:68:83:1e:4e:
                    99:cd:17:db:47:3e:50:f3:89:d2:e7:dc:98:fb:05:
                    f8:aa:d6:63:f4:54:4d:c1:71:03:b0:1f:1b:76:b3:
                    1a:34:30:73:f1:28:32:60:83:fd:b4:9c:d7:b6:d2:
                    22:37:7c:19:aa:3b:de:13:10:69:6e:5c:06:d3:6f:
                    a3:f2:66:5a:76:42:48:af:80:d1:54:59:3d:d4:b9:
                    d4:db:ed:b9:ab:39:99:f4:ee:62:ab:e1:78:72:7b:
                    d8:38:8d:40:b6:cc:dc:12:00:70:43:85:69:d8:18:
                    e3:ca:57:72:9f:b4:df:3f:fc:22:a8:42:52:f5:77:
                    5b:99:f0:56:2d:26:70:16:36:12:c2:27:9e:57:a6:
                    7c:d0:23:f1:79:dc:a3:93:58:28:38:3d:9f:ad:36:
                    43:ee:37:fb:f8:f9:43:ad:c8:56:f2:94:12:5e:42:
                    eb:73:b8:13:0d:cb:a6:d5:86:b9:aa:28:6a:54:03:
                    a1:3f:0f:29:eb:09:00:e8:3f:5e:a2:7f:17:3d:a1:
                    2b:f8:be:d0:75:1d:a4:84:e3:ab:17:65:06:52:00:
                    af:b1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                B4:C6:7F:1A:43:CC:9B:75:5D:2F:C4:4B:F2:8B:98:10:E9:F1:51:10
            X509v3 Authority Key Identifier: 
                keyid:B4:C6:7F:1A:43:CC:9B:75:5D:2F:C4:4B:F2:8B:98:10:E9:F1:51:10

    Signature Algorithm: sha1WithRSAEncryption
        ac:80:bb:c4:25:05:0b:58:a4:e4:7e:29:7e:af:bc:3b:ec:2d:
        c0:44:2e:f9:91:e0:d2:3b:32:27:90:2d:f6:80:09:5c:c2:ab:
        65:24:da:38:10:46:c4:49:d2:fd:9a:ab:28:48:77:88:c6:e9:
        6f:d1:47:91:d5:35:4f:14:09:a8:5b:40:07:1d:7c:71:56:cb:
        89:42:d4:bf:61:c0:22:f7:2e:df:ab:f3:72:43:8b:40:e8:94:
        eb:b0:26:da:d1:13:d3:ab:d0:36:2d:2e:3a:95:b3:77:2e:15:
        39:18:0c:69:ba:aa:80:ed:f1:53:4e:33:9b:68:04:e2:a0:30:
        2e:d7:d1:5d:d4:a6:66:9d:84:e6:e7:bb:3c:89:bb:36:9d:fc:
        17:a9:3d:55:2b:8a:fb:9b:c4:4c:84:ff:df:d2:be:69:1b:74:
        b0:a8:f6:ea:b0:9c:b2:29:74:81:4c:68:3a:9a:7f:73:25:39:
        f5:13:e0:66:91:69:d4:57:4b:b7:ee:ad:45:e0:2c:c3:88:d3:
        be:94:49:89:1f:ff:70:d5:5b:6d:39:13:b0:1d:cb:98:e6:67:
        63:0d:63:f6:fb:c3:d7:61:72:83:88:3f:70:7e:53:c9:9e:89:
        54:d6:4f:7f:7d:71:b9:ae:f1:60:8b:77:60:ec:f8:bf:fa:6a:
        a3:9c:01:22', 'F2CC562A4DE616375A97EA6D3538D1109BDBB8DCA9040995332E09C5007B1A78428FC8F4058EFED268831E4E99CD17DB473E50F389D2E7DC98FB05F8AAD663F4544DC17103B01F1B76B31A343073F128326083FDB49CD7B6D222377C19AA3BDE1310696E5C06D36FA3F2665A764248AF80D154593DD4B9D4DBEDB9AB3999F4EE62ABE178727BD8388D40B6CCDC120070438569D818E3CA57729FB4DF3FFC22A84252F5775B99F0562D2670163612C2279E57A67CD023F179DCA3935828383D9FAD3643EE37FBF8F943ADC856F294125E42EB73B8130DCBA6D586B9AA286A5403A13F0F29EB0900E83F5EA27F173DA12BF8BED0751DA484E3AB1765065200AFB1', '/C=US/ST=Arizona/L=Scottsdale/O=Starfield Technologies, Inc./OU=http://certificates.starfieldtech.com/repository//CN=Starfield Services Root Certificate Authority', 'C=US/ST=Arizona/L=Scottsdale/O=Starfield Technologies, Inc./OU=http://certificates.starfieldtech.com/repository//CN=Starfield Services Root Certificate Authority', '00', NULL, '-----BEGIN CERTIFICATE-----
MIIEfjCCA2agAwIBAgIBADANBgkqhkiG9w0BAQUFADCBzzELMAkGA1UEBhMCVVMx
EDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxJTAjBgNVBAoT
HFN0YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xOjA4BgNVBAsTMWh0dHA6Ly9j
ZXJ0aWZpY2F0ZXMuc3RhcmZpZWxkdGVjaC5jb20vcmVwb3NpdG9yeS8xNjA0BgNV
BAMTLVN0YXJmaWVsZCBTZXJ2aWNlcyBSb290IENlcnRpZmljYXRlIEF1dGhvcml0
eTAeFw0wODA2MDIwMDAwMDBaFw0yOTEyMzEyMzU5NTlaMIHPMQswCQYDVQQGEwJV
UzEQMA4GA1UECBMHQXJpem9uYTETMBEGA1UEBxMKU2NvdHRzZGFsZTElMCMGA1UE
ChMcU3RhcmZpZWxkIFRlY2hub2xvZ2llcywgSW5jLjE6MDgGA1UECxMxaHR0cDov
L2NlcnRpZmljYXRlcy5zdGFyZmllbGR0ZWNoLmNvbS9yZXBvc2l0b3J5LzE2MDQG
A1UEAxMtU3RhcmZpZWxkIFNlcnZpY2VzIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9y
aXR5MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA8sxWKk3mFjdal+pt
NTjREJvbuNypBAmVMy4JxQB7GnhCj8j0BY7+0miDHk6ZzRfbRz5Q84nS59yY+wX4
qtZj9FRNwXEDsB8bdrMaNDBz8SgyYIP9tJzXttIiN3wZqjveExBpblwG02+j8mZa
dkJIr4DRVFk91LnU2+25qzmZ9O5iq+F4cnvYOI1AtszcEgBwQ4Vp2Bjjyldyn7Tf
P/wiqEJS9XdbmfBWLSZwFjYSwieeV6Z80CPxedyjk1goOD2frTZD7jf7+PlDrchW
8pQSXkLrc7gTDcum1Ya5qihqVAOhPw8p6wkA6D9eon8XPaEr+L7QdR2khOOrF2UG
UgCvsQIDAQABo2MwYTAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBBjAd
BgNVHQ4EFgQUtMZ/GkPMm3VdL8RL8ouYEOnxURAwHwYDVR0jBBgwFoAUtMZ/GkPM
m3VdL8RL8ouYEOnxURAwDQYJKoZIhvcNAQEFBQADggEBAKyAu8QlBQtYpOR+KX6v
vDvsLcBELvmR4NI7MieQLfaACVzCq2Uk2jgQRsRJ0v2aqyhId4jG6W/RR5HVNU8U
CahbQAcdfHFWy4lC1L9hwCL3Lt+r83JDi0DolOuwJtrRE9Or0DYtLjqVs3cuFTkY
DGm6qoDt8VNOM5toBOKgMC7X0V3UpmadhObnuzyJuzad/BepPVUrivubxEyE/9/S
vmkbdLCo9uqwnLIpdIFMaDqaf3MlOfUT4GaRadRXS7furUXgLMOI076USYkf/3DV
W205E7Ady5jmZ2MNY/b7w9dhcoOIP3B+U8meiVTWT399cbmu8WCLd2Ds+L/6aqOc
ASI=
-----END CERTIFICATE-----', 'dbc3f745856bd8d5c3efcaeda2d2566c');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Starfield Technologies, Inc., CN=Starfield Services Root Certificate Authority - G2', 3, 1, 0, '2009-09-01 00:00:00', '2037-12-31 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., CN=Starfield Services Root Certificate Authority - G2
        Validity
            Not Before: Sep  1 00:00:00 2009 GMT
            Not After : Dec 31 23:59:59 2037 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., CN=Starfield Services Root Certificate Authority - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:d5:0c:3a:c4:2a:f9:4e:e2:f5:be:19:97:5f:8e:
                    88:53:b1:1f:3f:cb:cf:9f:20:13:6d:29:3a:c8:0f:
                    7d:3c:f7:6b:76:38:63:d9:36:60:a8:9b:5e:5c:00:
                    80:b2:2f:59:7f:f6:87:f9:25:43:86:e7:69:1b:52:
                    9a:90:e1:71:e3:d8:2d:0d:4e:6f:f6:c8:49:d9:b6:
                    f3:1a:56:ae:2b:b6:74:14:eb:cf:fb:26:e3:1a:ba:
                    1d:96:2e:6a:3b:58:94:89:47:56:ff:25:a0:93:70:
                    53:83:da:84:74:14:c3:67:9e:04:68:3a:df:8e:40:
                    5a:1d:4a:4e:cf:43:91:3b:e7:56:d6:00:70:cb:52:
                    ee:7b:7d:ae:3a:e7:bc:31:f9:45:f6:c2:60:cf:13:
                    59:02:2b:80:cc:34:47:df:b9:de:90:65:6d:02:cf:
                    2c:91:a6:a6:e7:de:85:18:49:7c:66:4e:a3:3a:6d:
                    a9:b5:ee:34:2e:ba:0d:03:b8:33:df:47:eb:b1:6b:
                    8d:25:d9:9b:ce:81:d1:45:46:32:96:70:87:de:02:
                    0e:49:43:85:b6:6c:73:bb:64:ea:61:41:ac:c9:d4:
                    54:df:87:2f:c7:22:b2:26:cc:9f:59:54:68:9f:fc:
                    be:2a:2f:c4:55:1c:75:40:60:17:85:02:55:39:8b:
                    7f:05
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                9C:5F:00:DF:AA:01:D7:30:2B:38:88:A2:B8:6D:4A:9C:F2:11:91:83
    Signature Algorithm: sha256WithRSAEncryption
        4b:36:a6:84:77:69:dd:3b:19:9f:67:23:08:6f:0e:61:c9:fd:
        84:dc:5f:d8:36:81:cd:d8:1b:41:2d:9f:60:dd:c7:1a:68:d9:
        d1:6e:86:e1:88:23:cf:13:de:43:cf:e2:34:b3:04:9d:1f:29:
        d5:bf:f8:5e:c8:d5:c1:bd:ee:92:6f:32:74:f2:91:82:2f:bd:
        82:42:7a:ad:2a:b7:20:7d:4d:bc:7a:55:12:c2:15:ea:bd:f7:
        6a:95:2e:6c:74:9f:cf:1c:b4:f2:c5:01:a3:85:d0:72:3e:ad:
        73:ab:0b:9b:75:0c:6d:45:b7:8e:94:ac:96:37:b5:a0:d0:8f:
        15:47:0e:e3:e8:83:dd:8f:fd:ef:41:01:77:cc:27:a9:62:85:
        33:f2:37:08:ef:71:cf:77:06:de:c8:19:1d:88:40:cf:7d:46:
        1d:ff:1e:c7:e1:ce:ff:23:db:c6:fa:8d:55:4e:a9:02:e7:47:
        11:46:3e:f4:fd:bd:7b:29:26:bb:a9:61:62:37:28:b6:2d:2a:
        f6:10:86:64:c9:70:a7:d2:ad:b7:29:70:79:ea:3c:da:63:25:
        9f:fd:68:b7:30:ec:70:fb:75:8a:b7:6d:60:67:b2:1e:c8:b9:
        e9:d8:a8:6f:02:8b:67:0d:4d:26:57:71:da:20:fc:c1:4a:50:
        8d:b1:28:ba', 'D50C3AC42AF94EE2F5BE19975F8E8853B11F3FCBCF9F20136D293AC80F7D3CF76B763863D93660A89B5E5C0080B22F597FF687F9254386E7691B529A90E171E3D82D0D4E6FF6C849D9B6F31A56AE2BB67414EBCFFB26E31ABA1D962E6A3B5894894756FF25A093705383DA847414C3679E04683ADF8E405A1D4A4ECF43913BE756D60070CB52EE7B7DAE3AE7BC31F945F6C260CF1359022B80CC3447DFB9DE90656D02CF2C91A6A6E7DE8518497C664EA33A6DA9B5EE342EBA0D03B833DF47EBB16B8D25D99BCE81D1454632967087DE020E494385B66C73BB64EA6141ACC9D454DF872FC722B226CC9F5954689FFCBE2A2FC4551C75406017850255398B7F05', '/C=US/ST=Arizona/L=Scottsdale/O=Starfield Technologies, Inc./CN=Starfield Services Root Certificate Authority - G2', 'C=US/ST=Arizona/L=Scottsdale/O=Starfield Technologies, Inc./CN=Starfield Services Root Certificate Authority - G2', '00', NULL, '-----BEGIN CERTIFICATE-----
MIID7zCCAtegAwIBAgIBADANBgkqhkiG9w0BAQsFADCBmDELMAkGA1UEBhMCVVMx
EDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxJTAjBgNVBAoT
HFN0YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xOzA5BgNVBAMTMlN0YXJmaWVs
ZCBTZXJ2aWNlcyBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTA5
MDkwMTAwMDAwMFoXDTM3MTIzMTIzNTk1OVowgZgxCzAJBgNVBAYTAlVTMRAwDgYD
VQQIEwdBcml6b25hMRMwEQYDVQQHEwpTY290dHNkYWxlMSUwIwYDVQQKExxTdGFy
ZmllbGQgVGVjaG5vbG9naWVzLCBJbmMuMTswOQYDVQQDEzJTdGFyZmllbGQgU2Vy
dmljZXMgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgLSBHMjCCASIwDQYJKoZI
hvcNAQEBBQADggEPADCCAQoCggEBANUMOsQq+U7i9b4Zl1+OiFOxHz/Lz58gE20p
OsgPfTz3a3Y4Y9k2YKibXlwAgLIvWX/2h/klQ4bnaRtSmpDhcePYLQ1Ob/bISdm2
8xpWriu2dBTrz/sm4xq6HZYuajtYlIlHVv8loJNwU4PahHQUw2eeBGg6345AWh1K
Ts9DkTvnVtYAcMtS7nt9rjrnvDH5RfbCYM8TWQIrgMw0R9+53pBlbQLPLJGmpufe
hRhJfGZOozptqbXuNC66DQO4M99H67FrjSXZm86B0UVGMpZwh94CDklDhbZsc7tk
6mFBrMnUVN+HL8cisibMn1lUaJ/8viovxFUcdUBgF4UCVTmLfwUCAwEAAaNCMEAw
DwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFJxfAN+q
AdcwKziIorhtSpzyEZGDMA0GCSqGSIb3DQEBCwUAA4IBAQBLNqaEd2ndOxmfZyMI
bw5hyf2E3F/YNoHN2BtBLZ9g3ccaaNnRbobhiCPPE95Dz+I0swSdHynVv/heyNXB
ve6SbzJ08pGCL72CQnqtKrcgfU28elUSwhXqvfdqlS5sdJ/PHLTyxQGjhdByPq1z
qwubdQxtRbeOlKyWN7Wg0I8VRw7j6IPdj/3vQQF3zCepYoUz8jcI73HPdwbeyBkd
iEDPfUYd/x7H4c7/I9vG+o1VTqkC50cRRj70/b17KSa7qWFiNyi2LSr2EIZkyXCn
0q23KXB56jzaYyWf/Wi3MOxw+3WKt21gZ7IeyLnp2KhvAotnDU0mV3HaIPzBSlCN
sSi6
-----END CERTIFICATE-----', 'afa7c51b1be82699985b1cf2f6552663');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Symantec Corporation, CN=Symantec Class 1 Public Primary Certification Authority - G6', 3, 1, 0, '2011-10-18 00:00:00', '2037-12-01 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            24:32:75:f2:1d:2f:d2:09:33:f7:b4:6a:ca:d0:f3:98
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=Symantec Corporation, OU=Symantec Trust Network, CN=Symantec Class 1 Public Primary Certification Authority - G6
        Validity
            Not Before: Oct 18 00:00:00 2011 GMT
            Not After : Dec  1 23:59:59 2037 GMT
        Subject: C=US, O=Symantec Corporation, OU=Symantec Trust Network, CN=Symantec Class 1 Public Primary Certification Authority - G6
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:c7:39:d7:49:64:a9:99:82:22:4c:ea:45:d9:07:
                    16:e3:7b:f4:83:e8:99:73:fa:6b:b1:36:e0:9a:77:
                    a0:40:c2:81:8d:01:c7:cc:8c:bd:8f:7d:f7:79:e3:
                    7a:4c:03:4d:d9:fb:fd:87:38:28:2c:dd:9a:8b:54:
                    08:db:67:fb:1b:8c:fe:28:92:2f:be:b7:b2:48:a7:
                    81:a1:d8:5e:88:c3:cc:39:40:41:5a:d1:dc:e5:da:
                    10:9f:2f:da:01:4d:fd:2e:46:7c:f9:2e:27:0a:69:
                    37:ee:91:a3:1b:6a:cc:44:bf:1b:c7:c3:d4:11:b2:
                    50:60:97:09:bd:2e:22:f5:41:84:66:9f:cd:40:a6:
                    a9:00:80:c1:1f:95:92:9f:de:f3:48:ef:db:1d:77:
                    61:fc:7f:df:ee:96:a4:72:d0:b6:3e:ff:78:27:af:
                    cb:92:15:69:08:db:63:10:e2:e6:97:ac:6e:dc:ac:
                    f6:a2:ce:1e:47:99:b9:89:b7:12:e6:a1:d4:cd:59:
                    11:67:c3:6f:85:d8:42:4e:28:be:59:55:59:04:95:
                    ab:8f:37:80:bf:0d:f0:fc:1f:3a:64:31:58:81:78:
                    d7:e2:35:f6:20:3f:29:b8:8f:16:6e:3e:48:dc:b5:
                    4c:07:e1:f2:1a:ea:7e:0a:79:d6:a8:bd:eb:5d:86:
                    2b:4d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                33:41:E8:C8:39:12:15:93:48:F2:96:32:2E:5A:F5:DA:94:5F:53:60
    Signature Algorithm: sha256WithRSAEncryption
        15:e3:73:57:b1:17:b6:5f:49:69:44:a6:f6:5e:7a:67:ac:d2:
        de:75:49:ab:fe:25:55:c7:3a:c9:44:15:10:6e:bf:31:6b:cb:
        d9:07:93:7f:1c:85:63:00:e3:32:12:e0:cc:cb:fb:39:6c:8f:
        e2:53:e2:3c:40:33:d9:a4:8c:47:e6:ad:58:fb:89:af:e3:de:
        86:29:56:34:2c:45:b8:12:fa:44:89:6e:2d:14:25:28:24:01:
        65:d6:ea:52:ac:05:6e:56:12:09:3d:d0:74:f4:d7:bd:06:ca:
        a8:3a:8d:56:42:fa:8d:72:3e:74:f1:03:72:df:87:1b:5e:0e:
        7a:55:96:2c:38:b7:98:85:cd:4d:33:44:c9:94:8f:5a:31:30:
        37:4b:a3:3a:12:b3:e7:36:d1:21:68:4b:2d:38:e6:53:ae:1c:
        25:56:08:56:03:67:84:9d:c6:c3:ce:24:62:c7:4c:36:cf:b0:
        06:44:b7:f5:5f:02:dd:d9:54:e9:2f:90:4e:7a:c8:4e:83:40:
        0c:9a:97:3c:37:bf:bf:ec:f6:f0:b4:85:77:28:c1:0b:c8:67:
        82:10:17:38:a2:b7:06:ea:9b:bf:3a:f8:e9:23:07:bf:74:e0:
        98:38:15:55:78:ee:72:00:5c:19:a3:f4:d2:33:e0:ff:bd:d1:
        54:39:29:0f', 'C739D74964A99982224CEA45D90716E37BF483E89973FA6BB136E09A77A040C2818D01C7CC8CBD8F7DF779E37A4C034DD9FBFD8738282CDD9A8B5408DB67FB1B8CFE28922FBEB7B248A781A1D85E88C3CC3940415AD1DCE5DA109F2FDA014DFD2E467CF92E270A6937EE91A31B6ACC44BF1BC7C3D411B250609709BD2E22F54184669FCD40A6A90080C11F95929FDEF348EFDB1D7761FC7FDFEE96A472D0B63EFF7827AFCB92156908DB6310E2E697AC6EDCACF6A2CE1E4799B989B712E6A1D4CD591167C36F85D8424E28BE5955590495AB8F3780BF0DF0FC1F3A6431588178D7E235F6203F29B88F166E3E48DCB54C07E1F21AEA7E0A79D6A8BDEB5D862B4D', '/C=US/O=Symantec Corporation/OU=Symantec Trust Network/CN=Symantec Class 1 Public Primary Certification Authority - G6', 'C=US/O=Symantec Corporation/OU=Symantec Trust Network/CN=Symantec Class 1 Public Primary Certification Authority - G6', '243275F21D2FD20933F7B46ACAD0F398', NULL, '-----BEGIN CERTIFICATE-----
MIID9jCCAt6gAwIBAgIQJDJ18h0v0gkz97RqytDzmDANBgkqhkiG9w0BAQsFADCB
lDELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMUUwQwYDVQQDEzxTeW1hbnRl
YyBDbGFzcyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5
IC0gRzYwHhcNMTExMDE4MDAwMDAwWhcNMzcxMjAxMjM1OTU5WjCBlDELMAkGA1UE
BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZT
eW1hbnRlYyBUcnVzdCBOZXR3b3JrMUUwQwYDVQQDEzxTeW1hbnRlYyBDbGFzcyAx
IFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzYwggEi
MA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDHOddJZKmZgiJM6kXZBxbje/SD
6Jlz+muxNuCad6BAwoGNAcfMjL2Pffd543pMA03Z+/2HOCgs3ZqLVAjbZ/sbjP4o
ki++t7JIp4Gh2F6Iw8w5QEFa0dzl2hCfL9oBTf0uRnz5LicKaTfukaMbasxEvxvH
w9QRslBglwm9LiL1QYRmn81ApqkAgMEflZKf3vNI79sdd2H8f9/ulqRy0LY+/3gn
r8uSFWkI22MQ4uaXrG7crPaizh5HmbmJtxLmodTNWRFnw2+F2EJOKL5ZVVkElauP
N4C/DfD8HzpkMViBeNfiNfYgPym4jxZuPkjctUwH4fIa6n4KedaovetdhitNAgMB
AAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQW
BBQzQejIORIVk0jyljIuWvXalF9TYDANBgkqhkiG9w0BAQsFAAOCAQEAFeNzV7EX
tl9JaUSm9l56Z6zS3nVJq/4lVcc6yUQVEG6/MWvL2QeTfxyFYwDjMhLgzMv7OWyP
4lPiPEAz2aSMR+atWPuJr+PehilWNCxFuBL6RIluLRQlKCQBZdbqUqwFblYSCT3Q
dPTXvQbKqDqNVkL6jXI+dPEDct+HG14OelWWLDi3mIXNTTNEyZSPWjEwN0ujOhKz
5zbRIWhLLTjmU64cJVYIVgNnhJ3Gw84kYsdMNs+wBkS39V8C3dlU6S+QTnrIToNA
DJqXPDe/v+z28LSFdyjBC8hnghAXOKK3Buqbvzr46SMHv3TgmDgVVXjucgBcGaP0
0jPg/73RVDkpDw==
-----END CERTIFICATE-----', 'a2781828fe8b66e03868ab3c47267793');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Symantec Corporation, CN=Symantec Class 2 Public Primary Certification Authority - G6', 3, 1, 0, '2011-10-18 00:00:00', '2037-12-01 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            64:82:9e:fc:37:1e:74:5d:fc:97:ff:97:c8:b1:ff:41
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=Symantec Corporation, OU=Symantec Trust Network, CN=Symantec Class 2 Public Primary Certification Authority - G6
        Validity
            Not Before: Oct 18 00:00:00 2011 GMT
            Not After : Dec  1 23:59:59 2037 GMT
        Subject: C=US, O=Symantec Corporation, OU=Symantec Trust Network, CN=Symantec Class 2 Public Primary Certification Authority - G6
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:cd:cc:e9:05:c8:63:85:cb:3f:40:63:17:bd:18:
                    fa:35:e6:04:67:57:65:98:29:a4:4f:c9:5c:8f:0f:
                    34:d2:f8:da:a8:13:62:aa:b8:1e:50:67:78:b0:16:
                    4c:a0:39:a9:15:7a:ae:ed:d2:a2:c0:f0:90:37:29:
                    18:26:5c:e8:0d:3c:b6:6c:49:3f:c1:e0:dc:d9:4b:
                    b6:14:19:0b:a6:d3:96:e1:d6:09:e3:19:26:1c:f9:
                    1f:65:4b:f9:1a:43:1c:00:83:d6:d0:aa:49:a2:d4:
                    db:e6:62:38:ba:50:14:43:6d:f9:31:f8:56:16:d9:
                    38:02:91:cf:eb:6c:dd:bb:39:4e:99:e1:30:67:45:
                    f1:d4:f0:8d:c3:df:fe:f2:38:07:21:7d:00:5e:56:
                    44:b3:e4:60:bd:91:2b:9c:ab:5b:04:72:0f:b2:28:
                    d9:72:ab:05:20:42:25:a9:5b:03:6a:20:10:cc:31:
                    f0:2b:da:35:2c:d0:fb:9a:97:4e:f0:82:4b:2b:d8:
                    5f:36:a3:0b:2d:af:63:0d:1d:25:7f:a1:6e:5c:62:
                    a1:8d:28:3e:a1:fc:1c:20:f8:01:2f:ba:55:9a:11:
                    b0:19:d2:c8:50:79:6b:0e:6a:05:d7:aa:04:36:b2:
                    a3:f2:e1:5f:77:a7:77:9c:e5:1e:dc:e9:df:6a:c1:
                    65:5d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                87:8C:20:95:C8:98:4A:D1:D6:80:06:4A:90:34:44:DF:1C:4D:BF:B0
    Signature Algorithm: sha256WithRSAEncryption
        81:8e:b2:a5:66:96:b7:21:a5:b6:ef:6f:23:5a:5f:db:81:c5:
        42:a5:78:c1:69:fd:f4:3c:d7:f9:5c:6b:70:72:1a:fc:5a:97:
        4d:00:80:88:88:82:8a:c3:71:0d:8e:c5:89:9b:2c:ed:8d:0b:
        d2:72:54:f5:7d:d4:5c:43:57:e9:f3:ae:a5:02:11:f6:76:2b:
        81:57:dd:7d:da:74:30:fd:54:47:f6:e0:16:6e:a6:b4:0a:48:
        e6:e7:75:07:0f:29:19:39:ce:79:f4:b6:6c:c5:5f:99:d5:1f:
        4b:fa:df:6d:2c:3c:0d:54:80:70:f0:88:0b:80:cf:c6:68:a2:
        b8:1d:70:d9:76:8c:fc:ee:a5:c9:cf:ad:1d:cf:99:25:57:5a:
        62:45:cb:16:6b:bd:49:cd:a5:a3:8c:69:79:25:ae:b8:4c:6c:
        8b:40:66:4b:16:3f:cf:02:1a:dd:e1:6c:6b:07:61:6a:76:15:
        29:99:7f:1b:dd:88:80:c1:bf:b5:8f:73:c5:a6:96:23:84:a6:
        28:86:24:33:6a:01:2e:57:73:25:b6:5e:bf:8f:e6:1d:61:a8:
        40:29:67:1d:87:9b:1d:7f:9b:9f:99:cd:31:d6:54:be:62:bb:
        39:ac:68:12:48:91:20:a5:cb:b1:dd:fe:6f:fc:5a:e4:82:55:
        59:af:31:a9', 'CDCCE905C86385CB3F406317BD18FA35E6046757659829A44FC95C8F0F34D2F8DAA81362AAB81E506778B0164CA039A9157AAEEDD2A2C0F090372918265CE80D3CB66C493FC1E0DCD94BB614190BA6D396E1D609E319261CF91F654BF91A431C0083D6D0AA49A2D4DBE66238BA5014436DF931F85616D9380291CFEB6CDDBB394E99E1306745F1D4F08DC3DFFEF23807217D005E5644B3E460BD912B9CAB5B04720FB228D972AB05204225A95B036A2010CC31F02BDA352CD0FB9A974EF0824B2BD85F36A30B2DAF630D1D257FA16E5C62A18D283EA1FC1C20F8012FBA559A11B019D2C850796B0E6A05D7AA0436B2A3F2E15F77A7779CE51EDCE9DF6AC1655D', '/C=US/O=Symantec Corporation/OU=Symantec Trust Network/CN=Symantec Class 2 Public Primary Certification Authority - G6', 'C=US/O=Symantec Corporation/OU=Symantec Trust Network/CN=Symantec Class 2 Public Primary Certification Authority - G6', '64829EFC371E745DFC97FF97C8B1FF41', NULL, '-----BEGIN CERTIFICATE-----
MIID9jCCAt6gAwIBAgIQZIKe/DcedF38l/+XyLH/QTANBgkqhkiG9w0BAQsFADCB
lDELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMUUwQwYDVQQDEzxTeW1hbnRl
YyBDbGFzcyAyIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5
IC0gRzYwHhcNMTExMDE4MDAwMDAwWhcNMzcxMjAxMjM1OTU5WjCBlDELMAkGA1UE
BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZT
eW1hbnRlYyBUcnVzdCBOZXR3b3JrMUUwQwYDVQQDEzxTeW1hbnRlYyBDbGFzcyAy
IFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzYwggEi
MA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDNzOkFyGOFyz9AYxe9GPo15gRn
V2WYKaRPyVyPDzTS+NqoE2KquB5QZ3iwFkygOakVeq7t0qLA8JA3KRgmXOgNPLZs
ST/B4NzZS7YUGQum05bh1gnjGSYc+R9lS/kaQxwAg9bQqkmi1NvmYji6UBRDbfkx
+FYW2TgCkc/rbN27OU6Z4TBnRfHU8I3D3/7yOAchfQBeVkSz5GC9kSucq1sEcg+y
KNlyqwUgQiWpWwNqIBDMMfAr2jUs0Pual07wgksr2F82owstr2MNHSV/oW5cYqGN
KD6h/Bwg+AEvulWaEbAZ0shQeWsOagXXqgQ2sqPy4V93p3ec5R7c6d9qwWVdAgMB
AAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQW
BBSHjCCVyJhK0daABkqQNETfHE2/sDANBgkqhkiG9w0BAQsFAAOCAQEAgY6ypWaW
tyGltu9vI1pf24HFQqV4wWn99DzX+VxrcHIa/FqXTQCAiIiCisNxDY7FiZss7Y0L
0nJU9X3UXENX6fOupQIR9nYrgVfdfdp0MP1UR/bgFm6mtApI5ud1Bw8pGTnOefS2
bMVfmdUfS/rfbSw8DVSAcPCIC4DPxmiiuB1w2XaM/O6lyc+tHc+ZJVdaYkXLFmu9
Sc2lo4xpeSWuuExsi0BmSxY/zwIa3eFsawdhanYVKZl/G92IgMG/tY9zxaaWI4Sm
KIYkM2oBLldzJbZev4/mHWGoQClnHYebHX+bn5nNMdZUvmK7OaxoEkiRIKXLsd3+
b/xa5IJVWa8xqQ==
-----END CERTIFICATE-----', '59bb0d5198db40ed3f9bdb113ba38e74');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=thawte, Inc., CN=thawte Primary Root CA', 3, 1, 0, '2006-11-17 00:00:00', '2036-07-16 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            34:4e:d5:57:20:d5:ed:ec:49:f4:2f:ce:37:db:2b:6d
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=thawte, Inc., OU=Certification Services Division, OU=(c) 2006 thawte, Inc. - For authorized use only, CN=thawte Primary Root CA
        Validity
            Not Before: Nov 17 00:00:00 2006 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=thawte, Inc., OU=Certification Services Division, OU=(c) 2006 thawte, Inc. - For authorized use only, CN=thawte Primary Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ac:a0:f0:fb:80:59:d4:9c:c7:a4:cf:9d:a1:59:
                    73:09:10:45:0c:0d:2c:6e:68:f1:6c:5b:48:68:49:
                    59:37:fc:0b:33:19:c2:77:7f:cc:10:2d:95:34:1c:
                    e6:eb:4d:09:a7:1c:d2:b8:c9:97:36:02:b7:89:d4:
                    24:5f:06:c0:cc:44:94:94:8d:02:62:6f:eb:5a:dd:
                    11:8d:28:9a:5c:84:90:10:7a:0d:bd:74:66:2f:6a:
                    38:a0:e2:d5:54:44:eb:1d:07:9f:07:ba:6f:ee:e9:
                    fd:4e:0b:29:f5:3e:84:a0:01:f1:9c:ab:f8:1c:7e:
                    89:a4:e8:a1:d8:71:65:0d:a3:51:7b:ee:bc:d2:22:
                    60:0d:b9:5b:9d:df:ba:fc:51:5b:0b:af:98:b2:e9:
                    2e:e9:04:e8:62:87:de:2b:c8:d7:4e:c1:4c:64:1e:
                    dd:cf:87:58:ba:4a:4f:ca:68:07:1d:1c:9d:4a:c6:
                    d5:2f:91:cc:7c:71:72:1c:c5:c0:67:eb:32:fd:c9:
                    92:5c:94:da:85:c0:9b:bf:53:7d:2b:09:f4:8c:9d:
                    91:1f:97:6a:52:cb:de:09:36:a4:77:d8:7b:87:50:
                    44:d5:3e:6e:29:69:fb:39:49:26:1e:09:a5:80:7b:
                    40:2d:eb:e8:27:85:c9:fe:61:fd:7e:e6:7c:97:1d:
                    d5:9d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                7B:5B:45:CF:AF:CE:CB:7A:FD:31:92:1A:6A:B6:F3:46:EB:57:48:50
    Signature Algorithm: sha1WithRSAEncryption
        79:11:c0:4b:b3:91:b6:fc:f0:e9:67:d4:0d:6e:45:be:55:e8:
        93:d2:ce:03:3f:ed:da:25:b0:1d:57:cb:1e:3a:76:a0:4c:ec:
        50:76:e8:64:72:0c:a4:a9:f1:b8:8b:d6:d6:87:84:bb:32:e5:
        41:11:c0:77:d9:b3:60:9d:eb:1b:d5:d1:6e:44:44:a9:a6:01:
        ec:55:62:1d:77:b8:5c:8e:48:49:7c:9c:3b:57:11:ac:ad:73:
        37:8e:2f:78:5c:90:68:47:d9:60:60:e6:fc:07:3d:22:20:17:
        c4:f7:16:e9:c4:d8:72:f9:c8:73:7c:df:16:2f:15:a9:3e:fd:
        6a:27:b6:a1:eb:5a:ba:98:1f:d5:e3:4d:64:0a:9d:13:c8:61:
        ba:f5:39:1c:87:ba:b8:bd:7b:22:7f:f6:fe:ac:40:79:e5:ac:
        10:6f:3d:8f:1b:79:76:8b:c4:37:b3:21:18:84:e5:36:00:eb:
        63:20:99:b9:e9:fe:33:04:bb:41:c8:c1:02:f9:44:63:20:9e:
        81:ce:42:d3:d6:3f:2c:76:d3:63:9c:59:dd:8f:a6:e1:0e:a0:
        2e:41:f7:2e:95:47:cf:bc:fd:33:f3:f6:0b:61:7e:7e:91:2b:
        81:47:c2:27:30:ee:a7:10:5d:37:8f:5c:39:2b:e4:04:f0:7b:
        8d:56:8c:68', 'ACA0F0FB8059D49CC7A4CF9DA159730910450C0D2C6E68F16C5B4868495937FC0B3319C2777FCC102D95341CE6EB4D09A71CD2B8C9973602B789D4245F06C0CC4494948D02626FEB5ADD118D289A5C8490107A0DBD74662F6A38A0E2D55444EB1D079F07BA6FEEE9FD4E0B29F53E84A001F19CABF81C7E89A4E8A1D871650DA3517BEEBCD222600DB95B9DDFBAFC515B0BAF98B2E92EE904E86287DE2BC8D74EC14C641EDDCF8758BA4A4FCA68071D1C9D4AC6D52F91CC7C71721CC5C067EB32FDC9925C94DA85C09BBF537D2B09F48C9D911F976A52CBDE0936A477D87B875044D53E6E2969FB3949261E09A5807B402DEBE82785C9FE61FD7EE67C971DD59D', '/C=US/O=thawte, Inc./OU=Certification Services Division/OU=(c) 2006 thawte, Inc. - For authorized use only/CN=thawte Primary Root CA', 'C=US/O=thawte, Inc./OU=Certification Services Division/OU=(c) 2006 thawte, Inc. - For authorized use only/CN=thawte Primary Root CA',' 344ED55720D5EDEC49F42FCE37DB2B6D', NULL, '-----BEGIN CERTIFICATE-----
MIIEIDCCAwigAwIBAgIQNE7VVyDV7exJ9C/ON9srbTANBgkqhkiG9w0BAQUFADCB
qTELMAkGA1UEBhMCVVMxFTATBgNVBAoTDHRoYXd0ZSwgSW5jLjEoMCYGA1UECxMf
Q2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjE4MDYGA1UECxMvKGMpIDIw
MDYgdGhhd3RlLCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxHzAdBgNV
BAMTFnRoYXd0ZSBQcmltYXJ5IFJvb3QgQ0EwHhcNMDYxMTE3MDAwMDAwWhcNMzYw
NzE2MjM1OTU5WjCBqTELMAkGA1UEBhMCVVMxFTATBgNVBAoTDHRoYXd0ZSwgSW5j
LjEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjE4MDYG
A1UECxMvKGMpIDIwMDYgdGhhd3RlLCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNl
IG9ubHkxHzAdBgNVBAMTFnRoYXd0ZSBQcmltYXJ5IFJvb3QgQ0EwggEiMA0GCSqG
SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCsoPD7gFnUnMekz52hWXMJEEUMDSxuaPFs
W0hoSVk3/AszGcJ3f8wQLZU0HObrTQmnHNK4yZc2AreJ1CRfBsDMRJSUjQJib+ta
3RGNKJpchJAQeg29dGYvajig4tVUROsdB58Hum/u6f1OCyn1PoSgAfGcq/gcfomk
6KHYcWUNo1F77rzSImANuVud37r8UVsLr5iy6S7pBOhih94ryNdOwUxkHt3Ph1i6
Sk/KaAcdHJ1KxtUvkcx8cXIcxcBn6zL9yZJclNqFwJu/U30rCfSMnZEfl2pSy94J
NqR32HuHUETVPm4pafs5SSYeCaWAe0At6+gnhcn+Yf1+5nyXHdWdAgMBAAGjQjBA
MA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBR7W0XP
r87Lev0xkhpqtvNG61dIUDANBgkqhkiG9w0BAQUFAAOCAQEAeRHAS7ORtvzw6WfU
DW5FvlXok9LOAz/t2iWwHVfLHjp2oEzsUHboZHIMpKnxuIvW1oeEuzLlQRHAd9mz
YJ3rG9XRbkREqaYB7FViHXe4XI5ISXycO1cRrK1zN44veFyQaEfZYGDm/Ac9IiAX
xPcW6cTYcvnIc3zfFi8VqT79aie2oetaupgf1eNNZAqdE8hhuvU5HIe6uL17In/2
/qxAeeWsEG89jxt5dovEN7MhGITlNgDrYyCZuen+MwS7QcjBAvlEYyCegc5C09Y/
LHbTY5xZ3Y+m4Q6gLkH3LpVHz7z9M/P2C2F+fpErgUfCJzDupxBdN49cOSvkBPB7
jVaMaA==
-----END CERTIFICATE-----', 'de3d5930e6e6b3fdb385f60a05206588');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=thawte, Inc., CN=thawte Primary Root CA - G3', 3, 1, 0, '2008-04-02 00:00:00', '2037-12-01 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            60:01:97:b7:46:a7:ea:b4:b4:9a:d6:4b:2f:f7:90:fb
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=thawte, Inc., OU=Certification Services Division, OU=(c) 2008 thawte, Inc. - For authorized use only, CN=thawte Primary Root CA - G3
        Validity
            Not Before: Apr  2 00:00:00 2008 GMT
            Not After : Dec  1 23:59:59 2037 GMT
        Subject: C=US, O=thawte, Inc., OU=Certification Services Division, OU=(c) 2008 thawte, Inc. - For authorized use only, CN=thawte Primary Root CA - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b2:bf:27:2c:fb:db:d8:5b:dd:78:7b:1b:9e:77:
                    66:81:cb:3e:bc:7c:ae:f3:a6:27:9a:34:a3:68:31:
                    71:38:33:62:e4:f3:71:66:79:b1:a9:65:a3:a5:8b:
                    d5:8f:60:2d:3f:42:cc:aa:6b:32:c0:23:cb:2c:41:
                    dd:e4:df:fc:61:9c:e2:73:b2:22:95:11:43:18:5f:
                    c4:b6:1f:57:6c:0a:05:58:22:c8:36:4c:3a:7c:a5:
                    d1:cf:86:af:88:a7:44:02:13:74:71:73:0a:42:59:
                    02:f8:1b:14:6b:42:df:6f:5f:ba:6b:82:a2:9d:5b:
                    e7:4a:bd:1e:01:72:db:4b:74:e8:3b:7f:7f:7d:1f:
                    04:b4:26:9b:e0:b4:5a:ac:47:3d:55:b8:d7:b0:26:
                    52:28:01:31:40:66:d8:d9:24:bd:f6:2a:d8:ec:21:
                    49:5c:9b:f6:7a:e9:7f:55:35:7e:96:6b:8d:93:93:
                    27:cb:92:bb:ea:ac:40:c0:9f:c2:f8:80:cf:5d:f4:
                    5a:dc:ce:74:86:a6:3e:6c:0b:53:ca:bd:92:ce:19:
                    06:72:e6:0c:5c:38:69:c7:04:d6:bc:6c:ce:5b:f6:
                    f7:68:9c:dc:25:15:48:88:a1:e9:a9:f8:98:9c:e0:
                    f3:d5:31:28:61:11:6c:67:96:8d:39:99:cb:c2:45:
                    24:39
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                AD:6C:AA:94:60:9C:ED:E4:FF:FA:3E:0A:74:2B:63:03:F7:B6:59:BF
    Signature Algorithm: sha256WithRSAEncryption
        1a:40:d8:95:65:ac:09:92:89:c6:39:f4:10:e5:a9:0e:66:53:
        5d:78:de:fa:24:91:bb:e7:44:51:df:c6:16:34:0a:ef:6a:44:
        51:ea:2b:07:8a:03:7a:c3:eb:3f:0a:2c:52:16:a0:2b:43:b9:
        25:90:3f:70:a9:33:25:6d:45:1a:28:3b:27:cf:aa:c3:29:42:
        1b:df:3b:4c:c0:33:34:5b:41:88:bf:6b:2b:65:af:28:ef:b2:
        f5:c3:aa:66:ce:7b:56:ee:b7:c8:cb:67:c1:c9:9c:1a:18:b8:
        c4:c3:49:03:f1:60:0e:50:cd:46:c5:f3:77:79:f7:b6:15:e0:
        38:db:c7:2f:28:a0:0c:3f:77:26:74:d9:25:12:da:31:da:1a:
        1e:dc:29:41:91:22:3c:69:a7:bb:02:f2:b6:5c:27:03:89:f4:
        06:ea:9b:e4:72:82:e3:a1:09:c1:e9:00:19:d3:3e:d4:70:6b:
        ba:71:a6:aa:58:ae:f4:bb:e9:6c:b6:ef:87:cc:9b:bb:ff:39:
        e6:56:61:d3:0a:a7:c4:5c:4c:60:7b:05:77:26:7a:bf:d8:07:
        52:2c:62:f7:70:63:d9:39:bc:6f:1c:c2:79:dc:76:29:af:ce:
        c5:2c:64:04:5e:88:36:6e:31:d4:40:1a:62:34:36:3f:35:01:
        ae:ac:63:a0', 'B2BF272CFBDBD85BDD787B1B9E776681CB3EBC7CAEF3A6279A34A3683171383362E4F3716679B1A965A3A58BD58F602D3F42CCAA6B32C023CB2C41DDE4DFFC619CE273B222951143185FC4B61F576C0A055822C8364C3A7CA5D1CF86AF88A74402137471730A425902F81B146B42DF6F5FBA6B82A29D5BE74ABD1E0172DB4B74E83B7F7F7D1F04B4269BE0B45AAC473D55B8D7B026522801314066D8D924BDF62AD8EC21495C9BF67AE97F55357E966B8D939327CB92BBEAAC40C09FC2F880CF5DF45ADCCE7486A63E6C0B53CABD92CE190672E60C5C3869C704D6BC6CCE5BF6F7689CDC25154888A1E9A9F8989CE0F3D5312861116C67968D3999CBC2452439', '/C=US/O=thawte, Inc./OU=Certification Services Division/OU=(c) 2008 thawte, Inc. - For authorized use only/CN=thawte Primary Root CA - G3', 'C=US/O=thawte, Inc./OU=Certification Services Division/OU=(c) 2008 thawte, Inc. - For authorized use only/CN=thawte Primary Root CA - G3', '600197B746A7EAB4B49AD64B2FF790FB', NULL, '-----BEGIN CERTIFICATE-----
MIIEKjCCAxKgAwIBAgIQYAGXt0an6rS0mtZLL/eQ+zANBgkqhkiG9w0BAQsFADCB
rjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDHRoYXd0ZSwgSW5jLjEoMCYGA1UECxMf
Q2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjE4MDYGA1UECxMvKGMpIDIw
MDggdGhhd3RlLCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxJDAiBgNV
BAMTG3RoYXd0ZSBQcmltYXJ5IFJvb3QgQ0EgLSBHMzAeFw0wODA0MDIwMDAwMDBa
Fw0zNzEyMDEyMzU5NTlaMIGuMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMdGhhd3Rl
LCBJbmMuMSgwJgYDVQQLEx9DZXJ0aWZpY2F0aW9uIFNlcnZpY2VzIERpdmlzaW9u
MTgwNgYDVQQLEy8oYykgMjAwOCB0aGF3dGUsIEluYy4gLSBGb3IgYXV0aG9yaXpl
ZCB1c2Ugb25seTEkMCIGA1UEAxMbdGhhd3RlIFByaW1hcnkgUm9vdCBDQSAtIEcz
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsr8nLPvb2FvdeHsbnndm
gcs+vHyu86YnmjSjaDFxODNi5PNxZnmxqWWjpYvVj2AtP0LMqmsywCPLLEHd5N/8
YZzic7IilRFDGF/Eth9XbAoFWCLINkw6fKXRz4aviKdEAhN0cXMKQlkC+BsUa0Lf
b1+6a4KinVvnSr0eAXLbS3ToO39/fR8EtCab4LRarEc9VbjXsCZSKAExQGbY2SS9
9irY7CFJXJv2eul/VTV+lmuNk5Mny5K76qxAwJ/C+IDPXfRa3M50hqY+bAtTyr2S
zhkGcuYMXDhpxwTWvGzOW/b3aJzcJRVIiKHpqfiYnODz1TEoYRFsZ5aNOZnLwkUk
OQIDAQABo0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBBjAdBgNV
HQ4EFgQUrWyqlGCc7eT/+j4KdCtjA/e2Wb8wDQYJKoZIhvcNAQELBQADggEBABpA
2JVlrAmSicY59BDlqQ5mU1143vokkbvnRFHfxhY0Cu9qRFHqKweKA3rD6z8KLFIW
oCtDuSWQP3CpMyVtRRooOyfPqsMpQhvfO0zAMzRbQYi/aytlryjvsvXDqmbOe1bu
t8jLZ8HJnBoYuMTDSQPxYA5QzUbF83d597YV4Djbxy8ooAw/dyZ02SUS2jHaGh7c
KUGRIjxpp7sC8rZcJwOJ9Abqm+RyguOhCcHpABnTPtRwa7pxpqpYrvS76Wy274fM
m7v/OeZWYdMKp8RcTGB7BXcmer/YB1IsYvdwY9k5vG8cwnncdimvzsUsZAReiDZu
MdRAGmI0Nj81Aa6sY6A=
-----END CERTIFICATE-----', '7940d0333af9e5de8515419506540624');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=The Go Daddy Group, Inc.', 3, 1, 0, '2004-06-29 17:06:20', '2034-06-29 17:06:20', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=The Go Daddy Group, Inc., OU=Go Daddy Class 2 Certification Authority
        Validity
            Not Before: Jun 29 17:06:20 2004 GMT
            Not After : Jun 29 17:06:20 2034 GMT
        Subject: C=US, O=The Go Daddy Group, Inc., OU=Go Daddy Class 2 Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:de:9d:d7:ea:57:18:49:a1:5b:eb:d7:5f:48:86:
                    ea:be:dd:ff:e4:ef:67:1c:f4:65:68:b3:57:71:a0:
                    5e:77:bb:ed:9b:49:e9:70:80:3d:56:18:63:08:6f:
                    da:f2:cc:d0:3f:7f:02:54:22:54:10:d8:b2:81:d4:
                    c0:75:3d:4b:7f:c7:77:c3:3e:78:ab:1a:03:b5:20:
                    6b:2f:6a:2b:b1:c5:88:7e:c4:bb:1e:b0:c1:d8:45:
                    27:6f:aa:37:58:f7:87:26:d7:d8:2d:f6:a9:17:b7:
                    1f:72:36:4e:a6:17:3f:65:98:92:db:2a:6e:5d:a2:
                    fe:88:e0:0b:de:7f:e5:8d:15:e1:eb:cb:3a:d5:e2:
                    12:a2:13:2d:d8:8e:af:5f:12:3d:a0:08:05:08:b6:
                    5c:a5:65:38:04:45:99:1e:a3:60:60:74:c5:41:a5:
                    72:62:1b:62:c5:1f:6f:5f:1a:42:be:02:51:65:a8:
                    ae:23:18:6a:fc:78:03:a9:4d:7f:80:c3:fa:ab:5a:
                    fc:a1:40:a4:ca:19:16:fe:b2:c8:ef:5e:73:0d:ee:
                    77:bd:9a:f6:79:98:bc:b1:07:67:a2:15:0d:dd:a0:
                    58:c6:44:7b:0a:3e:62:28:5f:ba:41:07:53:58:cf:
                    11:7e:38:74:c5:f8:ff:b5:69:90:8f:84:74:ea:97:
                    1b:af
                Exponent: 3 (0x3)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                D2:C4:B0:D2:91:D4:4C:11:71:B3:61:CB:3D:A1:FE:DD:A8:6A:D4:E3
            X509v3 Authority Key Identifier: 
                keyid:D2:C4:B0:D2:91:D4:4C:11:71:B3:61:CB:3D:A1:FE:DD:A8:6A:D4:E3
                DirName:/C=US/O=The Go Daddy Group, Inc./OU=Go Daddy Class 2 Certification Authority
                serial:00

            X509v3 Basic Constraints: 
                CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        32:4b:f3:b2:ca:3e:91:fc:12:c6:a1:07:8c:8e:77:a0:33:06:
        14:5c:90:1e:18:f7:08:a6:3d:0a:19:f9:87:80:11:6e:69:e4:
        96:17:30:ff:34:91:63:72:38:ee:cc:1c:01:a3:1d:94:28:a4:
        31:f6:7a:c4:54:d7:f6:e5:31:58:03:a2:cc:ce:62:db:94:45:
        73:b5:bf:45:c9:24:b5:d5:82:02:ad:23:79:69:8d:b8:b6:4d:
        ce:cf:4c:ca:33:23:e8:1c:88:aa:9d:8b:41:6e:16:c9:20:e5:
        89:9e:cd:3b:da:70:f7:7e:99:26:20:14:54:25:ab:6e:73:85:
        e6:9b:21:9d:0a:6c:82:0e:a8:f8:c2:0c:fa:10:1e:6c:96:ef:
        87:0d:c4:0f:61:8b:ad:ee:83:2b:95:f8:8e:92:84:72:39:eb:
        20:ea:83:ed:83:cd:97:6e:08:bc:eb:4e:26:b6:73:2b:e4:d3:
        f6:4c:fe:26:71:e2:61:11:74:4a:ff:57:1a:87:0f:75:48:2e:
        cf:51:69:17:a0:02:12:61:95:d5:d1:40:b2:10:4c:ee:c4:ac:
        10:43:a6:a5:9e:0a:d5:95:62:9a:0d:cf:88:82:c5:32:0c:e4:
        2b:9f:45:e6:0d:9f:28:9c:b1:b9:2a:5a:57:ad:37:0f:af:1d:
        7f:db:bd:9f', 'DE9DD7EA571849A15BEBD75F4886EABEDDFFE4EF671CF46568B35771A05E77BBED9B49E970803D561863086FDAF2CCD03F7F0254225410D8B281D4C0753D4B7FC777C33E78AB1A03B5206B2F6A2BB1C5887EC4BB1EB0C1D845276FAA3758F78726D7D82DF6A917B71F72364EA6173F659892DB2A6E5DA2FE88E00BDE7FE58D15E1EBCB3AD5E212A2132DD88EAF5F123DA0080508B65CA565380445991EA3606074C541A572621B62C51F6F5F1A42BE025165A8AE23186AFC7803A94D7F80C3FAAB5AFCA140A4CA1916FEB2C8EF5E730DEE77BD9AF67998BCB10767A2150DDDA058C6447B0A3E62285FBA41075358CF117E3874C5F8FFB569908F8474EA971BAF', '/C=US/O=The Go Daddy Group, Inc./OU=Go Daddy Class 2 Certification Authority', 'C=US/O=The Go Daddy Group, Inc./OU=Go Daddy Class 2 Certification Authority', '00', NULL, '-----BEGIN CERTIFICATE-----
MIIEADCCAuigAwIBAgIBADANBgkqhkiG9w0BAQUFADBjMQswCQYDVQQGEwJVUzEh
MB8GA1UEChMYVGhlIEdvIERhZGR5IEdyb3VwLCBJbmMuMTEwLwYDVQQLEyhHbyBE
YWRkeSBDbGFzcyAyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA0MDYyOTE3
MDYyMFoXDTM0MDYyOTE3MDYyMFowYzELMAkGA1UEBhMCVVMxITAfBgNVBAoTGFRo
ZSBHbyBEYWRkeSBHcm91cCwgSW5jLjExMC8GA1UECxMoR28gRGFkZHkgQ2xhc3Mg
MiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCCASAwDQYJKoZIhvcNAQEBBQADggEN
ADCCAQgCggEBAN6d1+pXGEmhW+vXX0iG6r7d/+TvZxz0ZWizV3GgXne77ZtJ6XCA
PVYYYwhv2vLM0D9/AlQiVBDYsoHUwHU9S3/Hd8M+eKsaA7Ugay9qK7HFiH7Eux6w
wdhFJ2+qN1j3hybX2C32qRe3H3I2TqYXP2WYktsqbl2i/ojgC95/5Y0V4evLOtXi
EqITLdiOr18SPaAIBQi2XKVlOARFmR6jYGB0xUGlcmIbYsUfb18aQr4CUWWoriMY
avx4A6lNf4DD+qta/KFApMoZFv6yyO9ecw3ud72a9nmYvLEHZ6IVDd2gWMZEewo+
YihfukEHU1jPEX44dMX4/7VpkI+EdOqXG68CAQOjgcAwgb0wHQYDVR0OBBYEFNLE
sNKR1EwRcbNhyz2h/t2oatTjMIGNBgNVHSMEgYUwgYKAFNLEsNKR1EwRcbNhyz2h
/t2oatTjoWekZTBjMQswCQYDVQQGEwJVUzEhMB8GA1UEChMYVGhlIEdvIERhZGR5
IEdyb3VwLCBJbmMuMTEwLwYDVQQLEyhHbyBEYWRkeSBDbGFzcyAyIENlcnRpZmlj
YXRpb24gQXV0aG9yaXR5ggEAMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQAD
ggEBADJL87LKPpH8EsahB4yOd6AzBhRckB4Y9wimPQoZ+YeAEW5p5JYXMP80kWNy
OO7MHAGjHZQopDH2esRU1/blMVgDoszOYtuURXO1v0XJJLXVggKtI3lpjbi2Tc7P
TMozI+gciKqdi0FuFskg5YmezTvacPd+mSYgFFQlq25zheabIZ0KbIIOqPjCDPoQ
HmyW74cNxA9hi63ugyuV+I6ShHI56yDqg+2DzZduCLzrTia2cyvk0/ZM/iZx4mER
dEr/VxqHD3VILs9RaRegAhJhldXRQLIQTO7ErBBDpqWeCtWVYpoNz4iCxTIM5Cuf
ReYNnyicsbkqWletNw+vHX/bvZ8=
-----END CERTIFICATE-----', '4e1ac09956520b52461ca8b0a8b29826');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=The Go Daddy Group, Inc.', 3, 1, 0, '2004-06-29 17:06:20', '2024-06-29 17:06:20', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 269 (0x10d)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 2 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Validity
            Not Before: Jun 29 17:06:20 2004 GMT
            Not After : Jun 29 17:06:20 2024 GMT
        Subject: C=US, O=The Go Daddy Group, Inc., OU=Go Daddy Class 2 Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:de:9d:d7:ea:57:18:49:a1:5b:eb:d7:5f:48:86:
                    ea:be:dd:ff:e4:ef:67:1c:f4:65:68:b3:57:71:a0:
                    5e:77:bb:ed:9b:49:e9:70:80:3d:56:18:63:08:6f:
                    da:f2:cc:d0:3f:7f:02:54:22:54:10:d8:b2:81:d4:
                    c0:75:3d:4b:7f:c7:77:c3:3e:78:ab:1a:03:b5:20:
                    6b:2f:6a:2b:b1:c5:88:7e:c4:bb:1e:b0:c1:d8:45:
                    27:6f:aa:37:58:f7:87:26:d7:d8:2d:f6:a9:17:b7:
                    1f:72:36:4e:a6:17:3f:65:98:92:db:2a:6e:5d:a2:
                    fe:88:e0:0b:de:7f:e5:8d:15:e1:eb:cb:3a:d5:e2:
                    12:a2:13:2d:d8:8e:af:5f:12:3d:a0:08:05:08:b6:
                    5c:a5:65:38:04:45:99:1e:a3:60:60:74:c5:41:a5:
                    72:62:1b:62:c5:1f:6f:5f:1a:42:be:02:51:65:a8:
                    ae:23:18:6a:fc:78:03:a9:4d:7f:80:c3:fa:ab:5a:
                    fc:a1:40:a4:ca:19:16:fe:b2:c8:ef:5e:73:0d:ee:
                    77:bd:9a:f6:79:98:bc:b1:07:67:a2:15:0d:dd:a0:
                    58:c6:44:7b:0a:3e:62:28:5f:ba:41:07:53:58:cf:
                    11:7e:38:74:c5:f8:ff:b5:69:90:8f:84:74:ea:97:
                    1b:af
                Exponent: 3 (0x3)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                D2:C4:B0:D2:91:D4:4C:11:71:B3:61:CB:3D:A1:FE:DD:A8:6A:D4:E3
            X509v3 Authority Key Identifier: 
                DirName:/L=ValiCert Validation Network/O=ValiCert, Inc./OU=ValiCert Class 2 Policy Validation Authority/CN=http://www.valicert.com//emailAddress=info@valicert.com
                serial:01

            X509v3 Basic Constraints: critical
                CA:TRUE
            Authority Information Access: 
                OCSP - URI:http://ocsp.godaddy.com

            X509v3 CRL Distribution Points: 
                URI:http://certificates.godaddy.com/repository/root.crl

            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: http://certificates.godaddy.com/repository

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        b5:40:f9:a7:1d:f6:ea:fe:a4:1a:42:5a:44:f7:15:d4:85:46:
        89:c0:be:9e:e3:e3:eb:c5:e3:58:89:8f:92:9f:57:a8:71:2c:
        48:d1:81:b2:79:1f:ac:06:35:19:b0:4e:0e:58:1b:14:b3:98:
        81:d1:04:1e:c8:07:c9:83:9f:78:44:0a:18:0b:98:dc:76:7a:
        65:0d:0d:6d:80:c4:0b:01:1c:cb:ad:47:3e:71:be:77:4b:cc:
        06:77:d0:f4:56:6b:1f:4b:13:9a:14:8a:88:23:a8:51:f0:83:
        4c:ab:35:bf:46:7e:39:dc:75:a4:ae:e8:29:fb:ef:39:8f:4f:
        55:67', 'DE9DD7EA571849A15BEBD75F4886EABEDDFFE4EF671CF46568B35771A05E77BBED9B49E970803D561863086FDAF2CCD03F7F0254225410D8B281D4C0753D4B7FC777C33E78AB1A03B5206B2F6A2BB1C5887EC4BB1EB0C1D845276FAA3758F78726D7D82DF6A917B71F72364EA6173F659892DB2A6E5DA2FE88E00BDE7FE58D15E1EBCB3AD5E212A2132DD88EAF5F123DA0080508B65CA565380445991EA3606074C541A572621B62C51F6F5F1A42BE025165A8AE23186AFC7803A94D7F80C3FAAB5AFCA140A4CA1916FEB2C8EF5E730DEE77BD9AF67998BCB10767A2150DDDA058C6447B0A3E62285FBA41075358CF117E3874C5F8FFB569908F8474EA971BAF', '/C=US/O=The Go Daddy Group, Inc./OU=Go Daddy Class 2 Certification Authority', 'L=ValiCert Validation Network/O=ValiCert, Inc./OU=ValiCert Class 2 Policy Validation Authority/CN=http://www.valicert.com//emailAddress=info@valicert.com', '010D', NULL, '-----BEGIN CERTIFICATE-----
MIIE+zCCBGSgAwIBAgICAQ0wDQYJKoZIhvcNAQEFBQAwgbsxJDAiBgNVBAcTG1Zh
bGlDZXJ0IFZhbGlkYXRpb24gTmV0d29yazEXMBUGA1UEChMOVmFsaUNlcnQsIElu
Yy4xNTAzBgNVBAsTLFZhbGlDZXJ0IENsYXNzIDIgUG9saWN5IFZhbGlkYXRpb24g
QXV0aG9yaXR5MSEwHwYDVQQDExhodHRwOi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAe
BgkqhkiG9w0BCQEWEWluZm9AdmFsaWNlcnQuY29tMB4XDTA0MDYyOTE3MDYyMFoX
DTI0MDYyOTE3MDYyMFowYzELMAkGA1UEBhMCVVMxITAfBgNVBAoTGFRoZSBHbyBE
YWRkeSBHcm91cCwgSW5jLjExMC8GA1UECxMoR28gRGFkZHkgQ2xhc3MgMiBDZXJ0
aWZpY2F0aW9uIEF1dGhvcml0eTCCASAwDQYJKoZIhvcNAQEBBQADggENADCCAQgC
ggEBAN6d1+pXGEmhW+vXX0iG6r7d/+TvZxz0ZWizV3GgXne77ZtJ6XCAPVYYYwhv
2vLM0D9/AlQiVBDYsoHUwHU9S3/Hd8M+eKsaA7Ugay9qK7HFiH7Eux6wwdhFJ2+q
N1j3hybX2C32qRe3H3I2TqYXP2WYktsqbl2i/ojgC95/5Y0V4evLOtXiEqITLdiO
r18SPaAIBQi2XKVlOARFmR6jYGB0xUGlcmIbYsUfb18aQr4CUWWoriMYavx4A6lN
f4DD+qta/KFApMoZFv6yyO9ecw3ud72a9nmYvLEHZ6IVDd2gWMZEewo+YihfukEH
U1jPEX44dMX4/7VpkI+EdOqXG68CAQOjggHhMIIB3TAdBgNVHQ4EFgQU0sSw0pHU
TBFxs2HLPaH+3ahq1OMwgdIGA1UdIwSByjCBx6GBwaSBvjCBuzEkMCIGA1UEBxMb
VmFsaUNlcnQgVmFsaWRhdGlvbiBOZXR3b3JrMRcwFQYDVQQKEw5WYWxpQ2VydCwg
SW5jLjE1MDMGA1UECxMsVmFsaUNlcnQgQ2xhc3MgMiBQb2xpY3kgVmFsaWRhdGlv
biBBdXRob3JpdHkxITAfBgNVBAMTGGh0dHA6Ly93d3cudmFsaWNlcnQuY29tLzEg
MB4GCSqGSIb3DQEJARYRaW5mb0B2YWxpY2VydC5jb22CAQEwDwYDVR0TAQH/BAUw
AwEB/zAzBggrBgEFBQcBAQQnMCUwIwYIKwYBBQUHMAGGF2h0dHA6Ly9vY3NwLmdv
ZGFkZHkuY29tMEQGA1UdHwQ9MDswOaA3oDWGM2h0dHA6Ly9jZXJ0aWZpY2F0ZXMu
Z29kYWRkeS5jb20vcmVwb3NpdG9yeS9yb290LmNybDBLBgNVHSAERDBCMEAGBFUd
IAAwODA2BggrBgEFBQcCARYqaHR0cDovL2NlcnRpZmljYXRlcy5nb2RhZGR5LmNv
bS9yZXBvc2l0b3J5MA4GA1UdDwEB/wQEAwIBBjANBgkqhkiG9w0BAQUFAAOBgQC1
QPmnHfbq/qQaQlpE9xXUhUaJwL6e4+PrxeNYiY+Sn1eocSxI0YGyeR+sBjUZsE4O
WBsUs5iB0QQeyAfJg594RAoYC5jcdnplDQ1tgMQLARzLrUc+cb53S8wGd9D0Vmsf
SxOaFIqII6hR8INMqzW/Rn453HWkrugp++85j09VZw==
-----END CERTIFICATE-----', 'beb03a7edc694ef3adc708b1e1f89c70');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=The USERTRUST Network, CN=UTN - DATACorp SGC', 3, 1, 0, '1999-06-24 18:57:21', '2019-06-24 19:06:30', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            44:be:0c:8b:50:00:21:b4:11:d3:2a:68:06:a9:ad:69
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, ST=UT, L=Salt Lake City, O=The USERTRUST Network, OU=http://www.usertrust.com, CN=UTN - DATACorp SGC
        Validity
            Not Before: Jun 24 18:57:21 1999 GMT
            Not After : Jun 24 19:06:30 2019 GMT
        Subject: C=US, ST=UT, L=Salt Lake City, O=The USERTRUST Network, OU=http://www.usertrust.com, CN=UTN - DATACorp SGC
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:df:ee:58:10:a2:2b:6e:55:c4:8e:bf:2e:46:09:
                    e7:e0:08:0f:2e:2b:7a:13:94:1b:bd:f6:b6:80:8e:
                    65:05:93:00:1e:bc:af:e2:0f:8e:19:0d:12:47:ec:
                    ac:ad:a3:fa:2e:70:f8:de:6e:fb:56:42:15:9e:2e:
                    5c:ef:23:de:21:b9:05:76:27:19:0f:4f:d6:c3:9c:
                    b4:be:94:19:63:f2:a6:11:0a:eb:53:48:9c:be:f2:
                    29:3b:16:e8:1a:a0:4c:a6:c9:f4:18:59:68:c0:70:
                    f2:53:00:c0:5e:50:82:a5:56:6f:36:f9:4a:e0:44:
                    86:a0:4d:4e:d6:47:6e:49:4a:cb:67:d7:a6:c4:05:
                    b9:8e:1e:f4:fc:ff:cd:e7:36:e0:9c:05:6c:b2:33:
                    22:15:d0:b4:e0:cc:17:c0:b2:c0:f4:fe:32:3f:29:
                    2a:95:7b:d8:f2:a7:4e:0f:54:7c:a1:0d:80:b3:09:
                    03:c1:ff:5c:dd:5e:9a:3e:bc:ae:bc:47:8a:6a:ae:
                    71:ca:1f:b1:2a:b8:5f:42:05:0b:ec:46:30:d1:72:
                    0b:ca:e9:56:6d:f5:ef:df:78:be:61:ba:b2:a5:ae:
                    04:4c:bc:a8:ac:69:15:97:bd:ef:eb:b4:8c:bf:35:
                    f8:d4:c3:d1:28:0e:5c:3a:9f:70:18:33:20:77:c4:
                    a2:af
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: 
                Digital Signature, Non Repudiation, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                53:32:D1:B3:CF:7F:FA:E0:F1:A0:5D:85:4E:92:D2:9E:45:1D:B4:4F
            X509v3 CRL Distribution Points: 
                URI:http://crl.usertrust.com/UTN-DATACorpSGC.crl

            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, Microsoft Server Gated Crypto, Netscape Server Gated Crypto
    Signature Algorithm: sha1WithRSAEncryption
        27:35:97:00:8a:8b:28:bd:c6:33:30:1e:29:fc:e2:f7:d5:98:
        d4:40:bb:60:ca:bf:ab:17:2c:09:36:7f:50:fa:41:dc:ae:96:
        3a:0a:23:3e:89:59:c9:a3:07:ed:1b:37:ad:fc:7c:be:51:49:
        5a:de:3a:0a:54:08:16:45:c2:99:b1:87:cd:8c:68:e0:69:03:
        e9:c4:4e:98:b2:3b:8c:16:b3:0e:a0:0c:98:50:9b:93:a9:70:
        09:c8:2c:a3:8f:df:02:e4:e0:71:3a:f1:b4:23:72:a0:aa:01:
        df:df:98:3e:14:50:a0:31:26:bd:28:e9:5a:30:26:75:f9:7b:
        60:1c:8d:f3:cd:50:26:6d:04:27:9a:df:d5:0d:45:47:29:6b:
        2c:e6:76:d9:a9:29:7d:32:dd:c9:36:3c:bd:ae:35:f1:11:9e:
        1d:bb:90:3f:12:47:4e:8e:d7:7e:0f:62:73:1d:52:26:38:1c:
        18:49:fd:30:74:9a:c4:e5:22:2f:d8:c0:8d:ed:91:7a:4c:00:
        8f:72:7f:5d:da:dd:1b:8b:45:6b:e7:dd:69:97:a8:c5:56:4c:
        0f:0c:f6:9f:7a:91:37:f6:97:82:e0:dd:71:69:ff:76:3f:60:
        4d:3c:cf:f7:99:f9:c6:57:f4:c9:55:39:78:ba:2c:79:c9:a6:
        88:2b:f4:08', 'DFEE5810A22B6E55C48EBF2E4609E7E0080F2E2B7A13941BBDF6B6808E650593001EBCAFE20F8E190D1247ECACADA3FA2E70F8DE6EFB5642159E2E5CEF23DE21B9057627190F4FD6C39CB4BE941963F2A6110AEB53489CBEF2293B16E81AA04CA6C9F4185968C070F25300C05E5082A5566F36F94AE04486A04D4ED6476E494ACB67D7A6C405B98E1EF4FCFFCDE736E09C056CB2332215D0B4E0CC17C0B2C0F4FE323F292A957BD8F2A74E0F547CA10D80B30903C1FF5CDD5E9A3EBCAEBC478A6AAE71CA1FB12AB85F42050BEC4630D1720BCAE9566DF5EFDF78BE61BAB2A5AE044CBCA8AC691597BDEFEBB48CBF35F8D4C3D1280E5C3A9F7018332077C4A2AF', '/C=US/ST=UT/L=Salt Lake City/O=The USERTRUST Network/OU=http://www.usertrust.com/CN=UTN - DATACorp SGC', 'C=US/ST=UT/L=Salt Lake City/O=The USERTRUST Network/OU=http://www.usertrust.com/CN=UTN - DATACorp SGC', '44BE0C8B500021B411D32A6806A9AD69', NULL, '-----BEGIN CERTIFICATE-----
MIIEXjCCA0agAwIBAgIQRL4Mi1AAIbQR0ypoBqmtaTANBgkqhkiG9w0BAQUFADCB
kzELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAlVUMRcwFQYDVQQHEw5TYWx0IExha2Ug
Q2l0eTEeMBwGA1UEChMVVGhlIFVTRVJUUlVTVCBOZXR3b3JrMSEwHwYDVQQLExho
dHRwOi8vd3d3LnVzZXJ0cnVzdC5jb20xGzAZBgNVBAMTElVUTiAtIERBVEFDb3Jw
IFNHQzAeFw05OTA2MjQxODU3MjFaFw0xOTA2MjQxOTA2MzBaMIGTMQswCQYDVQQG
EwJVUzELMAkGA1UECBMCVVQxFzAVBgNVBAcTDlNhbHQgTGFrZSBDaXR5MR4wHAYD
VQQKExVUaGUgVVNFUlRSVVNUIE5ldHdvcmsxITAfBgNVBAsTGGh0dHA6Ly93d3cu
dXNlcnRydXN0LmNvbTEbMBkGA1UEAxMSVVROIC0gREFUQUNvcnAgU0dDMIIBIjAN
BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3+5YEKIrblXEjr8uRgnn4AgPLit6
E5Qbvfa2gI5lBZMAHryv4g+OGQ0SR+ysraP6LnD43m77VkIVni5c7yPeIbkFdicZ
D0/Ww5y0vpQZY/KmEQrrU0icvvIpOxboGqBMpsn0GFlowHDyUwDAXlCCpVZvNvlK
4ESGoE1O1kduSUrLZ9emxAW5jh70/P/N5zbgnAVssjMiFdC04MwXwLLA9P4yPykq
lXvY8qdOD1R8oQ2AswkDwf9c3V6aPryuvEeKaq5xyh+xKrhfQgUL7EYw0XILyulW
bfXv33i+Ybqypa4ETLyorGkVl73v67SMvzX41MPRKA5cOp9wGDMgd8SirwIDAQAB
o4GrMIGoMAsGA1UdDwQEAwIBxjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBRT
MtGzz3/64PGgXYVOktKeRR20TzA9BgNVHR8ENjA0MDKgMKAuhixodHRwOi8vY3Js
LnVzZXJ0cnVzdC5jb20vVVROLURBVEFDb3JwU0dDLmNybDAqBgNVHSUEIzAhBggr
BgEFBQcDAQYKKwYBBAGCNwoDAwYJYIZIAYb4QgQBMA0GCSqGSIb3DQEBBQUAA4IB
AQAnNZcAiosovcYzMB4p/OL31ZjUQLtgyr+rFywJNn9Q+kHcrpY6CiM+iVnJowft
Gzet/Hy+UUla3joKVAgWRcKZsYfNjGjgaQPpxE6YsjuMFrMOoAyYUJuTqXAJyCyj
j98C5OBxOvG0I3KgqgHf35g+FFCgMSa9KOlaMCZ1+XtgHI3zzVAmbQQnmt/VDUVH
KWss5nbZqSl9Mt3JNjy9rjXxEZ4du5A/EkdOjtd+D2JzHVImOBwYSf0wdJrE5SIv
2MCN7ZF6TACPcn9d2t0bi0Vr591pl6jFVkwPDPafepE39peC4N1xaf92P2BNPM/3
mfnGV/TJVTl4uix5yaaIK/QI
-----END CERTIFICATE-----', '84b747f76d29985faa00eb366f28c8bc');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=The USERTRUST Network, CN=UTN-USERFirst-Client Authentication and Email', 3, 1, 0, '1999-07-09 17:28:50', '2019-07-09 17:36:58', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            44:be:0c:8b:50:00:24:b4:11:d3:36:25:25:67:c9:89
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, ST=UT, L=Salt Lake City, O=The USERTRUST Network, OU=http://www.usertrust.com, CN=UTN-USERFirst-Client Authentication and Email
        Validity
            Not Before: Jul  9 17:28:50 1999 GMT
            Not After : Jul  9 17:36:58 2019 GMT
        Subject: C=US, ST=UT, L=Salt Lake City, O=The USERTRUST Network, OU=http://www.usertrust.com, CN=UTN-USERFirst-Client Authentication and Email
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b2:39:85:a4:f2:7d:ab:41:3b:62:46:37:ae:cd:
                    c1:60:75:bc:39:65:f9:4a:1a:47:a2:b9:cc:48:cc:
                    6a:98:d5:4d:35:19:b9:a4:42:e5:ce:49:e2:8a:2f:
                    1e:7c:d2:31:07:c7:4e:b4:83:64:9d:2e:29:d5:a2:
                    64:c4:85:bd:85:51:35:79:a4:4e:68:90:7b:1c:7a:
                    a4:92:a8:17:f2:98:15:f2:93:cc:c9:a4:32:95:bb:
                    0c:4f:30:bd:98:a0:0b:8b:e5:6e:1b:a2:46:fa:78:
                    bc:a2:6f:ab:59:5e:a5:2f:cf:ca:da:6d:aa:2f:eb:
                    ac:a1:b3:6a:aa:b7:2e:67:35:8b:79:e1:1e:69:88:
                    e2:e6:46:cd:a0:a5:ea:be:0b:ce:76:3a:7a:0e:9b:
                    ea:fc:da:27:5b:3d:73:1f:22:e6:48:61:c6:4c:f3:
                    69:b1:a8:2e:1b:b6:d4:31:20:2c:bc:82:8a:8e:a4:
                    0e:a5:d7:89:43:fc:16:5a:af:1d:71:d7:11:59:da:
                    ba:87:0d:af:fa:f3:e1:c2:f0:a4:c5:67:8c:d6:d6:
                    54:3a:de:0a:a4:ba:03:77:b3:65:c8:fd:1e:d3:74:
                    62:aa:18:ca:68:93:1e:a1:85:7e:f5:47:65:cb:f8:
                    4d:57:28:74:d2:34:ff:30:b6:ee:f6:62:30:14:8c:
                    2c:eb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: 
                Digital Signature, Non Repudiation, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                89:82:67:7D:C4:9D:26:70:00:4B:B4:50:48:7C:DE:3D:AE:04:6E:7D
            X509v3 CRL Distribution Points: 
                URI:http://crl.usertrust.com/UTN-USERFirst-ClientAuthenticationandEmail.crl

            X509v3 Extended Key Usage: 
                TLS Web Client Authentication, E-mail Protection
    Signature Algorithm: sha1WithRSAEncryption
        b1:6d:61:5d:a6:1a:7f:7c:ab:4a:e4:30:fc:53:6f:25:24:c6:
        ca:ed:e2:31:5c:2b:0e:ee:ee:61:55:6f:04:3e:cf:39:de:c5:
        1b:49:94:e4:eb:20:4c:b4:e6:9e:50:2e:72:d9:8d:f5:aa:a3:
        b3:4a:da:56:1c:60:97:80:dc:82:a2:ad:4a:bd:8a:2b:ff:0b:
        09:b4:c6:d7:20:04:45:e4:cd:80:01:ba:ba:2b:6e:ce:aa:d7:
        92:fe:e4:af:eb:f4:26:1d:16:2a:7f:6c:30:95:37:2f:33:12:
        ac:7f:dd:c7:d1:11:8c:51:98:b2:d0:a3:91:d0:ad:f6:9f:9e:
        83:93:1e:1d:42:b8:46:af:6b:66:f0:9b:7f:ea:e3:03:02:e5:
        02:51:c1:aa:d5:35:9d:72:40:03:89:ba:31:1d:c5:10:68:52:
        9e:df:a2:85:c5:5c:08:a6:78:e6:53:4f:b1:e8:b7:d3:14:9e:
        93:a6:c3:64:e3:ac:7e:71:cd:bc:9f:e9:03:1b:cc:fb:e9:ac:
        31:c1:af:7c:15:74:02:99:c3:b2:47:a6:c2:32:61:d7:c7:6f:
        48:24:51:27:a1:d5:87:55:f2:7b:8f:98:3d:16:9e:ee:75:b6:
        f8:d0:8e:f2:f3:c6:ae:28:5b:a7:f0:f3:36:17:fc:c3:05:d3:
        ca:03:4a:54', 'B23985A4F27DAB413B624637AECDC16075BC3965F94A1A47A2B9CC48CC6A98D54D3519B9A442E5CE49E28A2F1E7CD23107C74EB483649D2E29D5A264C485BD85513579A44E68907B1C7AA492A817F29815F293CCC9A43295BB0C4F30BD98A00B8BE56E1BA246FA78BCA26FAB595EA52FCFCADA6DAA2FEBACA1B36AAAB72E67358B79E11E6988E2E646CDA0A5EABE0BCE763A7A0E9BEAFCDA275B3D731F22E64861C64CF369B1A82E1BB6D431202CBC828A8EA40EA5D78943FC165AAF1D71D71159DABA870DAFFAF3E1C2F0A4C5678CD6D6543ADE0AA4BA0377B365C8FD1ED37462AA18CA68931EA1857EF54765CBF84D572874D234FF30B6EEF66230148C2CEB', '/C=US/ST=UT/L=Salt Lake City/O=The USERTRUST Network/OU=http://www.usertrust.com/CN=UTN-USERFirst-Client Authentication and Email', 'C=US/ST=UT/L=Salt Lake City/O=The USERTRUST Network/OU=http://www.usertrust.com/CN=UTN-USERFirst-Client Authentication and Email', '44BE0C8B500024B411D336252567C989', NULL, '-----BEGIN CERTIFICATE-----
MIIEojCCA4qgAwIBAgIQRL4Mi1AAJLQR0zYlJWfJiTANBgkqhkiG9w0BAQUFADCB
rjELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAlVUMRcwFQYDVQQHEw5TYWx0IExha2Ug
Q2l0eTEeMBwGA1UEChMVVGhlIFVTRVJUUlVTVCBOZXR3b3JrMSEwHwYDVQQLExho
dHRwOi8vd3d3LnVzZXJ0cnVzdC5jb20xNjA0BgNVBAMTLVVUTi1VU0VSRmlyc3Qt
Q2xpZW50IEF1dGhlbnRpY2F0aW9uIGFuZCBFbWFpbDAeFw05OTA3MDkxNzI4NTBa
Fw0xOTA3MDkxNzM2NThaMIGuMQswCQYDVQQGEwJVUzELMAkGA1UECBMCVVQxFzAV
BgNVBAcTDlNhbHQgTGFrZSBDaXR5MR4wHAYDVQQKExVUaGUgVVNFUlRSVVNUIE5l
dHdvcmsxITAfBgNVBAsTGGh0dHA6Ly93d3cudXNlcnRydXN0LmNvbTE2MDQGA1UE
AxMtVVROLVVTRVJGaXJzdC1DbGllbnQgQXV0aGVudGljYXRpb24gYW5kIEVtYWls
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsjmFpPJ9q0E7YkY3rs3B
YHW8OWX5ShpHornMSMxqmNVNNRm5pELlzkniii8efNIxB8dOtINknS4p1aJkxIW9
hVE1eaROaJB7HHqkkqgX8pgV8pPMyaQylbsMTzC9mKALi+VuG6JG+ni8om+rWV6l
L8/K2m2qL+usobNqqrcuZzWLeeEeaYji5kbNoKXqvgvOdjp6Dpvq/NonWz1zHyLm
SGHGTPNpsaguG7bUMSAsvIKKjqQOpdeJQ/wWWq8dcdcRWdq6hw2v+vPhwvCkxWeM
1tZUOt4KpLoDd7NlyP0e03RiqhjKaJMeoYV+9Udly/hNVyh00jT/MLbu9mIwFIws
6wIDAQABo4G5MIG2MAsGA1UdDwQEAwIBxjAPBgNVHRMBAf8EBTADAQH/MB0GA1Ud
DgQWBBSJgmd9xJ0mcABLtFBIfN49rgRufTBYBgNVHR8EUTBPME2gS6BJhkdodHRw
Oi8vY3JsLnVzZXJ0cnVzdC5jb20vVVROLVVTRVJGaXJzdC1DbGllbnRBdXRoZW50
aWNhdGlvbmFuZEVtYWlsLmNybDAdBgNVHSUEFjAUBggrBgEFBQcDAgYIKwYBBQUH
AwQwDQYJKoZIhvcNAQEFBQADggEBALFtYV2mGn98q0rkMPxTbyUkxsrt4jFcKw7u
7mFVbwQ+zznexRtJlOTrIEy05p5QLnLZjfWqo7NK2lYcYJeA3IKirUq9iiv/Cwm0
xtcgBEXkzYABurorbs6q15L+5K/r9CYdFip/bDCVNy8zEqx/3cfREYxRmLLQo5HQ
rfafnoOTHh1CuEava2bwm3/q4wMC5QJRwarVNZ1yQAOJujEdxRBoUp7fooXFXAim
eOZTT7Hot9MUnpOmw2TjrH5xzbyf6QMbzPvprDHBr3wVdAKZw7JHpsIyYdfHb0gk
USeh1YdV8nuPmD0Wnu51tvjQjvLzxq4oW6fw8zYX/MMF08oDSlQ=
-----END CERTIFICATE-----', '8ab011a35b6d2479179b6aaec33f8d51');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=The USERTRUST Network, CN=UTN-USERFirst-Hardware', 3, 1, 0, '1999-07-09 18:10:42', '2019-07-09 18:19:22', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            44:be:0c:8b:50:00:24:b4:11:d3:36:2a:fe:65:0a:fd
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, ST=UT, L=Salt Lake City, O=The USERTRUST Network, OU=http://www.usertrust.com, CN=UTN-USERFirst-Hardware
        Validity
            Not Before: Jul  9 18:10:42 1999 GMT
            Not After : Jul  9 18:19:22 2019 GMT
        Subject: C=US, ST=UT, L=Salt Lake City, O=The USERTRUST Network, OU=http://www.usertrust.com, CN=UTN-USERFirst-Hardware
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b1:f7:c3:38:3f:b4:a8:7f:cf:39:82:51:67:d0:
                    6d:9f:d2:ff:58:f3:e7:9f:2b:ec:0d:89:54:99:b9:
                    38:99:16:f7:e0:21:79:48:c2:bb:61:74:12:96:1d:
                    3c:6a:72:d5:3c:10:67:3a:39:ed:2b:13:cd:66:eb:
                    95:09:33:a4:6c:97:b1:e8:c6:ec:c1:75:79:9c:46:
                    5e:8d:ab:d0:6a:fd:b9:2a:55:17:10:54:b3:19:f0:
                    9a:f6:f1:b1:5d:b6:a7:6d:fb:e0:71:17:6b:a2:88:
                    fb:00:df:fe:1a:31:77:0c:9a:01:7a:b1:32:e3:2b:
                    01:07:38:6e:c3:a5:5e:23:bc:45:9b:7b:50:c1:c9:
                    30:8f:db:e5:2b:7a:d3:5b:fb:33:40:1e:a0:d5:98:
                    17:bc:8b:87:c3:89:d3:5d:a0:8e:b2:aa:aa:f6:8e:
                    69:88:06:c5:fa:89:21:f3:08:9d:69:2e:09:33:9b:
                    29:0d:46:0f:8c:cc:49:34:b0:69:51:bd:f9:06:cd:
                    68:ad:66:4c:bc:3e:ac:61:bd:0a:88:0e:c8:df:3d:
                    ee:7c:04:4c:9d:0a:5e:6b:91:d6:ee:c7:ed:28:8d:
                    ab:4d:87:89:73:d0:6e:a4:d0:1e:16:8b:14:e1:76:
                    44:03:7f:63:ac:e4:cd:49:9c:c5:92:f4:ab:32:a1:
                    48:5b
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: 
                Digital Signature, Non Repudiation, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                A1:72:5F:26:1B:28:98:43:95:5D:07:37:D5:85:96:9D:4B:D2:C3:45
            X509v3 CRL Distribution Points: 
                URI:http://crl.usertrust.com/UTN-USERFirst-Hardware.crl

            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, IPSec End System, IPSec Tunnel, IPSec User
    Signature Algorithm: sha1WithRSAEncryption
        47:19:0f:de:74:c6:99:97:af:fc:ad:28:5e:75:8e:eb:2d:67:
        ee:4e:7b:2b:d7:0c:ff:f6:de:cb:55:a2:0a:e1:4c:54:65:93:
        60:6b:9f:12:9c:ad:5e:83:2c:eb:5a:ae:c0:e4:2d:f4:00:63:
        1d:b8:c0:6c:f2:cf:49:bb:4d:93:6f:06:a6:0a:22:b2:49:62:
        08:4e:ff:c8:c8:14:b2:88:16:5d:e7:01:e4:12:95:e5:45:34:
        b3:8b:69:bd:cf:b4:85:8f:75:51:9e:7d:3a:38:3a:14:48:12:
        c6:fb:a7:3b:1a:8d:0d:82:40:07:e8:04:08:90:a1:89:cb:19:
        50:df:ca:1c:01:bc:1d:04:19:7b:10:76:97:3b:ee:90:90:ca:
        c4:0e:1f:16:6e:75:ef:33:f8:d3:6f:5b:1e:96:e3:e0:74:77:
        74:7b:8a:a2:6e:2d:dd:76:d6:39:30:82:f0:ab:9c:52:f2:2a:
        c7:af:49:5e:7e:c7:68:e5:82:81:c8:6a:27:f9:27:88:2a:d5:
        58:50:95:1f:f0:3b:1c:57:bb:7d:14:39:62:2b:9a:c9:94:92:
        2a:a3:22:0c:ff:89:26:7d:5f:23:2b:47:d7:15:1d:a9:6a:9e:
        51:0d:2a:51:9e:81:f9:d4:3b:5e:70:12:7f:10:32:9c:1e:bb:
        9d:f8:66:a8', 'B1F7C3383FB4A87FCF39825167D06D9FD2FF58F3E79F2BEC0D895499B9389916F7E0217948C2BB617412961D3C6A72D53C10673A39ED2B13CD66EB950933A46C97B1E8C6ECC175799C465E8DABD06AFDB92A55171054B319F09AF6F1B15DB6A76DFBE071176BA288FB00DFFE1A31770C9A017AB132E32B0107386EC3A55E23BC459B7B50C1C9308FDBE52B7AD35BFB33401EA0D59817BC8B87C389D35DA08EB2AAAAF68E698806C5FA8921F3089D692E09339B290D460F8CCC4934B06951BDF906CD68AD664CBC3EAC61BD0A880EC8DF3DEE7C044C9D0A5E6B91D6EEC7ED288DAB4D878973D06EA4D01E168B14E17644037F63ACE4CD499CC592F4AB32A1485B', '/C=US/ST=UT/L=Salt Lake City/O=The USERTRUST Network/OU=http://www.usertrust.com/CN=UTN-USERFirst-Hardware', 'C=US/ST=UT/L=Salt Lake City/O=The USERTRUST Network/OU=http://www.usertrust.com/CN=UTN-USERFirst-Hardware', '44BE0C8B500024B411D3362AFE650AFD', NULL, '-----BEGIN CERTIFICATE-----
MIIEdDCCA1ygAwIBAgIQRL4Mi1AAJLQR0zYq/mUK/TANBgkqhkiG9w0BAQUFADCB
lzELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAlVUMRcwFQYDVQQHEw5TYWx0IExha2Ug
Q2l0eTEeMBwGA1UEChMVVGhlIFVTRVJUUlVTVCBOZXR3b3JrMSEwHwYDVQQLExho
dHRwOi8vd3d3LnVzZXJ0cnVzdC5jb20xHzAdBgNVBAMTFlVUTi1VU0VSRmlyc3Qt
SGFyZHdhcmUwHhcNOTkwNzA5MTgxMDQyWhcNMTkwNzA5MTgxOTIyWjCBlzELMAkG
A1UEBhMCVVMxCzAJBgNVBAgTAlVUMRcwFQYDVQQHEw5TYWx0IExha2UgQ2l0eTEe
MBwGA1UEChMVVGhlIFVTRVJUUlVTVCBOZXR3b3JrMSEwHwYDVQQLExhodHRwOi8v
d3d3LnVzZXJ0cnVzdC5jb20xHzAdBgNVBAMTFlVUTi1VU0VSRmlyc3QtSGFyZHdh
cmUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCx98M4P7Sof885glFn
0G2f0v9Y8+efK+wNiVSZuTiZFvfgIXlIwrthdBKWHTxqctU8EGc6Oe0rE81m65UJ
M6Rsl7HoxuzBdXmcRl6Nq9Bq/bkqVRcQVLMZ8Jr28bFdtqdt++BxF2uiiPsA3/4a
MXcMmgF6sTLjKwEHOG7DpV4jvEWbe1DByTCP2+UretNb+zNAHqDVmBe8i4fDidNd
oI6yqqr2jmmIBsX6iSHzCJ1pLgkzmykNRg+MzEk0sGlRvfkGzWitZky8PqxhvQqI
DsjfPe58BEydCl5rkdbux+0ojatNh4lz0G6k0B4WixThdkQDf2Os5M1JnMWS9Ksy
oUhbAgMBAAGjgbkwgbYwCwYDVR0PBAQDAgHGMA8GA1UdEwEB/wQFMAMBAf8wHQYD
VR0OBBYEFKFyXyYbKJhDlV0HN9WFlp1L0sNFMEQGA1UdHwQ9MDswOaA3oDWGM2h0
dHA6Ly9jcmwudXNlcnRydXN0LmNvbS9VVE4tVVNFUkZpcnN0LUhhcmR3YXJlLmNy
bDAxBgNVHSUEKjAoBggrBgEFBQcDAQYIKwYBBQUHAwUGCCsGAQUFBwMGBggrBgEF
BQcDBzANBgkqhkiG9w0BAQUFAAOCAQEARxkP3nTGmZev/K0oXnWO6y1n7k57K9cM
//bey1WiCuFMVGWTYGufEpytXoMs61quwOQt9ABjHbjAbPLPSbtNk28Gpgoiskli
CE7/yMgUsogWXecB5BKV5UU0s4tpvc+0hY91UZ59Ojg6FEgSxvunOxqNDYJAB+gE
CJChicsZUN/KHAG8HQQZexB2lzvukJDKxA4fFm517zP4029bHpbj4HR3dHuKom4t
3XbWOTCC8KucUvIqx69JXn7HaOWCgchqJ/kniCrVWFCVH/A7HFe7fRQ5YiuayZSS
KqMiDP+JJn1fIytH1xUdqWqeUQ0qUZ6B+dQ7XnASfxAynB67nfhmqA==
-----END CERTIFICATE-----', '2fda7e44620cefba61549028d5243aaa');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=The USERTRUST Network, CN=UTN-USERFirst-Network Applications', 3, 1, 0, '1999-07-09 18:48:39', '2019-07-09 18:57:49', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            44:be:0c:8b:50:00:24:b4:11:d3:36:30:4b:c0:33:77
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, ST=UT, L=Salt Lake City, O=The USERTRUST Network, OU=http://www.usertrust.com, CN=UTN-USERFirst-Network Applications
        Validity
            Not Before: Jul  9 18:48:39 1999 GMT
            Not After : Jul  9 18:57:49 2019 GMT
        Subject: C=US, ST=UT, L=Salt Lake City, O=The USERTRUST Network, OU=http://www.usertrust.com, CN=UTN-USERFirst-Network Applications
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b3:fb:91:a1:e4:36:55:85:ac:06:34:5b:a0:9a:
                    58:b2:f8:b5:0f:05:77:83:ae:32:b1:76:92:68:ec:
                    23:4a:c9:76:3f:e3:9c:b6:37:79:03:b9:ab:69:8d:
                    07:25:b6:19:67:e4:b0:1b:18:73:61:4a:e8:7e:cd:
                    d3:2f:64:e3:a6:7c:0c:fa:17:80:a3:0d:47:89:4f:
                    51:71:2f:ee:fc:3f:f9:b8:16:80:87:89:93:25:20:
                    9a:43:82:69:24:76:28:59:35:a1:1d:c0:7f:83:06:
                    64:16:20:2c:d3:49:a4:85:b4:c0:61:7f:51:08:f8:
                    68:15:91:80:cb:a5:d5:ee:3b:3a:f4:84:04:5e:60:
                    59:a7:8c:34:72:ee:b8:78:c5:d1:3b:12:4a:6f:7e:
                    65:27:b9:a4:55:c5:b9:6f:43:a4:c5:1d:2c:99:c0:
                    52:a4:78:4c:15:b3:40:98:08:6b:43:c6:01:b0:7a:
                    7b:f5:6b:1c:22:3f:cb:ef:ff:a8:d0:3a:4b:76:15:
                    9e:d2:d1:c6:2e:e3:db:57:1b:32:a2:b8:6f:e8:86:
                    a6:3f:70:ab:e5:70:92:ab:44:1e:40:50:fb:9c:a3:
                    62:e4:6c:6e:a0:c8:de:e2:80:42:fa:e9:2f:e8:ce:
                    32:04:8f:7c:8d:b7:1c:a3:35:3c:15:dd:9e:c3:ae:
                    97:a5
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: 
                Digital Signature, Non Repudiation, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                FA:86:C9:DB:E0:BA:E9:78:F5:4B:A8:D6:15:DF:F0:D3:E1:6A:14:3C
            X509v3 CRL Distribution Points: 
                URI:http://crl.usertrust.com/UTN-USERFirst-NetworkApplications.crl

    Signature Algorithm: sha1WithRSAEncryption
        a4:f3:25:cc:d1:d4:91:83:22:d0:cc:32:ab:9b:96:4e:34:91:
        54:20:25:34:61:5f:2a:02:15:e1:8b:aa:ff:7d:64:51:cf:0a:
        ff:bc:7d:d8:21:6a:78:cb:2f:51:6f:f8:42:1d:33:bd:eb:b5:
        7b:94:c3:c3:a9:a0:2d:df:d1:29:1f:1d:fe:8f:3f:bb:a8:45:
        2a:7f:d1:6e:55:24:e2:bb:02:fb:31:3f:be:e8:bc:ec:40:2b:
        f8:01:d4:56:38:e4:ca:44:82:b5:61:20:21:67:65:f6:f0:0b:
        e7:34:f8:a5:c2:9c:a3:5c:40:1f:85:93:95:06:de:4f:d4:27:
        a9:b6:a5:fc:16:cd:73:31:3f:b8:65:27:cf:d4:53:1a:f0:ac:
        6e:9f:4f:05:0c:03:81:a7:84:29:c4:5a:bd:64:57:72:ad:3b:
        cf:37:18:a6:98:c6:ad:06:b4:dc:08:a3:04:d5:29:a4:96:9a:
        12:67:4a:8c:60:45:9d:f1:23:9a:b0:00:9c:68:b5:98:50:d3:
        ef:8e:2e:92:65:b1:48:3e:21:be:15:30:2a:0d:b5:0c:a3:6b:
        3f:ae:7f:57:f5:1f:96:7c:df:6f:dd:82:30:2c:65:1b:40:4a:
        cd:68:b9:72:ec:71:76:ec:54:8e:1f:85:0c:01:6a:fa:a6:38:
        ac:1f:c4:84', 'B3FB91A1E4365585AC06345BA09A58B2F8B50F057783AE32B1769268EC234AC9763FE39CB6377903B9AB698D0725B61967E4B01B1873614AE87ECDD32F64E3A67C0CFA1780A30D47894F51712FEEFC3FF9B8168087899325209A4382692476285935A11DC07F83066416202CD349A485B4C0617F5108F868159180CBA5D5EE3B3AF484045E6059A78C3472EEB878C5D13B124A6F7E6527B9A455C5B96F43A4C51D2C99C052A4784C15B34098086B43C601B07A7BF56B1C223FCBEFFFA8D03A4B76159ED2D1C62EE3DB571B32A2B86FE886A63F70ABE57092AB441E4050FB9CA362E46C6EA0C8DEE28042FAE92FE8CE32048F7C8DB71CA3353C15DD9EC3AE97A5', '/C=US/ST=UT/L=Salt Lake City/O=The USERTRUST Network/OU=http://www.usertrust.com/CN=UTN-USERFirst-Network Applications', 'C=US/ST=UT/L=Salt Lake City/O=The USERTRUST Network/OU=http://www.usertrust.com/CN=UTN-USERFirst-Network Applications', '44BE0C8B500024B411D336304BC03377', NULL, '-----BEGIN CERTIFICATE-----
MIIEZDCCA0ygAwIBAgIQRL4Mi1AAJLQR0zYwS8AzdzANBgkqhkiG9w0BAQUFADCB
ozELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAlVUMRcwFQYDVQQHEw5TYWx0IExha2Ug
Q2l0eTEeMBwGA1UEChMVVGhlIFVTRVJUUlVTVCBOZXR3b3JrMSEwHwYDVQQLExho
dHRwOi8vd3d3LnVzZXJ0cnVzdC5jb20xKzApBgNVBAMTIlVUTi1VU0VSRmlyc3Qt
TmV0d29yayBBcHBsaWNhdGlvbnMwHhcNOTkwNzA5MTg0ODM5WhcNMTkwNzA5MTg1
NzQ5WjCBozELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAlVUMRcwFQYDVQQHEw5TYWx0
IExha2UgQ2l0eTEeMBwGA1UEChMVVGhlIFVTRVJUUlVTVCBOZXR3b3JrMSEwHwYD
VQQLExhodHRwOi8vd3d3LnVzZXJ0cnVzdC5jb20xKzApBgNVBAMTIlVUTi1VU0VS
Rmlyc3QtTmV0d29yayBBcHBsaWNhdGlvbnMwggEiMA0GCSqGSIb3DQEBAQUAA4IB
DwAwggEKAoIBAQCz+5Gh5DZVhawGNFugmliy+LUPBXeDrjKxdpJo7CNKyXY/45y2
N3kDuatpjQclthln5LAbGHNhSuh+zdMvZOOmfAz6F4CjDUeJT1FxL+78P/m4FoCH
iZMlIJpDgmkkdihZNaEdwH+DBmQWICzTSaSFtMBhf1EI+GgVkYDLpdXuOzr0hARe
YFmnjDRy7rh4xdE7EkpvfmUnuaRVxblvQ6TFHSyZwFKkeEwVs0CYCGtDxgGwenv1
axwiP8vv/6jQOkt2FZ7S0cYu49tXGzKiuG/ohqY/cKvlcJKrRB5AUPuco2LkbG6g
yN7igEL66S/ozjIEj3yNtxyjNTwV3Z7DrpelAgMBAAGjgZEwgY4wCwYDVR0PBAQD
AgHGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFPqGydvguul49Uuo1hXf8NPh
ahQ8ME8GA1UdHwRIMEYwRKBCoECGPmh0dHA6Ly9jcmwudXNlcnRydXN0LmNvbS9V
VE4tVVNFUkZpcnN0LU5ldHdvcmtBcHBsaWNhdGlvbnMuY3JsMA0GCSqGSIb3DQEB
BQUAA4IBAQCk8yXM0dSRgyLQzDKrm5ZONJFUICU0YV8qAhXhi6r/fWRRzwr/vH3Y
IWp4yy9Rb/hCHTO967V7lMPDqaAt39EpHx3+jz+7qEUqf9FuVSTiuwL7MT++6Lzs
QCv4AdRWOOTKRIK1YSAhZ2X28AvnNPilwpyjXEAfhZOVBt5P1CeptqX8Fs1zMT+4
ZSfP1FMa8Kxun08FDAOBp4QpxFq9ZFdyrTvPNximmMatBrTcCKME1SmklpoSZ0qM
YEWd8SOasACcaLWYUNPvji6SZbFIPiG+FTAqDbUMo2s/rn9X9R+WfN9v3YIwLGUb
QErNaLly7HF27FSOH4UMAWr6pjisH8SE
-----END CERTIFICATE-----', 'cd8936687e54326d08c14dc47575f445');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=The USERTRUST Network, CN=UTN-USERFirst-Object', 3, 1, 0, '1999-07-09 18:31:20', '2019-07-09 18:40:36', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            44:be:0c:8b:50:00:24:b4:11:d3:36:2d:e0:b3:5f:1b
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, ST=UT, L=Salt Lake City, O=The USERTRUST Network, OU=http://www.usertrust.com, CN=UTN-USERFirst-Object
        Validity
            Not Before: Jul  9 18:31:20 1999 GMT
            Not After : Jul  9 18:40:36 2019 GMT
        Subject: C=US, ST=UT, L=Salt Lake City, O=The USERTRUST Network, OU=http://www.usertrust.com, CN=UTN-USERFirst-Object
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ce:aa:81:3f:a3:a3:61:78:aa:31:00:55:95:11:
                    9e:27:0f:1f:1c:df:3a:9b:82:68:30:c0:4a:61:1d:
                    f1:2f:0e:fa:be:79:f7:a5:23:ef:55:51:96:84:cd:
                    db:e3:b9:6e:3e:31:d8:0a:20:67:c7:f4:d9:bf:94:
                    eb:47:04:3e:02:ce:2a:a2:5d:87:04:09:f6:30:9d:
                    18:8a:97:b2:aa:1c:fc:41:d2:a1:36:cb:fb:3d:91:
                    ba:e7:d9:70:35:fa:e4:e7:90:c3:9b:a3:9b:d3:3c:
                    f5:12:99:77:b1:b7:09:e0:68:e6:1c:b8:f3:94:63:
                    88:6a:6a:fe:0b:76:c9:be:f4:22:e4:67:b9:ab:1a:
                    5e:77:c1:85:07:dd:0d:6c:bf:ee:06:c7:77:6a:41:
                    9e:a7:0f:d7:fb:ee:94:17:b7:fc:85:be:a4:ab:c4:
                    1c:31:dd:d7:b6:d1:e4:f0:ef:df:16:8f:b2:52:93:
                    d7:a1:d4:89:a1:07:2e:bf:e1:01:12:42:1e:1a:e1:
                    d8:95:34:db:64:79:28:ff:ba:2e:11:c2:e5:e8:5b:
                    92:48:fb:47:0b:c2:6c:da:ad:32:83:41:f3:a5:e5:
                    41:70:fd:65:90:6d:fa:fa:51:c4:f9:bd:96:2b:19:
                    04:2c:d3:6d:a7:dc:f0:7f:6f:83:65:e2:6a:ab:87:
                    86:75
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: 
                Digital Signature, Non Repudiation, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                DA:ED:64:74:14:9C:14:3C:AB:DD:99:A9:BD:5B:28:4D:8B:3C:C9:D8
            X509v3 CRL Distribution Points: 
                URI:http://crl.usertrust.com/UTN-USERFirst-Object.crl

            X509v3 Extended Key Usage: 
                Code Signing, Time Stamping, Microsoft Encrypted File System
    Signature Algorithm: sha1WithRSAEncryption
        08:1f:52:b1:37:44:78:db:fd:ce:b9:da:95:96:98:aa:55:64:
        80:b5:5a:40:dd:21:a5:c5:c1:f3:5f:2c:4c:c8:47:5a:69:ea:
        e8:f0:35:35:f4:d0:25:f3:c8:a6:a4:87:4a:bd:1b:b1:73:08:
        bd:d4:c3:ca:b6:35:bb:59:86:77:31:cd:a7:80:14:ae:13:ef:
        fc:b1:48:f9:6b:25:25:2d:51:b6:2c:6d:45:c1:98:c8:8a:56:
        5d:3e:ee:43:4e:3e:6b:27:8e:d0:3a:4b:85:0b:5f:d3:ed:6a:
        a7:75:cb:d1:5a:87:2f:39:75:13:5a:72:b0:02:81:9f:be:f0:
        0f:84:54:20:62:6c:69:d4:e1:4d:c6:0d:99:43:01:0d:12:96:
        8c:78:9d:bf:50:a2:b1:44:aa:6a:cf:17:7a:cf:6f:0f:d4:f8:
        24:55:5f:f0:34:16:49:66:3e:50:46:c9:63:71:38:31:62:b8:
        62:b9:f3:53:ad:6c:b5:2b:a2:12:aa:19:4f:09:da:5e:e7:93:
        c6:8e:14:08:fe:f0:30:80:18:a0:86:85:4d:c8:7d:d7:8b:03:
        fe:6e:d5:f7:9d:16:ac:92:2c:a0:23:e5:9c:91:52:1f:94:df:
        17:94:73:c3:b3:c1:c1:71:05:20:00:78:bd:13:52:1d:a8:3e:
        cd:00:1f:c8', 'CEAA813FA3A36178AA31005595119E270F1F1CDF3A9B826830C04A611DF12F0EFABE79F7A523EF55519684CDDBE3B96E3E31D80A2067C7F4D9BF94EB47043E02CE2AA25D870409F6309D188A97B2AA1CFC41D2A136CBFB3D91BAE7D97035FAE4E790C39BA39BD33CF5129977B1B709E068E61CB8F39463886A6AFE0B76C9BEF422E467B9AB1A5E77C18507DD0D6CBFEE06C7776A419EA70FD7FBEE9417B7FC85BEA4ABC41C31DDD7B6D1E4F0EFDF168FB25293D7A1D489A1072EBFE10112421E1AE1D89534DB647928FFBA2E11C2E5E85B9248FB470BC26CDAAD328341F3A5E54170FD65906DFAFA51C4F9BD962B19042CD36DA7DCF07F6F8365E26AAB878675', '/C=US/ST=UT/L=Salt Lake City/O=The USERTRUST Network/OU=http://www.usertrust.com/CN=UTN-USERFirst-Object', 'C=US/ST=UT/L=Salt Lake City/O=The USERTRUST Network/OU=http://www.usertrust.com/CN=UTN-USERFirst-Object', '44BE0C8B500024B411D3362DE0B35F1B', NULL, '-----BEGIN CERTIFICATE-----
MIIEZjCCA06gAwIBAgIQRL4Mi1AAJLQR0zYt4LNfGzANBgkqhkiG9w0BAQUFADCB
lTELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAlVUMRcwFQYDVQQHEw5TYWx0IExha2Ug
Q2l0eTEeMBwGA1UEChMVVGhlIFVTRVJUUlVTVCBOZXR3b3JrMSEwHwYDVQQLExho
dHRwOi8vd3d3LnVzZXJ0cnVzdC5jb20xHTAbBgNVBAMTFFVUTi1VU0VSRmlyc3Qt
T2JqZWN0MB4XDTk5MDcwOTE4MzEyMFoXDTE5MDcwOTE4NDAzNlowgZUxCzAJBgNV
BAYTAlVTMQswCQYDVQQIEwJVVDEXMBUGA1UEBxMOU2FsdCBMYWtlIENpdHkxHjAc
BgNVBAoTFVRoZSBVU0VSVFJVU1QgTmV0d29yazEhMB8GA1UECxMYaHR0cDovL3d3
dy51c2VydHJ1c3QuY29tMR0wGwYDVQQDExRVVE4tVVNFUkZpcnN0LU9iamVjdDCC
ASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM6qgT+jo2F4qjEAVZURnicP
HxzfOpuCaDDASmEd8S8O+r5596Uj71VRloTN2+O5bj4x2AogZ8f02b+U60cEPgLO
KqJdhwQJ9jCdGIqXsqoc/EHSoTbL+z2RuufZcDX65OeQw5ujm9M89RKZd7G3CeBo
5hy485RjiGpq/gt2yb70IuRnuasaXnfBhQfdDWy/7gbHd2pBnqcP1/vulBe3/IW+
pKvEHDHd17bR5PDv3xaPslKT16HUiaEHLr/hARJCHhrh2JU022R5KP+6LhHC5ehb
kkj7RwvCbNqtMoNB86XlQXD9ZZBt+vpRxPm9lisZBCzTbafc8H9vg2XiaquHhnUC
AwEAAaOBrzCBrDALBgNVHQ8EBAMCAcYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4E
FgQU2u1kdBScFDyr3ZmpvVsoTYs8ydgwQgYDVR0fBDswOTA3oDWgM4YxaHR0cDov
L2NybC51c2VydHJ1c3QuY29tL1VUTi1VU0VSRmlyc3QtT2JqZWN0LmNybDApBgNV
HSUEIjAgBggrBgEFBQcDAwYIKwYBBQUHAwgGCisGAQQBgjcKAwQwDQYJKoZIhvcN
AQEFBQADggEBAAgfUrE3RHjb/c652pWWmKpVZIC1WkDdIaXFwfNfLEzIR1pp6ujw
NTX00CXzyKakh0q9G7FzCL3Uw8q2NbtZhncxzaeAFK4T7/yxSPlrJSUtUbYsbUXB
mMiKVl0+7kNOPmsnjtA6S4ULX9Ptaqd1y9Fahy85dRNacrACgZ++8A+EVCBibGnU
4U3GDZlDAQ0Slox4nb9QorFEqmrPF3rPbw/U+CRVX/A0FklmPlBGyWNxODFiuGK5
81OtbLUrohKqGU8J2l7nk8aOFAj+8DCAGKCGhU3IfdeLA/5u1fedFqySLKAj5ZyR
Uh+U3xeUc8OzwcFxBSAAeL0TUh2oPs0AH8g=
-----END CERTIFICATE-----', '97806fddbf5a135a247c4e7676d12cf9');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc.', 3, 1, 0, '1996-01-29 00:00:00', '2028-08-01 23:59:59', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            70:ba:e4:1d:10:d9:29:34:b6:38:ca:7b:03:cc:ba:bf
        Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c9:5c:59:9e:f2:1b:8a:01:14:b4:10:df:04:40:
                    db:e3:57:af:6a:45:40:8f:84:0c:0b:d1:33:d9:d9:
                    11:cf:ee:02:58:1f:25:f7:2a:a8:44:05:aa:ec:03:
                    1f:78:7f:9e:93:b9:9a:00:aa:23:7d:d6:ac:85:a2:
                    63:45:c7:72:27:cc:f4:4c:c6:75:71:d2:39:ef:4f:
                    42:f0:75:df:0a:90:c6:8e:20:6f:98:0f:f8:ac:23:
                    5f:70:29:36:a4:c9:86:e7:b1:9a:20:cb:53:a5:85:
                    e7:3d:be:7d:9a:fe:24:45:33:dc:76:15:ed:0f:a2:
                    71:64:4c:65:2e:81:68:45:a7
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
        bb:4c:12:2b:cf:2c:26:00:4f:14:13:dd:a6:fb:fc:0a:11:84:
        8c:f3:28:1c:67:92:2f:7c:b6:c5:fa:df:f0:e8:95:bc:1d:8f:
        6c:2c:a8:51:cc:73:d8:a4:c0:53:f0:4e:d6:26:c0:76:01:57:
        81:92:5e:21:f1:d1:b1:ff:e7:d0:21:58:cd:69:17:e3:44:1c:
        9c:19:44:39:89:5c:dc:9c:00:0f:56:8d:02:99:ed:a2:90:45:
        4c:e4:bb:10:a4:3d:f0:32:03:0e:f1:ce:f8:e8:c9:51:8c:e6:
        62:9f:e6:9f:c0:7d:b7:72:9c:c9:36:3a:6b:9f:4e:a8:ff:64:
        0d:64', 'C95C599EF21B8A0114B410DF0440DBE357AF6A45408F840C0BD133D9D911CFEE02581F25F72AA84405AAEC031F787F9E93B99A00AA237DD6AC85A26345C77227CCF44CC67571D239EF4F42F075DF0A90C68E206F980FF8AC235F702936A4C986E7B19A20CB53A585E73DBE7D9AFE244533DC7615ED0FA271644C652E816845A7', '/C=US/O=VeriSign, Inc./OU=Class 3 Public Primary Certification Authority', 'C=US/O=VeriSign, Inc./OU=Class 3 Public Primary Certification Authority', '70BAE41D10D92934B638CA7B03CCBABF', NULL, '-----BEGIN CERTIFICATE-----
MIICPDCCAaUCEHC65B0Q2Sk0tjjKewPMur8wDQYJKoZIhvcNAQECBQAwXzELMAkG
A1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz
cyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2
MDEyOTAwMDAwMFoXDTI4MDgwMTIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNV
BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmlt
YXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GN
ADCBiQKBgQDJXFme8huKARS0EN8EQNvjV69qRUCPhAwL0TPZ2RHP7gJYHyX3KqhE
BarsAx94f56TuZoAqiN91qyFomNFx3InzPRMxnVx0jnvT0Lwdd8KkMaOIG+YD/is
I19wKTakyYbnsZogy1Olhec9vn2a/iRFM9x2Fe0PonFkTGUugWhFpwIDAQABMA0G
CSqGSIb3DQEBAgUAA4GBALtMEivPLCYATxQT3ab7/AoRhIzzKBxnki98tsX63/Do
lbwdj2wsqFHMc9ikwFPwTtYmwHYBV4GSXiHx0bH/59AhWM1pF+NEHJwZRDmJXNyc
AA9WjQKZ7aKQRUzkuxCkPfAyAw7xzvjoyVGM5mKf5p/AfbdynMk2OmufTqj/ZA1k
-----END CERTIFICATE-----', '0a28dafb3cab3a7249654d5c8323ef33');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc.', 3, 1, 0, '1998-05-18 00:00:00', '2028-08-01 23:59:59', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            b9:2f:60:cc:88:9f:a1:7a:46:09:b8:5b:70:6c:8a:af
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Validity
            Not Before: May 18 00:00:00 1998 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:a7:88:01:21:74:2c:e7:1a:03:f0:98:e1:97:3c:
                    0f:21:08:f1:9c:db:97:e9:9a:fc:c2:04:06:13:be:
                    5f:52:c8:cc:1e:2c:12:56:2c:b8:01:69:2c:cc:99:
                    1f:ad:b0:96:ae:79:04:f2:13:39:c1:7b:98:ba:08:
                    2c:e8:c2:84:13:2c:aa:69:e9:09:f4:c7:a9:02:a4:
                    42:c2:23:4f:4a:d8:f0:0e:a2:fb:31:6c:c9:e6:6f:
                    99:27:07:f5:e6:f4:4c:78:9e:6d:eb:46:86:fa:b9:
                    86:c9:54:f2:b2:c4:af:d4:46:1c:5a:c9:15:30:ff:
                    0d:6c:f5:2d:0e:6d:ce:7f:77
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        72:2e:f9:7f:d1:f1:71:fb:c4:9e:f6:c5:5e:51:8a:40:98:b8:
        68:f8:9b:1c:83:d8:e2:9d:bd:ff:ed:a1:e6:66:ea:2f:09:f4:
        ca:d7:ea:a5:2b:95:f6:24:60:86:4d:44:2e:83:a5:c4:2d:a0:
        d3:ae:78:69:6f:72:da:6c:ae:08:f0:63:92:37:e6:bb:c4:30:
        17:ad:77:cc:49:35:aa:cf:d8:8f:d1:be:b7:18:96:47:73:6a:
        54:22:34:64:2d:b6:16:9b:59:5b:b4:51:59:3a:b3:0b:14:f4:
        12:df:67:a0:f4:ad:32:64:5e:b1:46:72:27:8c:12:7b:c5:44:
        b4:ae', 'A7880121742CE71A03F098E1973C0F2108F19CDB97E99AFCC2040613BE5F52C8CC1E2C12562CB801692CCC991FADB096AE7904F21339C17B98BA082CE8C284132CAA69E909F4C7A902A442C2234F4AD8F00EA2FB316CC9E66F992707F5E6F44C789E6DEB4686FAB986C954F2B2C4AFD4461C5AC91530FF0D6CF52D0E6DCE7F77', '/C=US/O=VeriSign, Inc./OU=Class 2 Public Primary Certification Authority - G2/OU=(c) 1998 VeriSign, Inc. - For authorized use only/OU=VeriSign Trust Network', 'C=US/O=VeriSign, Inc./OU=Class 2 Public Primary Certification Authority - G2/OU=(c) 1998 VeriSign, Inc. - For authorized use only/OU=VeriSign Trust Network', 'B92F60CC889FA17A4609B85B706C8AAF', NULL, '-----BEGIN CERTIFICATE-----
MIIDAzCCAmwCEQC5L2DMiJ+hekYJuFtwbIqvMA0GCSqGSIb3DQEBBQUAMIHBMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xPDA6BgNVBAsTM0Ns
YXNzIDIgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBH
MjE6MDgGA1UECxMxKGMpIDE5OTggVmVyaVNpZ24sIEluYy4gLSBGb3IgYXV0aG9y
aXplZCB1c2Ugb25seTEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazAe
Fw05ODA1MTgwMDAwMDBaFw0yODA4MDEyMzU5NTlaMIHBMQswCQYDVQQGEwJVUzEX
MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xPDA6BgNVBAsTM0NsYXNzIDIgUHVibGlj
IFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBHMjE6MDgGA1UECxMx
KGMpIDE5OTggVmVyaVNpZ24sIEluYy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25s
eTEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazCBnzANBgkqhkiG9w0B
AQEFAAOBjQAwgYkCgYEAp4gBIXQs5xoD8JjhlzwPIQjxnNuX6Zr8wgQGE75fUsjM
HiwSViy4AWkszJkfrbCWrnkE8hM5wXuYuggs6MKEEyyqaekJ9MepAqRCwiNPStjw
DqL7MWzJ5m+ZJwf15vRMeJ5t60aG+rmGyVTyssSv1EYcWskVMP8NbPUtDm3Of3cC
AwEAATANBgkqhkiG9w0BAQUFAAOBgQByLvl/0fFx+8Se9sVeUYpAmLho+Jscg9ji
nb3/7aHmZuovCfTK1+qlK5X2JGCGTUQug6XELaDTrnhpb3LabK4I8GOSN+a7xDAX
rXfMSTWqz9iP0b63GJZHc2pUIjRkLbYWm1lbtFFZOrMLFPQS32eg9K0yZF6xRnIn
jBJ7xUS0rg==
-----END CERTIFICATE-----', 'ed4eb0d800a5f250b3286653d6c357e7');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc.', 3, 1, 0, '1996-01-29 00:00:00', '2028-08-01 23:59:59', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            2d:1b:fc:4a:17:8d:a3:91:eb:e7:ff:f5:8b:45:be:0b
        Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:b6:5a:8b:a3:0d:6a:23:83:80:6b:cf:39:87:f4:
                    21:13:33:06:4c:25:a2:ed:55:12:97:c5:a7:80:b9:
                    fa:83:c1:20:a0:fa:2f:15:0d:7c:a1:60:6b:7e:79:
                    2c:fa:06:0f:3a:ae:f6:1b:6f:b1:d2:ff:2f:28:52:
                    5f:83:7d:4b:c4:7a:b7:f8:66:1f:80:54:fc:b7:c2:
                    8e:59:4a:14:57:46:d1:9a:93:be:41:91:03:bb:15:
                    80:93:5c:eb:e7:cc:08:6c:3f:3e:b3:4a:fc:ff:4b:
                    6c:23:d5:50:82:26:44:19:8e:23:c3:71:ea:19:24:
                    47:04:9e:75:bf:c8:a6:00:1f
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
        8a:1b:2b:fa:39:c1:74:d7:5e:d8:19:64:a2:58:4a:2d:37:e0:
        33:47:0f:ac:ed:f7:aa:db:1e:e4:8b:06:5c:60:27:ca:45:52:
        ce:16:ef:3f:06:64:e7:94:68:7c:60:33:15:11:69:af:9d:62:
        8d:a3:03:54:6b:a6:be:e5:ee:05:18:60:04:bf:42:80:fd:d0:
        a8:a8:1e:01:3b:f7:a3:5c:af:a3:dc:e6:26:80:23:3c:b8:44:
        74:f7:0a:ae:49:8b:61:78:cc:24:bf:88:8a:a7:0e:ea:73:19:
        41:fd:4d:03:f0:88:d1:e5:78:8d:a5:2a:4f:f6:97:0d:17:77:
        ca:d8', 'B65A8BA30D6A2383806BCF3987F4211333064C25A2ED551297C5A780B9FA83C120A0FA2F150D7CA1606B7E792CFA060F3AAEF61B6FB1D2FF2F28525F837D4BC47AB7F8661F8054FCB7C28E594A145746D19A93BE419103BB1580935CEBE7CC086C3F3EB34AFCFF4B6C23D550822644198E23C371EA192447049E75BFC8A6001F', '/C=US/O=VeriSign, Inc./OU=Class 2 Public Primary Certification Authority', 'C=US/O=VeriSign, Inc./OU=Class 2 Public Primary Certification Authority', '2D1BFC4A178DA391EBE7FFF58B45BE0B', NULL, '-----BEGIN CERTIFICATE-----
MIICPDCCAaUCEC0b/EoXjaOR6+f/9YtFvgswDQYJKoZIhvcNAQECBQAwXzELMAkG
A1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz
cyAyIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2
MDEyOTAwMDAwMFoXDTI4MDgwMTIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNV
BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAyIFB1YmxpYyBQcmlt
YXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GN
ADCBiQKBgQC2WoujDWojg4BrzzmH9CETMwZMJaLtVRKXxaeAufqDwSCg+i8VDXyh
YGt+eSz6Bg86rvYbb7HS/y8oUl+DfUvEerf4Zh+AVPy3wo5ZShRXRtGak75BkQO7
FYCTXOvnzAhsPz6zSvz/S2wj1VCCJkQZjiPDceoZJEcEnnW/yKYAHwIDAQABMA0G
CSqGSIb3DQEBAgUAA4GBAIobK/o5wXTXXtgZZKJYSi034DNHD6zt96rbHuSLBlxg
J8pFUs4W7z8GZOeUaHxgMxURaa+dYo2jA1Rrpr7l7gUYYAS/QoD90KioHgE796Nc
r6Pc5iaAIzy4RHT3Cq5Ji2F4zCS/iIqnDupzGUH9TQPwiNHleI2lKk/2lw0Xd8rY
-----END CERTIFICATE-----', '28f98a3e51849b4da8d3f5238516b71c');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc.', 3, 1, 0, '1998-05-18 00:00:00', '2028-08-01 23:59:59', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            32:88:8e:9a:d2:f5:eb:13:47:f8:7f:c4:20:37:25:f8
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 4 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Validity
            Not Before: May 18 00:00:00 1998 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 4 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ba:f0:e4:cf:f9:c4:ae:85:54:b9:07:57:f9:8f:
                    c5:7f:68:11:f8:c4:17:b0:44:dc:e3:30:73:d5:2a:
                    62:2a:b8:d0:cc:1c:ed:28:5b:7e:bd:6a:dc:b3:91:
                    24:ca:41:62:3c:fc:02:01:bf:1c:16:31:94:05:97:
                    76:6e:a2:ad:bd:61:17:6c:4e:30:86:f0:51:37:2a:
                    50:c7:a8:62:81:dc:5b:4a:aa:c1:a0:b4:6e:eb:2f:
                    e5:57:c5:b1:2b:40:70:db:5a:4d:a1:8e:1f:bd:03:
                    1f:d8:03:d4:8f:4c:99:71:bc:e2:82:cc:58:e8:98:
                    3a:86:d3:86:38:f3:00:29:1f
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        85:8c:12:c1:a7:b9:50:15:7a:cb:3e:ac:b8:43:8a:dc:aa:dd:
        14:ba:89:81:7e:01:3c:23:71:21:88:2f:82:dc:63:fa:02:45:
        ac:45:59:d7:2a:58:44:5b:b7:9f:81:3b:92:68:3d:e2:37:24:
        f5:7b:6c:8f:76:35:96:09:a8:59:9d:b9:ce:23:ab:74:d6:83:
        fd:32:73:27:d8:69:3e:43:74:f6:ae:c5:89:9a:e7:53:7c:e9:
        7b:f6:4b:f3:c1:65:83:de:8d:8a:9c:3c:88:8d:39:59:fc:aa:
        3f:22:8d:a1:c1:66:50:81:72:4c:ed:22:64:4f:4f:ca:80:91:
        b6:29', 'BAF0E4CFF9C4AE8554B90757F98FC57F6811F8C417B044DCE33073D52A622AB8D0CC1CED285B7EBD6ADCB39124CA41623CFC0201BF1C1631940597766EA2ADBD61176C4E3086F051372A50C7A86281DC5B4AAAC1A0B46EEB2FE557C5B12B4070DB5A4DA18E1FBD031FD803D48F4C9971BCE282CC58E8983A86D38638F300291F', '/C=US/O=VeriSign, Inc./OU=Class 4 Public Primary Certification Authority - G2/OU=(c) 1998 VeriSign, Inc. - For authorized use only/OU=VeriSign Trust Network', 'C=US/O=VeriSign, Inc./OU=Class 4 Public Primary Certification Authority - G2/OU=(c) 1998 VeriSign, Inc. - For authorized use only/OU=VeriSign Trust Network', '32888E9AD2F5EB1347F87FC4203725F8', NULL, '-----BEGIN CERTIFICATE-----
MIIDAjCCAmsCEDKIjprS9esTR/h/xCA3JfgwDQYJKoZIhvcNAQEFBQAwgcExCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xh
c3MgNCBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcy
MTowOAYDVQQLEzEoYykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3Jp
emVkIHVzZSBvbmx5MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMB4X
DTk4MDUxODAwMDAwMFoXDTI4MDgwMTIzNTk1OVowgcExCzAJBgNVBAYTAlVTMRcw
FQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xhc3MgNCBQdWJsaWMg
UHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcyMTowOAYDVQQLEzEo
YykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMIGfMA0GCSqGSIb3DQEB
AQUAA4GNADCBiQKBgQC68OTP+cSuhVS5B1f5j8V/aBH4xBewRNzjMHPVKmIquNDM
HO0oW369atyzkSTKQWI8/AIBvxwWMZQFl3Zuoq29YRdsTjCG8FE3KlDHqGKB3FtK
qsGgtG7rL+VXxbErQHDbWk2hjh+9Ax/YA9SPTJlxvOKCzFjomDqG04Y48wApHwID
AQABMA0GCSqGSIb3DQEBBQUAA4GBAIWMEsGnuVAVess+rLhDityq3RS6iYF+ATwj
cSGIL4LcY/oCRaxFWdcqWERbt5+BO5JoPeI3JPV7bI92NZYJqFmduc4jq3TWg/0y
cyfYaT5DdPauxYma51N86Xv2S/PBZYPejYqcPIiNOVn8qj8ijaHBZlCBckztImRP
T8qAkbYp
-----END CERTIFICATE-----', 'b3ab24952bb020a447242dfa3f1bd059');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc.', 3, 1, 0, '1996-01-29 00:00:00', '2028-08-01 23:59:59', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            cd:ba:7f:56:f0:df:e4:bc:54:fe:22:ac:b3:72:aa:55
        Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:e5:19:bf:6d:a3:56:61:2d:99:48:71:f6:67:de:
                    b9:8d:eb:b7:9e:86:80:0a:91:0e:fa:38:25:af:46:
                    88:82:e5:73:a8:a0:9b:24:5d:0d:1f:cc:65:6e:0c:
                    b0:d0:56:84:18:87:9a:06:9b:10:a1:73:df:b4:58:
                    39:6b:6e:c1:f6:15:d5:a8:a8:3f:aa:12:06:8d:31:
                    ac:7f:b0:34:d7:8f:34:67:88:09:cd:14:11:e2:4e:
                    45:56:69:1f:78:02:80:da:dc:47:91:29:bb:36:c9:
                    63:5c:c5:e0:d7:2d:87:7b:a1:b7:32:b0:7b:30:ba:
                    2a:2f:31:aa:ee:a3:67:da:db
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
        4c:3f:b8:8b:c6:68:df:ee:43:33:0e:5d:e9:a6:cb:07:84:4d:
        7a:33:ff:92:1b:f4:36:ad:d8:95:22:36:68:11:6c:7c:42:cc:
        f3:9c:2e:c4:07:3f:14:b0:0f:4f:ff:90:92:76:f9:e2:bc:4a:
        e9:8f:cd:a0:80:0a:f7:c5:29:f1:82:22:5d:b8:b1:dd:81:23:
        a3:7b:25:15:46:30:79:16:f8:ea:05:4b:94:7f:1d:c2:1c:c8:
        e3:b7:f4:10:40:3c:13:c3:5f:1f:53:e8:48:e4:86:b4:7b:a1:
        35:b0:7b:25:ba:b8:d3:8e:ab:3f:38:9d:00:34:00:98:f3:d1:
        71:94', 'E519BF6DA356612D994871F667DEB98DEBB79E86800A910EFA3825AF468882E573A8A09B245D0D1FCC656E0CB0D0568418879A069B10A173DFB458396B6EC1F615D5A8A83FAA12068D31AC7FB034D78F34678809CD1411E24E4556691F780280DADC479129BB36C9635CC5E0D72D877BA1B732B07B30BA2A2F31AAEEA367DADB', '/C=US/O=VeriSign, Inc./OU=Class 1 Public Primary Certification Authority', 'C=US/O=VeriSign, Inc./OU=Class 1 Public Primary Certification Authority', 'CDBA7F56F0DFE4BC54FE22ACB372AA55', NULL, '-----BEGIN CERTIFICATE-----
MIICPTCCAaYCEQDNun9W8N/kvFT+IqyzcqpVMA0GCSqGSIb3DQEBAgUAMF8xCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xh
c3MgMSBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05
NjAxMjkwMDAwMDBaFw0yODA4MDEyMzU5NTlaMF8xCzAJBgNVBAYTAlVTMRcwFQYD
VQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMSBQdWJsaWMgUHJp
bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCBnzANBgkqhkiG9w0BAQEFAAOB
jQAwgYkCgYEA5Rm/baNWYS2ZSHH2Z965jeu3noaACpEO+jglr0aIguVzqKCbJF0N
H8xlbgyw0FaEGIeaBpsQoXPftFg5a27B9hXVqKg/qhIGjTGsf7A01480Z4gJzRQR
4k5FVmkfeAKA2txHkSm7NsljXMXg1y2He6G3MrB7MLoqLzGq7qNn2tsCAwEAATAN
BgkqhkiG9w0BAQIFAAOBgQBMP7iLxmjf7kMzDl3ppssHhE16M/+SG/Q2rdiVIjZo
EWx8QszznC7EBz8UsA9P/5CSdvnivErpj82ggAr3xSnxgiJduLHdgSOjeyUVRjB5
FvjqBUuUfx3CHMjjt/QQQDwTw18fU+hI5Ia0e6E1sHslurjTjqs/OJ0ANACY89Fx
lA==
-----END CERTIFICATE-----', '637798b55707f7c52a6b546b2b31927e');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc.', 3, 1, 0, '1998-05-18 00:00:00', '2028-08-01 23:59:59', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            7d:d9:fe:07:cf:a8:1e:b7:10:79:67:fb:a7:89:34:c6
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Validity
            Not Before: May 18 00:00:00 1998 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:cc:5e:d1:11:5d:5c:69:d0:ab:d3:b9:6a:4c:99:
                    1f:59:98:30:8e:16:85:20:46:6d:47:3f:d4:85:20:
                    84:e1:6d:b3:f8:a4:ed:0c:f1:17:0f:3b:f9:a7:f9:
                    25:d7:c1:cf:84:63:f2:7c:63:cf:a2:47:f2:c6:5b:
                    33:8e:64:40:04:68:c1:80:b9:64:1c:45:77:c7:d8:
                    6e:f5:95:29:3c:50:e8:34:d7:78:1f:a8:ba:6d:43:
                    91:95:8f:45:57:5e:7e:c5:fb:ca:a4:04:eb:ea:97:
                    37:54:30:6f:bb:01:47:32:33:cd:dc:57:9b:64:69:
                    61:f8:9b:1d:1c:89:4f:5c:67
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        51:4d:cd:be:5c:cb:98:19:9c:15:b2:01:39:78:2e:4d:0f:67:
        70:70:99:c6:10:5a:94:a4:53:4d:54:6d:2b:af:0d:5d:40:8b:
        64:d3:d7:ee:de:56:61:92:5f:a6:c4:1d:10:61:36:d3:2c:27:
        3c:e8:29:09:b9:11:64:74:cc:b5:73:9f:1c:48:a9:bc:61:01:
        ee:e2:17:a6:0c:e3:40:08:3b:0e:e7:eb:44:73:2a:9a:f1:69:
        92:ef:71:14:c3:39:ac:71:a7:91:09:6f:e4:71:06:b3:ba:59:
        57:26:79:00:f6:f8:0d:a2:33:30:28:d4:aa:58:a0:9d:9d:69:
        91:fd', 'CC5ED1115D5C69D0ABD3B96A4C991F5998308E168520466D473FD4852084E16DB3F8A4ED0CF1170F3BF9A7F925D7C1CF8463F27C63CFA247F2C65B338E64400468C180B9641C4577C7D86EF595293C50E834D7781FA8BA6D4391958F45575E7EC5FBCAA404EBEA973754306FBB01473233CDDC579B646961F89B1D1C894F5C67', '/C=US/O=VeriSign, Inc./OU=Class 3 Public Primary Certification Authority - G2/OU=(c) 1998 VeriSign, Inc. - For authorized use only/OU=VeriSign Trust Network', 'C=US/O=VeriSign, Inc./OU=Class 3 Public Primary Certification Authority - G2/OU=(c) 1998 VeriSign, Inc. - For authorized use only/OU=VeriSign Trust Network', '7DD9FE07CFA81EB7107967FBA78934C6', NULL, '-----BEGIN CERTIFICATE-----
MIIDAjCCAmsCEH3Z/gfPqB63EHln+6eJNMYwDQYJKoZIhvcNAQEFBQAwgcExCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xh
c3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcy
MTowOAYDVQQLEzEoYykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3Jp
emVkIHVzZSBvbmx5MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMB4X
DTk4MDUxODAwMDAwMFoXDTI4MDgwMTIzNTk1OVowgcExCzAJBgNVBAYTAlVTMRcw
FQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xhc3MgMyBQdWJsaWMg
UHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcyMTowOAYDVQQLEzEo
YykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMIGfMA0GCSqGSIb3DQEB
AQUAA4GNADCBiQKBgQDMXtERXVxp0KvTuWpMmR9ZmDCOFoUgRm1HP9SFIIThbbP4
pO0M8RcPO/mn+SXXwc+EY/J8Y8+iR/LGWzOOZEAEaMGAuWQcRXfH2G71lSk8UOg0
13gfqLptQ5GVj0VXXn7F+8qkBOvqlzdUMG+7AUcyM83cV5tkaWH4mx0ciU9cZwID
AQABMA0GCSqGSIb3DQEBBQUAA4GBAFFNzb5cy5gZnBWyATl4Lk0PZ3BwmcYQWpSk
U01UbSuvDV1Ai2TT1+7eVmGSX6bEHRBhNtMsJzzoKQm5EWR0zLVznxxIqbxhAe7i
F6YM40AIOw7n60RzKprxaZLvcRTDOaxxp5EJb+RxBrO6WVcmeQD2+A2iMzAo1KpY
oJ2daZH9
-----END CERTIFICATE-----', '77803d7de91902c213cf348c3a41ace8');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc.', 3, 1, 0, '1998-05-18 00:00:00', '2028-08-01 23:59:59', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            4c:c7:ea:aa:98:3e:71:d3:93:10:f8:3d:3a:89:91:92
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Validity
            Not Before: May 18 00:00:00 1998 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use only, OU=VeriSign Trust Network
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:aa:d0:ba:be:16:2d:b8:83:d4:ca:d2:0f:bc:76:
                    31:ca:94:d8:1d:93:8c:56:02:bc:d9:6f:1a:6f:52:
                    36:6e:75:56:0a:55:d3:df:43:87:21:11:65:8a:7e:
                    8f:bd:21:de:6b:32:3f:1b:84:34:95:05:9d:41:35:
                    eb:92:eb:96:dd:aa:59:3f:01:53:6d:99:4f:ed:e5:
                    e2:2a:5a:90:c1:b9:c4:a6:15:cf:c8:45:eb:a6:5d:
                    8e:9c:3e:f0:64:24:76:a5:cd:ab:1a:6f:b6:d8:7b:
                    51:61:6e:a6:7f:87:c8:e2:b7:e5:34:dc:41:88:ea:
                    09:40:be:73:92:3d:6b:e7:75
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        a9:4f:c3:0d:c7:67:be:2c:cb:d9:a8:cd:2d:75:e7:7e:15:9e:
        3b:72:eb:7e:eb:5c:2d:09:87:d6:6b:6d:60:7c:e5:ae:c5:90:
        23:0c:5c:4a:d0:af:b1:5d:f3:c7:b6:0a:db:e0:15:93:0d:dd:
        03:bc:c7:76:8a:b5:dd:4f:c3:9b:13:75:b8:01:c0:e6:c9:5b:
        6b:a5:b8:89:dc:ac:a4:dd:72:ed:4e:a1:f7:4f:bc:06:d3:ea:
        c8:64:74:7b:c2:95:41:9c:65:73:58:f1:90:9a:3c:6a:b1:98:
        c9:c4:87:bc:cf:45:6d:45:e2:6e:22:3f:fe:bc:0f:31:5c:e8:
        f2:d9', 'AAD0BABE162DB883D4CAD20FBC7631CA94D81D938C5602BCD96F1A6F52366E75560A55D3DF43872111658A7E8FBD21DE6B323F1B843495059D4135EB92EB96DDAA593F01536D994FEDE5E22A5A90C1B9C4A615CFC845EBA65D8E9C3EF0642476A5CDAB1A6FB6D87B51616EA67F87C8E2B7E534DC4188EA0940BE73923D6BE775', '/C=US/O=VeriSign, Inc./OU=Class 1 Public Primary Certification Authority - G2/OU=(c) 1998 VeriSign, Inc. - For authorized use only/OU=VeriSign Trust Network', 'C=US/O=VeriSign, Inc./OU=Class 1 Public Primary Certification Authority - G2/OU=(c) 1998 VeriSign, Inc. - For authorized use only/OU=VeriSign Trust Network', '4CC7EAAA983E71D39310F83D3A899192', NULL, '-----BEGIN CERTIFICATE-----
MIIDAjCCAmsCEEzH6qqYPnHTkxD4PTqJkZIwDQYJKoZIhvcNAQEFBQAwgcExCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xh
c3MgMSBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcy
MTowOAYDVQQLEzEoYykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3Jp
emVkIHVzZSBvbmx5MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMB4X
DTk4MDUxODAwMDAwMFoXDTI4MDgwMTIzNTk1OVowgcExCzAJBgNVBAYTAlVTMRcw
FQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE8MDoGA1UECxMzQ2xhc3MgMSBQdWJsaWMg
UHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEcyMTowOAYDVQQLEzEo
YykgMTk5OCBWZXJpU2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5
MR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMIGfMA0GCSqGSIb3DQEB
AQUAA4GNADCBiQKBgQCq0Lq+Fi24g9TK0g+8djHKlNgdk4xWArzZbxpvUjZudVYK
VdPfQ4chEWWKfo+9Id5rMj8bhDSVBZ1BNeuS65bdqlk/AVNtmU/t5eIqWpDBucSm
Fc/IReumXY6cPvBkJHalzasab7bYe1FhbqZ/h8jit+U03EGI6glAvnOSPWvndQID
AQABMA0GCSqGSIb3DQEBBQUAA4GBAKlPww3HZ74sy9mozS11534Vnjty637rXC0J
h9ZrbWB85a7FkCMMXErQr7Fd88e2CtvgFZMN3QO8x3aKtd1Pw5sTdbgBwObJW2ul
uIncrKTdcu1OofdPvAbT6shkdHvClUGcZXNY8ZCaPGqxmMnEh7zPRW1F4m4iP/68
DzFc6PLZ
-----END CERTIFICATE-----', '3c27012371ea65ee5e9b1dad2fea684a');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc.', 3, 1, 0, '1996-01-29 00:00:00', '2028-08-02 23:59:59', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            3c:91:31:cb:1f:f6:d0:1b:0e:9a:b8:d0:44:bf:12:be
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Aug  2 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c9:5c:59:9e:f2:1b:8a:01:14:b4:10:df:04:40:
                    db:e3:57:af:6a:45:40:8f:84:0c:0b:d1:33:d9:d9:
                    11:cf:ee:02:58:1f:25:f7:2a:a8:44:05:aa:ec:03:
                    1f:78:7f:9e:93:b9:9a:00:aa:23:7d:d6:ac:85:a2:
                    63:45:c7:72:27:cc:f4:4c:c6:75:71:d2:39:ef:4f:
                    42:f0:75:df:0a:90:c6:8e:20:6f:98:0f:f8:ac:23:
                    5f:70:29:36:a4:c9:86:e7:b1:9a:20:cb:53:a5:85:
                    e7:3d:be:7d:9a:fe:24:45:33:dc:76:15:ed:0f:a2:
                    71:64:4c:65:2e:81:68:45:a7
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        10:72:52:a9:05:14:19:32:08:41:f0:c5:6b:0a:cc:7e:0f:21:
        19:cd:e4:67:dc:5f:a9:1b:e6:ca:e8:73:9d:22:d8:98:6e:73:
        03:61:91:c5:7c:b0:45:40:6e:44:9d:8d:b0:b1:96:74:61:2d:
        0d:a9:45:d2:a4:92:2a:d6:9a:75:97:6e:3f:53:fd:45:99:60:
        1d:a8:2b:4c:f9:5e:a7:09:d8:75:30:d7:d2:65:60:3d:67:d6:
        48:55:75:69:3f:91:f5:48:0b:47:69:22:69:82:96:be:c9:c8:
        38:86:4a:7a:2c:73:19:48:69:4e:6b:7c:65:bf:0f:fc:70:ce:
        88:90', 'C95C599EF21B8A0114B410DF0440DBE357AF6A45408F840C0BD133D9D911CFEE02581F25F72AA84405AAEC031F787F9E93B99A00AA237DD6AC85A26345C77227CCF44CC67571D239EF4F42F075DF0A90C68E206F980FF8AC235F702936A4C986E7B19A20CB53A585E73DBE7D9AFE244533DC7615ED0FA271644C652E816845A7', '/C=US/O=VeriSign, Inc./OU=Class 3 Public Primary Certification Authority', 'C=US/O=VeriSign, Inc./OU=Class 3 Public Primary Certification Authority', '3C9131CB1FF6D01B0E9AB8D044BF12BE', NULL, '-----BEGIN CERTIFICATE-----
MIICPDCCAaUCEDyRMcsf9tAbDpq40ES/Er4wDQYJKoZIhvcNAQEFBQAwXzELMAkG
A1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz
cyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2
MDEyOTAwMDAwMFoXDTI4MDgwMjIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNV
BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmlt
YXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GN
ADCBiQKBgQDJXFme8huKARS0EN8EQNvjV69qRUCPhAwL0TPZ2RHP7gJYHyX3KqhE
BarsAx94f56TuZoAqiN91qyFomNFx3InzPRMxnVx0jnvT0Lwdd8KkMaOIG+YD/is
I19wKTakyYbnsZogy1Olhec9vn2a/iRFM9x2Fe0PonFkTGUugWhFpwIDAQABMA0G
CSqGSIb3DQEBBQUAA4GBABByUqkFFBkyCEHwxWsKzH4PIRnN5GfcX6kb5sroc50i
2JhucwNhkcV8sEVAbkSdjbCxlnRhLQ2pRdKkkirWmnWXbj9T/UWZYB2oK0z5XqcJ
2HUw19JlYD1n1khVdWk/kfVIC0dpImmClr7JyDiGSnoscxlIaU5rfGW/D/xwzoiQ
-----END CERTIFICATE-----', 'b52dc1df5233371ed264e38efae830fe');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc., CN=VeriSign Class 1 Public Primary Certification Authority - G3', 3, 1, 0, '1999-10-01 00:00:00', '2036-07-16 23:59:59', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            8b:5b:75:56:84:54:85:0b:00:cf:af:38:48:ce:b1:a4
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 1 Public Primary Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 1 Public Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:dd:84:d4:b9:b4:f9:a7:d8:f3:04:78:9c:de:3d:
                    dc:6c:13:16:d9:7a:dd:24:51:66:c0:c7:26:59:0d:
                    ac:06:08:c2:94:d1:33:1f:f0:83:35:1f:6e:1b:c8:
                    de:aa:6e:15:4e:54:27:ef:c4:6d:1a:ec:0b:e3:0e:
                    f0:44:a5:57:c7:40:58:1e:a3:47:1f:71:ec:60:f6:
                    6d:94:c8:18:39:ed:fe:42:18:56:df:e4:4c:49:10:
                    78:4e:01:76:35:63:12:36:dd:66:bc:01:04:36:a3:
                    55:68:d5:a2:36:09:ac:ab:21:26:54:06:ad:3f:ca:
                    14:e0:ac:ca:ad:06:1d:95:e2:f8:9d:f1:e0:60:ff:
                    c2:7f:75:2b:4c:cc:da:fe:87:99:21:ea:ba:fe:3e:
                    54:d7:d2:59:78:db:3c:6e:cf:a0:13:00:1a:b8:27:
                    a1:e4:be:67:96:ca:a0:c5:b3:9c:dd:c9:75:9e:eb:
                    30:9a:5f:a3:cd:d9:ae:78:19:3f:23:e9:5c:db:29:
                    bd:ad:55:c8:1b:54:8c:63:f6:e8:a6:ea:c7:37:12:
                    5c:a3:29:1e:02:d9:db:1f:3b:b4:d7:0f:56:47:81:
                    15:04:4a:af:83:27:d1:c5:58:88:c1:dd:f6:aa:a7:
                    a3:18:da:68:aa:6d:11:51:e1:bf:65:6b:9f:96:76:
                    d1:3d
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        ab:66:8d:d7:b3:ba:c7:9a:b6:e6:55:d0:05:f1:9f:31:8d:5a:
        aa:d9:aa:46:26:0f:71:ed:a5:ad:53:56:62:01:47:2a:44:e9:
        fe:3f:74:0b:13:9b:b9:f4:4d:1b:b2:d1:5f:b2:b6:d2:88:5c:
        b3:9f:cd:cb:d4:a7:d9:60:95:84:3a:f8:c1:37:1d:61:ca:e7:
        b0:c5:e5:91:da:54:a6:ac:31:81:ae:97:de:cd:08:ac:b8:c0:
        97:80:7f:6e:72:a4:e7:69:13:95:65:1f:c4:93:3c:fd:79:8f:
        04:d4:3e:4f:ea:f7:9e:ce:cd:67:7c:4f:65:02:ff:91:85:54:
        73:c7:ff:36:f7:86:2d:ec:d0:5e:4f:ff:11:9f:72:06:d6:b8:
        1a:f1:4c:0d:26:65:e2:44:80:1e:c7:9f:e3:dd:e8:0a:da:ec:
        a5:20:80:69:68:a1:4f:7e:e1:6b:cf:07:41:fa:83:8e:bc:38:
        dd:b0:2e:11:b1:6b:b2:42:cc:9a:bc:f9:48:22:79:4a:19:0f:
        b2:1c:3e:20:74:d9:6a:c3:be:f2:28:78:13:56:79:4f:6d:50:
        ea:1b:b0:b5:57:b1:37:66:58:23:f3:dc:0f:df:0a:87:c4:ef:
        86:05:d5:38:14:60:99:a3:4b:de:06:96:71:2c:f2:db:b6:1f:
        a4:ef:3f:ee', 'DD84D4B9B4F9A7D8F304789CDE3DDC6C1316D97ADD245166C0C726590DAC0608C294D1331FF083351F6E1BC8DEAA6E154E5427EFC46D1AEC0BE30EF044A557C740581EA3471F71EC60F66D94C81839EDFE421856DFE44C4910784E017635631236DD66BC010436A35568D5A23609ACAB21265406AD3FCA14E0ACCAAD061D95E2F89DF1E060FFC27F752B4CCCDAFE879921EABAFE3E54D7D25978DB3C6ECFA013001AB827A1E4BE6796CAA0C5B39CDDC9759EEB309A5FA3CDD9AE78193F23E95CDB29BDAD55C81B548C63F6E8A6EAC737125CA3291E02D9DB1F3BB4D70F56478115044AAF8327D1C55888C1DDF6AAA7A318DA68AA6D1151E1BF656B9F9676D13D', '/C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 1 Public Primary Certification Authority - G3', 'C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 1 Public Primary Certification Authority - G3', '8B5B75568454850B00CFAF3848CEB1A4', NULL, '-----BEGIN CERTIFICATE-----
MIIEGjCCAwICEQCLW3VWhFSFCwDPrzhIzrGkMA0GCSqGSIb3DQEBBQUAMIHKMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
cmlTaWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWdu
LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlT
aWduIENsYXNzIDEgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
dHkgLSBHMzAeFw05OTEwMDEwMDAwMDBaFw0zNjA3MTYyMzU5NTlaMIHKMQswCQYD
VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
aWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWduLCBJ
bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlTaWdu
IENsYXNzIDEgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkg
LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAN2E1Lm0+afY8wR4
nN493GwTFtl63SRRZsDHJlkNrAYIwpTRMx/wgzUfbhvI3qpuFU5UJ+/EbRrsC+MO
8ESlV8dAWB6jRx9x7GD2bZTIGDnt/kIYVt/kTEkQeE4BdjVjEjbdZrwBBDajVWjV
ojYJrKshJlQGrT/KFOCsyq0GHZXi+J3x4GD/wn91K0zM2v6HmSHquv4+VNfSWXjb
PG7PoBMAGrgnoeS+Z5bKoMWznN3JdZ7rMJpfo83ZrngZPyPpXNspva1VyBtUjGP2
6KbqxzcSXKMpHgLZ2x87tNcPVkeBFQRKr4Mn0cVYiMHd9qqnoxjaaKptEVHhv2Vr
n5Z20T0CAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAq2aN17O6x5q25lXQBfGfMY1a
qtmqRiYPce2lrVNWYgFHKkTp/j90CxObufRNG7LRX7K20ohcs5/Ny9Sn2WCVhDr4
wTcdYcrnsMXlkdpUpqwxga6X3s0IrLjAl4B/bnKk52kTlWUfxJM8/XmPBNQ+T+r3
ns7NZ3xPZQL/kYVUc8f/NveGLezQXk//EZ9yBta4GvFMDSZl4kSAHsef493oCtrs
pSCAaWihT37ha88HQfqDjrw43bAuEbFrskLMmrz5SCJ5ShkPshw+IHTZasO+8ih4
E1Z5T21Q6huwtVexN2ZYI/PcD98Kh8TvhgXVOBRgmaNL3gaWcSzy27YfpO8/7g==
-----END CERTIFICATE-----', 'd90b7cbf0b9bb7e9ba7fa0f3fe72f499');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc., CN=VeriSign Class 2 Public Primary Certification Authority - G3', 3, 1, 0, '1999-10-01 00:00:00', '2036-07-16 23:59:59', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            61:70:cb:49:8c:5f:98:45:29:e7:b0:a6:d9:50:5b:7a
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 2 Public Primary Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 2 Public Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:af:0a:0d:c2:d5:2c:db:67:b9:2d:e5:94:27:dd:
                    a5:be:e0:b0:4d:8f:b3:61:56:3c:d6:7c:c3:f4:cd:
                    3e:86:cb:a2:88:e2:e1:d8:a4:69:c5:b5:e2:bf:c1:
                    a6:47:50:5e:46:39:8b:d5:96:ba:b5:6f:14:bf:10:
                    ce:27:13:9e:05:47:9b:31:7a:13:d8:1f:d9:d3:02:
                    37:8b:ad:2c:47:f0:8e:81:06:a7:0d:30:0c:eb:f7:
                    3c:0f:20:1d:dc:72:46:ee:a5:02:c8:5b:c3:c9:56:
                    69:4c:c5:18:c1:91:7b:0b:d5:13:00:9b:bc:ef:c3:
                    48:3e:46:60:20:85:2a:d5:90:b6:cd:8b:a0:cc:32:
                    dd:b7:fd:40:55:b2:50:1c:56:ae:cc:8d:77:4d:c7:
                    20:4d:a7:31:76:ef:68:92:8a:90:1e:08:81:56:b2:
                    ad:69:a3:52:d0:cb:1c:c4:23:3d:1f:99:fe:4c:e8:
                    16:63:8e:c6:08:8e:f6:31:f6:d2:fa:e5:76:dd:b5:
                    1c:92:a3:49:cd:cd:01:cd:68:cd:a9:69:ba:a3:eb:
                    1d:0d:9c:a4:20:a6:c1:a0:c5:d1:46:4c:17:6d:d2:
                    ac:66:3f:96:8c:e0:84:d4:36:ff:22:59:c5:f9:11:
                    60:a8:5f:04:7d:f2:1a:f6:25:42:61:0f:c4:4a:b8:
                    3e:89
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        34:26:15:3c:c0:8d:4d:43:49:1d:bd:e9:21:92:d7:66:9c:b7:
        de:c5:b8:d0:e4:5d:5f:76:22:c0:26:f9:84:3a:3a:f9:8c:b5:
        fb:ec:60:f1:e8:ce:04:b0:c8:dd:a7:03:8f:30:f3:98:df:a4:
        e6:a4:31:df:d3:1c:0b:46:dc:72:20:3f:ae:ee:05:3c:a4:33:
        3f:0b:39:ac:70:78:73:4b:99:2b:df:30:c2:54:b0:a8:3b:55:
        a1:fe:16:28:cd:42:bd:74:6e:80:db:27:44:a7:ce:44:5d:d4:
        1b:90:98:0d:1e:42:94:b1:00:2c:04:d0:74:a3:02:05:22:63:
        63:cd:83:b5:fb:c1:6d:62:6b:69:75:fd:5d:70:41:b9:f5:bf:
        7c:df:be:c1:32:73:22:21:8b:58:81:7b:15:91:7a:ba:e3:64:
        48:b0:7f:fb:36:25:da:95:d0:f1:24:14:17:dd:18:80:6b:46:
        23:39:54:f5:8e:62:09:04:1d:94:90:a6:9b:e6:25:e2:42:45:
        aa:b8:90:ad:be:08:8f:a9:0b:42:18:94:cf:72:39:e1:b1:43:
        e0:28:cf:b7:e7:5a:6c:13:6b:49:b3:ff:e3:18:7c:89:8b:33:
        5d:ac:33:d7:a7:f9:da:3a:55:c9:58:10:f9:aa:ef:5a:b6:cf:
        4b:4b:df:2a', 'AF0A0DC2D52CDB67B92DE59427DDA5BEE0B04D8FB361563CD67CC3F4CD3E86CBA288E2E1D8A469C5B5E2BFC1A647505E46398BD596BAB56F14BF10CE27139E05479B317A13D81FD9D302378BAD2C47F08E8106A70D300CEBF73C0F201DDC7246EEA502C85BC3C956694CC518C1917B0BD513009BBCEFC3483E466020852AD590B6CD8BA0CC32DDB7FD4055B2501C56AECC8D774DC7204DA73176EF68928A901E088156B2AD69A352D0CB1CC4233D1F99FE4CE816638EC6088EF631F6D2FAE576DDB51C92A349CDCD01CD68CDA969BAA3EB1D0D9CA420A6C1A0C5D1464C176DD2AC663F968CE084D436FF2259C5F91160A85F047DF21AF62542610FC44AB83E89', '/C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 2 Public Primary Certification Authority - G3', 'C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 2 Public Primary Certification Authority - G3', '6170CB498C5F984529E7B0A6D9505B7A', NULL, '-----BEGIN CERTIFICATE-----
MIIEGTCCAwECEGFwy0mMX5hFKeewptlQW3owDQYJKoZIhvcNAQEFBQAwgcoxCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVy
aVNpZ24gVHJ1c3QgTmV0d29yazE6MDgGA1UECxMxKGMpIDE5OTkgVmVyaVNpZ24s
IEluYy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVyaVNp
Z24gQ2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0
eSAtIEczMB4XDTk5MTAwMTAwMDAwMFoXDTM2MDcxNjIzNTk1OVowgcoxCzAJBgNV
BAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
Z24gVHJ1c3QgTmV0d29yazE6MDgGA1UECxMxKGMpIDE5OTkgVmVyaVNpZ24sIElu
Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVyaVNpZ24g
Q2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAt
IEczMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArwoNwtUs22e5LeWU
J92lvuCwTY+zYVY81nzD9M0+hsuiiOLh2KRpxbXiv8GmR1BeRjmL1Za6tW8UvxDO
JxOeBUebMXoT2B/Z0wI3i60sR/COgQanDTAM6/c8DyAd3HJG7qUCyFvDyVZpTMUY
wZF7C9UTAJu878NIPkZgIIUq1ZC2zYugzDLdt/1AVbJQHFauzI13TccgTacxdu9o
koqQHgiBVrKtaaNS0MscxCM9H5n+TOgWY47GCI72MfbS+uV23bUckqNJzc0BzWjN
qWm6o+sdDZykIKbBoMXRRkwXbdKsZj+WjOCE1Db/IlnF+RFgqF8EffIa9iVCYQ/E
Srg+iQIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQA0JhU8wI1NQ0kdvekhktdmnLfe
xbjQ5F1fdiLAJvmEOjr5jLX77GDx6M4EsMjdpwOPMPOY36TmpDHf0xwLRtxyID+u
7gU8pDM/CzmscHhzS5kr3zDCVLCoO1Wh/hYozUK9dG6A2ydEp85EXdQbkJgNHkKU
sQAsBNB0owIFImNjzYO1+8FtYmtpdf1dcEG59b98377BMnMiIYtYgXsVkXq642RI
sH/7NiXaldDxJBQX3RiAa0YjOVT1jmIJBB2UkKab5iXiQkWquJCtvgiPqQtCGJTP
cjnhsUPgKM+351psE2tJs//jGHyJizNdrDPXp/naOlXJWBD5qu9ats9LS98q
-----END CERTIFICATE-----', 'f44eac80f725f84df11c10e4ba901dcd');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc., CN=VeriSign Class 3 Public Primary Certification Authority - G3', 3, 1, 0, '1999-10-01 00:00:00', '2036-07-16 23:59:59', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            9b:7e:06:49:a3:3e:62:b9:d5:ee:90:48:71:29:ef:57
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 3 Public Primary Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 3 Public Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:cb:ba:9c:52:fc:78:1f:1a:1e:6f:1b:37:73:bd:
                    f8:c9:6b:94:12:30:4f:f0:36:47:f5:d0:91:0a:f5:
                    17:c8:a5:61:c1:16:40:4d:fb:8a:61:90:e5:76:20:
                    c1:11:06:7d:ab:2c:6e:a6:f5:11:41:8e:fa:2d:ad:
                    2a:61:59:a4:67:26:4c:d0:e8:bc:52:5b:70:20:04:
                    58:d1:7a:c9:a4:69:bc:83:17:64:ad:05:8b:bc:d0:
                    58:ce:8d:8c:f5:eb:f0:42:49:0b:9d:97:27:67:32:
                    6e:e1:ae:93:15:1c:70:bc:20:4d:2f:18:de:92:88:
                    e8:6c:85:57:11:1a:e9:7e:e3:26:11:54:a2:45:96:
                    55:83:ca:30:89:e8:dc:d8:a3:ed:2a:80:3f:7f:79:
                    65:57:3e:15:20:66:08:2f:95:93:bf:aa:47:2f:a8:
                    46:97:f0:12:e2:fe:c2:0a:2b:51:e6:76:e6:b7:46:
                    b7:e2:0d:a6:cc:a8:c3:4c:59:55:89:e6:e8:53:5c:
                    1c:ea:9d:f0:62:16:0b:a7:c9:5f:0c:f0:de:c2:76:
                    ce:af:f7:6a:f2:fa:41:a6:a2:33:14:c9:e5:7a:63:
                    d3:9e:62:37:d5:85:65:9e:0e:e6:53:24:74:1b:5e:
                    1d:12:53:5b:c7:2c:e7:83:49:3b:15:ae:8a:68:b9:
                    57:97
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        11:14:96:c1:ab:92:08:f7:3f:2f:c9:b2:fe:e4:5a:9f:64:de:
        db:21:4f:86:99:34:76:36:57:dd:d0:15:2f:c5:ad:7f:15:1f:
        37:62:73:3e:d4:e7:5f:ce:17:03:db:35:fa:2b:db:ae:60:09:
        5f:1e:5f:8f:6e:bb:0b:3d:ea:5a:13:1e:0c:60:6f:b5:c0:b5:
        23:22:2e:07:0b:cb:a9:74:cb:47:bb:1d:c1:d7:a5:6b:cc:2f:
        d2:42:fd:49:dd:a7:89:cf:53:ba:da:00:5a:28:bf:82:df:f8:
        ba:13:1d:50:86:82:fd:8e:30:8f:29:46:b0:1e:3d:35:da:38:
        62:16:18:4a:ad:e6:b6:51:6c:de:af:62:eb:01:d0:1e:24:fe:
        7a:8f:12:1a:12:68:b8:fb:66:99:14:14:45:5c:ae:e7:ae:69:
        17:81:2b:5a:37:c9:5e:2a:f4:c6:e2:a1:5c:54:9b:a6:54:00:
        cf:f0:f1:c1:c7:98:30:1a:3b:36:16:db:a3:6e:ea:fd:ad:b2:
        c2:da:ef:02:47:13:8a:c0:f1:b3:31:ad:4f:1c:e1:4f:9c:af:
        0f:0c:9d:f7:78:0d:d8:f4:35:56:80:da:b7:6d:17:8f:9d:1e:
        81:64:e1:fe:c5:45:ba:ad:6b:b9:0a:7a:4e:4f:4b:84:ee:4b:
        f1:7d:dd:11', 'CBBA9C52FC781F1A1E6F1B3773BDF8C96B9412304FF03647F5D0910AF517C8A561C116404DFB8A6190E57620C111067DAB2C6EA6F511418EFA2DAD2A6159A467264CD0E8BC525B70200458D17AC9A469BC831764AD058BBCD058CE8D8CF5EBF042490B9D972767326EE1AE93151C70BC204D2F18DE9288E86C8557111AE97EE3261154A245965583CA3089E8DCD8A3ED2A803F7F7965573E152066082F9593BFAA472FA84697F012E2FEC20A2B51E676E6B746B7E20DA6CCA8C34C595589E6E8535C1CEA9DF062160BA7C95F0CF0DEC276CEAFF76AF2FA41A6A23314C9E57A63D39E6237D585659E0EE65324741B5E1D12535BC72CE783493B15AE8A68B95797', '/C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 3 Public Primary Certification Authority - G3', 'C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 3 Public Primary Certification Authority - G3', '9B7E0649A33E62B9D5EE90487129EF57', NULL, '-----BEGIN CERTIFICATE-----
MIIEGjCCAwICEQCbfgZJoz5iudXukEhxKe9XMA0GCSqGSIb3DQEBBQUAMIHKMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
cmlTaWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWdu
LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlT
aWduIENsYXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
dHkgLSBHMzAeFw05OTEwMDEwMDAwMDBaFw0zNjA3MTYyMzU5NTlaMIHKMQswCQYD
VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
aWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWduLCBJ
bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlTaWdu
IENsYXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkg
LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMu6nFL8eB8aHm8b
N3O9+MlrlBIwT/A2R/XQkQr1F8ilYcEWQE37imGQ5XYgwREGfassbqb1EUGO+i2t
KmFZpGcmTNDovFJbcCAEWNF6yaRpvIMXZK0Fi7zQWM6NjPXr8EJJC52XJ2cybuGu
kxUccLwgTS8Y3pKI6GyFVxEa6X7jJhFUokWWVYPKMIno3Nij7SqAP395ZVc+FSBm
CC+Vk7+qRy+oRpfwEuL+wgorUeZ25rdGt+INpsyow0xZVYnm6FNcHOqd8GIWC6fJ
Xwzw3sJ2zq/3avL6QaaiMxTJ5Xpj055iN9WFZZ4O5lMkdBteHRJTW8cs54NJOxWu
imi5V5cCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAERSWwauSCPc/L8my/uRan2Te
2yFPhpk0djZX3dAVL8WtfxUfN2JzPtTnX84XA9s1+ivbrmAJXx5fj267Cz3qWhMe
DGBvtcC1IyIuBwvLqXTLR7sdwdela8wv0kL9Sd2nic9TutoAWii/gt/4uhMdUIaC
/Y4wjylGsB49Ndo4YhYYSq3mtlFs3q9i6wHQHiT+eo8SGhJouPtmmRQURVyu565p
F4ErWjfJXir0xuKhXFSbplQAz/DxwceYMBo7Nhbbo27q/a2ywtrvAkcTisDxszGt
TxzhT5yvDwyd93gN2PQ1VoDat20Xj50egWTh/sVFuq1ruQp6Tk9LhO5L8X3dEQ==
-----END CERTIFICATE-----', 'ea05cc1d1781f57e74c3fbba2634e2e3');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc., CN=VeriSign Class 3 Public Primary Certification Authority - G5', 3, 1, 0, '2006-11-08 00:00:00', '2036-07-16 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            18:da:d1:9e:26:7d:e8:bb:4a:21:58:cd:cc:6b:3b:4a
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 2006 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 3 Public Primary Certification Authority - G5
        Validity
            Not Before: Nov  8 00:00:00 2006 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 2006 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 3 Public Primary Certification Authority - G5
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:af:24:08:08:29:7a:35:9e:60:0c:aa:e7:4b:3b:
                    4e:dc:7c:bc:3c:45:1c:bb:2b:e0:fe:29:02:f9:57:
                    08:a3:64:85:15:27:f5:f1:ad:c8:31:89:5d:22:e8:
                    2a:aa:a6:42:b3:8f:f8:b9:55:b7:b1:b7:4b:b3:fe:
                    8f:7e:07:57:ec:ef:43:db:66:62:15:61:cf:60:0d:
                    a4:d8:de:f8:e0:c3:62:08:3d:54:13:eb:49:ca:59:
                    54:85:26:e5:2b:8f:1b:9f:eb:f5:a1:91:c2:33:49:
                    d8:43:63:6a:52:4b:d2:8f:e8:70:51:4d:d1:89:69:
                    7b:c7:70:f6:b3:dc:12:74:db:7b:5d:4b:56:d3:96:
                    bf:15:77:a1:b0:f4:a2:25:f2:af:1c:92:67:18:e5:
                    f4:06:04:ef:90:b9:e4:00:e4:dd:3a:b5:19:ff:02:
                    ba:f4:3c:ee:e0:8b:eb:37:8b:ec:f4:d7:ac:f2:f6:
                    f0:3d:af:dd:75:91:33:19:1d:1c:40:cb:74:24:19:
                    21:93:d9:14:fe:ac:2a:52:c7:8f:d5:04:49:e4:8d:
                    63:47:88:3c:69:83:cb:fe:47:bd:2b:7e:4f:c5:95:
                    ae:0e:9d:d4:d1:43:c0:67:73:e3:14:08:7e:e5:3f:
                    9f:73:b8:33:0a:cf:5d:3f:34:87:96:8a:ee:53:e8:
                    25:15
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            1.3.6.1.5.5.7.1.12: 
                0_.].[0Y0W0U..image/gif0!0.0...+..............k...j.H.,{..0%.#http://logo.verisign.com/vslogo.gif
            X509v3 Subject Key Identifier: 
                7F:D3:65:A7:C2:DD:EC:BB:F0:30:09:F3:43:39:FA:02:AF:33:31:33
    Signature Algorithm: sha1WithRSAEncryption
        93:24:4a:30:5f:62:cf:d8:1a:98:2f:3d:ea:dc:99:2d:bd:77:
        f6:a5:79:22:38:ec:c4:a7:a0:78:12:ad:62:0e:45:70:64:c5:
        e7:97:66:2d:98:09:7e:5f:af:d6:cc:28:65:f2:01:aa:08:1a:
        47:de:f9:f9:7c:92:5a:08:69:20:0d:d9:3e:6d:6e:3c:0d:6e:
        d8:e6:06:91:40:18:b9:f8:c1:ed:df:db:41:aa:e0:96:20:c9:
        cd:64:15:38:81:c9:94:ee:a2:84:29:0b:13:6f:8e:db:0c:dd:
        25:02:db:a4:8b:19:44:d2:41:7a:05:69:4a:58:4f:60:ca:7e:
        82:6a:0b:02:aa:25:17:39:b5:db:7f:e7:84:65:2a:95:8a:bd:
        86:de:5e:81:16:83:2d:10:cc:de:fd:a8:82:2a:6d:28:1f:0d:
        0b:c4:e5:e7:1a:26:19:e1:f4:11:6f:10:b5:95:fc:e7:42:05:
        32:db:ce:9d:51:5e:28:b6:9e:85:d3:5b:ef:a5:7d:45:40:72:
        8e:b7:0e:6b:0e:06:fb:33:35:48:71:b8:9d:27:8b:c4:65:5f:
        0d:86:76:9c:44:7a:f6:95:5c:f6:5d:32:08:33:a4:54:b6:18:
        3f:68:5c:f2:42:4a:85:38:54:83:5f:d1:e8:2c:f2:ac:11:d6:
        a8:ed:63:6a', 'AF240808297A359E600CAAE74B3B4EDC7CBC3C451CBB2BE0FE2902F95708A364851527F5F1ADC831895D22E82AAAA642B38FF8B955B7B1B74BB3FE8F7E0757ECEF43DB66621561CF600DA4D8DEF8E0C362083D5413EB49CA59548526E52B8F1B9FEBF5A191C23349D843636A524BD28FE870514DD189697BC770F6B3DC1274DB7B5D4B56D396BF1577A1B0F4A225F2AF1C926718E5F40604EF90B9E400E4DD3AB519FF02BAF43CEEE08BEB378BECF4D7ACF2F6F03DAFDD759133191D1C40CB7424192193D914FEAC2A52C78FD50449E48D6347883C6983CBFE47BD2B7E4FC595AE0E9DD4D143C06773E314087EE53F9F73B8330ACF5D3F3487968AEE53E82515', '/C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 2006 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 3 Public Primary Certification Authority - G5', 'C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 2006 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 3 Public Primary Certification Authority - G5', '18DAD19E267DE8BB4A2158CDCC6B3B4A', NULL, '-----BEGIN CERTIFICATE-----
MIIE0zCCA7ugAwIBAgIQGNrRniZ96LtKIVjNzGs7SjANBgkqhkiG9w0BAQUFADCB
yjELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL
ExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwNiBWZXJp
U2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxW
ZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0
aG9yaXR5IC0gRzUwHhcNMDYxMTA4MDAwMDAwWhcNMzYwNzE2MjM1OTU5WjCByjEL
MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQLExZW
ZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwNiBWZXJpU2ln
biwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxWZXJp
U2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9y
aXR5IC0gRzUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCvJAgIKXo1
nmAMqudLO07cfLw8RRy7K+D+KQL5VwijZIUVJ/XxrcgxiV0i6CqqpkKzj/i5Vbex
t0uz/o9+B1fs70PbZmIVYc9gDaTY3vjgw2IIPVQT60nKWVSFJuUrjxuf6/WhkcIz
SdhDY2pSS9KP6HBRTdGJaXvHcPaz3BJ023tdS1bTlr8Vd6Gw9KIl8q8ckmcY5fQG
BO+QueQA5N06tRn/Arr0PO7gi+s3i+z016zy9vA9r911kTMZHRxAy3QkGSGT2RT+
rCpSx4/VBEnkjWNHiDxpg8v+R70rfk/Fla4OndTRQ8Bnc+MUCH7lP59zuDMKz10/
NIeWiu5T6CUVAgMBAAGjgbIwga8wDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8E
BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJaW1hZ2UvZ2lmMCEwHzAH
BgUrDgMCGgQUj+XTGoasjY5rw8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVy
aXNpZ24uY29tL3ZzbG9nby5naWYwHQYDVR0OBBYEFH/TZafC3ey78DAJ80M5+gKv
MzEzMA0GCSqGSIb3DQEBBQUAA4IBAQCTJEowX2LP2BqYLz3q3JktvXf2pXkiOOzE
p6B4Eq1iDkVwZMXnl2YtmAl+X6/WzChl8gGqCBpH3vn5fJJaCGkgDdk+bW48DW7Y
5gaRQBi5+MHt39tBquCWIMnNZBU4gcmU7qKEKQsTb47bDN0lAtukixlE0kF6BWlK
WE9gyn6CagsCqiUXObXbf+eEZSqVir2G3l6BFoMtEMze/aiCKm0oHw0LxOXnGiYZ
4fQRbxC1lfznQgUy286dUV4otp6F01vvpX1FQHKOtw5rDgb7MzVIcbidJ4vEZV8N
hnacRHr2lVz2XTIIM6RUthg/aFzyQkqFOFSDX9HoLPKsEdao7WNq
-----END CERTIFICATE-----', '5ff1a2581cfb062a8620a64ba3881248');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc., CN=VeriSign Class 4 Public Primary Certification Authority - G3', 3, 1, 0, '1999-10-01 00:00:00', '2036-07-16 23:59:59', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            ec:a0:a7:8b:6e:75:6a:01:cf:c4:7c:cc:2f:94:5e:d7
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 4 Public Primary Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 4 Public Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ad:cb:a5:11:69:c6:59:ab:f1:8f:b5:19:0f:56:
                    ce:cc:b5:1f:20:e4:9e:26:25:4b:e0:73:65:89:59:
                    de:d0:83:e4:f5:0f:b5:bb:ad:f1:7c:e8:21:fc:e4:
                    e8:0c:ee:7c:45:22:19:76:92:b4:13:b7:20:5b:09:
                    fa:61:ae:a8:f2:a5:8d:85:c2:2a:d6:de:66:36:d2:
                    9b:02:f4:a8:92:60:7c:9c:69:b4:8f:24:1e:d0:86:
                    52:f6:32:9c:41:58:1e:22:bd:cd:45:62:95:08:6e:
                    d0:66:dd:53:a2:cc:f0:10:dc:54:73:8b:04:a1:46:
                    33:33:5c:17:40:b9:9e:4d:d3:f3:be:55:83:e8:b1:
                    89:8e:5a:7c:9a:96:22:90:3b:88:25:f2:d2:53:88:
                    02:0c:0b:78:f2:e6:37:17:4b:30:46:07:e4:80:6d:
                    a6:d8:96:2e:e8:2c:f8:11:b3:38:0d:66:a6:9b:ea:
                    c9:23:5b:db:8e:e2:f3:13:8e:1a:59:2d:aa:02:f0:
                    ec:a4:87:66:dc:c1:3f:f5:d8:b9:f4:ec:82:c6:d2:
                    3d:95:1d:e5:c0:4f:84:c9:d9:a3:44:28:06:6a:d7:
                    45:ac:f0:6b:6a:ef:4e:5f:f8:11:82:1e:38:63:34:
                    66:50:d4:3e:93:73:fa:30:c3:66:ad:ff:93:2d:97:
                    ef:03
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        8f:fa:25:6b:4f:5b:e4:a4:4e:27:55:ab:22:15:59:3c:ca:b5:
        0a:d4:4a:db:ab:dd:a1:5f:53:c5:a0:57:39:c2:ce:47:2b:be:
        3a:c8:56:bf:c2:d9:27:10:3a:b1:05:3c:c0:77:31:bb:3a:d3:
        05:7b:6d:9a:1c:30:8c:80:cb:93:93:2a:83:ab:05:51:82:02:
        00:11:67:6b:f3:88:61:47:5f:03:93:d5:5b:0d:e0:f1:d4:a1:
        32:35:85:b2:3a:db:b0:82:ab:d1:cb:0a:bc:4f:8c:5b:c5:4b:
        00:3b:1f:2a:82:a6:7e:36:85:dc:7e:3c:67:00:b5:e4:3b:52:
        e0:a8:eb:5d:15:f9:c6:6d:f0:ad:1d:0e:85:b7:a9:9a:73:14:
        5a:5b:8f:41:28:c0:d5:e8:2d:4d:a4:5e:cd:aa:d9:ed:ce:dc:
        d8:d5:3c:42:1d:17:c1:12:5d:45:38:c3:38:f3:fc:85:2e:83:
        46:48:b2:d7:20:5f:92:36:8f:e7:79:0f:98:5e:99:e8:f0:d0:
        a4:bb:f5:53:bd:2a:ce:59:b0:af:6e:7f:6c:bb:d2:1e:00:b0:
        21:ed:f8:41:62:82:b9:d8:b2:c4:bb:46:50:f3:31:c5:8f:01:
        a8:74:eb:f5:78:27:da:e7:f7:66:43:f3:9e:83:3e:20:aa:c3:
        35:60:91:ce', 'ADCBA51169C659ABF18FB5190F56CECCB51F20E49E26254BE073658959DED083E4F50FB5BBADF17CE821FCE4E80CEE7C4522197692B413B7205B09FA61AEA8F2A58D85C22AD6DE6636D29B02F4A892607C9C69B48F241ED08652F6329C41581E22BDCD456295086ED066DD53A2CCF010DC54738B04A14633335C1740B99E4DD3F3BE5583E8B1898E5A7C9A9622903B8825F2D25388020C0B78F2E637174B304607E4806DA6D8962EE82CF811B3380D66A69BEAC9235BDB8EE2F3138E1A592DAA02F0ECA48766DCC13FF5D8B9F4EC82C6D23D951DE5C04F84C9D9A34428066AD745ACF06B6AEF4E5FF811821E3863346650D43E9373FA30C366ADFF932D97EF03', '/C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 4 Public Primary Certification Authority - G3', 'C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 1999 VeriSign, Inc. - For authorized use only/CN=VeriSign Class 4 Public Primary Certification Authority - G3', 'ECA0A78B6E756A01CFC47CCC2F945ED7', NULL, '-----BEGIN CERTIFICATE-----
MIIEGjCCAwICEQDsoKeLbnVqAc/EfMwvlF7XMA0GCSqGSIb3DQEBBQUAMIHKMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
cmlTaWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWdu
LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlT
aWduIENsYXNzIDQgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
dHkgLSBHMzAeFw05OTEwMDEwMDAwMDBaFw0zNjA3MTYyMzU5NTlaMIHKMQswCQYD
VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
aWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWduLCBJ
bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlTaWdu
IENsYXNzIDQgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkg
LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK3LpRFpxlmr8Y+1
GQ9Wzsy1HyDkniYlS+BzZYlZ3tCD5PUPtbut8XzoIfzk6AzufEUiGXaStBO3IFsJ
+mGuqPKljYXCKtbeZjbSmwL0qJJgfJxptI8kHtCGUvYynEFYHiK9zUVilQhu0Gbd
U6LM8BDcVHOLBKFGMzNcF0C5nk3T875Vg+ixiY5afJqWIpA7iCXy0lOIAgwLePLm
NxdLMEYH5IBtptiWLugs+BGzOA1mppvqySNb247i8xOOGlktqgLw7KSHZtzBP/XY
ufTsgsbSPZUd5cBPhMnZo0QoBmrXRazwa2rvTl/4EYIeOGM0ZlDUPpNz+jDDZq3/
ky2X7wMCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAj/ola09b5KROJ1WrIhVZPMq1
CtRK26vdoV9TxaBXOcLORyu+OshWv8LZJxA6sQU8wHcxuzrTBXttmhwwjIDLk5Mq
g6sFUYICABFna/OIYUdfA5PVWw3g8dShMjWFsjrbsIKr0csKvE+MW8VLADsfKoKm
fjaF3H48ZwC15DtS4KjrXRX5xm3wrR0OhbepmnMUWluPQSjA1egtTaRezarZ7c7c
2NU8Qh0XwRJdRTjDOPP8hS6DRkiy1yBfkjaP53kPmF6Z6PDQpLv1U70qzlmwr25/
bLvSHgCwIe34QWKCudiyxLtGUPMxxY8BqHTr9Xgn2uf3ZkPznoM+IKrDNWCRzg==
-----END CERTIFICATE-----', 'b66a56bd22db3cb7277f2dd16963ef2c');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VeriSign, Inc., CN=VeriSign Universal Root Certification Authority', 3, 1, 0, '2008-04-02 00:00:00', '2037-12-01 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            40:1a:c4:64:21:b3:13:21:03:0e:bb:e4:12:1a:c5:1d
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 2008 VeriSign, Inc. - For authorized use only, CN=VeriSign Universal Root Certification Authority
        Validity
            Not Before: Apr  2 00:00:00 2008 GMT
            Not After : Dec  1 23:59:59 2037 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 2008 VeriSign, Inc. - For authorized use only, CN=VeriSign Universal Root Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:c7:61:37:5e:b1:01:34:db:62:d7:15:9b:ff:58:
                    5a:8c:23:23:d6:60:8e:91:d7:90:98:83:7a:e6:58:
                    19:38:8c:c5:f6:e5:64:85:b4:a2:71:fb:ed:bd:b9:
                    da:cd:4d:00:b4:c8:2d:73:a5:c7:69:71:95:1f:39:
                    3c:b2:44:07:9c:e8:0e:fa:4d:4a:c4:21:df:29:61:
                    8f:32:22:61:82:c5:87:1f:6e:8c:7c:5f:16:20:51:
                    44:d1:70:4f:57:ea:e3:1c:e3:cc:79:ee:58:d8:0e:
                    c2:b3:45:93:c0:2c:e7:9a:17:2b:7b:00:37:7a:41:
                    33:78:e1:33:e2:f3:10:1a:7f:87:2c:be:f6:f5:f7:
                    42:e2:e5:bf:87:62:89:5f:00:4b:df:c5:dd:e4:75:
                    44:32:41:3a:1e:71:6e:69:cb:0b:75:46:08:d1:ca:
                    d2:2b:95:d0:cf:fb:b9:40:6b:64:8c:57:4d:fc:13:
                    11:79:84:ed:5e:54:f6:34:9f:08:01:f3:10:25:06:
                    17:4a:da:f1:1d:7a:66:6b:98:60:66:a4:d9:ef:d2:
                    2e:82:f1:f0:ef:09:ea:44:c9:15:6a:e2:03:6e:33:
                    d3:ac:9f:55:00:c7:f6:08:6a:94:b9:5f:dc:e0:33:
                    f1:84:60:f9:5b:27:11:b4:fc:16:f2:bb:56:6a:80:
                    25:8d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            1.3.6.1.5.5.7.1.12: 
                0_.].[0Y0W0U..image/gif0!0.0...+..............k...j.H.,{..0%.#http://logo.verisign.com/vslogo.gif
            X509v3 Subject Key Identifier: 
                B6:77:FA:69:48:47:9F:53:12:D5:C2:EA:07:32:76:07:D1:97:07:19
    Signature Algorithm: sha256WithRSAEncryption
        4a:f8:f8:b0:03:e6:2c:67:7b:e4:94:77:63:cc:6e:4c:f9:7d:
        0e:0d:dc:c8:b9:35:b9:70:4f:63:fa:24:fa:6c:83:8c:47:9d:
        3b:63:f3:9a:f9:76:32:95:91:b1:77:bc:ac:9a:be:b1:e4:31:
        21:c6:81:95:56:5a:0e:b1:c2:d4:b1:a6:59:ac:f1:63:cb:b8:
        4c:1d:59:90:4a:ef:90:16:28:1f:5a:ae:10:fb:81:50:38:0c:
        6c:cc:f1:3d:c3:f5:63:e3:b3:e3:21:c9:24:39:e9:fd:15:66:
        46:f4:1b:11:d0:4d:73:a3:7d:46:f9:3d:ed:a8:5f:62:d4:f1:
        3f:f8:e0:74:57:2b:18:9d:81:b4:c4:28:da:94:97:a5:70:eb:
        ac:1d:be:07:11:f0:d5:db:dd:e5:8c:f0:d5:32:b0:83:e6:57:
        e2:8f:bf:be:a1:aa:bf:3d:1d:b5:d4:38:ea:d7:b0:5c:3a:4f:
        6a:3f:8f:c0:66:6c:63:aa:e9:d9:a4:16:f4:81:d1:95:14:0e:
        7d:cd:95:34:d9:d2:8f:70:73:81:7b:9c:7e:bd:98:61:d8:45:
        87:98:90:c5:eb:86:30:c6:35:bf:f0:ff:c3:55:88:83:4b:ef:
        05:92:06:71:f2:b8:98:93:b7:ec:cd:82:61:f1:38:e6:4f:97:
        98:2a:5a:8d', 'C761375EB10134DB62D7159BFF585A8C2323D6608E91D79098837AE65819388CC5F6E56485B4A271FBEDBDB9DACD4D00B4C82D73A5C76971951F393CB244079CE80EFA4D4AC421DF29618F32226182C5871F6E8C7C5F16205144D1704F57EAE31CE3CC79EE58D80EC2B34593C02CE79A172B7B00377A413378E133E2F3101A7F872CBEF6F5F742E2E5BF8762895F004BDFC5DDE4754432413A1E716E69CB0B754608D1CAD22B95D0CFFBB9406B648C574DFC13117984ED5E54F6349F0801F3102506174ADAF11D7A666B986066A4D9EFD22E82F1F0EF09EA44C9156AE2036E33D3AC9F5500C7F6086A94B95FDCE033F18460F95B2711B4FC16F2BB566A80258D', '/C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 2008 VeriSign, Inc. - For authorized use only/CN=VeriSign Universal Root Certification Authority', 'C=US/O=VeriSign, Inc./OU=VeriSign Trust Network/OU=(c) 2008 VeriSign, Inc. - For authorized use only/CN=VeriSign Universal Root Certification Authority', '401AC46421B31321030EBBE4121AC51D', NULL, '-----BEGIN CERTIFICATE-----
MIIEuTCCA6GgAwIBAgIQQBrEZCGzEyEDDrvkEhrFHTANBgkqhkiG9w0BAQsFADCB
vTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL
ExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwOCBWZXJp
U2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5MTgwNgYDVQQDEy9W
ZXJpU2lnbiBVbml2ZXJzYWwgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAe
Fw0wODA0MDIwMDAwMDBaFw0zNzEyMDEyMzU5NTlaMIG9MQswCQYDVQQGEwJVUzEX
MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAyMDA4IFZlcmlTaWduLCBJbmMuIC0gRm9y
IGF1dGhvcml6ZWQgdXNlIG9ubHkxODA2BgNVBAMTL1ZlcmlTaWduIFVuaXZlcnNh
bCBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIIBIjANBgkqhkiG9w0BAQEF
AAOCAQ8AMIIBCgKCAQEAx2E3XrEBNNti1xWb/1hajCMj1mCOkdeQmIN65lgZOIzF
9uVkhbSicfvtvbnazU0AtMgtc6XHaXGVHzk8skQHnOgO+k1KxCHfKWGPMiJhgsWH
H26MfF8WIFFE0XBPV+rjHOPMee5Y2A7Cs0WTwCznmhcrewA3ekEzeOEz4vMQGn+H
LL729fdC4uW/h2KJXwBL38Xd5HVEMkE6HnFuacsLdUYI0crSK5XQz/u5QGtkjFdN
/BMReYTtXlT2NJ8IAfMQJQYXStrxHXpma5hgZqTZ79IugvHw7wnqRMkVauIDbjPT
rJ9VAMf2CGqUuV/c4DPxhGD5WycRtPwW8rtWaoAljQIDAQABo4GyMIGvMA8GA1Ud
EwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMG0GCCsGAQUFBwEMBGEwX6FdoFsw
WTBXMFUWCWltYWdlL2dpZjAhMB8wBwYFKw4DAhoEFI/l0xqGrI2Oa8PPgGrUSBgs
exkuMCUWI2h0dHA6Ly9sb2dvLnZlcmlzaWduLmNvbS92c2xvZ28uZ2lmMB0GA1Ud
DgQWBBS2d/ppSEefUxLVwuoHMnYH0ZcHGTANBgkqhkiG9w0BAQsFAAOCAQEASvj4
sAPmLGd75JR3Y8xuTPl9Dg3cyLk1uXBPY/ok+myDjEedO2Pzmvl2MpWRsXe8rJq+
seQxIcaBlVZaDrHC1LGmWazxY8u4TB1ZkErvkBYoH1quEPuBUDgMbMzxPcP1Y+Oz
4yHJJDnp/RVmRvQbEdBNc6N9Rvk97ahfYtTxP/jgdFcrGJ2BtMQo2pSXpXDrrB2+
BxHw1dvd5Yzw1TKwg+ZX4o+/vqGqvz0dtdQ46tewXDpPaj+PwGZsY6rp2aQW9IHR
lRQOfc2VNNnSj3BzgXucfr2YYdhFh5iQxeuGMMY1v/D/w1WIg0vvBZIGcfK4mJO3
7M2CYfE45k+XmCpajQ==
-----END CERTIFICATE-----', '2e0cf9fd6ff9126b1fbf0290901f0ad4');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VISA, CN=GP Root 2', 3, 1, 0, '2000-08-16 22:51:00', '2020-08-15 23:59:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 798 (0x31e)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VISA, OU=Visa International Service Association, CN=GP Root 2
        Validity
            Not Before: Aug 16 22:51:00 2000 GMT
            Not After : Aug 15 23:59:00 2020 GMT
        Subject: C=US, O=VISA, OU=Visa International Service Association, CN=GP Root 2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:a9:01:70:b5:aa:c4:40:f0:ab:6a:26:61:79:19:
                    00:fc:bf:9b:37:59:0c:af:6f:64:1b:f8:da:95:94:
                    24:69:33:11:70:ca:e3:56:74:a2:17:57:64:5c:20:
                    06:e1:d6:ef:71:b7:3b:f7:ab:c1:69:d0:49:a4:b1:
                    04:d7:f4:57:62:89:5c:b0:75:2d:17:24:69:e3:42:
                    60:e4:ee:74:d6:ab:80:56:d8:88:28:e1:fb:6d:22:
                    fd:23:7c:46:73:4f:7e:54:73:1e:a8:2c:55:58:75:
                    b7:4c:f3:5a:45:a5:02:1a:fa:da:9d:c3:45:c3:22:
                    5e:f3:8b:f1:60:29:d2:c7:5f:b4:0c:3a:51:83:ef:
                    30:f8:d4:e7:c7:f2:fa:99:a3:22:50:be:f9:05:37:
                    a3:ad:ed:9a:c3:e6:ec:88:1b:b6:19:27:1b:38:8b:
                    80:4d:ec:b9:c7:c5:89:cb:fc:1a:32:ed:23:f0:b5:
                    01:58:f9:f6:8f:e0:85:a9:4c:09:72:39:12:db:b3:
                    f5:cf:4e:62:64:da:c6:19:15:3a:63:1d:e9:17:55:
                    a1:4c:22:3c:34:32:46:f8:65:57:ba:2b:ef:36:8c:
                    6a:fa:d9:d9:44:f4:aa:dd:84:d7:0d:1c:b2:54:ac:
                    32:85:b4:64:0d:de:41:bb:b1:34:c6:01:86:32:64:
                    d5:9f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                9E:7D:4B:34:BF:71:AD:C2:05:F6:03:75:80:CE:A9:4F:1A:C4:24:4C
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        21:a5:76:14:55:f9:ad:27:70:8f:3c:f4:d5:6c:c8:cc:0a:ab:
        a3:98:0b:8a:06:23:c5:c9:61:db:99:07:69:35:26:31:fe:c7:
        2e:84:c2:99:61:d4:0d:e9:7d:2e:13:2b:7c:8e:85:b6:85:c7:
        4b:cf:35:b6:2c:47:3d:ce:29:2f:d8:6f:9f:89:1c:64:93:bf:
        08:bd:76:d0:90:8a:94:b3:7f:28:5b:6e:ac:4d:33:2c:ed:65:
        dc:16:cc:e2:cd:ae:a4:3d:62:92:06:95:26:bf:df:b9:e4:20:
        a6:73:6a:c1:be:f7:94:44:d6:4d:6f:2a:0b:6b:18:4d:74:10:
        36:68:6a:5a:c1:6a:a7:dd:36:29:8c:b8:30:8b:4f:21:3f:00:
        2e:54:30:07:3a:ba:8a:e4:c3:9e:ca:d8:b5:d8:7b:ce:75:45:
        66:07:f4:6d:2d:d8:7a:ca:e9:89:8a:f2:23:d8:2f:cb:6e:00:
        36:4f:fb:f0:2f:01:cc:0f:c0:22:65:f4:ab:e2:4e:61:2d:03:
        82:7d:91:16:b5:30:d5:14:de:5e:c7:90:fc:a1:fc:ab:10:af:
        5c:6b:70:a7:07:ef:29:86:e8:b2:25:c7:20:ff:26:dd:77:ef:
        79:44:14:c4:bd:dd:3b:c5:03:9b:77:23:ec:a0:ec:bb:5a:39:
        b5:cc:ad:06', 'A90170B5AAC440F0AB6A2661791900FCBF9B37590CAF6F641BF8DA95942469331170CAE35674A21757645C2006E1D6EF71B73BF7ABC169D049A4B104D7F45762895CB0752D172469E34260E4EE74D6AB8056D88828E1FB6D22FD237C46734F7E54731EA82C555875B74CF35A45A5021AFADA9DC345C3225EF38BF16029D2C75FB40C3A5183EF30F8D4E7C7F2FA99A32250BEF90537A3ADED9AC3E6EC881BB619271B388B804DECB9C7C589CBFC1A32ED23F0B50158F9F68FE085A94C09723912DBB3F5CF4E6264DAC619153A631DE91755A14C223C343246F86557BA2BEF368C6AFAD9D944F4AADD84D70D1CB254AC3285B4640DDE41BBB134C601863264D59F', '/C=US/O=VISA/OU=Visa International Service Association/CN=GP Root 2', 'C=US/O=VISA/OU=Visa International Service Association/CN=GP Root 2', '031E', NULL, '-----BEGIN CERTIFICATE-----
MIIDgDCCAmigAwIBAgICAx4wDQYJKoZIhvcNAQEFBQAwYTELMAkGA1UEBhMCVVMx
DTALBgNVBAoTBFZJU0ExLzAtBgNVBAsTJlZpc2EgSW50ZXJuYXRpb25hbCBTZXJ2
aWNlIEFzc29jaWF0aW9uMRIwEAYDVQQDEwlHUCBSb290IDIwHhcNMDAwODE2MjI1
MTAwWhcNMjAwODE1MjM1OTAwWjBhMQswCQYDVQQGEwJVUzENMAsGA1UEChMEVklT
QTEvMC0GA1UECxMmVmlzYSBJbnRlcm5hdGlvbmFsIFNlcnZpY2UgQXNzb2NpYXRp
b24xEjAQBgNVBAMTCUdQIFJvb3QgMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCC
AQoCggEBAKkBcLWqxEDwq2omYXkZAPy/mzdZDK9vZBv42pWUJGkzEXDK41Z0ohdX
ZFwgBuHW73G3O/erwWnQSaSxBNf0V2KJXLB1LRckaeNCYOTudNargFbYiCjh+20i
/SN8RnNPflRzHqgsVVh1t0zzWkWlAhr62p3DRcMiXvOL8WAp0sdftAw6UYPvMPjU
58fy+pmjIlC++QU3o63tmsPm7IgbthknGziLgE3sucfFicv8GjLtI/C1AVj59o/g
halMCXI5Etuz9c9OYmTaxhkVOmMd6RdVoUwiPDQyRvhlV7or7zaMavrZ2UT0qt2E
1w0cslSsMoW0ZA3eQbuxNMYBhjJk1Z8CAwEAAaNCMEAwHQYDVR0OBBYEFJ59SzS/
ca3CBfYDdYDOqU8axCRMMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEG
MA0GCSqGSIb3DQEBBQUAA4IBAQAhpXYUVfmtJ3CPPPTVbMjMCqujmAuKBiPFyWHb
mQdpNSYx/scuhMKZYdQN6X0uEyt8joW2hcdLzzW2LEc9zikv2G+fiRxkk78IvXbQ
kIqUs38oW26sTTMs7WXcFsziza6kPWKSBpUmv9+55CCmc2rBvveURNZNbyoLaxhN
dBA2aGpawWqn3TYpjLgwi08hPwAuVDAHOrqK5MOeyti12HvOdUVmB/RtLdh6yumJ
ivIj2C/LbgA2T/vwLwHMD8AiZfSr4k5hLQOCfZEWtTDVFN5ex5D8ofyrEK9ca3Cn
B+8phuiyJccg/ybdd+95RBTEvd07xQObdyPsoOy7Wjm1zK0G
-----END CERTIFICATE-----', '1b08bbdb82633c11ea85b15ccf3c1ab8');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=VISA, CN=Visa eCommerce Root', 3, 1, 0, '2002-06-26 02:18:36', '2022-06-24 00:16:12', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            13:86:35:4d:1d:3f:06:f2:c1:f9:65:05:d5:90:1c:62
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VISA, OU=Visa International Service Association, CN=Visa eCommerce Root
        Validity
            Not Before: Jun 26 02:18:36 2002 GMT
            Not After : Jun 24 00:16:12 2022 GMT
        Subject: C=US, O=VISA, OU=Visa International Service Association, CN=Visa eCommerce Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:af:57:de:56:1e:6e:a1:da:60:b1:94:27:cb:17:
                    db:07:3f:80:85:4f:c8:9c:b6:d0:f4:6f:4f:cf:99:
                    d8:e1:db:c2:48:5c:3a:ac:39:33:c7:1f:6a:8b:26:
                    3d:2b:35:f5:48:b1:91:c1:02:4e:04:96:91:7b:b0:
                    33:f0:b1:14:4e:11:6f:b5:40:af:1b:45:a5:4a:ef:
                    7e:b6:ac:f2:a0:1f:58:3f:12:46:60:3c:8d:a1:e0:
                    7d:cf:57:3e:33:1e:fb:47:f1:aa:15:97:07:55:66:
                    a5:b5:2d:2e:d8:80:59:b2:a7:0d:b7:46:ec:21:63:
                    ff:35:ab:a5:02:cf:2a:f4:4c:fe:7b:f5:94:5d:84:
                    4d:a8:f2:60:8f:db:0e:25:3c:9f:73:71:cf:94:df:
                    4a:ea:db:df:72:38:8c:f3:96:bd:f1:17:bc:d2:ba:
                    3b:45:5a:c6:a7:f6:c6:17:8b:01:9d:fc:19:a8:2a:
                    83:16:b8:3a:48:fe:4e:3e:a0:ab:06:19:e9:53:f3:
                    80:13:07:ed:2d:bf:3f:0a:3c:55:20:39:2c:2c:00:
                    69:74:95:4a:bc:20:b2:a9:79:e5:18:89:91:a8:dc:
                    1c:4d:ef:bb:7e:37:0b:5d:fe:39:a5:88:52:8c:00:
                    6c:ec:18:7c:41:bd:f6:8b:75:77:ba:60:9d:84:e7:
                    fe:2d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                15:38:83:0F:3F:2C:3F:70:33:1E:CD:46:FE:07:8C:20:E0:D7:C3:B7
    Signature Algorithm: sha1WithRSAEncryption
        5f:f1:41:7d:7c:5c:08:b9:2b:e0:d5:92:47:fa:67:5c:a5:13:
        c3:03:21:9b:2b:4c:89:46:cf:59:4d:c9:fe:a5:40:b6:63:cd:
        dd:71:28:95:67:11:cc:24:ac:d3:44:6c:71:ae:01:20:6b:03:
        a2:8f:18:b7:29:3a:7d:e5:16:60:53:78:3c:c0:af:15:83:f7:
        8f:52:33:24:bd:64:93:97:ee:8b:f7:db:18:a8:6d:71:b3:f7:
        2c:17:d0:74:25:69:f7:fe:6b:3c:94:be:4d:4b:41:8c:4e:e2:
        73:d0:e3:90:22:73:43:cd:f3:ef:ea:73:ce:45:8a:b0:a6:49:
        ff:4c:7d:9d:71:88:c4:76:1d:90:5b:1d:ee:fd:cc:f7:ee:fd:
        60:a5:b1:7a:16:71:d1:16:d0:7c:12:3c:6c:69:97:db:ae:5f:
        39:9a:70:2f:05:3c:19:46:04:99:20:36:d0:60:6e:61:06:bb:
        16:42:8c:70:f7:30:fb:e0:db:66:a3:00:01:bd:e6:2c:da:91:
        5f:a0:46:8b:4d:6a:9c:3d:3d:dd:05:46:fe:76:bf:a0:0a:3c:
        e4:00:e6:27:b7:ff:84:2d:de:ba:22:27:96:10:71:eb:22:ed:
        df:df:33:9c:cf:e3:ad:ae:8e:d4:8e:e6:4f:51:af:16:92:e0:
        5c:f6:07:0f', 'AF57DE561E6EA1DA60B19427CB17DB073F80854FC89CB6D0F46F4FCF99D8E1DBC2485C3AAC3933C71F6A8B263D2B35F548B191C1024E0496917BB033F0B1144E116FB540AF1B45A54AEF7EB6ACF2A01F583F1246603C8DA1E07DCF573E331EFB47F1AA1597075566A5B52D2ED88059B2A70DB746EC2163FF35ABA502CF2AF44CFE7BF5945D844DA8F2608FDB0E253C9F7371CF94DF4AEADBDF72388CF396BDF117BCD2BA3B455AC6A7F6C6178B019DFC19A82A8316B83A48FE4E3EA0AB0619E953F3801307ED2DBF3F0A3C5520392C2C006974954ABC20B2A979E5188991A8DC1C4DEFBB7E370B5DFE39A588528C006CEC187C41BDF68B7577BA609D84E7FE2D', '/C=US/O=VISA/OU=Visa International Service Association/CN=Visa eCommerce Root', 'C=US/O=VISA/OU=Visa International Service Association/CN=Visa eCommerce Root', '1386354D1D3F06F2C1F96505D5901C62', NULL, '-----BEGIN CERTIFICATE-----
MIIDojCCAoqgAwIBAgIQE4Y1TR0/BvLB+WUF1ZAcYjANBgkqhkiG9w0BAQUFADBr
MQswCQYDVQQGEwJVUzENMAsGA1UEChMEVklTQTEvMC0GA1UECxMmVmlzYSBJbnRl
cm5hdGlvbmFsIFNlcnZpY2UgQXNzb2NpYXRpb24xHDAaBgNVBAMTE1Zpc2EgZUNv
bW1lcmNlIFJvb3QwHhcNMDIwNjI2MDIxODM2WhcNMjIwNjI0MDAxNjEyWjBrMQsw
CQYDVQQGEwJVUzENMAsGA1UEChMEVklTQTEvMC0GA1UECxMmVmlzYSBJbnRlcm5h
dGlvbmFsIFNlcnZpY2UgQXNzb2NpYXRpb24xHDAaBgNVBAMTE1Zpc2EgZUNvbW1l
cmNlIFJvb3QwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCvV95WHm6h
2mCxlCfLF9sHP4CFT8icttD0b0/Pmdjh28JIXDqsOTPHH2qLJj0rNfVIsZHBAk4E
lpF7sDPwsRROEW+1QK8bRaVK7362rPKgH1g/EkZgPI2h4H3PVz4zHvtH8aoVlwdV
ZqW1LS7YgFmypw23RuwhY/81q6UCzyr0TP579ZRdhE2o8mCP2w4lPJ9zcc+U30rq
299yOIzzlr3xF7zSujtFWsan9sYXiwGd/BmoKoMWuDpI/k4+oKsGGelT84ATB+0t
vz8KPFUgOSwsAGl0lUq8ILKpeeUYiZGo3BxN77t+Nwtd/jmliFKMAGzsGHxBvfaL
dXe6YJ2E5/4tAgMBAAGjQjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQD
AgEGMB0GA1UdDgQWBBQVOIMPPyw/cDMezUb+B4wg4NfDtzANBgkqhkiG9w0BAQUF
AAOCAQEAX/FBfXxcCLkr4NWSR/pnXKUTwwMhmytMiUbPWU3J/qVAtmPN3XEolWcR
zCSs00Rsca4BIGsDoo8Ytyk6feUWYFN4PMCvFYP3j1IzJL1kk5fui/fbGKhtcbP3
LBfQdCVp9/5rPJS+TUtBjE7ic9DjkCJzQ83z7+pzzkWKsKZJ/0x9nXGIxHYdkFsd
7v3M9+79YKWxehZx0RbQfBI8bGmX265fOZpwLwU8GUYEmSA20GBuYQa7FkKMcPcw
++DbZqMAAb3mLNqRX6BGi01qnD093QVG/na/oAo85ADmJ7f/hC3euiInlhBx6yLt
398znM/jra6O1I7mT1GvFpLgXPYHDw==
-----END CERTIFICATE-----', '3368fff3b2a3506ad83108f0d78ba23f');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=XRamp Security Services Inc, CN=XRamp Global Certification Authority', 3, 1, 0, '2004-11-01 17:14:04', '2035-01-01 05:37:19', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            50:94:6c:ec:18:ea:d5:9c:4d:d5:97:ef:75:8f:a0:ad
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, OU=www.xrampsecurity.com, O=XRamp Security Services Inc, CN=XRamp Global Certification Authority
        Validity
            Not Before: Nov  1 17:14:04 2004 GMT
            Not After : Jan  1 05:37:19 2035 GMT
        Subject: C=US, OU=www.xrampsecurity.com, O=XRamp Security Services Inc, CN=XRamp Global Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:98:24:1e:bd:15:b4:ba:df:c7:8c:a5:27:b6:38:
                    0b:69:f3:b6:4e:a8:2c:2e:21:1d:5c:44:df:21:5d:
                    7e:23:74:fe:5e:7e:b4:4a:b7:a6:ad:1f:ae:e0:06:
                    16:e2:9b:5b:d9:67:74:6b:5d:80:8f:29:9d:86:1b:
                    d9:9c:0d:98:6d:76:10:28:58:e4:65:b0:7f:4a:98:
                    79:9f:e0:c3:31:7e:80:2b:b5:8c:c0:40:3b:11:86:
                    d0:cb:a2:86:36:60:a4:d5:30:82:6d:d9:6e:d0:0f:
                    12:04:33:97:5f:4f:61:5a:f0:e4:f9:91:ab:e7:1d:
                    3b:bc:e8:cf:f4:6b:2d:34:7c:e2:48:61:1c:8e:f3:
                    61:44:cc:6f:a0:4a:a9:94:b0:4d:da:e7:a9:34:7a:
                    72:38:a8:41:cc:3c:94:11:7d:eb:c8:a6:8c:b7:86:
                    cb:ca:33:3b:d9:3d:37:8b:fb:7a:3e:86:2c:e7:73:
                    d7:0a:57:ac:64:9b:19:eb:f4:0f:04:08:8a:ac:03:
                    17:19:64:f4:5a:25:22:8d:34:2c:b2:f6:68:1d:12:
                    6d:d3:8a:1e:14:da:c4:8f:a6:e2:23:85:d5:7a:0d:
                    bd:6a:e0:e9:ec:ec:17:bb:42:1b:67:aa:25:ed:45:
                    83:21:fc:c1:c9:7c:d5:62:3e:fa:f2:c5:2d:d3:fd:
                    d4:65
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            1.3.6.1.4.1.311.20.2: 
                ...C.A
            X509v3 Key Usage: 
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                C6:4F:A2:3D:06:63:84:09:9C:CE:62:E4:04:AC:8D:5C:B5:E9:B6:1B
            X509v3 CRL Distribution Points: 
                URI:http://crl.xrampsecurity.com/XGCA.crl

            1.3.6.1.4.1.311.21.1: 
                ...
    Signature Algorithm: sha1WithRSAEncryption
        91:15:39:03:01:1b:67:fb:4a:1c:f9:0a:60:5b:a1:da:4d:97:
        62:f9:24:53:27:d7:82:64:4e:90:2e:c3:49:1b:2b:9a:dc:fc:
        a8:78:67:35:f1:1d:f0:11:bd:b7:48:e3:10:f6:0d:df:3f:d2:
        c9:b6:aa:55:a4:48:ba:02:db:de:59:2e:15:5b:3b:9d:16:7d:
        47:d7:37:ea:5f:4d:76:12:36:bb:1f:d7:a1:81:04:46:20:a3:
        2c:6d:a9:9e:01:7e:3f:29:ce:00:93:df:fd:c9:92:73:89:89:
        64:9e:e7:2b:e4:1c:91:2c:d2:b9:ce:7d:ce:6f:31:99:d3:e6:
        be:d2:1e:90:f0:09:14:79:5c:23:ab:4d:d2:da:21:1f:4d:99:
        79:9d:e1:cf:27:9f:10:9b:1c:88:0d:b0:8a:64:41:31:b8:0e:
        6c:90:24:a4:9b:5c:71:8f:ba:bb:7e:1c:1b:db:6a:80:0f:21:
        bc:e9:db:a6:b7:40:f4:b2:8b:a9:b1:e4:ef:9a:1a:d0:3d:69:
        99:ee:a8:28:a3:e1:3c:b3:f0:b2:11:9c:cf:7c:40:e6:dd:e7:
        43:7d:a2:d8:3a:b5:a9:8d:f2:34:99:c4:d4:10:e1:06:fd:09:
        84:10:3b:ee:c4:4c:f4:ec:27:7c:42:c2:74:7c:82:8a:09:c9:
        b4:03:25:bc', '98241EBD15B4BADFC78CA527B6380B69F3B64EA82C2E211D5C44DF215D7E2374FE5E7EB44AB7A6AD1FAEE00616E29B5BD967746B5D808F299D861BD99C0D986D76102858E465B07F4A98799FE0C3317E802BB58CC0403B1186D0CBA2863660A4D530826DD96ED00F120433975F4F615AF0E4F991ABE71D3BBCE8CFF46B2D347CE248611C8EF36144CC6FA04AA994B04DDAE7A9347A7238A841CC3C94117DEBC8A68CB786CBCA333BD93D378BFB7A3E862CE773D70A57AC649B19EBF40F04088AAC03171964F45A25228D342CB2F6681D126DD38A1E14DAC48FA6E22385D57A0DBD6AE0E9ECEC17BB421B67AA25ED458321FCC1C97CD5623EFAF2C52DD3FDD465', '/C=US/OU=www.xrampsecurity.com/O=XRamp Security Services Inc/CN=XRamp Global Certification Authority', 'C=US/OU=www.xrampsecurity.com/O=XRamp Security Services Inc/CN=XRamp Global Certification Authority', '50946CEC18EAD59C4DD597EF758FA0AD', NULL, '-----BEGIN CERTIFICATE-----
MIIEMDCCAxigAwIBAgIQUJRs7Bjq1ZxN1ZfvdY+grTANBgkqhkiG9w0BAQUFADCB
gjELMAkGA1UEBhMCVVMxHjAcBgNVBAsTFXd3dy54cmFtcHNlY3VyaXR5LmNvbTEk
MCIGA1UEChMbWFJhbXAgU2VjdXJpdHkgU2VydmljZXMgSW5jMS0wKwYDVQQDEyRY
UmFtcCBHbG9iYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMDQxMTAxMTcx
NDA0WhcNMzUwMTAxMDUzNzE5WjCBgjELMAkGA1UEBhMCVVMxHjAcBgNVBAsTFXd3
dy54cmFtcHNlY3VyaXR5LmNvbTEkMCIGA1UEChMbWFJhbXAgU2VjdXJpdHkgU2Vy
dmljZXMgSW5jMS0wKwYDVQQDEyRYUmFtcCBHbG9iYWwgQ2VydGlmaWNhdGlvbiBB
dXRob3JpdHkwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCYJB69FbS6
38eMpSe2OAtp87ZOqCwuIR1cRN8hXX4jdP5efrRKt6atH67gBhbim1vZZ3RrXYCP
KZ2GG9mcDZhtdhAoWORlsH9KmHmf4MMxfoArtYzAQDsRhtDLooY2YKTVMIJt2W7Q
DxIEM5dfT2Fa8OT5kavnHTu86M/0ay00fOJIYRyO82FEzG+gSqmUsE3a56k0enI4
qEHMPJQRfevIpoy3hsvKMzvZPTeL+3o+hiznc9cKV6xkmxnr9A8ECIqsAxcZZPRa
JSKNNCyy9mgdEm3Tih4U2sSPpuIjhdV6Db1q4Ons7Be7QhtnqiXtRYMh/MHJfNVi
PvryxS3T/dRlAgMBAAGjgZ8wgZwwEwYJKwYBBAGCNxQCBAYeBABDAEEwCwYDVR0P
BAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFMZPoj0GY4QJnM5i5ASs
jVy16bYbMDYGA1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9jcmwueHJhbXBzZWN1cml0
eS5jb20vWEdDQS5jcmwwEAYJKwYBBAGCNxUBBAMCAQEwDQYJKoZIhvcNAQEFBQAD
ggEBAJEVOQMBG2f7Shz5CmBbodpNl2L5JFMn14JkTpAuw0kbK5rc/Kh4ZzXxHfAR
vbdI4xD2Dd8/0sm2qlWkSLoC295ZLhVbO50WfUfXN+pfTXYSNrsf16GBBEYgoyxt
qZ4Bfj8pzgCT3/3JknOJiWSe5yvkHJEs0rnOfc5vMZnT5r7SHpDwCRR5XCOrTdLa
IR9NmXmd4c8nnxCbHIgNsIpkQTG4DmyQJKSbXHGPurt+HBvbaoAPIbzp26a3QPSy
i6mx5O+aGtA9aZnuqCij4Tyz8LIRnM98QObd50N9otg6tamN8jSZxNQQ4Qb9CYQQ
O+7ETPTsJ3xCwnR8gooJybQDJbw=
-----END CERTIFICATE-----', '9022170930c6993faa24b8660ab0e777');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ZA, O=Thawte, CN=Thawte Timestamping CA', 3, 1, 0, '1997-01-01 00:00:00', '2020-12-31 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Durbanville, O=Thawte, OU=Thawte Certification, CN=Thawte Timestamping CA
        Validity
            Not Before: Jan  1 00:00:00 1997 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Durbanville, O=Thawte, OU=Thawte Certification, CN=Thawte Timestamping CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d6:2b:58:78:61:45:86:53:ea:34:7b:51:9c:ed:
                    b0:e6:2e:18:0e:fe:e0:5f:a8:27:d3:b4:c9:e0:7c:
                    59:4e:16:0e:73:54:60:c1:7f:f6:9f:2e:e9:3a:85:
                    24:15:3c:db:47:04:63:c3:9e:c4:94:1a:5a:df:4c:
                    7a:f3:d9:43:1d:3c:10:7a:79:25:db:90:fe:f0:51:
                    e7:30:d6:41:00:fd:9f:28:df:79:be:94:bb:9d:b6:
                    14:e3:23:85:d7:a9:41:e0:4c:a4:79:b0:2b:1a:8b:
                    f2:f8:3b:8a:3e:45:ac:71:92:00:b4:90:41:98:fb:
                    5f:ed:fa:b7:2e:8a:f8:88:37
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        67:db:e2:c2:e6:87:3d:40:83:86:37:35:7d:1f:ce:9a:c3:0c:
        66:20:a8:ba:aa:04:89:86:c2:f5:10:08:0d:bf:cb:a2:05:8a:
        d0:4d:36:3e:f4:d7:ef:69:c6:5e:e4:b0:94:6f:4a:b9:e7:de:
        5b:88:b6:7b:db:e3:27:e5:76:c3:f0:35:c1:cb:b5:27:9b:33:
        79:dc:90:a6:00:9e:77:fa:fc:cd:27:94:42:16:9c:d3:1c:68:
        ec:bf:5c:dd:e5:a9:7b:10:0a:32:74:54:13:31:8b:85:03:84:
        91:b7:58:01:30:14:38:af:28:ca:fc:b1:50:19:19:09:ac:89:
        49:d3', 'D62B587861458653EA347B519CEDB0E62E180EFEE05FA827D3B4C9E07C594E160E735460C17FF69F2EE93A8524153CDB470463C39EC4941A5ADF4C7AF3D9431D3C107A7925DB90FEF051E730D64100FD9F28DF79BE94BB9DB614E32385D7A941E04CA479B02B1A8BF2F83B8A3E45AC719200B4904198FB5FEDFAB72E8AF88837', '/C=ZA/ST=Western Cape/L=Durbanville/O=Thawte/OU=Thawte Certification/CN=Thawte Timestamping CA', 'C=ZA/ST=Western Cape/L=Durbanville/O=Thawte/OU=Thawte Certification/CN=Thawte Timestamping CA', '00', NULL, '-----BEGIN CERTIFICATE-----
MIICoTCCAgqgAwIBAgIBADANBgkqhkiG9w0BAQQFADCBizELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTEUMBIGA1UEBxMLRHVyYmFudmlsbGUxDzAN
BgNVBAoTBlRoYXd0ZTEdMBsGA1UECxMUVGhhd3RlIENlcnRpZmljYXRpb24xHzAd
BgNVBAMTFlRoYXd0ZSBUaW1lc3RhbXBpbmcgQ0EwHhcNOTcwMTAxMDAwMDAwWhcN
MjAxMjMxMjM1OTU5WjCBizELMAkGA1UEBhMCWkExFTATBgNVBAgTDFdlc3Rlcm4g
Q2FwZTEUMBIGA1UEBxMLRHVyYmFudmlsbGUxDzANBgNVBAoTBlRoYXd0ZTEdMBsG
A1UECxMUVGhhd3RlIENlcnRpZmljYXRpb24xHzAdBgNVBAMTFlRoYXd0ZSBUaW1l
c3RhbXBpbmcgQ0EwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBANYrWHhhRYZT
6jR7UZztsOYuGA7+4F+oJ9O0yeB8WU4WDnNUYMF/9p8u6TqFJBU820cEY8OexJQa
Wt9MevPZQx08EHp5JduQ/vBR5zDWQQD9nyjfeb6Uu522FOMjhdepQeBMpHmwKxqL
8vg7ij5FrHGSALSQQZj7X+36ty6K+Ig3AgMBAAGjEzARMA8GA1UdEwEB/wQFMAMB
Af8wDQYJKoZIhvcNAQEEBQADgYEAZ9viwuaHPUCDhjc1fR/OmsMMZiCouqoEiYbC
9RAIDb/LogWK0E02PvTX72nGXuSwlG9KuefeW4i2e9vjJ+V2w/A1wcu1J5szedyQ
pgCed/r8zSeUQhac0xxo7L9c3eWpexAKMnRUEzGLhQOEkbdYATAUOK8oyvyxUBkZ
CayJSdM=
-----END CERTIFICATE-----', '19430e94b36393d001fdd42106adbca3');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ZA, O=Thawte Consulting cc, CN=Thawte Premium Server CA', 3, 1, 0, '1996-08-01 00:00:00', '2020-12-31 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Premium Server CA/emailAddress=premium-server@thawte.com
        Validity
            Not Before: Aug  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Premium Server CA/emailAddress=premium-server@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d2:36:36:6a:8b:d7:c2:5b:9e:da:81:41:62:8f:
                    38:ee:49:04:55:d6:d0:ef:1c:1b:95:16:47:ef:18:
                    48:35:3a:52:f4:2b:6a:06:8f:3b:2f:ea:56:e3:af:
                    86:8d:9e:17:f7:9e:b4:65:75:02:4d:ef:cb:09:a2:
                    21:51:d8:9b:d0:67:d0:ba:0d:92:06:14:73:d4:93:
                    cb:97:2a:00:9c:5c:4e:0c:bc:fa:15:52:fc:f2:44:
                    6e:da:11:4a:6e:08:9f:2f:2d:e3:f9:aa:3a:86:73:
                    b6:46:53:58:c8:89:05:bd:83:11:b8:73:3f:aa:07:
                    8d:f4:42:4d:e7:40:9d:1c:37
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        26:48:2c:16:c2:58:fa:e8:16:74:0c:aa:aa:5f:54:3f:f2:d7:
        c9:78:60:5e:5e:6e:37:63:22:77:36:7e:b2:17:c4:34:b9:f5:
        08:85:fc:c9:01:38:ff:4d:be:f2:16:42:43:e7:bb:5a:46:fb:
        c1:c6:11:1f:f1:4a:b0:28:46:c9:c3:c4:42:7d:bc:fa:ab:59:
        6e:d5:b7:51:88:11:e3:a4:85:19:6b:82:4c:a4:0c:12:ad:e9:
        a4:ae:3f:f1:c3:49:65:9a:8c:c5:c8:3e:25:b7:94:99:bb:92:
        32:71:07:f0:86:5e:ed:50:27:a6:0d:a6:23:f9:bb:cb:a6:07:
        14:42', 'D236366A8BD7C25B9EDA8141628F38EE490455D6D0EF1C1B951647EF1848353A52F42B6A068F3B2FEA56E3AF868D9E17F79EB46575024DEFCB09A22151D89BD067D0BA0D92061473D493CB972A009C5C4E0CBCFA1552FCF2446EDA114A6E089F2F2DE3F9AA3A8673B6465358C88905BD8311B8733FAA078DF4424DE7409D1C37', '/C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting cc/OU=Certification Services Division/CN=Thawte Premium Server CA/emailAddress=premium-server@thawte.com', 'C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting cc/OU=Certification Services Division/CN=Thawte Premium Server CA/emailAddress=premium-server@thawte.com', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIDJzCCApCgAwIBAgIBATANBgkqhkiG9w0BAQQFADCBzjELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMR0wGwYD
VQQKExRUaGF3dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UECxMfQ2VydGlmaWNhdGlv
biBTZXJ2aWNlcyBEaXZpc2lvbjEhMB8GA1UEAxMYVGhhd3RlIFByZW1pdW0gU2Vy
dmVyIENBMSgwJgYJKoZIhvcNAQkBFhlwcmVtaXVtLXNlcnZlckB0aGF3dGUuY29t
MB4XDTk2MDgwMTAwMDAwMFoXDTIwMTIzMTIzNTk1OVowgc4xCzAJBgNVBAYTAlpB
MRUwEwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcTCUNhcGUgVG93bjEdMBsG
A1UEChMUVGhhd3RlIENvbnN1bHRpbmcgY2MxKDAmBgNVBAsTH0NlcnRpZmljYXRp
b24gU2VydmljZXMgRGl2aXNpb24xITAfBgNVBAMTGFRoYXd0ZSBQcmVtaXVtIFNl
cnZlciBDQTEoMCYGCSqGSIb3DQEJARYZcHJlbWl1bS1zZXJ2ZXJAdGhhd3RlLmNv
bTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA0jY2aovXwlue2oFBYo847kkE
VdbQ7xwblRZH7xhINTpS9CtqBo87L+pW46+GjZ4X9560ZXUCTe/LCaIhUdib0GfQ
ug2SBhRz1JPLlyoAnFxODLz6FVL88kRu2hFKbgifLy3j+ao6hnO2RlNYyIkFvYMR
uHM/qgeN9EJN50CdHDcCAwEAAaMTMBEwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG
9w0BAQQFAAOBgQAmSCwWwlj66BZ0DKqqX1Q/8tfJeGBeXm43YyJ3Nn6yF8Q0ufUI
hfzJATj/Tb7yFkJD57taRvvBxhEf8UqwKEbJw8RCfbz6q1lu1bdRiBHjpIUZa4JM
pAwSremkrj/xw0llmozFyD4lt5SZu5IycQfwhl7tUCemDaYj+bvLpgcUQg==
-----END CERTIFICATE-----', '13565a277532df79f7a1f758dba288f1');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ZA, O=Thawte Consulting cc, CN=Thawte Premium Server CA', 3, 1, 0, '1996-08-01 00:00:00', '2021-01-01 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            36:12:22:96:c5:e3:38:a5:20:a1:d2:5f:4c:d7:09:54
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Premium Server CA/emailAddress=premium-server@thawte.com
        Validity
            Not Before: Aug  1 00:00:00 1996 GMT
            Not After : Jan  1 23:59:59 2021 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Premium Server CA/emailAddress=premium-server@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d2:36:36:6a:8b:d7:c2:5b:9e:da:81:41:62:8f:
                    38:ee:49:04:55:d6:d0:ef:1c:1b:95:16:47:ef:18:
                    48:35:3a:52:f4:2b:6a:06:8f:3b:2f:ea:56:e3:af:
                    86:8d:9e:17:f7:9e:b4:65:75:02:4d:ef:cb:09:a2:
                    21:51:d8:9b:d0:67:d0:ba:0d:92:06:14:73:d4:93:
                    cb:97:2a:00:9c:5c:4e:0c:bc:fa:15:52:fc:f2:44:
                    6e:da:11:4a:6e:08:9f:2f:2d:e3:f9:aa:3a:86:73:
                    b6:46:53:58:c8:89:05:bd:83:11:b8:73:3f:aa:07:
                    8d:f4:42:4d:e7:40:9d:1c:37
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        65:90:ac:88:0f:56:d9:e6:30:34:d4:26:c7:d0:50:f1:92:de:
        6b:d4:39:88:09:22:c6:a6:63:83:03:f7:99:77:d8:b2:e5:18:
        b8:5d:63:f3:d4:73:fb:6c:9c:99:78:f1:4b:78:7d:19:24:c3:
        2b:02:84:f8:bc:22:d9:8a:22:d7:a0:fc:71:ec:91:87:20:f1:
        b8:ec:b1:e5:55:80:ac:3d:52:c8:39:0e:c2:f0:c0:05:4f:d6:
        82:75:8c:bd:5f:d2:dc:76:9a:05:12:c9:af:72:c3:dc:25:7e:
        a4:4d:8e:17:a5:e0:87:7f:e1:9a:5a:e1:60:dc:64:23:3c:42:
        2e:4d', 'D236366A8BD7C25B9EDA8141628F38EE490455D6D0EF1C1B951647EF1848353A52F42B6A068F3B2FEA56E3AF868D9E17F79EB46575024DEFCB09A22151D89BD067D0BA0D92061473D493CB972A009C5C4E0CBCFA1552FCF2446EDA114A6E089F2F2DE3F9AA3A8673B6465358C88905BD8311B8733FAA078DF4424DE7409D1C37', '/C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting cc/OU=Certification Services Division/CN=Thawte Premium Server CA/emailAddress=premium-server@thawte.com', 'C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting cc/OU=Certification Services Division/CN=Thawte Premium Server CA/emailAddress=premium-server@thawte.com', '36122296C5E338A520A1D25F4CD70954', NULL, '-----BEGIN CERTIFICATE-----
MIIDNjCCAp+gAwIBAgIQNhIilsXjOKUgodJfTNcJVDANBgkqhkiG9w0BAQUFADCB
zjELMAkGA1UEBhMCWkExFTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJ
Q2FwZSBUb3duMR0wGwYDVQQKExRUaGF3dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UE
CxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjEhMB8GA1UEAxMYVGhh
d3RlIFByZW1pdW0gU2VydmVyIENBMSgwJgYJKoZIhvcNAQkBFhlwcmVtaXVtLXNl
cnZlckB0aGF3dGUuY29tMB4XDTk2MDgwMTAwMDAwMFoXDTIxMDEwMTIzNTk1OVow
gc4xCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcT
CUNhcGUgVG93bjEdMBsGA1UEChMUVGhhd3RlIENvbnN1bHRpbmcgY2MxKDAmBgNV
BAsTH0NlcnRpZmljYXRpb24gU2VydmljZXMgRGl2aXNpb24xITAfBgNVBAMTGFRo
YXd0ZSBQcmVtaXVtIFNlcnZlciBDQTEoMCYGCSqGSIb3DQEJARYZcHJlbWl1bS1z
ZXJ2ZXJAdGhhd3RlLmNvbTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA0jY2
aovXwlue2oFBYo847kkEVdbQ7xwblRZH7xhINTpS9CtqBo87L+pW46+GjZ4X9560
ZXUCTe/LCaIhUdib0GfQug2SBhRz1JPLlyoAnFxODLz6FVL88kRu2hFKbgifLy3j
+ao6hnO2RlNYyIkFvYMRuHM/qgeN9EJN50CdHDcCAwEAAaMTMBEwDwYDVR0TAQH/
BAUwAwEB/zANBgkqhkiG9w0BAQUFAAOBgQBlkKyID1bZ5jA01CbH0FDxkt5r1DmI
CSLGpmODA/eZd9iy5Ri4XWPz1HP7bJyZePFLeH0ZJMMrAoT4vCLZiiLXoPxx7JGH
IPG47LHlVYCsPVLIOQ7C8MAFT9aCdYy9X9LcdpoFEsmvcsPcJX6kTY4XpeCHf+Ga
WuFg3GQjPEIuTQ==
-----END CERTIFICATE-----', '5354f35ffc1779cbe07a025bc2e1a158');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ZA, O=Thawte Consulting cc, CN=Thawte Server CA', 3, 1, 0, '1996-08-01 00:00:00', '2020-12-31 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Server CA/emailAddress=server-certs@thawte.com
        Validity
            Not Before: Aug  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Server CA/emailAddress=server-certs@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d3:a4:50:6e:c8:ff:56:6b:e6:cf:5d:b6:ea:0c:
                    68:75:47:a2:aa:c2:da:84:25:fc:a8:f4:47:51:da:
                    85:b5:20:74:94:86:1e:0f:75:c9:e9:08:61:f5:06:
                    6d:30:6e:15:19:02:e9:52:c0:62:db:4d:99:9e:e2:
                    6a:0c:44:38:cd:fe:be:e3:64:09:70:c5:fe:b1:6b:
                    29:b6:2f:49:c8:3b:d4:27:04:25:10:97:2f:e7:90:
                    6d:c0:28:42:99:d7:4c:43:de:c3:f5:21:6d:54:9f:
                    5d:c3:58:e1:c0:e4:d9:5b:b0:b8:dc:b4:7b:df:36:
                    3a:c2:b5:66:22:12:d6:87:0d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        07:fa:4c:69:5c:fb:95:cc:46:ee:85:83:4d:21:30:8e:ca:d9:
        a8:6f:49:1a:e6:da:51:e3:60:70:6c:84:61:11:a1:1a:c8:48:
        3e:59:43:7d:4f:95:3d:a1:8b:b7:0b:62:98:7a:75:8a:dd:88:
        4e:4e:9e:40:db:a8:cc:32:74:b9:6f:0d:c6:e3:b3:44:0b:d9:
        8a:6f:9a:29:9b:99:18:28:3b:d1:e3:40:28:9a:5a:3c:d5:b5:
        e7:20:1b:8b:ca:a4:ab:8d:e9:51:d9:e2:4c:2c:59:a9:da:b9:
        b2:75:1b:f6:42:f2:ef:c7:f2:18:f9:89:bc:a3:ff:8a:23:2e:
        70:47', 'D3A4506EC8FF566BE6CF5DB6EA0C687547A2AAC2DA8425FCA8F44751DA85B5207494861E0F75C9E90861F5066D306E151902E952C062DB4D999EE26A0C4438CDFEBEE3640970C5FEB16B29B62F49C83BD427042510972FE7906DC0284299D74C43DEC3F5216D549F5DC358E1C0E4D95BB0B8DCB47BDF363AC2B5662212D6870D', '/C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting cc/OU=Certification Services Division/CN=Thawte Server CA/emailAddress=server-certs@thawte.com', 'C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting cc/OU=Certification Services Division/CN=Thawte Server CA/emailAddress=server-certs@thawte.com', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIDEzCCAnygAwIBAgIBATANBgkqhkiG9w0BAQQFADCBxDELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMR0wGwYD
VQQKExRUaGF3dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UECxMfQ2VydGlmaWNhdGlv
biBTZXJ2aWNlcyBEaXZpc2lvbjEZMBcGA1UEAxMQVGhhd3RlIFNlcnZlciBDQTEm
MCQGCSqGSIb3DQEJARYXc2VydmVyLWNlcnRzQHRoYXd0ZS5jb20wHhcNOTYwODAx
MDAwMDAwWhcNMjAxMjMxMjM1OTU5WjCBxDELMAkGA1UEBhMCWkExFTATBgNVBAgT
DFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMR0wGwYDVQQKExRUaGF3
dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNl
cyBEaXZpc2lvbjEZMBcGA1UEAxMQVGhhd3RlIFNlcnZlciBDQTEmMCQGCSqGSIb3
DQEJARYXc2VydmVyLWNlcnRzQHRoYXd0ZS5jb20wgZ8wDQYJKoZIhvcNAQEBBQAD
gY0AMIGJAoGBANOkUG7I/1Zr5s9dtuoMaHVHoqrC2oQl/Kj0R1HahbUgdJSGHg91
yekIYfUGbTBuFRkC6VLAYttNmZ7iagxEOM3+vuNkCXDF/rFrKbYvScg71CcEJRCX
L+eQbcAoQpnXTEPew/UhbVSfXcNY4cDk2VuwuNy0e982OsK1ZiIS1ocNAgMBAAGj
EzARMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEEBQADgYEAB/pMaVz7lcxG
7oWDTSEwjsrZqG9JGubaUeNgcGyEYRGhGshIPllDfU+VPaGLtwtimHp1it2ITk6e
QNuozDJ0uW8NxuOzRAvZim+aKZuZGCg70eNAKJpaPNW15yAbi8qkq43pUdniTCxZ
qdq5snUb9kLy78fyGPmJvKP/iiMucEc=
-----END CERTIFICATE-----', '9dbedb7e623a515178b57c7e53248c7c');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ZA, O=Thawte Consulting cc, CN=Thawte Server CA', 3, 1, 0, '1996-08-01 00:00:00', '2021-01-01 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            34:a4:ff:f6:30:af:4c:a5:3c:33:17:42:a1:94:66:75
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Server CA/emailAddress=server-certs@thawte.com
        Validity
            Not Before: Aug  1 00:00:00 1996 GMT
            Not After : Jan  1 23:59:59 2021 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Server CA/emailAddress=server-certs@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d3:a4:50:6e:c8:ff:56:6b:e6:cf:5d:b6:ea:0c:
                    68:75:47:a2:aa:c2:da:84:25:fc:a8:f4:47:51:da:
                    85:b5:20:74:94:86:1e:0f:75:c9:e9:08:61:f5:06:
                    6d:30:6e:15:19:02:e9:52:c0:62:db:4d:99:9e:e2:
                    6a:0c:44:38:cd:fe:be:e3:64:09:70:c5:fe:b1:6b:
                    29:b6:2f:49:c8:3b:d4:27:04:25:10:97:2f:e7:90:
                    6d:c0:28:42:99:d7:4c:43:de:c3:f5:21:6d:54:9f:
                    5d:c3:58:e1:c0:e4:d9:5b:b0:b8:dc:b4:7b:df:36:
                    3a:c2:b5:66:22:12:d6:87:0d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        be:40:69:41:6f:c6:db:c1:a7:bf:07:c0:45:e4:d0:b5:43:1e:
        4c:95:33:35:e9:5e:c2:3e:28:f6:a8:0d:50:d5:ff:e2:0c:0f:
        fc:50:02:8e:ae:91:b9:ad:34:8a:8d:9f:27:71:aa:19:cc:4b:
        e8:04:ca:d4:17:6b:12:1a:d6:c6:5f:d6:cd:5e:ff:89:76:bf:
        d8:48:d8:59:bd:08:8a:89:1d:57:cd:45:1e:52:ba:12:9a:84:
        fa:18:89:5f:e8:f9:30:35:6a:01:60:b9:99:80:83:85:0a:6e:
        da:f4:c9:8f:5e:73:2d:31:4a:63:a0:74:f2:1f:8b:22:d2:29:
        3e:eb', 'D3A4506EC8FF566BE6CF5DB6EA0C687547A2AAC2DA8425FCA8F44751DA85B5207494861E0F75C9E90861F5066D306E151902E952C062DB4D999EE26A0C4438CDFEBEE3640970C5FEB16B29B62F49C83BD427042510972FE7906DC0284299D74C43DEC3F5216D549F5DC358E1C0E4D95BB0B8DCB47BDF363AC2B5662212D6870D', '/C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting cc/OU=Certification Services Division/CN=Thawte Server CA/emailAddress=server-certs@thawte.com', 'C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting cc/OU=Certification Services Division/CN=Thawte Server CA/emailAddress=server-certs@thawte.com', '34A4FFF630AF4CA53C331742A1946675', NULL, '-----BEGIN CERTIFICATE-----
MIIDIjCCAougAwIBAgIQNKT/9jCvTKU8MxdCoZRmdTANBgkqhkiG9w0BAQUFADCB
xDELMAkGA1UEBhMCWkExFTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJ
Q2FwZSBUb3duMR0wGwYDVQQKExRUaGF3dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UE
CxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjEZMBcGA1UEAxMQVGhh
d3RlIFNlcnZlciBDQTEmMCQGCSqGSIb3DQEJARYXc2VydmVyLWNlcnRzQHRoYXd0
ZS5jb20wHhcNOTYwODAxMDAwMDAwWhcNMjEwMTAxMjM1OTU5WjCBxDELMAkGA1UE
BhMCWkExFTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3du
MR0wGwYDVQQKExRUaGF3dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UECxMfQ2VydGlm
aWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjEZMBcGA1UEAxMQVGhhd3RlIFNlcnZl
ciBDQTEmMCQGCSqGSIb3DQEJARYXc2VydmVyLWNlcnRzQHRoYXd0ZS5jb20wgZ8w
DQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBANOkUG7I/1Zr5s9dtuoMaHVHoqrC2oQl
/Kj0R1HahbUgdJSGHg91yekIYfUGbTBuFRkC6VLAYttNmZ7iagxEOM3+vuNkCXDF
/rFrKbYvScg71CcEJRCXL+eQbcAoQpnXTEPew/UhbVSfXcNY4cDk2VuwuNy0e982
OsK1ZiIS1ocNAgMBAAGjEzARMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEF
BQADgYEAvkBpQW/G28GnvwfAReTQtUMeTJUzNelewj4o9qgNUNX/4gwP/FACjq6R
ua00io2fJ3GqGcxL6ATK1BdrEhrWxl/WzV7/iXa/2EjYWb0IiokdV81FHlK6EpqE
+hiJX+j5MDVqAWC5mYCDhQpu2vTJj15zLTFKY6B08h+LItIpPus=
-----END CERTIFICATE-----', '8b029308674daec138ae2860527f275e');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ZA, O=Thawte Consulting, CN=Thawte Personal Basic CA', 3, 1, 0, '1996-01-01 00:00:00', '2020-12-31 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Basic CA/emailAddress=personal-basic@thawte.com
        Validity
            Not Before: Jan  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Basic CA/emailAddress=personal-basic@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:bc:bc:93:53:6d:c0:50:4f:82:15:e6:48:94:35:
                    a6:5a:be:6f:42:fa:0f:47:ee:77:75:72:dd:8d:49:
                    9b:96:57:a0:78:d4:ca:3f:51:b3:69:0b:91:76:17:
                    22:07:97:6a:c4:51:93:4b:e0:8d:ef:37:95:a1:0c:
                    4d:da:34:90:1d:17:89:97:e0:35:38:57:4a:c0:f4:
                    08:70:e9:3c:44:7b:50:7e:61:9a:90:e3:23:d3:88:
                    11:46:27:f5:0b:07:0e:bb:dd:d1:7f:20:0a:88:b9:
                    56:0b:2e:1c:80:da:f1:e3:9e:29:ef:14:bd:0a:44:
                    fb:1b:5b:18:d1:bf:23:93:21
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        2d:e2:99:6b:b0:3d:7a:89:d7:59:a2:94:01:1f:2b:dd:12:4b:
        53:c2:ad:7f:aa:a7:00:5c:91:40:57:25:4a:38:aa:84:70:b9:
        d9:80:0f:a5:7b:5c:fb:73:c6:bd:d7:8a:61:5c:03:e3:2d:27:
        a8:17:e0:84:85:42:dc:5e:9b:c6:b7:b2:6d:bb:74:af:e4:3f:
        cb:a7:b7:b0:e0:5d:be:78:83:25:94:d2:db:81:0f:79:07:6d:
        4f:f4:39:15:5a:52:01:7b:de:32:d6:4d:38:f6:12:5c:06:50:
        df:05:5b:bd:14:4b:a1:df:29:ba:3b:41:8d:f7:63:56:a1:df:
        22:b1', 'BCBC93536DC0504F8215E6489435A65ABE6F42FA0F47EE777572DD8D499B9657A078D4CA3F51B3690B9176172207976AC451934BE08DEF3795A10C4DDA34901D178997E03538574AC0F40870E93C447B507E619A90E323D388114627F50B070EBBDDD17F200A88B9560B2E1C80DAF1E39E29EF14BD0A44FB1B5B18D1BF239321', '/C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting/OU=Certification Services Division/CN=Thawte Personal Basic CA/emailAddress=personal-basic@thawte.com', 'C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting/OU=Certification Services Division/CN=Thawte Personal Basic CA/emailAddress=personal-basic@thawte.com', '00', NULL, '-----BEGIN CERTIFICATE-----
MIIDITCCAoqgAwIBAgIBADANBgkqhkiG9w0BAQQFADCByzELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMRowGAYD
VQQKExFUaGF3dGUgQ29uc3VsdGluZzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBT
ZXJ2aWNlcyBEaXZpc2lvbjEhMB8GA1UEAxMYVGhhd3RlIFBlcnNvbmFsIEJhc2lj
IENBMSgwJgYJKoZIhvcNAQkBFhlwZXJzb25hbC1iYXNpY0B0aGF3dGUuY29tMB4X
DTk2MDEwMTAwMDAwMFoXDTIwMTIzMTIzNTk1OVowgcsxCzAJBgNVBAYTAlpBMRUw
EwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcTCUNhcGUgVG93bjEaMBgGA1UE
ChMRVGhhd3RlIENvbnN1bHRpbmcxKDAmBgNVBAsTH0NlcnRpZmljYXRpb24gU2Vy
dmljZXMgRGl2aXNpb24xITAfBgNVBAMTGFRoYXd0ZSBQZXJzb25hbCBCYXNpYyBD
QTEoMCYGCSqGSIb3DQEJARYZcGVyc29uYWwtYmFzaWNAdGhhd3RlLmNvbTCBnzAN
BgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEAvLyTU23AUE+CFeZIlDWmWr5vQvoPR+53
dXLdjUmbllegeNTKP1GzaQuRdhciB5dqxFGTS+CN7zeVoQxN2jSQHReJl+A1OFdK
wPQIcOk8RHtQfmGakOMj04gRRif1CwcOu93RfyAKiLlWCy4cgNrx454p7xS9CkT7
G1sY0b8jkyECAwEAAaMTMBEwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQQF
AAOBgQAt4plrsD16iddZopQBHyvdEktTwq1/qqcAXJFAVyVKOKqEcLnZgA+le1z7
c8a914phXAPjLSeoF+CEhULcXpvGt7Jtu3Sv5D/Lp7ew4F2+eIMllNLbgQ95B21P
9DkVWlIBe94y1k049hJcBlDfBVu9FEuh3ym6O0GN92NWod8isQ==
-----END CERTIFICATE-----', '9010b0cbf289ffdec7e0a2489e53c92f');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ZA, O=Thawte Consulting, CN=Thawte Personal Freemail CA', 3, 1, 0, '1996-01-01 00:00:00', '2020-12-31 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Freemail CA/emailAddress=personal-freemail@thawte.com
        Validity
            Not Before: Jan  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Freemail CA/emailAddress=personal-freemail@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d4:69:d7:d4:b0:94:64:5b:71:e9:47:d8:0c:51:
                    b6:ea:72:91:b0:84:5e:7d:2d:0d:8f:7b:12:df:85:
                    25:75:28:74:3a:42:2c:63:27:9f:95:7b:4b:ef:7e:
                    19:87:1d:86:ea:a3:dd:b9:ce:96:64:1a:c2:14:6e:
                    44:ac:7c:e6:8f:e8:4d:0f:71:1f:40:38:a6:00:a3:
                    87:78:f6:f9:94:86:5e:ad:ea:c0:5e:76:eb:d9:14:
                    a3:5d:6e:7a:7c:0c:a5:4b:55:7f:06:19:29:7f:9e:
                    9a:26:d5:6a:bb:38:24:08:6a:98:c7:b1:da:a3:98:
                    91:fd:79:db:e5:5a:c4:1c:b9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        c7:ec:92:7e:4e:f8:f5:96:a5:67:62:2a:a4:f0:4d:11:60:d0:
        6f:8d:60:58:61:ac:26:bb:52:35:5c:08:cf:30:fb:a8:4a:96:
        8a:1f:62:42:23:8c:17:0f:f4:ba:64:9c:17:ac:47:29:df:9d:
        98:5e:d2:6c:60:71:5c:a2:ac:dc:79:e3:e7:6e:00:47:1f:b5:
        0d:28:e8:02:9d:e4:9a:fd:13:f4:a6:d9:7c:b1:f8:dc:5f:23:
        26:09:91:80:73:d0:14:1b:de:43:a9:83:25:f2:e6:9c:2f:15:
        ca:fe:a6:ab:8a:07:75:8b:0c:dd:51:84:6b:e4:f8:d1:ce:77:
        a2:81', 'D469D7D4B094645B71E947D80C51B6EA7291B0845E7D2D0D8F7B12DF85257528743A422C63279F957B4BEF7E19871D86EAA3DDB9CE96641AC2146E44AC7CE68FE84D0F711F4038A600A38778F6F994865EADEAC05E76EBD914A35D6E7A7C0CA54B557F0619297F9E9A26D56ABB3824086A98C7B1DAA39891FD79DBE55AC41CB9', '/C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting/OU=Certification Services Division/CN=Thawte Personal Freemail CA/emailAddress=personal-freemail@thawte.com', 'C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting/OU=Certification Services Division/CN=Thawte Personal Freemail CA/emailAddress=personal-freemail@thawte.com', '00', NULL, '-----BEGIN CERTIFICATE-----
MIIDLTCCApagAwIBAgIBADANBgkqhkiG9w0BAQQFADCB0TELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMRowGAYD
VQQKExFUaGF3dGUgQ29uc3VsdGluZzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBT
ZXJ2aWNlcyBEaXZpc2lvbjEkMCIGA1UEAxMbVGhhd3RlIFBlcnNvbmFsIEZyZWVt
YWlsIENBMSswKQYJKoZIhvcNAQkBFhxwZXJzb25hbC1mcmVlbWFpbEB0aGF3dGUu
Y29tMB4XDTk2MDEwMTAwMDAwMFoXDTIwMTIzMTIzNTk1OVowgdExCzAJBgNVBAYT
AlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcTCUNhcGUgVG93bjEa
MBgGA1UEChMRVGhhd3RlIENvbnN1bHRpbmcxKDAmBgNVBAsTH0NlcnRpZmljYXRp
b24gU2VydmljZXMgRGl2aXNpb24xJDAiBgNVBAMTG1RoYXd0ZSBQZXJzb25hbCBG
cmVlbWFpbCBDQTErMCkGCSqGSIb3DQEJARYccGVyc29uYWwtZnJlZW1haWxAdGhh
d3RlLmNvbTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA1GnX1LCUZFtx6UfY
DFG26nKRsIRefS0Nj3sS34UldSh0OkIsYyeflXtL734Zhx2G6qPduc6WZBrCFG5E
rHzmj+hND3EfQDimAKOHePb5lIZererAXnbr2RSjXW56fAylS1V/Bhkpf56aJtVq
uzgkCGqYx7Hao5iR/Xnb5VrEHLkCAwEAAaMTMBEwDwYDVR0TAQH/BAUwAwEB/zAN
BgkqhkiG9w0BAQQFAAOBgQDH7JJ+Tvj1lqVnYiqk8E0RYNBvjWBYYawmu1I1XAjP
MPuoSpaKH2JCI4wXD/S6ZJwXrEcp352YXtJsYHFcoqzceePnbgBHH7UNKOgCneSa
/RP0ptl8sfjcXyMmCZGAc9AUG95DqYMl8uacLxXK/qarigd1iwzdUYRr5PjRznei
gQ==
-----END CERTIFICATE-----', '035442d140e3c0a9607eb66b3a9de029');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=ZA, O=Thawte Consulting, CN=Thawte Personal Premium CA', 3, 1, 0, '1996-01-01 00:00:00', '2020-12-31 23:59:59', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Premium CA/emailAddress=personal-premium@thawte.com
        Validity
            Not Before: Jan  1 00:00:00 1996 GMT
            Not After : Dec 31 23:59:59 2020 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting, OU=Certification Services Division, CN=Thawte Personal Premium CA/emailAddress=personal-premium@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c9:66:d9:f8:07:44:cf:b9:8c:2e:f0:a1:ef:13:
                    45:6c:05:df:de:27:16:51:36:41:11:6c:6c:3b:ed:
                    fe:10:7d:12:9e:e5:9b:42:9a:fe:60:31:c3:66:b7:
                    73:3a:48:ae:4e:d0:32:37:94:88:b5:0d:b6:d9:f3:
                    f2:44:d9:d5:88:12:dd:76:4d:f2:1a:fc:6f:23:1e:
                    7a:f1:d8:98:45:4e:07:10:ef:16:42:d0:43:75:6d:
                    4a:de:e2:aa:c9:31:ff:1f:00:70:7c:66:cf:10:25:
                    08:ba:fa:ee:00:e9:46:03:66:27:11:15:3b:aa:5b:
                    f2:98:dd:36:42:b2:da:88:75
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: md5WithRSAEncryption
        69:36:89:f7:34:2a:33:72:2f:6d:3b:d4:22:b2:b8:6f:9a:c5:
        36:66:0e:1b:3c:a1:b1:75:5a:e6:fd:35:d3:f8:a8:f2:07:6f:
        85:67:8e:de:2b:b9:e2:17:b0:3a:a0:f0:0e:a2:00:9a:df:f3:
        14:15:6e:bb:c8:85:5a:98:80:f9:ff:be:74:1d:3d:f3:fe:30:
        25:d1:37:34:67:fa:a5:71:79:30:61:29:72:c0:e0:2c:4c:fb:
        56:e4:3a:a8:6f:e5:32:59:52:db:75:28:50:59:0c:f8:0b:19:
        e4:ac:d9:af:96:8d:2f:50:db:07:c3:ea:1f:ab:33:e0:f5:2b:
        31:89', 'C966D9F80744CFB98C2EF0A1EF13456C05DFDE2716513641116C6C3BEDFE107D129EE59B429AFE6031C366B7733A48AE4ED032379488B50DB6D9F3F244D9D58812DD764DF21AFC6F231E7AF1D898454E0710EF1642D043756D4ADEE2AAC931FF1F00707C66CF102508BAFAEE00E94603662711153BAA5BF298DD3642B2DA8875', '/C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting/OU=Certification Services Division/CN=Thawte Personal Premium CA/emailAddress=personal-premium@thawte.com', 'C=ZA/ST=Western Cape/L=Cape Town/O=Thawte Consulting/OU=Certification Services Division/CN=Thawte Personal Premium CA/emailAddress=personal-premium@thawte.com', '00', NULL, '-----BEGIN CERTIFICATE-----
MIIDKTCCApKgAwIBAgIBADANBgkqhkiG9w0BAQQFADCBzzELMAkGA1UEBhMCWkEx
FTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJQ2FwZSBUb3duMRowGAYD
VQQKExFUaGF3dGUgQ29uc3VsdGluZzEoMCYGA1UECxMfQ2VydGlmaWNhdGlvbiBT
ZXJ2aWNlcyBEaXZpc2lvbjEjMCEGA1UEAxMaVGhhd3RlIFBlcnNvbmFsIFByZW1p
dW0gQ0ExKjAoBgkqhkiG9w0BCQEWG3BlcnNvbmFsLXByZW1pdW1AdGhhd3RlLmNv
bTAeFw05NjAxMDEwMDAwMDBaFw0yMDEyMzEyMzU5NTlaMIHPMQswCQYDVQQGEwJa
QTEVMBMGA1UECBMMV2VzdGVybiBDYXBlMRIwEAYDVQQHEwlDYXBlIFRvd24xGjAY
BgNVBAoTEVRoYXd0ZSBDb25zdWx0aW5nMSgwJgYDVQQLEx9DZXJ0aWZpY2F0aW9u
IFNlcnZpY2VzIERpdmlzaW9uMSMwIQYDVQQDExpUaGF3dGUgUGVyc29uYWwgUHJl
bWl1bSBDQTEqMCgGCSqGSIb3DQEJARYbcGVyc29uYWwtcHJlbWl1bUB0aGF3dGUu
Y29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJZtn4B0TPuYwu8KHvE0Vs
Bd/eJxZRNkERbGw77f4QfRKe5ZtCmv5gMcNmt3M6SK5O0DI3lIi1DbbZ8/JE2dWI
Et12TfIa/G8jHnrx2JhFTgcQ7xZC0EN1bUre4qrJMf8fAHB8Zs8QJQi6+u4A6UYD
ZicRFTuqW/KY3TZCstqIdQIDAQABoxMwETAPBgNVHRMBAf8EBTADAQH/MA0GCSqG
SIb3DQEBBAUAA4GBAGk2ifc0KjNyL2071CKyuG+axTZmDhs8obF1Wub9NdP4qPIH
b4Vnjt4rueIXsDqg8A6iAJrf8xQVbrvIhVqYgPn/vnQdPfP+MCXRNzRn+qVxeTBh
KXLA4CxM+1bkOqhv5TJZUtt1KFBZDPgLGeSs2a+WjS9Q2wfD6h+rM+D1KzGJ
-----END CERTIFICATE-----', 'a21650238ccc34d012c845fca5031c4b');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=beTRUSTed, CN=beTRUSTed Root CA-Baltimore Implementation', 3, 1, 0, '2002-04-11 07:38:51', '2022-04-11 07:38:51', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1018510662 (0x3cb53d46)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=beTRUSTed, OU=beTRUSTed Root CAs, CN=beTRUSTed Root CA-Baltimore Implementation
        Validity
            Not Before: Apr 11 07:38:51 2002 GMT
            Not After : Apr 11 07:38:51 2022 GMT
        Subject: O=beTRUSTed, OU=beTRUSTed Root CAs, CN=beTRUSTed Root CA-Baltimore Implementation
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:bc:7e:c4:39:9c:8c:e3:d6:1c:86:ff:ca:62:ad:
                    e0:7f:30:45:7a:8e:1a:b3:b8:c7:f9:d1:36:ff:22:
                    f3:4e:6a:5f:84:10:fb:66:81:c3:94:79:31:d2:91:
                    e1:77:8e:18:2a:c3:14:de:51:f5:4f:a3:2b:bc:18:
                    16:e2:b5:dd:79:de:22:f8:82:7e:cb:81:1f:fd:27:
                    2c:8f:fa:97:64:22:8e:f8:ff:61:a3:9c:1b:1e:92:
                    8f:c0:a8:09:df:09:11:ec:b7:7d:31:9a:1a:ea:83:
                    21:06:3c:9f:ba:5c:ff:94:ea:6a:b8:c3:6b:55:34:
                    4f:3d:32:1f:dd:81:14:e0:c4:3c:cd:9d:30:f8:30:
                    a9:97:d3:ee:cc:a3:d0:1f:5f:1c:13:81:d4:18:ab:
                    94:d1:63:c3:9e:7f:35:92:9e:5f:44:ea:ec:f4:22:
                    5c:b7:e8:3d:7d:a4:f9:89:a9:91:b2:2a:d9:eb:33:
                    87:ee:a5:fd:e3:da:cc:88:e6:89:26:6e:c7:2b:82:
                    d0:5e:9d:59:db:14:ec:91:83:05:c3:5e:0e:c6:2a:
                    d0:04:dd:71:3d:20:4e:58:27:fc:53:fb:78:78:19:
                    14:b2:fc:90:52:89:38:62:60:07:b4:a0:ec:ac:6b:
                    50:d6:fd:b9:28:6b:ef:52:2d:3a:b2:ff:f1:01:40:
                    ac:37
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Certificate Policies: 
                Policy: 1.3.6.1.4.1.6334.0.0.1.9.40.51377
                  User Notice:
                    Explicit Text: Reliance on or use of this Certificate creates an acknowledgment and acceptance of the then applicable standard terms and conditions of use, the Certification Practice Statement and the Relying Party Agreement, which can be found at the beTRUSTed web site, http://www.betrusted.com/products_services/index.html
                  CPS: http://www.betrusted.com/products_services/index.html

            X509v3 Subject Key Identifier: 
                45:3D:C3:A9:D1:DC:3F:24:56:98:1C:73:18:88:6A:FF:83:47:ED:B6
            X509v3 Authority Key Identifier: 
                keyid:45:3D:C3:A9:D1:DC:3F:24:56:98:1C:73:18:88:6A:FF:83:47:ED:B6

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        49:92:bc:a3:ee:ac:bd:fa:0d:c9:8b:79:86:1c:23:76:b0:80:
        59:77:fc:da:7f:b4:4b:df:c3:64:4b:6a:4e:0e:ad:f2:7d:59:
        77:05:ad:0a:89:73:b0:fa:bc:cb:dc:8d:00:88:8f:a6:a0:b2:
        ea:ac:52:27:bf:a1:48:7c:97:10:7b:ba:ed:13:1d:9a:07:6e:
        cb:31:62:12:e8:63:03:aa:7d:6d:e3:f8:1b:76:21:78:1b:9f:
        4b:43:8c:d3:49:86:f6:1b:5c:f6:2e:60:15:d3:e9:e3:7b:75:
        3f:d0:02:83:d0:18:82:41:cd:65:37:ea:8e:32:7e:bd:6b:99:
        5d:30:11:c8:db:48:54:1c:3b:e1:a7:13:d3:6a:48:93:f7:3d:
        8c:7f:05:e8:ce:f3:88:2a:63:04:b8:ea:7e:58:7c:01:7b:5b:
        e1:c5:7d:ef:21:e0:8d:0e:5d:51:7d:b1:67:fd:a3:bd:38:36:
        c6:f2:38:86:87:1a:96:68:60:46:fb:28:14:47:55:e1:a7:80:
        0c:6b:e2:ea:df:4d:7c:90:48:a0:36:bd:09:17:89:7f:c3:f2:
        d3:9c:9c:e3:dd:c4:1b:dd:f5:b7:71:b3:53:05:89:06:d0:cb:
        4a:80:c1:c8:53:90:b5:3c:31:88:17:50:9f:c9:c4:0e:8b:d8:
        a8:02:63:0d', 'BC7EC4399C8CE3D61C86FFCA62ADE07F30457A8E1AB3B8C7F9D136FF22F34E6A5F8410FB6681C3947931D291E1778E182AC314DE51F54FA32BBC1816E2B5DD79DE22F8827ECB811FFD272C8FFA9764228EF8FF61A39C1B1E928FC0A809DF0911ECB77D319A1AEA8321063C9FBA5CFF94EA6AB8C36B55344F3D321FDD8114E0C43CCD9D30F830A997D3EECCA3D01F5F1C1381D418AB94D163C39E7F35929E5F44EAECF4225CB7E83D7DA4F989A991B22AD9EB3387EEA5FDE3DACC88E689266EC72B82D05E9D59DB14EC918305C35E0EC62AD004DD713D204E5827FC53FB78781914B2FC90528938626007B4A0ECAC6B50D6FDB9286BEF522D3AB2FFF10140AC37', '/O=beTRUSTed/OU=beTRUSTed Root CAs/CN=beTRUSTed Root CA-Baltimore Implementation', 'O=beTRUSTed/OU=beTRUSTed Root CAs/CN=beTRUSTed Root CA-Baltimore Implementation', '3CB53D46', NULL, '-----BEGIN CERTIFICATE-----
MIIFajCCBFKgAwIBAgIEPLU9RjANBgkqhkiG9w0BAQUFADBmMRIwEAYDVQQKEwli
ZVRSVVNUZWQxGzAZBgNVBAsTEmJlVFJVU1RlZCBSb290IENBczEzMDEGA1UEAxMq
YmVUUlVTVGVkIFJvb3QgQ0EtQmFsdGltb3JlIEltcGxlbWVudGF0aW9uMB4XDTAy
MDQxMTA3Mzg1MVoXDTIyMDQxMTA3Mzg1MVowZjESMBAGA1UEChMJYmVUUlVTVGVk
MRswGQYDVQQLExJiZVRSVVNUZWQgUm9vdCBDQXMxMzAxBgNVBAMTKmJlVFJVU1Rl
ZCBSb290IENBLUJhbHRpbW9yZSBJbXBsZW1lbnRhdGlvbjCCASIwDQYJKoZIhvcN
AQEBBQADggEPADCCAQoCggEBALx+xDmcjOPWHIb/ymKt4H8wRXqOGrO4x/nRNv8i
805qX4QQ+2aBw5R5MdKR4XeOGCrDFN5R9U+jK7wYFuK13XneIviCfsuBH/0nLI/6
l2Qijvj/YaOcGx6Sj8CoCd8JEey3fTGaGuqDIQY8n7pc/5TqarjDa1U0Tz0yH92B
FODEPM2dMPgwqZfT7syj0B9fHBOB1BirlNFjw55/NZKeX0Tq7PQiXLfoPX2k+Ymp
kbIq2eszh+6l/ePazIjmiSZuxyuC0F6dWdsU7JGDBcNeDsYq0ATdcT0gTlgn/FP7
eHgZFLL8kFKJOGJgB7Sg7KxrUNb9uShr71ItOrL/8QFArDcCAwEAAaOCAh4wggIa
MA8GA1UdEwEB/wQFMAMBAf8wggG1BgNVHSAEggGsMIIBqDCCAaQGDysGAQQBsT4A
AAEJKIORMTCCAY8wggFIBggrBgEFBQcCAjCCAToaggE2UmVsaWFuY2Ugb24gb3Ig
dXNlIG9mIHRoaXMgQ2VydGlmaWNhdGUgY3JlYXRlcyBhbiBhY2tub3dsZWRnbWVu
dCBhbmQgYWNjZXB0YW5jZSBvZiB0aGUgdGhlbiBhcHBsaWNhYmxlIHN0YW5kYXJk
IHRlcm1zIGFuZCBjb25kaXRpb25zIG9mIHVzZSwgdGhlIENlcnRpZmljYXRpb24g
UHJhY3RpY2UgU3RhdGVtZW50IGFuZCB0aGUgUmVseWluZyBQYXJ0eSBBZ3JlZW1l
bnQsIHdoaWNoIGNhbiBiZSBmb3VuZCBhdCB0aGUgYmVUUlVTVGVkIHdlYiBzaXRl
LCBodHRwOi8vd3d3LmJldHJ1c3RlZC5jb20vcHJvZHVjdHNfc2VydmljZXMvaW5k
ZXguaHRtbDBBBggrBgEFBQcCARY1aHR0cDovL3d3dy5iZXRydXN0ZWQuY29tL3By
b2R1Y3RzX3NlcnZpY2VzL2luZGV4Lmh0bWwwHQYDVR0OBBYEFEU9w6nR3D8kVpgc
cxiIav+DR+22MB8GA1UdIwQYMBaAFEU9w6nR3D8kVpgccxiIav+DR+22MA4GA1Ud
DwEB/wQEAwIBBjANBgkqhkiG9w0BAQUFAAOCAQEASZK8o+6svfoNyYt5hhwjdrCA
WXf82n+0S9/DZEtqTg6t8n1ZdwWtColzsPq8y9yNAIiPpqCy6qxSJ7+hSHyXEHu6
7RMdmgduyzFiEuhjA6p9beP4G3YheBufS0OM00mG9htc9i5gFdPp43t1P9ACg9AY
gkHNZTfqjjJ+vWuZXTARyNtIVBw74acT02pIk/c9jH8F6M7ziCpjBLjqflh8AXtb
4cV97yHgjQ5dUX2xZ/2jvTg2xvI4hocalmhgRvsoFEdV4aeADGvi6t9NfJBIoDa9
CReJf8Py05yc493EG931t3GzUwWJBtDLSoDByFOQtTwxiBdQn8nEDovYqAJjDQ==
-----END CERTIFICATE-----', '0992519d96a1f9b297a7dde8c2e37a86');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=beTRUSTed, CN=beTRUSTed Root CA - Entrust Implementation', 3, 1, 0, '2002-04-11 08:24:27', '2022-04-11 08:54:27', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1018515264 (0x3cb54f40)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=beTRUSTed, OU=beTRUSTed Root CAs, CN=beTRUSTed Root CA - Entrust Implementation
        Validity
            Not Before: Apr 11 08:24:27 2002 GMT
            Not After : Apr 11 08:54:27 2022 GMT
        Subject: O=beTRUSTed, OU=beTRUSTed Root CAs, CN=beTRUSTed Root CA - Entrust Implementation
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ba:f4:44:03:aa:12:6a:b5:43:ec:55:92:b6:30:
                    7d:35:57:0c:db:f3:0d:27:6e:4c:f7:50:a8:9b:4e:
                    2b:6f:db:f5:ad:1c:4b:5d:b3:a9:c1:fe:7b:44:eb:
                    5b:a3:05:0d:1f:c5:34:2b:30:00:29:f1:78:40:b2:
                    a4:ff:3a:f4:01:88:17:7e:e6:d4:26:d3:ba:4c:ea:
                    32:fb:43:77:97:87:23:c5:db:43:a3:f5:2a:a3:51:
                    5e:e1:3b:d2:65:69:7e:55:15:9b:7a:e7:69:f7:44:
                    e0:57:b5:15:e8:66:60:0f:0d:03:fb:82:8e:a3:e8:
                    11:7b:6c:be:c7:63:0e:17:93:df:cf:4b:ae:6e:73:
                    75:e0:f3:aa:b9:a4:c0:09:1b:85:ea:71:29:88:41:
                    32:f9:f0:2a:0e:6c:09:f2:74:6b:66:6c:52:13:1f:
                    18:bc:d4:3e:f7:d8:6e:20:9e:ca:fe:fc:21:94:ee:
                    13:28:4b:d7:5c:5e:0c:66:ee:e9:bb:0f:c1:34:b1:
                    7f:08:76:f3:3d:26:70:c9:8b:25:1d:62:24:0c:ea:
                    1c:75:4e:c0:12:e4:ba:13:1d:30:29:2d:56:33:05:
                    bb:97:59:7e:c6:49:4f:89:d7:2f:24:a8:b6:88:40:
                    b5:64:92:53:56:24:e4:a2:a0:85:b3:5e:90:b4:12:
                    33:cd
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Certificate Policies: 
                Policy: 1.3.6.1.4.1.6334.0.0.2.9.40.51377
                  User Notice:
                    Explicit Text: Reliance on or use of this Certificate creates an acknowledgment and acceptance of the then applicable standard terms and conditions of use, the Certification Practice Statement and the Relying Party Agreement, which can be found at the beTRUSTed web site, https://www.betrusted.com/products_services/index.html
                  CPS: https://www.betrusted.com/products_services/index.html

            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 CRL Distribution Points: 
                DirName:/O=beTRUSTed/OU=beTRUSTed Root CAs/CN=beTRUSTed Root CA - Entrust Implementation/CN=CRL1

            X509v3 Private Key Usage Period: 
                Not Before: Apr 11 08:24:27 2002 GMT, Not After: Apr 11 08:54:27 2022 GMT
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
                keyid:7D:70:E5:AE:38:8B:06:3F:AA:1C:1A:8F:F9:CF:24:30:AA:84:84:16

            X509v3 Subject Key Identifier: 
                7D:70:E5:AE:38:8B:06:3F:AA:1C:1A:8F:F9:CF:24:30:AA:84:84:16
            X509v3 Basic Constraints: 
                CA:TRUE
            1.2.840.113533.7.65.0: 
                0...V6.0:4.0....
    Signature Algorithm: sha1WithRSAEncryption
        2a:b8:17:ce:1f:10:94:eb:b8:9a:b7:b9:5f:ec:da:f7:92:24:
        ac:dc:92:3b:c7:20:8d:f2:99:e5:5d:38:a1:c2:34:ed:c5:13:
        59:5c:05:b5:2b:4f:61:9b:91:fb:41:fc:fc:d5:3c:4d:98:76:
        06:f5:81:7d:eb:dd:90:e6:d1:56:54:da:e3:2d:0c:9f:11:32:
        94:22:01:7a:f6:6c:2c:74:67:04:cc:a5:8f:8e:2c:b3:43:b5:
        94:a2:d0:7d:e9:62:7f:06:be:27:01:83:9e:3a:fd:8a:ee:98:
        43:4a:6b:d7:b5:97:3b:3a:bf:4f:6d:b4:63:fa:33:00:34:2e:
        2d:6d:96:c9:7b:ca:99:63:ba:be:f4:f6:30:a0:2d:98:96:e9:
        56:44:05:a9:44:a3:61:10:eb:82:a1:67:5d:bc:5d:27:75:aa:
        8a:28:36:2a:38:92:d9:dd:a4:5e:00:a5:cc:cc:7c:29:2a:de:
        28:90:ab:b7:e1:b6:ff:7d:25:0b:40:d8:aa:34:a3:2d:de:07:
        eb:5f:ce:0a:dd:ca:7e:3a:7d:26:c1:62:68:3a:e6:2f:37:f3:
        81:86:21:c4:a9:64:aa:ef:45:36:d1:1a:66:7c:f8:e9:37:d6:
        d6:61:be:a2:ad:48:e7:df:e6:74:fe:d3:6d:7d:d2:25:dc:ac:
        62:57:a9:f7', 'BAF44403AA126AB543EC5592B6307D35570CDBF30D276E4CF750A89B4E2B6FDBF5AD1C4B5DB3A9C1FE7B44EB5BA3050D1FC5342B300029F17840B2A4FF3AF40188177EE6D426D3BA4CEA32FB4377978723C5DB43A3F52AA3515EE13BD265697E55159B7AE769F744E057B515E866600F0D03FB828EA3E8117B6CBEC7630E1793DFCF4BAE6E7375E0F3AAB9A4C0091B85EA7129884132F9F02A0E6C09F2746B666C52131F18BCD43EF7D86E209ECAFEFC2194EE13284BD75C5E0C66EEE9BB0FC134B17F0876F33D2670C98B251D62240CEA1C754EC012E4BA131D30292D563305BB97597EC6494F89D72F24A8B68840B56492535624E4A2A085B35E90B41233CD', '/O=beTRUSTed/OU=beTRUSTed Root CAs/CN=beTRUSTed Root CA - Entrust Implementation', 'O=beTRUSTed/OU=beTRUSTed Root CAs/CN=beTRUSTed Root CA - Entrust Implementation', '3CB54F40', NULL, '-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----', '96fd413e84492805d0a5e5f291104783');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=beTRUSTed, CN=beTRUSTed Root CA - RSA Implementation', 3, 1, 0, '2002-04-11 11:18:13', '2022-04-12 11:07:25', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            3b:59:c7:7b:cd:5b:57:9e:bd:37:52:ac:76:b4:aa:1a
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=beTRUSTed, OU=beTRUSTed Root CAs, CN=beTRUSTed Root CA - RSA Implementation
        Validity
            Not Before: Apr 11 11:18:13 2002 GMT
            Not After : Apr 12 11:07:25 2022 GMT
        Subject: O=beTRUSTed, OU=beTRUSTed Root CAs, CN=beTRUSTed Root CA - RSA Implementation
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:e4:ba:34:30:09:8e:57:d0:b9:06:2c:6f:6e:24:
                    80:22:bf:5d:43:a6:fa:4f:ac:82:e7:1c:68:70:85:
                    1b:a3:6e:b5:aa:78:d9:6e:07:4b:3f:e9:df:f5:ea:
                    e8:54:a1:61:8a:0e:2f:69:75:18:b7:0c:e5:14:8d:
                    71:6e:98:b8:55:fc:0c:95:d0:9b:6e:e1:2d:88:d4:
                    3a:40:6b:92:f1:99:96:64:de:db:ff:78:f4:ee:96:
                    1d:47:89:7c:d4:be:b9:88:77:23:3a:09:e6:04:9e:
                    6d:aa:5e:d2:c8:bd:9a:4e:19:df:89:ea:5b:0e:7e:
                    c3:e4:b4:f0:e0:69:3b:88:0f:41:90:f8:d4:71:43:
                    24:c1:8f:26:4b:3b:56:e9:ff:8c:6c:37:e9:45:ad:
                    85:8c:53:c3:60:86:90:4a:96:c9:b3:54:b0:bb:17:
                    f0:1c:45:d9:d4:1b:19:64:56:0a:19:f7:cc:e1:ff:
                    86:af:7e:58:5e:ac:7a:90:1f:c9:28:39:45:7b:a2:
                    b6:c7:9c:1f:da:85:d4:21:86:59:30:93:be:53:33:
                    37:f6:ef:41:cf:33:c7:ab:72:6b:25:f5:f3:53:1b:
                    0c:4c:2e:f1:75:4b:ef:a0:87:f7:fe:8a:15:d0:6c:
                    d5:cb:f9:68:53:b9:70:15:13:c2:f5:2e:fb:43:35:
                    75:2d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
                CA:TRUE
            X509v3 Certificate Policies: 
                Policy: 1.3.6.1.4.1.6334.0.0.3.9.40.51377
                  CPS: http://www.betrusted.com/products_services/index.html
                  User Notice:
                    Explicit Text: Reliance on or use of this Certificate creates an acknowledgment and acceptance of the then applicable standard terms and conditions of use, the Certification Practice Statement and the Relying Party Agreement, which can be found at the beTRUSTed web site, http://www.betrusted.com/products_services/index.html

            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
                keyid:A9:EC:14:7E:F9:D9:43:CC:53:2B:14:AD:CF:F7:F0:59:89:41:CD:19

            X509v3 Subject Key Identifier: 
                A9:EC:14:7E:F9:D9:43:CC:53:2B:14:AD:CF:F7:F0:59:89:41:CD:19
    Signature Algorithm: sha1WithRSAEncryption
        db:97:b0:75:ea:0c:c4:c1:98:ca:56:05:c0:a8:ad:26:48:af:
        2d:20:e8:81:c7:b6:df:43:c1:2c:1d:75:4b:d4:42:8d:e7:7a:
        a8:74:dc:66:42:59:87:b3:f5:69:6d:d9:a9:9e:b3:7d:1c:31:
        c1:f5:54:e2:59:24:49:e5:ee:bd:39:a6:6b:8a:98:44:fb:9b:
        d7:2a:83:97:34:2d:c7:7d:35:4c:2d:34:b8:3e:0d:c4:ec:88:
        27:af:9e:92:fd:50:61:82:a8:60:07:14:53:cc:65:13:c1:f6:
        47:44:69:d2:31:c8:a6:dd:2e:b3:0b:de:4a:8d:5b:3d:ab:0d:
        c2:35:52:a2:56:37:cc:32:8b:28:85:42:9c:91:40:7a:70:2b:
        38:36:d5:e1:73:1a:1f:e5:fa:7e:5f:dc:d6:9c:3b:30:ea:db:
        c0:5b:27:5c:d3:73:07:c1:c2:f3:4c:9b:6f:9f:1b:ca:1e:aa:
        a8:38:33:09:58:b2:ae:fc:07:e8:36:dc:55:ba:2f:4f:40:fe:
        7a:bd:06:a6:81:c1:93:22:7c:86:11:0a:06:77:48:ae:35:b7:
        2f:32:9a:61:5e:8b:be:29:9f:29:24:88:56:39:2c:a8:d2:ab:
        96:03:5a:d4:48:9f:b9:40:84:0b:98:68:fb:01:43:d6:1b:e2:
        09:b1:97:1c', 'E4BA3430098E57D0B9062C6F6E248022BF5D43A6FA4FAC82E71C6870851BA36EB5AA78D96E074B3FE9DFF5EAE854A1618A0E2F697518B70CE5148D716E98B855FC0C95D09B6EE12D88D43A406B92F1999664DEDBFF78F4EE961D47897CD4BEB98877233A09E6049E6DAA5ED2C8BD9A4E19DF89EA5B0E7EC3E4B4F0E0693B880F4190F8D4714324C18F264B3B56E9FF8C6C37E945AD858C53C36086904A96C9B354B0BB17F01C45D9D41B1964560A19F7CCE1FF86AF7E585EAC7A901FC92839457BA2B6C79C1FDA85D42186593093BE533337F6EF41CF33C7AB726B25F5F3531B0C4C2EF1754BEFA087F7FE8A15D06CD5CBF96853B9701513C2F52EFB4335752D', '/O=beTRUSTed/OU=beTRUSTed Root CAs/CN=beTRUSTed Root CA - RSA Implementation', 'O=beTRUSTed/OU=beTRUSTed Root CAs/CN=beTRUSTed Root CA - RSA Implementation', '3B59C77BCD5B579EBD3752AC76B4AA1A', NULL, '-----BEGIN CERTIFICATE-----
MIIFaDCCBFCgAwIBAgIQO1nHe81bV569N1KsdrSqGjANBgkqhkiG9w0BAQUFADBi
MRIwEAYDVQQKEwliZVRSVVNUZWQxGzAZBgNVBAsTEmJlVFJVU1RlZCBSb290IENB
czEvMC0GA1UEAxMmYmVUUlVTVGVkIFJvb3QgQ0EgLSBSU0EgSW1wbGVtZW50YXRp
b24wHhcNMDIwNDExMTExODEzWhcNMjIwNDEyMTEwNzI1WjBiMRIwEAYDVQQKEwli
ZVRSVVNUZWQxGzAZBgNVBAsTEmJlVFJVU1RlZCBSb290IENBczEvMC0GA1UEAxMm
YmVUUlVTVGVkIFJvb3QgQ0EgLSBSU0EgSW1wbGVtZW50YXRpb24wggEiMA0GCSqG
SIb3DQEBAQUAA4IBDwAwggEKAoIBAQDkujQwCY5X0LkGLG9uJIAiv11DpvpPrILn
HGhwhRujbrWqeNluB0s/6d/16uhUoWGKDi9pdRi3DOUUjXFumLhV/AyV0Jtu4S2I
1DpAa5LxmZZk3tv/ePTulh1HiXzUvrmIdyM6CeYEnm2qXtLIvZpOGd+J6lsOfsPk
tPDgaTuID0GQ+NRxQyTBjyZLO1bp/4xsN+lFrYWMU8NghpBKlsmzVLC7F/AcRdnU
GxlkVgoZ98zh/4avflherHqQH8koOUV7orbHnB/ahdQhhlkwk75TMzf270HPM8er
cmsl9fNTGwxMLvF1S++gh/f+ihXQbNXL+WhTuXAVE8L1LvtDNXUtAgMBAAGjggIY
MIICFDAMBgNVHRMEBTADAQH/MIIBtQYDVR0gBIIBrDCCAagwggGkBg8rBgEEAbE+
AAADCSiDkTEwggGPMEEGCCsGAQUFBwIBFjVodHRwOi8vd3d3LmJldHJ1c3RlZC5j
b20vcHJvZHVjdHNfc2VydmljZXMvaW5kZXguaHRtbDCCAUgGCCsGAQUFBwICMIIB
OhqCATZSZWxpYW5jZSBvbiBvciB1c2Ugb2YgdGhpcyBDZXJ0aWZpY2F0ZSBjcmVh
dGVzIGFuIGFja25vd2xlZGdtZW50IGFuZCBhY2NlcHRhbmNlIG9mIHRoZSB0aGVu
IGFwcGxpY2FibGUgc3RhbmRhcmQgdGVybXMgYW5kIGNvbmRpdGlvbnMgb2YgdXNl
LCB0aGUgQ2VydGlmaWNhdGlvbiBQcmFjdGljZSBTdGF0ZW1lbnQgYW5kIHRoZSBS
ZWx5aW5nIFBhcnR5IEFncmVlbWVudCwgd2hpY2ggY2FuIGJlIGZvdW5kIGF0IHRo
ZSBiZVRSVVNUZWQgd2ViIHNpdGUsIGh0dHA6Ly93d3cuYmV0cnVzdGVkLmNvbS9w
cm9kdWN0c19zZXJ2aWNlcy9pbmRleC5odG1sMAsGA1UdDwQEAwIBBjAfBgNVHSME
GDAWgBSp7BR++dlDzFMrFK3P9/BZiUHNGTAdBgNVHQ4EFgQUqewUfvnZQ8xTKxSt
z/fwWYlBzRkwDQYJKoZIhvcNAQEFBQADggEBANuXsHXqDMTBmMpWBcCorSZIry0g
6IHHtt9DwSwddUvUQo3neqh03GZCWYez9Wlt2ames30cMcH1VOJZJEnl7r05pmuK
mET7m9cqg5c0Lcd9NUwtNLg+DcTsiCevnpL9UGGCqGAHFFPMZRPB9kdEadIxyKbd
LrML3kqNWz2rDcI1UqJWN8wyiyiFQpyRQHpwKzg21eFzGh/l+n5f3NacOzDq28Bb
J1zTcwfBwvNMm2+fG8oeqqg4MwlYsq78B+g23FW6L09A/nq9BqaBwZMifIYRCgZ3
SK41ty8ymmFei74pnykkiFY5LKjSq5YDWtRIn7lAhAuYaPsBQ9Yb4gmxlxw=
-----END CERTIFICATE-----', '42fcba5edeedc61ae4a35db6ebcd951c');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=Entrust.net, CN=Entrust.net Certification Authority (2048)', 3, 1, 0, '1999-12-24 17:50:51', '2019-12-24 18:20:51', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 946059622 (0x3863b966)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=Entrust.net, OU=www.entrust.net/CPS_2048 incorp. by ref. (limits liab.), OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Certification Authority (2048)
        Validity
            Not Before: Dec 24 17:50:51 1999 GMT
            Not After : Dec 24 18:20:51 2019 GMT
        Subject: O=Entrust.net, OU=www.entrust.net/CPS_2048 incorp. by ref. (limits liab.), OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Certification Authority (2048)
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ad:4d:4b:a9:12:86:b2:ea:a3:20:07:15:16:64:
                    2a:2b:4b:d1:bf:0b:4a:4d:8e:ed:80:76:a5:67:b7:
                    78:40:c0:73:42:c8:68:c0:db:53:2b:dd:5e:b8:76:
                    98:35:93:8b:1a:9d:7c:13:3a:0e:1f:5b:b7:1e:cf:
                    e5:24:14:1e:b1:81:a9:8d:7d:b8:cc:6b:4b:03:f1:
                    02:0c:dc:ab:a5:40:24:00:7f:74:94:a1:9d:08:29:
                    b3:88:0b:f5:87:77:9d:55:cd:e4:c3:7e:d7:6a:64:
                    ab:85:14:86:95:5b:97:32:50:6f:3d:c8:ba:66:0c:
                    e3:fc:bd:b8:49:c1:76:89:49:19:fd:c0:a8:bd:89:
                    a3:67:2f:c6:9f:bc:71:19:60:b8:2d:e9:2c:c9:90:
                    76:66:7b:94:e2:af:78:d6:65:53:5d:3c:d6:9c:b2:
                    cf:29:03:f9:2f:a4:50:b2:d4:48:ce:05:32:55:8a:
                    fd:b2:64:4c:0e:e4:98:07:75:db:7f:df:b9:08:55:
                    60:85:30:29:f9:7b:48:a4:69:86:e3:35:3f:1e:86:
                    5d:7a:7a:15:bd:ef:00:8e:15:22:54:17:00:90:26:
                    93:bc:0e:49:68:91:bf:f8:47:d3:9d:95:42:c1:0e:
                    4d:df:6f:26:cf:c3:18:21:62:66:43:70:d6:d5:c0:
                    07:e1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 Authority Key Identifier: 
                keyid:55:E4:81:D1:11:80:BE:D8:89:B9:08:A3:31:F9:A1:24:09:16:B9:70

            X509v3 Subject Key Identifier: 
                55:E4:81:D1:11:80:BE:D8:89:B9:08:A3:31:F9:A1:24:09:16:B9:70
            1.2.840.113533.7.65.0: 
                0...V5.0:4.0....
    Signature Algorithm: sha1WithRSAEncryption
        59:47:ac:21:84:8a:17:c9:9c:89:53:1e:ba:80:85:1a:c6:3c:
        4e:3e:b1:9c:b6:7c:c6:92:5d:18:64:02:e3:d3:06:08:11:61:
        7c:63:e3:2b:9d:31:03:70:76:d2:a3:28:a0:f4:bb:9a:63:73:
        ed:6d:e5:2a:db:ed:14:a9:2b:c6:36:11:d0:2b:eb:07:8b:a5:
        da:9e:5c:19:9d:56:12:f5:54:29:c8:05:ed:b2:12:2a:8d:f4:
        03:1b:ff:e7:92:10:87:b0:3a:b5:c3:9d:05:37:12:a3:c7:f4:
        15:b9:d5:a4:39:16:9b:53:3a:23:91:f1:a8:82:a2:6a:88:68:
        c1:79:02:22:bc:aa:a6:d6:ae:df:b0:14:5f:b8:87:d0:dd:7c:
        7f:7b:ff:af:1c:cf:e6:db:07:ad:5e:db:85:9d:d0:2b:0d:33:
        db:04:d1:e6:49:40:13:2b:76:fb:3e:e9:9c:89:0f:15:ce:18:
        b0:85:78:21:4f:6b:4f:0e:fa:36:67:cd:07:f2:ff:08:d0:e2:
        de:d9:bf:2a:af:b8:87:86:21:3c:04:ca:b7:94:68:7f:cf:3c:
        e9:98:d7:38:ff:ec:c0:d9:50:f0:2e:4b:58:ae:46:6f:d0:2e:
        c3:60:da:72:55:72:bd:4c:45:9e:61:ba:bf:84:81:92:03:d1:
        d2:69:7c:c5', 'AD4D4BA91286B2EAA320071516642A2B4BD1BF0B4A4D8EED8076A567B77840C07342C868C0DB532BDD5EB8769835938B1A9D7C133A0E1F5BB71ECFE524141EB181A98D7DB8CC6B4B03F1020CDCABA54024007F7494A19D0829B3880BF587779D55CDE4C37ED76A64AB851486955B9732506F3DC8BA660CE3FCBDB849C176894919FDC0A8BD89A3672FC69FBC711960B82DE92CC99076667B94E2AF78D665535D3CD69CB2CF2903F92FA450B2D448CE0532558AFDB2644C0EE4980775DB7FDFB9085560853029F97B48A46986E3353F1E865D7A7A15BDEF008E1522541700902693BC0E496891BFF847D39D9542C10E4DDF6F26CFC3182162664370D6D5C007E1', '/O=Entrust.net/OU=www.entrust.net/CPS_2048 incorp. by ref. (limits liab.)/OU=(c) 1999 Entrust.net Limited/CN=Entrust.net Certification Authority (2048)', 'O=Entrust.net/OU=www.entrust.net/CPS_2048 incorp. by ref. (limits liab.)/OU=(c) 1999 Entrust.net Limited/CN=Entrust.net Certification Authority (2048)', '3863B966', NULL, '-----BEGIN CERTIFICATE-----
MIIEXDCCA0SgAwIBAgIEOGO5ZjANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChML
RW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBp
bmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5
IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRp
ZmljYXRpb24gQXV0aG9yaXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0xOTEy
MjQxODIwNTFaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3
LmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxp
YWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEG
A1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgp
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQq
K0vRvwtKTY7tgHalZ7d4QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQe
sYGpjX24zGtLA/ECDNyrpUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuX
MlBvPci6Zgzj/L24ScF2iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVT
XTzWnLLPKQP5L6RQstRIzgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/
HoZdenoVve8AjhUiVBcAkCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH
4QIDAQABo3QwcjARBglghkgBhvhCAQEEBAMCAAcwHwYDVR0jBBgwFoAUVeSB0RGA
vtiJuQijMfmhJAkWuXAwHQYDVR0OBBYEFFXkgdERgL7YibkIozH5oSQJFrlwMB0G
CSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQUFAAOCAQEA
WUesIYSKF8mciVMeuoCFGsY8Tj6xnLZ8xpJdGGQC49MGCBFhfGPjK50xA3B20qMo
oPS7mmNz7W3lKtvtFKkrxjYR0CvrB4ul2p5cGZ1WEvVUKcgF7bISKo30Axv/55IQ
h7A6tcOdBTcSo8f0FbnVpDkWm1M6I5HxqIKiaohowXkCIryqptau37AUX7iH0N18
f3v/rxzP5tsHrV7bhZ3QKw0z2wTR5klAEyt2+z7pnIkPFc4YsIV4IU9rTw76NmfN
B/L/CNDi3tm/Kq+4h4YhPATKt5Rof8886ZjXOP/swNlQ8C5LWK5Gb9Auw2DaclVy
vUxFnmG6v4SBkgPR0ml8xQ==
-----END CERTIFICATE-----', '0315b2915a0f74cc3498cfdd54933452');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=Entrust.net, CN=Entrust.net Client Certification Authority', 3, 1, 0, '2000-02-07 16:16:40', '2020-02-07 16:46:40', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 949941988 (0x389ef6e4)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: O=Entrust.net, OU=www.entrust.net/GCCA_CPS incorp. by ref. (limits liab.), OU=(c) 2000 Entrust.net Limited, CN=Entrust.net Client Certification Authority
        Validity
            Not Before: Feb  7 16:16:40 2000 GMT
            Not After : Feb  7 16:46:40 2020 GMT
        Subject: O=Entrust.net, OU=www.entrust.net/GCCA_CPS incorp. by ref. (limits liab.), OU=(c) 2000 Entrust.net Limited, CN=Entrust.net Client Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:93:74:b4:b6:e4:c5:4b:d6:a1:68:7f:62:d5:ec:
                    f7:51:57:b3:72:4a:98:f5:d0:89:c9:ad:63:cd:4d:
                    35:51:6a:84:d4:ad:c9:68:79:6f:b8:eb:11:db:87:
                    ae:5c:24:51:13:f1:54:25:84:af:29:2b:9f:e3:80:
                    e2:d9:cb:dd:c6:45:49:34:88:90:5e:01:97:ef:ea:
                    53:a6:dd:fc:c1:de:4b:2a:25:e4:e9:35:fa:55:05:
                    06:e5:89:7a:ea:a4:11:57:3b:fc:7c:3d:36:cd:67:
                    35:6d:a4:a9:25:59:bd:66:f5:f9:27:e4:95:67:d6:
                    3f:92:80:5e:f2:34:7d:2b:85
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 CRL Distribution Points: 
                DirName:/O=Entrust.net/OU=www.entrust.net/GCCA_CPS incorp. by ref. (limits liab.)/OU=(c) 2000 Entrust.net Limited/CN=Entrust.net Client Certification Authority/CN=CRL1

            X509v3 Private Key Usage Period: 
                Not Before: Feb  7 16:16:40 2000 GMT, Not After: Feb  7 16:46:40 2020 GMT
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
                keyid:84:8B:74:FD:C5:8D:C0:FF:27:6D:20:37:45:7C:FE:2D:CE:BA:D3:7D

            X509v3 Subject Key Identifier: 
                84:8B:74:FD:C5:8D:C0:FF:27:6D:20:37:45:7C:FE:2D:CE:BA:D3:7D
            X509v3 Basic Constraints: 
                CA:TRUE
            1.2.840.113533.7.65.0: 
                0...V5.0:4.0....
    Signature Algorithm: md5WithRSAEncryption
        4e:6f:35:80:3b:d1:8a:f5:0e:a7:20:cb:2d:65:55:d0:92:f4:
        e7:84:b5:06:26:83:12:84:0b:ac:3b:b2:44:ee:bd:cf:40:db:
        20:0e:ba:6e:14:ea:30:e0:3b:62:7c:7f:8b:6b:7c:4a:a7:d5:
        35:3c:be:a8:5c:ea:4b:bb:93:8e:80:66:ab:0f:29:fd:4d:2d:
        bf:1a:9b:0a:90:c5:ab:da:d1:b3:86:d4:2f:24:52:5c:7a:6d:
        c6:f2:fe:e5:4d:1a:30:8c:90:f2:ba:d7:4a:3e:43:7e:d4:c8:
        50:1a:87:f8:4f:81:c7:76:0b:84:3a:72:9d:ce:65:66:97:ae:
        26:5e', '9374B4B6E4C54BD6A1687F62D5ECF75157B3724A98F5D089C9AD63CD4D35516A84D4ADC968796FB8EB11DB87AE5C245113F1542584AF292B9FE380E2D9CBDDC645493488905E0197EFEA53A6DDFCC1DE4B2A25E4E935FA550506E5897AEAA411573BFC7C3D36CD67356DA4A92559BD66F5F927E49567D63F92805EF2347D2B85', '/O=Entrust.net/OU=www.entrust.net/GCCA_CPS incorp. by ref. (limits liab.)/OU=(c) 2000 Entrust.net Limited/CN=Entrust.net Client Certification Authority', 'O=Entrust.net/OU=www.entrust.net/GCCA_CPS incorp. by ref. (limits liab.)/OU=(c) 2000 Entrust.net Limited/CN=Entrust.net Client Certification Authority', '389EF6E4', NULL, '-----BEGIN CERTIFICATE-----
MIIEgzCCA+ygAwIBAgIEOJ725DANBgkqhkiG9w0BAQQFADCBtDEUMBIGA1UEChML
RW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9HQ0NBX0NQUyBp
bmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAyMDAw
IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENsaWVu
dCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wMDAyMDcxNjE2NDBaFw0yMDAy
MDcxNjQ2NDBaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3
LmVudHJ1c3QubmV0L0dDQ0FfQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxp
YWIuKTElMCMGA1UECxMcKGMpIDIwMDAgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEG
A1UEAxMqRW50cnVzdC5uZXQgQ2xpZW50IENlcnRpZmljYXRpb24gQXV0aG9yaXR5
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCTdLS25MVL1qFof2LV7PdRV7Ny
Spj10InJrWPNTTVRaoTUrcloeW+46xHbh65cJFET8VQlhK8pK5/jgOLZy93GRUk0
iJBeAZfv6lOm3fzB3ksqJeTpNfpVBQbliXrqpBFXO/x8PTbNZzVtpKklWb1m9fkn
5JVn1j+SgF7yNH0rhQIDAQABo4IBnjCCAZowEQYJYIZIAYb4QgEBBAQDAgAHMIHd
BgNVHR8EgdUwgdIwgc+ggcyggcmkgcYwgcMxFDASBgNVBAoTC0VudHJ1c3QubmV0
MUAwPgYDVQQLFDd3d3cuZW50cnVzdC5uZXQvR0NDQV9DUFMgaW5jb3JwLiBieSBy
ZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMjAwMCBFbnRydXN0Lm5l
dCBMaW1pdGVkMTMwMQYDVQQDEypFbnRydXN0Lm5ldCBDbGllbnQgQ2VydGlmaWNh
dGlvbiBBdXRob3JpdHkxDTALBgNVBAMTBENSTDEwKwYDVR0QBCQwIoAPMjAwMDAy
MDcxNjE2NDBagQ8yMDIwMDIwNzE2NDY0MFowCwYDVR0PBAQDAgEGMB8GA1UdIwQY
MBaAFISLdP3FjcD/J20gN0V8/i3OutN9MB0GA1UdDgQWBBSEi3T9xY3A/ydtIDdF
fP4tzrrTfTAMBgNVHRMEBTADAQH/MB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4w
AwIEkDANBgkqhkiG9w0BAQQFAAOBgQBObzWAO9GK9Q6nIMstZVXQkvTnhLUGJoMS
hAusO7JE7r3PQNsgDrpuFOow4DtifH+La3xKp9U1PL6oXOpLu5OOgGarDyn9TS2/
GpsKkMWr2tGzhtQvJFJcem3G8v7lTRowjJDyutdKPkN+1MhQGof4T4HHdguEOnKd
zmVml64mXg==
-----END CERTIFICATE-----', '5b76149f2bbede26c8d21f5a94d134ea');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=Entrust.net, CN=Entrust.net Secure Server Certification Authority', 3, 1, 0, '2000-02-04 17:20:00', '2020-02-04 17:50:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 949686588 (0x389b113c)
        Signature Algorithm: md5WithRSAEncryption
        Issuer: O=Entrust.net, OU=www.entrust.net/SSL_CPS incorp. by ref. (limits liab.), OU=(c) 2000 Entrust.net Limited, CN=Entrust.net Secure Server Certification Authority
        Validity
            Not Before: Feb  4 17:20:00 2000 GMT
            Not After : Feb  4 17:50:00 2020 GMT
        Subject: O=Entrust.net, OU=www.entrust.net/SSL_CPS incorp. by ref. (limits liab.), OU=(c) 2000 Entrust.net Limited, CN=Entrust.net Secure Server Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:c7:c1:5f:4e:71:f1:ce:f0:60:86:0f:d2:58:7f:
                    d3:33:97:2d:17:a2:75:30:b5:96:64:26:2f:68:c3:
                    44:ab:a8:75:e6:00:67:34:57:9e:65:c7:22:9b:73:
                    e6:d3:dd:08:0e:37:55:aa:25:46:81:6c:bd:fe:a8:
                    f6:75:57:57:8c:90:6c:4a:c3:3e:8b:4b:43:0a:c9:
                    11:56:9a:9a:27:22:99:cf:55:9e:61:d9:02:e2:7c:
                    b6:7c:38:07:dc:e3:7f:4f:9a:b9:03:41:80:b6:75:
                    67:13:0b:9f:e8:57:36:c8:5d:00:36:de:66:14:da:
                    6e:76:1f:4f:37:8c:82:13:89
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 CRL Distribution Points: 
                DirName:/O=Entrust.net/OU=www.entrust.net/SSL_CPS incorp. by ref. (limits liab.)/OU=(c) 2000 Entrust.net Limited/CN=Entrust.net Secure Server Certification Authority/CN=CRL1

            X509v3 Private Key Usage Period: 
                Not Before: Feb  4 17:20:00 2000 GMT, Not After: Feb  4 17:50:00 2020 GMT
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
                keyid:CB:6C:C0:6B:E3:BB:3E:CB:FC:22:9C:FE:FB:8B:92:9C:B0:F2:6E:22

            X509v3 Subject Key Identifier: 
                CB:6C:C0:6B:E3:BB:3E:CB:FC:22:9C:FE:FB:8B:92:9C:B0:F2:6E:22
            X509v3 Basic Constraints: 
                CA:TRUE
            1.2.840.113533.7.65.0: 
                0...V5.0:4.0....
    Signature Algorithm: md5WithRSAEncryption
        62:db:81:91:ce:c8:9a:77:42:2f:ec:bd:27:a3:53:0f:50:1b:
        ea:4e:92:f0:a9:af:a9:a0:ba:48:61:cb:ef:c9:06:ef:1f:d5:
        f4:ee:df:56:2d:e6:ca:6a:19:73:aa:53:be:92:b3:50:02:b6:
        85:26:72:63:d8:75:50:62:75:14:b7:b3:50:1a:3f:ca:11:00:
        0b:85:45:69:6d:b6:a5:ae:51:e1:4a:dc:82:3f:6c:8c:34:b2:
        77:6b:d9:02:f6:7f:0e:ea:65:04:f1:cd:54:ca:ba:c9:cc:e0:
        84:f7:c8:3e:11:97:d3:60:09:18:bc:05:ff:6c:89:33:f0:ec:
        15:0f', 'C7C15F4E71F1CEF060860FD2587FD333972D17A27530B59664262F68C344ABA875E6006734579E65C7229B73E6D3DD080E3755AA2546816CBDFEA8F67557578C906C4AC33E8B4B430AC911569A9A272299CF559E61D902E27CB67C3807DCE37F4F9AB9034180B67567130B9FE85736C85D0036DE6614DA6E761F4F378C821389', '/O=Entrust.net/OU=www.entrust.net/SSL_CPS incorp. by ref. (limits liab.)/OU=(c) 2000 Entrust.net Limited/CN=Entrust.net Secure Server Certification Authority', 'O=Entrust.net/OU=www.entrust.net/SSL_CPS incorp. by ref. (limits liab.)/OU=(c) 2000 Entrust.net Limited/CN=Entrust.net Secure Server Certification Authority', '389B113C', NULL, '-----BEGIN CERTIFICATE-----
MIIElTCCA/6gAwIBAgIEOJsRPDANBgkqhkiG9w0BAQQFADCBujEUMBIGA1UEChML
RW50cnVzdC5uZXQxPzA9BgNVBAsUNnd3dy5lbnRydXN0Lm5ldC9TU0xfQ1BTIGlu
Y29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDIwMDAg
RW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJl
IFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wMDAyMDQxNzIwMDBa
Fw0yMDAyMDQxNzUwMDBaMIG6MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDE/MD0GA1UE
CxQ2d3d3LmVudHJ1c3QubmV0L1NTTF9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1p
dHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMjAwMCBFbnRydXN0Lm5ldCBMaW1pdGVk
MTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRp
b24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHwV9OcfHO
8GCGD9JYf9Mzly0XonUwtZZkJi9ow0SrqHXmAGc0V55lxyKbc+bT3QgON1WqJUaB
bL3+qPZ1V1eMkGxKwz6LS0MKyRFWmponIpnPVZ5h2QLifLZ8OAfc439PmrkDQYC2
dWcTC5/oVzbIXQA23mYU2m52H083jIITiQIDAQABo4IBpDCCAaAwEQYJYIZIAYb4
QgEBBAQDAgAHMIHjBgNVHR8EgdswgdgwgdWggdKggc+kgcwwgckxFDASBgNVBAoT
C0VudHJ1c3QubmV0MT8wPQYDVQQLFDZ3d3cuZW50cnVzdC5uZXQvU1NMX0NQUyBp
bmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAyMDAw
IEVudHJ1c3QubmV0IExpbWl0ZWQxOjA4BgNVBAMTMUVudHJ1c3QubmV0IFNlY3Vy
ZSBTZXJ2ZXIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxDTALBgNVBAMTBENSTDEw
KwYDVR0QBCQwIoAPMjAwMDAyMDQxNzIwMDBagQ8yMDIwMDIwNDE3NTAwMFowCwYD
VR0PBAQDAgEGMB8GA1UdIwQYMBaAFMtswGvjuz7L/CKc/vuLkpyw8m4iMB0GA1Ud
DgQWBBTLbMBr47s+y/winP77i5KcsPJuIjAMBgNVHRMEBTADAQH/MB0GCSqGSIb2
fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQQFAAOBgQBi24GRzsia
d0Iv7L0no1MPUBvqTpLwqa+poLpIYcvvyQbvH9X07t9WLebKahlzqlO+krNQAraF
JnJj2HVQYnUUt7NQGj/KEQALhUVpbbalrlHhStyCP2yMNLJ3a9kC9n8O6mUE8c1U
yrrJzOCE98g+EZfTYAkYvAX/bIkz8OwVDw==
-----END CERTIFICATE-----', 'ef39169d288af20ec2f5bee407c3470a');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=GlobalSign, CN=GlobalSign', 3, 1, 0, '2006-12-15 08:00:00', '2021-12-15 08:00:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:0f:86:26:e6:0d
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: OU=GlobalSign Root CA - R2, O=GlobalSign, CN=GlobalSign
        Validity
            Not Before: Dec 15 08:00:00 2006 GMT
            Not After : Dec 15 08:00:00 2021 GMT
        Subject: OU=GlobalSign Root CA - R2, O=GlobalSign, CN=GlobalSign
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:a6:cf:24:0e:be:2e:6f:28:99:45:42:c4:ab:3e:
                    21:54:9b:0b:d3:7f:84:70:fa:12:b3:cb:bf:87:5f:
                    c6:7f:86:d3:b2:30:5c:d6:fd:ad:f1:7b:dc:e5:f8:
                    60:96:09:92:10:f5:d0:53:de:fb:7b:7e:73:88:ac:
                    52:88:7b:4a:a6:ca:49:a6:5e:a8:a7:8c:5a:11:bc:
                    7a:82:eb:be:8c:e9:b3:ac:96:25:07:97:4a:99:2a:
                    07:2f:b4:1e:77:bf:8a:0f:b5:02:7c:1b:96:b8:c5:
                    b9:3a:2c:bc:d6:12:b9:eb:59:7d:e2:d0:06:86:5f:
                    5e:49:6a:b5:39:5e:88:34:ec:bc:78:0c:08:98:84:
                    6c:a8:cd:4b:b4:a0:7d:0c:79:4d:f0:b8:2d:cb:21:
                    ca:d5:6c:5b:7d:e1:a0:29:84:a1:f9:d3:94:49:cb:
                    24:62:91:20:bc:dd:0b:d5:d9:cc:f9:ea:27:0a:2b:
                    73:91:c6:9d:1b:ac:c8:cb:e8:e0:a0:f4:2f:90:8b:
                    4d:fb:b0:36:1b:f6:19:7a:85:e0:6d:f2:61:13:88:
                    5c:9f:e0:93:0a:51:97:8a:5a:ce:af:ab:d5:f7:aa:
                    09:aa:60:bd:dc:d9:5f:df:72:a9:60:13:5e:00:01:
                    c9:4a:fa:3f:a4:ea:07:03:21:02:8e:82:ca:03:c2:
                    9b:8f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                9B:E2:07:57:67:1C:1E:C0:6A:06:DE:59:B4:9A:2D:DF:DC:19:86:2E
            X509v3 CRL Distribution Points: 
                URI:http://crl.globalsign.net/root-r2.crl

            X509v3 Authority Key Identifier: 
                keyid:9B:E2:07:57:67:1C:1E:C0:6A:06:DE:59:B4:9A:2D:DF:DC:19:86:2E

    Signature Algorithm: sha1WithRSAEncryption
        99:81:53:87:1c:68:97:86:91:ec:e0:4a:b8:44:0b:ab:81:ac:
        27:4f:d6:c1:b8:1c:43:78:b3:0c:9a:fc:ea:2c:3c:6e:61:1b:
        4d:4b:29:f5:9f:05:1d:26:c1:b8:e9:83:00:62:45:b6:a9:08:
        93:b9:a9:33:4b:18:9a:c2:f8:87:88:4e:db:dd:71:34:1a:c1:
        54:da:46:3f:e0:d3:2a:ab:6d:54:22:f5:3a:62:cd:20:6f:ba:
        29:89:d7:dd:91:ee:d3:5c:a2:3e:a1:5b:41:f5:df:e5:64:43:
        2d:e9:d5:39:ab:d2:a2:df:b7:8b:d0:c0:80:19:1c:45:c0:2d:
        8c:e8:f8:2d:a4:74:56:49:c5:05:b5:4f:15:de:6e:44:78:39:
        87:a8:7e:bb:f3:79:18:91:bb:f4:6f:9d:c1:f0:8c:35:8c:5d:
        01:fb:c3:6d:b9:ef:44:6d:79:46:31:7e:0a:fe:a9:82:c1:ff:
        ef:ab:6e:20:c4:50:c9:5f:9d:4d:9b:17:8c:0c:e5:01:c9:a0:
        41:6a:73:53:fa:a5:50:b4:6e:25:0f:fb:4c:18:f4:fd:52:d9:
        8e:69:b1:e8:11:0f:de:88:d8:fb:1d:49:f7:aa:de:95:cf:20:
        78:c2:60:12:db:25:40:8c:6a:fc:7e:42:38:40:64:12:f7:9e:
        81:e1:93:2e', 'A6CF240EBE2E6F28994542C4AB3E21549B0BD37F8470FA12B3CBBF875FC67F86D3B2305CD6FDADF17BDCE5F86096099210F5D053DEFB7B7E7388AC52887B4AA6CA49A65EA8A78C5A11BC7A82EBBE8CE9B3AC962507974A992A072FB41E77BF8A0FB5027C1B96B8C5B93A2CBCD612B9EB597DE2D006865F5E496AB5395E8834ECBC780C0898846CA8CD4BB4A07D0C794DF0B82DCB21CAD56C5B7DE1A02984A1F9D39449CB24629120BCDD0BD5D9CCF9EA270A2B7391C69D1BACC8CBE8E0A0F42F908B4DFBB0361BF6197A85E06DF26113885C9FE0930A51978A5ACEAFABD5F7AA09AA60BDDCD95FDF72A960135E0001C94AFA3FA4EA070321028E82CA03C29B8F', '/OU=GlobalSign Root CA - R2/O=GlobalSign/CN=GlobalSign', 'OU=GlobalSign Root CA - R2/O=GlobalSign/CN=GlobalSign', '0400000000010F8626E60D', NULL, '-----BEGIN CERTIFICATE-----
MIIDujCCAqKgAwIBAgILBAAAAAABD4Ym5g0wDQYJKoZIhvcNAQEFBQAwTDEgMB4G
A1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjIxEzARBgNVBAoTCkdsb2JhbFNp
Z24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMDYxMjE1MDgwMDAwWhcNMjExMjE1
MDgwMDAwWjBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSMjETMBEG
A1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjCCASIwDQYJKoZI
hvcNAQEBBQADggEPADCCAQoCggEBAKbPJA6+Lm8omUVCxKs+IVSbC9N/hHD6ErPL
v4dfxn+G07IwXNb9rfF73OX4YJYJkhD10FPe+3t+c4isUoh7SqbKSaZeqKeMWhG8
eoLrvozps6yWJQeXSpkqBy+0Hne/ig+1AnwblrjFuTosvNYSuetZfeLQBoZfXklq
tTleiDTsvHgMCJiEbKjNS7SgfQx5TfC4LcshytVsW33hoCmEofnTlEnLJGKRILzd
C9XZzPnqJworc5HGnRusyMvo4KD0L5CLTfuwNhv2GXqF4G3yYROIXJ/gkwpRl4pa
zq+r1feqCapgvdzZX99yqWATXgAByUr6P6TqBwMhAo6CygPCm48CAwEAAaOBnDCB
mTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUm+IH
V2ccHsBqBt5ZtJot39wZhi4wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
bG9iYWxzaWduLm5ldC9yb290LXIyLmNybDAfBgNVHSMEGDAWgBSb4gdXZxwewGoG
3lm0mi3f3BmGLjANBgkqhkiG9w0BAQUFAAOCAQEAmYFThxxol4aR7OBKuEQLq4Gs
J0/WwbgcQ3izDJr86iw8bmEbTUsp9Z8FHSbBuOmDAGJFtqkIk7mpM0sYmsL4h4hO
291xNBrBVNpGP+DTKqttVCL1OmLNIG+6KYnX3ZHu01yiPqFbQfXf5WRDLenVOavS
ot+3i9DAgBkcRcAtjOj4LaR0VknFBbVPFd5uRHg5h6h+u/N5GJG79G+dwfCMNYxd
AfvDbbnvRG15RjF+Cv6pgsH/76tuIMRQyV+dTZsXjAzlAcmgQWpzU/qlULRuJQ/7
TBj0/VLZjmmx6BEP3ojY+x1J96relc8geMJgEtslQIxq/H5COEBkEveegeGTLg==
-----END CERTIFICATE-----', '20af0db1f0a1bd929c472dfcfe4b13c7');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=GlobalSign, CN=GlobalSign', 3, 1, 0, '2009-03-18 10:00:00', '2029-03-18 10:00:00', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:21:58:53:08:a2
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: OU=GlobalSign Root CA - R3, O=GlobalSign, CN=GlobalSign
        Validity
            Not Before: Mar 18 10:00:00 2009 GMT
            Not After : Mar 18 10:00:00 2029 GMT
        Subject: OU=GlobalSign Root CA - R3, O=GlobalSign, CN=GlobalSign
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:cc:25:76:90:79:06:78:22:16:f5:c0:83:b6:84:
                    ca:28:9e:fd:05:76:11:c5:ad:88:72:fc:46:02:43:
                    c7:b2:8a:9d:04:5f:24:cb:2e:4b:e1:60:82:46:e1:
                    52:ab:0c:81:47:70:6c:dd:64:d1:eb:f5:2c:a3:0f:
                    82:3d:0c:2b:ae:97:d7:b6:14:86:10:79:bb:3b:13:
                    80:77:8c:08:e1:49:d2:6a:62:2f:1f:5e:fa:96:68:
                    df:89:27:95:38:9f:06:d7:3e:c9:cb:26:59:0d:73:
                    de:b0:c8:e9:26:0e:83:15:c6:ef:5b:8b:d2:04:60:
                    ca:49:a6:28:f6:69:3b:f6:cb:c8:28:91:e5:9d:8a:
                    61:57:37:ac:74:14:dc:74:e0:3a:ee:72:2f:2e:9c:
                    fb:d0:bb:bf:f5:3d:00:e1:06:33:e8:82:2b:ae:53:
                    a6:3a:16:73:8c:dd:41:0e:20:3a:c0:b4:a7:a1:e9:
                    b2:4f:90:2e:32:60:e9:57:cb:b9:04:92:68:68:e5:
                    38:26:60:75:b2:9f:77:ff:91:14:ef:ae:20:49:fc:
                    ad:40:15:48:d1:02:31:61:19:5e:b8:97:ef:ad:77:
                    b7:64:9a:7a:bf:5f:c1:13:ef:9b:62:fb:0d:6c:e0:
                    54:69:16:a9:03:da:6e:e9:83:93:71:76:c6:69:85:
                    82:17
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                8F:F0:4B:7F:A8:2E:45:24:AE:4D:50:FA:63:9A:8B:DE:E2:DD:1B:BC
    Signature Algorithm: sha256WithRSAEncryption
        4b:40:db:c0:50:aa:fe:c8:0c:ef:f7:96:54:45:49:bb:96:00:
        09:41:ac:b3:13:86:86:28:07:33:ca:6b:e6:74:b9:ba:00:2d:
        ae:a4:0a:d3:f5:f1:f1:0f:8a:bf:73:67:4a:83:c7:44:7b:78:
        e0:af:6e:6c:6f:03:29:8e:33:39:45:c3:8e:e4:b9:57:6c:aa:
        fc:12:96:ec:53:c6:2d:e4:24:6c:b9:94:63:fb:dc:53:68:67:
        56:3e:83:b8:cf:35:21:c3:c9:68:fe:ce:da:c2:53:aa:cc:90:
        8a:e9:f0:5d:46:8c:95:dd:7a:58:28:1a:2f:1d:de:cd:00:37:
        41:8f:ed:44:6d:d7:53:28:97:7e:f3:67:04:1e:15:d7:8a:96:
        b4:d3:de:4c:27:a4:4c:1b:73:73:76:f4:17:99:c2:1f:7a:0e:
        e3:2d:08:ad:0a:1c:2c:ff:3c:ab:55:0e:0f:91:7e:36:eb:c3:
        57:49:be:e1:2e:2d:7c:60:8b:c3:41:51:13:23:9d:ce:f7:32:
        6b:94:01:a8:99:e7:2c:33:1f:3a:3b:25:d2:86:40:ce:3b:2c:
        86:78:c9:61:2f:14:ba:ee:db:55:6f:df:84:ee:05:09:4d:bd:
        28:d8:72:ce:d3:62:50:65:1e:eb:92:97:83:31:d9:b3:b5:ca:
        47:58:3f:5f', 'CC2576907906782216F5C083B684CA289EFD057611C5AD8872FC460243C7B28A9D045F24CB2E4BE1608246E152AB0C8147706CDD64D1EBF52CA30F823D0C2BAE97D7B614861079BB3B1380778C08E149D26A622F1F5EFA9668DF892795389F06D73EC9CB26590D73DEB0C8E9260E8315C6EF5B8BD20460CA49A628F6693BF6CBC82891E59D8A615737AC7414DC74E03AEE722F2E9CFBD0BBBFF53D00E10633E8822BAE53A63A16738CDD410E203AC0B4A7A1E9B24F902E3260E957CBB904926868E538266075B29F77FF9114EFAE2049FCAD401548D1023161195EB897EFAD77B7649A7ABF5FC113EF9B62FB0D6CE0546916A903DA6EE983937176C669858217', '/OU=GlobalSign Root CA - R3/O=GlobalSign/CN=GlobalSign', 'OU=GlobalSign Root CA - R3/O=GlobalSign/CN=GlobalSign', '04000000000121585308A2', NULL, '-----BEGIN CERTIFICATE-----
MIIDXzCCAkegAwIBAgILBAAAAAABIVhTCKIwDQYJKoZIhvcNAQELBQAwTDEgMB4G
A1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjMxEzARBgNVBAoTCkdsb2JhbFNp
Z24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMDkwMzE4MTAwMDAwWhcNMjkwMzE4
MTAwMDAwWjBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEG
A1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjCCASIwDQYJKoZI
hvcNAQEBBQADggEPADCCAQoCggEBAMwldpB5BngiFvXAg7aEyiie/QV2EcWtiHL8
RgJDx7KKnQRfJMsuS+FggkbhUqsMgUdwbN1k0ev1LKMPgj0MK66X17YUhhB5uzsT
gHeMCOFJ0mpiLx9e+pZo34knlTifBtc+ycsmWQ1z3rDI6SYOgxXG71uL0gRgykmm
KPZpO/bLyCiR5Z2KYVc3rHQU3HTgOu5yLy6c+9C7v/U9AOEGM+iCK65TpjoWc4zd
QQ4gOsC0p6Hpsk+QLjJg6VfLuQSSaGjlOCZgdbKfd/+RFO+uIEn8rUAVSNECMWEZ
XriX7613t2Saer9fwRPvm2L7DWzgVGkWqQPabumDk3F2xmmFghcCAwEAAaNCMEAw
DgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFI/wS3+o
LkUkrk1Q+mOai97i3Ru8MA0GCSqGSIb3DQEBCwUAA4IBAQBLQNvAUKr+yAzv95ZU
RUm7lgAJQayzE4aGKAczymvmdLm6AC2upArT9fHxD4q/c2dKg8dEe3jgr25sbwMp
jjM5RcOO5LlXbKr8EpbsU8Yt5CRsuZRj+9xTaGdWPoO4zzUhw8lo/s7awlOqzJCK
6fBdRoyV3XpYKBovHd7NADdBj+1EbddTKJd+82cEHhXXipa0095MJ6RMG3NzdvQX
mcIfeg7jLQitChws/zyrVQ4PkX4268NXSb7hLi18YIvDQVETI53O9zJrlAGomecs
Mx86OyXShkDOOyyGeMlhLxS67ttVb9+E7gUJTb0o2HLO02JQZR7rkpeDMdmztcpH
WD9f
-----END CERTIFICATE-----','221eb05e63024bb1b6420f8606d0c092');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=RSA Security Inc', 3, 1, 0, '2001-02-22 20:39:23', '2026-02-22 20:39:23', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            0a:01:01:01:00:00:02:7c:00:00:00:0a:00:00:00:02
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=RSA Security Inc, OU=RSA Security 2048 V3
        Validity
            Not Before: Feb 22 20:39:23 2001 GMT
            Not After : Feb 22 20:39:23 2026 GMT
        Subject: O=RSA Security Inc, OU=RSA Security 2048 V3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:b7:8f:55:71:d2:80:dd:7b:69:79:a7:f0:18:50:
                    32:3c:62:67:f6:0a:95:07:dd:e6:1b:f3:9e:d9:d2:
                    41:54:6b:ad:9f:7c:be:19:cd:fb:46:ab:41:68:1e:
                    18:ea:55:c8:2f:91:78:89:28:fb:27:29:60:ff:df:
                    8f:8c:3b:c9:49:9b:b5:a4:94:ce:01:ea:3e:b5:63:
                    7b:7f:26:fd:19:dd:c0:21:bd:84:d1:2d:4f:46:c3:
                    4e:dc:d8:37:39:3b:28:af:cb:9d:1a:ea:2b:af:21:
                    a5:c1:23:22:b8:b8:1b:5a:13:87:57:83:d1:f0:20:
                    e7:e8:4f:23:42:b0:00:a5:7d:89:e9:e9:61:73:94:
                    98:71:26:bc:2d:6a:e0:f7:4d:f0:f1:b6:2a:38:31:
                    81:0d:29:e1:00:c1:51:0f:4c:52:f8:04:5a:aa:7d:
                    72:d3:b8:87:2a:bb:63:10:03:2a:b3:a1:4f:0d:5a:
                    5e:46:b7:3d:0e:f5:74:ec:99:9f:f9:3d:24:81:88:
                    a6:dd:60:54:e8:95:36:3d:c6:09:93:9a:a3:12:80:
                    00:55:99:19:47:bd:d0:a5:7c:c3:ba:fb:1f:f7:f5:
                    0f:f8:ac:b9:b5:f4:37:98:13:18:de:85:5b:b7:0c:
                    82:3b:87:6f:95:39:58:30:da:6e:01:68:17:22:cc:
                    c0:0b
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
                keyid:07:C3:51:30:A4:AA:E9:45:AE:35:24:FA:FF:24:2C:33:D0:B1:9D:8C

            X509v3 Subject Key Identifier: 
                07:C3:51:30:A4:AA:E9:45:AE:35:24:FA:FF:24:2C:33:D0:B1:9D:8C
    Signature Algorithm: sha1WithRSAEncryption
        5f:3e:86:76:6e:b8:35:3c:4e:36:1c:1e:79:98:bf:fd:d5:12:
        11:79:52:0e:ee:31:89:bc:dd:7f:f9:d1:c6:15:21:e8:8a:01:
        54:0d:3a:fb:54:b9:d6:63:d4:b1:aa:96:4d:a2:42:4d:d4:53:
        1f:8b:10:de:7f:65:be:60:13:27:71:88:a4:73:e3:84:63:d1:
        a4:55:e1:50:93:e6:1b:0e:79:d0:67:bc:46:c8:bf:3f:17:0d:
        95:e6:c6:90:69:de:e7:b4:2f:de:95:7d:d0:12:3f:3d:3e:7f:
        4d:3f:14:68:f5:11:50:d5:c1:f4:90:a5:08:1d:31:60:ff:60:
        8c:23:54:0a:af:fe:a1:6e:c5:d1:7a:2a:68:78:cf:1e:82:0a:
        20:b4:1f:ad:e5:85:b2:6a:68:75:4e:ad:25:37:94:85:be:bd:
        a1:d4:ea:b7:0c:4b:3c:9d:e8:12:00:f0:5f:ac:0d:e1:ac:70:
        63:73:f7:7f:79:9f:32:25:42:74:05:80:28:bf:bd:c1:24:96:
        58:15:b1:17:21:e9:89:4b:db:07:88:67:f4:15:ad:70:3e:2f:
        4d:85:3b:c2:b7:db:fe:98:68:23:89:e1:74:0f:de:f4:c5:84:
        63:29:1b:cc:cb:07:c9:00:a4:a9:d7:c2:22:4f:67:d7:77:ec:
        20:05:61:de', 'B78F5571D280DD7B6979A7F01850323C6267F60A9507DDE61BF39ED9D241546BAD9F7CBE19CDFB46AB41681E18EA55C82F91788928FB272960FFDF8F8C3BC9499BB5A494CE01EA3EB5637B7F26FD19DDC021BD84D12D4F46C34EDCD837393B28AFCB9D1AEA2BAF21A5C12322B8B81B5A13875783D1F020E7E84F2342B000A57D89E9E9617394987126BC2D6AE0F74DF0F1B62A3831810D29E100C1510F4C52F8045AAA7D72D3B8872ABB6310032AB3A14F0D5A5E46B73D0EF574EC999FF93D248188A6DD6054E895363DC609939AA312800055991947BDD0A57CC3BAFB1FF7F50FF8ACB9B5F437981318DE855BB70C823B876F95395830DA6E01681722CCC00B', '/O=RSA Security Inc/OU=RSA Security 2048 V3', 'O=RSA Security Inc/OU=RSA Security 2048 V3', '0A0101010000027C0000000A00000002', NULL, '-----BEGIN CERTIFICATE-----
MIIDYTCCAkmgAwIBAgIQCgEBAQAAAnwAAAAKAAAAAjANBgkqhkiG9w0BAQUFADA6
MRkwFwYDVQQKExBSU0EgU2VjdXJpdHkgSW5jMR0wGwYDVQQLExRSU0EgU2VjdXJp
dHkgMjA0OCBWMzAeFw0wMTAyMjIyMDM5MjNaFw0yNjAyMjIyMDM5MjNaMDoxGTAX
BgNVBAoTEFJTQSBTZWN1cml0eSBJbmMxHTAbBgNVBAsTFFJTQSBTZWN1cml0eSAy
MDQ4IFYzMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAt49VcdKA3Xtp
eafwGFAyPGJn9gqVB93mG/Oe2dJBVGutn3y+Gc37RqtBaB4Y6lXIL5F4iSj7Jylg
/9+PjDvJSZu1pJTOAeo+tWN7fyb9Gd3AIb2E0S1PRsNO3Ng3OTsor8udGuorryGl
wSMiuLgbWhOHV4PR8CDn6E8jQrAApX2J6elhc5SYcSa8LWrg903w8bYqODGBDSnh
AMFRD0xS+ARaqn1y07iHKrtjEAMqs6FPDVpeRrc9DvV07Jmf+T0kgYim3WBU6JU2
PcYJk5qjEoAAVZkZR73QpXzDuvsf9/UP+Ky5tfQ3mBMY3oVbtwyCO4dvlTlYMNpu
AWgXIszACwIDAQABo2MwYTAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIB
BjAfBgNVHSMEGDAWgBQHw1EwpKrpRa41JPr/JCwz0LGdjDAdBgNVHQ4EFgQUB8NR
MKSq6UWuNST6/yQsM9CxnYwwDQYJKoZIhvcNAQEFBQADggEBAF8+hnZuuDU8TjYc
HnmYv/3VEhF5Ug7uMYm83X/50cYVIeiKAVQNOvtUudZj1LGqlk2iQk3UUx+LEN5/
Zb5gEydxiKRz44Rj0aRV4VCT5hsOedBnvEbIvz8XDZXmxpBp3ue0L96VfdASPz0+
f00/FGj1EVDVwfSQpQgdMWD/YIwjVAqv/qFuxdF6Kmh4zx6CCiC0H63lhbJqaHVO
rSU3lIW+vaHU6rcMSzyd6BIA8F+sDeGscGNz9395nzIlQnQFgCi/vcEkllgVsRch
6YlL2weIZ/QVrXA+L02FO8K32/6YaCOJ4XQP3vTFhGMpG8zLB8kApKnXwiJPZ9d3
7CAFYd4=
-----END CERTIFICATE-----', '1272672914b1eadfb88d408534e154de');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=RSA Security Inc', 3, 1, 0, '2001-02-22 21:01:49', '2026-02-22 20:01:49', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            0a:01:01:01:00:00:02:7c:00:00:00:0b:00:00:00:02
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=RSA Security Inc, OU=RSA Security 1024 V3
        Validity
            Not Before: Feb 22 21:01:49 2001 GMT
            Not After : Feb 22 20:01:49 2026 GMT
        Subject: O=RSA Security Inc, OU=RSA Security 1024 V3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d5:dd:fe:66:09:cf:24:3c:3e:ae:81:4e:4e:8a:
                    c4:69:80:5b:59:3b:df:b9:4d:4c:ca:b5:2d:c3:27:
                    2d:3c:af:00:42:6d:bc:28:a6:96:cf:7f:d7:58:ac:
                    83:0a:a3:55:b5:7b:17:90:15:84:4c:8a:ee:26:99:
                    dc:58:ef:c7:38:a6:aa:af:d0:8e:42:c8:62:d7:ab:
                    ac:a9:fb:4a:7d:bf:ea:fe:12:4d:dd:ff:26:2d:6f:
                    36:54:68:c8:d2:84:56:ee:92:53:61:09:b3:3f:39:
                    9b:a8:c9:9b:bd:ce:9f:7e:d4:19:6a:16:29:18:be:
                    d7:3a:69:dc:25:5b:33:1a:51
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
                keyid:C4:C0:1C:A4:07:94:FD:CD:4D:01:D4:54:DA:A5:0C:5F:DE:AE:05:5A

            X509v3 Subject Key Identifier: 
                C4:C0:1C:A4:07:94:FD:CD:4D:01:D4:54:DA:A5:0C:5F:DE:AE:05:5A
    Signature Algorithm: sha1WithRSAEncryption
        3f:2d:6a:e3:26:43:95:7d:89:97:65:fb:75:e4:72:1d:46:57:
        c4:61:6b:69:9f:12:9b:2c:d5:5a:e8:c0:a2:f0:43:95:e3:1f:
        e9:76:cd:dc:eb:bc:93:a0:65:0a:c7:4d:4f:5f:a7:af:a2:46:
        14:b9:0c:f3:cc:bd:6a:6e:b7:9d:de:25:42:d0:54:ff:9e:68:
        73:63:dc:24:eb:22:bf:a8:72:f2:5e:00:e1:0d:4e:3a:43:6e:
        99:4e:3f:89:78:03:98:ca:f3:55:cc:9d:ae:8e:c1:aa:45:98:
        fa:8f:1a:a0:8d:88:23:f1:15:41:0d:a5:46:3e:91:3f:8b:eb:
        f7:71', 'D5DDFE6609CF243C3EAE814E4E8AC469805B593BDFB94D4CCAB52DC3272D3CAF00426DBC28A696CF7FD758AC830AA355B57B179015844C8AEE2699DC58EFC738A6AAAFD08E42C862D7ABACA9FB4A7DBFEAFE124DDDFF262D6F365468C8D28456EE92536109B33F399BA8C99BBDCE9F7ED4196A162918BED73A69DC255B331A51', '/O=RSA Security Inc/OU=RSA Security 1024 V3', 'O=RSA Security Inc/OU=RSA Security 1024 V3', '0A0101010000027C0000000B00000002', NULL, '-----BEGIN CERTIFICATE-----
MIICXDCCAcWgAwIBAgIQCgEBAQAAAnwAAAALAAAAAjANBgkqhkiG9w0BAQUFADA6
MRkwFwYDVQQKExBSU0EgU2VjdXJpdHkgSW5jMR0wGwYDVQQLExRSU0EgU2VjdXJp
dHkgMTAyNCBWMzAeFw0wMTAyMjIyMTAxNDlaFw0yNjAyMjIyMDAxNDlaMDoxGTAX
BgNVBAoTEFJTQSBTZWN1cml0eSBJbmMxHTAbBgNVBAsTFFJTQSBTZWN1cml0eSAx
MDI0IFYzMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDV3f5mCc8kPD6ugU5O
isRpgFtZO9+5TUzKtS3DJy08rwBCbbwoppbPf9dYrIMKo1W1exeQFYRMiu4mmdxY
78c4pqqv0I5CyGLXq6yp+0p9v+r+Ek3d/yYtbzZUaMjShFbuklNhCbM/OZuoyZu9
zp9+1BlqFikYvtc6adwlWzMaUQIDAQABo2MwYTAPBgNVHRMBAf8EBTADAQH/MA4G
A1UdDwEB/wQEAwIBBjAfBgNVHSMEGDAWgBTEwBykB5T9zU0B1FTapQxf3q4FWjAd
BgNVHQ4EFgQUxMAcpAeU/c1NAdRU2qUMX96uBVowDQYJKoZIhvcNAQEFBQADgYEA
Py1q4yZDlX2Jl2X7deRyHUZXxGFraZ8SmyzVWujAovBDleMf6XbN3Ou8k6BlCsdN
T1+nr6JGFLkM88y9am63nd4lQtBU/55oc2PcJOsiv6hy8l4A4Q1OOkNumU4/iXgD
mMrzVcydro7BqkWY+o8aoI2II/EVQQ2lRj6RP4vr93E=
-----END CERTIFICATE-----', '5456f75a2c42751bd3a7620da58213b1');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=ValiCert, Inc., CN=http://www.valicert.com/', 3, 1, 0, '1999-06-25 22:23:48', '2019-06-25 22:23:48', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 1 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Validity
            Not Before: Jun 25 22:23:48 1999 GMT
            Not After : Jun 25 22:23:48 2019 GMT
        Subject: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 1 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d8:59:82:7a:89:b8:96:ba:a6:2f:68:6f:58:2e:
                    a7:54:1c:06:6e:f4:ea:8d:48:bc:31:94:17:f0:f3:
                    4e:bc:b2:b8:35:92:76:b0:d0:a5:a5:01:d7:00:03:
                    12:22:19:08:f8:ff:11:23:9b:ce:07:f5:bf:69:1a:
                    26:fe:4e:e9:d1:7f:9d:2c:40:1d:59:68:6e:a6:f8:
                    58:b0:9d:1a:8f:d3:3f:f1:dc:19:06:81:a8:0e:e0:
                    3a:dd:c8:53:45:09:06:e6:0f:70:c3:fa:40:a6:0e:
                    e2:56:05:0f:18:4d:fc:20:82:d1:73:55:74:8d:76:
                    72:a0:1d:9d:1d:c0:dd:3f:71
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        50:68:3d:49:f4:2c:1c:06:94:df:95:60:7f:96:7b:17:fe:4f:
        71:ad:64:c8:dd:77:d2:ef:59:55:e8:3f:e8:8e:05:2a:21:f2:
        07:d2:b5:a7:52:fe:9c:b1:b6:e2:5b:77:17:40:ea:72:d6:23:
        cb:28:81:32:c3:00:79:18:ec:59:17:89:c9:c6:6a:1e:71:c9:
        fd:b7:74:a5:25:45:69:c5:48:ab:19:e1:45:8a:25:6b:19:ee:
        e5:bb:12:f5:7f:f7:a6:8d:51:c3:f0:9d:74:b7:a9:3e:a0:a5:
        ff:b6:49:03:13:da:22:cc:ed:71:82:2b:99:cf:3a:b7:f5:2d:
        72:c8', 'D859827A89B896BAA62F686F582EA7541C066EF4EA8D48BC319417F0F34EBCB2B8359276B0D0A5A501D7000312221908F8FF11239BCE07F5BF691A26FE4EE9D17F9D2C401D59686EA6F858B09D1A8FD33FF1DC190681A80EE03ADDC853450906E60F70C3FA40A60EE256050F184DFC2082D17355748D7672A01D9D1DC0DD3F71', '/L=ValiCert Validation Network/O=ValiCert, Inc./OU=ValiCert Class 1 Policy Validation Authority/CN=http://www.valicert.com//emailAddress=info@valicert.com', 'L=ValiCert Validation Network/O=ValiCert, Inc./OU=ValiCert Class 1 Policy Validation Authority/CN=http://www.valicert.com//emailAddress=info@valicert.com', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIC5zCCAlACAQEwDQYJKoZIhvcNAQEFBQAwgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0
IFZhbGlkYXRpb24gTmV0d29yazEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAz
BgNVBAsTLFZhbGlDZXJ0IENsYXNzIDEgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9y
aXR5MSEwHwYDVQQDExhodHRwOi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG
9w0BCQEWEWluZm9AdmFsaWNlcnQuY29tMB4XDTk5MDYyNTIyMjM0OFoXDTE5MDYy
NTIyMjM0OFowgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0IFZhbGlkYXRpb24gTmV0d29y
azEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAzBgNVBAsTLFZhbGlDZXJ0IENs
YXNzIDEgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9yaXR5MSEwHwYDVQQDExhodHRw
Oi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG9w0BCQEWEWluZm9AdmFsaWNl
cnQuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDYWYJ6ibiWuqYvaG9Y
LqdUHAZu9OqNSLwxlBfw8068srg1knaw0KWlAdcAAxIiGQj4/xEjm84H9b9pGib+
TunRf50sQB1ZaG6m+FiwnRqP0z/x3BkGgagO4DrdyFNFCQbmD3DD+kCmDuJWBQ8Y
TfwggtFzVXSNdnKgHZ0dwN0/cQIDAQABMA0GCSqGSIb3DQEBBQUAA4GBAFBoPUn0
LBwGlN+VYH+Wexf+T3GtZMjdd9LvWVXoP+iOBSoh8gfStadS/pyxtuJbdxdA6nLW
I8sogTLDAHkY7FkXicnGah5xyf23dKUlRWnFSKsZ4UWKJWsZ7uW7EvV/96aNUcPw
nXS3qT6gpf+2SQMT2iLM7XGCK5nPOrf1LXLI
-----END CERTIFICATE-----', 'a194cb5767b2eb60c4e2d90d4419cdc8');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=ValiCert, Inc., CN=http://www.valicert.com/', 3, 1, 0, '1999-06-26 00:22:33', '2019-06-26 00:22:33', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 3 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Validity
            Not Before: Jun 26 00:22:33 1999 GMT
            Not After : Jun 26 00:22:33 2019 GMT
        Subject: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 3 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:e3:98:51:96:1c:e8:d5:b1:06:81:6a:57:c3:72:
                    75:93:ab:cf:9e:a6:fc:f3:16:52:d6:2d:4d:9f:35:
                    44:a8:2e:04:4d:07:49:8a:38:29:f5:77:37:e7:b7:
                    ab:5d:df:36:71:14:99:8f:dc:c2:92:f1:e7:60:92:
                    97:ec:d8:48:dc:bf:c1:02:20:c6:24:a4:28:4c:30:
                    5a:76:6d:b1:5c:f3:dd:de:9e:10:71:a1:88:c7:5b:
                    9b:41:6d:ca:b0:b8:8e:15:ee:ad:33:2b:cf:47:04:
                    5c:75:71:0a:98:24:98:29:a7:49:59:a5:dd:f8:b7:
                    43:62:61:f3:d3:e2:d0:55:3f
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        56:bb:02:58:84:67:08:2c:df:1f:db:7b:49:33:f5:d3:67:9d:
        f4:b4:0a:10:b3:c9:c5:2c:e2:92:6a:71:78:27:f2:70:83:42:
        d3:3e:cf:a9:54:f4:f1:d8:92:16:8c:d1:04:cb:4b:ab:c9:9f:
        45:ae:3c:8a:a9:b0:71:33:5d:c8:c5:57:df:af:a8:35:b3:7f:
        89:87:e9:e8:25:92:b8:7f:85:7a:ae:d6:bc:1e:37:58:2a:67:
        c9:91:cf:2a:81:3e:ed:c6:39:df:c0:3e:19:9c:19:cc:13:4d:
        82:41:b5:8c:de:e0:3d:60:08:20:0f:45:7e:6b:a2:7f:a3:8c:
        15:ee', 'E39851961CE8D5B106816A57C3727593ABCF9EA6FCF31652D62D4D9F3544A82E044D07498A3829F57737E7B7AB5DDF367114998FDCC292F1E7609297ECD848DCBFC10220C624A4284C305A766DB15CF3DDDE9E1071A188C75B9B416DCAB0B88E15EEAD332BCF47045C75710A98249829A74959A5DDF8B7436261F3D3E2D0553F', '/L=ValiCert Validation Network/O=ValiCert, Inc./OU=ValiCert Class 3 Policy Validation Authority/CN=http://www.valicert.com//emailAddress=info@valicert.com', 'L=ValiCert Validation Network/O=ValiCert, Inc./OU=ValiCert Class 3 Policy Validation Authority/CN=http://www.valicert.com//emailAddress=info@valicert.com', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIC5zCCAlACAQEwDQYJKoZIhvcNAQEFBQAwgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0
IFZhbGlkYXRpb24gTmV0d29yazEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAz
BgNVBAsTLFZhbGlDZXJ0IENsYXNzIDMgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9y
aXR5MSEwHwYDVQQDExhodHRwOi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG
9w0BCQEWEWluZm9AdmFsaWNlcnQuY29tMB4XDTk5MDYyNjAwMjIzM1oXDTE5MDYy
NjAwMjIzM1owgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0IFZhbGlkYXRpb24gTmV0d29y
azEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAzBgNVBAsTLFZhbGlDZXJ0IENs
YXNzIDMgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9yaXR5MSEwHwYDVQQDExhodHRw
Oi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG9w0BCQEWEWluZm9AdmFsaWNl
cnQuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDjmFGWHOjVsQaBalfD
cnWTq8+epvzzFlLWLU2fNUSoLgRNB0mKOCn1dzfnt6td3zZxFJmP3MKS8edgkpfs
2Ejcv8ECIMYkpChMMFp2bbFc893enhBxoYjHW5tBbcqwuI4V7q0zK89HBFx1cQqY
JJgpp0lZpd34t0NiYfPT4tBVPwIDAQABMA0GCSqGSIb3DQEBBQUAA4GBAFa7AliE
Zwgs3x/be0kz9dNnnfS0ChCzycUs4pJqcXgn8nCDQtM+z6lU9PHYkhaM0QTLS6vJ
n0WuPIqpsHEzXcjFV9+vqDWzf4mH6eglkrh/hXqu1rweN1gqZ8mRzyqBPu3GOd/A
PhmcGcwTTYJBtYze4D1gCCAPRX5ron+jjBXu
-----END CERTIFICATE-----', 'cd5da287512f0012a62825afc209a9a9');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'O=ValiCert, Inc., CN=http://www.valicert.com/', 3, 1, 0, '1999-06-26 00:19:54', '2019-06-26 00:19:54', 'Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number: 1 (0x1)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 2 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Validity
            Not Before: Jun 26 00:19:54 1999 GMT
            Not After : Jun 26 00:19:54 2019 GMT
        Subject: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 2 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:ce:3a:71:ca:e5:ab:c8:59:92:55:d7:ab:d8:74:
                    0e:f9:ee:d9:f6:55:47:59:65:47:0e:05:55:dc:eb:
                    98:36:3c:5c:53:5d:d3:30:cf:38:ec:bd:41:89:ed:
                    25:42:09:24:6b:0a:5e:b3:7c:dd:52:2d:4c:e6:d4:
                    d6:7d:5a:59:a9:65:d4:49:13:2d:24:4d:1c:50:6f:
                    b5:c1:85:54:3b:fe:71:e4:d3:5c:42:f9:80:e0:91:
                    1a:0a:5b:39:36:67:f3:3f:55:7c:1b:3f:b4:5f:64:
                    73:34:e3:b4:12:bf:87:64:f8:da:12:ff:37:27:c1:
                    b3:43:bb:ef:7b:6e:2e:69:f7
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        3b:7f:50:6f:6f:50:94:99:49:62:38:38:1f:4b:f8:a5:c8:3e:
        a7:82:81:f6:2b:c7:e8:c5:ce:e8:3a:10:82:cb:18:00:8e:4d:
        bd:a8:58:7f:a1:79:00:b5:bb:e9:8d:af:41:d9:0f:34:ee:21:
        81:19:a0:32:49:28:f4:c4:8e:56:d5:52:33:fd:50:d5:7e:99:
        6c:03:e4:c9:4c:fc:cb:6c:ab:66:b3:4a:21:8c:e5:b5:0c:32:
        3e:10:b2:cc:6c:a1:dc:9a:98:4c:02:5b:f3:ce:b9:9e:a5:72:
        0e:4a:b7:3f:3c:e6:16:68:f8:be:ed:74:4c:bc:5b:d5:62:1f:
        43:dd', 'CE3A71CAE5ABC8599255D7ABD8740EF9EED9F655475965470E0555DCEB98363C5C535DD330CF38ECBD4189ED254209246B0A5EB37CDD522D4CE6D4D67D5A59A965D449132D244D1C506FB5C185543BFE71E4D35C42F980E0911A0A5B393667F33F557C1B3FB45F647334E3B412BF8764F8DA12FF3727C1B343BBEF7B6E2E69F7', '/L=ValiCert Validation Network/O=ValiCert, Inc./OU=ValiCert Class 2 Policy Validation Authority/CN=http://www.valicert.com//emailAddress=info@valicert.com', 'L=ValiCert Validation Network/O=ValiCert, Inc./OU=ValiCert Class 2 Policy Validation Authority/CN=http://www.valicert.com//emailAddress=info@valicert.com', '01', NULL, '-----BEGIN CERTIFICATE-----
MIIC5zCCAlACAQEwDQYJKoZIhvcNAQEFBQAwgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0
IFZhbGlkYXRpb24gTmV0d29yazEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAz
BgNVBAsTLFZhbGlDZXJ0IENsYXNzIDIgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9y
aXR5MSEwHwYDVQQDExhodHRwOi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG
9w0BCQEWEWluZm9AdmFsaWNlcnQuY29tMB4XDTk5MDYyNjAwMTk1NFoXDTE5MDYy
NjAwMTk1NFowgbsxJDAiBgNVBAcTG1ZhbGlDZXJ0IFZhbGlkYXRpb24gTmV0d29y
azEXMBUGA1UEChMOVmFsaUNlcnQsIEluYy4xNTAzBgNVBAsTLFZhbGlDZXJ0IENs
YXNzIDIgUG9saWN5IFZhbGlkYXRpb24gQXV0aG9yaXR5MSEwHwYDVQQDExhodHRw
Oi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAeBgkqhkiG9w0BCQEWEWluZm9AdmFsaWNl
cnQuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDOOnHK5avIWZJV16vY
dA757tn2VUdZZUcOBVXc65g2PFxTXdMwzzjsvUGJ7SVCCSRrCl6zfN1SLUzm1NZ9
WlmpZdRJEy0kTRxQb7XBhVQ7/nHk01xC+YDgkRoKWzk2Z/M/VXwbP7RfZHM047QS
v4dk+NoS/zcnwbNDu+97bi5p9wIDAQABMA0GCSqGSIb3DQEBBQUAA4GBADt/UG9v
UJSZSWI4OB9L+KXIPqeCgfYrx+jFzug6EILLGACOTb2oWH+heQC1u+mNr0HZDzTu
IYEZoDJJKPTEjlbVUjP9UNV+mWwD5MlM/Mtsq2azSiGM5bUMMj4QssxsodyamEwC
W/POuZ6lcg5Ktz885hZo+L7tdEy8W9ViH0Pd
-----END CERTIFICATE-----', 'fdf03feab80e9a109adb8f9912b36f5d');

INSERT INTO tb_tls_certificate VALUES (nextval('tb_certificate_id_seq'), 'C=US, O=Trend Micro Inc, CN=Trend Micro S2 CA', 3, 1, 0, '2014-03-01 23:13:48', '2030-12-31 14:06:06', 'Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            5b:46:99:90:ec:75:9d:34
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=AffirmTrust, CN=AffirmTrust Commercial
        Validity
            Not Before: Mar  1 23:13:48 2014 GMT
            Not After : Dec 31 14:06:06 2030 GMT
        Subject: C=US, O=Trend Micro Inc, CN=Trend Micro S2 CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:de:68:90:89:5c:9a:4b:3d:74:b8:2e:c4:bf:fe:
                    09:2e:43:b2:d7:23:f2:e4:3f:f0:b3:d7:06:82:c4:
                    f1:b8:1a:ad:90:d9:dd:56:22:6a:0f:a8:e3:4e:27:
                    54:46:e3:a4:83:d3:05:4a:25:8b:32:c1:45:82:c9:
                    83:76:ee:ef:f0:8c:39:3f:a7:16:a6:66:a7:7f:88:
                    b7:df:a5:9c:97:ca:e1:9a:1e:bb:7a:9f:7a:57:e6:
                    20:20:3c:03:7c:3c:29:d6:c2:29:ff:ec:2e:50:ba:
                    4a:43:f7:c9:79:51:1d:13:5b:cf:a8:c0:22:ff:e7:
                    05:0e:35:4a:ac:92:59:4b:12:dd:ae:79:d3:45:53:
                    18:46:b1:70:ea:e4:cb:2f:8d:0c:b6:7b:49:c5:06:
                    ff:c6:14:92:e2:9e:42:f6:4d:f4:c8:66:c5:39:11:
                    47:c4:a3:0e:e7:0e:66:fb:28:e1:59:43:e5:67:b8:
                    7c:22:9e:9c:aa:34:9e:64:ad:68:5e:f7:8e:35:da:
                    b3:7e:9b:9f:a4:b5:8e:eb:34:48:8a:67:3e:92:c8:
                    f4:15:42:64:24:29:10:ef:6c:66:be:84:bc:cf:92:
                    1a:0b:3b:2c:79:71:71:61:31:58:d9:1c:65:82:c6:
                    bc:eb:13:6c:0b:28:f7:63:be:05:23:bb:be:b9:1f:
                    43:2d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Authority Information Access: 
                CA Issuers - URI:http://ocsp.affirmtrust.com/commca.crt
                OCSP - URI:http://ocsp.affirmtrust.com/comm

            X509v3 Subject Key Identifier: 
                B0:99:E1:90:4E:F3:65:63:28:9C:12:3F:78:56:BA:84:C0:C7:3A:3D
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:9D:93:C6:53:8B:5E:CA:AF:3F:9F:1E:0F:E5:99:95:BC:24:F6:94:8F

            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: http://www.affirmtrust.com/resources/cps

            X509v3 CRL Distribution Points: 
                URI:http://crl.affirmtrust.com/crl/AffirmTrustCommercial.crl

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
        bc:2c:13:61:90:a8:ad:e5:45:9b:44:b3:d1:80:0f:78:c0:de:
        bd:20:8d:28:66:29:37:3f:97:c5:15:e0:c1:65:a9:b9:ba:8c:
        8a:be:7e:04:a6:7b:c4:a3:ae:e7:59:15:1e:f3:13:60:95:60:
        76:9b:ed:b2:72:a0:a5:f0:1f:96:95:54:87:9a:7c:91:50:3f:
        40:44:9e:e3:db:e8:12:a0:96:0e:66:3e:f7:1b:44:63:7c:34:
        01:01:44:be:55:41:ad:97:a1:94:4b:98:9b:c6:7f:2e:e5:ad:
        a6:2c:ec:94:3e:ee:b9:7f:cb:46:de:ff:f2:9f:61:c0:94:23:
        39:f8:a7:cc:97:8a:21:38:90:51:8f:03:f4:41:81:bf:bf:dc:
        09:c5:97:a5:51:b5:dd:5f:0f:13:a4:ce:f0:4f:fd:09:b0:b2:
        f0:7e:f3:7b:7a:ef:08:cb:53:40:31:bf:d4:3a:6d:89:e4:43:
        89:8f:95:9c:c4:db:c6:3f:bc:e3:9e:3a:ad:99:56:8d:54:dd:
        f7:cf:13:e1:5b:68:b5:1c:10:f1:55:e3:5a:98:75:58:12:3c:
        2b:d8:6b:b1:86:1b:c5:38:dd:f5:00:4a:a5:f0:b2:1a:0e:a6:
        76:de:b4:8f:b3:44:de:5a:1f:54:ed:4c:ae:f5:7b:69:13:a9:
        ca:84:72:43
', 'DE6890895C9A4B3D74B82EC4BFFE092E43B2D723F2E43FF0B3D70682C4F1B81AAD90D9DD56226A0FA8E34E275446E3A483D3054A258B32C14582C98376EEEFF08C393FA716A666A77F88B7DFA59C97CAE19A1EBB7A9F7A57E620203C037C3C29D6C229FFEC2E50BA4A43F7C979511D135BCFA8C022FFE7050E354AAC92594B12DDAE79D345531846B170EAE4CB2F8D0CB67B49C506FFC61492E29E42F64DF4C866C5391147C4A30EE70E66FB28E15943E567B87C229E9CAA349E64AD685EF78E35DAB37E9B9FA4B58EEB34488A673E92C8F4154264242910EF6C66BE84BCCF921A0B3B2C797171613158D91C6582C6BCEB136C0B28F763BE0523BBBEB91F432D', '/C=US/O=Trend Micro Inc/CN=Trend Micro S2 CA', 'C=US/O=AffirmTrust/CN=AffirmTrust Commercial', '5B469990EC759D34', NULL, '-----BEGIN CERTIFICATE-----
MIIEeDCCA2CgAwIBAgIIW0aZkOx1nTQwDQYJKoZIhvcNAQELBQAwRDELMAkGA1UEBhMCVVMxFDAS
BgNVBAoMC0FmZmlybVRydXN0MR8wHQYDVQQDDBZBZmZpcm1UcnVzdCBDb21tZXJjaWFsMB4XDTE0
MDMwMTIzMTM0OFoXDTMwMTIzMTE0MDYwNlowQzELMAkGA1UEBhMCVVMxGDAWBgNVBAoMD1RyZW5k
IE1pY3JvIEluYzEaMBgGA1UEAwwRVHJlbmQgTWljcm8gUzIgQ0EwggEiMA0GCSqGSIb3DQEBAQUA
A4IBDwAwggEKAoIBAQDeaJCJXJpLPXS4LsS//gkuQ7LXI/LkP/Cz1waCxPG4Gq2Q2d1WImoPqONO
J1RG46SD0wVKJYsywUWCyYN27u/wjDk/pxamZqd/iLffpZyXyuGaHrt6n3pX5iAgPAN8PCnWwin/
7C5QukpD98l5UR0TW8+owCL/5wUONUqskllLEt2uedNFUxhGsXDq5MsvjQy2e0nFBv/GFJLinkL2
TfTIZsU5EUfEow7nDmb7KOFZQ+VnuHwinpyqNJ5krWhe94412rN+m5+ktY7rNEiKZz6SyPQVQmQk
KRDvbGa+hLzPkhoLOyx5cXFhMVjZHGWCxrzrE2wLKPdjvgUju765H0MtAgMBAAGjggFtMIIBaTBw
BggrBgEFBQcBAQRkMGIwMgYIKwYBBQUHMAKGJmh0dHA6Ly9vY3NwLmFmZmlybXRydXN0LmNvbS9j
b21tY2EuY3J0MCwGCCsGAQUFBzABhiBodHRwOi8vb2NzcC5hZmZpcm10cnVzdC5jb20vY29tbTAd
BgNVHQ4EFgQUsJnhkE7zZWMonBI/eFa6hMDHOj0wDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
gBSdk8ZTi17Krz+fHg/lmZW8JPaUjzBJBgNVHSAEQjBAMD4GBFUdIAAwNjA0BggrBgEFBQcCARYo
aHR0cDovL3d3dy5hZmZpcm10cnVzdC5jb20vcmVzb3VyY2VzL2NwczBJBgNVHR8EQjBAMD6gPKA6
hjhodHRwOi8vY3JsLmFmZmlybXRydXN0LmNvbS9jcmwvQWZmaXJtVHJ1c3RDb21tZXJjaWFsLmNy
bDAOBgNVHQ8BAf8EBAMCAQYwDQYJKoZIhvcNAQELBQADggEBALwsE2GQqK3lRZtEs9GAD3jA3r0g
jShmKTc/l8UV4MFlqbm6jIq+fgSme8SjrudZFR7zE2CVYHab7bJyoKXwH5aVVIeafJFQP0BEnuPb
6BKglg5mPvcbRGN8NAEBRL5VQa2XoZRLmJvGfy7lraYs7JQ+7rl/y0be//KfYcCUIzn4p8yXiiE4
kFGPA/RBgb+/3AnFl6VRtd1fDxOkzvBP/QmwsvB+83t67wjLU0Axv9Q6bYnkQ4mPlZzE28Y/vOOe
Oq2ZVo1U3ffPE+FbaLUcEPFV41qYdVgSPCvYa7GGG8U43fUASqXwshoOpnbetI+zRN5aH1TtTK71
e2kTqcqEckM=
-----END CERTIFICATE-----
', '85b0859a7836cd8dfce4816f4614c919');


---
---   initialize tb_tls_service_certificate_usage for default UI and MTA
---
INSERT INTO tb_tls_service_certificate_usage VALUES(1, 0, 1, 0);
INSERT INTO tb_tls_service_certificate_usage VALUES(1, 1, 2, 0);
INSERT INTO tb_tls_service_certificate_usage VALUES(1, 2, 2, 0);
INSERT INTO tb_tls_service_certificate_usage VALUES(1, 3, 1, 0);


---   Quick solution: to make migration easy, hard code the id to 99999, which need special handling in migration
insert into tb_named_obj(id, type, name, content) values(99999, 3, 'Cloud Pre-Filter Quarantine', '15:27:Cloud Pre-Filter Quarantine:0:');
insert into tb_named_obj(type, name, content) values(3, 'Compliance Quarantine', '15:21:Compliance Quarantine:0:');
insert into tb_named_obj(type, name, content) values(1, 'Compliance violation notification', E'33:Compliance violation notification:30:postmaster@imss.trendmicro.com:0::25:IMSS Compliance violation:394:InterScan Messaging Security Suite has detected a message which violated the compliance settings configured in Policy > Compliance. The message was quarantined. You can find out more about this event by querying the Policy Event logs for compliance.\r\n\r\nMessage details:\r\nSender: %SENDER%\r\nRecipient: %RCPTS%\r\nSubject: %SUBJECT%\r\nMessage ID: %XMAILID%\r\nReason: %DETECTED%\r\nAttachment: %FILENAME%:0::0:1:0:0:0:0:1:');
insert into tb_named_obj(type, name, content) values(1, 'Email encryption exceptions notification', E'40:Email encryption exceptions notification:30:postmaster@imss.trendmicro.com:0::43:IMSS Trend Micro Email Encryption exception:357:InterScan Messaging Security Suite has detected a message which violated the encryption settings configured in Policy. The message was quarantined. You can find out more about this event by querying the Policy Event logs for encryption.\r\n\r\nMessage details:\r\nSender: %SENDER%\r\nRecipient: %RCPTS%\r\nSubject: %SUBJECT%\r\nMessage ID: %XMAILID%\r\nReason: %DETECTED%:0::0:1:0:0:0:0:1:');
---   This record save the Compliance Template XML generated timestamp 
--insert into tb_named_obj(type, name, content) values(9, 'DLPComplianceTemplateTimeStamp', CURRENT_TIMESTAMP);
--- This is used to put SO detected mails, the id is 100000 for easy handling
INSERT INTO tb_named_obj(id, type, name, content) VALUES (100000, 3, 'Suspicious Objects Quarantine', '15:29:Suspicious Objects Quarantine:0:');
---   Followng SQL statement already do L10N by special task, so need not go through common SQL L10N process
---   This record save the Compliance Template XML need feed to eManager, put an empty record here, it will be updated at the end of installation by a script.
insert into tb_named_obj(type, name, content) values(9, 'DLPComplianceTemplateFullXML', '');

-- Data changes.
-- DLP templates begins.
---   This record save the Compliance Template XML generated timestamp 
insert into tb_named_obj(type, name, content) values(9, 'DLPComplianceTemplateTimeStamp', CURRENT_TIMESTAMP);

---   This record save the Compliance Template XML need feed to eManager
insert into tb_dlp_keyword_list(name, display_name, description, criteria, char_number, score, pre_define, modified, content) values('00000000-0000-0000-0002-000000000001' ,'Adult', 'Words commonly associated with the adult entertainment industry, including pornographic websites',3, 0, 4, true, current_timestamp, '<dictionary description="Words commonly associated with the adult entertainment industry, including pornographic websites" display_name="Adult" name="00000000-0000-0000-0002-000000000001" pre-defined="true" threshold="4" type="Threshold">            <keyword caseSensitive="false" description="" score="1">brittney</keyword>            <keyword caseSensitive="false" description="" score="1">licking</keyword>            <keyword caseSensitive="false" description="" score="1">marketa</keyword>            <keyword caseSensitive="false" description="" score="1">suzie</keyword>            <keyword caseSensitive="false" description="" score="1">sexvideos</keyword>            <keyword caseSensitive="false" description="" score="1">kash</keyword>            <keyword caseSensitive="false" description="" score="1">adele</keyword>            <keyword caseSensitive="false" description="" score="1">ivana</keyword>            <keyword caseSensitive="false" description="" score="1">ladyboys</keyword>            <keyword caseSensitive="false" description="" score="1">alexa</keyword>            <keyword caseSensitive="false" description="" score="1">becca</keyword>            <keyword caseSensitive="false" description="" score="1">transvestites</keyword>            <keyword caseSensitive="false" description="" score="1">shemales</keyword>            <keyword caseSensitive="false" description="" score="1">nospam</keyword>            <keyword caseSensitive="false" description="" score="1">ohne</keyword>            <keyword caseSensitive="false" description="" score="1">jaymes</keyword>            <keyword caseSensitive="false" description="" score="1">cocks</keyword>            <keyword caseSensitive="false" description="" score="1">klara</keyword>            <keyword caseSensitive="false" description="" score="1">nakita</keyword>            <keyword caseSensitive="false" description="" score="1">kelle</keyword>            <keyword caseSensitive="false" description="" score="1">sexy</keyword>            <keyword caseSensitive="false" description="" score="1">hentai</keyword>            <keyword caseSensitive="false" description="" score="1">breanne</keyword>            <keyword caseSensitive="false" description="" score="1">ebony</keyword>            <keyword caseSensitive="false" description="" score="1">erotica</keyword>            <keyword caseSensitive="false" description="" score="1">bondage</keyword>            <keyword caseSensitive="false" description="" score="1">porno</keyword>            <keyword caseSensitive="false" description="" score="1">bartez</keyword>            <keyword caseSensitive="false" description="" score="1">haluzikova</keyword>            <keyword caseSensitive="false" description="" score="1">kove</keyword>            <keyword caseSensitive="false" description="" score="1">mrhacova</keyword>            <keyword caseSensitive="false" description="" score="1">pornsites</keyword>            <keyword caseSensitive="false" description="" score="1">smetanova</keyword>            <keyword caseSensitive="false" description="" score="1">toyne</keyword>            <keyword caseSensitive="false" description="" score="1">slave</keyword>            <keyword caseSensitive="false" description="" score="1">vids</keyword>            <keyword caseSensitive="false" description="" score="1">sucking</keyword>            <keyword caseSensitive="false" description="" score="1">alaura</keyword>            <keyword caseSensitive="false" description="" score="1">cumshots</keyword>            <keyword caseSensitive="false" description="" score="1">lesabre</keyword>            <keyword caseSensitive="false" description="" score="1">cumshot</keyword>            <keyword caseSensitive="false" description="" score="1">danceporn</keyword>            <keyword caseSensitive="false" description="" score="1">ipostnaked</keyword>            <keyword caseSensitive="false" description="" score="1">mysx</keyword>            <keyword caseSensitive="false" description="" score="1">projectvoyeur</keyword>            <keyword caseSensitive="false" description="" score="1">skankster</keyword>            <keyword caseSensitive="false" description="" score="1">teenpix</keyword>            <keyword caseSensitive="false" description="" score="1">thetruevoyeur</keyword>            <keyword caseSensitive="false" description="" score="1">videowish</keyword>            <keyword caseSensitive="false" description="" score="1">voyeurpost</keyword>            <keyword caseSensitive="false" description="" score="1">voyeurzine</keyword>            <keyword caseSensitive="false" description="" score="1">watchersweb</keyword>            <keyword caseSensitive="false" description="" score="1">plundering</keyword>            <keyword caseSensitive="false" description="" score="1">kostenlos</keyword>            <keyword caseSensitive="false" description="" score="1">busty</keyword>            <keyword caseSensitive="false" description="" score="1">brunette</keyword>            <keyword caseSensitive="false" description="" score="1">fuck</keyword>            <keyword caseSensitive="false" description="" score="1">amateur</keyword>            <keyword caseSensitive="false" description="" score="1">analsex</keyword>            <keyword caseSensitive="false" description="" score="1">slut</keyword>            <keyword caseSensitive="false" description="" score="1">horny</keyword>            <keyword caseSensitive="false" description="" score="1">babe</keyword>            <keyword caseSensitive="false" description="" score="1">bdsm</keyword>            <keyword caseSensitive="false" description="" score="1">blowjob</keyword>            <keyword caseSensitive="false" description="" score="1">tranny</keyword>            <keyword caseSensitive="false" description="" score="1">binaries</keyword>            <keyword caseSensitive="false" description="" score="1">pornstar</keyword>            <keyword caseSensitive="false" description="" score="1">teen</keyword>            <keyword caseSensitive="false" description="" score="1">shemale</keyword>            <keyword caseSensitive="false" description="" score="1">tits</keyword>            <keyword caseSensitive="false" description="" score="1">fucking</keyword>            <keyword caseSensitive="false" description="" score="1">fucked</keyword>            <keyword caseSensitive="false" description="" score="1">milf</keyword>            <keyword caseSensitive="false" description="" score="1">blonde</keyword>            <keyword caseSensitive="false" description="" score="1">incest</keyword>            <keyword caseSensitive="false" description="" score="1">arschfick</keyword>            <keyword caseSensitive="false" description="" score="1">diggerporn</keyword>            <keyword caseSensitive="false" description="" score="1">free-sex</keyword>            <keyword caseSensitive="false" description="" score="1">gallerystop</keyword>            <keyword caseSensitive="false" description="" score="1">hotorange</keyword>            <keyword caseSensitive="false" description="" score="1">arsch</keyword>            <keyword caseSensitive="false" description="" score="1">hardcore</keyword>            <keyword caseSensitive="false" description="" score="1">pics</keyword>            <keyword caseSensitive="false" description="" score="1">rape</keyword>            <keyword caseSensitive="false" description="" score="1">mature</keyword>            <keyword caseSensitive="false" description="" score="1">pussy</keyword>            <keyword caseSensitive="false" description="" score="1">anal</keyword>            <keyword caseSensitive="false" description="" score="1">cock</keyword>            <keyword caseSensitive="false" description="" score="1">porn</keyword>            <keyword caseSensitive="false" description="" score="1">meine</keyword>            <keyword caseSensitive="false" description="" score="1">grammagals</keyword>            <keyword caseSensitive="false" description="" score="1">dicks</keyword>        </dictionary>        ');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','brittney',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','licking',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','marketa',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','suzie',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','sexvideos',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','kash',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','adele',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','ivana',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','ladyboys',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','alexa',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','becca',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','transvestites',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','shemales',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','nospam',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','ohne',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','jaymes',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','cocks',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','klara',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','nakita',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','kelle',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','sexy',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','hentai',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','breanne',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','ebony',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','erotica',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','bondage',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','porno',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','bartez',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','haluzikova',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','kove',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','mrhacova',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','pornsites',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','smetanova',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','toyne',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','slave',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','vids',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','sucking',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','alaura',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','cumshots',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','lesabre',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','cumshot',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','danceporn',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','ipostnaked',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','mysx',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','projectvoyeur',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','skankster',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','teenpix',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','thetruevoyeur',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','videowish',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','voyeurpost',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','voyeurzine',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','watchersweb',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','plundering',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','kostenlos',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','busty',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','brunette',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','fuck',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','amateur',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','analsex',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','slut',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','horny',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','babe',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','bdsm',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','blowjob',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','tranny',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','binaries',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','pornstar',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','teen',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','shemale',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','tits',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','fucking',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','fucked',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','milf',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','blonde',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','incest',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','arschfick',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','diggerporn',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','free-sex',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','gallerystop',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','hotorange',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','arsch',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','hardcore',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','pics',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','rape',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','mature',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','pussy',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','anal',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','cock',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','porn',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','meine',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','grammagals',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000001','dicks',false, '1');
insert into tb_dlp_keyword_list(name, display_name, description, criteria, char_number, score, pre_define, modified, content) values('00000000-0000-0000-0002-000000000002' ,'Forms: First Name, Last Name', 'Common use of the (First Name) and (Last Name) fields in documents such as forms',2, 50, 0, true, current_timestamp, '<dictionary description="Common use of the (First Name) and (Last Name) fields in documents such as forms" display_name="Forms: First Name, Last Name" name="00000000-0000-0000-0002-000000000002" number="50" pre-defined="true" type="Distance">            <keyword caseSensitive="false" description="" score="0">First Name</keyword>            <keyword caseSensitive="false" description="" score="0">Last Name</keyword>        </dictionary>        ');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000002','First Name',false, '0');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000002','Last Name',false, '0');
insert into tb_dlp_keyword_list(name, display_name, description, criteria, char_number, score, pre_define, modified, content) values('00000000-0000-0000-0002-000000000003' ,'Forms: (First), (Middle), Name', 'Common use of the (First), (Middle) and (Last Name) fields in documents such as forms',2, 50, 0, true, current_timestamp, '<dictionary description="Common use of the (First), (Middle) and (Last Name) fields in documents such as forms" display_name="Forms: (First), (Middle), Name" name="00000000-0000-0000-0002-000000000003" number="50" pre-defined="true" type="Distance">            <keyword caseSensitive="false" description="" score="0">(Middle)</keyword>            <keyword caseSensitive="false" description="" score="0">(First)</keyword>            <keyword caseSensitive="false" description="" score="0">Name</keyword>        </dictionary>        ');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000003','(Middle)',false, '0');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000003','(First)',false, '0');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000003','Name',false, '0');
insert into tb_dlp_keyword_list(name, display_name, description, criteria, char_number, score, pre_define, modified, content) values('00000000-0000-0000-0002-000000000004' ,'Source Code: C/C++', 'Common source code functions/commands used in C/C++',3, 0, 10, true, current_timestamp, '<dictionary description="Common source code functions/commands used in C/C++" display_name="Source Code: C/C++" name="00000000-0000-0000-0002-000000000004" pre-defined="true" threshold="10" type="Threshold">            <keyword caseSensitive="true" description="" score="1">#define</keyword>            <keyword caseSensitive="true" description="" score="1">#include</keyword>            <keyword caseSensitive="true" description="" score="1">#ifndef</keyword>            <keyword caseSensitive="true" description="" score="1">#ifdef</keyword>            <keyword caseSensitive="true" description="" score="1">#else</keyword>            <keyword caseSensitive="true" description="" score="1">#endif</keyword>            <keyword caseSensitive="true" description="" score="1">#undef</keyword>            <keyword caseSensitive="true" description="" score="1">#error</keyword>            <keyword caseSensitive="true" description="" score="1">#pragma</keyword>            <keyword caseSensitive="true" description="" score="1">#line</keyword>            <keyword caseSensitive="true" description="" score="1">!defined</keyword>            <keyword caseSensitive="true" description="" score="1">errno.h</keyword>            <keyword caseSensitive="true" description="" score="1">stddef.h</keyword>            <keyword caseSensitive="true" description="" score="1">assert.h</keyword>            <keyword caseSensitive="true" description="" score="1">ctype.h</keyword>            <keyword caseSensitive="true" description="" score="1">locale.h</keyword>            <keyword caseSensitive="true" description="" score="1">math.h</keyword>            <keyword caseSensitive="true" description="" score="1">setjmp.h</keyword>            <keyword caseSensitive="true" description="" score="1">signal.h</keyword>            <keyword caseSensitive="true" description="" score="1">stdarg.h</keyword>            <keyword caseSensitive="true" description="" score="1">stdio.h</keyword>            <keyword caseSensitive="true" description="" score="1">stdlib.h</keyword>            <keyword caseSensitive="true" description="" score="1">string.h</keyword>            <keyword caseSensitive="true" description="" score="1">time.h</keyword>            <keyword caseSensitive="true" description="" score="1">limits.h</keyword>            <keyword caseSensitive="true" description="" score="1">float.h</keyword>            <keyword caseSensitive="true" description="" score="1">&lt;vector&gt;</keyword>            <keyword caseSensitive="true" description="" score="1">iostream.h</keyword>            <keyword caseSensitive="true" description="" score="1">fstream.h</keyword>            <keyword caseSensitive="true" description="" score="1">iomanip.h</keyword>            <keyword caseSensitive="true" description="" score="1">strstream.h</keyword>            <keyword caseSensitive="true" description="" score="1">__LINE__</keyword>            <keyword caseSensitive="true" description="" score="1">__FILE__</keyword>            <keyword caseSensitive="true" description="" score="1">__DATE__</keyword>            <keyword caseSensitive="true" description="" score="1">__TIME__</keyword>            <keyword caseSensitive="true" description="" score="1">__STDC__</keyword>            <keyword caseSensitive="true" description="" score="1">_int64</keyword>            <keyword caseSensitive="true" description="" score="1">WIN32</keyword>            <keyword caseSensitive="true" description="" score="1">EDOM</keyword>            <keyword caseSensitive="true" description="" score="1">ERANGE</keyword>            <keyword caseSensitive="true" description="" score="1">errno</keyword>            <keyword caseSensitive="true" description="" score="1">offsetof</keyword>            <keyword caseSensitive="true" description="" score="1">ptrdiff_t</keyword>            <keyword caseSensitive="true" description="" score="1">wchar_t</keyword>            <keyword caseSensitive="true" description="" score="1">NDEBUG</keyword>            <keyword caseSensitive="true" description="" score="1">LC_ALL</keyword>            <keyword caseSensitive="true" description="" score="1">LC_COLLATE</keyword>            <keyword caseSensitive="true" description="" score="1">LC_CTYPE</keyword>            <keyword caseSensitive="true" description="" score="1">LC_MONETARY</keyword>            <keyword caseSensitive="true" description="" score="1">LC_NUMERIC</keyword>            <keyword caseSensitive="true" description="" score="1">LC_TIME</keyword>            <keyword caseSensitive="true" description="" score="1">sig_atomic_t</keyword>            <keyword caseSensitive="true" description="" score="1">SIG_DFL</keyword>            <keyword caseSensitive="true" description="" score="1">SIG_ERR</keyword>            <keyword caseSensitive="true" description="" score="1">SIG_IGN</keyword>            <keyword caseSensitive="true" description="" score="1">SIGABRT</keyword>            <keyword caseSensitive="true" description="" score="1">SIGFPE</keyword>            <keyword caseSensitive="true" description="" score="1">SIGILL</keyword>            <keyword caseSensitive="true" description="" score="1">SIGINT</keyword>            <keyword caseSensitive="true" description="" score="1">SIGSEGV</keyword>            <keyword caseSensitive="true" description="" score="1">SIGTERM</keyword>            <keyword caseSensitive="true" description="" score="1">_IOFBF</keyword>            <keyword caseSensitive="true" description="" score="1">_IOLBF</keyword>            <keyword caseSensitive="true" description="" score="1">_IONBF</keyword>            <keyword caseSensitive="true" description="" score="1">BUFSIZ</keyword>            <keyword caseSensitive="true" description="" score="1">FILENAME_MAX</keyword>            <keyword caseSensitive="true" description="" score="1">FOPEN_MAX</keyword>            <keyword caseSensitive="true" description="" score="1">fpos_t</keyword>            <keyword caseSensitive="true" description="" score="1">SEEK_CUR</keyword>            <keyword caseSensitive="true" description="" score="1">SEEK_END</keyword>            <keyword caseSensitive="true" description="" score="1">SEEK_SET</keyword>            <keyword caseSensitive="true" description="" score="1">EXIT_FAILURE</keyword>            <keyword caseSensitive="true" description="" score="1">EXIT_SUCCESS</keyword>            <keyword caseSensitive="true" description="" score="1">MB_CUR_MAX</keyword>            <keyword caseSensitive="true" description="" score="1">RAND_MAX</keyword>            <keyword caseSensitive="true" description="" score="1">CLOCKS_PER_SEC</keyword>            <keyword caseSensitive="true" description="" score="1">size_t</keyword>            <keyword caseSensitive="true" description="" score="1">clock_t</keyword>            <keyword caseSensitive="true" description="" score="1">time_t</keyword>            <keyword caseSensitive="true" description="" score="1">stderr</keyword>            <keyword caseSensitive="true" description="" score="1">stdin</keyword>            <keyword caseSensitive="true" description="" score="1">stdout</keyword>            <keyword caseSensitive="true" description="" score="1">TMP_MAX</keyword>            <keyword caseSensitive="true" description="" score="1">fclose</keyword>            <keyword caseSensitive="true" description="" score="1">fopen</keyword>            <keyword caseSensitive="true" description="" score="1">fflush</keyword>            <keyword caseSensitive="true" description="" score="1">freopen</keyword>            <keyword caseSensitive="true" description="" score="1">setbuf</keyword>            <keyword caseSensitive="true" description="" score="1">setvbuf</keyword>            <keyword caseSensitive="true" description="" score="1">fprintf</keyword>            <keyword caseSensitive="true" description="" score="1">fscanf</keyword>            <keyword caseSensitive="true" description="" score="1">printf</keyword>            <keyword caseSensitive="true" description="" score="1">scanf</keyword>            <keyword caseSensitive="true" description="" score="1">sprintf</keyword>            <keyword caseSensitive="true" description="" score="1">sscanf</keyword>            <keyword caseSensitive="true" description="" score="1">vfprintf</keyword>            <keyword caseSensitive="true" description="" score="1">vprintf</keyword>            <keyword caseSensitive="true" description="" score="1">vsprintf</keyword>            <keyword caseSensitive="true" description="" score="1">fgetc</keyword>            <keyword caseSensitive="true" description="" score="1">fgets</keyword>            <keyword caseSensitive="true" description="" score="1">fputc</keyword>            <keyword caseSensitive="true" description="" score="1">fputs</keyword>            <keyword caseSensitive="true" description="" score="1">getchar</keyword>            <keyword caseSensitive="true" description="" score="1">putchar</keyword>            <keyword caseSensitive="true" description="" score="1">ungetc</keyword>            <keyword caseSensitive="true" description="" score="1">fread</keyword>            <keyword caseSensitive="true" description="" score="1">fwrite</keyword>            <keyword caseSensitive="true" description="" score="1">fgetpos</keyword>            <keyword caseSensitive="true" description="" score="1">fseek</keyword>            <keyword caseSensitive="true" description="" score="1">fsetpos</keyword>            <keyword caseSensitive="true" description="" score="1">ftell</keyword>            <keyword caseSensitive="true" description="" score="1">rewind</keyword>            <keyword caseSensitive="true" description="" score="1">clearerr</keyword>            <keyword caseSensitive="true" description="" score="1">feof(</keyword>            <keyword caseSensitive="true" description="" score="1">ferror</keyword>            <keyword caseSensitive="true" description="" score="1">perror</keyword>            <keyword caseSensitive="true" description="" score="1">atof(</keyword>            <keyword caseSensitive="true" description="" score="1">atoi(</keyword>            <keyword caseSensitive="true" description="" score="1">atol(</keyword>            <keyword caseSensitive="true" description="" score="1">strtod</keyword>            <keyword caseSensitive="true" description="" score="1">strtol</keyword>            <keyword caseSensitive="true" description="" score="1">strtoul</keyword>            <keyword caseSensitive="true" description="" score="1">rand(</keyword>            <keyword caseSensitive="true" description="" score="1">srand(</keyword>            <keyword caseSensitive="true" description="" score="1">calloc</keyword>            <keyword caseSensitive="true" description="" score="1">free(</keyword>            <keyword caseSensitive="true" description="" score="1">malloc</keyword>            <keyword caseSensitive="true" description="" score="1">realloc</keyword>            <keyword caseSensitive="true" description="" score="1">abort(</keyword>            <keyword caseSensitive="true" description="" score="1">atexit</keyword>            <keyword caseSensitive="true" description="" score="1">exit(</keyword>            <keyword caseSensitive="true" description="" score="1">getenv</keyword>            <keyword caseSensitive="true" description="" score="1">system(</keyword>            <keyword caseSensitive="true" description="" score="1">bsearch</keyword>            <keyword caseSensitive="true" description="" score="1">qsort</keyword>            <keyword caseSensitive="true" description="" score="1">labs(</keyword>            <keyword caseSensitive="true" description="" score="1">ldiv(</keyword>            <keyword caseSensitive="true" description="" score="1">mblen</keyword>            <keyword caseSensitive="true" description="" score="1">mbtowc</keyword>            <keyword caseSensitive="true" description="" score="1">wctomb</keyword>            <keyword caseSensitive="true" description="" score="1">mbstowcs</keyword>            <keyword caseSensitive="true" description="" score="1">wcstombs</keyword>            <keyword caseSensitive="true" description="" score="1">memmove</keyword>            <keyword caseSensitive="true" description="" score="1">strcpy</keyword>            <keyword caseSensitive="true" description="" score="1">strncpy</keyword>            <keyword caseSensitive="true" description="" score="1">strcat</keyword>            <keyword caseSensitive="true" description="" score="1">strncat</keyword>            <keyword caseSensitive="true" description="" score="1">memcpy</keyword>            <keyword caseSensitive="true" description="" score="1">memcmp</keyword>            <keyword caseSensitive="true" description="" score="1">strcmp</keyword>            <keyword caseSensitive="true" description="" score="1">strcoll</keyword>            <keyword caseSensitive="true" description="" score="1">strncmp</keyword>            <keyword caseSensitive="true" description="" score="1">strxfrm</keyword>            <keyword caseSensitive="true" description="" score="1">memchr</keyword>            <keyword caseSensitive="true" description="" score="1">strchr</keyword>            <keyword caseSensitive="true" description="" score="1">strcspn</keyword>            <keyword caseSensitive="true" description="" score="1">strpbrk</keyword>            <keyword caseSensitive="true" description="" score="1">strrchr</keyword>            <keyword caseSensitive="true" description="" score="1">strspn</keyword>            <keyword caseSensitive="true" description="" score="1">strstr</keyword>            <keyword caseSensitive="true" description="" score="1">strtok</keyword>            <keyword caseSensitive="true" description="" score="1">memset</keyword>            <keyword caseSensitive="true" description="" score="1">strerror</keyword>            <keyword caseSensitive="true" description="" score="1">strlen</keyword>            <keyword caseSensitive="true" description="" score="1">clock(</keyword>            <keyword caseSensitive="true" description="" score="1">difftime</keyword>            <keyword caseSensitive="true" description="" score="1">mktime</keyword>            <keyword caseSensitive="true" description="" score="1">time(</keyword>            <keyword caseSensitive="true" description="" score="1">asctime</keyword>            <keyword caseSensitive="true" description="" score="1">ctime</keyword>            <keyword caseSensitive="true" description="" score="1">gmtime</keyword>            <keyword caseSensitive="true" description="" score="1">localtime</keyword>            <keyword caseSensitive="true" description="" score="1">strftime</keyword>            <keyword caseSensitive="true" description="" score="1">namespace</keyword>            <keyword caseSensitive="true" description="" score="1">template</keyword>            <keyword caseSensitive="true" description="" score="1">public:</keyword>            <keyword caseSensitive="true" description="" score="1">private:</keyword>            <keyword caseSensitive="true" description="" score="1">protected:</keyword>            <keyword caseSensitive="true" description="" score="1">assert(</keyword>            <keyword caseSensitive="true" description="" score="1">__cplusplus</keyword>            <keyword caseSensitive="true" description="" score="1">extern "C"</keyword>            <keyword caseSensitive="true" description="" score="1">typedef</keyword>            <keyword caseSensitive="true" description="" score="1">catch(</keyword>            <keyword caseSensitive="true" description="" score="1">catch (</keyword>            <keyword caseSensitive="true" description="" score="1">for (</keyword>            <keyword caseSensitive="true" description="" score="1">while(</keyword>            <keyword caseSensitive="true" description="" score="1">while (</keyword>            <keyword caseSensitive="true" description="" score="1">main(</keyword>            <keyword caseSensitive="true" description="" score="1">main (</keyword>            <keyword caseSensitive="true" description="" score="1">try {</keyword>            <keyword caseSensitive="true" description="" score="1">cout&lt;&lt;</keyword>            <keyword caseSensitive="true" description="" score="1">cout &lt;&lt;</keyword>            <keyword caseSensitive="true" description="" score="1">cin&gt;&gt;</keyword>            <keyword caseSensitive="true" description="" score="1">cin &gt;&gt;</keyword>            <keyword caseSensitive="true" description="" score="1">cerr&lt;&lt;</keyword>            <keyword caseSensitive="true" description="" score="1">cerr &lt;&lt;</keyword>            <keyword caseSensitive="true" description="" score="1">isalnum</keyword>            <keyword caseSensitive="true" description="" score="1">isalpha</keyword>            <keyword caseSensitive="true" description="" score="1">iscntrl</keyword>            <keyword caseSensitive="true" description="" score="1">isdigit</keyword>            <keyword caseSensitive="true" description="" score="1">isgraph</keyword>            <keyword caseSensitive="true" description="" score="1">islower</keyword>            <keyword caseSensitive="true" description="" score="1">isprint</keyword>            <keyword caseSensitive="true" description="" score="1">ispunct</keyword>            <keyword caseSensitive="true" description="" score="1">isspace</keyword>            <keyword caseSensitive="true" description="" score="1">issupper</keyword>            <keyword caseSensitive="true" description="" score="1">isxdigit</keyword>            <keyword caseSensitive="true" description="" score="1">tolower</keyword>            <keyword caseSensitive="true" description="" score="1">toupper</keyword>            <keyword caseSensitive="true" description="" score="1">setlocale</keyword>            <keyword caseSensitive="true" description="" score="1">localeconv</keyword>            <keyword caseSensitive="true" description="" score="1">acos(</keyword>            <keyword caseSensitive="true" description="" score="1">asin(</keyword>            <keyword caseSensitive="true" description="" score="1">atan(</keyword>            <keyword caseSensitive="true" description="" score="1">atan2(</keyword>            <keyword caseSensitive="true" description="" score="1">cosh(</keyword>            <keyword caseSensitive="true" description="" score="1">sinh(</keyword>            <keyword caseSensitive="true" description="" score="1">tanh(</keyword>            <keyword caseSensitive="true" description="" score="1">frexp(</keyword>            <keyword caseSensitive="true" description="" score="1">ldexp(</keyword>            <keyword caseSensitive="true" description="" score="1">log10</keyword>            <keyword caseSensitive="true" description="" score="1">modf(</keyword>            <keyword caseSensitive="true" description="" score="1">sqrt(</keyword>            <keyword caseSensitive="true" description="" score="1">ceil(</keyword>            <keyword caseSensitive="true" description="" score="1">fabs(</keyword>            <keyword caseSensitive="true" description="" score="1">floor(</keyword>            <keyword caseSensitive="true" description="" score="1">fmod(</keyword>            <keyword caseSensitive="true" description="" score="1">setjmp</keyword>            <keyword caseSensitive="true" description="" score="1">longjmp</keyword>            <keyword caseSensitive="true" description="" score="1">signal(</keyword>            <keyword caseSensitive="true" description="" score="1">raise(</keyword>            <keyword caseSensitive="true" description="" score="1">va_list</keyword>            <keyword caseSensitive="true" description="" score="1">va_start</keyword>            <keyword caseSensitive="true" description="" score="1">va_arg</keyword>            <keyword caseSensitive="true" description="" score="1">va_end</keyword>            <keyword caseSensitive="true" description="" score="1">unsigned int</keyword>            <keyword caseSensitive="true" description="" score="1">unsigned long</keyword>            <keyword caseSensitive="true" description="" score="1">unsigned short</keyword>            <keyword caseSensitive="true" description="" score="1">unsigned char</keyword>            <keyword caseSensitive="true" description="" score="1">char *</keyword>            <keyword caseSensitive="true" description="" score="1">void *</keyword>            <keyword caseSensitive="true" description="" score="1">void*</keyword>            <keyword caseSensitive="true" description="" score="1">int *</keyword>            <keyword caseSensitive="true" description="" score="1">long *</keyword>            <keyword caseSensitive="true" description="" score="1">long*</keyword>            <keyword caseSensitive="true" description="" score="1">short *</keyword>            <keyword caseSensitive="true" description="" score="1">short*</keyword>            <keyword caseSensitive="true" description="" score="1">longlong</keyword>            <keyword caseSensitive="true" description="" score="1">long long</keyword>            <keyword caseSensitive="true" description="" score="1">double *</keyword>            <keyword caseSensitive="true" description="" score="1">double*</keyword>            <keyword caseSensitive="true" description="" score="1">float *</keyword>            <keyword caseSensitive="true" description="" score="1">float*</keyword>            <keyword caseSensitive="true" description="" score="1">ofstream</keyword>            <keyword caseSensitive="true" description="" score="1">ifstream</keyword>            <keyword caseSensitive="true" description="" score="1">istrstream</keyword>            <keyword caseSensitive="true" description="" score="1">ostrstream</keyword>            <keyword caseSensitive="true" description="" score="1">istream</keyword>            <keyword caseSensitive="true" description="" score="1">ostream</keyword>        </dictionary>        ');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','#define',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','#include',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','#ifndef',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','#ifdef',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','#else',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','#endif',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','#undef',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','#error',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','#pragma',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','#line',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','!defined',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','errno.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','stddef.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','assert.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ctype.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','locale.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','math.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','setjmp.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','signal.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','stdarg.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','stdio.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','stdlib.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','string.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','time.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','limits.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','float.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','<vector>',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','iostream.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fstream.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','iomanip.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strstream.h',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','__LINE__',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','__FILE__',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','__DATE__',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','__TIME__',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','__STDC__',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','_int64',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','WIN32',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','EDOM',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ERANGE',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','errno',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','offsetof',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ptrdiff_t',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','wchar_t',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','NDEBUG',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','LC_ALL',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','LC_COLLATE',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','LC_CTYPE',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','LC_MONETARY',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','LC_NUMERIC',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','LC_TIME',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','sig_atomic_t',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','SIG_DFL',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','SIG_ERR',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','SIG_IGN',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','SIGABRT',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','SIGFPE',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','SIGILL',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','SIGINT',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','SIGSEGV',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','SIGTERM',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','_IOFBF',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','_IOLBF',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','_IONBF',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','BUFSIZ',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','FILENAME_MAX',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','FOPEN_MAX',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fpos_t',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','SEEK_CUR',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','SEEK_END',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','SEEK_SET',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','EXIT_FAILURE',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','EXIT_SUCCESS',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','MB_CUR_MAX',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','RAND_MAX',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','CLOCKS_PER_SEC',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','size_t',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','clock_t',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','time_t',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','stderr',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','stdin',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','stdout',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','TMP_MAX',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fclose',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fopen',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fflush',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','freopen',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','setbuf',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','setvbuf',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fprintf',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fscanf',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','printf',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','scanf',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','sprintf',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','sscanf',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','vfprintf',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','vprintf',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','vsprintf',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fgetc',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fgets',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fputc',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fputs',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','getchar',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','putchar',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ungetc',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fread',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fwrite',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fgetpos',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fseek',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fsetpos',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ftell',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','rewind',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','clearerr',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','feof(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ferror',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','perror',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','atof(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','atoi(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','atol(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strtod',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strtol',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strtoul',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','rand(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','srand(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','calloc',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','free(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','malloc',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','realloc',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','abort(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','atexit',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','exit(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','getenv',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','system(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','bsearch',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','qsort',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','labs(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ldiv(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','mblen',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','mbtowc',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','wctomb',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','mbstowcs',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','wcstombs',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','memmove',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strcpy',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strncpy',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strcat',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strncat',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','memcpy',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','memcmp',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strcmp',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strcoll',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strncmp',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strxfrm',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','memchr',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strchr',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strcspn',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strpbrk',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strrchr',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strspn',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strstr',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strtok',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','memset',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strerror',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strlen',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','clock(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','difftime',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','mktime',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','time(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','asctime',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ctime',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','gmtime',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','localtime',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','strftime',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','namespace',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','template',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','public:',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','private:',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','protected:',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','assert(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','__cplusplus',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','extern "C"',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','typedef',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','catch(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','catch (',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','for (',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','while(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','while (',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','main(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','main (',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','try {',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','cout<<',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','cout <<',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','cin>>',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','cin >>',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','cerr<<',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','cerr <<',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','isalnum',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','isalpha',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','iscntrl',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','isdigit',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','isgraph',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','islower',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','isprint',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ispunct',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','isspace',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','issupper',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','isxdigit',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','tolower',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','toupper',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','setlocale',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','localeconv',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','acos(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','asin(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','atan(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','atan2(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','cosh(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','sinh(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','tanh(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','frexp(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ldexp(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','log10',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','modf(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','sqrt(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ceil(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fabs(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','floor(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','fmod(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','setjmp',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','longjmp',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','signal(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','raise(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','va_list',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','va_start',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','va_arg',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','va_end',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','unsigned int',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','unsigned long',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','unsigned short',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','unsigned char',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','char *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','void *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','void*',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','int *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','long *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','long*',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','short *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','short*',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','longlong',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','long long',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','double *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','double*',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','float *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','float*',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ofstream',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ifstream',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','istrstream',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ostrstream',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','istream',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000004','ostream',true, '1');
insert into tb_dlp_keyword_list(name, display_name, description, criteria, char_number, score, pre_define, modified, content) values('00000000-0000-0000-0002-000000000005' ,'Source Code: C#', 'Common source code functions/commands used in C#',3, 0, 10, true, current_timestamp, '<dictionary description="Common source code functions/commands used in C#" display_name="Source Code: C#" name="00000000-0000-0000-0002-000000000005" pre-defined="true" threshold="10" type="Threshold">            <keyword caseSensitive="true" description="" score="1">namespace</keyword>            <keyword caseSensitive="true" description="" score="1">using System;</keyword>            <keyword caseSensitive="true" description="" score="1">using System.</keyword>            <keyword caseSensitive="true" description="" score="1">public class</keyword>            <keyword caseSensitive="true" description="" score="1">public abstract</keyword>            <keyword caseSensitive="true" description="" score="1">public interface</keyword>            <keyword caseSensitive="true" description="" score="1">public final</keyword>            <keyword caseSensitive="true" description="" score="1">public static</keyword>            <keyword caseSensitive="true" description="" score="1">public int</keyword>            <keyword caseSensitive="true" description="" score="1">public long</keyword>            <keyword caseSensitive="true" description="" score="1">public short</keyword>            <keyword caseSensitive="true" description="" score="1">public string</keyword>            <keyword caseSensitive="true" description="" score="1">public boolean</keyword>            <keyword caseSensitive="true" description="" score="1">public byte</keyword>            <keyword caseSensitive="true" description="" score="1">public sbyte</keyword>            <keyword caseSensitive="true" description="" score="1">public ushort</keyword>            <keyword caseSensitive="true" description="" score="1">public ulong</keyword>            <keyword caseSensitive="true" description="" score="1">public decimal</keyword>            <keyword caseSensitive="true" description="" score="1">public double</keyword>            <keyword caseSensitive="true" description="" score="1">public void</keyword>            <keyword caseSensitive="true" description="" score="1">public override</keyword>            <keyword caseSensitive="true" description="" score="1">public delegate</keyword>            <keyword caseSensitive="true" description="" score="1">private class</keyword>            <keyword caseSensitive="true" description="" score="1">private abstract</keyword>            <keyword caseSensitive="true" description="" score="1">private final</keyword>            <keyword caseSensitive="true" description="" score="1">private static</keyword>            <keyword caseSensitive="true" description="" score="1">private int</keyword>            <keyword caseSensitive="true" description="" score="1">private long</keyword>            <keyword caseSensitive="true" description="" score="1">private short</keyword>            <keyword caseSensitive="true" description="" score="1">private string</keyword>            <keyword caseSensitive="true" description="" score="1">private boolean</keyword>            <keyword caseSensitive="true" description="" score="1">private byte</keyword>            <keyword caseSensitive="true" description="" score="1">private sbyte</keyword>            <keyword caseSensitive="true" description="" score="1">private ushort</keyword>            <keyword caseSensitive="true" description="" score="1">private ulong</keyword>            <keyword caseSensitive="true" description="" score="1">private decimal</keyword>            <keyword caseSensitive="true" description="" score="1">private double</keyword>            <keyword caseSensitive="true" description="" score="1">protected abstract</keyword>            <keyword caseSensitive="true" description="" score="1">protectedfinal</keyword>            <keyword caseSensitive="true" description="" score="1">protected static</keyword>            <keyword caseSensitive="true" description="" score="1">protected int</keyword>            <keyword caseSensitive="true" description="" score="1">protected long</keyword>            <keyword caseSensitive="true" description="" score="1">protected short</keyword>            <keyword caseSensitive="true" description="" score="1">protected string</keyword>            <keyword caseSensitive="true" description="" score="1">protected boolean</keyword>            <keyword caseSensitive="true" description="" score="1">protected byte</keyword>            <keyword caseSensitive="true" description="" score="1">protected sbyte</keyword>            <keyword caseSensitive="true" description="" score="1">protected ushort</keyword>            <keyword caseSensitive="true" description="" score="1">protected ulong</keyword>            <keyword caseSensitive="true" description="" score="1">protected decimal</keyword>            <keyword caseSensitive="true" description="" score="1">protected double</keyword>            <keyword caseSensitive="true" description="" score="1">protected void</keyword>            <keyword caseSensitive="true" description="" score="1">protected virtual</keyword>            <keyword caseSensitive="true" description="" score="1">catch(</keyword>            <keyword caseSensitive="true" description="" score="1">catch (</keyword>            <keyword caseSensitive="true" description="" score="1">finally{</keyword>            <keyword caseSensitive="true" description="" score="1">finally {</keyword>            <keyword caseSensitive="true" description="" score="1">Main(</keyword>            <keyword caseSensitive="true" description="" score="1">Main (</keyword>            <keyword caseSensitive="true" description="" score="1">for (</keyword>            <keyword caseSensitive="true" description="" score="1">foreach</keyword>            <keyword caseSensitive="true" description="" score="1">while(</keyword>            <keyword caseSensitive="true" description="" score="1">while (</keyword>            <keyword caseSensitive="true" description="" score="1">switch(</keyword>            <keyword caseSensitive="true" description="" score="1">switch (</keyword>            <keyword caseSensitive="true" description="" score="1">default :</keyword>            <keyword caseSensitive="true" description="" score="1">default:</keyword>            <keyword caseSensitive="true" description="" score="1">break;</keyword>            <keyword caseSensitive="true" description="" score="1">break ;</keyword>            <keyword caseSensitive="true" description="" score="1">else if</keyword>            <keyword caseSensitive="true" description="" score="1">return false</keyword>            <keyword caseSensitive="true" description="" score="1">return true</keyword>            <keyword caseSensitive="true" description="" score="1">return null</keyword>            <keyword caseSensitive="true" description="" score="1">return new</keyword>            <keyword caseSensitive="true" description="" score="1">throw new</keyword>            <keyword caseSensitive="true" description="" score="1">throws Exception</keyword>            <keyword caseSensitive="true" description="" score="1">.GetLength(</keyword>            <keyword caseSensitive="true" description="" score="1">.Length(</keyword>            <keyword caseSensitive="true" description="" score="1">.Reverse(</keyword>            <keyword caseSensitive="true" description="" score="1">.Sort(</keyword>            <keyword caseSensitive="true" description="" score="1">.WriteLine(</keyword>            <keyword caseSensitive="true" description="" score="1">.ToString(</keyword>            <keyword caseSensitive="true" description="" score="1">.GetHashCode(</keyword>            <keyword caseSensitive="true" description="" score="1">.Equals(</keyword>            <keyword caseSensitive="true" description="" score="1">.ReferenceEquals(</keyword>            <keyword caseSensitive="true" description="" score="1">.GetType(</keyword>            <keyword caseSensitive="true" description="" score="1">.MemberwiseClone(</keyword>            <keyword caseSensitive="true" description="" score="1">sizeof(</keyword>            <keyword caseSensitive="true" description="" score="1">.Finalize(</keyword>            <keyword caseSensitive="true" description="" score="1">.Compare(</keyword>            <keyword caseSensitive="true" description="" score="1">.CompareOrdinal</keyword>            <keyword caseSensitive="true" description="" score="1">.Format(</keyword>            <keyword caseSensitive="true" description="" score="1">.IndexOf(</keyword>            <keyword caseSensitive="true" description="" score="1">.IndexOfAny</keyword>            <keyword caseSensitive="true" description="" score="1">.LastIndexOfAny</keyword>            <keyword caseSensitive="true" description="" score="1">.PadRight</keyword>            <keyword caseSensitive="true" description="" score="1">.PadLeft</keyword>            <keyword caseSensitive="true" description="" score="1">.Replace(</keyword>            <keyword caseSensitive="true" description="" score="1">.Split(</keyword>            <keyword caseSensitive="true" description="" score="1">.SubString(</keyword>            <keyword caseSensitive="true" description="" score="1">.ToLower(</keyword>            <keyword caseSensitive="true" description="" score="1">.ToUpper(</keyword>            <keyword caseSensitive="true" description="" score="1">.Trim(</keyword>            <keyword caseSensitive="true" description="" score="1">.Append(</keyword>            <keyword caseSensitive="true" description="" score="1">.AppendFormat</keyword>            <keyword caseSensitive="true" description="" score="1">.Insert(</keyword>            <keyword caseSensitive="true" description="" score="1">.Remove(</keyword>            <keyword caseSensitive="true" description="" score="1">string[]</keyword>            <keyword caseSensitive="true" description="" score="1">sbyte</keyword>            <keyword caseSensitive="true" description="" score="1">ushort</keyword>            <keyword caseSensitive="true" description="" score="1">ulong</keyword>            <keyword caseSensitive="true" description="" score="1">(int*)</keyword>            <keyword caseSensitive="true" description="" score="1">(long*)</keyword>            <keyword caseSensitive="true" description="" score="1">(short*)</keyword>            <keyword caseSensitive="true" description="" score="1">(string*)</keyword>            <keyword caseSensitive="true" description="" score="1">(boolean*)</keyword>            <keyword caseSensitive="true" description="" score="1">(sbyte*)</keyword>            <keyword caseSensitive="true" description="" score="1">(ushort*)</keyword>            <keyword caseSensitive="true" description="" score="1">(ulong*)</keyword>            <keyword caseSensitive="true" description="" score="1">(decimal*)</keyword>            <keyword caseSensitive="true" description="" score="1">(void*)</keyword>            <keyword caseSensitive="true" description="" score="1">(byte*)</keyword>            <keyword caseSensitive="true" description="" score="1">(uint*)</keyword>            <keyword caseSensitive="true" description="" score="1">long *</keyword>            <keyword caseSensitive="true" description="" score="1">short *</keyword>            <keyword caseSensitive="true" description="" score="1">string *</keyword>            <keyword caseSensitive="true" description="" score="1">boolean *</keyword>            <keyword caseSensitive="true" description="" score="1">sbyte *</keyword>            <keyword caseSensitive="true" description="" score="1">ushort *</keyword>            <keyword caseSensitive="true" description="" score="1">ulong *</keyword>            <keyword caseSensitive="true" description="" score="1">decimal *</keyword>            <keyword caseSensitive="true" description="" score="1">void *</keyword>            <keyword caseSensitive="true" description="" score="1">byte *</keyword>            <keyword caseSensitive="true" description="" score="1">uint *</keyword>        </dictionary>        ');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','namespace',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','using System;',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','using System.',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public class',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public abstract',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public interface',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public final',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public static',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public int',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public long',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public short',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public string',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public boolean',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public byte',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public sbyte',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public ushort',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public ulong',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public decimal',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public double',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public void',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public override',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','public delegate',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private class',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private abstract',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private final',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private static',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private int',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private long',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private short',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private string',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private boolean',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private byte',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private sbyte',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private ushort',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private ulong',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private decimal',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','private double',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected abstract',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protectedfinal',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected static',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected int',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected long',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected short',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected string',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected boolean',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected byte',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected sbyte',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected ushort',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected ulong',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected decimal',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected double',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected void',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','protected virtual',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','catch(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','catch (',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','finally{',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','finally {',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','Main(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','Main (',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','for (',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','foreach',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','while(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','while (',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','switch(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','switch (',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','default :',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','default:',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','break;',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','break ;',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','else if',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','return false',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','return true',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','return null',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','return new',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','throw new',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','throws Exception',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.GetLength(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.Length(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.Reverse(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.Sort(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.WriteLine(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.ToString(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.GetHashCode(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.Equals(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.ReferenceEquals(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.GetType(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.MemberwiseClone(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','sizeof(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.Finalize(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.Compare(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.CompareOrdinal',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.Format(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.IndexOf(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.IndexOfAny',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.LastIndexOfAny',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.PadRight',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.PadLeft',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.Replace(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.Split(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.SubString(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.ToLower(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.ToUpper(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.Trim(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.Append(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.AppendFormat',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.Insert(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','.Remove(',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','string[]',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','sbyte',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','ushort',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','ulong',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','(int*)',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','(long*)',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','(short*)',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','(string*)',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','(boolean*)',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','(sbyte*)',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','(ushort*)',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','(ulong*)',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','(decimal*)',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','(void*)',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','(byte*)',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','(uint*)',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','long *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','short *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','string *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','boolean *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','sbyte *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','ushort *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','ulong *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','decimal *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','void *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','byte *',true, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000005','uint *',true, '1');
insert into tb_dlp_keyword_list(name, display_name, description, criteria, char_number, score, pre_define, modified, content) values('00000000-0000-0000-0002-000000000006' ,'Source Code: COBOL', 'Common source code functions/commands used in COBOL',3, 0, 10, true, current_timestamp, '<dictionary description="Common source code functions/commands used in COBOL" display_name="Source Code: COBOL" name="00000000-0000-0000-0002-000000000006" pre-defined="true" threshold="10" type="Threshold">            <keyword caseSensitive="false" description="" score="1">IDENTIFICATION DIVISION.</keyword>            <keyword caseSensitive="false" description="" score="1">ID DIVISION.</keyword>            <keyword caseSensitive="false" description="" score="1">ENVIRONMENT DIVISION.</keyword>            <keyword caseSensitive="false" description="" score="1">DATA DIVISION.</keyword>            <keyword caseSensitive="false" description="" score="1">PROCEDURE DIVISION.</keyword>            <keyword caseSensitive="false" description="" score="1">PROGRAM-ID.</keyword>            <keyword caseSensitive="false" description="" score="1">DATE-WRITTEN</keyword>            <keyword caseSensitive="false" description="" score="1">DATE-COMPILED</keyword>            <keyword caseSensitive="false" description="" score="1">CONFIGURATION SECTION.</keyword>            <keyword caseSensitive="false" description="" score="1">SOURCE-COMPUTER.</keyword>            <keyword caseSensitive="false" description="" score="1">OBJECT-COMPUTER.</keyword>            <keyword caseSensitive="false" description="" score="1">INPUT-OUTPUT SECTION.</keyword>            <keyword caseSensitive="false" description="" score="1">FILE-CONTROL.</keyword>            <keyword caseSensitive="false" description="" score="1">ASSIGN TO</keyword>            <keyword caseSensitive="false" description="" score="1">SCREEN SECTION.</keyword>            <keyword caseSensitive="false" description="" score="1">FILE SECTION.</keyword>            <keyword caseSensitive="false" description="" score="1">RECORD CONTAINS</keyword>            <keyword caseSensitive="false" description="" score="1">WORKING-STORAGE SECTION.</keyword>            <keyword caseSensitive="false" description="" score="1">OPEN INPUT</keyword>            <keyword caseSensitive="false" description="" score="1">I-O-CONTROL.</keyword>            <keyword caseSensitive="false" description="" score="1">PERFORM UNTIL</keyword>            <keyword caseSensitive="false" description="" score="1">END-PERFORM</keyword>            <keyword caseSensitive="false" description="" score="1">END-IF</keyword>            <keyword caseSensitive="false" description="" score="1">END-READ</keyword>            <keyword caseSensitive="false" description="" score="1">END-DIVIDE</keyword>            <keyword caseSensitive="false" description="" score="1">END-DELETE</keyword>            <keyword caseSensitive="false" description="" score="1">NEXT SENTENCE</keyword>            <keyword caseSensitive="false" description="" score="1">GO TO</keyword>            <keyword caseSensitive="false" description="" score="1">ON ESCAPE</keyword>            <keyword caseSensitive="false" description="" score="1">EXIT.</keyword>            <keyword caseSensitive="false" description="" score="1">AT END</keyword>            <keyword caseSensitive="false" description="" score="1">STOP RUN.</keyword>            <keyword caseSensitive="false" description="" score="1">ON SIZE ERROR</keyword>            <keyword caseSensitive="false" description="" score="1">MOVE ZERO TO</keyword>            <keyword caseSensitive="false" description="" score="1">END-EVALUATE</keyword>            <keyword caseSensitive="false" description="" score="1">INVALID KEY</keyword>            <keyword caseSensitive="false" description="" score="1">UNSTRING</keyword>            <keyword caseSensitive="false" description="" score="1">DELIMITED BY</keyword>            <keyword caseSensitive="false" description="" score="1">ON OVERFLOW</keyword>            <keyword caseSensitive="false" description="" score="1">ASCENDING KEY</keyword>            <keyword caseSensitive="false" description="" score="1">INDEXED BY</keyword>            <keyword caseSensitive="false" description="" score="1">SEARCH ALL</keyword>            <keyword caseSensitive="false" description="" score="1">PIC X(</keyword>            <keyword caseSensitive="false" description="" score="1">PIC 9(</keyword>            <keyword caseSensitive="false" description="" score="1">PIC ?(</keyword>        </dictionary>        ');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','IDENTIFICATION DIVISION.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','ID DIVISION.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','ENVIRONMENT DIVISION.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','DATA DIVISION.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','PROCEDURE DIVISION.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','PROGRAM-ID.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','DATE-WRITTEN',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','DATE-COMPILED',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','CONFIGURATION SECTION.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','SOURCE-COMPUTER.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','OBJECT-COMPUTER.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','INPUT-OUTPUT SECTION.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','FILE-CONTROL.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','ASSIGN TO',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','SCREEN SECTION.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','FILE SECTION.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','RECORD CONTAINS',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','WORKING-STORAGE SECTION.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','OPEN INPUT',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','I-O-CONTROL.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','PERFORM UNTIL',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','END-PERFORM',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','END-IF',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','END-READ',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','END-DIVIDE',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','END-DELETE',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','NEXT SENTENCE',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','GO TO',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','ON ESCAPE',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','EXIT.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','AT END',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','STOP RUN.',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','ON SIZE ERROR',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','MOVE ZERO TO',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','END-EVALUATE',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','INVALID KEY',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','UNSTRING',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','DELIMITED BY',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','ON OVERFLOW',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','ASCENDING KEY',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','INDEXED BY',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','SEARCH ALL',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','PIC X(',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','PIC 9(',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000006','PIC ?(',false, '1');
insert into tb_dlp_keyword_list(name, display_name, description, criteria, char_number, score, pre_define, modified, content) values('00000000-0000-0000-0002-000000000007' ,'Common Medical Terms', 'Terms used by hospitals and other health care providers',3, 0, 5, true, current_timestamp, '<dictionary description="Terms used by hospitals and other health care providers" display_name="Common Medical Terms" name="00000000-0000-0000-0002-000000000007" pre-defined="true" threshold="5" type="Threshold">            <keyword caseSensitive="false" description="" score="1">Aneurysm</keyword>            <keyword caseSensitive="false" description="" score="1">Antibiotic</keyword>            <keyword caseSensitive="false" description="" score="1">Diarrhea</keyword>            <keyword caseSensitive="false" description="" score="1">Abdominal</keyword>            <keyword caseSensitive="false" description="" score="1">Abdomen</keyword>            <keyword caseSensitive="false" description="" score="1">Abortion</keyword>            <keyword caseSensitive="false" description="" score="1">Bacteria</keyword>            <keyword caseSensitive="false" description="" score="1">Brain Injury</keyword>            <keyword caseSensitive="false" description="" score="1">Anemia</keyword>            <keyword caseSensitive="false" description="" score="1">Enzyme</keyword>            <keyword caseSensitive="false" description="" score="1">Anterior</keyword>            <keyword caseSensitive="false" description="" score="1">Ligament</keyword>            <keyword caseSensitive="false" description="" score="1">Syndrome</keyword>            <keyword caseSensitive="false" description="" score="1">Hormone</keyword>            <keyword caseSensitive="false" description="" score="1">Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Disorder</keyword>            <keyword caseSensitive="false" description="" score="1">Drug Reaction</keyword>            <keyword caseSensitive="false" description="" score="1">Liver Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Infection</keyword>            <keyword caseSensitive="false" description="" score="1">Infectious</keyword>            <keyword caseSensitive="false" description="" score="1">Dermatitis</keyword>            <keyword caseSensitive="false" description="" score="1">Nephritis</keyword>            <keyword caseSensitive="false" description="" score="1">Knee Amputation</keyword>            <keyword caseSensitive="false" description="" score="1">Lung Injury</keyword>            <keyword caseSensitive="false" description="" score="1">Leukemia</keyword>            <keyword caseSensitive="false" description="" score="1">Diabetes</keyword>            <keyword caseSensitive="false" description="" score="1">Autoimmune</keyword>            <keyword caseSensitive="false" description="" score="1">AIDS-related</keyword>            <keyword caseSensitive="false" description="" score="1">Distress Syndrome</keyword>            <keyword caseSensitive="false" description="" score="1">Renal Failure</keyword>            <keyword caseSensitive="false" description="" score="1">Membranes</keyword>            <keyword caseSensitive="false" description="" score="1">Therapy</keyword>            <keyword caseSensitive="false" description="" score="1">Aspirin</keyword>            <keyword caseSensitive="false" description="" score="1">X-Ray</keyword>            <keyword caseSensitive="false" description="" score="1">Globulin ratio</keyword>            <keyword caseSensitive="false" description="" score="1">Albumin ratio</keyword>            <keyword caseSensitive="false" description="" score="1">Glandular Cells</keyword>            <keyword caseSensitive="false" description="" score="1">Undetermined Significance</keyword>            <keyword caseSensitive="false" description="" score="1">Heart Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Blood Alcohol Level</keyword>            <keyword caseSensitive="false" description="" score="1">Acid Output</keyword>            <keyword caseSensitive="false" description="" score="1">Blood Culture</keyword>            <keyword caseSensitive="false" description="" score="1">Amino Acid</keyword>            <keyword caseSensitive="false" description="" score="1">Vaccination</keyword>            <keyword caseSensitive="false" description="" score="1">Glucose Level</keyword>            <keyword caseSensitive="false" description="" score="1">Bowel Movement</keyword>            <keyword caseSensitive="false" description="" score="1">Bone Mineral Content</keyword>            <keyword caseSensitive="false" description="" score="1">Bone Mineral Density</keyword>            <keyword caseSensitive="false" description="" score="1">Body Mass Index</keyword>            <keyword caseSensitive="false" description="" score="1">Metabolic Profile</keyword>            <keyword caseSensitive="false" description="" score="1">Metabolic Rate</keyword>            <keyword caseSensitive="false" description="" score="1">Bone Marrow</keyword>            <keyword caseSensitive="false" description="" score="1">Marrow Transplant</keyword>            <keyword caseSensitive="false" description="" score="1">Blood Pressure</keyword>            <keyword caseSensitive="false" description="" score="1">Personality Disorder</keyword>            <keyword caseSensitive="false" description="" score="1">Beats Per Minute</keyword>            <keyword caseSensitive="false" description="" score="1">Red Blood</keyword>            <keyword caseSensitive="false" description="" score="1">Blood Sugar</keyword>            <keyword caseSensitive="false" description="" score="1">Breathe Sound</keyword>            <keyword caseSensitive="false" description="" score="1">Bowel Sounds</keyword>            <keyword caseSensitive="false" description="" score="1">Body Surface Area</keyword>            <keyword caseSensitive="false" description="" score="1">Blood Sugar Level</keyword>            <keyword caseSensitive="false" description="" score="1">Bleeding Time</keyword>            <keyword caseSensitive="false" description="" score="1">Breakthrough pain</keyword>            <keyword caseSensitive="false" description="" score="1">Body Weight</keyword>            <keyword caseSensitive="false" description="" score="1">Cancer</keyword>            <keyword caseSensitive="false" description="" score="1">ABlood Count</keyword>            <keyword caseSensitive="false" description="" score="1">Blood Gas</keyword>            <keyword caseSensitive="false" description="" score="1">Brain Syndrome</keyword>            <keyword caseSensitive="false" description="" score="1">Urine</keyword>            <keyword caseSensitive="false" description="" score="1">Cardiac Failure</keyword>            <keyword caseSensitive="false" description="" score="1">Fatigue Syndrome</keyword>            <keyword caseSensitive="false" description="" score="1">Cardiac Index</keyword>            <keyword caseSensitive="false" description="" score="1">Kidney Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Nervous System</keyword>            <keyword caseSensitive="false" description="" score="1">Cranial Nerves</keyword>            <keyword caseSensitive="false" description="" score="1">Central Nervous System</keyword>            <keyword caseSensitive="false" description="" score="1">Cardiac Output</keyword>            <keyword caseSensitive="false" description="" score="1">Carbon Monoxide</keyword>            <keyword caseSensitive="false" description="" score="1">Carbon Dioxide</keyword>            <keyword caseSensitive="false" description="" score="1">Lung Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Pulmonary Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Chest Pain</keyword>            <keyword caseSensitive="false" description="" score="1">Renal Insufficiency</keyword>            <keyword caseSensitive="false" description="" score="1">Tomography</keyword>            <keyword caseSensitive="false" description="" score="1">Cancer Treatment Unit</keyword>            <keyword caseSensitive="false" description="" score="1">Cardiovascular Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Cardiovascular incident</keyword>            <keyword caseSensitive="false" description="" score="1">Chest X-Ray</keyword>            <keyword caseSensitive="false" description="" score="1">Antiglobulin Test</keyword>            <keyword caseSensitive="false" description="" score="1">Brain Stimulation</keyword>            <keyword caseSensitive="false" description="" score="1">Behavioral Therapy</keyword>            <keyword caseSensitive="false" description="" score="1">Discharge</keyword>            <keyword caseSensitive="false" description="" score="1">Discontinue</keyword>            <keyword caseSensitive="false" description="" score="1">Dental Surgery</keyword>            <keyword caseSensitive="false" description="" score="1">Heart Failure</keyword>            <keyword caseSensitive="false" description="" score="1">Drugs of Abuse</keyword>            <keyword caseSensitive="false" description="" score="1">vaccine</keyword>            <keyword caseSensitive="false" description="" score="1">Diagnosis</keyword>            <keyword caseSensitive="false" description="" score="1">Virus</keyword>            <keyword caseSensitive="false" description="" score="1">Medical Record</keyword>            <keyword caseSensitive="false" description="" score="1">Renal Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Pregnancy</keyword>            <keyword caseSensitive="false" description="" score="1">Examination</keyword>            <keyword caseSensitive="false" description="" score="1">Foreign Body</keyword>            <keyword caseSensitive="false" description="" score="1">Blood Count</keyword>            <keyword caseSensitive="false" description="" score="1">Blood Exam</keyword>            <keyword caseSensitive="false" description="" score="1">Blood Test</keyword>            <keyword caseSensitive="false" description="" score="1">Blood Glucose</keyword>            <keyword caseSensitive="false" description="" score="1">Fetal Heart Rate</keyword>            <keyword caseSensitive="false" description="" score="1">Fetal Heart Sound</keyword>            <keyword caseSensitive="false" description="" score="1">Fetal Heart Tones</keyword>            <keyword caseSensitive="false" description="" score="1">Family History</keyword>            <keyword caseSensitive="false" description="" score="1">Fever</keyword>            <keyword caseSensitive="false" description="" score="1">Chill</keyword>            <keyword caseSensitive="false" description="" score="1">Glycemic Index</keyword>            <keyword caseSensitive="false" description="" score="1">Antibody</keyword>            <keyword caseSensitive="false" description="" score="1">Reflux Disease</keyword>            <keyword caseSensitive="false" description="" score="1">First Pregnancy</keyword>            <keyword caseSensitive="false" description="" score="1">Gun Shot Wound</keyword>            <keyword caseSensitive="false" description="" score="1">Heart Block</keyword>            <keyword caseSensitive="false" description="" score="1">HIV-associated</keyword>            <keyword caseSensitive="false" description="" score="1">HIV Positive</keyword>            <keyword caseSensitive="false" description="" score="1">Hodgkin''s Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Hodgkin''s Lymphoma</keyword>            <keyword caseSensitive="false" description="" score="1">High Dependancy Unit</keyword>            <keyword caseSensitive="false" description="" score="1">Cholesterol</keyword>            <keyword caseSensitive="false" description="" score="1">A Virus</keyword>            <keyword caseSensitive="false" description="" score="1">B Virus</keyword>            <keyword caseSensitive="false" description="" score="1">C Virus</keyword>            <keyword caseSensitive="false" description="" score="1">D Virus</keyword>            <keyword caseSensitive="false" description="" score="1">E Virus</keyword>            <keyword caseSensitive="false" description="" score="1">F Virus</keyword>            <keyword caseSensitive="false" description="" score="1">G Virus</keyword>            <keyword caseSensitive="false" description="" score="1">Simplex Virus</keyword>            <keyword caseSensitive="false" description="" score="1">T-lymphotropic Virus</keyword>            <keyword caseSensitive="false" description="" score="1">Hearing Level</keyword>            <keyword caseSensitive="false" description="" score="1">Membrane Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Hemolytic Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Colorectal Cancer</keyword>            <keyword caseSensitive="false" description="" score="1">Microscopy</keyword>            <keyword caseSensitive="false" description="" score="1">Heart Rate</keyword>            <keyword caseSensitive="false" description="" score="1">Medical History</keyword>            <keyword caseSensitive="false" description="" score="1">Physical Examination</keyword>            <keyword caseSensitive="false" description="" score="1">Breast Cancer</keyword>            <keyword caseSensitive="false" description="" score="1">Bowel Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Intensive Care</keyword>            <keyword caseSensitive="false" description="" score="1">Care Unit</keyword>            <keyword caseSensitive="false" description="" score="1">Intracranial Pressure</keyword>            <keyword caseSensitive="false" description="" score="1">Intercostal Space</keyword>            <keyword caseSensitive="false" description="" score="1">Deficiency</keyword>            <keyword caseSensitive="false" description="" score="1">Infectious Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Isoniazid</keyword>            <keyword caseSensitive="false" description="" score="1">fertilization</keyword>            <keyword caseSensitive="false" description="" score="1">White Blood Cell</keyword>            <keyword caseSensitive="false" description="" score="1">Atrium</keyword>            <keyword caseSensitive="false" description="" score="1">Left Anterior</keyword>            <keyword caseSensitive="false" description="" score="1">Low Back Pain</keyword>            <keyword caseSensitive="false" description="" score="1">Menstrual Period</keyword>            <keyword caseSensitive="false" description="" score="1">Left Ventricle</keyword>            <keyword caseSensitive="false" description="" score="1">Ventricular Failure</keyword>            <keyword caseSensitive="false" description="" score="1">Murmur</keyword>            <keyword caseSensitive="false" description="" score="1">Blood Type</keyword>            <keyword caseSensitive="false" description="" score="1">Cell Volume</keyword>            <keyword caseSensitive="false" description="" score="1">Clinical Depression</keyword>            <keyword caseSensitive="false" description="" score="1">Heart Attack</keyword>            <keyword caseSensitive="false" description="" score="1">Glandular Fever</keyword>            <keyword caseSensitive="false" description="" score="1">Mental Status</keyword>            <keyword caseSensitive="false" description="" score="1">Mental Status Examination</keyword>            <keyword caseSensitive="false" description="" score="1">Injection</keyword>            <keyword caseSensitive="false" description="" score="1">Distress</keyword>            <keyword caseSensitive="false" description="" score="1">Newborn</keyword>            <keyword caseSensitive="false" description="" score="1">Nerve Conduction</keyword>            <keyword caseSensitive="false" description="" score="1">Not Elsewhere Classified</keyword>            <keyword caseSensitive="false" description="" score="1">Recurrent Disease</keyword>            <keyword caseSensitive="false" description="" score="1">No Evidence</keyword>            <keyword caseSensitive="false" description="" score="1">Nuclear Medicine</keyword>            <keyword caseSensitive="false" description="" score="1">Do not repeat</keyword>            <keyword caseSensitive="false" description="" score="1">Nil per os</keyword>            <keyword caseSensitive="false" description="" score="1">Non-Stress Test</keyword>            <keyword caseSensitive="false" description="" score="1">Not Tested</keyword>            <keyword caseSensitive="false" description="" score="1">Vaginal Delivery</keyword>            <keyword caseSensitive="false" description="" score="1">Constipation</keyword>            <keyword caseSensitive="false" description="" score="1">Not Significant</keyword>            <keyword caseSensitive="false" description="" score="1">Nausea</keyword>            <keyword caseSensitive="false" description="" score="1">Vomiting</keyword>            <keyword caseSensitive="false" description="" score="1">Oxygen</keyword>            <keyword caseSensitive="false" description="" score="1">Compulsive Disorder</keyword>            <keyword caseSensitive="false" description="" score="1">Right Eye</keyword>            <keyword caseSensitive="false" description="" score="1">Left Eye</keyword>            <keyword caseSensitive="false" description="" score="1">Occupational Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Ear Infection</keyword>            <keyword caseSensitive="false" description="" score="1">Overdose</keyword>            <keyword caseSensitive="false" description="" score="1">Out of bed</keyword>            <keyword caseSensitive="false" description="" score="1">Outpatient</keyword>            <keyword caseSensitive="false" description="" score="1">Both eye</keyword>            <keyword caseSensitive="false" description="" score="1">On examination</keyword>            <keyword caseSensitive="false" description="" score="1">Peak Acid Output</keyword>            <keyword caseSensitive="false" description="" score="1">Pap Smear</keyword>            <keyword caseSensitive="false" description="" score="1">Papanicolaou Test</keyword>            <keyword caseSensitive="false" description="" score="1">Prostate Cancer</keyword>            <keyword caseSensitive="false" description="" score="1">Patient Care Report</keyword>            <keyword caseSensitive="false" description="" score="1">Penicillin</keyword>            <keyword caseSensitive="false" description="" score="1">Pneumonia</keyword>            <keyword caseSensitive="false" description="" score="1">Parkinson''s Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Peritoneal Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Pulmonary Function Test</keyword>            <keyword caseSensitive="false" description="" score="1">Picogram</keyword>            <keyword caseSensitive="false" description="" score="1">Past History</keyword>            <keyword caseSensitive="false" description="" score="1">Present Illness</keyword>            <keyword caseSensitive="false" description="" score="1">Insufficiency Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Past Medical History</keyword>            <keyword caseSensitive="false" description="" score="1">Physical Medicine</keyword>            <keyword caseSensitive="false" description="" score="1">Physical Rehabilitation</keyword>            <keyword caseSensitive="false" description="" score="1">Postoperative Days</keyword>            <keyword caseSensitive="false" description="" score="1">Monoclonal Protein</keyword>            <keyword caseSensitive="false" description="" score="1">Skin Change</keyword>            <keyword caseSensitive="false" description="" score="1">Postpartum Depression</keyword>            <keyword caseSensitive="false" description="" score="1">Mantoux Test</keyword>            <keyword caseSensitive="false" description="" score="1">Precipitate</keyword>            <keyword caseSensitive="false" description="" score="1">HIV Prevention</keyword>            <keyword caseSensitive="false" description="" score="1">Premature Baby</keyword>            <keyword caseSensitive="false" description="" score="1">Neurologic Deficit</keyword>            <keyword caseSensitive="false" description="" score="1">Prognosis</keyword>            <keyword caseSensitive="false" description="" score="1">Pscychosocial History</keyword>            <keyword caseSensitive="false" description="" score="1">Patient</keyword>            <keyword caseSensitive="false" description="" score="1">Physical Therapy</keyword>            <keyword caseSensitive="false" description="" score="1">Prothrombin Time</keyword>            <keyword caseSensitive="false" description="" score="1">Amnesia</keyword>            <keyword caseSensitive="false" description="" score="1">Prior to Discharge</keyword>            <keyword caseSensitive="false" description="" score="1">Parathyroid Hormone</keyword>            <keyword caseSensitive="false" description="" score="1">Ulcer Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Vascular Disease</keyword>            <keyword caseSensitive="false" description="" score="1">After Food</keyword>            <keyword caseSensitive="false" description="" score="1">By Mouth</keyword>            <keyword caseSensitive="false" description="" score="1">Per rectum</keyword>            <keyword caseSensitive="false" description="" score="1">Per Vagina</keyword>            <keyword caseSensitive="false" description="" score="1">Percussion</keyword>            <keyword caseSensitive="false" description="" score="1">Every bedtime</keyword>            <keyword caseSensitive="false" description="" score="1">Radian</keyword>            <keyword caseSensitive="false" description="" score="1">Axis Deviation</keyword>            <keyword caseSensitive="false" description="" score="1">Pupilary Defect</keyword>            <keyword caseSensitive="false" description="" score="1">Eye Movement</keyword>            <keyword caseSensitive="false" description="" score="1">Rheumatic Fever</keyword>            <keyword caseSensitive="false" description="" score="1">Rheumatoid Factor</keyword>            <keyword caseSensitive="false" description="" score="1">Renal Function Test</keyword>            <keyword caseSensitive="false" description="" score="1">Rhesus factor</keyword>            <keyword caseSensitive="false" description="" score="1">Lobe-lung</keyword>            <keyword caseSensitive="false" description="" score="1">Respiratory Rate</keyword>            <keyword caseSensitive="false" description="" score="1">Symptom</keyword>            <keyword caseSensitive="false" description="" score="1">Surgery</keyword>            <keyword caseSensitive="false" description="" score="1">Tablet</keyword>            <keyword caseSensitive="false" description="" score="1">Diphtheria</keyword>            <keyword caseSensitive="false" description="" score="1">Temperature</keyword>            <keyword caseSensitive="false" description="" score="1">Meditation</keyword>            <keyword caseSensitive="false" description="" score="1">Too numerous to count</keyword>            <keyword caseSensitive="false" description="" score="1">Telephone Order</keyword>            <keyword caseSensitive="false" description="" score="1">Nutrition</keyword>            <keyword caseSensitive="false" description="" score="1">Teaspoon</keyword>            <keyword caseSensitive="false" description="" score="1">Therapeutic System</keyword>            <keyword caseSensitive="false" description="" score="1">Tumor</keyword>            <keyword caseSensitive="false" description="" score="1">Prostate</keyword>            <keyword caseSensitive="false" description="" score="1">Blood Transfusion</keyword>            <keyword caseSensitive="false" description="" score="1">Type and Hold</keyword>            <keyword caseSensitive="false" description="" score="1">Urinanalysis</keyword>            <keyword caseSensitive="false" description="" score="1">Uric Acid</keyword>            <keyword caseSensitive="false" description="" score="1">Usual Childhood Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Drug Screening</keyword>            <keyword caseSensitive="false" description="" score="1">Urinary Output</keyword>            <keyword caseSensitive="false" description="" score="1">Ultrasonogram</keyword>            <keyword caseSensitive="false" description="" score="1">Ultrasound</keyword>            <keyword caseSensitive="false" description="" score="1">Prenatal Ultrasound Imaging</keyword>            <keyword caseSensitive="false" description="" score="1">Ultrasound Scan</keyword>            <keyword caseSensitive="false" description="" score="1">Venereal Disease</keyword>            <keyword caseSensitive="false" description="" score="1">Vaginal Examination</keyword>            <keyword caseSensitive="false" description="" score="1">Respiratory Failure</keyword>            <keyword caseSensitive="false" description="" score="1">Vital Signs</keyword>            <keyword caseSensitive="false" description="" score="1">Premature Beats</keyword>            <keyword caseSensitive="false" description="" score="1">Premature Contraction</keyword>            <keyword caseSensitive="false" description="" score="1">Septal Defect</keyword>            <keyword caseSensitive="false" description="" score="1">Ventricular</keyword>            <keyword caseSensitive="false" description="" score="1">Vessel Wall</keyword>            <keyword caseSensitive="false" description="" score="1">tissue</keyword>            <keyword caseSensitive="false" description="" score="1">Intoxication</keyword>            <keyword caseSensitive="false" description="" score="1">intoxicated</keyword>            <keyword caseSensitive="false" description="" score="1">Radiation Therapy</keyword>            <keyword caseSensitive="false" description="" score="1">Yellow Fever</keyword>            <keyword caseSensitive="false" description="" score="1">Year of Birth</keyword>            <keyword caseSensitive="false" description="" score="1">Year to Date</keyword>            <keyword caseSensitive="false" description="" score="1">Zinc Deficiency</keyword>            <keyword caseSensitive="false" description="" score="1">Sedimentation Rate</keyword>        </dictionary>        ');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Aneurysm',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Antibiotic',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Diarrhea',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Abdominal',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Abdomen',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Abortion',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Bacteria',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Brain Injury',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Anemia',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Enzyme',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Anterior',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Ligament',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Syndrome',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Hormone',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Disorder',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Drug Reaction',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Liver Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Infection',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Infectious',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Dermatitis',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Nephritis',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Knee Amputation',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Lung Injury',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Leukemia',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Diabetes',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Autoimmune',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','AIDS-related',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Distress Syndrome',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Renal Failure',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Membranes',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Therapy',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Aspirin',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','X-Ray',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Globulin ratio',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Albumin ratio',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Glandular Cells',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Undetermined Significance',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Heart Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Blood Alcohol Level',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Acid Output',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Blood Culture',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Amino Acid',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Vaccination',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Glucose Level',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Bowel Movement',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Bone Mineral Content',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Bone Mineral Density',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Body Mass Index',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Metabolic Profile',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Metabolic Rate',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Bone Marrow',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Marrow Transplant',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Blood Pressure',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Personality Disorder',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Beats Per Minute',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Red Blood',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Blood Sugar',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Breathe Sound',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Bowel Sounds',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Body Surface Area',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Blood Sugar Level',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Bleeding Time',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Breakthrough pain',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Body Weight',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Cancer',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','ABlood Count',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Blood Gas',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Brain Syndrome',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Urine',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Cardiac Failure',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Fatigue Syndrome',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Cardiac Index',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Kidney Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Nervous System',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Cranial Nerves',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Central Nervous System',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Cardiac Output',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Carbon Monoxide',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Carbon Dioxide',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Lung Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Pulmonary Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Chest Pain',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Renal Insufficiency',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Tomography',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Cancer Treatment Unit',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Cardiovascular Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Cardiovascular incident',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Chest X-Ray',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Antiglobulin Test',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Brain Stimulation',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Behavioral Therapy',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Discharge',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Discontinue',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Dental Surgery',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Heart Failure',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Drugs of Abuse',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','vaccine',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Diagnosis',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Virus',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Medical Record',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Renal Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Pregnancy',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Examination',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Foreign Body',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Blood Count',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Blood Exam',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Blood Test',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Blood Glucose',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Fetal Heart Rate',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Fetal Heart Sound',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Fetal Heart Tones',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Family History',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Fever',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Chill',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Glycemic Index',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Antibody',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Reflux Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','First Pregnancy',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Gun Shot Wound',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Heart Block',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','HIV-associated',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','HIV Positive',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Hodgkin''s Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Hodgkin''s Lymphoma',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','High Dependancy Unit',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Cholesterol',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','A Virus',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','B Virus',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','C Virus',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','D Virus',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','E Virus',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','F Virus',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','G Virus',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Simplex Virus',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','T-lymphotropic Virus',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Hearing Level',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Membrane Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Hemolytic Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Colorectal Cancer',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Microscopy',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Heart Rate',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Medical History',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Physical Examination',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Breast Cancer',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Bowel Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Intensive Care',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Care Unit',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Intracranial Pressure',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Intercostal Space',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Deficiency',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Infectious Disease',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Isoniazid',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','fertilization',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','White Blood Cell',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Atrium',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Left Anterior',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Low Back Pain',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Menstrual Period',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Left Ventricle',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Ventricular Failure',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Murmur',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Blood Type',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Cell Volume',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Clinical Depression',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Heart Attack',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Glandular Fever',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Mental Status',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Mental Status Examination',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('00000000-0000-0000-0002-000000000007','Injection',false, '1');
insert into tb_dlp_sub_keyword_list(list_name, sub_keyword, case_sensitive, score) values('0000000