#!/bin/sh

# The script for IMSS/IMSVA application installation/upgrade.

# disable ctl-c,ctrl-z and kill
trap "" SIGINT SIGTERM SIGTSTP
# Clear TMOUT in this script because we need user see the execution result.
export TMOUT=0

LD_LIBRARY_PATH=imssbase/lib:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH
PATH=imssbase/bin:$PATH
export PATH

UPGRADE_SIGN=/etc/imsva-inline-upgrade-flag
EXT_DB_CONF=/etc/database.conf
# 0: install, 1:upgrade
MODE=0
# 0: successful
RESULT=-1

CUR_DIR=$(cd "$(dirname "$0")"; pwd)
cd ${CUR_DIR}

GLIBC_NAME="glibc.i686"
HAVE_GLIBC=`rpm -q ${GLIBC_NAME} > /dev/null`
if [ $? -ne 0 ]; then
    echo "The package \"${GLIBC_NAME}\" on which the installation program depends is not installed. Install this package and retry."
    exit 1
fi

sed -e "s%_INSTALL_PKG_PATH_%${CUR_DIR}%g"  -i ${CUR_DIR}/config/installer.ini

if [ -f /etc/trend-release ]; then
    # IMSVA
    if [ -f $UPGRADE_SIGN ]; then
        # Upgrade
        MODE=1
        python/bin/python script/main.py -m upgrade -c ${CUR_DIR}/config/installer.ini
        RESULT=$?
    else
        if [ -f $EXT_DB_CONF ]; then
            cp -af ${CUR_DIR}/config/installer.ini ${CUR_DIR}/config/installer.ini.bak
            # The user chooses to use external adminDB during OS installation,
            # need to get configurations and write into installer config file.
            HOST=`grep 'host=' $EXT_DB_CONF | cut -d'=' -f2`
            PORT=`grep 'port=' $EXT_DB_CONF | cut -d'=' -f2`
            NAME=`grep 'name=' $EXT_DB_CONF | cut -d'=' -f2`
            USER=`grep 'user=' $EXT_DB_CONF | cut -d'=' -f2`
            PASS=`grep 'passwd=' $EXT_DB_CONF | cut -d'=' -f2`
            sed -e "s/^admin_db_type[[:space:]]*=.*\$/admin_db_type = 1/" -i ${CUR_DIR}/config/installer.ini --follow-symlinks
            sed -e "s/^admin_db_address[[:space:]]*=.*\$/admin_db_address = ${HOST}/" -i ${CUR_DIR}/config/installer.ini --follow-symlinks
            sed -e "s/^admin_db_port[[:space:]]*=.*\$/admin_db_port = ${PORT}/" -i ${CUR_DIR}/config/installer.ini --follow-symlinks
            sed -e "s/^admin_db_name[[:space:]]*=.*\$/admin_db_name = ${NAME}/" -i ${CUR_DIR}/config/installer.ini --follow-symlinks
            sed -e "s/^admin_db_username[[:space:]]*=.*\$/admin_db_username = ${USER}/" -i ${CUR_DIR}/config/installer.ini --follow-symlinks
            sed -e "s/^admin_db_password[[:space:]]*=.*\$/admin_db_password = ${PASS}/" -i ${CUR_DIR}/config/installer.ini --follow-symlinks
        fi        
        # Fresh install
        python/bin/python script/main.py -m install -c ${CUR_DIR}/config/installer.ini
        RESULT=$?
    fi
    
    if [ $RESULT -eq 0 ] && [ -f /etc/rc.local ]; then
        sed -e '/^\/mnt\/backup\/install\.sh$/d' -i /etc/rc.local --follow-symlinks
    fi
else
    # IMSS
    # Fresh install
    python/bin/python script/main.py -m install -c ${CUR_DIR}/config/installer.ini
    RESULT=$?
fi

# Successful
if [ $RESULT -eq 0 ]; then
    # Get the current IMSS_HOME
    INSTALL_ROOT=/opt/trend
    IMSS_HOME=/opt/trend/imss
    if [ -f /etc/trend-release ]; then
        INSTALL_ROOT=/opt/trend
        IMSS_HOME=/opt/trend/imss
        IMSS_HOME_HIDDEN=/opt/trend/.imss
    else
        PREFIX=`rpm -q --queryformat '%{INSTPREFIXES}' imss`
        if [ -d $PREFIX ]; then
            INSTALL_ROOT=$PREFIX
            IMSS_HOME=$PREFIX/imss
        else
            INSTALL_ROOT=/opt/trend
            IMSS_HOME=/opt/trend/imss
        fi
    fi

    if [ $MODE -eq 0 ]; then
        if [ -f /etc/trend-release ]; then
            # Remove the external db config file.
            rm -rf $EXT_DB_CONF
        fi
    elif [ $MODE -eq 1 ]; then
        UNINSTALL_PATH=$IMSS_HOME/backup/uninstall.sh
        if [ -f /etc/trend-release ]; then
            # For IMSVA, copy uninstall to hidden imss home
            UNINSTALL_PATH=$IMSS_HOME_HIDDEN/backup/uninstall.sh
        fi
        cp -af ${CUR_DIR}/.uninstall.sh $UNINSTALL_PATH
        chown imss:imss $UNINSTALL_PATH
        chmod 750 $UNINSTALL_PATH
        
        if [ -f /etc/trend-release ]; then
            # Remove the upgrade sign
            rm -rf $UPGRADE_SIGN
            # Pause to prompt the user to start dryrun.
            read -n1 -s
        fi
    fi
# Fail
else
    if [ -f /etc/trend-release ]; then
        if [ $MODE -eq 0 -a ! -e /opt/trend/imss/postfix ]; then
            tar xjf /mnt/backup/imsva_rescue.tar.bz2 -C /
        fi
        
        read -n1 -s
    fi
    # IMSS doesn't need to pause because in IMSS installation/upgrade, the user has to interact with
    # the installer, so the user can see the error immediately.
fi
