# constans used in imss7.1 upgrade

# constans used in upgrade step
import ConfigParser
import json
import os
import subprocess

import re

import configdiff
import utility



class Const:
    POSTGRESQL_CHECK_VERSION = 'postgresql 9.6'
    DEBUG_FLAG_FILE="/tmp/imssdebug"
    MODE_IMSS_UPGRADE = "imss_upgrade"
    INTERNAL_DB_PATH = "/opt/trend/imss/PostgreSQL"
    PGDATA_SRC_FOLDER = "/var/imss/pgdata"
    PGDATA_LOG_FILE = "/var/imss/pglog"
    PGCONF_FILE_SET = ["pg_hba.conf"]
    PGLOG_BCK_FILE="pglog.bakForUpgrade"
    PGDATA_BCK_FOLDER = "pgdata.bakForUpgrade"
    MIE_FILE_NAME = "imsx_config.dat"
    DUMP_LOG_FILE = "dump.txt"
    RESTORE_LOG_FILE = "restore.txt"
    DUMP_FILE_ADMINDB = "backup_admin.tar"
    DUMP_FILE_EUQDB = "backup_euq.tar"
    IMSS91_TEMP_FOLDER = ".imss91_temp"
    DUMP_MOD_EUQ = "euq"
    DUMP_MOD_ALL = "all"
    DEFAULT_ADMINDB_NAME = "imss"
    DEFAULT_EUQDB_NAME = "imsseuq"
    # environ that used in dump and restore
    ENV_PG_PSW = "PGPASSWORD"
    ENV_LD_PATH = "LD_LIBRARY_PATH"

    RPM_IMSS91 = "imss-9.1-1"
    RPM_IMSS = "imss-7.1"
    RPM_CTRL = "imsscctrl"
    RPM_EUQ = "imsseuq"
    RPM_NRS = "nrs"
    RPM_IPP = "ipprofiler"

    RPM_IS_INSTALL = "is_install"
    RPM_INSTALL_PATH = "install_path"
    RPM_IS_BACKUP = "is_back_up"
    RPM_BACKUP_PATH = "backup_path"

    IMSS_RPMS = (RPM_CTRL, RPM_IMSS, RPM_EUQ)
    ALL_RPMS = (RPM_CTRL, RPM_IMSS, RPM_EUQ, RPM_IPP, RPM_NRS)

    CRON_BACKUP_FILE = "origCrontabFile"
    CRON_NEW_FILE = "newCrontabFile"

    # rc links that created in imss71 installation
    # $work_directory/script/dbctl.sh       S98dbctl     K03dbctl
    # $work_directory/script/S99CMAGENT   S99CMAGENT  K02CMAGENT
    # $work_directory/bind/bindctl.sh       S99bindctl      K03bindctl
    # $work_directory/UI/adminUI/bin/Tomcat.sh  S99IMSSUI   K01IMSSUI
    # $work_directory/script/S99FOXDNS S99FOXDNS K02FOXDNS
    #   $work_directory/script/S99SCHEDULED S99SCHEDULED K02SCHEDULED
    # $work_directory/script/S99MONITOR S99MONITOR K01MONITOR
    # CreateLink $work_directory / script / imssstop.sh $RCINITDIR / imssstop
    # CreateLink $RCINITDIR / imssstop  $RCDIR0 / K00IMSSSTOP
    # CreateLink $RCINITDIR / imssstop  $RCDIR6 / K00IMSSSTOP

    ALL_RC_LINKS = [["%s/script/dbctl.sh", "S98dbctl", "K03dbctl"],
                    ["%s/script/S99CMAGENT", "S99CMAGENT", "K02CMAGENT"],
                    ["%s/bind/bindctl.sh", "S99bindctl", "K03bindctl"],
                    ["%s/UI/adminUI/bin/Tomcat.sh", "S99IMSSUI", "K01IMSSUI"],
                    ["%s/script/S99FOXDNS", "S99FOXDNS", "K02FOXDNS"],
                    ["%s/script/S99SCHEDULED", "S99SCHEDULED", "K02SCHEDULED"],
                    ["%s/script/S99MONITOR", "S99MONITOR", "K01MONITOR"]]

    IMSS_SERVICE = "imss.service"
    IMSS_SERVICE_DST_FILE = "/usr/lib/systemd/system/%s" % IMSS_SERVICE

    # Agent imss.ini foxproxy.ini foxdns.ini    need merge
    #

    FILES_NEED_COPY = [
        ("%s/UI/adminUI/ROOT/reports/*", "%s/UI/adminUI/ROOT/reports/")
        # policy log format is not compatible, so not copy bookmark files
        # ("%s/bin/*bookmark", "%s/bin/")
    ]
    #if the component folders has those folders and they are exist then copy them
    NEED_COPY_FOLDERS = [("logs", "imss/log/"), ("log", "imss/log/"),
                         ("queue", "imss/queue/"),
                         ("UI/adminUI/ROOT/logs","imss/UI/adminUI/ROOT/logs/")]

    CONFIG_MERGE_LIST = [
        ("%s/config/Agent.ini", "%s/config/"),
        ("%s/config/foxdns.ini", "%s/config/"),
        ("%s/config/imss.ini", "%s/config/"),
        ("%s/config/foxproxy.ini", "%s/config/"),
        ("%s/config/database.ini", "%s/config/"),
        ("%s/config/euqodbc.ini", "%s/config/"),
        ("%s/config/krb5.ini", "%s/config/"),
        ("%s/config/odbc.ini", "%s/config/"),
        ("%s/config/odbcinst.ini", "%s/config/"),
        ("%s/config/pslist.ini", "%s/config/"),
        ("%s/config/rtstat.ini", "%s/config/"),
        ("%s/config/slave.nfo", "%s/config/"),
        ("%s/config/tmfbe_guid", "%s/config/"),
        ("%s/config/LocalDisable.ERS", "%s/config/"),
        ("%s/config/foxproxy.list", "%s/config/"),
        # ("%s/config/fox_dns_server.list", "%s/config/"),
        ("%s/config/fox_tls_forced_domain.list", "%s/config/"),
        ("%s/config/normal_dns_server.list", "%s/config/"),
        ("%s/config/rbl_check.list", "%s/config/"),
        ("%s/config/rbl_info_regex.list", "%s/config/"),
        ("%s/config/ret_replace.list", "%s/config/")]
    
    MAX_ADDRESS_LEN = 256
    MAX_DATABASE_NAME_LEN = 32
    MAX_DATABASE_USER_LEN = 32
    MAX_DATABASE_PASSWORD_LEN = 32
    MAX_ADMIN_USER_LEN = 64
    MAX_ADMIN_PASSWORD_LEN = 32
    #postfix main.cf backup
    MAIN_CF_BACKUP = "main.cf.bak"

class ModelsCtrl:
    def __init__(self):
        self.mode = ""

    def initial(self, conf, logger, util,res,mode):
        self.mode = mode
        self.conf = conf
        self.logger = logger
        self.util = util
        self.res = res
        self.rpm_status = RpmStatus()
        # initial rpm status info
        self.rpm_status.checkRpmStatus()
        self.conf.setInstallPath(self.rpm_status.getPathToInstallNew())
        self.rc_mgr = RcMgr(self.conf, self.logger, self.rpm_status)
        self.folder_backup_mgr = FolderBackupMgr(self.rpm_status, self.conf, self.logger, self.util)
        self.db_mgr = DbDataMgr(self.conf, self.logger, self.util, self.rpm_status)
        #this should be initial after confirm odbc.ini
        #self.db_mgr.initial()
        self.config_mgr = ConfMgr(self.conf, self.logger,self.util, self.rpm_status)
        self.service_mgr = ServiceSwitcher(self.conf, self.logger, self.rpm_status, self.conf.getInstallPath())
        self.rpm_mgr = RpmManager(self.conf, self.logger, self.util, self.res, self.conf.getInstallPath(),self.rpm_status)
        self.version_checker = VersionChecker(conf=self.conf,logger=self.logger,rpm_status=self.rpm_status,res=self.res)
        self.logger.debug(self.rpm_status.getRpmStatus())
        self.conf.setInstallPkgPath(os.path.dirname(os.path.dirname(os.path.realpath(__file__))))
        self.copy_mgr = FolderCopyMgr(self.conf, self.logger, self.rpm_status)
        self.disk_checker = DiskChecker(self.conf,self.util,  self.logger, self.res, self.rpm_status)

g_upd_models = ModelsCtrl()


class RpmStatus:
    def __init__(self):
        # list[0] is component installed
        # list[1] component installed path if install path is /opt/trend, this path is /opt/trend/imss
        # list[2]component files backup folder
        # list[3]is component files backuped
        self.rpm_status = {Const.RPM_CTRL: [False, '', '', False], Const.RPM_IMSS: [False, '', '', False],
                           Const.RPM_EUQ: [False, '', '', False],
                           Const.RPM_NRS: [False, '', '', False], Const.RPM_IPP: [False, '', '', False]}
        self.install_path_set = set()

    def getInstallPathSet(self):
        return self.install_path_set

    def getBackupPathSet(self):
        ret = set()
        for key in self.rpm_status.keys():
            if self.rpm_status[key][3]:
                ret.add(self.rpm_status[key][2])
        return ret

    def checkRpmStatus(self):
        # value is  [isInstalled, installed path, back up path]
        for key in self.rpm_status.keys():
            self.rpm_status[key][0] = utility.Utility.isRpmInstalled(key)
            if self.rpm_status[key][0]:
                self.rpm_status[key][1] = utility.Utility.getRpmInstalledPath(key)
                if self.rpm_status[key][1] not in self.install_path_set:
                    self.install_path_set.add(self.rpm_status[key][1])

    def getRpmStatus(self):
        return self.rpm_status

    def isOnlyNrs(self):
        if not self.isOneOfImssInstalled() and not self.isIppInstalled():
            return self.isNrsInstalled()
        return False

    def isOnlyIpp(self):
        if not self.isOneOfImssInstalled() and not self.isNrsInstalled():
            return self.isIppInstalled()
        return False

    def isImssInstalled(self):
        return self.getRpmInfo(Const.RPM_IMSS, Const.RPM_IS_INSTALL)

    def isImssCtrlInstalled(self):
        return self.getRpmInfo(Const.RPM_CTRL, Const.RPM_IS_INSTALL)

    def isEuqInstalled(self):
        return self.getRpmInfo(Const.RPM_EUQ, Const.RPM_IS_INSTALL)

    def isNrsInstalled(self):
        return self.getRpmInfo(Const.RPM_NRS, Const.RPM_IS_INSTALL)

    def isIppInstalled(self):
        return self.getRpmInfo(Const.RPM_IPP, Const.RPM_IS_INSTALL)

    def getIppInstallPath(self):
        return self.getRpmInfo(Const.RPM_IPP, Const.RPM_INSTALL_PATH)

    def isOneOfImssInstalled(self):
        rpms_status = self.getRpmStatus()
        for rpm_name in Const.IMSS_RPMS:
            if rpms_status[rpm_name][0]:
                return True
        return False

    def getImssInstalledPath(self):
        rpms_status = self.getRpmStatus()
        for rpm_name in Const.IMSS_RPMS:
            if rpms_status[rpm_name][0]:
                return rpms_status[rpm_name][1]
        return ""

    def getRpmInfo(self, rpm_name, field):
        rpms_status = self.getRpmStatus()
        if rpms_status.has_key(rpm_name):
            if field == Const.RPM_IS_INSTALL:
                return rpms_status[rpm_name][0]
            elif field == Const.RPM_INSTALL_PATH:
                return rpms_status[rpm_name][1]
            elif field == Const.RPM_BACKUP_PATH:
                return rpms_status[rpm_name][2]
            elif field == Const.RPM_IS_BACKUP:
                return rpms_status[rpm_name][3]

    def getPathToInstallNew(self):
        for key in Const.ALL_RPMS:
            if self.rpm_status[key][0]:
                return os.path.dirname(self.rpm_status[key][1])
        return ""

# imss 7.1 cron jobs

# 5,20,35,50 * * * * /opt/trend/nrs/NRSLogParser.sh start >/dev/null 2>&1
# 0 * * * * /opt/trend/ipprofiler/script/foxpurgelog >/dev/null 2>&1
# 0 3 * * * /opt/trend/imss/script/db_maintain.sh vacuumanalyzewholedb  > /dev/null 2>&1
# 0 * * * * /opt/trend/imss/script/S99SCHEDULED start >/dev/null 2>&1

class CronMgr:
    def __init__(self, conf, logger, updater):
        self.logger = logger
        self.updater = updater
        self.conf = conf
        backupFolder = self.conf.getBackupFolder()
        self.cron_backup_file = os.path.join(backupFolder, Const.CRON_BACKUP_FILE)
        self.cron_new_file = os.path.join(backupFolder, Const.CRON_NEW_FILE)
        self.is_cron_done = False

    def upgradeCron(self):
        # install 9.1 cron jobs
        # Upgrade the crontab.
        cmd = "crontab -l 2>/dev/null|sort|uniq > %s 2>/dev/null" % self.cron_backup_file
        if os.system(cmd) != 0:
            self.logger.debug("Fail to backup cron jobs, command: %s" % cmd)
            # return -1

        cmd = "crontab -l 2>/dev/null|grep -v NRSLogParser.sh|grep -v foxpurgelog > %s 2>/dev/null" % (self.cron_new_file)
        if os.system(cmd) != 0:
            self.logger.debug("Fail to create new cron jobs, command: %s" % cmd)
            # return -1


        # cron_set = ("foxpurgelog", "db_maintain.sh", "S99SCHEDULED")
        try:
            file_content = []
            with open(self.cron_new_file, "r") as f:
                for line in f.readlines():
                    file_content.append(line)

            with open(self.cron_new_file, "a") as f:
                for line in self.conf.getCronSetting():
                    sig, content = line
                    flag = False
                    for line in file_content:
                        if sig in line:
                            flag = True
                            break
                    if flag:
                        continue
                    f.write(content + "\n")
        except Exception as e:
            self.logger.debug("Fail to write new cron jobs,exception:" + str(e))
            # return -1

        cmd = "crontab %s 2>/dev/null" % self.cron_new_file
        ret = os.system(cmd)
        self.is_cron_done = True
        if ret != 0:
            self.logger.debug("Fail to set new cron jobs, command: %s" % cmd)
            # return -1

        return 0

    def rollBackCron(self):
        # Need to restore crontab only if the original crontab is backed up.
        if self.is_cron_done:
            cmd = "crontab %s  2>/dev/null" % self.cron_backup_file
            ret = os.system(cmd)
            if ret != 0:
                self.logger.debug("Fail to restore cron jobs, command:%s." % cmd)
                return -1

        if os.path.exists(self.cron_backup_file):
            cmd = "/bin/rm -f %s"%self.cron_backup_file
            if os.system(cmd) !=0:
                self.logger.debug("Fail to remove old cron file.Command:%s"%cmd)

        if os.path.exists(self.cron_new_file):
            cmd = "/bin/rm -f %s"%self.cron_new_file
            if os.system(cmd) !=0:
                self.logger.debug("Fail to remove new cron file.Command:%s"%cmd)
        return 0


# fixme  imss 7.1  redhat7 is not in
class RcMgr:
    def __init__(self, conf, logger, rpm_mgr):
        self.conf = conf
        self.logger = logger
        self.rpm_mgr = rpm_mgr
        self.imss_backup_file = os.path.join(self.conf.getBackupFolder(), "imss.service")

    def removeImss71RcLinks(self):
        if utility.Utility.isOSVer7orLatter():
            cmd = "/bin/mv %s %s>/dev/null 2>&1" % (Const.IMSS_SERVICE_DST_FILE, self.imss_backup_file)
            ret = os.system(cmd)
            if ret != 0:
                self.logger.debug("Fail to remove imss.service on Redhat7 or above os. Command:%s" % cmd)
        else:
            for link in Const.ALL_RC_LINKS:
                self.deleteRCLink(link[1], link[2])
            # remove imssstop link
            os.system("/bin/rm -f  /etc/rc.d/rc0.d/%s>/dev/null 2>&1" % "K00IMSSSTOP")
            os.system("/bin/rm -f  /etc/rc.d/rc6.d/%s>/dev/null 2>&1" % "K00IMSSSTOP")
            os.system("/bin/rm -f  /etc/init.d/%s>/dev/null 2>&1" % "imssstop")

    def rollbackImss71RcLinks(self):
        if utility.Utility.isOSVer7orLatter():
            cmd = "/bin/mv %s %s>/dev/null 2>&1" % (self.imss_backup_file, Const.IMSS_SERVICE_DST_FILE)
            ret = os.system(cmd)
            if ret != 0:
                self.logger.debug("Fail to rollback imss.service on Redhat7 or above os. Command:%s" % cmd)
        else:
            imss_path = self.rpm_mgr.getImssInstalledPath()

            for link in Const.ALL_RC_LINKS:
                for path in self.rpm_mgr.getInstallPathSet():
                    src_path = link[0] % path
                    # print src_path, os.path.exists(src_path)
                    if os.path.exists(src_path):
                        self.createRCLink(src_path, link[1], link[2])
                        break;

            if imss_path:
                self.createLink("%s/script/imssstop.sh" % imss_path, "/etc/init.d/imssstop")
                self.createLink("/etc/init.d/imssstop", "/etc/rc.d/rc0.d/K00IMSSSTOP")
                self.createLink("/etc/init.d/imssstop", "/etc/rc.d/rc6.d/K00IMSSSTOP")

    def deleteRCLink(self, slink, klink):
        os.system("/bin/rm -f /etc/init.d/%s" % slink)
        # remove slink
        os.system("/bin/rm -f  /etc/rc.d/rc2.d/%s>/dev/null 2>&1" % slink)
        os.system("/bin/rm -f  /etc/rc.d/rc3.d/%s>/dev/null 2>&1" % slink)
        os.system("/bin/rm -f  /etc/rc.d/rc5.d/%s>/dev/null 2>&1" % slink)
        # remove klink
        os.system("/bin/rm -f  /etc/rc.d/rc0.d/%s>/dev/null 2>&1" % klink)
        os.system("/bin/rm -f  /etc/rc.d/rc6.d/%s>/dev/null 2>&1" % klink)

    def createLink(self, src, dst):
        os.system("test -f %s&&(rm -rf %s; ln -s %s %s)" % (src, dst, src, dst))

    def createRCLink(self, src_path, dst_name, krc_name):
        dst_path = "/etc/rc.d/init.d/%s" % dst_name
        os.system("/bin/cp %s %s&&chmod +x %s" % (src_path, dst_path, dst_path))
        # create normal rc
        self.createLink(dst_path, "/etc/rc.d/rc2.d/%s" % dst_name)
        self.createLink(dst_path, "/etc/rc.d/rc3.d/%s" % dst_name)
        self.createLink(dst_path, "/etc/rc.d/rc5.d/%s" % dst_name)
        # create k name
        self.createLink(dst_path, "/etc/rc.d/rc0.d/%s" % krc_name)
        self.createLink(dst_path, "/etc/rc.d/rc6.d/%s" % krc_name)

    def installImss91Services(self, step, updater):
        return step.installService(updater)

    def rollbackImss91Services(self, step):
        return step.uninstallService()


# fixme pgdata log backup
class FolderBackupMgr:
    def __init__(self, rpm_status, conf, logger, util):
        self.rpm_status = rpm_status
        self.conf = conf
        self.logger = logger
        self.util = util
        self.adminDbBackedUp = False
        self.upd_bck_folder = self.conf.getBackupFolder()
        self.mie_export_path = os.path.join(self.conf.getDBBackupFolder(), Const.MIE_FILE_NAME)
        self.pgdata_src_path = Const.PGDATA_SRC_FOLDER
        self.pgdata_log_path = Const.PGDATA_LOG_FILE
        self.pgdata_bck_path = os.path.join(self.conf.getDBBackupFolder(), Const.PGDATA_BCK_FOLDER)
        self.initialFolder()

    # clean backup folder or  create backupfolder
    def initialFolder(self):
        # clean exist backup folders
        for path in (self.upd_bck_folder, self.upd_bck_folder):
            if os.path.exists(path):
                pass
                # fixme need not to remove?
                # cmd = "rm -rf  %s/* 2>/dev/null" % path
                # ret = os.system(cmd)
                # if ret != 0:
                # self.logger.debug("Fail to create pgdata backup folder, command:%s" % cmd)
            else:
                # create backup path if not exist
                for p in (self.upd_bck_folder, self.upd_bck_folder):
                    cmd = "mkdir -p %s 2>/dev/null" % p
                    ret = os.system(cmd)
                    if ret != 0:
                        self.logger.debug("Fail to create backup folder, command:%s" % cmd)
                        return -1
        return 0

    def doPgDataFolderBack(self):
        if self.util.isUsingInternalDB():
            p = subprocess.Popen("/bin/mv -f %s %s>/dev/null 2>&1" % (self.pgdata_src_path, self.pgdata_bck_path),
                                 shell=True,
                                 stdout=subprocess.PIPE,
                                 stderr=subprocess.PIPE)

            (stdout, stderr) = p.communicate()
            if p.returncode != 0:
                self.logger.debug("Fail to copy the adminDB data folder, stdout: %s, stderr: %s" % (stdout, stderr))
                return -1
            cmd = "/bin/mv -f %s %s>/dev/null 2>&1"%(self.pgdata_log_path, os.path.join(self.conf.getDBBackupFolder(), Const.PGLOG_BCK_FILE))
            if os.system(cmd)!=0:
                self.logger.debug("Fail to copy postgres pglog file.Command:%s"%cmd)
            self.adminDbBackedUp = True
            # cmd = "rm -rf %s" % self.pgdata_src_path
            # if os.system(cmd)!=0:
            #     self.logger.debug("Fail to remove src pgdata folder, command: %s" % cmd)
            #     return -1
            return 0
        return 0

    def rollbackPgDataFolder(self):
        if self.adminDbBackedUp:
            self.logger.debug(
                "Try to restore the adminDB data from folder %s to %s." % (self.pgdata_bck_path, self.pgdata_src_path))
            if os.path.isdir(self.pgdata_bck_path):
                cmd = "/bin/rm -rf %s && mkdir -p %s  && /bin/mv -f %s %s>/dev/null 2>&1" % (
                    self.pgdata_src_path, os.path.dirname(self.pgdata_src_path), self.pgdata_bck_path,
                    self.pgdata_src_path)
                # cmd = "rm -rf %s && mkdir -p %s  && cp -af %s %s && rm -rf %s" % (
                #     self.pgdata_src_path, os.path.dirname(self.pgdata_src_path), self.pgdata_bck_path,
                #     self.pgdata_src_path, self.pgdata_bck_path)
                p = subprocess.Popen(cmd,
                                     shell=True,
                                     stdout=subprocess.PIPE,
                                     stderr=subprocess.PIPE)
                (stdout, stderr) = p.communicate()
                if p.returncode != 0:
                    self.logger.debug(
                        "Fail to restore the adminDB data folder, stdout: %s, stderr: %s" % (stdout, stderr))
                    return -1
            else:
                self.logger.debug("The adminDB backup folder %s doesn't exist." % (self.pgdata_bck_path))
                return -1

            cmd = "/bin/mv -f %s %s>/dev/null 2>&1" % (os.path.join(self.conf.getDBBackupFolder(), Const.PGLOG_BCK_FILE), self.pgdata_log_path)
            if os.system(cmd)!=0:
                self.logger.debug("Fail to rollback postgres pglog file.Command:%s" % cmd)

        self.logger.debug("The pgsql backup pgdata folder is rollbacked.")
        return 0

    def doRpmFilesBack(self):
        back_folder_set = set()
        rpms_status = self.rpm_status.getRpmStatus()
        for key in rpms_status.keys():
            # if installed
            if rpms_status[key][0]:
                src_path = rpms_status[key][1]
                if src_path not in back_folder_set:
                    dst_path = os.path.join(self.conf.getBackupFolder(), os.path.basename(src_path))
                    # cmd = "cp -af %s %s" % (src_path, dst_path)
                    cmd = "/bin/mv -f %s %s>/dev/null 2>&1" % (src_path, dst_path)
                    if os.system(cmd) != 0:
                        self.logger.debug("Fail to backup files of imss components, command:%s " % cmd)
                        return -1
                    rpms_status[key][2] = dst_path
                    rpms_status[key][3] = True
                    back_folder_set.add(src_path)
                    # cmd = "rm -rf %s" % src_path
                    # if os.system(cmd) != 0:
                    #     self.logger.debug("Fail to remove source files of imss components, command:%s" % cmd)
                    #     return -1
        return 0

    def rollbackRpmFiles(self):
        back_folder_set = set()
        rpms_status = self.rpm_status.getRpmStatus()
        for key in rpms_status.keys():
            # if installed
            if rpms_status[key][0] and rpms_status[key][3]:
                src_path = rpms_status[key][1]
                dst_path = rpms_status[key][2]
                if dst_path and dst_path not in back_folder_set:
                    # cmd = "cp -af %s %s" % (dst_path, src_path)
                    cmd = "/bin/mv -f %s %s>/dev/null 2>&1" % (dst_path, src_path)
                    ret = os.system(cmd)
                    if ret != 0:
                        self.logger.debug("Fail to backup files of imss components, command:%s " % cmd)
                        return -1
                    back_folder_set.add(dst_path)
                    # cmd = "rm -rf %s" % dst_path
                    # if os.system(cmd) != 0:
                    #     self.logger.debug("Fail to remove source files of imss components, command:%s" % cmd)
                    #     return -1
                    self.logger.debug("The %s components rpm files are restored."%key)
        return 0

class DatabaseInfo:
    def __init__(self,addr="", port=0, usr="",psw="",dbname=""):
        self.address = addr
        self.port = port
        self.username = usr
        self.password = psw
        self.dbname = dbname

    def __str__(self):
        return "[address]:%s [port]:%s [usrname]:%s [psw]:%s  [dbname]:%s"%(self.address,str(self.port),self.username,len(self.password)*"*",self.dbname)


# fixme if is EUQ  is rule 1?
class DbDataMgr:
    def __init__(self, conf, logger, util, rpm_status):
        self.rpm_status = rpm_status
        self.logger = logger
        self.conf = conf
        self.util = util
        self.install_package_folder = os.path.dirname(os.path.dirname(os.path.realpath(__file__)))
        self.back_up_folder = self.conf.getBackupFolder()
        # fixme  libreadline.so libpq.so need move to imssbase/lib
        # envs that need by pg_dump
        self.environ = os.environ.copy()
        self.environ[Const.ENV_LD_PATH] = os.path.join(self.install_package_folder, "imssbase/lib")
        self.mie_export_path = os.path.join(self.conf.getDBBackupFolder(), Const.MIE_FILE_NAME)
        self.admindb_dump_path = os.path.join(self.conf.getDBBackupFolder(),Const.DUMP_FILE_ADMINDB)
        self.euqdb_dump_path = os.path.join(self.conf.getDBBackupFolder(),Const.DUMP_FILE_EUQDB)
        self.dump_log_file = os.path.join(self.conf.getDBBackupFolder(), Const.DUMP_LOG_FILE)
        self.restore_log_file = os.path.join(self.conf.getDBBackupFolder(), Const.RESTORE_LOG_FILE)
        self.is_need_dump_restore = False
        self.is_need_euqdb_dump = False
        self.is_need_admindb_dump = False
        self.euq_password = ""
        self.local_euq_db_info = DatabaseInfo()

    def initial(self):
        #TODO   db password can be define by use should read from odbc.ini
        self.environ[Const.ENV_PG_PSW] = self.util.decryptString(self.conf.getAdminDBPassword())
        self.is_need_dump_restore = self.util.isUsingInternalDB()
        if self.is_need_dump_restore:
            self.logger.debug("Internal DB is running on this server, need to do data dump and restore.")
        else:
            self.logger.debug("No Internal DB this server, need not to do data dump and restore.")
        # if self.isAdminDBExist() == 0 and self.rpm_status.isImssCtrlInstalled():
        self.is_need_admindb_dump = self.util.isUsingInternalAdminDB(self.rpm_status)
        self.checkLocalEuqDbNeedDumpRestore()
        self.logger.debug("Status: is_need_dump_restore:%s is_need_admindb_dump:%s is_need_euqdb_dump:%s"%
                          (self.is_need_dump_restore, self.is_need_admindb_dump, self.is_need_euqdb_dump))
        if os.path.exists(Const.DEBUG_FLAG_FILE):
            self.logger.debug("Password for dump restore: admindb:%s euqdb:%s"%(self.conf.getAdminDBPassword(), self.euq_password))

    def isAdminDBExist(self):
        adminDBInfo = DatabaseInfo(self.conf.getAdminDBAddress(),
                                                        self.conf.getAdminDBPort(),
                                                        self.conf.getAdminDBUsername(),
                                                        #this password is read from odbc.ini  imss7.1 that is not encrypt
                                                        self.util.decryptString(self.conf.getAdminDBPassword()),
                                                        self.conf.getAdminDBName())
        ret = self.util.isDbExist(adminDBInfo.address,
                                adminDBInfo.port,
                                adminDBInfo.username,
                                adminDBInfo.password,
                                adminDBInfo.dbname)
        if ret !=0:
            self.logger.debug("DB is not exist, %s"%str(adminDBInfo))
        return ret

    def checkLocalEuqDbNeedDumpRestore(self):
        adminDBInfo = DatabaseInfo(self.conf.getAdminDBAddress(),
                                                        self.conf.getAdminDBPort(),
                                                        self.conf.getAdminDBUsername(),
                                                        #this password is read from odbc.ini  imss7.1 that is not encrypt
                                                        self.util.decryptString(self.conf.getAdminDBPassword()),
                                                        self.conf.getAdminDBName())

        self.logger.debug("Admin db info is %s" % str(adminDBInfo))
        euqDBInfo = self.getLocalEuqDbInfoFromAdminDB(adminDBInfo)
        euqDBInfo.password = self.util.decryptString(euqDBInfo.password)
        self.logger.debug("Get internal euq db info: %s" % str(euqDBInfo))
        if euqDBInfo.address:
            ret = self.util.isDbExist(euqDBInfo.address,
                              euqDBInfo.port,
                              euqDBInfo.username,
                              euqDBInfo.password,
                              "imsseuq")
            if ret ==0:
                self.is_need_euqdb_dump = True
                self.euq_password = euqDBInfo.password
                self.environ[Const.ENV_PG_PSW] = self.euq_password
                self.local_euq_db_info = euqDBInfo
                self.conf.setEuqDBUsername("sa")
                self.conf.setEuqDBPassword(self.euq_password)



        self.logger.debug("Is EuqDB exists in local internal DB. %s" % str(self.is_need_euqdb_dump))

    #get all euqdb info
    #travel every db record and testConn to local db
    #if connectable and has imsseuq db
    def getLocalEuqDbInfoFromAdminDB(self, dbinfo):
        (ret,ept) = utility.Utility.executeQueryStatement(dbinfo.address,
                                                  dbinfo.port,
                                                  dbinfo.username,
                                                  dbinfo.password,
                                                  dbinfo.dbname,"select password from tb_euq_db_info",para=None)
        if ept == None:
            for password in ret:
                r,e = self.util.isDatabaseConnectable("127.0.0.1", 5432,"sa", self.util.decryptString( password[0]), "imsseuq")
                if e == None:
                    return DatabaseInfo("127.0.0.1", 5432,"sa",password[0], "imsseuq")
        else:
            self.logger.debug("Fail to get local Euq DB info from Admin DB. Exception:%s"%str(ept))
            return DatabaseInfo()

        self.logger.debug("Fail to get local Euq DB info")
        return DatabaseInfo()

    def doPgDumpFromImss71(self):
        if not self.is_need_dump_restore:
            return 0
        cmd_tmp = "cd %s&&%s/database/pg_dump -U sa -v -Fc %s > %s 2>>%s"
        if self.is_need_admindb_dump:
            cmd = cmd_tmp % (
                self.back_up_folder, self.install_package_folder, Const.DEFAULT_ADMINDB_NAME, Const.DUMP_FILE_ADMINDB,Const.DUMP_LOG_FILE)
            p = subprocess.Popen([cmd],
                                 stdout=open("/dev/null"),
                                 stderr=open("/dev/null"), shell=True, env=self.environ)
            # stdout return all the data until EOF
            (stdout, stderr) = p.communicate()
            if p.returncode != 0:
                # print log info, let usr check dump.txt file
                self.logger.debug("Fail to dump pgdb, command is %s" % cmd)
                return -1

        if self.is_need_euqdb_dump:
            self.environ[Const.ENV_PG_PSW] = self.euq_password
            # if using internal DB and scannner_id is not 1. and imsseuq is installed on this server.  Then need dump
            cmd = cmd_tmp % (
                self.back_up_folder, self.install_package_folder, Const.DEFAULT_EUQDB_NAME, Const.DUMP_FILE_EUQDB,Const.DUMP_LOG_FILE)
            p = subprocess.Popen([cmd],
                                 stdout=open("/dev/null"),
                                 stderr=open("/dev/null"), shell=True, env=self.environ)
            # stdout return all the data until EOF
            (stdout, stderr) = p.communicate()
            if p.returncode != 0:
                # print log info, let usr check dump.txt file
                self.logger.debug("Fail to dump pgdb, command is %s" % cmd)
                return -1
        return 0

    def doEuqSchemaUpdate(self):
        if not self.is_need_dump_restore:
            return 0

        euq_schema_upgrade=[ """CREATE TABLE tb_dl_entry_keys
                                                        (
                                                          id serial NOT NULL ,
                                                          distribution_list varchar(256),
                                                          submitter varchar(256),
                                                          authentication_code varchar(8),
                                                          created_time timestamptz,
                                                          expired_time timestamptz,
                                                          heartbeat_time timestamptz,
                                                          is_logined int4 DEFAULT 0
                                                        );"""]
                             # """ALTER TABLE ONLY tb_msg_action DROP CONSTRAINT  pk_msg_action;""",
                             # """ALTER TABLE ONLY tb_msg_action ADD CONSTRAINT pk_msg_action PRIMARY KEY (user_id, msg_id, scanner_id);"""]
        if self.is_need_euqdb_dump:
            for sql in euq_schema_upgrade:
                (ret, ept) = self.util.executeUpdateStatement("127.0.0.1",
                                                                   5432,
                                                                   "sa",
                                                                   self.euq_password,
                                                                   "imsseuq",
                                                                    sql,
                                                                  para=None)
                if ept != None or ret !=0:
                    self.logger.debug("Fail to do EuqDB schema upgrade.Exception:%s, error sql:%s"%(utility.excToString(ept), sql))
                    return -1
        return 0


    def doPgRestoreToImss91(self):
        if not self.is_need_dump_restore:
            return 0

        cmd_tmp = "cd %s&&%s/database/pg_restore -U sa -d postgres -C -v -e < %s 2>>%s"
        if self.is_need_admindb_dump:
            cmd = cmd_tmp % (self.back_up_folder, self.install_package_folder, Const.DUMP_FILE_ADMINDB, Const.RESTORE_LOG_FILE)
            p = subprocess.Popen([cmd],
                                 stdout=open("/dev/null"),
                                 stderr=open("/dev/null"), shell=True, env=self.environ)
            # stdout return all the data until EOF
            (stdout, stderr) = p.communicate()
            if os.system("/bin/rm -rf %s"%os.path.join(self.back_up_folder,Const.DUMP_FILE_ADMINDB )) !=0:
                self.logger.debug("Fail to remove adminDB dump file.")
            if p.returncode != 0:
                self.logger.debug("Failt to restore admindb.Command:%s ReturnCode:%s stdout:%s stderr:%s"
                                  % (cmd, p.returncode, stdout, stderr))
                return -1


        if self.is_need_euqdb_dump:
            self.environ[Const.ENV_PG_PSW] = self.euq_password
        # if using internal DB and scannner_id is not 1. And euq is installed.  Then need restore
            cmd = cmd_tmp % (self.back_up_folder, self.install_package_folder, Const.DUMP_FILE_EUQDB, Const.RESTORE_LOG_FILE)
            p = subprocess.Popen([cmd],
                                 stdout=open("/dev/null"),
                                 stderr=open("/dev/null"), shell=True, env=self.environ)
            # stdout return all the data until EOF
            (stdout, stderr) = p.communicate()
            if os.system("/bin/rm -rf %s"%os.path.join(self.back_up_folder,Const.DUMP_FILE_EUQDB )) !=0:
                self.logger.debug("Fail to remove EuqDB dump file.")
            if p.returncode != 0:
                self.logger.debug("Failt to restore euqdb.Command:%s ReturnCode:%s stdout:%s stderr:%s"
                                  %(cmd,p.returncode,stdout,stderr))
                return -1
        return 0

    #imsx config data import is done in migrateAdminDB  in step.
    #so need not to do it again
    def importMIEToImss91(self):
        # Export MIE configuration from adminDB if is imsscctrl server.
        if self.conf.getRole() == 0:
            # Export the configurations.
            toolPath = "%s/script/imp_exp.sh" % self.rpm_status.getImssInstalledPath()
            # Export the setting from adminDB.
            p = subprocess.Popen([toolPath, "-i", self.mie_export_path],
                                 stdout=subprocess.PIPE,
                                 stderr=subprocess.PIPE)
            (stdout, stderr) = p.communicate()
            if p.returncode != 0:
                self.logger.debug("Fail to execute imp_exp.sh, stdout: %s, stderr: %s, return code:%d"
                                  % (stdout, stderr , p.returncode))
                return -1
            else:
                self.logger.debug("The previous settings in adminDB has been import successfully")
        return 0

    def doMieExport(self):
        # Export MIE configuration from adminDB if is imsscctrl server.
        if self.conf.getRole() == 0:
            # Export the configurations.
            toolPath = "%s/script/imp_exp.sh" % self.rpm_status.getImssInstalledPath()
            # Export the setting from adminDB.
            p = subprocess.Popen([toolPath, "-e", self.mie_export_path],
                                 stdout=subprocess.PIPE,
                                 stderr=subprocess.PIPE)
            (stdout, stderr) = p.communicate()
            if p.returncode != 0:
                self.logger.debug("Fail to export from adminDB,export path:%s stdout: %s, stderr: %s, return code:%d"
                                  % (self.mie_export_path, stdout, stderr, p.returncode))
                return -1
            else:
                self.logger.debug("The previous settings in adminDB has been export successfully")
        return 0

    def removeMieExport(self):
        # remove mie export file
        if os.path.exists(self.mie_export_path):
            p = subprocess.Popen("rm -rf %s" % self.mie_export_path,
                                 shell=True,
                                 stdout=subprocess.PIPE,
                                 stderr=subprocess.PIPE)
            (stdout, stderr) = p.communicate()
            if p.returncode != 0:
                self.logger.debug(
                    "Fail to remove mie export file, stdout: %s, stderr: %s" % (stdout, stderr))
                return -1
        return 0

    def removePgdumpFiles(self):
        # remove pg_dump files
        for f in (Const.DUMP_FILE_ADMINDB, Const.DUMP_FILE_EUQDB):
            dumpFile = os.path.join(self.conf.getBackupFolder(), f)
            if os.path.exists(dumpFile):
                cmd = "rm -rf %s" % dumpFile
                ret = os.system(cmd)
                if ret != 0:
                    self.logger.debug(
                        "Fail to remove database dump file, compassmand:%s" % cmd)
                    return -1
        if os.path.exists(self.dump_log_file):
            cmd = "/bin/rm -f  %s"%self.dump_log_file
            ret = os.system(cmd)
            if ret != 0:
                self.logger.debug("Fail to remove dump log file. Command: %s"%cmd)

        if os.path.exists(self.restore_log_file):
            cmd = "/bin/rm -f  %s"%self.restore_log_file
            ret = os.system(cmd)
            if ret != 0:
                self.logger.debug("Fail to remove restore log file. Command: %s"%cmd)

        self.logger.debug("pg_dump export files are removed.")
        return 0

class FolderCopyMgr:
    def __init__(self,conf,logger,rpm_status):
        self.conf = conf
        self.rpm_status = rpm_status
        self.logger = logger
        self.folders = Const.NEED_COPY_FOLDERS

        self.pgdata_bck_path = os.path.join(self.conf.getDBBackupFolder(), Const.PGDATA_BCK_FOLDER)
        self.pgdata_new_path = Const.PGDATA_SRC_FOLDER

    def copyPgConf(self):
        for conf in Const.PGCONF_FILE_SET:
            src = os.path.join(self.pgdata_bck_path, conf)
            dst = os.path.join(self.pgdata_new_path, conf)
            cmd = "/bin/cp -rf %s %s >/dev/null 2>&1"%(src, dst)
            ret = os.system(cmd)
            if ret != 0:
                self.logger.debug("Fail to copy pg config files.(Remote db need not copy)Command: %s."%cmd)
                return -1
        return 0


    def copyFiles(self):
        backup_path_set = self.rpm_status.getBackupPathSet()
        for src,dst in self.folders:
            dst_path = os.path.join(self.conf.getInstallPath(), dst)
            if not os.path.exists(dst_path):
                cmd = "mkdir -p %s"%dst_path
                if os.system(cmd)!=0:
                    self.logger("Fail to create imss9.1 folder.Command: %s"%cmd)

            for bak in backup_path_set:
                src_path = os.path.join(bak,src)
                if os.path.exists(src_path):
                    cmd = "/bin/cp -rf %s/* %s >/dev/null 2>&1"%(src_path, dst_path)
                    ret = os.system(cmd)
                    if ret != 0:
                        self.logger.debug("Fail to copy log files from backup folder to install folder.Command:%s" % cmd)
                        # return -1
                else:
                    self.logger.debug("File not exists.Path:%s"%src_path)

            cmd = "rm -f %spolevt.imss.*" % (dst_path)
            ret = os.system(cmd)
            if ret != 0:
                self.logger.debug("Fail to remove policy event log files.Command:%s" % cmd)

            cmd = "chown -R imss:imss %s" % dst_path
            if os.system(cmd) != 0:
                self.logger("Fail to change permission.Path is %s" % dst_path)
        return 0

class ConfMgr:
    def __init__(self, conf, logger,util, rpm_mgr):
        self.rpm_mgr = rpm_mgr
        self.logger = logger
        self.conf = conf
        self.util = util

        self.MATCH_VALUE = "matchValue"
        self.MATCH_TYPE = "matchType"
        self.ACTION_TYPE = "actionType"
        self.ACTION_CONTENT = "actionContent"

        # --------------------value match type-------------------#
        self.EQUAL = "equal"
        self.INCLUDE = "include"
        self.INCLUDE_HEAD = "include_head"
        self.REGEX_MATCH = "regex_match"
        self.FILE_END = "file_end"
        # ---------------------value match type-------------------#
        # /opt/trend/ipprofiler/foxproxy.ini
        # /opt/trend/imss
        # no change in

        self.imss_config_set = {"Agent.ini": configdiff.agent_ini_diff,
                                "foxdns.ini": configdiff.foxdns_ini_diff,
                                "imss.ini": configdiff.imss_ini_diff,
                                "foxproxy.ini": configdiff.foxproxy_ini_diff}

        #odbc.ini and euqodbc.ini need encrypt the password
        self.db_config_odbc="%s/config/odbc.ini"
        self.db_config_euqodbc = "%s/config/euqodbc.ini"
        self.db_config_database = "%s/config/database.ini"
        self.db_config_odbcinst = "%s/config/odbcinst.ini"
        self.db_config_set = (self.db_config_odbc,self.db_config_euqodbc,self.db_config_database)
        self.need_rollback_maincf = False
        self.maincf_import_bck = ""
        self.maincf_client_res = ""
        self.need_rollback_client_res = False
        #config files set that need merge
        self.config_need_merge_set=[]

    def updateScannerIdInConfigFiles(self):

        s_id = self.getLocalScannerId()
        if  s_id > 0:
            self.logger.debug("Local scanner id is %s, need not to do update"%(str(s_id)))
            return 0
        else:
            self.logger.debug("Local scanner id is %s, need  to do update"%(str(s_id)))

        icp = self.util.getIcpName()
        if not icp:
            self.logger.debug("Fail to get icp device name.")
            return -1
        nicInfo = self.util.getNicInfo()
        if nicInfo.has_key(icp):
            self.logger.debug("The icp %s exist on this machine." %(icp))
            ip = nicInfo[icp][0]
            sql = "select scanner_id from tb_component_list where ip_addr=%s"
            (ret, excp) = self.util.executeQueryStatement(self.conf.getAdminDBAddress(),
                                                           self.conf.getAdminDBPort(),
                                                           self.conf.getAdminDBUsername(),
                                                           self.util.decryptString(self.conf.getAdminDBPassword()),
                                                           self.conf.getAdminDBName(),
                                                           sql,
                                                           [ip])
            if excp != None:
                self.logger.debug(
                    "Fail to update get scanner_id. Exception: %s, sql: %s" % (utility.excToString(excp), sql))

            self.logger.debug("Scanner_id get from tb_component_list is : %s" % str(ret))
            scannerId = 0
            try:
                scannerId = ret[0][0]
            except Exception as e:
                self.logger.debug("Fail to get scanner_id.Exception: %s"%utility.excToString(e))

            if scannerId !=0:
                self.logger.debug("Updating imss.ini foxproxy.ini foxproxy.ini server.xml in scanner:%d"%scannerId)
                # Update scanner id in imss.ini.
                iniPath = "%s/imss/config/imss.ini" % (self.conf.getInstallPath())
                (ret, e) = self.util.replaceInFile([(r"^scanner_id\s*=\s*.+", r"scanner_id=%d" % (scannerId))],
                                                   iniPath)
                if ret != 0:
                    self.logger.debug("Failed to update scanner_id in imss.ini, %s" % (utility.excToString(e)))

                # Update scanner id in foxproxy.ini
                iniPath = "%s/imss/config/foxproxy.ini" % (self.conf.getInstallPath())
                (ret, e) = self.util.replaceInFile([(r"^scanner_id\s*=\s*.+", r"scanner_id=%d" % (scannerId))],
                                                   iniPath)
                if ret != 0:
                    self.logger.debug("Failed to update scanner_id in foxproxy.ini, %s" % (utility.excToString(e)))

                # Update scanner id in EUQ's server.xml.
                xmlPath = "%s/imss/UI/euqUI/conf/server.xml" % (self.conf.getInstallPath())
                (ret, e) = self.util.replaceInFile([(r'jvmRoute=".+"', r'jvmRoute="euq%d"' % (scannerId))],
                                                   xmlPath)
                if ret != 0:
                    self.logger.debug("Failed to update scanner_id in EUQ's server.xml, %s" % (utility.excToString(e)))
                return 0
            else:
                self.logger.debug("Fail to update imss.ini foxproxy.ini foxproxy.ini server.xml in scanner:%d" % scannerId)
                return -1
        else:
            self.logger.debug("Fail to get ICP")
            return -1

    def getLocalScannerId(self):
        """
        Get the scanner id of current device from imss.ini.

        return: the scanner id, -1 if any error happens.
        """
        imssIniPath = "%s/imss/config/imss.ini" % (self.conf.getInstallPath())
        try:
            parser = ConfigParser.SafeConfigParser()
            parser.readfp(open(imssIniPath, "r"))
            return parser.getint("imss_manager", "scanner_id")
        except Exception, e:
            self.logger.debug("Fail to get local scanner ID from imss.ini, %s" % (utility.excToString(e)))
            return -1

    def doConfigUpgrade(self):
        for path in self.rpm_mgr.getBackupPathSet():
            if os.path.basename(path) == "imss":
                for origin, dst in Const.FILES_NEED_COPY:
                    orgin_config_path = origin % path
                    dst_config_path = dst % (os.path.join(self.conf.getInstallPath(), "imss"))

                    if os.system("/bin/cp -rf %s %s >/dev/null 2>&1" % (orgin_config_path, dst_config_path)) != 0:
                        self.logger.debug("Fail to copy files from imss7.1 to 9.1. %s %s" % (orgin_config_path, dst_config_path))
                    else:
                        self.logger.debug("Successed to copy files from imss7.1 to 9.1. %s %s" % (orgin_config_path, dst_config_path))

                    cmd = "chown -R imss:imss %s" % dst_config_path
                    if os.system(cmd) != 0:
                        self.logger("Fail to change permission.Path is %s" % dst_config_path)

        self.config_need_merge_set=[]
        # copy old configs to new folder
        for origin, dst in Const.CONFIG_MERGE_LIST:
            for path in self.rpm_mgr.getBackupPathSet():
                orgin_config_path = origin % path
                dst_config_path = dst % (os.path.join(self.conf.getInstallPath(), "imss"))
                if os.path.exists(orgin_config_path):
                    self.config_need_merge_set.append(orgin_config_path)
                    cmd = "/bin/cp -f %s %s >/dev/null 2>&1" % (orgin_config_path, dst_config_path)
                    if os.system(cmd) != 0:
                        self.logger.debug("Fail to copy config from orgin to new folder, Command: %s" % cmd)
                        return -1
                else:
                    self.logger.debug("File not exists.Path:%s"%orgin_config_path)

                cmd = "chown -R imss:imss %s" % dst_config_path
                if os.system(cmd) != 0:
                    self.logger("Fail to change permission.Path is %s" % dst_config_path)
                    return -1
        if self.mergeConfigFiles() != 0:
            self.logger.debug("Fail to upgrade config files.")
            return -1

        # odbc.ini and euqodbc.ini  should be upgrade password section with
        for path in self.db_config_set:
            conf_path = path%(os.path.join(self.conf.getInstallPath(), "imss"))
            if self.updateOdbcConfig(conf_path) != 0:
                return -1

        # update odbc.ini euqodbc.ini database.ini if external adminDB
        if not self.util.isUsingInternalAdminDB(self.rpm_mgr):
            # odbc.ini and euqodbc.ini  should be upgrade password section with
            conf_path = self.db_config_odbc % (os.path.join(self.conf.getInstallPath(), "imss"))
            ret = self.writeDatabaseConf(conf_path)
            if ret!=0:
                return -1

            #euqodbc.ini should not updated. there is no relationship between admindb and euqDB
            # conf_path = self.db_config_euqodbc% (os.path.join(self.conf.getInstallPath(), "imss"))
            # ret = self.writeDatabaseConf(conf_path)
            # if ret!=0:
            #     return -1

            conf_path = self.db_config_database % (os.path.join(self.conf.getInstallPath(), "imss"))
            parser = ConfigParser.SafeConfigParser()
            parser.optionxform = str
            try:
                #UserId    #Password   #Database
                parser.readfp(open(conf_path, "r"))
                parser.set("Database_Settings", "Database", self.conf.getAdminDBName())
                parser.set("Database_Settings", "UserId", self.conf.getAdminDBUsername())
                parser.set("Database_Settings", "Password", self.util.encryptString(self.conf.getAdminDBPassword()))
                with open(conf_path, 'w') as fpc:
                    parser.write(fpc)
            except Exception as e:
                self.logger.debug("Fail to parse ini file %s, %s" % (conf_path, utility.excToString(e)))
                return -1

        #update odbcinst.ini so files path
        inst_path = self.db_config_odbcinst %  (os.path.join(self.conf.getInstallPath(), "imss"))
        parser = ConfigParser.SafeConfigParser()
        parser.optionxform = str
        try:
            # UserId    #Password   #Database
            parser.readfp(open(inst_path, "r"))
            #Driver=/opt/trend/imss/lib/libodbcpsql.so
            #Setup=/opt/trend/imss/lib/libodbcpsqlS.so
            parser.set("PostgreSQL", "Driver", "%s/imss/lib/libodbcpsql.so"%(self.conf.getInstallPath()))
            parser.set("PostgreSQL", "Setup",  "%s/imss/lib/libodbcpsqlS.so"%(self.conf.getInstallPath()))
            with open(inst_path, 'w') as fpc:
                parser.write(fpc)
        except Exception as e:
            self.logger.debug("Fail to parse ini file %s, %s" % (inst_path, utility.excToString(e)))
            return -1

        if self.updateScannerIdInConfigFiles() !=0:
            self.logger.debug("Fail to update imss.ini foxproxy.ini foxproxy.ini server.xml")

        return 0

    #when upgrade and remote db.
    #need write user config into new odbc.ini
    def writeDatabaseConf(self,odbciniPath):
        try:
            parser = ConfigParser.SafeConfigParser()
            parser.optionxform = str
            parser.readfp(open(odbciniPath,'r'))
            parser.set("IMSS", "Servername", self.conf.getAdminDBAddress())
            parser.set("IMSS", "Port", str(self.conf.getAdminDBPort()))
            parser.set("IMSS", "Database", self.conf.getAdminDBName())
            parser.set("IMSS", "UserName", self.conf.getAdminDBUsername())
            parser.set("IMSS", "Password", self.util.encryptString(self.conf.getAdminDBPassword()))
            with open(odbciniPath,'w') as fpc:
                parser.write(fpc)
        except Exception as e:
            self.logger.debug("Fail to write ini file %s, %s" %(odbciniPath, utility.excToString(e)))
            return -1
        return 0

    def updateOdbcConfig(self, config_path):
        try:
            if not os.path.exists(config_path):
                self.logger.debug("Config file is not exist:%s" % config_path)
                return 0
            content = []
            with open(config_path, 'r') as configfile:
                for line in configfile.readlines():
                    clean_line = line.strip().replace(" ", "")
                    if clean_line.find("Password") == 0:
                        value = clean_line.split("=")[1]
                        content.append("Password=" + self.util.encryptString(value) + "\n")
                    else:
                        content.append(line)
            with open(config_path, 'w') as configfile:
                configfile.writelines(content)
        except Exception as e:
            self.logger.debug("Fail to upgrade odbc config files. Exception: %s"%str(e))
        return 0

    def mergeConfigFiles(self):
        path = os.path.join(self.conf.getInstallPath(), "imss")
        if path and os.path.exists(path):
            new_path = os.path.join(path, "config")
            flag = False
            for file_name in self.imss_config_set.keys():
                for path in self.config_need_merge_set:
                    if file_name in path:
                        flag = True

                if flag:
                    config_file = os.path.join(new_path, file_name)
                    if self.mergeData(self.imss_config_set[file_name], config_file, config_file) != 0:
                        return -1
        else:
            self.logger.debug("Fail to merge config files, imss path is %s" % path)
        return 0

    def rollbackConfigFiles(self):
        """config files is not need to rollback"""
        pass

    def checkValMatch(self, file_content, cur_line, match_vals, match_type):
        # orgin content should be return
        orgin_content = []
        if match_type == self.EQUAL:
            for step in range(0, len(match_vals)):
                if (step + cur_line) >= len(file_content) or file_content[cur_line + step].strip() != match_vals[step]:
                    return (False, [])
                else:
                    orgin_content.append(file_content[cur_line + step])
            return (True, orgin_content)
        elif match_type == self.INCLUDE:
            for step in range(0, len(match_vals)):
                if (step + cur_line) >= len(file_content) or file_content[cur_line + step].find(match_vals[step]) < 0:
                    return (False, [])
                else:
                    orgin_content.append(file_content[cur_line + step])
            return (True, orgin_content)
        elif match_type == self.INCLUDE_HEAD:
            for step in range(0, len(match_vals)):
                if (step + cur_line) >= len(file_content) or file_content[cur_line + step].find(match_vals[step]) != 0:
                    return (False, [])
                else:
                    orgin_content.append(file_content[cur_line + step])
            return (True, orgin_content)
        elif match_type == self.REGEX_MATCH:
            for step in range(0,len(match_vals)):
                if (step + cur_line) >= len(file_content) or re.match(match_vals[step],file_content[cur_line + step] ) == None:
                    return (False, [])
                else:
                    orgin_content.append(file_content[cur_line + step])
                return (True, orgin_content)

        # print match_type
        return (False, [])

    def doAction(self, cur_line, match_vals, orgin_content, new_content, action_type, action_content):
        if len(match_vals) != len(orgin_content):
            self.logger.debug("Fail to upgrade config files, orgin and match lines are not correct")
        # return next step
        if action_type == "insert":
            for line in action_content:
                new_content.append(line)
            for line in orgin_content:
                new_content.append(line)
            return (cur_line + len(match_vals))
        elif action_type == "append":
            for line in orgin_content:
                new_content.append(line)
            for line in action_content:
                new_content.append(line)
            return (cur_line + len(match_vals))
        elif action_type == "delete":
            return (cur_line + len(match_vals))
        elif action_type == "replace":
            for line in action_content:
                new_content.append(line)
            return (cur_line + len(match_vals))

    def mergeData(self, json_str, src_path, dst_path):
        obj = json.loads(json_str)
        new_content = []
        file_content = []
        try:
            with open(src_path, "r") as f:
                file_content = f.readlines()
            file_length = len(file_content)
            line = 0
            # for each item in json diff file, broswer the whole file , after do action. break and copy left file content
            for dic in obj:
                matchType = dic[self.MATCH_TYPE]
                matchValue = dic[self.MATCH_VALUE]
                actionType = dic[self.ACTION_TYPE]
                actionContent = dic[self.ACTION_CONTENT]
                if matchType.find("file_") == 0:
                    continue
                line = 0
                need_copy_left = False
                while line<file_length:
                    step = line
                    ret, orgin_content = self.checkValMatch(file_content, line, matchValue, matchType)
                    if ret:
                        # after check rule, do action: replace,insert,apend
                        # one one rule will be operated in one line
                        step = self.doAction(line, matchValue, orgin_content, new_content, actionType, actionContent)
                    if step == line:
                        new_content.append(file_content[line])
                        line = line + 1
                    else:
                        line = step
                        need_copy_left = True
                        #after do action , break
                        break
                if need_copy_left:
                    while line<file_length:
                        new_content.append(file_content[line])
                        line = line + 1
                else:
                    # print "Fail to merge config diff item,item %s"%str(dic)
                    self.logger.debug("Didn't merge this config diff item,item %s"%str(dic))


                file_content = list(new_content)
                file_length=len(file_content)
                new_content[:] = []

            new_content = file_content
            # while line < file_length:
            #     cur_content = file_content[line]
            #     step = line
            #     for dic in obj:
            #         matchType = dic[self.MATCH_TYPE]
            #         matchValue = dic[self.MATCH_VALUE]
            #         actionType = dic[self.ACTION_TYPE]
            #         actionContent = dic[self.ACTION_CONTENT]
            #         if matchType.find("file_") == 0:
            #             continue
            #         ret, orgin_content = self.checkValMatch(file_content, line, matchValue, matchType)
            #         if ret:
            #             # after check rule, do action: replace,insert,apend
            #             # one one rule will be operated in one line
            #             step = self.doAction(line, matchValue, orgin_content, new_content, actionType, actionContent)
            #             break
            #     if step == line:
            #         new_content.append(file_content[line])
            #         line = line + 1
            #     else:
            #         line = step
            for dic in obj:
                matchType = dic[self.MATCH_TYPE]
                actionContent = dic[self.ACTION_CONTENT]
                if matchType == self.FILE_END:
                    for l in actionContent:
                        new_content.append(l)
            with open(dst_path, "w") as f:
                for line in new_content:
                    f.write(line.rstrip() + "\n")
        except Exception as e:
            self.logger.debug("Fail to upgrade config files,exception:%s config file:%s" % (str(e), src_path))
            return -1
        return 0

    def updateMaincf(self):
        # if not self.rpm_mgr.isIppInstalled():
        #     return 0
        # Determine if the user has postfix installed.
        self.need_rollback_maincf = False
        self.maincf_import_bck = ""

        if not self.util.isRpmInstalled("postfix"):
            return 0
        self.logger.debug("Found postfix installed on this machine.")

        # os.system("postconf > %s"%(os.path.join(self.conf.getBackupFolder(), Const.MAIN_CF_BACKUP)))
        #backup  import_environment value in main.cf
        cmd = "postconf -n import_environment"
        p = subprocess.Popen(cmd,
                             shell=True,
                             stdout=subprocess.PIPE,
                             stderr=subprocess.PIPE)
        (stdout, stderr) = p.communicate()
        if p.returncode == 0:
            self.maincf_import_bck = stdout.strip()
        else:
            self.logger.debug("Fail to run command, cmd:%s"%cmd)
        self.logger.debug("previous import_environment value is [%s]"%self.maincf_import_bck)

        # should not modify the config
        # Make foxhunter aware the foxlib exists
        self.util.replaceInFile([(r"has_foxlib_installed=0", r"has_foxlib_installed=1")],
                                "%s/imss/config/foxproxy.ini" % (self.conf.getInstallPath()))
        # Config changed, need to restart foxhunter
        # subprocess.call(["%s/imss/script/foxproxyd" % (self.conf.getInstallPath()), "restart"],
        #                 stdout=open("/dev/null"),
        #                 stderr=open("/dev/null"))
        # Identify if the postfix is 64bit
        is64bitPostfix = False
        p = subprocess.Popen("rpm -q postfix | grep x86_64 | wc -l",
                             shell=True,
                             stdout=subprocess.PIPE,
                             stderr=subprocess.PIPE)
        (stdout, stderr) = p.communicate()
        if p.returncode == 0:
            is64bitPostfix = stdout.strip() == "1"
        else:
            self.logger.debug("Fail to check if postfix is 64bit, stderr: %s" % (stderr))

        foxlibEnv = "LD_PRELOAD=%s/imss/%s/libTmFoxSocketLib.so TM_FOX_PROXY_LIST=%s/imss/config/foxproxy.list LD_LIBRARY_PATH=%s/imss/lib TM_FOX_PROXY_CONNECT_PORT=2500" % (
        self.conf.getInstallPath(), "lib64" if is64bitPostfix else "lib", self.conf.getInstallPath(),
        self.conf.getInstallPath())

        KEY_PRELOAD='LD_PRELOAD'
        KEY_FOX_LIST='TM_FOX_PROXY_LIST'
        KEY_LIB_PATH='LD_LIBRARY_PATH'
        KEY_FOX_PORT='TM_FOX_PROXY_CONNECT_PORT'

        fox_conf_dic = {
        KEY_PRELOAD:KEY_PRELOAD+'=%s/imss/%s/libTmFoxSocketLib.so'%(self.conf.getInstallPath(), "lib64" if is64bitPostfix else "lib"),
        KEY_FOX_LIST:KEY_FOX_LIST+'=%s/imss/config/foxproxy.list'%self.conf.getInstallPath(),
        KEY_LIB_PATH:KEY_LIB_PATH+'=%s/imss/lib'%self.conf.getInstallPath(),
        KEY_FOX_PORT:KEY_FOX_PORT+'=2500'
        }
        need_update = [KEY_PRELOAD,KEY_FOX_LIST,KEY_LIB_PATH]
        should_keep_old = [KEY_FOX_PORT]

        # Get the current import_environment setting of postfix
        oldEnv=""
        p = subprocess.Popen(["postconf", "-h", "import_environment"],
                             stdout=subprocess.PIPE,
                             stderr=subprocess.PIPE)
        (stdout, stderr) = p.communicate()
        if p.returncode == 0:
            oldEnv = stdout.strip()

        # if one of need_update exist. then update it
        #if should should_keep_old exist. then keep old
        #else use new config
        if oldEnv:
            old_env_array = oldEnv.split(" ")
            new_env_array = []

            for key in need_update:
                new_env_array.append(fox_conf_dic[key])

            for old_item in old_env_array:
                is_exist = False
                for key in need_update:
                    if key in old_item:
                        is_exist = True
                        break
                if not is_exist:
                    new_env_array.append(old_item)

            for key in should_keep_old:
                is_exist = False
                for item in old_env_array:
                    if key in item:
                        is_exist = True
                        break
                if not is_exist:
                    new_env_array.append(fox_conf_dic[key])
            dstEnv = ' '.join(new_env_array)
        else:
            dstEnv = foxlibEnv

        newEnv =dstEnv
        self.logger.debug("The postfix import_environment will be set to [%s]" % (newEnv))
        subprocess.call(["postconf", "-e", "import_environment=%s" % (newEnv)],
                        stdout=open("/dev/null"),
                        stderr=open("/dev/null"))
        self.need_rollback_maincf = True
        # Check if postfix is running
        p = subprocess.Popen("ps -ef | grep master | grep -v grep | wc -l",
                             shell=True,
                             stdout=subprocess.PIPE,
                             stderr=subprocess.PIPE)
        (stdout, stderr) = p.communicate()
        if p.returncode == 0 and int(stdout) > 0:
            self.logger.debug("Postfix is running, need to restart it")
            subprocess.call(["%s/imss/script/postfixctl.sh" % (self.conf.getInstallPath()), "restart"],
                            stdout=open("/dev/null"),
                            stderr=open("/dev/null"))
        else:
            self.logger.debug("Fail to check if postfix is running, stderr: %s" % (stderr))

        self.logger.debug("Finished applying postfix changes.")
        return 0

    def rollbackMaincf(self):
        if not self.need_rollback_maincf:
            return
        if len(self.maincf_import_bck) >0:
            returncode = subprocess.call(["postconf", "-e", self.maincf_import_bck],
                            stdout=open("/dev/null"),
                            stderr=open("/dev/null"))
            self.logger.debug("Rollback import_environment to value:%s. returncode:%s"%(self.maincf_import_bck, str(returncode)))

    def updatePostfixConf(self):
        if not self.util.isRpmInstalled("postfix"):
            return 0
        self.maincf_client_res = ""
        self.need_rollback_client_res=False

        os.system("postconf > %s" % (os.path.join(self.conf.getBackupFolder(), Const.MAIN_CF_BACKUP)))
        #smtpd_client_restrictions
        cmd = "postconf -n smtpd_client_restrictions"
        p = subprocess.Popen(cmd,
                             shell=True,
                             stdout=subprocess.PIPE,
                             stderr=subprocess.PIPE)
        (stdout, stderr) = p.communicate()
        if p.returncode == 0:
            self.maincf_client_res = stdout.strip()
        else:
            self.logger.debug("Fail to run command, cmd:%s"%cmd)
            return -1

        self.logger.debug("previous smtpd_client_restrictions value is [%s]" % self.maincf_client_res)

        cmd = "postconf -e smtpd_client_restrictions="
        p = subprocess.Popen(cmd,
                             shell=True,
                             stdout=subprocess.PIPE,
                             stderr=subprocess.PIPE)
        (stdout, stderr) = p.communicate()
        if p.returncode != 0:
            self.logger.debug("Fail to run command, cmd:%s"%cmd)
            return -1

        self.need_rollback_client_res = True
        return 0


    def rollbackPostfixConf(self):
        if not self.need_rollback_client_res:
            return
        maincf_back = os.path.join(self.conf.getBackupFolder(), Const.MAIN_CF_BACKUP)

        if os.path.exists(maincf_back):
            cmd = "rm -f %s>/dev/null 2>&1"%(maincf_back)
            if os.system(cmd) !=0:
                self.logger.debug("Fail to run command: %s"%(cmd))
        else:
            self.logger.debug("Back up postconf file %s not exists."%maincf_back)

        if len(self.maincf_client_res) >0:
            returncode = subprocess.call(["postconf", "-e", self.maincf_client_res],
                            stdout=open("/dev/null"),
                            stderr=open("/dev/null"))
            self.logger.debug("Rollback smtpd_client_restrictions to value:%s. returncode:%s"%(self.maincf_client_res, str(returncode)))


class RpmManager:
    def __init__(self, conf, logger, util,res, install_path,rpm_status):
        self.conf = conf
        self.logger = logger
        self.rpm_paths = self.conf.getRpmPaths()
        self.install_path = install_path
        self.util = util
        self.install_package_folder = os.path.dirname(os.path.dirname(os.path.realpath(__file__)))
        self.rpm_status = rpm_status.getRpmStatus()
        self.res = res

    def removeImss71Rpms(self):
        #move
        #move current folder
        cmd = "/bin/mv %s %s>/dev/null 2>&1"%(os.path.join(self.install_path,"imss"), os.path.join(self.install_path,Const.IMSS91_TEMP_FOLDER));
        if os.system(cmd) !=0:
            self.logger.debug("Fail to mv imss 9.1 app folder.Command:%s"%cmd)
            return -1
        for key in self.rpm_status.keys():
            if self.rpm_status[key][0]:
                cmd = "rpm -e %s>/dev/null 2>&1"%key
                if os.system(cmd) !=0:
                    self.logger.debug("Fail to remove imss71 rpms.Command:%s"%cmd)
                    return -1
        #move to origin folder
        cmd = "/bin/mv %s %s>/dev/null 2>&1" % (
        os.path.join(self.install_path, Const.IMSS91_TEMP_FOLDER),os.path.join(self.install_path, "imss"));
        if os.system(cmd) != 0:
            self.logger.debug("Fail to mv imss 9.1 app to orgin folder.Command:%s"%cmd)
            return -1
        return 0


    def installNewRpm(self,updater):
        if len(self.rpm_paths) == 0:
            return -1

        for p in self.rpm_paths:
            path = os.path.join(self.install_package_folder, p)
            if not os.path.exists(path):
                updater.append(self.res.getWording("msg.rpmFileNotExist") % (path))
                self.logger.debug("File %s doesn't exits." % (path))
                return -1
            self.logger.debug("Start to install %s." % (path))
            updater.append(self.res.getWording("msg.rpmInstallBegin") % (os.path.basename(path)))
            (ret, stdout, stderr) = self.util.installRpm(path,
                                                         ["--force", "--prefix", self.install_path])

            if ret != 0:
                self.logger.debug("Failed to install rpm %s, stdout: %s, stderr: %s"
                                  % (path, stdout, stderr))
                updater.append(self.res.getWording("msg.rpmInstallFail") % (path, stderr))
                return -1
            self.logger.debug("%s is installed successfully." % (path))
            updater.append(self.res.getWording("msg.rpmInstallSuccess") % (path))
        return 0

    def rollBackInstalledNewRpm(self):
        # remove rpm and clean imss9.1 folder
        if self.util.isRpmInstalled(Const.RPM_IMSS91):
            (ret, stdout, stderr) = self.util.uninstallRpm(Const.RPM_IMSS91, ["--nodeps"])
            if ret != 0:
                self.logger.debug(
                    "Fail to uninstall rpm %s, stdout: %s, stderr: %s" % (Const.RPM_IMSS91, stdout, stderr))
                return -1

        install_folder = "%s/imss" % self.install_path
        if os.path.exists(install_folder):
            ret = os.system("rm -rf %s" % install_folder)
            if ret != 0:
                self.logger.debug("Remove imss folder failed: %s" % install_folder)
                return -1
        return 0


class ServiceSwitcher:
    def __init__(self, conf, logger, rpm_status, install_path):
        self.conf = conf
        self.logger = logger
        self.imss_path = rpm_status.getImssInstalledPath()
        self.rpm_status = rpm_status
        self.new_imss_ctrl_script =  '%s/imss/script/imssctl.sh' % install_path

    # fixme , need implement
    def startDb(self):
        self.ctlPostgreSQL("start")

    def stopDb(self):
        self.ctlPostgreSQL("stop")

    def ctlPostgreSQL(self, cmd):
        dbctlPath = "%s/imss/script/dbctl.sh" % (self.conf.getInstallPath())
        if os.path.exists(dbctlPath):
            subprocess.call([dbctlPath, cmd],
                            stdout=open("/dev/null"),
                            stderr=open("/dev/null"), env=utility.getEnvForRunCmd(self.conf))

    def startCronJobs(self):
        # Shutdown the crond
        cmd = "service crond start>/dev/null 2>&1"
        ret = os.system(cmd)
        if ret != 0:
            self.logger.debug("Fail to start cron jobs, command: %s" % cmd)
            return -1
        return 0

    def stopCronJobs(self):
        # Shutdown the crond
        cmd = "service crond stop>/dev/null 2>&1"
        ret = os.system(cmd)
        if ret != 0:
            self.logger.debug("Fail to stop cron jobs, command: %s" % cmd)
            return -1
        return 0

    def startImss91Services(self):
        cmd = "%s start >/dev/null 2>&1"%self.new_imss_ctrl_script
        if os.system(cmd) !=0:
            self.logger.debug("Fail to start imss 91 services.Command:%s"%cmd)

    def stopImss91Services(self):
        cmd = "%s stop >/dev/null 2>&1"%self.new_imss_ctrl_script
        if os.system(cmd) !=0:
            self.logger.debug("Fail to stop imss 91 services.Command:%s"%cmd)

    def stopImss71Services(self):
        if self.imss_path:
            cmd = "%s/script/imssstop.sh stop>/dev/null 2>&1" % self.imss_path
            ret = os.system(cmd)
            if ret != 0:
                self.logger.debug("Faile Stop all services, command:%s " % cmd)
                return -1
        elif not self.imss_path and self.rpm_status.isIppInstalled():
            ip_path = self.rpm_status.getIppInstallPath()
            cmd = "%s/script/foxproxyd stop>/dev/null 2>&1" % ip_path;
            ret = os.system(cmd)
            if ret != 0:
                self.logger.debug("Faile Stop all services, command:%s " % cmd)
                return -1
        return 0

    def startImss71Services(self):
        imss_path = self.rpm_status.getImssInstalledPath()
        self.logger.debug("Starting services of imss7.1.  imss path: %s "%imss_path)
        if imss_path:
            cmd = "%s/script/imssstart.sh>/dev/null 2>&1" % imss_path
            ret = os.system(cmd)
            if ret != 0:
                self.logger.debug("Faile start all services, command:%s " % cmd)
                return -1
        elif not imss_path and self.rpm_status.isIppInstalled():
            ip_path = self.rpm_status.getIppInstallPath()
            cmd = "%s/script/foxproxyd start>/dev/null 2>&1" % ip_path;
            ret = os.system(cmd)
            if ret != 0:
                self.logger.debug("Faile Stop all services, command:%s " % cmd)
                return -1
        self.logger.debug("Services of imss7.1 have been started.  Imss path: %s " % imss_path)
        return 0

class PostUpgradeAction:
    def __init__(self, conf, logger, util):
        self.conf = conf
        self.new_imss_path = os.path.join(self.conf.getInstallPath(), "imss")
        self.logger = logger
        self.util = util

    def doUpgradePostWork(self, scanner_id):
        try:
            self.doPostAction(scanner_id)
            self.updateFoxproxyIni(scanner_id)
        except Exception as e:
            self.logger.debug("Fail to do upgrade post action. Exception:%s"%utility.excToString(e))

    def updateFoxproxyIni(self, scannerId):
        if scannerId <= 0:
            self.logger.debug("Fail to update foxproxy.ini")
            return
        # Update scanner id in foxproxy.ini
        iniPath = "%s/imss/config/foxproxy.ini" %(self.conf.getInstallPath())
        (ret, e) = self.util.replaceInFile([(r"^scanner_id\s*=\s*.+", r"scanner_id=%s" %(str(scannerId)))],
                                           iniPath)
        if ret != 0:
            self.logger.debug("Failed to update scanner_id in foxproxy.ini, %s" %(utility.excToString(e)))


    def doPostAction(self, scanner_id):
        if scanner_id == 1:
            job = "*/2 * * * * %s/python/bin/python %s/script/DataTransferAsync.py >%s/log/data_transfer.log 2>&1 "%\
                  (self.new_imss_path,self.new_imss_path,self.new_imss_path)
            self.util.addNewCronJob(job)

            list = self.util.getNoUpgradeEuqDbList()
            for dbinfo in list:
                dbId = dbinfo[4]
                sql="update tb_euq_db_info set status=0 where db_id=%s"%(str(dbId))
                (ret,excp) =  self.util.executeUpdateStatement(self.conf.getAdminDBAddress(),
                                                               self.conf.getAdminDBPort(),
                                                               self.conf.getAdminDBUsername(),
                                                               self.util.decryptString(self.conf.getAdminDBPassword()),
                                                               self.conf.getAdminDBName(), sql)
                if excp!=None:
                    self.logger.debug("Fail to execute disable old version euq db sql. Exception: %s, Sql: %s"%(utility.excToString(excp),sql))

            #euq is default disable in imss9.1 refer to IMSS-230
            sql = "update tb_global_setting set value='0' where section='general' and name='enable_euq' and inifile='imss.ini'"
            (ret, excp) = self.util.executeUpdateStatement(self.conf.getAdminDBAddress(),
                                                           self.conf.getAdminDBPort(),
                                                           self.conf.getAdminDBUsername(),
                                                           self.util.decryptString(self.conf.getAdminDBPassword()),
                                                           self.conf.getAdminDBName(), sql)
            if excp != None:
                self.logger.debug("Fail to disable euq. Exception: %s, sql: %s" % (utility.excToString(excp), sql))

        sql_set_update_component = [
        "UPDATE tb_component_list set ipprofiler=2 where ip_addr=%s",
        "UPDATE tb_component_list set nrs=2 where ip_addr=%s",
        "UPDATE tb_component_list set daemon=1 where daemon=0 and ip_addr=%s",
        "UPDATE tb_component_list set policy=1 where policy=0 and ip_addr=%s",
        "UPDATE tb_component_list set euq=0 where ip_addr=%s"]

        # Get the icp of current device.
        icp = self.util.getIcpName()
        if not icp:
            self.logger.debug("Fail to get icp device name.")
            return -1
        nicInfo = self.util.getNicInfo()
        if nicInfo.has_key(icp):
            self.logger.debug("The icp %s exist on this machine." %(icp))
            ip = nicInfo[icp][0]
            for sql in sql_set_update_component:
                (ret, excp) = self.util.executeUpdateStatement(self.conf.getAdminDBAddress(),
                                                               self.conf.getAdminDBPort(),
                                                               self.conf.getAdminDBUsername(),
                                                               self.util.decryptString(self.conf.getAdminDBPassword()),
                                                               self.conf.getAdminDBName(), sql, [ip])
                if excp != None:
                    self.logger.debug("Fail to update tb_component_list. Exception: %s, sql: %s" % (utility.excToString(excp), sql))
        else:
            self.logger.error("Fail to update tb_component_list. Can't get local IP address getNicInfo():%s"%(str(nicInfo)))

        confDst = "%s/config/installer.ini" % (self.new_imss_path)
        (ret, e) = self.conf.saveConfig(confDst)
        if ret != 0:
            self.logger.debug("Fail to save install config data to %s, %s" %(confDst, utility.excToString(e)))

        uninstall_path = "%s/backup/uninstall.sh" % self.new_imss_path
        self.install_package_folder = os.path.dirname(os.path.dirname(os.path.realpath(__file__)))

        cmd = "/bin/cp -af %s/.uninstall.sh %s >/dev/null 2>&1" % (self.install_package_folder, uninstall_path)
        if os.system(cmd) != 0:
            self.logger.debug("Fail to copy uninstall.sh file. Command: %s" % cmd)
        cmd = "chown imss:imss %s" % uninstall_path
        if os.system(cmd) != 0:
            self.logger.debug("Fail change owner uninstall.sh file. Command: %s" % cmd)
        cmd = "chmod 750 %s" % uninstall_path
        if os.system(cmd) != 0:
            self.logger.debug("Fail to change mod uninstall.sh file. Command: %s" % cmd)




class VersionChecker:
    def __init__(self,logger,conf, rpm_status,res):
        self.logger = logger
        self.conf = conf
        self.rpm_status_mgr = rpm_status
        self.rpm_status = rpm_status.getRpmStatus()
        self.res = res

    def readVersionInfo(self, conf_path):
        cp = ConfigParser.SafeConfigParser()
        if os.path.exists(conf_path):
            cp.readfp(open(conf_path, "r"))
            hf_num = cp.getint("general", "hotfix_number")
            pa_num = cp.getint("general", "patch_number")
            sp_num = cp.getint("general", "service_pack")
            self.logger.debug(
                "Read from imss.ini: hotfix_number:%d patch_number:%d service_pack:%d" % (hf_num, pa_num, sp_num))
            self.logger.debug("Upgrade requires: hotfix_number:%d patch_number:%d service_pack:%d" % (
                self.conf.getBaseHfNo(), self.conf.getBasePatchNo(), self.conf.getBaseSpNo()))
            return (0, hf_num, pa_num, sp_num)
        else:
            self.logger.debug("Config file is not exist, path is %s"%conf_path)
        return (-1, 0, 0, 0)

    def checkImssAppVersion(self,updater):
        """
        if user only install ers on a server, there will also a imss/config/imss.ini to store  build number
        for example:  /xxx/nrs  nrs installed folder, /xxx/imss/config/imss.ini the config folder
        return  0   build number check OK,
        return -1 exception happen
        return -2  build number is not fit the requirement
        check  component version on this server is 7.1
        """
        try:
            # if any of rpms in this server is not 7.1 then return check error
            for key in self.rpm_status.keys():
                if self.rpm_status[key][0]:
                    (rc, rs) = utility.Utility.getResultFromCmd(["rpm -q %s" % (key)])
                    if rc < 0 or rs.find("7.1") < 0:
                        self.logger.error("one of IMSS components in this server is not version 7.1:%s" % (rs))
                        return -1

            # first check rpms that contains imss.ini
            for key in self.rpm_status.keys():
                if key in (Const.RPM_CTRL, Const.RPM_IMSS, Const.RPM_EUQ) and self.rpm_status[key][0]:
                    path = self.rpm_status[key][1]
                    conf_path = path + "/config/imss.ini"
                    if os.path.exists(conf_path):
                        (rc, hf_num, pa_num, sp_num) = self.readVersionInfo(conf_path)
                        self.logger.debug(
                            "Read version info result is: %s Current hotfix_number patch_number SP_number is %s %s %s, require numbers is %s %s %s" %
                            (rc, hf_num, pa_num, sp_num, self.conf.getBaseHfNo(), self.conf.getBasePatchNo(),
                             self.conf.getBaseSpNo()))

                        if rc == 0 and self.conf.getBaseSpNo() <= sp_num:
                            return 0
                        if rc == 0 and self.conf.getBaseSpNo() == sp_num and self.conf.getBasePatchNo() <= pa_num:
                            return 0

            # then check nrs and ipprofiler rpm, brother folder , such as /xxx/nrs => /xxx/imss
            for key in self.rpm_status.keys():
                if key in ("nrs", "ipprofiler") and self.rpm_status[key][0]:
                    path = self.rpm_status[key][1]
                    conf_path = os.path.dirname(path) + "/imss/config/imss.ini"
                    if os.path.exists(conf_path):
                        (rc, hf_num, pa_num, sp_num) = self.readVersionInfo(conf_path)
                        self.logger.debug("hf patch sp number is: %s %s %s" % (hf_num, pa_num, sp_num));
                        if rc == 0 and self.conf.getBaseSpNo() <= sp_num:
                            return 0
                        if rc == 0 and self.conf.getBaseSpNo() == sp_num and self.conf.getBasePatchNo() <= pa_num:
                            return 0
            #if none of imss tree couple is installed. not check version.  because there is no config that can tell the version ...
            if not self.rpm_status_mgr.isOneOfImssInstalled():
                return 0
        except Exception as e:
            self.logger.debug("Exception when get build num:%s" % (str(e)))
        self.logger.debug("Fail to check imss components version.")
        return -1

    def checkOSVersion(self,updater):
        """is Redhat4 return -1"""
        ret = -1
        version_set = ["CentOS Linux release 7","CentOS release 5","CentOS release 6",
                       "Red Hat Enterprise Linux Server release 5","Red Hat Enterprise Linux Client release 5",
                       "Red Hat Enterprise Linux Server release 6","Red Hat Enterprise Linux Client release 6",
                       "Red Hat Enterprise Linux Server release 7","Red Hat Enterprise Linux Client release 7",
                       "Red Hat Enterprise Linux release 8"]
        cur_version = ""
        try:
            with open("/etc/redhat-release") as f:
                cur_version = f.readline()
                self.logger.debug("This servers OS version info is %s"%cur_version)
                for version in version_set:
                    #ignore case
                    if cur_version.lower().find(version.lower()) >= 0:
                        ret = 0
        except  Exception as e:
            self.logger.error("Exception when check version of OS: %s" + str(e))
        if ret !=0:
            updater.append(self.res.getWording("txt.upgrade.check.os.errmsg"))
        return ret

class DiskChecker:
    def __init__(self, conf,util, logger, res, rpm_status):
        self.rpm_status = rpm_status
        self.logger = logger
        self.conf = conf
        self.util = util
        self.res = res


    def checkBackupFolderStatus(self, updater):
        """
        check backup folder empty or not  and free disk size
        :param updater:
        :return:
        """
        #cal /var/imss/pgdata size
        #cal install folder size
        # txt.upgrade.backup.invalidInstallPath
        # txt.upgrade.backup.insufficientDisk
        pathSet = self.rpm_status.getInstallPathSet()
        totalSize = 0
        try:
            #all installed folders size + pg
            for path in pathSet:
                if os.path.exists(path):
                    totalSize = totalSize + int(subprocess.check_output(['du', '-sb', path]).split()[0])

            if os.path.exists(Const.PGDATA_SRC_FOLDER):
                totalSize = totalSize + int(subprocess.check_output(['du', '-sb', Const.PGDATA_SRC_FOLDER]).split()[0])

            totalSize = totalSize * 1.5

            if not os.path.isabs(self.conf.getBackupFolder()):
                self.logger.debug("The backup path %s is not a valid absolute path." % (self.conf.getBackupFolder()))
                updater.append(self.res.getWording("txt.upgrade.backup.invalidInstallPath"))
                return -1

            if os.path.exists(self.conf.getBackupFolder()) and len(os.listdir(self.conf.getBackupFolder()))>0:
                self.logger.debug("The backup path %s is not a empty folder." % (self.conf.getBackupFolder()))
                updater.append(self.res.getWording("txt.upgrade.backup.notEmpty")%self.conf.getBackupFolder())
                return -1

            avaiDiskSize = self.util.getDiskFreeSize(self.conf.getBackupFolder())
            if avaiDiskSize < totalSize:
                self.logger.debug("The available free backup disk size %d bytes in /var/imss is less than "
                                  "required size %d bytes."
                                  % (avaiDiskSize, totalSize))
                # Change size from bytes to human-readable MB format.
                updater.append(self.res.getWording("txt.upgrade.backup.insufficientDisk")
                               % (totalSize / 1024 / 1024))
                return -1
            else:
                self.logger.debug("The available free backup disk size %d bytes is larger than "
                                  "required size %d bytes."
                                  % (avaiDiskSize, totalSize))
        except Exception as e:
            self.logger.debug("Fail to check backup folder size. Exception: %s"%utility.excToString(e))
            return -1
        return 0

class Debugger:
    @staticmethod
    def print_db_info(logger, conf):
        if logger != None and conf != None:
           logger.debug(conf.getAdminDBAddress())
           logger.debug(conf.getAdminDBPort())
           logger.debug(conf.getAdminDBUsername())
           logger.debug(conf.getAdminDBPassword())
           logger.debug(conf.getAdminDBName())
    @staticmethod
    def debug_print(logger, obj):
        logger.debug(str(obj))
