-- This file will be executed after configuration migration during upgrade.
-- Normally inserting data to existing tables will be contained in this file.

--
-- Modified Table Constraints due to data transfer
--

ALTER TABLE ONLY tb_component_list
    ADD CONSTRAINT component_list_scanner_id_pk PRIMARY KEY (scanner_id);

ALTER TABLE ONLY tb_rule
    ADD CONSTRAINT rule_id PRIMARY KEY (rule_id);
ALTER TABLE ONLY tb_rule
    ADD CONSTRAINT policy_id FOREIGN KEY (policy_id) REFERENCES tb_policy(policy_id) ON UPDATE CASCADE ON DELETE CASCADE;

ALTER TABLE ONLY tb_named_obj_rule
    ADD CONSTRAINT rule_id FOREIGN KEY (rule_id) REFERENCES tb_rule(rule_id) ON UPDATE RESTRICT ON DELETE RESTRICT;

--
-- New data added to existing tables
--

SELECT insertGlobalSetting('General-Notification', 'EUQ_EnableInlineAction', 'no', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'FreeDataPartitionSize', '10240', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'FreeDataPartitionEmail', 'on', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'FreeDataPartitionSNMP', '', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'FreeDataPartition_Message', 'Free disk space of data partition on scanner is below threshold.', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'FreeDataPartition_SNMPMessage', 'Free disk space of data partition on scanner is below threshold.', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'FreeDataPartition_Subject', 'Free disk space of data partition on scanner is below threshold.', 'imss.ini', NULL);

SELECT insertGlobalSetting('General-Notification', 'FreeMTAPartitionSize', '5120', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'FreeMTAPartitionEmail', 'on', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'FreeMTAPartitionSNMP', '', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'FreeMTAPartition_Message', 'Free disk space of MTA partition on scanner is below threshold.', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'FreeMTAPartition_SNMPMessage', 'Free disk space of MTA partition on scanner is below threshold.', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'FreeMTAPartition_Subject', 'Free disk space of MTA partition on scanner is below threshold.', 'imss.ini', NULL);

SELECT insertGlobalSetting('General-Notification','SysNotificationInterval','10','imss.ini', NULL);

SELECT insertGlobalSetting('General-Notification', 'ImssReminder_NonExpireSubj', 'Your license for Trend Micro Antivirus and Content Filter will expire in %EXPIREDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'ImssReminder_ExpireSubj', 'Your license for Trend Micro Antivirus and Content Filter expired %EXPIREDAYS% day(s) ago.', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'ImssReminder_TrialNonExpireMsg', '
Your trial for Trend Micro Antivirus and Content Filter will expire in %EXPIREDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'ImssReminder_TrialExpireMsg', '
Your trial for Trend Micro Antivirus and Content Filter expired %EXPIREDAYS% day(s) ago.
Trend Micro has extended your license for an additional grace period that ends in %GRACEDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'ImssReminder_FullNonExpireMsg', '
Your license for Trend Micro Antivirus and Content Filter will expire in %EXPIREDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'ImssReminder_FullExpireMsg', '
Your license for Trend Micro Antivirus and Content Filter expired %EXPIREDAYS% day(s) ago.
Trend Micro has extended your license for an additional grace period that ends in %GRACEDAYS% day(s).', 'imss.ini', NULL);

SELECT insertGlobalSetting('General-Notification', 'SPSReminder_NonExpireSubj', 'Your license for Spam Prevention Solution (SPS) will expire in %EXPIREDAYS% day(s)', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SPSReminder_ExpireSubj', 'Your license for Spam Prevention Solution (SPS) expired %EXPIREDAYS% day(s) ago', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SPSReminder_TrialNonExpireMsg', '
Your license for Spam Prevention Solution (SPS) will expire in %EXPIREDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SPSReminder_TrialExpireMsg', '
Your license for Spam Prevention Solution (SPS) expired %EXPIREDAYS% day(s) ago.
Trend Micro has extended your license for an additional grace period that ends in %GRACEDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SPSReminder_FullNonExpireMsg', '
Your license for Spam Prevention Solution (SPS) will expire in %EXPIREDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SPSReminder_FullExpireMsg', '
Your license for Spam Prevention Solution (SPS) expired %EXPIREDAYS% day(s) ago.
Trend Micro has extended your license for an additional grace period that ends in %GRACEDAYS% day(s).', 'imss.ini', NULL);

SELECT insertGlobalSetting('General-Notification', 'NRSReminder_NonExpireSubj', 'Your license for Email Reputation Service (ERS) will expire in %EXPIREDAYS% day(s)', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'NRSReminder_ExpireSubj', 'Your license for Email Reputation Service (ERS) expired %EXPIREDAYS% day(s) ago', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'NRSReminder_TrialNonExpireMsg', '
Your license for Email Reputation Service (ERS) will expire in %EXPIREDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'NRSReminder_TrialExpireMsg', '
Your license for Email Reputation Service (ERS) expired %EXPIREDAYS% day(s) ago.
Trend Micro has extended your license for an additional grace period that ends in %GRACEDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'NRSReminder_FullNonExpireMsg', '
Your license for Email Reputation Service (ERS) will expire in %EXPIREDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'NRSReminder_FullExpireMsg', '
Your license for Email Reputation Service (ERS) expired %EXPIREDAYS% day(s) ago.
Trend Micro has extended your license for an additional grace period that ends in %GRACEDAYS% day(s).', 'imss.ini', NULL);

SELECT insertGlobalSetting('General-Notification', 'PreFltReminder_NonExpireSubj', 'Your license for Cloud Pre-Filter will expire in %EXPIREDAYS% day(s)', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'PreFltReminder_ExpireSubj', 'Your license for Cloud Pre-Filter expired %EXPIREDAYS% day(s) ago', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'PreFltReminder_TrialNonExpireMsg', '
Your license for Cloud Pre-Filter will expire in %EXPIREDAYS% day(s).
Cloud Pre-Filter will reject all email messages sent to it after your license expires.
You need to renew your license or modify your MX records before the license expires to avoid having your email messages rejected.', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'PreFltReminder_TrialExpireMsg', '
Your license for Cloud Pre-Filter expired %EXPIREDAYS% day(s) ago.
Trend Micro has extended your license for an additional grace period that ends in %GRACEDAYS% day(s).
Cloud Pre-Filter will reject all email messages sent to it after the grace period expires.
You need to renew your license or modify your MX records before the grace period expires to avoid having your email messages rejected.', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'PreFltReminder_FullNonExpireMsg', '
Your license for Cloud Pre-Filter will expire in %EXPIREDAYS% day(s).
Cloud Pre-Filter will reject all email messages sent to it after your license expires.
You need to renew your license or modify your MX records before the license expires to avoid having your email messages rejected.', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'PreFltReminder_FullExpireMsg', '
Your license for Cloud Pre-Filter expired %EXPIREDAYS% day(s) ago.
Trend Micro has extended your license for an additional grace period that ends in %GRACEDAYS% day(s).
Cloud Pre-Filter will reject all email messages sent to it after the grace period expires.
You need to renew your license or modify your MX records before the grace period expires to avoid having your email messages rejected.', 'imss.ini', NULL);

SELECT insertGlobalSetting('General-Notification', 'IBEReminder_NonExpireSubj', 'Your Email Encryption license will expire in %EXPIREDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'IBEReminder_ExpireSubj', 'Your Email Encryption license expired %EXPIREDAYS% day(s) ago.', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'IBEReminder_TrialNonExpireMsg', '
Your Email Encryption trial license will expire in %EXPIREDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'IBEReminder_TrialExpireMsg', '
Your Email Encryption trial license expired %EXPIREDAYS% day(s) ago.
Trend Micro has extended your license for an additional grace period that ends in %GRACEDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'IBEReminder_FullNonExpireMsg', '
Your Email Encryption license will expire in %EXPIREDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'IBEReminder_FullExpireMsg', '
Your Email Encryption license expired %EXPIREDAYS% day(s) ago.
Trend Micro has extended your license for an additional grace period that ends in %GRACEDAYS% day(s).', 'imss.ini', NULL);

SELECT insertGlobalSetting('General-Notification', 'ComplianceReminder_NonExpireSubj', 'Your Regulatory Compliance license will expire in %EXPIREDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'ComplianceReminder_ExpireSubj', 'Your Regulatory Compliance license expired %EXPIREDAYS% day(s) ago.', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'ComplianceReminder_TrialNonExpireMsg', '
Your Regulatory Compliance trial license will expire in %EXPIREDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'ComplianceReminder_TrialExpireMsg', '
Your Regulatory Compliance trial license expired %EXPIREDAYS% day(s) ago.
Trend Micro has extended your license for an additional grace period that ends in %GRACEDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'ComplianceReminder_FullNonExpireMsg', '
Your Regulatory Compliance license will expire in %EXPIREDAYS% day(s).', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'ComplianceReminder_FullExpireMsg', '
Your Regulatory Compliance license expired %EXPIREDAYS% day(s) ago.
Trend Micro has extended your license for an additional grace period that ends in %GRACEDAYS% day(s).', 'imss.ini', NULL);

SELECT insertGlobalSetting('General-Notification', 'DKIMSignMsgDeliMinute', '10', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'DKIMSignMsgCount', '5', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'DKIMSignSettingEmail', 'yes', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'DKIMSignSettingSNMP', 'no', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'DKIMSign_Subject', 'Unable to add DKIM signatures', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'DKIMSign_Message', 'IMSS is unable to add DKIM signatures for %TOTALMESSAGES% email messages during the last %INTERVAL%  minutes. Details are listed as follows:
Server: %HOSTNAME% 
Time: %DATE&TIME%
Reason:%REASON%
', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'DKIMSign_SNMPMessage', 'Unable to add DKIM signatures to a total of %TOTALMESSAGES% email messages during the last %INTERVAL%  minutes. Details are listed as follows:
Server: %HOSTNAME% 
Time: %DATE&TIME%
Reason:%REASON%
', 'imss.ini', NULL);

SELECT insertGlobalSetting('General-Notification', 'SmartProtectionEventSNMP', 'no', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SmartProtectionEventEmail', 'yes', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SmartProtectionEvent_Subject', 'Smart protection services unavailable on your server', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SmartProtectionEvent_Message', 'No %REPUTATIONTYPE% Reputation Services can be accessed on the scanner (host name: %HOSTNAME%). Check your settings.', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SmartProtectionEvent_SNMPMessage', 'No %REPUTATIONTYPE% Reputation Services can be accessed on the scanner (host name: %HOSTNAME%). Check your settings.', 'imss.ini', NULL);

SELECT insertGlobalSetting('General-Notification', 'WRSEventSNMP', 'no', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'WRSEventEmail', 'yes', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'WRSEvent_Subject', 'Unable to use local sources for Web Reputation queries ', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'WRSEvent_Message', 'IMSS is unable to use Smart Protection Servers for Web Reputation queries and has reverted to Smart Protection Network.', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'WRSEvent_SNMPMessage', 'IMSS is unable to use Smart Protection Servers for Web Reputation queries and has reverted to Smart Protection Network.', 'imss.ini', NULL);

SELECT insertGlobalSetting('General-Notification', 'SuspiciousObjectReloadSNMP', 'yes', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SuspiciousObjectReloadEmail', 'yes', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SuspiciousObjectReload_Subject', 'Unable to load suspicious object lists', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SuspiciousObjectReload_Message', 'IMSS is unable to load local suspicious object lists.
Host name: %HOSTNAME%
If you continuously receive this message, contact Trend Micro technical support.
', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SuspiciousObjectReload_SNMPMessage', 'IMSS is unable to load local suspicious object lists.
Host name: %HOSTNAME%
If you continuously receive this message, contact Trend Micro technical support.
', 'imss.ini', NULL);

SELECT insertGlobalSetting('imss_manager','euq_pool_param','1;1;0;3600000','imss.ini', NULL);
SELECT insertGlobalSetting('IP-Profiler','foxparser_pool_param','1;5;1;3600000','imss.ini', NULL);

SELECT insertGlobalSetting('LDAP','access_type','0','imss.ini',NULL);
SELECT insertGlobalSetting('LDAP_SVR_1','last_sync_time','','imss.ini',NULL);
SELECT insertGlobalSetting('LDAP_SVR_1','description','','imss.ini',NULL);
SELECT insertGlobalSetting('LDAP_SVR_1','default_domain','','imss.ini',NULL);
SELECT insertGlobalSetting('LDAP_SVR_1','default_realm','','imss.ini',NULL);
SELECT insertGlobalSetting('LDAP_SVR_1','KDC_admin_server','','imss.ini',NULL);
SELECT insertGlobalSetting('LDAP_SVR_1','KDC_port','','imss.ini',NULL);
SELECT insertGlobalSetting('LDAP','server_num','0','imss.ini',NULL);
SELECT insertGlobalSetting('ldap-cache','sync_status','0','imss.ini',NULL);
SELECT insertGlobalSetting('ldap-cache','sync_fail_server','','imss.ini',NULL);

SELECT insertGlobalSetting('Update', 'UpdateATSEEngine', 'yes', 'imss.ini', NULL);
SELECT insertGlobalSetting('Update', 'UpdateDateATSEEngine', NULL, 'imss.ini', NULL);

SELECT insertGlobalSetting('euq', 'enable_sso', 'no', 'imss.ini', NULL);
SELECT insertGlobalSetting('euq', 'Admin_Not_Spam', '1', 'imss.ini', NULL);
SELECT insertGlobalSetting('euq', 'enable_sso_ntlm', 'no', 'imss.ini', NULL);
SELECT insertGlobalSetting('euq', 'enable_sso_kerberos', 'no', 'imss.ini', NULL);
SELECT insertGlobalSetting('euq', 'digest_inline_action_key', random_string(16), 'imss.ini', NULL);

SELECT insertGlobalSetting('general', 'ers_evt_log_prefix', 'ers.imss', 'imss.ini', NULL);
---SELECT insertGlobalSetting('general', 'ers_evt_log_path', '/opt/trend/imss/log', 'imss.ini', NULL);
SELECT insertGlobalSetting('general', 'message_trace_log_prefix', 'msgtra.imss', 'imss.ini', NULL);
---SELECT insertGlobalSetting('general', 'message_trace_log_path', '/opt/trend/imss/log', 'imss.ini', NULL);
--- Delete some records according to Case Jira-IMSS-41
DELETE FROM tb_global_setting WHERE section='general' and name in ('event_log_path', 'policy_evt_log_path' , 'queue_notify');

SELECT insertGlobalSetting('Report', 'trafficsum_bookmark', '0', 'imss.ini', NULL);

--- Update Data on demand
UPDATE tb_administrator set prefilter_permission='3' where admin_name='admin';
UPDATE tb_administrator set prefilter_permission='0' where admin_name!='admin';
UPDATE tb_global_setting set value='no' where name='ers_enabled' and (select count(nrs) from tb_component_list where nrs!=0) = 0;
UPDATE t_foxhuntersetting set enable=false where "type"=1 and (select count(ipprofiler) from tb_component_list where ipprofiler!=0) = 0;
SELECT insertGlobalSetting('graymail', 'graymail_ers_query_zone', 'r.ers.trendmicro.com', 'imss.ini', NULL);
DELETE FROM tb_global_setting WHERE section='mml' and name='mml_ers_query_zone';
UPDATE tb_global_setting SET value='utf-8' WHERE section='MessageModule' and name='DefaultSourceCharset' and value='us-ascii';
UPDATE tb_global_setting SET value='50' WHERE section='general' and name='log_individual_split_when_size';
UPDATE tb_global_setting SET value='50000' WHERE section='general' and name='proc_max_connections';
UPDATE tb_global_setting SET value='utf-8' WHERE section='General-Notification' and name='PreferredCharset' and value='us-ascii';
DELETE FROM tb_global_setting WHERE section='General-Notification' and name in ('SmartScan_Subject', 'SmartScan_Message', 'SmartScan_SNMPMessage');
SELECT insertGlobalSetting('General-Notification', 'SmartScan_Subject', 'Switched to Conventional Scan', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SmartScan_Message', 'IMSS is unable to use Smart Scan and has reverted to Conventional Scan.', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'SmartScan_SNMPMessage', 'IMSS is unable to use Smart Scan and has reverted to Conventional Scan.', 'imss.ini', NULL);
DELETE FROM tb_global_setting WHERE section='LDAP' and name='mail_attr' and inifile='ldap.ini';

--- IBE
SELECT insertGlobalSetting('IBE','enable','no','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','enc_size_limit','10','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','dec_size_limit','20','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','max_rcpt_number','100','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','enable_outgoing_enc_excp','yes','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','enable_outgoing_dec_excp','yes','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','default_sender','','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','account','','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','gateway_id','','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','contact_name','','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','phone_number','','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','password','','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','account_status','1','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','domain_number','0','imss.ini',NULL);
SELECT insertGlobalSetting('IBE','ibe_db_pool_param','5;100;5;300000','imss.ini',NULL);

---INSERT INTO tb_scanning_exceptions VALUES(5, '2;10;', '1;0;0;0;2;1;3;2;3;1-1;1;3;10;4;1-11;');
---INSERT INTO tb_scanning_exceptions VALUES(6, '2;10;', '1;0;0;0;2;1;3;2;3;1-1;1;3;10;3;1-4;');

---INSERT INTO tb_named_obj_scan_exception VALUES (1, 5);
---INSERT INTO tb_named_obj_scan_exception VALUES (11, 5);

---   Quick solution: its value must be the same as the id allocated for 'Cloud Pre-Filter Quarantine' in tb_named_obj
SELECT insertGlobalSetting('pre-filter', 'spam_quar_rule_blob', '99999', 'imss.ini', NULL);
SELECT insertGlobalSetting('pre-filter', 'spam_quar_area_blob', '15:27:Cloud Pre-Filter Quarantine:0:', 'imss.ini', NULL);

SELECT insertGlobalSetting('pre-filter','imht_port','9000','imss.ini',NULL);
SELECT insertGlobalSetting('pre-filter','imht_uri_charset','UTF-8','imss.ini',NULL);
SELECT insertGlobalSetting('pre-filter','imht_def_host','ws3.emailsecurity.trendmicro.com','imss.ini',NULL);
SELECT insertGlobalSetting('pre-filter','imht_pass','236263a483d766f9e40b111e00451641f523af79640099a0','imss.ini',NULL);
SELECT insertGlobalSetting('pre-filter','bundle_name','prefilter_imss','imss.ini',NULL);
SELECT insertGlobalSetting('pre-filter','imht_def_service_status_addr','https://emsp-sp-us01-wsstatus.trendmicro.com:443/status','imss.ini',NULL);

---
---  set the maximum number of rollbackable patch
---
SELECT insertGlobalSetting('patch', 'max_rollbackable_patch_number', '5', 'imss.ini', NULL);

insert into t_type_setting_default(type, enable, "Duration", totalmail, rate, recipients, action, nonexistrcpt,blockduration,watchtimeunits,blocktimeunits) values(5, false,300, 1000,10000, 1, 2, 1,1800,2,2);
insert into t_type_setting_default(type, enable, "Duration", totalmail, rate, recipients, action, nonexistrcpt,blockduration,watchtimeunits,blocktimeunits) values(6, false,300, 1000, 0, 1, 2, 1,1800,2,2);

---
---   initialize tb_tls_policy_map setting for outgoing
---
INSERT INTO tb_tls_policy_map VALUES (1, 1, 'default', 0, 'may', 'medium', NULL, NULL, NULL, NULL);

---
---   initialize tb_tls_policy_map setting for incoming
---
INSERT INTO tb_tls_policy_map VALUES (0, 1, 'default', 0, 'may', 'medium', NULL, NULL, NULL, NULL);

UPDATE tb_global_setting SET value='9.950.1006' where section='Update' and name='VersionVirusEngine';
---UPDATE tb_global_setting SET value='9.867.1029' where section='Update' and name='VersionATSEEngine';
UPDATE tb_global_setting SET value='12.439.00' where section='Update' and name='VersionSmartScanAgentPattern';
UPDATE tb_global_setting SET value='12.439.00' where section='Update' and name='VersionVirusPattern';
UPDATE tb_global_setting SET value='1.719.00' where section='Update' and name='VersionSpywarePattern';
UPDATE tb_global_setting SET value='0.227.00' where section='Update' and name='VersionIntellitrapPattern';
UPDATE tb_global_setting SET value='1.279.00' where section='Update' and name='VersionIntellitrapException';
UPDATE tb_global_setting SET value='8.100.1062' where section='Update' and name='VersionTMASEEngine';
UPDATE tb_global_setting SET value='22232.006' where section='Update' and name='VersionTMASEPattern';
UPDATE tb_global_setting SET value='3.910.1008' where section='Update' and name='VersionTMUFEEngine';
UPDATE tb_global_setting SET value='Linux' where section='Update' and name='Platform';
---add atse engine
SELECT insertGlobalSetting('Update', 'VersionATSEEngine', '9.867.1029', 'imss.ini', NULL);

-- AU type update
update tb_active_update set type=110 where type=109;
update tb_active_update set type=10 where type=9;


SELECT insertGlobalSetting('import', 'disabled_feature', '', 'imss.ini', NULL);

--added for DTAS integration
SELECT insertGlobalSetting('general', 'scan_mode', '0', 'imss.ini', NULL);
SELECT insertGlobalSetting('dda', 'dda_enabled', '0', 'imss.ini', NULL);
SELECT insertGlobalSetting('dda', 'EnableProxy', '0', 'imss.ini', NULL);
SELECT insertGlobalSetting('dda', 'ProxyServer', '', 'imss.ini', NULL);
SELECT insertGlobalSetting('dda', 'ProxyPort', '8080', 'imss.ini', NULL);
SELECT insertGlobalSetting('dda', 'ProxyUserName', '', 'imss.ini', NULL);
SELECT insertGlobalSetting('dda', 'ProxyPassword', '', 'imss.ini', NULL);
SELECT insertGlobalSetting('dda', 'RiskLevel', '3', 'imss.ini', NULL);
SELECT insertGlobalSetting('dda', 'dda_num', '0', 'imss.ini', NULL);

SELECT insertGlobalSetting('General-Notification', 'DDASettingSNMP', 'no', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'DDASettingEmail', 'yes', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'DDA_Subject', 'Message analysis is incomplete or invalid', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'DDA_Message', 'Scanning server: %HOSTNAME%
Message ID: %XMAILID%
Subject: %SUBJECT%
Sender: %SENDER%
Recipient(s): %RCPTS%
Attachment(s): %FILENAME%
Reason: %REASON%', 'imss.ini', NULL);
SELECT insertGlobalSetting('General-Notification', 'DDA_SNMPMessage', 'Scanning server: %HOSTNAME%
Message ID: %XMAILID%
Subject: %SUBJECT%
Sender: %SENDER%
Recipient(s): %RCPTS%
Attachment(s): %FILENAME%
Reason: %REASON%', 'imss.ini', NULL);

SELECT insertGlobalSetting('smart_scan', 'query_timeout_ms', '1500', 'imss.ini', NULL);
SELECT insertGlobalSetting('smart_scan', 'use_local', '0', 'imss.ini', NULL);
SELECT insertGlobalSetting('smart_scan', 'auto_switch_back_to_conventional', '1', 'imss.ini', NULL);

--add for wrs category mapping
SELECT insertGlobalSetting('wrs','Adult','16,1,2,8,11,9,25,5,26,6,3,4,10,14,15','imss.ini',NULL);
SELECT insertGlobalSetting('wrs','Business','21,31,32,45,59,58,60','imss.ini',NULL);
SELECT insertGlobalSetting('wrs','CommunicationsAndSearch','40,41,24,42,51,52,53,50,89','imss.ini',NULL);
SELECT insertGlobalSetting('wrs','General','27,34,36,37,38,46,48,49,35,67,90,12,13','imss.ini',NULL);
SELECT insertGlobalSetting('wrs','InternetSecurity','77,79,82,86,78,75,73,39,76,74,88,91,92,93,95','imss.ini',NULL);
SELECT insertGlobalSetting('wrs','Lifestyle','30,44,18,19,20,29,54,55,61,63,64,65,66,68,22,33,47,87','imss.ini',NULL);
SELECT insertGlobalSetting('wrs','NetworkBandwidth','23,56,72,70,71,57,43,69','imss.ini',NULL);

--add for WRS agent
SELECT insertGlobalSetting('wrsagent','use_local','0','imss.ini',NULL);
SELECT insertGlobalSetting('wrsagent','auto_switch_back_to_spn','1','imss.ini',NULL);
SELECT insertGlobalSetting('wrsagent','stop_external_query','0','imss.ini',NULL);
SELECT insertGlobalSetting('wrsagent','tmufe_alter_rs_host','backup35.url.trendmicro.com','imss.ini',NULL);

-- this is the db data initialize script for rtstat
insert into tb_rtstat_setting values(60,300,150,150);

---
---   initialize DB Maintain setting
---
--SELECT insertGlobalSetting('DB_Maintain', 'enableReindex', 'on', 'imss.ini', '');
SELECT insertGlobalSetting('DB_Maintain', 'enableAnalyze', 'on', 'imss.ini', '');
SELECT insertGlobalSetting('DB_Maintain', 'enableVacuum', 'on', 'imss.ini', '');
--SELECT insertGlobalSetting('DB_Maintain', 'isMonthSched', '0', 'imss.ini', '');
--SELECT insertGlobalSetting('DB_Maintain', 'weekDay', '0', 'imss.ini', '');
--SELECT insertGlobalSetting('DB_Maintain', 'weekHour', '4', 'imss.ini', '');
--SELECT insertGlobalSetting('DB_Maintain', 'weekMinute', '0', 'imss.ini', '');
--SELECT insertGlobalSetting('DB_Maintain', 'monthDay', '1', 'imss.ini', '');
--SELECT insertGlobalSetting('DB_Maintain', 'monthHour', '4', 'imss.ini', '');
--SELECT insertGlobalSetting('DB_Maintain', 'monthMinute', '0', 'imss.ini', '');
SELECT insertGlobalSetting('DB_Maintain', 'analyzeHour', '2', 'imss.ini', '');
SELECT insertGlobalSetting('DB_Maintain', 'analyzeMinute', '0', 'imss.ini', '');
SELECT insertGlobalSetting('DB_Maintain', 'vacuumHour', '3', 'imss.ini', '');
SELECT insertGlobalSetting('DB_Maintain', 'vacuumMinute', '0', 'imss.ini', '');

---
---   initialize EUQ setting
---
SELECT insertGlobalSetting('general', 'enable_euq', '0', 'imss.ini', '');

---
---   EUQ DL Management
---
SELECT insertGlobalSetting('general','enable_dl_maintain','0','imss.ini', NULL);

---
---   initialzed Internal Host setting
---
SELECT insertGlobalSetting('general', 'internal_host_enable', 'no', 'imss.ini', '');
SELECT insertGlobalSetting('general', 'received_ip_expression_file_path', '/config/received_ip_expression','imss.ini', '');
SELECT insertGlobalSetting('general', 'received_ip_expression_default', E'.*.*\\s*from\\s+.*?\\[(.+)\\].*','imss.ini','');

---
---  initialized ERS setting
---
SELECT insertGlobalSetting('ers','ers_enabled','no','imss.ini',NULL);
SELECT insertGlobalSetting('ers','ers_approved_list','','imss.ini',NULL);
SELECT insertGlobalSetting('ers','update_ers_ac','','imss.ini',NULL);
SELECT insertGlobalSetting('ers','rbl_reply_map_use_default','yes','imss.ini',NULL);
SELECT insertGlobalSetting('ers','rbl_reply_map_use_standard_default','yes','imss.ini',NULL);
SELECT insertGlobalSetting('ers','rbl_reply_map_user','450,Service unavailable','imss.ini',NULL);
SELECT insertGlobalSetting('ers','rbl_reply_map_user_standard','550,error message','imss.ini',NULL);

---
---  insert default Known host IP
---
INSERT INTO tb_internal_host VALUES('10.0.0.0/8',1,'');
INSERT INTO tb_internal_host VALUES('127.0.0.0/8',1,'');
INSERT INTO tb_internal_host VALUES('172.16.0.0/12',1,'');
INSERT INTO tb_internal_host VALUES('192.168.0.0/16',1,'');
INSERT INTO tb_internal_host VALUES('::1',1,'');
INSERT INTO tb_internal_host VALUES('fe80::/10',1,'');

---
--- flag for sync foxproxy.ini
---
INSERT INTO tb_tables_version VALUES ('t_iprule',0);
INSERT INTO tb_tables_version VALUES('ers',0);
INSERT INTO tb_tables_version VALUES('ip_profiler',0);
INSERT INTO tb_tables_version VALUES('internal_host',0);
INSERT INTO tb_tables_version VALUES('smpt_traffic_throttling',0);
-- flag for sync custom defense black list
INSERT INTO tb_tables_version VALUES('tb_custom_defense_blacklist',0);

---
---   hidden key for aggressive level setting (ATSE)
---
SELECT insertGlobalSetting('general','detection_aggressive_level','3','imss.ini',NULL);

SELECT insertGlobalSetting('syslog_setting','log_sync_interval','30','imss.ini',NULL);
SELECT insertGlobalSetting('syslog_setting','monitor_interval','30','imss.ini',NULL);
SELECT insertGlobalSetting('syslog_setting','log_buffer_size','100','imss.ini',NULL);
SELECT insertGlobalSetting('syslog_setting','syslog_version','1','imss.ini',NULL);

insert into tb_syslog_logtype values('LOGTYPE_MESSAGE_TRACKING','msgtra.imss');
insert into tb_syslog_logtype values('LOGTYPE_POLICY_EVENT','polevt.imss');
insert into tb_syslog_logtype values('LOGTYPE_SYSTEM_EVENT','sysevt.imss');
insert into tb_syslog_logtype values('LOGTYPE_MTA_EVENT','imssdps;tlsagent');
insert into tb_syslog_logtype values('LOGTYPE_IP_FILTERING','foxdns.log;foxmsg;foxreport;ers.imss;foxnullmsg;connblocked.imss;smtpconnagent');
insert into tb_syslog_logtype values('LOGTYPE_CONTENT_SCANNING','log.imss;imssps;wrsagent;dtasagent');
insert into tb_syslog_logtype values('LOGTYPE_ADMINISTRATION','imssui;imssmgr;imsstasks;euqerror.imss;euqretry.imss;euqsynch.imss;msgsync.imss;msgretry.imss;Agent.log;EntityMain.log');
--insert into tb_syslog_logtype values('LOGTYPE_Others','polevt.imss');

--different version may use different URL
insert into tb_smart_protection_server values('5e6abb2a-aec3-4364-a7c3-5a98fd2a9098', 'imss91-lnx.icrc.trendmicro.com', 1, 0, 443, 0, 1, 1, '/ss','',0,0,null);
insert into tb_smart_protection_server values('f50ec2f2-16bc-4131-965a-a881e069f310','imss91-en.url.trendmicro.com',0,1,0,80,0,1,'','',0,0,null);

-- To identify the DLP template version we are using now.
SELECT insertGlobalSetting('general','dlp_template_version','3.1.1008','imss.ini', NULL);

SELECT insertGlobalSetting('click_protection', 'ws_host', 'imss91-ctp.trendmicro.com', 'imss.ini', NULL);
SELECT insertGlobalSetting('click_protection', 'ws_port', '443', 'imss.ini', NULL);
SELECT insertGlobalSetting('click_protection', 'ws_api_key', '', 'imss.ini', NULL);
SELECT insertGlobalSetting('click_protection', 'ws_sec_key', '', 'imss.ini', NULL);
SELECT insertGlobalSetting('click_protection', 'ws_conn_timeout', '10', 'imss.ini', NULL);
SELECT insertGlobalSetting('click_protection', 'ws_so_timeout', '30', 'imss.ini', NULL);
SELECT insertGlobalSetting('click_protection', 'ws_retry_count', '3', 'imss.ini', NULL);
SELECT insertGlobalSetting('click_protection', 'ws_expiry_time', '600', 'imss.ini', NULL);
SELECT insertGlobalSetting('click_protection', 'ws_search_limit_one_time', '1000', 'imss.ini', NULL);
SELECT insertGlobalSetting('click_protection', 'ws_search_limit_total', '10000', 'imss.ini', NULL);

SELECT insertGlobalSetting('NTP_Setting','ntp_server','','imss.ini', NULL);
SELECT insertGlobalSetting('NTP_Setting','enable_ntp','no','imss.ini', NULL);

--- SMTP Traffic Throttling
SELECT insertGlobalSetting('general','connection_is_enable','no','imss.ini',NULL);
SELECT insertGlobalSetting('smtp_traffic_throttling','connection_blockedlog_record_interval','300','imss.ini',NULL);
SELECT insertGlobalSetting('smtp_traffic_throttling','connection_config_reload_interval','60','imss.ini',NULL);
SELECT insertGlobalSetting('smtp_traffic_throttling','connection_response_blocked_ip','action=421 4.7.5 Connection IP is blocked by SMTP Traffic Throttling of IMSS','imss.ini',NULL);
SELECT insertGlobalSetting('smtp_traffic_throttling','connection_response_blocked_sender','action=421 4.7.5 Current Sender is blocked by SMTP Traffic Throttling of IMSS','imss.ini',NULL);

-- Registration information updates.
update tb_global_setting set value='9.1' where section='Registration' and name='product_version';

-- AU server setting
update tb_global_setting set value='http://imss91-p.activeupdate.trendmicro.com/activeupdate' where section='Update' and name='UpdateServer';
update tb_global_setting set value='http://imss91-p.activeupdate.trendmicro.com/activeupdate' where section='Update' and name='TMASEServerurl';

-- Cleanup utilities used in upgrade.
DROP FUNCTION IF EXISTS insertGlobalSetting(TEXT, TEXT, TEXT, TEXT, TEXT);

-- DataTransfer Prepare
CREATE TABLE tb_log_table_info_bak as select * from tb_log_table_info;

CREATE TABLE tb_data_transfer_info (
    table_id int4,
    table_name text,
    start_time timestamp with time zone,
    end_time timestamp with time zone,
    status int4,
    retry_count int4
)WITHOUT OIDS;


CREATE OR REPLACE FUNCTION ModifyPolicyEventTables(int, int) RETURNS int AS $$
DECLARE
    nFirstHour     ALIAS FOR $1;
    nCreateNum     ALIAS FOR $2;
    nTmp           int;
    nHourSeq       int;
    szCmd text;
    vTableName text;
    vTableNameBak text;
    vSeq text;
    vSeqBak text;
    vInfo_NotFoundTable text;
    v_Rec          RECORD;
BEGIN
    nTmp := 0;
    while nCreateNum > nTmp loop
        nHourSeq := nFirstHour + nTmp;
        vTableName := 'tb_policy_event_' || nHourSeq;
        vTableNameBak := vTableName || '_bak';
      
        vSeq := vTableName|| '_policy_event_id_seq';
        vSeqBak := vTableNameBak || '_policy_event_id_seq';
        vInfo_NotFoundTable := 'not Found table ' || vTableName || ', just create it.';

        SELECT INTO v_rec * FROM pg_class WHERE relname = vTableName;
        if found then  
            szCmd := 'ALTER TABLE ' || vTableName || ' DROP CONSTRAINT policy_event_' || nHourSeq || '_policy_event_id_pk';
            execute szCmd;  
            szCmd := 'DROP INDEX IF EXISTS idx_policy_event_' || nHourSeq || '_timedate';
            execute szCmd;
            szCmd := 'DROP INDEX IF EXISTS idx_policy_event_' || nHourSeq || '_msgid_scannerid';
            execute szCmd; 
            szCmd := 'ALTER TABLE ' || vTableName  || ' RENAME TO ' || vTableNameBak;
            execute szCmd;
            szCmd := 'ALTER TABLE ' || vTableNameBak || ' ALTER policy_event_id TYPE INTEGER';
            execute szCmd;
            szCmd := 'ALTER SEQUENCE ' || vSeq || ' RENAME TO ' || vSeqBak;
            execute szCmd; 
            szCmd := 'CREATE TABLE ' || vTableName || ' (
                policy_event_id serial NOT NULL,
                msg_id char(36) NOT NULL,
                scanner_id int4 NOT NULL,  
                smtp_sender varchar(321),
                smtp_rcpt varchar(2048),
                msg_subject varchar(256),
                msg_route int2,
                msg_size float8,
                rule_name varchar(256),
                time_date timestamptz NOT NULL,
                filter_type_virus bit(1) DEFAULT B''0''::"bit",
                filter_type_spyware bit(1) DEFAULT B''0''::"bit",
                filter_type_spam bit(1) DEFAULT B''0''::"bit",
                filter_type_attachment bit(1) DEFAULT B''0''::"bit",
                filter_type_content bit(1) DEFAULT B''0''::"bit",
                filter_type_size bit(1) DEFAULT B''0''::"bit",
                filter_type_other bit(1) DEFAULT B''0''::"bit",
                filter_type_malformed bit(1) DEFAULT B''0''::"bit",
                filter_type_unscanned bit(1) DEFAULT B''0''::"bit",
                filter_type_phishing bit(1) DEFAULT B''0''::"bit",
                filter_description varchar(256),
                act_deleted bit(1) DEFAULT B''0''::"bit",
                act_quarantined bit(1) DEFAULT B''0''::"bit",
                act_delivered bit(1) DEFAULT B''0''::"bit",
                act_archived bit(1) DEFAULT B''0''::"bit",
                act_rcptchanged bit(1) DEFAULT B''0''::"bit",
                act_stamped bit(1) DEFAULT B''0''::"bit",
                act_attachments_deleted bit(1) DEFAULT B''0''::"bit",
                act_subjects_tagged bit(1) DEFAULT B''0''::"bit",
                act_delivery_postponed bit(1) DEFAULT B''0''::"bit",
                act_notifications_sent bit(1) DEFAULT B''0''::"bit",
                act_cleaned bit(1) DEFAULT B''0''::"bit",
                act_bcc bit(1) DEFAULT B''0''::"bit",
                act_handoff bit(1) DEFAULT B''0''::"bit",
                spam_score float4 DEFAULT (0)::real,
                spam_category_id int4 DEFAULT 1,
                spam_sensitive int2 DEFAULT 0,
                attach_name varchar(1024),
                attach_type varchar(80),
                virus_name varchar(1024),
                virus_type varchar(80),
                original_msg_id varchar(1024),
                filter_type_wrs bit(1) DEFAULT B''0''::"bit",
                wrs_threshold int4,
                wrs_score int4,
                reason varchar(1024),
                filter_type_dkim bit(1) DEFAULT B''0''::"bit",
                dkim_author varchar(256),
                dkim_reason varchar(1024),
                act_insert_x_header_tag bit(1) DEFAULT B''0''::"bit",
                filter_type_preflt bit(1) DEFAULT B''0''::"bit",
                filter_type_compliance bit(1) DEFAULT B''0''::"bit",
                act_decryption bit(1) DEFAULT B''0''::"bit",
                act_encryption bit(1) DEFAULT B''0''::"bit",
                act_reencryption bit(1) DEFAULT B''0''::"bit",
                dda_status int2,
                dda_rating int2,
                filter_type_ccca bit(1) DEFAULT B''0''::"bit",
                ccca_detection_type    varchar(10),
                ccca_detection_addresses varchar(1024),
                wrs_category_list varchar(1024),
                filter_type_graymail bit(1) DEFAULT B''0''::"bit",
                graymail_category int4 DEFAULT 0,
                dlp_compliance_matchdetail varchar(32768),
                filter_type_snap bit(1) DEFAULT B''0''::"bit",
                snap_report text,
                suspicious_apt_filters_map int4,
                analyzed_apt_filters_map int4,
                triggered_keywords varchar(2048),
                original_attach_name varchar(1024),
                filter_type_so bit(1) DEFAULT B''0''::"bit",
                so_file_detection int2 default 0,
                so_file_sourcetype text,
                so_file_action int2,
                so_file_value text,
                so_url_detection int2 default 0,
                so_url_sourcetype text,
                so_url_action int2,
                so_url_value text,
                is_rule_triggered boolean DEFAULT false,
                rewrite_status smallint DEFAULT 0,
                rewritten_url_num integer DEFAULT 0,
                emerging_threat_category smallint,
                dda_virus_name text,
                ransomware_type smallint,
                CONSTRAINT policy_event_' || nHourSeq || '_policy_event_id_pk PRIMARY KEY (policy_event_id)
            )
            WITHOUT OIDS;';
            execute szCmd; 
            szCmd :=  'SELECT setval(''' || vSeq || ''', nextval(''' || vSeqBak ||'''));';
            execute szCmd;  
            szCmd := 'INSERT INTO tb_data_transfer_info(table_id, table_name, status, retry_count) values('''||nHourSeq||''', '''||vTableName||''', 0, 0);';          
            execute szCmd;
            szCmd := 'CREATE INDEX idx_policy_event_' || nHourSeq || '_timedate ON tb_policy_event_' || nHourSeq || '(time_date)';
            execute szCmd;
        else
            RAISE INFO '%', vInfo_NotFoundTable;
            szCmd := 'CREATE TABLE ' || vTableName || ' (
                policy_event_id serial NOT NULL,
                msg_id char(36) NOT NULL,
                scanner_id int4 NOT NULL,  
                smtp_sender varchar(321),
                smtp_rcpt varchar(2048),
                msg_subject varchar(256),
                msg_route int2,
                msg_size float8,
                rule_name varchar(256),
                time_date timestamptz NOT NULL,
                filter_type_virus bit(1) DEFAULT B''0''::"bit",
                filter_type_spyware bit(1) DEFAULT B''0''::"bit",
                filter_type_spam bit(1) DEFAULT B''0''::"bit",
                filter_type_attachment bit(1) DEFAULT B''0''::"bit",
                filter_type_content bit(1) DEFAULT B''0''::"bit",
                filter_type_size bit(1) DEFAULT B''0''::"bit",
                filter_type_other bit(1) DEFAULT B''0''::"bit",
                filter_type_malformed bit(1) DEFAULT B''0''::"bit",
                filter_type_unscanned bit(1) DEFAULT B''0''::"bit",
                filter_type_phishing bit(1) DEFAULT B''0''::"bit",
                filter_description varchar(256),
                act_deleted bit(1) DEFAULT B''0''::"bit",
                act_quarantined bit(1) DEFAULT B''0''::"bit",
                act_delivered bit(1) DEFAULT B''0''::"bit",
                act_archived bit(1) DEFAULT B''0''::"bit",
                act_rcptchanged bit(1) DEFAULT B''0''::"bit",
                act_stamped bit(1) DEFAULT B''0''::"bit",
                act_attachments_deleted bit(1) DEFAULT B''0''::"bit",
                act_subjects_tagged bit(1) DEFAULT B''0''::"bit",
                act_delivery_postponed bit(1) DEFAULT B''0''::"bit",
                act_notifications_sent bit(1) DEFAULT B''0''::"bit",
                act_cleaned bit(1) DEFAULT B''0''::"bit",
                act_bcc bit(1) DEFAULT B''0''::"bit",
                act_handoff bit(1) DEFAULT B''0''::"bit",
                spam_score float4 DEFAULT (0)::real,
                spam_category_id int4 DEFAULT 1,
                spam_sensitive int2 DEFAULT 0,
                attach_name varchar(1024),
                attach_type varchar(80),
                virus_name varchar(1024),
                virus_type varchar(80),
                original_msg_id varchar(1024),
                filter_type_wrs bit(1) DEFAULT B''0''::"bit",
                wrs_threshold int4,
                wrs_score int4,
                reason varchar(1024),
                filter_type_dkim bit(1) DEFAULT B''0''::"bit",
                dkim_author varchar(256),
                dkim_reason varchar(1024),
                act_insert_x_header_tag bit(1) DEFAULT B''0''::"bit",
                filter_type_preflt bit(1) DEFAULT B''0''::"bit",
                filter_type_compliance bit(1) DEFAULT B''0''::"bit",
                act_decryption bit(1) DEFAULT B''0''::"bit",
                act_encryption bit(1) DEFAULT B''0''::"bit",
                act_reencryption bit(1) DEFAULT B''0''::"bit",
                dda_status int2,
                dda_rating int2,
                filter_type_ccca bit(1) DEFAULT B''0''::"bit",
                ccca_detection_type    varchar(10),
                ccca_detection_addresses varchar(1024),
                wrs_category_list varchar(1024),
                filter_type_graymail bit(1) DEFAULT B''0''::"bit",
                graymail_category int4 DEFAULT 0,
                dlp_compliance_matchdetail varchar(32768),
                filter_type_snap bit(1) DEFAULT B''0''::"bit",
                snap_report text,
                suspicious_apt_filters_map int4,
                analyzed_apt_filters_map int4,
                triggered_keywords varchar(2048),
                original_attach_name varchar(1024),
                filter_type_so bit(1) DEFAULT B''0''::"bit",
                so_file_detection int2 default 0,
                so_file_sourcetype text,
                so_file_action int2,
                so_file_value text,
                so_url_detection int2 default 0,
                so_url_sourcetype text,
                so_url_action int2,
                so_url_value text,
                is_rule_triggered boolean DEFAULT false,
                rewrite_status smallint DEFAULT 0,
                rewritten_url_num integer DEFAULT 0,
                emerging_threat_category smallint,
                dda_virus_name text,
                ransomware_type smallint,
                CONSTRAINT policy_event_' || nHourSeq || '_policy_event_id_pk PRIMARY KEY (policy_event_id)
            )
            WITHOUT OIDS;';
            execute szCmd;
            szCmd := 'CREATE INDEX idx_policy_event_' || nHourSeq || '_timedate ON tb_policy_event_' || nHourSeq || '(time_date)';
            execute szCmd; 
        end if;
        
        nTmp := nTmp + 1;
    end loop;
	  
    return 0;
END;
$$ LANGUAGE plpgsql;

DO $$ BEGIN
    PERFORM ModifyPolicyEventTables(0, 512);
    PERFORM ModifyPolicyEventTables(512, 512);
    PERFORM ModifyPolicyEventTables(1024, 512);
END $$;
DROP FUNCTION ModifyPolicyEventTables(int, int);

CREATE OR REPLACE FUNCTION ModifyArchiveTables(int, int) RETURNS int AS $$
DECLARE
    nFirstHour     ALIAS FOR $1;
    nCreateNum     ALIAS FOR $2;
    nTmp           int;
    nHourSeq       int;
    szCmd text;
    vTableName text;
    vTableNameBak text;
    
    vInfo_NotFoundTable text;
    v_Rec          RECORD;
BEGIN
    nTmp := 0;
    while nCreateNum > nTmp loop
        nHourSeq := nFirstHour + nTmp;
        vTableName := 'tb_archive_' || nHourSeq;
        vTableNameBak := vTableName || '_bak';

        vInfo_NotFoundTable := 'not Found table ' || vTableName || ', just create it.';

        SELECT INTO v_rec * FROM pg_class WHERE relname = vTableName;
        if found then  
            szCmd := 'ALTER TABLE ' || vTableName || ' DROP CONSTRAINT archive_' || nHourSeq || '_policy_event_id_pk';
            execute szCmd;  
            szCmd := 'DROP INDEX IF EXISTS idx_archive_' || nHourSeq || '_timedate';
            execute szCmd;
            szCmd := 'DROP INDEX IF EXISTS idx_archive_' || nHourSeq || '_msgid_scannerid';
            execute szCmd;
            szCmd := 'ALTER TABLE ' || vTableName  || ' RENAME TO ' || vTableNameBak;
            execute szCmd;
            szCmd := 'CREATE TABLE ' || vTableName || ' (
                policy_event_id int4 NOT NULL,
                msg_id char(36) NOT NULL,
                scanner_id int4 NOT NULL,
                smtp_sender varchar(321),
                smtp_rcpt varchar(2048),
                msg_subject varchar(256),
                msg_route int2,
                msg_size float8,
                qa_id int4 NOT NULL,
                rule_name varchar(256),
                time_date timestamptz,
                filter_type_virus bit(1) DEFAULT B''0''::"bit",
                filter_type_spyware bit(1) DEFAULT B''0''::"bit",
                filter_type_spam bit(1) DEFAULT B''0''::"bit",
                filter_type_attachment bit(1) DEFAULT B''0''::"bit",
                filter_type_content bit(1) DEFAULT B''0''::"bit",
                filter_type_size bit(1) DEFAULT B''0''::"bit",
                filter_type_other bit(1) DEFAULT B''0''::"bit",
                filter_type_malformed bit(1) DEFAULT B''0''::"bit",
                filter_type_unscanned bit(1) DEFAULT B''0''::"bit",
                filter_type_phishing bit(1) DEFAULT B''0''::"bit",
                attach_name varchar(1024),
                qt_live_ttl timestamptz,
                original_msg_id varchar(1024),
                filter_type_wrs bit(1) DEFAULT B''0''::"bit",
                filter_type_dkim bit(1) DEFAULT B''0''::"bit",
                filter_type_preflt bit(1) DEFAULT B''0''::"bit",
                filter_type_compliance bit(1) DEFAULT B''0''::"bit",
                dda_status int2,
                dda_rating int2,
                filter_type_ccca bit(1) DEFAULT B''0''::"bit",
                filter_type_graymail bit(1) DEFAULT B''0''::"bit",
                filter_type_snap bit(1) DEFAULT B''0''::"bit",
                suspicious_apt_filters_map int4,
                analyzed_apt_filters_map int4,
                filter_type_so bit(1) DEFAULT B''0''::"bit",
                CONSTRAINT archive_' || nHourSeq || '_policy_event_id_pk PRIMARY KEY (policy_event_id)
            ) 
            WITHOUT OIDS;';
            execute szCmd;  
            szCmd := 'INSERT INTO tb_data_transfer_info(table_id, table_name, status, retry_count) values('''||nHourSeq||''', '''||vTableName||''', 0, 0);';          
            execute szCmd;
            szCmd := 'CREATE INDEX idx_archive_' || nHourSeq || '_timedate ON tb_archive_' || nHourSeq || '(time_date)';
            execute szCmd;
        else
            RAISE INFO '%', vInfo_NotFoundTable;
            szCmd := 'CREATE TABLE ' || vTableName || ' (
                policy_event_id int4 NOT NULL,
                msg_id char(36) NOT NULL,
                scanner_id int4 NOT NULL,
                smtp_sender varchar(321),
                smtp_rcpt varchar(2048),
                msg_subject varchar(256),
                msg_route int2,
                msg_size float8,
                qa_id int4 NOT NULL,
                rule_name varchar(256),
                time_date timestamptz,
                filter_type_virus bit(1) DEFAULT B''0''::"bit",
                filter_type_spyware bit(1) DEFAULT B''0''::"bit",
                filter_type_spam bit(1) DEFAULT B''0''::"bit",
                filter_type_attachment bit(1) DEFAULT B''0''::"bit",
                filter_type_content bit(1) DEFAULT B''0''::"bit",
                filter_type_size bit(1) DEFAULT B''0''::"bit",
                filter_type_other bit(1) DEFAULT B''0''::"bit",
                filter_type_malformed bit(1) DEFAULT B''0''::"bit",
                filter_type_unscanned bit(1) DEFAULT B''0''::"bit",
                filter_type_phishing bit(1) DEFAULT B''0''::"bit",
                attach_name varchar(1024),
                qt_live_ttl timestamptz,
                original_msg_id varchar(1024),
                filter_type_wrs bit(1) DEFAULT B''0''::"bit",
                filter_type_dkim bit(1) DEFAULT B''0''::"bit",
                filter_type_preflt bit(1) DEFAULT B''0''::"bit",
                filter_type_compliance bit(1) DEFAULT B''0''::"bit",
                dda_status int2,
                dda_rating int2,
                filter_type_ccca bit(1) DEFAULT B''0''::"bit",
                filter_type_graymail bit(1) DEFAULT B''0''::"bit",
                filter_type_snap bit(1) DEFAULT B''0''::"bit",
                suspicious_apt_filters_map int4,
                analyzed_apt_filters_map int4,
                filter_type_so bit(1) DEFAULT B''0''::"bit",
                CONSTRAINT archive_' || nHourSeq || '_policy_event_id_pk PRIMARY KEY (policy_event_id)
            ) 
            WITHOUT OIDS;';
            execute szCmd;
            szCmd := 'CREATE INDEX idx_archive_' || nHourSeq || '_timedate ON tb_archive_' || nHourSeq || '(time_date)';
            execute szCmd;  
        end if;
        
        nTmp := nTmp + 1;
    end loop;
	  
    return 0;
END;
$$ LANGUAGE plpgsql;

DO $$ BEGIN
    PERFORM ModifyArchiveTables(0, 512);
    PERFORM ModifyArchiveTables(512, 512);
    PERFORM ModifyArchiveTables(1024, 512);
END $$;
DROP FUNCTION ModifyArchiveTables(int, int);

CREATE OR REPLACE FUNCTION ModifyQuarantineTables(int, int) RETURNS int AS $$
DECLARE
    nFirstHour     ALIAS FOR $1;
    nCreateNum     ALIAS FOR $2;
    nTmp           int;
    nHourSeq       int;
    szCmd text;
    vTableName text;
    vTableNameBak text;
    
    vInfo_NotFoundTable text;
    v_Rec          RECORD;
BEGIN
    nTmp := 0;
    while nCreateNum > nTmp loop
        nHourSeq := nFirstHour + nTmp;
        vTableName := 'tb_quarantine_' || nHourSeq;
        vTableNameBak := vTableName || '_bak';

        vInfo_NotFoundTable := 'not Found table ' || vTableName || ', just create it.';

        SELECT INTO v_rec * FROM pg_class WHERE relname = vTableName;
        if found then  
            szCmd := 'ALTER TABLE ' || vTableName || ' DROP CONSTRAINT quarantine_' || nHourSeq || '_policy_event_id_pk';
            execute szCmd;   
            szCmd := 'DROP INDEX IF EXISTS idx_quarantine_' || nHourSeq || '_timedate';
            execute szCmd;
            szCmd := 'DROP INDEX IF EXISTS idx_quarantine_' || nHourSeq || '_msgid_scannerid';
            execute szCmd;
            szCmd := 'ALTER TABLE ' || vTableName  || ' RENAME TO ' || vTableNameBak;
            execute szCmd;
            szCmd := 'CREATE TABLE ' || vTableName || ' (
                policy_event_id int4 NOT NULL,
                msg_id char(36) NOT NULL,
                scanner_id int4 NOT NULL,
                smtp_sender varchar(321),
                smtp_rcpt varchar(2048),
                msg_subject varchar(256),
                msg_route int2,
                msg_size float8,
                qa_id int4 NOT NULL,
                rule_name varchar(256),
                time_date timestamptz,
                filter_type_virus bit(1) DEFAULT B''0''::"bit",
                filter_type_spyware bit(1) DEFAULT B''0''::"bit",
                filter_type_spam bit(1) DEFAULT B''0''::"bit",
                filter_type_attachment bit(1) DEFAULT B''0''::"bit",
                filter_type_content bit(1) DEFAULT B''0''::"bit",
                filter_type_size bit(1) DEFAULT B''0''::"bit",
                filter_type_other bit(1) DEFAULT B''0''::"bit",
                filter_type_malformed bit(1) DEFAULT B''0''::"bit",
                filter_type_unscanned bit(1) DEFAULT B''0''::"bit",
                filter_type_phishing bit(1) DEFAULT B''0''::"bit",
                attach_name varchar(1024),
                qt_live_ttl timestamptz,
                ref_num int4 DEFAULT 0,
                original_msg_id varchar(1024),
                filter_type_wrs bit(1) DEFAULT B''0''::"bit",
                filter_type_dkim bit(1) DEFAULT B''0''::"bit",
                filter_type_preflt bit(1) DEFAULT B''0''::"bit",
                filter_type_compliance bit(1) DEFAULT B''0''::"bit",
                dda_status int2,
                dda_rating int2,
                filter_type_ccca bit(1) DEFAULT B''0''::"bit",
                filter_type_graymail bit(1) DEFAULT B''0''::"bit",
                filter_type_snap bit(1) DEFAULT B''0''::"bit",
                suspicious_apt_filters_map int4,
                analyzed_apt_filters_map int4,
                filter_type_so bit(1) DEFAULT B''0''::"bit",
                CONSTRAINT quarantine_' || nHourSeq || '_policy_event_id_pk PRIMARY KEY (policy_event_id)
            ) 
            WITHOUT OIDS;';
            execute szCmd;  
            szCmd := 'INSERT INTO tb_data_transfer_info(table_id, table_name, status, retry_count) values('''||nHourSeq||''', '''||vTableName||''', 0, 0);';         
            execute szCmd;
            szCmd := 'CREATE INDEX idx_quarantine_' || nHourSeq || '_timedate ON tb_quarantine_' || nHourSeq || '(time_date)';
            execute szCmd;
        else
            RAISE INFO '%', vInfo_NotFoundTable;
            szCmd := 'CREATE TABLE ' || vTableName || ' (
                policy_event_id int4 NOT NULL,
                msg_id char(36) NOT NULL,
                scanner_id int4 NOT NULL,
                smtp_sender varchar(321),
                smtp_rcpt varchar(2048),
                msg_subject varchar(256),
                msg_route int2,
                msg_size float8,
                qa_id int4 NOT NULL,
                rule_name varchar(256),
                time_date timestamptz,
                filter_type_virus bit(1) DEFAULT B''0''::"bit",
                filter_type_spyware bit(1) DEFAULT B''0''::"bit",
                filter_type_spam bit(1) DEFAULT B''0''::"bit",
                filter_type_attachment bit(1) DEFAULT B''0''::"bit",
                filter_type_content bit(1) DEFAULT B''0''::"bit",
                filter_type_size bit(1) DEFAULT B''0''::"bit",
                filter_type_other bit(1) DEFAULT B''0''::"bit",
                filter_type_malformed bit(1) DEFAULT B''0''::"bit",
                filter_type_unscanned bit(1) DEFAULT B''0''::"bit",
                filter_type_phishing bit(1) DEFAULT B''0''::"bit",
                attach_name varchar(1024),
                qt_live_ttl timestamptz,
                ref_num int4 DEFAULT 0,
                original_msg_id varchar(1024),
                filter_type_wrs bit(1) DEFAULT B''0''::"bit",
                filter_type_dkim bit(1) DEFAULT B''0''::"bit",
                filter_type_preflt bit(1) DEFAULT B''0''::"bit",
                filter_type_compliance bit(1) DEFAULT B''0''::"bit",
                dda_status int2,
                dda_rating int2,
                filter_type_ccca bit(1) DEFAULT B''0''::"bit",
                filter_type_graymail bit(1) DEFAULT B''0''::"bit",
                filter_type_snap bit(1) DEFAULT B''0''::"bit",
                suspicious_apt_filters_map int4,
                analyzed_apt_filters_map int4,
                filter_type_so bit(1) DEFAULT B''0''::"bit",
                CONSTRAINT quarantine_' || nHourSeq || '_policy_event_id_pk PRIMARY KEY (policy_event_id)
            ) 
            WITHOUT OIDS;';
            execute szCmd; 
            szCmd := 'CREATE INDEX idx_quarantine_' || nHourSeq || '_timedate ON tb_quarantine_' || nHourSeq || '(time_date)';
            execute szCmd;
        end if;
        
        nTmp := nTmp + 1;
    end loop;
	  
    return 0;
END;
$$ LANGUAGE plpgsql;

DO $$ BEGIN
    PERFORM ModifyQuarantineTables(0, 512);
    PERFORM ModifyQuarantineTables(512, 512);
    PERFORM ModifyQuarantineTables(1024, 512);
END $$;
DROP FUNCTION ModifyQuarantineTables(int, int);

CREATE OR REPLACE FUNCTION ModifyMsgTracingTables(int, int) RETURNS int AS $$
DECLARE
    nFirstHour     ALIAS FOR $1;
    nCreateNum     ALIAS FOR $2;
    nTmp           int;
    nHourSeq       int;
    szCmd text;
    vTableName text;
    vTableNameBak text;
    vSeq text;
    vSeqBak text;
    vInfo_NotFoundTable text;
    v_Rec          RECORD;
BEGIN
    nTmp := 0;
    while nCreateNum > nTmp loop
        nHourSeq := nFirstHour + nTmp;
        vTableName := 'tb_msg_tracing_' || nHourSeq;
        vTableNameBak := vTableName || '_bak';
      
        vSeq := vTableName|| '_msg_tracing_id_seq';
        vSeqBak := vTableNameBak || '_msg_tracing_id_seq';
        vInfo_NotFoundTable := 'not Found table ' || vTableName || ', skip.';

        SELECT INTO v_rec * FROM pg_class WHERE relname = vTableName;
        if found then 
            RAISE INFO 'Should not found this table %', vTableName; 
        else
            RAISE INFO '%', vInfo_NotFoundTable;
            szCmd := 'CREATE TABLE ' || vTableName || ' (
                msg_tracing_id serial NOT NULL, 
                in_timestamp timestamptz NOT NULL,
                scan_timestamp timestamptz,
                out_timestamp timestamptz,
                first_delivery_timestamp timestamptz,
                msg_id varchar(1024) NOT NULL,
                internal_msg_id varchar(36),
                postfix_id varchar(16),
                scanner_id int4 NOT NULL CHECK (scanner_id > 0),
                smtp_mail_from varchar(321) NOT NULL,
                smtp_rcpt_to varchar(2048) NOT NULL,
                subject varchar(256),
                client_ip varchar(384),
                delivery_ip varchar(384),
                delivery_feedback varchar(384),
                delivery_status varchar(8),
                first_delivery_info varchar(384),
                act_deleted bit(1) DEFAULT B''0''::"bit",
                act_quarantined bit(1) DEFAULT B''0''::"bit",
                act_delivered bit(1) DEFAULT B''0''::"bit",
                act_archived bit(1) DEFAULT B''0''::"bit",
                act_rcptchanged bit(1) DEFAULT B''0''::"bit",
                act_stamped bit(1) DEFAULT B''0''::"bit",
                act_attachments_deleted bit(1) DEFAULT B''0''::"bit",
                act_subjects_tagged bit(1) DEFAULT B''0''::"bit",
                act_delivery_postponed bit(1) DEFAULT B''0''::"bit",
                act_notifications_sent bit(1) DEFAULT B''0''::"bit",
                act_cleaned bit(1) DEFAULT B''0''::"bit",
                act_bcc bit(1) DEFAULT B''0''::"bit",
                act_handoff bit(1) DEFAULT B''0''::"bit",
                act_insert_x_header_tag bit(1) DEFAULT B''0''::"bit",
                extra_item text,
                split_flag int4 NOT NULL DEFAULT 0 CHECK (split_flag = 0 OR split_flag = 1 OR split_flag = 2),
                reprocess_flag bool NOT NULL DEFAULT false,
                match_policy_flag bool NOT NULL DEFAULT true,
                todeliverytimestamp timestamptz,
                indeliverytimestamp timestamptz,
                act_decryption bit(1) DEFAULT B''0''::"bit",
                act_encryption bit(1) DEFAULT B''0''::"bit",
                act_reencryption bit(1) DEFAULT B''0''::"bit",
                dkim_result text,
                tls int4 NOT NULL DEFAULT 0,
                original_attach_name text,
                CONSTRAINT msg_tracing_' || nHourSeq || '_msg_tracing_id_pk PRIMARY KEY (msg_tracing_id)
            )
            WITHOUT OIDS;';
            execute szCmd; 
            szCmd := 'CREATE INDEX idx_msg_tracing_' || nHourSeq || '_timedate ON tb_msg_tracing_' || nHourSeq || '(in_timestamp)';
            execute szCmd;
            szCmd := 'CREATE INDEX idx_tb_msg_tracing_' || nHourSeq || '_postfix_id ON tb_msg_tracing_' || nHourSeq || '(postfix_id)';
            execute szCmd;
        end if;
        
        nTmp := nTmp + 1;
    end loop;
	  
    return 0;
END;
$$ LANGUAGE plpgsql;

DO $$ BEGIN
    PERFORM ModifyMsgTracingTables(0, 512);
    PERFORM ModifyMsgTracingTables(512, 512);
    PERFORM ModifyMsgTracingTables(1024, 512);
END $$;
DROP FUNCTION ModifyMsgTracingTables(int, int);


CREATE OR REPLACE FUNCTION DoDataTransferAsyn() RETURNS text AS $$  
DECLARE
    v_count INT;
    v_rec RECORD;
    v_log_table_info_rec_new RECORD;
    v_log_table_info_rec_old RECORD;
    v_table_id INT;
    v_table_name TEXT;
    v_cmd TEXT;
    v_start_time TIMESTAMP;
    v_need_transfer BOOLEAN;
    v_need_reindex  BOOLEAN;
BEGIN
    v_count := 0;
    FOR v_rec IN SELECT * FROM tb_data_transfer_info WHERE status=0 ORDER BY table_id, table_name limit 60
    loop
        v_need_transfer := FALSE;
        v_need_reindex := FALSE;
        if v_rec.retry_count > 2
        then
            RAISE INFO 'I am not able to transfer data for this table %', v_rec.table_name;
            return 'SKIP';
        end if;
        if v_table_id is NULL or v_rec.table_id != v_table_id
        then
            if v_count > 14
            then
                RAISE INFO 'I am tired, I need to have a break';
                return 'SUCCESS';
            else
                v_count := v_count + 1; 
                v_table_id := v_rec.table_id;
                RAISE INFO 'I will process No.% table in this execution with table_id %', v_count, v_table_id;
            end if;
        end if;
        v_table_name := v_rec.table_name;
        RAISE INFO 'now i am processing % and now is %', v_rec.table_name, extract(epoch from clock_timestamp());
        SELECT INTO v_start_time clock_timestamp();
        SELECT INTO v_log_table_info_rec_new * FROM tb_log_table_info WHERE table_id=v_table_id;
        if found and v_log_table_info_rec_new.hour_num is not NULL and v_log_table_info_rec_new.hour_num != '-1'
        then
            RAISE INFO 'this table is not truncated';
            SELECT INTO v_log_table_info_rec_old * FROM tb_log_table_info_bak WHERE table_id=v_table_id;
            if found and v_log_table_info_rec_new.hour_num is not NULL and 
                v_log_table_info_rec_old.hour_num is not NULL and 
                v_log_table_info_rec_new.hour_num = v_log_table_info_rec_old.hour_num
            then
                if v_log_table_info_rec_new.time_start is not NULL and 
                    v_log_table_info_rec_old.time_start is not NULL and
                    v_log_table_info_rec_new.time_start = v_log_table_info_rec_old.time_start
                then
                    RAISE INFO 'this table needs to transfer';
                    v_need_transfer := TRUE;
                    if v_log_table_info_rec_old.indexed is not NULL and
                        v_log_table_info_rec_old.indexed = B'1'
                    then
                        RAISE INFO 'this table needs to reindex';
                        v_need_reindex := TRUE;
                    end if;
                else
                    RAISE INFO 'this table is reused with different time_start';
                end if;
            else
                RAISE INFO 'this table is reused with different hour_num';
            end if;
        end if;
        
        if v_need_transfer
        then
            if v_rec.table_name like 'tb_policy_event%'
            then
                RAISE INFO 'process type policy_event';
                v_cmd := 'INSERT INTO ' || v_rec.table_name || ' (policy_event_id, msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, 
                            msg_size, rule_name, time_date, filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment, filter_type_content, 
                            filter_type_size, filter_type_other, filter_type_malformed, filter_type_unscanned, filter_type_phishing, filter_description, act_deleted, 
                            act_quarantined, act_delivered, act_archived, act_rcptchanged, act_stamped, act_attachments_deleted, act_subjects_tagged,  act_delivery_postponed, 
                            act_notifications_sent, act_cleaned, act_bcc, act_handoff, spam_score, spam_category_id, spam_sensitive, attach_name, attach_type, virus_name, 
                            virus_type, original_msg_id, filter_type_wrs, wrs_threshold, wrs_score, reason, filter_type_dkim, dkim_author, dkim_reason, 
                            act_insert_x_header_tag, filter_type_graymail,triggered_keywords, original_attach_name, wrs_category_list, emerging_threat_category, 
                            ransomware_type, dda_status, is_rule_triggered) SELECT policy_event_id, msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, 
                            msg_size, rule_name, time_date, filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment, filter_type_content, 
                            filter_type_size, filter_type_other, filter_type_malformed, filter_type_unscanned, filter_type_phishing, filter_description, act_deleted, 
                            act_quarantined, act_delivered, act_archived, act_rcptchanged, act_stamped, act_attachments_deleted, act_subjects_tagged,  act_delivery_postponed, 
                            act_notifications_sent, act_cleaned, act_bcc, act_handoff, spam_score, spam_category_id, spam_sensitive, attach_name, attach_type, virus_name, 
                            virus_type, original_msg_id, filter_type_wrs, wrs_threshold, wrs_score, reason, filter_type_dkim, dkim_author, dkim_reason, 
                            act_insert_x_header_tag, filter_type_mml,triggered_keywords, original_attach_name, wrs_category_list, emerging_threat_category, 
                            ransomware_type, 0 as dda_status, true as is_rule_triggered FROM ' || v_rec.table_name || '_bak;';
                execute v_cmd;
                v_cmd := 'UPDATE ' || v_rec.table_name || ' SET is_rule_triggered=false WHERE rule_name=''''';
                execute v_cmd;
                if v_need_reindex
                then
                    v_cmd := 'CREATE INDEX idx_policy_event_' || v_table_id || '_msgid_scannerid ON tb_policy_event_' || v_table_id || '(msg_id, scanner_id)';
                    execute v_cmd;
                end if;
            end if;
            if v_rec.table_name like 'tb_archive%'
            then
                RAISE INFO 'process type archive';
                v_cmd := 'INSERT INTO ' || v_rec.table_name || ' (policy_event_id, msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, 
                            msg_size, qa_id, rule_name, time_date, filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment, filter_type_content, 
                            filter_type_size, filter_type_other, filter_type_malformed, filter_type_unscanned, filter_type_phishing, attach_name, qt_live_ttl, original_msg_id,
                            filter_type_wrs, filter_type_dkim, filter_type_graymail, dda_status) SELECT policy_event_id, msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, 
                            msg_size, qa_id, rule_name, time_date, filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment, filter_type_content, 
                            filter_type_size, filter_type_other, filter_type_malformed, filter_type_unscanned, filter_type_phishing, attach_name, qt_live_ttl, original_msg_id,
                            filter_type_wrs, filter_type_dkim, filter_type_mml, 0 as dda_status FROM ' || v_rec.table_name || '_bak;';
                execute v_cmd;
                if v_need_reindex
                then
                    v_cmd := 'CREATE INDEX idx_archive_' || v_table_id || '_msgid_scannerid ON tb_archive_' || v_table_id || '(msg_id, scanner_id)';
                    execute v_cmd;
                end if;
            end if;
            if v_rec.table_name like 'tb_quarantine%'
            then
                RAISE INFO 'process type quarantine';
                v_cmd := 'INSERT INTO ' || v_rec.table_name || ' (policy_event_id, msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, 
                            msg_size, qa_id, rule_name, time_date, filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment, filter_type_content, 
                            filter_type_size, filter_type_other, filter_type_malformed, filter_type_unscanned, filter_type_phishing, attach_name, qt_live_ttl, 
                            ref_num, original_msg_id, filter_type_wrs, filter_type_dkim, filter_type_graymail, dda_status) SELECT policy_event_id, msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, 
                            msg_size, qa_id, rule_name, time_date, filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment, filter_type_content, 
                            filter_type_size, filter_type_other, filter_type_malformed, filter_type_unscanned, filter_type_phishing, attach_name, qt_live_ttl, 
                            ref_num, original_msg_id, filter_type_wrs, filter_type_dkim, filter_type_mml, 0 as dda_status FROM ' || v_rec.table_name || '_bak;';
                execute v_cmd;
                if v_need_reindex
                then
                    v_cmd := 'CREATE INDEX idx_quarantine_' || v_table_id || '_msgid_scannerid ON tb_quarantine_' || v_table_id || '(msg_id, scanner_id)';
                    execute v_cmd;
                end if;
            end if;
        end if;
        UPDATE tb_data_transfer_info SET start_time=v_start_time, end_time=clock_timestamp(), status=1 where table_id=v_table_id and table_name=v_table_name;
        v_cmd := 'DROP TABLE '||v_rec.table_name||'_bak';
        execute v_cmd;
        
    end loop;
    return 'SUCCESS';
EXCEPTION WHEN OTHERS THEN
    RAISE INFO 'Exception %', SQLERRM;
    return v_table_name;
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION DoDataTransferSync() RETURNS int AS $$  
DECLARE
    v_count INT;
    v_rec RECORD;
    v_log_table_info_rec_new RECORD;
    v_log_table_info_rec_old RECORD;
    v_table_id INT;
    v_table_name TEXT;
    v_cmd TEXT;
    v_start_time TIMESTAMP;
    v_need_transfer BOOLEAN;
    v_need_reindex  BOOLEAN;
BEGIN
    v_count := 0;
    FOR v_rec IN SELECT * FROM tb_data_transfer_info WHERE table_id in (SELECT table_id from tb_log_table_info_bak where time_start is not NULL order by time_start desc limit 24) ORDER BY table_id, table_name
    loop
        v_need_transfer := FALSE;
        v_need_reindex := FALSE;
        v_table_id := v_rec.table_id;
        v_table_name := v_rec.table_name;
        RAISE INFO 'now i am processing % and now is %', v_rec.table_name, extract(epoch from clock_timestamp());
        SELECT INTO v_start_time clock_timestamp();
        SELECT INTO v_log_table_info_rec_new * FROM tb_log_table_info WHERE table_id=v_table_id;
        if found and v_log_table_info_rec_new.hour_num is not NULL and v_log_table_info_rec_new.hour_num != '-1'
        then
            RAISE INFO 'this table is not truncated';
            SELECT INTO v_log_table_info_rec_old * FROM tb_log_table_info_bak WHERE table_id=v_table_id;
            if found and v_log_table_info_rec_new.hour_num is not NULL and 
                v_log_table_info_rec_old.hour_num is not NULL and 
                v_log_table_info_rec_new.hour_num = v_log_table_info_rec_old.hour_num
            then
                if v_log_table_info_rec_new.time_start is not NULL and 
                    v_log_table_info_rec_old.time_start is not NULL and
                    v_log_table_info_rec_new.time_start = v_log_table_info_rec_old.time_start
                then
                    RAISE INFO 'this table needs to transfer';
                    v_need_transfer := TRUE;
                    if v_log_table_info_rec_old.indexed is not NULL and
                        v_log_table_info_rec_old.indexed = B'1'
                    then
                        RAISE INFO 'this table needs to reindex';
                        v_need_reindex := TRUE;
                    end if;
                else
                    RAISE INFO 'this table is reused with different time_start';
                end if;
            else
                RAISE INFO 'this table is reused with different hour_num';
            end if;
        end if;
        
        if v_need_transfer
        then
            if v_rec.table_name like 'tb_policy_event%'
            then
                RAISE INFO 'process type policy_event';
                v_cmd := 'INSERT INTO ' || v_rec.table_name || ' (policy_event_id, msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, 
                            msg_size, rule_name, time_date, filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment, filter_type_content, 
                            filter_type_size, filter_type_other, filter_type_malformed, filter_type_unscanned, filter_type_phishing, filter_description, act_deleted, 
                            act_quarantined, act_delivered, act_archived, act_rcptchanged, act_stamped, act_attachments_deleted, act_subjects_tagged,  act_delivery_postponed, 
                            act_notifications_sent, act_cleaned, act_bcc, act_handoff, spam_score, spam_category_id, spam_sensitive, attach_name, attach_type, virus_name, 
                            virus_type, original_msg_id, filter_type_wrs, wrs_threshold, wrs_score, reason, filter_type_dkim, dkim_author, dkim_reason, 
                            act_insert_x_header_tag, filter_type_graymail,triggered_keywords, original_attach_name, wrs_category_list, emerging_threat_category, 
                            ransomware_type, dda_status, is_rule_triggered) SELECT policy_event_id, msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, 
                            msg_size, rule_name, time_date, filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment, filter_type_content, 
                            filter_type_size, filter_type_other, filter_type_malformed, filter_type_unscanned, filter_type_phishing, filter_description, act_deleted, 
                            act_quarantined, act_delivered, act_archived, act_rcptchanged, act_stamped, act_attachments_deleted, act_subjects_tagged,  act_delivery_postponed, 
                            act_notifications_sent, act_cleaned, act_bcc, act_handoff, spam_score, spam_category_id, spam_sensitive, attach_name, attach_type, virus_name, 
                            virus_type, original_msg_id, filter_type_wrs, wrs_threshold, wrs_score, reason, filter_type_dkim, dkim_author, dkim_reason, 
                            act_insert_x_header_tag, filter_type_mml,triggered_keywords, original_attach_name, wrs_category_list, emerging_threat_category, 
                            ransomware_type, 0 as dda_status, true as is_rule_triggered FROM ' || v_rec.table_name || '_bak;';
                execute v_cmd;
                v_cmd := 'UPDATE ' || v_rec.table_name || ' SET is_rule_triggered=false WHERE rule_name=''''';
                execute v_cmd;
                if v_need_reindex
                then
                    v_cmd := 'CREATE INDEX idx_policy_event_' || v_table_id || '_msgid_scannerid ON tb_policy_event_' || v_table_id || '(msg_id, scanner_id)';
                    execute v_cmd;
                end if;
            end if;
            if v_rec.table_name like 'tb_archive%'
            then
                RAISE INFO 'process type archive';
                v_cmd := 'INSERT INTO ' || v_rec.table_name || ' (policy_event_id, msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, 
                            msg_size, qa_id, rule_name, time_date, filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment, filter_type_content, 
                            filter_type_size, filter_type_other, filter_type_malformed, filter_type_unscanned, filter_type_phishing, attach_name, qt_live_ttl, original_msg_id,
                            filter_type_wrs, filter_type_dkim, filter_type_graymail, dda_status) SELECT policy_event_id, msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, 
                            msg_size, qa_id, rule_name, time_date, filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment, filter_type_content, 
                            filter_type_size, filter_type_other, filter_type_malformed, filter_type_unscanned, filter_type_phishing, attach_name, qt_live_ttl, original_msg_id,
                            filter_type_wrs, filter_type_dkim, filter_type_mml, 0 as dda_status FROM ' || v_rec.table_name || '_bak;';
                execute v_cmd;
                if v_need_reindex
                then
                    v_cmd := 'CREATE INDEX idx_archive_' || v_table_id || '_msgid_scannerid ON tb_archive_' || v_table_id || '(msg_id, scanner_id)';
                    execute v_cmd;
                end if;
            end if;
            if v_rec.table_name like 'tb_quarantine%'
            then
                RAISE INFO 'process type quarantine';
                v_cmd := 'INSERT INTO ' || v_rec.table_name || ' (policy_event_id, msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, 
                            msg_size, qa_id, rule_name, time_date, filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment, filter_type_content, 
                            filter_type_size, filter_type_other, filter_type_malformed, filter_type_unscanned, filter_type_phishing, attach_name, qt_live_ttl, 
                            ref_num, original_msg_id, filter_type_wrs, filter_type_dkim, filter_type_graymail, dda_status) SELECT policy_event_id, msg_id, scanner_id, smtp_sender, smtp_rcpt, msg_subject, msg_route, 
                            msg_size, qa_id, rule_name, time_date, filter_type_virus, filter_type_spyware, filter_type_spam, filter_type_attachment, filter_type_content, 
                            filter_type_size, filter_type_other, filter_type_malformed, filter_type_unscanned, filter_type_phishing, attach_name, qt_live_ttl, 
                            ref_num, original_msg_id, filter_type_wrs, filter_type_dkim, filter_type_mml, 0 as dda_status FROM ' || v_rec.table_name || '_bak;';
                execute v_cmd;
                if v_need_reindex
                then
                    v_cmd := 'CREATE INDEX idx_quarantine_' || v_table_id || '_msgid_scannerid ON tb_quarantine_' || v_table_id || '(msg_id, scanner_id)';
                    execute v_cmd;
                end if;
            end if;
        end if;
        UPDATE tb_data_transfer_info SET start_time=v_start_time, end_time=clock_timestamp(), status=1 where table_id=v_table_id and table_name=v_table_name;
        v_cmd := 'DROP TABLE '||v_rec.table_name||'_bak';
        execute v_cmd;
        
    end loop;
    return 0;
EXCEPTION WHEN OTHERS THEN
    RAISE INFO 'Exception %', SQLERRM;
    return 2;
END;
$$ LANGUAGE plpgsql;

DO $$ BEGIN
    PERFORM DoDataTransferSync();
END $$;
DROP FUNCTION DoDataTransferSync();


