/* Kernel Hook Module for Trend Micro ServerProtect for Linux  */
/* Copyright (C) 2012 Trend Micro Incorporated.                */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 */

#ifndef _MISC_H_
#define _MISC_H_

#include    <linux/fs.h>

extern void removeCache(struct inode *inode);
extern void removeCacheBySuperblock(struct        super_block *sb);
extern void addCache(struct inode *inode);

extern Boolean needToScanThisOpen(struct dentry *dentry, struct vfsmount *mnt, int flags, struct inode *inode);
extern Boolean needToScanThisClose(struct dentry *dentry, struct vfsmount *mnt, int flags, struct inode *inode);
extern Boolean needToScanThisExecve(struct dentry *dentry, struct vfsmount *mnt, struct inode *inode);
extern Boolean needToDenyWrite(struct dentry *dentry, struct vfsmount *mnt, int flags);

#endif

