@echo off
ECHO -------------------------------------------------------------------------------
ECHO Usage: ReconfMemLimits.cmd [Local SQLServer Instance Name] [Memory Limit in MB]
ECHO -------------------------------------------------------------------------------
ECHO.

SET SQLSVRINSTANCE=ScanMail
SET MEMORYLIMIT=200
IF '%1'=='' (GOTO ELSE1)
SET SQLSVRINSTANCE=%1
:ELSE1
IF '%2'=='' (GOTO ELSE2)
SET MEMORYLIMIT=%2
:ELSE2

ECHO Connect to server ".\%SQLSVRINSTANCE%" and to configure the memory limite to "%MEMORYLIMIT%".....
ECHO.

SET STATEMENT1=EXEC sys.sp_configure N'show advanced options', N'1'  RECONFIGURE WITH OVERRIDE;
SET STATEMENT2=EXEC sys.sp_configure N'max server memory (MB)', N'%MEMORYLIMIT%';
SET STATEMENT3=RECONFIGURE WITH OVERRIDE;
SET STATEMENT3=EXEC sys.sp_configure N'show advanced options', N'0'  RECONFIGURE WITH OVERRIDE;
SET SQLSTATEMENT=%STATEMENT1% %STATEMENT2% %STATEMENT3% %STATEMENT4%

ECHO Executing SQL statement.....
ECHO %SQLSTATEMENT%
ECHO.
ECHO Execution result.....
sqlcmd -S .\%SQLSVRINSTANCE% -E -Q "%SQLSTATEMENT%"

GOTO END

:END
