﻿<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY % cfgDefinition SYSTEM "cfgDefinition.dtd">
	%cfgDefinition;
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes" omit-xml-declaration="yes"/>
	<xsl:template match="cfg_database">
		<xsl:apply-templates select="tables//table"/>
	</xsl:template>
	<xsl:template match="cfg_database/tables/table">
			<xsl:text>
			</xsl:text>
			<sql>CREATE TABLE <xsl:value-of select="@name"/>
			<xsl:text>
			(
					&DEFAULT_INDEX_FIELD_NAME; NVARCHAR(128) PRIMARY KEY,
					&DEFAULT_DEFAULT_INSTANCE_FIELD_NAME; NTEXT DEFAULT "</xsl:text>
					<xsl:value-of select="schema/fieldset/defaule_instance_reference/@value"/><xsl:text>",
					&DEFAULT_IGNORE_FIELDS_FIELD_NAME; NTEXT DEFAULT "</xsl:text>
					<xsl:for-each select="schema/fieldset/fields/field[@import_action='&DEFINE_IT_IGNORE;' or @import_action='&DEFINE_IT_ALWAYS_IGNORE;']">
						<xsl:value-of select="@name"/><xsl:if test="@import_action ='&DEFINE_IT_ALWAYS_IGNORE;'">###</xsl:if>
						<xsl:if test="position() != last()">
						<xsl:text>;</xsl:text>
						</xsl:if>
					</xsl:for-each>				
					<xsl:text>",
					</xsl:text>
				<xsl:apply-templates select="schema/fieldset/fields/field/*">
				<xsl:with-param name="value_only">false</xsl:with-param>
				</xsl:apply-templates>
			<xsl:text>
			)
			</xsl:text>
			</sql>
		<xsl:apply-templates select="instances//instance"/>
	</xsl:template>
	<xsl:template match="cfg_database/tables/table/instances/instance">
			<xsl:text>
			</xsl:text>
			<sql>INSERT INTO <xsl:value-of select="../../@name"/>
			<xsl:text>
			(
					&DEFAULT_INDEX_FIELD_NAME;,
					&DEFAULT_DEFAULT_INSTANCE_FIELD_NAME;,
					&DEFAULT_IGNORE_FIELDS_FIELD_NAME;,
					</xsl:text>
		<xsl:for-each select="fieldset/fields/field">
			<xsl:value-of select="@name"/>
			<xsl:if test="position() != last()">
				<xsl:text>,
					</xsl:text>
			</xsl:if>
		</xsl:for-each>
		<xsl:text>
			)
			</xsl:text>
			<xsl:text>VALUES
			(
					</xsl:text>
		<xsl:text>"</xsl:text>
		<xsl:value-of select="fieldset/index/@value"/>
		<xsl:text>",
					"</xsl:text>
		<xsl:value-of select="fieldset/defaule_instance_reference/@value"/>
		<xsl:text>",
					"</xsl:text>
		<xsl:for-each select="../../schema/fieldset/fields/field[@import_action='&DEFINE_IT_IGNORE;' or @import_action='&DEFINE_IT_ALWAYS_IGNORE;']">
			<xsl:value-of select="@name"/><xsl:if test="@import_action ='&DEFINE_IT_ALWAYS_IGNORE;'">###</xsl:if>
			<xsl:if test="position() != last()">
				<xsl:text>;</xsl:text>
			</xsl:if>
		</xsl:for-each>
		<xsl:text>",
					</xsl:text>
		<xsl:apply-templates select="fieldset/fields/field/*">
			<xsl:with-param name="value_only">true</xsl:with-param>
		</xsl:apply-templates>
		<xsl:text>
			);
			</xsl:text>
			</sql>
	</xsl:template>
	<!-- ================================================================================================ -->
	<xsl:template match="fieldset/fields/field/*[@dt_type='&DEFINE_DT_BOOLEAN;']">
		<xsl:param name="value_only"/>
		<xsl:if test="$value_only='false'">
			<xsl:value-of select="../@name"/><xsl:text> BIT DEFAULT </xsl:text>
		</xsl:if>
		<xsl:choose>
			<xsl:when test=". = '1'">
				<xsl:text>-1</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="position() != last()">
			<xsl:text>,
					</xsl:text>
		</xsl:if>
	</xsl:template>
	<!--xsl:template match="fieldset/fields/field/*[name(.)='short_value' or name(.)='long_value' or name(.)='integer_value' or name(.)='vs_scantype_value' or name(.)='vs_szie_unit_value' or name(.)='vs_default_action_value' or name(.)='vs_notify_value' or name(.)='vs_action_value' or name(.)='vs_threat_scan_value' or name(.)='vs_heuristic_scan_level_value' or name(.)='ntf_admin_mail_to_value' or name(.)='ntf_admin_mail_send_value' or name(.)='ntf_admin_mail_send_time_unit_value' or name(.)='ntf_sender_external_value' or name(.)='ntf_recipient_external_value' or name(.)='as_detection_rate_value' or name(.)='as_action_value' or name(.)='cf_ruletype_value' or name(.)='cf_action_value' or name(.)='sm_select_value' or name(.)='sm_show_value' or name(.)='sm_show_type_for_value' or name(.)='admin_ntf_internal_mail_value' or name(.)='alert_duration_unit_value' or name(.)='alert_size_unit_value' or name(.)='bsr_scan_status_value' or name(.)='fb_scantype_value' or name(.)='fb_actiontype_value' or name(.)='fb_notifytype_value' or name(.)='fb_compress_file_scanning_value' or name(.)='mu_location_value' or name(.)='ss_schedule_value' or name(.)='su_schedule_value']"-->
	<xsl:template match="fieldset/fields/field/*[@dt_type='&DEFINE_DT_SHORT;' or @dt_type='&DEFINE_DT_LONG;' or @dt_type='&DEFINE_DT_INTEGER;']">
		<xsl:param name="value_only"/>
		<xsl:if test="$value_only='false'">
			<xsl:value-of select="../@name"/><xsl:text> INTEGER DEFAULT </xsl:text>
		</xsl:if>
		<xsl:value-of select="."/>
		<xsl:if test="position() != last()">
			<xsl:text>,
					</xsl:text>
		</xsl:if>
	</xsl:template>
	<xsl:template match="fieldset/fields/field/*[@dt_type='&DEFINE_DT_DATETIME;']">
		<xsl:param name="value_only"/>
		<xsl:choose>
			<xsl:when test="$value_only='false'">
				<xsl:value-of select="../@name"/><xsl:text> DATETIME </xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
				<!--xsl:variable name="strDateTime" select="."/>
					<xsl:variable name="strDate" select="substring($strDateTime, 1, 10)"/>
					<xsl:variable name="strTime" select="substring($strDateTime, 12, 8)"/>
					<xsl:text>#</xsl:text><xsl:value-of select="$strDate"></xsl:value-of><xsl:text> </xsl:text><xsl:value-of select="$strTime"></xsl:value-of><xsl:text>#</xsl:text-->
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="position() != last()">
			<xsl:text>,
					</xsl:text>
		</xsl:if>
	</xsl:template>
	<xsl:template match="fieldset/fields/field/*[@dt_type='&DEFINE_DT_BINARY;']">
		<xsl:param name="value_only"/>
		<xsl:choose>
			<xsl:when test="$value_only='false'">
				<xsl:value-of select="../@name"/><xsl:text> LONGBINARY </xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>0</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:if test="position() != last()">
			<xsl:text>,
					</xsl:text>
		</xsl:if>
	</xsl:template>
	<xsl:template match="fieldset/fields/field/*[@dt_type='&DEFINE_DT_STRING;']">
		<xsl:param name="value_only"/>
		<xsl:if test="$value_only='false'">
			<xsl:value-of select="../@name"/><xsl:text> NTEXT NOT NULL DEFAULT </xsl:text>
		</xsl:if>
		<xsl:text>"</xsl:text>
		<xsl:value-of select="."/>
		<xsl:text>"</xsl:text>
		<xsl:if test="position() != last()">
			<xsl:text>,
					</xsl:text>
		</xsl:if>
	</xsl:template>
	<!--xsl:template match="fieldset/fields/field/*[name(.)='string256_value']">
		<xsl:param name="value_only"/>
		<xsl:if test="$value_only='false'">
			<xsl:value-of select="../@name"/><xsl:text> TEXT(256) NOT NULL DEFAULT </xsl:text>
		</xsl:if>
		<xsl:text>"</xsl:text>
		<xsl:value-of select="."/>
		<xsl:text>"</xsl:text>
		<xsl:if test="position() != last()">
			<xsl:text>,
					</xsl:text>
		</xsl:if>
	</xsl:template-->
</xsl:stylesheet>
