
# /****************************************************************************
# *
# *    (C) Copyright 1989-2015 Trend Micro, Inc.
# *    All Rights Reserved.
# *
# *    This program is an unpublished copyrighted work which is proprietary
# *    to Trend Micro, Inc. and contains confidential information that is not
# *    to be reproduced or disclosed to any other person or entity without
# *    prior written consent from Trend Micro, Inc. in each and every instance.
# *
# *    WARNING:  Unauthorized reproduction of this program as well as
# *    unauthorized preparation of derivative works based upon the
# *    program or distribution of copies by sale, rental, lease or
# *    lending are violations of federal copyright laws and state trade
# *    secret laws, punishable by civil and criminal penalties.
# *
# * ---------------------------------------------------------------------------
# * Title: critical patch/hotfix install script
# * Project: SPLX 3.0
# * Revision: 
# * Author: 
# * Date: 
# * Description: 
# * Log: 
# *
# ***************************************************************************** 

echo "Check system ......"

is_32bit=-1
uname_i=`uname -m`
arch=""
platform=""
if [ "${uname_i}" = "i686" -o "${uname_i}" = "i386" -o "${uname_i}" = "i586" ]; then
    is_32bit=1
    arch="i686"
else
    is_32bit=0
    arch="x86_64"
fi

key_bin="/sbin/yast"
is_suse=1

if [ -f ${key_bin} ]; then
    is_suse=1
    platform="SuSE"
else
    is_suse=0
fi

is_splx_64=0
suse_release="/etc/SuSE-release"
if [ $is_suse -eq 1 ]; then
	query_is_suse12=`cat $suse_release | grep SUSE`
	ret_suse12="$?"
	if [ $ret_suse12 -eq 0 ]; then
		suse12_release=$(awk '(NR > 0) && ($5 == 12) { print $5 }' $suse_release)
		if [ $suse12_release ]; then
			is_splx_64=1
			platform="ALL"
		fi
	fi
	is_splx_64=1
fi

is_centOS6=0
is_platformRH6=0
rhel_release="/etc/redhat-release"
if [ $is_suse -ne 1 -a $is_splx_64 -ne 1 ]; then
    query_is_centOS=`cat $rhel_release | grep CentOS`
    ret_centOS="$?"
    if [ $ret_centOS -eq 0 ]; then
	centos_release=$(awk '(NR > 0) && ($4 >= 7) { print $4 }' $rhel_release)
	centos_release_2=$(awk '(NR > 0) && ($3 >= 7) { print $3 }' $rhel_release)
	if [ $centos_release ] || [ $centos_release_2 ] ; then
            is_splx_64=1
            platform="ALL"
	fi
	if [ $is_splx_64 -eq 0 ]; then
	    centos_release=$(awk '(NR > 0) && ($4 >= 6) && ($4 < 7) { print $4 }' $rhel_release)
	    centos_release_2=$(awk '(NR > 0) && ($3 >= 6) && ($3 < 7) { print $3 }' $rhel_release)
	    if [ $centos_release ] || [ $centos_release_2 ] ; then
		is_centOS6=1
		platform="RedHat6"
		is_platformRH6=1
	    fi
        fi
    fi
fi

if [ $is_suse -ne 1 -a $is_centOS6 -ne 1 -a $is_splx_64 -ne 1 ]; then
	release=$(awk '(NR > 0) && ($7 >= 7) { print $7 }' $rhel_release)
	if [ $release ]; then
        platform="ALL"
		is_splx_64=1
    fi
	if [ $is_splx_64 -eq 0 ]; then
		release=$(awk '(NR > 0) && ($7 >= 6) && ($7 < 7) { print $7 }' $rhel_release)
		if [ $release ]; then
			platform="RedHat6"
			is_platformRH6=1
		else
			platform="RedHat"
		fi
    fi
fi

echo "Starting to install package. Please wait."

# check if this script is run by root
if [ $UID -ne 0 ] ; then
    echo "You must be logged in as root to run this script."
    exit 1
fi

# check if initial SProtectLinux is installed
query_splx=`rpm -q SProtectLinux-3.0`
is_splx_existed=$?

if [ $is_splx_existed -ne 0 ] ; then
    echo "Please install ServerProtect for Linux 3.0 before installing this package."
    exit 1
else
    echo "The current installation of ServerProtect on your system is $query_splx."
fi

query_splx_p7=`rpm -q splx-3.0-sp1-patch7`
is_splx_p7_existed=$?
if [ $is_splx_p7_existed -ne 0 ] ; then
    echo "Please install SPLX 3.0 Patch7 for sp1 before installing this package."
    exit 1
fi

BuildNumber=1541
Postfix=cp

F_ini_set() {
    INI_F="$1"
    INI_SECTION="$2"
    INI_KEY="$3"
    INI_VALUE="$4"
    TMP_F=/tmp/temp$$

    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
    return 1
    fi

    RANGE_START="/\[${INI_SECTION}\]/"
    RANGE_END="/\\[.*\]/"

    MY_SEDCMD="${RANGE_START},${RANGE_END}s?^[ \t]*${INI_KEY}=.*?${INI_KEY}=${INI_VALUE}?"
    sed -e "${MY_SEDCMD}" ${INI_F} > ${TMP_F}
    cp -f ${TMP_F} ${INI_F}
    rm -f ${TMP_F}
}

F_ini_get()
{
    INI_F="$1"
    INI_SECTION="$2"
    INI_KEY="$3"
    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
        return 1
    fi

    RANGE_START="/^\[${INI_SECTION}\]/"
    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
        return 1
    fi

    RANGE_START="/^\[${INI_SECTION}\]/"
    RANGE_END="/^\[.*\]/"

    MY_SEDCMD_1="${RANGE_START},${RANGE_END}p"
    MY_SEDCMD_2="/^[\t ]*${INI_KEY}=/p"

    _R=`sed -n -e "${MY_SEDCMD_1}" ${INI_F} | sed -n -e "${MY_SEDCMD_2}" | awk -F= '{ printf $2 }'`
    printf "%s" "$_R"
    if [ -z "$_R" ] ; then
        return 1
    else
        return 0
    fi
}

File="/opt/TrendMicro/SProtectLinux/Patch.ini"
if [ -f $File ]; then
    BuildNo=`F_ini_get $File "CurrentVersion" "BuildNumber"`
    if [ "${BuildNo}" -eq "${BuildNumber}" ]; then
	echo "Package has been installed. Install process exits."
	exit 1
    fi
fi

# Stop SPLX   
echo "Stopping splx ......"
/etc/init.d/splx stop

#---------------------
bak_path=/opt/TrendMicro/SProtectLinux/backup/$Postfix$BuildNumber

if [ -d $bak_path ]; then
    rm -rf $bak_path/*
else
    mkdir -p $bak_path
fi   

if [ -f /opt/TrendMicro/SProtectLinux/tmsplx.xml ] ; then
    cp -f /opt/TrendMicro/SProtectLinux/tmsplx.xml $bak_path
fi

DefaultDirToMoveWhiteList="/opt/TrendMicro/SProtectLinux/SPLX.Quarantine"
DefaultDirToSaveWhiteList="/opt/TrendMicro/SProtectLinux/SPLX.Backup"

preDirToMoveValue=$(grep DirToMove /opt/TrendMicro/SProtectLinux/tmsplx.xml | grep -v '<--'  | awk -F= '{print $NF}' | awk -F\" '{print $2}')
preDirToSaveValue=$(grep DirToSave /opt/TrendMicro/SProtectLinux/tmsplx.xml | grep -v '<--'  | awk -F= '{print $NF}' | awk -F\" '{print $2}')

DirToSaveStr=$(grep DirToSave /opt/TrendMicro/SProtectLinux/tmsplx.xml | grep -v '<--')

if [ "${DefaultDirToMoveWhiteList}" != "${preDirToMoveValue}" ]; then
	DefaultDirToMoveWhiteList="${DefaultDirToMoveWhiteList}:$preDirToMoveValue"
fi

if [ "${DefaultDirToSaveWhiteList}" != "${preDirToSaveValue}" ]; then
	DefaultDirToSaveWhiteList="${DefaultDirToSaveWhiteList}:$preDirToSaveValue"
fi

DirToMoveWhiteList="   <P Name=\"MoveToWhiteList\" Value=\"$DefaultDirToMoveWhiteList\"/>"
DirToSaveWhiteList="   <P Name=\"SaveToWhiteList\" Value=\"$DefaultDirToSaveWhiteList\"/>"

grep "SaveToWhiteList" /opt/TrendMicro/SProtectLinux/tmsplx.xml > /dev/null

if [ $? -ne 0 ]; then
	sed -i "/DirToSave/a\ $DirToMoveWhiteList\n $DirToSaveWhiteList" /opt/TrendMicro/SProtectLinux/tmsplx.xml > /dev/null
fi

DefaultSource="https://splx3-p.activeupdate.trendmicro.com/activeupdate"
SourceValue=$(grep 'Name="Source"' /opt/TrendMicro/SProtectLinux/tmsplx.xml | grep -v '<--'  | awk -F= '{print $NF}' | awk -F\" '{print $2}')
DefaultSourceValue=$(grep 'Name="DefaultSource"' /opt/TrendMicro/SProtectLinux/tmsplx.xml | grep -v '<--'  | awk -F= '{print $NF}' | awk -F\" '{print $2}' | grep 'TVCSDownload')

if [ "${DefaultSourceValue}" == "" ]; then
	sed -i "/DefaultSource/c\\    <P Name=\"DefaultSource\" Value=\"${DefaultSource}\"/>" /opt/TrendMicro/SProtectLinux/tmsplx.xml > /dev/null
fi

if [ "${SourceValue}" == "" -a "${DefaultSourceValue}" == "" ]; then
	sed -i "/DigSig/c\\    <P Name=\"DigSig\" Value=\"1\"/>" /opt/TrendMicro/SProtectLinux/tmsplx.xml > /dev/null
	sed -i "/SrvAuth/c\\    <P Name=\"SrvAuth\" Value=\"1\"/>" /opt/TrendMicro/SProtectLinux/tmsplx.xml > /dev/null
fi

#Copy files starts
if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi $bak_path/$file_name
fi

cp -f ./$platform/$arch/log_management.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi $bak_path/$file_name
fi

cp -f ./$platform/$arch/proption.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi $bak_path/$file_name
fi

cp -f ./$platform/$arch/scanoption_set.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi $bak_path/$file_name
fi

cp -f ./$platform/$arch/showpage.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi $bak_path/$file_name
fi

cp -f ./$platform/$arch/tmcm_sso.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi $bak_path/$file_name
fi

cp -f ./$platform/$arch/cmoption.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi $bak_path/$file_name
fi

cp -f ./$platform/$arch/login_and_register.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi $bak_path/$file_name
fi

cp -f ./$platform/$arch/scanoption.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi $bak_path/$file_name
fi

cp -f ./$platform/$arch/srv_admin.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi $bak_path/$file_name
fi

cp -f ./$platform/$arch/viewlog.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi $bak_path/$file_name
fi

cp -f ./$platform/$arch/notification.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi $bak_path/$file_name
fi

cp -f ./$platform/$arch/summary.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig $bak_path/$file_name
fi

cp -f ./$platform/$arch/CMconfig /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool $bak_path/$file_name
fi

cp -f ./$platform/$arch/DiagnosticTool /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.util/xmlvalidator ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/xmlvalidator)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.util/xmlvalidator $bak_path/$file_name
fi

cp -f ./$platform/$arch/xmlvalidator /opt/TrendMicro/SProtectLinux/SPLX.util/xmlvalidator


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity $bak_path/$file_name
fi

cp -f ./$platform/$arch/entity /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp $bak_path/$file_name
fi

cp -f ./$platform/$arch/vsapiapp /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain $bak_path/$file_name
fi

cp -f ./$platform/$arch/splxmain /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd $bak_path/$file_name
fi

cp -f ./$platform/$arch/splxhttpd /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/conf/splxhttpd.conf ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/conf/splxhttpd.conf)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/conf/splxhttpd.conf $bak_path/$file_name
fi

cp -f ./$platform/$arch/splxhttpd.conf /opt/TrendMicro/SProtectLinux/SPLX.httpd/conf/splxhttpd.conf


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/help/Specifying_the_Download_Source.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/help/Specifying_the_Download_Source.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/help/Specifying_the_Download_Source.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/Specifying_the_Download_Source.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/help/Specifying_the_Download_Source.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/summary.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/summary.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/summary.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/summary.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/summary.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/backup_directory.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/backup_directory.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/backup_directory.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/backup_directory.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/backup_directory.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_no_reg.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_no_reg.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_no_reg.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/cmsettings_no_reg.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_no_reg.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_reged.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_reged.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_reged.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/cmsettings_reged.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_reged.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/password.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/password.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/password.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/password.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/password.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/pr_activate.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate_rej.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate_rej.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate_rej.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/pr_activate_rej.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate_rej.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_end.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_end.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_end.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/pr_licenseinfo_full_ac_end.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_end.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/pr_licenseinfo_full_ac.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_progress.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_progress.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_progress.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/pr_licenseinfo_full_ac_progress.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_progress.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_no_ac.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_no_ac.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_no_ac.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/pr_licenseinfo_no_ac.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_no_ac.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/proxy_settings.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings_update.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings_update.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings_update.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/proxy_settings_update.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings_update.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/quarantine_directory.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/quarantine_directory.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/quarantine_directory.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/quarantine_directory.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/quarantine_directory.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/registration.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/registration.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/registration.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/registration.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/registration.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/exclusion_manual.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual_response.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual_response.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual_response.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/exclusion_manual_response.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual_response.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/exclusion_real.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real_response.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real_response.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real_response.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/exclusion_real_response.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real_response.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/exclusion_scheduled.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled_response.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled_response.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled_response.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/exclusion_scheduled_response.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled_response.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/javascript/script_splx.js ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/javascript/script_splx.js)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/javascript/script_splx.js $bak_path/$file_name
fi

cp -f ./$platform/$arch/script_splx.js /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/javascript/script_splx.js


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/log_directory.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/log_directory.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/log_directory.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/log_directory.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/log_directory.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/logs_on_disk.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/logs_on_disk.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/logs_on_disk.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/logs_on_disk.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/logs_on_disk.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/purge_now.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/purge_now.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/purge_now.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/purge_now.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/purge_now.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/scan_logs.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/scan_logs.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/scan_logs.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/scan_logs.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/scan_logs.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/spyware_logs.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/spyware_logs.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/spyware_logs.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/spyware_logs.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/spyware_logs.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/system_logs.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/system_logs.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/system_logs.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/system_logs.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/system_logs.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/virus_logs.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/virus_logs.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/virus_logs.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/virus_logs.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/virus_logs.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Alerts.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Alerts.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Alerts.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/Alerts.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Alerts.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Recipients.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Recipients.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Recipients.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/Recipients.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Recipients.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Manual.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Manual.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Manual.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/Manual.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Manual.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Real-time.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Real-time.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Real-time.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/Real-time.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Real-time.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress0.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress0.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress0.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/scan_progress0.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress0.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/scan_progress.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Scheduled.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Scheduled.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Scheduled.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/Scheduled.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Scheduled.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Manual.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Manual.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Manual.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/Update_Manual.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Manual.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Scheduled.htm ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Scheduled.htm)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Scheduled.htm $bak_path/$file_name
fi

cp -f ./$platform/$arch/Update_Scheduled.htm /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Scheduled.htm


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/liblogrdr.so.1 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/liblogrdr.so.1)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/liblogrdr.so.1 $bak_path/$file_name
fi

cp -f ./$platform/$arch/liblogrdr.so.1 /opt/TrendMicro/SProtectLinux/SPLX.lib/liblogrdr.so.1

#Copy files ends

#if any, delete the old backup files
#find /opt/TrendMicro/SProtectLinux -name "*.bak.cp1519"|xargs rm -rf

# Modify BIF interval
if [ -f /etc/init.d/splxcore ]; then
    sed -i "s/$BIF_schedule_command=\"\* \* \* \* 0/$BIF_schedule_command=\"30 2 \* \* 0/g" /etc/init.d/splxcore > /dev/null
fi

if [ ! -f /opt/TrendMicro/SProtectLinux/Patch.ini ]; then
    cp -f ./$platform/$arch/Patch.ini /opt/TrendMicro/SProtectLinux/Patch.ini
	PreBuildNo=`rpm -qa | grep splx | awk -F- '{print $NF}' | awk -F. '{print $1}'`
else
    PreBuildNo=${BuildNo}
fi

RpmVersion=`rpm -qa | grep splx`
#PreBuildNo=`rpm -qa | grep splx | awk -F- '{print $NF}' | awk -F. '{print $1}'`
CurBuildNo=$BuildNumber
Date=`date`

File="/opt/TrendMicro/SProtectLinux/Patch.ini"

F_ini_set $File "General" "UpdateTime" "$Date"
F_ini_set $File "PreviousVersion" "BuildNumber" "$PreBuildNo"
F_ini_set $File "CurrentVersion" "BuildNumber" "$CurBuildNo"


ldconfig
# Start SPLX
echo "Starting splx ......"
/etc/init.d/splx start
echo "Successfully install package."
