
# /****************************************************************************
# *
# *    (C) Copyright 1989-2015 Trend Micro, Inc.
# *    All Rights Reserved.
# *
# *    This program is an unpublished copyrighted work which is proprietary
# *    to Trend Micro, Inc. and contains confidential information that is not
# *    to be reproduced or disclosed to any other person or entity without
# *    prior written consent from Trend Micro, Inc. in each and every instance.
# *
# *    WARNING:  Unauthorized reproduction of this program as well as
# *    unauthorized preparation of derivative works based upon the
# *    program or distribution of copies by sale, rental, lease or
# *    lending are violations of federal copyright laws and state trade
# *    secret laws, punishable by civil and criminal penalties.
# *
# * ---------------------------------------------------------------------------
# * Title: critical patch/hotfix rollback script
# * Project: SPLX 3.0
# * Revision: 
# * Author: 
# * Date: 
# * Description: 
# * Log: 
# *
# ***************************************************************************** 
F_ini_set() {
    INI_F="$1"
    INI_SECTION="$2"
    INI_KEY="$3"
    INI_VALUE="$4"
    TMP_F=/tmp/temp$$

    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
    return 1
    fi

    RANGE_START="/\[${INI_SECTION}\]/"
    RANGE_END="/\\[.*\]/"

    MY_SEDCMD="${RANGE_START},${RANGE_END}s?^[ \t]*${INI_KEY}=.*?${INI_KEY}=${INI_VALUE}?"
    sed -e "${MY_SEDCMD}" ${INI_F} > ${TMP_F}
    cp -f ${TMP_F} ${INI_F}
    rm -f ${TMP_F}
}


F_ini_get()
{
    INI_F="$1"
    INI_SECTION="$2"
    INI_KEY="$3"
    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
        return 1
    fi

    RANGE_START="/^\[${INI_SECTION}\]/"
    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
        return 1
    fi

    RANGE_START="/^\[${INI_SECTION}\]/"
    RANGE_END="/^\[.*\]/"

    MY_SEDCMD_1="${RANGE_START},${RANGE_END}p"
    MY_SEDCMD_2="/^[\t ]*${INI_KEY}=/p"

    _R=`sed -n -e "${MY_SEDCMD_1}" ${INI_F} | sed -n -e "${MY_SEDCMD_2}" | awk -F= '{ printf $2 }'`
    printf "%s" "$_R"
    if [ -z "$_R" ] ; then
        return 1
    else
        return 0
    fi
}

BuildNumber=1541
Postfix=cp

File="/opt/TrendMicro/SProtectLinux/Patch.ini"

if [ -f $File ]; then
    CurBuildNo=`F_ini_get $File "CurrentVersion" "BuildNumber"`
    if [ "${BuildNumber}" -ne "${CurBuildNo}" ]; then
        echo "Package was not installed. Rollback process exits."
        exit 1
    fi
else
    echo "Package was not installed. Rollback process exits."
    exit 1
fi

echo "Starting to rollback package. Please wait."
#Stop splx
echo "Stopping splx ......"
/etc/init.d/splx stop

preBuildNo=`F_ini_get $File "PreviousVersion" "BuildNumber"`
Date=`date`

F_ini_set $File "General" "UpdateTime" "$Date"
F_ini_set $File "PreviousVersion" "BuildNumber" "$CurBuildNo"
F_ini_set $File "CurrentVersion" "BuildNumber" "$preBuildNo"

bak_path=/opt/TrendMicro/SProtectLinux/backup/$Postfix$BuildNumber

file_name=$(basename /opt/TrendMicro/SProtectLinux/tmsplx.xml)

if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/tmsplx.xml ]; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/tmsplx.xml
fi

#Copy files starts
file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/xmlvalidator)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.util/xmlvalidator ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.util/xmlvalidator
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/conf/splxhttpd.conf)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/conf/splxhttpd.conf ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.httpd/conf/splxhttpd.conf
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/help/Specifying_the_Download_Source.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/help/Specifying_the_Download_Source.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/help/Specifying_the_Download_Source.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/summary.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/summary.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/summary.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/backup_directory.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/backup_directory.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/backup_directory.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_no_reg.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_no_reg.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_no_reg.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_reged.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_reged.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/cmsettings_reged.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/password.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/password.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/password.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate_rej.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate_rej.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_activate_rej.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_end.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_end.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_end.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_progress.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_progress.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_full_ac_progress.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_no_ac.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_no_ac.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/pr_licenseinfo_no_ac.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings_update.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings_update.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/proxy_settings_update.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/quarantine_directory.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/quarantine_directory.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/quarantine_directory.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/registration.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/registration.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Administration/registration.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual_response.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual_response.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_manual_response.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real_response.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real_response.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_real_response.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled_response.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled_response.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ExclusionList/exclusion_scheduled_response.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/javascript/script_splx.js)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/javascript/script_splx.js ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/javascript/script_splx.js
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/log_directory.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/log_directory.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/log_directory.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/logs_on_disk.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/logs_on_disk.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/logs_on_disk.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/purge_now.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/purge_now.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogMgt/purge_now.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/scan_logs.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/scan_logs.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/scan_logs.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/spyware_logs.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/spyware_logs.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/spyware_logs.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/system_logs.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/system_logs.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/system_logs.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/virus_logs.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/virus_logs.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/LogQuery/virus_logs.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Alerts.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Alerts.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Alerts.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Recipients.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Recipients.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Notification/Recipients.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Manual.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Manual.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Manual.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Real-time.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Real-time.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Real-time.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress0.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress0.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress0.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/scan_progress.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Scheduled.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Scheduled.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/ScanOptions/Scheduled.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Manual.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Manual.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Manual.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Scheduled.htm)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Scheduled.htm ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/html/Update/Update_Scheduled.htm
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/liblogrdr.so.1)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/liblogrdr.so.1 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/liblogrdr.so.1
fi

#Copy files ends

ldconfig
# Start SPLX
echo "Starting splx ......"
/etc/init.d/splx start
echo "Successfully rollback package."
