#!/usr/bin/perl
#
# chkconfig: 345 99 01
# description: Starts and stops the SPLX daemons used to provide SPLX services.
#
# /etc/init.d/splx
#
### BEGIN INIT INFO
# Provides: splx
# Required-Start:
# X-UnitedLinux-Should-Start:
# Required-Stop:
# X-UnitedLinux-Should-Stop:
# Default-Start: 3 4 5
# Default-Stop:
# Short-Description: ServerProtect for Linux
# Description: Starts and stops the SPLX daemons used to provide SPLX services.
### END INIT INFO

use utf8;

use Sys::Syslog qw(:DEFAULT setlogsock);
use POSIX qw(strftime);

# define variables

$uid=$<;

$debuglevel=0;
$MODULE_NAME="splx_service";

#$tmi_cfg_file="/opt/TrendMicro/TMI/TMI.cfg";

$ld_so_conf_file="/etc/ld.so.conf";

$product_root="/opt/TrendMicro/SProtectLinux";

$splx_log_file="$product_root/SPLX.tmp/splx.log";

$tmsplx_xml_file="$product_root/tmsplx.xml";

$httpd_pid_file="$product_root/SPLX.httpd/logs/splxhttpd.pid";

$core_svc_start="/etc/init.d/splxcore start";

$core_svc_stop="/etc/init.d/splxcore stop";

$core_svc_status="/etc/init.d/splxcore status";

$httpd_svc_start="/etc/init.d/splxhttpd start";

$httpd_svc_stop="/etc/init.d/splxhttpd stop";

$httpd_svc_status="/etc/init.d/splxhttpd status";

$splxmain="$product_root/SPLX.vsapiapp/splxmain";

$CMconfig="$product_root/SPLX.util/CMconfig";

$virus_catch_monitor="$product_root/SPLX.vsapiapp/virus_catch_monitor";
$kcheckrunning="/usr/bin/kcheckrunning";

$expire_message="This evaluation version has expired. To purchase a valid license, contact Trend Micro sales or an authorized distributor.\n";

$CMconfig_message="ServerProtect for Linux Control Manager agent is currently registered to Trend Micro Control Manager server...\n";

# define commands

if( -e "/sbin/pidof" )
{
	$pidof="/sbin/pidof";
}elsif ( -e "/bin/pidof")
{
	$pidof="/bin/pidof";
}elsif ( -e "/usr/bin/pidof")
{
	$pidof="/usr/bin/pidof";
}elsif ( -e "/usr/sbin/pidof")
{
	$pidof="/usr/sbin/pidof";
}elsif ( -e "/usr/local/bin/pidof")
{
	$pidof="/usr/local/bin/pidof";
}elsif ( -e "/usr/local/sbin/pidof")
{
	$pidof="/usr/local/sbin/pidof";
}else
{
}
$ldconfig="/sbin/ldconfig";

$insmod="/sbin/insmod";

$rmmod="/sbin/rmmod";

$mknod="/bin/mknod";

# reads debug level from configuration file

open TMSPLX_XML, "< $tmsplx_xml_file";
while(<TMSPLX_XML>){
	if(/(Name=\"UserDebugLevel\"\sValue=\"\d\")/){
		@list=split / /, $1;
		foreach $token (@list){
			if($token=~/Value/){
				@sublist=split /=/, $token;
				$debuglevel=eval $sublist[1];
			}
		}
	}
}
close TMSPLX_XML;

# write logs if DEBUG is defined
my $log_file_is_open = 0; #FALSE
sub open_log{
	if (open LOG_FILE, ">> /var/log/messages") {
        binmode(LOG_FILE, ":utf8");
		$log_file_is_open = 1; #TRUE
	}
}

sub write_log{
	my $message=$_[0];

	if ($log_file_is_open) {
		$now_string = strftime "%b %e %H:%M:%S", localtime;
		($hostname, @alias, $ad, $len, @addrs) = gethostbyname('localhost');
		print LOG_FILE $now_string . " " . $hostname . " " . $MODULE_NAME . ": " . $message . "\n";
	}
	return 1;	
}

sub close_log{
	if ($log_file_is_open) {
		close(LOG_FILE);
	}

	return 1;
}

# check if this script is run by root

if (defined($uid) && ($uid!=0)){
	write_log "error: ServerProtect for Linux must be run by root.";
	print "splx must be launched by a root user. Login as root and try again.\n";
	exit 1;
}

# set colors for displaying results

$bootup=$ENV{"BOOTUP"};
$res_col=60;

if (!defined($bootup)) {
	$bootup="color";
}

sub move_to_colon{
	($bootup eq "color") && (print "\033[${res_col}G");
	return 1;
}

sub set_success_color{
	($bootup eq "color") && (print "\033[1;32m");
	return 1;
}

sub set_failure_color{
	($bootup eq "color") && (print "\033[1;31m");
	return 1;
}

sub set_normal_color{
	($bootup eq "color") && (print "\033[0;39m");
	return 1;
}

sub info_success {
    if ( -e "/etc/init.d/functions") {    
        system ("export CONSOLETYPE=vt && . /etc/init.d/functions && \$SETCOLOR_SUCCESS && echo -ne \"" . $_[0] . "\" && \$SETCOLOR_NORMAL");
    }
    else
    {
        set_success_color;
        print $_[0];
        set_normal_color;
    }
}

sub info_failure {
    if ( -e "/etc/init.d/functions") {    
        system ("export CONSOLETYPE=vt && . /etc/init.d/functions && \$SETCOLOR_FAILURE && echo -ne \"" . $_[0] . "\" && \$SETCOLOR_NORMAL");
    }
    else
    {
        set_failure_color;
        print $_[0];
        set_normal_color;
    }
}

# echo success or failure
sub echo_success {
    if (( -e "/etc/init.d/functions") && ($bootup eq "color")){    
        system ("export CONSOLETYPE=vt && . /etc/init.d/functions && \$MOVE_TO_COL && echo -n \"[  \" && \$SETCOLOR_SUCCESS && echo -n \"OK\" && \$SETCOLOR_NORMAL && echo -ne \"  ]\\r\"");
        print "\n"
    }
    else
    {
        ($bootup eq "color") && (&move_to_colon);
        print "[  ";
        
        ($bootup eq "color") && (&set_success_color);
        print "OK";
        
        ($bootup eq "color") && (&set_normal_color);
        print "  ]\n";
        
    }
}

sub echo_failure {
    if ((-e "/etc/init.d/functions") && ($bootup eq "color")){
        system ("export CONSOLETYPE=vt && . /etc/init.d/functions && \$MOVE_TO_COL && echo -n \"[\" && \$SETCOLOR_FAILURE && echo -n \"FAILED\" && \$SETCOLOR_NORMAL && echo -ne \"]\\r\"");
        print "\n";
    }
    else
    {
        ($bootup eq "color") && (&move_to_colon);
        print "[";
        
        ($bootup eq "color") && (&set_failure_color);
        print "FAILED";
        
        ($bootup eq "color") && (&set_normal_color);
        print "]\n";
    }
}

# check status of a program

sub is_running{
	my %property=(
		"running" => 0,
		"pid" => ""
	);
	my $program=$_[0];
	my @pid_list;
	my $pid;
	SWITCH:{
		# splxmod
		($program eq "splxmod") && do {
			open MODULES, "< /proc/modules";
			while(<MODULES>){
				if(/splxmod/){
					$property{'running'}=1;
				}
			}
			close MODULES;
			return %property;
			last SWITCH;
		};

		# default
		open PID_OF, "$pidof $program |" or return %property;
		while(<PID_OF>){
			@pid_list=split /\s/, $_;
		}
		close PID_OF;
		foreach $pid (@pid_list){
			if(kill 0, $pid){
				if($property{"pid"} eq ""){
					$property{"pid"}=$pid;
				}
				else{
					$property{"pid"}.=" $pid";
				}
			}
		}
		if($property{"pid"} ne ""){
			$property{"running"}=1;
			return %property;
		}
		else{
			$property{"running"}=0;
			return %property;
		}
	}
}

# show status of programs

sub show_status{
	my $program=$_[0];
	my $running=0;
	my %property=(
			"running" => 0,
			"pid" => ""
			);

	SWITCH:{
		($program eq "splxmod") && do {
			%property = is_running "splxmod";
			if($property{"running"}==1){
				print "$program module is running...\n";
				return 0;
			}
			if( -e "/var/lock/subsys/splxmod"){
				print "$program module has been loaded but is not running...\n";
				return 1;
			}
			else{
				print "$program module is stopped\n";
				return 1;
			}
			last SWITCH;
		};
		($program eq "entity") && do {
			%property = is_running "entity";
			if($property{"running"}==1){
				print "$program (pid ".$property{"pid"}.") is running...\n";
				return 0;
			}
			if(-e "/var/run/entity.pid"){
				open PID_FILE, "< /var/run/entity.pid";
				while(<PID_FILE>){
					chomp;
					if($_ ne ""){
						print "$program dead but pid file exists\n";
						return 1;
					}
					close PID_FILE;
				}
			}
			if( -e "/var/lock/subsys/entity.pid"){
				print "$program dead but subsys locked\n";
				return 1;
			}
			else{
				print "$program is stopped\n";
				return 1;
			}
			last SWITCH;
		};
		%property = is_running $program;
		if($property{"running"}==1){
			print "$program (pid ".$property{"pid"}.") is running...\n";
			return 0;
		}
		if(-e "/var/run/$program.pid"){
			open PID_FILE, "< /var/run/$program.pid";
			while(<PID_FILE>){
				print "$program dead but pid file exists\n";
				close PID_FILE;
				return 1;
			}
		}
		if(-e "/var/lock/subsys/$program"){
			print "$program dead but subsys locked\n";
			return 1;
		}
		else{
			print "$program is stopped\n";
			return 1;
		}
	}
}

# update library paths for execution

sub update_library_path{

	my $reload=0;
	my $libPathExisted=0;

	# check if SPLX.lib and SPLX.lib/agent is in so.conf file
	open LD_SO_CONF_FILE, "< $ld_so_conf_file";
	
	while($line=<LD_SO_CONF_FILE>){
	        if(!$libPathExisted && $line eq $product_root."\/SPLX.lib\n"){
	                $libPathExisted=1;
	        }

	}

	close LD_SO_CONF_FILE;

	# add SPLX.lib into so.conf file if it is not in it
	if($libPathExisted==0)
	{
		open LD_SO_CONF_FILE, ">> $ld_so_conf_file";
		print LD_SO_CONF_FILE "$product_root/SPLX.lib\n";
		$reload=1;
		close LD_SO_CONF_FILE;
	}


	
	if($reload==1){
		system "$ldconfig";
	}

	my $ld_library_path=$ENV{'LD_LIBRARY_PATH'};
	if(defined($ld_library_path)){
		if(!($ld_library_path=~/"$product_root\/SPLX.lib"/)){
			if(length($ld_library_path)==0){
				$ld_library_path="$product_root/SPLX.lib";
			}
			else{
				$ld_library_path="$ld_library_path:$product_root/SPLX.lib";
			}
		}
	}

	return 1;
}

# kill process

sub kill_proc{
	my $program=$_[0];
	my @pid_list;
	my $i;
	my $return_value=0;
	open PID_OF, "$pidof $program |" or return 0;
	while(<PID_OF>){
		@pid_list=split /\s/, $_;
	}
	close PID_OF;
	$i= scalar(@pid_list)-1;
	$return_value+=kill 15, $pid_list[ $i ];
	if($return_value){
		return 1;
	}
	else{
		return 0;
	}
}

# touch file

sub touch{
	my $filename=$_[0];
	if(-e $_[0]){
		open TEMP, $filename;
		close TEMP;
	}
	else{
		open TEMP, "> $filename";
		close TEMP;
	}
}

# main program

if($debuglevel!=0){
	open_log;
}
else
{
	if( -z "$product_root/tmsplx.xml" )
	{
		open_log;		
	}	
}
SWITCH:{
	(!defined($ARGV[0])) && do{
		print "The splx command line contains an invalid option.\n";
		print "Valid syntax is: '$0 {start|stop|restart|status}'.\n";
		print "Enter the correct splx command and try again.\n";
		exit 1;
	};
	($ARGV[0] eq "start") && do {
		my $START_core=0;
		my $START_splxhttpd=0;
		print "Starting ServerProtect for Linux: \n";
		write_log "Starting ServerProtect for Linux:";


		# check splx configuration file
		print "Checking configuration file: ";
		write_log "step: checking configuration file.";
		
		if( -z "$product_root/tmsplx.xml" )
		{
			write_log "The configuration file content is empty and SPLX will use the backup configuration file.";
			if( -e "$product_root/tmsplx.xml.bak" )
			{
				if( -z "$product_root/tmsplx.xml.bak" )
					{
						write_log "The backup configuration file content is empty.";					
						echo_failure;
						exit 1					
					}
				#copy backup configuration file	
				if ((system "cp -rf $product_root/tmsplx.xml.bak $product_root/tmsplx.xml") == 0) {
						write_log "Backup configuration file copy successful.";					
				} else {
						write_log "Backup configuration file copy unsuccessful.";					
						echo_failure;
						exit 1	
				}						
			}
			else
			{
					write_log "The backup configuration file does not exist.";					
					echo_failure;
					exit 1				
			}
		}
		if ((system "$product_root/SPLX.util/xmlvalidator") == 0) {
			write_log "step: checking configuration file done.";
			echo_success;
		} else {
			write_log "error: detected configuration file error.";
			echo_failure;
			exit 1
		}


		#update pattern version in tmsplx.xml
		system "$splxmain -U > /dev/null 2>&1";
        
		# start splxcore
		print "Starting splxcore:\n";
		write_log "step: starting splxcore service.";
             
		if((system "$core_svc_start")==0){
			write_log "step: splxcore service started.";
			echo_success;
		} else {
			write_log "error: splxcore service can't be started.";
			echo_failure;
			$START_core=1;
		}

		# start httpd
		print "Starting splxhttpd:\n";
		write_log "step: starting splxhttpd service.";
		if((system "$httpd_svc_start")==0){
			write_log "step: splxhttpd service started.";
			echo_success;
		} else {
			write_log "error: splxhttpd service can't be started.";
			echo_failure;
			$START_splxhttpd=1;
		}

		$START=$START_core+$START_splxhttpd;
		if($START==0){
			touch "/var/lock/subsys/splx";
            info_success("ServerProtect for Linux started.\n");
			write_log "ServerProtect for Linux started.";
		}
		else{
			info_failure( "Some errors were found while starting splx. See the system log for error description. The default system log file path is /var/log/messages .\n");
			write_log "ServerProtect for Linux started with errors.";
			exit 1;
		}
						
		# check product expiration and prompt to notice the product is expired
		$expire_ret=system "$splxmain -E > /dev/null 2>&1";
		$expire_ret >>= 8;
		if ($expire_ret == 1)
		{
			info_failure( "\nServerProtect has not been activated.\n");
			info_failure( "You must activate your product to enable scanning and security updates.\n");
		}
		elsif ($expire_ret == 2)
		{
			info_failure( "\nThe product has expired.\n");
			info_failure( "You must purchase a full version license and activate your product to keep your security and product updates current.\n");
		}
		elsif ($expire_ret == 3)
		{
			info_failure( "\nThe product has expired.\n");
			info_failure( "You may purchase a new activation Code or renew your current license to keep your security and product updates current.\n");
		}
		
		last SWITCH;
	};
	($ARGV[0] eq "stop") && do {
		my $STOP_splxcore=0;
		my $STOP_splxhttpd=0;
		my $no_splxcore=0;
		my $no_splxhttpd=0;

		print "Shutting down ServerProtect for Linux:\n";
		write_log "Shutting down ServerProtect for Linux: ";

		# stop splxcore
		print "Shutting down splxcore:\n";
		write_log "step: shutting down splxcore service.";
		
		$stop_core=system "$core_svc_stop";
		if($stop_core==0){
			write_log "success: splxcore service stopped.";
			echo_success;
			$STOP_splxcore=0;
		}
		elsif($stop_core==512)
		{
			write_log "warning: splxcore service not running.";
			echo_failure;
			$STOP_splxcore=0;
			$no_splxcore=1;
		}
		else{
			write_log "error: splxcore service can't be stopped.";
			echo_failure;
			$STOP_splxcore=1;
		}

		# stop splxhttpd
		print "Shutting down splxhttpd:\n";
		write_log "step: shutting down splxhttpd service.";
		$stop_httpd=system "$httpd_svc_stop";
		if($stop_httpd==0){
			write_log "success: splxhttpd service stopped.";
			echo_success;
			$STOP_splxhttpd=0;
		}
		elsif($stop_httpd==512)
		{
			write_log "warning: splxhttpd service not running.";
			echo_failure;
			$STOP_splxhttpd=0;
			$no_splxhttpd=1;
		}
		else{
			write_log "error: splxhttpd service can't be stopped.";
			echo_failure;
			$STOP_splxhttpd=1;
		}

		$STOP=$STOP_splxcore+$STOP_splxhttpd;
		$no_splx=$no_splxcore+$no_splxhttpd;
		if($STOP==0){
			if($no_splx==2)
			{
				info_failure( "ServerProtect for Linux not running.\n");
				unlink "/var/lock/subsys/splx";
				write_log "ServerProtect for Linux not running.";
				exit 0;
			}
			
			info_success( "ServerProtect for Linux stopped normally.\n");
			unlink "/var/lock/subsys/splx";
			write_log "ServerProtect for Linux stopped.";
			exit 0;
		}
		else{
			info_failure( "Some errors were found while stopping splx. See the system log for error description. The default system log file path is /var/log/messages.\n");
			write_log "ServerProtect for Linux stopped with errors.";
			exit 1;
		}

		last SWITCH;
	};
	($ARGV[0] eq "restart") && do {
		system "$0 stop";
		system "$0 start";
		last SWITCH;
	};
	($ARGV[0] eq "status") && do {
		my $STATUS_splxcore=0;
		my $STATUS_splxhttpd=0;
		$STATUS_splxcore=system "$core_svc_status";
		if ($STATUS_splxcore == 0){
			info_success( "ServerProtect for Linux core is running...\n");
		}
		else{
			info_failure ("ServerProtect for Linux core is stopped\n");
		}
		$STATUS_splxhttpd=system "$httpd_svc_status";
		if ($STATUS_splxhttpd == 0){
			info_success ("ServerProtect for Linux httpd is running...\n");
		}
		else{
			info_failure( "ServerProtect for Linux httpd is stopped\n");
		}
		# check scanning status
		$STATUS_manual_scan = `pidof splx_manual_scan 2>&1`;
		if ($STATUS_manual_scan == 0)
		{
			info_failure( "ServerProtect for Linux manual scan is stopped\n");
		}
		else{
			print "splx_manual_scan (pid ";
			chop($STATUS_manual_scan);
			print $STATUS_manual_scan;
			print ") is running...\n";
			info_success( "ServerProtect for Linux manual scan is running...\n");
		}
		$STATUS_schedule_scan = `pidof splx_schedule_s 2>&1`;
		if ($STATUS_schedule_scan == 0)
		{
			info_failure( "ServerProtect for Linux scheduled scan is stopped\n");
		}
		else{
			print "splx_schedule_s (pid ";
			chop($STATUS_schedule_scan);
			print $STATUS_schedule_scan;
			print ") is running...\n";
			info_success( "ServerProtect for Linux scheduled scan is running...\n");
		}
		
		# check CM agent connection
		$CMconfig_ret = `$CMconfig -Q 2>&1`;
		if ($CMconfig_ret eq $CMconfig_message)
		{
			info_success( "ServerProtect for Linux Control Manager agent is currently registered to Trend Micro Control Manager server...\n");
		}
		else
		{
			info_failure( "ServerProtect for Linux Control Manager agent is not registered to Trend Micro Control Manager server\n");
		}
										
										
		$STATUS=$STATUS_splxcore+$STATUS_splxhttpd;
		if($STATUS==0){
			exit 0;
		}
		else{
			exit 1;
		}
		last SWITCH;
	};
	print "The splx command line contains an invalid option.\n";
	print "Valid syntax is: '$0 {start|stop|restart|status}'.\n";
	print "Enter the correct splx command and try again.\n";
}

if($debuglevel!=0){
	close_log;
}

exit 0;
