
# /****************************************************************************
# *
# *    (C) Copyright 1989-2015 Trend Micro, Inc.
# *    All Rights Reserved.
# *
# *    This program is an unpublished copyrighted work which is proprietary
# *    to Trend Micro, Inc. and contains confidential information that is not
# *    to be reproduced or disclosed to any other person or entity without
# *    prior written consent from Trend Micro, Inc. in each and every instance.
# *
# *    WARNING:  Unauthorized reproduction of this program as well as
# *    unauthorized preparation of derivative works based upon the
# *    program or distribution of copies by sale, rental, lease or
# *    lending are violations of federal copyright laws and state trade
# *    secret laws, punishable by civil and criminal penalties.
# *
# * ---------------------------------------------------------------------------
# * Title: critical patch/hotfix install script
# * Project: SPLX 3.0
# * Revision: 
# * Author: 
# * Date: 
# * Description: 
# * Log: 
# *
# ***************************************************************************** 

echo "Check system ......"

is_32bit=-1
uname_i=`uname -m`
arch=""
platform=""
if [ "${uname_i}" = "i686" -o "${uname_i}" = "i386" -o "${uname_i}" = "i586" ]; then
    is_32bit=1
    arch="i686"
else
    is_32bit=0
    arch="x86_64"
fi

key_bin="/sbin/yast"
is_suse=1

if [ -f ${key_bin} ]; then
    is_suse=1
    platform="SuSE"
else
    is_suse=0
fi

is_splx_64=0
if [ $is_suse -eq 1 ]; then
	
	if [ -f /etc/os-release ] ; then
		grep -e "SUSE Linux Enterprise Server" -e "SUSE Linux Enterprise Desktop" /etc/os-release > /dev/null 2>&1
		if [ $? = 0 ] ; then
			is_splx_64=1
			platform="ALL"
		else
			suse_release="/etc/SuSE-release"
			query_is_suse12=`cat $suse_release | grep SUSE`
			ret_suse12="$?"
			if [ $ret_suse12 -eq 0 ]; then
				suse12_release=$(awk '(NR > 0) && ($5 == 12) { print $5 }' $suse_release)
				if [ $suse12_release ]; then
					is_splx_64=1
					platform="ALL"
				fi
			fi
		fi
	fi
fi

is_centOS=0
is_platformRH6=0
rhel_release="/etc/redhat-release"
if [ $is_suse -ne 1 ]; then
    query_is_centOS=`cat $rhel_release | grep CentOS`
    ret_centOS="$?"
    if [ $ret_centOS -eq 0 ]; then
		is_centOS=1
		centos_release=$(awk '(NR > 0) && ($4 >= 7) { print $4 }' $rhel_release)
		centos_release_2=$(awk '(NR > 0) && ($3 >= 7) { print $3 }' $rhel_release)
		if [ $centos_release ] || [ $centos_release_2 ] ; then
				is_splx_64=1
				platform="ALL"
		fi
		if [ $is_splx_64 -eq 0 ]; then
			centos_release=$(awk '(NR > 0) && ($4 >= 6) && ($4 < 7) { print $4 }' $rhel_release)
			centos_release_2=$(awk '(NR > 0) && ($3 >= 6) && ($3 < 7) { print $3 }' $rhel_release)
			if [ $centos_release ] || [ $centos_release_2 ] ; then
				platform="RedHat6"
				is_platformRH6=1
			else
				platform="RedHat"
			fi
		fi
    fi
fi

if [ $is_suse -ne 1 -a $is_centOS -ne 1 ]; then
	release=$(awk '(NR > 0) && ($7 >= 7) { print $7 }' $rhel_release)
	
	if [ $release ]; then
        platform="ALL"
		is_splx_64=1
	else
		# for RHEL8 and above, 2020.05.22
		release_2=$(awk '(NR > 0) && ($6 >= 7) { print $6 }' $rhel_release)	
		if [ $release_2 ]; then
			echo $release_2 | sed 's/\.//g' | grep [^0-9] >/dev/null 2>&1
			ret_release_2=$?
			
			if [ $ret_release_2 -eq 1 ];then
				platform="ALL"
				is_splx_64=1
			fi		
		fi
    fi
	
	if [ $is_splx_64 -eq 0 ]; then
		release=$(awk '(NR > 0) && ($7 >= 6) && ($7 < 7) { print $7 }' $rhel_release)
		if [ $release ]; then
			platform="RedHat6"
			is_platformRH6=1
		else
			platform="RedHat"
		fi
    fi
fi

echo "Starting to install package. Please wait."

# check if this script is run by root
if [ $UID -ne 0 ] ; then
    echo "You must be logged in as root to run this script."
    exit 1
fi

# check if initial SProtectLinux is installed
query_splx=`rpm -q SProtectLinux-3.0`
is_splx_existed=$?

if [ $is_splx_existed -ne 0 ] ; then
    echo "Please install ServerProtect for Linux 3.0 before installing this package."
    exit 1
fi

PostBuildNumber=1706
query_splx_p9=`rpm -q splx-3.0-sp1-patch9`
is_splx_p9_existed=$?
if [ $is_splx_p9_existed -ne 0 ] ; then
    query_build_number=$(rpm -qa | grep SProtectLinux-3.0 | awk -F- '{print $NF}' | awk -F. '{print $1}')
    if [ $query_build_number -ge $PostBuildNumber ] ; then
	    echo "You have installed $query_splx, which already includes all the changes made in the current package. Install process exits."
        exit 1
    fi

    if [ $query_build_number -gt 1657 ] ; then
        echo "The current installation of ServerProtect on your system is $query_splx."
    else
    	echo "Please install SPLX 3.0 Patch9 for sp1 before installing this package." 
    	exit 1
    fi
else
    echo "The current installation of ServerProtect on your system is $query_splx_p9."
fi

Postfix=cp

F_ini_set() {
    INI_F="$1"
    INI_SECTION="$2"
    INI_KEY="$3"
    INI_VALUE="$4"
    TMP_F=/tmp/temp$$

    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
    return 1
    fi

    RANGE_START="/\[${INI_SECTION}\]/"
    RANGE_END="/\\[.*\]/"

    MY_SEDCMD="${RANGE_START},${RANGE_END}s?^[ \t]*${INI_KEY}=.*?${INI_KEY}=${INI_VALUE}?"
    sed -e "${MY_SEDCMD}" ${INI_F} > ${TMP_F}
    cp -f ${TMP_F} ${INI_F}
    rm -f ${TMP_F}
}

F_ini_get()
{
    INI_F="$1"
    INI_SECTION="$2"
    INI_KEY="$3"
    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
        return 1
    fi

    RANGE_START="/^\[${INI_SECTION}\]/"
    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
        return 1
    fi

    RANGE_START="/^\[${INI_SECTION}\]/"
    RANGE_END="/^\[.*\]/"

    MY_SEDCMD_1="${RANGE_START},${RANGE_END}p"
    MY_SEDCMD_2="/^[\t ]*${INI_KEY}=/p"

    _R=`sed -n -e "${MY_SEDCMD_1}" ${INI_F} | sed -n -e "${MY_SEDCMD_2}" | awk -F= '{ printf $2 }'`
    printf "%s" "$_R"
    if [ -z "$_R" ] ; then
        return 1
    else
        return 0
    fi
}


CreatePatchIni()
{
File="/opt/TrendMicro/SProtectLinux/Patch.ini"
	
echo "[General]">>$File
echo "UpdateTime=">>$File
echo "">>$File
echo "[PreviousVersion]">>$File
echo "RpmVersion=">>$File
echo "ProtectVersion=3.0">>$File
echo "ServicePack=1">>$File
echo "PatchNumber=8">>$File
echo "BuildNumber=">>$File
echo "">>$File
echo "[CurrentVersion]">>$File
echo "RpmVersion=">>$File
echo "ProductVersion=3.0">>$File
echo "ServicePack=1">>$File
echo "PatchNumber=">>$File
echo "BuildNumber=">>$File
}

UpdatePatchIni()
{
#Get PreRpmVersion
PreRpmVersion=`rpm -qa | grep splx`
if [ -z "${PreRpmVersion}" ]; then
   PreRpmVersion=`rpm -qa | grep SProtectLinux`
fi

#Get PreSPNumber
PreSPNumber=$(rpm -qa | grep splx | awk -F- '{print $3}' | cut -c 3-)
if [ -z "${PreSPNumber}" ]; then
   PreSPNumber=0
fi

#Get PrePatchNumber
PrePatchNumber=$(rpm -qa | grep splx | awk -F- '{print $4}' | cut -c 6-)
if [ -z "${PrePatchNumber}" ]; then
   PrePatchNumber=0
fi

#Get PreBuildNumber
PreBuildNumber=$(rpm -qa | grep splx | awk -F- '{print $NF}' | awk -F. '{print $1}')
if [ -z "${PreBuildNumber}" ]; then
	#PreBuildNumber=$GMBuild
	PreBuildNumber=$(rpm -qa | grep SProtectLinux-3.0 | awk -F- '{print $NF}' | awk -F. '{print $1}')
fi

#if Patch.ini is exist, get PreviousVersion from Patch.ini|CurrentVersion
File="/opt/TrendMicro/SProtectLinux/Patch.ini"
if [ -f $File ]; then
    #backup 
    cp -f $File /opt/TrendMicro/SProtectLinux/backup/$Postfix$PostBuildNumber/Patch.ini
    PreRpmVer=`F_ini_get $File "CurrentVersion" "RpmVersion"`
	PreSPNo=`F_ini_get $File "CurrentVersion" "ServicePack"`
    PrePatchNo=`F_ini_get $File "CurrentVersion" "PatchNumber"`
    PreBuildNo=`F_ini_get $File "CurrentVersion" "BuildNumber"`  
else
    #create new Patch.ini
    CreatePatchIni
    PreRpmVer=$PreRpmVersion
	PreSPNo=$PreSPNumber
    PrePatchNo=$PrePatchNumber
    PreBuildNo=$PreBuildNumber
fi

Date=`date`

F_ini_set $File "General" "UpdateTime" "$Date"
F_ini_set $File "PreviousVersion" "RpmVersion" "$PreRpmVer"
F_ini_set $File "PreviousVersion" "ServicePack" "$PreSPNo"
F_ini_set $File "PreviousVersion" "PatchNumber" "$PrePatchNo"
F_ini_set $File "PreviousVersion" "BuildNumber" "$PreBuildNo"

#the RpmVersion/ServicePack/PatchNumber of CurrentVersion should be same with PreviousVersion
F_ini_set $File "CurrentVersion" "RpmVersion" "$PreRpmVer"
F_ini_set $File "CurrentVersion" "ServicePack" "$PreSPNo"
F_ini_set $File "CurrentVersion" "PatchNumber" "$PrePatchNumber"
F_ini_set $File "CurrentVersion" "BuildNumber" "$PostBuildNumber"
}

File="/opt/TrendMicro/SProtectLinux/Patch.ini"
if [ -f $File ]; then
    BuildNo=`F_ini_get $File "CurrentVersion" "BuildNumber"`
    if [ "${BuildNo}" -eq "${PostBuildNumber}" ]; then
	echo "Package has been installed. Install process exits."
	exit 1
    fi
fi

#Create bak_path
bak_path=/opt/TrendMicro/SProtectLinux/backup/$Postfix$PostBuildNumber

if [ -d $bak_path ]; then
    rm -rf $bak_path/*
else
    mkdir -p $bak_path
fi

# Stop SPLX   
echo "Stopping splx ......"
/etc/init.d/splx stop

file_name="libcrypto.so.1.0.0"
file_dir="/opt/TrendMicro/SProtectLinux/SPLX.lib/agent"
if [ -f $file_dir/$file_name ];then
	mv -f $file_dir/$file_name $bak_path/
fi

file_name="libcrypto.so.1.1"
file_dir="/opt/TrendMicro/SProtectLinux/SPLX.lib/agent"
if [ -f $file_dir/$file_name ];then
	mv -f $file_dir/$file_name $bak_path/
fi

file_name="libssl.so.1.0.0"
file_dir="/opt/TrendMicro/SProtectLinux/SPLX.lib/agent"
if [ -f $file_dir/$file_name ];then
	mv -f $file_dir/$file_name $bak_path/
fi

file_name="libssl.so.1.1"
file_dir="/opt/TrendMicro/SProtectLinux/SPLX.lib/agent"
if [ -f $file_dir/$file_name ];then
	mv -f $file_dir/$file_name $bak_path/
fi

#---------------------
if [ -f /opt/TrendMicro/SProtectLinux/Agent.ini ]; then
    cp -f /opt/TrendMicro/SProtectLinux/Agent.ini $bak_path
    if [ $is_splx_64 -eq 1 ]; then	
        sed -i "s/Agent_BuildNumber=\([0-9]\+\)/Agent_BuildNumber=2614/" /opt/TrendMicro/SProtectLinux/Agent.ini
    else
        sed -i "s/Agent_BuildNumber=\([0-9]\+\)/Agent_BuildNumber=2546/" /opt/TrendMicro/SProtectLinux/Agent.ini
    fi
fi

if [ -f /opt/TrendMicro/SProtectLinux/tmsplx.xml ] ; then
    cp -f /opt/TrendMicro/SProtectLinux/tmsplx.xml $bak_path
fi

preExcludeCommandValue=$(grep RealtimeExcludeCommand /opt/TrendMicro/SProtectLinux/tmsplx.xml | grep -v '<--'  | awk -F= '{print $NF}' | awk -F\" '{print $2}')

curExcludeCommandValue=${preExcludeCommandValue}

echo ${preExcludeCommandValue} | grep '*imjournal' > /dev/null
if [ $? -ne 0 ]; then
    curExcludeCommandValue="${curExcludeCommandValue}:*imjournal"
fi

if [ "${preExcludeCommandValue}" != "${curExcludeCommandValue}" ]; then
    sed "/RealtimeExcludeCommand/c\\    <P Name=\"RealtimeExcludeCommand\" Value=\"${curExcludeCommandValue}\"/>" /opt/TrendMicro/SProtectLinux/tmsplx.xml > /opt/TrendMicro/SProtectLinux/tmsplx.xml.new
    mv -f /opt/TrendMicro/SProtectLinux/tmsplx.xml.new /opt/TrendMicro/SProtectLinux/tmsplx.xml
fi

DefaultDirToMoveWhiteList="/opt/TrendMicro/SProtectLinux/SPLX.Quarantine"
DefaultDirToSaveWhiteList="/opt/TrendMicro/SProtectLinux/SPLX.Backup"

preDirToMoveValue=$(grep DirToMove /opt/TrendMicro/SProtectLinux/tmsplx.xml | grep -v '<--'  | awk -F= '{print $NF}' | awk -F\" '{print $2}')
preDirToSaveValue=$(grep DirToSave /opt/TrendMicro/SProtectLinux/tmsplx.xml | grep -v '<--'  | awk -F= '{print $NF}' | awk -F\" '{print $2}')

DirToSaveStr=$(grep DirToSave /opt/TrendMicro/SProtectLinux/tmsplx.xml | grep -v '<--')

if [ "${DefaultDirToMoveWhiteList}" != "${preDirToMoveValue}" ]; then
	DefaultDirToMoveWhiteList="${DefaultDirToMoveWhiteList}:$preDirToMoveValue"
fi

if [ "${DefaultDirToSaveWhiteList}" != "${preDirToSaveValue}" ]; then
	DefaultDirToSaveWhiteList="${DefaultDirToSaveWhiteList}:$preDirToSaveValue"
fi

DirToMoveWhiteList="   <P Name=\"MoveToWhiteList\" Value=\"$DefaultDirToMoveWhiteList\"/>"
DirToSaveWhiteList="   <P Name=\"SaveToWhiteList\" Value=\"$DefaultDirToSaveWhiteList\"/>"

grep "SaveToWhiteList" /opt/TrendMicro/SProtectLinux/tmsplx.xml > /dev/null

if [ $? -ne 0 ]; then
	sed -i "/DirToSave/a\ $DirToMoveWhiteList\n $DirToSaveWhiteList" /opt/TrendMicro/SProtectLinux/tmsplx.xml > /dev/null
fi

DefaultSource="https://splx3-p.activeupdate.trendmicro.com/activeupdate"
SourceValue=$(grep 'Name="Source"' /opt/TrendMicro/SProtectLinux/tmsplx.xml | grep -v '<--'  | awk -F= '{print $NF}' | awk -F\" '{print $2}')
DefaultSourceValue=$(grep 'Name="DefaultSource"' /opt/TrendMicro/SProtectLinux/tmsplx.xml | grep -v '<--'  | awk -F= '{print $NF}' | awk -F\" '{print $2}' | grep 'TVCSDownload')

if [ "${DefaultSourceValue}" == "" ]; then
	sed -i "/DefaultSource/c\\    <P Name=\"DefaultSource\" Value=\"${DefaultSource}\"/>" /opt/TrendMicro/SProtectLinux/tmsplx.xml > /dev/null
fi

if [ "${SourceValue}" == "" -a "${DefaultSourceValue}" == "" ]; then
	sed -i "/DigSig/c\\    <P Name=\"DigSig\" Value=\"1\"/>" /opt/TrendMicro/SProtectLinux/tmsplx.xml > /dev/null
	sed -i "/SrvAuth/c\\    <P Name=\"SrvAuth\" Value=\"1\"/>" /opt/TrendMicro/SProtectLinux/tmsplx.xml > /dev/null
fi

#check splx.service
is_systemd_exist=0

if [ $is_splx_64 -eq 1 ] ; then 
	check_results=`systemctl list-unit-files|grep splx.service`
	if [[ $check_results =~ "splx.service" ]] ; then
		is_systemd_exist=1
	fi
fi

#Copy files starts
if [ $is_splx_64 -eq 0 ]; then
if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.1.1 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.1.1)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.1.1 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.1.1) ] ; then 
    cp -f ./$platform/$arch/libapr-1.so.0.1.1 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.1.1
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2) ] ; then 
    cp -f ./$platform/$arch/libcares.so.2 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.1.1 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.1.1)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.1.1 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.1.1) ] ; then 
    cp -f ./$platform/$arch/libcrypto.so.1.1 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.1.1
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so) ] ; then 
    cp -f ./$platform/$arch/libProductLibrary.so /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.1.1 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.1.1)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.1.1 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.1.1) ] ; then 
    cp -f ./$platform/$arch/libssl.so.1.1 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.1.1
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0) ] ; then 
    cp -f ./$platform/$arch/libEn_Utility.so.1.0.0 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0) ] ; then 
    cp -f ./$platform/$arch/libSSO_PKIHelper.so.1.0.0 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0) ] ; then 
    cp -f ./$platform/$arch/libTrendAprWrapper.so.1.0.0 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.7.0 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.7.0)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.7.0 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.7.0) ] ; then 
    cp -f ./$platform/$arch/libcurl.so.4.7.0 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.7.0
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1) ] ; then 
    cp -f ./$platform/$arch/libTMNotifymt.so.1 /opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so) ] ; then 
    cp -f ./$platform/$arch/libsplxcommon.so /opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so) ] ; then 
    cp -f ./$platform/$arch/libtmprapi.so /opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd) ] ; then 
    cp -f ./$platform/$arch/splxhttpd /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3) ] ; then 
    cp -f ./$platform/$arch/libapr-1.so.0.7.3 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3) ] ; then 
    cp -f ./$platform/$arch/libaprutil-1.so.0.6.3 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10) ] ; then 
    cp -f ./$platform/$arch/libexpat.so.1.8.10 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp) ] ; then 
    cp -f ./$platform/$arch/vsapiapp /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan) ] ; then 
    cp -f ./$platform/$arch/splx_manual_scan /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity) ] ; then 
    cp -f ./$platform/$arch/entity /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder) ] ; then 
    cp -f ./$platform/$arch/virus_type_finder /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt) ] ; then 
    cp -f ./$platform/$arch/SetTMDefaultExt /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain) ] ; then 
    cp -f ./$platform/$arch/splxmain /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan) ] ; then 
    cp -f ./$platform/$arch/splx_schedule_scan /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool) ] ; then 
    cp -f ./$platform/$arch/DiagnosticTool /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword) ] ; then 
    cp -f ./$platform/$arch/EncryptAgentPassword /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF) ] ; then 
    cp -f ./$platform/$arch/TMBIF /opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig) ] ; then 
    cp -f ./$platform/$arch/CMconfig /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi) ] ; then 
    cp -f ./$platform/$arch/tmcm_sso.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi) ] ; then 
    cp -f ./$platform/$arch/srv_admin.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi) ] ; then 
    cp -f ./$platform/$arch/notification.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi) ] ; then 
    cp -f ./$platform/$arch/cmoption.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify) ] ; then 
    cp -f ./$platform/$arch/cgiCmdNotify /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi) ] ; then 
    cp -f ./$platform/$arch/showpage.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi) ] ; then 
    cp -f ./$platform/$arch/viewlog.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi) ] ; then 
    cp -f ./$platform/$arch/summary.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi) ] ; then 
    cp -f ./$platform/$arch/login_and_register.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi) ] ; then 
    cp -f ./$platform/$arch/log_management.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi) ] ; then 
    cp -f ./$platform/$arch/scanoption_set.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi) ] ; then 
    cp -f ./$platform/$arch/proption.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi) ] ; then 
    cp -f ./$platform/$arch/scanoption.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/AuPatch ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/AuPatch)
    cp -f /opt/TrendMicro/SProtectLinux/AuPatch $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/AuPatch) ] ; then 
    cp -f ./$platform/$arch/AuPatch /opt/TrendMicro/SProtectLinux/AuPatch
fi


if [ -f /opt/TrendMicro/SProtectLinux/cert5.db ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/cert5.db)
    cp -f /opt/TrendMicro/SProtectLinux/cert5.db $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/cert5.db) ] ; then 
    cp -f ./$platform/$arch/cert5.db /opt/TrendMicro/SProtectLinux/cert5.db
fi


if [ -f /opt/TrendMicro/SProtectLinux/libpatch.so ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/libpatch.so)
    cp -f /opt/TrendMicro/SProtectLinux/libpatch.so $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/libpatch.so) ] ; then 
    cp -f ./$platform/$arch/libpatch.so /opt/TrendMicro/SProtectLinux/libpatch.so
fi


if [ -f /opt/TrendMicro/SProtectLinux/libtmactupdate.so ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/libtmactupdate.so)
    cp -f /opt/TrendMicro/SProtectLinux/libtmactupdate.so $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/libtmactupdate.so) ] ; then 
    cp -f ./$platform/$arch/libtmactupdate.so /opt/TrendMicro/SProtectLinux/libtmactupdate.so
fi


if [ -f /opt/TrendMicro/SProtectLinux/x500.db ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/x500.db)
    cp -f /opt/TrendMicro/SProtectLinux/x500.db $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/x500.db) ] ; then 
    cp -f ./$platform/$arch/x500.db /opt/TrendMicro/SProtectLinux/x500.db
fi


if [ -f /opt/TrendMicro/SProtectLinux/expapply.so ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/expapply.so)
    cp -f /opt/TrendMicro/SProtectLinux/expapply.so $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/expapply.so) ] ; then 
    cp -f ./$platform/$arch/expapply.so /opt/TrendMicro/SProtectLinux/expapply.so
fi


fi
if [ $is_splx_64 -eq 1 ]; then
if [ -f /etc/init.d/splxcore ] ; then
    file_name=$(basename etc/init.d/splxcore)
    cp -f /etc/init.d/splxcore $bak_path/$file_name
fi

if [ -d /$(dirname etc/init.d/splxcore) ] ; then 
    cp -f ./$platform/$arch/splxcore /etc/init.d/splxcore
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1) ] ; then 
    cp -f ./$platform/$arch/libTMNotifymt.so.1 /opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so) ] ; then 
    cp -f ./$platform/$arch/libsplxcommon.so /opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so) ] ; then 
    cp -f ./$platform/$arch/libtmprapi.so /opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.6.5 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.6.5)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.6.5 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.6.5) ] ; then 
    cp -f ./$platform/$arch/libapr-1.so.0.6.5 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.6.5
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2) ] ; then 
    cp -f ./$platform/$arch/libcares.so.2 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.3 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.3)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.3 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.3) ] ; then 
    cp -f ./$platform/$arch/libcrypto.so.3 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.3
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so) ] ; then 
    cp -f ./$platform/$arch/libProductLibrary.so /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.3 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.3)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.3 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.3) ] ; then 
    cp -f ./$platform/$arch/libssl.so.3 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.3
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0) ] ; then 
    cp -f ./$platform/$arch/libEn_Utility.so.1.0.0 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0) ] ; then 
    cp -f ./$platform/$arch/libSSO_PKIHelper.so.1.0.0 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0) ] ; then 
    cp -f ./$platform/$arch/libTrendAprWrapper.so.1.0.0 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.8.0 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.8.0)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.8.0 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.8.0) ] ; then 
    cp -f ./$platform/$arch/libcurl.so.4.8.0 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.8.0
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify) ] ; then 
    cp -f ./$platform/$arch/cgiCmdNotify /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi) ] ; then 
    cp -f ./$platform/$arch/cmoption.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi) ] ; then 
    cp -f ./$platform/$arch/login_and_register.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi) ] ; then 
    cp -f ./$platform/$arch/log_management.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi) ] ; then 
    cp -f ./$platform/$arch/notification.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi) ] ; then 
    cp -f ./$platform/$arch/proption.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi) ] ; then 
    cp -f ./$platform/$arch/scanoption.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi) ] ; then 
    cp -f ./$platform/$arch/showpage.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi) ] ; then 
    cp -f ./$platform/$arch/srv_admin.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi) ] ; then 
    cp -f ./$platform/$arch/summary.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi) ] ; then 
    cp -f ./$platform/$arch/tmcm_sso.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi) ] ; then 
    cp -f ./$platform/$arch/viewlog.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi) ] ; then 
    cp -f ./$platform/$arch/scanoption_set.cgi /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig) ] ; then 
    cp -f ./$platform/$arch/CMconfig /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool) ] ; then 
    cp -f ./$platform/$arch/DiagnosticTool /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword) ] ; then 
    cp -f ./$platform/$arch/EncryptAgentPassword /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF) ] ; then 
    cp -f ./$platform/$arch/TMBIF /opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity) ] ; then 
    cp -f ./$platform/$arch/entity /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt) ] ; then 
    cp -f ./$platform/$arch/SetTMDefaultExt /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain) ] ; then 
    cp -f ./$platform/$arch/splxmain /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan) ] ; then 
    cp -f ./$platform/$arch/splx_manual_scan /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan) ] ; then 
    cp -f ./$platform/$arch/splx_schedule_scan /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder) ] ; then 
    cp -f ./$platform/$arch/virus_type_finder /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp) ] ; then 
    cp -f ./$platform/$arch/vsapiapp /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd) ] ; then 
    cp -f ./$platform/$arch/splxhttpd /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3) ] ; then 
    cp -f ./$platform/$arch/libapr-1.so.0.7.3 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3) ] ; then 
    cp -f ./$platform/$arch/libaprutil-1.so.0.6.3 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3
fi


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10 ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10)
    cp -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10 $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10) ] ; then 
    cp -f ./$platform/$arch/libexpat.so.1.8.10 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10
fi


if [ -f /opt/TrendMicro/SProtectLinux/AuPatch ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/AuPatch)
    cp -f /opt/TrendMicro/SProtectLinux/AuPatch $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/AuPatch) ] ; then 
    cp -f ./$platform/$arch/AuPatch /opt/TrendMicro/SProtectLinux/AuPatch
fi


if [ -f /opt/TrendMicro/SProtectLinux/cert5.db ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/cert5.db)
    cp -f /opt/TrendMicro/SProtectLinux/cert5.db $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/cert5.db) ] ; then 
    cp -f ./$platform/$arch/cert5.db /opt/TrendMicro/SProtectLinux/cert5.db
fi


if [ -f /opt/TrendMicro/SProtectLinux/libpatch.so ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/libpatch.so)
    cp -f /opt/TrendMicro/SProtectLinux/libpatch.so $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/libpatch.so) ] ; then 
    cp -f ./$platform/$arch/libpatch.so /opt/TrendMicro/SProtectLinux/libpatch.so
fi


if [ -f /opt/TrendMicro/SProtectLinux/libtmactupdate.so ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/libtmactupdate.so)
    cp -f /opt/TrendMicro/SProtectLinux/libtmactupdate.so $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/libtmactupdate.so) ] ; then 
    cp -f ./$platform/$arch/libtmactupdate.so /opt/TrendMicro/SProtectLinux/libtmactupdate.so
fi


if [ -f /opt/TrendMicro/SProtectLinux/x500.db ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/x500.db)
    cp -f /opt/TrendMicro/SProtectLinux/x500.db $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/x500.db) ] ; then 
    cp -f ./$platform/$arch/x500.db /opt/TrendMicro/SProtectLinux/x500.db
fi


if [ -f /opt/TrendMicro/SProtectLinux/expapply64.so ] ; then
    file_name=$(basename opt/TrendMicro/SProtectLinux/expapply64.so)
    cp -f /opt/TrendMicro/SProtectLinux/expapply64.so $bak_path/$file_name
fi

if [ -d /$(dirname opt/TrendMicro/SProtectLinux/expapply64.so) ] ; then 
    cp -f ./$platform/$arch/expapply64.so /opt/TrendMicro/SProtectLinux/expapply64.so
fi


fi


#Copy files ends

#create soft link to dynamic libraries
if [ $is_splx_64 -eq 0 ]; then
if [ -L /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4 ]; then
    soname=$(basename $(readlink /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4))
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4)
    if [ ! -f $bak_path/$soname ]; then
        mv -f $dir_name/$soname $bak_path/
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4
        ln -s /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.7.0 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4
    fi
fi

if [ -L /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1 ]; then
    soname=$(basename $(readlink /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1))
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1)
    if [ ! -f $bak_path/$soname ]; then
        mv -f $dir_name/$soname $bak_path/
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1
        ln -s /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1
    fi
fi

if [ -L /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0 ]; then
    soname=$(basename $(readlink /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0))
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0)
    if [ ! -f $bak_path/$soname ]; then
        mv -f $dir_name/$soname $bak_path/
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0
        ln -s /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0
    fi
fi

if [ -L /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0 ]; then
    soname=$(basename $(readlink /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0))
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0)
    if [ ! -f $bak_path/$soname ]; then
        mv -f $dir_name/$soname $bak_path/
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0
        ln -s /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0
    fi
fi

fi
if [ $is_splx_64 -eq 1 ]; then
if [ -L /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4 ]; then
    soname=$(basename $(readlink /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4))
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4)
    if [ ! -f $bak_path/$soname ]; then
        mv -f $dir_name/$soname $bak_path/
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4
        ln -s /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.8.0 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4
    fi
fi

if [ -L /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1 ]; then
    soname=$(basename $(readlink /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1))
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1)
    if [ ! -f $bak_path/$soname ]; then
        mv -f $dir_name/$soname $bak_path/
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1
        ln -s /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1
    fi
fi

if [ -L /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0 ]; then
    soname=$(basename $(readlink /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0))
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0)
    if [ ! -f $bak_path/$soname ]; then
        mv -f $dir_name/$soname $bak_path/
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0
        ln -s /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0
    fi
fi

if [ -L /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0 ]; then
    soname=$(basename $(readlink /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0))
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0)
    if [ ! -f $bak_path/$soname ]; then
        mv -f $dir_name/$soname $bak_path/
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0
        ln -s /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0
    fi
fi

fi

#Change the MenuVersion to 3.2 in Product.ini for upgrading 32 bit SPLX to redhat9 in build 1627
if [ $is_splx_64 -eq 0 ]; then
	ProductFile="/opt/TrendMicro/SProtectLinux/Product.ini"
	F_ini_set $ProductFile "Product_Info" "MenuVersion" "3.2"
fi

#start splx service at boot(splx_64 + no splx.service)
if [ $is_splx_64 -eq 1 -a $is_systemd_exist -eq 0 ] ; then 
	systemctl enable splx.service >/dev/null 2>&1
fi


# Modify BIF interval
if [ -f /etc/init.d/splxcore ]; then
    sed -i "s/$BIF_schedule_command=\"\* \* \* \* 0/$BIF_schedule_command=\"30 2 \* \* 0/g" /etc/init.d/splxcore > /dev/null
fi

# Modify MenuVersion number
if [ $is_splx_64 -eq 1 ]; then
	if [ -f /opt/TrendMicro/SProtectLinux/Product.ini ]; then
		sed -i "s/MenuVersion=3\.3/MenuVersion=3\.4/g" /opt/TrendMicro/SProtectLinux/Product.ini > /dev/null
	fi
	if [ -f /opt/TrendMicro/SProtectLinux/Product.ini.template ]; then
		sed -i "s/MenuVersion=3\.3/MenuVersion=3\.4/g" /opt/TrendMicro/SProtectLinux/Product.ini.template > /dev/null
	fi
else
	if [ -f /opt/TrendMicro/SProtectLinux/Product.ini ]; then
		sed -i "s/MenuVersion=3\.1/MenuVersion=3\.2/g" /opt/TrendMicro/SProtectLinux/Product.ini > /dev/null
	fi
	if [ -f /opt/TrendMicro/SProtectLinux/Product.ini.template ]; then
		sed -i "s/MenuVersion=3\.1/MenuVersion=3\.2/g" /opt/TrendMicro/SProtectLinux/Product.ini.template > /dev/null
	fi
fi

#added in cp 1519
UpdatePatchIni

ldconfig
# Start SPLX
echo "Starting splx ......"
/etc/init.d/splx start
echo "Successfully install package."
