#!/bin/sh

# /****************************************************************************
# *
# *    (C) Copyright 1989-2010 Trend Micro, Inc.
# *    All Rights Reserved.
# *
# *    This program is an unpublished copyrighted work which is proprietary
# *    to Trend Micro, Inc. and contains confidential information that is not
# *    to be reproduced or disclosed to any other person or entity without
# *    prior written consent from Trend Micro, Inc. in each and every instance.
# *
# *    WARNING:  Unauthorized reproduction of this program as well as
# *    unauthorized preparation of derivative works based upon the
# *    program or distribution of copies by sale, rental, lease or
# *    lending are violations of federal copyright laws and state trade
# *    secret laws, punishable by civil and criminal penalties.
# *
# * ---------------------------------------------------------------------------
# * Title: critical patch deploy script
# * Project: SPLX 3.0
# * Revision: 
# * Author: 
# * Date: 
# * Description: 
# * Log: 
# *
# ***************************************************************************** 

echo "Check system ......"

is_32bit=-1
uname_i=`uname -m`
arch=""
platform=""
if [ "${uname_i}" = "i686" -o "${uname_i}" = "i386" -o "${uname_i}" = "i586" ]; then
        is_32bit=1
        arch="i686"
else
        is_32bit=0
        arch="x86_64"
fi

key_bin="/sbin/yast"
is_suse=1

if [ -f ${key_bin} ]; then
        is_suse=1
		platform="SuSE"
else
        is_suse=0
fi

is_centOS6=0
is_platformRH6=0
rhel_release="/etc/redhat-release"
if [ $is_suse -ne 1 ]; then
	query_is_centOS=`cat $rhel_release | grep CentOS`
	ret_centOS="$?"
	if [ $ret_centOS -eq 0 ]; then
	    centos_release=$(awk '(NR > 0) && ($4 >= 6) { print $4 }' $rhel_release)
	    centos_release_2=$(awk '(NR > 0) && ($3 >= 6) { print $3 }' $rhel_release)
	    if [ $centos_release ] || [ $centos_release_2 ] ; then
	    	is_centOS6=1
	    	platform="RedHat6"
		is_platformRH6=1
	    fi
	fi
fi

if [ $is_suse -ne 1 -a $is_centOS6 -ne 1 ]; then
	release=$(awk '(NR > 0) && ($7 >= 6) { print $7 }' $rhel_release)
	if [ $release ]; then
		platform="RedHat6"
		is_platformRH6=1
	else
		platform="RedHat"
	fi
fi

echo "Starting to deploy critical patch. Please wait."

# check if this script is run by root
if [ $UID -ne 0 ] ; then
	echo "You must be logged in as root to run this script."
	exit 1
fi

# check if initial SProtectLinux is installed
query_splx=`rpm -q SProtectLinux-3.0`
is_splx_existed=$?

if [ $is_splx_existed -ne 0 ] ; then
	echo "Please install ServerProtect for Linux 3.0 before installing this critical patch."
	exit 1
else
	echo "The current installation of ServerProtect on your system is $query_splx."
fi

if [ $is_centOS6 -ne 1 ]; then
	query_splx_p4=`rpm -q splx-3.0-sp1-patch4`
	is_splx_p4_existed=$?
	if [ $is_splx_p4_existed -ne 0 ] ; then
		echo "Please install SPLX3 Patch4 for sp1 before installing this critical patch."
		exit 1
	fi
else 
	query_centOS6=`rpm -qa | grep "SProtect"| grep "1362"`
	ret_centos6="$?"
	if [ $ret_centos6 -ne 0 ]; then
		echo "The platform is CentOS6, Please install SPLX3 for CentOS6 GM build before install this critical patch."
                exit 1
    fi
fi
 
# Stop SPLX   
/etc/init.d/splx stop


if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity ] ; then
        cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity.bak.cp1366
fi

cp -f ./$platform/$arch/entity /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity

if [ -f /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig ] ; then
        cp -f /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig.bak.cp1366
fi

cp -f ./$platform/$arch/CMconfig /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig

if [ -f /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword ] ; then
        cp -f /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword.bak.cp1366
fi

cp -f ./$platform/$arch/EncryptAgentPassword /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword

if [ -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so ] ; then
        cp -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so.bak.cp1366
fi

cp -f ./$platform/$arch/libProductLibrary.so /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so

if [ -f /opt/TrendMicro/SProtectLinux/SPLX_CM_UI.zip ] ; then
        cp -f /opt/TrendMicro/SProtectLinux/SPLX_CM_UI.zip /opt/TrendMicro/SProtectLinux/SPLX_CM_UI.zip.bak.cp1366
fi

cp -f ./$platform/$arch/SPLX_CM_UI.zip /opt/TrendMicro/SProtectLinux/SPLX_CM_UI.zip

if [ -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain ] ; then
        cp -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain.bak.cp1366
fi

cp -f ./$platform/$arch/splxmain /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain

chmod +x //opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig
chmod +x //opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword
chmod +x //opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity

#revise Product.ini
file="//opt/TrendMicro/SProtectLinux/Product.ini"
tmpProduct_ini="//opt/TrendMicro/SProtectLinux/SPLX.tmp"
cp -f $file $file.bak.cp1366
if [ $is_platformRH6 -eq 1 ] ; then
	cat $file | sed 's/MenuVersion=3.0/MenuVersion=3.1/' | sed 's/Name=0x00020000/Name=0x48000089/' > $tmpProduct_ini/Product.ini
else
	cat $file | sed 's/MenuVersion=3.0/MenuVersion=3.1/'  > $tmpProduct_ini/Product.ini
fi
cp -f $tmpProduct_ini/Product.ini //opt/TrendMicro/SProtectLinux/Product.ini
rm -f $tmpProduct_ini/tmp/Product.ini

ldconfig
# Start SPLX
/etc/init.d/splx start
 echo "Successfully deployed critical patch."
