
# /****************************************************************************
# *
# *    (C) Copyright 1989-2015 Trend Micro, Inc.
# *    All Rights Reserved.
# *
# *    This program is an unpublished copyrighted work which is proprietary
# *    to Trend Micro, Inc. and contains confidential information that is not
# *    to be reproduced or disclosed to any other person or entity without
# *    prior written consent from Trend Micro, Inc. in each and every instance.
# *
# *    WARNING:  Unauthorized reproduction of this program as well as
# *    unauthorized preparation of derivative works based upon the
# *    program or distribution of copies by sale, rental, lease or
# *    lending are violations of federal copyright laws and state trade
# *    secret laws, punishable by civil and criminal penalties.
# *
# * ---------------------------------------------------------------------------
# * Title: critical patch/hotfix rollback script
# * Project: SPLX 3.0
# * Revision: 
# * Author: 
# * Date: 
# * Description: 
# * Log: 
# *
# ***************************************************************************** 

#echo "Check system begin......"

is_32bit=-1
uname_i=`uname -m`
arch=""
platform=""
if [ "${uname_i}" = "i686" -o "${uname_i}" = "i386" -o "${uname_i}" = "i586" ]; then
    is_32bit=1
    arch="i686"
else
    is_32bit=0
    arch="x86_64"
fi

key_bin="/sbin/yast"
is_suse=1

if [ -f ${key_bin} ]; then
    is_suse=1
    platform="SuSE"
else
    is_suse=0
fi

is_splx_64=0
if [ $is_suse -eq 1 ]; then
	
	if [ -f /etc/os-release ] ; then
		grep -e "SUSE Linux Enterprise Server" -e "SUSE Linux Enterprise Desktop" /etc/os-release > /dev/null 2>&1
		if [ $? = 0 ] ; then
			is_splx_64=1
			platform="ALL"
		else
			suse_release="/etc/SuSE-release"
			query_is_suse12=`cat $suse_release | grep SUSE`
			ret_suse12="$?"
			if [ $ret_suse12 -eq 0 ]; then
				suse12_release=$(awk '(NR > 0) && ($5 == 12) { print $5 }' $suse_release)
				if [ $suse12_release ]; then
					is_splx_64=1
					platform="ALL"
				fi
			fi
		fi
	fi
fi

is_centOS=0
is_platformRH6=0
rhel_release="/etc/redhat-release"
if [ $is_suse -ne 1 ]; then
    query_is_centOS=`cat $rhel_release | grep CentOS`
    ret_centOS="$?"
    if [ $ret_centOS -eq 0 ]; then
		is_centOS=1
		centos_release=$(awk '(NR > 0) && ($4 >= 7) { print $4 }' $rhel_release)
		centos_release_2=$(awk '(NR > 0) && ($3 >= 7) { print $3 }' $rhel_release)
		if [ $centos_release ] || [ $centos_release_2 ] ; then
				is_splx_64=1
				platform="ALL"
		fi
		if [ $is_splx_64 -eq 0 ]; then
			centos_release=$(awk '(NR > 0) && ($4 >= 6) && ($4 < 7) { print $4 }' $rhel_release)
			centos_release_2=$(awk '(NR > 0) && ($3 >= 6) && ($3 < 7) { print $3 }' $rhel_release)
			if [ $centos_release ] || [ $centos_release_2 ] ; then
				platform="RedHat6"
				is_platformRH6=1
			else
				platform="RedHat"
			fi
		fi
    fi
fi

if [ $is_suse -ne 1 -a $is_centOS -ne 1 ]; then
	release=$(awk '(NR > 0) && ($7 >= 7) { print $7 }' $rhel_release)
	
	if [ $release ]; then
        platform="ALL"
		is_splx_64=1
	else
		# for RHEL8 and above, 2020.05.22
		release_2=$(awk '(NR > 0) && ($6 >= 7) { print $6 }' $rhel_release)	
		if [ $release_2 ]; then
			echo $release_2 | sed 's/\.//g' | grep [^0-9] >/dev/null 2>&1
			ret_release_2=$?
			
			if [ $ret_release_2 -eq 1 ];then
				platform="ALL"
				is_splx_64=1
			fi		
		fi
    fi
	
	if [ $is_splx_64 -eq 0 ]; then
		release=$(awk '(NR > 0) && ($7 >= 6) && ($7 < 7) { print $7 }' $rhel_release)
		if [ $release ]; then
			platform="RedHat6"
			is_platformRH6=1
		else
			platform="RedHat"
		fi
    fi
fi

#echo "Check system end......"

F_ini_set() {
    INI_F="$1"
    INI_SECTION="$2"
    INI_KEY="$3"
    INI_VALUE="$4"
    TMP_F=/tmp/temp$$

    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
    return 1
    fi

    RANGE_START="/\[${INI_SECTION}\]/"
    RANGE_END="/\\[.*\]/"

    MY_SEDCMD="${RANGE_START},${RANGE_END}s?^[ \t]*${INI_KEY}=.*?${INI_KEY}=${INI_VALUE}?"
    sed -e "${MY_SEDCMD}" ${INI_F} > ${TMP_F}
    cp -f ${TMP_F} ${INI_F}
    rm -f ${TMP_F}
}


F_ini_get()
{
    INI_F="$1"
    INI_SECTION="$2"
    INI_KEY="$3"
    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
        return 1
    fi

    RANGE_START="/^\[${INI_SECTION}\]/"
    if [ ! -f "$INI_F" ] ; then
        echo "Error: ${INI_F} not found."
        return 1
    fi

    RANGE_START="/^\[${INI_SECTION}\]/"
    RANGE_END="/^\[.*\]/"

    MY_SEDCMD_1="${RANGE_START},${RANGE_END}p"
    MY_SEDCMD_2="/^[\t ]*${INI_KEY}=/p"

    _R=`sed -n -e "${MY_SEDCMD_1}" ${INI_F} | sed -n -e "${MY_SEDCMD_2}" | awk -F= '{ printf $2 }'`
    printf "%s" "$_R"
    if [ -z "$_R" ] ; then
        return 1
    else
        return 0
    fi
}

F_systemd_clean()
{
	if [ -f /etc/systemd/system/splx.service -o -f /etc/systemd/system/multi-user.target.wants/splx.service ] ; then 
		rm -rf /etc/systemd/system/splx.service
		rm -rf /etc/systemd/system/multi-user.target.wants/splx.service
	fi
	
	if [ -f /usr/lib/systemd/system/splx.service ] ; then 
		rm -rf /usr/lib/systemd/system/splx.service
	fi
	
	if [ -f /usr/lib/systemd/system/splxcore.service ] ; then 
		rm -rf /usr/lib/systemd/system/splxcore.service
	fi
	
	if [ -f /usr/lib/systemd/system/splxhttpd.service ] ; then 
		rm -rf /usr/lib/systemd/system/splxhttpd.service
	fi
}

PostBuildNumber=1706
Postfix=cp

File="/opt/TrendMicro/SProtectLinux/Patch.ini"

if [ -f $File ]; then
    CurBuildNo=`F_ini_get $File "CurrentVersion" "BuildNumber"`
    if [ "${PostBuildNumber}" -ne "${CurBuildNo}" ]; then
        echo "Package was not installed. Rollback process exits."
        exit 1
    fi
else
    echo "Package was not installed. Rollback process exits."
    exit 1
fi

is_rhel9=0
if [ $is_suse -ne 1 -a $is_centOS -ne 1 ]; then
    if grep -qi "red hat enterprise linux" /etc/redhat-release && grep -q "9" /etc/redhat-release; then
        is_rhel9=1
    fi
fi

#Restore Patch.ini in cp 1519
File="/opt/TrendMicro/SProtectLinux/backup/$Postfix$PostBuildNumber/Patch.ini"
if [ -f $File ]; then
    mv -f $File /opt/TrendMicro/SProtectLinux/Patch.ini
else
    #GM build for RHEL9 is larger than path9, there is no Patch.ini. This condition and delete action is only for hotfix 1699
    if [ $is_rhel9 -eq 1 ]; then 
	    rm /opt/TrendMicro/SProtectLinux/Patch.ini
    else
        echo "Package was not installed. Rollback process exits."
        exit 1
    fi
fi

echo "Starting to rollback package. Please wait."
#Stop splx
echo "Stopping splx ......"
/etc/init.d/splx stop

bak_path=/opt/TrendMicro/SProtectLinux/backup/$Postfix$PostBuildNumber

file_name=$(basename /opt/TrendMicro/SProtectLinux/tmsplx.xml)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/tmsplx.xml ]; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/tmsplx.xml
fi

file_name="Agent.ini"
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/$file_name ]; then
    preVer=`F_ini_get $bak_path/$file_name "Common" "Agent_BuildNumber"`
	F_ini_set /opt/TrendMicro/SProtectLinux/$file_name "Common" "Agent_BuildNumber" "$preVer"
fi

#file_name="libssl.so.1.0.0"
#if [ -f $bak_path/$file_name ]; then
   # cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent
#fi

file_name="libcrypto.so.1.0.0"
#if [ -f $bak_path/$file_name ]; then
   # cp $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent
#fi

#rm -rf /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.3
#rm -rf /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.3

#Copy files starts
if [ $is_splx_64 -eq 0 ]; then
file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.1.1)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.1.1 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.1.1
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.1.1)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.1.1 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.1.1
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.1.1)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.1.1 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.1.1
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.7.0)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.7.0 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.7.0
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/AuPatch)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/AuPatch ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/AuPatch
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/cert5.db)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/cert5.db ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/cert5.db
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/libpatch.so)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/libpatch.so ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/libpatch.so
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/libtmactupdate.so)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/libtmactupdate.so ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/libtmactupdate.so
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/x500.db)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/x500.db ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/x500.db
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/expapply.so)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/expapply.so ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/expapply.so
fi


fi
if [ $is_splx_64 -eq 1 ]; then
file_name=$(basename etc/init.d/splxcore)
if [ -f $bak_path/$file_name  -a -f /etc/init.d/splxcore ] ; then
    cp -f $bak_path/$file_name /etc/init.d/splxcore
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/libTMNotifymt.so.1
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/libsplxcommon.so
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/libtmprapi.so
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.6.5)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.6.5 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libapr-1.so.0.6.5
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcares.so.2
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.3)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.3 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcrypto.so.3
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.3)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.3 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libssl.so.3
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libEn_Utility.so.1.0.0
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libSSO_PKIHelper.so.1.0.0
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libTrendAprWrapper.so.1.0.0
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.8.0)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.8.0 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.8.0
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cgiCmdNotify
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/cmoption.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/login_and_register.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/log_management.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/notification.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/proption.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/showpage.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/srv_admin.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/summary.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/tmcm_sso.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/viewlog.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.WebUI/cgi-bin/scanoption_set.cgi
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.util/CMconfig
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.util/DiagnosticTool
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.util/EncryptAgentPassword
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.util/TMBIF
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/entity
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/SetTMDefaultExt
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splxmain
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_manual_scan
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/splx_schedule_scan
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/virus_type_finder
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.vsapiapp/vsapiapp
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.httpd/bin/splxhttpd
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10 ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/AuPatch)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/AuPatch ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/AuPatch
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/cert5.db)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/cert5.db ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/cert5.db
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/libpatch.so)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/libpatch.so ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/libpatch.so
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/libtmactupdate.so)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/libtmactupdate.so ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/libtmactupdate.so
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/x500.db)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/x500.db ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/x500.db
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/expapply64.so)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/expapply64.so ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/expapply64.so
fi


fi

libcrypto=$(find "/opt/TrendMicro/SProtectLinux/SPLX.lib/agent/" -regex ".*/libcrypto\.so\.[0-9]*\(\.[0-9]*\)*$")
libcrypto_current=$(basename $libcrypto)
libcrypto=$(find "$bak_path" -regex ".*/libcrypto\.so\.[0-9]*\(\.[0-9]*\)*$")
libcrypto_bak=$(basename $libcrypto)
if [ $libcrypto_current == $libcrypto_bak ] ; then
    cp -f $bak_path/$libcrypto_bak /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/$libcrypto_current
else
    rm -rf /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/$libcrypto_current
	cp -f $bak_path/$libcrypto_bak /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/
fi


file_name=$(basename opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so)
if [ -f $bak_path/$file_name  -a -f /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so ] ; then
    cp -f $bak_path/$file_name /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libProductLibrary.so
fi


libssl=$(find "/opt/TrendMicro/SProtectLinux/SPLX.lib/agent/" -regex ".*/libssl\.so\.[0-9]*\(\.[0-9]*\)*$")
libssl_current=$(basename $libssl)
libssl=$(find "$bak_path" -regex ".*/libssl\.so\.[0-9]*\(\.[0-9]*\)*$")
libssl_bak=$(basename $libssl)
if [ $libssl_current == $libssl_bak ] ; then
    cp -f $bak_path/$libssl_bak /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/$libssl_current
else
    rm -rf /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/$libssl_current
	cp -f $bak_path/$libssl_bak /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/
fi

#Copy files ends

#create soft link to dynamic libraries
if [ $is_splx_64 -eq 0 ]; then
if [ -L /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4 ]; then
    soname=$(basename /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4)
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4)
    if [ ! -f $bak_path/$(basename /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.7.0) ]; then
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.7.0
        prefix=${soname%%.[0-9]*}
        oldname=$(find $bak_path -name "${prefix}*" | sort -r)
        mv -f $bak_path/$(basename $oldname) ${dir_name}/
        ln -s ${dir_name}/$(basename $oldname) /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4
    fi
fi

if [ -L /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1 ]; then
    soname=$(basename /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1)
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1)
    if [ ! -f $bak_path/$(basename /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10) ]; then
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10
        prefix=${soname%%.[0-9]*}
        oldname=$(find $bak_path -name "${prefix}*" | sort -r)
        mv -f $bak_path/$(basename $oldname) ${dir_name}/
        ln -s ${dir_name}/$(basename $oldname) /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1
    fi
fi

if [ -L /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0 ]; then
    soname=$(basename /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0)
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0)
    if [ ! -f $bak_path/$(basename /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3) ]; then
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3
        prefix=${soname%%.[0-9]*}
        oldname=$(find $bak_path -name "${prefix}*" | sort -r)
        mv -f $bak_path/$(basename $oldname) ${dir_name}/
        ln -s ${dir_name}/$(basename $oldname) /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0
    fi
fi

if [ -L /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0 ]; then
    soname=$(basename /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0)
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0)
    if [ ! -f $bak_path/$(basename /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3) ]; then
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3
        prefix=${soname%%.[0-9]*}
        oldname=$(find $bak_path -name "${prefix}*" | sort -r)
        mv -f $bak_path/$(basename $oldname) ${dir_name}/
        ln -s ${dir_name}/$(basename $oldname) /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0
    fi
fi

fi
if [ $is_splx_64 -eq 1 ]; then
if [ -L /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4 ]; then
    soname=$(basename /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4)
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4)
    if [ ! -f $bak_path/$(basename /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.8.0) ]; then
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4 /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4.8.0
        prefix=${soname%%.[0-9]*}
        oldname=$(find $bak_path -name "${prefix}*" | sort -r)
        mv -f $bak_path/$(basename $oldname) ${dir_name}/
        ln -s ${dir_name}/$(basename $oldname) /opt/TrendMicro/SProtectLinux/SPLX.lib/agent/libcurl.so.4
    fi
fi

if [ -L /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1 ]; then
    soname=$(basename /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1)
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1)
    if [ ! -f $bak_path/$(basename /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10) ]; then
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1.8.10
        prefix=${soname%%.[0-9]*}
        oldname=$(find $bak_path -name "${prefix}*" | sort -r)
        mv -f $bak_path/$(basename $oldname) ${dir_name}/
        ln -s ${dir_name}/$(basename $oldname) /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libexpat.so.1
    fi
fi

if [ -L /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0 ]; then
    soname=$(basename /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0)
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0)
    if [ ! -f $bak_path/$(basename /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3) ]; then
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0.7.3
        prefix=${soname%%.[0-9]*}
        oldname=$(find $bak_path -name "${prefix}*" | sort -r)
        mv -f $bak_path/$(basename $oldname) ${dir_name}/
        ln -s ${dir_name}/$(basename $oldname) /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libapr-1.so.0
    fi
fi

if [ -L /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0 ]; then
    soname=$(basename /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0)
    dir_name=$(dirname /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0)
    if [ ! -f $bak_path/$(basename /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3) ]; then
        rm -rf /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0 /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0.6.3
        prefix=${soname%%.[0-9]*}
        oldname=$(find $bak_path -name "${prefix}*" | sort -r)
        mv -f $bak_path/$(basename $oldname) ${dir_name}/
        ln -s ${dir_name}/$(basename $oldname) /opt/TrendMicro/SProtectLinux/SPLX.httpd/lib/libaprutil-1.so.0
    fi
fi

fi

#clean systemd files
if [ ! -f $bak_path/splx.service ]; then 
	F_systemd_clean
fi

rm -rf $bak_path

ldconfig
ldconfig -n /opt/TrendMicro/SProtectLinux/SPLX.lib/agent
# Start SPLX
echo "Starting splx ......"
/etc/init.d/splx start
echo "Successfully rollback package."
