/* Kernel Hook Module for Trend Micro ServerProtect for Linux  */
/* Copyright (C) 2012 Trend Micro Incorporated.                */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 */

#ifndef _HOOKS_
#define _HOOKS_
#if defined(RHEL_RELEASE_CODE)&& defined(RHEL_RELEASE_VERSION)
    #if LINUX_VERSION_CODE >= KERNEL_VERSION(5,14,0)&& RHEL_RELEASE_CODE >= RHEL_RELEASE_VERSION(9,1)
        #include <linux/stdarg.h>
    #else
        #include <stdarg.h>
    #endif
#else
    #include <stdarg.h>
#endif

#ifdef IA32_HOOK
#include    <asm/compat.h>
#endif

//Reading macro
#define KHM_PART(x) 1 

typedef enum 
{
    OPEN_HOOK,
    OPENAT_HOOK,
}OPENTYPE;

typedef enum 
{
    CLOSE_HOOK,
    DUP2_HOOK,
    DUP3_HOOK
}CLOSETYPE;

typedef enum 
{
    WRITE_HOOK,
    PWRITE_HOOK,
    PWRITE64_HOOK,
    PWRITEV_HOOK,
    WRITEV_HOOK
}WRITETYPE;

typedef enum 
{
    EXIT_HOOK,
    EXIT_GROUP_HOOK
}EXITTYPE;

typedef enum 
{
    UMOUNT_HOOK,
    UMOUNT2_HOOK
}UMOUNTTYPE;

typedef enum 
{
    UNLINK_HOOK,
    UNLINKAT_HOOK,
}UNLINKTYPE;

/***********************function point declaration**************************/
extern void* orig_openat;
extern void* orig_open;
extern void* orig_close;
extern void* orig_dup2;
extern void* orig_dup3;
extern void* orig_exit;
extern void* orig_exit_group;
extern void* orig_getpgid;
extern void* orig_write;
extern void* orig_pwrite;
extern void* orig_pwrite64;
extern void* orig_writev;
extern void* orig_pwritev;
extern void* orig_umount;
extern void* orig_umount2;
extern void* orig_unlink;
extern void* orig_unlinkat;

#ifdef IA32_HOOK
extern void* IA32_orig_openat;
extern void* IA32_orig_open;
extern void* IA32_orig_close;
extern void* IA32_orig_dup2;
extern void* IA32_orig_dup3;
extern void* IA32_orig_exit;
extern void* IA32_orig_exit_group;
extern void* IA32_orig_getpgid;
extern void* IA32_orig_write;
extern void* IA32_orig_pwrite;
extern void* IA32_orig_pwrite64;
extern void* IA32_orig_writev;
extern void* IA32_orig_pwritev;
extern void* IA32_orig_umount;
extern void* IA32_orig_umount2;
extern void* IA32_orig_unlink;
extern void* IA32_orig_unlinkat;

#endif


#ifdef CONFIG_ARCH_HAS_SYSCALL_WRAPPER	

/***********************function point type declaration**************************/
typedef asmlinkage long (*pfn_orig_syscall_wrapper)(const struct pt_regs *regs);

/***********************function declaration**************************/
asmlinkage long openHook(const struct pt_regs *regs);
asmlinkage long openatHook(const struct pt_regs *regs);
asmlinkage long closeHook(const struct pt_regs *regs);
asmlinkage long dup2Hook(const struct pt_regs *regs);
asmlinkage long dup3Hook(const struct pt_regs *regs);
asmlinkage long exitHook(const struct pt_regs *regs);
asmlinkage long exitgroupHook(const struct pt_regs *regs);
asmlinkage long writeHook(const struct pt_regs *regs);
asmlinkage long pwrite64Hook(const struct pt_regs *regs);
asmlinkage long writevHook(const struct pt_regs *regs);
asmlinkage long pwritevHook(const struct pt_regs *regs);
asmlinkage long umountHook(const struct pt_regs *regs);
asmlinkage long umount2Hook(const struct pt_regs *regs);
asmlinkage long unlinkHook(const struct pt_regs *regs);
asmlinkage long unlinkatHook(const struct pt_regs *regs);


#ifdef IA32_HOOK
asmlinkage long IA32_openHook(const struct pt_regs *regs);
asmlinkage long IA32_openatHook(const struct pt_regs *regs);
asmlinkage long IA32_closeHook(const struct pt_regs *regs);
asmlinkage long IA32_dup2Hook(const struct pt_regs *regs);
asmlinkage long IA32_dup3Hook(const struct pt_regs *regs);
asmlinkage long IA32_exitHook(const struct pt_regs *regs);
asmlinkage long IA32_exitgroupHook(const struct pt_regs *regs);
asmlinkage long IA32_writeHook(const struct pt_regs *regs);
asmlinkage long IA32_pwriteHook(const struct pt_regs *regs);
asmlinkage long IA32_pwrite64Hook(const struct pt_regs *regs);
asmlinkage long IA32_writevHook(const struct pt_regs *regs);
asmlinkage long IA32_pwritevHook(const struct pt_regs *regs);
asmlinkage long IA32_umountHook(const struct pt_regs *regs);
asmlinkage long IA32_umount2Hook(const struct pt_regs *regs);
asmlinkage long IA32_unlinkHook(const struct pt_regs *regs);
asmlinkage long IA32_unlinkatHook(const struct pt_regs *regs);


#endif

#else

/***********************function point type declaration**************************/
typedef asmlinkage long (*pfn_orig_open)(const char *,int, mode_t );
typedef asmlinkage long (*pfn_orig_openat)(int,const char *,int, mode_t);
typedef asmlinkage long (*pfn_orig_close)(int);
typedef asmlinkage long (*pfn_orig_dup2)(int,int);
typedef asmlinkage long (*pfn_orig_dup3)(int,int,int);
typedef asmlinkage long (*pfn_orig_write)(int, const void *, size_t );
typedef asmlinkage long (*pfn_orig_writev)(int, const struct iovec *, int );
typedef asmlinkage long (*pfn_orig_umount)(const char*);
typedef asmlinkage long (*pfn_orig_umount2)(const char*, int );
typedef asmlinkage long (*pfn_orig_unlink)(const char *);
typedef asmlinkage long (*pfn_orig_unlinkat)(int,const char *, int);

#ifdef X86_64
typedef asmlinkage long (*pfn_orig_pwriteIA32)(int, const void *, size_t, long,long);
typedef asmlinkage long (*pfn_orig_pwrite64)(int, const void *, size_t, off_t);
typedef asmlinkage long (*pfn_orig_pwritev64)(int, const struct iovec *, int, long,long);
#else
typedef asmlinkage long (*pfn_orig_pwrite)(int, const void *, size_t, off_t);
typedef asmlinkage long (*pfn_orig_pwritev)(int, const struct iovec *, int, off_t);
#endif

typedef asmlinkage long (*pfn_orig_exit)(int);
typedef asmlinkage long (*pfn_orig_exit_group)(int);
typedef asmlinkage long (*pfn_orig_getpgid)(pid_t);
typedef asmlinkage long (*pfn_orig_execve)(char *, char __user * __user *,
                                      char __user * __user *, struct pt_regs);

/***********************function declaration**************************/
asmlinkage long openHook(const char *filename, int flags, mode_t mode);
asmlinkage long openatHook(int dirfd,const char *filename, int flags, mode_t mode);
asmlinkage long closeHook(int fd);
asmlinkage long dup2Hook(int oldfd, int newfd);
asmlinkage long dup3Hook(int oldfd,int newfd,int flag);
asmlinkage long writeHook(int fd, const void *buf, size_t count);
asmlinkage long pwrite64Hook(int fd, const void * buf, size_t count, off_t offset);
asmlinkage long writevHook(int fd, const struct iovec *iov, int iovcnt);
asmlinkage long pwritevHook(int fd, const struct iovec *iov, int iovcnt, off_t offset);
asmlinkage long exitHook(int errcode);
asmlinkage long exitgroupHook(int errcode);
asmlinkage long umountHook(const char *name);
asmlinkage long umount2Hook(const char *name, int flags);
asmlinkage long unlinkHook(const char *);
asmlinkage long unlinkatHook(int,const char *, int);


#ifdef IA32_HOOK
asmlinkage long IA32_openHook(const char *filename, int flags, mode_t mode);
asmlinkage long IA32_openatHook(int dirfd,const char *filename, int flags, mode_t mode);
asmlinkage long IA32_closeHook(int fd);
asmlinkage long IA32_dup2Hook(int oldfd, int newfd);
asmlinkage long IA32_dup3Hook(int oldfd,int newfd,int flag);
asmlinkage long IA32_writeHook(int fd, const void *buf, size_t count);
asmlinkage long IA32_pwriteHook(int fd, const void *buf, size_t count, off_t offset);
asmlinkage long IA32_pwrite64Hook(int fd, const void * buf, size_t count, long offset);
asmlinkage long IA32_writevHook(int fd, const struct iovec *iov, int iovcnt);
asmlinkage long IA32_pwritevHook(int fd, const struct iovec *iov, int iovcnt, off_t offset);
asmlinkage long IA32_exitHook(int errcode);
asmlinkage long IA32_exitgroupHook(int errcode);
asmlinkage long IA32_umountHook(const char *name);
asmlinkage long IA32_umount2Hook(const char *name, int flags);
asmlinkage long IA32_unlinkHook(const char *);
asmlinkage long IA32_unlinkatHook(int,const char *, int);

#endif

#endif//CONFIG_ARCH_HAS_SYSCALL_WRAPPER




#ifdef KHM_PART("merge from modreg.c")

#ifdef X86_64

#if LINUX_VERSION_CODE <= KERNEL_VERSION(2,6,18)
extern long execveHook(char __user *name, char __user *__user *argv,
                        char __user *__user *envp, struct pt_regs regs);
#else
#if  (defined(SLES11SP1_64) && defined(CONFIG_XEN)) || !defined(SLES11SP1_64)
extern long execveHook(char __user *name, char __user *__user *argv,
                        char __user *__user *envp, struct pt_regs *regs);
#endif
#endif//execveHook

#if LINUX_VERSION_CODE <= KERNEL_VERSION(2,6,18)
extern asmlinkage long (*orig_execve)(char *, char __user *__user *,
                               char __user *__user *, struct pt_regs);
#else
extern asmlinkage long (*orig_execve)(char *, char __user *__user *,
                               char __user *__user *, struct pt_regs *);
#endif//2.6.18

#ifdef IA32_HOOK
extern long stub32_execveHook(char __user *name, char __user *argv,
                                char  __user *envp, struct pt_regs regs);

extern asmlinkage long (*IA32_orig_execve)(char *, char __user *__user *,
                                    char __user *__user *, struct pt_regs);
extern asmlinkage long (*IA32_orig_syscall)(void);

extern asmlinkage long  (*IA32_orig_compat_do_execve)(char __user *name, compat_uptr_t __user *,
                                    compat_uptr_t __user *, struct pt_regs *);

extern asmlinkage long IA32_execveHook(char __user *name, compat_uptr_t __user *argv,
                 compat_uptr_t __user *envp, struct pt_regs *regs);
#endif//IA32_HOOK

#else
extern asmlinkage int (*orig_execve)(struct pt_regs);
extern asmlinkage int execveHook(struct pt_regs);

#endif//X86_64



extern asmlinkage long (*orig_syscall)(void);
extern int (*orig_do_execve)(char * ,
                                  char __user *__user *,
                                  char __user *__user *,
                                  struct pt_regs * );
#ifdef  NFSD
extern asmlinkage int (*orig_nfsd_open)(struct svc_rqst *, struct svc_fh *, int, int,
                      struct file *);
extern asmlinkage void (*orig_nfsd_close)(struct file *);

extern asmlinkage void *nfsd_sys_call_table[];
extern asmlinkage int nfsdOpenHook(struct svc_rqst *, struct svc_fh *, int, int,
                        struct file *);
extern asmlinkage void nfsdCloseHook(struct file *);

#endif

#endif

#endif
